// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18222 = arguments.length;
switch (G__18222) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,ledger){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,ledger,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,ledger,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18225 = arguments.length;
switch (G__18225) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___18278 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18256){
var state_val_18257 = (state_18256[(1)]);
if((state_val_18257 === (1))){
var state_18256__$1 = state_18256;
var statearr_18258_18279 = state_18256__$1;
(statearr_18258_18279[(2)] = null);

(statearr_18258_18279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (2))){
var _ = (function (){var statearr_18259 = state_18256;
(statearr_18259[(4)] = cljs.core.cons((5),(state_18256[(4)])));

return statearr_18259;
})();
var inst_18233 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_18256__$1 = state_18256;
if(cljs.core.truth_(inst_18233)){
var statearr_18260_18280 = state_18256__$1;
(statearr_18260_18280[(1)] = (6));

} else {
var statearr_18261_18281 = state_18256__$1;
(statearr_18261_18281[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (3))){
var inst_18254 = (state_18256[(2)]);
var state_18256__$1 = state_18256;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18256__$1,inst_18254);
} else {
if((state_val_18257 === (4))){
var inst_18226 = (state_18256[(2)]);
var inst_18227 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_18226);
var state_18256__$1 = state_18256;
var statearr_18263_18282 = state_18256__$1;
(statearr_18263_18282[(2)] = inst_18227);

(statearr_18263_18282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (5))){
var _ = (function (){var statearr_18264 = state_18256;
(statearr_18264[(4)] = cljs.core.rest((state_18256[(4)])));

return statearr_18264;
})();
var state_18256__$1 = state_18256;
var ex18262 = (state_18256__$1[(2)]);
var statearr_18265_18283 = state_18256__$1;
(statearr_18265_18283[(5)] = ex18262);


var statearr_18266_18284 = state_18256__$1;
(statearr_18266_18284[(1)] = (4));

(statearr_18266_18284[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (6))){
var inst_18235 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18236 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18237 = cljs.core.PersistentHashMap.fromArrays(inst_18235,inst_18236);
var inst_18238 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_18237);
var inst_18239 = (function(){throw inst_18238})();
var state_18256__$1 = state_18256;
var statearr_18267_18285 = state_18256__$1;
(statearr_18267_18285[(2)] = inst_18239);

(statearr_18267_18285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (7))){
var inst_18241 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18243 = [operation,data,pc,opts];
var inst_18244 = (new cljs.core.PersistentVector(null,4,(5),inst_18242,inst_18243,null));
var inst_18245 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18241,inst_18244);
var inst_18246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18247 = [operation,data,pc,opts];
var inst_18248 = (new cljs.core.PersistentVector(null,4,(5),inst_18246,inst_18247,null));
var inst_18249 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Put operation on connection req-chan: ",inst_18248) : fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_18248));
var state_18256__$1 = (function (){var statearr_18268 = state_18256;
(statearr_18268[(7)] = inst_18245);

return statearr_18268;
})();
var statearr_18269_18286 = state_18256__$1;
(statearr_18269_18286[(2)] = inst_18249);

(statearr_18269_18286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18257 === (8))){
var inst_18251 = (state_18256[(2)]);
var _ = (function (){var statearr_18270 = state_18256;
(statearr_18270[(4)] = cljs.core.rest((state_18256[(4)])));

return statearr_18270;
})();
var state_18256__$1 = state_18256;
var statearr_18271_18287 = state_18256__$1;
(statearr_18271_18287[(2)] = inst_18251);

(statearr_18271_18287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2684__auto__ = null;
var fluree$db$operations$state_machine__2684__auto____0 = (function (){
var statearr_18272 = [null,null,null,null,null,null,null,null];
(statearr_18272[(0)] = fluree$db$operations$state_machine__2684__auto__);

(statearr_18272[(1)] = (1));

return statearr_18272;
});
var fluree$db$operations$state_machine__2684__auto____1 = (function (state_18256){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18256);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18273){var ex__2687__auto__ = e18273;
var statearr_18274_18288 = state_18256;
(statearr_18274_18288[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18256[(4)]))){
var statearr_18275_18289 = state_18256;
(statearr_18275_18289[(1)] = cljs.core.first((state_18256[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18290 = state_18256;
state_18256 = G__18290;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2684__auto__ = function(state_18256){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2684__auto____1.call(this,state_18256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2684__auto____0;
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2684__auto____1;
return fluree$db$operations$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18276 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18276[(6)] = c__2706__auto___18278);

return statearr_18276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18292 = arguments.length;
switch (G__18292) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18293){
var map__18294 = p__18293;
var map__18294__$1 = cljs.core.__destructure_map(map__18294);
var opts = map__18294__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18294__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18295 = session;
var map__18295__$1 = cljs.core.__destructure_map(map__18295);
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18295__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18295__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18295__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5775__auto__ = [];
var len__5769__auto___18322 = arguments.length;
var i__5770__auto___18323 = (0);
while(true){
if((i__5770__auto___18323 < len__5769__auto___18322)){
args__5775__auto__.push((arguments[i__5770__auto___18323]));

var G__18324 = (i__5770__auto___18323 + (1));
i__5770__auto___18323 = G__18324;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18299){
var vec__18300 = p__18299;
var map__18303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18300,(0),null);
var map__18303__$1 = cljs.core.__destructure_map(map__18303);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18303__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18303__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18300;
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18315){
var state_val_18316 = (state_18315[(1)]);
if((state_val_18316 === (1))){
var inst_18305 = session;
var inst_18306 = cljs.core.__destructure_map(inst_18305);
var inst_18307 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18306,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18308 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18306,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_18309 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18306,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18310 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18311 = [inst_18307,inst_18308,toBlock,toTime];
var inst_18312 = cljs.core.PersistentHashMap.fromArrays(inst_18310,inst_18311);
var inst_18313 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_18309,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18312);
var state_18315__$1 = state_18315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18315__$1,inst_18313);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2684__auto__ = null;
var fluree$db$operations$state_machine__2684__auto____0 = (function (){
var statearr_18317 = [null,null,null,null,null,null,null];
(statearr_18317[(0)] = fluree$db$operations$state_machine__2684__auto__);

(statearr_18317[(1)] = (1));

return statearr_18317;
});
var fluree$db$operations$state_machine__2684__auto____1 = (function (state_18315){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18315);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18318){var ex__2687__auto__ = e18318;
var statearr_18319_18325 = state_18315;
(statearr_18319_18325[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18315[(4)]))){
var statearr_18320_18326 = state_18315;
(statearr_18320_18326[(1)] = cljs.core.first((state_18315[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18327 = state_18315;
state_18315 = G__18327;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2684__auto__ = function(state_18315){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2684__auto____1.call(this,state_18315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2684__auto____0;
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2684__auto____1;
return fluree$db$operations$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18321 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18321[(6)] = c__2706__auto__);

return statearr_18321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18297){
var G__18298 = cljs.core.first(seq18297);
var seq18297__$1 = cljs.core.next(seq18297);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18298,seq18297__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18328 = session;
var map__18328__$1 = cljs.core.__destructure_map(map__18328);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18328__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18328__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18328__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Sending transaction async: ",tx_map) : fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18330 = arguments.length;
switch (G__18330) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18331 = opts;
var map__18331__$1 = cljs.core.__destructure_map(map__18331);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18331__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18331__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = (function (){var G__18332 = "Subscribe to: ";
var G__18333 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var G__18334 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var G__18335 = auth_or_jwt;
return (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4(G__18332,G__18333,G__18334,G__18335) : fluree.db.util.log.trace.call(null,G__18332,G__18333,G__18334,G__18335));
})();
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsubscribe","unsubscribe",632650147),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null));
});
