// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__23919,error_ch,vars,p__23920){
var map__23921 = p__23919;
var map__23921__$1 = cljs.core.__destructure_map(map__23921);
var db = map__23921__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23921__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23921__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23921__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__23922 = p__23920;
var map__23922__$1 = cljs.core.__destructure_map(map__23922);
var _where_clause = map__23922__$1;
var p = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23922__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23922__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23922__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__23923 = (function (){var G__23926 = idx;
var G__23926__$1 = (((G__23926 instanceof cljs.core.Keyword))?G__23926.fqn:null);
switch (G__23926__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23926__$1)].join('')));

}
})();
var fflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23923,(0),null);
var lflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23923,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__5043__auto__ = o_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__5043__auto__;
}
})())?(function (p1__23917_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o_STAR_,fluree.db.flake.o(p1__23917_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__23918_SHARP_){
var G__23927 = fluree.db.flake.o(p1__23918_SHARP_);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23927) : f.call(null,G__23927));
});
})():null));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fflake,lflake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,cljs.core.get.cljs$core$IFn$_invoke$arity$2(novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((10),cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s),cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0()));
var c__2706__auto___23997 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23966){
var state_val_23967 = (state_23966[(1)]);
if((state_val_23967 === (7))){
var inst_23962 = (state_23966[(2)]);
var state_23966__$1 = state_23966;
var statearr_23968_23998 = state_23966__$1;
(statearr_23968_23998[(2)] = inst_23962);

(statearr_23968_23998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (1))){
var state_23966__$1 = state_23966;
var statearr_23969_23999 = state_23966__$1;
(statearr_23969_23999[(2)] = null);

(statearr_23969_23999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (4))){
var inst_23930 = (state_23966[(7)]);
var inst_23930__$1 = (state_23966[(2)]);
var inst_23931 = (inst_23930__$1 == null);
var state_23966__$1 = (function (){var statearr_23970 = state_23966;
(statearr_23970[(7)] = inst_23930__$1);

return statearr_23970;
})();
if(cljs.core.truth_(inst_23931)){
var statearr_23971_24000 = state_23966__$1;
(statearr_23971_24000[(1)] = (5));

} else {
var statearr_23972_24001 = state_23966__$1;
(statearr_23972_24001[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (15))){
var state_23966__$1 = state_23966;
var statearr_23973_24002 = state_23966__$1;
(statearr_23973_24002[(2)] = false);

(statearr_23973_24002[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (13))){
var inst_23942 = (state_23966[(2)]);
var state_23966__$1 = state_23966;
if(cljs.core.truth_(inst_23942)){
var statearr_23974_24003 = state_23966__$1;
(statearr_23974_24003[(1)] = (14));

} else {
var statearr_23975_24004 = state_23966__$1;
(statearr_23975_24004[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (6))){
var inst_23930 = (state_23966[(7)]);
var inst_23935 = cljs.core.seq(inst_23930);
var inst_23936 = inst_23935;
var inst_23937 = (0);
var state_23966__$1 = (function (){var statearr_23976 = state_23966;
(statearr_23976[(8)] = inst_23936);

(statearr_23976[(9)] = inst_23937);

return statearr_23976;
})();
var statearr_23977_24005 = state_23966__$1;
(statearr_23977_24005[(2)] = null);

(statearr_23977_24005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (17))){
var state_23966__$1 = state_23966;
var statearr_23978_24006 = state_23966__$1;
(statearr_23978_24006[(2)] = null);

(statearr_23978_24006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (3))){
var inst_23964 = (state_23966[(2)]);
var state_23966__$1 = state_23966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23966__$1,inst_23964);
} else {
if((state_val_23967 === (12))){
var inst_23952 = (state_23966[(2)]);
var state_23966__$1 = state_23966;
var statearr_23979_24007 = state_23966__$1;
(statearr_23979_24007[(2)] = inst_23952);

(statearr_23979_24007[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (2))){
var state_23966__$1 = state_23966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23966__$1,(4),tree_chan);
} else {
if((state_val_23967 === (19))){
var inst_23960 = (state_23966[(2)]);
var state_23966__$1 = state_23966;
var statearr_23980_24008 = state_23966__$1;
(statearr_23980_24008[(2)] = inst_23960);

(statearr_23980_24008[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (11))){
var state_23966__$1 = state_23966;
var statearr_23981_24009 = state_23966__$1;
(statearr_23981_24009[(2)] = true);

(statearr_23981_24009[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (9))){
var inst_23954 = (state_23966[(2)]);
var state_23966__$1 = state_23966;
if(cljs.core.truth_(inst_23954)){
var statearr_23982_24010 = state_23966__$1;
(statearr_23982_24010[(1)] = (17));

} else {
var statearr_23983_24011 = state_23966__$1;
(statearr_23983_24011[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (5))){
var inst_23933 = cljs.core.async.close_BANG_(return_chan);
var state_23966__$1 = state_23966;
var statearr_23984_24012 = state_23966__$1;
(statearr_23984_24012[(2)] = inst_23933);

(statearr_23984_24012[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (14))){
var inst_23936 = (state_23966[(8)]);
var inst_23937 = (state_23966[(9)]);
var inst_23944 = cljs.core.next(inst_23936);
var inst_23945 = (inst_23937 + (1));
var inst_23936__$1 = inst_23944;
var inst_23937__$1 = inst_23945;
var state_23966__$1 = (function (){var statearr_23985 = state_23966;
(statearr_23985[(8)] = inst_23936__$1);

(statearr_23985[(9)] = inst_23937__$1);

return statearr_23985;
})();
var statearr_23986_24013 = state_23966__$1;
(statearr_23986_24013[(2)] = null);

(statearr_23986_24013[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (16))){
var inst_23949 = (state_23966[(2)]);
var state_23966__$1 = state_23966;
var statearr_23987_24014 = state_23966__$1;
(statearr_23987_24014[(2)] = inst_23949);

(statearr_23987_24014[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (10))){
var inst_23936 = (state_23966[(8)]);
var inst_23940 = cljs.core.first(inst_23936);
var state_23966__$1 = state_23966;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23966__$1,(13),return_chan,inst_23940);
} else {
if((state_val_23967 === (18))){
var inst_23958 = cljs.core.async.close_BANG_(return_chan);
var state_23966__$1 = state_23966;
var statearr_23988_24015 = state_23966__$1;
(statearr_23988_24015[(2)] = inst_23958);

(statearr_23988_24015[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23967 === (8))){
var inst_23936 = (state_23966[(8)]);
var state_23966__$1 = state_23966;
if(cljs.core.truth_(inst_23936)){
var statearr_23989_24016 = state_23966__$1;
(statearr_23989_24016[(1)] = (10));

} else {
var statearr_23990_24017 = state_23966__$1;
(statearr_23990_24017[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____0 = (function (){
var statearr_23991 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23991[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__);

(statearr_23991[(1)] = (1));

return statearr_23991;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____1 = (function (state_23966){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23966);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23992){var ex__2687__auto__ = e23992;
var statearr_23993_24018 = state_23966;
(statearr_23993_24018[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23966[(4)]))){
var statearr_23994_24019 = state_23966;
(statearr_23994_24019[(1)] = cljs.core.first((state_23966[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24020 = state_23966;
state_23966 = G__24020;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__ = function(state_23966){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____1.call(this,state_23966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23995 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23995[(6)] = c__2706__auto___23997);

return statearr_23995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__24021){
var map__24022 = p__24021;
var map__24022__$1 = cljs.core.__destructure_map(map__24022);
var _opts = map__24022__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24022__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24022__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24022__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24022__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24022__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24022__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24022__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn(db):null);
return (function (sid,port){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24067){
var state_val_24068 = (state_24067[(1)]);
if((state_val_24068 === (7))){
var inst_24038 = (state_24067[(7)]);
var inst_24040 = fluree.db.query.subject_crawl.common.filter_subject(vars,filter_map,inst_24038);
var state_24067__$1 = state_24067;
var statearr_24069_24105 = state_24067__$1;
(statearr_24069_24105[(2)] = inst_24040);

(statearr_24069_24105[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (1))){
var state_24067__$1 = state_24067;
var statearr_24070_24106 = state_24067__$1;
(statearr_24070_24106[(2)] = null);

(statearr_24070_24106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (4))){
var inst_24023 = (state_24067[(2)]);
var inst_24024 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_24023);
var inst_24025 = cljs.core.async.close_BANG_(port);
var state_24067__$1 = (function (){var statearr_24071 = state_24067;
(statearr_24071[(8)] = inst_24025);

(statearr_24071[(9)] = inst_24024);

return statearr_24071;
})();
var statearr_24072_24107 = state_24067__$1;
(statearr_24072_24107[(2)] = null);

(statearr_24072_24107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (15))){
var inst_24055 = (state_24067[(10)]);
var inst_24055__$1 = (state_24067[(2)]);
var inst_24056 = cljs.core.seq(inst_24055__$1);
var state_24067__$1 = (function (){var statearr_24073 = state_24067;
(statearr_24073[(10)] = inst_24055__$1);

return statearr_24073;
})();
if(inst_24056){
var statearr_24074_24108 = state_24067__$1;
(statearr_24074_24108[(1)] = (17));

} else {
var statearr_24075_24109 = state_24067__$1;
(statearr_24075_24109[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (13))){
var inst_24048 = (state_24067[(11)]);
var state_24067__$1 = state_24067;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24067__$1,(16),inst_24048);
} else {
if((state_val_24068 === (6))){
var inst_24037 = (state_24067[(2)]);
var inst_24038 = fluree.db.util.async.throw_err(inst_24037);
var state_24067__$1 = (function (){var statearr_24076 = state_24067;
(statearr_24076[(7)] = inst_24038);

return statearr_24076;
})();
if(cljs.core.truth_(filter_map)){
var statearr_24077_24110 = state_24067__$1;
(statearr_24077_24110[(1)] = (7));

} else {
var statearr_24078_24111 = state_24067__$1;
(statearr_24078_24111[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (17))){
var inst_24055 = (state_24067[(10)]);
var inst_24058 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24055);
var state_24067__$1 = state_24067;
var statearr_24079_24112 = state_24067__$1;
(statearr_24079_24112[(2)] = inst_24058);

(statearr_24079_24112[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (3))){
var inst_24065 = (state_24067[(2)]);
var state_24067__$1 = state_24067;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24067__$1,inst_24065);
} else {
if((state_val_24068 === (12))){
var inst_24048 = (state_24067[(2)]);
var state_24067__$1 = (function (){var statearr_24080 = state_24067;
(statearr_24080[(11)] = inst_24048);

return statearr_24080;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_24081_24113 = state_24067__$1;
(statearr_24081_24113[(1)] = (13));

} else {
var statearr_24082_24114 = state_24067__$1;
(statearr_24082_24114[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (2))){
var _ = (function (){var statearr_24083 = state_24067;
(statearr_24083[(4)] = cljs.core.cons((5),(state_24067[(4)])));

return statearr_24083;
})();
var inst_24032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24033 = [sid];
var inst_24034 = (new cljs.core.PersistentVector(null,1,(5),inst_24032,inst_24033,null));
var inst_24035 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24034);
var state_24067__$1 = state_24067;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24067__$1,(6),inst_24035);
} else {
if((state_val_24068 === (19))){
var inst_24061 = (state_24067[(2)]);
var inst_24062 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_24084 = state_24067;
(statearr_24084[(4)] = cljs.core.rest((state_24067[(4)])));

return statearr_24084;
})();
var state_24067__$1 = (function (){var statearr_24085 = state_24067;
(statearr_24085[(12)] = inst_24061);

return statearr_24085;
})();
var statearr_24086_24115 = state_24067__$1;
(statearr_24086_24115[(2)] = inst_24062);

(statearr_24086_24115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (11))){
var inst_24043 = (state_24067[(13)]);
var state_24067__$1 = state_24067;
var statearr_24088_24116 = state_24067__$1;
(statearr_24088_24116[(2)] = inst_24043);

(statearr_24088_24116[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (9))){
var inst_24043 = (state_24067[(2)]);
var state_24067__$1 = (function (){var statearr_24089 = state_24067;
(statearr_24089[(13)] = inst_24043);

return statearr_24089;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_24090_24117 = state_24067__$1;
(statearr_24090_24117[(1)] = (10));

} else {
var statearr_24091_24118 = state_24067__$1;
(statearr_24091_24118[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (5))){
var _ = (function (){var statearr_24092 = state_24067;
(statearr_24092[(4)] = cljs.core.rest((state_24067[(4)])));

return statearr_24092;
})();
var state_24067__$1 = state_24067;
var ex24087 = (state_24067__$1[(2)]);
var statearr_24093_24119 = state_24067__$1;
(statearr_24093_24119[(5)] = ex24087);


var statearr_24094_24120 = state_24067__$1;
(statearr_24094_24120[(1)] = (4));

(statearr_24094_24120[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (14))){
var inst_24048 = (state_24067[(11)]);
var state_24067__$1 = state_24067;
var statearr_24095_24121 = state_24067__$1;
(statearr_24095_24121[(2)] = inst_24048);

(statearr_24095_24121[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (16))){
var inst_24051 = (state_24067[(2)]);
var inst_24052 = fluree.db.util.async.throw_err(inst_24051);
var state_24067__$1 = state_24067;
var statearr_24096_24122 = state_24067__$1;
(statearr_24096_24122[(2)] = inst_24052);

(statearr_24096_24122[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (10))){
var inst_24043 = (state_24067[(13)]);
var inst_24045 = (permissions.cljs$core$IFn$_invoke$arity$1 ? permissions.cljs$core$IFn$_invoke$arity$1(inst_24043) : permissions.call(null,inst_24043));
var state_24067__$1 = state_24067;
var statearr_24097_24123 = state_24067__$1;
(statearr_24097_24123[(2)] = inst_24045);

(statearr_24097_24123[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (18))){
var state_24067__$1 = state_24067;
var statearr_24098_24124 = state_24067__$1;
(statearr_24098_24124[(2)] = null);

(statearr_24098_24124[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24068 === (8))){
var inst_24038 = (state_24067[(7)]);
var state_24067__$1 = state_24067;
var statearr_24099_24125 = state_24067__$1;
(statearr_24099_24125[(2)] = inst_24038);

(statearr_24099_24125[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____0 = (function (){
var statearr_24100 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24100[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__);

(statearr_24100[(1)] = (1));

return statearr_24100;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____1 = (function (state_24067){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24067);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24101){var ex__2687__auto__ = e24101;
var statearr_24102_24126 = state_24067;
(statearr_24102_24126[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24067[(4)]))){
var statearr_24103_24127 = state_24067;
(statearr_24103_24127[(1)] = cljs.core.first((state_24067[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24128 = state_24067;
state_24067 = G__24128;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__ = function(state_24067){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____1.call(this,state_24067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24104 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24104[(6)] = c__2706__auto__);

return statearr_24104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__24129){
var map__24130 = p__24129;
var map__24130__$1 = cljs.core.__destructure_map(map__24130);
var f_where = map__24130__$1;
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24130__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var _id_val = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2706__auto___24167 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24150){
var state_val_24151 = (state_24150[(1)]);
if((state_val_24151 === (7))){
var inst_24138 = (state_24150[(7)]);
var inst_24141 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_24138);
var state_24150__$1 = state_24150;
var statearr_24152_24168 = state_24150__$1;
(statearr_24152_24168[(2)] = inst_24141);

(statearr_24152_24168[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (1))){
var inst_24131 = typeof _id_val === 'number';
var state_24150__$1 = state_24150;
if(cljs.core.truth_(inst_24131)){
var statearr_24153_24169 = state_24150__$1;
(statearr_24153_24169[(1)] = (2));

} else {
var statearr_24154_24170 = state_24150__$1;
(statearr_24154_24170[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (4))){
var inst_24147 = (state_24150[(2)]);
var inst_24148 = cljs.core.async.close_BANG_(return_ch);
var state_24150__$1 = (function (){var statearr_24155 = state_24150;
(statearr_24155[(8)] = inst_24147);

return statearr_24155;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_24150__$1,inst_24148);
} else {
if((state_val_24151 === (6))){
var inst_24138 = (state_24150[(7)]);
var inst_24138__$1 = (state_24150[(2)]);
var inst_24139 = fluree.db.util.core.exception_QMARK_(inst_24138__$1);
var state_24150__$1 = (function (){var statearr_24156 = state_24150;
(statearr_24156[(7)] = inst_24138__$1);

return statearr_24156;
})();
if(inst_24139){
var statearr_24157_24171 = state_24150__$1;
(statearr_24157_24171[(1)] = (7));

} else {
var statearr_24158_24172 = state_24150__$1;
(statearr_24158_24172[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (3))){
var inst_24136 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,_id_val);
var state_24150__$1 = state_24150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24150__$1,(6),inst_24136);
} else {
if((state_val_24151 === (2))){
var state_24150__$1 = state_24150;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24150__$1,(5),return_ch,_id_val);
} else {
if((state_val_24151 === (9))){
var inst_24145 = (state_24150[(2)]);
var state_24150__$1 = state_24150;
var statearr_24159_24173 = state_24150__$1;
(statearr_24159_24173[(2)] = inst_24145);

(statearr_24159_24173[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (5))){
var inst_24134 = (state_24150[(2)]);
var state_24150__$1 = state_24150;
var statearr_24160_24174 = state_24150__$1;
(statearr_24160_24174[(2)] = inst_24134);

(statearr_24160_24174[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24151 === (8))){
var inst_24138 = (state_24150[(7)]);
var inst_24143 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_24138);
var state_24150__$1 = state_24150;
var statearr_24161_24175 = state_24150__$1;
(statearr_24161_24175[(2)] = inst_24143);

(statearr_24161_24175[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____0 = (function (){
var statearr_24162 = [null,null,null,null,null,null,null,null,null];
(statearr_24162[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__);

(statearr_24162[(1)] = (1));

return statearr_24162;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____1 = (function (state_24150){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24150);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24163){var ex__2687__auto__ = e24163;
var statearr_24164_24176 = state_24150;
(statearr_24164_24176[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24150[(4)]))){
var statearr_24165_24177 = state_24150;
(statearr_24165_24177[(1)] = cljs.core.first((state_24150[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24178 = state_24150;
state_24150 = G__24178;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__ = function(state_24150){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____1.call(this,state_24150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24166 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24166[(6)] = c__2706__auto___24167);

return statearr_24166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_ch;
});
/**
 * If the predicate is a ref? type with an 'o' value, it must be resolved into a subject id.
 */
fluree.db.query.subject_crawl.subject.resolve_o_ident = (function fluree$db$query$subject_crawl$subject$resolve_o_ident(db,p__24179){
var map__24180 = p__24179;
var map__24180__$1 = cljs.core.__destructure_map(map__24180);
var where_clause = map__24180__$1;
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24180__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24204){
var state_val_24205 = (state_24204[(1)]);
if((state_val_24205 === (7))){
var inst_24191 = (state_24204[(7)]);
var state_24204__$1 = state_24204;
var statearr_24206_24225 = state_24204__$1;
(statearr_24206_24225[(2)] = inst_24191);

(statearr_24206_24225[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (1))){
var state_24204__$1 = state_24204;
var statearr_24207_24226 = state_24204__$1;
(statearr_24207_24226[(2)] = null);

(statearr_24207_24226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (4))){
var inst_24181 = (state_24204[(2)]);
var state_24204__$1 = state_24204;
var statearr_24208_24227 = state_24204__$1;
(statearr_24208_24227[(2)] = inst_24181);

(statearr_24208_24227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (6))){
var inst_24191 = (state_24204[(7)]);
var inst_24190 = (state_24204[(2)]);
var inst_24191__$1 = fluree.db.util.async.throw_err(inst_24190);
var state_24204__$1 = (function (){var statearr_24209 = state_24204;
(statearr_24209[(7)] = inst_24191__$1);

return statearr_24209;
})();
if(cljs.core.truth_(inst_24191__$1)){
var statearr_24210_24228 = state_24204__$1;
(statearr_24210_24228[(1)] = (7));

} else {
var statearr_24211_24229 = state_24204__$1;
(statearr_24211_24229[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (3))){
var inst_24202 = (state_24204[(2)]);
var state_24204__$1 = state_24204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24204__$1,inst_24202);
} else {
if((state_val_24205 === (2))){
var _ = (function (){var statearr_24213 = state_24204;
(statearr_24213[(4)] = cljs.core.cons((5),(state_24204[(4)])));

return statearr_24213;
})();
var inst_24187 = new cljs.core.Keyword(null,"ident","ident",-742346).cljs$core$IFn$_invoke$arity$1(o);
var inst_24188 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_24187);
var state_24204__$1 = state_24204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24204__$1,(6),inst_24188);
} else {
if((state_val_24205 === (9))){
var inst_24195 = (state_24204[(2)]);
var inst_24196 = [new cljs.core.Keyword(null,"value","value",305978217)];
var inst_24197 = [inst_24195];
var inst_24198 = cljs.core.PersistentHashMap.fromArrays(inst_24196,inst_24197);
var inst_24199 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(where_clause,new cljs.core.Keyword(null,"o","o",-1350007228),inst_24198);
var _ = (function (){var statearr_24214 = state_24204;
(statearr_24214[(4)] = cljs.core.rest((state_24204[(4)])));

return statearr_24214;
})();
var state_24204__$1 = state_24204;
var statearr_24215_24230 = state_24204__$1;
(statearr_24215_24230[(2)] = inst_24199);

(statearr_24215_24230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (5))){
var _ = (function (){var statearr_24216 = state_24204;
(statearr_24216[(4)] = cljs.core.rest((state_24204[(4)])));

return statearr_24216;
})();
var state_24204__$1 = state_24204;
var ex24212 = (state_24204__$1[(2)]);
var statearr_24217_24231 = state_24204__$1;
(statearr_24217_24231[(5)] = ex24212);


if((ex24212 instanceof Error)){
var statearr_24218_24232 = state_24204__$1;
(statearr_24218_24232[(1)] = (4));

(statearr_24218_24232[(5)] = null);

} else {
throw ex24212;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (8))){
var state_24204__$1 = state_24204;
var statearr_24219_24233 = state_24204__$1;
(statearr_24219_24233[(2)] = (0));

(statearr_24219_24233[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____0 = (function (){
var statearr_24220 = [null,null,null,null,null,null,null,null];
(statearr_24220[(0)] = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__);

(statearr_24220[(1)] = (1));

return statearr_24220;
});
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____1 = (function (state_24204){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24204);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24221){var ex__2687__auto__ = e24221;
var statearr_24222_24234 = state_24204;
(statearr_24222_24234[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24204[(4)]))){
var statearr_24223_24235 = state_24204;
(statearr_24223_24235[(1)] = cljs.core.first((state_24204[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24236 = state_24204;
state_24204 = G__24236;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__ = function(state_24204){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____1.call(this,state_24204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24224 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24224[(6)] = c__2706__auto__);

return statearr_24224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__24237){
var map__24238 = p__24237;
var map__24238__$1 = cljs.core.__destructure_map(map__24238);
var opts = map__24238__$1;
var finish_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24238__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24238__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var f_where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24238__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24238__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24238__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var ident_vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24238__$1,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24238__$1,new cljs.core.Keyword(null,"db","db",993250759));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24238__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24238__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24332){
var state_val_24333 = (state_24332[(1)]);
if((state_val_24333 === (7))){
var state_24332__$1 = state_24332;
var statearr_24334_24386 = state_24332__$1;
(statearr_24334_24386[(2)] = vars);

(statearr_24334_24386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (20))){
var inst_24285 = (state_24332[(7)]);
var inst_24295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24296 = [error_ch,inst_24285];
var inst_24297 = (new cljs.core.PersistentVector(null,2,(5),inst_24295,inst_24296,null));
var state_24332__$1 = state_24332;
return cljs.core.async.ioc_alts_BANG_(state_24332__$1,(22),inst_24297);
} else {
if((state_val_24333 === (27))){
var state_24332__$1 = state_24332;
var statearr_24335_24387 = state_24332__$1;
(statearr_24335_24387[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (1))){
var state_24332__$1 = state_24332;
var statearr_24337_24388 = state_24332__$1;
(statearr_24337_24388[(2)] = null);

(statearr_24337_24388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (24))){
var inst_24300 = (state_24332[(8)]);
var inst_24309 = (inst_24300 == null);
var state_24332__$1 = state_24332;
if(cljs.core.truth_(inst_24309)){
var statearr_24338_24389 = state_24332__$1;
(statearr_24338_24389[(1)] = (26));

} else {
var statearr_24339_24390 = state_24332__$1;
(statearr_24339_24390[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (4))){
var inst_24239 = (state_24332[(2)]);
var state_24332__$1 = state_24332;
var statearr_24340_24391 = state_24332__$1;
(statearr_24340_24391[(2)] = inst_24239);

(statearr_24340_24391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (15))){
var inst_24271 = (state_24332[(9)]);
var inst_24271__$1 = (state_24332[(2)]);
var inst_24272 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_24271__$1);
var inst_24273 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"_id","_id",-789960287),inst_24272);
var state_24332__$1 = (function (){var statearr_24341 = state_24332;
(statearr_24341[(9)] = inst_24271__$1);

return statearr_24341;
})();
if(inst_24273){
var statearr_24342_24392 = state_24332__$1;
(statearr_24342_24392[(1)] = (17));

} else {
var statearr_24343_24393 = state_24332__$1;
(statearr_24343_24393[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (21))){
var inst_24327 = (state_24332[(2)]);
var _ = (function (){var statearr_24344 = state_24332;
(statearr_24344[(4)] = cljs.core.rest((state_24332[(4)])));

return statearr_24344;
})();
var state_24332__$1 = state_24332;
var statearr_24345_24394 = state_24332__$1;
(statearr_24345_24394[(2)] = inst_24327);

(statearr_24345_24394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (31))){
var inst_24321 = (state_24332[(2)]);
var state_24332__$1 = state_24332;
var statearr_24346_24395 = state_24332__$1;
(statearr_24346_24395[(2)] = inst_24321);

(statearr_24346_24395[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (13))){
var inst_24265 = fluree.db.query.subject_crawl.subject.resolve_o_ident(db,f_where);
var state_24332__$1 = state_24332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24332__$1,(16),inst_24265);
} else {
if((state_val_24333 === (22))){
var inst_24299 = (state_24332[(2)]);
var inst_24300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24299,(0),null);
var inst_24301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24299,(1),null);
var inst_24302 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24301,error_ch);
var state_24332__$1 = (function (){var statearr_24347 = state_24332;
(statearr_24347[(8)] = inst_24300);

return statearr_24347;
})();
if(inst_24302){
var statearr_24348_24396 = state_24332__$1;
(statearr_24348_24396[(1)] = (23));

} else {
var statearr_24349_24397 = state_24332__$1;
(statearr_24349_24397[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (29))){
var inst_24290 = (state_24332[(10)]);
var inst_24300 = (state_24332[(8)]);
var inst_24317 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24290,inst_24300);
var inst_24290__$1 = inst_24317;
var state_24332__$1 = (function (){var statearr_24350 = state_24332;
(statearr_24350[(10)] = inst_24290__$1);

return statearr_24350;
})();
var statearr_24351_24398 = state_24332__$1;
(statearr_24351_24398[(2)] = null);

(statearr_24351_24398[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (6))){
var inst_24251 = fluree.db.query.subject_crawl.common.resolve_ident_vars(db,vars,ident_vars);
var state_24332__$1 = state_24332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24332__$1,(9),inst_24251);
} else {
if((state_val_24333 === (28))){
var inst_24323 = (state_24332[(2)]);
var state_24332__$1 = state_24332;
var statearr_24352_24399 = state_24332__$1;
(statearr_24352_24399[(2)] = inst_24323);

(statearr_24352_24399[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (25))){
var inst_24325 = (state_24332[(2)]);
var state_24332__$1 = state_24332;
var statearr_24353_24400 = state_24332__$1;
(statearr_24353_24400[(2)] = inst_24325);

(statearr_24353_24400[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (17))){
var inst_24257 = (state_24332[(11)]);
var inst_24271 = (state_24332[(9)]);
var inst_24275 = fluree.db.query.subject_crawl.subject.subjects_id_chan(db,error_ch,inst_24257,inst_24271);
var state_24332__$1 = state_24332;
var statearr_24354_24401 = state_24332__$1;
(statearr_24354_24401[(2)] = inst_24275);

(statearr_24354_24401[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (3))){
var inst_24330 = (state_24332[(2)]);
var state_24332__$1 = state_24332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24332__$1,inst_24330);
} else {
if((state_val_24333 === (12))){
var inst_24263 = (state_24332[(2)]);
var state_24332__$1 = state_24332;
if(cljs.core.truth_(inst_24263)){
var statearr_24355_24402 = state_24332__$1;
(statearr_24355_24402[(1)] = (13));

} else {
var statearr_24356_24403 = state_24332__$1;
(statearr_24356_24403[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (2))){
var _ = (function (){var statearr_24357 = state_24332;
(statearr_24357[(4)] = cljs.core.cons((5),(state_24332[(4)])));

return statearr_24357;
})();
var inst_24246 = f_where;
var inst_24247 = cljs.core.__destructure_map(inst_24246);
var inst_24248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24247,new cljs.core.Keyword(null,"o","o",-1350007228));
var inst_24249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24247,new cljs.core.Keyword(null,"p-ref?","p-ref?",-1416067934));
var state_24332__$1 = (function (){var statearr_24358 = state_24332;
(statearr_24358[(12)] = inst_24248);

(statearr_24358[(13)] = inst_24249);

return statearr_24358;
})();
if(cljs.core.truth_(ident_vars)){
var statearr_24359_24404 = state_24332__$1;
(statearr_24359_24404[(1)] = (6));

} else {
var statearr_24360_24405 = state_24332__$1;
(statearr_24360_24405[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (23))){
var inst_24285 = (state_24332[(7)]);
var inst_24284 = (state_24332[(14)]);
var inst_24300 = (state_24332[(8)]);
var inst_24279 = (state_24332[(15)]);
var inst_24304 = cljs.core.async.close_BANG_(inst_24279);
var inst_24305 = cljs.core.async.close_BANG_(inst_24284);
var inst_24306 = cljs.core.async.close_BANG_(inst_24285);
var inst_24307 = (function(){throw inst_24300})();
var state_24332__$1 = (function (){var statearr_24361 = state_24332;
(statearr_24361[(16)] = inst_24306);

(statearr_24361[(17)] = inst_24304);

(statearr_24361[(18)] = inst_24305);

return statearr_24361;
})();
var statearr_24362_24406 = state_24332__$1;
(statearr_24362_24406[(2)] = inst_24307);

(statearr_24362_24406[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (19))){
var inst_24285 = (state_24332[(7)]);
var inst_24284 = (state_24332[(14)]);
var inst_24258 = (state_24332[(19)]);
var inst_24279 = (state_24332[(15)]);
var inst_24279__$1 = (state_24332[(2)]);
var inst_24280 = fluree.db.query.subject_crawl.subject.flakes_xf(inst_24258);
var inst_24281 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_24282 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_24283 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_24281,inst_24282);
var inst_24284__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((32),inst_24283);
var inst_24285__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24286 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24284__$1,inst_24280,inst_24279__$1);
var inst_24287 = fluree.db.query.subject_crawl.common.result_af(inst_24258);
var inst_24288 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24285__$1,inst_24287,inst_24284__$1);
var inst_24289 = cljs.core.PersistentVector.EMPTY;
var inst_24290 = inst_24289;
var state_24332__$1 = (function (){var statearr_24363 = state_24332;
(statearr_24363[(20)] = inst_24286);

(statearr_24363[(7)] = inst_24285__$1);

(statearr_24363[(14)] = inst_24284__$1);

(statearr_24363[(10)] = inst_24290);

(statearr_24363[(21)] = inst_24288);

(statearr_24363[(15)] = inst_24279__$1);

return statearr_24363;
})();
var statearr_24364_24407 = state_24332__$1;
(statearr_24364_24407[(2)] = null);

(statearr_24364_24407[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (11))){
var inst_24249 = (state_24332[(13)]);
var state_24332__$1 = state_24332;
var statearr_24366_24408 = state_24332__$1;
(statearr_24366_24408[(2)] = inst_24249);

(statearr_24366_24408[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (9))){
var inst_24253 = (state_24332[(2)]);
var inst_24254 = fluree.db.util.async.throw_err(inst_24253);
var state_24332__$1 = state_24332;
var statearr_24367_24409 = state_24332__$1;
(statearr_24367_24409[(2)] = inst_24254);

(statearr_24367_24409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (5))){
var _ = (function (){var statearr_24368 = state_24332;
(statearr_24368[(4)] = cljs.core.rest((state_24332[(4)])));

return statearr_24368;
})();
var state_24332__$1 = state_24332;
var ex24365 = (state_24332__$1[(2)]);
var statearr_24369_24410 = state_24332__$1;
(statearr_24369_24410[(5)] = ex24365);


if((ex24365 instanceof Error)){
var statearr_24370_24411 = state_24332__$1;
(statearr_24370_24411[(1)] = (4));

(statearr_24370_24411[(5)] = null);

} else {
throw ex24365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (14))){
var state_24332__$1 = state_24332;
var statearr_24371_24412 = state_24332__$1;
(statearr_24371_24412[(2)] = f_where);

(statearr_24371_24412[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (26))){
var inst_24285 = (state_24332[(7)]);
var inst_24284 = (state_24332[(14)]);
var inst_24290 = (state_24332[(10)]);
var inst_24279 = (state_24332[(15)]);
var inst_24311 = cljs.core.async.close_BANG_(inst_24279);
var inst_24312 = cljs.core.async.close_BANG_(inst_24284);
var inst_24313 = cljs.core.async.close_BANG_(inst_24285);
var inst_24314 = (finish_fn.cljs$core$IFn$_invoke$arity$1 ? finish_fn.cljs$core$IFn$_invoke$arity$1(inst_24290) : finish_fn.call(null,inst_24290));
var state_24332__$1 = (function (){var statearr_24372 = state_24332;
(statearr_24372[(22)] = inst_24313);

(statearr_24372[(23)] = inst_24311);

(statearr_24372[(24)] = inst_24312);

return statearr_24372;
})();
var statearr_24373_24413 = state_24332__$1;
(statearr_24373_24413[(2)] = inst_24314);

(statearr_24373_24413[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (16))){
var inst_24267 = (state_24332[(2)]);
var inst_24268 = fluree.db.util.async.throw_err(inst_24267);
var state_24332__$1 = state_24332;
var statearr_24374_24414 = state_24332__$1;
(statearr_24374_24414[(2)] = inst_24268);

(statearr_24374_24414[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (30))){
var state_24332__$1 = state_24332;
var statearr_24375_24415 = state_24332__$1;
(statearr_24375_24415[(2)] = null);

(statearr_24375_24415[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (10))){
var inst_24248 = (state_24332[(12)]);
var inst_24260 = new cljs.core.Keyword(null,"ident","ident",-742346).cljs$core$IFn$_invoke$arity$1(inst_24248);
var state_24332__$1 = state_24332;
var statearr_24376_24416 = state_24332__$1;
(statearr_24376_24416[(2)] = inst_24260);

(statearr_24376_24416[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (18))){
var inst_24257 = (state_24332[(11)]);
var inst_24271 = (state_24332[(9)]);
var inst_24277 = fluree.db.query.subject_crawl.subject.subjects_chan(db,error_ch,inst_24257,inst_24271);
var state_24332__$1 = state_24332;
var statearr_24377_24417 = state_24332__$1;
(statearr_24377_24417[(2)] = inst_24277);

(statearr_24377_24417[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24333 === (8))){
var inst_24257 = (state_24332[(11)]);
var inst_24249 = (state_24332[(13)]);
var inst_24257__$1 = (state_24332[(2)]);
var inst_24258 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_24257__$1);
var state_24332__$1 = (function (){var statearr_24378 = state_24332;
(statearr_24378[(19)] = inst_24258);

(statearr_24378[(11)] = inst_24257__$1);

return statearr_24378;
})();
if(cljs.core.truth_(inst_24249)){
var statearr_24379_24418 = state_24332__$1;
(statearr_24379_24418[(1)] = (10));

} else {
var statearr_24380_24419 = state_24332__$1;
(statearr_24380_24419[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____0 = (function (){
var statearr_24381 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24381[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__);

(statearr_24381[(1)] = (1));

return statearr_24381;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____1 = (function (state_24332){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24332);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24382){var ex__2687__auto__ = e24382;
var statearr_24383_24420 = state_24332;
(statearr_24383_24420[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24332[(4)]))){
var statearr_24384_24421 = state_24332;
(statearr_24384_24421[(1)] = cljs.core.first((state_24332[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24422 = state_24332;
state_24332 = G__24422;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__ = function(state_24332){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____1.call(this,state_24332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24385 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24385[(6)] = c__2706__auto__);

return statearr_24385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
