// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27286,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27290 = k27286;
var G__27290__$1 = (((G__27290 instanceof cljs.core.Keyword))?G__27290.fqn:null);
switch (G__27290__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27286,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__27291){
var vec__27292 = p__27291;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27292,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27292,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27285){
var self__ = this;
var G__27285__$1 = this;
return (new cljs.core.RecordIter((0),G__27285__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__27295 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__27295(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27287,other27288){
var self__ = this;
var this27287__$1 = this;
return (((!((other27288 == null)))) && ((((this27287__$1.constructor === other27288.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.conn,other27288.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.network,other27288.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.ledger_id,other27288.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.db_name,other27288.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.update_chan,other27288.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.transact_chan,other27288.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.state,other27288.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.schema_cache,other27288.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.blank_db,other27288.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.close,other27288.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.id,other27288.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27287__$1.__extmap,other27288.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27286){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27296 = k27286;
var G__27296__$1 = (((G__27296 instanceof cljs.core.Keyword))?G__27296.fqn:null);
switch (G__27296__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27286);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27285){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27297 = cljs.core.keyword_identical_QMARK_;
var expr__27298 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__27300 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27301 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27300,G__27301) : pred__27297.call(null,G__27300,G__27301));
})())){
return (new fluree.db.session.DbSession(G__27285,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27302 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27303 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27302,G__27303) : pred__27297.call(null,G__27302,G__27303));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__27285,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27304 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__27305 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27304,G__27305) : pred__27297.call(null,G__27304,G__27305));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27285,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27306 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__27307 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27306,G__27307) : pred__27297.call(null,G__27306,G__27307));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__27285,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27308 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__27309 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27308,G__27309) : pred__27297.call(null,G__27308,G__27309));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__27285,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27310 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__27311 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27310,G__27311) : pred__27297.call(null,G__27310,G__27311));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__27285,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27312 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__27313 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27312,G__27313) : pred__27297.call(null,G__27312,G__27313));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__27285,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27314 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27315 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27314,G__27315) : pred__27297.call(null,G__27314,G__27315));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27285,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27316 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__27317 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27316,G__27317) : pred__27297.call(null,G__27316,G__27317));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27285,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27318 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__27319 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27318,G__27319) : pred__27297.call(null,G__27318,G__27319));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27285,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27320 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__27321 = expr__27298;
return (pred__27297.cljs$core$IFn$_invoke$arity$2 ? pred__27297.cljs$core$IFn$_invoke$arity$2(G__27320,G__27321) : pred__27297.call(null,G__27320,G__27321));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27285,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__27285),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27285){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27285,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27289){
var extmap__5385__auto__ = (function (){var G__27322 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27289,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__27289)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27322);
} else {
return G__27322;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27289),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27289),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27289),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27289),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27289),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27289),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27289),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27289),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27289),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27289),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27289),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27325 = session;
var map__27325__$1 = cljs.core.__destructure_map(map__27325);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27325__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27325__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,ledger_id){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27367){
var state_val_27368 = (state_27367[(1)]);
if((state_val_27368 === (7))){
var inst_27341 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not found on this ledger group."].join('');
var inst_27342 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27343 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27344 = cljs.core.PersistentHashMap.fromArrays(inst_27342,inst_27343);
var inst_27345 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27341,inst_27344);
var inst_27346 = (function(){throw inst_27345})();
var state_27367__$1 = state_27367;
var statearr_27369_27392 = state_27367__$1;
(statearr_27369_27392[(2)] = inst_27346);

(statearr_27369_27392[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27368 === (1))){
var state_27367__$1 = state_27367;
var statearr_27370_27393 = state_27367__$1;
(statearr_27370_27393[(2)] = null);

(statearr_27370_27393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27368 === (4))){
var inst_27326 = (state_27367[(2)]);
var state_27367__$1 = state_27367;
var statearr_27371_27394 = state_27367__$1;
(statearr_27371_27394[(2)] = inst_27326);

(statearr_27371_27394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27368 === (6))){
var inst_27338 = (state_27367[(7)]);
var inst_27337 = (state_27367[(2)]);
var inst_27338__$1 = fluree.db.util.async.throw_err(inst_27337);
var inst_27339 = cljs.core.empty_QMARK_(inst_27338__$1);
var state_27367__$1 = (function (){var statearr_27372 = state_27367;
(statearr_27372[(7)] = inst_27338__$1);

return statearr_27372;
})();
if(inst_27339){
var statearr_27373_27395 = state_27367__$1;
(statearr_27373_27395[(1)] = (7));

} else {
var statearr_27374_27396 = state_27367__$1;
(statearr_27374_27396[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27368 === (3))){
var inst_27365 = (state_27367[(2)]);
var state_27367__$1 = state_27367;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27367__$1,inst_27365);
} else {
if((state_val_27368 === (12))){
var inst_27360 = (state_27367[(2)]);
var state_27367__$1 = state_27367;
var statearr_27375_27397 = state_27367__$1;
(statearr_27375_27397[(2)] = inst_27360);

(statearr_27375_27397[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27368 === (2))){
var _ = (function (){var statearr_27376 = state_27367;
(statearr_27376[(4)] = cljs.core.cons((5),(state_27367[(4)])));

return statearr_27376;
})();
var inst_27332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27333 = [network,ledger_id];
var inst_27334 = (new cljs.core.PersistentVector(null,2,(5),inst_27332,inst_27333,null));
var inst_27335 = fluree.db.operations.ledger_info_async(conn,inst_27334);
var state_27367__$1 = state_27367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27367__$1,(6),inst_27335);
} else {
if((state_val_27368 === (11))){
var inst_27338 = (state_27367[(7)]);
var state_27367__$1 = state_27367;
var statearr_27378_27398 = state_27367__$1;
(statearr_27378_27398[(2)] = inst_27338);

(statearr_27378_27398[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27368 === (9))){
var inst_27362 = (state_27367[(2)]);
var _ = (function (){var statearr_27379 = state_27367;
(statearr_27379[(4)] = cljs.core.rest((state_27367[(4)])));

return statearr_27379;
})();
var state_27367__$1 = state_27367;
var statearr_27380_27399 = state_27367__$1;
(statearr_27380_27399[(2)] = inst_27362);

(statearr_27380_27399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27368 === (5))){
var _ = (function (){var statearr_27381 = state_27367;
(statearr_27381[(4)] = cljs.core.rest((state_27367[(4)])));

return statearr_27381;
})();
var state_27367__$1 = state_27367;
var ex27377 = (state_27367__$1[(2)]);
var statearr_27382_27400 = state_27367__$1;
(statearr_27382_27400[(5)] = ex27377);


if((ex27377 instanceof Error)){
var statearr_27383_27401 = state_27367__$1;
(statearr_27383_27401[(1)] = (4));

(statearr_27383_27401[(5)] = null);

} else {
throw ex27377;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27368 === (10))){
var inst_27338 = (state_27367[(7)]);
var inst_27351 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27338);
var inst_27352 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27351),"."].join('');
var inst_27353 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27354 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27355 = cljs.core.PersistentHashMap.fromArrays(inst_27353,inst_27354);
var inst_27356 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27352,inst_27355);
var inst_27357 = (function(){throw inst_27356})();
var state_27367__$1 = state_27367;
var statearr_27384_27402 = state_27367__$1;
(statearr_27384_27402[(2)] = inst_27357);

(statearr_27384_27402[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27368 === (8))){
var inst_27338 = (state_27367[(7)]);
var inst_27348 = fluree.db.session.ready_QMARK_(inst_27338);
var inst_27349 = (!(inst_27348));
var state_27367__$1 = state_27367;
if(inst_27349){
var statearr_27385_27403 = state_27367__$1;
(statearr_27385_27403[(1)] = (10));

} else {
var statearr_27386_27404 = state_27367__$1;
(statearr_27386_27404[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0 = (function (){
var statearr_27387 = [null,null,null,null,null,null,null,null];
(statearr_27387[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2684__auto__);

(statearr_27387[(1)] = (1));

return statearr_27387;
});
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1 = (function (state_27367){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27367);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27388){var ex__2687__auto__ = e27388;
var statearr_27389_27405 = state_27367;
(statearr_27389_27405[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27367[(4)]))){
var statearr_27390_27406 = state_27367;
(statearr_27390_27406[(1)] = cljs.core.first((state_27367[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27407 = state_27367;
state_27367 = G__27407;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__ = function(state_27367){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1.call(this,state_27367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27391 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27391[(6)] = c__2706__auto__);

return statearr_27391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__27408){
var map__27409 = p__27408;
var map__27409__$1 = cljs.core.__destructure_map(map__27409);
var blank_db = map__27409__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27409__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27409__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27484){
var state_val_27485 = (state_27484[(1)]);
if((state_val_27485 === (7))){
var inst_27427 = (state_27484[(7)]);
var inst_27426 = (state_27484[(2)]);
var inst_27427__$1 = fluree.db.util.async.throw_err(inst_27426);
var state_27484__$1 = (function (){var statearr_27486 = state_27484;
(statearr_27486[(7)] = inst_27427__$1);

return statearr_27486;
})();
if(cljs.core.truth_(inst_27427__$1)){
var statearr_27487_27522 = state_27484__$1;
(statearr_27487_27522[(1)] = (8));

} else {
var statearr_27488_27523 = state_27484__$1;
(statearr_27488_27523[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (20))){
var inst_27432 = (state_27484[(8)]);
var inst_27465 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27432)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27466 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27467 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27468 = cljs.core.PersistentHashMap.fromArrays(inst_27466,inst_27467);
var inst_27469 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27465,inst_27468);
var inst_27470 = (function(){throw inst_27469})();
var state_27484__$1 = state_27484;
var statearr_27489_27524 = state_27484__$1;
(statearr_27489_27524[(2)] = inst_27470);

(statearr_27489_27524[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (1))){
var state_27484__$1 = state_27484;
var statearr_27490_27525 = state_27484__$1;
(statearr_27490_27525[(2)] = null);

(statearr_27490_27525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (4))){
var inst_27410 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27491_27526 = state_27484__$1;
(statearr_27491_27526[(2)] = inst_27410);

(statearr_27491_27526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (15))){
var inst_27474 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27492_27527 = state_27484__$1;
(statearr_27492_27527[(2)] = inst_27474);

(statearr_27492_27527[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (21))){
var inst_27472 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27493_27528 = state_27484__$1;
(statearr_27493_27528[(2)] = inst_27472);

(statearr_27493_27528[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (13))){
var inst_27431 = (state_27484[(9)]);
var inst_27436 = fluree.db.query.schema.schema_map(inst_27431);
var inst_27437 = fluree.db.query.schema.setting_map(inst_27431);
var inst_27438 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_27431);
var inst_27439 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_27438,cljs.core.empty);
var state_27484__$1 = (function (){var statearr_27494 = state_27484;
(statearr_27494[(10)] = inst_27437);

(statearr_27494[(11)] = inst_27439);

return statearr_27494;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27484__$1,(16),inst_27436);
} else {
if((state_val_27485 === (22))){
var inst_27432 = (state_27484[(8)]);
var inst_27460 = (state_27484[(2)]);
var inst_27461 = fluree.db.util.async.throw_err(inst_27460);
var inst_27462 = (inst_27432 + (1));
var inst_27431 = inst_27461;
var inst_27432__$1 = inst_27462;
var state_27484__$1 = (function (){var statearr_27495 = state_27484;
(statearr_27495[(8)] = inst_27432__$1);

(statearr_27495[(9)] = inst_27431);

return statearr_27495;
})();
var statearr_27496_27529 = state_27484__$1;
(statearr_27496_27529[(2)] = null);

(statearr_27496_27529[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (6))){
var inst_27419 = (state_27484[(2)]);
var inst_27420 = fluree.db.util.async.throw_err(inst_27419);
var inst_27421 = cljs.core.__destructure_map(inst_27420);
var inst_27422 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27421,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27423 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27421,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_27424 = fluree.db.storage.core.reify_db(conn,network,ledger_id,blank_db,inst_27423);
var state_27484__$1 = (function (){var statearr_27497 = state_27484;
(statearr_27497[(12)] = inst_27422);

return statearr_27497;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27484__$1,(7),inst_27424);
} else {
if((state_val_27485 === (17))){
var inst_27431 = (state_27484[(9)]);
var inst_27442 = (state_27484[(13)]);
var inst_27444 = (state_27484[(2)]);
var inst_27445 = fluree.db.util.async.throw_err(inst_27444);
var inst_27446 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_27431,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27442,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27445], 0));
var state_27484__$1 = state_27484;
var statearr_27498_27530 = state_27484__$1;
(statearr_27498_27530[(2)] = inst_27446);

(statearr_27498_27530[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (3))){
var inst_27482 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27484__$1,inst_27482);
} else {
if((state_val_27485 === (12))){
var inst_27476 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27499_27531 = state_27484__$1;
(statearr_27499_27531[(2)] = inst_27476);

(statearr_27499_27531[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (2))){
var _ = (function (){var statearr_27500 = state_27484;
(statearr_27500[(4)] = cljs.core.cons((5),(state_27484[(4)])));

return statearr_27500;
})();
var inst_27417 = fluree.db.session.load_ledger_info(conn,network,ledger_id);
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27484__$1,(6),inst_27417);
} else {
if((state_val_27485 === (19))){
var inst_27451 = (state_27484[(14)]);
var inst_27431 = (state_27484[(9)]);
var inst_27454 = cljs.core.__destructure_map(inst_27451);
var inst_27455 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27454,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27456 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27454,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27457 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27454,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27458 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27431,inst_27456,inst_27455);
var state_27484__$1 = (function (){var statearr_27501 = state_27484;
(statearr_27501[(15)] = inst_27457);

return statearr_27501;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27484__$1,(22),inst_27458);
} else {
if((state_val_27485 === (11))){
var inst_27422 = (state_27484[(12)]);
var inst_27432 = (state_27484[(8)]);
var inst_27434 = (inst_27432 > inst_27422);
var state_27484__$1 = state_27484;
if(cljs.core.truth_(inst_27434)){
var statearr_27503_27532 = state_27484__$1;
(statearr_27503_27532[(1)] = (13));

} else {
var statearr_27504_27533 = state_27484__$1;
(statearr_27504_27533[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (9))){
var state_27484__$1 = state_27484;
var statearr_27505_27534 = state_27484__$1;
(statearr_27505_27534[(2)] = null);

(statearr_27505_27534[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (5))){
var _ = (function (){var statearr_27506 = state_27484;
(statearr_27506[(4)] = cljs.core.rest((state_27484[(4)])));

return statearr_27506;
})();
var state_27484__$1 = state_27484;
var ex27502 = (state_27484__$1[(2)]);
var statearr_27507_27535 = state_27484__$1;
(statearr_27507_27535[(5)] = ex27502);


if((ex27502 instanceof Error)){
var statearr_27508_27536 = state_27484__$1;
(statearr_27508_27536[(1)] = (4));

(statearr_27508_27536[(5)] = null);

} else {
throw ex27502;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (14))){
var inst_27432 = (state_27484[(8)]);
var inst_27448 = fluree.db.storage.core.read_block(conn,network,ledger_id,inst_27432);
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27484__$1,(18),inst_27448);
} else {
if((state_val_27485 === (16))){
var inst_27437 = (state_27484[(10)]);
var inst_27441 = (state_27484[(2)]);
var inst_27442 = fluree.db.util.async.throw_err(inst_27441);
var state_27484__$1 = (function (){var statearr_27509 = state_27484;
(statearr_27509[(13)] = inst_27442);

return statearr_27509;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27484__$1,(17),inst_27437);
} else {
if((state_val_27485 === (10))){
var inst_27479 = (state_27484[(2)]);
var _ = (function (){var statearr_27510 = state_27484;
(statearr_27510[(4)] = cljs.core.rest((state_27484[(4)])));

return statearr_27510;
})();
var state_27484__$1 = state_27484;
var statearr_27511_27537 = state_27484__$1;
(statearr_27511_27537[(2)] = inst_27479);

(statearr_27511_27537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (18))){
var inst_27451 = (state_27484[(14)]);
var inst_27450 = (state_27484[(2)]);
var inst_27451__$1 = fluree.db.util.async.throw_err(inst_27450);
var state_27484__$1 = (function (){var statearr_27512 = state_27484;
(statearr_27512[(14)] = inst_27451__$1);

return statearr_27512;
})();
if(cljs.core.truth_(inst_27451__$1)){
var statearr_27513_27538 = state_27484__$1;
(statearr_27513_27538[(1)] = (19));

} else {
var statearr_27514_27539 = state_27484__$1;
(statearr_27514_27539[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (8))){
var inst_27427 = (state_27484[(7)]);
var inst_27429 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27427);
var inst_27430 = (inst_27429 + (1));
var inst_27431 = inst_27427;
var inst_27432 = inst_27430;
var state_27484__$1 = (function (){var statearr_27515 = state_27484;
(statearr_27515[(8)] = inst_27432);

(statearr_27515[(9)] = inst_27431);

return statearr_27515;
})();
var statearr_27516_27540 = state_27484__$1;
(statearr_27516_27540[(2)] = null);

(statearr_27516_27540[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2684__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2684__auto____0 = (function (){
var statearr_27517 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27517[(0)] = fluree$db$session$load_current_db_$_state_machine__2684__auto__);

(statearr_27517[(1)] = (1));

return statearr_27517;
});
var fluree$db$session$load_current_db_$_state_machine__2684__auto____1 = (function (state_27484){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27484);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27518){var ex__2687__auto__ = e27518;
var statearr_27519_27541 = state_27484;
(statearr_27519_27541[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27484[(4)]))){
var statearr_27520_27542 = state_27484;
(statearr_27520_27542[(1)] = cljs.core.first((state_27484[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27543 = state_27484;
state_27484 = G__27543;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2684__auto__ = function(state_27484){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2684__auto____1.call(this,state_27484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2684__auto____0;
fluree$db$session$load_current_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2684__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27521 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27521[(6)] = c__2706__auto__);

return statearr_27521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__27544,old_db_ch,new_db_ch){
var map__27545 = p__27544;
var map__27545__$1 = cljs.core.__destructure_map(map__27545);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27545__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p__27546){
var map__27547 = p__27546;
var map__27547__$1 = cljs.core.__destructure_map(map__27547);
var s = map__27547__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27547__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current,old_db_ch)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__27548){
var map__27549 = p__27548;
var map__27549__$1 = cljs.core.__destructure_map(map__27549);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27549__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__27550){
var map__27551 = p__27550;
var map__27551__$1 = cljs.core.__destructure_map(map__27551);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27551__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27551__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27551__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2706__auto___27588 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27571){
var state_val_27572 = (state_27571[(1)]);
if((state_val_27572 === (1))){
var state_27571__$1 = state_27571;
var statearr_27573_27589 = state_27571__$1;
(statearr_27573_27589[(2)] = null);

(statearr_27573_27589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27572 === (2))){
var _ = (function (){var statearr_27574 = state_27571;
(statearr_27574[(4)] = cljs.core.cons((5),(state_27571[(4)])));

return statearr_27574;
})();
var inst_27561 = fluree.db.session.load_current_db(conn,blank_db);
var state_27571__$1 = state_27571;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27571__$1,(6),inst_27561);
} else {
if((state_val_27572 === (3))){
var inst_27569 = (state_27571[(2)]);
var state_27571__$1 = state_27571;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27571__$1,inst_27569);
} else {
if((state_val_27572 === (4))){
var inst_27552 = (state_27571[(2)]);
var inst_27553 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27554 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_27552,"Error reloading db") : fluree.db.util.log.error.call(null,inst_27552,"Error reloading db"));
var inst_27555 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(db_ch,inst_27552);
var state_27571__$1 = (function (){var statearr_27576 = state_27571;
(statearr_27576[(7)] = inst_27554);

(statearr_27576[(8)] = inst_27553);

return statearr_27576;
})();
var statearr_27577_27590 = state_27571__$1;
(statearr_27577_27590[(2)] = inst_27555);

(statearr_27577_27590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27572 === (5))){
var _ = (function (){var statearr_27578 = state_27571;
(statearr_27578[(4)] = cljs.core.rest((state_27571[(4)])));

return statearr_27578;
})();
var state_27571__$1 = state_27571;
var ex27575 = (state_27571__$1[(2)]);
var statearr_27579_27591 = state_27571__$1;
(statearr_27579_27591[(5)] = ex27575);


var statearr_27580_27592 = state_27571__$1;
(statearr_27580_27592[(1)] = (4));

(statearr_27580_27592[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27572 === (6))){
var inst_27563 = (state_27571[(2)]);
var inst_27564 = fluree.db.util.async.throw_err(inst_27563);
var state_27571__$1 = state_27571;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27571__$1,(7),db_ch,inst_27564);
} else {
if((state_val_27572 === (7))){
var inst_27566 = (state_27571[(2)]);
var _ = (function (){var statearr_27581 = state_27571;
(statearr_27581[(4)] = cljs.core.rest((state_27571[(4)])));

return statearr_27581;
})();
var state_27571__$1 = state_27571;
var statearr_27582_27593 = state_27571__$1;
(statearr_27582_27593[(2)] = inst_27566);

(statearr_27582_27593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0 = (function (){
var statearr_27583 = [null,null,null,null,null,null,null,null,null];
(statearr_27583[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__);

(statearr_27583[(1)] = (1));

return statearr_27583;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1 = (function (state_27571){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27571);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27584){var ex__2687__auto__ = e27584;
var statearr_27585_27594 = state_27571;
(statearr_27585_27594[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27571[(4)]))){
var statearr_27586_27595 = state_27571;
(statearr_27586_27595[(1)] = cljs.core.first((state_27571[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27596 = state_27571;
state_27571 = G__27596;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__ = function(state_27571){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1.call(this,state_27571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27587 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27587[(6)] = c__2706__auto___27588);

return statearr_27587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__27598 = arguments.length;
switch (G__27598) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__27599){
var map__27600 = p__27599;
var map__27600__$1 = cljs.core.__destructure_map(map__27600);
var session = map__27600__$1;
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27600__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2(session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__27601,blank_db){
var map__27602 = p__27601;
var map__27602__$1 = cljs.core.__destructure_map(map__27602);
var session = map__27602__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27602__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27602__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis()),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
if(cljs.core.not(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cur_ch,state_ch)){
var c__2706__auto___27640 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27622){
var state_val_27623 = (state_27622[(1)]);
if((state_val_27623 === (1))){
var state_27622__$1 = state_27622;
var statearr_27624_27641 = state_27622__$1;
(statearr_27624_27641[(2)] = null);

(statearr_27624_27641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27623 === (2))){
var _ = (function (){var statearr_27625 = state_27622;
(statearr_27625[(4)] = cljs.core.cons((5),(state_27622[(4)])));

return statearr_27625;
})();
var inst_27612 = fluree.db.session.load_current_db(conn,blank_db);
var state_27622__$1 = state_27622;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27622__$1,(6),inst_27612);
} else {
if((state_val_27623 === (3))){
var inst_27620 = (state_27622[(2)]);
var state_27622__$1 = state_27622;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27622__$1,inst_27620);
} else {
if((state_val_27623 === (4))){
var inst_27603 = (state_27622[(2)]);
var inst_27604 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27605 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_27603,"Error loading current db") : fluree.db.util.log.error.call(null,inst_27603,"Error loading current db"));
var inst_27606 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cur_ch,inst_27603);
var state_27622__$1 = (function (){var statearr_27627 = state_27622;
(statearr_27627[(7)] = inst_27605);

(statearr_27627[(8)] = inst_27604);

return statearr_27627;
})();
var statearr_27628_27642 = state_27622__$1;
(statearr_27628_27642[(2)] = inst_27606);

(statearr_27628_27642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27623 === (5))){
var _ = (function (){var statearr_27629 = state_27622;
(statearr_27629[(4)] = cljs.core.rest((state_27622[(4)])));

return statearr_27629;
})();
var state_27622__$1 = state_27622;
var ex27626 = (state_27622__$1[(2)]);
var statearr_27630_27643 = state_27622__$1;
(statearr_27630_27643[(5)] = ex27626);


var statearr_27631_27644 = state_27622__$1;
(statearr_27631_27644[(1)] = (4));

(statearr_27631_27644[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27623 === (6))){
var inst_27614 = (state_27622[(2)]);
var inst_27615 = fluree.db.util.async.throw_err(inst_27614);
var state_27622__$1 = state_27622;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27622__$1,(7),cur_ch,inst_27615);
} else {
if((state_val_27623 === (7))){
var inst_27617 = (state_27622[(2)]);
var _ = (function (){var statearr_27632 = state_27622;
(statearr_27632[(4)] = cljs.core.rest((state_27622[(4)])));

return statearr_27632;
})();
var state_27622__$1 = state_27622;
var statearr_27633_27645 = state_27622__$1;
(statearr_27633_27645[(2)] = inst_27617);

(statearr_27633_27645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27634 = [null,null,null,null,null,null,null,null,null];
(statearr_27634[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27634[(1)] = (1));

return statearr_27634;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27622){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27622);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27635){var ex__2687__auto__ = e27635;
var statearr_27636_27646 = state_27622;
(statearr_27636_27646[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27622[(4)]))){
var statearr_27637_27647 = state_27622;
(statearr_27637_27647[(1)] = cljs.core.first((state_27622[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27648 = state_27622;
state_27622 = G__27648;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27622){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27638 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27638[(6)] = c__2706__auto___27640);

return statearr_27638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger named testledger on network testnet.
 *   - [testnet testledger] - already in form of [network ledger-id]
 * 
 *   The two-arity version of this exists for backwards compatibility. It doesn't do anything with the
 *   conn arg so there is also a single-arity version that just takes the ledger name.
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(var_args){
var G__27650 = arguments.length;
switch (G__27650) {
case 1:
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$1 = (function (ledger){
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(null,ledger);
}));

(fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2 = (function (_conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var ledger_id = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return ledger_id;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
}
}));

(fluree.db.session.resolve_ledger.cljs$lang$maxFixedArity = 2);

if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__27652 = cljs.core.get_global_hierarchy;
return (fexpr__27652.cljs$core$IFn$_invoke$arity$0 ? fexpr__27652.cljs$core$IFn$_invoke$arity$0() : fexpr__27652.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27654){
var state_val_27655 = (state_27654[(1)]);
if((state_val_27655 === (1))){
var state_27654__$1 = state_27654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27654__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27656 = [null,null,null,null,null,null,null];
(statearr_27656[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27656[(1)] = (1));

return statearr_27656;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27654){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27654);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27657){var ex__2687__auto__ = e27657;
var statearr_27658_27661 = state_27654;
(statearr_27658_27661[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27654[(4)]))){
var statearr_27659_27662 = state_27654;
(statearr_27659_27662[(1)] = cljs.core.first((state_27654[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27663 = state_27654;
state_27654 = G__27663;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27654){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27660 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27660[(6)] = c__2706__auto__);

return statearr_27660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27664){
var map__27665 = p__27664;
var map__27665__$1 = cljs.core.__destructure_map(map__27665);
var data = map__27665__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27665__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27665__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27665__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27724){
var state_val_27725 = (state_27724[(1)]);
if((state_val_27725 === (7))){
var inst_27676 = (state_27724[(7)]);
var inst_27679 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27680 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27681 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27679),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27680),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27676),". No-op."].join('');
var inst_27682 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(inst_27681) : fluree.db.util.log.info.call(null,inst_27681));
var state_27724__$1 = state_27724;
var statearr_27726_27764 = state_27724__$1;
(statearr_27726_27764[(2)] = inst_27682);

(statearr_27726_27764[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (1))){
var state_27724__$1 = state_27724;
var statearr_27727_27765 = state_27724__$1;
(statearr_27727_27765[(2)] = null);

(statearr_27727_27765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (4))){
var inst_27666 = (state_27724[(2)]);
var state_27724__$1 = state_27724;
var statearr_27728_27766 = state_27724__$1;
(statearr_27728_27766[(2)] = inst_27666);

(statearr_27728_27766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (15))){
var inst_27705 = (state_27724[(2)]);
var state_27724__$1 = state_27724;
var statearr_27729_27767 = state_27724__$1;
(statearr_27729_27767[(2)] = inst_27705);

(statearr_27729_27767[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (13))){
var inst_27696 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27697 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27698 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27699 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27700 = [inst_27698,inst_27699];
var inst_27701 = (new cljs.core.PersistentVector(null,2,(5),inst_27697,inst_27700,null));
var inst_27702 = (function (){var G__27730 = inst_27696;
var G__27731 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__27732 = inst_27701;
var G__27733 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__27730,G__27731,G__27732,G__27733) : fluree.db.conn_events.process_event.call(null,G__27730,G__27731,G__27732,G__27733));
})();
var state_27724__$1 = state_27724;
var statearr_27734_27768 = state_27724__$1;
(statearr_27734_27768[(2)] = inst_27702);

(statearr_27734_27768[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (6))){
var inst_27676 = (state_27724[(7)]);
var inst_27675 = (state_27724[(8)]);
var inst_27674 = (state_27724[(2)]);
var inst_27675__$1 = fluree.db.util.async.throw_err(inst_27674);
var inst_27676__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27675__$1);
var inst_27677 = (block <= inst_27676__$1);
var state_27724__$1 = (function (){var statearr_27735 = state_27724;
(statearr_27735[(7)] = inst_27676__$1);

(statearr_27735[(8)] = inst_27675__$1);

return statearr_27735;
})();
if(cljs.core.truth_(inst_27677)){
var statearr_27736_27769 = state_27724__$1;
(statearr_27736_27769[(1)] = (7));

} else {
var statearr_27737_27770 = state_27724__$1;
(statearr_27737_27770[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (17))){
var state_27724__$1 = state_27724;
var statearr_27738_27771 = state_27724__$1;
(statearr_27738_27771[(2)] = null);

(statearr_27738_27771[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (3))){
var inst_27722 = (state_27724[(2)]);
var state_27724__$1 = state_27724;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27724__$1,inst_27722);
} else {
if((state_val_27725 === (12))){
var inst_27717 = (state_27724[(2)]);
var state_27724__$1 = state_27724;
var statearr_27739_27772 = state_27724__$1;
(statearr_27739_27772[(2)] = inst_27717);

(statearr_27739_27772[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (2))){
var inst_27672 = (state_27724[(9)]);
var _ = (function (){var statearr_27740 = state_27724;
(statearr_27740[(4)] = cljs.core.cons((5),(state_27724[(4)])));

return statearr_27740;
})();
var inst_27672__$1 = fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
var state_27724__$1 = (function (){var statearr_27741 = state_27724;
(statearr_27741[(9)] = inst_27672__$1);

return statearr_27741;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27724__$1,(6),inst_27672__$1);
} else {
if((state_val_27725 === (11))){
var state_27724__$1 = state_27724;
var statearr_27743_27773 = state_27724__$1;
(statearr_27743_27773[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (9))){
var inst_27719 = (state_27724[(2)]);
var _ = (function (){var statearr_27745 = state_27724;
(statearr_27745[(4)] = cljs.core.rest((state_27724[(4)])));

return statearr_27745;
})();
var state_27724__$1 = state_27724;
var statearr_27746_27774 = state_27724__$1;
(statearr_27746_27774[(2)] = inst_27719);

(statearr_27746_27774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (5))){
var _ = (function (){var statearr_27747 = state_27724;
(statearr_27747[(4)] = cljs.core.rest((state_27724[(4)])));

return statearr_27747;
})();
var state_27724__$1 = state_27724;
var ex27742 = (state_27724__$1[(2)]);
var statearr_27748_27775 = state_27724__$1;
(statearr_27748_27775[(5)] = ex27742);


if((ex27742 instanceof Error)){
var statearr_27749_27776 = state_27724__$1;
(statearr_27749_27776[(1)] = (4));

(statearr_27749_27776[(5)] = null);

} else {
throw ex27742;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (14))){
var state_27724__$1 = state_27724;
var statearr_27750_27777 = state_27724__$1;
(statearr_27750_27777[(2)] = null);

(statearr_27750_27777[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (16))){
var inst_27676 = (state_27724[(7)]);
var inst_27708 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27709 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27710 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27708),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27709),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27676),". Forcing a db reload."].join('');
var inst_27711 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(inst_27710) : fluree.db.util.log.info.call(null,inst_27710));
var inst_27712 = fluree.db.session.reload_db_BANG_(session);
var state_27724__$1 = (function (){var statearr_27751 = state_27724;
(statearr_27751[(10)] = inst_27711);

return statearr_27751;
})();
var statearr_27752_27778 = state_27724__$1;
(statearr_27752_27778[(2)] = inst_27712);

(statearr_27752_27778[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (10))){
var inst_27676 = (state_27724[(7)]);
var inst_27675 = (state_27724[(8)]);
var inst_27672 = (state_27724[(9)]);
var inst_27687 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27688 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27689 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27687),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27688),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27690 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$1(inst_27689) : fluree.db.util.log.trace.call(null,inst_27689));
var inst_27691 = (function (){var current_db_ch = inst_27672;
var current_db = inst_27675;
var current_block = inst_27676;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(f);
}
});
})();
var inst_27692 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27691,flakes);
var inst_27693 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27675,block,inst_27692);
var inst_27694 = fluree.db.session.cas_db_BANG_(session,inst_27672,inst_27693);
var state_27724__$1 = (function (){var statearr_27753 = state_27724;
(statearr_27753[(11)] = inst_27690);

return statearr_27753;
})();
if(inst_27694){
var statearr_27754_27779 = state_27724__$1;
(statearr_27754_27779[(1)] = (13));

} else {
var statearr_27755_27780 = state_27724__$1;
(statearr_27755_27780[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (18))){
var inst_27715 = (state_27724[(2)]);
var state_27724__$1 = state_27724;
var statearr_27756_27781 = state_27724__$1;
(statearr_27756_27781[(2)] = inst_27715);

(statearr_27756_27781[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (8))){
var inst_27676 = (state_27724[(7)]);
var inst_27684 = ((1) + inst_27676);
var inst_27685 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27684);
var state_27724__$1 = state_27724;
if(inst_27685){
var statearr_27757_27782 = state_27724__$1;
(statearr_27757_27782[(1)] = (10));

} else {
var statearr_27758_27783 = state_27724__$1;
(statearr_27758_27783[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27759 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27759[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27759[(1)] = (1));

return statearr_27759;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27724){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27724);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27760){var ex__2687__auto__ = e27760;
var statearr_27761_27784 = state_27724;
(statearr_27761_27784[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27724[(4)]))){
var statearr_27762_27785 = state_27724;
(statearr_27762_27785[(1)] = cljs.core.first((state_27724[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27786 = state_27724;
state_27724 = G__27786;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27724){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27763 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27763[(6)] = c__2706__auto__);

return statearr_27763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27793){
var state_val_27794 = (state_27793[(1)]);
if((state_val_27794 === (1))){
var inst_27787 = fluree.db.session.clear_db_BANG_(session);
var inst_27788 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27789 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27790 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27788),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27789)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27791 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1(inst_27790) : fluree.db.util.log.debug.call(null,inst_27790));
var state_27793__$1 = (function (){var statearr_27795 = state_27793;
(statearr_27795[(7)] = inst_27787);

(statearr_27795[(8)] = inst_27791);

return statearr_27795;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27793__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27796 = [null,null,null,null,null,null,null,null,null];
(statearr_27796[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27796[(1)] = (1));

return statearr_27796;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27793){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27793);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27797){var ex__2687__auto__ = e27797;
var statearr_27798_27801 = state_27793;
(statearr_27798_27801[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27793[(4)]))){
var statearr_27799_27802 = state_27793;
(statearr_27799_27802[(1)] = cljs.core.first((state_27793[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27803 = state_27793;
state_27793 = G__27803;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27793){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27800 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27800[(6)] = c__2706__auto__);

return statearr_27800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27805 = arguments.length;
switch (G__27805) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__27806){
var map__27807 = p__27806;
var map__27807__$1 = cljs.core.__destructure_map(map__27807);
var session = map__27807__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27807__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27807__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27807__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27807__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27807__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27807__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27807__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
fluree.db.session.remove_cache_BANG_(network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__27808_27811 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27808_27811.cljs$core$IFn$_invoke$arity$3 ? fexpr__27808_27811.cljs$core$IFn$_invoke$arity$3(network,ledger_id,id) : fexpr__27808_27811.call(null,network,ledger_id,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,ledger_id);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__27809_27812 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__27809_27812.cljs$core$IFn$_invoke$arity$0 ? fexpr__27809_27812.cljs$core$IFn$_invoke$arity$0() : fexpr__27809_27812.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27864){
var state_val_27865 = (state_27864[(1)]);
if((state_val_27865 === (7))){
var inst_27860 = (state_27864[(2)]);
var state_27864__$1 = state_27864;
var statearr_27866_27897 = state_27864__$1;
(statearr_27866_27897[(2)] = inst_27860);

(statearr_27866_27897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (1))){
var state_27864__$1 = state_27864;
var statearr_27867_27898 = state_27864__$1;
(statearr_27867_27898[(2)] = null);

(statearr_27867_27898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (4))){
var inst_27816 = (state_27864[(7)]);
var inst_27815 = (state_27864[(2)]);
var inst_27816__$1 = fluree.db.util.async.throw_err(inst_27815);
var inst_27817 = fluree.db.session.from_cache(network,ledger_id);
var inst_27818 = (inst_27816__$1 == null);
var state_27864__$1 = (function (){var statearr_27868 = state_27864;
(statearr_27868[(8)] = inst_27817);

(statearr_27868[(7)] = inst_27816__$1);

return statearr_27868;
})();
if(cljs.core.truth_(inst_27818)){
var statearr_27869_27899 = state_27864__$1;
(statearr_27869_27899[(1)] = (5));

} else {
var statearr_27870_27900 = state_27864__$1;
(statearr_27870_27900[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (15))){
var inst_27852 = (state_27864[(2)]);
var state_27864__$1 = (function (){var statearr_27871 = state_27864;
(statearr_27871[(9)] = inst_27852);

return statearr_27871;
})();
var statearr_27872_27901 = state_27864__$1;
(statearr_27872_27901[(2)] = null);

(statearr_27872_27901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (13))){
var inst_27856 = (state_27864[(2)]);
var state_27864__$1 = state_27864;
var statearr_27874_27902 = state_27864__$1;
(statearr_27874_27902[(2)] = inst_27856);

(statearr_27874_27902[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (6))){
var inst_27817 = (state_27864[(8)]);
var inst_27823 = (inst_27817 == null);
var state_27864__$1 = state_27864;
if(cljs.core.truth_(inst_27823)){
var statearr_27875_27903 = state_27864__$1;
(statearr_27875_27903[(1)] = (8));

} else {
var statearr_27876_27904 = state_27864__$1;
(statearr_27876_27904[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (17))){
var _ = (function (){var statearr_27877 = state_27864;
(statearr_27877[(4)] = cljs.core.rest((state_27864[(4)])));

return statearr_27877;
})();
var state_27864__$1 = state_27864;
var ex27873 = (state_27864__$1[(2)]);
var statearr_27878_27905 = state_27864__$1;
(statearr_27878_27905[(5)] = ex27873);


var statearr_27879_27906 = state_27864__$1;
(statearr_27879_27906[(1)] = (16));

(statearr_27879_27906[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (3))){
var inst_27862 = (state_27864[(2)]);
var state_27864__$1 = state_27864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27864__$1,inst_27862);
} else {
if((state_val_27865 === (12))){
var state_27864__$1 = state_27864;
var statearr_27880_27907 = state_27864__$1;
(statearr_27880_27907[(2)] = null);

(statearr_27880_27907[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (2))){
var state_27864__$1 = state_27864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27864__$1,(4),update_chan);
} else {
if((state_val_27865 === (11))){
var state_27864__$1 = state_27864;
var statearr_27881_27908 = state_27864__$1;
(statearr_27881_27908[(2)] = null);

(statearr_27881_27908[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (9))){
var state_27864__$1 = state_27864;
var statearr_27882_27909 = state_27864__$1;
(statearr_27882_27909[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (5))){
var inst_27820 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27821 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Channel closed for session updates for:",inst_27820) : fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_27820));
var state_27864__$1 = state_27864;
var statearr_27884_27910 = state_27864__$1;
(statearr_27884_27910[(2)] = inst_27821);

(statearr_27884_27910[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (14))){
var inst_27817 = (state_27864[(8)]);
var inst_27816 = (state_27864[(7)]);
var _ = (function (){var statearr_27885 = state_27864;
(statearr_27885[(4)] = cljs.core.cons((17),(state_27864[(4)])));

return statearr_27885;
})();
var inst_27840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27816,(0),null);
var inst_27841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27816,(1),null);
var inst_27842 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27843 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27816], 0));
var inst_27844 = fluree.db.util.core.trunc(inst_27843,(200));
var inst_27845 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2(inst_27842,inst_27844) : fluree.db.util.log.trace.call(null,inst_27842,inst_27844));
var inst_27846 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_27817,inst_27840,inst_27841) : fluree.db.session.process_ledger_update.call(null,inst_27817,inst_27840,inst_27841));
var state_27864__$1 = (function (){var statearr_27886 = state_27864;
(statearr_27886[(10)] = inst_27845);

return statearr_27886;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27864__$1,(18),inst_27846);
} else {
if((state_val_27865 === (16))){
var inst_27816 = (state_27864[(7)]);
var inst_27830 = (state_27864[(2)]);
var inst_27831 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_27830,"Exception processing ledger updates for message: ",inst_27816) : fluree.db.util.log.error.call(null,inst_27830,"Exception processing ledger updates for message: ",inst_27816));
var state_27864__$1 = state_27864;
var statearr_27887_27911 = state_27864__$1;
(statearr_27887_27911[(2)] = inst_27831);

(statearr_27887_27911[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (10))){
var inst_27858 = (state_27864[(2)]);
var state_27864__$1 = state_27864;
var statearr_27888_27912 = state_27864__$1;
(statearr_27888_27912[(2)] = inst_27858);

(statearr_27888_27912[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (18))){
var inst_27848 = (state_27864[(2)]);
var inst_27849 = fluree.db.util.async.throw_err(inst_27848);
var _ = (function (){var statearr_27889 = state_27864;
(statearr_27889[(4)] = cljs.core.rest((state_27864[(4)])));

return statearr_27889;
})();
var state_27864__$1 = state_27864;
var statearr_27890_27913 = state_27864__$1;
(statearr_27890_27913[(2)] = inst_27849);

(statearr_27890_27913[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27865 === (8))){
var inst_27816 = (state_27864[(7)]);
var inst_27825 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27826 = cljs.core.first(inst_27816);
var inst_27827 = (fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4("Ledger update received for session that is no longer open:",inst_27825,"Message: ",inst_27826) : fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_27825,"Message: ",inst_27826));
var state_27864__$1 = state_27864;
var statearr_27891_27914 = state_27864__$1;
(statearr_27891_27914[(2)] = inst_27827);

(statearr_27891_27914[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0 = (function (){
var statearr_27892 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27892[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__);

(statearr_27892[(1)] = (1));

return statearr_27892;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1 = (function (state_27864){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27864);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27893){var ex__2687__auto__ = e27893;
var statearr_27894_27915 = state_27864;
(statearr_27894_27915[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27864[(4)]))){
var statearr_27895_27916 = state_27864;
(statearr_27895_27916[(1)] = cljs.core.first((state_27864[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27917 = state_27864;
state_27864 = G__27917;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__ = function(state_27864){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1.call(this,state_27864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27896 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27896[(6)] = c__2706__auto__);

return statearr_27896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27918){
var map__27919 = p__27918;
var map__27919__$1 = cljs.core.__destructure_map(map__27919);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27919__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27919__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27919__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27919__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27919__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27919__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27919__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27919__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27919__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null),network,null,conn]));
var current_db_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db(conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27923 = block_result;
var map__27923__$1 = cljs.core.__destructure_map(map__27923);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27923__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27923__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27923__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27923__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27923__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__27924 = tx_result;
var map__27924__$1 = cljs.core.__destructure_map(map__27924);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27924__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27924__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__27920_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,fluree.db.flake.t(p1__27920_SHARP_));
}):(function (p1__27921_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27921_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__27922_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__27922_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27922_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27925 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27925,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27925,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27925,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27925,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var G__27928_27930 = "Create and cache session. Opt keys: ";
var G__27929_27931 = cljs.core.keys(opts);
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2(G__27928_27930,G__27929_27931) : fluree.db.util.log.trace.call(null,G__27928_27930,G__27929_27931));

var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27933 = arguments.length;
switch (G__27933) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27934){
var map__27935 = p__27934;
var map__27935__$1 = cljs.core.__destructure_map(map__27935);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27935__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27935__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27935__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27935__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27936 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27936,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27936,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27936,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__27940_28092 = network;
var G__27941_28093 = ledger_id;
var G__27942_28094 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__27943_28095 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27944 = cljs.core.seq(tids);
var chunk__27945 = null;
var count__27946 = (0);
var i__27947 = (0);
while(true){
if((i__27947 < count__27946)){
var tid = chunk__27945.cljs$core$IIndexed$_nth$arity$2(null,i__27947);
var temp__5804__auto___28097__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___28097__$1)){
var keyed_callbacks_28098 = temp__5804__auto___28097__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28099 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28004_28100 = cljs.core.seq(keyed_callbacks_28098);
var chunk__28005_28101 = null;
var count__28006_28102 = (0);
var i__28007_28103 = (0);
while(true){
if((i__28007_28103 < count__28006_28102)){
var vec__28020_28104 = chunk__28005_28101.cljs$core$IIndexed$_nth$arity$2(null,i__28007_28103);
var k_28105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28020_28104,(0),null);
var f_28106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28020_28104,(1),null);
try{(f_28106.cljs$core$IFn$_invoke$arity$1 ? f_28106.cljs$core$IFn$_invoke$arity$1(tx_response_28099) : f_28106.call(null,tx_response_28099));
}catch (e28023){var e_28107 = e28023;
var G__28024_28108 = e_28107;
var G__28025_28109 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__28024_28108,G__28025_28109) : fluree.db.util.log.error.call(null,G__28024_28108,G__28025_28109));
}

var G__28110 = seq__28004_28100;
var G__28111 = chunk__28005_28101;
var G__28112 = count__28006_28102;
var G__28113 = (i__28007_28103 + (1));
seq__28004_28100 = G__28110;
chunk__28005_28101 = G__28111;
count__28006_28102 = G__28112;
i__28007_28103 = G__28113;
continue;
} else {
var temp__5804__auto___28114__$2 = cljs.core.seq(seq__28004_28100);
if(temp__5804__auto___28114__$2){
var seq__28004_28115__$1 = temp__5804__auto___28114__$2;
if(cljs.core.chunked_seq_QMARK_(seq__28004_28115__$1)){
var c__5568__auto___28116 = cljs.core.chunk_first(seq__28004_28115__$1);
var G__28117 = cljs.core.chunk_rest(seq__28004_28115__$1);
var G__28118 = c__5568__auto___28116;
var G__28119 = cljs.core.count(c__5568__auto___28116);
var G__28120 = (0);
seq__28004_28100 = G__28117;
chunk__28005_28101 = G__28118;
count__28006_28102 = G__28119;
i__28007_28103 = G__28120;
continue;
} else {
var vec__28026_28121 = cljs.core.first(seq__28004_28115__$1);
var k_28122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28026_28121,(0),null);
var f_28123 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28026_28121,(1),null);
try{(f_28123.cljs$core$IFn$_invoke$arity$1 ? f_28123.cljs$core$IFn$_invoke$arity$1(tx_response_28099) : f_28123.call(null,tx_response_28099));
}catch (e28029){var e_28124 = e28029;
var G__28030_28125 = e_28124;
var G__28031_28126 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__28030_28125,G__28031_28126) : fluree.db.util.log.error.call(null,G__28030_28125,G__28031_28126));
}

var G__28127 = cljs.core.next(seq__28004_28115__$1);
var G__28128 = null;
var G__28129 = (0);
var G__28130 = (0);
seq__28004_28100 = G__28127;
chunk__28005_28101 = G__28128;
count__28006_28102 = G__28129;
i__28007_28103 = G__28130;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28131 = seq__27944;
var G__28132 = chunk__27945;
var G__28133 = count__27946;
var G__28134 = (i__27947 + (1));
seq__27944 = G__28131;
chunk__27945 = G__28132;
count__27946 = G__28133;
i__27947 = G__28134;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq(seq__27944);
if(temp__5804__auto____$1){
var seq__27944__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__27944__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__27944__$1);
var G__28135 = cljs.core.chunk_rest(seq__27944__$1);
var G__28136 = c__5568__auto__;
var G__28137 = cljs.core.count(c__5568__auto__);
var G__28138 = (0);
seq__27944 = G__28135;
chunk__27945 = G__28136;
count__27946 = G__28137;
i__27947 = G__28138;
continue;
} else {
var tid = cljs.core.first(seq__27944__$1);
var temp__5804__auto___28139__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___28139__$2)){
var keyed_callbacks_28140 = temp__5804__auto___28139__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28141 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28032_28142 = cljs.core.seq(keyed_callbacks_28140);
var chunk__28033_28143 = null;
var count__28034_28144 = (0);
var i__28035_28145 = (0);
while(true){
if((i__28035_28145 < count__28034_28144)){
var vec__28048_28146 = chunk__28033_28143.cljs$core$IIndexed$_nth$arity$2(null,i__28035_28145);
var k_28147 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28048_28146,(0),null);
var f_28148 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28048_28146,(1),null);
try{(f_28148.cljs$core$IFn$_invoke$arity$1 ? f_28148.cljs$core$IFn$_invoke$arity$1(tx_response_28141) : f_28148.call(null,tx_response_28141));
}catch (e28051){var e_28149 = e28051;
var G__28052_28150 = e_28149;
var G__28053_28151 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__28052_28150,G__28053_28151) : fluree.db.util.log.error.call(null,G__28052_28150,G__28053_28151));
}

var G__28152 = seq__28032_28142;
var G__28153 = chunk__28033_28143;
var G__28154 = count__28034_28144;
var G__28155 = (i__28035_28145 + (1));
seq__28032_28142 = G__28152;
chunk__28033_28143 = G__28153;
count__28034_28144 = G__28154;
i__28035_28145 = G__28155;
continue;
} else {
var temp__5804__auto___28156__$3 = cljs.core.seq(seq__28032_28142);
if(temp__5804__auto___28156__$3){
var seq__28032_28157__$1 = temp__5804__auto___28156__$3;
if(cljs.core.chunked_seq_QMARK_(seq__28032_28157__$1)){
var c__5568__auto___28158 = cljs.core.chunk_first(seq__28032_28157__$1);
var G__28159 = cljs.core.chunk_rest(seq__28032_28157__$1);
var G__28160 = c__5568__auto___28158;
var G__28161 = cljs.core.count(c__5568__auto___28158);
var G__28162 = (0);
seq__28032_28142 = G__28159;
chunk__28033_28143 = G__28160;
count__28034_28144 = G__28161;
i__28035_28145 = G__28162;
continue;
} else {
var vec__28054_28163 = cljs.core.first(seq__28032_28157__$1);
var k_28164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28054_28163,(0),null);
var f_28165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28054_28163,(1),null);
try{(f_28165.cljs$core$IFn$_invoke$arity$1 ? f_28165.cljs$core$IFn$_invoke$arity$1(tx_response_28141) : f_28165.call(null,tx_response_28141));
}catch (e28057){var e_28166 = e28057;
var G__28058_28167 = e_28166;
var G__28059_28168 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__28058_28167,G__28059_28168) : fluree.db.util.log.error.call(null,G__28058_28167,G__28059_28168));
}

var G__28169 = cljs.core.next(seq__28032_28157__$1);
var G__28170 = null;
var G__28171 = (0);
var G__28172 = (0);
seq__28032_28142 = G__28169;
chunk__28033_28143 = G__28170;
count__28034_28144 = G__28171;
i__28035_28145 = G__28172;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28173 = cljs.core.next(seq__27944__$1);
var G__28174 = null;
var G__28175 = (0);
var G__28176 = (0);
seq__27944 = G__28173;
chunk__27945 = G__28174;
count__27946 = G__28175;
i__27947 = G__28176;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__27939_28096 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27939_28096.cljs$core$IFn$_invoke$arity$4 ? fexpr__27939_28096.cljs$core$IFn$_invoke$arity$4(G__27940_28092,G__27941_28093,G__27942_28094,G__27943_28095) : fexpr__27939_28096.call(null,G__27940_28092,G__27941_28093,G__27942_28094,G__27943_28095));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28177 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2706__auto___28178 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28076){
var state_val_28077 = (state_28076[(1)]);
if((state_val_28077 === (1))){
var state_28076__$1 = state_28076;
var statearr_28078_28179 = state_28076__$1;
(statearr_28078_28179[(2)] = null);

(statearr_28078_28179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28077 === (2))){
var inst_28061 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28076__$1 = state_28076;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28076__$1,(4),inst_28061);
} else {
if((state_val_28077 === (3))){
var inst_28074 = (state_28076[(2)]);
var state_28076__$1 = state_28076;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28076__$1,inst_28074);
} else {
if((state_val_28077 === (4))){
var inst_28063 = (state_28076[(7)]);
var inst_28063__$1 = (state_28076[(2)]);
var inst_28064 = (inst_28063__$1 == null);
var state_28076__$1 = (function (){var statearr_28079 = state_28076;
(statearr_28079[(7)] = inst_28063__$1);

return statearr_28079;
})();
if(cljs.core.truth_(inst_28064)){
var statearr_28080_28180 = state_28076__$1;
(statearr_28080_28180[(1)] = (5));

} else {
var statearr_28081_28181 = state_28076__$1;
(statearr_28081_28181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28077 === (5))){
var inst_28066 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28067 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Transactor session closing for db:",inst_28066) : fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_28066));
var state_28076__$1 = state_28076;
var statearr_28082_28182 = state_28076__$1;
(statearr_28082_28182[(2)] = inst_28067);

(statearr_28082_28182[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28077 === (6))){
var inst_28063 = (state_28076[(7)]);
var inst_28069 = (transact_handler_28177.cljs$core$IFn$_invoke$arity$2 ? transact_handler_28177.cljs$core$IFn$_invoke$arity$2(conn,inst_28063) : transact_handler_28177.call(null,conn,inst_28063));
var state_28076__$1 = (function (){var statearr_28083 = state_28076;
(statearr_28083[(8)] = inst_28069);

return statearr_28083;
})();
var statearr_28084_28183 = state_28076__$1;
(statearr_28084_28183[(2)] = null);

(statearr_28084_28183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28077 === (7))){
var inst_28072 = (state_28076[(2)]);
var state_28076__$1 = state_28076;
var statearr_28085_28184 = state_28076__$1;
(statearr_28085_28184[(2)] = inst_28072);

(statearr_28085_28184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_28086 = [null,null,null,null,null,null,null,null,null];
(statearr_28086[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_28086[(1)] = (1));

return statearr_28086;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_28076){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28076);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28087){var ex__2687__auto__ = e28087;
var statearr_28088_28185 = state_28076;
(statearr_28088_28185[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28076[(4)]))){
var statearr_28089_28186 = state_28076;
(statearr_28089_28186[(1)] = cljs.core.first((state_28076[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28187 = state_28076;
state_28076 = G__28187;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_28076){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_28076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28090 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28090[(6)] = c__2706__auto___28178);

return statearr_28090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28190 = arguments.length;
switch (G__28190) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28191 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28188_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__28188_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28191);
} else {
return G__28191;
}
})();
var seq__28192 = cljs.core.seq(sessions);
var chunk__28193 = null;
var count__28194 = (0);
var i__28195 = (0);
while(true){
if((i__28195 < count__28194)){
var session = chunk__28193.cljs$core$IIndexed$_nth$arity$2(null,i__28195);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28197 = seq__28192;
var G__28198 = chunk__28193;
var G__28199 = count__28194;
var G__28200 = (i__28195 + (1));
seq__28192 = G__28197;
chunk__28193 = G__28198;
count__28194 = G__28199;
i__28195 = G__28200;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__28192);
if(temp__5804__auto__){
var seq__28192__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28192__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__28192__$1);
var G__28201 = cljs.core.chunk_rest(seq__28192__$1);
var G__28202 = c__5568__auto__;
var G__28203 = cljs.core.count(c__5568__auto__);
var G__28204 = (0);
seq__28192 = G__28201;
chunk__28193 = G__28202;
count__28194 = G__28203;
i__28195 = G__28204;
continue;
} else {
var session = cljs.core.first(seq__28192__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28205 = cljs.core.next(seq__28192__$1);
var G__28206 = null;
var G__28207 = (0);
var G__28208 = (0);
seq__28192 = G__28205;
chunk__28193 = G__28206;
count__28194 = G__28207;
i__28195 = G__28208;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
