// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
var G__19743_19746 = "XHTTP Request Error:";
var G__19744_19747 = e.request;
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__19743_19746,G__19744_19747) : fluree.db.util.log.error.call(null,G__19743_19746,G__19744_19747));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__19745 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19745,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__19745;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__19748 = opts;
var map__19748__$1 = cljs.core.__destructure_map(map__19748);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19748__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19748__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19748__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19749 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__19749__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19749,headers], 0)):G__19749);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19749__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19749__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json, :edn or :binary (default :text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__19750 = opts;
var map__19750__$1 = cljs.core.__destructure_map(map__19750);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19750__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19750__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19750__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19750__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19750__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19751 = cljs.core.PersistentArrayMap.EMPTY;
var G__19751__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19751,headers], 0)):G__19751);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19751__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19751__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__19752 = output_format;
var G__19752__$1 = (((G__19752 instanceof cljs.core.Keyword))?G__19752.fqn:null);
switch (G__19752__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__19754 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19754,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__19754;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19786){
var state_val_19787 = (state_19786[(1)]);
if((state_val_19787 === (7))){
var inst_19782 = (state_19786[(2)]);
var state_19786__$1 = state_19786;
var statearr_19788_19813 = state_19786__$1;
(statearr_19788_19813[(2)] = inst_19782);

(statearr_19788_19813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (1))){
var state_19786__$1 = state_19786;
var statearr_19789_19814 = state_19786__$1;
(statearr_19789_19814[(2)] = null);

(statearr_19789_19814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (4))){
var inst_19757 = (state_19786[(7)]);
var inst_19757__$1 = (state_19786[(2)]);
var inst_19758 = (inst_19757__$1 == null);
var state_19786__$1 = (function (){var statearr_19790 = state_19786;
(statearr_19790[(7)] = inst_19757__$1);

return statearr_19790;
})();
if(cljs.core.truth_(inst_19758)){
var statearr_19791_19815 = state_19786__$1;
(statearr_19791_19815[(1)] = (5));

} else {
var statearr_19792_19816 = state_19786__$1;
(statearr_19792_19816[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (6))){
var inst_19757 = (state_19786[(7)]);
var inst_19765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19757,(0),null);
var inst_19766 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19757,(1),null);
var state_19786__$1 = (function (){var statearr_19793 = state_19786;
(statearr_19793[(8)] = inst_19766);

(statearr_19793[(9)] = inst_19765);

return statearr_19793;
})();
var statearr_19794_19817 = state_19786__$1;
(statearr_19794_19817[(2)] = null);

(statearr_19794_19817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (3))){
var inst_19784 = (state_19786[(2)]);
var state_19786__$1 = state_19786;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19786__$1,inst_19784);
} else {
if((state_val_19787 === (2))){
var state_19786__$1 = state_19786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19786__$1,(4),pub_chan);
} else {
if((state_val_19787 === (11))){
var _ = (function (){var statearr_19796 = state_19786;
(statearr_19796[(4)] = cljs.core.rest((state_19786[(4)])));

return statearr_19796;
})();
var state_19786__$1 = state_19786;
var ex19795 = (state_19786__$1[(2)]);
var statearr_19797_19818 = state_19786__$1;
(statearr_19797_19818[(5)] = ex19795);


var statearr_19798_19819 = state_19786__$1;
(statearr_19798_19819[(1)] = (10));

(statearr_19798_19819[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (9))){
var inst_19779 = (state_19786[(2)]);
var state_19786__$1 = (function (){var statearr_19799 = state_19786;
(statearr_19799[(10)] = inst_19779);

return statearr_19799;
})();
var statearr_19800_19820 = state_19786__$1;
(statearr_19800_19820[(2)] = null);

(statearr_19800_19820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (5))){
var inst_19760 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1("Web socket pub/producer channel closed.") : fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed."));
var state_19786__$1 = state_19786;
var statearr_19801_19821 = state_19786__$1;
(statearr_19801_19821[(2)] = inst_19760);

(statearr_19801_19821[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (10))){
var inst_19766 = (state_19786[(8)]);
var inst_19765 = (state_19786[(9)]);
var inst_19767 = (state_19786[(2)]);
var inst_19768 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_19767,"Error sending websocket message:",inst_19765) : fluree.db.util.log.error.call(null,inst_19767,"Error sending websocket message:",inst_19765));
var inst_19769 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19766,false);
var state_19786__$1 = (function (){var statearr_19802 = state_19786;
(statearr_19802[(11)] = inst_19768);

return statearr_19802;
})();
var statearr_19803_19822 = state_19786__$1;
(statearr_19803_19822[(2)] = inst_19769);

(statearr_19803_19822[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19787 === (8))){
var inst_19766 = (state_19786[(8)]);
var inst_19765 = (state_19786[(9)]);
var _ = (function (){var statearr_19804 = state_19786;
(statearr_19804[(4)] = cljs.core.cons((11),(state_19786[(4)])));

return statearr_19804;
})();
var inst_19775 = ws.send(inst_19765);
var inst_19776 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19766,true);
var ___$1 = (function (){var statearr_19805 = state_19786;
(statearr_19805[(4)] = cljs.core.rest((state_19786[(4)])));

return statearr_19805;
})();
var state_19786__$1 = (function (){var statearr_19806 = state_19786;
(statearr_19806[(12)] = inst_19775);

return statearr_19806;
})();
var statearr_19807_19823 = state_19786__$1;
(statearr_19807_19823[(2)] = inst_19776);

(statearr_19807_19823[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0 = (function (){
var statearr_19808 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19808[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__);

(statearr_19808[(1)] = (1));

return statearr_19808;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1 = (function (state_19786){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19786);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19809){var ex__2687__auto__ = e19809;
var statearr_19810_19824 = state_19786;
(statearr_19810_19824[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19786[(4)]))){
var statearr_19811_19825 = state_19786;
(statearr_19811_19825[(1)] = cljs.core.first((state_19786[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19826 = state_19786;
state_19786 = G__19826;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__ = function(state_19786){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1.call(this,state_19786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19812 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19812[(6)] = c__2706__auto__);

return statearr_19812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
var G__19827_19868 = "Websocket closed: ";
var G__19828_19869 = e.reason;
var G__19829_19870 = "Code: ";
var G__19830_19871 = e.code;
(fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4(G__19827_19868,G__19828_19869,G__19829_19870,G__19830_19871) : fluree.db.util.log.warn.call(null,G__19827_19868,G__19828_19869,G__19829_19870,G__19830_19871));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2706__auto___19872 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19855){
var state_val_19856 = (state_19855[(1)]);
if((state_val_19856 === (1))){
var inst_19834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19835 = [open_QMARK_,timeout_chan];
var inst_19836 = (new cljs.core.PersistentVector(null,2,(5),inst_19834,inst_19835,null));
var state_19855__$1 = state_19855;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_19855__$1,(2),inst_19836,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_19856 === (2))){
var inst_19838 = (state_19855[(2)]);
var inst_19839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19838,(0),null);
var inst_19840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19838,(1),null);
var inst_19841 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19840,timeout_chan);
var state_19855__$1 = (function (){var statearr_19857 = state_19855;
(statearr_19857[(7)] = inst_19839);

return statearr_19857;
})();
if(inst_19841){
var statearr_19858_19873 = state_19855__$1;
(statearr_19858_19873[(1)] = (3));

} else {
var statearr_19859_19874 = state_19855__$1;
(statearr_19859_19874[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19856 === (3))){
var inst_19843 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_19844 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19845 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_19846 = cljs.core.PersistentHashMap.fromArrays(inst_19844,inst_19845);
var inst_19847 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19843,inst_19846);
var inst_19848 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_19847);
var inst_19849 = fluree.db.util.xhttp.close_websocket(ws);
var state_19855__$1 = (function (){var statearr_19860 = state_19855;
(statearr_19860[(8)] = inst_19848);

return statearr_19860;
})();
var statearr_19861_19875 = state_19855__$1;
(statearr_19861_19875[(2)] = inst_19849);

(statearr_19861_19875[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19856 === (4))){
var inst_19851 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_19855__$1 = state_19855;
var statearr_19862_19876 = state_19855__$1;
(statearr_19862_19876[(2)] = inst_19851);

(statearr_19862_19876[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19856 === (5))){
var inst_19853 = (state_19855[(2)]);
var state_19855__$1 = state_19855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19855__$1,inst_19853);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_19863 = [null,null,null,null,null,null,null,null,null];
(statearr_19863[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__);

(statearr_19863[(1)] = (1));

return statearr_19863;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1 = (function (state_19855){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19855);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19864){var ex__2687__auto__ = e19864;
var statearr_19865_19877 = state_19855;
(statearr_19865_19877[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19855[(4)]))){
var statearr_19866_19878 = state_19855;
(statearr_19866_19878[(1)] = cljs.core.first((state_19855[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19879 = state_19855;
state_19855 = G__19879;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__ = function(state_19855){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1.call(this,state_19855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19867 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19867[(6)] = c__2706__auto___19872);

return statearr_19867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
