// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.connection_js');
goog.require('goog.object');
goog.scope(function(){
flureeworker.goog$module$goog$object = goog.module.get('goog.object');
});
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__70635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70635__$1 = cljs.core.__destructure_map(map__70635);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70635__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70635__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = flureeworker.goog$module$goog$object.get.call(null,obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__70636 = cljs.core.get_global_hierarchy;
return (fexpr__70636.cljs$core$IFn$_invoke$arity$0 ? fexpr__70636.cljs$core$IFn$_invoke$arity$0() : fexpr__70636.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__70637__delegate = function (conn_id,event,_){
return event;
};
var G__70637 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__70638__i = 0, G__70638__a = new Array(arguments.length -  2);
while (G__70638__i < G__70638__a.length) {G__70638__a[G__70638__i] = arguments[G__70638__i + 2]; ++G__70638__i;}
  _ = new cljs.core.IndexedSeq(G__70638__a,0,null);
} 
return G__70637__delegate.call(this,conn_id,event,_);};
G__70637.cljs$lang$maxFixedArity = 2;
G__70637.cljs$lang$applyTo = (function (arglist__70639){
var conn_id = cljs.core.first(arglist__70639);
arglist__70639 = cljs.core.next(arglist__70639);
var event = cljs.core.first(arglist__70639);
var _ = cljs.core.rest(arglist__70639);
return G__70637__delegate(conn_id,event,_);
});
G__70637.cljs$core$IFn$_invoke$arity$variadic = G__70637__delegate;
return G__70637;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__5045__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70657){
var state_val_70658 = (state_70657[(1)]);
if((state_val_70658 === (1))){
var inst_70640 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_70641 = flureeworker.conn_id__GT_db(conn_id,inst_70640);
var inst_70642 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_70643 = fluree.db.api.query.query(inst_70641,inst_70642);
var state_70657__$1 = state_70657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70657__$1,(2),inst_70643);
} else {
if((state_val_70658 === (2))){
var inst_70645 = (state_70657[(7)]);
var inst_70645__$1 = (state_70657[(2)]);
var inst_70646 = fluree.db.util.core.exception_QMARK_(inst_70645__$1);
var state_70657__$1 = (function (){var statearr_70659 = state_70657;
(statearr_70659[(7)] = inst_70645__$1);

return statearr_70659;
})();
if(inst_70646){
var statearr_70660_70673 = state_70657__$1;
(statearr_70660_70673[(1)] = (3));

} else {
var statearr_70661_70674 = state_70657__$1;
(statearr_70661_70674[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70658 === (3))){
var inst_70645 = (state_70657[(7)]);
var inst_70648 = flureeworker.error_return_map(inst_70645);
var state_70657__$1 = state_70657;
var statearr_70662_70675 = state_70657__$1;
(statearr_70662_70675[(2)] = inst_70648);

(statearr_70662_70675[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70658 === (4))){
var inst_70645 = (state_70657[(7)]);
var inst_70650 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_70651 = [inst_70645,"loaded"];
var inst_70652 = cljs.core.PersistentHashMap.fromArrays(inst_70650,inst_70651);
var state_70657__$1 = state_70657;
var statearr_70663_70676 = state_70657__$1;
(statearr_70663_70676[(2)] = inst_70652);

(statearr_70663_70676[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70658 === (5))){
var inst_70654 = (state_70657[(2)]);
var inst_70655 = (function (){var G__70664 = conn_id;
var G__70665 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__70666 = id;
var G__70667 = inst_70654;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70664,G__70665,G__70666,G__70667) : flureeworker.worker_action.call(null,G__70664,G__70665,G__70666,G__70667));
})();
var state_70657__$1 = state_70657;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70657__$1,inst_70655);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2684__auto__ = null;
var flureeworker$process_query_$_state_machine__2684__auto____0 = (function (){
var statearr_70668 = [null,null,null,null,null,null,null,null];
(statearr_70668[(0)] = flureeworker$process_query_$_state_machine__2684__auto__);

(statearr_70668[(1)] = (1));

return statearr_70668;
});
var flureeworker$process_query_$_state_machine__2684__auto____1 = (function (state_70657){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70657);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70669){var ex__2687__auto__ = e70669;
var statearr_70670_70677 = state_70657;
(statearr_70670_70677[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70657[(4)]))){
var statearr_70671_70678 = state_70657;
(statearr_70671_70678[(1)] = cljs.core.first((state_70657[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70679 = state_70657;
state_70657 = G__70679;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2684__auto__ = function(state_70657){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2684__auto____1.call(this,state_70657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2684__auto____0;
flureeworker$process_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2684__auto____1;
return flureeworker$process_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70672 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70672[(6)] = c__2706__auto__);

return statearr_70672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__70680 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70680__$1 = cljs.core.__destructure_map(map__70680);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70680__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70680__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__70681 = cljs.core.seq(query_ids);
var chunk__70682 = null;
var count__70683 = (0);
var i__70684 = (0);
while(true){
if((i__70684 < count__70683)){
var id = chunk__70682.cljs$core$IIndexed$_nth$arity$2(null,i__70684);
flureeworker.process_query(conn_id,id,opts);


var G__70685 = seq__70681;
var G__70686 = chunk__70682;
var G__70687 = count__70683;
var G__70688 = (i__70684 + (1));
seq__70681 = G__70685;
chunk__70682 = G__70686;
count__70683 = G__70687;
i__70684 = G__70688;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__70681);
if(temp__5804__auto__){
var seq__70681__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__70681__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__70681__$1);
var G__70689 = cljs.core.chunk_rest(seq__70681__$1);
var G__70690 = c__5568__auto__;
var G__70691 = cljs.core.count(c__5568__auto__);
var G__70692 = (0);
seq__70681 = G__70689;
chunk__70682 = G__70690;
count__70683 = G__70691;
i__70684 = G__70692;
continue;
} else {
var id = cljs.core.first(seq__70681__$1);
flureeworker.process_query(conn_id,id,opts);


var G__70693 = cljs.core.next(seq__70681__$1);
var G__70694 = null;
var G__70695 = (0);
var G__70696 = (0);
seq__70681 = G__70693;
chunk__70682 = G__70694;
count__70683 = G__70695;
i__70684 = G__70696;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__70697 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70697,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70697,(1),null);
var cb = (function (header,data){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70705){
var state_val_70706 = (state_70705[(1)]);
if((state_val_70706 === (1))){
var inst_70700 = cljs.core.async.timeout((100));
var state_70705__$1 = state_70705;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70705__$1,(2),inst_70700);
} else {
if((state_val_70706 === (2))){
var inst_70702 = (state_70705[(2)]);
var inst_70703 = flureeworker.process_all_queries(conn_id);
var state_70705__$1 = (function (){var statearr_70707 = state_70705;
(statearr_70707[(7)] = inst_70702);

return statearr_70707;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_70705__$1,inst_70703);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2684__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2684__auto____0 = (function (){
var statearr_70708 = [null,null,null,null,null,null,null,null];
(statearr_70708[(0)] = flureeworker$ledger_listener_$_state_machine__2684__auto__);

(statearr_70708[(1)] = (1));

return statearr_70708;
});
var flureeworker$ledger_listener_$_state_machine__2684__auto____1 = (function (state_70705){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70705);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70709){var ex__2687__auto__ = e70709;
var statearr_70710_70713 = state_70705;
(statearr_70710_70713[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70705[(4)]))){
var statearr_70711_70714 = state_70705;
(statearr_70711_70714[(1)] = cljs.core.first((state_70705[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70715 = state_70705;
state_70705 = G__70715;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2684__auto__ = function(state_70705){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2684__auto____1.call(this,state_70705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2684__auto____0;
flureeworker$ledger_listener_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2684__auto____1;
return flureeworker$ledger_listener_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70712 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70712[(6)] = c__2706__auto__);

return statearr_70712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__70716 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70716,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70716,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__70719 = config;
var map__70719__$1 = cljs.core.__destructure_map(map__70719);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70719__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70719__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70719__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70719__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70719__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70719__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__5045__auto__ = queries;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70720 = conn_data;
var map__70720__$1 = cljs.core.__destructure_map(map__70720);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70720__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70720__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70720__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__70721 = config;
var map__70721__$1 = cljs.core.__destructure_map(map__70721);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70721__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70721__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70721__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70721__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70727){
var state_val_70728 = (state_70727[(1)]);
if((state_val_70728 === (1))){
var inst_70722 = cljs.core.async.timeout((100));
var state_70727__$1 = state_70727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70727__$1,(2),inst_70722);
} else {
if((state_val_70728 === (2))){
var inst_70724 = (state_70727[(2)]);
var inst_70725 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_70727__$1 = (function (){var statearr_70729 = state_70727;
(statearr_70729[(7)] = inst_70724);

return statearr_70729;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_70727__$1,inst_70725);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2684__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2684__auto____0 = (function (){
var statearr_70730 = [null,null,null,null,null,null,null,null];
(statearr_70730[(0)] = flureeworker$connect_STAR__$_state_machine__2684__auto__);

(statearr_70730[(1)] = (1));

return statearr_70730;
});
var flureeworker$connect_STAR__$_state_machine__2684__auto____1 = (function (state_70727){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70727);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70731){var ex__2687__auto__ = e70731;
var statearr_70732_70743 = state_70727;
(statearr_70732_70743[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70727[(4)]))){
var statearr_70733_70744 = state_70727;
(statearr_70733_70744[(1)] = cljs.core.first((state_70727[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70745 = state_70727;
state_70727 = G__70745;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2684__auto__ = function(state_70727){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2684__auto____1.call(this,state_70727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2684__auto____0;
flureeworker$connect_STAR__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2684__auto____1;
return flureeworker$connect_STAR__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70734 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70734[(6)] = c__2706__auto__);

return statearr_70734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__70735_70746 = conn_id;
var G__70736_70747 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__70737_70748 = ref;
var G__70738_70749 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70735_70746,G__70736_70747,G__70737_70748,G__70738_70749) : flureeworker.worker_action.call(null,G__70735_70746,G__70736_70747,G__70737_70748,G__70738_70749));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__70739 = conn_id;
var G__70740 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__70741 = ref;
var G__70742 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70739,G__70740,G__70741,G__70742) : flureeworker.worker_action.call(null,G__70739,G__70740,G__70741,G__70742));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__70751 = arguments.length;
switch (G__70751) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70752 = conn_data;
var map__70752__$1 = cljs.core.__destructure_map(map__70752);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70752__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70752__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70752__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70752__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__70759 = conn_id;
var G__70760 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__70761 = ref;
var G__70762 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70759,G__70760,G__70761,G__70762) : flureeworker.worker_action.call(null,G__70759,G__70760,G__70761,G__70762));
}catch (e70754){var e = e70754;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__70755 = conn_id;
var G__70756 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__70757 = ref;
var G__70758 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70755,G__70756,G__70757,G__70758) : flureeworker.worker_action.call(null,G__70755,G__70756,G__70757,G__70758));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e70763){var e = e70763;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__70764 = conn_id;
var G__70765 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__70766 = ref;
var G__70767 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70764,G__70765,G__70766,G__70767) : flureeworker.worker_action.call(null,G__70764,G__70765,G__70766,G__70767));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__70768 = config_STAR_;
var map__70768__$1 = cljs.core.__destructure_map(map__70768);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70768__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70768__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70768__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70768__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70774){
var state_val_70775 = (state_70774[(1)]);
if((state_val_70775 === (1))){
var inst_70769 = cljs.core.async.timeout((100));
var state_70774__$1 = state_70774;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70774__$1,(2),inst_70769);
} else {
if((state_val_70775 === (2))){
var inst_70771 = (state_70774[(2)]);
var inst_70772 = flureeworker.connect_STAR_(id,ref);
var state_70774__$1 = (function (){var statearr_70776 = state_70774;
(statearr_70776[(7)] = inst_70771);

return statearr_70776;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_70774__$1,inst_70772);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2684__auto__ = null;
var flureeworker$connect_p_$_state_machine__2684__auto____0 = (function (){
var statearr_70777 = [null,null,null,null,null,null,null,null];
(statearr_70777[(0)] = flureeworker$connect_p_$_state_machine__2684__auto__);

(statearr_70777[(1)] = (1));

return statearr_70777;
});
var flureeworker$connect_p_$_state_machine__2684__auto____1 = (function (state_70774){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70774);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70778){var ex__2687__auto__ = e70778;
var statearr_70779_70790 = state_70774;
(statearr_70779_70790[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70774[(4)]))){
var statearr_70780_70791 = state_70774;
(statearr_70780_70791[(1)] = cljs.core.first((state_70774[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70792 = state_70774;
state_70774 = G__70792;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2684__auto__ = function(state_70774){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2684__auto____1.call(this,state_70774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2684__auto____0;
flureeworker$connect_p_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2684__auto____1;
return flureeworker$connect_p_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70781 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70781[(6)] = c__2706__auto__);

return statearr_70781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__70782 = id;
var G__70783 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__70784 = ref;
var G__70785 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70782,G__70783,G__70784,G__70785) : flureeworker.worker_action.call(null,G__70782,G__70783,G__70784,G__70785));
})).catch((function (error){
var G__70786 = id;
var G__70787 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__70788 = ref;
var G__70789 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70786,G__70787,G__70788,G__70789) : flureeworker.worker_action.call(null,G__70786,G__70787,G__70788,G__70789));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70860 = arguments.length;
var i__5770__auto___70861 = (0);
while(true){
if((i__5770__auto___70861 < len__5769__auto___70860)){
args__5775__auto__.push((arguments[i__5770__auto___70861]));

var G__70862 = (i__5770__auto___70861 + (1));
i__5770__auto___70861 = G__70862;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((4) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5776__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__70798){
var vec__70799 = p__70798;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70799,(0),null);
var map__70802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70802__$1 = cljs.core.__destructure_map(map__70802);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70802__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70802__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70802__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__70803 = conn_id;
var G__70804 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70805 = ref;
var G__70806 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70803,G__70804,G__70805,G__70806) : flureeworker.worker_action.call(null,G__70803,G__70804,G__70805,G__70806));
})());
var auth = null;
var c__2706__auto___70863 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70827){
var state_val_70828 = (state_70827[(1)]);
if((state_val_70828 === (1))){
var state_70827__$1 = state_70827;
var statearr_70829_70864 = state_70827__$1;
(statearr_70829_70864[(2)] = null);

(statearr_70829_70864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70828 === (2))){
var ___$1 = (function (){var statearr_70830 = state_70827;
(statearr_70830[(4)] = cljs.core.cons((5),(state_70827[(4)])));

return statearr_70830;
})();
var inst_70818 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_70819 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__70831 = conn_id;
var G__70832 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70833 = ref;
var G__70834 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70831,G__70832,G__70833,G__70834) : flureeworker.worker_action.call(null,G__70831,G__70832,G__70833,G__70834));
});
})();
var inst_70820 = inst_70818.then(inst_70819);
var inst_70821 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e70835){var ___$2 = e70835;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__70836 = conn_id;
var G__70837 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70838 = ref;
var G__70839 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70836,G__70837,G__70838,G__70839) : flureeworker.worker_action.call(null,G__70836,G__70837,G__70838,G__70839));
} else {
var G__70840 = conn_id;
var G__70841 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70842 = ref;
var G__70843 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70840,G__70841,G__70842,G__70843) : flureeworker.worker_action.call(null,G__70840,G__70841,G__70842,G__70843));

}
});
})();
var inst_70822 = inst_70820.catch(inst_70821);
var ___$2 = (function (){var statearr_70844 = state_70827;
(statearr_70844[(4)] = cljs.core.rest((state_70827[(4)])));

return statearr_70844;
})();
var state_70827__$1 = state_70827;
var statearr_70845_70865 = state_70827__$1;
(statearr_70845_70865[(2)] = inst_70822);

(statearr_70845_70865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70828 === (3))){
var inst_70825 = (state_70827[(2)]);
var state_70827__$1 = state_70827;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70827__$1,inst_70825);
} else {
if((state_val_70828 === (4))){
var inst_70807 = (state_70827[(2)]);
var inst_70808 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_70809 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70807);
var inst_70810 = [(400),inst_70809];
var inst_70811 = cljs.core.PersistentHashMap.fromArrays(inst_70808,inst_70810);
var inst_70812 = (function (){var G__70847 = conn_id;
var G__70848 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70849 = ref;
var G__70850 = inst_70811;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70847,G__70848,G__70849,G__70850) : flureeworker.worker_action.call(null,G__70847,G__70848,G__70849,G__70850));
})();
var state_70827__$1 = state_70827;
var statearr_70851_70866 = state_70827__$1;
(statearr_70851_70866[(2)] = inst_70812);

(statearr_70851_70866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70828 === (5))){
var ___$1 = (function (){var statearr_70852 = state_70827;
(statearr_70852[(4)] = cljs.core.rest((state_70827[(4)])));

return statearr_70852;
})();
var state_70827__$1 = state_70827;
var ex70846 = (state_70827__$1[(2)]);
var statearr_70853_70867 = state_70827__$1;
(statearr_70853_70867[(5)] = ex70846);


var statearr_70854_70868 = state_70827__$1;
(statearr_70854_70868[(1)] = (4));

(statearr_70854_70868[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2684__auto__ = null;
var flureeworker$state_machine__2684__auto____0 = (function (){
var statearr_70855 = [null,null,null,null,null,null,null];
(statearr_70855[(0)] = flureeworker$state_machine__2684__auto__);

(statearr_70855[(1)] = (1));

return statearr_70855;
});
var flureeworker$state_machine__2684__auto____1 = (function (state_70827){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70827);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70856){var ex__2687__auto__ = e70856;
var statearr_70857_70869 = state_70827;
(statearr_70857_70869[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70827[(4)]))){
var statearr_70858_70870 = state_70827;
(statearr_70858_70870[(1)] = cljs.core.first((state_70827[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70871 = state_70827;
state_70827 = G__70871;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$state_machine__2684__auto__ = function(state_70827){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$state_machine__2684__auto____1.call(this,state_70827);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2684__auto____0;
flureeworker$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2684__auto____1;
return flureeworker$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70859 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70859[(6)] = c__2706__auto___70863);

return statearr_70859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq70793){
var G__70794 = cljs.core.first(seq70793);
var seq70793__$1 = cljs.core.next(seq70793);
var G__70795 = cljs.core.first(seq70793__$1);
var seq70793__$2 = cljs.core.next(seq70793__$1);
var G__70796 = cljs.core.first(seq70793__$2);
var seq70793__$3 = cljs.core.next(seq70793__$2);
var G__70797 = cljs.core.first(seq70793__$3);
var seq70793__$4 = cljs.core.next(seq70793__$3);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70794,G__70795,G__70796,G__70797,seq70793__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__70872 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70872__$1 = cljs.core.__destructure_map(map__70872);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70872__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70872__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__70874 = conn_id;
var G__70875 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70876 = ref;
var G__70877 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70874,G__70875,G__70876,G__70877) : flureeworker.worker_action.call(null,G__70874,G__70875,G__70876,G__70877));
})());
var map__70873 = map_data;
var map__70873__$1 = cljs.core.__destructure_map(map__70873);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70873__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70873__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70873__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2706__auto___70931 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70898){
var state_val_70899 = (state_70898[(1)]);
if((state_val_70899 === (1))){
var state_70898__$1 = state_70898;
var statearr_70900_70932 = state_70898__$1;
(statearr_70900_70932[(2)] = null);

(statearr_70900_70932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (2))){
var ___$1 = (function (){var statearr_70901 = state_70898;
(statearr_70901[(4)] = cljs.core.cons((5),(state_70898[(4)])));

return statearr_70901;
})();
var inst_70889 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_70890 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__70902 = conn_id;
var G__70903 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__70904 = ref;
var G__70905 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70902,G__70903,G__70904,G__70905) : flureeworker.worker_action.call(null,G__70902,G__70903,G__70904,G__70905));
});
})();
var inst_70891 = inst_70889.then(inst_70890);
var inst_70892 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e70906){var ___$2 = e70906;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__70907 = conn_id;
var G__70908 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__70909 = ref;
var G__70910 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70907,G__70908,G__70909,G__70910) : flureeworker.worker_action.call(null,G__70907,G__70908,G__70909,G__70910));
} else {
var G__70911 = conn_id;
var G__70912 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__70913 = ref;
var G__70914 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70911,G__70912,G__70913,G__70914) : flureeworker.worker_action.call(null,G__70911,G__70912,G__70913,G__70914));

}
});
})();
var inst_70893 = inst_70891.catch(inst_70892);
var ___$2 = (function (){var statearr_70915 = state_70898;
(statearr_70915[(4)] = cljs.core.rest((state_70898[(4)])));

return statearr_70915;
})();
var state_70898__$1 = state_70898;
var statearr_70916_70933 = state_70898__$1;
(statearr_70916_70933[(2)] = inst_70893);

(statearr_70916_70933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (3))){
var inst_70896 = (state_70898[(2)]);
var state_70898__$1 = state_70898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70898__$1,inst_70896);
} else {
if((state_val_70899 === (4))){
var inst_70878 = (state_70898[(2)]);
var inst_70879 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_70880 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70878);
var inst_70881 = [(400),inst_70880];
var inst_70882 = cljs.core.PersistentHashMap.fromArrays(inst_70879,inst_70881);
var inst_70883 = (function (){var G__70918 = conn_id;
var G__70919 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__70920 = ref;
var G__70921 = inst_70882;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70918,G__70919,G__70920,G__70921) : flureeworker.worker_action.call(null,G__70918,G__70919,G__70920,G__70921));
})();
var state_70898__$1 = state_70898;
var statearr_70922_70934 = state_70898__$1;
(statearr_70922_70934[(2)] = inst_70883);

(statearr_70922_70934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (5))){
var ___$1 = (function (){var statearr_70923 = state_70898;
(statearr_70923[(4)] = cljs.core.rest((state_70898[(4)])));

return statearr_70923;
})();
var state_70898__$1 = state_70898;
var ex70917 = (state_70898__$1[(2)]);
var statearr_70924_70935 = state_70898__$1;
(statearr_70924_70935[(5)] = ex70917);


var statearr_70925_70936 = state_70898__$1;
(statearr_70925_70936[(1)] = (4));

(statearr_70925_70936[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2684__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2684__auto____0 = (function (){
var statearr_70926 = [null,null,null,null,null,null,null];
(statearr_70926[(0)] = flureeworker$pw_generate_$_state_machine__2684__auto__);

(statearr_70926[(1)] = (1));

return statearr_70926;
});
var flureeworker$pw_generate_$_state_machine__2684__auto____1 = (function (state_70898){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70898);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70927){var ex__2687__auto__ = e70927;
var statearr_70928_70937 = state_70898;
(statearr_70928_70937[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70898[(4)]))){
var statearr_70929_70938 = state_70898;
(statearr_70929_70938[(1)] = cljs.core.first((state_70898[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70939 = state_70898;
state_70898 = G__70939;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2684__auto__ = function(state_70898){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2684__auto____1.call(this,state_70898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2684__auto____0;
flureeworker$pw_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2684__auto____1;
return flureeworker$pw_generate_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70930 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70930[(6)] = c__2706__auto___70931);

return statearr_70930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__70940_SHARP_){
return (js_array[p1__70940_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e70941){var e = e70941;
var data = (event["data"]);
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5804__auto___70942 = cljs.core.not(self.document);
if(temp__5804__auto___70942){
var worker_QMARK__70943 = temp__5804__auto___70942;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__70944_70946 = null;
var G__70945_70947 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__70944_70946,G__70945_70947) : flureeworker.worker_action.call(null,G__70944_70946,G__70945_70947));
