// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__76915 = arguments.length;
switch (G__76915) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___76954 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_76936){
var state_val_76937 = (state_76936[(1)]);
if((state_val_76937 === (1))){
var state_76936__$1 = state_76936;
var statearr_76938_76955 = state_76936__$1;
(statearr_76938_76955[(2)] = null);

(statearr_76938_76955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76937 === (2))){
var _ = (function (){var statearr_76939 = state_76936;
(statearr_76939[(4)] = cljs.core.cons((5),(state_76936[(4)])));

return statearr_76939;
})();
var inst_76922 = fluree.db.session.db(conn,ledger,null);
var state_76936__$1 = state_76936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76936__$1,(7),inst_76922);
} else {
if((state_val_76937 === (3))){
var inst_76932 = (state_76936[(2)]);
var inst_76933 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_76932);
var inst_76934 = cljs.core.async.close_BANG_(pc);
var state_76936__$1 = (function (){var statearr_76941 = state_76936;
(statearr_76941[(7)] = inst_76933);

return statearr_76941;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_76936__$1,inst_76934);
} else {
if((state_val_76937 === (4))){
var inst_76916 = (state_76936[(2)]);
var state_76936__$1 = state_76936;
var statearr_76942_76956 = state_76936__$1;
(statearr_76942_76956[(2)] = inst_76916);

(statearr_76942_76956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76937 === (5))){
var _ = (function (){var statearr_76943 = state_76936;
(statearr_76943[(4)] = cljs.core.rest((state_76936[(4)])));

return statearr_76943;
})();
var state_76936__$1 = state_76936;
var ex76940 = (state_76936__$1[(2)]);
var statearr_76944_76957 = state_76936__$1;
(statearr_76944_76957[(5)] = ex76940);


var statearr_76945_76958 = state_76936__$1;
(statearr_76945_76958[(1)] = (4));

(statearr_76945_76958[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76937 === (6))){
var inst_76928 = (state_76936[(2)]);
var inst_76929 = fluree.db.util.async.throw_err(inst_76928);
var _ = (function (){var statearr_76946 = state_76936;
(statearr_76946[(4)] = cljs.core.rest((state_76936[(4)])));

return statearr_76946;
})();
var state_76936__$1 = state_76936;
var statearr_76947_76959 = state_76936__$1;
(statearr_76947_76959[(2)] = inst_76929);

(statearr_76947_76959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76937 === (7))){
var inst_76924 = (state_76936[(2)]);
var inst_76925 = fluree.db.util.async.throw_err(inst_76924);
var inst_76926 = fluree.db.time_travel.as_of_block(inst_76925,block);
var state_76936__$1 = state_76936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76936__$1,(6),inst_76926);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_76948 = [null,null,null,null,null,null,null,null];
(statearr_76948[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_76948[(1)] = (1));

return statearr_76948;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_76936){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_76936);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e76949){var ex__2687__auto__ = e76949;
var statearr_76950_76960 = state_76936;
(statearr_76950_76960[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_76936[(4)]))){
var statearr_76951_76961 = state_76936;
(statearr_76951_76961[(1)] = cljs.core.first((state_76936[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76962 = state_76936;
state_76936 = G__76962;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_76936){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_76936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_76952 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_76952[(6)] = c__2706__auto___76954);

return statearr_76952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77003){
var state_val_77004 = (state_77003[(1)]);
if((state_val_77004 === (7))){
var inst_76972 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_77003__$1 = state_77003;
if(inst_76972){
var statearr_77005_77036 = state_77003__$1;
(statearr_77005_77036[(1)] = (9));

} else {
var statearr_77006_77037 = state_77003__$1;
(statearr_77006_77037[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (1))){
var state_77003__$1 = state_77003;
var statearr_77007_77038 = state_77003__$1;
(statearr_77007_77038[(2)] = null);

(statearr_77007_77038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (4))){
var inst_76963 = (state_77003[(2)]);
var state_77003__$1 = state_77003;
var statearr_77008_77039 = state_77003__$1;
(statearr_77008_77039[(2)] = inst_76963);

(statearr_77008_77039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (15))){
var inst_76980 = (state_77003[(7)]);
var inst_76979 = (state_77003[(2)]);
var inst_76980__$1 = fluree.db.util.async.throw_err(inst_76979);
var state_77003__$1 = (function (){var statearr_77009 = state_77003;
(statearr_77009[(7)] = inst_76980__$1);

return statearr_77009;
})();
if(cljs.core.truth_(inst_76980__$1)){
var statearr_77010_77040 = state_77003__$1;
(statearr_77010_77040[(1)] = (16));

} else {
var statearr_77011_77041 = state_77003__$1;
(statearr_77011_77041[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (13))){
var state_77003__$1 = state_77003;
var statearr_77012_77042 = state_77003__$1;
(statearr_77012_77042[(2)] = null);

(statearr_77012_77042[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (6))){
var state_77003__$1 = state_77003;
var statearr_77013_77043 = state_77003__$1;
(statearr_77013_77043[(2)] = db);

(statearr_77013_77043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (17))){
var inst_76984 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_76985 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76986 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_76987 = cljs.core.PersistentHashMap.fromArrays(inst_76985,inst_76986);
var inst_76988 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76984,inst_76987);
var inst_76989 = (function(){throw inst_76988})();
var state_77003__$1 = state_77003;
var statearr_77014_77044 = state_77003__$1;
(statearr_77014_77044[(2)] = inst_76989);

(statearr_77014_77044[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (3))){
var inst_77001 = (state_77003[(2)]);
var state_77003__$1 = state_77003;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77003__$1,inst_77001);
} else {
if((state_val_77004 === (12))){
var inst_76977 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_77003__$1 = state_77003;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77003__$1,(15),inst_76977);
} else {
if((state_val_77004 === (2))){
var _ = (function (){var statearr_77015 = state_77003;
(statearr_77015[(4)] = cljs.core.cons((5),(state_77003[(4)])));

return statearr_77015;
})();
var inst_76969 = cljs.core.not(auth);
var state_77003__$1 = state_77003;
if(inst_76969){
var statearr_77016_77045 = state_77003__$1;
(statearr_77016_77045[(1)] = (6));

} else {
var statearr_77017_77046 = state_77003__$1;
(statearr_77017_77046[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (11))){
var inst_76996 = (state_77003[(2)]);
var state_77003__$1 = state_77003;
var statearr_77019_77047 = state_77003__$1;
(statearr_77019_77047[(2)] = inst_76996);

(statearr_77019_77047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (9))){
var inst_76974 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_77003__$1 = state_77003;
var statearr_77020_77048 = state_77003__$1;
(statearr_77020_77048[(2)] = inst_76974);

(statearr_77020_77048[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (5))){
var _ = (function (){var statearr_77021 = state_77003;
(statearr_77021[(4)] = cljs.core.rest((state_77003[(4)])));

return statearr_77021;
})();
var state_77003__$1 = state_77003;
var ex77018 = (state_77003__$1[(2)]);
var statearr_77022_77049 = state_77003__$1;
(statearr_77022_77049[(5)] = ex77018);


if((ex77018 instanceof Error)){
var statearr_77023_77050 = state_77003__$1;
(statearr_77023_77050[(1)] = (4));

(statearr_77023_77050[(5)] = null);

} else {
throw ex77018;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (14))){
var inst_76994 = (state_77003[(2)]);
var state_77003__$1 = state_77003;
var statearr_77024_77051 = state_77003__$1;
(statearr_77024_77051[(2)] = inst_76994);

(statearr_77024_77051[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (16))){
var inst_76980 = (state_77003[(7)]);
var inst_76982 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_76980);
var state_77003__$1 = state_77003;
var statearr_77025_77052 = state_77003__$1;
(statearr_77025_77052[(2)] = inst_76982);

(statearr_77025_77052[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (10))){
var state_77003__$1 = state_77003;
var statearr_77026_77053 = state_77003__$1;
(statearr_77026_77053[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (18))){
var inst_76991 = (state_77003[(2)]);
var state_77003__$1 = state_77003;
var statearr_77028_77054 = state_77003__$1;
(statearr_77028_77054[(2)] = inst_76991);

(statearr_77028_77054[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77004 === (8))){
var inst_76998 = (state_77003[(2)]);
var _ = (function (){var statearr_77029 = state_77003;
(statearr_77029[(4)] = cljs.core.rest((state_77003[(4)])));

return statearr_77029;
})();
var state_77003__$1 = state_77003;
var statearr_77030_77055 = state_77003__$1;
(statearr_77030_77055[(2)] = inst_76998);

(statearr_77030_77055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0 = (function (){
var statearr_77031 = [null,null,null,null,null,null,null,null];
(statearr_77031[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__);

(statearr_77031[(1)] = (1));

return statearr_77031;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1 = (function (state_77003){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_77003);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77032){var ex__2687__auto__ = e77032;
var statearr_77033_77056 = state_77003;
(statearr_77033_77056[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_77003[(4)]))){
var statearr_77034_77057 = state_77003;
(statearr_77034_77057[(1)] = cljs.core.first((state_77003[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77058 = state_77003;
state_77003 = G__77058;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = function(state_77003){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1.call(this,state_77003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77035 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_77035[(6)] = c__2706__auto__);

return statearr_77035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77130){
var state_val_77131 = (state_77130[(1)]);
if((state_val_77131 === (7))){
var inst_77068 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_77130__$1 = state_77130;
if(inst_77068){
var statearr_77132_77186 = state_77130__$1;
(statearr_77132_77186[(1)] = (9));

} else {
var statearr_77133_77187 = state_77130__$1;
(statearr_77133_77187[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (20))){
var inst_77092 = (state_77130[(7)]);
var state_77130__$1 = state_77130;
if(cljs.core.truth_(inst_77092)){
var statearr_77134_77188 = state_77130__$1;
(statearr_77134_77188[(1)] = (22));

} else {
var statearr_77135_77189 = state_77130__$1;
(statearr_77135_77189[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (27))){
var state_77130__$1 = state_77130;
var statearr_77136_77190 = state_77130__$1;
(statearr_77136_77190[(2)] = null);

(statearr_77136_77190[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (1))){
var state_77130__$1 = state_77130;
var statearr_77137_77191 = state_77130__$1;
(statearr_77137_77191[(2)] = null);

(statearr_77137_77191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (24))){
var inst_77106 = (state_77130[(2)]);
var state_77130__$1 = state_77130;
var statearr_77138_77192 = state_77130__$1;
(statearr_77138_77192[(2)] = inst_77106);

(statearr_77138_77192[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (4))){
var inst_77059 = (state_77130[(2)]);
var state_77130__$1 = state_77130;
var statearr_77139_77193 = state_77130__$1;
(statearr_77139_77193[(2)] = inst_77059);

(statearr_77139_77193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (15))){
var inst_77075 = (state_77130[(8)]);
var inst_77074 = (state_77130[(2)]);
var inst_77075__$1 = fluree.db.util.async.throw_err(inst_77074);
var state_77130__$1 = (function (){var statearr_77140 = state_77130;
(statearr_77140[(8)] = inst_77075__$1);

return statearr_77140;
})();
if(cljs.core.truth_(inst_77075__$1)){
var statearr_77141_77194 = state_77130__$1;
(statearr_77141_77194[(1)] = (16));

} else {
var statearr_77142_77195 = state_77130__$1;
(statearr_77142_77195[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (21))){
var inst_77108 = (state_77130[(9)]);
var inst_77108__$1 = (state_77130[(2)]);
var state_77130__$1 = (function (){var statearr_77143 = state_77130;
(statearr_77143[(9)] = inst_77108__$1);

return statearr_77143;
})();
if(cljs.core.truth_(inst_77108__$1)){
var statearr_77144_77196 = state_77130__$1;
(statearr_77144_77196[(1)] = (29));

} else {
var statearr_77145_77197 = state_77130__$1;
(statearr_77145_77197[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (31))){
var inst_77108 = (state_77130[(9)]);
var inst_77116 = (state_77130[(2)]);
var state_77130__$1 = (function (){var statearr_77146 = state_77130;
(statearr_77146[(10)] = inst_77116);

return statearr_77146;
})();
if(cljs.core.truth_(inst_77108)){
var statearr_77147_77198 = state_77130__$1;
(statearr_77147_77198[(1)] = (33));

} else {
var statearr_77148_77199 = state_77130__$1;
(statearr_77148_77199[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (32))){
var inst_77112 = (state_77130[(2)]);
var inst_77113 = fluree.db.util.async.throw_err(inst_77112);
var state_77130__$1 = state_77130;
var statearr_77149_77200 = state_77130__$1;
(statearr_77149_77200[(2)] = inst_77113);

(statearr_77149_77200[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (33))){
var inst_77108 = (state_77130[(9)]);
var inst_77118 = fluree.db.permissions.permission_map(db,inst_77108,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_77130__$1 = state_77130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77130__$1,(36),inst_77118);
} else {
if((state_val_77131 === (13))){
var state_77130__$1 = state_77130;
var statearr_77150_77201 = state_77130__$1;
(statearr_77150_77201[(2)] = null);

(statearr_77150_77201[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (22))){
var inst_77092 = (state_77130[(7)]);
var inst_77096 = fluree.db.auth.roles(db,inst_77092);
var state_77130__$1 = state_77130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77130__$1,(25),inst_77096);
} else {
if((state_val_77131 === (36))){
var inst_77120 = (state_77130[(2)]);
var inst_77121 = fluree.db.util.async.throw_err(inst_77120);
var state_77130__$1 = state_77130;
var statearr_77151_77202 = state_77130__$1;
(statearr_77151_77202[(2)] = inst_77121);

(statearr_77151_77202[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (29))){
var inst_77108 = (state_77130[(9)]);
var inst_77092 = (state_77130[(7)]);
var inst_77110 = fluree.db.dbfunctions.ctx.build(db,inst_77092,inst_77108);
var state_77130__$1 = state_77130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77130__$1,(32),inst_77110);
} else {
if((state_val_77131 === (6))){
var state_77130__$1 = state_77130;
var statearr_77152_77203 = state_77130__$1;
(statearr_77152_77203[(2)] = null);

(statearr_77152_77203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (28))){
var inst_77104 = (state_77130[(2)]);
var state_77130__$1 = state_77130;
var statearr_77153_77204 = state_77130__$1;
(statearr_77153_77204[(2)] = inst_77104);

(statearr_77153_77204[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (25))){
var inst_77098 = (state_77130[(2)]);
var inst_77099 = fluree.db.util.async.throw_err(inst_77098);
var state_77130__$1 = state_77130;
var statearr_77154_77205 = state_77130__$1;
(statearr_77154_77205[(2)] = inst_77099);

(statearr_77154_77205[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (34))){
var state_77130__$1 = state_77130;
var statearr_77155_77206 = state_77130__$1;
(statearr_77155_77206[(2)] = null);

(statearr_77155_77206[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (17))){
var inst_77078 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_77079 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77080 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_77081 = cljs.core.PersistentHashMap.fromArrays(inst_77079,inst_77080);
var inst_77082 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_77078,inst_77081);
var inst_77083 = (function(){throw inst_77082})();
var state_77130__$1 = state_77130;
var statearr_77156_77207 = state_77130__$1;
(statearr_77156_77207[(2)] = inst_77083);

(statearr_77156_77207[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (3))){
var inst_77128 = (state_77130[(2)]);
var state_77130__$1 = state_77130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77130__$1,inst_77128);
} else {
if((state_val_77131 === (12))){
var inst_77072 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_77130__$1 = state_77130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77130__$1,(15),inst_77072);
} else {
if((state_val_77131 === (2))){
var _ = (function (){var statearr_77157 = state_77130;
(statearr_77157[(4)] = cljs.core.cons((5),(state_77130[(4)])));

return statearr_77157;
})();
var inst_77065 = (auth == null);
var state_77130__$1 = state_77130;
if(cljs.core.truth_(inst_77065)){
var statearr_77158_77208 = state_77130__$1;
(statearr_77158_77208[(1)] = (6));

} else {
var statearr_77159_77209 = state_77130__$1;
(statearr_77159_77209[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (23))){
var state_77130__$1 = state_77130;
var statearr_77160_77210 = state_77130__$1;
(statearr_77160_77210[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (35))){
var inst_77108 = (state_77130[(9)]);
var inst_77092 = (state_77130[(7)]);
var inst_77116 = (state_77130[(10)]);
var inst_77124 = (state_77130[(2)]);
var inst_77125 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_77092,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"auth-id","auth-id",444160740),auth,new cljs.core.Keyword(null,"roles","roles",143379530),inst_77108,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_77124,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_77116], 0));
var _ = (function (){var statearr_77162 = state_77130;
(statearr_77162[(4)] = cljs.core.rest((state_77130[(4)])));

return statearr_77162;
})();
var state_77130__$1 = state_77130;
var statearr_77163_77211 = state_77130__$1;
(statearr_77163_77211[(2)] = inst_77125);

(statearr_77163_77211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (19))){
var state_77130__$1 = state_77130;
var statearr_77164_77212 = state_77130__$1;
(statearr_77164_77212[(2)] = roles);

(statearr_77164_77212[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (11))){
var inst_77090 = (state_77130[(2)]);
var state_77130__$1 = state_77130;
var statearr_77166_77213 = state_77130__$1;
(statearr_77166_77213[(2)] = inst_77090);

(statearr_77166_77213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (9))){
var state_77130__$1 = state_77130;
var statearr_77167_77214 = state_77130__$1;
(statearr_77167_77214[(2)] = (0));

(statearr_77167_77214[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (5))){
var _ = (function (){var statearr_77168 = state_77130;
(statearr_77168[(4)] = cljs.core.rest((state_77130[(4)])));

return statearr_77168;
})();
var state_77130__$1 = state_77130;
var ex77165 = (state_77130__$1[(2)]);
var statearr_77169_77215 = state_77130__$1;
(statearr_77169_77215[(5)] = ex77165);


if((ex77165 instanceof Error)){
var statearr_77170_77216 = state_77130__$1;
(statearr_77170_77216[(1)] = (4));

(statearr_77170_77216[(5)] = null);

} else {
throw ex77165;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (14))){
var inst_77088 = (state_77130[(2)]);
var state_77130__$1 = state_77130;
var statearr_77171_77217 = state_77130__$1;
(statearr_77171_77217[(2)] = inst_77088);

(statearr_77171_77217[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (26))){
var state_77130__$1 = state_77130;
var statearr_77172_77218 = state_77130__$1;
(statearr_77172_77218[(2)] = null);

(statearr_77172_77218[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (16))){
var inst_77075 = (state_77130[(8)]);
var state_77130__$1 = state_77130;
var statearr_77173_77219 = state_77130__$1;
(statearr_77173_77219[(2)] = inst_77075);

(statearr_77173_77219[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (30))){
var state_77130__$1 = state_77130;
var statearr_77174_77220 = state_77130__$1;
(statearr_77174_77220[(2)] = null);

(statearr_77174_77220[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (10))){
var state_77130__$1 = state_77130;
if(cljs.core.truth_(auth)){
var statearr_77175_77221 = state_77130__$1;
(statearr_77175_77221[(1)] = (12));

} else {
var statearr_77176_77222 = state_77130__$1;
(statearr_77176_77222[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (18))){
var inst_77085 = (state_77130[(2)]);
var state_77130__$1 = state_77130;
var statearr_77177_77223 = state_77130__$1;
(statearr_77177_77223[(2)] = inst_77085);

(statearr_77177_77223[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77131 === (8))){
var inst_77092 = (state_77130[(2)]);
var state_77130__$1 = (function (){var statearr_77178 = state_77130;
(statearr_77178[(7)] = inst_77092);

return statearr_77178;
})();
if(cljs.core.truth_(roles)){
var statearr_77179_77224 = state_77130__$1;
(statearr_77179_77224[(1)] = (19));

} else {
var statearr_77180_77225 = state_77130__$1;
(statearr_77180_77225[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0 = (function (){
var statearr_77181 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_77181[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__);

(statearr_77181[(1)] = (1));

return statearr_77181;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1 = (function (state_77130){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_77130);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77182){var ex__2687__auto__ = e77182;
var statearr_77183_77226 = state_77130;
(statearr_77183_77226[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_77130[(4)]))){
var statearr_77184_77227 = state_77130;
(statearr_77184_77227[(1)] = cljs.core.first((state_77130[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77228 = state_77130;
state_77130 = G__77228;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = function(state_77130){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1.call(this,state_77130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77185 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_77185[(6)] = c__2706__auto__);

return statearr_77185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__77229 = db;
var map__77229__$1 = cljs.core.__destructure_map(map__77229);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77229__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77229__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77229__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77236){
var state_val_77237 = (state_77236[(1)]);
if((state_val_77237 === (1))){
var inst_77230 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_77231 = fluree.db.session.db(conn,inst_77230,null);
var state_77236__$1 = state_77236;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77236__$1,(2),inst_77231);
} else {
if((state_val_77237 === (2))){
var inst_77233 = (state_77236[(2)]);
var inst_77234 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_77233);
var state_77236__$1 = state_77236;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77236__$1,inst_77234);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_77238 = [null,null,null,null,null,null,null];
(statearr_77238[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_77238[(1)] = (1));

return statearr_77238;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_77236){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_77236);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77239){var ex__2687__auto__ = e77239;
var statearr_77240_77267 = state_77236;
(statearr_77240_77267[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_77236[(4)]))){
var statearr_77241_77268 = state_77236;
(statearr_77241_77268[(1)] = cljs.core.first((state_77236[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77269 = state_77236;
state_77236 = G__77269;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_77236){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_77236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77242 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_77242[(6)] = c__2706__auto__);

return statearr_77242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77255){
var state_val_77256 = (state_77255[(1)]);
if((state_val_77256 === (1))){
var inst_77243 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_77244 = fluree.db.session.db(conn,inst_77243,null);
var state_77255__$1 = state_77255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77255__$1,(2),inst_77244);
} else {
if((state_val_77256 === (2))){
var inst_77246 = (state_77255[(7)]);
var inst_77246__$1 = (state_77255[(2)]);
var inst_77247 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_77246__$1);
var inst_77248 = newer_block_QMARK_(inst_77247);
var state_77255__$1 = (function (){var statearr_77257 = state_77255;
(statearr_77257[(7)] = inst_77246__$1);

return statearr_77257;
})();
if(inst_77248){
var statearr_77258_77270 = state_77255__$1;
(statearr_77258_77270[(1)] = (3));

} else {
var statearr_77259_77271 = state_77255__$1;
(statearr_77259_77271[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77256 === (3))){
var inst_77246 = (state_77255[(7)]);
var inst_77250 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_77246);
var state_77255__$1 = state_77255;
var statearr_77260_77272 = state_77255__$1;
(statearr_77260_77272[(2)] = inst_77250);

(statearr_77260_77272[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77256 === (4))){
var state_77255__$1 = state_77255;
var statearr_77261_77273 = state_77255__$1;
(statearr_77261_77273[(2)] = null);

(statearr_77261_77273[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77256 === (5))){
var inst_77253 = (state_77255[(2)]);
var state_77255__$1 = state_77255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77255__$1,inst_77253);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_77262 = [null,null,null,null,null,null,null,null];
(statearr_77262[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_77262[(1)] = (1));

return statearr_77262;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_77255){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_77255);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77263){var ex__2687__auto__ = e77263;
var statearr_77264_77274 = state_77255;
(statearr_77264_77274[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_77255[(4)]))){
var statearr_77265_77275 = state_77255;
(statearr_77265_77275[(1)] = cljs.core.first((state_77255[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77276 = state_77255;
state_77255 = G__77276;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_77255){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_77255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77266 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_77266[(6)] = c__2706__auto__);

return statearr_77266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__77277 = db;
var map__77277__$1 = cljs.core.__destructure_map(map__77277);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77277__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77277__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77277__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2706__auto___77353 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77327){
var state_val_77328 = (state_77327[(1)]);
if((state_val_77328 === (7))){
var inst_77293 = (state_77327[(7)]);
var inst_77304 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77293,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_77327__$1 = state_77327;
if(inst_77304){
var statearr_77329_77354 = state_77327__$1;
(statearr_77329_77354[(1)] = (9));

} else {
var statearr_77330_77355 = state_77327__$1;
(statearr_77330_77355[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (1))){
var inst_77286 = (state_77327[(8)]);
var inst_77278 = (state_77327[(9)]);
var inst_77278__$1 = cljs.core.async.timeout(timeout);
var inst_77286__$1 = res_port;
var inst_77287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77288 = [inst_77278__$1,inst_77286__$1];
var inst_77289 = (new cljs.core.PersistentVector(null,2,(5),inst_77287,inst_77288,null));
var state_77327__$1 = (function (){var statearr_77331 = state_77327;
(statearr_77331[(8)] = inst_77286__$1);

(statearr_77331[(9)] = inst_77278__$1);

return statearr_77331;
})();
return cljs.core.async.ioc_alts_BANG_(state_77327__$1,(2),inst_77289);
} else {
if((state_val_77328 === (4))){
var inst_77286 = (state_77327[(8)]);
var inst_77293 = (state_77327[(7)]);
var inst_77297 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77293,inst_77286);
var state_77327__$1 = state_77327;
if(inst_77297){
var statearr_77332_77356 = state_77327__$1;
(statearr_77332_77356[(1)] = (6));

} else {
var statearr_77333_77357 = state_77327__$1;
(statearr_77333_77357[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (13))){
var inst_77312 = (state_77327[(10)]);
var inst_77323 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_77312);
var state_77327__$1 = state_77327;
var statearr_77334_77358 = state_77327__$1;
(statearr_77334_77358[(2)] = inst_77323);

(statearr_77334_77358[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (6))){
var inst_77291 = (state_77327[(11)]);
var inst_77302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77291,(0),null);
var state_77327__$1 = state_77327;
var statearr_77335_77359 = state_77327__$1;
(statearr_77335_77359[(2)] = inst_77302);

(statearr_77335_77359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (3))){
var state_77327__$1 = state_77327;
var statearr_77336_77360 = state_77327__$1;
(statearr_77336_77360[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_77336_77360[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (12))){
var inst_77316 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_77317 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77318 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_77319 = cljs.core.PersistentHashMap.fromArrays(inst_77317,inst_77318);
var inst_77320 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_77316,inst_77319);
var inst_77321 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_77320);
var state_77327__$1 = state_77327;
var statearr_77337_77361 = state_77327__$1;
(statearr_77337_77361[(2)] = inst_77321);

(statearr_77337_77361[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (2))){
var inst_77291 = (state_77327[(11)]);
var inst_77293 = (state_77327[(7)]);
var inst_77278 = (state_77327[(9)]);
var inst_77291__$1 = (state_77327[(2)]);
var inst_77292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77291__$1,(0),null);
var inst_77293__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77291__$1,(1),null);
var inst_77294 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77293__$1,inst_77278);
var state_77327__$1 = (function (){var statearr_77338 = state_77327;
(statearr_77338[(11)] = inst_77291__$1);

(statearr_77338[(7)] = inst_77293__$1);

(statearr_77338[(12)] = inst_77292);

return statearr_77338;
})();
if(inst_77294){
var statearr_77339_77362 = state_77327__$1;
(statearr_77339_77362[(1)] = (3));

} else {
var statearr_77340_77363 = state_77327__$1;
(statearr_77340_77363[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (11))){
var inst_77308 = (state_77327[(2)]);
var state_77327__$1 = state_77327;
var statearr_77341_77364 = state_77327__$1;
(statearr_77341_77364[(2)] = inst_77308);

(statearr_77341_77364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (9))){
var inst_77292 = (state_77327[(12)]);
var state_77327__$1 = state_77327;
var statearr_77342_77365 = state_77327__$1;
(statearr_77342_77365[(2)] = inst_77292);

(statearr_77342_77365[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (5))){
var inst_77312 = (state_77327[(10)]);
var inst_77312__$1 = (state_77327[(2)]);
var inst_77313 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_77314 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_77312__$1);
var state_77327__$1 = (function (){var statearr_77343 = state_77327;
(statearr_77343[(10)] = inst_77312__$1);

(statearr_77343[(13)] = inst_77313);

return statearr_77343;
})();
if(inst_77314){
var statearr_77344_77366 = state_77327__$1;
(statearr_77344_77366[(1)] = (12));

} else {
var statearr_77345_77367 = state_77327__$1;
(statearr_77345_77367[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (14))){
var inst_77325 = (state_77327[(2)]);
var state_77327__$1 = state_77327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77327__$1,inst_77325);
} else {
if((state_val_77328 === (10))){
var state_77327__$1 = state_77327;
var statearr_77346_77368 = state_77327__$1;
(statearr_77346_77368[(2)] = null);

(statearr_77346_77368[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77328 === (8))){
var inst_77310 = (state_77327[(2)]);
var state_77327__$1 = state_77327;
var statearr_77347_77369 = state_77327__$1;
(statearr_77347_77369[(2)] = inst_77310);

(statearr_77347_77369[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0 = (function (){
var statearr_77348 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77348[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__);

(statearr_77348[(1)] = (1));

return statearr_77348;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1 = (function (state_77327){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_77327);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77349){var ex__2687__auto__ = e77349;
var statearr_77350_77370 = state_77327;
(statearr_77350_77370[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_77327[(4)]))){
var statearr_77351_77371 = state_77327;
(statearr_77351_77371[(1)] = cljs.core.first((state_77327[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77372 = state_77327;
state_77327 = G__77372;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = function(state_77327){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1.call(this,state_77327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77352 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_77352[(6)] = c__2706__auto___77353);

return statearr_77352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__77374 = arguments.length;
switch (G__77374) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__77375){
var map__77376 = p__77375;
var map__77376__$1 = cljs.core.__destructure_map(map__77376);
var opts = map__77376__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77376__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77376__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77376__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77376__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77376__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2706__auto___77465 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77427){
var state_val_77428 = (state_77427[(1)]);
if((state_val_77428 === (7))){
var inst_77389 = (state_77427[(7)]);
var inst_77391 = fluree.db.api.ledger.syncTo_db(inst_77389,syncTo,syncTimeout);
var state_77427__$1 = state_77427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77427__$1,(10),inst_77391);
} else {
if((state_val_77428 === (20))){
var inst_77413 = (state_77427[(8)]);
var state_77427__$1 = state_77427;
var statearr_77429_77466 = state_77427__$1;
(statearr_77429_77466[(2)] = inst_77413);

(statearr_77429_77466[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (1))){
var state_77427__$1 = state_77427;
var statearr_77430_77467 = state_77427__$1;
(statearr_77430_77467[(2)] = null);

(statearr_77430_77467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (4))){
var inst_77377 = (state_77427[(2)]);
var inst_77378 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_77377);
var inst_77379 = cljs.core.async.close_BANG_(pc);
var state_77427__$1 = (function (){var statearr_77431 = state_77427;
(statearr_77431[(9)] = inst_77378);

return statearr_77431;
})();
var statearr_77432_77468 = state_77427__$1;
(statearr_77432_77468[(2)] = inst_77379);

(statearr_77432_77468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (15))){
var inst_77405 = (state_77427[(10)]);
var inst_77407 = fluree.db.api.ledger.add_db_permissions(inst_77405,auth,roles);
var state_77427__$1 = state_77427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77427__$1,(18),inst_77407);
} else {
if((state_val_77428 === (21))){
var inst_77421 = (state_77427[(2)]);
var inst_77422 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_77421);
var _ = (function (){var statearr_77433 = state_77427;
(statearr_77433[(4)] = cljs.core.rest((state_77427[(4)])));

return statearr_77433;
})();
var state_77427__$1 = state_77427;
var statearr_77434_77469 = state_77427__$1;
(statearr_77434_77469[(2)] = inst_77422);

(statearr_77434_77469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (13))){
var inst_77405 = (state_77427[(2)]);
var state_77427__$1 = (function (){var statearr_77435 = state_77427;
(statearr_77435[(10)] = inst_77405);

return statearr_77435;
})();
if(cljs.core.truth_(roles)){
var statearr_77436_77470 = state_77427__$1;
(statearr_77436_77470[(1)] = (15));

} else {
var statearr_77437_77471 = state_77427__$1;
(statearr_77437_77471[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (22))){
var inst_77417 = (state_77427[(2)]);
var inst_77418 = fluree.db.util.async.throw_err(inst_77417);
var state_77427__$1 = state_77427;
var statearr_77438_77472 = state_77427__$1;
(statearr_77438_77472[(2)] = inst_77418);

(statearr_77438_77472[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (6))){
var inst_77388 = (state_77427[(2)]);
var inst_77389 = fluree.db.util.async.throw_err(inst_77388);
var state_77427__$1 = (function (){var statearr_77439 = state_77427;
(statearr_77439[(7)] = inst_77389);

return statearr_77439;
})();
if(cljs.core.truth_(syncTo)){
var statearr_77440_77473 = state_77427__$1;
(statearr_77440_77473[(1)] = (7));

} else {
var statearr_77441_77474 = state_77427__$1;
(statearr_77441_77474[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (17))){
var inst_77413 = (state_77427[(2)]);
var state_77427__$1 = (function (){var statearr_77442 = state_77427;
(statearr_77442[(8)] = inst_77413);

return statearr_77442;
})();
if(cljs.core.truth_(auth)){
var statearr_77443_77475 = state_77427__$1;
(statearr_77443_77475[(1)] = (19));

} else {
var statearr_77444_77476 = state_77427__$1;
(statearr_77444_77476[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (3))){
var inst_77425 = (state_77427[(2)]);
var state_77427__$1 = state_77427;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77427__$1,inst_77425);
} else {
if((state_val_77428 === (12))){
var inst_77397 = (state_77427[(11)]);
var state_77427__$1 = state_77427;
var statearr_77445_77477 = state_77427__$1;
(statearr_77445_77477[(2)] = inst_77397);

(statearr_77445_77477[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (2))){
var _ = (function (){var statearr_77446 = state_77427;
(statearr_77446[(4)] = cljs.core.cons((5),(state_77427[(4)])));

return statearr_77446;
})();
var inst_77386 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_77427__$1 = state_77427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77427__$1,(6),inst_77386);
} else {
if((state_val_77428 === (19))){
var inst_77413 = (state_77427[(8)]);
var inst_77415 = fluree.db.api.ledger.add_db_permissions(inst_77413,auth,roles);
var state_77427__$1 = state_77427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77427__$1,(22),inst_77415);
} else {
if((state_val_77428 === (11))){
var inst_77397 = (state_77427[(11)]);
var inst_77399 = fluree.db.time_travel.as_of_block(inst_77397,block);
var state_77427__$1 = state_77427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77427__$1,(14),inst_77399);
} else {
if((state_val_77428 === (9))){
var inst_77397 = (state_77427[(2)]);
var state_77427__$1 = (function (){var statearr_77448 = state_77427;
(statearr_77448[(11)] = inst_77397);

return statearr_77448;
})();
if(cljs.core.truth_(block)){
var statearr_77449_77478 = state_77427__$1;
(statearr_77449_77478[(1)] = (11));

} else {
var statearr_77450_77479 = state_77427__$1;
(statearr_77450_77479[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (5))){
var _ = (function (){var statearr_77451 = state_77427;
(statearr_77451[(4)] = cljs.core.rest((state_77427[(4)])));

return statearr_77451;
})();
var state_77427__$1 = state_77427;
var ex77447 = (state_77427__$1[(2)]);
var statearr_77452_77480 = state_77427__$1;
(statearr_77452_77480[(5)] = ex77447);


var statearr_77453_77481 = state_77427__$1;
(statearr_77453_77481[(1)] = (4));

(statearr_77453_77481[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (14))){
var inst_77401 = (state_77427[(2)]);
var inst_77402 = fluree.db.util.async.throw_err(inst_77401);
var state_77427__$1 = state_77427;
var statearr_77454_77482 = state_77427__$1;
(statearr_77454_77482[(2)] = inst_77402);

(statearr_77454_77482[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (16))){
var inst_77405 = (state_77427[(10)]);
var state_77427__$1 = state_77427;
var statearr_77455_77483 = state_77427__$1;
(statearr_77455_77483[(2)] = inst_77405);

(statearr_77455_77483[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (10))){
var inst_77393 = (state_77427[(2)]);
var inst_77394 = fluree.db.util.async.throw_err(inst_77393);
var state_77427__$1 = state_77427;
var statearr_77456_77484 = state_77427__$1;
(statearr_77456_77484[(2)] = inst_77394);

(statearr_77456_77484[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (18))){
var inst_77409 = (state_77427[(2)]);
var inst_77410 = fluree.db.util.async.throw_err(inst_77409);
var state_77427__$1 = state_77427;
var statearr_77457_77485 = state_77427__$1;
(statearr_77457_77485[(2)] = inst_77410);

(statearr_77457_77485[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77428 === (8))){
var inst_77389 = (state_77427[(7)]);
var state_77427__$1 = state_77427;
var statearr_77458_77486 = state_77427__$1;
(statearr_77458_77486[(2)] = inst_77389);

(statearr_77458_77486[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_77459 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77459[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_77459[(1)] = (1));

return statearr_77459;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_77427){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_77427);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77460){var ex__2687__auto__ = e77460;
var statearr_77461_77487 = state_77427;
(statearr_77461_77487[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_77427[(4)]))){
var statearr_77462_77488 = state_77427;
(statearr_77462_77488[(1)] = cljs.core.first((state_77427[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77489 = state_77427;
state_77427 = G__77489;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_77427){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_77427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77463 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_77463[(6)] = c__2706__auto___77465);

return statearr_77463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

