// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___74637 = arguments.length;
var i__5770__auto___74638 = (0);
while(true){
if((i__5770__auto___74638 < len__5769__auto___74637)){
args__5775__auto__.push((arguments[i__5770__auto___74638]));

var G__74639 = (i__5770__auto___74638 + (1));
i__5770__auto___74638 = G__74639;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__74566){
var vec__74567 = p__74566;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74567,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___74640 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74614){
var state_val_74615 = (state_74614[(1)]);
if((state_val_74615 === (7))){
var inst_74600 = (state_74614[(7)]);
var inst_74591 = (state_74614[(8)]);
var inst_74602 = fluree.db.time_travel.as_of_block(inst_74600,inst_74591);
var state_74614__$1 = state_74614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74614__$1,(10),inst_74602);
} else {
if((state_val_74615 === (1))){
var state_74614__$1 = state_74614;
var statearr_74616_74641 = state_74614__$1;
(statearr_74616_74641[(2)] = null);

(statearr_74616_74641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74615 === (4))){
var inst_74570 = (state_74614[(2)]);
var inst_74571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74572 = [inst_74570];
var inst_74573 = (new cljs.core.PersistentVector(null,1,(5),inst_74571,inst_74572,null));
var inst_74574 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74573);
var inst_74575 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74570);
var inst_74576 = cljs.core.async.close_BANG_(pc);
var state_74614__$1 = (function (){var statearr_74617 = state_74614;
(statearr_74617[(9)] = inst_74575);

(statearr_74617[(10)] = inst_74574);

return statearr_74617;
})();
var statearr_74618_74642 = state_74614__$1;
(statearr_74618_74642[(2)] = inst_74576);

(statearr_74618_74642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74615 === (6))){
var inst_74595 = (state_74614[(11)]);
var inst_74594 = (state_74614[(12)]);
var inst_74591 = (state_74614[(8)]);
var inst_74598 = (state_74614[(2)]);
var inst_74599 = fluree.db.util.async.throw_err(inst_74598);
var inst_74600 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_74599,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_74594,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_74595], 0));
var state_74614__$1 = (function (){var statearr_74619 = state_74614;
(statearr_74619[(7)] = inst_74600);

return statearr_74619;
})();
if(cljs.core.truth_(inst_74591)){
var statearr_74620_74643 = state_74614__$1;
(statearr_74620_74643[(1)] = (7));

} else {
var statearr_74621_74644 = state_74614__$1;
(statearr_74621_74644[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74615 === (3))){
var inst_74612 = (state_74614[(2)]);
var state_74614__$1 = state_74614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74614__$1,inst_74612);
} else {
if((state_val_74615 === (2))){
var _ = (function (){var statearr_74623 = state_74614;
(statearr_74623[(4)] = cljs.core.cons((5),(state_74614[(4)])));

return statearr_74623;
})();
var inst_74586 = opts;
var inst_74587 = cljs.core.__destructure_map(inst_74586);
var inst_74588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74587,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_74589 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74587,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_74590 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74587,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_74591 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74587,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74592 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_74593 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var inst_74594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74593,(0),null);
var inst_74595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74593,(1),null);
var inst_74596 = fluree.db.session.db(conn,ledger,opts);
var state_74614__$1 = (function (){var statearr_74624 = state_74614;
(statearr_74624[(13)] = inst_74589);

(statearr_74624[(11)] = inst_74595);

(statearr_74624[(12)] = inst_74594);

(statearr_74624[(14)] = inst_74590);

(statearr_74624[(15)] = inst_74588);

(statearr_74624[(8)] = inst_74591);

(statearr_74624[(16)] = inst_74592);

return statearr_74624;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74614__$1,(6),inst_74596);
} else {
if((state_val_74615 === (9))){
var inst_74608 = (state_74614[(2)]);
var inst_74609 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74608);
var _ = (function (){var statearr_74625 = state_74614;
(statearr_74625[(4)] = cljs.core.rest((state_74614[(4)])));

return statearr_74625;
})();
var state_74614__$1 = state_74614;
var statearr_74626_74645 = state_74614__$1;
(statearr_74626_74645[(2)] = inst_74609);

(statearr_74626_74645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74615 === (5))){
var _ = (function (){var statearr_74627 = state_74614;
(statearr_74627[(4)] = cljs.core.rest((state_74614[(4)])));

return statearr_74627;
})();
var state_74614__$1 = state_74614;
var ex74622 = (state_74614__$1[(2)]);
var statearr_74628_74646 = state_74614__$1;
(statearr_74628_74646[(5)] = ex74622);


var statearr_74629_74647 = state_74614__$1;
(statearr_74629_74647[(1)] = (4));

(statearr_74629_74647[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74615 === (10))){
var inst_74604 = (state_74614[(2)]);
var inst_74605 = fluree.db.util.async.throw_err(inst_74604);
var state_74614__$1 = state_74614;
var statearr_74630_74648 = state_74614__$1;
(statearr_74630_74648[(2)] = inst_74605);

(statearr_74630_74648[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74615 === (8))){
var inst_74600 = (state_74614[(7)]);
var state_74614__$1 = state_74614;
var statearr_74631_74649 = state_74614__$1;
(statearr_74631_74649[(2)] = inst_74600);

(statearr_74631_74649[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_74632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74632[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_74632[(1)] = (1));

return statearr_74632;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_74614){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_74614);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74633){var ex__2687__auto__ = e74633;
var statearr_74634_74650 = state_74614;
(statearr_74634_74650[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_74614[(4)]))){
var statearr_74635_74651 = state_74614;
(statearr_74635_74651[(1)] = cljs.core.first((state_74614[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74652 = state_74614;
state_74614 = G__74652;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_74614){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_74614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74636 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_74636[(6)] = c__2706__auto___74640);

return statearr_74636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq74563){
var G__74564 = cljs.core.first(seq74563);
var seq74563__$1 = cljs.core.next(seq74563);
var G__74565 = cljs.core.first(seq74563__$1);
var seq74563__$2 = cljs.core.next(seq74563__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74564,G__74565,seq74563__$2);
}));

fluree.db.api_js.ledger_ident_QMARK_ = (function fluree$db$api_js$ledger_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_(val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,ledger_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_(val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_(val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,ledger_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__74654 = arguments.length;
switch (G__74654) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74783){
var state_val_74784 = (state_74783[(1)]);
if((state_val_74784 === (7))){
var inst_74683 = (state_74783[(7)]);
var inst_74673 = (state_74783[(8)]);
var inst_74685 = fluree.db.time_travel.as_of_block(inst_74683,inst_74673);
var state_74783__$1 = state_74783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74783__$1,(10),inst_74685);
} else {
if((state_val_74784 === (20))){
var inst_74677 = (state_74783[(9)]);
var state_74783__$1 = state_74783;
var statearr_74785_74865 = state_74783__$1;
(statearr_74785_74865[(2)] = inst_74677);

(statearr_74785_74865[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (27))){
var inst_74671 = (state_74783[(10)]);
var state_74783__$1 = state_74783;
var statearr_74786_74866 = state_74783__$1;
(statearr_74786_74866[(2)] = inst_74671);

(statearr_74786_74866[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (1))){
var state_74783__$1 = state_74783;
var statearr_74787_74867 = state_74783__$1;
(statearr_74787_74867[(2)] = null);

(statearr_74787_74867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (24))){
var inst_74680 = (state_74783[(11)]);
var state_74783__$1 = state_74783;
if(cljs.core.truth_(inst_74680)){
var statearr_74788_74868 = state_74783__$1;
(statearr_74788_74868[(1)] = (26));

} else {
var statearr_74789_74869 = state_74783__$1;
(statearr_74789_74869[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (39))){
var inst_74745 = (state_74783[(12)]);
var inst_74748 = cljs.core.ex_data(inst_74745);
var inst_74749 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74750 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_74748);
var inst_74751 = cljs.core.ex_message(inst_74745);
var inst_74752 = [inst_74750,inst_74751,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74753 = cljs.core.PersistentHashMap.fromArrays(inst_74749,inst_74752);
var state_74783__$1 = state_74783;
var statearr_74790_74870 = state_74783__$1;
(statearr_74790_74870[(2)] = inst_74753);

(statearr_74790_74870[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (46))){
var inst_74745 = (state_74783[(12)]);
var state_74783__$1 = state_74783;
var statearr_74791_74871 = state_74783__$1;
(statearr_74791_74871[(2)] = inst_74745);

(statearr_74791_74871[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (4))){
var inst_74655 = (state_74783[(2)]);
var inst_74656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74657 = [inst_74655];
var inst_74658 = (new cljs.core.PersistentVector(null,1,(5),inst_74656,inst_74657,null));
var inst_74659 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74658);
var inst_74660 = cljs.core.ex_data(inst_74655);
var inst_74661 = cljs.core.ex_message(inst_74655);
var inst_74662 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74660,new cljs.core.Keyword(null,"message","message",-406056002),inst_74661);
var state_74783__$1 = (function (){var statearr_74792 = state_74783;
(statearr_74792[(13)] = inst_74659);

return statearr_74792;
})();
var statearr_74793_74872 = state_74783__$1;
(statearr_74793_74872[(2)] = inst_74662);

(statearr_74793_74872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (15))){
var state_74783__$1 = state_74783;
var statearr_74794_74873 = state_74783__$1;
(statearr_74794_74873[(2)] = (1000000));

(statearr_74794_74873[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (48))){
var inst_74745 = (state_74783[(12)]);
var state_74783__$1 = state_74783;
var statearr_74795_74874 = state_74783__$1;
(statearr_74795_74874[(2)] = inst_74745);

(statearr_74795_74874[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (50))){
var inst_74772 = (state_74783[(2)]);
var state_74783__$1 = state_74783;
var statearr_74796_74875 = state_74783__$1;
(statearr_74796_74875[(2)] = inst_74772);

(statearr_74796_74875[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (21))){
var inst_74676 = (state_74783[(14)]);
var state_74783__$1 = state_74783;
if(cljs.core.truth_(inst_74676)){
var statearr_74797_74876 = state_74783__$1;
(statearr_74797_74876[(1)] = (23));

} else {
var statearr_74798_74877 = state_74783__$1;
(statearr_74798_74877[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (31))){
var inst_74734 = (state_74783[(2)]);
var inst_74735 = cljs.core.not(inst_74734);
var state_74783__$1 = state_74783;
if(inst_74735){
var statearr_74799_74878 = state_74783__$1;
(statearr_74799_74878[(1)] = (35));

} else {
var statearr_74800_74879 = state_74783__$1;
(statearr_74800_74879[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (32))){
var inst_74678 = (state_74783[(15)]);
var state_74783__$1 = state_74783;
var statearr_74801_74880 = state_74783__$1;
(statearr_74801_74880[(2)] = inst_74678);

(statearr_74801_74880[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (40))){
var inst_74708 = (state_74783[(16)]);
var state_74783__$1 = state_74783;
if(cljs.core.truth_(inst_74708)){
var statearr_74802_74881 = state_74783__$1;
(statearr_74802_74881[(1)] = (42));

} else {
var statearr_74803_74882 = state_74783__$1;
(statearr_74803_74882[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (33))){
var inst_74674 = (state_74783[(17)]);
var state_74783__$1 = state_74783;
var statearr_74804_74883 = state_74783__$1;
(statearr_74804_74883[(2)] = inst_74674);

(statearr_74804_74883[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (13))){
var inst_74703 = (state_74783[(18)]);
var inst_74679 = (state_74783[(19)]);
var inst_74701 = (state_74783[(2)]);
var inst_74702 = cljs.core.volatile_BANG_((0));
var inst_74703__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_74679);
var state_74783__$1 = (function (){var statearr_74805 = state_74783;
(statearr_74805[(20)] = inst_74702);

(statearr_74805[(18)] = inst_74703__$1);

(statearr_74805[(21)] = inst_74701);

return statearr_74805;
})();
if(cljs.core.truth_(inst_74703__$1)){
var statearr_74806_74884 = state_74783__$1;
(statearr_74806_74884[(1)] = (14));

} else {
var statearr_74807_74885 = state_74783__$1;
(statearr_74807_74885[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (22))){
var inst_74724 = (state_74783[(2)]);
var state_74783__$1 = state_74783;
var statearr_74808_74886 = state_74783__$1;
(statearr_74808_74886[(2)] = inst_74724);

(statearr_74808_74886[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (36))){
var inst_74710 = (state_74783[(22)]);
var inst_74691 = (state_74783[(23)]);
var inst_74741 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74710);
var inst_74742 = fluree.db.query.fql.query(inst_74691,inst_74741);
var state_74783__$1 = state_74783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74783__$1,(38),inst_74742);
} else {
if((state_val_74784 === (41))){
var inst_74776 = (state_74783[(2)]);
var state_74783__$1 = state_74783;
var statearr_74809_74887 = state_74783__$1;
(statearr_74809_74887[(2)] = inst_74776);

(statearr_74809_74887[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (43))){
var state_74783__$1 = state_74783;
var statearr_74810_74888 = state_74783__$1;
(statearr_74810_74888[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (29))){
var inst_74678 = (state_74783[(15)]);
var state_74783__$1 = state_74783;
if(cljs.core.truth_(inst_74678)){
var statearr_74812_74889 = state_74783__$1;
(statearr_74812_74889[(1)] = (32));

} else {
var statearr_74813_74890 = state_74783__$1;
(statearr_74813_74890[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (44))){
var inst_74774 = (state_74783[(2)]);
var state_74783__$1 = state_74783;
var statearr_74814_74891 = state_74783__$1;
(statearr_74814_74891[(2)] = inst_74774);

(statearr_74814_74891[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (6))){
var inst_74673 = (state_74783[(8)]);
var inst_74682 = (state_74783[(2)]);
var inst_74683 = fluree.db.util.async.throw_err(inst_74682);
var state_74783__$1 = (function (){var statearr_74815 = state_74783;
(statearr_74815[(7)] = inst_74683);

return statearr_74815;
})();
if(cljs.core.truth_(inst_74673)){
var statearr_74816_74892 = state_74783__$1;
(statearr_74816_74892[(1)] = (7));

} else {
var statearr_74817_74893 = state_74783__$1;
(statearr_74817_74893[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (28))){
var inst_74720 = (state_74783[(2)]);
var state_74783__$1 = state_74783;
var statearr_74818_74894 = state_74783__$1;
(statearr_74818_74894[(2)] = inst_74720);

(statearr_74818_74894[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (25))){
var inst_74722 = (state_74783[(2)]);
var state_74783__$1 = state_74783;
var statearr_74819_74895 = state_74783__$1;
(statearr_74819_74895[(2)] = inst_74722);

(statearr_74819_74895[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (34))){
var inst_74731 = (state_74783[(2)]);
var state_74783__$1 = state_74783;
var statearr_74820_74896 = state_74783__$1;
(statearr_74820_74896[(2)] = inst_74731);

(statearr_74820_74896[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (17))){
var inst_74672 = (state_74783[(24)]);
var state_74783__$1 = state_74783;
var statearr_74821_74897 = state_74783__$1;
(statearr_74821_74897[(2)] = inst_74672);

(statearr_74821_74897[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (3))){
var inst_74781 = (state_74783[(2)]);
var state_74783__$1 = state_74783;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74783__$1,inst_74781);
} else {
if((state_val_74784 === (12))){
var inst_74699 = cljs.core.PersistentHashMap.EMPTY;
var state_74783__$1 = state_74783;
var statearr_74822_74898 = state_74783__$1;
(statearr_74822_74898[(2)] = inst_74699);

(statearr_74822_74898[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (2))){
var _ = (function (){var statearr_74823 = state_74783;
(statearr_74823[(4)] = cljs.core.cons((5),(state_74783[(4)])));

return statearr_74823;
})();
var inst_74669 = query_map;
var inst_74670 = cljs.core.__destructure_map(inst_74669);
var inst_74671 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74670,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_74672 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74670,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_74673 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74670,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74674 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74670,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_74675 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74670,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_74676 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74670,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_74677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74670,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_74678 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74670,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_74679 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74670,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_74680 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74670,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_74783__$1 = (function (){var statearr_74824 = state_74783;
(statearr_74824[(17)] = inst_74674);

(statearr_74824[(25)] = inst_74675);

(statearr_74824[(15)] = inst_74678);

(statearr_74824[(10)] = inst_74671);

(statearr_74824[(19)] = inst_74679);

(statearr_74824[(8)] = inst_74673);

(statearr_74824[(9)] = inst_74677);

(statearr_74824[(11)] = inst_74680);

(statearr_74824[(14)] = inst_74676);

(statearr_74824[(24)] = inst_74672);

return statearr_74824;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74783__$1,(6),sources);
} else {
if((state_val_74784 === (23))){
var inst_74676 = (state_74783[(14)]);
var state_74783__$1 = state_74783;
var statearr_74825_74899 = state_74783__$1;
(statearr_74825_74899[(2)] = inst_74676);

(statearr_74825_74899[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (47))){
var inst_74702 = (state_74783[(20)]);
var inst_74691 = (state_74783[(23)]);
var inst_74756 = (state_74783[(26)]);
var inst_74709 = (state_74783[(27)]);
var inst_74762 = (state_74783[(2)]);
var inst_74763 = cljs.core.deref(inst_74702);
var inst_74764 = fluree.db.util.core.response_time_formatted(inst_74709);
var inst_74765 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74691);
var inst_74766 = [(200),inst_74762,inst_74763,inst_74764,inst_74765];
var inst_74767 = cljs.core.PersistentHashMap.fromArrays(inst_74756,inst_74766);
var state_74783__$1 = state_74783;
var statearr_74826_74900 = state_74783__$1;
(statearr_74826_74900[(2)] = inst_74767);

(statearr_74826_74900[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (35))){
var inst_74737 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74738 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74739 = cljs.core.PersistentHashMap.fromArrays(inst_74737,inst_74738);
var state_74783__$1 = state_74783;
var statearr_74827_74901 = state_74783__$1;
(statearr_74827_74901[(2)] = inst_74739);

(statearr_74827_74901[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (19))){
var inst_74726 = (state_74783[(28)]);
var inst_74726__$1 = (state_74783[(2)]);
var state_74783__$1 = (function (){var statearr_74828 = state_74783;
(statearr_74828[(28)] = inst_74726__$1);

return statearr_74828;
})();
if(cljs.core.truth_(inst_74726__$1)){
var statearr_74829_74902 = state_74783__$1;
(statearr_74829_74902[(1)] = (29));

} else {
var statearr_74830_74903 = state_74783__$1;
(statearr_74830_74903[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (11))){
var inst_74675 = (state_74783[(25)]);
var inst_74691 = (state_74783[(23)]);
var inst_74692 = (state_74783[(29)]);
var inst_74694 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_74691);
var inst_74695 = fluree.db.connection_js.open_api_QMARK_(inst_74692);
var inst_74696 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_74691);
var inst_74697 = fluree.db.api_js.get_sources(inst_74692,inst_74694,inst_74695,inst_74696,inst_74675,db_fn);
var state_74783__$1 = state_74783;
var statearr_74832_74904 = state_74783__$1;
(statearr_74832_74904[(2)] = inst_74697);

(statearr_74832_74904[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (9))){
var inst_74675 = (state_74783[(25)]);
var inst_74691 = (state_74783[(23)]);
var inst_74691__$1 = (state_74783[(2)]);
var inst_74692 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_74691__$1);
var state_74783__$1 = (function (){var statearr_74833 = state_74783;
(statearr_74833[(23)] = inst_74691__$1);

(statearr_74833[(29)] = inst_74692);

return statearr_74833;
})();
if(cljs.core.truth_(inst_74675)){
var statearr_74834_74905 = state_74783__$1;
(statearr_74834_74905[(1)] = (11));

} else {
var statearr_74835_74906 = state_74783__$1;
(statearr_74835_74906[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (5))){
var _ = (function (){var statearr_74836 = state_74783;
(statearr_74836[(4)] = cljs.core.rest((state_74783[(4)])));

return statearr_74836;
})();
var state_74783__$1 = state_74783;
var ex74831 = (state_74783__$1[(2)]);
var statearr_74837_74907 = state_74783__$1;
(statearr_74837_74907[(5)] = ex74831);


var statearr_74838_74908 = state_74783__$1;
(statearr_74838_74908[(1)] = (4));

(statearr_74838_74908[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (14))){
var inst_74703 = (state_74783[(18)]);
var state_74783__$1 = state_74783;
var statearr_74839_74909 = state_74783__$1;
(statearr_74839_74909[(2)] = inst_74703);

(statearr_74839_74909[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (45))){
var inst_74745 = (state_74783[(12)]);
var inst_74759 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_74745);
var state_74783__$1 = state_74783;
var statearr_74840_74910 = state_74783__$1;
(statearr_74840_74910[(2)] = inst_74759);

(statearr_74840_74910[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (26))){
var inst_74680 = (state_74783[(11)]);
var state_74783__$1 = state_74783;
var statearr_74841_74911 = state_74783__$1;
(statearr_74841_74911[(2)] = inst_74680);

(statearr_74841_74911[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (16))){
var inst_74702 = (state_74783[(20)]);
var inst_74679 = (state_74783[(19)]);
var inst_74701 = (state_74783[(21)]);
var inst_74672 = (state_74783[(24)]);
var inst_74707 = (state_74783[(2)]);
var inst_74708 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_74679);
var inst_74709 = fluree.db.util.core.current_time_millis();
var inst_74710 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_74679,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_74701,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_74707,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74702], 0));
var state_74783__$1 = (function (){var statearr_74842 = state_74783;
(statearr_74842[(16)] = inst_74708);

(statearr_74842[(22)] = inst_74710);

(statearr_74842[(27)] = inst_74709);

return statearr_74842;
})();
if(cljs.core.truth_(inst_74672)){
var statearr_74843_74912 = state_74783__$1;
(statearr_74843_74912[(1)] = (17));

} else {
var statearr_74844_74913 = state_74783__$1;
(statearr_74844_74913[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (38))){
var inst_74745 = (state_74783[(12)]);
var inst_74744 = (state_74783[(2)]);
var inst_74745__$1 = fluree.db.util.async.throw_err(inst_74744);
var inst_74746 = (inst_74745__$1 instanceof cljs.core.ExceptionInfo);
var state_74783__$1 = (function (){var statearr_74845 = state_74783;
(statearr_74845[(12)] = inst_74745__$1);

return statearr_74845;
})();
if(cljs.core.truth_(inst_74746)){
var statearr_74846_74914 = state_74783__$1;
(statearr_74846_74914[(1)] = (39));

} else {
var statearr_74847_74915 = state_74783__$1;
(statearr_74847_74915[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (30))){
var inst_74726 = (state_74783[(28)]);
var state_74783__$1 = state_74783;
var statearr_74848_74916 = state_74783__$1;
(statearr_74848_74916[(2)] = inst_74726);

(statearr_74848_74916[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (10))){
var inst_74687 = (state_74783[(2)]);
var inst_74688 = fluree.db.util.async.throw_err(inst_74687);
var state_74783__$1 = state_74783;
var statearr_74849_74917 = state_74783__$1;
(statearr_74849_74917[(2)] = inst_74688);

(statearr_74849_74917[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (18))){
var inst_74677 = (state_74783[(9)]);
var state_74783__$1 = state_74783;
if(cljs.core.truth_(inst_74677)){
var statearr_74850_74918 = state_74783__$1;
(statearr_74850_74918[(1)] = (20));

} else {
var statearr_74851_74919 = state_74783__$1;
(statearr_74851_74919[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (42))){
var inst_74745 = (state_74783[(12)]);
var inst_74756 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_74757 = cljs.core.sequential_QMARK_(inst_74745);
var state_74783__$1 = (function (){var statearr_74852 = state_74783;
(statearr_74852[(26)] = inst_74756);

return statearr_74852;
})();
if(inst_74757){
var statearr_74853_74920 = state_74783__$1;
(statearr_74853_74920[(1)] = (45));

} else {
var statearr_74854_74921 = state_74783__$1;
(statearr_74854_74921[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (37))){
var inst_74778 = (state_74783[(2)]);
var _ = (function (){var statearr_74855 = state_74783;
(statearr_74855[(4)] = cljs.core.rest((state_74783[(4)])));

return statearr_74855;
})();
var state_74783__$1 = state_74783;
var statearr_74856_74922 = state_74783__$1;
(statearr_74856_74922[(2)] = inst_74778);

(statearr_74856_74922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (8))){
var inst_74683 = (state_74783[(7)]);
var state_74783__$1 = state_74783;
var statearr_74857_74923 = state_74783__$1;
(statearr_74857_74923[(2)] = inst_74683);

(statearr_74857_74923[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74784 === (49))){
var state_74783__$1 = state_74783;
var statearr_74858_74924 = state_74783__$1;
(statearr_74858_74924[(2)] = null);

(statearr_74858_74924[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_74859 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74859[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_74859[(1)] = (1));

return statearr_74859;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_74783){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_74783);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74860){var ex__2687__auto__ = e74860;
var statearr_74861_74925 = state_74783;
(statearr_74861_74925[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_74783[(4)]))){
var statearr_74862_74926 = state_74783;
(statearr_74862_74926[(1)] = cljs.core.first((state_74783[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74927 = state_74783;
state_74783 = G__74927;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_74783){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_74783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74863 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_74863[(6)] = c__2706__auto__);

return statearr_74863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__74928_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__74928_SHARP_);
}));

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74950){
var state_val_74951 = (state_74950[(1)]);
if((state_val_74951 === (1))){
var inst_74932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74933 = [resp_chan,timeout_chan];
var inst_74934 = (new cljs.core.PersistentVector(null,2,(5),inst_74932,inst_74933,null));
var state_74950__$1 = state_74950;
return cljs.core.async.ioc_alts_BANG_(state_74950__$1,(2),inst_74934);
} else {
if((state_val_74951 === (2))){
var inst_74936 = (state_74950[(2)]);
var inst_74937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74936,(0),null);
var inst_74938 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74936,(1),null);
var inst_74939 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_74938);
var state_74950__$1 = (function (){var statearr_74952 = state_74950;
(statearr_74952[(7)] = inst_74937);

return statearr_74952;
})();
if(inst_74939){
var statearr_74953_74963 = state_74950__$1;
(statearr_74953_74963[(1)] = (3));

} else {
var statearr_74954_74964 = state_74950__$1;
(statearr_74954_74964[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74951 === (3))){
var inst_74941 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_74942 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_74943 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_74944 = [tid,(408),inst_74943];
var inst_74945 = cljs.core.PersistentHashMap.fromArrays(inst_74942,inst_74944);
var state_74950__$1 = (function (){var statearr_74955 = state_74950;
(statearr_74955[(8)] = inst_74941);

return statearr_74955;
})();
var statearr_74956_74965 = state_74950__$1;
(statearr_74956_74965[(2)] = inst_74945);

(statearr_74956_74965[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74951 === (4))){
var inst_74937 = (state_74950[(7)]);
var state_74950__$1 = state_74950;
var statearr_74957_74966 = state_74950__$1;
(statearr_74957_74966[(2)] = inst_74937);

(statearr_74957_74966[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74951 === (5))){
var inst_74948 = (state_74950[(2)]);
var state_74950__$1 = state_74950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74950__$1,inst_74948);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0 = (function (){
var statearr_74958 = [null,null,null,null,null,null,null,null,null];
(statearr_74958[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__);

(statearr_74958[(1)] = (1));

return statearr_74958;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1 = (function (state_74950){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_74950);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74959){var ex__2687__auto__ = e74959;
var statearr_74960_74967 = state_74950;
(statearr_74960_74967[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_74950[(4)]))){
var statearr_74961_74968 = state_74950;
(statearr_74961_74968[(1)] = cljs.core.first((state_74950[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74969 = state_74950;
state_74950 = G__74969;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__ = function(state_74950){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1.call(this,state_74950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74962 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_74962[(6)] = c__2706__auto__);

return statearr_74962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__74971 = arguments.length;
switch (G__74971) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__74972 = opts;
var map__74972__$1 = cljs.core.__destructure_map(map__74972);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74972__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74972__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74972__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74972__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__74973 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74973,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74973,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e74976){var e = e74976;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__74979 = arguments.length;
switch (G__74979) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_75048){
var state_val_75049 = (state_75048[(1)]);
if((state_val_75049 === (7))){
var inst_75002 = (state_75048[(7)]);
var inst_75003 = (state_75048[(8)]);
var inst_75004 = (state_75048[(9)]);
var inst_74999 = (state_75048[(10)]);
var inst_75001 = (state_75048[(11)]);
var inst_75017 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_75018 = [ledger,txn,inst_74999,inst_75001,inst_75002,inst_75003,inst_75004];
var inst_75019 = cljs.core.PersistentHashMap.fromArrays(inst_75017,inst_75018);
var inst_75020 = fluree.db.util.core.without_nils(inst_75019);
var inst_75021 = fluree.db.operations.transact_async(conn,inst_75020);
var state_75048__$1 = state_75048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75048__$1,(13),inst_75021);
} else {
if((state_val_75049 === (20))){
var inst_75039 = (state_75048[(2)]);
var state_75048__$1 = state_75048;
var statearr_75050_75086 = state_75048__$1;
(statearr_75050_75086[(2)] = inst_75039);

(statearr_75050_75086[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (1))){
var state_75048__$1 = state_75048;
var statearr_75051_75087 = state_75048__$1;
(statearr_75051_75087[(2)] = null);

(statearr_75051_75087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (4))){
var inst_74980 = (state_75048[(2)]);
var inst_74981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74982 = [inst_74980];
var inst_74983 = (new cljs.core.PersistentVector(null,1,(5),inst_74981,inst_74982,null));
var inst_74984 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74983);
var inst_74985 = cljs.core.ex_data(inst_74980);
var inst_74986 = cljs.core.ex_message(inst_74980);
var inst_74987 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74985,new cljs.core.Keyword(null,"message","message",-406056002),inst_74986);
var state_75048__$1 = (function (){var statearr_75052 = state_75048;
(statearr_75052[(12)] = inst_74984);

return statearr_75052;
})();
var statearr_75053_75088 = state_75048__$1;
(statearr_75053_75088[(2)] = inst_74987);

(statearr_75053_75088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (15))){
var inst_75023 = (state_75048[(13)]);
var inst_74998 = (state_75048[(14)]);
var inst_75026 = fluree.db.api_js.monitor_tx(conn,ledger,inst_75023,inst_74998);
var state_75048__$1 = state_75048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75048__$1,(17),inst_75026);
} else {
if((state_val_75049 === (13))){
var inst_74997 = (state_75048[(15)]);
var inst_75023 = (state_75048[(2)]);
var state_75048__$1 = (function (){var statearr_75054 = state_75048;
(statearr_75054[(13)] = inst_75023);

return statearr_75054;
})();
if(cljs.core.truth_(inst_74997)){
var statearr_75055_75089 = state_75048__$1;
(statearr_75055_75089[(1)] = (14));

} else {
var statearr_75056_75090 = state_75048__$1;
(statearr_75056_75090[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (6))){
var inst_74997 = (state_75048[(15)]);
var inst_74996 = (state_75048[(16)]);
var inst_75006 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_74996,opts);
var inst_75007 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_75006);
var inst_75008 = fluree.db.operations.command_async(conn,inst_75006);
var state_75048__$1 = (function (){var statearr_75057 = state_75048;
(statearr_75057[(17)] = inst_75008);

(statearr_75057[(18)] = inst_75007);

return statearr_75057;
})();
if(cljs.core.truth_(inst_74997)){
var statearr_75058_75091 = state_75048__$1;
(statearr_75058_75091[(1)] = (9));

} else {
var statearr_75059_75092 = state_75048__$1;
(statearr_75059_75092[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (17))){
var inst_75028 = (state_75048[(19)]);
var inst_75028__$1 = (state_75048[(2)]);
var inst_75029 = (inst_75028__$1 instanceof cljs.core.ExceptionInfo);
var state_75048__$1 = (function (){var statearr_75060 = state_75048;
(statearr_75060[(19)] = inst_75028__$1);

return statearr_75060;
})();
if(cljs.core.truth_(inst_75029)){
var statearr_75061_75093 = state_75048__$1;
(statearr_75061_75093[(1)] = (18));

} else {
var statearr_75062_75094 = state_75048__$1;
(statearr_75062_75094[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (3))){
var inst_75046 = (state_75048[(2)]);
var state_75048__$1 = state_75048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75048__$1,inst_75046);
} else {
if((state_val_75049 === (12))){
var inst_75013 = (state_75048[(2)]);
var state_75048__$1 = state_75048;
var statearr_75063_75095 = state_75048__$1;
(statearr_75063_75095[(2)] = inst_75013);

(statearr_75063_75095[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (2))){
var inst_74996 = (state_75048[(16)]);
var _ = (function (){var statearr_75064 = state_75048;
(statearr_75064[(4)] = cljs.core.cons((5),(state_75048[(4)])));

return statearr_75064;
})();
var inst_74994 = opts;
var inst_74995 = cljs.core.__destructure_map(inst_74994);
var inst_74996__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74995,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_74997 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74995,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_74998 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74995,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_74999 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74995,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_75000 = fluree.db.util.core.current_time_millis();
var inst_75001 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74995,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_75000);
var inst_75002 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74995,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_75003 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74995,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_75004 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74995,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_75048__$1 = (function (){var statearr_75065 = state_75048;
(statearr_75065[(7)] = inst_75002);

(statearr_75065[(8)] = inst_75003);

(statearr_75065[(9)] = inst_75004);

(statearr_75065[(10)] = inst_74999);

(statearr_75065[(15)] = inst_74997);

(statearr_75065[(14)] = inst_74998);

(statearr_75065[(11)] = inst_75001);

(statearr_75065[(16)] = inst_74996__$1);

return statearr_75065;
})();
if(cljs.core.truth_(inst_74996__$1)){
var statearr_75066_75096 = state_75048__$1;
(statearr_75066_75096[(1)] = (6));

} else {
var statearr_75067_75097 = state_75048__$1;
(statearr_75067_75097[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (19))){
var inst_75028 = (state_75048[(19)]);
var state_75048__$1 = state_75048;
var statearr_75068_75098 = state_75048__$1;
(statearr_75068_75098[(2)] = inst_75028);

(statearr_75068_75098[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (11))){
var inst_75015 = (state_75048[(2)]);
var state_75048__$1 = state_75048;
var statearr_75070_75099 = state_75048__$1;
(statearr_75070_75099[(2)] = inst_75015);

(statearr_75070_75099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (9))){
var inst_75008 = (state_75048[(17)]);
var state_75048__$1 = state_75048;
var statearr_75071_75100 = state_75048__$1;
(statearr_75071_75100[(2)] = inst_75008);

(statearr_75071_75100[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (5))){
var _ = (function (){var statearr_75072 = state_75048;
(statearr_75072[(4)] = cljs.core.rest((state_75048[(4)])));

return statearr_75072;
})();
var state_75048__$1 = state_75048;
var ex75069 = (state_75048__$1[(2)]);
var statearr_75073_75101 = state_75048__$1;
(statearr_75073_75101[(5)] = ex75069);


var statearr_75074_75102 = state_75048__$1;
(statearr_75074_75102[(1)] = (4));

(statearr_75074_75102[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (14))){
var inst_75023 = (state_75048[(13)]);
var state_75048__$1 = state_75048;
var statearr_75075_75103 = state_75048__$1;
(statearr_75075_75103[(2)] = inst_75023);

(statearr_75075_75103[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (16))){
var inst_75041 = (state_75048[(2)]);
var state_75048__$1 = state_75048;
var statearr_75076_75104 = state_75048__$1;
(statearr_75076_75104[(2)] = inst_75041);

(statearr_75076_75104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (10))){
var inst_74998 = (state_75048[(14)]);
var inst_75007 = (state_75048[(18)]);
var inst_75011 = fluree.db.api_js.monitor_tx(conn,ledger,inst_75007,inst_74998);
var state_75048__$1 = state_75048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75048__$1,(12),inst_75011);
} else {
if((state_val_75049 === (18))){
var inst_75028 = (state_75048[(19)]);
var inst_75031 = cljs.core.ex_data(inst_75028);
var inst_75032 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75033 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_75031);
var inst_75034 = cljs.core.ex_message(inst_75028);
var inst_75035 = [inst_75033,inst_75034,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_75036 = cljs.core.PersistentHashMap.fromArrays(inst_75032,inst_75035);
var state_75048__$1 = state_75048;
var statearr_75077_75105 = state_75048__$1;
(statearr_75077_75105[(2)] = inst_75036);

(statearr_75077_75105[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75049 === (8))){
var inst_75043 = (state_75048[(2)]);
var _ = (function (){var statearr_75078 = state_75048;
(statearr_75078[(4)] = cljs.core.rest((state_75048[(4)])));

return statearr_75078;
})();
var state_75048__$1 = state_75048;
var statearr_75079_75106 = state_75048__$1;
(statearr_75079_75106[(2)] = inst_75043);

(statearr_75079_75106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_75080 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75080[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_75080[(1)] = (1));

return statearr_75080;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_75048){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_75048);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e75081){var ex__2687__auto__ = e75081;
var statearr_75082_75107 = state_75048;
(statearr_75082_75107[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_75048[(4)]))){
var statearr_75083_75108 = state_75048;
(statearr_75083_75108[(1)] = cljs.core.first((state_75048[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75109 = state_75048;
state_75048 = G__75109;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_75048){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_75048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_75084 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_75084[(6)] = c__2706__auto__);

return statearr_75084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___75111 = arguments.length;
var i__5770__auto___75112 = (0);
while(true){
if((i__5770__auto___75112 < len__5769__auto___75111)){
args__5775__auto__.push((arguments[i__5770__auto___75112]));

var G__75113 = (i__5770__auto___75112 + (1));
i__5770__auto___75112 = G__75113;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq75110){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq75110));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_75145){
var state_val_75146 = (state_75145[(1)]);
if((state_val_75146 === (1))){
var inst_75114 = cljs.core.first(flakes);
var inst_75115 = cljs.core.rest(flakes);
var inst_75116 = cljs.core.PersistentVector.EMPTY;
var inst_75117 = inst_75114;
var inst_75118 = inst_75115;
var inst_75119 = inst_75116;
var state_75145__$1 = (function (){var statearr_75147 = state_75145;
(statearr_75147[(7)] = inst_75117);

(statearr_75147[(8)] = inst_75119);

(statearr_75147[(9)] = inst_75118);

return statearr_75147;
})();
var statearr_75148_75161 = state_75145__$1;
(statearr_75148_75161[(2)] = null);

(statearr_75148_75161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75146 === (2))){
var inst_75117 = (state_75145[(7)]);
var inst_75121 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_75122 = cljs.core.PersistentHashMap.EMPTY;
var inst_75123 = [true,inst_75122];
var inst_75124 = cljs.core.PersistentHashMap.fromArrays(inst_75121,inst_75123);
var inst_75125 = cljs.core.PersistentHashMap.EMPTY;
var inst_75126 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_75124,inst_75125,inst_75117);
var state_75145__$1 = state_75145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75145__$1,(4),inst_75126);
} else {
if((state_val_75146 === (3))){
var inst_75143 = (state_75145[(2)]);
var state_75145__$1 = state_75145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75145__$1,inst_75143);
} else {
if((state_val_75146 === (4))){
var inst_75119 = (state_75145[(8)]);
var inst_75118 = (state_75145[(9)]);
var inst_75128 = (state_75145[(2)]);
var inst_75129 = fluree.db.util.async.throw_err(inst_75128);
var inst_75130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75131 = [inst_75129];
var inst_75132 = (new cljs.core.PersistentVector(null,1,(5),inst_75130,inst_75131,null));
var inst_75133 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_75119,inst_75132);
var inst_75134 = cljs.core.first(inst_75118);
var state_75145__$1 = (function (){var statearr_75149 = state_75145;
(statearr_75149[(10)] = inst_75133);

return statearr_75149;
})();
if(cljs.core.truth_(inst_75134)){
var statearr_75150_75162 = state_75145__$1;
(statearr_75150_75162[(1)] = (5));

} else {
var statearr_75151_75163 = state_75145__$1;
(statearr_75151_75163[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75146 === (5))){
var inst_75118 = (state_75145[(9)]);
var inst_75133 = (state_75145[(10)]);
var inst_75136 = cljs.core.first(inst_75118);
var inst_75137 = cljs.core.rest(inst_75118);
var inst_75117 = inst_75136;
var inst_75118__$1 = inst_75137;
var inst_75119 = inst_75133;
var state_75145__$1 = (function (){var statearr_75152 = state_75145;
(statearr_75152[(7)] = inst_75117);

(statearr_75152[(8)] = inst_75119);

(statearr_75152[(9)] = inst_75118__$1);

return statearr_75152;
})();
var statearr_75153_75164 = state_75145__$1;
(statearr_75153_75164[(2)] = null);

(statearr_75153_75164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75146 === (6))){
var inst_75133 = (state_75145[(10)]);
var state_75145__$1 = state_75145;
var statearr_75154_75165 = state_75145__$1;
(statearr_75154_75165[(2)] = inst_75133);

(statearr_75154_75165[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75146 === (7))){
var inst_75141 = (state_75145[(2)]);
var state_75145__$1 = state_75145;
var statearr_75155_75166 = state_75145__$1;
(statearr_75155_75166[(2)] = inst_75141);

(statearr_75155_75166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_75156 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_75156[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__);

(statearr_75156[(1)] = (1));

return statearr_75156;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1 = (function (state_75145){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_75145);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e75157){var ex__2687__auto__ = e75157;
var statearr_75158_75167 = state_75145;
(statearr_75158_75167[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_75145[(4)]))){
var statearr_75159_75168 = state_75145;
(statearr_75159_75168[(1)] = cljs.core.first((state_75145[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75169 = state_75145;
state_75145 = G__75169;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__ = function(state_75145){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1.call(this,state_75145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_75160 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_75160[(6)] = c__2706__auto__);

return statearr_75160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_75237){
var state_val_75238 = (state_75237[(1)]);
if((state_val_75238 === (7))){
var inst_75197 = (state_75237[(2)]);
var inst_75198 = fluree.db.util.async.throw_err(inst_75197);
var state_75237__$1 = state_75237;
var statearr_75239_75265 = state_75237__$1;
(statearr_75239_75265[(2)] = inst_75198);

(statearr_75239_75265[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (1))){
var inst_75174 = cljs.core.volatile_BANG_((0));
var inst_75175 = cljs.core.PersistentHashMap.EMPTY;
var inst_75176 = cljs.core.volatile_BANG_(inst_75175);
var inst_75177 = cljs.core.first(resp);
var inst_75178 = cljs.core.rest(resp);
var inst_75179 = cljs.core.PersistentVector.EMPTY;
var inst_75180 = inst_75174;
var inst_75181 = inst_75176;
var inst_75182 = inst_75177;
var inst_75183 = inst_75178;
var inst_75184 = inst_75179;
var state_75237__$1 = (function (){var statearr_75240 = state_75237;
(statearr_75240[(7)] = inst_75184);

(statearr_75240[(8)] = inst_75180);

(statearr_75240[(9)] = inst_75182);

(statearr_75240[(10)] = inst_75183);

(statearr_75240[(11)] = inst_75181);

return statearr_75240;
})();
var statearr_75241_75266 = state_75237__$1;
(statearr_75241_75266[(2)] = null);

(statearr_75241_75266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (4))){
var inst_75184 = (state_75237[(7)]);
var inst_75186 = (state_75237[(12)]);
var inst_75180 = (state_75237[(8)]);
var inst_75182 = (state_75237[(9)]);
var inst_75188 = (state_75237[(13)]);
var inst_75183 = (state_75237[(10)]);
var inst_75181 = (state_75237[(11)]);
var inst_75192 = (function (){var fuel = inst_75180;
var cache = inst_75181;
var curr_block = inst_75182;
var rest_blocks = inst_75183;
var acc = inst_75184;
var flakes = inst_75186;
var asserted = inst_75188;
return (function (p1__75171_SHARP_){
return p1__75171_SHARP_.s;
});
})();
var inst_75193 = cljs.core.group_by(inst_75192,inst_75188);
var inst_75194 = cljs.core.vals(inst_75193);
var inst_75195 = fluree.db.api_js.format_flake_groups_pretty(db,inst_75181,inst_75180,inst_75194);
var state_75237__$1 = state_75237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75237__$1,(7),inst_75195);
} else {
if((state_val_75238 === (13))){
var inst_75225 = (state_75237[(14)]);
var state_75237__$1 = state_75237;
var statearr_75242_75267 = state_75237__$1;
(statearr_75242_75267[(2)] = inst_75225);

(statearr_75242_75267[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (6))){
var inst_75203 = (state_75237[(15)]);
var inst_75184 = (state_75237[(7)]);
var inst_75186 = (state_75237[(12)]);
var inst_75180 = (state_75237[(8)]);
var inst_75182 = (state_75237[(9)]);
var inst_75188 = (state_75237[(13)]);
var inst_75183 = (state_75237[(10)]);
var inst_75181 = (state_75237[(11)]);
var inst_75201 = (state_75237[(16)]);
var inst_75201__$1 = (state_75237[(2)]);
var inst_75202 = (function (){var fuel = inst_75180;
var cache = inst_75181;
var curr_block = inst_75182;
var rest_blocks = inst_75183;
var acc = inst_75184;
var flakes = inst_75186;
var asserted = inst_75188;
var asserted_SINGLEQUOTE_ = inst_75201__$1;
return (function (p1__75172_SHARP_){
return p1__75172_SHARP_.op === false;
});
})();
var inst_75203__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_75202,inst_75186);
var inst_75204 = cljs.core.empty_QMARK_(inst_75203__$1);
var inst_75205 = (!(inst_75204));
var state_75237__$1 = (function (){var statearr_75245 = state_75237;
(statearr_75245[(15)] = inst_75203__$1);

(statearr_75245[(16)] = inst_75201__$1);

return statearr_75245;
})();
if(inst_75205){
var statearr_75246_75268 = state_75237__$1;
(statearr_75246_75268[(1)] = (8));

} else {
var statearr_75247_75269 = state_75237__$1;
(statearr_75247_75269[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (3))){
var inst_75235 = (state_75237[(2)]);
var state_75237__$1 = state_75237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75237__$1,inst_75235);
} else {
if((state_val_75238 === (12))){
var inst_75225 = (state_75237[(14)]);
var inst_75180 = (state_75237[(8)]);
var inst_75183 = (state_75237[(10)]);
var inst_75181 = (state_75237[(11)]);
var inst_75228 = cljs.core.first(inst_75183);
var inst_75229 = cljs.core.rest(inst_75183);
var tmp75243 = inst_75180;
var tmp75244 = inst_75181;
var inst_75180__$1 = tmp75243;
var inst_75181__$1 = tmp75244;
var inst_75182 = inst_75228;
var inst_75183__$1 = inst_75229;
var inst_75184 = inst_75225;
var state_75237__$1 = (function (){var statearr_75248 = state_75237;
(statearr_75248[(7)] = inst_75184);

(statearr_75248[(8)] = inst_75180__$1);

(statearr_75248[(9)] = inst_75182);

(statearr_75248[(10)] = inst_75183__$1);

(statearr_75248[(11)] = inst_75181__$1);

return statearr_75248;
})();
var statearr_75249_75270 = state_75237__$1;
(statearr_75249_75270[(2)] = null);

(statearr_75249_75270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (2))){
var inst_75184 = (state_75237[(7)]);
var inst_75186 = (state_75237[(12)]);
var inst_75180 = (state_75237[(8)]);
var inst_75182 = (state_75237[(9)]);
var inst_75188 = (state_75237[(13)]);
var inst_75183 = (state_75237[(10)]);
var inst_75181 = (state_75237[(11)]);
var inst_75186__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_75182);
var inst_75187 = (function (){var fuel = inst_75180;
var cache = inst_75181;
var curr_block = inst_75182;
var rest_blocks = inst_75183;
var acc = inst_75184;
var flakes = inst_75186__$1;
return (function (p1__75170_SHARP_){
return p1__75170_SHARP_.op;
});
})();
var inst_75188__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_75187,inst_75186__$1);
var inst_75189 = cljs.core.empty_QMARK_(inst_75188__$1);
var inst_75190 = (!(inst_75189));
var state_75237__$1 = (function (){var statearr_75250 = state_75237;
(statearr_75250[(12)] = inst_75186__$1);

(statearr_75250[(13)] = inst_75188__$1);

return statearr_75250;
})();
if(inst_75190){
var statearr_75251_75271 = state_75237__$1;
(statearr_75251_75271[(1)] = (4));

} else {
var statearr_75252_75272 = state_75237__$1;
(statearr_75252_75272[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (11))){
var inst_75213 = (state_75237[(2)]);
var inst_75214 = fluree.db.util.async.throw_err(inst_75213);
var state_75237__$1 = state_75237;
var statearr_75253_75273 = state_75237__$1;
(statearr_75253_75273[(2)] = inst_75214);

(statearr_75253_75273[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (9))){
var state_75237__$1 = state_75237;
var statearr_75254_75274 = state_75237__$1;
(statearr_75254_75274[(2)] = null);

(statearr_75254_75274[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (5))){
var state_75237__$1 = state_75237;
var statearr_75255_75275 = state_75237__$1;
(statearr_75255_75275[(2)] = null);

(statearr_75255_75275[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (14))){
var inst_75233 = (state_75237[(2)]);
var state_75237__$1 = state_75237;
var statearr_75256_75276 = state_75237__$1;
(statearr_75256_75276[(2)] = inst_75233);

(statearr_75256_75276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (10))){
var inst_75184 = (state_75237[(7)]);
var inst_75182 = (state_75237[(9)]);
var inst_75183 = (state_75237[(10)]);
var inst_75201 = (state_75237[(16)]);
var inst_75217 = (state_75237[(2)]);
var inst_75218 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_75219 = [inst_75201,inst_75217];
var inst_75220 = cljs.core.PersistentHashMap.fromArrays(inst_75218,inst_75219);
var inst_75221 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75182,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_75220);
var inst_75222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75223 = [inst_75221];
var inst_75224 = (new cljs.core.PersistentVector(null,1,(5),inst_75222,inst_75223,null));
var inst_75225 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_75184,inst_75224);
var inst_75226 = cljs.core.first(inst_75183);
var state_75237__$1 = (function (){var statearr_75257 = state_75237;
(statearr_75257[(14)] = inst_75225);

return statearr_75257;
})();
if(cljs.core.truth_(inst_75226)){
var statearr_75258_75277 = state_75237__$1;
(statearr_75258_75277[(1)] = (12));

} else {
var statearr_75259_75278 = state_75237__$1;
(statearr_75259_75278[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75238 === (8))){
var inst_75203 = (state_75237[(15)]);
var inst_75184 = (state_75237[(7)]);
var inst_75186 = (state_75237[(12)]);
var inst_75180 = (state_75237[(8)]);
var inst_75182 = (state_75237[(9)]);
var inst_75188 = (state_75237[(13)]);
var inst_75183 = (state_75237[(10)]);
var inst_75181 = (state_75237[(11)]);
var inst_75201 = (state_75237[(16)]);
var inst_75207 = (function (){var flakes = inst_75186;
var rest_blocks = inst_75183;
var curr_block = inst_75182;
var asserted_SINGLEQUOTE_ = inst_75201;
var acc = inst_75184;
var fuel = inst_75180;
var cache = inst_75181;
var retracted = inst_75203;
var asserted = inst_75188;
return (function (p1__75173_SHARP_){
return p1__75173_SHARP_.s;
});
})();
var inst_75208 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_75203);
var inst_75209 = cljs.core.group_by(inst_75207,inst_75208);
var inst_75210 = cljs.core.vals(inst_75209);
var inst_75211 = fluree.db.api_js.format_flake_groups_pretty(db,inst_75181,inst_75180,inst_75210);
var state_75237__$1 = state_75237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75237__$1,(11),inst_75211);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_75260 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75260[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__);

(statearr_75260[(1)] = (1));

return statearr_75260;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1 = (function (state_75237){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_75237);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e75261){var ex__2687__auto__ = e75261;
var statearr_75262_75279 = state_75237;
(statearr_75262_75279[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_75237[(4)]))){
var statearr_75263_75280 = state_75237;
(statearr_75263_75280[(1)] = cljs.core.first((state_75237[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75281 = state_75237;
state_75237 = G__75281;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__ = function(state_75237){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1.call(this,state_75237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_75264 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_75264[(6)] = c__2706__auto__);

return statearr_75264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_75381){
var state_val_75382 = (state_75381[(1)]);
if((state_val_75382 === (7))){
var inst_75353 = (state_75381[(7)]);
var inst_75346 = (state_75381[(8)]);
var inst_75352 = cljs.core.seq(inst_75346);
var inst_75353__$1 = cljs.core.first(inst_75352);
var inst_75354 = cljs.core.next(inst_75352);
var state_75381__$1 = (function (){var statearr_75383 = state_75381;
(statearr_75383[(7)] = inst_75353__$1);

(statearr_75383[(9)] = inst_75354);

return statearr_75383;
})();
if(cljs.core.truth_(inst_75353__$1)){
var statearr_75384_75421 = state_75381__$1;
(statearr_75384_75421[(1)] = (9));

} else {
var statearr_75385_75422 = state_75381__$1;
(statearr_75385_75422[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75382 === (1))){
var state_75381__$1 = state_75381;
var statearr_75386_75423 = state_75381__$1;
(statearr_75386_75423[(2)] = null);

(statearr_75386_75423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75382 === (4))){
var inst_75283 = (state_75381[(2)]);
var state_75381__$1 = state_75381;
var statearr_75387_75424 = state_75381__$1;
(statearr_75387_75424[(2)] = inst_75283);

(statearr_75387_75424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75382 === (6))){
var inst_75332 = (state_75381[(2)]);
var inst_75333 = fluree.db.util.async.throw_err(inst_75332);
var inst_75341 = resp;
var inst_75342 = cljs.core.seq(inst_75341);
var inst_75343 = cljs.core.first(inst_75342);
var inst_75344 = cljs.core.next(inst_75342);
var inst_75345 = cljs.core.PersistentHashMap.EMPTY;
var inst_75346 = inst_75341;
var inst_75347 = inst_75345;
var state_75381__$1 = (function (){var statearr_75388 = state_75381;
(statearr_75388[(8)] = inst_75346);

(statearr_75388[(10)] = inst_75343);

(statearr_75388[(11)] = inst_75347);

(statearr_75388[(12)] = inst_75344);

(statearr_75388[(13)] = inst_75333);

return statearr_75388;
})();
var statearr_75389_75425 = state_75381__$1;
(statearr_75389_75425[(2)] = null);

(statearr_75389_75425[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75382 === (3))){
var inst_75379 = (state_75381[(2)]);
var state_75381__$1 = state_75381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75381__$1,inst_75379);
} else {
if((state_val_75382 === (2))){
var _ = (function (){var statearr_75390 = state_75381;
(statearr_75390[(4)] = cljs.core.cons((5),(state_75381[(4)])));

return statearr_75390;
})();
var inst_75289 = (function (){return (function (p1__75282_SHARP_){
return p1__75282_SHARP_.t;
});
})();
var inst_75290 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_75289,resp);
var inst_75291 = cljs.core.set(inst_75290);
var inst_75328 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_75329 = (function (){var ts = inst_75291;
var c__2706__auto____$1 = inst_75328;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_75326){
var state_val_75327 = (state_75326[(1)]);
if((state_val_75327 === (1))){
var inst_75299 = ts;
var inst_75300 = cljs.core.seq(inst_75299);
var inst_75301 = cljs.core.first(inst_75300);
var inst_75302 = cljs.core.next(inst_75300);
var inst_75303 = cljs.core.PersistentHashMap.EMPTY;
var inst_75304 = inst_75299;
var inst_75305 = inst_75303;
var state_75326__$1 = (function (){var statearr_75391 = state_75326;
(statearr_75391[(7)] = inst_75302);

(statearr_75391[(8)] = inst_75301);

(statearr_75391[(9)] = inst_75304);

(statearr_75391[(10)] = inst_75305);

return statearr_75391;
})();
var statearr_75392_75426 = state_75326__$1;
(statearr_75392_75426[(2)] = null);

(statearr_75392_75426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75327 === (2))){
var inst_75304 = (state_75326[(9)]);
var inst_75311 = (state_75326[(11)]);
var inst_75310 = cljs.core.seq(inst_75304);
var inst_75311__$1 = cljs.core.first(inst_75310);
var inst_75312 = cljs.core.next(inst_75310);
var state_75326__$1 = (function (){var statearr_75393 = state_75326;
(statearr_75393[(12)] = inst_75312);

(statearr_75393[(11)] = inst_75311__$1);

return statearr_75393;
})();
if(cljs.core.truth_(inst_75311__$1)){
var statearr_75394_75427 = state_75326__$1;
(statearr_75394_75427[(1)] = (4));

} else {
var statearr_75395_75428 = state_75326__$1;
(statearr_75395_75428[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75327 === (3))){
var inst_75324 = (state_75326[(2)]);
var state_75326__$1 = state_75326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75326__$1,inst_75324);
} else {
if((state_val_75327 === (4))){
var inst_75311 = (state_75326[(11)]);
var inst_75314 = fluree.db.time_travel.non_border_t_to_block(db,inst_75311);
var state_75326__$1 = state_75326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75326__$1,(7),inst_75314);
} else {
if((state_val_75327 === (5))){
var inst_75305 = (state_75326[(10)]);
var state_75326__$1 = state_75326;
var statearr_75396_75429 = state_75326__$1;
(statearr_75396_75429[(2)] = inst_75305);

(statearr_75396_75429[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75327 === (6))){
var inst_75322 = (state_75326[(2)]);
var state_75326__$1 = state_75326;
var statearr_75397_75430 = state_75326__$1;
(statearr_75397_75430[(2)] = inst_75322);

(statearr_75397_75430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75327 === (7))){
var inst_75312 = (state_75326[(12)]);
var inst_75305 = (state_75326[(10)]);
var inst_75311 = (state_75326[(11)]);
var inst_75316 = (state_75326[(2)]);
var inst_75317 = fluree.db.util.async.throw_err(inst_75316);
var inst_75318 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75305,inst_75311,inst_75317);
var inst_75304 = inst_75312;
var inst_75305__$1 = inst_75318;
var state_75326__$1 = (function (){var statearr_75398 = state_75326;
(statearr_75398[(9)] = inst_75304);

(statearr_75398[(10)] = inst_75305__$1);

return statearr_75398;
})();
var statearr_75399_75431 = state_75326__$1;
(statearr_75399_75431[(2)] = null);

(statearr_75399_75431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_75400 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75400[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__);

(statearr_75400[(1)] = (1));

return statearr_75400;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1 = (function (state_75326){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_75326);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e75401){var ex__2687__auto__ = e75401;
var statearr_75402_75432 = state_75326;
(statearr_75402_75432[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_75326[(4)]))){
var statearr_75403_75433 = state_75326;
(statearr_75403_75433[(1)] = cljs.core.first((state_75326[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75434 = state_75326;
state_75326 = G__75434;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = function(state_75326){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1.call(this,state_75326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_75404 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_75404[(6)] = c__2706__auto____$1);

return statearr_75404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_75330 = cljs.core.async.impl.dispatch.run(inst_75329);
var state_75381__$1 = (function (){var statearr_75405 = state_75381;
(statearr_75405[(14)] = inst_75330);

return statearr_75405;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75381__$1,(6),inst_75328);
} else {
if((state_val_75382 === (11))){
var inst_75373 = (state_75381[(2)]);
var state_75381__$1 = state_75381;
var statearr_75407_75435 = state_75381__$1;
(statearr_75407_75435[(2)] = inst_75373);

(statearr_75407_75435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75382 === (9))){
var inst_75353 = (state_75381[(7)]);
var inst_75354 = (state_75381[(9)]);
var inst_75347 = (state_75381[(11)]);
var inst_75333 = (state_75381[(13)]);
var inst_75356 = inst_75353.t;
var inst_75357 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75333,inst_75356);
var inst_75358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75359 = [inst_75357,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_75360 = (new cljs.core.PersistentVector(null,2,(5),inst_75358,inst_75359,null));
var inst_75361 = cljs.core.assoc_in(inst_75347,inst_75360,inst_75357);
var inst_75362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75363 = [inst_75357,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_75364 = (new cljs.core.PersistentVector(null,2,(5),inst_75362,inst_75363,null));
var inst_75365 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_75361,inst_75364,cljs.core.conj,inst_75353);
var inst_75366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75367 = [inst_75357,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_75368 = (new cljs.core.PersistentVector(null,2,(5),inst_75366,inst_75367,null));
var inst_75369 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_75365,inst_75368,fluree.db.api_js.min_safe,inst_75356);
var inst_75346 = inst_75354;
var inst_75347__$1 = inst_75369;
var state_75381__$1 = (function (){var statearr_75408 = state_75381;
(statearr_75408[(8)] = inst_75346);

(statearr_75408[(11)] = inst_75347__$1);

return statearr_75408;
})();
var statearr_75409_75436 = state_75381__$1;
(statearr_75409_75436[(2)] = null);

(statearr_75409_75436[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75382 === (5))){
var _ = (function (){var statearr_75410 = state_75381;
(statearr_75410[(4)] = cljs.core.rest((state_75381[(4)])));

return statearr_75410;
})();
var state_75381__$1 = state_75381;
var ex75406 = (state_75381__$1[(2)]);
var statearr_75411_75437 = state_75381__$1;
(statearr_75411_75437[(5)] = ex75406);


if((ex75406 instanceof Error)){
var statearr_75412_75438 = state_75381__$1;
(statearr_75412_75438[(1)] = (4));

(statearr_75412_75438[(5)] = null);

} else {
throw ex75406;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75382 === (10))){
var inst_75347 = (state_75381[(11)]);
var state_75381__$1 = state_75381;
var statearr_75413_75439 = state_75381__$1;
(statearr_75413_75439[(2)] = inst_75347);

(statearr_75413_75439[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75382 === (8))){
var inst_75375 = (state_75381[(2)]);
var inst_75376 = cljs.core.vals(inst_75375);
var _ = (function (){var statearr_75414 = state_75381;
(statearr_75414[(4)] = cljs.core.rest((state_75381[(4)])));

return statearr_75414;
})();
var state_75381__$1 = state_75381;
var statearr_75415_75440 = state_75381__$1;
(statearr_75415_75440[(2)] = inst_75376);

(statearr_75415_75440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_75416 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75416[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__);

(statearr_75416[(1)] = (1));

return statearr_75416;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1 = (function (state_75381){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_75381);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e75417){var ex__2687__auto__ = e75417;
var statearr_75418_75441 = state_75381;
(statearr_75418_75441[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_75381[(4)]))){
var statearr_75419_75442 = state_75381;
(statearr_75419_75442[(1)] = cljs.core.first((state_75381[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75443 = state_75381;
state_75381 = G__75443;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = function(state_75381){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1.call(this,state_75381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_75420 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_75420[(6)] = c__2706__auto__);

return statearr_75420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_75591){
var state_val_75592 = (state_75591[(1)]);
if((state_val_75592 === (7))){
var inst_75471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75472 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75473 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75474 = [inst_75472,inst_75473];
var inst_75475 = (new cljs.core.PersistentVector(null,2,(5),inst_75471,inst_75474,null));
var state_75591__$1 = state_75591;
var statearr_75593_75664 = state_75591__$1;
(statearr_75593_75664[(2)] = inst_75475);

(statearr_75593_75664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (20))){
var inst_75501 = (state_75591[(7)]);
var state_75591__$1 = state_75591;
var statearr_75594_75665 = state_75591__$1;
(statearr_75594_75665[(2)] = inst_75501);

(statearr_75594_75665[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (27))){
var state_75591__$1 = state_75591;
var statearr_75595_75666 = state_75591__$1;
(statearr_75595_75666[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (1))){
var state_75591__$1 = state_75591;
var statearr_75597_75667 = state_75591__$1;
(statearr_75597_75667[(2)] = null);

(statearr_75597_75667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (24))){
var inst_75500 = (state_75591[(8)]);
var state_75591__$1 = state_75591;
if(cljs.core.truth_(inst_75500)){
var statearr_75598_75668 = state_75591__$1;
(statearr_75598_75668[(1)] = (26));

} else {
var statearr_75599_75669 = state_75591__$1;
(statearr_75599_75669[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (39))){
var inst_75546 = (state_75591[(9)]);
var inst_75547 = (state_75591[(10)]);
var inst_75572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75573 = [inst_75546,inst_75547];
var inst_75574 = (new cljs.core.PersistentVector(null,2,(5),inst_75572,inst_75573,null));
var state_75591__$1 = state_75591;
var statearr_75600_75670 = state_75591__$1;
(statearr_75600_75670[(2)] = inst_75574);

(statearr_75600_75670[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (4))){
var inst_75444 = (state_75591[(2)]);
var inst_75445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75446 = [inst_75444];
var inst_75447 = (new cljs.core.PersistentVector(null,1,(5),inst_75445,inst_75446,null));
var inst_75448 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75447);
var inst_75449 = cljs.core.ex_data(inst_75444);
var inst_75450 = cljs.core.ex_message(inst_75444);
var inst_75451 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75449,new cljs.core.Keyword(null,"message","message",-406056002),inst_75450);
var state_75591__$1 = (function (){var statearr_75601 = state_75591;
(statearr_75601[(11)] = inst_75448);

return statearr_75601;
})();
var statearr_75602_75671 = state_75591__$1;
(statearr_75602_75671[(2)] = inst_75451);

(statearr_75602_75671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (15))){
var inst_75485 = (state_75591[(12)]);
var inst_75480 = (state_75591[(13)]);
var inst_75494 = (state_75591[(2)]);
var inst_75495 = [inst_75485,inst_75494];
var inst_75496 = (new cljs.core.PersistentVector(null,2,(5),inst_75480,inst_75495,null));
var state_75591__$1 = state_75591;
var statearr_75603_75672 = state_75591__$1;
(statearr_75603_75672[(2)] = inst_75496);

(statearr_75603_75672[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (21))){
var inst_75500 = (state_75591[(8)]);
var state_75591__$1 = state_75591;
var statearr_75604_75673 = state_75591__$1;
(statearr_75604_75673[(2)] = inst_75500);

(statearr_75604_75673[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (31))){
var inst_75541 = (state_75591[(2)]);
var state_75591__$1 = state_75591;
var statearr_75605_75674 = state_75591__$1;
(statearr_75605_75674[(2)] = inst_75541);

(statearr_75605_75674[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (32))){
var inst_75547 = (state_75591[(10)]);
var inst_75550 = cljs.core.pos_int_QMARK_(inst_75547);
var state_75591__$1 = state_75591;
var statearr_75606_75675 = state_75591__$1;
(statearr_75606_75675[(2)] = inst_75550);

(statearr_75606_75675[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (40))){
var inst_75578 = (state_75591[(14)]);
var inst_75502 = (state_75591[(15)]);
var inst_75576 = (state_75591[(2)]);
var inst_75577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75576,(0),null);
var inst_75578__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75576,(1),null);
var inst_75579 = (inst_75578__$1 > inst_75502);
var state_75591__$1 = (function (){var statearr_75607 = state_75591;
(statearr_75607[(14)] = inst_75578__$1);

(statearr_75607[(16)] = inst_75577);

return statearr_75607;
})();
if(cljs.core.truth_(inst_75579)){
var statearr_75608_75676 = state_75591__$1;
(statearr_75608_75676[(1)] = (41));

} else {
var statearr_75609_75677 = state_75591__$1;
(statearr_75609_75677[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (33))){
var inst_75548 = (state_75591[(17)]);
var state_75591__$1 = state_75591;
var statearr_75610_75678 = state_75591__$1;
(statearr_75610_75678[(2)] = inst_75548);

(statearr_75610_75678[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (13))){
var inst_75486 = (state_75591[(18)]);
var inst_75488 = fluree.db.time_travel.block_to_int_format(db,inst_75486);
var state_75591__$1 = state_75591;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75591__$1,(16),inst_75488);
} else {
if((state_val_75592 === (22))){
var inst_75519 = (state_75591[(2)]);
var state_75591__$1 = state_75591;
if(cljs.core.truth_(inst_75519)){
var statearr_75611_75679 = state_75591__$1;
(statearr_75611_75679[(1)] = (23));

} else {
var statearr_75612_75680 = state_75591__$1;
(statearr_75612_75680[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (36))){
var state_75591__$1 = state_75591;
var statearr_75613_75681 = state_75591__$1;
(statearr_75613_75681[(2)] = null);

(statearr_75613_75681[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (41))){
var inst_75502 = (state_75591[(15)]);
var state_75591__$1 = state_75591;
var statearr_75614_75682 = state_75591__$1;
(statearr_75614_75682[(2)] = inst_75502);

(statearr_75614_75682[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (43))){
var inst_75577 = (state_75591[(16)]);
var inst_75583 = (state_75591[(2)]);
var inst_75584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75585 = [inst_75577,inst_75583];
var inst_75586 = (new cljs.core.PersistentVector(null,2,(5),inst_75584,inst_75585,null));
var _ = (function (){var statearr_75615 = state_75591;
(statearr_75615[(4)] = cljs.core.rest((state_75591[(4)])));

return statearr_75615;
})();
var state_75591__$1 = state_75591;
var statearr_75616_75683 = state_75591__$1;
(statearr_75616_75683[(2)] = inst_75586);

(statearr_75616_75683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (29))){
var inst_75477 = (state_75591[(19)]);
var inst_75532 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75477], 0));
var inst_75533 = ["Invalid block range provided: ",inst_75532].join('');
var inst_75534 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75535 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75536 = cljs.core.PersistentHashMap.fromArrays(inst_75534,inst_75535);
var inst_75537 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75533,inst_75536);
var inst_75538 = (function(){throw inst_75537})();
var state_75591__$1 = state_75591;
var statearr_75617_75684 = state_75591__$1;
(statearr_75617_75684[(2)] = inst_75538);

(statearr_75617_75684[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (6))){
var inst_75469 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_75591__$1 = state_75591;
var statearr_75618_75685 = state_75591__$1;
(statearr_75618_75685[(2)] = inst_75469);

(statearr_75618_75685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (28))){
var inst_75543 = (state_75591[(2)]);
var state_75591__$1 = state_75591;
var statearr_75619_75686 = state_75591__$1;
(statearr_75619_75686[(2)] = inst_75543);

(statearr_75619_75686[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (25))){
var inst_75546 = (state_75591[(9)]);
var inst_75548 = (state_75591[(17)]);
var inst_75545 = (state_75591[(2)]);
var inst_75546__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75545,(0),null);
var inst_75547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75545,(1),null);
var inst_75548__$1 = cljs.core.pos_int_QMARK_(inst_75546__$1);
var state_75591__$1 = (function (){var statearr_75620 = state_75591;
(statearr_75620[(9)] = inst_75546__$1);

(statearr_75620[(17)] = inst_75548__$1);

(statearr_75620[(10)] = inst_75547);

return statearr_75620;
})();
if(inst_75548__$1){
var statearr_75621_75687 = state_75591__$1;
(statearr_75621_75687[(1)] = (32));

} else {
var statearr_75622_75688 = state_75591__$1;
(statearr_75622_75688[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (34))){
var inst_75553 = (state_75591[(2)]);
var inst_75554 = cljs.core.not(inst_75553);
var state_75591__$1 = state_75591;
if(inst_75554){
var statearr_75623_75689 = state_75591__$1;
(statearr_75623_75689[(1)] = (35));

} else {
var statearr_75624_75690 = state_75591__$1;
(statearr_75624_75690[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (17))){
var inst_75502 = (state_75591[(15)]);
var inst_75500 = (state_75591[(8)]);
var inst_75505 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75500], 0));
var inst_75506 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75502], 0));
var inst_75507 = ["Start block is out of range for this ledger. Start block provided: ",inst_75505,". Database block: ",inst_75506].join('');
var inst_75508 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75509 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75510 = cljs.core.PersistentHashMap.fromArrays(inst_75508,inst_75509);
var inst_75511 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75507,inst_75510);
var inst_75512 = (function(){throw inst_75511})();
var state_75591__$1 = state_75591;
var statearr_75625_75691 = state_75591__$1;
(statearr_75625_75691[(2)] = inst_75512);

(statearr_75625_75691[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (3))){
var inst_75589 = (state_75591[(2)]);
var state_75591__$1 = state_75591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75591__$1,inst_75589);
} else {
if((state_val_75592 === (12))){
var inst_75486 = (state_75591[(18)]);
var inst_75477 = (state_75591[(19)]);
var inst_75484 = (state_75591[(2)]);
var inst_75485 = fluree.db.util.async.throw_err(inst_75484);
var inst_75486__$1 = cljs.core.second(inst_75477);
var state_75591__$1 = (function (){var statearr_75626 = state_75591;
(statearr_75626[(12)] = inst_75485);

(statearr_75626[(18)] = inst_75486__$1);

return statearr_75626;
})();
if(cljs.core.truth_(inst_75486__$1)){
var statearr_75627_75692 = state_75591__$1;
(statearr_75627_75692[(1)] = (13));

} else {
var statearr_75628_75693 = state_75591__$1;
(statearr_75628_75693[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (2))){
var _ = (function (){var statearr_75629 = state_75591;
(statearr_75629[(4)] = cljs.core.cons((5),(state_75591[(4)])));

return statearr_75629;
})();
var inst_75466 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75467 = cljs.core.sequential_QMARK_(inst_75466);
var state_75591__$1 = state_75591;
if(inst_75467){
var statearr_75630_75694 = state_75591__$1;
(statearr_75630_75694[(1)] = (6));

} else {
var statearr_75631_75695 = state_75591__$1;
(statearr_75631_75695[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (23))){
var inst_75501 = (state_75591[(7)]);
var inst_75500 = (state_75591[(8)]);
var inst_75521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75522 = [inst_75500,inst_75501];
var inst_75523 = (new cljs.core.PersistentVector(null,2,(5),inst_75521,inst_75522,null));
var state_75591__$1 = state_75591;
var statearr_75632_75696 = state_75591__$1;
(statearr_75632_75696[(2)] = inst_75523);

(statearr_75632_75696[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (35))){
var inst_75477 = (state_75591[(19)]);
var inst_75556 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75477], 0));
var inst_75557 = ["Invalid block range provided: ",inst_75556].join('');
var inst_75558 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75559 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75560 = cljs.core.PersistentHashMap.fromArrays(inst_75558,inst_75559);
var inst_75561 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75557,inst_75560);
var inst_75562 = (function(){throw inst_75561})();
var state_75591__$1 = state_75591;
var statearr_75633_75697 = state_75591__$1;
(statearr_75633_75697[(2)] = inst_75562);

(statearr_75633_75697[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (19))){
var inst_75500 = (state_75591[(8)]);
var inst_75515 = (state_75591[(2)]);
var state_75591__$1 = (function (){var statearr_75634 = state_75591;
(statearr_75634[(20)] = inst_75515);

return statearr_75634;
})();
if(cljs.core.truth_(inst_75500)){
var statearr_75635_75698 = state_75591__$1;
(statearr_75635_75698[(1)] = (20));

} else {
var statearr_75636_75699 = state_75591__$1;
(statearr_75636_75699[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (11))){
var inst_75502 = (state_75591[(15)]);
var inst_75500 = (state_75591[(8)]);
var inst_75499 = (state_75591[(2)]);
var inst_75500__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75499,(0),null);
var inst_75501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75499,(1),null);
var inst_75502__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_75503 = (inst_75500__$1 > inst_75502__$1);
var state_75591__$1 = (function (){var statearr_75638 = state_75591;
(statearr_75638[(7)] = inst_75501);

(statearr_75638[(15)] = inst_75502__$1);

(statearr_75638[(8)] = inst_75500__$1);

return statearr_75638;
})();
if(cljs.core.truth_(inst_75503)){
var statearr_75639_75700 = state_75591__$1;
(statearr_75639_75700[(1)] = (17));

} else {
var statearr_75640_75701 = state_75591__$1;
(statearr_75640_75701[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (9))){
var inst_75477 = (state_75591[(19)]);
var inst_75480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75481 = cljs.core.first(inst_75477);
var inst_75482 = fluree.db.time_travel.block_to_int_format(db,inst_75481);
var state_75591__$1 = (function (){var statearr_75641 = state_75591;
(statearr_75641[(13)] = inst_75480);

return statearr_75641;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75591__$1,(12),inst_75482);
} else {
if((state_val_75592 === (5))){
var _ = (function (){var statearr_75642 = state_75591;
(statearr_75642[(4)] = cljs.core.rest((state_75591[(4)])));

return statearr_75642;
})();
var state_75591__$1 = state_75591;
var ex75637 = (state_75591__$1[(2)]);
var statearr_75643_75702 = state_75591__$1;
(statearr_75643_75702[(5)] = ex75637);


var statearr_75644_75703 = state_75591__$1;
(statearr_75644_75703[(1)] = (4));

(statearr_75644_75703[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (14))){
var state_75591__$1 = state_75591;
var statearr_75645_75704 = state_75591__$1;
(statearr_75645_75704[(2)] = null);

(statearr_75645_75704[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (26))){
var inst_75500 = (state_75591[(8)]);
var inst_75526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75527 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_75528 = [inst_75500,inst_75527];
var inst_75529 = (new cljs.core.PersistentVector(null,2,(5),inst_75526,inst_75528,null));
var state_75591__$1 = state_75591;
var statearr_75646_75705 = state_75591__$1;
(statearr_75646_75705[(2)] = inst_75529);

(statearr_75646_75705[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (16))){
var inst_75490 = (state_75591[(2)]);
var inst_75491 = fluree.db.util.async.throw_err(inst_75490);
var state_75591__$1 = state_75591;
var statearr_75647_75706 = state_75591__$1;
(statearr_75647_75706[(2)] = inst_75491);

(statearr_75647_75706[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (38))){
var inst_75546 = (state_75591[(9)]);
var inst_75547 = (state_75591[(10)]);
var inst_75568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75569 = [inst_75547,inst_75546];
var inst_75570 = (new cljs.core.PersistentVector(null,2,(5),inst_75568,inst_75569,null));
var state_75591__$1 = state_75591;
var statearr_75648_75707 = state_75591__$1;
(statearr_75648_75707[(2)] = inst_75570);

(statearr_75648_75707[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (30))){
var state_75591__$1 = state_75591;
var statearr_75649_75708 = state_75591__$1;
(statearr_75649_75708[(2)] = null);

(statearr_75649_75708[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (10))){
var inst_75477 = (state_75591[(19)]);
var state_75591__$1 = state_75591;
var statearr_75650_75709 = state_75591__$1;
(statearr_75650_75709[(2)] = inst_75477);

(statearr_75650_75709[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (18))){
var state_75591__$1 = state_75591;
var statearr_75651_75710 = state_75591__$1;
(statearr_75651_75710[(2)] = null);

(statearr_75651_75710[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (42))){
var inst_75578 = (state_75591[(14)]);
var state_75591__$1 = state_75591;
var statearr_75652_75711 = state_75591__$1;
(statearr_75652_75711[(2)] = inst_75578);

(statearr_75652_75711[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (37))){
var inst_75546 = (state_75591[(9)]);
var inst_75547 = (state_75591[(10)]);
var inst_75565 = (state_75591[(2)]);
var inst_75566 = (inst_75547 < inst_75546);
var state_75591__$1 = (function (){var statearr_75653 = state_75591;
(statearr_75653[(21)] = inst_75565);

return statearr_75653;
})();
if(cljs.core.truth_(inst_75566)){
var statearr_75654_75712 = state_75591__$1;
(statearr_75654_75712[(1)] = (38));

} else {
var statearr_75655_75713 = state_75591__$1;
(statearr_75655_75713[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (8))){
var inst_75477 = (state_75591[(19)]);
var inst_75477__$1 = (state_75591[(2)]);
var inst_75478 = cljs.core.some(cljs.core.string_QMARK_,inst_75477__$1);
var state_75591__$1 = (function (){var statearr_75656 = state_75591;
(statearr_75656[(19)] = inst_75477__$1);

return statearr_75656;
})();
if(cljs.core.truth_(inst_75478)){
var statearr_75657_75714 = state_75591__$1;
(statearr_75657_75714[(1)] = (9));

} else {
var statearr_75658_75715 = state_75591__$1;
(statearr_75658_75715[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0 = (function (){
var statearr_75659 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75659[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__);

(statearr_75659[(1)] = (1));

return statearr_75659;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1 = (function (state_75591){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_75591);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e75660){var ex__2687__auto__ = e75660;
var statearr_75661_75716 = state_75591;
(statearr_75661_75716[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_75591[(4)]))){
var statearr_75662_75717 = state_75591;
(statearr_75662_75717[(1)] = cljs.core.first((state_75591[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75718 = state_75591;
state_75591 = G__75718;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__ = function(state_75591){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1.call(this,state_75591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_75663 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_75663[(6)] = c__2706__auto__);

return statearr_75663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__75720 = arguments.length;
switch (G__75720) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_75814){
var state_val_75815 = (state_75814[(1)]);
if((state_val_75815 === (7))){
var inst_75746 = (state_75814[(7)]);
var inst_75749 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_75746);
var state_75814__$1 = state_75814;
var statearr_75816_75867 = state_75814__$1;
(statearr_75816_75867[(2)] = inst_75749);

(statearr_75816_75867[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (20))){
var inst_75785 = (state_75814[(8)]);
var inst_75788 = fluree.db.api_js.format_block_resp_pretty(db,inst_75785);
var state_75814__$1 = state_75814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75814__$1,(23),inst_75788);
} else {
if((state_val_75815 === (27))){
var inst_75794 = (state_75814[(9)]);
var inst_75800 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_75794);
var state_75814__$1 = state_75814;
var statearr_75817_75868 = state_75814__$1;
(statearr_75817_75868[(2)] = inst_75800);

(statearr_75817_75868[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (1))){
var state_75814__$1 = state_75814;
var statearr_75818_75869 = state_75814__$1;
(statearr_75818_75869[(2)] = null);

(statearr_75818_75869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (24))){
var inst_75794 = (state_75814[(9)]);
var inst_75797 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_75798 = cljs.core.sequential_QMARK_(inst_75794);
var state_75814__$1 = (function (){var statearr_75819 = state_75814;
(statearr_75819[(10)] = inst_75797);

return statearr_75819;
})();
if(inst_75798){
var statearr_75820_75870 = state_75814__$1;
(statearr_75820_75870[(1)] = (27));

} else {
var statearr_75821_75871 = state_75814__$1;
(statearr_75821_75871[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (4))){
var inst_75721 = (state_75814[(2)]);
var inst_75722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75723 = [inst_75721];
var inst_75724 = (new cljs.core.PersistentVector(null,1,(5),inst_75722,inst_75723,null));
var inst_75725 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75724);
var inst_75726 = cljs.core.ex_data(inst_75721);
var inst_75727 = cljs.core.ex_message(inst_75721);
var inst_75728 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75726,new cljs.core.Keyword(null,"message","message",-406056002),inst_75727);
var state_75814__$1 = (function (){var statearr_75822 = state_75814;
(statearr_75822[(11)] = inst_75725);

return statearr_75822;
})();
var statearr_75823_75872 = state_75814__$1;
(statearr_75823_75872[(2)] = inst_75728);

(statearr_75823_75872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (15))){
var inst_75746 = (state_75814[(7)]);
var inst_75759 = (state_75814[(2)]);
var inst_75760 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75759,inst_75746);
var inst_75761 = (function(){throw inst_75760})();
var state_75814__$1 = state_75814;
var statearr_75824_75873 = state_75814__$1;
(statearr_75824_75873[(2)] = inst_75761);

(statearr_75824_75873[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (21))){
var inst_75785 = (state_75814[(8)]);
var state_75814__$1 = state_75814;
var statearr_75825_75874 = state_75814__$1;
(statearr_75825_75874[(2)] = inst_75785);

(statearr_75825_75874[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (13))){
var inst_75754 = (state_75814[(12)]);
var state_75814__$1 = state_75814;
var statearr_75826_75875 = state_75814__$1;
(statearr_75826_75875[(2)] = inst_75754);

(statearr_75826_75875[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (22))){
var inst_75794 = (state_75814[(2)]);
var inst_75795 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_75814__$1 = (function (){var statearr_75827 = state_75814;
(statearr_75827[(9)] = inst_75794);

return statearr_75827;
})();
if(cljs.core.truth_(inst_75795)){
var statearr_75828_75876 = state_75814__$1;
(statearr_75828_75876[(1)] = (24));

} else {
var statearr_75829_75877 = state_75814__$1;
(statearr_75829_75877[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (29))){
var inst_75797 = (state_75814[(10)]);
var inst_75738 = (state_75814[(13)]);
var inst_75803 = (state_75814[(2)]);
var inst_75804 = fluree.db.util.core.response_time_formatted(inst_75738);
var inst_75805 = [(200),inst_75803,(100),inst_75804];
var inst_75806 = cljs.core.PersistentHashMap.fromArrays(inst_75797,inst_75805);
var state_75814__$1 = state_75814;
var statearr_75830_75878 = state_75814__$1;
(statearr_75830_75878[(2)] = inst_75806);

(statearr_75830_75878[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (6))){
var inst_75747 = (state_75814[(14)]);
var inst_75746 = (state_75814[(7)]);
var inst_75745 = (state_75814[(2)]);
var inst_75746__$1 = fluree.db.util.async.throw_err(inst_75745);
var inst_75747__$1 = cljs.core.map_QMARK_(inst_75746__$1);
var state_75814__$1 = (function (){var statearr_75831 = state_75814;
(statearr_75831[(14)] = inst_75747__$1);

(statearr_75831[(7)] = inst_75746__$1);

return statearr_75831;
})();
if(inst_75747__$1){
var statearr_75832_75879 = state_75814__$1;
(statearr_75832_75879[(1)] = (7));

} else {
var statearr_75833_75880 = state_75814__$1;
(statearr_75833_75880[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (28))){
var inst_75794 = (state_75814[(9)]);
var state_75814__$1 = state_75814;
var statearr_75834_75881 = state_75814__$1;
(statearr_75834_75881[(2)] = inst_75794);

(statearr_75834_75881[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (25))){
var inst_75794 = (state_75814[(9)]);
var state_75814__$1 = state_75814;
var statearr_75835_75882 = state_75814__$1;
(statearr_75835_75882[(2)] = inst_75794);

(statearr_75835_75882[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (17))){
var inst_75777 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_75778 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_75777].join('');
var inst_75779 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75780 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75781 = cljs.core.PersistentHashMap.fromArrays(inst_75779,inst_75780);
var inst_75782 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75778,inst_75781);
var inst_75783 = (function(){throw inst_75782})();
var state_75814__$1 = state_75814;
var statearr_75836_75883 = state_75814__$1;
(statearr_75836_75883[(2)] = inst_75783);

(statearr_75836_75883[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (3))){
var inst_75812 = (state_75814[(2)]);
var state_75814__$1 = state_75814;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75814__$1,inst_75812);
} else {
if((state_val_75815 === (12))){
var inst_75746 = (state_75814[(7)]);
var inst_75764 = (state_75814[(2)]);
var inst_75765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75746,(0),null);
var inst_75766 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75746,(1),null);
var inst_75767 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_75768 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_75769 = cljs.core.keys(inst_75768);
var inst_75770 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75767,inst_75769);
var state_75814__$1 = (function (){var statearr_75837 = state_75814;
(statearr_75837[(15)] = inst_75765);

(statearr_75837[(16)] = inst_75764);

(statearr_75837[(17)] = inst_75766);

return statearr_75837;
})();
if(inst_75770){
var statearr_75838_75884 = state_75814__$1;
(statearr_75838_75884[(1)] = (16));

} else {
var statearr_75839_75885 = state_75814__$1;
(statearr_75839_75885[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (2))){
var _ = (function (){var statearr_75840 = state_75814;
(statearr_75840[(4)] = cljs.core.cons((5),(state_75814[(4)])));

return statearr_75840;
})();
var inst_75738 = fluree.db.util.core.current_time_millis();
var inst_75739 = db;
var inst_75740 = cljs.core.__destructure_map(inst_75739);
var inst_75741 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75740,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_75742 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75740,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_75743 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_75814__$1 = (function (){var statearr_75841 = state_75814;
(statearr_75841[(18)] = inst_75741);

(statearr_75841[(19)] = inst_75742);

(statearr_75841[(13)] = inst_75738);

return statearr_75841;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75814__$1,(6),inst_75743);
} else {
if((state_val_75815 === (23))){
var inst_75790 = (state_75814[(2)]);
var inst_75791 = fluree.db.util.async.throw_err(inst_75790);
var state_75814__$1 = state_75814;
var statearr_75842_75886 = state_75814__$1;
(statearr_75842_75886[(2)] = inst_75791);

(statearr_75842_75886[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (19))){
var inst_75774 = (state_75814[(2)]);
var inst_75775 = fluree.db.util.async.throw_err(inst_75774);
var state_75814__$1 = state_75814;
var statearr_75843_75887 = state_75814__$1;
(statearr_75843_75887[(2)] = inst_75775);

(statearr_75843_75887[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (11))){
var state_75814__$1 = state_75814;
var statearr_75845_75888 = state_75814__$1;
(statearr_75845_75888[(2)] = null);

(statearr_75845_75888[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (9))){
var inst_75752 = (state_75814[(2)]);
var state_75814__$1 = state_75814;
if(cljs.core.truth_(inst_75752)){
var statearr_75846_75889 = state_75814__$1;
(statearr_75846_75889[(1)] = (10));

} else {
var statearr_75847_75890 = state_75814__$1;
(statearr_75847_75890[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (5))){
var _ = (function (){var statearr_75848 = state_75814;
(statearr_75848[(4)] = cljs.core.rest((state_75814[(4)])));

return statearr_75848;
})();
var state_75814__$1 = state_75814;
var ex75844 = (state_75814__$1[(2)]);
var statearr_75849_75891 = state_75814__$1;
(statearr_75849_75891[(5)] = ex75844);


var statearr_75850_75892 = state_75814__$1;
(statearr_75850_75892[(1)] = (4));

(statearr_75850_75892[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (14))){
var inst_75741 = (state_75814[(18)]);
var inst_75742 = (state_75814[(19)]);
var inst_75757 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75741),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75742)].join('');
var state_75814__$1 = state_75814;
var statearr_75851_75893 = state_75814__$1;
(statearr_75851_75893[(2)] = inst_75757);

(statearr_75851_75893[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (26))){
var inst_75809 = (state_75814[(2)]);
var _ = (function (){var statearr_75852 = state_75814;
(statearr_75852[(4)] = cljs.core.rest((state_75814[(4)])));

return statearr_75852;
})();
var state_75814__$1 = state_75814;
var statearr_75853_75894 = state_75814__$1;
(statearr_75853_75894[(2)] = inst_75809);

(statearr_75853_75894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (16))){
var inst_75765 = (state_75814[(15)]);
var inst_75766 = (state_75814[(17)]);
var inst_75772 = fluree.db.query.block.block_range(db,inst_75765,inst_75766,opts);
var state_75814__$1 = state_75814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75814__$1,(19),inst_75772);
} else {
if((state_val_75815 === (10))){
var inst_75754 = (state_75814[(12)]);
var inst_75746 = (state_75814[(7)]);
var inst_75754__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_75746);
var state_75814__$1 = (function (){var statearr_75854 = state_75814;
(statearr_75854[(12)] = inst_75754__$1);

return statearr_75854;
})();
if(cljs.core.truth_(inst_75754__$1)){
var statearr_75855_75895 = state_75814__$1;
(statearr_75855_75895[(1)] = (13));

} else {
var statearr_75856_75896 = state_75814__$1;
(statearr_75856_75896[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (18))){
var inst_75785 = (state_75814[(2)]);
var inst_75786 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_75814__$1 = (function (){var statearr_75857 = state_75814;
(statearr_75857[(8)] = inst_75785);

return statearr_75857;
})();
if(cljs.core.truth_(inst_75786)){
var statearr_75858_75897 = state_75814__$1;
(statearr_75858_75897[(1)] = (20));

} else {
var statearr_75859_75898 = state_75814__$1;
(statearr_75859_75898[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75815 === (8))){
var inst_75747 = (state_75814[(14)]);
var state_75814__$1 = state_75814;
var statearr_75860_75899 = state_75814__$1;
(statearr_75860_75899[(2)] = inst_75747);

(statearr_75860_75899[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_75861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75861[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_75861[(1)] = (1));

return statearr_75861;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_75814){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_75814);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e75862){var ex__2687__auto__ = e75862;
var statearr_75863_75900 = state_75814;
(statearr_75863_75900[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_75814[(4)]))){
var statearr_75864_75901 = state_75814;
(statearr_75864_75901[(1)] = cljs.core.first((state_75814[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75902 = state_75814;
state_75814 = G__75902;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_75814){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_75814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_75865 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_75865[(6)] = c__2706__auto__);

return statearr_75865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__75904 = arguments.length;
switch (G__75904) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_76099){
var state_val_76100 = (state_76099[(1)]);
if((state_val_76100 === (62))){
var inst_76097 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76099__$1,inst_76097);
} else {
if((state_val_76100 === (7))){
var inst_75925 = (state_76099[(7)]);
var inst_75935 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_75925);
var state_76099__$1 = state_76099;
var statearr_76101_76192 = state_76099__$1;
(statearr_76101_76192[(2)] = inst_75935);

(statearr_76101_76192[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (59))){
var inst_76085 = (state_76099[(2)]);
var inst_76086 = fluree.db.util.async.throw_err(inst_76085);
var state_76099__$1 = state_76099;
var statearr_76102_76193 = state_76099__$1;
(statearr_76102_76193[(2)] = inst_76086);

(statearr_76102_76193[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (20))){
var inst_76001 = (state_76099[(8)]);
var inst_75993 = (state_76099[(9)]);
var inst_75993__$1 = (state_76099[(2)]);
var inst_75994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75995 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75993__$1,(0));
var inst_75996 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75993__$1,(1));
var inst_75997 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75993__$1,(2));
var inst_75998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75993__$1,(3));
var inst_75999 = [inst_75995,inst_75996,inst_75997,inst_75998];
var inst_76000 = (new cljs.core.PersistentVector(null,4,(5),inst_75994,inst_75999,null));
var inst_76001__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76000,(0),null);
var inst_76002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76000,(1),null);
var inst_76003 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76000,(2),null);
var inst_76004 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76000,(3),null);
var inst_76005 = (inst_76001__$1 == null);
var inst_76006 = cljs.core.not(inst_76005);
var state_76099__$1 = (function (){var statearr_76103 = state_76099;
(statearr_76103[(10)] = inst_76004);

(statearr_76103[(11)] = inst_76003);

(statearr_76103[(8)] = inst_76001__$1);

(statearr_76103[(9)] = inst_75993__$1);

(statearr_76103[(12)] = inst_76002);

return statearr_76103;
})();
if(inst_76006){
var statearr_76104_76194 = state_76099__$1;
(statearr_76104_76194[(1)] = (30));

} else {
var statearr_76105_76195 = state_76099__$1;
(statearr_76105_76195[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (58))){
var inst_75933 = (state_76099[(13)]);
var inst_76089 = (state_76099[(2)]);
var state_76099__$1 = (function (){var statearr_76106 = state_76099;
(statearr_76106[(14)] = inst_76089);

return statearr_76106;
})();
if(cljs.core.truth_(inst_75933)){
var statearr_76107_76196 = state_76099__$1;
(statearr_76107_76196[(1)] = (60));

} else {
var statearr_76108_76197 = state_76099__$1;
(statearr_76108_76197[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (60))){
var inst_76077 = (state_76099[(15)]);
var inst_76089 = (state_76099[(14)]);
var inst_76091 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_76092 = cljs.core.count(inst_76077);
var inst_76093 = [inst_76089,inst_76092,(200)];
var inst_76094 = cljs.core.PersistentHashMap.fromArrays(inst_76091,inst_76093);
var state_76099__$1 = state_76099;
var statearr_76109_76198 = state_76099__$1;
(statearr_76109_76198[(2)] = inst_76094);

(statearr_76109_76198[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (27))){
var inst_75912 = (state_76099[(16)]);
var inst_75981 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75912)].join('');
var inst_75982 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75983 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75984 = cljs.core.PersistentHashMap.fromArrays(inst_75982,inst_75983);
var inst_75985 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75981,inst_75984);
var inst_75986 = (function(){throw inst_75985})();
var state_76099__$1 = state_76099;
var statearr_76110_76199 = state_76099__$1;
(statearr_76110_76199[(2)] = inst_75986);

(statearr_76110_76199[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (1))){
var inst_75909 = query_map;
var inst_75910 = cljs.core.__destructure_map(inst_75909);
var inst_75911 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75910,new cljs.core.Keyword(null,"block","block",664686210));
var inst_75912 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75910,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_75913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75910,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_76099__$1 = (function (){var statearr_76111 = state_76099;
(statearr_76111[(17)] = inst_75911);

(statearr_76111[(16)] = inst_75912);

(statearr_76111[(18)] = inst_75913);

return statearr_76111;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76099__$1,(2),sources);
} else {
if((state_val_76100 === (24))){
var inst_75912 = (state_76099[(16)]);
var inst_75970 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75912)].join('');
var inst_75971 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75972 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75973 = cljs.core.PersistentHashMap.fromArrays(inst_75971,inst_75972);
var inst_75974 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75970,inst_75973);
var inst_75975 = (function(){throw inst_75974})();
var state_76099__$1 = state_76099;
var statearr_76112_76200 = state_76099__$1;
(statearr_76112_76200[(2)] = inst_75975);

(statearr_76112_76200[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (55))){
var inst_75913 = (state_76099[(18)]);
var inst_76080 = (state_76099[(2)]);
var inst_76081 = fluree.db.util.async.throw_err(inst_76080);
var state_76099__$1 = (function (){var statearr_76113 = state_76099;
(statearr_76113[(19)] = inst_76081);

return statearr_76113;
})();
if(cljs.core.truth_(inst_75913)){
var statearr_76114_76201 = state_76099__$1;
(statearr_76114_76201[(1)] = (56));

} else {
var statearr_76115_76202 = state_76099__$1;
(statearr_76115_76202[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (39))){
var inst_76004 = (state_76099[(10)]);
var inst_76003 = (state_76099[(11)]);
var inst_76001 = (state_76099[(8)]);
var inst_76002 = (state_76099[(12)]);
var inst_76025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76027 = [inst_76002,inst_76001,inst_76003,inst_76004];
var inst_76028 = (new cljs.core.PersistentVector(null,4,(5),inst_76026,inst_76027,null));
var inst_76029 = [inst_76028,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_76030 = (new cljs.core.PersistentVector(null,2,(5),inst_76025,inst_76029,null));
var state_76099__$1 = state_76099;
var statearr_76116_76203 = state_76099__$1;
(statearr_76116_76203[(2)] = inst_76030);

(statearr_76116_76203[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (46))){
var inst_76035 = (state_76099[(20)]);
var state_76099__$1 = state_76099;
var statearr_76117_76204 = state_76099__$1;
(statearr_76117_76204[(2)] = inst_76035);

(statearr_76117_76204[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (4))){
var state_76099__$1 = state_76099;
var statearr_76118_76205 = state_76099__$1;
(statearr_76118_76205[(2)] = null);

(statearr_76118_76205[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (54))){
var inst_76077 = (state_76099[(15)]);
var inst_75916 = (state_76099[(21)]);
var inst_76076 = (state_76099[(2)]);
var inst_76077__$1 = fluree.db.util.async.throw_err(inst_76076);
var inst_76078 = fluree.db.api_js.format_history_resp(inst_75916,inst_76077__$1);
var state_76099__$1 = (function (){var statearr_76119 = state_76099;
(statearr_76119[(15)] = inst_76077__$1);

return statearr_76119;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76099__$1,(55),inst_76078);
} else {
if((state_val_76100 === (15))){
var inst_75916 = (state_76099[(21)]);
var inst_75957 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75916);
var state_76099__$1 = state_76099;
var statearr_76120_76206 = state_76099__$1;
(statearr_76120_76206[(2)] = inst_75957);

(statearr_76120_76206[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (48))){
var inst_76004 = (state_76099[(10)]);
var inst_76003 = (state_76099[(11)]);
var inst_76001 = (state_76099[(8)]);
var inst_76002 = (state_76099[(12)]);
var inst_76046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76048 = [inst_76002,inst_76003,inst_76001,inst_76004];
var inst_76049 = (new cljs.core.PersistentVector(null,4,(5),inst_76047,inst_76048,null));
var inst_76050 = [inst_76049,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_76051 = (new cljs.core.PersistentVector(null,2,(5),inst_76046,inst_76050,null));
var state_76099__$1 = state_76099;
var statearr_76121_76207 = state_76099__$1;
(statearr_76121_76207[(2)] = inst_76051);

(statearr_76121_76207[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (50))){
var inst_76064 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
var statearr_76122_76208 = state_76099__$1;
(statearr_76122_76208[(2)] = inst_76064);

(statearr_76122_76208[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (21))){
var inst_75912 = (state_76099[(16)]);
var inst_75968 = cljs.core.empty_QMARK_(inst_75912);
var state_76099__$1 = state_76099;
if(inst_75968){
var statearr_76123_76209 = state_76099__$1;
(statearr_76123_76209[(1)] = (24));

} else {
var statearr_76124_76210 = state_76099__$1;
(statearr_76124_76210[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (31))){
var inst_76012 = (state_76099[(22)]);
var inst_76001 = (state_76099[(8)]);
var inst_76012__$1 = (inst_76001 == null);
var state_76099__$1 = (function (){var statearr_76125 = state_76099;
(statearr_76125[(22)] = inst_76012__$1);

return statearr_76125;
})();
if(cljs.core.truth_(inst_76012__$1)){
var statearr_76126_76211 = state_76099__$1;
(statearr_76126_76211[(1)] = (33));

} else {
var statearr_76127_76212 = state_76099__$1;
(statearr_76127_76212[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (32))){
var inst_75959 = (state_76099[(23)]);
var inst_75949 = (state_76099[(24)]);
var inst_75916 = (state_76099[(21)]);
var inst_76068 = (state_76099[(2)]);
var inst_76069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76068,(0),null);
var inst_76070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76068,(1),null);
var inst_76071 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_76072 = [inst_75949,inst_75959];
var inst_76073 = cljs.core.PersistentHashMap.fromArrays(inst_76071,inst_76072);
var inst_76074 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_75916,inst_76070,cljs.core._EQ_,inst_76069,inst_76073);
var state_76099__$1 = state_76099;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76099__$1,(54),inst_76074);
} else {
if((state_val_76100 === (40))){
var inst_76001 = (state_76099[(8)]);
var inst_76032 = (state_76099[(25)]);
var inst_76032__$1 = (inst_76001 == null);
var state_76099__$1 = (function (){var statearr_76128 = state_76099;
(statearr_76128[(25)] = inst_76032__$1);

return statearr_76128;
})();
if(cljs.core.truth_(inst_76032__$1)){
var statearr_76129_76213 = state_76099__$1;
(statearr_76129_76213[(1)] = (42));

} else {
var statearr_76130_76214 = state_76099__$1;
(statearr_76130_76214[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (56))){
var inst_76081 = (state_76099[(19)]);
var inst_75916 = (state_76099[(21)]);
var inst_76083 = fluree.db.api_js.format_block_resp_pretty(inst_75916,inst_76081);
var state_76099__$1 = state_76099;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76099__$1,(59),inst_76083);
} else {
if((state_val_76100 === (33))){
var inst_76015 = (state_76099[(26)]);
var inst_76002 = (state_76099[(12)]);
var inst_76014 = (inst_76002 == null);
var inst_76015__$1 = cljs.core.not(inst_76014);
var state_76099__$1 = (function (){var statearr_76131 = state_76099;
(statearr_76131[(26)] = inst_76015__$1);

return statearr_76131;
})();
if(inst_76015__$1){
var statearr_76132_76215 = state_76099__$1;
(statearr_76132_76215[(1)] = (36));

} else {
var statearr_76133_76216 = state_76099__$1;
(statearr_76133_76216[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (13))){
var inst_75943 = (state_76099[(2)]);
var inst_75944 = fluree.db.util.async.throw_err(inst_75943);
var inst_75945 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75944);
var inst_75946 = (inst_75945 - (1));
var state_76099__$1 = state_76099;
var statearr_76134_76217 = state_76099__$1;
(statearr_76134_76217[(2)] = inst_75946);

(statearr_76134_76217[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (22))){
var state_76099__$1 = state_76099;
var statearr_76135_76218 = state_76099__$1;
(statearr_76135_76218[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (36))){
var inst_76003 = (state_76099[(11)]);
var inst_76017 = (inst_76003 == null);
var state_76099__$1 = state_76099;
var statearr_76137_76219 = state_76099__$1;
(statearr_76137_76219[(2)] = inst_76017);

(statearr_76137_76219[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (41))){
var inst_76066 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
var statearr_76138_76220 = state_76099__$1;
(statearr_76138_76220[(2)] = inst_76066);

(statearr_76138_76220[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (43))){
var inst_76032 = (state_76099[(25)]);
var state_76099__$1 = state_76099;
var statearr_76139_76221 = state_76099__$1;
(statearr_76139_76221[(2)] = inst_76032);

(statearr_76139_76221[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (61))){
var inst_76089 = (state_76099[(14)]);
var state_76099__$1 = state_76099;
var statearr_76140_76222 = state_76099__$1;
(statearr_76140_76222[(2)] = inst_76089);

(statearr_76140_76222[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (29))){
var inst_75989 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
var statearr_76141_76223 = state_76099__$1;
(statearr_76141_76223[(2)] = inst_75989);

(statearr_76141_76223[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (44))){
var inst_76044 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
if(cljs.core.truth_(inst_76044)){
var statearr_76142_76224 = state_76099__$1;
(statearr_76142_76224[(1)] = (48));

} else {
var statearr_76143_76225 = state_76099__$1;
(statearr_76143_76225[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (6))){
var inst_75920 = (state_76099[(2)]);
var inst_75921 = fluree.db.util.async.throw_err(inst_75920);
var state_76099__$1 = state_76099;
var statearr_76144_76226 = state_76099__$1;
(statearr_76144_76226[(2)] = inst_75921);

(statearr_76144_76226[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (28))){
var state_76099__$1 = state_76099;
var statearr_76145_76227 = state_76099__$1;
(statearr_76145_76227[(2)] = null);

(statearr_76145_76227[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (51))){
var inst_75912 = (state_76099[(16)]);
var inst_76054 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75912)].join('');
var inst_76055 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76056 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76057 = cljs.core.PersistentHashMap.fromArrays(inst_76055,inst_76056);
var inst_76058 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76054,inst_76057);
var inst_76059 = (function(){throw inst_76058})();
var state_76099__$1 = state_76099;
var statearr_76146_76228 = state_76099__$1;
(statearr_76146_76228[(2)] = inst_76059);

(statearr_76146_76228[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (25))){
var inst_75912 = (state_76099[(16)]);
var state_76099__$1 = state_76099;
var statearr_76147_76229 = state_76099__$1;
(statearr_76147_76229[(2)] = inst_75912);

(statearr_76147_76229[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (34))){
var inst_76012 = (state_76099[(22)]);
var state_76099__$1 = state_76099;
var statearr_76148_76230 = state_76099__$1;
(statearr_76148_76230[(2)] = inst_76012);

(statearr_76148_76230[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (17))){
var inst_75953 = (state_76099[(2)]);
var inst_75954 = fluree.db.util.async.throw_err(inst_75953);
var inst_75955 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75954);
var state_76099__$1 = state_76099;
var statearr_76149_76231 = state_76099__$1;
(statearr_76149_76231[(2)] = inst_75955);

(statearr_76149_76231[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (3))){
var inst_75916 = (state_76099[(21)]);
var inst_75918 = fluree.db.api_js.resolve_block_range(inst_75916,query_map);
var state_76099__$1 = state_76099;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76099__$1,(6),inst_75918);
} else {
if((state_val_76100 === (12))){
var inst_75926 = (state_76099[(27)]);
var inst_75949 = (state_76099[(2)]);
var state_76099__$1 = (function (){var statearr_76150 = state_76099;
(statearr_76150[(24)] = inst_75949);

return statearr_76150;
})();
if(cljs.core.truth_(inst_75926)){
var statearr_76151_76232 = state_76099__$1;
(statearr_76151_76232[(1)] = (14));

} else {
var statearr_76152_76233 = state_76099__$1;
(statearr_76152_76233[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (2))){
var inst_75911 = (state_76099[(17)]);
var inst_75915 = (state_76099[(2)]);
var inst_75916 = fluree.db.util.async.throw_err(inst_75915);
var state_76099__$1 = (function (){var statearr_76153 = state_76099;
(statearr_76153[(21)] = inst_75916);

return statearr_76153;
})();
if(cljs.core.truth_(inst_75911)){
var statearr_76154_76234 = state_76099__$1;
(statearr_76154_76234[(1)] = (3));

} else {
var statearr_76155_76235 = state_76099__$1;
(statearr_76155_76235[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (23))){
var inst_75991 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
var statearr_76156_76236 = state_76099__$1;
(statearr_76156_76236[(2)] = inst_75991);

(statearr_76156_76236[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (47))){
var inst_76041 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
var statearr_76157_76237 = state_76099__$1;
(statearr_76157_76237[(2)] = inst_76041);

(statearr_76157_76237[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (35))){
var inst_76023 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
if(cljs.core.truth_(inst_76023)){
var statearr_76158_76238 = state_76099__$1;
(statearr_76158_76238[(1)] = (39));

} else {
var statearr_76159_76239 = state_76099__$1;
(statearr_76159_76239[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (19))){
var inst_75912 = (state_76099[(16)]);
var inst_75966 = cljs.core.sequential_QMARK_(inst_75912);
var state_76099__$1 = state_76099;
if(inst_75966){
var statearr_76160_76240 = state_76099__$1;
(statearr_76160_76240[(1)] = (21));

} else {
var statearr_76161_76241 = state_76099__$1;
(statearr_76161_76241[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (57))){
var inst_76081 = (state_76099[(19)]);
var state_76099__$1 = state_76099;
var statearr_76162_76242 = state_76099__$1;
(statearr_76162_76242[(2)] = inst_76081);

(statearr_76162_76242[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (11))){
var state_76099__$1 = state_76099;
var statearr_76163_76243 = state_76099__$1;
(statearr_76163_76243[(2)] = (-1));

(statearr_76163_76243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (9))){
var inst_75938 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
if(cljs.core.truth_(inst_75938)){
var statearr_76164_76244 = state_76099__$1;
(statearr_76164_76244[(1)] = (10));

} else {
var statearr_76165_76245 = state_76099__$1;
(statearr_76165_76245[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (5))){
var inst_75925 = (state_76099[(7)]);
var inst_75924 = (state_76099[(2)]);
var inst_75925__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75924,(0),null);
var inst_75926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75924,(1),null);
var inst_75933 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_76099__$1 = (function (){var statearr_76166 = state_76099;
(statearr_76166[(27)] = inst_75926);

(statearr_76166[(13)] = inst_75933);

(statearr_76166[(7)] = inst_75925__$1);

return statearr_76166;
})();
if(cljs.core.truth_(inst_75925__$1)){
var statearr_76167_76246 = state_76099__$1;
(statearr_76167_76246[(1)] = (7));

} else {
var statearr_76168_76247 = state_76099__$1;
(statearr_76168_76247[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (14))){
var inst_75926 = (state_76099[(27)]);
var inst_75916 = (state_76099[(21)]);
var inst_75951 = fluree.db.time_travel.as_of_block(inst_75916,inst_75926);
var state_76099__$1 = state_76099;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76099__$1,(17),inst_75951);
} else {
if((state_val_76100 === (45))){
var inst_76003 = (state_76099[(11)]);
var inst_76037 = (inst_76003 == null);
var inst_76038 = cljs.core.not(inst_76037);
var state_76099__$1 = state_76099;
var statearr_76169_76248 = state_76099__$1;
(statearr_76169_76248[(2)] = inst_76038);

(statearr_76169_76248[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (53))){
var inst_76062 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
var statearr_76170_76249 = state_76099__$1;
(statearr_76170_76249[(2)] = inst_76062);

(statearr_76170_76249[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (26))){
var inst_75978 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
var statearr_76171_76250 = state_76099__$1;
(statearr_76171_76250[(2)] = inst_75978);

(statearr_76171_76250[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (16))){
var inst_75912 = (state_76099[(16)]);
var inst_75959 = (state_76099[(2)]);
var inst_75960 = fluree.db.util.core.subj_ident_QMARK_(inst_75912);
var state_76099__$1 = (function (){var statearr_76172 = state_76099;
(statearr_76172[(23)] = inst_75959);

return statearr_76172;
})();
if(inst_75960){
var statearr_76173_76251 = state_76099__$1;
(statearr_76173_76251[(1)] = (18));

} else {
var statearr_76174_76252 = state_76099__$1;
(statearr_76174_76252[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (38))){
var inst_76020 = (state_76099[(2)]);
var state_76099__$1 = state_76099;
var statearr_76175_76253 = state_76099__$1;
(statearr_76175_76253[(2)] = inst_76020);

(statearr_76175_76253[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (30))){
var inst_75993 = (state_76099[(9)]);
var inst_76008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76009 = [inst_75993,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_76010 = (new cljs.core.PersistentVector(null,2,(5),inst_76008,inst_76009,null));
var state_76099__$1 = state_76099;
var statearr_76176_76254 = state_76099__$1;
(statearr_76176_76254[(2)] = inst_76010);

(statearr_76176_76254[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (10))){
var inst_75925 = (state_76099[(7)]);
var inst_75916 = (state_76099[(21)]);
var inst_75940 = (inst_75925 - (1));
var inst_75941 = fluree.db.time_travel.as_of_block(inst_75916,inst_75940);
var state_76099__$1 = state_76099;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76099__$1,(13),inst_75941);
} else {
if((state_val_76100 === (18))){
var inst_75912 = (state_76099[(16)]);
var inst_75962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75963 = [inst_75912];
var inst_75964 = (new cljs.core.PersistentVector(null,1,(5),inst_75962,inst_75963,null));
var state_76099__$1 = state_76099;
var statearr_76177_76255 = state_76099__$1;
(statearr_76177_76255[(2)] = inst_75964);

(statearr_76177_76255[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (52))){
var state_76099__$1 = state_76099;
var statearr_76178_76256 = state_76099__$1;
(statearr_76178_76256[(2)] = null);

(statearr_76178_76256[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (42))){
var inst_76035 = (state_76099[(20)]);
var inst_76002 = (state_76099[(12)]);
var inst_76034 = (inst_76002 == null);
var inst_76035__$1 = cljs.core.not(inst_76034);
var state_76099__$1 = (function (){var statearr_76179 = state_76099;
(statearr_76179[(20)] = inst_76035__$1);

return statearr_76179;
})();
if(inst_76035__$1){
var statearr_76180_76257 = state_76099__$1;
(statearr_76180_76257[(1)] = (45));

} else {
var statearr_76181_76258 = state_76099__$1;
(statearr_76181_76258[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (37))){
var inst_76015 = (state_76099[(26)]);
var state_76099__$1 = state_76099;
var statearr_76182_76259 = state_76099__$1;
(statearr_76182_76259[(2)] = inst_76015);

(statearr_76182_76259[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (8))){
var inst_75925 = (state_76099[(7)]);
var state_76099__$1 = state_76099;
var statearr_76183_76260 = state_76099__$1;
(statearr_76183_76260[(2)] = inst_75925);

(statearr_76183_76260[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76100 === (49))){
var state_76099__$1 = state_76099;
var statearr_76184_76261 = state_76099__$1;
(statearr_76184_76261[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_76186 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76186[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_76186[(1)] = (1));

return statearr_76186;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_76099){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_76099);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e76187){var ex__2687__auto__ = e76187;
var statearr_76188_76262 = state_76099;
(statearr_76188_76262[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_76099[(4)]))){
var statearr_76189_76263 = state_76099;
(statearr_76189_76263[(1)] = cljs.core.first((state_76099[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76264 = state_76099;
state_76099 = G__76264;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_76099){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_76099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_76190 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_76190[(6)] = c__2706__auto__);

return statearr_76190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__76272 = arguments.length;
switch (G__76272) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__76265_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__76265_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_76361){
var state_val_76362 = (state_76361[(1)]);
if((state_val_76362 === (7))){
var inst_76318 = (state_76361[(7)]);
var inst_76312 = (state_76361[(8)]);
var inst_76322 = (state_76361[(9)]);
var inst_76315 = (state_76361[(10)]);
var inst_76328 = (function (){var responses = inst_76312;
var responses_STAR_ = inst_76315;
var statuses = inst_76318;
var fuel = inst_76322;
return (function (p1__76268_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__76268_SHARP_);
});
})();
var inst_76329 = cljs.core.some(inst_76328,inst_76318);
var state_76361__$1 = state_76361;
if(cljs.core.truth_(inst_76329)){
var statearr_76363_76411 = state_76361__$1;
(statearr_76363_76411[(1)] = (9));

} else {
var statearr_76364_76412 = state_76361__$1;
(statearr_76364_76412[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (20))){
var inst_76356 = (state_76361[(2)]);
var state_76361__$1 = state_76361;
var statearr_76365_76413 = state_76361__$1;
(statearr_76365_76413[(2)] = inst_76356);

(statearr_76365_76413[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (1))){
var inst_76307 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_76308 = (function (){var c__2706__auto____$1 = inst_76307;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_76305){
var state_val_76306 = (state_76305[(1)]);
if((state_val_76306 === (1))){
var inst_76273 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_76274 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_76275 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76274,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_76276 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_76277 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_76278 = cljs.core.PersistentHashMap.EMPTY;
var inst_76279 = inst_76273;
var inst_76280 = inst_76275;
var inst_76281 = inst_76276;
var inst_76282 = inst_76277;
var inst_76283 = inst_76278;
var state_76305__$1 = (function (){var statearr_76366 = state_76305;
(statearr_76366[(7)] = inst_76282);

(statearr_76366[(8)] = inst_76283);

(statearr_76366[(9)] = inst_76279);

(statearr_76366[(10)] = inst_76281);

(statearr_76366[(11)] = inst_76280);

return statearr_76366;
})();
var statearr_76367_76414 = state_76305__$1;
(statearr_76367_76414[(2)] = null);

(statearr_76367_76414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76306 === (2))){
var inst_76280 = (state_76305[(11)]);
var inst_76285 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_76280);
var inst_76286 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_76285], 0));
var inst_76287 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76280,new cljs.core.Keyword(null,"opts","opts",155075701),inst_76286);
var inst_76288 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_76287,db_fn);
var state_76305__$1 = state_76305;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76305__$1,(4),inst_76288);
} else {
if((state_val_76306 === (3))){
var inst_76303 = (state_76305[(2)]);
var state_76305__$1 = state_76305;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76305__$1,inst_76303);
} else {
if((state_val_76306 === (4))){
var inst_76283 = (state_76305[(8)]);
var inst_76279 = (state_76305[(9)]);
var inst_76281 = (state_76305[(10)]);
var inst_76290 = (state_76305[(2)]);
var inst_76291 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76283,inst_76279,inst_76290);
var inst_76292 = cljs.core.first(inst_76281);
var state_76305__$1 = (function (){var statearr_76368 = state_76305;
(statearr_76368[(12)] = inst_76291);

return statearr_76368;
})();
if(cljs.core.truth_(inst_76292)){
var statearr_76369_76415 = state_76305__$1;
(statearr_76369_76415[(1)] = (5));

} else {
var statearr_76370_76416 = state_76305__$1;
(statearr_76370_76416[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76306 === (5))){
var inst_76291 = (state_76305[(12)]);
var inst_76282 = (state_76305[(7)]);
var inst_76281 = (state_76305[(10)]);
var inst_76294 = cljs.core.first(inst_76281);
var inst_76295 = cljs.core.first(inst_76282);
var inst_76296 = cljs.core.rest(inst_76281);
var inst_76297 = cljs.core.rest(inst_76282);
var inst_76279 = inst_76294;
var inst_76280 = inst_76295;
var inst_76281__$1 = inst_76296;
var inst_76282__$1 = inst_76297;
var inst_76283 = inst_76291;
var state_76305__$1 = (function (){var statearr_76371 = state_76305;
(statearr_76371[(7)] = inst_76282__$1);

(statearr_76371[(8)] = inst_76283);

(statearr_76371[(9)] = inst_76279);

(statearr_76371[(10)] = inst_76281__$1);

(statearr_76371[(11)] = inst_76280);

return statearr_76371;
})();
var statearr_76372_76417 = state_76305__$1;
(statearr_76372_76417[(2)] = null);

(statearr_76372_76417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76306 === (6))){
var inst_76291 = (state_76305[(12)]);
var state_76305__$1 = state_76305;
var statearr_76373_76418 = state_76305__$1;
(statearr_76373_76418[(2)] = inst_76291);

(statearr_76373_76418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76306 === (7))){
var inst_76301 = (state_76305[(2)]);
var state_76305__$1 = state_76305;
var statearr_76374_76419 = state_76305__$1;
(statearr_76374_76419[(2)] = inst_76301);

(statearr_76374_76419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_76375 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76375[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_76375[(1)] = (1));

return statearr_76375;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_76305){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_76305);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e76376){var ex__2687__auto__ = e76376;
var statearr_76377_76420 = state_76305;
(statearr_76377_76420[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_76305[(4)]))){
var statearr_76378_76421 = state_76305;
(statearr_76378_76421[(1)] = cljs.core.first((state_76305[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76422 = state_76305;
state_76305 = G__76422;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_76305){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_76305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_76379 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_76379[(6)] = c__2706__auto____$1);

return statearr_76379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_76309 = cljs.core.async.impl.dispatch.run(inst_76308);
var state_76361__$1 = (function (){var statearr_76380 = state_76361;
(statearr_76380[(11)] = inst_76309);

return statearr_76380;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76361__$1,(2),inst_76307);
} else {
if((state_val_76362 === (4))){
var inst_76312 = (state_76361[(8)]);
var state_76361__$1 = state_76361;
var statearr_76381_76423 = state_76361__$1;
(statearr_76381_76423[(2)] = inst_76312);

(statearr_76381_76423[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (15))){
var state_76361__$1 = state_76361;
var statearr_76382_76424 = state_76361__$1;
(statearr_76382_76424[(2)] = (400));

(statearr_76382_76424[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (13))){
var state_76361__$1 = state_76361;
var statearr_76383_76425 = state_76361__$1;
(statearr_76383_76425[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (6))){
var inst_76318 = (state_76361[(7)]);
var inst_76326 = cljs.core.first(inst_76318);
var state_76361__$1 = state_76361;
var statearr_76385_76426 = state_76361__$1;
(statearr_76385_76426[(2)] = inst_76326);

(statearr_76385_76426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (17))){
var inst_76339 = (state_76361[(2)]);
var state_76361__$1 = state_76361;
var statearr_76386_76427 = state_76361__$1;
(statearr_76386_76427[(2)] = inst_76339);

(statearr_76386_76427[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (3))){
var inst_76318 = (state_76361[(7)]);
var inst_76312 = (state_76361[(8)]);
var inst_76322 = (state_76361[(9)]);
var inst_76315 = (state_76361[(10)]);
var inst_76317 = cljs.core.vals(inst_76312);
var inst_76318__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_76317);
var inst_76319 = (function (){var responses = inst_76312;
var responses_STAR_ = inst_76315;
var statuses = inst_76318__$1;
return (function (p1__76266_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__76266_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_76320 = cljs.core.vals(inst_76312);
var inst_76321 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_76319,inst_76320);
var inst_76322__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_76321);
var inst_76323 = (function (){var responses = inst_76312;
var responses_STAR_ = inst_76315;
var statuses = inst_76318__$1;
var fuel = inst_76322__$1;
return (function (p1__76267_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__76267_SHARP_);
});
})();
var inst_76324 = cljs.core.every_QMARK_(inst_76323,inst_76318__$1);
var state_76361__$1 = (function (){var statearr_76387 = state_76361;
(statearr_76387[(7)] = inst_76318__$1);

(statearr_76387[(9)] = inst_76322__$1);

return statearr_76387;
})();
if(inst_76324){
var statearr_76388_76428 = state_76361__$1;
(statearr_76388_76428[(1)] = (6));

} else {
var statearr_76389_76429 = state_76361__$1;
(statearr_76389_76429[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (12))){
var state_76361__$1 = state_76361;
var statearr_76390_76430 = state_76361__$1;
(statearr_76390_76430[(2)] = (500));

(statearr_76390_76430[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (2))){
var inst_76312 = (state_76361[(8)]);
var inst_76311 = (state_76361[(2)]);
var inst_76312__$1 = fluree.db.util.async.throw_err(inst_76311);
var inst_76313 = (function (){var responses = inst_76312__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_76314 = cljs.core.PersistentHashMap.EMPTY;
var inst_76315 = cljs.core.reduce_kv(inst_76313,inst_76314,inst_76312__$1);
var state_76361__$1 = (function (){var statearr_76391 = state_76361;
(statearr_76391[(8)] = inst_76312__$1);

(statearr_76391[(10)] = inst_76315);

return statearr_76391;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_76392_76431 = state_76361__$1;
(statearr_76392_76431[(1)] = (3));

} else {
var statearr_76393_76432 = state_76361__$1;
(statearr_76393_76432[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (19))){
var inst_76345 = (state_76361[(12)]);
var inst_76322 = (state_76361[(9)]);
var inst_76315 = (state_76361[(10)]);
var inst_76354 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_76315,new cljs.core.Keyword(null,"status","status",-1997798413),inst_76345,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_76322], 0));
var state_76361__$1 = state_76361;
var statearr_76394_76433 = state_76361__$1;
(statearr_76394_76433[(2)] = inst_76354);

(statearr_76394_76433[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (11))){
var inst_76343 = (state_76361[(2)]);
var state_76361__$1 = state_76361;
var statearr_76395_76434 = state_76361__$1;
(statearr_76395_76434[(2)] = inst_76343);

(statearr_76395_76434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (9))){
var state_76361__$1 = state_76361;
var statearr_76396_76435 = state_76361__$1;
(statearr_76396_76435[(2)] = (207));

(statearr_76396_76435[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (5))){
var inst_76359 = (state_76361[(2)]);
var state_76361__$1 = state_76361;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76361__$1,inst_76359);
} else {
if((state_val_76362 === (14))){
var inst_76341 = (state_76361[(2)]);
var state_76361__$1 = state_76361;
var statearr_76397_76436 = state_76361__$1;
(statearr_76397_76436[(2)] = inst_76341);

(statearr_76397_76436[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (16))){
var state_76361__$1 = state_76361;
var statearr_76398_76437 = state_76361__$1;
(statearr_76398_76437[(2)] = null);

(statearr_76398_76437[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (10))){
var inst_76318 = (state_76361[(7)]);
var inst_76312 = (state_76361[(8)]);
var inst_76322 = (state_76361[(9)]);
var inst_76315 = (state_76361[(10)]);
var inst_76332 = (function (){var responses = inst_76312;
var responses_STAR_ = inst_76315;
var statuses = inst_76318;
var fuel = inst_76322;
return (function (p1__76269_SHARP_){
return ((499) < p1__76269_SHARP_);
});
})();
var inst_76333 = cljs.core.some(inst_76332,inst_76318);
var state_76361__$1 = state_76361;
if(cljs.core.truth_(inst_76333)){
var statearr_76399_76438 = state_76361__$1;
(statearr_76399_76438[(1)] = (12));

} else {
var statearr_76400_76439 = state_76361__$1;
(statearr_76400_76439[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (18))){
var inst_76345 = (state_76361[(12)]);
var inst_76322 = (state_76361[(9)]);
var inst_76315 = (state_76361[(10)]);
var inst_76350 = (state_76361[(13)]);
var inst_76352 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_76315,new cljs.core.Keyword(null,"status","status",-1997798413),inst_76345,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_76322,new cljs.core.Keyword(null,"block","block",664686210),inst_76350], 0));
var state_76361__$1 = state_76361;
var statearr_76401_76440 = state_76361__$1;
(statearr_76401_76440[(2)] = inst_76352);

(statearr_76401_76440[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76362 === (8))){
var inst_76318 = (state_76361[(7)]);
var inst_76345 = (state_76361[(12)]);
var inst_76312 = (state_76361[(8)]);
var inst_76322 = (state_76361[(9)]);
var inst_76315 = (state_76361[(10)]);
var inst_76350 = (state_76361[(13)]);
var inst_76345__$1 = (state_76361[(2)]);
var inst_76346 = (function (){var responses = inst_76312;
var responses_STAR_ = inst_76315;
var statuses = inst_76318;
var fuel = inst_76322;
var status = inst_76345__$1;
return (function (p1__76270_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__76270_SHARP_));
});
})();
var inst_76347 = cljs.core.vals(inst_76312);
var inst_76348 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_76346,inst_76347);
var inst_76349 = cljs.core.first(inst_76348);
var inst_76350__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_76349);
var state_76361__$1 = (function (){var statearr_76402 = state_76361;
(statearr_76402[(12)] = inst_76345__$1);

(statearr_76402[(13)] = inst_76350__$1);

return statearr_76402;
})();
if(cljs.core.truth_(inst_76350__$1)){
var statearr_76403_76441 = state_76361__$1;
(statearr_76403_76441[(1)] = (18));

} else {
var statearr_76404_76442 = state_76361__$1;
(statearr_76404_76442[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_76405 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76405[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_76405[(1)] = (1));

return statearr_76405;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_76361){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_76361);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e76406){var ex__2687__auto__ = e76406;
var statearr_76407_76443 = state_76361;
(statearr_76407_76443[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_76361[(4)]))){
var statearr_76408_76444 = state_76361;
(statearr_76408_76444[(1)] = cljs.core.first((state_76361[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76445 = state_76361;
state_76361 = G__76445;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_76361){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_76361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_76409 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_76409[(6)] = c__2706__auto__);

return statearr_76409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__76447 = arguments.length;
switch (G__76447) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__76448 = opts;
var map__76448__$1 = cljs.core.__destructure_map(map__76448);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76448__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76448__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76448__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76448__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__76449 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76449,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76449,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e76452){var e = e76452;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__76455 = arguments.length;
switch (G__76455) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_76489){
var state_val_76490 = (state_76489[(1)]);
if((state_val_76490 === (7))){
var state_76489__$1 = state_76489;
var statearr_76491_76512 = state_76489__$1;
(statearr_76491_76512[(2)] = opts);

(statearr_76491_76512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76490 === (1))){
var state_76489__$1 = state_76489;
var statearr_76492_76513 = state_76489__$1;
(statearr_76492_76513[(2)] = null);

(statearr_76492_76513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76490 === (4))){
var inst_76456 = (state_76489[(2)]);
var inst_76457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76458 = [inst_76456];
var inst_76459 = (new cljs.core.PersistentVector(null,1,(5),inst_76457,inst_76458,null));
var inst_76460 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76459);
var inst_76461 = cljs.core.ex_data(inst_76456);
var inst_76462 = cljs.core.ex_message(inst_76456);
var inst_76463 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76461,new cljs.core.Keyword(null,"message","message",-406056002),inst_76462);
var state_76489__$1 = (function (){var statearr_76493 = state_76489;
(statearr_76493[(7)] = inst_76460);

return statearr_76493;
})();
var statearr_76494_76514 = state_76489__$1;
(statearr_76494_76514[(2)] = inst_76463);

(statearr_76494_76514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76490 === (6))){
var inst_76473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76474 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_76475 = (new cljs.core.PersistentVector(null,1,(5),inst_76473,inst_76474,null));
var inst_76476 = cljs.core.assoc_in(opts,inst_76475,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_76489__$1 = state_76489;
var statearr_76495_76515 = state_76489__$1;
(statearr_76495_76515[(2)] = inst_76476);

(statearr_76495_76515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76490 === (3))){
var inst_76487 = (state_76489[(2)]);
var state_76489__$1 = state_76489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76489__$1,inst_76487);
} else {
if((state_val_76490 === (2))){
var _ = (function (){var statearr_76497 = state_76489;
(statearr_76497[(4)] = cljs.core.cons((5),(state_76489[(4)])));

return statearr_76497;
})();
var inst_76469 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_76470 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_76471 = (inst_76470 == null);
var state_76489__$1 = (function (){var statearr_76498 = state_76489;
(statearr_76498[(8)] = inst_76469);

return statearr_76498;
})();
if(cljs.core.truth_(inst_76471)){
var statearr_76499_76516 = state_76489__$1;
(statearr_76499_76516[(1)] = (6));

} else {
var statearr_76500_76517 = state_76489__$1;
(statearr_76500_76517[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76490 === (9))){
var inst_76483 = (state_76489[(2)]);
var inst_76484 = fluree.db.util.async.throw_err(inst_76483);
var _ = (function (){var statearr_76501 = state_76489;
(statearr_76501[(4)] = cljs.core.rest((state_76489[(4)])));

return statearr_76501;
})();
var state_76489__$1 = state_76489;
var statearr_76502_76518 = state_76489__$1;
(statearr_76502_76518[(2)] = inst_76484);

(statearr_76502_76518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76490 === (5))){
var _ = (function (){var statearr_76503 = state_76489;
(statearr_76503[(4)] = cljs.core.rest((state_76489[(4)])));

return statearr_76503;
})();
var state_76489__$1 = state_76489;
var ex76496 = (state_76489__$1[(2)]);
var statearr_76504_76519 = state_76489__$1;
(statearr_76504_76519[(5)] = ex76496);


var statearr_76505_76520 = state_76489__$1;
(statearr_76505_76520[(1)] = (4));

(statearr_76505_76520[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76490 === (8))){
var inst_76469 = (state_76489[(8)]);
var inst_76479 = (state_76489[(2)]);
var inst_76480 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_76469,inst_76479);
var inst_76481 = fluree.db.operations.command_async(conn,inst_76480);
var state_76489__$1 = state_76489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76489__$1,(9),inst_76481);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_76506 = [null,null,null,null,null,null,null,null,null];
(statearr_76506[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_76506[(1)] = (1));

return statearr_76506;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_76489){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_76489);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e76507){var ex__2687__auto__ = e76507;
var statearr_76508_76521 = state_76489;
(statearr_76508_76521[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_76489[(4)]))){
var statearr_76509_76522 = state_76489;
(statearr_76509_76522[(1)] = cljs.core.first((state_76489[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76523 = state_76489;
state_76489 = G__76523;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_76489){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_76489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_76510 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_76510[(6)] = c__2706__auto__);

return statearr_76510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

