// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__72737_72918 = cljs.core.seq(servers);
var chunk__72738_72919 = null;
var count__72739_72920 = (0);
var i__72740_72921 = (0);
while(true){
if((i__72740_72921 < count__72739_72920)){
var server_72922 = chunk__72738_72919.cljs$core$IIndexed$_nth$arity$2(null,i__72740_72921);
var healthcheck_uri_72923 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_72922),"/fdb/health"].join('');
var resp_chan_72924 = fluree.db.util.xhttp.post_json(healthcheck_uri_72923,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___72925 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,c__2706__auto___72925,healthcheck_uri_72923,resp_chan_72924,server_72922){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,c__2706__auto___72925,healthcheck_uri_72923,resp_chan_72924,server_72922){
return (function (state_72810){
var state_val_72811 = (state_72810[(1)]);
if((state_val_72811 === (1))){
var state_72810__$1 = state_72810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72810__$1,(2),resp_chan_72924);
} else {
if((state_val_72811 === (2))){
var inst_72796 = (state_72810[(7)]);
var inst_72796__$1 = (state_72810[(2)]);
var inst_72797 = fluree.db.util.core.exception_QMARK_(inst_72796__$1);
var state_72810__$1 = (function (){var statearr_72812 = state_72810;
(statearr_72812[(7)] = inst_72796__$1);

return statearr_72812;
})();
if(inst_72797){
var statearr_72813_72926 = state_72810__$1;
(statearr_72813_72926[(1)] = (3));

} else {
var statearr_72814_72927 = state_72810__$1;
(statearr_72814_72927[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72811 === (3))){
var inst_72796 = (state_72810[(7)]);
var inst_72799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72800 = cljs.core.ex_message(inst_72796);
var inst_72801 = cljs.core.ex_data(inst_72796);
var inst_72802 = ["Server contact error: ",inst_72800,inst_72801];
var inst_72803 = (new cljs.core.PersistentVector(null,3,(5),inst_72799,inst_72802,null));
var inst_72804 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_72803);
var state_72810__$1 = state_72810;
var statearr_72815_72928 = state_72810__$1;
(statearr_72815_72928[(2)] = inst_72804);

(statearr_72815_72928[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72811 === (4))){
var inst_72806 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_72922);
var state_72810__$1 = state_72810;
var statearr_72816_72929 = state_72810__$1;
(statearr_72816_72929[(2)] = inst_72806);

(statearr_72816_72929[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72811 === (5))){
var inst_72808 = (state_72810[(2)]);
var state_72810__$1 = state_72810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72810__$1,inst_72808);
} else {
return null;
}
}
}
}
}
});})(seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,c__2706__auto___72925,healthcheck_uri_72923,resp_chan_72924,server_72922))
;
return ((function (seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,switch__2683__auto__,c__2706__auto___72925,healthcheck_uri_72923,resp_chan_72924,server_72922){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_72817 = [null,null,null,null,null,null,null,null];
(statearr_72817[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_72817[(1)] = (1));

return statearr_72817;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_72810){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72810);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72818){var ex__2687__auto__ = e72818;
var statearr_72819_72930 = state_72810;
(statearr_72819_72930[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72810[(4)]))){
var statearr_72820_72931 = state_72810;
(statearr_72820_72931[(1)] = cljs.core.first((state_72810[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72932 = state_72810;
state_72810 = G__72932;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_72810){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_72810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,switch__2683__auto__,c__2706__auto___72925,healthcheck_uri_72923,resp_chan_72924,server_72922))
})();
var state__2708__auto__ = (function (){var statearr_72821 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72821[(6)] = c__2706__auto___72925);

return statearr_72821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});})(seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,c__2706__auto___72925,healthcheck_uri_72923,resp_chan_72924,server_72922))
);



var G__72933 = seq__72737_72918;
var G__72934 = chunk__72738_72919;
var G__72935 = count__72739_72920;
var G__72936 = (i__72740_72921 + (1));
seq__72737_72918 = G__72933;
chunk__72738_72919 = G__72934;
count__72739_72920 = G__72935;
i__72740_72921 = G__72936;
continue;
} else {
var temp__5804__auto___72937 = cljs.core.seq(seq__72737_72918);
if(temp__5804__auto___72937){
var seq__72737_72938__$1 = temp__5804__auto___72937;
if(cljs.core.chunked_seq_QMARK_(seq__72737_72938__$1)){
var c__5568__auto___72939 = cljs.core.chunk_first(seq__72737_72938__$1);
var G__72940 = cljs.core.chunk_rest(seq__72737_72938__$1);
var G__72941 = c__5568__auto___72939;
var G__72942 = cljs.core.count(c__5568__auto___72939);
var G__72943 = (0);
seq__72737_72918 = G__72940;
chunk__72738_72919 = G__72941;
count__72739_72920 = G__72942;
i__72740_72921 = G__72943;
continue;
} else {
var server_72944 = cljs.core.first(seq__72737_72938__$1);
var healthcheck_uri_72945 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_72944),"/fdb/health"].join('');
var resp_chan_72946 = fluree.db.util.xhttp.post_json(healthcheck_uri_72945,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___72947 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,c__2706__auto___72947,healthcheck_uri_72945,resp_chan_72946,server_72944,seq__72737_72938__$1,temp__5804__auto___72937){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,c__2706__auto___72947,healthcheck_uri_72945,resp_chan_72946,server_72944,seq__72737_72938__$1,temp__5804__auto___72937){
return (function (state_72837){
var state_val_72838 = (state_72837[(1)]);
if((state_val_72838 === (1))){
var state_72837__$1 = state_72837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72837__$1,(2),resp_chan_72946);
} else {
if((state_val_72838 === (2))){
var inst_72823 = (state_72837[(7)]);
var inst_72823__$1 = (state_72837[(2)]);
var inst_72824 = fluree.db.util.core.exception_QMARK_(inst_72823__$1);
var state_72837__$1 = (function (){var statearr_72839 = state_72837;
(statearr_72839[(7)] = inst_72823__$1);

return statearr_72839;
})();
if(inst_72824){
var statearr_72840_72948 = state_72837__$1;
(statearr_72840_72948[(1)] = (3));

} else {
var statearr_72841_72949 = state_72837__$1;
(statearr_72841_72949[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72838 === (3))){
var inst_72823 = (state_72837[(7)]);
var inst_72826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72827 = cljs.core.ex_message(inst_72823);
var inst_72828 = cljs.core.ex_data(inst_72823);
var inst_72829 = ["Server contact error: ",inst_72827,inst_72828];
var inst_72830 = (new cljs.core.PersistentVector(null,3,(5),inst_72826,inst_72829,null));
var inst_72831 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_72830);
var state_72837__$1 = state_72837;
var statearr_72842_72950 = state_72837__$1;
(statearr_72842_72950[(2)] = inst_72831);

(statearr_72842_72950[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72838 === (4))){
var inst_72833 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_72944);
var state_72837__$1 = state_72837;
var statearr_72843_72951 = state_72837__$1;
(statearr_72843_72951[(2)] = inst_72833);

(statearr_72843_72951[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72838 === (5))){
var inst_72835 = (state_72837[(2)]);
var state_72837__$1 = state_72837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72837__$1,inst_72835);
} else {
return null;
}
}
}
}
}
});})(seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,c__2706__auto___72947,healthcheck_uri_72945,resp_chan_72946,server_72944,seq__72737_72938__$1,temp__5804__auto___72937))
;
return ((function (seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,switch__2683__auto__,c__2706__auto___72947,healthcheck_uri_72945,resp_chan_72946,server_72944,seq__72737_72938__$1,temp__5804__auto___72937){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_72844 = [null,null,null,null,null,null,null,null];
(statearr_72844[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_72844[(1)] = (1));

return statearr_72844;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_72837){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72837);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72845){var ex__2687__auto__ = e72845;
var statearr_72846_72952 = state_72837;
(statearr_72846_72952[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72837[(4)]))){
var statearr_72847_72953 = state_72837;
(statearr_72847_72953[(1)] = cljs.core.first((state_72837[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72954 = state_72837;
state_72837 = G__72954;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_72837){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_72837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,switch__2683__auto__,c__2706__auto___72947,healthcheck_uri_72945,resp_chan_72946,server_72944,seq__72737_72938__$1,temp__5804__auto___72937))
})();
var state__2708__auto__ = (function (){var statearr_72848 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72848[(6)] = c__2706__auto___72947);

return statearr_72848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});})(seq__72737_72918,chunk__72738_72919,count__72739_72920,i__72740_72921,c__2706__auto___72947,healthcheck_uri_72945,resp_chan_72946,server_72944,seq__72737_72938__$1,temp__5804__auto___72937))
);



var G__72955 = cljs.core.next(seq__72737_72938__$1);
var G__72956 = null;
var G__72957 = (0);
var G__72958 = (0);
seq__72737_72918 = G__72955;
chunk__72738_72919 = G__72956;
count__72739_72920 = G__72957;
i__72740_72921 = G__72958;
continue;
}
} else {
}
}
break;
}

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72892){
var state_val_72893 = (state_72892[(1)]);
if((state_val_72893 === (7))){
var inst_72864 = (state_72892[(7)]);
var inst_72871 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72864,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_72892__$1 = state_72892;
if(inst_72871){
var statearr_72894_72959 = state_72892__$1;
(statearr_72894_72959[(1)] = (9));

} else {
var statearr_72895_72960 = state_72892__$1;
(statearr_72895_72960[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (1))){
var inst_72857 = (state_72892[(8)]);
var inst_72856 = (state_72892[(9)]);
var inst_72856__$1 = promise_chan;
var inst_72857__$1 = cljs.core.async.timeout((60000));
var inst_72858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72859 = [inst_72856__$1,inst_72857__$1];
var inst_72860 = (new cljs.core.PersistentVector(null,2,(5),inst_72858,inst_72859,null));
var state_72892__$1 = (function (){var statearr_72896 = state_72892;
(statearr_72896[(8)] = inst_72857__$1);

(statearr_72896[(9)] = inst_72856__$1);

return statearr_72896;
})();
return cljs.core.async.ioc_alts_BANG_(state_72892__$1,(2),inst_72860);
} else {
if((state_val_72893 === (4))){
var inst_72864 = (state_72892[(7)]);
var inst_72857 = (state_72892[(8)]);
var inst_72868 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72864,inst_72857);
var state_72892__$1 = state_72892;
if(inst_72868){
var statearr_72897_72961 = state_72892__$1;
(statearr_72897_72961[(1)] = (6));

} else {
var statearr_72898_72962 = state_72892__$1;
(statearr_72898_72962[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (13))){
var state_72892__$1 = state_72892;
var statearr_72899_72963 = state_72892__$1;
(statearr_72899_72963[(2)] = null);

(statearr_72899_72963[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (6))){
var state_72892__$1 = state_72892;
var statearr_72900_72964 = state_72892__$1;
(statearr_72900_72964[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_72900_72964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (3))){
var state_72892__$1 = state_72892;
var statearr_72901_72965 = state_72892__$1;
(statearr_72901_72965[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_72901_72965[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (12))){
var inst_72882 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_72883 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72884 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_72885 = cljs.core.PersistentHashMap.fromArrays(inst_72883,inst_72884);
var inst_72886 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_72885);
var inst_72887 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_72886);
var state_72892__$1 = (function (){var statearr_72902 = state_72892;
(statearr_72902[(10)] = inst_72882);

return statearr_72902;
})();
var statearr_72903_72966 = state_72892__$1;
(statearr_72903_72966[(2)] = inst_72887);

(statearr_72903_72966[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (2))){
var inst_72864 = (state_72892[(7)]);
var inst_72856 = (state_72892[(9)]);
var inst_72862 = (state_72892[(2)]);
var inst_72863 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72862,(0),null);
var inst_72864__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72862,(1),null);
var inst_72865 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72864__$1,inst_72856);
var state_72892__$1 = (function (){var statearr_72904 = state_72892;
(statearr_72904[(7)] = inst_72864__$1);

(statearr_72904[(11)] = inst_72863);

return statearr_72904;
})();
if(inst_72865){
var statearr_72905_72967 = state_72892__$1;
(statearr_72905_72967[(1)] = (3));

} else {
var statearr_72906_72968 = state_72892__$1;
(statearr_72906_72968[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (11))){
var inst_72875 = (state_72892[(2)]);
var state_72892__$1 = state_72892;
var statearr_72907_72969 = state_72892__$1;
(statearr_72907_72969[(2)] = inst_72875);

(statearr_72907_72969[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (9))){
var inst_72863 = (state_72892[(11)]);
var state_72892__$1 = state_72892;
var statearr_72908_72970 = state_72892__$1;
(statearr_72908_72970[(2)] = inst_72863);

(statearr_72908_72970[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (5))){
var inst_72879 = (state_72892[(2)]);
var inst_72880 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_72879);
var state_72892__$1 = state_72892;
if(inst_72880){
var statearr_72909_72971 = state_72892__$1;
(statearr_72909_72971[(1)] = (12));

} else {
var statearr_72910_72972 = state_72892__$1;
(statearr_72910_72972[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (14))){
var inst_72890 = (state_72892[(2)]);
var state_72892__$1 = state_72892;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72892__$1,inst_72890);
} else {
if((state_val_72893 === (10))){
var state_72892__$1 = state_72892;
var statearr_72911_72973 = state_72892__$1;
(statearr_72911_72973[(2)] = null);

(statearr_72911_72973[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72893 === (8))){
var inst_72877 = (state_72892[(2)]);
var state_72892__$1 = state_72892;
var statearr_72912_72974 = state_72892__$1;
(statearr_72912_72974[(2)] = inst_72877);

(statearr_72912_72974[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_72913 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72913[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_72913[(1)] = (1));

return statearr_72913;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_72892){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72892);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72914){var ex__2687__auto__ = e72914;
var statearr_72915_72975 = state_72892;
(statearr_72915_72975[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72892[(4)]))){
var statearr_72916_72976 = state_72892;
(statearr_72916_72976[(1)] = cljs.core.first((state_72892[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72977 = state_72892;
state_72892 = G__72977;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_72892){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_72892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72917 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72917[(6)] = c__2706__auto__);

return statearr_72917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73021){
var state_val_73022 = (state_73021[(1)]);
if((state_val_73022 === (7))){
var state_73021__$1 = state_73021;
var statearr_73023_73049 = state_73021__$1;
(statearr_73023_73049[(2)] = null);

(statearr_73023_73049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73022 === (1))){
var state_73021__$1 = state_73021;
var statearr_73024_73050 = state_73021__$1;
(statearr_73024_73050[(2)] = null);

(statearr_73024_73050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73022 === (4))){
var inst_72978 = (state_73021[(2)]);
var state_73021__$1 = state_73021;
var statearr_73025_73051 = state_73021__$1;
(statearr_73025_73051[(2)] = inst_72978);

(statearr_73025_73051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73022 === (6))){
var inst_73000 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_73021__$1 = state_73021;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73021__$1,(9),inst_73000);
} else {
if((state_val_73022 === (3))){
var inst_73019 = (state_73021[(2)]);
var state_73021__$1 = state_73021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73021__$1,inst_73019);
} else {
if((state_val_73022 === (12))){
var inst_73013 = (state_73021[(2)]);
var state_73021__$1 = state_73021;
var statearr_73026_73052 = state_73021__$1;
(statearr_73026_73052[(2)] = inst_73013);

(statearr_73026_73052[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73022 === (2))){
var inst_72994 = (state_73021[(7)]);
var inst_72989 = (state_73021[(8)]);
var inst_72984 = (state_73021[(9)]);
var _ = (function (){var statearr_73027 = state_73021;
(statearr_73027[(4)] = cljs.core.cons((5),(state_73021[(4)])));

return statearr_73027;
})();
var inst_72984__$1 = cljs.core.random_uuid();
var inst_72985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72986 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_72987 = (new cljs.core.PersistentVector(null,2,(5),inst_72985,inst_72986,null));
var inst_72988 = (function (){var lock_id = inst_72984__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_72989__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_72987,inst_72988);
var inst_72990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72991 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_72992 = (new cljs.core.PersistentVector(null,3,(5),inst_72990,inst_72991,null));
var inst_72993 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72989__$1,inst_72992);
var inst_72994__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72984__$1,inst_72993);
var inst_72995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72996 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_72997 = (new cljs.core.PersistentVector(null,3,(5),inst_72995,inst_72996,null));
var inst_72998 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72989__$1,inst_72997);
var state_73021__$1 = (function (){var statearr_73028 = state_73021;
(statearr_73028[(7)] = inst_72994__$1);

(statearr_73028[(8)] = inst_72989__$1);

(statearr_73028[(9)] = inst_72984__$1);

(statearr_73028[(10)] = inst_72998);

return statearr_73028;
})();
if(inst_72994__$1){
var statearr_73029_73053 = state_73021__$1;
(statearr_73029_73053[(1)] = (6));

} else {
var statearr_73030_73054 = state_73021__$1;
(statearr_73030_73054[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73022 === (11))){
var inst_72998 = (state_73021[(10)]);
var inst_73005 = (state_73021[(11)]);
var inst_73004 = (state_73021[(12)]);
var inst_73011 = fluree.db.util.xhttp.try_socket(inst_73004,sub_chan,pub_chan,inst_72998,(60000),inst_73005);
var state_73021__$1 = state_73021;
var statearr_73032_73055 = state_73021__$1;
(statearr_73032_73055[(2)] = inst_73011);

(statearr_73032_73055[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73022 === (9))){
var inst_72994 = (state_73021[(7)]);
var inst_72989 = (state_73021[(8)]);
var inst_73002 = (state_73021[(13)]);
var inst_72984 = (state_73021[(9)]);
var inst_72998 = (state_73021[(10)]);
var inst_73004 = (state_73021[(12)]);
var inst_73002__$1 = (state_73021[(2)]);
var inst_73003 = clojure.string.replace(inst_73002__$1,"http","ws");
var inst_73004__$1 = [inst_73003,"/fdb/ws"].join('');
var inst_73005 = (function (){var lock_id = inst_72984;
var state = inst_72989;
var have_lock_QMARK_ = inst_72994;
var resp_chan = inst_72998;
var healthy_server = inst_73002__$1;
var ws_url = inst_73004__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_73006 = fluree.db.util.core.exception_QMARK_(inst_73002__$1);
var state_73021__$1 = (function (){var statearr_73033 = state_73021;
(statearr_73033[(13)] = inst_73002__$1);

(statearr_73033[(11)] = inst_73005);

(statearr_73033[(12)] = inst_73004__$1);

return statearr_73033;
})();
if(inst_73006){
var statearr_73034_73056 = state_73021__$1;
(statearr_73034_73056[(1)] = (10));

} else {
var statearr_73035_73057 = state_73021__$1;
(statearr_73035_73057[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73022 === (5))){
var _ = (function (){var statearr_73036 = state_73021;
(statearr_73036[(4)] = cljs.core.rest((state_73021[(4)])));

return statearr_73036;
})();
var state_73021__$1 = state_73021;
var ex73031 = (state_73021__$1[(2)]);
var statearr_73037_73058 = state_73021__$1;
(statearr_73037_73058[(5)] = ex73031);


if((ex73031 instanceof Error)){
var statearr_73038_73059 = state_73021__$1;
(statearr_73038_73059[(1)] = (4));

(statearr_73038_73059[(5)] = null);

} else {
throw ex73031;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73022 === (10))){
var inst_73002 = (state_73021[(13)]);
var inst_72998 = (state_73021[(10)]);
var inst_73008 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_73009 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72998,inst_73002);
var state_73021__$1 = (function (){var statearr_73039 = state_73021;
(statearr_73039[(14)] = inst_73008);

return statearr_73039;
})();
var statearr_73040_73060 = state_73021__$1;
(statearr_73040_73060[(2)] = inst_73009);

(statearr_73040_73060[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73022 === (8))){
var inst_72998 = (state_73021[(10)]);
var inst_73016 = (state_73021[(2)]);
var _ = (function (){var statearr_73041 = state_73021;
(statearr_73041[(4)] = cljs.core.rest((state_73021[(4)])));

return statearr_73041;
})();
var state_73021__$1 = (function (){var statearr_73042 = state_73021;
(statearr_73042[(15)] = inst_73016);

return statearr_73042;
})();
var statearr_73043_73061 = state_73021__$1;
(statearr_73043_73061[(2)] = inst_72998);

(statearr_73043_73061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_73044 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73044[(0)] = fluree$db$connection$establish_socket_$_state_machine__2684__auto__);

(statearr_73044[(1)] = (1));

return statearr_73044;
});
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____1 = (function (state_73021){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73021);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73045){var ex__2687__auto__ = e73045;
var statearr_73046_73062 = state_73021;
(statearr_73046_73062[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73021[(4)]))){
var statearr_73047_73063 = state_73021;
(statearr_73047_73063[(1)] = cljs.core.first((state_73021[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73064 = state_73021;
state_73021 = G__73064;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = function(state_73021){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____1.call(this,state_73021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73048 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73048[(6)] = c__2706__auto__);

return statearr_73048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k73066,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__73070 = k73066;
var G__73070__$1 = (((G__73070 instanceof cljs.core.Keyword))?G__73070.fqn:null);
switch (G__73070__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k73066,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__73071){
var vec__73072 = p__73071;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73072,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73072,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__73065){
var self__ = this;
var G__73065__$1 = this;
return (new cljs.core.RecordIter((0),G__73065__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__73075 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__73075(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this73067,other73068){
var self__ = this;
var this73067__$1 = this;
return (((!((other73068 == null)))) && ((((this73067__$1.constructor === other73068.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.id,other73068.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.servers,other73068.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.state,other73068.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.req_chan,other73068.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.sub_chan,other73068.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.pub_chan,other73068.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.group,other73068.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.storage_read,other73068.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.storage_list,other73068.storage_list)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.storage_write,other73068.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.storage_exists,other73068.storage_exists)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.storage_rename,other73068.storage_rename)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.storage_delete,other73068.storage_delete)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.object_cache,other73068.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.async_cache,other73068.async_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.parallelism,other73068.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.serializer,other73068.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.default_network,other73068.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.transactor_QMARK_,other73068.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.publish,other73068.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.transact_handler,other73068.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.tx_private_key,other73068.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.tx_key_id,other73068.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.meta,other73068.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.add_listener,other73068.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.remove_listener,other73068.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.close,other73068.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73067__$1.__extmap,other73068.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__73076){
var self__ = this;
var map__73077 = p__73076;
var map__73077__$1 = cljs.core.__destructure_map(map__73077);
var node = map__73077__$1;
var id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73077__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73077__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73077__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf(node);
} else {
var G__73078 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__73079 = (function (_){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3(conn__$1,node,(function (){
var G__73080 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__73081 = null;
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__73080,G__73081) : self__.async_cache.call(null,G__73080,G__73081));
}));
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__73078,G__73079) : self__.async_cache.call(null,G__73078,G__73079));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k73066){
var self__ = this;
var this__5350__auto____$1 = this;
var G__73082 = k73066;
var G__73082__$1 = (((G__73082 instanceof cljs.core.Keyword))?G__73082.fqn:null);
switch (G__73082__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k73066);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__73065){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__73083 = cljs.core.keyword_identical_QMARK_;
var expr__73084 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__73086 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__73087 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73086,G__73087) : pred__73083.call(null,G__73086,G__73087));
})())){
return (new fluree.db.connection.Connection(G__73065,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73088 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__73089 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73088,G__73089) : pred__73083.call(null,G__73088,G__73089));
})())){
return (new fluree.db.connection.Connection(self__.id,G__73065,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73090 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__73091 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73090,G__73091) : pred__73083.call(null,G__73090,G__73091));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__73065,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73092 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__73093 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73092,G__73093) : pred__73083.call(null,G__73092,G__73093));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__73065,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73094 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__73095 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73094,G__73095) : pred__73083.call(null,G__73094,G__73095));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__73065,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73096 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__73097 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73096,G__73097) : pred__73083.call(null,G__73096,G__73097));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__73065,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73098 = new cljs.core.Keyword(null,"group","group",582596132);
var G__73099 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73098,G__73099) : pred__73083.call(null,G__73098,G__73099));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__73065,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73100 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__73101 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73100,G__73101) : pred__73083.call(null,G__73100,G__73101));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__73065,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73102 = new cljs.core.Keyword(null,"storage-list","storage-list",1202854328);
var G__73103 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73102,G__73103) : pred__73083.call(null,G__73102,G__73103));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__73065,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73104 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__73105 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73104,G__73105) : pred__73083.call(null,G__73104,G__73105));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__73065,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73106 = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075);
var G__73107 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73106,G__73107) : pred__73083.call(null,G__73106,G__73107));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__73065,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73108 = new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229);
var G__73109 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73108,G__73109) : pred__73083.call(null,G__73108,G__73109));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__73065,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73110 = new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532);
var G__73111 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73110,G__73111) : pred__73083.call(null,G__73110,G__73111));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__73065,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73112 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__73113 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73112,G__73113) : pred__73083.call(null,G__73112,G__73113));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__73065,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73114 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__73115 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73114,G__73115) : pred__73083.call(null,G__73114,G__73115));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__73065,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73116 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__73117 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73116,G__73117) : pred__73083.call(null,G__73116,G__73117));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__73065,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73118 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__73119 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73118,G__73119) : pred__73083.call(null,G__73118,G__73119));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__73065,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73120 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__73121 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73120,G__73121) : pred__73083.call(null,G__73120,G__73121));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__73065,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73122 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__73123 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73122,G__73123) : pred__73083.call(null,G__73122,G__73123));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__73065,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73124 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__73125 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73124,G__73125) : pred__73083.call(null,G__73124,G__73125));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__73065,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73126 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__73127 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73126,G__73127) : pred__73083.call(null,G__73126,G__73127));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__73065,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73128 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__73129 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73128,G__73129) : pred__73083.call(null,G__73128,G__73129));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__73065,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73130 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__73131 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73130,G__73131) : pred__73083.call(null,G__73130,G__73131));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__73065,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73132 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__73133 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73132,G__73133) : pred__73083.call(null,G__73132,G__73133));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__73065,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73134 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__73135 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73134,G__73135) : pred__73083.call(null,G__73134,G__73135));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__73065,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73136 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__73137 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73136,G__73137) : pred__73083.call(null,G__73136,G__73137));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__73065,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73138 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__73139 = expr__73084;
return (pred__73083.cljs$core$IFn$_invoke$arity$2 ? pred__73083.cljs$core$IFn$_invoke$arity$2(G__73138,G__73139) : pred__73083.call(null,G__73138,G__73139));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__73065,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__73065),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_read.cljs$core$IFn$_invoke$arity$1 ? self__.storage_read.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_read.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return (self__.storage_write.cljs$core$IFn$_invoke$arity$2 ? self__.storage_write.cljs$core$IFn$_invoke$arity$2(k,data) : self__.storage_write.call(null,k,data));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_exists.cljs$core$IFn$_invoke$arity$1 ? self__.storage_exists.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_exists.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return (self__.storage_rename.cljs$core$IFn$_invoke$arity$2 ? self__.storage_rename.cljs$core$IFn$_invoke$arity$2(old_key,new_key) : self__.storage_rename.call(null,old_key,new_key));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return (self__.storage_list.cljs$core$IFn$_invoke$arity$1 ? self__.storage_list.cljs$core$IFn$_invoke$arity$1(d) : self__.storage_list.call(null,d));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_delete.cljs$core$IFn$_invoke$arity$1 ? self__.storage_delete.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_delete.call(null,k));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__73065){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__73065,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__73069){
var extmap__5385__auto__ = (function (){var G__73140 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__73069,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__73069)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__73140);
} else {
return G__73140;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__73069),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__73069),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__73146 = servers_STAR_;
var vec__73147 = G__73146;
var seq__73148 = cljs.core.seq(vec__73147);
var first__73149 = cljs.core.first(seq__73148);
var seq__73148__$1 = cljs.core.next(seq__73148);
var server = first__73149;
var r = seq__73148__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__73146__$1 = G__73146;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__73153 = G__73146__$1;
var seq__73154 = cljs.core.seq(vec__73153);
var first__73155 = cljs.core.first(seq__73154);
var seq__73154__$1 = cljs.core.next(seq__73154);
var server__$1 = first__73155;
var r__$1 = seq__73154__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__73156 = r__$1;
var G__73157 = is_https_QMARK_;
var G__73158 = result_STAR_;
G__73146__$1 = G__73156;
https_QMARK___$1 = G__73157;
result__$1 = G__73158;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__73159 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__73159 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__73159);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73188){
var state_val_73189 = (state_73188[(1)]);
if((state_val_73189 === (7))){
var inst_73174 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73175 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73176 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73177 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73178 = fluree.db.connection.establish_socket(inst_73174,inst_73175,inst_73176,inst_73177);
var state_73188__$1 = state_73188;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73188__$1,(9),inst_73178);
} else {
if((state_val_73189 === (1))){
var state_73188__$1 = state_73188;
var statearr_73190_73209 = state_73188__$1;
(statearr_73190_73209[(2)] = null);

(statearr_73190_73209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73189 === (4))){
var inst_73160 = (state_73188[(2)]);
var state_73188__$1 = state_73188;
var statearr_73191_73210 = state_73188__$1;
(statearr_73191_73210[(2)] = inst_73160);

(statearr_73191_73210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73189 === (6))){
var inst_73171 = (state_73188[(7)]);
var state_73188__$1 = state_73188;
var statearr_73192_73211 = state_73188__$1;
(statearr_73192_73211[(2)] = inst_73171);

(statearr_73192_73211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73189 === (3))){
var inst_73186 = (state_73188[(2)]);
var state_73188__$1 = state_73188;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73188__$1,inst_73186);
} else {
if((state_val_73189 === (2))){
var inst_73171 = (state_73188[(7)]);
var _ = (function (){var statearr_73194 = state_73188;
(statearr_73194[(4)] = cljs.core.cons((5),(state_73188[(4)])));

return statearr_73194;
})();
var inst_73166 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_73167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73168 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73169 = [inst_73168,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_73170 = (new cljs.core.PersistentVector(null,3,(5),inst_73167,inst_73169,null));
var inst_73171__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_73166,inst_73170);
var state_73188__$1 = (function (){var statearr_73195 = state_73188;
(statearr_73195[(7)] = inst_73171__$1);

return statearr_73195;
})();
if(cljs.core.truth_(inst_73171__$1)){
var statearr_73196_73212 = state_73188__$1;
(statearr_73196_73212[(1)] = (6));

} else {
var statearr_73197_73213 = state_73188__$1;
(statearr_73197_73213[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73189 === (9))){
var inst_73180 = (state_73188[(2)]);
var inst_73181 = fluree.db.util.async.throw_err(inst_73180);
var state_73188__$1 = state_73188;
var statearr_73198_73214 = state_73188__$1;
(statearr_73198_73214[(2)] = inst_73181);

(statearr_73198_73214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73189 === (5))){
var _ = (function (){var statearr_73199 = state_73188;
(statearr_73199[(4)] = cljs.core.rest((state_73188[(4)])));

return statearr_73199;
})();
var state_73188__$1 = state_73188;
var ex73193 = (state_73188__$1[(2)]);
var statearr_73200_73215 = state_73188__$1;
(statearr_73200_73215[(5)] = ex73193);


if((ex73193 instanceof Error)){
var statearr_73201_73216 = state_73188__$1;
(statearr_73201_73216[(1)] = (4));

(statearr_73201_73216[(5)] = null);

} else {
throw ex73193;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73189 === (8))){
var inst_73183 = (state_73188[(2)]);
var _ = (function (){var statearr_73202 = state_73188;
(statearr_73202[(4)] = cljs.core.rest((state_73188[(4)])));

return statearr_73202;
})();
var state_73188__$1 = state_73188;
var statearr_73203_73217 = state_73188__$1;
(statearr_73203_73217[(2)] = inst_73183);

(statearr_73203_73217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_73204 = [null,null,null,null,null,null,null,null];
(statearr_73204[(0)] = fluree$db$connection$get_socket_$_state_machine__2684__auto__);

(statearr_73204[(1)] = (1));

return statearr_73204;
});
var fluree$db$connection$get_socket_$_state_machine__2684__auto____1 = (function (state_73188){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73188);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73205){var ex__2687__auto__ = e73205;
var statearr_73206_73218 = state_73188;
(statearr_73206_73218[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73188[(4)]))){
var statearr_73207_73219 = state_73188;
(statearr_73207_73219[(1)] = cljs.core.first((state_73188[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73220 = state_73188;
state_73188 = G__73220;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2684__auto__ = function(state_73188){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____1.call(this,state_73188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2684__auto____0;
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73208 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73208[(6)] = c__2706__auto__);

return statearr_73208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e73221){var e = e73221;
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__73223){
var map__73224 = p__73223;
var map__73224__$1 = cljs.core.__destructure_map(map__73224);
var conn = map__73224__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73224__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73224__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73224__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73370){
var state_val_73371 = (state_73370[(1)]);
if((state_val_73371 === (7))){
var inst_73366 = (state_73370[(2)]);
var state_73370__$1 = state_73370;
var statearr_73373_73447 = state_73370__$1;
(statearr_73373_73447[(2)] = inst_73366);

(statearr_73373_73447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (20))){
var _ = (function (){var statearr_73374 = state_73370;
(statearr_73374[(4)] = cljs.core.rest((state_73370[(4)])));

return statearr_73374;
})();
var state_73370__$1 = state_73370;
var ex73372 = (state_73370__$1[(2)]);
var statearr_73375_73448 = state_73370__$1;
(statearr_73375_73448[(5)] = ex73372);


var statearr_73376_73449 = state_73370__$1;
(statearr_73376_73449[(1)] = (10));

(statearr_73376_73449[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (27))){
var inst_73327 = (state_73370[(7)]);
var inst_73327__$1 = (state_73370[(2)]);
var inst_73328 = inst_73327__$1 === true;
var state_73370__$1 = (function (){var statearr_73377 = state_73370;
(statearr_73377[(7)] = inst_73327__$1);

return statearr_73377;
})();
if(cljs.core.truth_(inst_73328)){
var statearr_73378_73450 = state_73370__$1;
(statearr_73378_73450[(1)] = (28));

} else {
var statearr_73379_73451 = state_73370__$1;
(statearr_73379_73451[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (1))){
var inst_73225 = (0);
var state_73370__$1 = (function (){var statearr_73380 = state_73370;
(statearr_73380[(8)] = inst_73225);

return statearr_73380;
})();
var statearr_73381_73452 = state_73370__$1;
(statearr_73381_73452[(2)] = null);

(statearr_73381_73452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (24))){
var inst_73317 = (state_73370[(9)]);
var state_73370__$1 = state_73370;
var statearr_73382_73453 = state_73370__$1;
(statearr_73382_73453[(2)] = inst_73317);

(statearr_73382_73453[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (39))){
var inst_73352 = (state_73370[(2)]);
var state_73370__$1 = state_73370;
var statearr_73383_73454 = state_73370__$1;
(statearr_73383_73454[(2)] = inst_73352);

(statearr_73383_73454[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (4))){
var inst_73228 = (state_73370[(10)]);
var inst_73228__$1 = (state_73370[(2)]);
var state_73370__$1 = (function (){var statearr_73384 = state_73370;
(statearr_73384[(10)] = inst_73228__$1);

return statearr_73384;
})();
if(cljs.core.truth_(inst_73228__$1)){
var statearr_73385_73455 = state_73370__$1;
(statearr_73385_73455[(1)] = (5));

} else {
var statearr_73386_73456 = state_73370__$1;
(statearr_73386_73456[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (15))){
var inst_73241 = (state_73370[(11)]);
var state_73370__$1 = state_73370;
var statearr_73387_73457 = state_73370__$1;
(statearr_73387_73457[(2)] = inst_73241);

(statearr_73387_73457[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (21))){
var inst_73270 = (state_73370[(12)]);
var inst_73273 = (state_73370[(13)]);
var inst_73275 = (state_73370[(14)]);
var inst_73225 = (state_73370[(8)]);
var inst_73279 = (state_73370[(15)]);
var inst_73274 = (state_73370[(16)]);
var inst_73278 = (state_73370[(17)]);
var inst_73228 = (state_73370[(10)]);
var inst_73271 = (state_73370[(18)]);
var inst_73272 = (state_73370[(19)]);
var inst_73281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73282 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_73278];
var inst_73283 = (new cljs.core.PersistentVector(null,2,(5),inst_73281,inst_73282,null));
var inst_73284 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_73283,inst_73273);
var inst_73311 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_73312 = (function (){var resp_chan = inst_73273;
var timeout = inst_73279;
var i = inst_73225;
var data = inst_73272;
var vec__73263 = inst_73228;
var _ = inst_73270;
var req_id = inst_73278;
var operation = inst_73271;
var msg = inst_73228;
var temp__5804__auto__ = inst_73228;
var c__2706__auto____$1 = inst_73311;
var map__73266 = inst_73275;
var opts = inst_73274;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73309){
var state_val_73310 = (state_73309[(1)]);
if((state_val_73310 === (1))){
var inst_73288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73289 = cljs.core.async.timeout(timeout);
var inst_73290 = [resp_chan,inst_73289];
var inst_73291 = (new cljs.core.PersistentVector(null,2,(5),inst_73288,inst_73290,null));
var state_73309__$1 = state_73309;
return cljs.core.async.ioc_alts_BANG_(state_73309__$1,(2),inst_73291);
} else {
if((state_val_73310 === (2))){
var inst_73294 = (state_73309[(7)]);
var inst_73293 = (state_73309[(2)]);
var inst_73294__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73293,(0),null);
var inst_73295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73293,(1),null);
var inst_73296 = (function (){var vec__73285 = inst_73293;
var resp = inst_73294__$1;
var c = inst_73295;
return (function (p1__73222_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__73222_SHARP_,req_id);
});
})();
var inst_73297 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_73296);
var inst_73298 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73295,resp_chan);
var state_73309__$1 = (function (){var statearr_73388 = state_73309;
(statearr_73388[(8)] = inst_73297);

(statearr_73388[(7)] = inst_73294__$1);

return statearr_73388;
})();
if(inst_73298){
var statearr_73389_73458 = state_73309__$1;
(statearr_73389_73458[(1)] = (3));

} else {
var statearr_73390_73459 = state_73309__$1;
(statearr_73390_73459[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73310 === (3))){
var inst_73294 = (state_73309[(7)]);
var state_73309__$1 = state_73309;
var statearr_73391_73460 = state_73309__$1;
(statearr_73391_73460[(2)] = inst_73294);

(statearr_73391_73460[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73310 === (4))){
var inst_73301 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_73302 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73303 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_73304 = cljs.core.PersistentHashMap.fromArrays(inst_73302,inst_73303);
var inst_73305 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73301,inst_73304);
var state_73309__$1 = state_73309;
var statearr_73392_73461 = state_73309__$1;
(statearr_73392_73461[(2)] = inst_73305);

(statearr_73392_73461[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73310 === (5))){
var inst_73307 = (state_73309[(2)]);
var state_73309__$1 = state_73309;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73309__$1,inst_73307);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_73393 = [null,null,null,null,null,null,null,null,null];
(statearr_73393[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_73393[(1)] = (1));

return statearr_73393;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_73309){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73309);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73394){var ex__2687__auto__ = e73394;
var statearr_73395_73462 = state_73309;
(statearr_73395_73462[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73309[(4)]))){
var statearr_73396_73463 = state_73309;
(statearr_73396_73463[(1)] = cljs.core.first((state_73309[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73464 = state_73309;
state_73309 = G__73464;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_73309){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_73309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73397 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73397[(6)] = c__2706__auto____$1);

return statearr_73397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_73313 = cljs.core.async.impl.dispatch.run(inst_73312);
var state_73370__$1 = (function (){var statearr_73398 = state_73370;
(statearr_73398[(20)] = inst_73313);

(statearr_73398[(21)] = inst_73284);

return statearr_73398;
})();
var statearr_73399_73465 = state_73370__$1;
(statearr_73399_73465[(2)] = inst_73311);

(statearr_73399_73465[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (31))){
var inst_73327 = (state_73370[(7)]);
var inst_73333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73334 = [inst_73327,"Error processing message in producer."];
var inst_73335 = (new cljs.core.PersistentVector(null,2,(5),inst_73333,inst_73334,null));
var inst_73336 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73335);
var state_73370__$1 = state_73370;
var statearr_73400_73466 = state_73370__$1;
(statearr_73400_73466[(2)] = inst_73336);

(statearr_73400_73466[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (32))){
var inst_73327 = (state_73370[(7)]);
var inst_73338 = (inst_73327 == null);
var state_73370__$1 = state_73370;
if(cljs.core.truth_(inst_73338)){
var statearr_73401_73467 = state_73370__$1;
(statearr_73401_73467[(1)] = (34));

} else {
var statearr_73402_73468 = state_73370__$1;
(statearr_73402_73468[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (33))){
var inst_73356 = (state_73370[(2)]);
var state_73370__$1 = state_73370;
var statearr_73403_73469 = state_73370__$1;
(statearr_73403_73469[(2)] = inst_73356);

(statearr_73403_73469[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (13))){
var inst_73241 = (state_73370[(11)]);
var inst_73238 = (state_73370[(2)]);
var inst_73239 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73238,(0),null);
var inst_73240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73238,(1),null);
var inst_73241__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73238,(2),null);
var state_73370__$1 = (function (){var statearr_73404 = state_73370;
(statearr_73404[(11)] = inst_73241__$1);

(statearr_73404[(22)] = inst_73240);

(statearr_73404[(23)] = inst_73239);

return statearr_73404;
})();
if(cljs.core.truth_(inst_73241__$1)){
var statearr_73405_73470 = state_73370__$1;
(statearr_73405_73470[(1)] = (14));

} else {
var statearr_73406_73471 = state_73370__$1;
(statearr_73406_73471[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (22))){
var state_73370__$1 = state_73370;
var statearr_73407_73472 = state_73370__$1;
(statearr_73407_73472[(2)] = null);

(statearr_73407_73472[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (36))){
var inst_73354 = (state_73370[(2)]);
var state_73370__$1 = state_73370;
var statearr_73408_73473 = state_73370__$1;
(statearr_73408_73473[(2)] = inst_73354);

(statearr_73408_73473[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (29))){
var inst_73327 = (state_73370[(7)]);
var inst_73331 = fluree.db.util.core.exception_QMARK_(inst_73327);
var state_73370__$1 = state_73370;
if(inst_73331){
var statearr_73409_73474 = state_73370__$1;
(statearr_73409_73474[(1)] = (31));

} else {
var statearr_73410_73475 = state_73370__$1;
(statearr_73410_73475[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (6))){
var state_73370__$1 = state_73370;
var statearr_73411_73476 = state_73370__$1;
(statearr_73411_73476[(2)] = null);

(statearr_73411_73476[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (28))){
var state_73370__$1 = state_73370;
var statearr_73412_73477 = state_73370__$1;
(statearr_73412_73477[(2)] = null);

(statearr_73412_73477[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (25))){
var state_73370__$1 = state_73370;
var statearr_73413_73478 = state_73370__$1;
(statearr_73413_73478[(2)] = fluree.db.connection.default_publish_fn);

(statearr_73413_73478[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (34))){
var inst_73340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73341 = ["Error processing message in producer. Socket closed."];
var inst_73342 = (new cljs.core.PersistentVector(null,1,(5),inst_73340,inst_73341,null));
var inst_73343 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73342);
var state_73370__$1 = state_73370;
var statearr_73414_73479 = state_73370__$1;
(statearr_73414_73479[(2)] = inst_73343);

(statearr_73414_73479[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (17))){
var inst_73241 = (state_73370[(11)]);
var inst_73230 = (state_73370[(24)]);
var inst_73248 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73241,inst_73230);
var state_73370__$1 = state_73370;
var statearr_73415_73480 = state_73370__$1;
(statearr_73415_73480[(2)] = inst_73248);

(statearr_73415_73480[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (3))){
var inst_73368 = (state_73370[(2)]);
var state_73370__$1 = state_73370;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73370__$1,inst_73368);
} else {
if((state_val_73371 === (12))){
var state_73370__$1 = state_73370;
var statearr_73416_73481 = state_73370__$1;
(statearr_73416_73481[(2)] = null);

(statearr_73416_73481[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (2))){
var state_73370__$1 = state_73370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73370__$1,(4),req_chan);
} else {
if((state_val_73371 === (23))){
var inst_73317 = (state_73370[(9)]);
var inst_73316 = (state_73370[(2)]);
var inst_73317__$1 = publish;
var state_73370__$1 = (function (){var statearr_73417 = state_73370;
(statearr_73417[(9)] = inst_73317__$1);

(statearr_73417[(25)] = inst_73316);

return statearr_73417;
})();
if(cljs.core.truth_(inst_73317__$1)){
var statearr_73418_73482 = state_73370__$1;
(statearr_73418_73482[(1)] = (24));

} else {
var statearr_73419_73483 = state_73370__$1;
(statearr_73419_73483[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (35))){
var state_73370__$1 = state_73370;
var statearr_73420_73484 = state_73370__$1;
(statearr_73420_73484[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (19))){
var inst_73257 = (state_73370[(2)]);
var state_73370__$1 = state_73370;
var statearr_73422_73485 = state_73370__$1;
(statearr_73422_73485[(2)] = inst_73257);

(statearr_73422_73485[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (11))){
var inst_73228 = (state_73370[(10)]);
var state_73370__$1 = state_73370;
var statearr_73423_73486 = state_73370__$1;
(statearr_73423_73486[(2)] = inst_73228);

(statearr_73423_73486[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (9))){
var inst_73225 = (state_73370[(8)]);
var inst_73361 = (state_73370[(2)]);
var inst_73362 = (inst_73225 + (1));
var inst_73225__$1 = inst_73362;
var state_73370__$1 = (function (){var statearr_73424 = state_73370;
(statearr_73424[(26)] = inst_73361);

(statearr_73424[(8)] = inst_73225__$1);

return statearr_73424;
})();
var statearr_73425_73487 = state_73370__$1;
(statearr_73425_73487[(2)] = null);

(statearr_73425_73487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (5))){
var state_73370__$1 = state_73370;
var statearr_73426_73488 = state_73370__$1;
(statearr_73426_73488[(2)] = null);

(statearr_73426_73488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (14))){
var inst_73241 = (state_73370[(11)]);
var inst_73243 = fluree.db.util.async.channel_QMARK_(inst_73241);
var state_73370__$1 = state_73370;
var statearr_73427_73489 = state_73370__$1;
(statearr_73427_73489[(2)] = inst_73243);

(statearr_73427_73489[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (26))){
var inst_73278 = (state_73370[(17)]);
var inst_73271 = (state_73370[(18)]);
var inst_73272 = (state_73370[(19)]);
var inst_73321 = (state_73370[(2)]);
var inst_73322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73323 = [inst_73271,inst_73278,inst_73272];
var inst_73324 = (new cljs.core.PersistentVector(null,3,(5),inst_73322,inst_73323,null));
var inst_73325 = (inst_73321.cljs$core$IFn$_invoke$arity$2 ? inst_73321.cljs$core$IFn$_invoke$arity$2(conn,inst_73324) : inst_73321.call(null,conn,inst_73324));
var state_73370__$1 = state_73370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73370__$1,(27),inst_73325);
} else {
if((state_val_73371 === (16))){
var inst_73246 = (state_73370[(2)]);
var state_73370__$1 = state_73370;
if(cljs.core.truth_(inst_73246)){
var statearr_73428_73490 = state_73370__$1;
(statearr_73428_73490[(1)] = (17));

} else {
var statearr_73429_73491 = state_73370__$1;
(statearr_73429_73491[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (38))){
var state_73370__$1 = state_73370;
var statearr_73430_73492 = state_73370__$1;
(statearr_73430_73492[(2)] = null);

(statearr_73430_73492[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (30))){
var inst_73358 = (state_73370[(2)]);
var _ = (function (){var statearr_73431 = state_73370;
(statearr_73431[(4)] = cljs.core.rest((state_73370[(4)])));

return statearr_73431;
})();
var state_73370__$1 = state_73370;
var statearr_73432_73493 = state_73370__$1;
(statearr_73432_73493[(2)] = inst_73358);

(statearr_73432_73493[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (10))){
var inst_73228 = (state_73370[(10)]);
var inst_73230 = (state_73370[(2)]);
var inst_73234 = cljs.core.sequential_QMARK_(inst_73228);
var state_73370__$1 = (function (){var statearr_73433 = state_73370;
(statearr_73433[(24)] = inst_73230);

return statearr_73433;
})();
if(inst_73234){
var statearr_73434_73494 = state_73370__$1;
(statearr_73434_73494[(1)] = (11));

} else {
var statearr_73435_73495 = state_73370__$1;
(statearr_73435_73495[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (18))){
var inst_73230 = (state_73370[(24)]);
var inst_73228 = (state_73370[(10)]);
var inst_73250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73251 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73228], 0));
var inst_73252 = ["Error processing ledger request, no valid return channel: ",inst_73251].join('');
var inst_73253 = [inst_73230,inst_73252];
var inst_73254 = (new cljs.core.PersistentVector(null,2,(5),inst_73250,inst_73253,null));
var inst_73255 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73254);
var state_73370__$1 = state_73370;
var statearr_73436_73496 = state_73370__$1;
(statearr_73436_73496[(2)] = inst_73255);

(statearr_73436_73496[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (37))){
var inst_73327 = (state_73370[(7)]);
var inst_73346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73347 = ["Error processing message in producer. Socket closed. Published result",inst_73327];
var inst_73348 = (new cljs.core.PersistentVector(null,2,(5),inst_73346,inst_73347,null));
var inst_73349 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73348);
var state_73370__$1 = state_73370;
var statearr_73437_73497 = state_73370__$1;
(statearr_73437_73497[(2)] = inst_73349);

(statearr_73437_73497[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (8))){
var inst_73273 = (state_73370[(13)]);
var inst_73275 = (state_73370[(14)]);
var inst_73274 = (state_73370[(16)]);
var inst_73228 = (state_73370[(10)]);
var _ = (function (){var statearr_73438 = state_73370;
(statearr_73438[(4)] = cljs.core.cons((20),(state_73370[(4)])));

return statearr_73438;
})();
var inst_73267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73268 = ["Outgoing message to websocket: ",inst_73228];
var inst_73269 = (new cljs.core.PersistentVector(null,2,(5),inst_73267,inst_73268,null));
var inst_73270 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_73269);
var inst_73271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73228,(0),null);
var inst_73272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73228,(1),null);
var inst_73273__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73228,(2),null);
var inst_73274__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73228,(3),null);
var inst_73275__$1 = cljs.core.__destructure_map(inst_73274__$1);
var inst_73276 = cljs.core.random_uuid();
var inst_73277 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73276);
var inst_73278 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73275__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_73277);
var inst_73279 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73275__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_73370__$1 = (function (){var statearr_73439 = state_73370;
(statearr_73439[(12)] = inst_73270);

(statearr_73439[(13)] = inst_73273__$1);

(statearr_73439[(14)] = inst_73275__$1);

(statearr_73439[(15)] = inst_73279);

(statearr_73439[(16)] = inst_73274__$1);

(statearr_73439[(17)] = inst_73278);

(statearr_73439[(18)] = inst_73271);

(statearr_73439[(19)] = inst_73272);

return statearr_73439;
})();
if(cljs.core.truth_(inst_73273__$1)){
var statearr_73440_73498 = state_73370__$1;
(statearr_73440_73498[(1)] = (21));

} else {
var statearr_73441_73499 = state_73370__$1;
(statearr_73441_73499[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_73442 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73442[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_73442[(1)] = (1));

return statearr_73442;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_73370){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73370);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73443){var ex__2687__auto__ = e73443;
var statearr_73444_73500 = state_73370;
(statearr_73444_73500[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73370[(4)]))){
var statearr_73445_73501 = state_73370;
(statearr_73445_73501[(1)] = cljs.core.first((state_73370[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73502 = state_73370;
state_73370 = G__73502;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_73370){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_73370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73446 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73446[(6)] = c__2706__auto__);

return statearr_73446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73540){
var state_val_73541 = (state_73540[(1)]);
if((state_val_73541 === (7))){
var inst_73511 = (state_73540[(7)]);
var state_73540__$1 = state_73540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73540__$1,(9),inst_73511);
} else {
if((state_val_73541 === (1))){
var inst_73503 = (1);
var state_73540__$1 = (function (){var statearr_73542 = state_73540;
(statearr_73542[(8)] = inst_73503);

return statearr_73542;
})();
var statearr_73543_73566 = state_73540__$1;
(statearr_73543_73566[(2)] = null);

(statearr_73543_73566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73541 === (4))){
var inst_73508 = (state_73540[(2)]);
var inst_73509 = fluree.db.connection.get_socket(conn);
var state_73540__$1 = (function (){var statearr_73544 = state_73540;
(statearr_73544[(9)] = inst_73508);

return statearr_73544;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73540__$1,(5),inst_73509);
} else {
if((state_val_73541 === (15))){
var inst_73536 = (state_73540[(2)]);
var state_73540__$1 = state_73540;
var statearr_73545_73567 = state_73540__$1;
(statearr_73545_73567[(2)] = inst_73536);

(statearr_73545_73567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73541 === (13))){
var inst_73503 = (state_73540[(8)]);
var inst_73518 = (state_73540[(10)]);
var inst_73526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73527 = [inst_73518,"Cannot establish connection to a healthy server, backing off:",inst_73503,"s."];
var inst_73528 = (new cljs.core.PersistentVector(null,4,(5),inst_73526,inst_73527,null));
var inst_73529 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73528);
var inst_73530 = ((2) * inst_73503);
var inst_73531 = ((60) * (2));
var inst_73532 = ((inst_73530 < inst_73531) ? inst_73530 : inst_73531);
var inst_73503__$1 = inst_73532;
var state_73540__$1 = (function (){var statearr_73546 = state_73540;
(statearr_73546[(11)] = inst_73529);

(statearr_73546[(8)] = inst_73503__$1);

return statearr_73546;
})();
var statearr_73547_73568 = state_73540__$1;
(statearr_73547_73568[(2)] = null);

(statearr_73547_73568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73541 === (6))){
var inst_73511 = (state_73540[(7)]);
var state_73540__$1 = state_73540;
var statearr_73548_73569 = state_73540__$1;
(statearr_73548_73569[(2)] = inst_73511);

(statearr_73548_73569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73541 === (3))){
var inst_73538 = (state_73540[(2)]);
var state_73540__$1 = state_73540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73540__$1,inst_73538);
} else {
if((state_val_73541 === (12))){
var inst_73524 = (state_73540[(2)]);
var state_73540__$1 = state_73540;
if(cljs.core.truth_(inst_73524)){
var statearr_73549_73570 = state_73540__$1;
(statearr_73549_73570[(1)] = (13));

} else {
var statearr_73550_73571 = state_73540__$1;
(statearr_73550_73571[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73541 === (2))){
var inst_73503 = (state_73540[(8)]);
var inst_73505 = (inst_73503 * (1000));
var inst_73506 = cljs.core.async.timeout(inst_73505);
var state_73540__$1 = state_73540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73540__$1,(4),inst_73506);
} else {
if((state_val_73541 === (11))){
var inst_73518 = (state_73540[(10)]);
var inst_73522 = fluree.db.util.core.exception_QMARK_(inst_73518);
var state_73540__$1 = state_73540;
var statearr_73551_73572 = state_73540__$1;
(statearr_73551_73572[(2)] = inst_73522);

(statearr_73551_73572[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73541 === (9))){
var inst_73516 = (state_73540[(2)]);
var state_73540__$1 = state_73540;
var statearr_73552_73573 = state_73540__$1;
(statearr_73552_73573[(2)] = inst_73516);

(statearr_73552_73573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73541 === (5))){
var inst_73511 = (state_73540[(7)]);
var inst_73511__$1 = (state_73540[(2)]);
var inst_73512 = fluree.db.util.core.exception_QMARK_(inst_73511__$1);
var state_73540__$1 = (function (){var statearr_73553 = state_73540;
(statearr_73553[(7)] = inst_73511__$1);

return statearr_73553;
})();
if(inst_73512){
var statearr_73554_73574 = state_73540__$1;
(statearr_73554_73574[(1)] = (6));

} else {
var statearr_73555_73575 = state_73540__$1;
(statearr_73555_73575[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73541 === (14))){
var inst_73518 = (state_73540[(10)]);
var state_73540__$1 = state_73540;
var statearr_73556_73576 = state_73540__$1;
(statearr_73556_73576[(2)] = inst_73518);

(statearr_73556_73576[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73541 === (10))){
var inst_73519 = (state_73540[(12)]);
var state_73540__$1 = state_73540;
var statearr_73557_73577 = state_73540__$1;
(statearr_73557_73577[(2)] = inst_73519);

(statearr_73557_73577[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73541 === (8))){
var inst_73519 = (state_73540[(12)]);
var inst_73518 = (state_73540[(10)]);
var inst_73518__$1 = (state_73540[(2)]);
var inst_73519__$1 = (inst_73518__$1 == null);
var state_73540__$1 = (function (){var statearr_73558 = state_73540;
(statearr_73558[(12)] = inst_73519__$1);

(statearr_73558[(10)] = inst_73518__$1);

return statearr_73558;
})();
if(cljs.core.truth_(inst_73519__$1)){
var statearr_73559_73578 = state_73540__$1;
(statearr_73559_73578[(1)] = (10));

} else {
var statearr_73560_73579 = state_73540__$1;
(statearr_73560_73579[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0 = (function (){
var statearr_73561 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73561[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__);

(statearr_73561[(1)] = (1));

return statearr_73561;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1 = (function (state_73540){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73540);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73562){var ex__2687__auto__ = e73562;
var statearr_73563_73580 = state_73540;
(statearr_73563_73580[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73540[(4)]))){
var statearr_73564_73581 = state_73540;
(statearr_73564_73581[(1)] = cljs.core.first((state_73540[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73582 = state_73540;
state_73540 = G__73582;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__ = function(state_73540){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1.call(this,state_73540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73565 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73565[(6)] = c__2706__auto__);

return statearr_73565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__73583){
var map__73584 = p__73583;
var map__73584__$1 = cljs.core.__destructure_map(map__73584);
var conn = map__73584__$1;
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73584__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73584__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73584__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73584__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73695){
var state_val_73696 = (state_73695[(1)]);
if((state_val_73696 === (7))){
var inst_73691 = (state_73695[(2)]);
var state_73695__$1 = state_73695;
var statearr_73697_73753 = state_73695__$1;
(statearr_73697_73753[(2)] = inst_73691);

(statearr_73697_73753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (20))){
var inst_73642 = (state_73695[(2)]);
var state_73695__$1 = state_73695;
var statearr_73698_73754 = state_73695__$1;
(statearr_73698_73754[(2)] = inst_73642);

(statearr_73698_73754[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (27))){
var inst_73660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73661 = ["Connection closed."];
var inst_73662 = (new cljs.core.PersistentVector(null,1,(5),inst_73660,inst_73661,null));
var inst_73663 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_73662);
var state_73695__$1 = state_73695;
var statearr_73699_73755 = state_73695__$1;
(statearr_73699_73755[(2)] = inst_73663);

(statearr_73699_73755[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (1))){
var inst_73585 = (0);
var state_73695__$1 = (function (){var statearr_73700 = state_73695;
(statearr_73700[(7)] = inst_73585);

return statearr_73700;
})();
var statearr_73701_73756 = state_73695__$1;
(statearr_73701_73756[(2)] = null);

(statearr_73701_73756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (24))){
var inst_73629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73630 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_73631 = [keep_alive_fn];
var inst_73632 = cljs.core.PersistentHashMap.fromArrays(inst_73630,inst_73631);
var inst_73633 = ["Unsupported callback registered",inst_73632];
var inst_73634 = (new cljs.core.PersistentVector(null,2,(5),inst_73629,inst_73633,null));
var inst_73635 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_73634);
var state_73695__$1 = state_73695;
var statearr_73702_73757 = state_73695__$1;
(statearr_73702_73757[(2)] = inst_73635);

(statearr_73702_73757[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (4))){
var inst_73590 = (state_73695[(8)]);
var inst_73595 = (state_73695[(2)]);
var inst_73596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73595,(0),null);
var inst_73597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73595,(1),null);
var inst_73598 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73597,inst_73590);
var state_73695__$1 = (function (){var statearr_73703 = state_73695;
(statearr_73703[(9)] = inst_73596);

return statearr_73703;
})();
if(inst_73598){
var statearr_73704_73758 = state_73695__$1;
(statearr_73704_73758[(1)] = (5));

} else {
var statearr_73705_73759 = state_73695__$1;
(statearr_73705_73759[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (15))){
var inst_73615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73616 = ["No keep-alive callback is registered"];
var inst_73617 = (new cljs.core.PersistentVector(null,1,(5),inst_73615,inst_73616,null));
var inst_73618 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_73617);
var state_73695__$1 = state_73695;
var statearr_73706_73760 = state_73695__$1;
(statearr_73706_73760[(2)] = inst_73618);

(statearr_73706_73760[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (21))){
var inst_73626 = cljs.core.eval(keep_alive_fn);
var state_73695__$1 = state_73695;
var statearr_73707_73761 = state_73695__$1;
(statearr_73707_73761[(2)] = inst_73626);

(statearr_73707_73761[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (31))){
var state_73695__$1 = state_73695;
var statearr_73708_73762 = state_73695__$1;
(statearr_73708_73762[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (32))){
var inst_73687 = (state_73695[(2)]);
var state_73695__$1 = state_73695;
var statearr_73710_73763 = state_73695__$1;
(statearr_73710_73763[(2)] = inst_73687);

(statearr_73710_73763[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (33))){
var inst_73596 = (state_73695[(9)]);
var inst_73674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73675 = fluree.db.util.json.parse(inst_73596);
var inst_73676 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73675], 0));
var inst_73677 = ["Received message:",inst_73676];
var inst_73678 = (new cljs.core.PersistentVector(null,2,(5),inst_73674,inst_73677,null));
var inst_73679 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_73678);
var inst_73680 = fluree.db.util.json.parse(inst_73596);
var inst_73681 = fluree.db.conn_events.process_events(conn,inst_73680);
var inst_73585 = (0);
var state_73695__$1 = (function (){var statearr_73711 = state_73695;
(statearr_73711[(10)] = inst_73681);

(statearr_73711[(7)] = inst_73585);

(statearr_73711[(11)] = inst_73679);

return statearr_73711;
})();
var statearr_73712_73764 = state_73695__$1;
(statearr_73712_73764[(2)] = null);

(statearr_73712_73764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (13))){
var inst_73650 = (state_73695[(2)]);
var state_73695__$1 = state_73695;
var statearr_73713_73765 = state_73695__$1;
(statearr_73713_73765[(2)] = inst_73650);

(statearr_73713_73765[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (22))){
var state_73695__$1 = state_73695;
var statearr_73714_73766 = state_73695__$1;
(statearr_73714_73766[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (29))){
var inst_73689 = (state_73695[(2)]);
var state_73695__$1 = state_73695;
var statearr_73716_73767 = state_73695__$1;
(statearr_73716_73767[(2)] = inst_73689);

(statearr_73716_73767[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (6))){
var inst_73596 = (state_73695[(9)]);
var inst_73658 = (inst_73596 == null);
var state_73695__$1 = state_73695;
if(cljs.core.truth_(inst_73658)){
var statearr_73717_73768 = state_73695__$1;
(statearr_73717_73768[(1)] = (27));

} else {
var statearr_73718_73769 = state_73695__$1;
(statearr_73718_73769[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (28))){
var inst_73596 = (state_73695[(9)]);
var inst_73665 = fluree.db.util.core.exception_QMARK_(inst_73596);
var state_73695__$1 = state_73695;
if(inst_73665){
var statearr_73719_73770 = state_73695__$1;
(statearr_73719_73770[(1)] = (30));

} else {
var statearr_73720_73771 = state_73695__$1;
(statearr_73720_73771[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (25))){
var state_73695__$1 = state_73695;
var statearr_73721_73772 = state_73695__$1;
(statearr_73721_73772[(2)] = null);

(statearr_73721_73772[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (34))){
var state_73695__$1 = state_73695;
var statearr_73722_73773 = state_73695__$1;
(statearr_73722_73773[(2)] = null);

(statearr_73722_73773[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (17))){
var inst_73644 = (state_73695[(2)]);
var inst_73645 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73646 = fluree.db.connection.close_websocket(inst_73645);
var inst_73647 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73648 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_73647);
var state_73695__$1 = (function (){var statearr_73723 = state_73695;
(statearr_73723[(12)] = inst_73646);

(statearr_73723[(13)] = inst_73644);

return statearr_73723;
})();
var statearr_73724_73774 = state_73695__$1;
(statearr_73724_73774[(2)] = inst_73648);

(statearr_73724_73774[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (3))){
var inst_73693 = (state_73695[(2)]);
var state_73695__$1 = state_73695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73695__$1,inst_73693);
} else {
if((state_val_73696 === (12))){
var inst_73608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73609 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_73610 = (new cljs.core.PersistentVector(null,1,(5),inst_73608,inst_73609,null));
var inst_73611 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_73610);
var inst_73612 = keep_alive_fn;
var inst_73613 = (keep_alive_fn == null);
var state_73695__$1 = (function (){var statearr_73725 = state_73695;
(statearr_73725[(14)] = inst_73611);

(statearr_73725[(15)] = inst_73612);

return statearr_73725;
})();
if(cljs.core.truth_(inst_73613)){
var statearr_73726_73775 = state_73695__$1;
(statearr_73726_73775[(1)] = (15));

} else {
var statearr_73727_73776 = state_73695__$1;
(statearr_73727_73776[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (2))){
var inst_73590 = (state_73695[(8)]);
var inst_73590__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_73591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73592 = [sub_chan,inst_73590__$1];
var inst_73593 = (new cljs.core.PersistentVector(null,2,(5),inst_73591,inst_73592,null));
var state_73695__$1 = (function (){var statearr_73728 = state_73695;
(statearr_73728[(8)] = inst_73590__$1);

return statearr_73728;
})();
return cljs.core.async.ioc_alts_BANG_(state_73695__$1,(4),inst_73593);
} else {
if((state_val_73696 === (23))){
var inst_73640 = (state_73695[(2)]);
var state_73695__$1 = state_73695;
var statearr_73729_73777 = state_73695__$1;
(statearr_73729_73777[(2)] = inst_73640);

(statearr_73729_73777[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (35))){
var inst_73685 = (state_73695[(2)]);
var state_73695__$1 = state_73695;
var statearr_73730_73778 = state_73695__$1;
(statearr_73730_73778[(2)] = inst_73685);

(statearr_73730_73778[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (19))){
var inst_73624 = typeof keep_alive_fn === 'string';
var state_73695__$1 = state_73695;
if(cljs.core.truth_(inst_73624)){
var statearr_73731_73779 = state_73695__$1;
(statearr_73731_73779[(1)] = (21));

} else {
var statearr_73732_73780 = state_73695__$1;
(statearr_73732_73780[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (11))){
var inst_73603 = fluree.db.connection.reconnect_conn(conn);
var state_73695__$1 = state_73695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73695__$1,(14),inst_73603);
} else {
if((state_val_73696 === (9))){
var inst_73585 = (state_73695[(7)]);
var inst_73652 = fluree.db.connection.ping_transactor(req_chan);
var inst_73653 = (inst_73585 + (1));
var inst_73585__$1 = inst_73653;
var state_73695__$1 = (function (){var statearr_73733 = state_73695;
(statearr_73733[(7)] = inst_73585__$1);

(statearr_73733[(16)] = inst_73652);

return statearr_73733;
})();
var statearr_73734_73781 = state_73695__$1;
(statearr_73734_73781[(2)] = null);

(statearr_73734_73781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (5))){
var inst_73585 = (state_73695[(7)]);
var inst_73600 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_73585);
var state_73695__$1 = state_73695;
if(inst_73600){
var statearr_73735_73782 = state_73695__$1;
(statearr_73735_73782[(1)] = (8));

} else {
var statearr_73736_73783 = state_73695__$1;
(statearr_73736_73783[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (14))){
var inst_73605 = (state_73695[(2)]);
var inst_73585 = (0);
var state_73695__$1 = (function (){var statearr_73737 = state_73695;
(statearr_73737[(17)] = inst_73605);

(statearr_73737[(7)] = inst_73585);

return statearr_73737;
})();
var statearr_73738_73784 = state_73695__$1;
(statearr_73738_73784[(2)] = null);

(statearr_73738_73784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (26))){
var inst_73638 = (state_73695[(2)]);
var state_73695__$1 = state_73695;
var statearr_73739_73785 = state_73695__$1;
(statearr_73739_73785[(2)] = inst_73638);

(statearr_73739_73785[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (16))){
var inst_73620 = cljs.core.fn_QMARK_(keep_alive_fn);
var state_73695__$1 = state_73695;
if(inst_73620){
var statearr_73740_73786 = state_73695__$1;
(statearr_73740_73786[(1)] = (18));

} else {
var statearr_73741_73787 = state_73695__$1;
(statearr_73741_73787[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (30))){
var inst_73596 = (state_73695[(9)]);
var inst_73667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73668 = [inst_73596];
var inst_73669 = (new cljs.core.PersistentVector(null,1,(5),inst_73667,inst_73668,null));
var inst_73670 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73669);
var inst_73585 = (0);
var state_73695__$1 = (function (){var statearr_73742 = state_73695;
(statearr_73742[(7)] = inst_73585);

(statearr_73742[(18)] = inst_73670);

return statearr_73742;
})();
var statearr_73743_73788 = state_73695__$1;
(statearr_73743_73788[(2)] = null);

(statearr_73743_73788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (10))){
var inst_73656 = (state_73695[(2)]);
var state_73695__$1 = state_73695;
var statearr_73744_73789 = state_73695__$1;
(statearr_73744_73789[(2)] = inst_73656);

(statearr_73744_73789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (18))){
var inst_73622 = (keep_alive_fn.cljs$core$IFn$_invoke$arity$0 ? keep_alive_fn.cljs$core$IFn$_invoke$arity$0() : keep_alive_fn.call(null));
var state_73695__$1 = state_73695;
var statearr_73745_73790 = state_73695__$1;
(statearr_73745_73790[(2)] = inst_73622);

(statearr_73745_73790[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73696 === (8))){
var state_73695__$1 = state_73695;
if(cljs.core.truth_(keep_alive)){
var statearr_73746_73791 = state_73695__$1;
(statearr_73746_73791[(1)] = (11));

} else {
var statearr_73747_73792 = state_73695__$1;
(statearr_73747_73792[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0 = (function (){
var statearr_73748 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73748[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2684__auto__);

(statearr_73748[(1)] = (1));

return statearr_73748;
});
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1 = (function (state_73695){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73695);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73749){var ex__2687__auto__ = e73749;
var statearr_73750_73793 = state_73695;
(statearr_73750_73793[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73695[(4)]))){
var statearr_73751_73794 = state_73695;
(statearr_73751_73794[(1)] = cljs.core.first((state_73695[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73795 = state_73695;
state_73695 = G__73795;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = function(state_73695){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1.call(this,state_73695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73752 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73752[(6)] = c__2706__auto__);

return statearr_73752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__73797 = arguments.length;
switch (G__73797) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__73798 = opts;
var map__73798__$1 = cljs.core.__destructure_map(map__73798);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73798__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73798__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73850){
var state_val_73851 = (state_73850[(1)]);
if((state_val_73851 === (7))){
var inst_73808 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_73809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73810 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_73811 = (new cljs.core.PersistentVector(null,2,(5),inst_73809,inst_73810,null));
var inst_73812 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_73808,inst_73811);
var state_73850__$1 = state_73850;
var statearr_73852_73883 = state_73850__$1;
(statearr_73852_73883[(2)] = inst_73812);

(statearr_73852_73883[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (1))){
var state_73850__$1 = state_73850;
var statearr_73853_73884 = state_73850__$1;
(statearr_73853_73884[(2)] = null);

(statearr_73853_73884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (4))){
var inst_73799 = (state_73850[(2)]);
var state_73850__$1 = state_73850;
var statearr_73854_73885 = state_73850__$1;
(statearr_73854_73885[(2)] = inst_73799);

(statearr_73854_73885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (15))){
var inst_73819 = (state_73850[(7)]);
var inst_73838 = (state_73850[(2)]);
var inst_73839 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_73840 = [(5000),inst_73838,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_73841 = cljs.core.PersistentHashMap.fromArrays(inst_73839,inst_73840);
var inst_73842 = fluree.db.util.xhttp.get(inst_73819,inst_73841);
var state_73850__$1 = state_73850;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73850__$1,(16),inst_73842);
} else {
if((state_val_73851 === (13))){
var inst_73829 = (state_73850[(8)]);
var inst_73819 = (state_73850[(7)]);
var inst_73831 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_73832 = [inst_73829];
var inst_73833 = cljs.core.PersistentHashMap.fromArrays(inst_73831,inst_73832);
var inst_73834 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_73819,inst_73833,private$);
var inst_73835 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_73834);
var state_73850__$1 = state_73850;
var statearr_73855_73886 = state_73850__$1;
(statearr_73855_73886[(2)] = inst_73835);

(statearr_73855_73886[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (6))){
var inst_73805 = (state_73850[(9)]);
var state_73850__$1 = state_73850;
var statearr_73856_73887 = state_73850__$1;
(statearr_73856_73887[(2)] = inst_73805);

(statearr_73856_73887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (3))){
var inst_73848 = (state_73850[(2)]);
var state_73850__$1 = state_73850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73850__$1,inst_73848);
} else {
if((state_val_73851 === (12))){
var inst_73829 = (state_73850[(2)]);
var state_73850__$1 = (function (){var statearr_73857 = state_73850;
(statearr_73857[(8)] = inst_73829);

return statearr_73857;
})();
if(cljs.core.truth_(private$)){
var statearr_73858_73888 = state_73850__$1;
(statearr_73858_73888[(1)] = (13));

} else {
var statearr_73859_73889 = state_73850__$1;
(statearr_73859_73889[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (2))){
var inst_73805 = (state_73850[(9)]);
var _ = (function (){var statearr_73860 = state_73850;
(statearr_73860[(4)] = cljs.core.cons((5),(state_73850[(4)])));

return statearr_73860;
})();
var inst_73805__$1 = jwt;
var state_73850__$1 = (function (){var statearr_73861 = state_73850;
(statearr_73861[(9)] = inst_73805__$1);

return statearr_73861;
})();
if(cljs.core.truth_(inst_73805__$1)){
var statearr_73862_73890 = state_73850__$1;
(statearr_73862_73890[(1)] = (6));

} else {
var statearr_73863_73891 = state_73850__$1;
(statearr_73863_73891[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (11))){
var inst_73823 = (state_73850[(10)]);
var state_73850__$1 = state_73850;
var statearr_73865_73892 = state_73850__$1;
(statearr_73865_73892[(2)] = inst_73823);

(statearr_73865_73892[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (9))){
var inst_73815 = (state_73850[(11)]);
var inst_73814 = (state_73850[(12)]);
var inst_73818 = (state_73850[(2)]);
var inst_73819 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73818),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73815)].join('');
var inst_73821 = ["Accept"];
var inst_73822 = ["application/json"];
var inst_73823 = cljs.core.PersistentHashMap.fromArrays(inst_73821,inst_73822);
var state_73850__$1 = (function (){var statearr_73866 = state_73850;
(statearr_73866[(10)] = inst_73823);

(statearr_73866[(7)] = inst_73819);

return statearr_73866;
})();
if(cljs.core.truth_(inst_73814)){
var statearr_73867_73893 = state_73850__$1;
(statearr_73867_73893[(1)] = (10));

} else {
var statearr_73868_73894 = state_73850__$1;
(statearr_73868_73894[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (5))){
var _ = (function (){var statearr_73869 = state_73850;
(statearr_73869[(4)] = cljs.core.rest((state_73850[(4)])));

return statearr_73869;
})();
var state_73850__$1 = state_73850;
var ex73864 = (state_73850__$1[(2)]);
var statearr_73870_73895 = state_73850__$1;
(statearr_73870_73895[(5)] = ex73864);


if((ex73864 instanceof Error)){
var statearr_73871_73896 = state_73850__$1;
(statearr_73871_73896[(1)] = (4));

(statearr_73871_73896[(5)] = null);

} else {
throw ex73864;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (14))){
var inst_73829 = (state_73850[(8)]);
var state_73850__$1 = state_73850;
var statearr_73872_73897 = state_73850__$1;
(statearr_73872_73897[(2)] = inst_73829);

(statearr_73872_73897[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (16))){
var inst_73844 = (state_73850[(2)]);
var inst_73845 = fluree.db.util.async.throw_err(inst_73844);
var _ = (function (){var statearr_73873 = state_73850;
(statearr_73873[(4)] = cljs.core.rest((state_73850[(4)])));

return statearr_73873;
})();
var state_73850__$1 = state_73850;
var statearr_73874_73898 = state_73850__$1;
(statearr_73874_73898[(2)] = inst_73845);

(statearr_73874_73898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (10))){
var inst_73823 = (state_73850[(10)]);
var inst_73814 = (state_73850[(12)]);
var inst_73825 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73814)].join('');
var inst_73826 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73823,"Authorization",inst_73825);
var state_73850__$1 = state_73850;
var statearr_73875_73899 = state_73850__$1;
(statearr_73875_73899[(2)] = inst_73826);

(statearr_73875_73899[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73851 === (8))){
var inst_73814 = (state_73850[(2)]);
var inst_73815 = clojure.string.replace(k,"_","/");
var inst_73816 = fluree.db.connection.get_server(conn_id,servers);
var state_73850__$1 = (function (){var statearr_73876 = state_73850;
(statearr_73876[(11)] = inst_73815);

(statearr_73876[(12)] = inst_73814);

return statearr_73876;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73850__$1,(9),inst_73816);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_73877 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73877[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_73877[(1)] = (1));

return statearr_73877;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_73850){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73850);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73878){var ex__2687__auto__ = e73878;
var statearr_73879_73900 = state_73850;
(statearr_73879_73900[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73850[(4)]))){
var statearr_73880_73901 = state_73850;
(statearr_73880_73901[(1)] = cljs.core.first((state_73850[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73902 = state_73850;
state_73850 = G__73902;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_73850){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_73850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73881 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73881[(6)] = c__2706__auto__);

return statearr_73881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var temp__5802__auto___73927 = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___73927)){
var v_73928 = temp__5802__auto___73927;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,v_73928);
} else {
var c__2706__auto___73929 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73914){
var state_val_73915 = (state_73914[(1)]);
if((state_val_73915 === (1))){
var inst_73903 = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
var state_73914__$1 = state_73914;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73914__$1,(2),inst_73903);
} else {
if((state_val_73915 === (2))){
var inst_73905 = (state_73914[(7)]);
var inst_73905__$1 = (state_73914[(2)]);
var inst_73906 = fluree.db.util.core.exception_QMARK_(inst_73905__$1);
var state_73914__$1 = (function (){var statearr_73916 = state_73914;
(statearr_73916[(7)] = inst_73905__$1);

return statearr_73916;
})();
if(inst_73906){
var statearr_73917_73930 = state_73914__$1;
(statearr_73917_73930[(1)] = (3));

} else {
var statearr_73918_73931 = state_73914__$1;
(statearr_73918_73931[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73915 === (3))){
var state_73914__$1 = state_73914;
var statearr_73919_73932 = state_73914__$1;
(statearr_73919_73932[(2)] = null);

(statearr_73919_73932[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73915 === (4))){
var inst_73905 = (state_73914[(7)]);
var inst_73909 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,inst_73905);
var state_73914__$1 = state_73914;
var statearr_73920_73933 = state_73914__$1;
(statearr_73920_73933[(2)] = inst_73909);

(statearr_73920_73933[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73915 === (5))){
var inst_73905 = (state_73914[(7)]);
var inst_73911 = (state_73914[(2)]);
var inst_73912 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,inst_73905);
var state_73914__$1 = (function (){var statearr_73921 = state_73914;
(statearr_73921[(8)] = inst_73911);

return statearr_73921;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73914__$1,inst_73912);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_73922 = [null,null,null,null,null,null,null,null,null];
(statearr_73922[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__);

(statearr_73922[(1)] = (1));

return statearr_73922;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1 = (function (state_73914){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73914);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73923){var ex__2687__auto__ = e73923;
var statearr_73924_73934 = state_73914;
(statearr_73924_73934[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73914[(4)]))){
var statearr_73925_73935 = state_73914;
(statearr_73925_73935[(1)] = cljs.core.first((state_73914[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73936 = state_73914;
state_73914 = G__73936;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__ = function(state_73914){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1.call(this,state_73914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73926 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73926[(6)] = c__2706__auto___73929);

return statearr_73926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__73937_SHARP_){
if(cljs.core.truth_(p1__73937_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__73938_SHARP_){
var or__5045__auto__ = p1__73938_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e73939){var e = e73939;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__73940 = opts;
var map__73940__$1 = cljs.core.__destructure_map(map__73940);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73940__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73940__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73940__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73940__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73940__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73940__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73940__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73940__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73940__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73940__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73940__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__73941_73942 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__73941_73942.cljs$core$IFn$_invoke$arity$0 ? fexpr__73941_73942.cljs$core$IFn$_invoke$arity$0() : fexpr__73941_73942.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___73986 = arguments.length;
var i__5770__auto___73987 = (0);
while(true){
if((i__5770__auto___73987 < len__5769__auto___73986)){
args__5775__auto__.push((arguments[i__5770__auto___73987]));

var G__73988 = (i__5770__auto___73987 + (1));
i__5770__auto___73987 = G__73988;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__73945){
var vec__73946 = p__73945;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73946,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2706__auto___73989 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73969){
var state_val_73970 = (state_73969[(1)]);
if((state_val_73970 === (1))){
var inst_73949 = fluree.db.connection.get_socket(conn);
var state_73969__$1 = state_73969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73969__$1,(2),inst_73949);
} else {
if((state_val_73970 === (2))){
var inst_73951 = (state_73969[(7)]);
var inst_73952 = (state_73969[(8)]);
var inst_73951__$1 = (state_73969[(2)]);
var inst_73952__$1 = (inst_73951__$1 == null);
var state_73969__$1 = (function (){var statearr_73971 = state_73969;
(statearr_73971[(7)] = inst_73951__$1);

(statearr_73971[(8)] = inst_73952__$1);

return statearr_73971;
})();
if(cljs.core.truth_(inst_73952__$1)){
var statearr_73972_73990 = state_73969__$1;
(statearr_73972_73990[(1)] = (3));

} else {
var statearr_73973_73991 = state_73969__$1;
(statearr_73973_73991[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73970 === (3))){
var inst_73952 = (state_73969[(8)]);
var state_73969__$1 = state_73969;
var statearr_73974_73992 = state_73969__$1;
(statearr_73974_73992[(2)] = inst_73952);

(statearr_73974_73992[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73970 === (4))){
var inst_73951 = (state_73969[(7)]);
var inst_73955 = fluree.db.util.core.exception_QMARK_(inst_73951);
var state_73969__$1 = state_73969;
var statearr_73975_73993 = state_73969__$1;
(statearr_73975_73993[(2)] = inst_73955);

(statearr_73975_73993[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73970 === (5))){
var inst_73957 = (state_73969[(2)]);
var state_73969__$1 = state_73969;
if(cljs.core.truth_(inst_73957)){
var statearr_73976_73994 = state_73969__$1;
(statearr_73976_73994[(1)] = (6));

} else {
var statearr_73977_73995 = state_73969__$1;
(statearr_73977_73995[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73970 === (6))){
var inst_73951 = (state_73969[(7)]);
var inst_73959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73960 = [inst_73951,"Cannot establish connection to a healthy server, disconnecting."];
var inst_73961 = (new cljs.core.PersistentVector(null,2,(5),inst_73959,inst_73960,null));
var inst_73962 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73961);
var inst_73963 = cljs.core.async.close_BANG_(conn);
var state_73969__$1 = (function (){var statearr_73978 = state_73969;
(statearr_73978[(9)] = inst_73962);

return statearr_73978;
})();
var statearr_73979_73996 = state_73969__$1;
(statearr_73979_73996[(2)] = inst_73963);

(statearr_73979_73996[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73970 === (7))){
var inst_73965 = fluree.db.connection.msg_consumer(conn);
var state_73969__$1 = state_73969;
var statearr_73980_73997 = state_73969__$1;
(statearr_73980_73997[(2)] = inst_73965);

(statearr_73980_73997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73970 === (8))){
var inst_73967 = (state_73969[(2)]);
var state_73969__$1 = state_73969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73969__$1,inst_73967);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_73981 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73981[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_73981[(1)] = (1));

return statearr_73981;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_73969){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73969);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73982){var ex__2687__auto__ = e73982;
var statearr_73983_73998 = state_73969;
(statearr_73983_73998[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73969[(4)]))){
var statearr_73984_73999 = state_73969;
(statearr_73984_73999[(1)] = cljs.core.first((state_73969[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74000 = state_73969;
state_73969 = G__74000;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_73969){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_73969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73985 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73985[(6)] = c__2706__auto___73989);

return statearr_73985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq73943){
var G__73944 = cljs.core.first(seq73943);
var seq73943__$1 = cljs.core.next(seq73943);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73944,seq73943__$1);
}));

