// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__74011 = arguments.length;
switch (G__74011) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74056){
var state_val_74057 = (state_74056[(1)]);
if((state_val_74057 === (7))){
var inst_74026 = typeof user === 'string';
var state_74056__$1 = state_74056;
if(cljs.core.truth_(inst_74026)){
var statearr_74058_74087 = state_74056__$1;
(statearr_74058_74087[(1)] = (9));

} else {
var statearr_74059_74088 = state_74056__$1;
(statearr_74059_74088[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (1))){
var state_74056__$1 = state_74056;
var statearr_74060_74089 = state_74056__$1;
(statearr_74060_74089[(2)] = null);

(statearr_74060_74089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (4))){
var inst_74012 = (state_74056[(2)]);
var inst_74013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74014 = [inst_74012];
var inst_74015 = (new cljs.core.PersistentVector(null,1,(5),inst_74013,inst_74014,null));
var inst_74016 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74015);
var inst_74017 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_74012) : reject.call(null,inst_74012));
var state_74056__$1 = (function (){var statearr_74061 = state_74056;
(statearr_74061[(7)] = inst_74016);

return statearr_74061;
})();
var statearr_74062_74090 = state_74056__$1;
(statearr_74062_74090[(2)] = inst_74017);

(statearr_74062_74090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (15))){
var inst_74045 = (state_74056[(2)]);
var inst_74046 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_74045);
var inst_74047 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74048 = cljs.core.constantly(inst_74046);
var inst_74049 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74047,inst_74048);
var inst_74050 = fluree.db.connection.add_token(conn,inst_74046);
var inst_74051 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_74045) : resolve.call(null,inst_74045));
var _ = (function (){var statearr_74063 = state_74056;
(statearr_74063[(4)] = cljs.core.rest((state_74056[(4)])));

return statearr_74063;
})();
var state_74056__$1 = (function (){var statearr_74064 = state_74056;
(statearr_74064[(8)] = inst_74050);

(statearr_74064[(9)] = inst_74049);

return statearr_74064;
})();
var statearr_74065_74091 = state_74056__$1;
(statearr_74065_74091[(2)] = inst_74051);

(statearr_74065_74091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (13))){
var state_74056__$1 = state_74056;
var statearr_74066_74092 = state_74056__$1;
(statearr_74066_74092[(2)] = null);

(statearr_74066_74092[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (6))){
var state_74056__$1 = state_74056;
var statearr_74067_74093 = state_74056__$1;
(statearr_74067_74093[(2)] = user);

(statearr_74067_74093[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (3))){
var inst_74054 = (state_74056[(2)]);
var state_74056__$1 = state_74056;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74056__$1,inst_74054);
} else {
if((state_val_74057 === (12))){
var state_74056__$1 = state_74056;
var statearr_74068_74094 = state_74056__$1;
(statearr_74068_74094[(2)] = user);

(statearr_74068_74094[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (2))){
var _ = (function (){var statearr_74069 = state_74056;
(statearr_74069[(4)] = cljs.core.cons((5),(state_74056[(4)])));

return statearr_74069;
})();
var inst_74023 = typeof user === 'number';
var state_74056__$1 = state_74056;
if(cljs.core.truth_(inst_74023)){
var statearr_74070_74095 = state_74056__$1;
(statearr_74070_74095[(1)] = (6));

} else {
var statearr_74071_74096 = state_74056__$1;
(statearr_74071_74096[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (11))){
var inst_74037 = (state_74056[(2)]);
var state_74056__$1 = state_74056;
var statearr_74073_74097 = state_74056__$1;
(statearr_74073_74097[(2)] = inst_74037);

(statearr_74073_74097[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (9))){
var inst_74028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74029 = ["_user/username",user];
var inst_74030 = (new cljs.core.PersistentVector(null,2,(5),inst_74028,inst_74029,null));
var state_74056__$1 = state_74056;
var statearr_74074_74098 = state_74056__$1;
(statearr_74074_74098[(2)] = inst_74030);

(statearr_74074_74098[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (5))){
var _ = (function (){var statearr_74075 = state_74056;
(statearr_74075[(4)] = cljs.core.rest((state_74056[(4)])));

return statearr_74075;
})();
var state_74056__$1 = state_74056;
var ex74072 = (state_74056__$1[(2)]);
var statearr_74076_74099 = state_74056__$1;
(statearr_74076_74099[(5)] = ex74072);


var statearr_74077_74100 = state_74056__$1;
(statearr_74077_74100[(1)] = (4));

(statearr_74077_74100[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (14))){
var inst_74035 = (state_74056[(2)]);
var state_74056__$1 = state_74056;
var statearr_74078_74101 = state_74056__$1;
(statearr_74078_74101[(2)] = inst_74035);

(statearr_74078_74101[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (10))){
var state_74056__$1 = state_74056;
var statearr_74079_74102 = state_74056__$1;
(statearr_74079_74102[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74057 === (8))){
var inst_74039 = (state_74056[(2)]);
var inst_74040 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_74041 = [account,inst_74039,password,expireSeconds,syncTo];
var inst_74042 = cljs.core.PersistentHashMap.fromArrays(inst_74040,inst_74041);
var inst_74043 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_74042);
var state_74056__$1 = state_74056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74056__$1,(15),inst_74043);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_74081 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74081[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_74081[(1)] = (1));

return statearr_74081;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_74056){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_74056);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74082){var ex__2687__auto__ = e74082;
var statearr_74083_74103 = state_74056;
(statearr_74083_74103[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_74056[(4)]))){
var statearr_74084_74104 = state_74056;
(statearr_74084_74104[(1)] = cljs.core.first((state_74056[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74105 = state_74056;
state_74056 = G__74105;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_74056){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_74056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74085 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_74085[(6)] = c__2706__auto__);

return statearr_74085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__74107 = arguments.length;
switch (G__74107) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74116){
var state_val_74117 = (state_74116[(1)]);
if((state_val_74117 === (1))){
var inst_74108 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74110 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_74111 = (new cljs.core.PersistentVector(null,4,(5),inst_74109,inst_74110,null));
var inst_74112 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74108,inst_74111);
var inst_74113 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__74118 = cljs.core.seq(cljs.core.keys(x));
var chunk__74119 = null;
var count__74120 = (0);
var i__74121 = (0);
while(true){
if((i__74121 < count__74120)){
var k = chunk__74119.cljs$core$IIndexed$_nth$arity$2(null,i__74121);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__74129 = seq__74118;
var G__74130 = chunk__74119;
var G__74131 = count__74120;
var G__74132 = (i__74121 + (1));
seq__74118 = G__74129;
chunk__74119 = G__74130;
count__74120 = G__74131;
i__74121 = G__74132;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__74118);
if(temp__5804__auto__){
var seq__74118__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__74118__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__74118__$1);
var G__74133 = cljs.core.chunk_rest(seq__74118__$1);
var G__74134 = c__5568__auto__;
var G__74135 = cljs.core.count(c__5568__auto__);
var G__74136 = (0);
seq__74118 = G__74133;
chunk__74119 = G__74134;
count__74120 = G__74135;
i__74121 = G__74136;
continue;
} else {
var k = cljs.core.first(seq__74118__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__74137 = cljs.core.next(seq__74118__$1);
var G__74138 = null;
var G__74139 = (0);
var G__74140 = (0);
seq__74118 = G__74137;
chunk__74119 = G__74138;
count__74120 = G__74139;
i__74121 = G__74140;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_74114 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74113);
var state_74116__$1 = (function (){var statearr_74122 = state_74116;
(statearr_74122[(7)] = inst_74112);

return statearr_74122;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_74116__$1,inst_74114);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_74123 = [null,null,null,null,null,null,null,null];
(statearr_74123[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_74123[(1)] = (1));

return statearr_74123;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_74116){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_74116);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74124){var ex__2687__auto__ = e74124;
var statearr_74125_74141 = state_74116;
(statearr_74125_74141[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_74116[(4)]))){
var statearr_74126_74142 = state_74116;
(statearr_74126_74142[(1)] = cljs.core.first((state_74116[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74143 = state_74116;
state_74116 = G__74143;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_74116){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_74116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74127 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_74127[(6)] = c__2706__auto__);

return statearr_74127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__74145 = arguments.length;
switch (G__74145) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74182){
var state_val_74183 = (state_74182[(1)]);
if((state_val_74183 === (1))){
var state_74182__$1 = state_74182;
var statearr_74184_74205 = state_74182__$1;
(statearr_74184_74205[(2)] = null);

(statearr_74184_74205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74183 === (2))){
var _ = (function (){var statearr_74185 = state_74182;
(statearr_74185[(4)] = cljs.core.cons((5),(state_74182[(4)])));

return statearr_74185;
})();
var inst_74157 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_74158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74159 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_74160 = (new cljs.core.PersistentVector(null,1,(5),inst_74158,inst_74159,null));
var inst_74161 = cljs.core.PersistentHashMap.EMPTY;
var inst_74162 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_74161);
var inst_74163 = cljs.core.assoc_in(inst_74157,inst_74160,inst_74162);
var inst_74164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74165 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_74166 = (new cljs.core.PersistentVector(null,1,(5),inst_74164,inst_74165,null));
var inst_74167 = cljs.core.PersistentHashMap.EMPTY;
var inst_74168 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_74167);
var inst_74169 = cljs.core.assoc_in(inst_74163,inst_74166,inst_74168);
var inst_74170 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_74171 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_74169);
var inst_74172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74173 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_74170,null];
var inst_74174 = (new cljs.core.PersistentVector(null,4,(5),inst_74172,inst_74173,null));
var inst_74175 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74171,inst_74174);
var inst_74176 = (function (){var conn = inst_74169;
var pc = inst_74170;
return (function (x){
if((x == null)){
} else {
var seq__74186_74206 = cljs.core.seq(cljs.core.keys(x));
var chunk__74187_74207 = null;
var count__74188_74208 = (0);
var i__74189_74209 = (0);
while(true){
if((i__74189_74209 < count__74188_74208)){
var k_74210 = chunk__74187_74207.cljs$core$IIndexed$_nth$arity$2(null,i__74189_74209);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_74210], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_74210,null));


var G__74211 = seq__74186_74206;
var G__74212 = chunk__74187_74207;
var G__74213 = count__74188_74208;
var G__74214 = (i__74189_74209 + (1));
seq__74186_74206 = G__74211;
chunk__74187_74207 = G__74212;
count__74188_74208 = G__74213;
i__74189_74209 = G__74214;
continue;
} else {
var temp__5804__auto___74215 = cljs.core.seq(seq__74186_74206);
if(temp__5804__auto___74215){
var seq__74186_74216__$1 = temp__5804__auto___74215;
if(cljs.core.chunked_seq_QMARK_(seq__74186_74216__$1)){
var c__5568__auto___74217 = cljs.core.chunk_first(seq__74186_74216__$1);
var G__74218 = cljs.core.chunk_rest(seq__74186_74216__$1);
var G__74219 = c__5568__auto___74217;
var G__74220 = cljs.core.count(c__5568__auto___74217);
var G__74221 = (0);
seq__74186_74206 = G__74218;
chunk__74187_74207 = G__74219;
count__74188_74208 = G__74220;
i__74189_74209 = G__74221;
continue;
} else {
var k_74222 = cljs.core.first(seq__74186_74216__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_74222], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_74222,null));


var G__74223 = cljs.core.next(seq__74186_74216__$1);
var G__74224 = null;
var G__74225 = (0);
var G__74226 = (0);
seq__74186_74206 = G__74223;
chunk__74187_74207 = G__74224;
count__74188_74208 = G__74225;
i__74189_74209 = G__74226;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_74177 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74170,inst_74176);
var ___$1 = (function (){var statearr_74190 = state_74182;
(statearr_74190[(4)] = cljs.core.rest((state_74182[(4)])));

return statearr_74190;
})();
var state_74182__$1 = (function (){var statearr_74191 = state_74182;
(statearr_74191[(7)] = inst_74175);

return statearr_74191;
})();
var statearr_74192_74227 = state_74182__$1;
(statearr_74192_74227[(2)] = inst_74177);

(statearr_74192_74227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74183 === (3))){
var inst_74180 = (state_74182[(2)]);
var state_74182__$1 = state_74182;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74182__$1,inst_74180);
} else {
if((state_val_74183 === (4))){
var inst_74146 = (state_74182[(2)]);
var inst_74147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74148 = [inst_74146];
var inst_74149 = (new cljs.core.PersistentVector(null,1,(5),inst_74147,inst_74148,null));
var inst_74150 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74149);
var inst_74151 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_74146) : reject.call(null,inst_74146));
var state_74182__$1 = (function (){var statearr_74194 = state_74182;
(statearr_74194[(8)] = inst_74150);

return statearr_74194;
})();
var statearr_74195_74228 = state_74182__$1;
(statearr_74195_74228[(2)] = inst_74151);

(statearr_74195_74228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74183 === (5))){
var _ = (function (){var statearr_74196 = state_74182;
(statearr_74196[(4)] = cljs.core.rest((state_74182[(4)])));

return statearr_74196;
})();
var state_74182__$1 = state_74182;
var ex74193 = (state_74182__$1[(2)]);
var statearr_74197_74229 = state_74182__$1;
(statearr_74197_74229[(5)] = ex74193);


var statearr_74198_74230 = state_74182__$1;
(statearr_74198_74230[(1)] = (4));

(statearr_74198_74230[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_74199 = [null,null,null,null,null,null,null,null,null];
(statearr_74199[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_74199[(1)] = (1));

return statearr_74199;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_74182){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_74182);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74200){var ex__2687__auto__ = e74200;
var statearr_74201_74231 = state_74182;
(statearr_74201_74231[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_74182[(4)]))){
var statearr_74202_74232 = state_74182;
(statearr_74202_74232[(1)] = cljs.core.first((state_74182[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74233 = state_74182;
state_74182 = G__74233;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_74182){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_74182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74203 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_74203[(6)] = c__2706__auto__);

return statearr_74203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__74235 = arguments.length;
switch (G__74235) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__74237 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74237,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74237,(1),null);
var cb_STAR_ = (function (header,data){
var G__74240 = cljs.core.clj__GT_js(header);
var G__74241 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__74240,G__74241) : callback.call(null,G__74240,G__74241));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__74242 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74242,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74242,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74295){
var state_val_74296 = (state_74295[(1)]);
if((state_val_74296 === (7))){
var inst_74256 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74257 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_74258 = cljs.core.PersistentHashMap.fromArrays(inst_74256,inst_74257);
var inst_74259 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_74258);
var inst_74260 = (function(){throw inst_74259})();
var state_74295__$1 = state_74295;
var statearr_74297_74329 = state_74295__$1;
(statearr_74297_74329[(2)] = inst_74260);

(statearr_74297_74329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (1))){
var state_74295__$1 = state_74295;
var statearr_74298_74330 = state_74295__$1;
(statearr_74298_74330[(2)] = null);

(statearr_74298_74330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (4))){
var inst_74245 = (state_74295[(2)]);
var inst_74246 = cljs.core.clj__GT_js(inst_74245);
var inst_74247 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_74246) : reject.call(null,inst_74246));
var state_74295__$1 = state_74295;
var statearr_74299_74331 = state_74295__$1;
(statearr_74299_74331[(2)] = inst_74247);

(statearr_74299_74331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (13))){
var inst_74274 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74275 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74276 = cljs.core.PersistentHashMap.fromArrays(inst_74274,inst_74275);
var inst_74277 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_74276);
var inst_74278 = (function(){throw inst_74277})();
var state_74295__$1 = state_74295;
var statearr_74300_74332 = state_74295__$1;
(statearr_74300_74332[(2)] = inst_74278);

(statearr_74300_74332[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (6))){
var state_74295__$1 = state_74295;
var statearr_74301_74333 = state_74295__$1;
(statearr_74301_74333[(2)] = null);

(statearr_74301_74333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (3))){
var inst_74293 = (state_74295[(2)]);
var state_74295__$1 = state_74295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74295__$1,inst_74293);
} else {
if((state_val_74296 === (12))){
var state_74295__$1 = state_74295;
var statearr_74302_74334 = state_74295__$1;
(statearr_74302_74334[(2)] = null);

(statearr_74302_74334[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (2))){
var _ = (function (){var statearr_74303 = state_74295;
(statearr_74303[(4)] = cljs.core.cons((5),(state_74295[(4)])));

return statearr_74303;
})();
var inst_74253 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_74295__$1 = state_74295;
if(cljs.core.truth_(inst_74253)){
var statearr_74304_74335 = state_74295__$1;
(statearr_74304_74335[(1)] = (6));

} else {
var statearr_74305_74336 = state_74295__$1;
(statearr_74305_74336[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (11))){
var inst_74271 = (state_74295[(2)]);
var state_74295__$1 = (function (){var statearr_74307 = state_74295;
(statearr_74307[(7)] = inst_74271);

return statearr_74307;
})();
if(cljs.core.truth_(password)){
var statearr_74308_74337 = state_74295__$1;
(statearr_74308_74337[(1)] = (12));

} else {
var statearr_74309_74338 = state_74295__$1;
(statearr_74309_74338[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (9))){
var state_74295__$1 = state_74295;
var statearr_74310_74339 = state_74295__$1;
(statearr_74310_74339[(2)] = null);

(statearr_74310_74339[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (5))){
var _ = (function (){var statearr_74311 = state_74295;
(statearr_74311[(4)] = cljs.core.rest((state_74295[(4)])));

return statearr_74311;
})();
var state_74295__$1 = state_74295;
var ex74306 = (state_74295__$1[(2)]);
var statearr_74312_74340 = state_74295__$1;
(statearr_74312_74340[(5)] = ex74306);


var statearr_74313_74341 = state_74295__$1;
(statearr_74313_74341[(1)] = (4));

(statearr_74313_74341[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (14))){
var inst_74280 = (state_74295[(2)]);
var inst_74281 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_74282 = fluree.db.util.core.without_nils(inst_74281);
var inst_74283 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_74284 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74286 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_74282,inst_74283,null];
var inst_74287 = (new cljs.core.PersistentVector(null,4,(5),inst_74285,inst_74286,null));
var inst_74288 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74284,inst_74287);
var inst_74289 = (function (){var _ = inst_74280;
var data = inst_74282;
var pc = inst_74283;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__74314 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__74314) : reject.call(null,G__74314));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__74315 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__74315) : reject.call(null,G__74315));
} else {
var G__74316 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__74316) : resolve.call(null,G__74316));

}
}
});
})();
var inst_74290 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74283,inst_74289);
var _ = (function (){var statearr_74317 = state_74295;
(statearr_74317[(4)] = cljs.core.rest((state_74295[(4)])));

return statearr_74317;
})();
var state_74295__$1 = (function (){var statearr_74318 = state_74295;
(statearr_74318[(8)] = inst_74288);

return statearr_74318;
})();
var statearr_74319_74342 = state_74295__$1;
(statearr_74319_74342[(2)] = inst_74290);

(statearr_74319_74342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (10))){
var inst_74265 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74266 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74267 = cljs.core.PersistentHashMap.fromArrays(inst_74265,inst_74266);
var inst_74268 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_74267);
var inst_74269 = (function(){throw inst_74268})();
var state_74295__$1 = state_74295;
var statearr_74320_74343 = state_74295__$1;
(statearr_74320_74343[(2)] = inst_74269);

(statearr_74320_74343[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74296 === (8))){
var inst_74262 = (state_74295[(2)]);
var state_74295__$1 = (function (){var statearr_74321 = state_74295;
(statearr_74321[(9)] = inst_74262);

return statearr_74321;
})();
if(cljs.core.truth_(ledger)){
var statearr_74322_74344 = state_74295__$1;
(statearr_74322_74344[(1)] = (9));

} else {
var statearr_74323_74345 = state_74295__$1;
(statearr_74323_74345[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0 = (function (){
var statearr_74324 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74324[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2684__auto__);

(statearr_74324[(1)] = (1));

return statearr_74324;
});
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1 = (function (state_74295){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_74295);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74325){var ex__2687__auto__ = e74325;
var statearr_74326_74346 = state_74295;
(statearr_74326_74346[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_74295[(4)]))){
var statearr_74327_74347 = state_74295;
(statearr_74327_74347[(1)] = cljs.core.first((state_74295[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74348 = state_74295;
state_74295 = G__74348;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = function(state_74295){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1.call(this,state_74295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74328 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_74328[(6)] = c__2706__auto__);

return statearr_74328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__74350 = arguments.length;
switch (G__74350) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74417){
var state_val_74418 = (state_74417[(1)]);
if((state_val_74418 === (7))){
var inst_74362 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74363 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_74364 = cljs.core.PersistentHashMap.fromArrays(inst_74362,inst_74363);
var inst_74365 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_74364);
var inst_74366 = (function(){throw inst_74365})();
var state_74417__$1 = state_74417;
var statearr_74419_74461 = state_74417__$1;
(statearr_74419_74461[(2)] = inst_74366);

(statearr_74419_74461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (20))){
var inst_74400 = (state_74417[(2)]);
var inst_74401 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_74402 = [ledger,password,user,auth,expire];
var inst_74403 = cljs.core.PersistentHashMap.fromArrays(inst_74401,inst_74402);
var inst_74404 = fluree.db.util.core.without_nils(inst_74403);
var inst_74405 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_74406 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74408 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_74404,inst_74405,null];
var inst_74409 = (new cljs.core.PersistentVector(null,4,(5),inst_74407,inst_74408,null));
var inst_74410 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74406,inst_74409);
var inst_74411 = (function (){var _ = inst_74400;
var data = inst_74404;
var pc = inst_74405;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__74420 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__74420) : reject.call(null,G__74420));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__74421 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__74421) : reject.call(null,G__74421));
} else {
fluree.db.connection.add_token(conn,result);

var G__74422 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__74422) : resolve.call(null,G__74422));

}
}
});
})();
var inst_74412 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74405,inst_74411);
var _ = (function (){var statearr_74423 = state_74417;
(statearr_74423[(4)] = cljs.core.rest((state_74417[(4)])));

return statearr_74423;
})();
var state_74417__$1 = (function (){var statearr_74424 = state_74417;
(statearr_74424[(7)] = inst_74410);

return statearr_74424;
})();
var statearr_74425_74462 = state_74417__$1;
(statearr_74425_74462[(2)] = inst_74412);

(statearr_74425_74462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (1))){
var state_74417__$1 = state_74417;
var statearr_74426_74463 = state_74417__$1;
(statearr_74426_74463[(2)] = null);

(statearr_74426_74463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (4))){
var inst_74351 = (state_74417[(2)]);
var inst_74352 = cljs.core.clj__GT_js(inst_74351);
var inst_74353 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_74352) : reject.call(null,inst_74352));
var state_74417__$1 = state_74417;
var statearr_74427_74464 = state_74417__$1;
(statearr_74427_74464[(2)] = inst_74353);

(statearr_74427_74464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (15))){
var inst_74387 = (state_74417[(8)]);
var state_74417__$1 = state_74417;
var statearr_74428_74465 = state_74417__$1;
(statearr_74428_74465[(2)] = inst_74387);

(statearr_74428_74465[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (13))){
var inst_74380 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74381 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74382 = cljs.core.PersistentHashMap.fromArrays(inst_74380,inst_74381);
var inst_74383 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_74382);
var inst_74384 = (function(){throw inst_74383})();
var state_74417__$1 = state_74417;
var statearr_74429_74466 = state_74417__$1;
(statearr_74429_74466[(2)] = inst_74384);

(statearr_74429_74466[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (6))){
var state_74417__$1 = state_74417;
var statearr_74430_74467 = state_74417__$1;
(statearr_74430_74467[(2)] = null);

(statearr_74430_74467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (17))){
var inst_74391 = (state_74417[(2)]);
var state_74417__$1 = state_74417;
if(cljs.core.truth_(inst_74391)){
var statearr_74431_74468 = state_74417__$1;
(statearr_74431_74468[(1)] = (18));

} else {
var statearr_74432_74469 = state_74417__$1;
(statearr_74432_74469[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (3))){
var inst_74415 = (state_74417[(2)]);
var state_74417__$1 = state_74417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74417__$1,inst_74415);
} else {
if((state_val_74418 === (12))){
var state_74417__$1 = state_74417;
var statearr_74433_74470 = state_74417__$1;
(statearr_74433_74470[(2)] = null);

(statearr_74433_74470[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (2))){
var _ = (function (){var statearr_74434 = state_74417;
(statearr_74434[(4)] = cljs.core.cons((5),(state_74417[(4)])));

return statearr_74434;
})();
var inst_74359 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_74417__$1 = state_74417;
if(cljs.core.truth_(inst_74359)){
var statearr_74435_74471 = state_74417__$1;
(statearr_74435_74471[(1)] = (6));

} else {
var statearr_74436_74472 = state_74417__$1;
(statearr_74436_74472[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (19))){
var inst_74394 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74395 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74396 = cljs.core.PersistentHashMap.fromArrays(inst_74394,inst_74395);
var inst_74397 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_74396);
var inst_74398 = (function(){throw inst_74397})();
var state_74417__$1 = state_74417;
var statearr_74437_74473 = state_74417__$1;
(statearr_74437_74473[(2)] = inst_74398);

(statearr_74437_74473[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (11))){
var inst_74377 = (state_74417[(2)]);
var state_74417__$1 = (function (){var statearr_74439 = state_74417;
(statearr_74439[(9)] = inst_74377);

return statearr_74439;
})();
if(cljs.core.truth_(password)){
var statearr_74440_74474 = state_74417__$1;
(statearr_74440_74474[(1)] = (12));

} else {
var statearr_74441_74475 = state_74417__$1;
(statearr_74441_74475[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (9))){
var state_74417__$1 = state_74417;
var statearr_74442_74476 = state_74417__$1;
(statearr_74442_74476[(2)] = null);

(statearr_74442_74476[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (5))){
var _ = (function (){var statearr_74443 = state_74417;
(statearr_74443[(4)] = cljs.core.rest((state_74417[(4)])));

return statearr_74443;
})();
var state_74417__$1 = state_74417;
var ex74438 = (state_74417__$1[(2)]);
var statearr_74444_74477 = state_74417__$1;
(statearr_74444_74477[(5)] = ex74438);


var statearr_74445_74478 = state_74417__$1;
(statearr_74445_74478[(1)] = (4));

(statearr_74445_74478[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (14))){
var inst_74387 = (state_74417[(8)]);
var inst_74386 = (state_74417[(2)]);
var inst_74387__$1 = user;
var state_74417__$1 = (function (){var statearr_74446 = state_74417;
(statearr_74446[(8)] = inst_74387__$1);

(statearr_74446[(10)] = inst_74386);

return statearr_74446;
})();
if(cljs.core.truth_(inst_74387__$1)){
var statearr_74447_74479 = state_74417__$1;
(statearr_74447_74479[(1)] = (15));

} else {
var statearr_74448_74480 = state_74417__$1;
(statearr_74448_74480[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (16))){
var state_74417__$1 = state_74417;
var statearr_74449_74481 = state_74417__$1;
(statearr_74449_74481[(2)] = auth);

(statearr_74449_74481[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (10))){
var inst_74371 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74372 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74373 = cljs.core.PersistentHashMap.fromArrays(inst_74371,inst_74372);
var inst_74374 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_74373);
var inst_74375 = (function(){throw inst_74374})();
var state_74417__$1 = state_74417;
var statearr_74450_74482 = state_74417__$1;
(statearr_74450_74482[(2)] = inst_74375);

(statearr_74450_74482[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (18))){
var state_74417__$1 = state_74417;
var statearr_74451_74483 = state_74417__$1;
(statearr_74451_74483[(2)] = null);

(statearr_74451_74483[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74418 === (8))){
var inst_74368 = (state_74417[(2)]);
var state_74417__$1 = (function (){var statearr_74452 = state_74417;
(statearr_74452[(11)] = inst_74368);

return statearr_74452;
})();
if(cljs.core.truth_(ledger)){
var statearr_74453_74484 = state_74417__$1;
(statearr_74453_74484[(1)] = (9));

} else {
var statearr_74454_74485 = state_74417__$1;
(statearr_74454_74485[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_74455 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74455[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_74455[(1)] = (1));

return statearr_74455;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_74417){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_74417);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74456){var ex__2687__auto__ = e74456;
var statearr_74457_74486 = state_74417;
(statearr_74457_74486[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_74417[(4)]))){
var statearr_74458_74487 = state_74417;
(statearr_74458_74487[(1)] = cljs.core.first((state_74417[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74488 = state_74417;
state_74417 = G__74488;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_74417){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_74417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74459 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_74459[(6)] = c__2706__auto__);

return statearr_74459;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__74490 = arguments.length;
switch (G__74490) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74525){
var state_val_74526 = (state_74525[(1)]);
if((state_val_74526 === (1))){
var state_74525__$1 = state_74525;
var statearr_74527_74549 = state_74525__$1;
(statearr_74527_74549[(2)] = null);

(statearr_74527_74549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74526 === (2))){
var _ = (function (){var statearr_74528 = state_74525;
(statearr_74528[(4)] = cljs.core.cons((5),(state_74525[(4)])));

return statearr_74528;
})();
var inst_74499 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_74525__$1 = state_74525;
if(cljs.core.truth_(inst_74499)){
var statearr_74529_74550 = state_74525__$1;
(statearr_74529_74550[(1)] = (6));

} else {
var statearr_74530_74551 = state_74525__$1;
(statearr_74530_74551[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74526 === (3))){
var inst_74523 = (state_74525[(2)]);
var state_74525__$1 = state_74525;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74525__$1,inst_74523);
} else {
if((state_val_74526 === (4))){
var inst_74491 = (state_74525[(2)]);
var inst_74492 = cljs.core.clj__GT_js(inst_74491);
var inst_74493 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_74492) : reject.call(null,inst_74492));
var state_74525__$1 = state_74525;
var statearr_74532_74552 = state_74525__$1;
(statearr_74532_74552[(2)] = inst_74493);

(statearr_74532_74552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74526 === (5))){
var _ = (function (){var statearr_74533 = state_74525;
(statearr_74533[(4)] = cljs.core.rest((state_74525[(4)])));

return statearr_74533;
})();
var state_74525__$1 = state_74525;
var ex74531 = (state_74525__$1[(2)]);
var statearr_74534_74553 = state_74525__$1;
(statearr_74534_74553[(5)] = ex74531);


var statearr_74535_74554 = state_74525__$1;
(statearr_74535_74554[(1)] = (4));

(statearr_74535_74554[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74526 === (6))){
var state_74525__$1 = state_74525;
var statearr_74536_74555 = state_74525__$1;
(statearr_74536_74555[(2)] = null);

(statearr_74536_74555[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74526 === (7))){
var inst_74502 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74503 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_74504 = cljs.core.PersistentHashMap.fromArrays(inst_74502,inst_74503);
var inst_74505 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_74504);
var inst_74506 = (function(){throw inst_74505})();
var state_74525__$1 = state_74525;
var statearr_74537_74556 = state_74525__$1;
(statearr_74537_74556[(2)] = inst_74506);

(statearr_74537_74556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74526 === (8))){
var inst_74508 = (state_74525[(2)]);
var inst_74509 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_74510 = [jwt,expire];
var inst_74511 = cljs.core.PersistentHashMap.fromArrays(inst_74509,inst_74510);
var inst_74512 = fluree.db.util.core.without_nils(inst_74511);
var inst_74513 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_74514 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74516 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_74512,inst_74513,null];
var inst_74517 = (new cljs.core.PersistentVector(null,4,(5),inst_74515,inst_74516,null));
var inst_74518 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74514,inst_74517);
var inst_74519 = (function (){var _ = inst_74508;
var data = inst_74512;
var pc = inst_74513;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__74538 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__74538) : reject.call(null,G__74538));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__74539 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__74539) : resolve.call(null,G__74539));

}
});
})();
var inst_74520 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74513,inst_74519);
var _ = (function (){var statearr_74540 = state_74525;
(statearr_74540[(4)] = cljs.core.rest((state_74525[(4)])));

return statearr_74540;
})();
var state_74525__$1 = (function (){var statearr_74541 = state_74525;
(statearr_74541[(7)] = inst_74518);

return statearr_74541;
})();
var statearr_74542_74557 = state_74525__$1;
(statearr_74542_74557[(2)] = inst_74520);

(statearr_74542_74557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_74543 = [null,null,null,null,null,null,null,null];
(statearr_74543[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_74543[(1)] = (1));

return statearr_74543;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_74525){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_74525);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74544){var ex__2687__auto__ = e74544;
var statearr_74545_74558 = state_74525;
(statearr_74545_74558[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_74525[(4)]))){
var statearr_74546_74559 = state_74525;
(statearr_74546_74559[(1)] = cljs.core.first((state_74525[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74560 = state_74525;
state_74525 = G__74560;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_74525){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_74525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74547 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_74547[(6)] = c__2706__auto__);

return statearr_74547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

