// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38053 = arguments.length;
var i__5770__auto___38054 = (0);
while(true){
if((i__5770__auto___38054 < len__5769__auto___38053)){
args__5775__auto__.push((arguments[i__5770__auto___38054]));

var G__38055 = (i__5770__auto___38054 + (1));
i__5770__auto___38054 = G__38055;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
var G__38048_38056 = e;
var G__38049_38057 = "Function Error: ";
var G__38050_38058 = function_name;
var G__38051_38059 = "args: ";
var G__38052_38060 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5(G__38048_38056,G__38049_38057,G__38050_38058,G__38051_38059,G__38052_38060) : fluree.db.util.log.error.call(null,G__38048_38056,G__38049_38057,G__38050_38058,G__38051_38059,G__38052_38060));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq38045){
var G__38046 = cljs.core.first(seq38045);
var seq38045__$1 = cljs.core.next(seq38045);
var G__38047 = cljs.core.first(seq38045__$1);
var seq38045__$2 = cljs.core.next(seq38045__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38046,G__38047,seq38045__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e38061){var e = e38061;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e38062){var e = e38062;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e38063){var e = e38063;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e38064){var e = e38064;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e38065){var e = e38065;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38068 = arguments.length;
var i__5770__auto___38069 = (0);
while(true){
if((i__5770__auto___38069 < len__5769__auto___38068)){
args__5775__auto__.push((arguments[i__5770__auto___38069]));

var G__38070 = (i__5770__auto___38069 + (1));
i__5770__auto___38069 = G__38070;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e38067){var e = e38067;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq38066){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38066));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38073 = arguments.length;
var i__5770__auto___38074 = (0);
while(true){
if((i__5770__auto___38074 < len__5769__auto___38073)){
args__5775__auto__.push((arguments[i__5770__auto___38074]));

var G__38075 = (i__5770__auto___38074 + (1));
i__5770__auto___38074 = G__38075;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e38072){var e = e38072;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq38071){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38071));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e38076){var e = e38076;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38079 = arguments.length;
var i__5770__auto___38080 = (0);
while(true){
if((i__5770__auto___38080 < len__5769__auto___38079)){
args__5775__auto__.push((arguments[i__5770__auto___38080]));

var G__38081 = (i__5770__auto___38080 + (1));
i__5770__auto___38080 = G__38081;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e38078){var e = e38078;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq38077){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38077));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38084 = arguments.length;
var i__5770__auto___38085 = (0);
while(true){
if((i__5770__auto___38085 < len__5769__auto___38084)){
args__5775__auto__.push((arguments[i__5770__auto___38085]));

var G__38086 = (i__5770__auto___38085 + (1));
i__5770__auto___38085 = G__38086;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e38083){var e = e38083;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq38082){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38082));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e38087){var e = e38087;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e38088){var e = e38088;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38091 = arguments.length;
var i__5770__auto___38092 = (0);
while(true){
if((i__5770__auto___38092 < len__5769__auto___38091)){
args__5775__auto__.push((arguments[i__5770__auto___38092]));

var G__38093 = (i__5770__auto___38092 + (1));
i__5770__auto___38092 = G__38093;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e38090){var e = e38090;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq38089){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38089));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38096 = arguments.length;
var i__5770__auto___38097 = (0);
while(true){
if((i__5770__auto___38097 < len__5769__auto___38096)){
args__5775__auto__.push((arguments[i__5770__auto___38097]));

var G__38098 = (i__5770__auto___38097 + (1));
i__5770__auto___38097 = G__38098;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e38095){var e = e38095;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq38094){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38094));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38101 = arguments.length;
var i__5770__auto___38102 = (0);
while(true){
if((i__5770__auto___38102 < len__5769__auto___38101)){
args__5775__auto__.push((arguments[i__5770__auto___38102]));

var G__38103 = (i__5770__auto___38102 + (1));
i__5770__auto___38102 = G__38103;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e38100){var e = e38100;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq38099){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38099));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38106 = arguments.length;
var i__5770__auto___38107 = (0);
while(true){
if((i__5770__auto___38107 < len__5769__auto___38106)){
args__5775__auto__.push((arguments[i__5770__auto___38107]));

var G__38108 = (i__5770__auto___38107 + (1));
i__5770__auto___38107 = G__38108;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e38105){var e = e38105;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq38104){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38104));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38111 = arguments.length;
var i__5770__auto___38112 = (0);
while(true){
if((i__5770__auto___38112 < len__5769__auto___38111)){
args__5775__auto__.push((arguments[i__5770__auto___38112]));

var G__38113 = (i__5770__auto___38112 + (1));
i__5770__auto___38112 = G__38113;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e38110){var e = e38110;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq38109){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38109));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38116 = arguments.length;
var i__5770__auto___38117 = (0);
while(true){
if((i__5770__auto___38117 < len__5769__auto___38116)){
args__5775__auto__.push((arguments[i__5770__auto___38117]));

var G__38118 = (i__5770__auto___38117 + (1));
i__5770__auto___38117 = G__38118;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e38115){var e = e38115;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq38114){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38114));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38121 = arguments.length;
var i__5770__auto___38122 = (0);
while(true){
if((i__5770__auto___38122 < len__5769__auto___38121)){
args__5775__auto__.push((arguments[i__5770__auto___38122]));

var G__38123 = (i__5770__auto___38122 + (1));
i__5770__auto___38122 = G__38123;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e38120){var e = e38120;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq38119){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38119));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__38125 = arguments.length;
switch (G__38125) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_38153){
var state_val_38154 = (state_38153[(1)]);
if((state_val_38154 === (7))){
var inst_38138 = (state_38153[(7)]);
var inst_38141 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38138,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_38153__$1 = state_38153;
var statearr_38155_38241 = state_38153__$1;
(statearr_38155_38241[(2)] = inst_38141);

(statearr_38155_38241[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38154 === (1))){
var state_38153__$1 = state_38153;
var statearr_38156_38242 = state_38153__$1;
(statearr_38156_38242[(2)] = null);

(statearr_38156_38242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38154 === (4))){
var inst_38126 = (state_38153[(2)]);
var state_38153__$1 = state_38153;
var statearr_38157_38243 = state_38153__$1;
(statearr_38157_38243[(2)] = inst_38126);

(statearr_38157_38243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38154 === (6))){
var inst_38138 = (state_38153[(7)]);
var inst_38138__$1 = (state_38153[(2)]);
var inst_38139 = fluree.db.util.core.exception_QMARK_(inst_38138__$1);
var state_38153__$1 = (function (){var statearr_38158 = state_38153;
(statearr_38158[(7)] = inst_38138__$1);

return statearr_38158;
})();
if(inst_38139){
var statearr_38159_38244 = state_38153__$1;
(statearr_38159_38244[(1)] = (7));

} else {
var statearr_38160_38245 = state_38153__$1;
(statearr_38160_38245[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38154 === (3))){
var inst_38151 = (state_38153[(2)]);
var state_38153__$1 = state_38153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38153__$1,inst_38151);
} else {
if((state_val_38154 === (2))){
var inst_38132 = (state_38153[(8)]);
var _ = (function (){var statearr_38162 = state_38153;
(statearr_38162[(4)] = cljs.core.cons((5),(state_38153[(4)])));

return statearr_38162;
})();
var inst_38132__$1 = cljs.core.volatile_BANG_((0));
var inst_38133 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_38134 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_38133,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_38132__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_38135 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_38134);
var inst_38136 = fluree.db.query.fql.query(db,inst_38135);
var state_38153__$1 = (function (){var statearr_38163 = state_38153;
(statearr_38163[(8)] = inst_38132__$1);

return statearr_38163;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38153__$1,(6),inst_38136);
} else {
if((state_val_38154 === (9))){
var inst_38148 = (state_38153[(2)]);
var _ = (function (){var statearr_38164 = state_38153;
(statearr_38164[(4)] = cljs.core.rest((state_38153[(4)])));

return statearr_38164;
})();
var state_38153__$1 = state_38153;
var statearr_38165_38246 = state_38153__$1;
(statearr_38165_38246[(2)] = inst_38148);

(statearr_38165_38246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38154 === (5))){
var _ = (function (){var statearr_38166 = state_38153;
(statearr_38166[(4)] = cljs.core.rest((state_38153[(4)])));

return statearr_38166;
})();
var state_38153__$1 = state_38153;
var ex38161 = (state_38153__$1[(2)]);
var statearr_38167_38247 = state_38153__$1;
(statearr_38167_38247[(5)] = ex38161);


if((ex38161 instanceof Error)){
var statearr_38168_38248 = state_38153__$1;
(statearr_38168_38248[(1)] = (4));

(statearr_38168_38248[(5)] = null);

} else {
throw ex38161;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38154 === (8))){
var inst_38132 = (state_38153[(8)]);
var inst_38138 = (state_38153[(7)]);
var inst_38143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38144 = cljs.core.deref(inst_38132);
var inst_38145 = [inst_38138,inst_38144];
var inst_38146 = (new cljs.core.PersistentVector(null,2,(5),inst_38143,inst_38145,null));
var state_38153__$1 = state_38153;
var statearr_38169_38249 = state_38153__$1;
(statearr_38169_38249[(2)] = inst_38146);

(statearr_38169_38249[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_38170 = [null,null,null,null,null,null,null,null,null];
(statearr_38170[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_38170[(1)] = (1));

return statearr_38170;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_38153){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_38153);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e38171){var ex__2687__auto__ = e38171;
var statearr_38172_38250 = state_38153;
(statearr_38172_38250[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_38153[(4)]))){
var statearr_38173_38251 = state_38153;
(statearr_38173_38251[(1)] = cljs.core.first((state_38153[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38252 = state_38153;
state_38153 = G__38252;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_38153){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_38153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_38174 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_38174[(6)] = c__2706__auto__);

return statearr_38174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_38219){
var state_val_38220 = (state_38219[(1)]);
if((state_val_38220 === (7))){
var inst_38205 = (state_38219[(2)]);
var inst_38206 = fluree.db.query.fql.query(db,inst_38205);
var state_38219__$1 = state_38219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38219__$1,(8),inst_38206);
} else {
if((state_val_38220 === (1))){
var inst_38175 = typeof select === 'string';
var state_38219__$1 = state_38219;
if(cljs.core.truth_(inst_38175)){
var statearr_38221_38253 = state_38219__$1;
(statearr_38221_38253[(1)] = (2));

} else {
var statearr_38222_38254 = state_38219__$1;
(statearr_38222_38254[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38220 === (4))){
var inst_38181 = (state_38219[(7)]);
var inst_38188 = (state_38219[(8)]);
var inst_38180 = (state_38219[(2)]);
var inst_38181__$1 = cljs.core.volatile_BANG_((0));
var inst_38182 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_38183 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_38184 = [inst_38181__$1,(100000)];
var inst_38185 = cljs.core.PersistentHashMap.fromArrays(inst_38183,inst_38184);
var inst_38186 = [inst_38180,from,where,block,limit,inst_38185];
var inst_38187 = cljs.core.PersistentHashMap.fromArrays(inst_38182,inst_38186);
var inst_38188__$1 = fluree.db.util.core.without_nils(inst_38187);
var inst_38189 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_38188__$1);
var inst_38190 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_38188__$1);
var inst_38191 = cljs.core.first(inst_38190);
var inst_38192 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38191], 0));
var inst_38193 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_38192);
var inst_38194 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_38188__$1);
var inst_38195 = cljs.core.last(inst_38194);
var inst_38196 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38195], 0));
var inst_38197 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_38196);
var inst_38198 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38189,inst_38193,inst_38197], 0));
var state_38219__$1 = (function (){var statearr_38223 = state_38219;
(statearr_38223[(7)] = inst_38181__$1);

(statearr_38223[(8)] = inst_38188__$1);

return statearr_38223;
})();
if(cljs.core.truth_(inst_38198)){
var statearr_38224_38255 = state_38219__$1;
(statearr_38224_38255[(1)] = (5));

} else {
var statearr_38225_38256 = state_38219__$1;
(statearr_38225_38256[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38220 === (6))){
var inst_38188 = (state_38219[(8)]);
var state_38219__$1 = state_38219;
var statearr_38226_38257 = state_38219__$1;
(statearr_38226_38257[(2)] = inst_38188);

(statearr_38226_38257[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38220 === (3))){
var state_38219__$1 = state_38219;
var statearr_38227_38258 = state_38219__$1;
(statearr_38227_38258[(2)] = select);

(statearr_38227_38258[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38220 === (2))){
var inst_38177 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_38219__$1 = state_38219;
var statearr_38228_38259 = state_38219__$1;
(statearr_38228_38259[(2)] = inst_38177);

(statearr_38228_38259[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38220 === (11))){
var inst_38217 = (state_38219[(2)]);
var state_38219__$1 = state_38219;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38219__$1,inst_38217);
} else {
if((state_val_38220 === (9))){
var inst_38208 = (state_38219[(9)]);
var state_38219__$1 = state_38219;
var statearr_38229_38260 = state_38219__$1;
(statearr_38229_38260[(2)] = inst_38208);

(statearr_38229_38260[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38220 === (5))){
var inst_38188 = (state_38219[(8)]);
var inst_38200 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_38188);
var inst_38201 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_38200);
var inst_38202 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38188,new cljs.core.Keyword(null,"where","where",-2044795965),inst_38201);
var state_38219__$1 = state_38219;
var statearr_38230_38261 = state_38219__$1;
(statearr_38230_38261[(2)] = inst_38202);

(statearr_38230_38261[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38220 === (10))){
var inst_38181 = (state_38219[(7)]);
var inst_38208 = (state_38219[(9)]);
var inst_38212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38213 = cljs.core.deref(inst_38181);
var inst_38214 = [inst_38208,inst_38213];
var inst_38215 = (new cljs.core.PersistentVector(null,2,(5),inst_38212,inst_38214,null));
var state_38219__$1 = state_38219;
var statearr_38231_38262 = state_38219__$1;
(statearr_38231_38262[(2)] = inst_38215);

(statearr_38231_38262[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38220 === (8))){
var inst_38208 = (state_38219[(9)]);
var inst_38208__$1 = (state_38219[(2)]);
var inst_38209 = fluree.db.util.core.exception_QMARK_(inst_38208__$1);
var state_38219__$1 = (function (){var statearr_38232 = state_38219;
(statearr_38232[(9)] = inst_38208__$1);

return statearr_38232;
})();
if(inst_38209){
var statearr_38233_38263 = state_38219__$1;
(statearr_38233_38263[(1)] = (9));

} else {
var statearr_38234_38264 = state_38219__$1;
(statearr_38234_38264[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_38235 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38235[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_38235[(1)] = (1));

return statearr_38235;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_38219){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_38219);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e38236){var ex__2687__auto__ = e38236;
var statearr_38237_38265 = state_38219;
(statearr_38237_38265[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_38219[(4)]))){
var statearr_38238_38266 = state_38219;
(statearr_38238_38266[(1)] = cljs.core.first((state_38219[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38267 = state_38219;
state_38219 = G__38267;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_38219){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_38219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_38239 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_38239[(6)] = c__2706__auto__);

return statearr_38239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__38271 = path;
var vec__38272 = G__38271;
var seq__38273 = cljs.core.seq(vec__38272);
var first__38274 = cljs.core.first(seq__38273);
var seq__38273__$1 = cljs.core.next(seq__38273);
var var$ = first__38274;
var r = seq__38273__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__38271__$1 = G__38271;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__38278 = G__38271__$1;
var seq__38279 = cljs.core.seq(vec__38278);
var first__38280 = cljs.core.first(seq__38279);
var seq__38279__$1 = cljs.core.next(seq__38279);
var var$__$1 = first__38280;
var r__$1 = seq__38279__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__38281 = r__$1;
var G__38282 = n__$2;
var G__38283 = next_clauses;
G__38271__$1 = G__38281;
n__$1 = G__38282;
where_clauses__$1 = G__38283;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__38284 = r__$1;
var G__38285 = next_n;
var G__38286 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__38271__$1 = G__38284;
n__$1 = G__38285;
where_clauses__$1 = G__38286;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_38323){
var state_val_38324 = (state_38323[(1)]);
if((state_val_38324 === (7))){
var inst_38296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38297 = [path];
var inst_38298 = (new cljs.core.PersistentVector(null,1,(5),inst_38296,inst_38297,null));
var state_38323__$1 = state_38323;
var statearr_38325_38353 = state_38323__$1;
(statearr_38325_38353[(2)] = inst_38298);

(statearr_38325_38353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (1))){
var state_38323__$1 = state_38323;
var statearr_38326_38354 = state_38323__$1;
(statearr_38326_38354[(2)] = null);

(statearr_38326_38354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (4))){
var inst_38287 = (state_38323[(2)]);
var state_38323__$1 = state_38323;
var statearr_38327_38355 = state_38323__$1;
(statearr_38327_38355[(2)] = inst_38287);

(statearr_38327_38355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (13))){
var inst_38314 = (state_38323[(2)]);
var inst_38315 = fluree.db.util.async.throw_err(inst_38314);
var _ = (function (){var statearr_38328 = state_38323;
(statearr_38328[(4)] = cljs.core.rest((state_38323[(4)])));

return statearr_38328;
})();
var state_38323__$1 = state_38323;
var statearr_38329_38356 = state_38323__$1;
(statearr_38329_38356[(2)] = inst_38315);

(statearr_38329_38356[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (6))){
var state_38323__$1 = state_38323;
var statearr_38331_38357 = state_38323__$1;
(statearr_38331_38357[(2)] = path);

(statearr_38331_38357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (3))){
var inst_38321 = (state_38323[(2)]);
var state_38323__$1 = state_38323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38323__$1,inst_38321);
} else {
if((state_val_38324 === (12))){
var _ = (function (){var statearr_38332 = state_38323;
(statearr_38332[(4)] = cljs.core.rest((state_38323[(4)])));

return statearr_38332;
})();
var state_38323__$1 = state_38323;
var ex38330 = (state_38323__$1[(2)]);
var statearr_38333_38358 = state_38323__$1;
(statearr_38333_38358[(5)] = ex38330);


var statearr_38334_38359 = state_38323__$1;
(statearr_38334_38359[(1)] = (11));

(statearr_38334_38359[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (2))){
var _ = (function (){var statearr_38335 = state_38323;
(statearr_38335[(4)] = cljs.core.cons((5),(state_38323[(4)])));

return statearr_38335;
})();
var inst_38293 = cljs.core.vector_QMARK_(path);
var state_38323__$1 = state_38323;
if(inst_38293){
var statearr_38336_38360 = state_38323__$1;
(statearr_38336_38360[(1)] = (6));

} else {
var statearr_38337_38361 = state_38323__$1;
(statearr_38337_38361[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (11))){
var inst_38300 = (state_38323[(7)]);
var inst_38305 = (state_38323[(2)]);
var inst_38306 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38305,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_38300,endSubject], 0));
var state_38323__$1 = state_38323;
var statearr_38339_38362 = state_38323__$1;
(statearr_38339_38362[(2)] = inst_38306);

(statearr_38339_38362[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (9))){
var inst_38304 = (state_38323[(8)]);
var _ = (function (){var statearr_38340 = state_38323;
(statearr_38340[(4)] = cljs.core.cons((12),(state_38323[(4)])));

return statearr_38340;
})();
var inst_38312 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_38304);
var state_38323__$1 = state_38323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38323__$1,(13),inst_38312);
} else {
if((state_val_38324 === (5))){
var _ = (function (){var statearr_38341 = state_38323;
(statearr_38341[(4)] = cljs.core.rest((state_38323[(4)])));

return statearr_38341;
})();
var state_38323__$1 = state_38323;
var ex38338 = (state_38323__$1[(2)]);
var statearr_38342_38363 = state_38323__$1;
(statearr_38342_38363[(5)] = ex38338);


if((ex38338 instanceof Error)){
var statearr_38343_38364 = state_38323__$1;
(statearr_38343_38364[(1)] = (4));

(statearr_38343_38364[(5)] = null);

} else {
throw ex38338;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (10))){
var inst_38318 = (state_38323[(2)]);
var _ = (function (){var statearr_38344 = state_38323;
(statearr_38344[(4)] = cljs.core.rest((state_38323[(4)])));

return statearr_38344;
})();
var state_38323__$1 = state_38323;
var statearr_38345_38365 = state_38323__$1;
(statearr_38345_38365[(2)] = inst_38318);

(statearr_38345_38365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38324 === (8))){
var inst_38300 = (state_38323[(7)]);
var inst_38300__$1 = (state_38323[(2)]);
var inst_38301 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_38300__$1,endSubject);
var inst_38302 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_38303 = ["?var1",inst_38301];
var inst_38304 = cljs.core.PersistentHashMap.fromArrays(inst_38302,inst_38303);
var state_38323__$1 = (function (){var statearr_38346 = state_38323;
(statearr_38346[(8)] = inst_38304);

(statearr_38346[(7)] = inst_38300__$1);

return statearr_38346;
})();
var statearr_38347_38366 = state_38323__$1;
(statearr_38347_38366[(2)] = null);

(statearr_38347_38366[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_38348 = [null,null,null,null,null,null,null,null,null];
(statearr_38348[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__);

(statearr_38348[(1)] = (1));

return statearr_38348;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1 = (function (state_38323){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_38323);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e38349){var ex__2687__auto__ = e38349;
var statearr_38350_38367 = state_38323;
(statearr_38350_38367[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_38323[(4)]))){
var statearr_38351_38368 = state_38323;
(statearr_38351_38368[(1)] = cljs.core.first((state_38323[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38369 = state_38323;
state_38323 = G__38369;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__ = function(state_38323){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1.call(this,state_38323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_38352 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_38352[(6)] = c__2706__auto__);

return statearr_38352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e38370){var e = e38370;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e38371){var e = e38371;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e38372){var e = e38372;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_38426){
var state_val_38427 = (state_38426[(1)]);
if((state_val_38427 === (7))){
var state_38426__$1 = state_38426;
var statearr_38428_38466 = state_38426__$1;
(statearr_38428_38466[(2)] = pred);

(statearr_38428_38466[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (20))){
var inst_38409 = (state_38426[(7)]);
var inst_38405 = (state_38426[(8)]);
var inst_38413 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_38409,inst_38405);
var state_38426__$1 = state_38426;
var statearr_38429_38467 = state_38426__$1;
(statearr_38429_38467[(2)] = inst_38413);

(statearr_38429_38467[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (1))){
var state_38426__$1 = state_38426;
var statearr_38430_38468 = state_38426__$1;
(statearr_38430_38468[(2)] = null);

(statearr_38430_38468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (4))){
var inst_38373 = (state_38426[(2)]);
var state_38426__$1 = state_38426;
var statearr_38431_38469 = state_38426__$1;
(statearr_38431_38469[(2)] = inst_38373);

(statearr_38431_38469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (15))){
var state_38426__$1 = state_38426;
var statearr_38432_38470 = state_38426__$1;
(statearr_38432_38470[(2)] = fluree.db.flake.o);

(statearr_38432_38470[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (21))){
var inst_38409 = (state_38426[(7)]);
var inst_38405 = (state_38426[(8)]);
var inst_38415 = cljs.core.first(inst_38405);
var inst_38416 = (inst_38409.cljs$core$IFn$_invoke$arity$1 ? inst_38409.cljs$core$IFn$_invoke$arity$1(inst_38415) : inst_38409.call(null,inst_38415));
var state_38426__$1 = state_38426;
var statearr_38433_38471 = state_38426__$1;
(statearr_38433_38471[(2)] = inst_38416);

(statearr_38433_38471[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (13))){
var inst_38402 = (state_38426[(2)]);
var inst_38403 = fluree.db.util.async.throw_err(inst_38402);
var state_38426__$1 = state_38426;
var statearr_38434_38472 = state_38426__$1;
(statearr_38434_38472[(2)] = inst_38403);

(statearr_38434_38472[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (22))){
var inst_38418 = (state_38426[(2)]);
var state_38426__$1 = state_38426;
var statearr_38435_38473 = state_38426__$1;
(statearr_38435_38473[(2)] = inst_38418);

(statearr_38435_38473[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (6))){
var inst_38383 = clojure.string.replace(pred,"/_","/");
var state_38426__$1 = state_38426;
var statearr_38436_38474 = state_38426__$1;
(statearr_38436_38474[(2)] = inst_38383);

(statearr_38436_38474[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (17))){
var inst_38387 = (state_38426[(9)]);
var state_38426__$1 = state_38426;
if(cljs.core.truth_(inst_38387)){
var statearr_38437_38475 = state_38426__$1;
(statearr_38437_38475[(1)] = (20));

} else {
var statearr_38438_38476 = state_38426__$1;
(statearr_38438_38476[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (3))){
var inst_38424 = (state_38426[(2)]);
var state_38426__$1 = state_38426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38426__$1,inst_38424);
} else {
if((state_val_38427 === (12))){
var inst_38394 = (state_38426[(2)]);
var inst_38395 = fluree.db.util.async.throw_err(inst_38394);
var state_38426__$1 = state_38426;
var statearr_38439_38477 = state_38426__$1;
(statearr_38439_38477[(2)] = inst_38395);

(statearr_38439_38477[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (2))){
var inst_38381 = (state_38426[(10)]);
var _ = (function (){var statearr_38440 = state_38426;
(statearr_38440[(4)] = cljs.core.cons((5),(state_38426[(4)])));

return statearr_38440;
})();
var inst_38379 = typeof pred === 'string';
var inst_38380 = cljs.core.re_matches(/.+\/_.+/,pred);
var inst_38381__$1 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38379,inst_38380], 0));
var state_38426__$1 = (function (){var statearr_38441 = state_38426;
(statearr_38441[(10)] = inst_38381__$1);

return statearr_38441;
})();
if(cljs.core.truth_(inst_38381__$1)){
var statearr_38442_38478 = state_38426__$1;
(statearr_38442_38478[(1)] = (6));

} else {
var statearr_38443_38479 = state_38426__$1;
(statearr_38443_38479[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (19))){
var inst_38421 = (state_38426[(2)]);
var _ = (function (){var statearr_38444 = state_38426;
(statearr_38444[(4)] = cljs.core.rest((state_38426[(4)])));

return statearr_38444;
})();
var state_38426__$1 = state_38426;
var statearr_38445_38480 = state_38426__$1;
(statearr_38445_38480[(2)] = inst_38421);

(statearr_38445_38480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (11))){
var inst_38381 = (state_38426[(10)]);
var inst_38405 = (state_38426[(2)]);
var state_38426__$1 = (function (){var statearr_38447 = state_38426;
(statearr_38447[(8)] = inst_38405);

return statearr_38447;
})();
if(cljs.core.truth_(inst_38381)){
var statearr_38448_38481 = state_38426__$1;
(statearr_38448_38481[(1)] = (14));

} else {
var statearr_38449_38482 = state_38426__$1;
(statearr_38449_38482[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (9))){
var inst_38386 = (state_38426[(11)]);
var inst_38389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38390 = [sid,inst_38386];
var inst_38391 = (new cljs.core.PersistentVector(null,2,(5),inst_38389,inst_38390,null));
var inst_38392 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_38391);
var state_38426__$1 = state_38426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38426__$1,(12),inst_38392);
} else {
if((state_val_38427 === (5))){
var _ = (function (){var statearr_38450 = state_38426;
(statearr_38450[(4)] = cljs.core.rest((state_38426[(4)])));

return statearr_38450;
})();
var state_38426__$1 = state_38426;
var ex38446 = (state_38426__$1[(2)]);
var statearr_38451_38483 = state_38426__$1;
(statearr_38451_38483[(5)] = ex38446);


if((ex38446 instanceof Error)){
var statearr_38452_38484 = state_38426__$1;
(statearr_38452_38484[(1)] = (4));

(statearr_38452_38484[(5)] = null);

} else {
throw ex38446;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (14))){
var state_38426__$1 = state_38426;
var statearr_38453_38485 = state_38426__$1;
(statearr_38453_38485[(2)] = fluree.db.flake.s);

(statearr_38453_38485[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (16))){
var inst_38405 = (state_38426[(8)]);
var inst_38409 = (state_38426[(2)]);
var inst_38410 = cljs.core.seq(inst_38405);
var state_38426__$1 = (function (){var statearr_38454 = state_38426;
(statearr_38454[(7)] = inst_38409);

return statearr_38454;
})();
if(inst_38410){
var statearr_38455_38486 = state_38426__$1;
(statearr_38455_38486[(1)] = (17));

} else {
var statearr_38456_38487 = state_38426__$1;
(statearr_38456_38487[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (10))){
var inst_38386 = (state_38426[(11)]);
var inst_38397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38398 = [sid,inst_38386];
var inst_38399 = (new cljs.core.PersistentVector(null,2,(5),inst_38397,inst_38398,null));
var inst_38400 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_38399);
var state_38426__$1 = state_38426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38426__$1,(13),inst_38400);
} else {
if((state_val_38427 === (18))){
var state_38426__$1 = state_38426;
var statearr_38457_38488 = state_38426__$1;
(statearr_38457_38488[(2)] = null);

(statearr_38457_38488[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38427 === (8))){
var inst_38386 = (state_38426[(11)]);
var inst_38381 = (state_38426[(10)]);
var inst_38386__$1 = (state_38426[(2)]);
var inst_38387 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_38386__$1);
var state_38426__$1 = (function (){var statearr_38458 = state_38426;
(statearr_38458[(11)] = inst_38386__$1);

(statearr_38458[(9)] = inst_38387);

return statearr_38458;
})();
if(cljs.core.truth_(inst_38381)){
var statearr_38459_38489 = state_38426__$1;
(statearr_38459_38489[(1)] = (9));

} else {
var statearr_38460_38490 = state_38426__$1;
(statearr_38460_38490[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0 = (function (){
var statearr_38461 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38461[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__);

(statearr_38461[(1)] = (1));

return statearr_38461;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1 = (function (state_38426){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_38426);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e38462){var ex__2687__auto__ = e38462;
var statearr_38463_38491 = state_38426;
(statearr_38463_38491[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_38426[(4)]))){
var statearr_38464_38492 = state_38426;
(statearr_38464_38492[(1)] = cljs.core.first((state_38426[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38493 = state_38426;
state_38426 = G__38493;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__ = function(state_38426){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1.call(this,state_38426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_38465 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_38465[(6)] = c__2706__auto__);

return statearr_38465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e38494){var e = e38494;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38497 = arguments.length;
var i__5770__auto___38498 = (0);
while(true){
if((i__5770__auto___38498 < len__5769__auto___38497)){
args__5775__auto__.push((arguments[i__5770__auto___38498]));

var G__38499 = (i__5770__auto___38498 + (1));
i__5770__auto___38498 = G__38499;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e38496){var e = e38496;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq38495){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38495));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38502 = arguments.length;
var i__5770__auto___38503 = (0);
while(true){
if((i__5770__auto___38503 < len__5769__auto___38502)){
args__5775__auto__.push((arguments[i__5770__auto___38503]));

var G__38504 = (i__5770__auto___38503 + (1));
i__5770__auto___38503 = G__38504;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e38501){var e = e38501;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq38500){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38500));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38507 = arguments.length;
var i__5770__auto___38508 = (0);
while(true){
if((i__5770__auto___38508 < len__5769__auto___38507)){
args__5775__auto__.push((arguments[i__5770__auto___38508]));

var G__38509 = (i__5770__auto___38508 + (1));
i__5770__auto___38508 = G__38509;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e38506){var e = e38506;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq38505){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38505));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38512 = arguments.length;
var i__5770__auto___38513 = (0);
while(true){
if((i__5770__auto___38513 < len__5769__auto___38512)){
args__5775__auto__.push((arguments[i__5770__auto___38513]));

var G__38514 = (i__5770__auto___38513 + (1));
i__5770__auto___38513 = G__38514;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e38511){var e = e38511;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq38510){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38510));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e38515){var e = e38515;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e38516){var e = e38516;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e38517){var e = e38517;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e38518){var e = e38518;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e38519){var e = e38519;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__38525 = path;
var vec__38526 = G__38525;
var seq__38527 = cljs.core.seq(vec__38526);
var first__38528 = cljs.core.first(seq__38527);
var seq__38527__$1 = cljs.core.next(seq__38527);
var pred = first__38528;
var r = seq__38527__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__38525__$1 = G__38525;
var subjects__$1 = subjects;
while(true){
var vec__38532 = G__38525__$1;
var seq__38533 = cljs.core.seq(vec__38532);
var first__38534 = cljs.core.first(seq__38533);
var seq__38533__$1 = cljs.core.next(seq__38533);
var pred__$1 = first__38534;
var r__$1 = seq__38533__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__38525__$1,subjects__$1,vec__38532,seq__38533,first__38534,seq__38533__$1,pred__$1,r__$1,subjects__$2,G__38525,vec__38526,seq__38527,first__38528,seq__38527__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__38525__$1,subjects__$1,vec__38532,seq__38533,first__38534,seq__38533__$1,pred__$1,r__$1,subjects__$2,G__38525,vec__38526,seq__38527,first__38528,seq__38527__$1,pred,r,subjects){
return (function (p1__38520_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__38520_SHARP_,pred__$1);
});})(G__38525__$1,subjects__$1,vec__38532,seq__38533,first__38534,seq__38533__$1,pred__$1,r__$1,subjects__$2,G__38525,vec__38526,seq__38527,first__38528,seq__38527__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__38525__$1,subjects__$1,vec__38532,seq__38533,first__38534,seq__38533__$1,pred__$1,r__$1,subjects__$2,G__38525,vec__38526,seq__38527,first__38528,seq__38527__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__38535 = r__$1;
var G__38536 = next_subjects;
G__38525__$1 = G__38535;
subjects__$1 = G__38536;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e38521){var e = e38521;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),fluree.db.dbfunctions.internal.count(path))){
return path;
} else {
var r_path = cljs.core.reverse(path);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first(r_path),cljs.core.rest(r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_38579){
var state_val_38580 = (state_38579[(1)]);
if((state_val_38580 === (7))){
var state_38579__$1 = state_38579;
var statearr_38581_38602 = state_38579__$1;
(statearr_38581_38602[(2)] = path);

(statearr_38581_38602[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38580 === (1))){
var state_38579__$1 = state_38579;
var statearr_38582_38603 = state_38579__$1;
(statearr_38582_38603[(2)] = null);

(statearr_38582_38603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38580 === (4))){
var inst_38537 = (state_38579[(2)]);
var inst_38538 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38537,"follow-subject",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([sid,path], 0));
var state_38579__$1 = state_38579;
var statearr_38583_38604 = state_38579__$1;
(statearr_38583_38604[(2)] = inst_38538);

(statearr_38583_38604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38580 === (6))){
var inst_38558 = (state_38579[(7)]);
var inst_38556 = (state_38579[(2)]);
var inst_38557 = fluree.db.util.async.throw_err(inst_38556);
var inst_38558__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38557,(0),null);
var inst_38559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38557,(1),null);
var inst_38560 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("follow-subject results:",inst_38558__$1) : fluree.db.util.log.debug.call(null,"follow-subject results:",inst_38558__$1));
var inst_38561 = cljs.core.last(path);
var inst_38562 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_38561);
var state_38579__$1 = (function (){var statearr_38584 = state_38579;
(statearr_38584[(8)] = inst_38560);

(statearr_38584[(7)] = inst_38558__$1);

(statearr_38584[(9)] = inst_38559);

return statearr_38584;
})();
if(inst_38562){
var statearr_38585_38605 = state_38579__$1;
(statearr_38585_38605[(1)] = (7));

} else {
var statearr_38586_38606 = state_38579__$1;
(statearr_38586_38606[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38580 === (3))){
var inst_38577 = (state_38579[(2)]);
var state_38579__$1 = state_38579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38579__$1,inst_38577);
} else {
if((state_val_38580 === (2))){
var _ = (function (){var statearr_38588 = state_38579;
(statearr_38588[(4)] = cljs.core.cons((5),(state_38579[(4)])));

return statearr_38588;
})();
var inst_38547 = fluree.db.dbfunctions.internal.select_from_path(path);
var inst_38548 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_38549 = cljs.core.PersistentHashMap.EMPTY;
var inst_38550 = [inst_38547,sid,inst_38549];
var inst_38551 = cljs.core.PersistentHashMap.fromArrays(inst_38548,inst_38550);
var inst_38552 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("follow-subject query:",inst_38551) : fluree.db.util.log.debug.call(null,"follow-subject query:",inst_38551));
var inst_38553 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38554 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38553,inst_38551);
var state_38579__$1 = (function (){var statearr_38589 = state_38579;
(statearr_38589[(10)] = inst_38552);

return statearr_38589;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38579__$1,(6),inst_38554);
} else {
if((state_val_38580 === (9))){
var inst_38558 = (state_38579[(7)]);
var inst_38559 = (state_38579[(9)]);
var inst_38567 = (state_38579[(2)]);
var inst_38568 = fluree.db.dbfunctions.internal.get_all(inst_38558,inst_38567);
var inst_38569 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("follow-subject res*:",inst_38568) : fluree.db.util.log.debug.call(null,"follow-subject res*:",inst_38568));
var inst_38570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38571 = fluree.db.dbfunctions.internal.count(path);
var inst_38572 = fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38559,inst_38571,(9)], 0));
var inst_38573 = [inst_38568,inst_38572];
var inst_38574 = (new cljs.core.PersistentVector(null,2,(5),inst_38570,inst_38573,null));
var _ = (function (){var statearr_38590 = state_38579;
(statearr_38590[(4)] = cljs.core.rest((state_38579[(4)])));

return statearr_38590;
})();
var state_38579__$1 = (function (){var statearr_38591 = state_38579;
(statearr_38591[(11)] = inst_38569);

return statearr_38591;
})();
var statearr_38592_38607 = state_38579__$1;
(statearr_38592_38607[(2)] = inst_38574);

(statearr_38592_38607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38580 === (5))){
var _ = (function (){var statearr_38593 = state_38579;
(statearr_38593[(4)] = cljs.core.rest((state_38579[(4)])));

return statearr_38593;
})();
var state_38579__$1 = state_38579;
var ex38587 = (state_38579__$1[(2)]);
var statearr_38594_38608 = state_38579__$1;
(statearr_38594_38608[(5)] = ex38587);


var statearr_38595_38609 = state_38579__$1;
(statearr_38595_38609[(1)] = (4));

(statearr_38595_38609[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38580 === (8))){
var inst_38565 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,"_id");
var state_38579__$1 = state_38579;
var statearr_38596_38610 = state_38579__$1;
(statearr_38596_38610[(2)] = inst_38565);

(statearr_38596_38610[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0 = (function (){
var statearr_38597 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38597[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__);

(statearr_38597[(1)] = (1));

return statearr_38597;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1 = (function (state_38579){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_38579);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e38598){var ex__2687__auto__ = e38598;
var statearr_38599_38611 = state_38579;
(statearr_38599_38611[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_38579[(4)]))){
var statearr_38600_38612 = state_38579;
(statearr_38600_38612[(1)] = cljs.core.first((state_38579[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38613 = state_38579;
state_38579 = G__38613;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__ = function(state_38579){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1.call(this,state_38579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_38601 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_38601[(6)] = c__2706__auto__);

return statearr_38601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e38614){var e = e38614;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_(key)){
return cljs.core.some((function (p1__38615_SHARP_){
return (fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2(coll,p1__38615_SHARP_) : fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__38615_SHARP_));
}),key);
} else {
return cljs.core.contains_QMARK_(coll,key);
}
}catch (e38616){var e = e38616;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38619 = arguments.length;
var i__5770__auto___38620 = (0);
while(true){
if((i__5770__auto___38620 < len__5769__auto___38619)){
args__5775__auto__.push((arguments[i__5770__auto___38620]));

var G__38621 = (i__5770__auto___38620 + (1));
i__5770__auto___38620 = G__38621;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e38618){var e = e38618;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq38617){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38617));
}));

/**
 * Returns the nth element in coll.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e38622){var e = e38622;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns the first element in coll.
 */
fluree.db.dbfunctions.internal.first = (function fluree$db$dbfunctions$internal$first(coll){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.vec(coll):coll);
return cljs.core.first(coll_SINGLEQUOTE_);
}catch (e38623){var e = e38623;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"first",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38626 = arguments.length;
var i__5770__auto___38627 = (0);
while(true){
if((i__5770__auto___38627 < len__5769__auto___38626)){
args__5775__auto__.push((arguments[i__5770__auto___38627]));

var G__38628 = (i__5770__auto___38627 + (1));
i__5770__auto___38627 = G__38628;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e38625){var e = e38625;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq38624){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38624));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e38629){var e = e38629;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_38686){
var state_val_38687 = (state_38686[(1)]);
if((state_val_38687 === (7))){
var inst_38632 = (state_38686[(2)]);
var state_38686__$1 = state_38686;
var statearr_38688_38722 = state_38686__$1;
(statearr_38688_38722[(2)] = inst_38632);

(statearr_38688_38722[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (1))){
var state_38686__$1 = state_38686;
var statearr_38689_38723 = state_38686__$1;
(statearr_38689_38723[(2)] = null);

(statearr_38689_38723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (4))){
var inst_38631 = (state_38686[(2)]);
var state_38686__$1 = (function (){var statearr_38690 = state_38686;
(statearr_38690[(7)] = inst_38631);

return statearr_38690;
})();
var statearr_38691_38724 = state_38686__$1;
(statearr_38691_38724[(2)] = null);

(statearr_38691_38724[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (15))){
var inst_38656 = (state_38686[(8)]);
var inst_38669 = (state_38686[(9)]);
var inst_38654 = (state_38686[(10)]);
var inst_38657 = (state_38686[(11)]);
var inst_38666 = (state_38686[(12)]);
var inst_38667 = (state_38686[(13)]);
var inst_38673 = (function (){var db = inst_38654;
var prevT = inst_38656;
var db_SINGLEQUOTE_ = inst_38657;
var prev_vals = inst_38666;
var fuel = inst_38667;
var G__38668 = inst_38669;
return (function (p1__38630_SHARP_){
var f = p1__38630_SHARP_;
return fluree.db.flake.o(f);
});
})();
var inst_38674 = (inst_38673.cljs$core$IFn$_invoke$arity$1 ? inst_38673.cljs$core$IFn$_invoke$arity$1(inst_38669) : inst_38673.call(null,inst_38669));
var state_38686__$1 = state_38686;
var statearr_38692_38725 = state_38686__$1;
(statearr_38692_38725[(2)] = inst_38674);

(statearr_38692_38725[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (13))){
var inst_38669 = (state_38686[(9)]);
var inst_38666 = (state_38686[(12)]);
var inst_38665 = (state_38686[(2)]);
var inst_38666__$1 = fluree.db.util.async.throw_err(inst_38665);
var inst_38667 = fluree.db.dbfunctions.internal.count(inst_38666__$1);
var inst_38669__$1 = cljs.core.first(inst_38666__$1);
var inst_38670 = (inst_38669__$1 == null);
var state_38686__$1 = (function (){var statearr_38693 = state_38686;
(statearr_38693[(9)] = inst_38669__$1);

(statearr_38693[(12)] = inst_38666__$1);

(statearr_38693[(13)] = inst_38667);

return statearr_38693;
})();
if(cljs.core.truth_(inst_38670)){
var statearr_38694_38726 = state_38686__$1;
(statearr_38694_38726[(1)] = (14));

} else {
var statearr_38695_38727 = state_38686__$1;
(statearr_38695_38727[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (6))){
var inst_38641 = (state_38686[(2)]);
var state_38686__$1 = state_38686;
var statearr_38696_38728 = state_38686__$1;
(statearr_38696_38728[(2)] = inst_38641);

(statearr_38696_38728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (3))){
var inst_38684 = (state_38686[(2)]);
var state_38686__$1 = state_38686;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38686__$1,inst_38684);
} else {
if((state_val_38687 === (12))){
var inst_38681 = (state_38686[(2)]);
var _ = (function (){var statearr_38697 = state_38686;
(statearr_38697[(4)] = cljs.core.rest((state_38686[(4)])));

return statearr_38697;
})();
var state_38686__$1 = state_38686;
var statearr_38698_38729 = state_38686__$1;
(statearr_38698_38729[(2)] = inst_38681);

(statearr_38698_38729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (2))){
var _ = (function (){var statearr_38700 = state_38686;
(statearr_38700[(4)] = cljs.core.cons((9),(state_38686[(4)])));

return statearr_38700;
})();
var inst_38647 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38648 = typeof inst_38647 === 'string';
var state_38686__$1 = state_38686;
if(cljs.core.truth_(inst_38648)){
var statearr_38701_38730 = state_38686__$1;
(statearr_38701_38730[(1)] = (10));

} else {
var statearr_38702_38731 = state_38686__$1;
(statearr_38702_38731[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (11))){
var inst_38656 = (state_38686[(8)]);
var inst_38654 = (state_38686[(10)]);
var inst_38657 = (state_38686[(11)]);
var inst_38654__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38655 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_38654__$1);
var inst_38656__$1 = fluree.db.dbfunctions.internal.inc(inst_38655);
var inst_38657__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38654__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_38656__$1);
var inst_38658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38659 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38660 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38661 = [inst_38659,inst_38660];
var inst_38662 = (new cljs.core.PersistentVector(null,2,(5),inst_38658,inst_38661,null));
var inst_38663 = fluree.db.dbproto._search(inst_38657__$1,inst_38662);
var state_38686__$1 = (function (){var statearr_38703 = state_38686;
(statearr_38703[(8)] = inst_38656__$1);

(statearr_38703[(10)] = inst_38654__$1);

(statearr_38703[(11)] = inst_38657__$1);

return statearr_38703;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38686__$1,(13),inst_38663);
} else {
if((state_val_38687 === (9))){
var _ = (function (){var statearr_38704 = state_38686;
(statearr_38704[(4)] = cljs.core.rest((state_38686[(4)])));

return statearr_38704;
})();
var state_38686__$1 = state_38686;
var ex38699 = (state_38686__$1[(2)]);
var statearr_38705_38732 = state_38686__$1;
(statearr_38705_38732[(5)] = ex38699);


var statearr_38706_38733 = state_38686__$1;
(statearr_38706_38733[(1)] = (4));

(statearr_38706_38733[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (5))){
var inst_38631 = (state_38686[(7)]);
var _ = (function (){var statearr_38707 = state_38686;
(statearr_38707[(4)] = cljs.core.cons((8),(state_38686[(4)])));

return statearr_38707;
})();
var inst_38638 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38631,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_38708 = state_38686;
(statearr_38708[(4)] = cljs.core.rest((state_38686[(4)])));

return statearr_38708;
})();
var state_38686__$1 = state_38686;
var statearr_38709_38734 = state_38686__$1;
(statearr_38709_38734[(2)] = inst_38638);

(statearr_38709_38734[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (14))){
var state_38686__$1 = state_38686;
var statearr_38710_38735 = state_38686__$1;
(statearr_38710_38735[(2)] = null);

(statearr_38710_38735[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (16))){
var inst_38667 = (state_38686[(13)]);
var inst_38676 = (state_38686[(2)]);
var inst_38677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38678 = [inst_38676,inst_38667];
var inst_38679 = (new cljs.core.PersistentVector(null,2,(5),inst_38677,inst_38678,null));
var state_38686__$1 = state_38686;
var statearr_38712_38736 = state_38686__$1;
(statearr_38712_38736[(2)] = inst_38679);

(statearr_38712_38736[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (10))){
var inst_38650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38651 = [null,(0)];
var inst_38652 = (new cljs.core.PersistentVector(null,2,(5),inst_38650,inst_38651,null));
var state_38686__$1 = state_38686;
var statearr_38713_38737 = state_38686__$1;
(statearr_38713_38737[(2)] = inst_38652);

(statearr_38713_38737[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38687 === (8))){
var _ = (function (){var statearr_38714 = state_38686;
(statearr_38714[(4)] = cljs.core.rest((state_38686[(4)])));

return statearr_38714;
})();
var state_38686__$1 = state_38686;
var ex38711 = (state_38686__$1[(2)]);
var statearr_38715_38738 = state_38686__$1;
(statearr_38715_38738[(5)] = ex38711);


var statearr_38716_38739 = state_38686__$1;
(statearr_38716_38739[(1)] = (7));

(statearr_38716_38739[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0 = (function (){
var statearr_38717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38717[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__);

(statearr_38717[(1)] = (1));

return statearr_38717;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1 = (function (state_38686){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_38686);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e38718){var ex__2687__auto__ = e38718;
var statearr_38719_38740 = state_38686;
(statearr_38719_38740[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_38686[(4)]))){
var statearr_38720_38741 = state_38686;
(statearr_38720_38741[(1)] = cljs.core.first((state_38686[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38742 = state_38686;
state_38686 = G__38742;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__ = function(state_38686){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1.call(this,state_38686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_38721 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_38721[(6)] = c__2706__auto__);

return statearr_38721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_38794){
var state_val_38795 = (state_38794[(1)]);
if((state_val_38795 === (7))){
var inst_38744 = (state_38794[(2)]);
var state_38794__$1 = state_38794;
var statearr_38796_38825 = state_38794__$1;
(statearr_38796_38825[(2)] = inst_38744);

(statearr_38796_38825[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38795 === (1))){
var state_38794__$1 = state_38794;
var statearr_38797_38826 = state_38794__$1;
(statearr_38797_38826[(2)] = null);

(statearr_38797_38826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38795 === (4))){
var inst_38743 = (state_38794[(2)]);
var state_38794__$1 = (function (){var statearr_38798 = state_38794;
(statearr_38798[(7)] = inst_38743);

return statearr_38798;
})();
var statearr_38799_38827 = state_38794__$1;
(statearr_38799_38827[(2)] = null);

(statearr_38799_38827[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38795 === (13))){
var inst_38789 = (state_38794[(2)]);
var _ = (function (){var statearr_38800 = state_38794;
(statearr_38800[(4)] = cljs.core.rest((state_38794[(4)])));

return statearr_38800;
})();
var state_38794__$1 = state_38794;
var statearr_38801_38828 = state_38794__$1;
(statearr_38801_38828[(2)] = inst_38789);

(statearr_38801_38828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38795 === (6))){
var inst_38753 = (state_38794[(2)]);
var state_38794__$1 = state_38794;
var statearr_38802_38829 = state_38794__$1;
(statearr_38802_38829[(2)] = inst_38753);

(statearr_38802_38829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38795 === (3))){
var inst_38792 = (state_38794[(2)]);
var state_38794__$1 = state_38794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38794__$1,inst_38792);
} else {
if((state_val_38795 === (12))){
var inst_38776 = (state_38794[(8)]);
var inst_38785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38786 = [null,inst_38776];
var inst_38787 = (new cljs.core.PersistentVector(null,2,(5),inst_38785,inst_38786,null));
var state_38794__$1 = state_38794;
var statearr_38803_38830 = state_38794__$1;
(statearr_38803_38830[(2)] = inst_38787);

(statearr_38803_38830[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38795 === (2))){
var _ = (function (){var statearr_38805 = state_38794;
(statearr_38805[(4)] = cljs.core.cons((9),(state_38794[(4)])));

return statearr_38805;
})();
var inst_38762 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_38763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38765 = [null,pred_name,"?o"];
var inst_38766 = (new cljs.core.PersistentVector(null,3,(5),inst_38764,inst_38765,null));
var inst_38767 = [inst_38766];
var inst_38768 = (new cljs.core.PersistentVector(null,1,(5),inst_38763,inst_38767,null));
var inst_38769 = ["?o",inst_38768,opts];
var inst_38770 = cljs.core.PersistentHashMap.fromArrays(inst_38762,inst_38769);
var inst_38771 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_38770);
var state_38794__$1 = state_38794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38794__$1,(10),inst_38771);
} else {
if((state_val_38795 === (11))){
var inst_38776 = (state_38794[(8)]);
var inst_38775 = (state_38794[(9)]);
var inst_38780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38781 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_38775);
var inst_38782 = [inst_38781,inst_38776];
var inst_38783 = (new cljs.core.PersistentVector(null,2,(5),inst_38780,inst_38782,null));
var state_38794__$1 = state_38794;
var statearr_38806_38831 = state_38794__$1;
(statearr_38806_38831[(2)] = inst_38783);

(statearr_38806_38831[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38795 === (9))){
var _ = (function (){var statearr_38807 = state_38794;
(statearr_38807[(4)] = cljs.core.rest((state_38794[(4)])));

return statearr_38807;
})();
var state_38794__$1 = state_38794;
var ex38804 = (state_38794__$1[(2)]);
var statearr_38808_38832 = state_38794__$1;
(statearr_38808_38832[(5)] = ex38804);


var statearr_38809_38833 = state_38794__$1;
(statearr_38809_38833[(1)] = (4));

(statearr_38809_38833[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38795 === (5))){
var inst_38743 = (state_38794[(7)]);
var _ = (function (){var statearr_38811 = state_38794;
(statearr_38811[(4)] = cljs.core.cons((8),(state_38794[(4)])));

return statearr_38811;
})();
var inst_38750 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38743,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_38812 = state_38794;
(statearr_38812[(4)] = cljs.core.rest((state_38794[(4)])));

return statearr_38812;
})();
var state_38794__$1 = state_38794;
var statearr_38813_38834 = state_38794__$1;
(statearr_38813_38834[(2)] = inst_38750);

(statearr_38813_38834[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38795 === (10))){
var inst_38775 = (state_38794[(9)]);
var inst_38773 = (state_38794[(2)]);
var inst_38774 = fluree.db.util.async.throw_err(inst_38773);
var inst_38775__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38774,(0),null);
var inst_38776 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38774,(1),null);
var inst_38777 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_38775__$1);
var inst_38778 = cljs.core.not(inst_38777);
var state_38794__$1 = (function (){var statearr_38814 = state_38794;
(statearr_38814[(8)] = inst_38776);

(statearr_38814[(9)] = inst_38775__$1);

return statearr_38814;
})();
if(inst_38778){
var statearr_38815_38835 = state_38794__$1;
(statearr_38815_38835[(1)] = (11));

} else {
var statearr_38816_38836 = state_38794__$1;
(statearr_38816_38836[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38795 === (8))){
var _ = (function (){var statearr_38817 = state_38794;
(statearr_38817[(4)] = cljs.core.rest((state_38794[(4)])));

return statearr_38817;
})();
var state_38794__$1 = state_38794;
var ex38810 = (state_38794__$1[(2)]);
var statearr_38818_38837 = state_38794__$1;
(statearr_38818_38837[(5)] = ex38810);


var statearr_38819_38838 = state_38794__$1;
(statearr_38819_38838[(1)] = (7));

(statearr_38819_38838[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0 = (function (){
var statearr_38820 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38820[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__);

(statearr_38820[(1)] = (1));

return statearr_38820;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1 = (function (state_38794){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_38794);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e38821){var ex__2687__auto__ = e38821;
var statearr_38822_38839 = state_38794;
(statearr_38822_38839[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_38794[(4)]))){
var statearr_38823_38840 = state_38794;
(statearr_38823_38840[(1)] = cljs.core.first((state_38794[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38841 = state_38794;
state_38794 = G__38841;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__ = function(state_38794){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1.call(this,state_38794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_38824 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_38824[(6)] = c__2706__auto__);

return statearr_38824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e38842){var e = e38842;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__38844 = arguments.length;
switch (G__38844) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_38914){
var state_val_38915 = (state_38914[(1)]);
if((state_val_38915 === (7))){
var inst_38846 = (state_38914[(2)]);
var state_38914__$1 = state_38914;
var statearr_38916_38960 = state_38914__$1;
(statearr_38916_38960[(2)] = inst_38846);

(statearr_38916_38960[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (20))){
var inst_38890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38891 = ["*"];
var inst_38892 = (new cljs.core.PersistentVector(null,1,(5),inst_38890,inst_38891,null));
var state_38914__$1 = state_38914;
var statearr_38917_38961 = state_38914__$1;
(statearr_38917_38961[(2)] = inst_38892);

(statearr_38917_38961[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (1))){
var state_38914__$1 = state_38914;
var statearr_38918_38962 = state_38914__$1;
(statearr_38918_38962[(2)] = null);

(statearr_38918_38962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (4))){
var inst_38845 = (state_38914[(2)]);
var state_38914__$1 = (function (){var statearr_38919 = state_38914;
(statearr_38919[(7)] = inst_38845);

return statearr_38919;
})();
var statearr_38920_38963 = state_38914__$1;
(statearr_38920_38963[(2)] = null);

(statearr_38920_38963[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (15))){
var inst_38909 = (state_38914[(2)]);
var _ = (function (){var statearr_38921 = state_38914;
(statearr_38921[(4)] = cljs.core.rest((state_38914[(4)])));

return statearr_38921;
})();
var state_38914__$1 = state_38914;
var statearr_38922_38964 = state_38914__$1;
(statearr_38922_38964[(2)] = inst_38909);

(statearr_38922_38964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (21))){
var inst_38873 = (state_38914[(8)]);
var inst_38880 = (state_38914[(9)]);
var inst_38894 = (state_38914[(2)]);
var inst_38895 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_38896 = cljs.core.PersistentHashMap.EMPTY;
var inst_38897 = [inst_38894,inst_38880,inst_38896];
var inst_38898 = cljs.core.PersistentHashMap.fromArrays(inst_38895,inst_38897);
var inst_38899 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38873,inst_38898);
var state_38914__$1 = state_38914;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38914__$1,(22),inst_38899);
} else {
if((state_val_38915 === (13))){
var inst_38868 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38914__$1 = state_38914;
var statearr_38923_38965 = state_38914__$1;
(statearr_38923_38965[(2)] = inst_38868);

(statearr_38923_38965[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (22))){
var inst_38901 = (state_38914[(2)]);
var inst_38902 = fluree.db.util.async.throw_err(inst_38901);
var inst_38903 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38902,(0),null);
var inst_38904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38902,(1),null);
var inst_38905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38906 = [inst_38903,inst_38904];
var inst_38907 = (new cljs.core.PersistentVector(null,2,(5),inst_38905,inst_38906,null));
var state_38914__$1 = state_38914;
var statearr_38924_38966 = state_38914__$1;
(statearr_38924_38966[(2)] = inst_38907);

(statearr_38924_38966[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (6))){
var inst_38855 = (state_38914[(2)]);
var state_38914__$1 = state_38914;
var statearr_38925_38967 = state_38914__$1;
(statearr_38925_38967[(2)] = inst_38855);

(statearr_38925_38967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (17))){
var inst_38877 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38878 = fluree.db.dbfunctions.internal.get(inst_38877,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_38914__$1 = state_38914;
var statearr_38926_38968 = state_38914__$1;
(statearr_38926_38968[(2)] = inst_38878);

(statearr_38926_38968[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (3))){
var inst_38912 = (state_38914[(2)]);
var state_38914__$1 = state_38914;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38914__$1,inst_38912);
} else {
if((state_val_38915 === (12))){
var inst_38866 = (state_38914[(2)]);
var state_38914__$1 = state_38914;
if(cljs.core.truth_(inst_38866)){
var statearr_38927_38969 = state_38914__$1;
(statearr_38927_38969[(1)] = (13));

} else {
var statearr_38928_38970 = state_38914__$1;
(statearr_38928_38970[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (2))){
var inst_38861 = (state_38914[(10)]);
var _ = (function (){var statearr_38929 = state_38914;
(statearr_38929[(4)] = cljs.core.cons((9),(state_38914[(4)])));

return statearr_38929;
})();
var inst_38861__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38914__$1 = (function (){var statearr_38930 = state_38914;
(statearr_38930[(10)] = inst_38861__$1);

return statearr_38930;
})();
if(cljs.core.truth_(inst_38861__$1)){
var statearr_38931_38971 = state_38914__$1;
(statearr_38931_38971[(1)] = (10));

} else {
var statearr_38932_38972 = state_38914__$1;
(statearr_38932_38972[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (19))){
var inst_38882 = cljs.core.PersistentVector.EMPTY;
var inst_38883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38884 = ["*"];
var inst_38885 = (new cljs.core.PersistentVector(null,1,(5),inst_38883,inst_38884,null));
var inst_38886 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_38887 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38885,inst_38886);
var inst_38888 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38882,inst_38887);
var state_38914__$1 = state_38914;
var statearr_38934_38973 = state_38914__$1;
(statearr_38934_38973[(2)] = inst_38888);

(statearr_38934_38973[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (11))){
var inst_38861 = (state_38914[(10)]);
var state_38914__$1 = state_38914;
var statearr_38935_38974 = state_38914__$1;
(statearr_38935_38974[(2)] = inst_38861);

(statearr_38935_38974[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (9))){
var _ = (function (){var statearr_38936 = state_38914;
(statearr_38936[(4)] = cljs.core.rest((state_38914[(4)])));

return statearr_38936;
})();
var state_38914__$1 = state_38914;
var ex38933 = (state_38914__$1[(2)]);
var statearr_38937_38975 = state_38914__$1;
(statearr_38937_38975[(5)] = ex38933);


var statearr_38938_38976 = state_38914__$1;
(statearr_38938_38976[(1)] = (4));

(statearr_38938_38976[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (5))){
var inst_38845 = (state_38914[(7)]);
var _ = (function (){var statearr_38939 = state_38914;
(statearr_38939[(4)] = cljs.core.cons((8),(state_38914[(4)])));

return statearr_38939;
})();
var inst_38852 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38845,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_38940 = state_38914;
(statearr_38940[(4)] = cljs.core.rest((state_38914[(4)])));

return statearr_38940;
})();
var state_38914__$1 = state_38914;
var statearr_38941_38977 = state_38914__$1;
(statearr_38941_38977[(2)] = inst_38852);

(statearr_38941_38977[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (14))){
var inst_38874 = (state_38914[(11)]);
var inst_38873 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38874__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38914__$1 = (function (){var statearr_38942 = state_38914;
(statearr_38942[(8)] = inst_38873);

(statearr_38942[(11)] = inst_38874__$1);

return statearr_38942;
})();
if(cljs.core.truth_(inst_38874__$1)){
var statearr_38943_38978 = state_38914__$1;
(statearr_38943_38978[(1)] = (16));

} else {
var statearr_38944_38979 = state_38914__$1;
(statearr_38944_38979[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (16))){
var inst_38874 = (state_38914[(11)]);
var state_38914__$1 = state_38914;
var statearr_38945_38980 = state_38914__$1;
(statearr_38945_38980[(2)] = inst_38874);

(statearr_38945_38980[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (10))){
var inst_38863 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_38914__$1 = state_38914;
var statearr_38947_38981 = state_38914__$1;
(statearr_38947_38981[(2)] = inst_38863);

(statearr_38947_38981[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (18))){
var inst_38880 = (state_38914[(2)]);
var state_38914__$1 = (function (){var statearr_38948 = state_38914;
(statearr_38948[(9)] = inst_38880);

return statearr_38948;
})();
if(cljs.core.truth_(additional_params)){
var statearr_38949_38982 = state_38914__$1;
(statearr_38949_38982[(1)] = (19));

} else {
var statearr_38950_38983 = state_38914__$1;
(statearr_38950_38983[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38915 === (8))){
var _ = (function (){var statearr_38951 = state_38914;
(statearr_38951[(4)] = cljs.core.rest((state_38914[(4)])));

return statearr_38951;
})();
var state_38914__$1 = state_38914;
var ex38946 = (state_38914__$1[(2)]);
var statearr_38952_38984 = state_38914__$1;
(statearr_38952_38984[(5)] = ex38946);


var statearr_38953_38985 = state_38914__$1;
(statearr_38953_38985[(1)] = (7));

(statearr_38953_38985[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_38954 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38954[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_38954[(1)] = (1));

return statearr_38954;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_38914){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_38914);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e38955){var ex__2687__auto__ = e38955;
var statearr_38956_38986 = state_38914;
(statearr_38956_38986[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_38914[(4)]))){
var statearr_38957_38987 = state_38914;
(statearr_38957_38987[(1)] = cljs.core.first((state_38914[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38988 = state_38914;
state_38914 = G__38988;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_38914){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_38914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_38958 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_38958[(6)] = c__2706__auto__);

return statearr_38958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__38990 = arguments.length;
switch (G__38990) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_39034){
var state_val_39035 = (state_39034[(1)]);
if((state_val_39035 === (7))){
var inst_39012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39013 = ["*"];
var inst_39014 = (new cljs.core.PersistentVector(null,1,(5),inst_39012,inst_39013,null));
var state_39034__$1 = state_39034;
var statearr_39036_39056 = state_39034__$1;
(statearr_39036_39056[(2)] = inst_39014);

(statearr_39036_39056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39035 === (1))){
var state_39034__$1 = state_39034;
var statearr_39037_39057 = state_39034__$1;
(statearr_39037_39057[(2)] = null);

(statearr_39037_39057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39035 === (4))){
var inst_38991 = (state_39034[(2)]);
var inst_38992 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38991,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_39034__$1 = state_39034;
var statearr_39038_39058 = state_39034__$1;
(statearr_39038_39058[(2)] = inst_38992);

(statearr_39038_39058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39035 === (6))){
var inst_39004 = cljs.core.PersistentVector.EMPTY;
var inst_39005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39006 = ["*"];
var inst_39007 = (new cljs.core.PersistentVector(null,1,(5),inst_39005,inst_39006,null));
var inst_39008 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_39009 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39007,inst_39008);
var inst_39010 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39004,inst_39009);
var state_39034__$1 = state_39034;
var statearr_39039_39059 = state_39034__$1;
(statearr_39039_39059[(2)] = inst_39010);

(statearr_39039_39059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39035 === (3))){
var inst_39032 = (state_39034[(2)]);
var state_39034__$1 = state_39034;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39034__$1,inst_39032);
} else {
if((state_val_39035 === (2))){
var _ = (function (){var statearr_39041 = state_39034;
(statearr_39041[(4)] = cljs.core.cons((5),(state_39034[(4)])));

return statearr_39041;
})();
var inst_39001 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39002 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39034__$1 = (function (){var statearr_39042 = state_39034;
(statearr_39042[(7)] = inst_39001);

(statearr_39042[(8)] = inst_39002);

return statearr_39042;
})();
if(cljs.core.truth_(additional_params)){
var statearr_39043_39060 = state_39034__$1;
(statearr_39043_39060[(1)] = (6));

} else {
var statearr_39044_39061 = state_39034__$1;
(statearr_39044_39061[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39035 === (9))){
var inst_39023 = (state_39034[(2)]);
var inst_39024 = fluree.db.util.async.throw_err(inst_39023);
var inst_39025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39024,(0),null);
var inst_39026 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39024,(1),null);
var inst_39027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39028 = [inst_39025,inst_39026];
var inst_39029 = (new cljs.core.PersistentVector(null,2,(5),inst_39027,inst_39028,null));
var _ = (function (){var statearr_39045 = state_39034;
(statearr_39045[(4)] = cljs.core.rest((state_39034[(4)])));

return statearr_39045;
})();
var state_39034__$1 = state_39034;
var statearr_39046_39062 = state_39034__$1;
(statearr_39046_39062[(2)] = inst_39029);

(statearr_39046_39062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39035 === (5))){
var _ = (function (){var statearr_39047 = state_39034;
(statearr_39047[(4)] = cljs.core.rest((state_39034[(4)])));

return statearr_39047;
})();
var state_39034__$1 = state_39034;
var ex39040 = (state_39034__$1[(2)]);
var statearr_39048_39063 = state_39034__$1;
(statearr_39048_39063[(5)] = ex39040);


var statearr_39049_39064 = state_39034__$1;
(statearr_39049_39064[(1)] = (4));

(statearr_39049_39064[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39035 === (8))){
var inst_39001 = (state_39034[(7)]);
var inst_39002 = (state_39034[(8)]);
var inst_39016 = (state_39034[(2)]);
var inst_39017 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39018 = cljs.core.PersistentHashMap.EMPTY;
var inst_39019 = [inst_39016,inst_39002,inst_39018];
var inst_39020 = cljs.core.PersistentHashMap.fromArrays(inst_39017,inst_39019);
var inst_39021 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_39001,inst_39020);
var state_39034__$1 = state_39034;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39034__$1,(9),inst_39021);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_39050 = [null,null,null,null,null,null,null,null,null];
(statearr_39050[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_39050[(1)] = (1));

return statearr_39050;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_39034){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_39034);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e39051){var ex__2687__auto__ = e39051;
var statearr_39052_39065 = state_39034;
(statearr_39052_39065[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_39034[(4)]))){
var statearr_39053_39066 = state_39034;
(statearr_39053_39066[(1)] = cljs.core.first((state_39034[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39067 = state_39034;
state_39034 = G__39067;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_39034){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_39034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_39054 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_39054[(6)] = c__2706__auto__);

return statearr_39054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_39111){
var state_val_39112 = (state_39111[(1)]);
if((state_val_39112 === (1))){
var state_39111__$1 = state_39111;
var statearr_39113_39127 = state_39111__$1;
(statearr_39113_39127[(2)] = null);

(statearr_39113_39127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39112 === (2))){
var _ = (function (){var statearr_39114 = state_39111;
(statearr_39114[(4)] = cljs.core.cons((5),(state_39111[(4)])));

return statearr_39114;
})();
var inst_39078 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39080 = ["_user/_auth"];
var inst_39081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39082 = ["*"];
var inst_39083 = (new cljs.core.PersistentVector(null,1,(5),inst_39081,inst_39082,null));
var inst_39084 = [inst_39083];
var inst_39085 = cljs.core.PersistentHashMap.fromArrays(inst_39080,inst_39084);
var inst_39086 = [inst_39085];
var inst_39087 = (new cljs.core.PersistentVector(null,1,(5),inst_39079,inst_39086,null));
var inst_39088 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39089 = cljs.core.PersistentHashMap.EMPTY;
var inst_39090 = [inst_39087,inst_39088,inst_39089];
var inst_39091 = cljs.core.PersistentHashMap.fromArrays(inst_39078,inst_39090);
var inst_39092 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39093 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_39092,inst_39091);
var state_39111__$1 = state_39111;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39111__$1,(6),inst_39093);
} else {
if((state_val_39112 === (3))){
var inst_39109 = (state_39111[(2)]);
var state_39111__$1 = state_39111;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39111__$1,inst_39109);
} else {
if((state_val_39112 === (4))){
var inst_39068 = (state_39111[(2)]);
var inst_39069 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_39068,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_39111__$1 = state_39111;
var statearr_39116_39128 = state_39111__$1;
(statearr_39116_39128[(2)] = inst_39069);

(statearr_39116_39128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39112 === (5))){
var _ = (function (){var statearr_39117 = state_39111;
(statearr_39117[(4)] = cljs.core.rest((state_39111[(4)])));

return statearr_39117;
})();
var state_39111__$1 = state_39111;
var ex39115 = (state_39111__$1[(2)]);
var statearr_39118_39129 = state_39111__$1;
(statearr_39118_39129[(5)] = ex39115);


var statearr_39119_39130 = state_39111__$1;
(statearr_39119_39130[(1)] = (4));

(statearr_39119_39130[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39112 === (6))){
var inst_39095 = (state_39111[(2)]);
var inst_39096 = fluree.db.util.async.throw_err(inst_39095);
var inst_39097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39096,(0),null);
var inst_39098 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39096,(1),null);
var inst_39099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39100 = ["_user/_auth","_id"];
var inst_39101 = (new cljs.core.PersistentVector(null,2,(5),inst_39099,inst_39100,null));
var inst_39102 = fluree.db.dbfunctions.internal.get_in(inst_39097,inst_39101);
var inst_39103 = cljs.core.first(inst_39102);
var inst_39104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39105 = [inst_39103,inst_39098];
var inst_39106 = (new cljs.core.PersistentVector(null,2,(5),inst_39104,inst_39105,null));
var _ = (function (){var statearr_39120 = state_39111;
(statearr_39120[(4)] = cljs.core.rest((state_39111[(4)])));

return statearr_39120;
})();
var state_39111__$1 = state_39111;
var statearr_39121_39131 = state_39111__$1;
(statearr_39121_39131[(2)] = inst_39106);

(statearr_39121_39131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0 = (function (){
var statearr_39122 = [null,null,null,null,null,null,null];
(statearr_39122[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__);

(statearr_39122[(1)] = (1));

return statearr_39122;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1 = (function (state_39111){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_39111);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e39123){var ex__2687__auto__ = e39123;
var statearr_39124_39132 = state_39111;
(statearr_39124_39132[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_39111[(4)]))){
var statearr_39125_39133 = state_39111;
(statearr_39125_39133[(1)] = cljs.core.first((state_39111[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39134 = state_39111;
state_39111 = G__39134;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__ = function(state_39111){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1.call(this,state_39111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_39126 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_39126[(6)] = c__2706__auto__);

return statearr_39126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_39156){
var state_val_39157 = (state_39156[(1)]);
if((state_val_39157 === (7))){
var inst_39141 = (state_39156[(7)]);
var inst_39145 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39146 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_39145,inst_39141);
var state_39156__$1 = state_39156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39156__$1,(9),inst_39146);
} else {
if((state_val_39157 === (1))){
var state_39156__$1 = state_39156;
var statearr_39158_39177 = state_39156__$1;
(statearr_39158_39177[(2)] = null);

(statearr_39158_39177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39157 === (4))){
var inst_39135 = (state_39156[(2)]);
var state_39156__$1 = state_39156;
var statearr_39159_39178 = state_39156__$1;
(statearr_39159_39178[(2)] = inst_39135);

(statearr_39159_39178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39157 === (6))){
var inst_39141 = (state_39156[(7)]);
var state_39156__$1 = state_39156;
var statearr_39160_39179 = state_39156__$1;
(statearr_39160_39179[(2)] = inst_39141);

(statearr_39160_39179[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39157 === (3))){
var inst_39154 = (state_39156[(2)]);
var state_39156__$1 = state_39156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39156__$1,inst_39154);
} else {
if((state_val_39157 === (2))){
var inst_39141 = (state_39156[(7)]);
var _ = (function (){var statearr_39162 = state_39156;
(statearr_39162[(4)] = cljs.core.cons((5),(state_39156[(4)])));

return statearr_39162;
})();
var inst_39141__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39142 = typeof inst_39141__$1 === 'number';
var state_39156__$1 = (function (){var statearr_39163 = state_39156;
(statearr_39163[(7)] = inst_39141__$1);

return statearr_39163;
})();
if(cljs.core.truth_(inst_39142)){
var statearr_39164_39180 = state_39156__$1;
(statearr_39164_39180[(1)] = (6));

} else {
var statearr_39165_39181 = state_39156__$1;
(statearr_39165_39181[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39157 === (9))){
var inst_39148 = (state_39156[(2)]);
var inst_39149 = fluree.db.util.async.throw_err(inst_39148);
var state_39156__$1 = state_39156;
var statearr_39166_39182 = state_39156__$1;
(statearr_39166_39182[(2)] = inst_39149);

(statearr_39166_39182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39157 === (5))){
var _ = (function (){var statearr_39167 = state_39156;
(statearr_39167[(4)] = cljs.core.rest((state_39156[(4)])));

return statearr_39167;
})();
var state_39156__$1 = state_39156;
var ex39161 = (state_39156__$1[(2)]);
var statearr_39168_39183 = state_39156__$1;
(statearr_39168_39183[(5)] = ex39161);


if((ex39161 instanceof Error)){
var statearr_39169_39184 = state_39156__$1;
(statearr_39169_39184[(1)] = (4));

(statearr_39169_39184[(5)] = null);

} else {
throw ex39161;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39157 === (8))){
var inst_39151 = (state_39156[(2)]);
var _ = (function (){var statearr_39170 = state_39156;
(statearr_39170[(4)] = cljs.core.rest((state_39156[(4)])));

return statearr_39170;
})();
var state_39156__$1 = state_39156;
var statearr_39171_39185 = state_39156__$1;
(statearr_39171_39185[(2)] = inst_39151);

(statearr_39171_39185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0 = (function (){
var statearr_39172 = [null,null,null,null,null,null,null,null];
(statearr_39172[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__);

(statearr_39172[(1)] = (1));

return statearr_39172;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1 = (function (state_39156){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_39156);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e39173){var ex__2687__auto__ = e39173;
var statearr_39174_39186 = state_39156;
(statearr_39174_39186[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_39156[(4)]))){
var statearr_39175_39187 = state_39156;
(statearr_39175_39187[(1)] = cljs.core.first((state_39156[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39188 = state_39156;
state_39156 = G__39188;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__ = function(state_39156){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1.call(this,state_39156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_39176 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_39176[(6)] = c__2706__auto__);

return statearr_39176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__39189_SHARP_){
return fluree.db.flake.op(p1__39189_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39190_SHARP_){
return fluree.db.flake.o(p1__39190_SHARP_);
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e39191){var e = e39191;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__39192_SHARP_){
return fluree.db.flake.op(p1__39192_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39193_SHARP_){
return fluree.db.flake.o(p1__39193_SHARP_);
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e39194){var e = e39194;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__39196 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__39196);
})() | (0));
return num;
}catch (e39195){var e = e39195;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_39276){
var state_val_39277 = (state_39276[(1)]);
if((state_val_39277 === (7))){
var inst_39215 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_39216 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39217 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39218 = cljs.core.PersistentHashMap.fromArrays(inst_39216,inst_39217);
var inst_39219 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39215,inst_39218);
var inst_39220 = (function(){throw inst_39219})();
var state_39276__$1 = state_39276;
var statearr_39278_39313 = state_39276__$1;
(statearr_39278_39313[(2)] = inst_39220);

(statearr_39278_39313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (1))){
var state_39276__$1 = state_39276;
var statearr_39279_39314 = state_39276__$1;
(statearr_39279_39314[(2)] = null);

(statearr_39279_39314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (4))){
var inst_39197 = (state_39276[(2)]);
var state_39276__$1 = state_39276;
var statearr_39280_39315 = state_39276__$1;
(statearr_39280_39315[(2)] = inst_39197);

(statearr_39280_39315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (15))){
var inst_39260 = (state_39276[(7)]);
var inst_39256 = (state_39276[(2)]);
var inst_39257 = fluree.db.util.async.throw_err(inst_39256);
var inst_39258 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39257,(0),null);
var inst_39259 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39257,(1),null);
var inst_39260__$1 = cljs.core.first(inst_39258);
var inst_39261 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39260__$1,compare_val);
var state_39276__$1 = (function (){var statearr_39281 = state_39276;
(statearr_39281[(7)] = inst_39260__$1);

(statearr_39281[(8)] = inst_39259);

return statearr_39281;
})();
if(inst_39261){
var statearr_39282_39316 = state_39276__$1;
(statearr_39282_39316[(1)] = (16));

} else {
var statearr_39283_39317 = state_39276__$1;
(statearr_39283_39317[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (13))){
var state_39276__$1 = state_39276;
var statearr_39284_39318 = state_39276__$1;
(statearr_39284_39318[(2)] = null);

(statearr_39284_39318[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (6))){
var state_39276__$1 = state_39276;
var statearr_39285_39319 = state_39276__$1;
(statearr_39285_39319[(2)] = null);

(statearr_39285_39319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (17))){
var inst_39260 = (state_39276[(7)]);
var inst_39264 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39260)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_39265 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39266 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39267 = cljs.core.PersistentHashMap.fromArrays(inst_39265,inst_39266);
var inst_39268 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39264,inst_39267);
var inst_39269 = (function(){throw inst_39268})();
var state_39276__$1 = state_39276;
var statearr_39286_39320 = state_39276__$1;
(statearr_39286_39320[(2)] = inst_39269);

(statearr_39286_39320[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (3))){
var inst_39274 = (state_39276[(2)]);
var state_39276__$1 = state_39276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39276__$1,inst_39274);
} else {
if((state_val_39277 === (12))){
var inst_39212 = (state_39276[(9)]);
var inst_39235 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_39212], 0));
var inst_39236 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39237 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39238 = cljs.core.PersistentHashMap.fromArrays(inst_39236,inst_39237);
var inst_39239 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39235,inst_39238);
var inst_39240 = (function(){throw inst_39239})();
var state_39276__$1 = state_39276;
var statearr_39287_39321 = state_39276__$1;
(statearr_39287_39321[(2)] = inst_39240);

(statearr_39287_39321[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (2))){
var inst_39211 = (state_39276[(10)]);
var inst_39209 = (state_39276[(11)]);
var inst_39210 = (state_39276[(12)]);
var _ = (function (){var statearr_39288 = state_39276;
(statearr_39288[(4)] = cljs.core.cons((5),(state_39276[(4)])));

return statearr_39288;
})();
var inst_39207 = _QMARK_ctx;
var inst_39208 = cljs.core.__destructure_map(inst_39207);
var inst_39209__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39208,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_39210__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39208,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_39211__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39208,new cljs.core.Keyword(null,"db","db",993250759));
var inst_39212 = fluree.db.dbproto._p_prop(inst_39211__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_39210__$1);
var state_39276__$1 = (function (){var statearr_39289 = state_39276;
(statearr_39289[(9)] = inst_39212);

(statearr_39289[(10)] = inst_39211__$1);

(statearr_39289[(11)] = inst_39209__$1);

(statearr_39289[(12)] = inst_39210__$1);

return statearr_39289;
})();
if(cljs.core.truth_(inst_39209__$1)){
var statearr_39290_39322 = state_39276__$1;
(statearr_39290_39322[(1)] = (6));

} else {
var statearr_39291_39323 = state_39276__$1;
(statearr_39291_39323[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (11))){
var inst_39211 = (state_39276[(10)]);
var inst_39210 = (state_39276[(12)]);
var inst_39232 = (state_39276[(2)]);
var inst_39233 = fluree.db.dbproto._p_prop(inst_39211,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_39210);
var state_39276__$1 = (function (){var statearr_39293 = state_39276;
(statearr_39293[(13)] = inst_39232);

return statearr_39293;
})();
if(cljs.core.truth_(inst_39233)){
var statearr_39294_39324 = state_39276__$1;
(statearr_39294_39324[(1)] = (12));

} else {
var statearr_39295_39325 = state_39276__$1;
(statearr_39295_39325[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (9))){
var state_39276__$1 = state_39276;
var statearr_39296_39326 = state_39276__$1;
(statearr_39296_39326[(2)] = null);

(statearr_39296_39326[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (5))){
var _ = (function (){var statearr_39297 = state_39276;
(statearr_39297[(4)] = cljs.core.rest((state_39276[(4)])));

return statearr_39297;
})();
var state_39276__$1 = state_39276;
var ex39292 = (state_39276__$1[(2)]);
var statearr_39298_39327 = state_39276__$1;
(statearr_39298_39327[(5)] = ex39292);


if((ex39292 instanceof Error)){
var statearr_39299_39328 = state_39276__$1;
(statearr_39299_39328[(1)] = (4));

(statearr_39299_39328[(5)] = null);

} else {
throw ex39292;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (14))){
var inst_39212 = (state_39276[(9)]);
var inst_39211 = (state_39276[(10)]);
var inst_39209 = (state_39276[(11)]);
var inst_39243 = (state_39276[(2)]);
var inst_39244 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39247 = [inst_39209,inst_39212,"?current-val"];
var inst_39248 = (new cljs.core.PersistentVector(null,3,(5),inst_39246,inst_39247,null));
var inst_39249 = [inst_39248];
var inst_39250 = (new cljs.core.PersistentVector(null,1,(5),inst_39245,inst_39249,null));
var inst_39251 = cljs.core.PersistentHashMap.EMPTY;
var inst_39252 = ["?current-val",inst_39250,inst_39251];
var inst_39253 = cljs.core.PersistentHashMap.fromArrays(inst_39244,inst_39252);
var inst_39254 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_39211,inst_39253);
var state_39276__$1 = (function (){var statearr_39300 = state_39276;
(statearr_39300[(14)] = inst_39243);

return statearr_39300;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39276__$1,(15),inst_39254);
} else {
if((state_val_39277 === (16))){
var state_39276__$1 = state_39276;
var statearr_39301_39329 = state_39276__$1;
(statearr_39301_39329[(2)] = new_val);

(statearr_39301_39329[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (10))){
var inst_39225 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_39226 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39227 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39228 = cljs.core.PersistentHashMap.fromArrays(inst_39226,inst_39227);
var inst_39229 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39225,inst_39228);
var inst_39230 = (function(){throw inst_39229})();
var state_39276__$1 = state_39276;
var statearr_39302_39330 = state_39276__$1;
(statearr_39302_39330[(2)] = inst_39230);

(statearr_39302_39330[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (18))){
var inst_39271 = (state_39276[(2)]);
var _ = (function (){var statearr_39303 = state_39276;
(statearr_39303[(4)] = cljs.core.rest((state_39276[(4)])));

return statearr_39303;
})();
var state_39276__$1 = state_39276;
var statearr_39304_39331 = state_39276__$1;
(statearr_39304_39331[(2)] = inst_39271);

(statearr_39304_39331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39277 === (8))){
var inst_39212 = (state_39276[(9)]);
var inst_39222 = (state_39276[(2)]);
var state_39276__$1 = (function (){var statearr_39305 = state_39276;
(statearr_39305[(15)] = inst_39222);

return statearr_39305;
})();
if(cljs.core.truth_(inst_39212)){
var statearr_39306_39332 = state_39276__$1;
(statearr_39306_39332[(1)] = (9));

} else {
var statearr_39307_39333 = state_39276__$1;
(statearr_39307_39333[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0 = (function (){
var statearr_39308 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39308[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__);

(statearr_39308[(1)] = (1));

return statearr_39308;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1 = (function (state_39276){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_39276);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e39309){var ex__2687__auto__ = e39309;
var statearr_39310_39334 = state_39276;
(statearr_39310_39334[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_39276[(4)]))){
var statearr_39311_39335 = state_39276;
(statearr_39311_39335[(1)] = cljs.core.first((state_39276[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39336 = state_39276;
state_39276 = G__39336;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__ = function(state_39276){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1.call(this,state_39276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_39312 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_39312[(6)] = c__2706__auto__);

return statearr_39312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
