// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18224 = arguments.length;
switch (G__18224) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,ledger){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,ledger,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,ledger,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18227 = arguments.length;
switch (G__18227) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___18280 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18258){
var state_val_18259 = (state_18258[(1)]);
if((state_val_18259 === (1))){
var state_18258__$1 = state_18258;
var statearr_18260_18281 = state_18258__$1;
(statearr_18260_18281[(2)] = null);

(statearr_18260_18281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18259 === (2))){
var _ = (function (){var statearr_18261 = state_18258;
(statearr_18261[(4)] = cljs.core.cons((5),(state_18258[(4)])));

return statearr_18261;
})();
var inst_18235 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_18258__$1 = state_18258;
if(cljs.core.truth_(inst_18235)){
var statearr_18262_18282 = state_18258__$1;
(statearr_18262_18282[(1)] = (6));

} else {
var statearr_18263_18283 = state_18258__$1;
(statearr_18263_18283[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18259 === (3))){
var inst_18256 = (state_18258[(2)]);
var state_18258__$1 = state_18258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18258__$1,inst_18256);
} else {
if((state_val_18259 === (4))){
var inst_18228 = (state_18258[(2)]);
var inst_18229 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_18228);
var state_18258__$1 = state_18258;
var statearr_18265_18284 = state_18258__$1;
(statearr_18265_18284[(2)] = inst_18229);

(statearr_18265_18284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18259 === (5))){
var _ = (function (){var statearr_18266 = state_18258;
(statearr_18266[(4)] = cljs.core.rest((state_18258[(4)])));

return statearr_18266;
})();
var state_18258__$1 = state_18258;
var ex18264 = (state_18258__$1[(2)]);
var statearr_18267_18285 = state_18258__$1;
(statearr_18267_18285[(5)] = ex18264);


var statearr_18268_18286 = state_18258__$1;
(statearr_18268_18286[(1)] = (4));

(statearr_18268_18286[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18259 === (6))){
var inst_18237 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18238 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18239 = cljs.core.PersistentHashMap.fromArrays(inst_18237,inst_18238);
var inst_18240 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_18239);
var inst_18241 = (function(){throw inst_18240})();
var state_18258__$1 = state_18258;
var statearr_18269_18287 = state_18258__$1;
(statearr_18269_18287[(2)] = inst_18241);

(statearr_18269_18287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18259 === (7))){
var inst_18243 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18245 = [operation,data,pc,opts];
var inst_18246 = (new cljs.core.PersistentVector(null,4,(5),inst_18244,inst_18245,null));
var inst_18247 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18243,inst_18246);
var inst_18248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18249 = [operation,data,pc,opts];
var inst_18250 = (new cljs.core.PersistentVector(null,4,(5),inst_18248,inst_18249,null));
var inst_18251 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Put operation on connection req-chan: ",inst_18250) : fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_18250));
var state_18258__$1 = (function (){var statearr_18270 = state_18258;
(statearr_18270[(7)] = inst_18247);

return statearr_18270;
})();
var statearr_18271_18288 = state_18258__$1;
(statearr_18271_18288[(2)] = inst_18251);

(statearr_18271_18288[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18259 === (8))){
var inst_18253 = (state_18258[(2)]);
var _ = (function (){var statearr_18272 = state_18258;
(statearr_18272[(4)] = cljs.core.rest((state_18258[(4)])));

return statearr_18272;
})();
var state_18258__$1 = state_18258;
var statearr_18273_18289 = state_18258__$1;
(statearr_18273_18289[(2)] = inst_18253);

(statearr_18273_18289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2684__auto__ = null;
var fluree$db$operations$state_machine__2684__auto____0 = (function (){
var statearr_18274 = [null,null,null,null,null,null,null,null];
(statearr_18274[(0)] = fluree$db$operations$state_machine__2684__auto__);

(statearr_18274[(1)] = (1));

return statearr_18274;
});
var fluree$db$operations$state_machine__2684__auto____1 = (function (state_18258){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18258);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18275){var ex__2687__auto__ = e18275;
var statearr_18276_18290 = state_18258;
(statearr_18276_18290[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18258[(4)]))){
var statearr_18277_18291 = state_18258;
(statearr_18277_18291[(1)] = cljs.core.first((state_18258[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18292 = state_18258;
state_18258 = G__18292;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2684__auto__ = function(state_18258){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2684__auto____1.call(this,state_18258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2684__auto____0;
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2684__auto____1;
return fluree$db$operations$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18278 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18278[(6)] = c__2706__auto___18280);

return statearr_18278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18294 = arguments.length;
switch (G__18294) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18295){
var map__18296 = p__18295;
var map__18296__$1 = cljs.core.__destructure_map(map__18296);
var opts = map__18296__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18296__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18297 = session;
var map__18297__$1 = cljs.core.__destructure_map(map__18297);
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18297__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18297__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18297__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5775__auto__ = [];
var len__5769__auto___18324 = arguments.length;
var i__5770__auto___18325 = (0);
while(true){
if((i__5770__auto___18325 < len__5769__auto___18324)){
args__5775__auto__.push((arguments[i__5770__auto___18325]));

var G__18326 = (i__5770__auto___18325 + (1));
i__5770__auto___18325 = G__18326;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18301){
var vec__18302 = p__18301;
var map__18305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18302,(0),null);
var map__18305__$1 = cljs.core.__destructure_map(map__18305);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18305__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18305__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18302;
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18317){
var state_val_18318 = (state_18317[(1)]);
if((state_val_18318 === (1))){
var inst_18307 = session;
var inst_18308 = cljs.core.__destructure_map(inst_18307);
var inst_18309 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18308,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18310 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18308,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_18311 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18308,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18312 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18313 = [inst_18309,inst_18310,toBlock,toTime];
var inst_18314 = cljs.core.PersistentHashMap.fromArrays(inst_18312,inst_18313);
var inst_18315 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_18311,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18314);
var state_18317__$1 = state_18317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18317__$1,inst_18315);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2684__auto__ = null;
var fluree$db$operations$state_machine__2684__auto____0 = (function (){
var statearr_18319 = [null,null,null,null,null,null,null];
(statearr_18319[(0)] = fluree$db$operations$state_machine__2684__auto__);

(statearr_18319[(1)] = (1));

return statearr_18319;
});
var fluree$db$operations$state_machine__2684__auto____1 = (function (state_18317){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18317);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18320){var ex__2687__auto__ = e18320;
var statearr_18321_18327 = state_18317;
(statearr_18321_18327[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18317[(4)]))){
var statearr_18322_18328 = state_18317;
(statearr_18322_18328[(1)] = cljs.core.first((state_18317[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18329 = state_18317;
state_18317 = G__18329;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2684__auto__ = function(state_18317){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2684__auto____1.call(this,state_18317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2684__auto____0;
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2684__auto____1;
return fluree$db$operations$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18323 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18323[(6)] = c__2706__auto__);

return statearr_18323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18299){
var G__18300 = cljs.core.first(seq18299);
var seq18299__$1 = cljs.core.next(seq18299);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18300,seq18299__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18330 = session;
var map__18330__$1 = cljs.core.__destructure_map(map__18330);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18330__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Sending transaction async: ",tx_map) : fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18332 = arguments.length;
switch (G__18332) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18333 = opts;
var map__18333__$1 = cljs.core.__destructure_map(map__18333);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18333__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18333__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = (function (){var G__18334 = "Subscribe to: ";
var G__18335 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var G__18336 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var G__18337 = auth_or_jwt;
return (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4(G__18334,G__18335,G__18336,G__18337) : fluree.db.util.log.trace.call(null,G__18334,G__18335,G__18336,G__18337));
})();
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsubscribe","unsubscribe",632650147),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null));
});
