// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_17190 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_17190(s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_17191 = (function (s,d){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__5394__auto__.call(null,s,d));
} else {
var m__5392__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__5392__auto__.call(null,s,d));
} else {
throw cljs.core.missing_protocol("Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_17191(s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_17192 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_17192(s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_17193 = (function (s,k,data){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__5394__auto__.call(null,s,k,data));
} else {
var m__5392__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__5392__auto__.call(null,s,k,data));
} else {
throw cljs.core.missing_protocol("Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_17193(s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_17194 = (function (s,old_key,new_key){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__5394__auto__.call(null,s,old_key,new_key));
} else {
var m__5392__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__5392__auto__.call(null,s,old_key,new_key));
} else {
throw cljs.core.missing_protocol("Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_17194(s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_17195 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_17195(s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix(network,ldgr_id);
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17217){
var state_val_17218 = (state_17217[(1)]);
if((state_val_17218 === (7))){
var inst_17206 = (state_17217[(7)]);
var inst_17208 = fluree.db.storage.core.serde(conn);
var inst_17209 = fluree.db.serde.protocol._deserialize_block(inst_17208,inst_17206);
var state_17217__$1 = state_17217;
var statearr_17219_17238 = state_17217__$1;
(statearr_17219_17238[(2)] = inst_17209);

(statearr_17219_17238[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17218 === (1))){
var state_17217__$1 = state_17217;
var statearr_17220_17239 = state_17217__$1;
(statearr_17220_17239[(2)] = null);

(statearr_17220_17239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17218 === (4))){
var inst_17196 = (state_17217[(2)]);
var state_17217__$1 = state_17217;
var statearr_17221_17240 = state_17217__$1;
(statearr_17221_17240[(2)] = inst_17196);

(statearr_17221_17240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17218 === (6))){
var inst_17206 = (state_17217[(7)]);
var inst_17205 = (state_17217[(2)]);
var inst_17206__$1 = fluree.db.util.async.throw_err(inst_17205);
var state_17217__$1 = (function (){var statearr_17222 = state_17217;
(statearr_17222[(7)] = inst_17206__$1);

return statearr_17222;
})();
if(cljs.core.truth_(inst_17206__$1)){
var statearr_17223_17241 = state_17217__$1;
(statearr_17223_17241[(1)] = (7));

} else {
var statearr_17224_17242 = state_17217__$1;
(statearr_17224_17242[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17218 === (3))){
var inst_17215 = (state_17217[(2)]);
var state_17217__$1 = state_17217;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17217__$1,inst_17215);
} else {
if((state_val_17218 === (2))){
var _ = (function (){var statearr_17226 = state_17217;
(statearr_17226[(4)] = cljs.core.cons((5),(state_17217[(4)])));

return statearr_17226;
})();
var inst_17202 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17203 = fluree.db.storage.core.read(conn,inst_17202);
var state_17217__$1 = state_17217;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17217__$1,(6),inst_17203);
} else {
if((state_val_17218 === (9))){
var inst_17212 = (state_17217[(2)]);
var _ = (function (){var statearr_17227 = state_17217;
(statearr_17227[(4)] = cljs.core.rest((state_17217[(4)])));

return statearr_17227;
})();
var state_17217__$1 = state_17217;
var statearr_17228_17243 = state_17217__$1;
(statearr_17228_17243[(2)] = inst_17212);

(statearr_17228_17243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17218 === (5))){
var _ = (function (){var statearr_17229 = state_17217;
(statearr_17229[(4)] = cljs.core.rest((state_17217[(4)])));

return statearr_17229;
})();
var state_17217__$1 = state_17217;
var ex17225 = (state_17217__$1[(2)]);
var statearr_17230_17244 = state_17217__$1;
(statearr_17230_17244[(5)] = ex17225);


if((ex17225 instanceof Error)){
var statearr_17231_17245 = state_17217__$1;
(statearr_17231_17245[(1)] = (4));

(statearr_17231_17245[(5)] = null);

} else {
throw ex17225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17218 === (8))){
var state_17217__$1 = state_17217;
var statearr_17232_17246 = state_17217__$1;
(statearr_17232_17246[(2)] = null);

(statearr_17232_17246[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2684__auto____0 = (function (){
var statearr_17233 = [null,null,null,null,null,null,null,null];
(statearr_17233[(0)] = fluree$db$storage$core$read_block_$_state_machine__2684__auto__);

(statearr_17233[(1)] = (1));

return statearr_17233;
});
var fluree$db$storage$core$read_block_$_state_machine__2684__auto____1 = (function (state_17217){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17217);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17234){var ex__2687__auto__ = e17234;
var statearr_17235_17247 = state_17217;
(statearr_17235_17247[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17217[(4)]))){
var statearr_17236_17248 = state_17217;
(statearr_17236_17248[(1)] = cljs.core.first((state_17217[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17249 = state_17217;
state_17217 = G__17249;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2684__auto__ = function(state_17217){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2684__auto____1.call(this,state_17217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17237 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17237[(6)] = c__2706__auto__);

return statearr_17237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17272){
var state_val_17273 = (state_17272[(1)]);
if((state_val_17273 === (7))){
var inst_17261 = (state_17272[(7)]);
var inst_17263 = fluree.db.storage.core.serde(conn);
var inst_17264 = fluree.db.serde.protocol._deserialize_block(inst_17263,inst_17261);
var state_17272__$1 = state_17272;
var statearr_17274_17293 = state_17272__$1;
(statearr_17274_17293[(2)] = inst_17264);

(statearr_17274_17293[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (1))){
var state_17272__$1 = state_17272;
var statearr_17275_17294 = state_17272__$1;
(statearr_17275_17294[(2)] = null);

(statearr_17275_17294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (4))){
var inst_17250 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
var statearr_17276_17295 = state_17272__$1;
(statearr_17276_17295[(2)] = inst_17250);

(statearr_17276_17295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (6))){
var inst_17261 = (state_17272[(7)]);
var inst_17260 = (state_17272[(2)]);
var inst_17261__$1 = fluree.db.util.async.throw_err(inst_17260);
var state_17272__$1 = (function (){var statearr_17277 = state_17272;
(statearr_17277[(7)] = inst_17261__$1);

return statearr_17277;
})();
if(cljs.core.truth_(inst_17261__$1)){
var statearr_17278_17296 = state_17272__$1;
(statearr_17278_17296[(1)] = (7));

} else {
var statearr_17279_17297 = state_17272__$1;
(statearr_17279_17297[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (3))){
var inst_17270 = (state_17272[(2)]);
var state_17272__$1 = state_17272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17272__$1,inst_17270);
} else {
if((state_val_17273 === (2))){
var _ = (function (){var statearr_17281 = state_17272;
(statearr_17281[(4)] = cljs.core.cons((5),(state_17272[(4)])));

return statearr_17281;
})();
var inst_17256 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17257 = [inst_17256,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17258 = fluree.db.storage.core.read(conn,inst_17257);
var state_17272__$1 = state_17272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17272__$1,(6),inst_17258);
} else {
if((state_val_17273 === (9))){
var inst_17267 = (state_17272[(2)]);
var _ = (function (){var statearr_17282 = state_17272;
(statearr_17282[(4)] = cljs.core.rest((state_17272[(4)])));

return statearr_17282;
})();
var state_17272__$1 = state_17272;
var statearr_17283_17298 = state_17272__$1;
(statearr_17283_17298[(2)] = inst_17267);

(statearr_17283_17298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (5))){
var _ = (function (){var statearr_17284 = state_17272;
(statearr_17284[(4)] = cljs.core.rest((state_17272[(4)])));

return statearr_17284;
})();
var state_17272__$1 = state_17272;
var ex17280 = (state_17272__$1[(2)]);
var statearr_17285_17299 = state_17272__$1;
(statearr_17285_17299[(5)] = ex17280);


if((ex17280 instanceof Error)){
var statearr_17286_17300 = state_17272__$1;
(statearr_17286_17300[(1)] = (4));

(statearr_17286_17300[(5)] = null);

} else {
throw ex17280;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17273 === (8))){
var state_17272__$1 = state_17272;
var statearr_17287_17301 = state_17272__$1;
(statearr_17287_17301[(2)] = null);

(statearr_17287_17301[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0 = (function (){
var statearr_17288 = [null,null,null,null,null,null,null,null];
(statearr_17288[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__);

(statearr_17288[(1)] = (1));

return statearr_17288;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1 = (function (state_17272){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17272);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17289){var ex__2687__auto__ = e17289;
var statearr_17290_17302 = state_17272;
(statearr_17290_17302[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17272[(4)]))){
var statearr_17291_17303 = state_17272;
(statearr_17291_17303[(1)] = cljs.core.first((state_17272[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17304 = state_17272;
state_17272 = G__17304;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__ = function(state_17272){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1.call(this,state_17272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17292 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17292[(6)] = c__2706__auto__);

return statearr_17292;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17328){
var state_val_17329 = (state_17328[(1)]);
if((state_val_17329 === (1))){
var state_17328__$1 = state_17328;
var statearr_17330_17344 = state_17328__$1;
(statearr_17330_17344[(2)] = null);

(statearr_17330_17344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17329 === (2))){
var _ = (function (){var statearr_17331 = state_17328;
(statearr_17331[(4)] = cljs.core.cons((5),(state_17328[(4)])));

return statearr_17331;
})();
var inst_17311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17312 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17313 = (new cljs.core.PersistentVector(null,3,(5),inst_17311,inst_17312,null));
var inst_17314 = cljs.core.select_keys(block_data,inst_17313);
var inst_17315 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17314);
var inst_17316 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_17315);
var inst_17317 = [inst_17316,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17318 = fluree.db.storage.core.serde(conn);
var inst_17319 = fluree.db.serde.protocol._serialize_block(inst_17318,inst_17314);
var inst_17320 = fluree.db.storage.core.write(conn,inst_17317,inst_17319);
var state_17328__$1 = state_17328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17328__$1,(6),inst_17320);
} else {
if((state_val_17329 === (3))){
var inst_17326 = (state_17328[(2)]);
var state_17328__$1 = state_17328;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17328__$1,inst_17326);
} else {
if((state_val_17329 === (4))){
var inst_17305 = (state_17328[(2)]);
var state_17328__$1 = state_17328;
var statearr_17333_17345 = state_17328__$1;
(statearr_17333_17345[(2)] = inst_17305);

(statearr_17333_17345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17329 === (5))){
var _ = (function (){var statearr_17334 = state_17328;
(statearr_17334[(4)] = cljs.core.rest((state_17328[(4)])));

return statearr_17334;
})();
var state_17328__$1 = state_17328;
var ex17332 = (state_17328__$1[(2)]);
var statearr_17335_17346 = state_17328__$1;
(statearr_17335_17346[(5)] = ex17332);


if((ex17332 instanceof Error)){
var statearr_17336_17347 = state_17328__$1;
(statearr_17336_17347[(1)] = (4));

(statearr_17336_17347[(5)] = null);

} else {
throw ex17332;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17329 === (6))){
var inst_17322 = (state_17328[(2)]);
var inst_17323 = fluree.db.util.async.throw_err(inst_17322);
var _ = (function (){var statearr_17337 = state_17328;
(statearr_17337[(4)] = cljs.core.rest((state_17328[(4)])));

return statearr_17337;
})();
var state_17328__$1 = state_17328;
var statearr_17338_17348 = state_17328__$1;
(statearr_17338_17348[(2)] = inst_17323);

(statearr_17338_17348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0 = (function (){
var statearr_17339 = [null,null,null,null,null,null,null];
(statearr_17339[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__);

(statearr_17339[(1)] = (1));

return statearr_17339;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1 = (function (state_17328){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17328);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17340){var ex__2687__auto__ = e17340;
var statearr_17341_17349 = state_17328;
(statearr_17341_17349[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17328[(4)]))){
var statearr_17342_17350 = state_17328;
(statearr_17342_17350[(1)] = cljs.core.first((state_17328[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17351 = state_17328;
state_17328 = G__17351;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__ = function(state_17328){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1.call(this,state_17328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17343 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17343[(6)] = c__2706__auto__);

return statearr_17343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17374){
var state_val_17375 = (state_17374[(1)]);
if((state_val_17375 === (1))){
var state_17374__$1 = state_17374;
var statearr_17376_17390 = state_17374__$1;
(statearr_17376_17390[(2)] = null);

(statearr_17376_17390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (2))){
var _ = (function (){var statearr_17377 = state_17374;
(statearr_17377[(4)] = cljs.core.cons((5),(state_17374[(4)])));

return statearr_17377;
})();
var inst_17358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17359 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17360 = (new cljs.core.PersistentVector(null,3,(5),inst_17358,inst_17359,null));
var inst_17361 = cljs.core.select_keys(block_data,inst_17360);
var inst_17362 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17361);
var inst_17363 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_17362);
var inst_17364 = fluree.db.storage.core.serde(conn);
var inst_17365 = fluree.db.serde.protocol._serialize_block(inst_17364,inst_17361);
var inst_17366 = fluree.db.storage.core.write(conn,inst_17363,inst_17365);
var state_17374__$1 = state_17374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17374__$1,(6),inst_17366);
} else {
if((state_val_17375 === (3))){
var inst_17372 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17374__$1,inst_17372);
} else {
if((state_val_17375 === (4))){
var inst_17352 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
var statearr_17379_17391 = state_17374__$1;
(statearr_17379_17391[(2)] = inst_17352);

(statearr_17379_17391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (5))){
var _ = (function (){var statearr_17380 = state_17374;
(statearr_17380[(4)] = cljs.core.rest((state_17374[(4)])));

return statearr_17380;
})();
var state_17374__$1 = state_17374;
var ex17378 = (state_17374__$1[(2)]);
var statearr_17381_17392 = state_17374__$1;
(statearr_17381_17392[(5)] = ex17378);


if((ex17378 instanceof Error)){
var statearr_17382_17393 = state_17374__$1;
(statearr_17382_17393[(1)] = (4));

(statearr_17382_17393[(5)] = null);

} else {
throw ex17378;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (6))){
var inst_17368 = (state_17374[(2)]);
var inst_17369 = fluree.db.util.async.throw_err(inst_17368);
var _ = (function (){var statearr_17383 = state_17374;
(statearr_17383[(4)] = cljs.core.rest((state_17374[(4)])));

return statearr_17383;
})();
var state_17374__$1 = state_17374;
var statearr_17384_17394 = state_17374__$1;
(statearr_17384_17394[(2)] = inst_17369);

(statearr_17384_17394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2684__auto____0 = (function (){
var statearr_17385 = [null,null,null,null,null,null,null];
(statearr_17385[(0)] = fluree$db$storage$core$write_block_$_state_machine__2684__auto__);

(statearr_17385[(1)] = (1));

return statearr_17385;
});
var fluree$db$storage$core$write_block_$_state_machine__2684__auto____1 = (function (state_17374){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17374);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17386){var ex__2687__auto__ = e17386;
var statearr_17387_17395 = state_17374;
(statearr_17387_17395[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17374[(4)]))){
var statearr_17388_17396 = state_17374;
(statearr_17388_17396[(1)] = cljs.core.first((state_17374[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17397 = state_17374;
state_17374 = G__17397;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2684__auto__ = function(state_17374){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2684__auto____1.call(this,state_17374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17389 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17389[(6)] = c__2706__auto__);

return statearr_17389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__17399 = arguments.length;
switch (G__17399) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__17400){
var map__17401 = p__17400;
var map__17401__$1 = cljs.core.__destructure_map(map__17401);
var leaf = map__17401__$1;
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17401__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17422){
var state_val_17423 = (state_17422[(1)]);
if((state_val_17423 === (1))){
var state_17422__$1 = state_17422;
var statearr_17424_17440 = state_17422__$1;
(statearr_17424_17440[(2)] = null);

(statearr_17424_17440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17423 === (2))){
var _ = (function (){var statearr_17425 = state_17422;
(statearr_17425[(4)] = cljs.core.cons((5),(state_17422[(4)])));

return statearr_17425;
})();
var inst_17408 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17409 = [flakes];
var inst_17410 = cljs.core.PersistentHashMap.fromArrays(inst_17408,inst_17409);
var inst_17411 = fluree.db.storage.core.serde(conn);
var inst_17412 = fluree.db.serde.protocol._serialize_leaf(inst_17411,inst_17410);
var inst_17413 = fluree.db.storage.core.write(conn,leaf_id,inst_17412);
var state_17422__$1 = state_17422;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17422__$1,(6),inst_17413);
} else {
if((state_val_17423 === (3))){
var inst_17420 = (state_17422[(2)]);
var state_17422__$1 = state_17422;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17422__$1,inst_17420);
} else {
if((state_val_17423 === (4))){
var inst_17402 = (state_17422[(2)]);
var state_17422__$1 = state_17422;
var statearr_17427_17441 = state_17422__$1;
(statearr_17427_17441[(2)] = inst_17402);

(statearr_17427_17441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17423 === (5))){
var _ = (function (){var statearr_17428 = state_17422;
(statearr_17428[(4)] = cljs.core.rest((state_17422[(4)])));

return statearr_17428;
})();
var state_17422__$1 = state_17422;
var ex17426 = (state_17422__$1[(2)]);
var statearr_17429_17442 = state_17422__$1;
(statearr_17429_17442[(5)] = ex17426);


if((ex17426 instanceof Error)){
var statearr_17430_17443 = state_17422__$1;
(statearr_17430_17443[(1)] = (4));

(statearr_17430_17443[(5)] = null);

} else {
throw ex17426;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17423 === (6))){
var inst_17415 = (state_17422[(2)]);
var inst_17416 = fluree.db.util.async.throw_err(inst_17415);
var inst_17417 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_17431 = state_17422;
(statearr_17431[(4)] = cljs.core.rest((state_17422[(4)])));

return statearr_17431;
})();
var state_17422__$1 = (function (){var statearr_17432 = state_17422;
(statearr_17432[(7)] = inst_17416);

return statearr_17432;
})();
var statearr_17433_17444 = state_17422__$1;
(statearr_17433_17444[(2)] = inst_17417);

(statearr_17433_17444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_17434 = [null,null,null,null,null,null,null,null];
(statearr_17434[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_17434[(1)] = (1));

return statearr_17434;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_17422){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17422);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17435){var ex__2687__auto__ = e17435;
var statearr_17436_17445 = state_17422;
(statearr_17436_17445[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17422[(4)]))){
var statearr_17437_17446 = state_17422;
(statearr_17437_17446[(1)] = cljs.core.first((state_17422[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17447 = state_17422;
state_17422 = G__17447;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_17422){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_17422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17438 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17438[(6)] = c__2706__auto__);

return statearr_17438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17464){
var state_val_17465 = (state_17464[(1)]);
if((state_val_17465 === (1))){
var state_17464__$1 = state_17464;
var statearr_17466_17481 = state_17464__$1;
(statearr_17466_17481[(2)] = null);

(statearr_17466_17481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17465 === (2))){
var _ = (function (){var statearr_17467 = state_17464;
(statearr_17467[(4)] = cljs.core.cons((5),(state_17464[(4)])));

return statearr_17467;
})();
var inst_17454 = fluree.db.storage.core.serde(conn);
var inst_17455 = fluree.db.serde.protocol._serialize_branch(inst_17454,data);
var inst_17456 = fluree.db.storage.core.write(conn,key,inst_17455);
var state_17464__$1 = state_17464;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17464__$1,(6),inst_17456);
} else {
if((state_val_17465 === (3))){
var inst_17462 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17464__$1,inst_17462);
} else {
if((state_val_17465 === (4))){
var inst_17448 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
var statearr_17469_17482 = state_17464__$1;
(statearr_17469_17482[(2)] = inst_17448);

(statearr_17469_17482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17465 === (5))){
var _ = (function (){var statearr_17470 = state_17464;
(statearr_17470[(4)] = cljs.core.rest((state_17464[(4)])));

return statearr_17470;
})();
var state_17464__$1 = state_17464;
var ex17468 = (state_17464__$1[(2)]);
var statearr_17471_17483 = state_17464__$1;
(statearr_17471_17483[(5)] = ex17468);


if((ex17468 instanceof Error)){
var statearr_17472_17484 = state_17464__$1;
(statearr_17472_17484[(1)] = (4));

(statearr_17472_17484[(5)] = null);

} else {
throw ex17468;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17465 === (6))){
var inst_17458 = (state_17464[(2)]);
var inst_17459 = fluree.db.util.async.throw_err(inst_17458);
var _ = (function (){var statearr_17473 = state_17464;
(statearr_17473[(4)] = cljs.core.rest((state_17464[(4)])));

return statearr_17473;
})();
var state_17464__$1 = (function (){var statearr_17474 = state_17464;
(statearr_17474[(7)] = inst_17459);

return statearr_17474;
})();
var statearr_17475_17485 = state_17464__$1;
(statearr_17475_17485[(2)] = key);

(statearr_17475_17485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0 = (function (){
var statearr_17476 = [null,null,null,null,null,null,null,null];
(statearr_17476[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__);

(statearr_17476[(1)] = (1));

return statearr_17476;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1 = (function (state_17464){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17464);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17477){var ex__2687__auto__ = e17477;
var statearr_17478_17486 = state_17464;
(statearr_17478_17486[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17464[(4)]))){
var statearr_17479_17487 = state_17464;
(statearr_17479_17487[(1)] = cljs.core.first((state_17464[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17488 = state_17464;
state_17464 = G__17488;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__ = function(state_17464){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1.call(this,state_17464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17480 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17480[(6)] = c__2706__auto__);

return statearr_17480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__17490 = arguments.length;
switch (G__17490) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__17491){
var map__17492 = p__17491;
var map__17492__$1 = cljs.core.__destructure_map(map__17492);
var branch = map__17492__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17492__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17518){
var state_val_17519 = (state_17518[(1)]);
if((state_val_17519 === (1))){
var state_17518__$1 = state_17518;
var statearr_17520_17537 = state_17518__$1;
(statearr_17520_17537[(2)] = null);

(statearr_17520_17537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17519 === (2))){
var _ = (function (){var statearr_17521 = state_17518;
(statearr_17521[(4)] = cljs.core.cons((5),(state_17518[(4)])));

return statearr_17521;
})();
var inst_17499 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.val,children);
var inst_17500 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.storage.core.child_data,inst_17499);
var inst_17501 = cljs.core.first(inst_17500);
var inst_17502 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_17501);
var inst_17503 = cljs.core.rseq(inst_17500);
var inst_17504 = cljs.core.first(inst_17503);
var inst_17505 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_17504);
var inst_17506 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_17507 = [inst_17500];
var inst_17508 = cljs.core.PersistentHashMap.fromArrays(inst_17506,inst_17507);
var inst_17509 = fluree.db.storage.core.write_branch_data(conn,branch_id,inst_17508);
var state_17518__$1 = (function (){var statearr_17522 = state_17518;
(statearr_17522[(7)] = inst_17505);

(statearr_17522[(8)] = inst_17502);

return statearr_17522;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17518__$1,(6),inst_17509);
} else {
if((state_val_17519 === (3))){
var inst_17516 = (state_17518[(2)]);
var state_17518__$1 = state_17518;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17518__$1,inst_17516);
} else {
if((state_val_17519 === (4))){
var inst_17493 = (state_17518[(2)]);
var state_17518__$1 = state_17518;
var statearr_17524_17538 = state_17518__$1;
(statearr_17524_17538[(2)] = inst_17493);

(statearr_17524_17538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17519 === (5))){
var _ = (function (){var statearr_17525 = state_17518;
(statearr_17525[(4)] = cljs.core.rest((state_17518[(4)])));

return statearr_17525;
})();
var state_17518__$1 = state_17518;
var ex17523 = (state_17518__$1[(2)]);
var statearr_17526_17539 = state_17518__$1;
(statearr_17526_17539[(5)] = ex17523);


if((ex17523 instanceof Error)){
var statearr_17527_17540 = state_17518__$1;
(statearr_17527_17540[(1)] = (4));

(statearr_17527_17540[(5)] = null);

} else {
throw ex17523;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17519 === (6))){
var inst_17511 = (state_17518[(2)]);
var inst_17512 = fluree.db.util.async.throw_err(inst_17511);
var inst_17513 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_17528 = state_17518;
(statearr_17528[(4)] = cljs.core.rest((state_17518[(4)])));

return statearr_17528;
})();
var state_17518__$1 = (function (){var statearr_17529 = state_17518;
(statearr_17529[(9)] = inst_17512);

return statearr_17529;
})();
var statearr_17530_17541 = state_17518__$1;
(statearr_17530_17541[(2)] = inst_17513);

(statearr_17530_17541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_17531 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17531[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_17531[(1)] = (1));

return statearr_17531;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_17518){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17518);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17532){var ex__2687__auto__ = e17532;
var statearr_17533_17542 = state_17518;
(statearr_17533_17542[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17518[(4)]))){
var statearr_17534_17543 = state_17518;
(statearr_17534_17543[(1)] = cljs.core.first((state_17518[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17544 = state_17518;
state_17518 = G__17544;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_17518){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_17518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17535 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17535[(6)] = c__2706__auto__);

return statearr_17535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17572){
var state_val_17573 = (state_17572[(1)]);
if((state_val_17573 === (1))){
var state_17572__$1 = state_17572;
var statearr_17574_17590 = state_17572__$1;
(statearr_17574_17590[(2)] = null);

(statearr_17574_17590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17573 === (2))){
var inst_17558 = (state_17572[(7)]);
var _ = (function (){var statearr_17575 = state_17572;
(statearr_17575[(4)] = cljs.core.cons((5),(state_17572[(4)])));

return statearr_17575;
})();
var inst_17552 = db;
var inst_17553 = cljs.core.__destructure_map(inst_17552);
var inst_17554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17553,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17555 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17553,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17553,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17557 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17553,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17558__$1 = fluree.db.storage.core.ledger_garbage_key(inst_17555,inst_17556,inst_17557);
var inst_17559 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17560 = [inst_17556,inst_17557,garbage];
var inst_17561 = cljs.core.PersistentHashMap.fromArrays(inst_17559,inst_17560);
var inst_17562 = fluree.db.storage.core.serde(inst_17554);
var inst_17563 = fluree.db.serde.protocol._serialize_garbage(inst_17562,inst_17561);
var inst_17564 = fluree.db.storage.core.write(inst_17554,inst_17558__$1,inst_17563);
var state_17572__$1 = (function (){var statearr_17576 = state_17572;
(statearr_17576[(7)] = inst_17558__$1);

return statearr_17576;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17572__$1,(6),inst_17564);
} else {
if((state_val_17573 === (3))){
var inst_17570 = (state_17572[(2)]);
var state_17572__$1 = state_17572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17572__$1,inst_17570);
} else {
if((state_val_17573 === (4))){
var inst_17545 = (state_17572[(2)]);
var state_17572__$1 = state_17572;
var statearr_17578_17591 = state_17572__$1;
(statearr_17578_17591[(2)] = inst_17545);

(statearr_17578_17591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17573 === (5))){
var _ = (function (){var statearr_17579 = state_17572;
(statearr_17579[(4)] = cljs.core.rest((state_17572[(4)])));

return statearr_17579;
})();
var state_17572__$1 = state_17572;
var ex17577 = (state_17572__$1[(2)]);
var statearr_17580_17592 = state_17572__$1;
(statearr_17580_17592[(5)] = ex17577);


if((ex17577 instanceof Error)){
var statearr_17581_17593 = state_17572__$1;
(statearr_17581_17593[(1)] = (4));

(statearr_17581_17593[(5)] = null);

} else {
throw ex17577;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17573 === (6))){
var inst_17558 = (state_17572[(7)]);
var inst_17566 = (state_17572[(2)]);
var inst_17567 = fluree.db.util.async.throw_err(inst_17566);
var _ = (function (){var statearr_17582 = state_17572;
(statearr_17582[(4)] = cljs.core.rest((state_17572[(4)])));

return statearr_17582;
})();
var state_17572__$1 = (function (){var statearr_17583 = state_17572;
(statearr_17583[(8)] = inst_17567);

return statearr_17583;
})();
var statearr_17584_17594 = state_17572__$1;
(statearr_17584_17594[(2)] = inst_17558);

(statearr_17584_17594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0 = (function (){
var statearr_17585 = [null,null,null,null,null,null,null,null,null];
(statearr_17585[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__);

(statearr_17585[(1)] = (1));

return statearr_17585;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1 = (function (state_17572){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17572);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17586){var ex__2687__auto__ = e17586;
var statearr_17587_17595 = state_17572;
(statearr_17587_17595[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17572[(4)]))){
var statearr_17588_17596 = state_17572;
(statearr_17588_17596[(1)] = cljs.core.first((state_17572[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17597 = state_17572;
state_17572 = G__17597;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__ = function(state_17572){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1.call(this,state_17572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17589 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17589[(6)] = c__2706__auto__);

return statearr_17589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17599 = arguments.length;
switch (G__17599) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17657){
var state_val_17658 = (state_17657[(1)]);
if((state_val_17658 === (7))){
var state_17657__$1 = state_17657;
var statearr_17659_17685 = state_17657__$1;
(statearr_17659_17685[(2)] = (0));

(statearr_17659_17685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (1))){
var state_17657__$1 = state_17657;
var statearr_17660_17686 = state_17657__$1;
(statearr_17660_17686[(2)] = null);

(statearr_17660_17686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (4))){
var inst_17600 = (state_17657[(2)]);
var state_17657__$1 = state_17657;
var statearr_17661_17687 = state_17657__$1;
(statearr_17661_17687[(2)] = inst_17600);

(statearr_17661_17687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (6))){
var inst_17626 = (state_17657[(7)]);
var state_17657__$1 = state_17657;
var statearr_17662_17688 = state_17657__$1;
(statearr_17662_17688[(2)] = inst_17626);

(statearr_17662_17688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (3))){
var inst_17655 = (state_17657[(2)]);
var state_17657__$1 = state_17657;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17657__$1,inst_17655);
} else {
if((state_val_17658 === (12))){
var inst_17623 = (state_17657[(8)]);
var inst_17651 = (state_17657[(2)]);
var inst_17652 = fluree.db.util.async.throw_err(inst_17651);
var _ = (function (){var statearr_17663 = state_17657;
(statearr_17663[(4)] = cljs.core.rest((state_17657[(4)])));

return statearr_17663;
})();
var state_17657__$1 = (function (){var statearr_17664 = state_17657;
(statearr_17664[(9)] = inst_17652);

return statearr_17664;
})();
var statearr_17665_17689 = state_17657__$1;
(statearr_17665_17689[(2)] = inst_17623);

(statearr_17665_17689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (2))){
var inst_17626 = (state_17657[(7)]);
var inst_17618 = (state_17657[(10)]);
var inst_17613 = (state_17657[(11)]);
var inst_17615 = (state_17657[(12)]);
var _ = (function (){var statearr_17666 = state_17657;
(statearr_17666[(4)] = cljs.core.cons((5),(state_17657[(4)])));

return statearr_17666;
})();
var inst_17607 = db;
var inst_17608 = cljs.core.__destructure_map(inst_17607);
var inst_17609 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17610 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17612 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17613__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17614 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17615__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17616 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17617 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_17618__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17621 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17622 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17608,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17623 = fluree.db.storage.core.ledger_root_key(inst_17609,inst_17618__$1,inst_17615__$1);
var inst_17624 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17625 = fluree.db.storage.core.child_data(inst_17616);
var inst_17626__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17613__$1);
var state_17657__$1 = (function (){var statearr_17667 = state_17657;
(statearr_17667[(13)] = inst_17612);

(statearr_17667[(7)] = inst_17626__$1);

(statearr_17667[(14)] = inst_17619);

(statearr_17667[(8)] = inst_17623);

(statearr_17667[(15)] = inst_17610);

(statearr_17667[(16)] = inst_17621);

(statearr_17667[(17)] = inst_17624);

(statearr_17667[(10)] = inst_17618__$1);

(statearr_17667[(18)] = inst_17617);

(statearr_17667[(19)] = inst_17622);

(statearr_17667[(11)] = inst_17613__$1);

(statearr_17667[(20)] = inst_17620);

(statearr_17667[(12)] = inst_17615__$1);

(statearr_17667[(21)] = inst_17625);

(statearr_17667[(22)] = inst_17611);

(statearr_17667[(23)] = inst_17614);

return statearr_17667;
})();
if(cljs.core.truth_(inst_17626__$1)){
var statearr_17668_17690 = state_17657__$1;
(statearr_17668_17690[(1)] = (6));

} else {
var statearr_17669_17691 = state_17657__$1;
(statearr_17669_17691[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (11))){
var inst_17612 = (state_17657[(13)]);
var inst_17623 = (state_17657[(8)]);
var inst_17610 = (state_17657[(15)]);
var inst_17630 = (state_17657[(24)]);
var inst_17631 = (state_17657[(25)]);
var inst_17621 = (state_17657[(16)]);
var inst_17624 = (state_17657[(17)]);
var inst_17618 = (state_17657[(10)]);
var inst_17622 = (state_17657[(19)]);
var inst_17613 = (state_17657[(11)]);
var inst_17620 = (state_17657[(20)]);
var inst_17615 = (state_17657[(12)]);
var inst_17625 = (state_17657[(21)]);
var inst_17611 = (state_17657[(22)]);
var inst_17614 = (state_17657[(23)]);
var inst_17636 = (state_17657[(2)]);
var inst_17637 = fluree.db.storage.core.child_data(inst_17620);
var inst_17638 = fluree.db.storage.core.child_data(inst_17622);
var inst_17639 = fluree.db.util.core.current_time_millis();
var inst_17640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17641 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17642 = (new cljs.core.PersistentVector(null,2,(5),inst_17640,inst_17641,null));
var inst_17643 = cljs.core.select_keys(inst_17613,inst_17642);
var inst_17644 = fluree.db.storage.core.child_data(inst_17612);
var inst_17645 = [inst_17615,inst_17625,inst_17630,inst_17618,inst_17631,inst_17636,inst_17637,inst_17638,inst_17610,inst_17639,inst_17611,inst_17621,inst_17643,inst_17644];
var inst_17646 = cljs.core.PersistentHashMap.fromArrays(inst_17624,inst_17645);
var inst_17647 = fluree.db.storage.core.serde(inst_17614);
var inst_17648 = fluree.db.serde.protocol._serialize_db_root(inst_17647,inst_17646);
var inst_17649 = fluree.db.storage.core.write(inst_17614,inst_17623,inst_17648);
var state_17657__$1 = state_17657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17657__$1,(12),inst_17649);
} else {
if((state_val_17658 === (9))){
var inst_17632 = (state_17657[(26)]);
var state_17657__$1 = state_17657;
var statearr_17671_17692 = state_17657__$1;
(statearr_17671_17692[(2)] = inst_17632);

(statearr_17671_17692[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (5))){
var _ = (function (){var statearr_17672 = state_17657;
(statearr_17672[(4)] = cljs.core.rest((state_17657[(4)])));

return statearr_17672;
})();
var state_17657__$1 = state_17657;
var ex17670 = (state_17657__$1[(2)]);
var statearr_17673_17693 = state_17657__$1;
(statearr_17673_17693[(5)] = ex17670);


if((ex17670 instanceof Error)){
var statearr_17674_17694 = state_17657__$1;
(statearr_17674_17694[(1)] = (4));

(statearr_17674_17694[(5)] = null);

} else {
throw ex17670;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (10))){
var inst_17619 = (state_17657[(14)]);
var state_17657__$1 = state_17657;
var statearr_17675_17695 = state_17657__$1;
(statearr_17675_17695[(2)] = inst_17619);

(statearr_17675_17695[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (8))){
var inst_17632 = (state_17657[(26)]);
var inst_17617 = (state_17657[(18)]);
var inst_17630 = (state_17657[(2)]);
var inst_17631 = fluree.db.storage.core.child_data(inst_17617);
var inst_17632__$1 = custom_ecount;
var state_17657__$1 = (function (){var statearr_17676 = state_17657;
(statearr_17676[(26)] = inst_17632__$1);

(statearr_17676[(24)] = inst_17630);

(statearr_17676[(25)] = inst_17631);

return statearr_17676;
})();
if(cljs.core.truth_(inst_17632__$1)){
var statearr_17677_17696 = state_17657__$1;
(statearr_17677_17696[(1)] = (9));

} else {
var statearr_17678_17697 = state_17657__$1;
(statearr_17678_17697[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_17679 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17679[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_17679[(1)] = (1));

return statearr_17679;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_17657){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17657);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17680){var ex__2687__auto__ = e17680;
var statearr_17681_17698 = state_17657;
(statearr_17681_17698[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17657[(4)]))){
var statearr_17682_17699 = state_17657;
(statearr_17682_17699[(1)] = cljs.core.first((state_17657[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17700 = state_17657;
state_17657 = G__17700;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_17657){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_17657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17683 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17683[(6)] = c__2706__auto__);

return statearr_17683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__17701,key){
var map__17702 = p__17701;
var map__17702__$1 = cljs.core.__destructure_map(map__17702);
var conn = map__17702__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17702__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17722){
var state_val_17723 = (state_17722[(1)]);
if((state_val_17723 === (7))){
var inst_17712 = (state_17722[(7)]);
var inst_17714 = fluree.db.serde.protocol._deserialize_branch(serializer,inst_17712);
var state_17722__$1 = state_17722;
var statearr_17724_17743 = state_17722__$1;
(statearr_17724_17743[(2)] = inst_17714);

(statearr_17724_17743[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17723 === (1))){
var state_17722__$1 = state_17722;
var statearr_17725_17744 = state_17722__$1;
(statearr_17725_17744[(2)] = null);

(statearr_17725_17744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17723 === (4))){
var inst_17703 = (state_17722[(2)]);
var state_17722__$1 = state_17722;
var statearr_17726_17745 = state_17722__$1;
(statearr_17726_17745[(2)] = inst_17703);

(statearr_17726_17745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17723 === (6))){
var inst_17712 = (state_17722[(7)]);
var inst_17711 = (state_17722[(2)]);
var inst_17712__$1 = fluree.db.util.async.throw_err(inst_17711);
var state_17722__$1 = (function (){var statearr_17727 = state_17722;
(statearr_17727[(7)] = inst_17712__$1);

return statearr_17727;
})();
if(cljs.core.truth_(inst_17712__$1)){
var statearr_17728_17746 = state_17722__$1;
(statearr_17728_17746[(1)] = (7));

} else {
var statearr_17729_17747 = state_17722__$1;
(statearr_17729_17747[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17723 === (3))){
var inst_17720 = (state_17722[(2)]);
var state_17722__$1 = state_17722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17722__$1,inst_17720);
} else {
if((state_val_17723 === (2))){
var _ = (function (){var statearr_17731 = state_17722;
(statearr_17731[(4)] = cljs.core.cons((5),(state_17722[(4)])));

return statearr_17731;
})();
var inst_17709 = fluree.db.storage.core.read(conn,key);
var state_17722__$1 = state_17722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17722__$1,(6),inst_17709);
} else {
if((state_val_17723 === (9))){
var inst_17717 = (state_17722[(2)]);
var _ = (function (){var statearr_17732 = state_17722;
(statearr_17732[(4)] = cljs.core.rest((state_17722[(4)])));

return statearr_17732;
})();
var state_17722__$1 = state_17722;
var statearr_17733_17748 = state_17722__$1;
(statearr_17733_17748[(2)] = inst_17717);

(statearr_17733_17748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17723 === (5))){
var _ = (function (){var statearr_17734 = state_17722;
(statearr_17734[(4)] = cljs.core.rest((state_17722[(4)])));

return statearr_17734;
})();
var state_17722__$1 = state_17722;
var ex17730 = (state_17722__$1[(2)]);
var statearr_17735_17749 = state_17722__$1;
(statearr_17735_17749[(5)] = ex17730);


if((ex17730 instanceof Error)){
var statearr_17736_17750 = state_17722__$1;
(statearr_17736_17750[(1)] = (4));

(statearr_17736_17750[(5)] = null);

} else {
throw ex17730;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17723 === (8))){
var state_17722__$1 = state_17722;
var statearr_17737_17751 = state_17722__$1;
(statearr_17737_17751[(2)] = null);

(statearr_17737_17751[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0 = (function (){
var statearr_17738 = [null,null,null,null,null,null,null,null];
(statearr_17738[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2684__auto__);

(statearr_17738[(1)] = (1));

return statearr_17738;
});
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1 = (function (state_17722){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17722);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17739){var ex__2687__auto__ = e17739;
var statearr_17740_17752 = state_17722;
(statearr_17740_17752[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17722[(4)]))){
var statearr_17741_17753 = state_17722;
(statearr_17741_17753[(1)] = cljs.core.first((state_17722[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17754 = state_17722;
state_17722 = G__17754;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__ = function(state_17722){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1.call(this,state_17722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17742 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17742[(6)] = c__2706__auto__);

return statearr_17742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__17755,key){
var map__17756 = p__17755;
var map__17756__$1 = cljs.core.__destructure_map(map__17756);
var conn = map__17756__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17756__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17776){
var state_val_17777 = (state_17776[(1)]);
if((state_val_17777 === (7))){
var inst_17766 = (state_17776[(7)]);
var inst_17768 = fluree.db.serde.protocol._deserialize_leaf(serializer,inst_17766);
var state_17776__$1 = state_17776;
var statearr_17778_17797 = state_17776__$1;
(statearr_17778_17797[(2)] = inst_17768);

(statearr_17778_17797[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (1))){
var state_17776__$1 = state_17776;
var statearr_17779_17798 = state_17776__$1;
(statearr_17779_17798[(2)] = null);

(statearr_17779_17798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (4))){
var inst_17757 = (state_17776[(2)]);
var state_17776__$1 = state_17776;
var statearr_17780_17799 = state_17776__$1;
(statearr_17780_17799[(2)] = inst_17757);

(statearr_17780_17799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (6))){
var inst_17766 = (state_17776[(7)]);
var inst_17765 = (state_17776[(2)]);
var inst_17766__$1 = fluree.db.util.async.throw_err(inst_17765);
var state_17776__$1 = (function (){var statearr_17781 = state_17776;
(statearr_17781[(7)] = inst_17766__$1);

return statearr_17781;
})();
if(cljs.core.truth_(inst_17766__$1)){
var statearr_17782_17800 = state_17776__$1;
(statearr_17782_17800[(1)] = (7));

} else {
var statearr_17783_17801 = state_17776__$1;
(statearr_17783_17801[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (3))){
var inst_17774 = (state_17776[(2)]);
var state_17776__$1 = state_17776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17776__$1,inst_17774);
} else {
if((state_val_17777 === (2))){
var _ = (function (){var statearr_17785 = state_17776;
(statearr_17785[(4)] = cljs.core.cons((5),(state_17776[(4)])));

return statearr_17785;
})();
var inst_17763 = fluree.db.storage.core.read(conn,key);
var state_17776__$1 = state_17776;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17776__$1,(6),inst_17763);
} else {
if((state_val_17777 === (9))){
var inst_17771 = (state_17776[(2)]);
var _ = (function (){var statearr_17786 = state_17776;
(statearr_17786[(4)] = cljs.core.rest((state_17776[(4)])));

return statearr_17786;
})();
var state_17776__$1 = state_17776;
var statearr_17787_17802 = state_17776__$1;
(statearr_17787_17802[(2)] = inst_17771);

(statearr_17787_17802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (5))){
var _ = (function (){var statearr_17788 = state_17776;
(statearr_17788[(4)] = cljs.core.rest((state_17776[(4)])));

return statearr_17788;
})();
var state_17776__$1 = state_17776;
var ex17784 = (state_17776__$1[(2)]);
var statearr_17789_17803 = state_17776__$1;
(statearr_17789_17803[(5)] = ex17784);


if((ex17784 instanceof Error)){
var statearr_17790_17804 = state_17776__$1;
(statearr_17790_17804[(1)] = (4));

(statearr_17790_17804[(5)] = null);

} else {
throw ex17784;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (8))){
var state_17776__$1 = state_17776;
var statearr_17791_17805 = state_17776__$1;
(statearr_17791_17805[(2)] = null);

(statearr_17791_17805[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0 = (function (){
var statearr_17792 = [null,null,null,null,null,null,null,null];
(statearr_17792[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__);

(statearr_17792[(1)] = (1));

return statearr_17792;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1 = (function (state_17776){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17776);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17793){var ex__2687__auto__ = e17793;
var statearr_17794_17806 = state_17776;
(statearr_17794_17806[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17776[(4)]))){
var statearr_17795_17807 = state_17776;
(statearr_17795_17807[(1)] = cljs.core.first((state_17776[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17808 = state_17776;
state_17776 = G__17808;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__ = function(state_17776){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1.call(this,state_17776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17796 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17796[(6)] = c__2706__auto__);

return statearr_17796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__17809,index,index_data){
var map__17810 = p__17809;
var map__17810__$1 = cljs.core.__destructure_map(map__17810);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17810__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17810__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17810__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17810__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17810__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db index root: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__17811 = index_data;
var G__17811__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__17811,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__17811);
var G__17811__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__17811__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__17811__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__17811__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0));

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17812 = root_data;
var map__17812__$1 = cljs.core.__destructure_map(map__17812);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17812__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17812__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17812__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17812__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root(conn,db,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17834){
var state_val_17835 = (state_17834[(1)]);
if((state_val_17835 === (7))){
var state_17834__$1 = state_17834;
var statearr_17836_17856 = state_17834__$1;
(statearr_17836_17856[(2)] = null);

(statearr_17836_17856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17835 === (1))){
var state_17834__$1 = state_17834;
var statearr_17837_17857 = state_17834__$1;
(statearr_17837_17857[(2)] = null);

(statearr_17837_17857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17835 === (4))){
var inst_17813 = (state_17834[(2)]);
var state_17834__$1 = state_17834;
var statearr_17838_17858 = state_17834__$1;
(statearr_17838_17858[(2)] = inst_17813);

(statearr_17838_17858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17835 === (6))){
var inst_17820 = (state_17834[(7)]);
var inst_17822 = fluree.db.storage.core.serde(conn);
var state_17834__$1 = (function (){var statearr_17839 = state_17834;
(statearr_17839[(8)] = inst_17822);

return statearr_17839;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17834__$1,(9),inst_17820);
} else {
if((state_val_17835 === (3))){
var inst_17832 = (state_17834[(2)]);
var state_17834__$1 = state_17834;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17834__$1,inst_17832);
} else {
if((state_val_17835 === (2))){
var inst_17820 = (state_17834[(7)]);
var _ = (function (){var statearr_17841 = state_17834;
(statearr_17841[(4)] = cljs.core.cons((5),(state_17834[(4)])));

return statearr_17841;
})();
var inst_17819 = fluree.db.storage.core.ledger_garbage_key(network,ledger_id,block);
var inst_17820__$1 = fluree.db.storage.core.read(conn,inst_17819);
var state_17834__$1 = (function (){var statearr_17842 = state_17834;
(statearr_17842[(7)] = inst_17820__$1);

return statearr_17842;
})();
if(cljs.core.truth_(inst_17820__$1)){
var statearr_17843_17859 = state_17834__$1;
(statearr_17843_17859[(1)] = (6));

} else {
var statearr_17844_17860 = state_17834__$1;
(statearr_17844_17860[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17835 === (9))){
var inst_17822 = (state_17834[(8)]);
var inst_17824 = (state_17834[(2)]);
var inst_17825 = fluree.db.util.async.throw_err(inst_17824);
var inst_17826 = fluree.db.serde.protocol._deserialize_garbage(inst_17822,inst_17825);
var state_17834__$1 = state_17834;
var statearr_17845_17861 = state_17834__$1;
(statearr_17845_17861[(2)] = inst_17826);

(statearr_17845_17861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17835 === (5))){
var _ = (function (){var statearr_17846 = state_17834;
(statearr_17846[(4)] = cljs.core.rest((state_17834[(4)])));

return statearr_17846;
})();
var state_17834__$1 = state_17834;
var ex17840 = (state_17834__$1[(2)]);
var statearr_17847_17862 = state_17834__$1;
(statearr_17847_17862[(5)] = ex17840);


if((ex17840 instanceof Error)){
var statearr_17848_17863 = state_17834__$1;
(statearr_17848_17863[(1)] = (4));

(statearr_17848_17863[(5)] = null);

} else {
throw ex17840;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17835 === (8))){
var inst_17829 = (state_17834[(2)]);
var _ = (function (){var statearr_17849 = state_17834;
(statearr_17849[(4)] = cljs.core.rest((state_17834[(4)])));

return statearr_17849;
})();
var state_17834__$1 = state_17834;
var statearr_17850_17864 = state_17834__$1;
(statearr_17850_17864[(2)] = inst_17829);

(statearr_17850_17864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0 = (function (){
var statearr_17851 = [null,null,null,null,null,null,null,null,null];
(statearr_17851[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__);

(statearr_17851[(1)] = (1));

return statearr_17851;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1 = (function (state_17834){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17834);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17852){var ex__2687__auto__ = e17852;
var statearr_17853_17865 = state_17834;
(statearr_17853_17865[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17834[(4)]))){
var statearr_17854_17866 = state_17834;
(statearr_17854_17866[(1)] = cljs.core.first((state_17834[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17867 = state_17834;
state_17834 = G__17867;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__ = function(state_17834){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1.call(this,state_17834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17855 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17855[(6)] = c__2706__auto__);

return statearr_17855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17889){
var state_val_17890 = (state_17889[(1)]);
if((state_val_17890 === (7))){
var inst_17878 = (state_17889[(7)]);
var inst_17880 = fluree.db.storage.core.serde(conn);
var inst_17881 = fluree.db.serde.protocol._deserialize_db_root(inst_17880,inst_17878);
var state_17889__$1 = state_17889;
var statearr_17891_17910 = state_17889__$1;
(statearr_17891_17910[(2)] = inst_17881);

(statearr_17891_17910[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (1))){
var state_17889__$1 = state_17889;
var statearr_17892_17911 = state_17889__$1;
(statearr_17892_17911[(2)] = null);

(statearr_17892_17911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (4))){
var inst_17868 = (state_17889[(2)]);
var state_17889__$1 = state_17889;
var statearr_17893_17912 = state_17889__$1;
(statearr_17893_17912[(2)] = inst_17868);

(statearr_17893_17912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (6))){
var inst_17878 = (state_17889[(7)]);
var inst_17877 = (state_17889[(2)]);
var inst_17878__$1 = fluree.db.util.async.throw_err(inst_17877);
var state_17889__$1 = (function (){var statearr_17894 = state_17889;
(statearr_17894[(7)] = inst_17878__$1);

return statearr_17894;
})();
if(cljs.core.truth_(inst_17878__$1)){
var statearr_17895_17913 = state_17889__$1;
(statearr_17895_17913[(1)] = (7));

} else {
var statearr_17896_17914 = state_17889__$1;
(statearr_17896_17914[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (3))){
var inst_17887 = (state_17889[(2)]);
var state_17889__$1 = state_17889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17889__$1,inst_17887);
} else {
if((state_val_17890 === (2))){
var _ = (function (){var statearr_17898 = state_17889;
(statearr_17898[(4)] = cljs.core.cons((5),(state_17889[(4)])));

return statearr_17898;
})();
var inst_17874 = fluree.db.storage.core.ledger_root_key(network,ledger_id,block);
var inst_17875 = fluree.db.storage.core.read(conn,inst_17874);
var state_17889__$1 = state_17889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17889__$1,(6),inst_17875);
} else {
if((state_val_17890 === (9))){
var inst_17884 = (state_17889[(2)]);
var _ = (function (){var statearr_17899 = state_17889;
(statearr_17899[(4)] = cljs.core.rest((state_17889[(4)])));

return statearr_17899;
})();
var state_17889__$1 = state_17889;
var statearr_17900_17915 = state_17889__$1;
(statearr_17900_17915[(2)] = inst_17884);

(statearr_17900_17915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (5))){
var _ = (function (){var statearr_17901 = state_17889;
(statearr_17901[(4)] = cljs.core.rest((state_17889[(4)])));

return statearr_17901;
})();
var state_17889__$1 = state_17889;
var ex17897 = (state_17889__$1[(2)]);
var statearr_17902_17916 = state_17889__$1;
(statearr_17902_17916[(5)] = ex17897);


if((ex17897 instanceof Error)){
var statearr_17903_17917 = state_17889__$1;
(statearr_17903_17917[(1)] = (4));

(statearr_17903_17917[(5)] = null);

} else {
throw ex17897;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17890 === (8))){
var state_17889__$1 = state_17889;
var statearr_17904_17918 = state_17889__$1;
(statearr_17904_17918[(2)] = null);

(statearr_17904_17918[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0 = (function (){
var statearr_17905 = [null,null,null,null,null,null,null,null];
(statearr_17905[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__);

(statearr_17905[(1)] = (1));

return statearr_17905;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1 = (function (state_17889){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17889);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17906){var ex__2687__auto__ = e17906;
var statearr_17907_17919 = state_17889;
(statearr_17907_17919[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17889[(4)]))){
var statearr_17908_17920 = state_17889;
(statearr_17908_17920[(1)] = cljs.core.first((state_17889[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17921 = state_17889;
state_17889 = G__17921;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__ = function(state_17889){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1.call(this,state_17889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17909 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17909[(6)] = c__2706__auto__);

return statearr_17909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17958){
var state_val_17959 = (state_17958[(1)]);
if((state_val_17959 === (7))){
var inst_17928 = (state_17958[(7)]);
var state_17958__$1 = state_17958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17958__$1,(9),inst_17928);
} else {
if((state_val_17959 === (1))){
var state_17958__$1 = state_17958;
var statearr_17960_17981 = state_17958__$1;
(statearr_17960_17981[(2)] = null);

(statearr_17960_17981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17959 === (4))){
var inst_17922 = (state_17958[(2)]);
var state_17958__$1 = state_17958;
var statearr_17961_17982 = state_17958__$1;
(statearr_17961_17982[(2)] = inst_17922);

(statearr_17961_17982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17959 === (6))){
var inst_17931 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_17932 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17933 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_17934 = cljs.core.PersistentHashMap.fromArrays(inst_17932,inst_17933);
var inst_17935 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17931,inst_17934);
var inst_17936 = (function(){throw inst_17935})();
var state_17958__$1 = state_17958;
var statearr_17962_17983 = state_17958__$1;
(statearr_17962_17983[(2)] = inst_17936);

(statearr_17962_17983[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17959 === (3))){
var inst_17956 = (state_17958[(2)]);
var state_17958__$1 = state_17958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17958__$1,inst_17956);
} else {
if((state_val_17959 === (2))){
var inst_17928 = (state_17958[(7)]);
var _ = (function (){var statearr_17963 = state_17958;
(statearr_17963[(4)] = cljs.core.cons((5),(state_17958[(4)])));

return statearr_17963;
})();
var inst_17928__$1 = fluree.db.storage.core.read_db_root(conn,network,ledger_id,index);
var inst_17929 = cljs.core.not(inst_17928__$1);
var state_17958__$1 = (function (){var statearr_17964 = state_17958;
(statearr_17964[(7)] = inst_17928__$1);

return statearr_17964;
})();
if(inst_17929){
var statearr_17965_17984 = state_17958__$1;
(statearr_17965_17984[(1)] = (6));

} else {
var statearr_17966_17985 = state_17958__$1;
(statearr_17966_17985[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17959 === (11))){
var inst_17946 = (state_17958[(8)]);
var inst_17949 = (state_17958[(2)]);
var inst_17950 = fluree.db.util.async.throw_err(inst_17949);
var inst_17951 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17946,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_17950);
var state_17958__$1 = state_17958;
var statearr_17968_17986 = state_17958__$1;
(statearr_17968_17986[(2)] = inst_17951);

(statearr_17968_17986[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17959 === (9))){
var inst_17941 = (state_17958[(9)]);
var inst_17939 = (state_17958[(2)]);
var inst_17940 = fluree.db.util.async.throw_err(inst_17939);
var inst_17941__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_17940);
var inst_17942 = fluree.db.query.schema.schema_map(inst_17941__$1);
var state_17958__$1 = (function (){var statearr_17969 = state_17958;
(statearr_17969[(9)] = inst_17941__$1);

return statearr_17969;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17958__$1,(10),inst_17942);
} else {
if((state_val_17959 === (5))){
var _ = (function (){var statearr_17970 = state_17958;
(statearr_17970[(4)] = cljs.core.rest((state_17958[(4)])));

return statearr_17970;
})();
var state_17958__$1 = state_17958;
var ex17967 = (state_17958__$1[(2)]);
var statearr_17971_17987 = state_17958__$1;
(statearr_17971_17987[(5)] = ex17967);


if((ex17967 instanceof Error)){
var statearr_17972_17988 = state_17958__$1;
(statearr_17972_17988[(1)] = (4));

(statearr_17972_17988[(5)] = null);

} else {
throw ex17967;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17959 === (10))){
var inst_17941 = (state_17958[(9)]);
var inst_17946 = (state_17958[(8)]);
var inst_17944 = (state_17958[(2)]);
var inst_17945 = fluree.db.util.async.throw_err(inst_17944);
var inst_17946__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17941,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_17945);
var inst_17947 = fluree.db.query.schema.setting_map(inst_17946__$1);
var state_17958__$1 = (function (){var statearr_17973 = state_17958;
(statearr_17973[(8)] = inst_17946__$1);

return statearr_17973;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17958__$1,(11),inst_17947);
} else {
if((state_val_17959 === (8))){
var inst_17953 = (state_17958[(2)]);
var _ = (function (){var statearr_17974 = state_17958;
(statearr_17974[(4)] = cljs.core.rest((state_17958[(4)])));

return statearr_17974;
})();
var state_17958__$1 = state_17958;
var statearr_17975_17989 = state_17958__$1;
(statearr_17975_17989[(2)] = inst_17953);

(statearr_17975_17989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0 = (function (){
var statearr_17976 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17976[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2684__auto__);

(statearr_17976[(1)] = (1));

return statearr_17976;
});
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1 = (function (state_17958){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17958);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17977){var ex__2687__auto__ = e17977;
var statearr_17978_17990 = state_17958;
(statearr_17978_17990[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17958[(4)]))){
var statearr_17979_17991 = state_17958;
(statearr_17979_17991[(1)] = cljs.core.first((state_17958[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17992 = state_17958;
state_17958 = G__17992;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__ = function(state_17958){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1.call(this,state_17958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17980 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17980[(6)] = c__2706__auto__);

return statearr_17980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__17993){
var map__17994 = p__17993;
var map__17994__$1 = cljs.core.__destructure_map(map__17994);
var branch = map__17994__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17994__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17994__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17994__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18031){
var state_val_18032 = (state_18031[(1)]);
if((state_val_18032 === (7))){
var inst_18004 = (state_18031[(7)]);
var inst_18007 = cljs.core.__destructure_map(inst_18004);
var inst_18008 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18007,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18010 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_18011 = (new cljs.core.PersistentVector(null,7,(5),inst_18009,inst_18010,null));
var inst_18012 = cljs.core.select_keys(branch,inst_18011);
var inst_18013 = (function (){var temp__5802__auto__ = inst_18004;
var map__18006 = inst_18007;
var children = inst_18008;
var branch_metadata = inst_18012;
return (function (i,child){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (i === (0));
} else {
return and__5043__auto__;
}
})()),child], 0));
});
})();
var inst_18014 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_18013,inst_18008);
var inst_18015 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_18016 = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(inst_18015,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_18014], 0));
var inst_18017 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,comparator,inst_18016);
var state_18031__$1 = state_18031;
var statearr_18033_18052 = state_18031__$1;
(statearr_18033_18052[(2)] = inst_18017);

(statearr_18033_18052[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18032 === (1))){
var state_18031__$1 = state_18031;
var statearr_18034_18053 = state_18031__$1;
(statearr_18034_18053[(2)] = null);

(statearr_18034_18053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18032 === (4))){
var inst_17995 = (state_18031[(2)]);
var state_18031__$1 = state_18031;
var statearr_18035_18054 = state_18031__$1;
(statearr_18035_18054[(2)] = inst_17995);

(statearr_18035_18054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18032 === (6))){
var inst_18004 = (state_18031[(7)]);
var inst_18003 = (state_18031[(2)]);
var inst_18004__$1 = fluree.db.util.async.throw_err(inst_18003);
var state_18031__$1 = (function (){var statearr_18036 = state_18031;
(statearr_18036[(7)] = inst_18004__$1);

return statearr_18036;
})();
if(cljs.core.truth_(inst_18004__$1)){
var statearr_18037_18055 = state_18031__$1;
(statearr_18037_18055[(1)] = (7));

} else {
var statearr_18038_18056 = state_18031__$1;
(statearr_18038_18056[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18032 === (3))){
var inst_18029 = (state_18031[(2)]);
var state_18031__$1 = state_18031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18031__$1,inst_18029);
} else {
if((state_val_18032 === (2))){
var _ = (function (){var statearr_18040 = state_18031;
(statearr_18040[(4)] = cljs.core.cons((5),(state_18031[(4)])));

return statearr_18040;
})();
var inst_18001 = fluree.db.storage.core.read_branch(conn,id);
var state_18031__$1 = state_18031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18031__$1,(6),inst_18001);
} else {
if((state_val_18032 === (9))){
var inst_18026 = (state_18031[(2)]);
var _ = (function (){var statearr_18041 = state_18031;
(statearr_18041[(4)] = cljs.core.rest((state_18031[(4)])));

return statearr_18041;
})();
var state_18031__$1 = state_18031;
var statearr_18042_18057 = state_18031__$1;
(statearr_18042_18057[(2)] = inst_18026);

(statearr_18042_18057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18032 === (5))){
var _ = (function (){var statearr_18043 = state_18031;
(statearr_18043[(4)] = cljs.core.rest((state_18031[(4)])));

return statearr_18043;
})();
var state_18031__$1 = state_18031;
var ex18039 = (state_18031__$1[(2)]);
var statearr_18044_18058 = state_18031__$1;
(statearr_18044_18058[(5)] = ex18039);


if((ex18039 instanceof Error)){
var statearr_18045_18059 = state_18031__$1;
(statearr_18045_18059[(1)] = (4));

(statearr_18045_18059[(5)] = null);

} else {
throw ex18039;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18032 === (8))){
var inst_18019 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_18020 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18021 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18022 = cljs.core.PersistentHashMap.fromArrays(inst_18020,inst_18021);
var inst_18023 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18019,inst_18022);
var inst_18024 = (function(){throw inst_18023})();
var state_18031__$1 = state_18031;
var statearr_18046_18060 = state_18031__$1;
(statearr_18046_18060[(2)] = inst_18024);

(statearr_18046_18060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____0 = (function (){
var statearr_18047 = [null,null,null,null,null,null,null,null];
(statearr_18047[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__);

(statearr_18047[(1)] = (1));

return statearr_18047;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____1 = (function (state_18031){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18031);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18048){var ex__2687__auto__ = e18048;
var statearr_18049_18061 = state_18031;
(statearr_18049_18061[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18031[(4)]))){
var statearr_18050_18062 = state_18031;
(statearr_18050_18062[(1)] = cljs.core.first((state_18031[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18063 = state_18031;
state_18031 = G__18063;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__ = function(state_18031){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____1.call(this,state_18031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18051 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18051[(6)] = c__2706__auto__);

return statearr_18051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__18064){
var map__18065 = p__18064;
var map__18065__$1 = cljs.core.__destructure_map(map__18065);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18065__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18065__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18094){
var state_val_18095 = (state_18094[(1)]);
if((state_val_18095 === (7))){
var inst_18075 = (state_18094[(7)]);
var inst_18078 = cljs.core.__destructure_map(inst_18075);
var inst_18079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18078,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18080 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,comparator,inst_18079);
var state_18094__$1 = state_18094;
var statearr_18096_18115 = state_18094__$1;
(statearr_18096_18115[(2)] = inst_18080);

(statearr_18096_18115[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18095 === (1))){
var state_18094__$1 = state_18094;
var statearr_18097_18116 = state_18094__$1;
(statearr_18097_18116[(2)] = null);

(statearr_18097_18116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18095 === (4))){
var inst_18066 = (state_18094[(2)]);
var state_18094__$1 = state_18094;
var statearr_18098_18117 = state_18094__$1;
(statearr_18098_18117[(2)] = inst_18066);

(statearr_18098_18117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18095 === (6))){
var inst_18075 = (state_18094[(7)]);
var inst_18074 = (state_18094[(2)]);
var inst_18075__$1 = fluree.db.util.async.throw_err(inst_18074);
var state_18094__$1 = (function (){var statearr_18099 = state_18094;
(statearr_18099[(7)] = inst_18075__$1);

return statearr_18099;
})();
if(cljs.core.truth_(inst_18075__$1)){
var statearr_18100_18118 = state_18094__$1;
(statearr_18100_18118[(1)] = (7));

} else {
var statearr_18101_18119 = state_18094__$1;
(statearr_18101_18119[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18095 === (3))){
var inst_18092 = (state_18094[(2)]);
var state_18094__$1 = state_18094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18094__$1,inst_18092);
} else {
if((state_val_18095 === (2))){
var _ = (function (){var statearr_18103 = state_18094;
(statearr_18103[(4)] = cljs.core.cons((5),(state_18094[(4)])));

return statearr_18103;
})();
var inst_18072 = fluree.db.storage.core.read_leaf(conn,id);
var state_18094__$1 = state_18094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18094__$1,(6),inst_18072);
} else {
if((state_val_18095 === (9))){
var inst_18089 = (state_18094[(2)]);
var _ = (function (){var statearr_18104 = state_18094;
(statearr_18104[(4)] = cljs.core.rest((state_18094[(4)])));

return statearr_18104;
})();
var state_18094__$1 = state_18094;
var statearr_18105_18120 = state_18094__$1;
(statearr_18105_18120[(2)] = inst_18089);

(statearr_18105_18120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18095 === (5))){
var _ = (function (){var statearr_18106 = state_18094;
(statearr_18106[(4)] = cljs.core.rest((state_18094[(4)])));

return statearr_18106;
})();
var state_18094__$1 = state_18094;
var ex18102 = (state_18094__$1[(2)]);
var statearr_18107_18121 = state_18094__$1;
(statearr_18107_18121[(5)] = ex18102);


if((ex18102 instanceof Error)){
var statearr_18108_18122 = state_18094__$1;
(statearr_18108_18122[(1)] = (4));

(statearr_18108_18122[(5)] = null);

} else {
throw ex18102;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18095 === (8))){
var inst_18082 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_18083 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18084 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18085 = cljs.core.PersistentHashMap.fromArrays(inst_18083,inst_18084);
var inst_18086 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18082,inst_18085);
var inst_18087 = (function(){throw inst_18086})();
var state_18094__$1 = state_18094;
var statearr_18109_18123 = state_18094__$1;
(statearr_18109_18123[(2)] = inst_18087);

(statearr_18109_18123[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____0 = (function (){
var statearr_18110 = [null,null,null,null,null,null,null,null];
(statearr_18110[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__);

(statearr_18110[(1)] = (1));

return statearr_18110;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____1 = (function (state_18094){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18094);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18111){var ex__2687__auto__ = e18111;
var statearr_18112_18124 = state_18094;
(statearr_18112_18124[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18094[(4)]))){
var statearr_18113_18125 = state_18094;
(statearr_18113_18125[(1)] = cljs.core.first((state_18094[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18126 = state_18094;
state_18094 = G__18126;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__ = function(state_18094){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____1.call(this,state_18094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18114 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18114[(6)] = c__2706__auto__);

return statearr_18114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__18128 = arguments.length;
switch (G__18128) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2(node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__18129,error_fn){
var map__18130 = p__18129;
var map__18130__$1 = cljs.core.__destructure_map(map__18130);
var node = map__18130__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18130__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18130__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___18202 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18174){
var state_val_18175 = (state_18174[(1)]);
if((state_val_18175 === (7))){
var inst_18139 = (state_18174[(2)]);
var state_18174__$1 = state_18174;
var statearr_18176_18203 = state_18174__$1;
(statearr_18176_18203[(2)] = inst_18139);

(statearr_18176_18203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18175 === (1))){
var state_18174__$1 = state_18174;
var statearr_18177_18204 = state_18174__$1;
(statearr_18177_18204[(2)] = null);

(statearr_18177_18204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18175 === (4))){
var inst_18131 = (state_18174[(7)]);
var inst_18131__$1 = (state_18174[(2)]);
var inst_18132 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_18131__$1,"Error resolving index node") : fluree.db.util.log.error.call(null,inst_18131__$1,"Error resolving index node"));
var state_18174__$1 = (function (){var statearr_18178 = state_18174;
(statearr_18178[(7)] = inst_18131__$1);

(statearr_18178[(8)] = inst_18132);

return statearr_18178;
})();
if(cljs.core.truth_(error_fn)){
var statearr_18179_18205 = state_18174__$1;
(statearr_18179_18205[(1)] = (5));

} else {
var statearr_18180_18206 = state_18174__$1;
(statearr_18180_18206[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18175 === (13))){
var inst_18157 = (state_18174[(9)]);
var inst_18160 = (state_18174[(2)]);
var inst_18161 = fluree.db.util.async.throw_err(inst_18160);
var inst_18162 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_18161];
var inst_18163 = (new cljs.core.PersistentVector(null,2,(5),inst_18157,inst_18162,null));
var state_18174__$1 = state_18174;
var statearr_18181_18207 = state_18174__$1;
(statearr_18181_18207[(2)] = inst_18163);

(statearr_18181_18207[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18175 === (6))){
var state_18174__$1 = state_18174;
var statearr_18182_18208 = state_18174__$1;
(statearr_18182_18208[(2)] = null);

(statearr_18182_18208[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18175 === (3))){
var inst_18172 = (state_18174[(2)]);
var state_18174__$1 = state_18174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18174__$1,inst_18172);
} else {
if((state_val_18175 === (12))){
var inst_18149 = (state_18174[(10)]);
var inst_18152 = (state_18174[(2)]);
var inst_18153 = fluree.db.util.async.throw_err(inst_18152);
var inst_18154 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18153];
var inst_18155 = (new cljs.core.PersistentVector(null,2,(5),inst_18149,inst_18154,null));
var state_18174__$1 = state_18174;
var statearr_18183_18209 = state_18174__$1;
(statearr_18183_18209[(2)] = inst_18155);

(statearr_18183_18209[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18175 === (2))){
var _ = (function (){var statearr_18184 = state_18174;
(statearr_18184[(4)] = cljs.core.cons((8),(state_18174[(4)])));

return statearr_18184;
})();
var state_18174__$1 = state_18174;
if(cljs.core.truth_(leaf)){
var statearr_18185_18210 = state_18174__$1;
(statearr_18185_18210[(1)] = (9));

} else {
var statearr_18186_18211 = state_18174__$1;
(statearr_18186_18211[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18175 === (11))){
var inst_18165 = (state_18174[(2)]);
var inst_18166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18165,(0),null);
var inst_18167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18165,(1),null);
var inst_18168 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,inst_18166,inst_18167);
var inst_18169 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18168);
var _ = (function (){var statearr_18187 = state_18174;
(statearr_18187[(4)] = cljs.core.rest((state_18174[(4)])));

return statearr_18187;
})();
var state_18174__$1 = state_18174;
var statearr_18188_18212 = state_18174__$1;
(statearr_18188_18212[(2)] = inst_18169);

(statearr_18188_18212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18175 === (9))){
var inst_18149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18150 = fluree.db.storage.core.fetch_leaf_flakes(conn,node);
var state_18174__$1 = (function (){var statearr_18189 = state_18174;
(statearr_18189[(10)] = inst_18149);

return statearr_18189;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18174__$1,(12),inst_18150);
} else {
if((state_val_18175 === (5))){
var inst_18131 = (state_18174[(7)]);
var inst_18134 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18131);
var inst_18135 = cljs.core.async.close_BANG_(return_ch);
var inst_18136 = (error_fn.cljs$core$IFn$_invoke$arity$2 ? error_fn.cljs$core$IFn$_invoke$arity$2(inst_18134,inst_18135) : error_fn.call(null,inst_18134,inst_18135));
var state_18174__$1 = state_18174;
var statearr_18191_18213 = state_18174__$1;
(statearr_18191_18213[(2)] = inst_18136);

(statearr_18191_18213[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18175 === (10))){
var inst_18157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18158 = fluree.db.storage.core.fetch_child_attributes(conn,node);
var state_18174__$1 = (function (){var statearr_18192 = state_18174;
(statearr_18192[(9)] = inst_18157);

return statearr_18192;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18174__$1,(13),inst_18158);
} else {
if((state_val_18175 === (8))){
var _ = (function (){var statearr_18193 = state_18174;
(statearr_18193[(4)] = cljs.core.rest((state_18174[(4)])));

return statearr_18193;
})();
var state_18174__$1 = state_18174;
var ex18190 = (state_18174__$1[(2)]);
var statearr_18194_18214 = state_18174__$1;
(statearr_18194_18214[(5)] = ex18190);


var statearr_18195_18215 = state_18174__$1;
(statearr_18195_18215[(1)] = (4));

(statearr_18195_18215[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_18196 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18196[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_18196[(1)] = (1));

return statearr_18196;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_18174){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18174);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18197){var ex__2687__auto__ = e18197;
var statearr_18198_18216 = state_18174;
(statearr_18198_18216[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18174[(4)]))){
var statearr_18199_18217 = state_18174;
(statearr_18199_18217[(1)] = cljs.core.first((state_18174[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18218 = state_18174;
state_18174 = G__18218;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_18174){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_18174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18200 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18200[(6)] = c__2706__auto___18202);

return statearr_18200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__18219){
var map__18220 = p__18219;
var map__18220__$1 = cljs.core.__destructure_map(map__18220);
var node = map__18220__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18220__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var empty_set = fluree.db.flake.sorted_set_by(comparator);
var empty_node = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,empty_node);

return ch;
});
