// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
var G__22743_22746 = "XHTTP Request Error:";
var G__22744_22747 = e.request;
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__22743_22746,G__22744_22747) : fluree.db.util.log.error.call(null,G__22743_22746,G__22744_22747));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__22745 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__22745,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__22745;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__22748 = opts;
var map__22748__$1 = cljs.core.__destructure_map(map__22748);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__22748__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22748__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22748__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__22749 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__22749__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__22749,headers], 0)):G__22749);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__22749__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__22749__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json, :edn or :binary (default :text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__22750 = opts;
var map__22750__$1 = cljs.core.__destructure_map(map__22750);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__22750__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22750__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22750__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22750__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__22750__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__22751 = cljs.core.PersistentArrayMap.EMPTY;
var G__22751__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__22751,headers], 0)):G__22751);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__22751__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__22751__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__22752 = output_format;
var G__22752__$1 = (((G__22752 instanceof cljs.core.Keyword))?G__22752.fqn:null);
switch (G__22752__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__22754 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__22754,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__22754;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22786){
var state_val_22787 = (state_22786[(1)]);
if((state_val_22787 === (7))){
var inst_22782 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
var statearr_22788_22813 = state_22786__$1;
(statearr_22788_22813[(2)] = inst_22782);

(statearr_22788_22813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (1))){
var state_22786__$1 = state_22786;
var statearr_22789_22814 = state_22786__$1;
(statearr_22789_22814[(2)] = null);

(statearr_22789_22814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (4))){
var inst_22757 = (state_22786[(7)]);
var inst_22757__$1 = (state_22786[(2)]);
var inst_22758 = (inst_22757__$1 == null);
var state_22786__$1 = (function (){var statearr_22790 = state_22786;
(statearr_22790[(7)] = inst_22757__$1);

return statearr_22790;
})();
if(cljs.core.truth_(inst_22758)){
var statearr_22791_22815 = state_22786__$1;
(statearr_22791_22815[(1)] = (5));

} else {
var statearr_22792_22816 = state_22786__$1;
(statearr_22792_22816[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (6))){
var inst_22757 = (state_22786[(7)]);
var inst_22765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22757,(0),null);
var inst_22766 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22757,(1),null);
var state_22786__$1 = (function (){var statearr_22793 = state_22786;
(statearr_22793[(8)] = inst_22766);

(statearr_22793[(9)] = inst_22765);

return statearr_22793;
})();
var statearr_22794_22817 = state_22786__$1;
(statearr_22794_22817[(2)] = null);

(statearr_22794_22817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (3))){
var inst_22784 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22786__$1,inst_22784);
} else {
if((state_val_22787 === (2))){
var state_22786__$1 = state_22786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22786__$1,(4),pub_chan);
} else {
if((state_val_22787 === (11))){
var _ = (function (){var statearr_22796 = state_22786;
(statearr_22796[(4)] = cljs.core.rest((state_22786[(4)])));

return statearr_22796;
})();
var state_22786__$1 = state_22786;
var ex22795 = (state_22786__$1[(2)]);
var statearr_22797_22818 = state_22786__$1;
(statearr_22797_22818[(5)] = ex22795);


var statearr_22798_22819 = state_22786__$1;
(statearr_22798_22819[(1)] = (10));

(statearr_22798_22819[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (9))){
var inst_22779 = (state_22786[(2)]);
var state_22786__$1 = (function (){var statearr_22799 = state_22786;
(statearr_22799[(10)] = inst_22779);

return statearr_22799;
})();
var statearr_22800_22820 = state_22786__$1;
(statearr_22800_22820[(2)] = null);

(statearr_22800_22820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (5))){
var inst_22760 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1("Web socket pub/producer channel closed.") : fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed."));
var state_22786__$1 = state_22786;
var statearr_22801_22821 = state_22786__$1;
(statearr_22801_22821[(2)] = inst_22760);

(statearr_22801_22821[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (10))){
var inst_22766 = (state_22786[(8)]);
var inst_22765 = (state_22786[(9)]);
var inst_22767 = (state_22786[(2)]);
var inst_22768 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_22767,"Error sending websocket message:",inst_22765) : fluree.db.util.log.error.call(null,inst_22767,"Error sending websocket message:",inst_22765));
var inst_22769 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_22766,false);
var state_22786__$1 = (function (){var statearr_22802 = state_22786;
(statearr_22802[(11)] = inst_22768);

return statearr_22802;
})();
var statearr_22803_22822 = state_22786__$1;
(statearr_22803_22822[(2)] = inst_22769);

(statearr_22803_22822[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (8))){
var inst_22766 = (state_22786[(8)]);
var inst_22765 = (state_22786[(9)]);
var _ = (function (){var statearr_22804 = state_22786;
(statearr_22804[(4)] = cljs.core.cons((11),(state_22786[(4)])));

return statearr_22804;
})();
var inst_22775 = ws.send(inst_22765);
var inst_22776 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_22766,true);
var ___$1 = (function (){var statearr_22805 = state_22786;
(statearr_22805[(4)] = cljs.core.rest((state_22786[(4)])));

return statearr_22805;
})();
var state_22786__$1 = (function (){var statearr_22806 = state_22786;
(statearr_22806[(12)] = inst_22775);

return statearr_22806;
})();
var statearr_22807_22823 = state_22786__$1;
(statearr_22807_22823[(2)] = inst_22776);

(statearr_22807_22823[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0 = (function (){
var statearr_22808 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22808[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__);

(statearr_22808[(1)] = (1));

return statearr_22808;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1 = (function (state_22786){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_22786);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22809){var ex__2687__auto__ = e22809;
var statearr_22810_22824 = state_22786;
(statearr_22810_22824[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_22786[(4)]))){
var statearr_22811_22825 = state_22786;
(statearr_22811_22825[(1)] = cljs.core.first((state_22786[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22826 = state_22786;
state_22786 = G__22826;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__ = function(state_22786){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1.call(this,state_22786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22812 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_22812[(6)] = c__2706__auto__);

return statearr_22812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
var G__22827_22868 = "Websocket closed: ";
var G__22828_22869 = e.reason;
var G__22829_22870 = "Code: ";
var G__22830_22871 = e.code;
(fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4(G__22827_22868,G__22828_22869,G__22829_22870,G__22830_22871) : fluree.db.util.log.warn.call(null,G__22827_22868,G__22828_22869,G__22829_22870,G__22830_22871));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2706__auto___22872 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22855){
var state_val_22856 = (state_22855[(1)]);
if((state_val_22856 === (1))){
var inst_22834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22835 = [open_QMARK_,timeout_chan];
var inst_22836 = (new cljs.core.PersistentVector(null,2,(5),inst_22834,inst_22835,null));
var state_22855__$1 = state_22855;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_22855__$1,(2),inst_22836,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_22856 === (2))){
var inst_22838 = (state_22855[(2)]);
var inst_22839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22838,(0),null);
var inst_22840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22838,(1),null);
var inst_22841 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22840,timeout_chan);
var state_22855__$1 = (function (){var statearr_22857 = state_22855;
(statearr_22857[(7)] = inst_22839);

return statearr_22857;
})();
if(inst_22841){
var statearr_22858_22873 = state_22855__$1;
(statearr_22858_22873[(1)] = (3));

} else {
var statearr_22859_22874 = state_22855__$1;
(statearr_22859_22874[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22856 === (3))){
var inst_22843 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_22844 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22845 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_22846 = cljs.core.PersistentHashMap.fromArrays(inst_22844,inst_22845);
var inst_22847 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_22843,inst_22846);
var inst_22848 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_22847);
var inst_22849 = fluree.db.util.xhttp.close_websocket(ws);
var state_22855__$1 = (function (){var statearr_22860 = state_22855;
(statearr_22860[(8)] = inst_22848);

return statearr_22860;
})();
var statearr_22861_22875 = state_22855__$1;
(statearr_22861_22875[(2)] = inst_22849);

(statearr_22861_22875[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22856 === (4))){
var inst_22851 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_22855__$1 = state_22855;
var statearr_22862_22876 = state_22855__$1;
(statearr_22862_22876[(2)] = inst_22851);

(statearr_22862_22876[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22856 === (5))){
var inst_22853 = (state_22855[(2)]);
var state_22855__$1 = state_22855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22855__$1,inst_22853);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_22863 = [null,null,null,null,null,null,null,null,null];
(statearr_22863[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__);

(statearr_22863[(1)] = (1));

return statearr_22863;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1 = (function (state_22855){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_22855);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22864){var ex__2687__auto__ = e22864;
var statearr_22865_22877 = state_22855;
(statearr_22865_22877[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_22855[(4)]))){
var statearr_22866_22878 = state_22855;
(statearr_22866_22878[(1)] = cljs.core.first((state_22855[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22879 = state_22855;
state_22855 = G__22879;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__ = function(state_22855){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1.call(this,state_22855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22867 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_22867[(6)] = c__2706__auto___22872);

return statearr_22867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
