// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11133 = arguments.length;
switch (G__11133) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11134 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11134 = (function (f,blockable,meta11135){
this.f = f;
this.blockable = blockable;
this.meta11135 = meta11135;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11134.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11136,meta11135__$1){
var self__ = this;
var _11136__$1 = this;
return (new cljs.core.async.t_cljs$core$async11134(self__.f,self__.blockable,meta11135__$1));
}));

(cljs.core.async.t_cljs$core$async11134.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11136){
var self__ = this;
var _11136__$1 = this;
return self__.meta11135;
}));

(cljs.core.async.t_cljs$core$async11134.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11134.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11134.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async11134.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async11134.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11135","meta11135",-1211129709,null)], null);
}));

(cljs.core.async.t_cljs$core$async11134.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11134.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11134");

(cljs.core.async.t_cljs$core$async11134.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async11134");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11134.
 */
cljs.core.async.__GT_t_cljs$core$async11134 = (function cljs$core$async$__GT_t_cljs$core$async11134(f__$1,blockable__$1,meta11135){
return (new cljs.core.async.t_cljs$core$async11134(f__$1,blockable__$1,meta11135));
});

}

return (new cljs.core.async.t_cljs$core$async11134(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11140 = arguments.length;
switch (G__11140) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11143 = arguments.length;
switch (G__11143) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11146 = arguments.length;
switch (G__11146) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11148 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11148);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_11148);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11150 = arguments.length;
switch (G__11150) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___11152 = n;
var x_11153 = (0);
while(true){
if((x_11153 < n__5636__auto___11152)){
(a[x_11153] = x_11153);

var G__11154 = (x_11153 + (1));
x_11153 = G__11154;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11155 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11155 = (function (flag,meta11156){
this.flag = flag;
this.meta11156 = meta11156;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11155.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11157,meta11156__$1){
var self__ = this;
var _11157__$1 = this;
return (new cljs.core.async.t_cljs$core$async11155(self__.flag,meta11156__$1));
}));

(cljs.core.async.t_cljs$core$async11155.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11157){
var self__ = this;
var _11157__$1 = this;
return self__.meta11156;
}));

(cljs.core.async.t_cljs$core$async11155.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11155.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async11155.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11155.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async11155.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11156","meta11156",-2007345746,null)], null);
}));

(cljs.core.async.t_cljs$core$async11155.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11155.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11155");

(cljs.core.async.t_cljs$core$async11155.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async11155");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11155.
 */
cljs.core.async.__GT_t_cljs$core$async11155 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11155(flag__$1,meta11156){
return (new cljs.core.async.t_cljs$core$async11155(flag__$1,meta11156));
});

}

return (new cljs.core.async.t_cljs$core$async11155(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11158 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11158 = (function (flag,cb,meta11159){
this.flag = flag;
this.cb = cb;
this.meta11159 = meta11159;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11158.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11160,meta11159__$1){
var self__ = this;
var _11160__$1 = this;
return (new cljs.core.async.t_cljs$core$async11158(self__.flag,self__.cb,meta11159__$1));
}));

(cljs.core.async.t_cljs$core$async11158.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11160){
var self__ = this;
var _11160__$1 = this;
return self__.meta11159;
}));

(cljs.core.async.t_cljs$core$async11158.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11158.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async11158.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11158.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async11158.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11159","meta11159",1743190182,null)], null);
}));

(cljs.core.async.t_cljs$core$async11158.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11158.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11158");

(cljs.core.async.t_cljs$core$async11158.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async11158");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11158.
 */
cljs.core.async.__GT_t_cljs$core$async11158 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11158(flag__$1,cb__$1,meta11159){
return (new cljs.core.async.t_cljs$core$async11158(flag__$1,cb__$1,meta11159));
});

}

return (new cljs.core.async.t_cljs$core$async11158(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11161_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11161_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11162_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11162_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11163 = (i + (1));
i = G__11163;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___11168 = arguments.length;
var i__5770__auto___11169 = (0);
while(true){
if((i__5770__auto___11169 < len__5769__auto___11168)){
args__5775__auto__.push((arguments[i__5770__auto___11169]));

var G__11170 = (i__5770__auto___11169 + (1));
i__5770__auto___11169 = G__11170;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11166){
var map__11167 = p__11166;
var map__11167__$1 = cljs.core.__destructure_map.call(null,map__11167);
var opts = map__11167__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11164){
var G__11165 = cljs.core.first.call(null,seq11164);
var seq11164__$1 = cljs.core.next.call(null,seq11164);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11165,seq11164__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11172 = arguments.length;
switch (G__11172) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11073__auto___11219 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_11196){
var state_val_11197 = (state_11196[(1)]);
if((state_val_11197 === (7))){
var inst_11192 = (state_11196[(2)]);
var state_11196__$1 = state_11196;
var statearr_11198_11220 = state_11196__$1;
(statearr_11198_11220[(2)] = inst_11192);

(statearr_11198_11220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11197 === (1))){
var state_11196__$1 = state_11196;
var statearr_11199_11221 = state_11196__$1;
(statearr_11199_11221[(2)] = null);

(statearr_11199_11221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11197 === (4))){
var inst_11175 = (state_11196[(7)]);
var inst_11175__$1 = (state_11196[(2)]);
var inst_11176 = (inst_11175__$1 == null);
var state_11196__$1 = (function (){var statearr_11200 = state_11196;
(statearr_11200[(7)] = inst_11175__$1);

return statearr_11200;
})();
if(cljs.core.truth_(inst_11176)){
var statearr_11201_11222 = state_11196__$1;
(statearr_11201_11222[(1)] = (5));

} else {
var statearr_11202_11223 = state_11196__$1;
(statearr_11202_11223[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11197 === (13))){
var state_11196__$1 = state_11196;
var statearr_11203_11224 = state_11196__$1;
(statearr_11203_11224[(2)] = null);

(statearr_11203_11224[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11197 === (6))){
var inst_11175 = (state_11196[(7)]);
var state_11196__$1 = state_11196;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11196__$1,(11),to,inst_11175);
} else {
if((state_val_11197 === (3))){
var inst_11194 = (state_11196[(2)]);
var state_11196__$1 = state_11196;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11196__$1,inst_11194);
} else {
if((state_val_11197 === (12))){
var state_11196__$1 = state_11196;
var statearr_11204_11225 = state_11196__$1;
(statearr_11204_11225[(2)] = null);

(statearr_11204_11225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11197 === (2))){
var state_11196__$1 = state_11196;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11196__$1,(4),from);
} else {
if((state_val_11197 === (11))){
var inst_11185 = (state_11196[(2)]);
var state_11196__$1 = state_11196;
if(cljs.core.truth_(inst_11185)){
var statearr_11205_11226 = state_11196__$1;
(statearr_11205_11226[(1)] = (12));

} else {
var statearr_11206_11227 = state_11196__$1;
(statearr_11206_11227[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11197 === (9))){
var state_11196__$1 = state_11196;
var statearr_11207_11228 = state_11196__$1;
(statearr_11207_11228[(2)] = null);

(statearr_11207_11228[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11197 === (5))){
var state_11196__$1 = state_11196;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11208_11229 = state_11196__$1;
(statearr_11208_11229[(1)] = (8));

} else {
var statearr_11209_11230 = state_11196__$1;
(statearr_11209_11230[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11197 === (14))){
var inst_11190 = (state_11196[(2)]);
var state_11196__$1 = state_11196;
var statearr_11210_11231 = state_11196__$1;
(statearr_11210_11231[(2)] = inst_11190);

(statearr_11210_11231[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11197 === (10))){
var inst_11182 = (state_11196[(2)]);
var state_11196__$1 = state_11196;
var statearr_11211_11232 = state_11196__$1;
(statearr_11211_11232[(2)] = inst_11182);

(statearr_11211_11232[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11197 === (8))){
var inst_11179 = cljs.core.async.close_BANG_.call(null,to);
var state_11196__$1 = state_11196;
var statearr_11212_11233 = state_11196__$1;
(statearr_11212_11233[(2)] = inst_11179);

(statearr_11212_11233[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_11213 = [null,null,null,null,null,null,null,null];
(statearr_11213[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_11213[(1)] = (1));

return statearr_11213;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_11196){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11196);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11214){var ex__11003__auto__ = e11214;
var statearr_11215_11234 = state_11196;
(statearr_11215_11234[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11196[(4)]))){
var statearr_11216_11235 = state_11196;
(statearr_11216_11235[(1)] = cljs.core.first.call(null,(state_11196[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11236 = state_11196;
state_11196 = G__11236;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_11196){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_11196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_11217 = f__11074__auto__.call(null);
(statearr_11217[(6)] = c__11073__auto___11219);

return statearr_11217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process__$1 = (function (p__11237){
var vec__11238 = p__11237;
var v = cljs.core.nth.call(null,vec__11238,(0),null);
var p = cljs.core.nth.call(null,vec__11238,(1),null);
var job = vec__11238;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11073__auto___11414 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_11245){
var state_val_11246 = (state_11245[(1)]);
if((state_val_11246 === (1))){
var state_11245__$1 = state_11245;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11245__$1,(2),res,v);
} else {
if((state_val_11246 === (2))){
var inst_11242 = (state_11245[(2)]);
var inst_11243 = cljs.core.async.close_BANG_.call(null,res);
var state_11245__$1 = (function (){var statearr_11247 = state_11245;
(statearr_11247[(7)] = inst_11242);

return statearr_11247;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11245__$1,inst_11243);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0 = (function (){
var statearr_11248 = [null,null,null,null,null,null,null,null];
(statearr_11248[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__);

(statearr_11248[(1)] = (1));

return statearr_11248;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1 = (function (state_11245){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11249){var ex__11003__auto__ = e11249;
var statearr_11250_11415 = state_11245;
(statearr_11250_11415[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11245[(4)]))){
var statearr_11251_11416 = state_11245;
(statearr_11251_11416[(1)] = cljs.core.first.call(null,(state_11245[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11417 = state_11245;
state_11245 = G__11417;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__ = function(state_11245){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1.call(this,state_11245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_11252 = f__11074__auto__.call(null);
(statearr_11252[(6)] = c__11073__auto___11414);

return statearr_11252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__11253){
var vec__11254 = p__11253;
var v = cljs.core.nth.call(null,vec__11254,(0),null);
var p = cljs.core.nth.call(null,vec__11254,(1),null);
var job = vec__11254;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__5636__auto___11418 = n;
var __11419 = (0);
while(true){
if((__11419 < n__5636__auto___11418)){
var G__11257_11420 = type;
var G__11257_11421__$1 = (((G__11257_11420 instanceof cljs.core.Keyword))?G__11257_11420.fqn:null);
switch (G__11257_11421__$1) {
case "compute":
var c__11073__auto___11423 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11419,c__11073__auto___11423,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async){
return (function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = ((function (__11419,c__11073__auto___11423,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async){
return (function (state_11270){
var state_val_11271 = (state_11270[(1)]);
if((state_val_11271 === (1))){
var state_11270__$1 = state_11270;
var statearr_11272_11424 = state_11270__$1;
(statearr_11272_11424[(2)] = null);

(statearr_11272_11424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11271 === (2))){
var state_11270__$1 = state_11270;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11270__$1,(4),jobs);
} else {
if((state_val_11271 === (3))){
var inst_11268 = (state_11270[(2)]);
var state_11270__$1 = state_11270;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11270__$1,inst_11268);
} else {
if((state_val_11271 === (4))){
var inst_11260 = (state_11270[(2)]);
var inst_11261 = process__$1.call(null,inst_11260);
var state_11270__$1 = state_11270;
if(cljs.core.truth_(inst_11261)){
var statearr_11273_11425 = state_11270__$1;
(statearr_11273_11425[(1)] = (5));

} else {
var statearr_11274_11426 = state_11270__$1;
(statearr_11274_11426[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11271 === (5))){
var state_11270__$1 = state_11270;
var statearr_11275_11427 = state_11270__$1;
(statearr_11275_11427[(2)] = null);

(statearr_11275_11427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11271 === (6))){
var state_11270__$1 = state_11270;
var statearr_11276_11428 = state_11270__$1;
(statearr_11276_11428[(2)] = null);

(statearr_11276_11428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11271 === (7))){
var inst_11266 = (state_11270[(2)]);
var state_11270__$1 = state_11270;
var statearr_11277_11429 = state_11270__$1;
(statearr_11277_11429[(2)] = inst_11266);

(statearr_11277_11429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11419,c__11073__auto___11423,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async))
;
return ((function (__11419,switch__10999__auto__,c__11073__auto___11423,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0 = (function (){
var statearr_11278 = [null,null,null,null,null,null,null];
(statearr_11278[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__);

(statearr_11278[(1)] = (1));

return statearr_11278;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1 = (function (state_11270){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11270);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11279){var ex__11003__auto__ = e11279;
var statearr_11280_11430 = state_11270;
(statearr_11280_11430[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11270[(4)]))){
var statearr_11281_11431 = state_11270;
(statearr_11281_11431[(1)] = cljs.core.first.call(null,(state_11270[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11432 = state_11270;
state_11270 = G__11432;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__ = function(state_11270){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1.call(this,state_11270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__;
})()
;})(__11419,switch__10999__auto__,c__11073__auto___11423,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async))
})();
var state__11075__auto__ = (function (){var statearr_11282 = f__11074__auto__.call(null);
(statearr_11282[(6)] = c__11073__auto___11423);

return statearr_11282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(__11419,c__11073__auto___11423,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async))
);


break;
case "async":
var c__11073__auto___11433 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11419,c__11073__auto___11433,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async){
return (function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = ((function (__11419,c__11073__auto___11433,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async){
return (function (state_11295){
var state_val_11296 = (state_11295[(1)]);
if((state_val_11296 === (1))){
var state_11295__$1 = state_11295;
var statearr_11297_11434 = state_11295__$1;
(statearr_11297_11434[(2)] = null);

(statearr_11297_11434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11296 === (2))){
var state_11295__$1 = state_11295;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11295__$1,(4),jobs);
} else {
if((state_val_11296 === (3))){
var inst_11293 = (state_11295[(2)]);
var state_11295__$1 = state_11295;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11295__$1,inst_11293);
} else {
if((state_val_11296 === (4))){
var inst_11285 = (state_11295[(2)]);
var inst_11286 = async.call(null,inst_11285);
var state_11295__$1 = state_11295;
if(cljs.core.truth_(inst_11286)){
var statearr_11298_11435 = state_11295__$1;
(statearr_11298_11435[(1)] = (5));

} else {
var statearr_11299_11436 = state_11295__$1;
(statearr_11299_11436[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11296 === (5))){
var state_11295__$1 = state_11295;
var statearr_11300_11437 = state_11295__$1;
(statearr_11300_11437[(2)] = null);

(statearr_11300_11437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11296 === (6))){
var state_11295__$1 = state_11295;
var statearr_11301_11438 = state_11295__$1;
(statearr_11301_11438[(2)] = null);

(statearr_11301_11438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11296 === (7))){
var inst_11291 = (state_11295[(2)]);
var state_11295__$1 = state_11295;
var statearr_11302_11439 = state_11295__$1;
(statearr_11302_11439[(2)] = inst_11291);

(statearr_11302_11439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11419,c__11073__auto___11433,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async))
;
return ((function (__11419,switch__10999__auto__,c__11073__auto___11433,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0 = (function (){
var statearr_11303 = [null,null,null,null,null,null,null];
(statearr_11303[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__);

(statearr_11303[(1)] = (1));

return statearr_11303;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1 = (function (state_11295){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11295);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11304){var ex__11003__auto__ = e11304;
var statearr_11305_11440 = state_11295;
(statearr_11305_11440[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11295[(4)]))){
var statearr_11306_11441 = state_11295;
(statearr_11306_11441[(1)] = cljs.core.first.call(null,(state_11295[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11442 = state_11295;
state_11295 = G__11442;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__ = function(state_11295){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1.call(this,state_11295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__;
})()
;})(__11419,switch__10999__auto__,c__11073__auto___11433,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async))
})();
var state__11075__auto__ = (function (){var statearr_11307 = f__11074__auto__.call(null);
(statearr_11307[(6)] = c__11073__auto___11433);

return statearr_11307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(__11419,c__11073__auto___11433,G__11257_11420,G__11257_11421__$1,n__5636__auto___11418,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11257_11421__$1)].join('')));

}

var G__11443 = (__11419 + (1));
__11419 = G__11443;
continue;
} else {
}
break;
}

var c__11073__auto___11444 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_11329){
var state_val_11330 = (state_11329[(1)]);
if((state_val_11330 === (7))){
var inst_11325 = (state_11329[(2)]);
var state_11329__$1 = state_11329;
var statearr_11331_11445 = state_11329__$1;
(statearr_11331_11445[(2)] = inst_11325);

(statearr_11331_11445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11330 === (1))){
var state_11329__$1 = state_11329;
var statearr_11332_11446 = state_11329__$1;
(statearr_11332_11446[(2)] = null);

(statearr_11332_11446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11330 === (4))){
var inst_11310 = (state_11329[(7)]);
var inst_11310__$1 = (state_11329[(2)]);
var inst_11311 = (inst_11310__$1 == null);
var state_11329__$1 = (function (){var statearr_11333 = state_11329;
(statearr_11333[(7)] = inst_11310__$1);

return statearr_11333;
})();
if(cljs.core.truth_(inst_11311)){
var statearr_11334_11447 = state_11329__$1;
(statearr_11334_11447[(1)] = (5));

} else {
var statearr_11335_11448 = state_11329__$1;
(statearr_11335_11448[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11330 === (6))){
var inst_11310 = (state_11329[(7)]);
var inst_11315 = (state_11329[(8)]);
var inst_11315__$1 = cljs.core.async.chan.call(null,(1));
var inst_11316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11317 = [inst_11310,inst_11315__$1];
var inst_11318 = (new cljs.core.PersistentVector(null,2,(5),inst_11316,inst_11317,null));
var state_11329__$1 = (function (){var statearr_11336 = state_11329;
(statearr_11336[(8)] = inst_11315__$1);

return statearr_11336;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11329__$1,(8),jobs,inst_11318);
} else {
if((state_val_11330 === (3))){
var inst_11327 = (state_11329[(2)]);
var state_11329__$1 = state_11329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11329__$1,inst_11327);
} else {
if((state_val_11330 === (2))){
var state_11329__$1 = state_11329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11329__$1,(4),from);
} else {
if((state_val_11330 === (9))){
var inst_11322 = (state_11329[(2)]);
var state_11329__$1 = (function (){var statearr_11337 = state_11329;
(statearr_11337[(9)] = inst_11322);

return statearr_11337;
})();
var statearr_11338_11449 = state_11329__$1;
(statearr_11338_11449[(2)] = null);

(statearr_11338_11449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11330 === (5))){
var inst_11313 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11329__$1 = state_11329;
var statearr_11339_11450 = state_11329__$1;
(statearr_11339_11450[(2)] = inst_11313);

(statearr_11339_11450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11330 === (8))){
var inst_11315 = (state_11329[(8)]);
var inst_11320 = (state_11329[(2)]);
var state_11329__$1 = (function (){var statearr_11340 = state_11329;
(statearr_11340[(10)] = inst_11320);

return statearr_11340;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11329__$1,(9),results,inst_11315);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0 = (function (){
var statearr_11341 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11341[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__);

(statearr_11341[(1)] = (1));

return statearr_11341;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1 = (function (state_11329){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11342){var ex__11003__auto__ = e11342;
var statearr_11343_11451 = state_11329;
(statearr_11343_11451[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11329[(4)]))){
var statearr_11344_11452 = state_11329;
(statearr_11344_11452[(1)] = cljs.core.first.call(null,(state_11329[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11453 = state_11329;
state_11329 = G__11453;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__ = function(state_11329){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1.call(this,state_11329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_11345 = f__11074__auto__.call(null);
(statearr_11345[(6)] = c__11073__auto___11444);

return statearr_11345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_11383){
var state_val_11384 = (state_11383[(1)]);
if((state_val_11384 === (7))){
var inst_11379 = (state_11383[(2)]);
var state_11383__$1 = state_11383;
var statearr_11385_11454 = state_11383__$1;
(statearr_11385_11454[(2)] = inst_11379);

(statearr_11385_11454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (20))){
var state_11383__$1 = state_11383;
var statearr_11386_11455 = state_11383__$1;
(statearr_11386_11455[(2)] = null);

(statearr_11386_11455[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (1))){
var state_11383__$1 = state_11383;
var statearr_11387_11456 = state_11383__$1;
(statearr_11387_11456[(2)] = null);

(statearr_11387_11456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (4))){
var inst_11348 = (state_11383[(7)]);
var inst_11348__$1 = (state_11383[(2)]);
var inst_11349 = (inst_11348__$1 == null);
var state_11383__$1 = (function (){var statearr_11388 = state_11383;
(statearr_11388[(7)] = inst_11348__$1);

return statearr_11388;
})();
if(cljs.core.truth_(inst_11349)){
var statearr_11389_11457 = state_11383__$1;
(statearr_11389_11457[(1)] = (5));

} else {
var statearr_11390_11458 = state_11383__$1;
(statearr_11390_11458[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (15))){
var inst_11361 = (state_11383[(8)]);
var state_11383__$1 = state_11383;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11383__$1,(18),to,inst_11361);
} else {
if((state_val_11384 === (21))){
var inst_11374 = (state_11383[(2)]);
var state_11383__$1 = state_11383;
var statearr_11391_11459 = state_11383__$1;
(statearr_11391_11459[(2)] = inst_11374);

(statearr_11391_11459[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (13))){
var inst_11376 = (state_11383[(2)]);
var state_11383__$1 = (function (){var statearr_11392 = state_11383;
(statearr_11392[(9)] = inst_11376);

return statearr_11392;
})();
var statearr_11393_11460 = state_11383__$1;
(statearr_11393_11460[(2)] = null);

(statearr_11393_11460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (6))){
var inst_11348 = (state_11383[(7)]);
var state_11383__$1 = state_11383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11383__$1,(11),inst_11348);
} else {
if((state_val_11384 === (17))){
var inst_11369 = (state_11383[(2)]);
var state_11383__$1 = state_11383;
if(cljs.core.truth_(inst_11369)){
var statearr_11394_11461 = state_11383__$1;
(statearr_11394_11461[(1)] = (19));

} else {
var statearr_11395_11462 = state_11383__$1;
(statearr_11395_11462[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (3))){
var inst_11381 = (state_11383[(2)]);
var state_11383__$1 = state_11383;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11383__$1,inst_11381);
} else {
if((state_val_11384 === (12))){
var inst_11358 = (state_11383[(10)]);
var state_11383__$1 = state_11383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11383__$1,(14),inst_11358);
} else {
if((state_val_11384 === (2))){
var state_11383__$1 = state_11383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11383__$1,(4),results);
} else {
if((state_val_11384 === (19))){
var state_11383__$1 = state_11383;
var statearr_11396_11463 = state_11383__$1;
(statearr_11396_11463[(2)] = null);

(statearr_11396_11463[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (11))){
var inst_11358 = (state_11383[(2)]);
var state_11383__$1 = (function (){var statearr_11397 = state_11383;
(statearr_11397[(10)] = inst_11358);

return statearr_11397;
})();
var statearr_11398_11464 = state_11383__$1;
(statearr_11398_11464[(2)] = null);

(statearr_11398_11464[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (9))){
var state_11383__$1 = state_11383;
var statearr_11399_11465 = state_11383__$1;
(statearr_11399_11465[(2)] = null);

(statearr_11399_11465[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (5))){
var state_11383__$1 = state_11383;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11400_11466 = state_11383__$1;
(statearr_11400_11466[(1)] = (8));

} else {
var statearr_11401_11467 = state_11383__$1;
(statearr_11401_11467[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (14))){
var inst_11361 = (state_11383[(8)]);
var inst_11363 = (state_11383[(11)]);
var inst_11361__$1 = (state_11383[(2)]);
var inst_11362 = (inst_11361__$1 == null);
var inst_11363__$1 = cljs.core.not.call(null,inst_11362);
var state_11383__$1 = (function (){var statearr_11402 = state_11383;
(statearr_11402[(8)] = inst_11361__$1);

(statearr_11402[(11)] = inst_11363__$1);

return statearr_11402;
})();
if(inst_11363__$1){
var statearr_11403_11468 = state_11383__$1;
(statearr_11403_11468[(1)] = (15));

} else {
var statearr_11404_11469 = state_11383__$1;
(statearr_11404_11469[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (16))){
var inst_11363 = (state_11383[(11)]);
var state_11383__$1 = state_11383;
var statearr_11405_11470 = state_11383__$1;
(statearr_11405_11470[(2)] = inst_11363);

(statearr_11405_11470[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (10))){
var inst_11355 = (state_11383[(2)]);
var state_11383__$1 = state_11383;
var statearr_11406_11471 = state_11383__$1;
(statearr_11406_11471[(2)] = inst_11355);

(statearr_11406_11471[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (18))){
var inst_11366 = (state_11383[(2)]);
var state_11383__$1 = state_11383;
var statearr_11407_11472 = state_11383__$1;
(statearr_11407_11472[(2)] = inst_11366);

(statearr_11407_11472[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11384 === (8))){
var inst_11352 = cljs.core.async.close_BANG_.call(null,to);
var state_11383__$1 = state_11383;
var statearr_11408_11473 = state_11383__$1;
(statearr_11408_11473[(2)] = inst_11352);

(statearr_11408_11473[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0 = (function (){
var statearr_11409 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11409[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__);

(statearr_11409[(1)] = (1));

return statearr_11409;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1 = (function (state_11383){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11383);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11410){var ex__11003__auto__ = e11410;
var statearr_11411_11474 = state_11383;
(statearr_11411_11474[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11383[(4)]))){
var statearr_11412_11475 = state_11383;
(statearr_11412_11475[(1)] = cljs.core.first.call(null,(state_11383[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11476 = state_11383;
state_11383 = G__11476;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__ = function(state_11383){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1.call(this,state_11383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11000__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_11413 = f__11074__auto__.call(null);
(statearr_11413[(6)] = c__11073__auto__);

return statearr_11413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));

return c__11073__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11478 = arguments.length;
switch (G__11478) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11481 = arguments.length;
switch (G__11481) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11484 = arguments.length;
switch (G__11484) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11073__auto___11534 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_11510){
var state_val_11511 = (state_11510[(1)]);
if((state_val_11511 === (7))){
var inst_11506 = (state_11510[(2)]);
var state_11510__$1 = state_11510;
var statearr_11512_11535 = state_11510__$1;
(statearr_11512_11535[(2)] = inst_11506);

(statearr_11512_11535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11511 === (1))){
var state_11510__$1 = state_11510;
var statearr_11513_11536 = state_11510__$1;
(statearr_11513_11536[(2)] = null);

(statearr_11513_11536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11511 === (4))){
var inst_11487 = (state_11510[(7)]);
var inst_11487__$1 = (state_11510[(2)]);
var inst_11488 = (inst_11487__$1 == null);
var state_11510__$1 = (function (){var statearr_11514 = state_11510;
(statearr_11514[(7)] = inst_11487__$1);

return statearr_11514;
})();
if(cljs.core.truth_(inst_11488)){
var statearr_11515_11537 = state_11510__$1;
(statearr_11515_11537[(1)] = (5));

} else {
var statearr_11516_11538 = state_11510__$1;
(statearr_11516_11538[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11511 === (13))){
var state_11510__$1 = state_11510;
var statearr_11517_11539 = state_11510__$1;
(statearr_11517_11539[(2)] = null);

(statearr_11517_11539[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11511 === (6))){
var inst_11487 = (state_11510[(7)]);
var inst_11493 = p.call(null,inst_11487);
var state_11510__$1 = state_11510;
if(cljs.core.truth_(inst_11493)){
var statearr_11518_11540 = state_11510__$1;
(statearr_11518_11540[(1)] = (9));

} else {
var statearr_11519_11541 = state_11510__$1;
(statearr_11519_11541[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11511 === (3))){
var inst_11508 = (state_11510[(2)]);
var state_11510__$1 = state_11510;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11510__$1,inst_11508);
} else {
if((state_val_11511 === (12))){
var state_11510__$1 = state_11510;
var statearr_11520_11542 = state_11510__$1;
(statearr_11520_11542[(2)] = null);

(statearr_11520_11542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11511 === (2))){
var state_11510__$1 = state_11510;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11510__$1,(4),ch);
} else {
if((state_val_11511 === (11))){
var inst_11487 = (state_11510[(7)]);
var inst_11497 = (state_11510[(2)]);
var state_11510__$1 = state_11510;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11510__$1,(8),inst_11497,inst_11487);
} else {
if((state_val_11511 === (9))){
var state_11510__$1 = state_11510;
var statearr_11521_11543 = state_11510__$1;
(statearr_11521_11543[(2)] = tc);

(statearr_11521_11543[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11511 === (5))){
var inst_11490 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11491 = cljs.core.async.close_BANG_.call(null,fc);
var state_11510__$1 = (function (){var statearr_11522 = state_11510;
(statearr_11522[(8)] = inst_11490);

return statearr_11522;
})();
var statearr_11523_11544 = state_11510__$1;
(statearr_11523_11544[(2)] = inst_11491);

(statearr_11523_11544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11511 === (14))){
var inst_11504 = (state_11510[(2)]);
var state_11510__$1 = state_11510;
var statearr_11524_11545 = state_11510__$1;
(statearr_11524_11545[(2)] = inst_11504);

(statearr_11524_11545[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11511 === (10))){
var state_11510__$1 = state_11510;
var statearr_11525_11546 = state_11510__$1;
(statearr_11525_11546[(2)] = fc);

(statearr_11525_11546[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11511 === (8))){
var inst_11499 = (state_11510[(2)]);
var state_11510__$1 = state_11510;
if(cljs.core.truth_(inst_11499)){
var statearr_11526_11547 = state_11510__$1;
(statearr_11526_11547[(1)] = (12));

} else {
var statearr_11527_11548 = state_11510__$1;
(statearr_11527_11548[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_11528 = [null,null,null,null,null,null,null,null,null];
(statearr_11528[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_11528[(1)] = (1));

return statearr_11528;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_11510){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11510);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11529){var ex__11003__auto__ = e11529;
var statearr_11530_11549 = state_11510;
(statearr_11530_11549[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11510[(4)]))){
var statearr_11531_11550 = state_11510;
(statearr_11531_11550[(1)] = cljs.core.first.call(null,(state_11510[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11551 = state_11510;
state_11510 = G__11551;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_11510){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_11510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_11532 = f__11074__auto__.call(null);
(statearr_11532[(6)] = c__11073__auto___11534);

return statearr_11532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_11573){
var state_val_11574 = (state_11573[(1)]);
if((state_val_11574 === (7))){
var inst_11569 = (state_11573[(2)]);
var state_11573__$1 = state_11573;
var statearr_11575_11594 = state_11573__$1;
(statearr_11575_11594[(2)] = inst_11569);

(statearr_11575_11594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (1))){
var inst_11552 = init;
var inst_11553 = inst_11552;
var state_11573__$1 = (function (){var statearr_11576 = state_11573;
(statearr_11576[(7)] = inst_11553);

return statearr_11576;
})();
var statearr_11577_11595 = state_11573__$1;
(statearr_11577_11595[(2)] = null);

(statearr_11577_11595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (4))){
var inst_11556 = (state_11573[(8)]);
var inst_11556__$1 = (state_11573[(2)]);
var inst_11557 = (inst_11556__$1 == null);
var state_11573__$1 = (function (){var statearr_11578 = state_11573;
(statearr_11578[(8)] = inst_11556__$1);

return statearr_11578;
})();
if(cljs.core.truth_(inst_11557)){
var statearr_11579_11596 = state_11573__$1;
(statearr_11579_11596[(1)] = (5));

} else {
var statearr_11580_11597 = state_11573__$1;
(statearr_11580_11597[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (6))){
var inst_11556 = (state_11573[(8)]);
var inst_11560 = (state_11573[(9)]);
var inst_11553 = (state_11573[(7)]);
var inst_11560__$1 = f.call(null,inst_11553,inst_11556);
var inst_11561 = cljs.core.reduced_QMARK_.call(null,inst_11560__$1);
var state_11573__$1 = (function (){var statearr_11581 = state_11573;
(statearr_11581[(9)] = inst_11560__$1);

return statearr_11581;
})();
if(inst_11561){
var statearr_11582_11598 = state_11573__$1;
(statearr_11582_11598[(1)] = (8));

} else {
var statearr_11583_11599 = state_11573__$1;
(statearr_11583_11599[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (3))){
var inst_11571 = (state_11573[(2)]);
var state_11573__$1 = state_11573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11573__$1,inst_11571);
} else {
if((state_val_11574 === (2))){
var state_11573__$1 = state_11573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11573__$1,(4),ch);
} else {
if((state_val_11574 === (9))){
var inst_11560 = (state_11573[(9)]);
var inst_11553 = inst_11560;
var state_11573__$1 = (function (){var statearr_11584 = state_11573;
(statearr_11584[(7)] = inst_11553);

return statearr_11584;
})();
var statearr_11585_11600 = state_11573__$1;
(statearr_11585_11600[(2)] = null);

(statearr_11585_11600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (5))){
var inst_11553 = (state_11573[(7)]);
var state_11573__$1 = state_11573;
var statearr_11586_11601 = state_11573__$1;
(statearr_11586_11601[(2)] = inst_11553);

(statearr_11586_11601[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (10))){
var inst_11567 = (state_11573[(2)]);
var state_11573__$1 = state_11573;
var statearr_11587_11602 = state_11573__$1;
(statearr_11587_11602[(2)] = inst_11567);

(statearr_11587_11602[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11574 === (8))){
var inst_11560 = (state_11573[(9)]);
var inst_11563 = cljs.core.deref.call(null,inst_11560);
var state_11573__$1 = state_11573;
var statearr_11588_11603 = state_11573__$1;
(statearr_11588_11603[(2)] = inst_11563);

(statearr_11588_11603[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__11000__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11000__auto____0 = (function (){
var statearr_11589 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11589[(0)] = cljs$core$async$reduce_$_state_machine__11000__auto__);

(statearr_11589[(1)] = (1));

return statearr_11589;
});
var cljs$core$async$reduce_$_state_machine__11000__auto____1 = (function (state_11573){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11590){var ex__11003__auto__ = e11590;
var statearr_11591_11604 = state_11573;
(statearr_11591_11604[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11573[(4)]))){
var statearr_11592_11605 = state_11573;
(statearr_11592_11605[(1)] = cljs.core.first.call(null,(state_11573[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11606 = state_11573;
state_11573 = G__11606;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11000__auto__ = function(state_11573){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11000__auto____1.call(this,state_11573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11000__auto____0;
cljs$core$async$reduce_$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11000__auto____1;
return cljs$core$async$reduce_$_state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_11593 = f__11074__auto__.call(null);
(statearr_11593[(6)] = c__11073__auto__);

return statearr_11593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));

return c__11073__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_11612){
var state_val_11613 = (state_11612[(1)]);
if((state_val_11613 === (1))){
var inst_11607 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_11612__$1 = state_11612;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11612__$1,(2),inst_11607);
} else {
if((state_val_11613 === (2))){
var inst_11609 = (state_11612[(2)]);
var inst_11610 = f__$1.call(null,inst_11609);
var state_11612__$1 = state_11612;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11612__$1,inst_11610);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__11000__auto__ = null;
var cljs$core$async$transduce_$_state_machine__11000__auto____0 = (function (){
var statearr_11614 = [null,null,null,null,null,null,null];
(statearr_11614[(0)] = cljs$core$async$transduce_$_state_machine__11000__auto__);

(statearr_11614[(1)] = (1));

return statearr_11614;
});
var cljs$core$async$transduce_$_state_machine__11000__auto____1 = (function (state_11612){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11612);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11615){var ex__11003__auto__ = e11615;
var statearr_11616_11619 = state_11612;
(statearr_11616_11619[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11612[(4)]))){
var statearr_11617_11620 = state_11612;
(statearr_11617_11620[(1)] = cljs.core.first.call(null,(state_11612[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11621 = state_11612;
state_11612 = G__11621;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__11000__auto__ = function(state_11612){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__11000__auto____1.call(this,state_11612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__11000__auto____0;
cljs$core$async$transduce_$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__11000__auto____1;
return cljs$core$async$transduce_$_state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_11618 = f__11074__auto__.call(null);
(statearr_11618[(6)] = c__11073__auto__);

return statearr_11618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));

return c__11073__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__11623 = arguments.length;
switch (G__11623) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_11648){
var state_val_11649 = (state_11648[(1)]);
if((state_val_11649 === (7))){
var inst_11630 = (state_11648[(2)]);
var state_11648__$1 = state_11648;
var statearr_11650_11672 = state_11648__$1;
(statearr_11650_11672[(2)] = inst_11630);

(statearr_11650_11672[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11649 === (1))){
var inst_11624 = cljs.core.seq.call(null,coll);
var inst_11625 = inst_11624;
var state_11648__$1 = (function (){var statearr_11651 = state_11648;
(statearr_11651[(7)] = inst_11625);

return statearr_11651;
})();
var statearr_11652_11673 = state_11648__$1;
(statearr_11652_11673[(2)] = null);

(statearr_11652_11673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11649 === (4))){
var inst_11625 = (state_11648[(7)]);
var inst_11628 = cljs.core.first.call(null,inst_11625);
var state_11648__$1 = state_11648;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11648__$1,(7),ch,inst_11628);
} else {
if((state_val_11649 === (13))){
var inst_11642 = (state_11648[(2)]);
var state_11648__$1 = state_11648;
var statearr_11653_11674 = state_11648__$1;
(statearr_11653_11674[(2)] = inst_11642);

(statearr_11653_11674[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11649 === (6))){
var inst_11633 = (state_11648[(2)]);
var state_11648__$1 = state_11648;
if(cljs.core.truth_(inst_11633)){
var statearr_11654_11675 = state_11648__$1;
(statearr_11654_11675[(1)] = (8));

} else {
var statearr_11655_11676 = state_11648__$1;
(statearr_11655_11676[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11649 === (3))){
var inst_11646 = (state_11648[(2)]);
var state_11648__$1 = state_11648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11648__$1,inst_11646);
} else {
if((state_val_11649 === (12))){
var state_11648__$1 = state_11648;
var statearr_11656_11677 = state_11648__$1;
(statearr_11656_11677[(2)] = null);

(statearr_11656_11677[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11649 === (2))){
var inst_11625 = (state_11648[(7)]);
var state_11648__$1 = state_11648;
if(cljs.core.truth_(inst_11625)){
var statearr_11657_11678 = state_11648__$1;
(statearr_11657_11678[(1)] = (4));

} else {
var statearr_11658_11679 = state_11648__$1;
(statearr_11658_11679[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11649 === (11))){
var inst_11639 = cljs.core.async.close_BANG_.call(null,ch);
var state_11648__$1 = state_11648;
var statearr_11659_11680 = state_11648__$1;
(statearr_11659_11680[(2)] = inst_11639);

(statearr_11659_11680[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11649 === (9))){
var state_11648__$1 = state_11648;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11660_11681 = state_11648__$1;
(statearr_11660_11681[(1)] = (11));

} else {
var statearr_11661_11682 = state_11648__$1;
(statearr_11661_11682[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11649 === (5))){
var inst_11625 = (state_11648[(7)]);
var state_11648__$1 = state_11648;
var statearr_11662_11683 = state_11648__$1;
(statearr_11662_11683[(2)] = inst_11625);

(statearr_11662_11683[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11649 === (10))){
var inst_11644 = (state_11648[(2)]);
var state_11648__$1 = state_11648;
var statearr_11663_11684 = state_11648__$1;
(statearr_11663_11684[(2)] = inst_11644);

(statearr_11663_11684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11649 === (8))){
var inst_11625 = (state_11648[(7)]);
var inst_11635 = cljs.core.next.call(null,inst_11625);
var inst_11625__$1 = inst_11635;
var state_11648__$1 = (function (){var statearr_11664 = state_11648;
(statearr_11664[(7)] = inst_11625__$1);

return statearr_11664;
})();
var statearr_11665_11685 = state_11648__$1;
(statearr_11665_11685[(2)] = null);

(statearr_11665_11685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_11666 = [null,null,null,null,null,null,null,null];
(statearr_11666[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_11666[(1)] = (1));

return statearr_11666;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_11648){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11667){var ex__11003__auto__ = e11667;
var statearr_11668_11686 = state_11648;
(statearr_11668_11686[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11648[(4)]))){
var statearr_11669_11687 = state_11648;
(statearr_11669_11687[(1)] = cljs.core.first.call(null,(state_11648[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11688 = state_11648;
state_11648 = G__11688;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_11648){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_11648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_11670 = f__11074__auto__.call(null);
(statearr_11670[(6)] = c__11073__auto__);

return statearr_11670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));

return c__11073__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__11690 = arguments.length;
switch (G__11690) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_11692 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,_);
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_11692.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_11693 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_11693.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_11694 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,ch);
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_11694.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_11695 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m);
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_11695.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11696 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11696 = (function (ch,cs,meta11697){
this.ch = ch;
this.cs = cs;
this.meta11697 = meta11697;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11696.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11698,meta11697__$1){
var self__ = this;
var _11698__$1 = this;
return (new cljs.core.async.t_cljs$core$async11696(self__.ch,self__.cs,meta11697__$1));
}));

(cljs.core.async.t_cljs$core$async11696.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11698){
var self__ = this;
var _11698__$1 = this;
return self__.meta11697;
}));

(cljs.core.async.t_cljs$core$async11696.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11696.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async11696.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11696.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async11696.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async11696.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async11696.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta11697","meta11697",-1263159049,null)], null);
}));

(cljs.core.async.t_cljs$core$async11696.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11696.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11696");

(cljs.core.async.t_cljs$core$async11696.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async11696");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11696.
 */
cljs.core.async.__GT_t_cljs$core$async11696 = (function cljs$core$async$mult_$___GT_t_cljs$core$async11696(ch__$1,cs__$1,meta11697){
return (new cljs.core.async.t_cljs$core$async11696(ch__$1,cs__$1,meta11697));
});

}

return (new cljs.core.async.t_cljs$core$async11696(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__11073__auto___11915 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_11831){
var state_val_11832 = (state_11831[(1)]);
if((state_val_11832 === (7))){
var inst_11827 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11833_11916 = state_11831__$1;
(statearr_11833_11916[(2)] = inst_11827);

(statearr_11833_11916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (20))){
var inst_11732 = (state_11831[(7)]);
var inst_11744 = cljs.core.first.call(null,inst_11732);
var inst_11745 = cljs.core.nth.call(null,inst_11744,(0),null);
var inst_11746 = cljs.core.nth.call(null,inst_11744,(1),null);
var state_11831__$1 = (function (){var statearr_11834 = state_11831;
(statearr_11834[(8)] = inst_11745);

return statearr_11834;
})();
if(cljs.core.truth_(inst_11746)){
var statearr_11835_11917 = state_11831__$1;
(statearr_11835_11917[(1)] = (22));

} else {
var statearr_11836_11918 = state_11831__$1;
(statearr_11836_11918[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (27))){
var inst_11701 = (state_11831[(9)]);
var inst_11774 = (state_11831[(10)]);
var inst_11776 = (state_11831[(11)]);
var inst_11781 = (state_11831[(12)]);
var inst_11781__$1 = cljs.core._nth.call(null,inst_11774,inst_11776);
var inst_11782 = cljs.core.async.put_BANG_.call(null,inst_11781__$1,inst_11701,done);
var state_11831__$1 = (function (){var statearr_11837 = state_11831;
(statearr_11837[(12)] = inst_11781__$1);

return statearr_11837;
})();
if(cljs.core.truth_(inst_11782)){
var statearr_11838_11919 = state_11831__$1;
(statearr_11838_11919[(1)] = (30));

} else {
var statearr_11839_11920 = state_11831__$1;
(statearr_11839_11920[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (1))){
var state_11831__$1 = state_11831;
var statearr_11840_11921 = state_11831__$1;
(statearr_11840_11921[(2)] = null);

(statearr_11840_11921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (24))){
var inst_11732 = (state_11831[(7)]);
var inst_11751 = (state_11831[(2)]);
var inst_11752 = cljs.core.next.call(null,inst_11732);
var inst_11710 = inst_11752;
var inst_11711 = null;
var inst_11712 = (0);
var inst_11713 = (0);
var state_11831__$1 = (function (){var statearr_11841 = state_11831;
(statearr_11841[(13)] = inst_11713);

(statearr_11841[(14)] = inst_11710);

(statearr_11841[(15)] = inst_11711);

(statearr_11841[(16)] = inst_11751);

(statearr_11841[(17)] = inst_11712);

return statearr_11841;
})();
var statearr_11842_11922 = state_11831__$1;
(statearr_11842_11922[(2)] = null);

(statearr_11842_11922[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (39))){
var state_11831__$1 = state_11831;
var statearr_11846_11923 = state_11831__$1;
(statearr_11846_11923[(2)] = null);

(statearr_11846_11923[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (4))){
var inst_11701 = (state_11831[(9)]);
var inst_11701__$1 = (state_11831[(2)]);
var inst_11702 = (inst_11701__$1 == null);
var state_11831__$1 = (function (){var statearr_11847 = state_11831;
(statearr_11847[(9)] = inst_11701__$1);

return statearr_11847;
})();
if(cljs.core.truth_(inst_11702)){
var statearr_11848_11924 = state_11831__$1;
(statearr_11848_11924[(1)] = (5));

} else {
var statearr_11849_11925 = state_11831__$1;
(statearr_11849_11925[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (15))){
var inst_11713 = (state_11831[(13)]);
var inst_11710 = (state_11831[(14)]);
var inst_11711 = (state_11831[(15)]);
var inst_11712 = (state_11831[(17)]);
var inst_11728 = (state_11831[(2)]);
var inst_11729 = (inst_11713 + (1));
var tmp11843 = inst_11710;
var tmp11844 = inst_11711;
var tmp11845 = inst_11712;
var inst_11710__$1 = tmp11843;
var inst_11711__$1 = tmp11844;
var inst_11712__$1 = tmp11845;
var inst_11713__$1 = inst_11729;
var state_11831__$1 = (function (){var statearr_11850 = state_11831;
(statearr_11850[(13)] = inst_11713__$1);

(statearr_11850[(14)] = inst_11710__$1);

(statearr_11850[(15)] = inst_11711__$1);

(statearr_11850[(18)] = inst_11728);

(statearr_11850[(17)] = inst_11712__$1);

return statearr_11850;
})();
var statearr_11851_11926 = state_11831__$1;
(statearr_11851_11926[(2)] = null);

(statearr_11851_11926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (21))){
var inst_11755 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11855_11927 = state_11831__$1;
(statearr_11855_11927[(2)] = inst_11755);

(statearr_11855_11927[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (31))){
var inst_11781 = (state_11831[(12)]);
var inst_11785 = cljs.core.async.untap_STAR_.call(null,m,inst_11781);
var state_11831__$1 = state_11831;
var statearr_11856_11928 = state_11831__$1;
(statearr_11856_11928[(2)] = inst_11785);

(statearr_11856_11928[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (32))){
var inst_11775 = (state_11831[(19)]);
var inst_11773 = (state_11831[(20)]);
var inst_11774 = (state_11831[(10)]);
var inst_11776 = (state_11831[(11)]);
var inst_11787 = (state_11831[(2)]);
var inst_11788 = (inst_11776 + (1));
var tmp11852 = inst_11775;
var tmp11853 = inst_11773;
var tmp11854 = inst_11774;
var inst_11773__$1 = tmp11853;
var inst_11774__$1 = tmp11854;
var inst_11775__$1 = tmp11852;
var inst_11776__$1 = inst_11788;
var state_11831__$1 = (function (){var statearr_11857 = state_11831;
(statearr_11857[(19)] = inst_11775__$1);

(statearr_11857[(20)] = inst_11773__$1);

(statearr_11857[(21)] = inst_11787);

(statearr_11857[(10)] = inst_11774__$1);

(statearr_11857[(11)] = inst_11776__$1);

return statearr_11857;
})();
var statearr_11858_11929 = state_11831__$1;
(statearr_11858_11929[(2)] = null);

(statearr_11858_11929[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (40))){
var inst_11800 = (state_11831[(22)]);
var inst_11804 = cljs.core.async.untap_STAR_.call(null,m,inst_11800);
var state_11831__$1 = state_11831;
var statearr_11859_11930 = state_11831__$1;
(statearr_11859_11930[(2)] = inst_11804);

(statearr_11859_11930[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (33))){
var inst_11791 = (state_11831[(23)]);
var inst_11793 = cljs.core.chunked_seq_QMARK_.call(null,inst_11791);
var state_11831__$1 = state_11831;
if(inst_11793){
var statearr_11860_11931 = state_11831__$1;
(statearr_11860_11931[(1)] = (36));

} else {
var statearr_11861_11932 = state_11831__$1;
(statearr_11861_11932[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (13))){
var inst_11722 = (state_11831[(24)]);
var inst_11725 = cljs.core.async.close_BANG_.call(null,inst_11722);
var state_11831__$1 = state_11831;
var statearr_11862_11933 = state_11831__$1;
(statearr_11862_11933[(2)] = inst_11725);

(statearr_11862_11933[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (22))){
var inst_11745 = (state_11831[(8)]);
var inst_11748 = cljs.core.async.close_BANG_.call(null,inst_11745);
var state_11831__$1 = state_11831;
var statearr_11863_11934 = state_11831__$1;
(statearr_11863_11934[(2)] = inst_11748);

(statearr_11863_11934[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (36))){
var inst_11791 = (state_11831[(23)]);
var inst_11795 = cljs.core.chunk_first.call(null,inst_11791);
var inst_11796 = cljs.core.chunk_rest.call(null,inst_11791);
var inst_11797 = cljs.core.count.call(null,inst_11795);
var inst_11773 = inst_11796;
var inst_11774 = inst_11795;
var inst_11775 = inst_11797;
var inst_11776 = (0);
var state_11831__$1 = (function (){var statearr_11864 = state_11831;
(statearr_11864[(19)] = inst_11775);

(statearr_11864[(20)] = inst_11773);

(statearr_11864[(10)] = inst_11774);

(statearr_11864[(11)] = inst_11776);

return statearr_11864;
})();
var statearr_11865_11935 = state_11831__$1;
(statearr_11865_11935[(2)] = null);

(statearr_11865_11935[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (41))){
var inst_11791 = (state_11831[(23)]);
var inst_11806 = (state_11831[(2)]);
var inst_11807 = cljs.core.next.call(null,inst_11791);
var inst_11773 = inst_11807;
var inst_11774 = null;
var inst_11775 = (0);
var inst_11776 = (0);
var state_11831__$1 = (function (){var statearr_11866 = state_11831;
(statearr_11866[(25)] = inst_11806);

(statearr_11866[(19)] = inst_11775);

(statearr_11866[(20)] = inst_11773);

(statearr_11866[(10)] = inst_11774);

(statearr_11866[(11)] = inst_11776);

return statearr_11866;
})();
var statearr_11867_11936 = state_11831__$1;
(statearr_11867_11936[(2)] = null);

(statearr_11867_11936[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (43))){
var state_11831__$1 = state_11831;
var statearr_11868_11937 = state_11831__$1;
(statearr_11868_11937[(2)] = null);

(statearr_11868_11937[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (29))){
var inst_11815 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11869_11938 = state_11831__$1;
(statearr_11869_11938[(2)] = inst_11815);

(statearr_11869_11938[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (44))){
var inst_11824 = (state_11831[(2)]);
var state_11831__$1 = (function (){var statearr_11870 = state_11831;
(statearr_11870[(26)] = inst_11824);

return statearr_11870;
})();
var statearr_11871_11939 = state_11831__$1;
(statearr_11871_11939[(2)] = null);

(statearr_11871_11939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (6))){
var inst_11765 = (state_11831[(27)]);
var inst_11764 = cljs.core.deref.call(null,cs);
var inst_11765__$1 = cljs.core.keys.call(null,inst_11764);
var inst_11766 = cljs.core.count.call(null,inst_11765__$1);
var inst_11767 = cljs.core.reset_BANG_.call(null,dctr,inst_11766);
var inst_11772 = cljs.core.seq.call(null,inst_11765__$1);
var inst_11773 = inst_11772;
var inst_11774 = null;
var inst_11775 = (0);
var inst_11776 = (0);
var state_11831__$1 = (function (){var statearr_11872 = state_11831;
(statearr_11872[(27)] = inst_11765__$1);

(statearr_11872[(19)] = inst_11775);

(statearr_11872[(20)] = inst_11773);

(statearr_11872[(10)] = inst_11774);

(statearr_11872[(11)] = inst_11776);

(statearr_11872[(28)] = inst_11767);

return statearr_11872;
})();
var statearr_11873_11940 = state_11831__$1;
(statearr_11873_11940[(2)] = null);

(statearr_11873_11940[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (28))){
var inst_11791 = (state_11831[(23)]);
var inst_11773 = (state_11831[(20)]);
var inst_11791__$1 = cljs.core.seq.call(null,inst_11773);
var state_11831__$1 = (function (){var statearr_11874 = state_11831;
(statearr_11874[(23)] = inst_11791__$1);

return statearr_11874;
})();
if(inst_11791__$1){
var statearr_11875_11941 = state_11831__$1;
(statearr_11875_11941[(1)] = (33));

} else {
var statearr_11876_11942 = state_11831__$1;
(statearr_11876_11942[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (25))){
var inst_11775 = (state_11831[(19)]);
var inst_11776 = (state_11831[(11)]);
var inst_11778 = (inst_11776 < inst_11775);
var inst_11779 = inst_11778;
var state_11831__$1 = state_11831;
if(cljs.core.truth_(inst_11779)){
var statearr_11877_11943 = state_11831__$1;
(statearr_11877_11943[(1)] = (27));

} else {
var statearr_11878_11944 = state_11831__$1;
(statearr_11878_11944[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (34))){
var state_11831__$1 = state_11831;
var statearr_11879_11945 = state_11831__$1;
(statearr_11879_11945[(2)] = null);

(statearr_11879_11945[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (17))){
var state_11831__$1 = state_11831;
var statearr_11880_11946 = state_11831__$1;
(statearr_11880_11946[(2)] = null);

(statearr_11880_11946[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (3))){
var inst_11829 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11831__$1,inst_11829);
} else {
if((state_val_11832 === (12))){
var inst_11760 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11881_11947 = state_11831__$1;
(statearr_11881_11947[(2)] = inst_11760);

(statearr_11881_11947[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (2))){
var state_11831__$1 = state_11831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11831__$1,(4),ch);
} else {
if((state_val_11832 === (23))){
var state_11831__$1 = state_11831;
var statearr_11882_11948 = state_11831__$1;
(statearr_11882_11948[(2)] = null);

(statearr_11882_11948[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (35))){
var inst_11813 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11883_11949 = state_11831__$1;
(statearr_11883_11949[(2)] = inst_11813);

(statearr_11883_11949[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (19))){
var inst_11732 = (state_11831[(7)]);
var inst_11736 = cljs.core.chunk_first.call(null,inst_11732);
var inst_11737 = cljs.core.chunk_rest.call(null,inst_11732);
var inst_11738 = cljs.core.count.call(null,inst_11736);
var inst_11710 = inst_11737;
var inst_11711 = inst_11736;
var inst_11712 = inst_11738;
var inst_11713 = (0);
var state_11831__$1 = (function (){var statearr_11884 = state_11831;
(statearr_11884[(13)] = inst_11713);

(statearr_11884[(14)] = inst_11710);

(statearr_11884[(15)] = inst_11711);

(statearr_11884[(17)] = inst_11712);

return statearr_11884;
})();
var statearr_11885_11950 = state_11831__$1;
(statearr_11885_11950[(2)] = null);

(statearr_11885_11950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (11))){
var inst_11710 = (state_11831[(14)]);
var inst_11732 = (state_11831[(7)]);
var inst_11732__$1 = cljs.core.seq.call(null,inst_11710);
var state_11831__$1 = (function (){var statearr_11886 = state_11831;
(statearr_11886[(7)] = inst_11732__$1);

return statearr_11886;
})();
if(inst_11732__$1){
var statearr_11887_11951 = state_11831__$1;
(statearr_11887_11951[(1)] = (16));

} else {
var statearr_11888_11952 = state_11831__$1;
(statearr_11888_11952[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (9))){
var inst_11762 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11889_11953 = state_11831__$1;
(statearr_11889_11953[(2)] = inst_11762);

(statearr_11889_11953[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (5))){
var inst_11708 = cljs.core.deref.call(null,cs);
var inst_11709 = cljs.core.seq.call(null,inst_11708);
var inst_11710 = inst_11709;
var inst_11711 = null;
var inst_11712 = (0);
var inst_11713 = (0);
var state_11831__$1 = (function (){var statearr_11890 = state_11831;
(statearr_11890[(13)] = inst_11713);

(statearr_11890[(14)] = inst_11710);

(statearr_11890[(15)] = inst_11711);

(statearr_11890[(17)] = inst_11712);

return statearr_11890;
})();
var statearr_11891_11954 = state_11831__$1;
(statearr_11891_11954[(2)] = null);

(statearr_11891_11954[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (14))){
var state_11831__$1 = state_11831;
var statearr_11892_11955 = state_11831__$1;
(statearr_11892_11955[(2)] = null);

(statearr_11892_11955[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (45))){
var inst_11821 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11893_11956 = state_11831__$1;
(statearr_11893_11956[(2)] = inst_11821);

(statearr_11893_11956[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (26))){
var inst_11765 = (state_11831[(27)]);
var inst_11817 = (state_11831[(2)]);
var inst_11818 = cljs.core.seq.call(null,inst_11765);
var state_11831__$1 = (function (){var statearr_11894 = state_11831;
(statearr_11894[(29)] = inst_11817);

return statearr_11894;
})();
if(inst_11818){
var statearr_11895_11957 = state_11831__$1;
(statearr_11895_11957[(1)] = (42));

} else {
var statearr_11896_11958 = state_11831__$1;
(statearr_11896_11958[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (16))){
var inst_11732 = (state_11831[(7)]);
var inst_11734 = cljs.core.chunked_seq_QMARK_.call(null,inst_11732);
var state_11831__$1 = state_11831;
if(inst_11734){
var statearr_11897_11959 = state_11831__$1;
(statearr_11897_11959[(1)] = (19));

} else {
var statearr_11898_11960 = state_11831__$1;
(statearr_11898_11960[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (38))){
var inst_11810 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11899_11961 = state_11831__$1;
(statearr_11899_11961[(2)] = inst_11810);

(statearr_11899_11961[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (30))){
var state_11831__$1 = state_11831;
var statearr_11900_11962 = state_11831__$1;
(statearr_11900_11962[(2)] = null);

(statearr_11900_11962[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (10))){
var inst_11713 = (state_11831[(13)]);
var inst_11711 = (state_11831[(15)]);
var inst_11721 = cljs.core._nth.call(null,inst_11711,inst_11713);
var inst_11722 = cljs.core.nth.call(null,inst_11721,(0),null);
var inst_11723 = cljs.core.nth.call(null,inst_11721,(1),null);
var state_11831__$1 = (function (){var statearr_11901 = state_11831;
(statearr_11901[(24)] = inst_11722);

return statearr_11901;
})();
if(cljs.core.truth_(inst_11723)){
var statearr_11902_11963 = state_11831__$1;
(statearr_11902_11963[(1)] = (13));

} else {
var statearr_11903_11964 = state_11831__$1;
(statearr_11903_11964[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (18))){
var inst_11758 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11904_11965 = state_11831__$1;
(statearr_11904_11965[(2)] = inst_11758);

(statearr_11904_11965[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (42))){
var state_11831__$1 = state_11831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11831__$1,(45),dchan);
} else {
if((state_val_11832 === (37))){
var inst_11791 = (state_11831[(23)]);
var inst_11701 = (state_11831[(9)]);
var inst_11800 = (state_11831[(22)]);
var inst_11800__$1 = cljs.core.first.call(null,inst_11791);
var inst_11801 = cljs.core.async.put_BANG_.call(null,inst_11800__$1,inst_11701,done);
var state_11831__$1 = (function (){var statearr_11905 = state_11831;
(statearr_11905[(22)] = inst_11800__$1);

return statearr_11905;
})();
if(cljs.core.truth_(inst_11801)){
var statearr_11906_11966 = state_11831__$1;
(statearr_11906_11966[(1)] = (39));

} else {
var statearr_11907_11967 = state_11831__$1;
(statearr_11907_11967[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (8))){
var inst_11713 = (state_11831[(13)]);
var inst_11712 = (state_11831[(17)]);
var inst_11715 = (inst_11713 < inst_11712);
var inst_11716 = inst_11715;
var state_11831__$1 = state_11831;
if(cljs.core.truth_(inst_11716)){
var statearr_11908_11968 = state_11831__$1;
(statearr_11908_11968[(1)] = (10));

} else {
var statearr_11909_11969 = state_11831__$1;
(statearr_11909_11969[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__11000__auto__ = null;
var cljs$core$async$mult_$_state_machine__11000__auto____0 = (function (){
var statearr_11910 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11910[(0)] = cljs$core$async$mult_$_state_machine__11000__auto__);

(statearr_11910[(1)] = (1));

return statearr_11910;
});
var cljs$core$async$mult_$_state_machine__11000__auto____1 = (function (state_11831){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_11831);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e11911){var ex__11003__auto__ = e11911;
var statearr_11912_11970 = state_11831;
(statearr_11912_11970[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_11831[(4)]))){
var statearr_11913_11971 = state_11831;
(statearr_11913_11971[(1)] = cljs.core.first.call(null,(state_11831[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11972 = state_11831;
state_11831 = G__11972;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11000__auto__ = function(state_11831){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11000__auto____1.call(this,state_11831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11000__auto____0;
cljs$core$async$mult_$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11000__auto____1;
return cljs$core$async$mult_$_state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_11914 = f__11074__auto__.call(null);
(statearr_11914[(6)] = c__11073__auto___11915);

return statearr_11914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__11974 = arguments.length;
switch (G__11974) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_11976 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,ch);
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_11976.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_11977 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,ch);
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_11977.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_11978 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m);
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_11978.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_11979 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,state_map);
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_11979.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_11980 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,mode);
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_11980.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___11990 = arguments.length;
var i__5770__auto___11991 = (0);
while(true){
if((i__5770__auto___11991 < len__5769__auto___11990)){
args__5775__auto__.push((arguments[i__5770__auto___11991]));

var G__11992 = (i__5770__auto___11991 + (1));
i__5770__auto___11991 = G__11992;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__11985){
var map__11986 = p__11985;
var map__11986__$1 = cljs.core.__destructure_map.call(null,map__11986);
var opts = map__11986__$1;
var statearr_11987_11993 = state;
(statearr_11987_11993[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_11988_11994 = state;
(statearr_11988_11994[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_11989_11995 = state;
(statearr_11989_11995[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq11981){
var G__11982 = cljs.core.first.call(null,seq11981);
var seq11981__$1 = cljs.core.next.call(null,seq11981);
var G__11983 = cljs.core.first.call(null,seq11981__$1);
var seq11981__$2 = cljs.core.next.call(null,seq11981__$1);
var G__11984 = cljs.core.first.call(null,seq11981__$2);
var seq11981__$3 = cljs.core.next.call(null,seq11981__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11982,G__11983,G__11984,seq11981__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11996 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11996 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta11997){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta11997 = meta11997;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11996.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11998,meta11997__$1){
var self__ = this;
var _11998__$1 = this;
return (new cljs.core.async.t_cljs$core$async11996(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta11997__$1));
}));

(cljs.core.async.t_cljs$core$async11996.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11998){
var self__ = this;
var _11998__$1 = this;
return self__.meta11997;
}));

(cljs.core.async.t_cljs$core$async11996.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11996.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async11996.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11996.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11996.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11996.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11996.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11996.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11996.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta11997","meta11997",-61306228,null)], null);
}));

(cljs.core.async.t_cljs$core$async11996.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11996.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11996");

(cljs.core.async.t_cljs$core$async11996.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async11996");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11996.
 */
cljs.core.async.__GT_t_cljs$core$async11996 = (function cljs$core$async$mix_$___GT_t_cljs$core$async11996(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta11997){
return (new cljs.core.async.t_cljs$core$async11996(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta11997));
});

}

return (new cljs.core.async.t_cljs$core$async11996(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11073__auto___12111 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_12066){
var state_val_12067 = (state_12066[(1)]);
if((state_val_12067 === (7))){
var inst_12026 = (state_12066[(2)]);
var state_12066__$1 = state_12066;
if(cljs.core.truth_(inst_12026)){
var statearr_12068_12112 = state_12066__$1;
(statearr_12068_12112[(1)] = (8));

} else {
var statearr_12069_12113 = state_12066__$1;
(statearr_12069_12113[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (20))){
var inst_12019 = (state_12066[(7)]);
var state_12066__$1 = state_12066;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12066__$1,(23),out,inst_12019);
} else {
if((state_val_12067 === (1))){
var inst_12002 = calc_state.call(null);
var inst_12003 = cljs.core.__destructure_map.call(null,inst_12002);
var inst_12004 = cljs.core.get.call(null,inst_12003,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12005 = cljs.core.get.call(null,inst_12003,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12006 = cljs.core.get.call(null,inst_12003,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12007 = inst_12002;
var state_12066__$1 = (function (){var statearr_12070 = state_12066;
(statearr_12070[(8)] = inst_12006);

(statearr_12070[(9)] = inst_12004);

(statearr_12070[(10)] = inst_12005);

(statearr_12070[(11)] = inst_12007);

return statearr_12070;
})();
var statearr_12071_12114 = state_12066__$1;
(statearr_12071_12114[(2)] = null);

(statearr_12071_12114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (24))){
var inst_12010 = (state_12066[(12)]);
var inst_12007 = inst_12010;
var state_12066__$1 = (function (){var statearr_12072 = state_12066;
(statearr_12072[(11)] = inst_12007);

return statearr_12072;
})();
var statearr_12073_12115 = state_12066__$1;
(statearr_12073_12115[(2)] = null);

(statearr_12073_12115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (4))){
var inst_12021 = (state_12066[(13)]);
var inst_12019 = (state_12066[(7)]);
var inst_12018 = (state_12066[(2)]);
var inst_12019__$1 = cljs.core.nth.call(null,inst_12018,(0),null);
var inst_12020 = cljs.core.nth.call(null,inst_12018,(1),null);
var inst_12021__$1 = (inst_12019__$1 == null);
var state_12066__$1 = (function (){var statearr_12074 = state_12066;
(statearr_12074[(13)] = inst_12021__$1);

(statearr_12074[(14)] = inst_12020);

(statearr_12074[(7)] = inst_12019__$1);

return statearr_12074;
})();
if(cljs.core.truth_(inst_12021__$1)){
var statearr_12075_12116 = state_12066__$1;
(statearr_12075_12116[(1)] = (5));

} else {
var statearr_12076_12117 = state_12066__$1;
(statearr_12076_12117[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (15))){
var inst_12011 = (state_12066[(15)]);
var inst_12040 = (state_12066[(16)]);
var inst_12040__$1 = cljs.core.empty_QMARK_.call(null,inst_12011);
var state_12066__$1 = (function (){var statearr_12077 = state_12066;
(statearr_12077[(16)] = inst_12040__$1);

return statearr_12077;
})();
if(inst_12040__$1){
var statearr_12078_12118 = state_12066__$1;
(statearr_12078_12118[(1)] = (17));

} else {
var statearr_12079_12119 = state_12066__$1;
(statearr_12079_12119[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (21))){
var inst_12010 = (state_12066[(12)]);
var inst_12007 = inst_12010;
var state_12066__$1 = (function (){var statearr_12080 = state_12066;
(statearr_12080[(11)] = inst_12007);

return statearr_12080;
})();
var statearr_12081_12120 = state_12066__$1;
(statearr_12081_12120[(2)] = null);

(statearr_12081_12120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (13))){
var inst_12033 = (state_12066[(2)]);
var inst_12034 = calc_state.call(null);
var inst_12007 = inst_12034;
var state_12066__$1 = (function (){var statearr_12082 = state_12066;
(statearr_12082[(17)] = inst_12033);

(statearr_12082[(11)] = inst_12007);

return statearr_12082;
})();
var statearr_12083_12121 = state_12066__$1;
(statearr_12083_12121[(2)] = null);

(statearr_12083_12121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (22))){
var inst_12060 = (state_12066[(2)]);
var state_12066__$1 = state_12066;
var statearr_12084_12122 = state_12066__$1;
(statearr_12084_12122[(2)] = inst_12060);

(statearr_12084_12122[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (6))){
var inst_12020 = (state_12066[(14)]);
var inst_12024 = cljs.core._EQ_.call(null,inst_12020,change);
var state_12066__$1 = state_12066;
var statearr_12085_12123 = state_12066__$1;
(statearr_12085_12123[(2)] = inst_12024);

(statearr_12085_12123[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (25))){
var state_12066__$1 = state_12066;
var statearr_12086_12124 = state_12066__$1;
(statearr_12086_12124[(2)] = null);

(statearr_12086_12124[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (17))){
var inst_12012 = (state_12066[(18)]);
var inst_12020 = (state_12066[(14)]);
var inst_12042 = inst_12012.call(null,inst_12020);
var inst_12043 = cljs.core.not.call(null,inst_12042);
var state_12066__$1 = state_12066;
var statearr_12087_12125 = state_12066__$1;
(statearr_12087_12125[(2)] = inst_12043);

(statearr_12087_12125[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (3))){
var inst_12064 = (state_12066[(2)]);
var state_12066__$1 = state_12066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12066__$1,inst_12064);
} else {
if((state_val_12067 === (12))){
var state_12066__$1 = state_12066;
var statearr_12088_12126 = state_12066__$1;
(statearr_12088_12126[(2)] = null);

(statearr_12088_12126[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (2))){
var inst_12010 = (state_12066[(12)]);
var inst_12007 = (state_12066[(11)]);
var inst_12010__$1 = cljs.core.__destructure_map.call(null,inst_12007);
var inst_12011 = cljs.core.get.call(null,inst_12010__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12012 = cljs.core.get.call(null,inst_12010__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12013 = cljs.core.get.call(null,inst_12010__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12066__$1 = (function (){var statearr_12089 = state_12066;
(statearr_12089[(15)] = inst_12011);

(statearr_12089[(18)] = inst_12012);

(statearr_12089[(12)] = inst_12010__$1);

return statearr_12089;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12066__$1,(4),inst_12013);
} else {
if((state_val_12067 === (23))){
var inst_12051 = (state_12066[(2)]);
var state_12066__$1 = state_12066;
if(cljs.core.truth_(inst_12051)){
var statearr_12090_12127 = state_12066__$1;
(statearr_12090_12127[(1)] = (24));

} else {
var statearr_12091_12128 = state_12066__$1;
(statearr_12091_12128[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (19))){
var inst_12046 = (state_12066[(2)]);
var state_12066__$1 = state_12066;
var statearr_12092_12129 = state_12066__$1;
(statearr_12092_12129[(2)] = inst_12046);

(statearr_12092_12129[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (11))){
var inst_12020 = (state_12066[(14)]);
var inst_12030 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12020);
var state_12066__$1 = state_12066;
var statearr_12093_12130 = state_12066__$1;
(statearr_12093_12130[(2)] = inst_12030);

(statearr_12093_12130[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (9))){
var inst_12011 = (state_12066[(15)]);
var inst_12020 = (state_12066[(14)]);
var inst_12037 = (state_12066[(19)]);
var inst_12037__$1 = inst_12011.call(null,inst_12020);
var state_12066__$1 = (function (){var statearr_12094 = state_12066;
(statearr_12094[(19)] = inst_12037__$1);

return statearr_12094;
})();
if(cljs.core.truth_(inst_12037__$1)){
var statearr_12095_12131 = state_12066__$1;
(statearr_12095_12131[(1)] = (14));

} else {
var statearr_12096_12132 = state_12066__$1;
(statearr_12096_12132[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (5))){
var inst_12021 = (state_12066[(13)]);
var state_12066__$1 = state_12066;
var statearr_12097_12133 = state_12066__$1;
(statearr_12097_12133[(2)] = inst_12021);

(statearr_12097_12133[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (14))){
var inst_12037 = (state_12066[(19)]);
var state_12066__$1 = state_12066;
var statearr_12098_12134 = state_12066__$1;
(statearr_12098_12134[(2)] = inst_12037);

(statearr_12098_12134[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (26))){
var inst_12056 = (state_12066[(2)]);
var state_12066__$1 = state_12066;
var statearr_12099_12135 = state_12066__$1;
(statearr_12099_12135[(2)] = inst_12056);

(statearr_12099_12135[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (16))){
var inst_12048 = (state_12066[(2)]);
var state_12066__$1 = state_12066;
if(cljs.core.truth_(inst_12048)){
var statearr_12100_12136 = state_12066__$1;
(statearr_12100_12136[(1)] = (20));

} else {
var statearr_12101_12137 = state_12066__$1;
(statearr_12101_12137[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (10))){
var inst_12062 = (state_12066[(2)]);
var state_12066__$1 = state_12066;
var statearr_12102_12138 = state_12066__$1;
(statearr_12102_12138[(2)] = inst_12062);

(statearr_12102_12138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (18))){
var inst_12040 = (state_12066[(16)]);
var state_12066__$1 = state_12066;
var statearr_12103_12139 = state_12066__$1;
(statearr_12103_12139[(2)] = inst_12040);

(statearr_12103_12139[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12067 === (8))){
var inst_12019 = (state_12066[(7)]);
var inst_12028 = (inst_12019 == null);
var state_12066__$1 = state_12066;
if(cljs.core.truth_(inst_12028)){
var statearr_12104_12140 = state_12066__$1;
(statearr_12104_12140[(1)] = (11));

} else {
var statearr_12105_12141 = state_12066__$1;
(statearr_12105_12141[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__11000__auto__ = null;
var cljs$core$async$mix_$_state_machine__11000__auto____0 = (function (){
var statearr_12106 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12106[(0)] = cljs$core$async$mix_$_state_machine__11000__auto__);

(statearr_12106[(1)] = (1));

return statearr_12106;
});
var cljs$core$async$mix_$_state_machine__11000__auto____1 = (function (state_12066){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_12066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e12107){var ex__11003__auto__ = e12107;
var statearr_12108_12142 = state_12066;
(statearr_12108_12142[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_12066[(4)]))){
var statearr_12109_12143 = state_12066;
(statearr_12109_12143[(1)] = cljs.core.first.call(null,(state_12066[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12144 = state_12066;
state_12066 = G__12144;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11000__auto__ = function(state_12066){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11000__auto____1.call(this,state_12066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11000__auto____0;
cljs$core$async$mix_$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11000__auto____1;
return cljs$core$async$mix_$_state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_12110 = f__11074__auto__.call(null);
(statearr_12110[(6)] = c__11073__auto___12111);

return statearr_12110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_12147 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_12147.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_12148 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,p,v,ch);
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_12148.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_12149 = (function() {
var G__12150 = null;
var G__12150__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,p);
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__12150__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,p,v);
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__12150 = function(p,v){
switch(arguments.length){
case 1:
return G__12150__1.call(this,p);
case 2:
return G__12150__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12150.cljs$core$IFn$_invoke$arity$1 = G__12150__1;
G__12150.cljs$core$IFn$_invoke$arity$2 = G__12150__2;
return G__12150;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12146 = arguments.length;
switch (G__12146) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12149.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12149.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12154 = arguments.length;
switch (G__12154) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__12152_SHARP_){
if(cljs.core.truth_(p1__12152_SHARP_.call(null,topic))){
return p1__12152_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12152_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12155 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12155 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12156){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12156 = meta12156;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12155.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12157,meta12156__$1){
var self__ = this;
var _12157__$1 = this;
return (new cljs.core.async.t_cljs$core$async12155(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12156__$1));
}));

(cljs.core.async.t_cljs$core$async12155.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12157){
var self__ = this;
var _12157__$1 = this;
return self__.meta12156;
}));

(cljs.core.async.t_cljs$core$async12155.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12155.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12155.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12155.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async12155.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async12155.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async12155.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async12155.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12156","meta12156",22135307,null)], null);
}));

(cljs.core.async.t_cljs$core$async12155.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12155.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12155");

(cljs.core.async.t_cljs$core$async12155.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async12155");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12155.
 */
cljs.core.async.__GT_t_cljs$core$async12155 = (function cljs$core$async$__GT_t_cljs$core$async12155(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12156){
return (new cljs.core.async.t_cljs$core$async12155(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12156));
});

}

return (new cljs.core.async.t_cljs$core$async12155(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11073__auto___12276 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_12229){
var state_val_12230 = (state_12229[(1)]);
if((state_val_12230 === (7))){
var inst_12225 = (state_12229[(2)]);
var state_12229__$1 = state_12229;
var statearr_12231_12277 = state_12229__$1;
(statearr_12231_12277[(2)] = inst_12225);

(statearr_12231_12277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (20))){
var state_12229__$1 = state_12229;
var statearr_12232_12278 = state_12229__$1;
(statearr_12232_12278[(2)] = null);

(statearr_12232_12278[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (1))){
var state_12229__$1 = state_12229;
var statearr_12233_12279 = state_12229__$1;
(statearr_12233_12279[(2)] = null);

(statearr_12233_12279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (24))){
var inst_12208 = (state_12229[(7)]);
var inst_12217 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12208);
var state_12229__$1 = state_12229;
var statearr_12234_12280 = state_12229__$1;
(statearr_12234_12280[(2)] = inst_12217);

(statearr_12234_12280[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (4))){
var inst_12160 = (state_12229[(8)]);
var inst_12160__$1 = (state_12229[(2)]);
var inst_12161 = (inst_12160__$1 == null);
var state_12229__$1 = (function (){var statearr_12235 = state_12229;
(statearr_12235[(8)] = inst_12160__$1);

return statearr_12235;
})();
if(cljs.core.truth_(inst_12161)){
var statearr_12236_12281 = state_12229__$1;
(statearr_12236_12281[(1)] = (5));

} else {
var statearr_12237_12282 = state_12229__$1;
(statearr_12237_12282[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (15))){
var inst_12202 = (state_12229[(2)]);
var state_12229__$1 = state_12229;
var statearr_12238_12283 = state_12229__$1;
(statearr_12238_12283[(2)] = inst_12202);

(statearr_12238_12283[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (21))){
var inst_12222 = (state_12229[(2)]);
var state_12229__$1 = (function (){var statearr_12239 = state_12229;
(statearr_12239[(9)] = inst_12222);

return statearr_12239;
})();
var statearr_12240_12284 = state_12229__$1;
(statearr_12240_12284[(2)] = null);

(statearr_12240_12284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (13))){
var inst_12184 = (state_12229[(10)]);
var inst_12186 = cljs.core.chunked_seq_QMARK_.call(null,inst_12184);
var state_12229__$1 = state_12229;
if(inst_12186){
var statearr_12241_12285 = state_12229__$1;
(statearr_12241_12285[(1)] = (16));

} else {
var statearr_12242_12286 = state_12229__$1;
(statearr_12242_12286[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (22))){
var inst_12214 = (state_12229[(2)]);
var state_12229__$1 = state_12229;
if(cljs.core.truth_(inst_12214)){
var statearr_12243_12287 = state_12229__$1;
(statearr_12243_12287[(1)] = (23));

} else {
var statearr_12244_12288 = state_12229__$1;
(statearr_12244_12288[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (6))){
var inst_12208 = (state_12229[(7)]);
var inst_12160 = (state_12229[(8)]);
var inst_12210 = (state_12229[(11)]);
var inst_12208__$1 = topic_fn.call(null,inst_12160);
var inst_12209 = cljs.core.deref.call(null,mults);
var inst_12210__$1 = cljs.core.get.call(null,inst_12209,inst_12208__$1);
var state_12229__$1 = (function (){var statearr_12245 = state_12229;
(statearr_12245[(7)] = inst_12208__$1);

(statearr_12245[(11)] = inst_12210__$1);

return statearr_12245;
})();
if(cljs.core.truth_(inst_12210__$1)){
var statearr_12246_12289 = state_12229__$1;
(statearr_12246_12289[(1)] = (19));

} else {
var statearr_12247_12290 = state_12229__$1;
(statearr_12247_12290[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (25))){
var inst_12219 = (state_12229[(2)]);
var state_12229__$1 = state_12229;
var statearr_12248_12291 = state_12229__$1;
(statearr_12248_12291[(2)] = inst_12219);

(statearr_12248_12291[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (17))){
var inst_12184 = (state_12229[(10)]);
var inst_12193 = cljs.core.first.call(null,inst_12184);
var inst_12194 = cljs.core.async.muxch_STAR_.call(null,inst_12193);
var inst_12195 = cljs.core.async.close_BANG_.call(null,inst_12194);
var inst_12196 = cljs.core.next.call(null,inst_12184);
var inst_12170 = inst_12196;
var inst_12171 = null;
var inst_12172 = (0);
var inst_12173 = (0);
var state_12229__$1 = (function (){var statearr_12249 = state_12229;
(statearr_12249[(12)] = inst_12173);

(statearr_12249[(13)] = inst_12172);

(statearr_12249[(14)] = inst_12171);

(statearr_12249[(15)] = inst_12170);

(statearr_12249[(16)] = inst_12195);

return statearr_12249;
})();
var statearr_12250_12292 = state_12229__$1;
(statearr_12250_12292[(2)] = null);

(statearr_12250_12292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (3))){
var inst_12227 = (state_12229[(2)]);
var state_12229__$1 = state_12229;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12229__$1,inst_12227);
} else {
if((state_val_12230 === (12))){
var inst_12204 = (state_12229[(2)]);
var state_12229__$1 = state_12229;
var statearr_12251_12293 = state_12229__$1;
(statearr_12251_12293[(2)] = inst_12204);

(statearr_12251_12293[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (2))){
var state_12229__$1 = state_12229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12229__$1,(4),ch);
} else {
if((state_val_12230 === (23))){
var state_12229__$1 = state_12229;
var statearr_12252_12294 = state_12229__$1;
(statearr_12252_12294[(2)] = null);

(statearr_12252_12294[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (19))){
var inst_12160 = (state_12229[(8)]);
var inst_12210 = (state_12229[(11)]);
var inst_12212 = cljs.core.async.muxch_STAR_.call(null,inst_12210);
var state_12229__$1 = state_12229;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12229__$1,(22),inst_12212,inst_12160);
} else {
if((state_val_12230 === (11))){
var inst_12170 = (state_12229[(15)]);
var inst_12184 = (state_12229[(10)]);
var inst_12184__$1 = cljs.core.seq.call(null,inst_12170);
var state_12229__$1 = (function (){var statearr_12253 = state_12229;
(statearr_12253[(10)] = inst_12184__$1);

return statearr_12253;
})();
if(inst_12184__$1){
var statearr_12254_12295 = state_12229__$1;
(statearr_12254_12295[(1)] = (13));

} else {
var statearr_12255_12296 = state_12229__$1;
(statearr_12255_12296[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (9))){
var inst_12206 = (state_12229[(2)]);
var state_12229__$1 = state_12229;
var statearr_12256_12297 = state_12229__$1;
(statearr_12256_12297[(2)] = inst_12206);

(statearr_12256_12297[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (5))){
var inst_12167 = cljs.core.deref.call(null,mults);
var inst_12168 = cljs.core.vals.call(null,inst_12167);
var inst_12169 = cljs.core.seq.call(null,inst_12168);
var inst_12170 = inst_12169;
var inst_12171 = null;
var inst_12172 = (0);
var inst_12173 = (0);
var state_12229__$1 = (function (){var statearr_12257 = state_12229;
(statearr_12257[(12)] = inst_12173);

(statearr_12257[(13)] = inst_12172);

(statearr_12257[(14)] = inst_12171);

(statearr_12257[(15)] = inst_12170);

return statearr_12257;
})();
var statearr_12258_12298 = state_12229__$1;
(statearr_12258_12298[(2)] = null);

(statearr_12258_12298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (14))){
var state_12229__$1 = state_12229;
var statearr_12262_12299 = state_12229__$1;
(statearr_12262_12299[(2)] = null);

(statearr_12262_12299[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (16))){
var inst_12184 = (state_12229[(10)]);
var inst_12188 = cljs.core.chunk_first.call(null,inst_12184);
var inst_12189 = cljs.core.chunk_rest.call(null,inst_12184);
var inst_12190 = cljs.core.count.call(null,inst_12188);
var inst_12170 = inst_12189;
var inst_12171 = inst_12188;
var inst_12172 = inst_12190;
var inst_12173 = (0);
var state_12229__$1 = (function (){var statearr_12263 = state_12229;
(statearr_12263[(12)] = inst_12173);

(statearr_12263[(13)] = inst_12172);

(statearr_12263[(14)] = inst_12171);

(statearr_12263[(15)] = inst_12170);

return statearr_12263;
})();
var statearr_12264_12300 = state_12229__$1;
(statearr_12264_12300[(2)] = null);

(statearr_12264_12300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (10))){
var inst_12173 = (state_12229[(12)]);
var inst_12172 = (state_12229[(13)]);
var inst_12171 = (state_12229[(14)]);
var inst_12170 = (state_12229[(15)]);
var inst_12178 = cljs.core._nth.call(null,inst_12171,inst_12173);
var inst_12179 = cljs.core.async.muxch_STAR_.call(null,inst_12178);
var inst_12180 = cljs.core.async.close_BANG_.call(null,inst_12179);
var inst_12181 = (inst_12173 + (1));
var tmp12259 = inst_12172;
var tmp12260 = inst_12171;
var tmp12261 = inst_12170;
var inst_12170__$1 = tmp12261;
var inst_12171__$1 = tmp12260;
var inst_12172__$1 = tmp12259;
var inst_12173__$1 = inst_12181;
var state_12229__$1 = (function (){var statearr_12265 = state_12229;
(statearr_12265[(12)] = inst_12173__$1);

(statearr_12265[(13)] = inst_12172__$1);

(statearr_12265[(14)] = inst_12171__$1);

(statearr_12265[(15)] = inst_12170__$1);

(statearr_12265[(17)] = inst_12180);

return statearr_12265;
})();
var statearr_12266_12301 = state_12229__$1;
(statearr_12266_12301[(2)] = null);

(statearr_12266_12301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (18))){
var inst_12199 = (state_12229[(2)]);
var state_12229__$1 = state_12229;
var statearr_12267_12302 = state_12229__$1;
(statearr_12267_12302[(2)] = inst_12199);

(statearr_12267_12302[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12230 === (8))){
var inst_12173 = (state_12229[(12)]);
var inst_12172 = (state_12229[(13)]);
var inst_12175 = (inst_12173 < inst_12172);
var inst_12176 = inst_12175;
var state_12229__$1 = state_12229;
if(cljs.core.truth_(inst_12176)){
var statearr_12268_12303 = state_12229__$1;
(statearr_12268_12303[(1)] = (10));

} else {
var statearr_12269_12304 = state_12229__$1;
(statearr_12269_12304[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_12270 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12270[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_12270[(1)] = (1));

return statearr_12270;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_12229){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_12229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e12271){var ex__11003__auto__ = e12271;
var statearr_12272_12305 = state_12229;
(statearr_12272_12305[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_12229[(4)]))){
var statearr_12273_12306 = state_12229;
(statearr_12273_12306[(1)] = cljs.core.first.call(null,(state_12229[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12307 = state_12229;
state_12229 = G__12307;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_12229){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_12229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_12274 = f__11074__auto__.call(null);
(statearr_12274[(6)] = c__11073__auto___12276);

return statearr_12274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12309 = arguments.length;
switch (G__12309) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12312 = arguments.length;
switch (G__12312) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12315 = arguments.length;
switch (G__12315) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_.call(null,out);
} else {
var c__11073__auto___12393 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_12358){
var state_val_12359 = (state_12358[(1)]);
if((state_val_12359 === (7))){
var state_12358__$1 = state_12358;
var statearr_12360_12394 = state_12358__$1;
(statearr_12360_12394[(2)] = null);

(statearr_12360_12394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (1))){
var state_12358__$1 = state_12358;
var statearr_12361_12395 = state_12358__$1;
(statearr_12361_12395[(2)] = null);

(statearr_12361_12395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (4))){
var inst_12319 = (state_12358[(7)]);
var inst_12318 = (state_12358[(8)]);
var inst_12321 = (inst_12319 < inst_12318);
var state_12358__$1 = state_12358;
if(cljs.core.truth_(inst_12321)){
var statearr_12362_12396 = state_12358__$1;
(statearr_12362_12396[(1)] = (6));

} else {
var statearr_12363_12397 = state_12358__$1;
(statearr_12363_12397[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (15))){
var inst_12344 = (state_12358[(9)]);
var inst_12349 = cljs.core.apply.call(null,f,inst_12344);
var state_12358__$1 = state_12358;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12358__$1,(17),out,inst_12349);
} else {
if((state_val_12359 === (13))){
var inst_12344 = (state_12358[(9)]);
var inst_12344__$1 = (state_12358[(2)]);
var inst_12345 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12344__$1);
var state_12358__$1 = (function (){var statearr_12364 = state_12358;
(statearr_12364[(9)] = inst_12344__$1);

return statearr_12364;
})();
if(cljs.core.truth_(inst_12345)){
var statearr_12365_12398 = state_12358__$1;
(statearr_12365_12398[(1)] = (14));

} else {
var statearr_12366_12399 = state_12358__$1;
(statearr_12366_12399[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (6))){
var state_12358__$1 = state_12358;
var statearr_12367_12400 = state_12358__$1;
(statearr_12367_12400[(2)] = null);

(statearr_12367_12400[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (17))){
var inst_12351 = (state_12358[(2)]);
var state_12358__$1 = (function (){var statearr_12369 = state_12358;
(statearr_12369[(10)] = inst_12351);

return statearr_12369;
})();
var statearr_12370_12401 = state_12358__$1;
(statearr_12370_12401[(2)] = null);

(statearr_12370_12401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (3))){
var inst_12356 = (state_12358[(2)]);
var state_12358__$1 = state_12358;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12358__$1,inst_12356);
} else {
if((state_val_12359 === (12))){
var _ = (function (){var statearr_12371 = state_12358;
(statearr_12371[(4)] = cljs.core.rest.call(null,(state_12358[(4)])));

return statearr_12371;
})();
var state_12358__$1 = state_12358;
var ex12368 = (state_12358__$1[(2)]);
var statearr_12372_12402 = state_12358__$1;
(statearr_12372_12402[(5)] = ex12368);


if((ex12368 instanceof Object)){
var statearr_12373_12403 = state_12358__$1;
(statearr_12373_12403[(1)] = (11));

(statearr_12373_12403[(5)] = null);

} else {
throw ex12368;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (2))){
var inst_12317 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12318 = cnt;
var inst_12319 = (0);
var state_12358__$1 = (function (){var statearr_12374 = state_12358;
(statearr_12374[(7)] = inst_12319);

(statearr_12374[(11)] = inst_12317);

(statearr_12374[(8)] = inst_12318);

return statearr_12374;
})();
var statearr_12375_12404 = state_12358__$1;
(statearr_12375_12404[(2)] = null);

(statearr_12375_12404[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (11))){
var inst_12323 = (state_12358[(2)]);
var inst_12324 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12358__$1 = (function (){var statearr_12376 = state_12358;
(statearr_12376[(12)] = inst_12323);

return statearr_12376;
})();
var statearr_12377_12405 = state_12358__$1;
(statearr_12377_12405[(2)] = inst_12324);

(statearr_12377_12405[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (9))){
var inst_12319 = (state_12358[(7)]);
var _ = (function (){var statearr_12378 = state_12358;
(statearr_12378[(4)] = cljs.core.cons.call(null,(12),(state_12358[(4)])));

return statearr_12378;
})();
var inst_12330 = chs__$1.call(null,inst_12319);
var inst_12331 = done.call(null,inst_12319);
var inst_12332 = cljs.core.async.take_BANG_.call(null,inst_12330,inst_12331);
var ___$1 = (function (){var statearr_12379 = state_12358;
(statearr_12379[(4)] = cljs.core.rest.call(null,(state_12358[(4)])));

return statearr_12379;
})();
var state_12358__$1 = state_12358;
var statearr_12380_12406 = state_12358__$1;
(statearr_12380_12406[(2)] = inst_12332);

(statearr_12380_12406[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (5))){
var inst_12342 = (state_12358[(2)]);
var state_12358__$1 = (function (){var statearr_12381 = state_12358;
(statearr_12381[(13)] = inst_12342);

return statearr_12381;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12358__$1,(13),dchan);
} else {
if((state_val_12359 === (14))){
var inst_12347 = cljs.core.async.close_BANG_.call(null,out);
var state_12358__$1 = state_12358;
var statearr_12382_12407 = state_12358__$1;
(statearr_12382_12407[(2)] = inst_12347);

(statearr_12382_12407[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (16))){
var inst_12354 = (state_12358[(2)]);
var state_12358__$1 = state_12358;
var statearr_12383_12408 = state_12358__$1;
(statearr_12383_12408[(2)] = inst_12354);

(statearr_12383_12408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (10))){
var inst_12319 = (state_12358[(7)]);
var inst_12335 = (state_12358[(2)]);
var inst_12336 = (inst_12319 + (1));
var inst_12319__$1 = inst_12336;
var state_12358__$1 = (function (){var statearr_12384 = state_12358;
(statearr_12384[(7)] = inst_12319__$1);

(statearr_12384[(14)] = inst_12335);

return statearr_12384;
})();
var statearr_12385_12409 = state_12358__$1;
(statearr_12385_12409[(2)] = null);

(statearr_12385_12409[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12359 === (8))){
var inst_12340 = (state_12358[(2)]);
var state_12358__$1 = state_12358;
var statearr_12386_12410 = state_12358__$1;
(statearr_12386_12410[(2)] = inst_12340);

(statearr_12386_12410[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_12387 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12387[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_12387[(1)] = (1));

return statearr_12387;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_12358){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_12358);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e12388){var ex__11003__auto__ = e12388;
var statearr_12389_12411 = state_12358;
(statearr_12389_12411[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_12358[(4)]))){
var statearr_12390_12412 = state_12358;
(statearr_12390_12412[(1)] = cljs.core.first.call(null,(state_12358[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12413 = state_12358;
state_12358 = G__12413;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_12358){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_12358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_12391 = f__11074__auto__.call(null);
(statearr_12391[(6)] = c__11073__auto___12393);

return statearr_12391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12416 = arguments.length;
switch (G__12416) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___12471 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_12448){
var state_val_12449 = (state_12448[(1)]);
if((state_val_12449 === (7))){
var inst_12427 = (state_12448[(7)]);
var inst_12428 = (state_12448[(8)]);
var inst_12427__$1 = (state_12448[(2)]);
var inst_12428__$1 = cljs.core.nth.call(null,inst_12427__$1,(0),null);
var inst_12429 = cljs.core.nth.call(null,inst_12427__$1,(1),null);
var inst_12430 = (inst_12428__$1 == null);
var state_12448__$1 = (function (){var statearr_12450 = state_12448;
(statearr_12450[(7)] = inst_12427__$1);

(statearr_12450[(8)] = inst_12428__$1);

(statearr_12450[(9)] = inst_12429);

return statearr_12450;
})();
if(cljs.core.truth_(inst_12430)){
var statearr_12451_12472 = state_12448__$1;
(statearr_12451_12472[(1)] = (8));

} else {
var statearr_12452_12473 = state_12448__$1;
(statearr_12452_12473[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (1))){
var inst_12417 = cljs.core.vec.call(null,chs);
var inst_12418 = inst_12417;
var state_12448__$1 = (function (){var statearr_12453 = state_12448;
(statearr_12453[(10)] = inst_12418);

return statearr_12453;
})();
var statearr_12454_12474 = state_12448__$1;
(statearr_12454_12474[(2)] = null);

(statearr_12454_12474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (4))){
var inst_12418 = (state_12448[(10)]);
var state_12448__$1 = state_12448;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12448__$1,(7),inst_12418);
} else {
if((state_val_12449 === (6))){
var inst_12444 = (state_12448[(2)]);
var state_12448__$1 = state_12448;
var statearr_12455_12475 = state_12448__$1;
(statearr_12455_12475[(2)] = inst_12444);

(statearr_12455_12475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (3))){
var inst_12446 = (state_12448[(2)]);
var state_12448__$1 = state_12448;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12448__$1,inst_12446);
} else {
if((state_val_12449 === (2))){
var inst_12418 = (state_12448[(10)]);
var inst_12420 = cljs.core.count.call(null,inst_12418);
var inst_12421 = (inst_12420 > (0));
var state_12448__$1 = state_12448;
if(cljs.core.truth_(inst_12421)){
var statearr_12457_12476 = state_12448__$1;
(statearr_12457_12476[(1)] = (4));

} else {
var statearr_12458_12477 = state_12448__$1;
(statearr_12458_12477[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (11))){
var inst_12418 = (state_12448[(10)]);
var inst_12437 = (state_12448[(2)]);
var tmp12456 = inst_12418;
var inst_12418__$1 = tmp12456;
var state_12448__$1 = (function (){var statearr_12459 = state_12448;
(statearr_12459[(11)] = inst_12437);

(statearr_12459[(10)] = inst_12418__$1);

return statearr_12459;
})();
var statearr_12460_12478 = state_12448__$1;
(statearr_12460_12478[(2)] = null);

(statearr_12460_12478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (9))){
var inst_12428 = (state_12448[(8)]);
var state_12448__$1 = state_12448;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12448__$1,(11),out,inst_12428);
} else {
if((state_val_12449 === (5))){
var inst_12442 = cljs.core.async.close_BANG_.call(null,out);
var state_12448__$1 = state_12448;
var statearr_12461_12479 = state_12448__$1;
(statearr_12461_12479[(2)] = inst_12442);

(statearr_12461_12479[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (10))){
var inst_12440 = (state_12448[(2)]);
var state_12448__$1 = state_12448;
var statearr_12462_12480 = state_12448__$1;
(statearr_12462_12480[(2)] = inst_12440);

(statearr_12462_12480[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (8))){
var inst_12427 = (state_12448[(7)]);
var inst_12428 = (state_12448[(8)]);
var inst_12418 = (state_12448[(10)]);
var inst_12429 = (state_12448[(9)]);
var inst_12432 = (function (){var cs = inst_12418;
var vec__12423 = inst_12427;
var v = inst_12428;
var c = inst_12429;
return (function (p1__12414_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12414_SHARP_);
});
})();
var inst_12433 = cljs.core.filterv.call(null,inst_12432,inst_12418);
var inst_12418__$1 = inst_12433;
var state_12448__$1 = (function (){var statearr_12463 = state_12448;
(statearr_12463[(10)] = inst_12418__$1);

return statearr_12463;
})();
var statearr_12464_12481 = state_12448__$1;
(statearr_12464_12481[(2)] = null);

(statearr_12464_12481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_12465 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12465[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_12465[(1)] = (1));

return statearr_12465;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_12448){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_12448);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e12466){var ex__11003__auto__ = e12466;
var statearr_12467_12482 = state_12448;
(statearr_12467_12482[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_12448[(4)]))){
var statearr_12468_12483 = state_12448;
(statearr_12468_12483[(1)] = cljs.core.first.call(null,(state_12448[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12484 = state_12448;
state_12448 = G__12484;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_12448){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_12448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_12469 = f__11074__auto__.call(null);
(statearr_12469[(6)] = c__11073__auto___12471);

return statearr_12469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12486 = arguments.length;
switch (G__12486) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___12532 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_12510){
var state_val_12511 = (state_12510[(1)]);
if((state_val_12511 === (7))){
var inst_12492 = (state_12510[(7)]);
var inst_12492__$1 = (state_12510[(2)]);
var inst_12493 = (inst_12492__$1 == null);
var inst_12494 = cljs.core.not.call(null,inst_12493);
var state_12510__$1 = (function (){var statearr_12512 = state_12510;
(statearr_12512[(7)] = inst_12492__$1);

return statearr_12512;
})();
if(inst_12494){
var statearr_12513_12533 = state_12510__$1;
(statearr_12513_12533[(1)] = (8));

} else {
var statearr_12514_12534 = state_12510__$1;
(statearr_12514_12534[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12511 === (1))){
var inst_12487 = (0);
var state_12510__$1 = (function (){var statearr_12515 = state_12510;
(statearr_12515[(8)] = inst_12487);

return statearr_12515;
})();
var statearr_12516_12535 = state_12510__$1;
(statearr_12516_12535[(2)] = null);

(statearr_12516_12535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12511 === (4))){
var state_12510__$1 = state_12510;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12510__$1,(7),ch);
} else {
if((state_val_12511 === (6))){
var inst_12505 = (state_12510[(2)]);
var state_12510__$1 = state_12510;
var statearr_12517_12536 = state_12510__$1;
(statearr_12517_12536[(2)] = inst_12505);

(statearr_12517_12536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12511 === (3))){
var inst_12507 = (state_12510[(2)]);
var inst_12508 = cljs.core.async.close_BANG_.call(null,out);
var state_12510__$1 = (function (){var statearr_12518 = state_12510;
(statearr_12518[(9)] = inst_12507);

return statearr_12518;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12510__$1,inst_12508);
} else {
if((state_val_12511 === (2))){
var inst_12487 = (state_12510[(8)]);
var inst_12489 = (inst_12487 < n);
var state_12510__$1 = state_12510;
if(cljs.core.truth_(inst_12489)){
var statearr_12519_12537 = state_12510__$1;
(statearr_12519_12537[(1)] = (4));

} else {
var statearr_12520_12538 = state_12510__$1;
(statearr_12520_12538[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12511 === (11))){
var inst_12487 = (state_12510[(8)]);
var inst_12497 = (state_12510[(2)]);
var inst_12498 = (inst_12487 + (1));
var inst_12487__$1 = inst_12498;
var state_12510__$1 = (function (){var statearr_12521 = state_12510;
(statearr_12521[(8)] = inst_12487__$1);

(statearr_12521[(10)] = inst_12497);

return statearr_12521;
})();
var statearr_12522_12539 = state_12510__$1;
(statearr_12522_12539[(2)] = null);

(statearr_12522_12539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12511 === (9))){
var state_12510__$1 = state_12510;
var statearr_12523_12540 = state_12510__$1;
(statearr_12523_12540[(2)] = null);

(statearr_12523_12540[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12511 === (5))){
var state_12510__$1 = state_12510;
var statearr_12524_12541 = state_12510__$1;
(statearr_12524_12541[(2)] = null);

(statearr_12524_12541[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12511 === (10))){
var inst_12502 = (state_12510[(2)]);
var state_12510__$1 = state_12510;
var statearr_12525_12542 = state_12510__$1;
(statearr_12525_12542[(2)] = inst_12502);

(statearr_12525_12542[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12511 === (8))){
var inst_12492 = (state_12510[(7)]);
var state_12510__$1 = state_12510;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12510__$1,(11),out,inst_12492);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_12526 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12526[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_12526[(1)] = (1));

return statearr_12526;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_12510){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_12510);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e12527){var ex__11003__auto__ = e12527;
var statearr_12528_12543 = state_12510;
(statearr_12528_12543[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_12510[(4)]))){
var statearr_12529_12544 = state_12510;
(statearr_12529_12544[(1)] = cljs.core.first.call(null,(state_12510[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12545 = state_12510;
state_12510 = G__12545;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_12510){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_12510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_12530 = f__11074__auto__.call(null);
(statearr_12530[(6)] = c__11073__auto___12532);

return statearr_12530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12547 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12547 = (function (f,ch,meta12548){
this.f = f;
this.ch = ch;
this.meta12548 = meta12548;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12547.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12549,meta12548__$1){
var self__ = this;
var _12549__$1 = this;
return (new cljs.core.async.t_cljs$core$async12547(self__.f,self__.ch,meta12548__$1));
}));

(cljs.core.async.t_cljs$core$async12547.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12549){
var self__ = this;
var _12549__$1 = this;
return self__.meta12548;
}));

(cljs.core.async.t_cljs$core$async12547.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12547.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12547.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12547.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12547.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12550 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12550 = (function (f,ch,meta12548,_,fn1,meta12551){
this.f = f;
this.ch = ch;
this.meta12548 = meta12548;
this._ = _;
this.fn1 = fn1;
this.meta12551 = meta12551;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12550.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12552,meta12551__$1){
var self__ = this;
var _12552__$1 = this;
return (new cljs.core.async.t_cljs$core$async12550(self__.f,self__.ch,self__.meta12548,self__._,self__.fn1,meta12551__$1));
}));

(cljs.core.async.t_cljs$core$async12550.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12552){
var self__ = this;
var _12552__$1 = this;
return self__.meta12551;
}));

(cljs.core.async.t_cljs$core$async12550.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12550.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async12550.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12550.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__12546_SHARP_){
return f1.call(null,(((p1__12546_SHARP_ == null))?null:self__.f.call(null,p1__12546_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async12550.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12548","meta12548",-627356540,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12547","cljs.core.async/t_cljs$core$async12547",2123440139,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12551","meta12551",2123883001,null)], null);
}));

(cljs.core.async.t_cljs$core$async12550.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12550.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12550");

(cljs.core.async.t_cljs$core$async12550.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async12550");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12550.
 */
cljs.core.async.__GT_t_cljs$core$async12550 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12550(f__$1,ch__$1,meta12548__$1,___$2,fn1__$1,meta12551){
return (new cljs.core.async.t_cljs$core$async12550(f__$1,ch__$1,meta12548__$1,___$2,fn1__$1,meta12551));
});

}

return (new cljs.core.async.t_cljs$core$async12550(self__.f,self__.ch,self__.meta12548,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async12547.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12547.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async12547.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12548","meta12548",-627356540,null)], null);
}));

(cljs.core.async.t_cljs$core$async12547.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12547.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12547");

(cljs.core.async.t_cljs$core$async12547.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async12547");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12547.
 */
cljs.core.async.__GT_t_cljs$core$async12547 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12547(f__$1,ch__$1,meta12548){
return (new cljs.core.async.t_cljs$core$async12547(f__$1,ch__$1,meta12548));
});

}

return (new cljs.core.async.t_cljs$core$async12547(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12553 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12553 = (function (f,ch,meta12554){
this.f = f;
this.ch = ch;
this.meta12554 = meta12554;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12553.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12555,meta12554__$1){
var self__ = this;
var _12555__$1 = this;
return (new cljs.core.async.t_cljs$core$async12553(self__.f,self__.ch,meta12554__$1));
}));

(cljs.core.async.t_cljs$core$async12553.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12555){
var self__ = this;
var _12555__$1 = this;
return self__.meta12554;
}));

(cljs.core.async.t_cljs$core$async12553.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12553.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12553.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12553.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12553.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12553.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async12553.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12554","meta12554",88410704,null)], null);
}));

(cljs.core.async.t_cljs$core$async12553.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12553.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12553");

(cljs.core.async.t_cljs$core$async12553.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async12553");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12553.
 */
cljs.core.async.__GT_t_cljs$core$async12553 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12553(f__$1,ch__$1,meta12554){
return (new cljs.core.async.t_cljs$core$async12553(f__$1,ch__$1,meta12554));
});

}

return (new cljs.core.async.t_cljs$core$async12553(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12556 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12556 = (function (p,ch,meta12557){
this.p = p;
this.ch = ch;
this.meta12557 = meta12557;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12556.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12558,meta12557__$1){
var self__ = this;
var _12558__$1 = this;
return (new cljs.core.async.t_cljs$core$async12556(self__.p,self__.ch,meta12557__$1));
}));

(cljs.core.async.t_cljs$core$async12556.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12558){
var self__ = this;
var _12558__$1 = this;
return self__.meta12557;
}));

(cljs.core.async.t_cljs$core$async12556.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12556.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12556.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12556.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12556.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12556.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12556.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async12556.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12557","meta12557",1228411040,null)], null);
}));

(cljs.core.async.t_cljs$core$async12556.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12556.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12556");

(cljs.core.async.t_cljs$core$async12556.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async12556");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12556.
 */
cljs.core.async.__GT_t_cljs$core$async12556 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12556(p__$1,ch__$1,meta12557){
return (new cljs.core.async.t_cljs$core$async12556(p__$1,ch__$1,meta12557));
});

}

return (new cljs.core.async.t_cljs$core$async12556(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__12560 = arguments.length;
switch (G__12560) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___12601 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_12581){
var state_val_12582 = (state_12581[(1)]);
if((state_val_12582 === (7))){
var inst_12577 = (state_12581[(2)]);
var state_12581__$1 = state_12581;
var statearr_12583_12602 = state_12581__$1;
(statearr_12583_12602[(2)] = inst_12577);

(statearr_12583_12602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12582 === (1))){
var state_12581__$1 = state_12581;
var statearr_12584_12603 = state_12581__$1;
(statearr_12584_12603[(2)] = null);

(statearr_12584_12603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12582 === (4))){
var inst_12563 = (state_12581[(7)]);
var inst_12563__$1 = (state_12581[(2)]);
var inst_12564 = (inst_12563__$1 == null);
var state_12581__$1 = (function (){var statearr_12585 = state_12581;
(statearr_12585[(7)] = inst_12563__$1);

return statearr_12585;
})();
if(cljs.core.truth_(inst_12564)){
var statearr_12586_12604 = state_12581__$1;
(statearr_12586_12604[(1)] = (5));

} else {
var statearr_12587_12605 = state_12581__$1;
(statearr_12587_12605[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12582 === (6))){
var inst_12563 = (state_12581[(7)]);
var inst_12568 = p.call(null,inst_12563);
var state_12581__$1 = state_12581;
if(cljs.core.truth_(inst_12568)){
var statearr_12588_12606 = state_12581__$1;
(statearr_12588_12606[(1)] = (8));

} else {
var statearr_12589_12607 = state_12581__$1;
(statearr_12589_12607[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12582 === (3))){
var inst_12579 = (state_12581[(2)]);
var state_12581__$1 = state_12581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12581__$1,inst_12579);
} else {
if((state_val_12582 === (2))){
var state_12581__$1 = state_12581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12581__$1,(4),ch);
} else {
if((state_val_12582 === (11))){
var inst_12571 = (state_12581[(2)]);
var state_12581__$1 = state_12581;
var statearr_12590_12608 = state_12581__$1;
(statearr_12590_12608[(2)] = inst_12571);

(statearr_12590_12608[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12582 === (9))){
var state_12581__$1 = state_12581;
var statearr_12591_12609 = state_12581__$1;
(statearr_12591_12609[(2)] = null);

(statearr_12591_12609[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12582 === (5))){
var inst_12566 = cljs.core.async.close_BANG_.call(null,out);
var state_12581__$1 = state_12581;
var statearr_12592_12610 = state_12581__$1;
(statearr_12592_12610[(2)] = inst_12566);

(statearr_12592_12610[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12582 === (10))){
var inst_12574 = (state_12581[(2)]);
var state_12581__$1 = (function (){var statearr_12593 = state_12581;
(statearr_12593[(8)] = inst_12574);

return statearr_12593;
})();
var statearr_12594_12611 = state_12581__$1;
(statearr_12594_12611[(2)] = null);

(statearr_12594_12611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12582 === (8))){
var inst_12563 = (state_12581[(7)]);
var state_12581__$1 = state_12581;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12581__$1,(11),out,inst_12563);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_12595 = [null,null,null,null,null,null,null,null,null];
(statearr_12595[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_12595[(1)] = (1));

return statearr_12595;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_12581){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_12581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e12596){var ex__11003__auto__ = e12596;
var statearr_12597_12612 = state_12581;
(statearr_12597_12612[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_12581[(4)]))){
var statearr_12598_12613 = state_12581;
(statearr_12598_12613[(1)] = cljs.core.first.call(null,(state_12581[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12614 = state_12581;
state_12581 = G__12614;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_12581){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_12581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_12599 = f__11074__auto__.call(null);
(statearr_12599[(6)] = c__11073__auto___12601);

return statearr_12599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__12616 = arguments.length;
switch (G__12616) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_12679){
var state_val_12680 = (state_12679[(1)]);
if((state_val_12680 === (7))){
var inst_12675 = (state_12679[(2)]);
var state_12679__$1 = state_12679;
var statearr_12681_12720 = state_12679__$1;
(statearr_12681_12720[(2)] = inst_12675);

(statearr_12681_12720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (20))){
var inst_12645 = (state_12679[(7)]);
var inst_12656 = (state_12679[(2)]);
var inst_12657 = cljs.core.next.call(null,inst_12645);
var inst_12631 = inst_12657;
var inst_12632 = null;
var inst_12633 = (0);
var inst_12634 = (0);
var state_12679__$1 = (function (){var statearr_12682 = state_12679;
(statearr_12682[(8)] = inst_12656);

(statearr_12682[(9)] = inst_12633);

(statearr_12682[(10)] = inst_12634);

(statearr_12682[(11)] = inst_12632);

(statearr_12682[(12)] = inst_12631);

return statearr_12682;
})();
var statearr_12683_12721 = state_12679__$1;
(statearr_12683_12721[(2)] = null);

(statearr_12683_12721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (1))){
var state_12679__$1 = state_12679;
var statearr_12684_12722 = state_12679__$1;
(statearr_12684_12722[(2)] = null);

(statearr_12684_12722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (4))){
var inst_12620 = (state_12679[(13)]);
var inst_12620__$1 = (state_12679[(2)]);
var inst_12621 = (inst_12620__$1 == null);
var state_12679__$1 = (function (){var statearr_12685 = state_12679;
(statearr_12685[(13)] = inst_12620__$1);

return statearr_12685;
})();
if(cljs.core.truth_(inst_12621)){
var statearr_12686_12723 = state_12679__$1;
(statearr_12686_12723[(1)] = (5));

} else {
var statearr_12687_12724 = state_12679__$1;
(statearr_12687_12724[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (15))){
var state_12679__$1 = state_12679;
var statearr_12691_12725 = state_12679__$1;
(statearr_12691_12725[(2)] = null);

(statearr_12691_12725[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (21))){
var state_12679__$1 = state_12679;
var statearr_12692_12726 = state_12679__$1;
(statearr_12692_12726[(2)] = null);

(statearr_12692_12726[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (13))){
var inst_12633 = (state_12679[(9)]);
var inst_12634 = (state_12679[(10)]);
var inst_12632 = (state_12679[(11)]);
var inst_12631 = (state_12679[(12)]);
var inst_12641 = (state_12679[(2)]);
var inst_12642 = (inst_12634 + (1));
var tmp12688 = inst_12633;
var tmp12689 = inst_12632;
var tmp12690 = inst_12631;
var inst_12631__$1 = tmp12690;
var inst_12632__$1 = tmp12689;
var inst_12633__$1 = tmp12688;
var inst_12634__$1 = inst_12642;
var state_12679__$1 = (function (){var statearr_12693 = state_12679;
(statearr_12693[(9)] = inst_12633__$1);

(statearr_12693[(10)] = inst_12634__$1);

(statearr_12693[(14)] = inst_12641);

(statearr_12693[(11)] = inst_12632__$1);

(statearr_12693[(12)] = inst_12631__$1);

return statearr_12693;
})();
var statearr_12694_12727 = state_12679__$1;
(statearr_12694_12727[(2)] = null);

(statearr_12694_12727[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (22))){
var state_12679__$1 = state_12679;
var statearr_12695_12728 = state_12679__$1;
(statearr_12695_12728[(2)] = null);

(statearr_12695_12728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (6))){
var inst_12620 = (state_12679[(13)]);
var inst_12629 = f.call(null,inst_12620);
var inst_12630 = cljs.core.seq.call(null,inst_12629);
var inst_12631 = inst_12630;
var inst_12632 = null;
var inst_12633 = (0);
var inst_12634 = (0);
var state_12679__$1 = (function (){var statearr_12696 = state_12679;
(statearr_12696[(9)] = inst_12633);

(statearr_12696[(10)] = inst_12634);

(statearr_12696[(11)] = inst_12632);

(statearr_12696[(12)] = inst_12631);

return statearr_12696;
})();
var statearr_12697_12729 = state_12679__$1;
(statearr_12697_12729[(2)] = null);

(statearr_12697_12729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (17))){
var inst_12645 = (state_12679[(7)]);
var inst_12649 = cljs.core.chunk_first.call(null,inst_12645);
var inst_12650 = cljs.core.chunk_rest.call(null,inst_12645);
var inst_12651 = cljs.core.count.call(null,inst_12649);
var inst_12631 = inst_12650;
var inst_12632 = inst_12649;
var inst_12633 = inst_12651;
var inst_12634 = (0);
var state_12679__$1 = (function (){var statearr_12698 = state_12679;
(statearr_12698[(9)] = inst_12633);

(statearr_12698[(10)] = inst_12634);

(statearr_12698[(11)] = inst_12632);

(statearr_12698[(12)] = inst_12631);

return statearr_12698;
})();
var statearr_12699_12730 = state_12679__$1;
(statearr_12699_12730[(2)] = null);

(statearr_12699_12730[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (3))){
var inst_12677 = (state_12679[(2)]);
var state_12679__$1 = state_12679;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12679__$1,inst_12677);
} else {
if((state_val_12680 === (12))){
var inst_12665 = (state_12679[(2)]);
var state_12679__$1 = state_12679;
var statearr_12700_12731 = state_12679__$1;
(statearr_12700_12731[(2)] = inst_12665);

(statearr_12700_12731[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (2))){
var state_12679__$1 = state_12679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12679__$1,(4),in$);
} else {
if((state_val_12680 === (23))){
var inst_12673 = (state_12679[(2)]);
var state_12679__$1 = state_12679;
var statearr_12701_12732 = state_12679__$1;
(statearr_12701_12732[(2)] = inst_12673);

(statearr_12701_12732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (19))){
var inst_12660 = (state_12679[(2)]);
var state_12679__$1 = state_12679;
var statearr_12702_12733 = state_12679__$1;
(statearr_12702_12733[(2)] = inst_12660);

(statearr_12702_12733[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (11))){
var inst_12645 = (state_12679[(7)]);
var inst_12631 = (state_12679[(12)]);
var inst_12645__$1 = cljs.core.seq.call(null,inst_12631);
var state_12679__$1 = (function (){var statearr_12703 = state_12679;
(statearr_12703[(7)] = inst_12645__$1);

return statearr_12703;
})();
if(inst_12645__$1){
var statearr_12704_12734 = state_12679__$1;
(statearr_12704_12734[(1)] = (14));

} else {
var statearr_12705_12735 = state_12679__$1;
(statearr_12705_12735[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (9))){
var inst_12667 = (state_12679[(2)]);
var inst_12668 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_12679__$1 = (function (){var statearr_12706 = state_12679;
(statearr_12706[(15)] = inst_12667);

return statearr_12706;
})();
if(cljs.core.truth_(inst_12668)){
var statearr_12707_12736 = state_12679__$1;
(statearr_12707_12736[(1)] = (21));

} else {
var statearr_12708_12737 = state_12679__$1;
(statearr_12708_12737[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (5))){
var inst_12623 = cljs.core.async.close_BANG_.call(null,out);
var state_12679__$1 = state_12679;
var statearr_12709_12738 = state_12679__$1;
(statearr_12709_12738[(2)] = inst_12623);

(statearr_12709_12738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (14))){
var inst_12645 = (state_12679[(7)]);
var inst_12647 = cljs.core.chunked_seq_QMARK_.call(null,inst_12645);
var state_12679__$1 = state_12679;
if(inst_12647){
var statearr_12710_12739 = state_12679__$1;
(statearr_12710_12739[(1)] = (17));

} else {
var statearr_12711_12740 = state_12679__$1;
(statearr_12711_12740[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (16))){
var inst_12663 = (state_12679[(2)]);
var state_12679__$1 = state_12679;
var statearr_12712_12741 = state_12679__$1;
(statearr_12712_12741[(2)] = inst_12663);

(statearr_12712_12741[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12680 === (10))){
var inst_12634 = (state_12679[(10)]);
var inst_12632 = (state_12679[(11)]);
var inst_12639 = cljs.core._nth.call(null,inst_12632,inst_12634);
var state_12679__$1 = state_12679;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12679__$1,(13),out,inst_12639);
} else {
if((state_val_12680 === (18))){
var inst_12645 = (state_12679[(7)]);
var inst_12654 = cljs.core.first.call(null,inst_12645);
var state_12679__$1 = state_12679;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12679__$1,(20),out,inst_12654);
} else {
if((state_val_12680 === (8))){
var inst_12633 = (state_12679[(9)]);
var inst_12634 = (state_12679[(10)]);
var inst_12636 = (inst_12634 < inst_12633);
var inst_12637 = inst_12636;
var state_12679__$1 = state_12679;
if(cljs.core.truth_(inst_12637)){
var statearr_12713_12742 = state_12679__$1;
(statearr_12713_12742[(1)] = (10));

} else {
var statearr_12714_12743 = state_12679__$1;
(statearr_12714_12743[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11000__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11000__auto____0 = (function (){
var statearr_12715 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12715[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11000__auto__);

(statearr_12715[(1)] = (1));

return statearr_12715;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11000__auto____1 = (function (state_12679){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_12679);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e12716){var ex__11003__auto__ = e12716;
var statearr_12717_12744 = state_12679;
(statearr_12717_12744[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_12679[(4)]))){
var statearr_12718_12745 = state_12679;
(statearr_12718_12745[(1)] = cljs.core.first.call(null,(state_12679[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12746 = state_12679;
state_12679 = G__12746;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11000__auto__ = function(state_12679){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11000__auto____1.call(this,state_12679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11000__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11000__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_12719 = f__11074__auto__.call(null);
(statearr_12719[(6)] = c__11073__auto__);

return statearr_12719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));

return c__11073__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__12748 = arguments.length;
switch (G__12748) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__12751 = arguments.length;
switch (G__12751) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__12754 = arguments.length;
switch (G__12754) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___12802 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_12778){
var state_val_12779 = (state_12778[(1)]);
if((state_val_12779 === (7))){
var inst_12773 = (state_12778[(2)]);
var state_12778__$1 = state_12778;
var statearr_12780_12803 = state_12778__$1;
(statearr_12780_12803[(2)] = inst_12773);

(statearr_12780_12803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (1))){
var inst_12755 = null;
var state_12778__$1 = (function (){var statearr_12781 = state_12778;
(statearr_12781[(7)] = inst_12755);

return statearr_12781;
})();
var statearr_12782_12804 = state_12778__$1;
(statearr_12782_12804[(2)] = null);

(statearr_12782_12804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (4))){
var inst_12758 = (state_12778[(8)]);
var inst_12758__$1 = (state_12778[(2)]);
var inst_12759 = (inst_12758__$1 == null);
var inst_12760 = cljs.core.not.call(null,inst_12759);
var state_12778__$1 = (function (){var statearr_12783 = state_12778;
(statearr_12783[(8)] = inst_12758__$1);

return statearr_12783;
})();
if(inst_12760){
var statearr_12784_12805 = state_12778__$1;
(statearr_12784_12805[(1)] = (5));

} else {
var statearr_12785_12806 = state_12778__$1;
(statearr_12785_12806[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (6))){
var state_12778__$1 = state_12778;
var statearr_12786_12807 = state_12778__$1;
(statearr_12786_12807[(2)] = null);

(statearr_12786_12807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (3))){
var inst_12775 = (state_12778[(2)]);
var inst_12776 = cljs.core.async.close_BANG_.call(null,out);
var state_12778__$1 = (function (){var statearr_12787 = state_12778;
(statearr_12787[(9)] = inst_12775);

return statearr_12787;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12778__$1,inst_12776);
} else {
if((state_val_12779 === (2))){
var state_12778__$1 = state_12778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12778__$1,(4),ch);
} else {
if((state_val_12779 === (11))){
var inst_12758 = (state_12778[(8)]);
var inst_12767 = (state_12778[(2)]);
var inst_12755 = inst_12758;
var state_12778__$1 = (function (){var statearr_12788 = state_12778;
(statearr_12788[(7)] = inst_12755);

(statearr_12788[(10)] = inst_12767);

return statearr_12788;
})();
var statearr_12789_12808 = state_12778__$1;
(statearr_12789_12808[(2)] = null);

(statearr_12789_12808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (9))){
var inst_12758 = (state_12778[(8)]);
var state_12778__$1 = state_12778;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12778__$1,(11),out,inst_12758);
} else {
if((state_val_12779 === (5))){
var inst_12758 = (state_12778[(8)]);
var inst_12755 = (state_12778[(7)]);
var inst_12762 = cljs.core._EQ_.call(null,inst_12758,inst_12755);
var state_12778__$1 = state_12778;
if(inst_12762){
var statearr_12791_12809 = state_12778__$1;
(statearr_12791_12809[(1)] = (8));

} else {
var statearr_12792_12810 = state_12778__$1;
(statearr_12792_12810[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (10))){
var inst_12770 = (state_12778[(2)]);
var state_12778__$1 = state_12778;
var statearr_12793_12811 = state_12778__$1;
(statearr_12793_12811[(2)] = inst_12770);

(statearr_12793_12811[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (8))){
var inst_12755 = (state_12778[(7)]);
var tmp12790 = inst_12755;
var inst_12755__$1 = tmp12790;
var state_12778__$1 = (function (){var statearr_12794 = state_12778;
(statearr_12794[(7)] = inst_12755__$1);

return statearr_12794;
})();
var statearr_12795_12812 = state_12778__$1;
(statearr_12795_12812[(2)] = null);

(statearr_12795_12812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_12796 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12796[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_12796[(1)] = (1));

return statearr_12796;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_12778){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_12778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e12797){var ex__11003__auto__ = e12797;
var statearr_12798_12813 = state_12778;
(statearr_12798_12813[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_12778[(4)]))){
var statearr_12799_12814 = state_12778;
(statearr_12799_12814[(1)] = cljs.core.first.call(null,(state_12778[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12815 = state_12778;
state_12778 = G__12815;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_12778){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_12778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_12800 = f__11074__auto__.call(null);
(statearr_12800[(6)] = c__11073__auto___12802);

return statearr_12800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__12817 = arguments.length;
switch (G__12817) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___12884 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_12855){
var state_val_12856 = (state_12855[(1)]);
if((state_val_12856 === (7))){
var inst_12851 = (state_12855[(2)]);
var state_12855__$1 = state_12855;
var statearr_12857_12885 = state_12855__$1;
(statearr_12857_12885[(2)] = inst_12851);

(statearr_12857_12885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12856 === (1))){
var inst_12818 = (new Array(n));
var inst_12819 = inst_12818;
var inst_12820 = (0);
var state_12855__$1 = (function (){var statearr_12858 = state_12855;
(statearr_12858[(7)] = inst_12820);

(statearr_12858[(8)] = inst_12819);

return statearr_12858;
})();
var statearr_12859_12886 = state_12855__$1;
(statearr_12859_12886[(2)] = null);

(statearr_12859_12886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12856 === (4))){
var inst_12823 = (state_12855[(9)]);
var inst_12823__$1 = (state_12855[(2)]);
var inst_12824 = (inst_12823__$1 == null);
var inst_12825 = cljs.core.not.call(null,inst_12824);
var state_12855__$1 = (function (){var statearr_12860 = state_12855;
(statearr_12860[(9)] = inst_12823__$1);

return statearr_12860;
})();
if(inst_12825){
var statearr_12861_12887 = state_12855__$1;
(statearr_12861_12887[(1)] = (5));

} else {
var statearr_12862_12888 = state_12855__$1;
(statearr_12862_12888[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12856 === (15))){
var inst_12845 = (state_12855[(2)]);
var state_12855__$1 = state_12855;
var statearr_12863_12889 = state_12855__$1;
(statearr_12863_12889[(2)] = inst_12845);

(statearr_12863_12889[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12856 === (13))){
var state_12855__$1 = state_12855;
var statearr_12864_12890 = state_12855__$1;
(statearr_12864_12890[(2)] = null);

(statearr_12864_12890[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12856 === (6))){
var inst_12820 = (state_12855[(7)]);
var inst_12841 = (inst_12820 > (0));
var state_12855__$1 = state_12855;
if(cljs.core.truth_(inst_12841)){
var statearr_12865_12891 = state_12855__$1;
(statearr_12865_12891[(1)] = (12));

} else {
var statearr_12866_12892 = state_12855__$1;
(statearr_12866_12892[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12856 === (3))){
var inst_12853 = (state_12855[(2)]);
var state_12855__$1 = state_12855;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12855__$1,inst_12853);
} else {
if((state_val_12856 === (12))){
var inst_12819 = (state_12855[(8)]);
var inst_12843 = cljs.core.vec.call(null,inst_12819);
var state_12855__$1 = state_12855;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12855__$1,(15),out,inst_12843);
} else {
if((state_val_12856 === (2))){
var state_12855__$1 = state_12855;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12855__$1,(4),ch);
} else {
if((state_val_12856 === (11))){
var inst_12835 = (state_12855[(2)]);
var inst_12836 = (new Array(n));
var inst_12819 = inst_12836;
var inst_12820 = (0);
var state_12855__$1 = (function (){var statearr_12867 = state_12855;
(statearr_12867[(7)] = inst_12820);

(statearr_12867[(10)] = inst_12835);

(statearr_12867[(8)] = inst_12819);

return statearr_12867;
})();
var statearr_12868_12893 = state_12855__$1;
(statearr_12868_12893[(2)] = null);

(statearr_12868_12893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12856 === (9))){
var inst_12819 = (state_12855[(8)]);
var inst_12833 = cljs.core.vec.call(null,inst_12819);
var state_12855__$1 = state_12855;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12855__$1,(11),out,inst_12833);
} else {
if((state_val_12856 === (5))){
var inst_12823 = (state_12855[(9)]);
var inst_12820 = (state_12855[(7)]);
var inst_12819 = (state_12855[(8)]);
var inst_12828 = (state_12855[(11)]);
var inst_12827 = (inst_12819[inst_12820] = inst_12823);
var inst_12828__$1 = (inst_12820 + (1));
var inst_12829 = (inst_12828__$1 < n);
var state_12855__$1 = (function (){var statearr_12869 = state_12855;
(statearr_12869[(12)] = inst_12827);

(statearr_12869[(11)] = inst_12828__$1);

return statearr_12869;
})();
if(cljs.core.truth_(inst_12829)){
var statearr_12870_12894 = state_12855__$1;
(statearr_12870_12894[(1)] = (8));

} else {
var statearr_12871_12895 = state_12855__$1;
(statearr_12871_12895[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12856 === (14))){
var inst_12848 = (state_12855[(2)]);
var inst_12849 = cljs.core.async.close_BANG_.call(null,out);
var state_12855__$1 = (function (){var statearr_12873 = state_12855;
(statearr_12873[(13)] = inst_12848);

return statearr_12873;
})();
var statearr_12874_12896 = state_12855__$1;
(statearr_12874_12896[(2)] = inst_12849);

(statearr_12874_12896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12856 === (10))){
var inst_12839 = (state_12855[(2)]);
var state_12855__$1 = state_12855;
var statearr_12875_12897 = state_12855__$1;
(statearr_12875_12897[(2)] = inst_12839);

(statearr_12875_12897[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12856 === (8))){
var inst_12819 = (state_12855[(8)]);
var inst_12828 = (state_12855[(11)]);
var tmp12872 = inst_12819;
var inst_12819__$1 = tmp12872;
var inst_12820 = inst_12828;
var state_12855__$1 = (function (){var statearr_12876 = state_12855;
(statearr_12876[(7)] = inst_12820);

(statearr_12876[(8)] = inst_12819__$1);

return statearr_12876;
})();
var statearr_12877_12898 = state_12855__$1;
(statearr_12877_12898[(2)] = null);

(statearr_12877_12898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_12878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12878[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_12878[(1)] = (1));

return statearr_12878;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_12855){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_12855);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e12879){var ex__11003__auto__ = e12879;
var statearr_12880_12899 = state_12855;
(statearr_12880_12899[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_12855[(4)]))){
var statearr_12881_12900 = state_12855;
(statearr_12881_12900[(1)] = cljs.core.first.call(null,(state_12855[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12901 = state_12855;
state_12855 = G__12901;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_12855){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_12855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_12882 = f__11074__auto__.call(null);
(statearr_12882[(6)] = c__11073__auto___12884);

return statearr_12882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__12903 = arguments.length;
switch (G__12903) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___12981 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11074__auto__ = (function (){var switch__10999__auto__ = (function (state_12948){
var state_val_12949 = (state_12948[(1)]);
if((state_val_12949 === (7))){
var inst_12944 = (state_12948[(2)]);
var state_12948__$1 = state_12948;
var statearr_12950_12982 = state_12948__$1;
(statearr_12950_12982[(2)] = inst_12944);

(statearr_12950_12982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (1))){
var inst_12904 = [];
var inst_12905 = inst_12904;
var inst_12906 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_12948__$1 = (function (){var statearr_12951 = state_12948;
(statearr_12951[(7)] = inst_12906);

(statearr_12951[(8)] = inst_12905);

return statearr_12951;
})();
var statearr_12952_12983 = state_12948__$1;
(statearr_12952_12983[(2)] = null);

(statearr_12952_12983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (4))){
var inst_12909 = (state_12948[(9)]);
var inst_12909__$1 = (state_12948[(2)]);
var inst_12910 = (inst_12909__$1 == null);
var inst_12911 = cljs.core.not.call(null,inst_12910);
var state_12948__$1 = (function (){var statearr_12953 = state_12948;
(statearr_12953[(9)] = inst_12909__$1);

return statearr_12953;
})();
if(inst_12911){
var statearr_12954_12984 = state_12948__$1;
(statearr_12954_12984[(1)] = (5));

} else {
var statearr_12955_12985 = state_12948__$1;
(statearr_12955_12985[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (15))){
var inst_12905 = (state_12948[(8)]);
var inst_12936 = cljs.core.vec.call(null,inst_12905);
var state_12948__$1 = state_12948;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12948__$1,(18),out,inst_12936);
} else {
if((state_val_12949 === (13))){
var inst_12931 = (state_12948[(2)]);
var state_12948__$1 = state_12948;
var statearr_12956_12986 = state_12948__$1;
(statearr_12956_12986[(2)] = inst_12931);

(statearr_12956_12986[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (6))){
var inst_12905 = (state_12948[(8)]);
var inst_12933 = inst_12905.length;
var inst_12934 = (inst_12933 > (0));
var state_12948__$1 = state_12948;
if(cljs.core.truth_(inst_12934)){
var statearr_12957_12987 = state_12948__$1;
(statearr_12957_12987[(1)] = (15));

} else {
var statearr_12958_12988 = state_12948__$1;
(statearr_12958_12988[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (17))){
var inst_12941 = (state_12948[(2)]);
var inst_12942 = cljs.core.async.close_BANG_.call(null,out);
var state_12948__$1 = (function (){var statearr_12959 = state_12948;
(statearr_12959[(10)] = inst_12941);

return statearr_12959;
})();
var statearr_12960_12989 = state_12948__$1;
(statearr_12960_12989[(2)] = inst_12942);

(statearr_12960_12989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (3))){
var inst_12946 = (state_12948[(2)]);
var state_12948__$1 = state_12948;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12948__$1,inst_12946);
} else {
if((state_val_12949 === (12))){
var inst_12905 = (state_12948[(8)]);
var inst_12924 = cljs.core.vec.call(null,inst_12905);
var state_12948__$1 = state_12948;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12948__$1,(14),out,inst_12924);
} else {
if((state_val_12949 === (2))){
var state_12948__$1 = state_12948;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12948__$1,(4),ch);
} else {
if((state_val_12949 === (11))){
var inst_12913 = (state_12948[(11)]);
var inst_12909 = (state_12948[(9)]);
var inst_12905 = (state_12948[(8)]);
var inst_12921 = inst_12905.push(inst_12909);
var tmp12961 = inst_12905;
var inst_12905__$1 = tmp12961;
var inst_12906 = inst_12913;
var state_12948__$1 = (function (){var statearr_12962 = state_12948;
(statearr_12962[(7)] = inst_12906);

(statearr_12962[(12)] = inst_12921);

(statearr_12962[(8)] = inst_12905__$1);

return statearr_12962;
})();
var statearr_12963_12990 = state_12948__$1;
(statearr_12963_12990[(2)] = null);

(statearr_12963_12990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (9))){
var inst_12906 = (state_12948[(7)]);
var inst_12917 = cljs.core.keyword_identical_QMARK_.call(null,inst_12906,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_12948__$1 = state_12948;
var statearr_12964_12991 = state_12948__$1;
(statearr_12964_12991[(2)] = inst_12917);

(statearr_12964_12991[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (5))){
var inst_12913 = (state_12948[(11)]);
var inst_12909 = (state_12948[(9)]);
var inst_12906 = (state_12948[(7)]);
var inst_12914 = (state_12948[(13)]);
var inst_12913__$1 = f.call(null,inst_12909);
var inst_12914__$1 = cljs.core._EQ_.call(null,inst_12913__$1,inst_12906);
var state_12948__$1 = (function (){var statearr_12965 = state_12948;
(statearr_12965[(11)] = inst_12913__$1);

(statearr_12965[(13)] = inst_12914__$1);

return statearr_12965;
})();
if(inst_12914__$1){
var statearr_12966_12992 = state_12948__$1;
(statearr_12966_12992[(1)] = (8));

} else {
var statearr_12967_12993 = state_12948__$1;
(statearr_12967_12993[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (14))){
var inst_12913 = (state_12948[(11)]);
var inst_12909 = (state_12948[(9)]);
var inst_12926 = (state_12948[(2)]);
var inst_12927 = [];
var inst_12928 = inst_12927.push(inst_12909);
var inst_12905 = inst_12927;
var inst_12906 = inst_12913;
var state_12948__$1 = (function (){var statearr_12968 = state_12948;
(statearr_12968[(14)] = inst_12928);

(statearr_12968[(15)] = inst_12926);

(statearr_12968[(7)] = inst_12906);

(statearr_12968[(8)] = inst_12905);

return statearr_12968;
})();
var statearr_12969_12994 = state_12948__$1;
(statearr_12969_12994[(2)] = null);

(statearr_12969_12994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (16))){
var state_12948__$1 = state_12948;
var statearr_12970_12995 = state_12948__$1;
(statearr_12970_12995[(2)] = null);

(statearr_12970_12995[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (10))){
var inst_12919 = (state_12948[(2)]);
var state_12948__$1 = state_12948;
if(cljs.core.truth_(inst_12919)){
var statearr_12971_12996 = state_12948__$1;
(statearr_12971_12996[(1)] = (11));

} else {
var statearr_12972_12997 = state_12948__$1;
(statearr_12972_12997[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (18))){
var inst_12938 = (state_12948[(2)]);
var state_12948__$1 = state_12948;
var statearr_12973_12998 = state_12948__$1;
(statearr_12973_12998[(2)] = inst_12938);

(statearr_12973_12998[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12949 === (8))){
var inst_12914 = (state_12948[(13)]);
var state_12948__$1 = state_12948;
var statearr_12974_12999 = state_12948__$1;
(statearr_12974_12999[(2)] = inst_12914);

(statearr_12974_12999[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11000__auto__ = null;
var cljs$core$async$state_machine__11000__auto____0 = (function (){
var statearr_12975 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12975[(0)] = cljs$core$async$state_machine__11000__auto__);

(statearr_12975[(1)] = (1));

return statearr_12975;
});
var cljs$core$async$state_machine__11000__auto____1 = (function (state_12948){
while(true){
var ret_value__11001__auto__ = (function (){try{while(true){
var result__11002__auto__ = switch__10999__auto__.call(null,state_12948);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11002__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11002__auto__;
}
break;
}
}catch (e12976){var ex__11003__auto__ = e12976;
var statearr_12977_13000 = state_12948;
(statearr_12977_13000[(2)] = ex__11003__auto__);


if(cljs.core.seq.call(null,(state_12948[(4)]))){
var statearr_12978_13001 = state_12948;
(statearr_12978_13001[(1)] = cljs.core.first.call(null,(state_12948[(4)])));

} else {
throw ex__11003__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11001__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13002 = state_12948;
state_12948 = G__13002;
continue;
} else {
return ret_value__11001__auto__;
}
break;
}
});
cljs$core$async$state_machine__11000__auto__ = function(state_12948){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11000__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11000__auto____1.call(this,state_12948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11000__auto____0;
cljs$core$async$state_machine__11000__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11000__auto____1;
return cljs$core$async$state_machine__11000__auto__;
})()
})();
var state__11075__auto__ = (function (){var statearr_12979 = f__11074__auto__.call(null);
(statearr_12979[(6)] = c__11073__auto___12981);

return statearr_12979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

