// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__77650 = arguments.length;
switch (G__77650) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2706__auto___77689 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77671){
var state_val_77672 = (state_77671[(1)]);
if((state_val_77672 === (1))){
var state_77671__$1 = state_77671;
var statearr_77673_77690 = state_77671__$1;
(statearr_77673_77690[(2)] = null);

(statearr_77673_77690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77672 === (2))){
var _ = (function (){var statearr_77674 = state_77671;
(statearr_77674[(4)] = cljs.core.cons.call(null,(5),(state_77671[(4)])));

return statearr_77674;
})();
var inst_77657 = fluree.db.session.db.call(null,conn,ledger,null);
var state_77671__$1 = state_77671;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77671__$1,(7),inst_77657);
} else {
if((state_val_77672 === (3))){
var inst_77667 = (state_77671[(2)]);
var inst_77668 = cljs.core.async.put_BANG_.call(null,pc,inst_77667);
var inst_77669 = cljs.core.async.close_BANG_.call(null,pc);
var state_77671__$1 = (function (){var statearr_77676 = state_77671;
(statearr_77676[(7)] = inst_77668);

return statearr_77676;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77671__$1,inst_77669);
} else {
if((state_val_77672 === (4))){
var inst_77651 = (state_77671[(2)]);
var state_77671__$1 = state_77671;
var statearr_77677_77691 = state_77671__$1;
(statearr_77677_77691[(2)] = inst_77651);

(statearr_77677_77691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77672 === (5))){
var _ = (function (){var statearr_77678 = state_77671;
(statearr_77678[(4)] = cljs.core.rest.call(null,(state_77671[(4)])));

return statearr_77678;
})();
var state_77671__$1 = state_77671;
var ex77675 = (state_77671__$1[(2)]);
var statearr_77679_77692 = state_77671__$1;
(statearr_77679_77692[(5)] = ex77675);


var statearr_77680_77693 = state_77671__$1;
(statearr_77680_77693[(1)] = (4));

(statearr_77680_77693[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77672 === (6))){
var inst_77663 = (state_77671[(2)]);
var inst_77664 = fluree.db.util.async.throw_err.call(null,inst_77663);
var _ = (function (){var statearr_77681 = state_77671;
(statearr_77681[(4)] = cljs.core.rest.call(null,(state_77671[(4)])));

return statearr_77681;
})();
var state_77671__$1 = state_77671;
var statearr_77682_77694 = state_77671__$1;
(statearr_77682_77694[(2)] = inst_77664);

(statearr_77682_77694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77672 === (7))){
var inst_77659 = (state_77671[(2)]);
var inst_77660 = fluree.db.util.async.throw_err.call(null,inst_77659);
var inst_77661 = fluree.db.time_travel.as_of_block.call(null,inst_77660,block);
var state_77671__$1 = state_77671;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77671__$1,(6),inst_77661);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_77683 = [null,null,null,null,null,null,null,null];
(statearr_77683[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_77683[(1)] = (1));

return statearr_77683;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_77671){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_77671);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77684){var ex__2687__auto__ = e77684;
var statearr_77685_77695 = state_77671;
(statearr_77685_77695[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_77671[(4)]))){
var statearr_77686_77696 = state_77671;
(statearr_77686_77696[(1)] = cljs.core.first.call(null,(state_77671[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77697 = state_77671;
state_77671 = G__77697;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_77671){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_77671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77687 = f__2707__auto__.call(null);
(statearr_77687[(6)] = c__2706__auto___77689);

return statearr_77687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77738){
var state_val_77739 = (state_77738[(1)]);
if((state_val_77739 === (7))){
var inst_77707 = cljs.core._EQ_.call(null,(0),auth);
var state_77738__$1 = state_77738;
if(inst_77707){
var statearr_77740_77771 = state_77738__$1;
(statearr_77740_77771[(1)] = (9));

} else {
var statearr_77741_77772 = state_77738__$1;
(statearr_77741_77772[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (1))){
var state_77738__$1 = state_77738;
var statearr_77742_77773 = state_77738__$1;
(statearr_77742_77773[(2)] = null);

(statearr_77742_77773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (4))){
var inst_77698 = (state_77738[(2)]);
var state_77738__$1 = state_77738;
var statearr_77743_77774 = state_77738__$1;
(statearr_77743_77774[(2)] = inst_77698);

(statearr_77743_77774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (15))){
var inst_77715 = (state_77738[(7)]);
var inst_77714 = (state_77738[(2)]);
var inst_77715__$1 = fluree.db.util.async.throw_err.call(null,inst_77714);
var state_77738__$1 = (function (){var statearr_77744 = state_77738;
(statearr_77744[(7)] = inst_77715__$1);

return statearr_77744;
})();
if(cljs.core.truth_(inst_77715__$1)){
var statearr_77745_77775 = state_77738__$1;
(statearr_77745_77775[(1)] = (16));

} else {
var statearr_77746_77776 = state_77738__$1;
(statearr_77746_77776[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (13))){
var state_77738__$1 = state_77738;
var statearr_77747_77777 = state_77738__$1;
(statearr_77747_77777[(2)] = null);

(statearr_77747_77777[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (6))){
var state_77738__$1 = state_77738;
var statearr_77748_77778 = state_77738__$1;
(statearr_77748_77778[(2)] = db);

(statearr_77748_77778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (17))){
var inst_77719 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_77720 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77721 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_77722 = cljs.core.PersistentHashMap.fromArrays(inst_77720,inst_77721);
var inst_77723 = cljs.core.ex_info.call(null,inst_77719,inst_77722);
var inst_77724 = (function(){throw inst_77723})();
var state_77738__$1 = state_77738;
var statearr_77749_77779 = state_77738__$1;
(statearr_77749_77779[(2)] = inst_77724);

(statearr_77749_77779[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (3))){
var inst_77736 = (state_77738[(2)]);
var state_77738__$1 = state_77738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77738__$1,inst_77736);
} else {
if((state_val_77739 === (12))){
var inst_77712 = fluree.db.dbproto._subid.call(null,db,auth);
var state_77738__$1 = state_77738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77738__$1,(15),inst_77712);
} else {
if((state_val_77739 === (2))){
var _ = (function (){var statearr_77750 = state_77738;
(statearr_77750[(4)] = cljs.core.cons.call(null,(5),(state_77738[(4)])));

return statearr_77750;
})();
var inst_77704 = cljs.core.not.call(null,auth);
var state_77738__$1 = state_77738;
if(inst_77704){
var statearr_77751_77780 = state_77738__$1;
(statearr_77751_77780[(1)] = (6));

} else {
var statearr_77752_77781 = state_77738__$1;
(statearr_77752_77781[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (11))){
var inst_77731 = (state_77738[(2)]);
var state_77738__$1 = state_77738;
var statearr_77754_77782 = state_77738__$1;
(statearr_77754_77782[(2)] = inst_77731);

(statearr_77754_77782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (9))){
var inst_77709 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_77738__$1 = state_77738;
var statearr_77755_77783 = state_77738__$1;
(statearr_77755_77783[(2)] = inst_77709);

(statearr_77755_77783[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (5))){
var _ = (function (){var statearr_77756 = state_77738;
(statearr_77756[(4)] = cljs.core.rest.call(null,(state_77738[(4)])));

return statearr_77756;
})();
var state_77738__$1 = state_77738;
var ex77753 = (state_77738__$1[(2)]);
var statearr_77757_77784 = state_77738__$1;
(statearr_77757_77784[(5)] = ex77753);


if((ex77753 instanceof Error)){
var statearr_77758_77785 = state_77738__$1;
(statearr_77758_77785[(1)] = (4));

(statearr_77758_77785[(5)] = null);

} else {
throw ex77753;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (14))){
var inst_77729 = (state_77738[(2)]);
var state_77738__$1 = state_77738;
var statearr_77759_77786 = state_77738__$1;
(statearr_77759_77786[(2)] = inst_77729);

(statearr_77759_77786[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (16))){
var inst_77715 = (state_77738[(7)]);
var inst_77717 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_77715);
var state_77738__$1 = state_77738;
var statearr_77760_77787 = state_77738__$1;
(statearr_77760_77787[(2)] = inst_77717);

(statearr_77760_77787[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (10))){
var state_77738__$1 = state_77738;
var statearr_77761_77788 = state_77738__$1;
(statearr_77761_77788[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (18))){
var inst_77726 = (state_77738[(2)]);
var state_77738__$1 = state_77738;
var statearr_77763_77789 = state_77738__$1;
(statearr_77763_77789[(2)] = inst_77726);

(statearr_77763_77789[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77739 === (8))){
var inst_77733 = (state_77738[(2)]);
var _ = (function (){var statearr_77764 = state_77738;
(statearr_77764[(4)] = cljs.core.rest.call(null,(state_77738[(4)])));

return statearr_77764;
})();
var state_77738__$1 = state_77738;
var statearr_77765_77790 = state_77738__$1;
(statearr_77765_77790[(2)] = inst_77733);

(statearr_77765_77790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0 = (function (){
var statearr_77766 = [null,null,null,null,null,null,null,null];
(statearr_77766[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__);

(statearr_77766[(1)] = (1));

return statearr_77766;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1 = (function (state_77738){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_77738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77767){var ex__2687__auto__ = e77767;
var statearr_77768_77791 = state_77738;
(statearr_77768_77791[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_77738[(4)]))){
var statearr_77769_77792 = state_77738;
(statearr_77769_77792[(1)] = cljs.core.first.call(null,(state_77738[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77793 = state_77738;
state_77738 = G__77793;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = function(state_77738){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1.call(this,state_77738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77770 = f__2707__auto__.call(null);
(statearr_77770[(6)] = c__2706__auto__);

return statearr_77770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77865){
var state_val_77866 = (state_77865[(1)]);
if((state_val_77866 === (7))){
var inst_77803 = cljs.core._EQ_.call(null,(0),auth);
var state_77865__$1 = state_77865;
if(inst_77803){
var statearr_77867_77921 = state_77865__$1;
(statearr_77867_77921[(1)] = (9));

} else {
var statearr_77868_77922 = state_77865__$1;
(statearr_77868_77922[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (20))){
var inst_77827 = (state_77865[(7)]);
var state_77865__$1 = state_77865;
if(cljs.core.truth_(inst_77827)){
var statearr_77869_77923 = state_77865__$1;
(statearr_77869_77923[(1)] = (22));

} else {
var statearr_77870_77924 = state_77865__$1;
(statearr_77870_77924[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (27))){
var state_77865__$1 = state_77865;
var statearr_77871_77925 = state_77865__$1;
(statearr_77871_77925[(2)] = null);

(statearr_77871_77925[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (1))){
var state_77865__$1 = state_77865;
var statearr_77872_77926 = state_77865__$1;
(statearr_77872_77926[(2)] = null);

(statearr_77872_77926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (24))){
var inst_77841 = (state_77865[(2)]);
var state_77865__$1 = state_77865;
var statearr_77873_77927 = state_77865__$1;
(statearr_77873_77927[(2)] = inst_77841);

(statearr_77873_77927[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (4))){
var inst_77794 = (state_77865[(2)]);
var state_77865__$1 = state_77865;
var statearr_77874_77928 = state_77865__$1;
(statearr_77874_77928[(2)] = inst_77794);

(statearr_77874_77928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (15))){
var inst_77810 = (state_77865[(8)]);
var inst_77809 = (state_77865[(2)]);
var inst_77810__$1 = fluree.db.util.async.throw_err.call(null,inst_77809);
var state_77865__$1 = (function (){var statearr_77875 = state_77865;
(statearr_77875[(8)] = inst_77810__$1);

return statearr_77875;
})();
if(cljs.core.truth_(inst_77810__$1)){
var statearr_77876_77929 = state_77865__$1;
(statearr_77876_77929[(1)] = (16));

} else {
var statearr_77877_77930 = state_77865__$1;
(statearr_77877_77930[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (21))){
var inst_77843 = (state_77865[(9)]);
var inst_77843__$1 = (state_77865[(2)]);
var state_77865__$1 = (function (){var statearr_77878 = state_77865;
(statearr_77878[(9)] = inst_77843__$1);

return statearr_77878;
})();
if(cljs.core.truth_(inst_77843__$1)){
var statearr_77879_77931 = state_77865__$1;
(statearr_77879_77931[(1)] = (29));

} else {
var statearr_77880_77932 = state_77865__$1;
(statearr_77880_77932[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (31))){
var inst_77843 = (state_77865[(9)]);
var inst_77851 = (state_77865[(2)]);
var state_77865__$1 = (function (){var statearr_77881 = state_77865;
(statearr_77881[(10)] = inst_77851);

return statearr_77881;
})();
if(cljs.core.truth_(inst_77843)){
var statearr_77882_77933 = state_77865__$1;
(statearr_77882_77933[(1)] = (33));

} else {
var statearr_77883_77934 = state_77865__$1;
(statearr_77883_77934[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (32))){
var inst_77847 = (state_77865[(2)]);
var inst_77848 = fluree.db.util.async.throw_err.call(null,inst_77847);
var state_77865__$1 = state_77865;
var statearr_77884_77935 = state_77865__$1;
(statearr_77884_77935[(2)] = inst_77848);

(statearr_77884_77935[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (33))){
var inst_77843 = (state_77865[(9)]);
var inst_77853 = fluree.db.permissions.permission_map.call(null,db,inst_77843,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_77865__$1 = state_77865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77865__$1,(36),inst_77853);
} else {
if((state_val_77866 === (13))){
var state_77865__$1 = state_77865;
var statearr_77885_77936 = state_77865__$1;
(statearr_77885_77936[(2)] = null);

(statearr_77885_77936[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (22))){
var inst_77827 = (state_77865[(7)]);
var inst_77831 = fluree.db.auth.roles.call(null,db,inst_77827);
var state_77865__$1 = state_77865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77865__$1,(25),inst_77831);
} else {
if((state_val_77866 === (36))){
var inst_77855 = (state_77865[(2)]);
var inst_77856 = fluree.db.util.async.throw_err.call(null,inst_77855);
var state_77865__$1 = state_77865;
var statearr_77886_77937 = state_77865__$1;
(statearr_77886_77937[(2)] = inst_77856);

(statearr_77886_77937[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (29))){
var inst_77827 = (state_77865[(7)]);
var inst_77843 = (state_77865[(9)]);
var inst_77845 = fluree.db.dbfunctions.ctx.build.call(null,db,inst_77827,inst_77843);
var state_77865__$1 = state_77865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77865__$1,(32),inst_77845);
} else {
if((state_val_77866 === (6))){
var state_77865__$1 = state_77865;
var statearr_77887_77938 = state_77865__$1;
(statearr_77887_77938[(2)] = null);

(statearr_77887_77938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (28))){
var inst_77839 = (state_77865[(2)]);
var state_77865__$1 = state_77865;
var statearr_77888_77939 = state_77865__$1;
(statearr_77888_77939[(2)] = inst_77839);

(statearr_77888_77939[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (25))){
var inst_77833 = (state_77865[(2)]);
var inst_77834 = fluree.db.util.async.throw_err.call(null,inst_77833);
var state_77865__$1 = state_77865;
var statearr_77889_77940 = state_77865__$1;
(statearr_77889_77940[(2)] = inst_77834);

(statearr_77889_77940[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (34))){
var state_77865__$1 = state_77865;
var statearr_77890_77941 = state_77865__$1;
(statearr_77890_77941[(2)] = null);

(statearr_77890_77941[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (17))){
var inst_77813 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_77814 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77815 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_77816 = cljs.core.PersistentHashMap.fromArrays(inst_77814,inst_77815);
var inst_77817 = cljs.core.ex_info.call(null,inst_77813,inst_77816);
var inst_77818 = (function(){throw inst_77817})();
var state_77865__$1 = state_77865;
var statearr_77891_77942 = state_77865__$1;
(statearr_77891_77942[(2)] = inst_77818);

(statearr_77891_77942[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (3))){
var inst_77863 = (state_77865[(2)]);
var state_77865__$1 = state_77865;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77865__$1,inst_77863);
} else {
if((state_val_77866 === (12))){
var inst_77807 = fluree.db.dbproto._subid.call(null,db,auth);
var state_77865__$1 = state_77865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77865__$1,(15),inst_77807);
} else {
if((state_val_77866 === (2))){
var _ = (function (){var statearr_77892 = state_77865;
(statearr_77892[(4)] = cljs.core.cons.call(null,(5),(state_77865[(4)])));

return statearr_77892;
})();
var inst_77800 = (auth == null);
var state_77865__$1 = state_77865;
if(cljs.core.truth_(inst_77800)){
var statearr_77893_77943 = state_77865__$1;
(statearr_77893_77943[(1)] = (6));

} else {
var statearr_77894_77944 = state_77865__$1;
(statearr_77894_77944[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (23))){
var state_77865__$1 = state_77865;
var statearr_77895_77945 = state_77865__$1;
(statearr_77895_77945[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (35))){
var inst_77851 = (state_77865[(10)]);
var inst_77827 = (state_77865[(7)]);
var inst_77843 = (state_77865[(9)]);
var inst_77859 = (state_77865[(2)]);
var inst_77860 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_77827,new cljs.core.Keyword(null,"auth-id","auth-id",444160740),auth,new cljs.core.Keyword(null,"roles","roles",143379530),inst_77843,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_77859,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_77851);
var _ = (function (){var statearr_77897 = state_77865;
(statearr_77897[(4)] = cljs.core.rest.call(null,(state_77865[(4)])));

return statearr_77897;
})();
var state_77865__$1 = state_77865;
var statearr_77898_77946 = state_77865__$1;
(statearr_77898_77946[(2)] = inst_77860);

(statearr_77898_77946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (19))){
var state_77865__$1 = state_77865;
var statearr_77899_77947 = state_77865__$1;
(statearr_77899_77947[(2)] = roles);

(statearr_77899_77947[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (11))){
var inst_77825 = (state_77865[(2)]);
var state_77865__$1 = state_77865;
var statearr_77901_77948 = state_77865__$1;
(statearr_77901_77948[(2)] = inst_77825);

(statearr_77901_77948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (9))){
var state_77865__$1 = state_77865;
var statearr_77902_77949 = state_77865__$1;
(statearr_77902_77949[(2)] = (0));

(statearr_77902_77949[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (5))){
var _ = (function (){var statearr_77903 = state_77865;
(statearr_77903[(4)] = cljs.core.rest.call(null,(state_77865[(4)])));

return statearr_77903;
})();
var state_77865__$1 = state_77865;
var ex77900 = (state_77865__$1[(2)]);
var statearr_77904_77950 = state_77865__$1;
(statearr_77904_77950[(5)] = ex77900);


if((ex77900 instanceof Error)){
var statearr_77905_77951 = state_77865__$1;
(statearr_77905_77951[(1)] = (4));

(statearr_77905_77951[(5)] = null);

} else {
throw ex77900;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (14))){
var inst_77823 = (state_77865[(2)]);
var state_77865__$1 = state_77865;
var statearr_77906_77952 = state_77865__$1;
(statearr_77906_77952[(2)] = inst_77823);

(statearr_77906_77952[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (26))){
var state_77865__$1 = state_77865;
var statearr_77907_77953 = state_77865__$1;
(statearr_77907_77953[(2)] = null);

(statearr_77907_77953[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (16))){
var inst_77810 = (state_77865[(8)]);
var state_77865__$1 = state_77865;
var statearr_77908_77954 = state_77865__$1;
(statearr_77908_77954[(2)] = inst_77810);

(statearr_77908_77954[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (30))){
var state_77865__$1 = state_77865;
var statearr_77909_77955 = state_77865__$1;
(statearr_77909_77955[(2)] = null);

(statearr_77909_77955[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (10))){
var state_77865__$1 = state_77865;
if(cljs.core.truth_(auth)){
var statearr_77910_77956 = state_77865__$1;
(statearr_77910_77956[(1)] = (12));

} else {
var statearr_77911_77957 = state_77865__$1;
(statearr_77911_77957[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (18))){
var inst_77820 = (state_77865[(2)]);
var state_77865__$1 = state_77865;
var statearr_77912_77958 = state_77865__$1;
(statearr_77912_77958[(2)] = inst_77820);

(statearr_77912_77958[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77866 === (8))){
var inst_77827 = (state_77865[(2)]);
var state_77865__$1 = (function (){var statearr_77913 = state_77865;
(statearr_77913[(7)] = inst_77827);

return statearr_77913;
})();
if(cljs.core.truth_(roles)){
var statearr_77914_77959 = state_77865__$1;
(statearr_77914_77959[(1)] = (19));

} else {
var statearr_77915_77960 = state_77865__$1;
(statearr_77915_77960[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0 = (function (){
var statearr_77916 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_77916[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__);

(statearr_77916[(1)] = (1));

return statearr_77916;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1 = (function (state_77865){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_77865);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77917){var ex__2687__auto__ = e77917;
var statearr_77918_77961 = state_77865;
(statearr_77918_77961[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_77865[(4)]))){
var statearr_77919_77962 = state_77865;
(statearr_77919_77962[(1)] = cljs.core.first.call(null,(state_77865[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77963 = state_77865;
state_77865 = G__77963;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = function(state_77865){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1.call(this,state_77865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77920 = f__2707__auto__.call(null);
(statearr_77920[(6)] = c__2706__auto__);

return statearr_77920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__77964 = db;
var map__77964__$1 = cljs.core.__destructure_map.call(null,map__77964);
var conn = cljs.core.get.call(null,map__77964__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__77964__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__77964__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);

var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77971){
var state_val_77972 = (state_77971[(1)]);
if((state_val_77972 === (1))){
var inst_77965 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_77966 = fluree.db.session.db.call(null,conn,inst_77965,null);
var state_77971__$1 = state_77971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77971__$1,(2),inst_77966);
} else {
if((state_val_77972 === (2))){
var inst_77968 = (state_77971[(2)]);
var inst_77969 = cljs.core.async.put_BANG_.call(null,resp_port,inst_77968);
var state_77971__$1 = state_77971;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77971__$1,inst_77969);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_77973 = [null,null,null,null,null,null,null];
(statearr_77973[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_77973[(1)] = (1));

return statearr_77973;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_77971){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_77971);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77974){var ex__2687__auto__ = e77974;
var statearr_77975_78002 = state_77971;
(statearr_77975_78002[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_77971[(4)]))){
var statearr_77976_78003 = state_77971;
(statearr_77976_78003[(1)] = cljs.core.first.call(null,(state_77971[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78004 = state_77971;
state_77971 = G__78004;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_77971){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_77971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77977 = f__2707__auto__.call(null);
(statearr_77977[(6)] = c__2706__auto__);

return statearr_77977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,ledger_id,listen_id,event_fn);

var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77990){
var state_val_77991 = (state_77990[(1)]);
if((state_val_77991 === (1))){
var inst_77978 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_77979 = fluree.db.session.db.call(null,conn,inst_77978,null);
var state_77990__$1 = state_77990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77990__$1,(2),inst_77979);
} else {
if((state_val_77991 === (2))){
var inst_77981 = (state_77990[(7)]);
var inst_77981__$1 = (state_77990[(2)]);
var inst_77982 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_77981__$1);
var inst_77983 = newer_block_QMARK_.call(null,inst_77982);
var state_77990__$1 = (function (){var statearr_77992 = state_77990;
(statearr_77992[(7)] = inst_77981__$1);

return statearr_77992;
})();
if(inst_77983){
var statearr_77993_78005 = state_77990__$1;
(statearr_77993_78005[(1)] = (3));

} else {
var statearr_77994_78006 = state_77990__$1;
(statearr_77994_78006[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77991 === (3))){
var inst_77981 = (state_77990[(7)]);
var inst_77985 = cljs.core.async.put_BANG_.call(null,resp_port,inst_77981);
var state_77990__$1 = state_77990;
var statearr_77995_78007 = state_77990__$1;
(statearr_77995_78007[(2)] = inst_77985);

(statearr_77995_78007[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77991 === (4))){
var state_77990__$1 = state_77990;
var statearr_77996_78008 = state_77990__$1;
(statearr_77996_78008[(2)] = null);

(statearr_77996_78008[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77991 === (5))){
var inst_77988 = (state_77990[(2)]);
var state_77990__$1 = state_77990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77990__$1,inst_77988);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_77997 = [null,null,null,null,null,null,null,null];
(statearr_77997[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_77997[(1)] = (1));

return statearr_77997;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_77990){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_77990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77998){var ex__2687__auto__ = e77998;
var statearr_77999_78009 = state_77990;
(statearr_77999_78009[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_77990[(4)]))){
var statearr_78000_78010 = state_77990;
(statearr_78000_78010[(1)] = cljs.core.first.call(null,(state_77990[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78011 = state_77990;
state_77990 = G__78011;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_77990){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_77990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78001 = f__2707__auto__.call(null);
(statearr_78001[(6)] = c__2706__auto__);

return statearr_78001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__78012 = db;
var map__78012__$1 = cljs.core.__destructure_map.call(null,map__78012);
var conn = cljs.core.get.call(null,map__78012__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__78012__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__78012__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2706__auto___78088 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78062){
var state_val_78063 = (state_78062[(1)]);
if((state_val_78063 === (7))){
var inst_78028 = (state_78062[(7)]);
var inst_78039 = cljs.core._EQ_.call(null,inst_78028,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_78062__$1 = state_78062;
if(inst_78039){
var statearr_78064_78089 = state_78062__$1;
(statearr_78064_78089[(1)] = (9));

} else {
var statearr_78065_78090 = state_78062__$1;
(statearr_78065_78090[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (1))){
var inst_78013 = (state_78062[(8)]);
var inst_78021 = (state_78062[(9)]);
var inst_78013__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_78021__$1 = res_port;
var inst_78022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78023 = [inst_78013__$1,inst_78021__$1];
var inst_78024 = (new cljs.core.PersistentVector(null,2,(5),inst_78022,inst_78023,null));
var state_78062__$1 = (function (){var statearr_78066 = state_78062;
(statearr_78066[(8)] = inst_78013__$1);

(statearr_78066[(9)] = inst_78021__$1);

return statearr_78066;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_78062__$1,(2),inst_78024);
} else {
if((state_val_78063 === (4))){
var inst_78021 = (state_78062[(9)]);
var inst_78028 = (state_78062[(7)]);
var inst_78032 = cljs.core._EQ_.call(null,inst_78028,inst_78021);
var state_78062__$1 = state_78062;
if(inst_78032){
var statearr_78067_78091 = state_78062__$1;
(statearr_78067_78091[(1)] = (6));

} else {
var statearr_78068_78092 = state_78062__$1;
(statearr_78068_78092[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (13))){
var inst_78047 = (state_78062[(10)]);
var inst_78058 = cljs.core.async.put_BANG_.call(null,pc,inst_78047);
var state_78062__$1 = state_78062;
var statearr_78069_78093 = state_78062__$1;
(statearr_78069_78093[(2)] = inst_78058);

(statearr_78069_78093[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (6))){
var inst_78026 = (state_78062[(11)]);
var inst_78037 = cljs.core.nth.call(null,inst_78026,(0),null);
var state_78062__$1 = state_78062;
var statearr_78070_78094 = state_78062__$1;
(statearr_78070_78094[(2)] = inst_78037);

(statearr_78070_78094[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (3))){
var state_78062__$1 = state_78062;
var statearr_78071_78095 = state_78062__$1;
(statearr_78071_78095[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_78071_78095[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (12))){
var inst_78051 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_78052 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78053 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_78054 = cljs.core.PersistentHashMap.fromArrays(inst_78052,inst_78053);
var inst_78055 = cljs.core.ex_info.call(null,inst_78051,inst_78054);
var inst_78056 = cljs.core.async.put_BANG_.call(null,pc,inst_78055);
var state_78062__$1 = state_78062;
var statearr_78072_78096 = state_78062__$1;
(statearr_78072_78096[(2)] = inst_78056);

(statearr_78072_78096[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (2))){
var inst_78013 = (state_78062[(8)]);
var inst_78028 = (state_78062[(7)]);
var inst_78026 = (state_78062[(11)]);
var inst_78026__$1 = (state_78062[(2)]);
var inst_78027 = cljs.core.nth.call(null,inst_78026__$1,(0),null);
var inst_78028__$1 = cljs.core.nth.call(null,inst_78026__$1,(1),null);
var inst_78029 = cljs.core._EQ_.call(null,inst_78028__$1,inst_78013);
var state_78062__$1 = (function (){var statearr_78073 = state_78062;
(statearr_78073[(7)] = inst_78028__$1);

(statearr_78073[(12)] = inst_78027);

(statearr_78073[(11)] = inst_78026__$1);

return statearr_78073;
})();
if(inst_78029){
var statearr_78074_78097 = state_78062__$1;
(statearr_78074_78097[(1)] = (3));

} else {
var statearr_78075_78098 = state_78062__$1;
(statearr_78075_78098[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (11))){
var inst_78043 = (state_78062[(2)]);
var state_78062__$1 = state_78062;
var statearr_78076_78099 = state_78062__$1;
(statearr_78076_78099[(2)] = inst_78043);

(statearr_78076_78099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (9))){
var inst_78027 = (state_78062[(12)]);
var state_78062__$1 = state_78062;
var statearr_78077_78100 = state_78062__$1;
(statearr_78077_78100[(2)] = inst_78027);

(statearr_78077_78100[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (5))){
var inst_78047 = (state_78062[(10)]);
var inst_78047__$1 = (state_78062[(2)]);
var inst_78048 = fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);
var inst_78049 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_78047__$1);
var state_78062__$1 = (function (){var statearr_78078 = state_78062;
(statearr_78078[(10)] = inst_78047__$1);

(statearr_78078[(13)] = inst_78048);

return statearr_78078;
})();
if(inst_78049){
var statearr_78079_78101 = state_78062__$1;
(statearr_78079_78101[(1)] = (12));

} else {
var statearr_78080_78102 = state_78062__$1;
(statearr_78080_78102[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (14))){
var inst_78060 = (state_78062[(2)]);
var state_78062__$1 = state_78062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78062__$1,inst_78060);
} else {
if((state_val_78063 === (10))){
var state_78062__$1 = state_78062;
var statearr_78081_78103 = state_78062__$1;
(statearr_78081_78103[(2)] = null);

(statearr_78081_78103[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78063 === (8))){
var inst_78045 = (state_78062[(2)]);
var state_78062__$1 = state_78062;
var statearr_78082_78104 = state_78062__$1;
(statearr_78082_78104[(2)] = inst_78045);

(statearr_78082_78104[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0 = (function (){
var statearr_78083 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78083[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__);

(statearr_78083[(1)] = (1));

return statearr_78083;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1 = (function (state_78062){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_78062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78084){var ex__2687__auto__ = e78084;
var statearr_78085_78105 = state_78062;
(statearr_78085_78105[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_78062[(4)]))){
var statearr_78086_78106 = state_78062;
(statearr_78086_78106[(1)] = cljs.core.first.call(null,(state_78062[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78107 = state_78062;
state_78062 = G__78107;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = function(state_78062){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1.call(this,state_78062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78087 = f__2707__auto__.call(null);
(statearr_78087[(6)] = c__2706__auto___78088);

return statearr_78087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__78109 = arguments.length;
switch (G__78109) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__78110){
var map__78111 = p__78110;
var map__78111__$1 = cljs.core.__destructure_map.call(null,map__78111);
var opts = map__78111__$1;
var roles = cljs.core.get.call(null,map__78111__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__78111__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__78111__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__78111__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__78111__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2706__auto___78200 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78162){
var state_val_78163 = (state_78162[(1)]);
if((state_val_78163 === (7))){
var inst_78124 = (state_78162[(7)]);
var inst_78126 = fluree.db.api.ledger.syncTo_db.call(null,inst_78124,syncTo,syncTimeout);
var state_78162__$1 = state_78162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78162__$1,(10),inst_78126);
} else {
if((state_val_78163 === (20))){
var inst_78148 = (state_78162[(8)]);
var state_78162__$1 = state_78162;
var statearr_78164_78201 = state_78162__$1;
(statearr_78164_78201[(2)] = inst_78148);

(statearr_78164_78201[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (1))){
var state_78162__$1 = state_78162;
var statearr_78165_78202 = state_78162__$1;
(statearr_78165_78202[(2)] = null);

(statearr_78165_78202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (4))){
var inst_78112 = (state_78162[(2)]);
var inst_78113 = cljs.core.async.put_BANG_.call(null,pc,inst_78112);
var inst_78114 = cljs.core.async.close_BANG_.call(null,pc);
var state_78162__$1 = (function (){var statearr_78166 = state_78162;
(statearr_78166[(9)] = inst_78113);

return statearr_78166;
})();
var statearr_78167_78203 = state_78162__$1;
(statearr_78167_78203[(2)] = inst_78114);

(statearr_78167_78203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (15))){
var inst_78140 = (state_78162[(10)]);
var inst_78142 = fluree.db.api.ledger.add_db_permissions.call(null,inst_78140,auth,roles);
var state_78162__$1 = state_78162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78162__$1,(18),inst_78142);
} else {
if((state_val_78163 === (21))){
var inst_78156 = (state_78162[(2)]);
var inst_78157 = cljs.core.async.put_BANG_.call(null,pc,inst_78156);
var _ = (function (){var statearr_78168 = state_78162;
(statearr_78168[(4)] = cljs.core.rest.call(null,(state_78162[(4)])));

return statearr_78168;
})();
var state_78162__$1 = state_78162;
var statearr_78169_78204 = state_78162__$1;
(statearr_78169_78204[(2)] = inst_78157);

(statearr_78169_78204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (13))){
var inst_78140 = (state_78162[(2)]);
var state_78162__$1 = (function (){var statearr_78170 = state_78162;
(statearr_78170[(10)] = inst_78140);

return statearr_78170;
})();
if(cljs.core.truth_(roles)){
var statearr_78171_78205 = state_78162__$1;
(statearr_78171_78205[(1)] = (15));

} else {
var statearr_78172_78206 = state_78162__$1;
(statearr_78172_78206[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (22))){
var inst_78152 = (state_78162[(2)]);
var inst_78153 = fluree.db.util.async.throw_err.call(null,inst_78152);
var state_78162__$1 = state_78162;
var statearr_78173_78207 = state_78162__$1;
(statearr_78173_78207[(2)] = inst_78153);

(statearr_78173_78207[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (6))){
var inst_78123 = (state_78162[(2)]);
var inst_78124 = fluree.db.util.async.throw_err.call(null,inst_78123);
var state_78162__$1 = (function (){var statearr_78174 = state_78162;
(statearr_78174[(7)] = inst_78124);

return statearr_78174;
})();
if(cljs.core.truth_(syncTo)){
var statearr_78175_78208 = state_78162__$1;
(statearr_78175_78208[(1)] = (7));

} else {
var statearr_78176_78209 = state_78162__$1;
(statearr_78176_78209[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (17))){
var inst_78148 = (state_78162[(2)]);
var state_78162__$1 = (function (){var statearr_78177 = state_78162;
(statearr_78177[(8)] = inst_78148);

return statearr_78177;
})();
if(cljs.core.truth_(auth)){
var statearr_78178_78210 = state_78162__$1;
(statearr_78178_78210[(1)] = (19));

} else {
var statearr_78179_78211 = state_78162__$1;
(statearr_78179_78211[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (3))){
var inst_78160 = (state_78162[(2)]);
var state_78162__$1 = state_78162;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78162__$1,inst_78160);
} else {
if((state_val_78163 === (12))){
var inst_78132 = (state_78162[(11)]);
var state_78162__$1 = state_78162;
var statearr_78180_78212 = state_78162__$1;
(statearr_78180_78212[(2)] = inst_78132);

(statearr_78180_78212[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (2))){
var _ = (function (){var statearr_78181 = state_78162;
(statearr_78181[(4)] = cljs.core.cons.call(null,(5),(state_78162[(4)])));

return statearr_78181;
})();
var inst_78121 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_78162__$1 = state_78162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78162__$1,(6),inst_78121);
} else {
if((state_val_78163 === (19))){
var inst_78148 = (state_78162[(8)]);
var inst_78150 = fluree.db.api.ledger.add_db_permissions.call(null,inst_78148,auth,roles);
var state_78162__$1 = state_78162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78162__$1,(22),inst_78150);
} else {
if((state_val_78163 === (11))){
var inst_78132 = (state_78162[(11)]);
var inst_78134 = fluree.db.time_travel.as_of_block.call(null,inst_78132,block);
var state_78162__$1 = state_78162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78162__$1,(14),inst_78134);
} else {
if((state_val_78163 === (9))){
var inst_78132 = (state_78162[(2)]);
var state_78162__$1 = (function (){var statearr_78183 = state_78162;
(statearr_78183[(11)] = inst_78132);

return statearr_78183;
})();
if(cljs.core.truth_(block)){
var statearr_78184_78213 = state_78162__$1;
(statearr_78184_78213[(1)] = (11));

} else {
var statearr_78185_78214 = state_78162__$1;
(statearr_78185_78214[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (5))){
var _ = (function (){var statearr_78186 = state_78162;
(statearr_78186[(4)] = cljs.core.rest.call(null,(state_78162[(4)])));

return statearr_78186;
})();
var state_78162__$1 = state_78162;
var ex78182 = (state_78162__$1[(2)]);
var statearr_78187_78215 = state_78162__$1;
(statearr_78187_78215[(5)] = ex78182);


var statearr_78188_78216 = state_78162__$1;
(statearr_78188_78216[(1)] = (4));

(statearr_78188_78216[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (14))){
var inst_78136 = (state_78162[(2)]);
var inst_78137 = fluree.db.util.async.throw_err.call(null,inst_78136);
var state_78162__$1 = state_78162;
var statearr_78189_78217 = state_78162__$1;
(statearr_78189_78217[(2)] = inst_78137);

(statearr_78189_78217[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (16))){
var inst_78140 = (state_78162[(10)]);
var state_78162__$1 = state_78162;
var statearr_78190_78218 = state_78162__$1;
(statearr_78190_78218[(2)] = inst_78140);

(statearr_78190_78218[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (10))){
var inst_78128 = (state_78162[(2)]);
var inst_78129 = fluree.db.util.async.throw_err.call(null,inst_78128);
var state_78162__$1 = state_78162;
var statearr_78191_78219 = state_78162__$1;
(statearr_78191_78219[(2)] = inst_78129);

(statearr_78191_78219[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (18))){
var inst_78144 = (state_78162[(2)]);
var inst_78145 = fluree.db.util.async.throw_err.call(null,inst_78144);
var state_78162__$1 = state_78162;
var statearr_78192_78220 = state_78162__$1;
(statearr_78192_78220[(2)] = inst_78145);

(statearr_78192_78220[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78163 === (8))){
var inst_78124 = (state_78162[(7)]);
var state_78162__$1 = state_78162;
var statearr_78193_78221 = state_78162__$1;
(statearr_78193_78221[(2)] = inst_78124);

(statearr_78193_78221[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_78194 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78194[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_78194[(1)] = (1));

return statearr_78194;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_78162){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_78162);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78195){var ex__2687__auto__ = e78195;
var statearr_78196_78222 = state_78162;
(statearr_78196_78222[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_78162[(4)]))){
var statearr_78197_78223 = state_78162;
(statearr_78197_78223[(1)] = cljs.core.first.call(null,(state_78162[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78224 = state_78162;
state_78162 = G__78224;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_78162){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_78162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78198 = f__2707__auto__.call(null);
(statearr_78198[(6)] = c__2706__auto___78200);

return statearr_78198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

