// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___73132 = arguments.length;
var i__5770__auto___73133 = (0);
while(true){
if((i__5770__auto___73133 < len__5769__auto___73132)){
args__5775__auto__.push((arguments[i__5770__auto___73133]));

var G__73134 = (i__5770__auto___73133 + (1));
i__5770__auto___73133 = G__73134;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__73061){
var vec__73062 = p__73061;
var opts = cljs.core.nth.call(null,vec__73062,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2706__auto___73135 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73109){
var state_val_73110 = (state_73109[(1)]);
if((state_val_73110 === (7))){
var inst_73086 = (state_73109[(7)]);
var inst_73095 = (state_73109[(8)]);
var inst_73097 = fluree.db.time_travel.as_of_block.call(null,inst_73095,inst_73086);
var state_73109__$1 = state_73109;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73109__$1,(10),inst_73097);
} else {
if((state_val_73110 === (1))){
var state_73109__$1 = state_73109;
var statearr_73111_73136 = state_73109__$1;
(statearr_73111_73136[(2)] = null);

(statearr_73111_73136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73110 === (4))){
var inst_73065 = (state_73109[(2)]);
var inst_73066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73067 = [inst_73065];
var inst_73068 = (new cljs.core.PersistentVector(null,1,(5),inst_73066,inst_73067,null));
var inst_73069 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73068);
var inst_73070 = cljs.core.async.put_BANG_.call(null,pc,inst_73065);
var inst_73071 = cljs.core.async.close_BANG_.call(null,pc);
var state_73109__$1 = (function (){var statearr_73112 = state_73109;
(statearr_73112[(9)] = inst_73069);

(statearr_73112[(10)] = inst_73070);

return statearr_73112;
})();
var statearr_73113_73137 = state_73109__$1;
(statearr_73113_73137[(2)] = inst_73071);

(statearr_73113_73137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73110 === (6))){
var inst_73090 = (state_73109[(11)]);
var inst_73086 = (state_73109[(7)]);
var inst_73089 = (state_73109[(12)]);
var inst_73093 = (state_73109[(2)]);
var inst_73094 = fluree.db.util.async.throw_err.call(null,inst_73093);
var inst_73095 = cljs.core.assoc.call(null,inst_73094,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_73089,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_73090);
var state_73109__$1 = (function (){var statearr_73114 = state_73109;
(statearr_73114[(8)] = inst_73095);

return statearr_73114;
})();
if(cljs.core.truth_(inst_73086)){
var statearr_73115_73138 = state_73109__$1;
(statearr_73115_73138[(1)] = (7));

} else {
var statearr_73116_73139 = state_73109__$1;
(statearr_73116_73139[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73110 === (3))){
var inst_73107 = (state_73109[(2)]);
var state_73109__$1 = state_73109;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73109__$1,inst_73107);
} else {
if((state_val_73110 === (2))){
var _ = (function (){var statearr_73118 = state_73109;
(statearr_73118[(4)] = cljs.core.cons.call(null,(5),(state_73109[(4)])));

return statearr_73118;
})();
var inst_73081 = opts;
var inst_73082 = cljs.core.__destructure_map.call(null,inst_73081);
var inst_73083 = cljs.core.get.call(null,inst_73082,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_73084 = cljs.core.get.call(null,inst_73082,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_73085 = cljs.core.get.call(null,inst_73082,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_73086 = cljs.core.get.call(null,inst_73082,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73087 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_73088 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_73089 = cljs.core.nth.call(null,inst_73088,(0),null);
var inst_73090 = cljs.core.nth.call(null,inst_73088,(1),null);
var inst_73091 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_73109__$1 = (function (){var statearr_73119 = state_73109;
(statearr_73119[(11)] = inst_73090);

(statearr_73119[(7)] = inst_73086);

(statearr_73119[(13)] = inst_73084);

(statearr_73119[(12)] = inst_73089);

(statearr_73119[(14)] = inst_73085);

(statearr_73119[(15)] = inst_73087);

(statearr_73119[(16)] = inst_73083);

return statearr_73119;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73109__$1,(6),inst_73091);
} else {
if((state_val_73110 === (9))){
var inst_73103 = (state_73109[(2)]);
var inst_73104 = cljs.core.async.put_BANG_.call(null,pc,inst_73103);
var _ = (function (){var statearr_73120 = state_73109;
(statearr_73120[(4)] = cljs.core.rest.call(null,(state_73109[(4)])));

return statearr_73120;
})();
var state_73109__$1 = state_73109;
var statearr_73121_73140 = state_73109__$1;
(statearr_73121_73140[(2)] = inst_73104);

(statearr_73121_73140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73110 === (5))){
var _ = (function (){var statearr_73122 = state_73109;
(statearr_73122[(4)] = cljs.core.rest.call(null,(state_73109[(4)])));

return statearr_73122;
})();
var state_73109__$1 = state_73109;
var ex73117 = (state_73109__$1[(2)]);
var statearr_73123_73141 = state_73109__$1;
(statearr_73123_73141[(5)] = ex73117);


var statearr_73124_73142 = state_73109__$1;
(statearr_73124_73142[(1)] = (4));

(statearr_73124_73142[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73110 === (10))){
var inst_73099 = (state_73109[(2)]);
var inst_73100 = fluree.db.util.async.throw_err.call(null,inst_73099);
var state_73109__$1 = state_73109;
var statearr_73125_73143 = state_73109__$1;
(statearr_73125_73143[(2)] = inst_73100);

(statearr_73125_73143[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73110 === (8))){
var inst_73095 = (state_73109[(8)]);
var state_73109__$1 = state_73109;
var statearr_73126_73144 = state_73109__$1;
(statearr_73126_73144[(2)] = inst_73095);

(statearr_73126_73144[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_73127 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73127[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_73127[(1)] = (1));

return statearr_73127;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_73109){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_73109);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73128){var ex__2687__auto__ = e73128;
var statearr_73129_73145 = state_73109;
(statearr_73129_73145[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_73109[(4)]))){
var statearr_73130_73146 = state_73109;
(statearr_73130_73146[(1)] = cljs.core.first.call(null,(state_73109[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73147 = state_73109;
state_73109 = G__73147;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_73109){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_73109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73131 = f__2707__auto__.call(null);
(statearr_73131[(6)] = c__2706__auto___73135);

return statearr_73131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq73058){
var G__73059 = cljs.core.first.call(null,seq73058);
var seq73058__$1 = cljs.core.next.call(null,seq73058);
var G__73060 = cljs.core.first.call(null,seq73058__$1);
var seq73058__$2 = cljs.core.next.call(null,seq73058__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73059,G__73060,seq73058__$2);
}));

fluree.db.api_js.ledger_ident_QMARK_ = (function fluree$db$api_js$ledger_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,ledger_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,ledger_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__73149 = arguments.length;
switch (G__73149) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73278){
var state_val_73279 = (state_73278[(1)]);
if((state_val_73279 === (7))){
var inst_73178 = (state_73278[(7)]);
var inst_73168 = (state_73278[(8)]);
var inst_73180 = fluree.db.time_travel.as_of_block.call(null,inst_73178,inst_73168);
var state_73278__$1 = state_73278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73278__$1,(10),inst_73180);
} else {
if((state_val_73279 === (20))){
var inst_73172 = (state_73278[(9)]);
var state_73278__$1 = state_73278;
var statearr_73280_73360 = state_73278__$1;
(statearr_73280_73360[(2)] = inst_73172);

(statearr_73280_73360[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (27))){
var inst_73166 = (state_73278[(10)]);
var state_73278__$1 = state_73278;
var statearr_73281_73361 = state_73278__$1;
(statearr_73281_73361[(2)] = inst_73166);

(statearr_73281_73361[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (1))){
var state_73278__$1 = state_73278;
var statearr_73282_73362 = state_73278__$1;
(statearr_73282_73362[(2)] = null);

(statearr_73282_73362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (24))){
var inst_73175 = (state_73278[(11)]);
var state_73278__$1 = state_73278;
if(cljs.core.truth_(inst_73175)){
var statearr_73283_73363 = state_73278__$1;
(statearr_73283_73363[(1)] = (26));

} else {
var statearr_73284_73364 = state_73278__$1;
(statearr_73284_73364[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (39))){
var inst_73240 = (state_73278[(12)]);
var inst_73243 = cljs.core.ex_data.call(null,inst_73240);
var inst_73244 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73245 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73243);
var inst_73246 = cljs.core.ex_message.call(null,inst_73240);
var inst_73247 = [inst_73245,inst_73246,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73248 = cljs.core.PersistentHashMap.fromArrays(inst_73244,inst_73247);
var state_73278__$1 = state_73278;
var statearr_73285_73365 = state_73278__$1;
(statearr_73285_73365[(2)] = inst_73248);

(statearr_73285_73365[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (46))){
var inst_73240 = (state_73278[(12)]);
var state_73278__$1 = state_73278;
var statearr_73286_73366 = state_73278__$1;
(statearr_73286_73366[(2)] = inst_73240);

(statearr_73286_73366[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (4))){
var inst_73150 = (state_73278[(2)]);
var inst_73151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73152 = [inst_73150];
var inst_73153 = (new cljs.core.PersistentVector(null,1,(5),inst_73151,inst_73152,null));
var inst_73154 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73153);
var inst_73155 = cljs.core.ex_data.call(null,inst_73150);
var inst_73156 = cljs.core.ex_message.call(null,inst_73150);
var inst_73157 = cljs.core.assoc.call(null,inst_73155,new cljs.core.Keyword(null,"message","message",-406056002),inst_73156);
var state_73278__$1 = (function (){var statearr_73287 = state_73278;
(statearr_73287[(13)] = inst_73154);

return statearr_73287;
})();
var statearr_73288_73367 = state_73278__$1;
(statearr_73288_73367[(2)] = inst_73157);

(statearr_73288_73367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (15))){
var state_73278__$1 = state_73278;
var statearr_73289_73368 = state_73278__$1;
(statearr_73289_73368[(2)] = (1000000));

(statearr_73289_73368[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (48))){
var inst_73240 = (state_73278[(12)]);
var state_73278__$1 = state_73278;
var statearr_73290_73369 = state_73278__$1;
(statearr_73290_73369[(2)] = inst_73240);

(statearr_73290_73369[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (50))){
var inst_73267 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
var statearr_73291_73370 = state_73278__$1;
(statearr_73291_73370[(2)] = inst_73267);

(statearr_73291_73370[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (21))){
var inst_73171 = (state_73278[(14)]);
var state_73278__$1 = state_73278;
if(cljs.core.truth_(inst_73171)){
var statearr_73292_73371 = state_73278__$1;
(statearr_73292_73371[(1)] = (23));

} else {
var statearr_73293_73372 = state_73278__$1;
(statearr_73293_73372[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (31))){
var inst_73229 = (state_73278[(2)]);
var inst_73230 = cljs.core.not.call(null,inst_73229);
var state_73278__$1 = state_73278;
if(inst_73230){
var statearr_73294_73373 = state_73278__$1;
(statearr_73294_73373[(1)] = (35));

} else {
var statearr_73295_73374 = state_73278__$1;
(statearr_73295_73374[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (32))){
var inst_73173 = (state_73278[(15)]);
var state_73278__$1 = state_73278;
var statearr_73296_73375 = state_73278__$1;
(statearr_73296_73375[(2)] = inst_73173);

(statearr_73296_73375[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (40))){
var inst_73203 = (state_73278[(16)]);
var state_73278__$1 = state_73278;
if(cljs.core.truth_(inst_73203)){
var statearr_73297_73376 = state_73278__$1;
(statearr_73297_73376[(1)] = (42));

} else {
var statearr_73298_73377 = state_73278__$1;
(statearr_73298_73377[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (33))){
var inst_73169 = (state_73278[(17)]);
var state_73278__$1 = state_73278;
var statearr_73299_73378 = state_73278__$1;
(statearr_73299_73378[(2)] = inst_73169);

(statearr_73299_73378[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (13))){
var inst_73174 = (state_73278[(18)]);
var inst_73198 = (state_73278[(19)]);
var inst_73196 = (state_73278[(2)]);
var inst_73197 = cljs.core.volatile_BANG_.call(null,(0));
var inst_73198__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_73174);
var state_73278__$1 = (function (){var statearr_73300 = state_73278;
(statearr_73300[(19)] = inst_73198__$1);

(statearr_73300[(20)] = inst_73197);

(statearr_73300[(21)] = inst_73196);

return statearr_73300;
})();
if(cljs.core.truth_(inst_73198__$1)){
var statearr_73301_73379 = state_73278__$1;
(statearr_73301_73379[(1)] = (14));

} else {
var statearr_73302_73380 = state_73278__$1;
(statearr_73302_73380[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (22))){
var inst_73219 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
var statearr_73303_73381 = state_73278__$1;
(statearr_73303_73381[(2)] = inst_73219);

(statearr_73303_73381[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (36))){
var inst_73205 = (state_73278[(22)]);
var inst_73186 = (state_73278[(23)]);
var inst_73236 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_73205);
var inst_73237 = fluree.db.query.fql.query.call(null,inst_73186,inst_73236);
var state_73278__$1 = state_73278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73278__$1,(38),inst_73237);
} else {
if((state_val_73279 === (41))){
var inst_73271 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
var statearr_73304_73382 = state_73278__$1;
(statearr_73304_73382[(2)] = inst_73271);

(statearr_73304_73382[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (43))){
var state_73278__$1 = state_73278;
var statearr_73305_73383 = state_73278__$1;
(statearr_73305_73383[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (29))){
var inst_73173 = (state_73278[(15)]);
var state_73278__$1 = state_73278;
if(cljs.core.truth_(inst_73173)){
var statearr_73307_73384 = state_73278__$1;
(statearr_73307_73384[(1)] = (32));

} else {
var statearr_73308_73385 = state_73278__$1;
(statearr_73308_73385[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (44))){
var inst_73269 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
var statearr_73309_73386 = state_73278__$1;
(statearr_73309_73386[(2)] = inst_73269);

(statearr_73309_73386[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (6))){
var inst_73168 = (state_73278[(8)]);
var inst_73177 = (state_73278[(2)]);
var inst_73178 = fluree.db.util.async.throw_err.call(null,inst_73177);
var state_73278__$1 = (function (){var statearr_73310 = state_73278;
(statearr_73310[(7)] = inst_73178);

return statearr_73310;
})();
if(cljs.core.truth_(inst_73168)){
var statearr_73311_73387 = state_73278__$1;
(statearr_73311_73387[(1)] = (7));

} else {
var statearr_73312_73388 = state_73278__$1;
(statearr_73312_73388[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (28))){
var inst_73215 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
var statearr_73313_73389 = state_73278__$1;
(statearr_73313_73389[(2)] = inst_73215);

(statearr_73313_73389[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (25))){
var inst_73217 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
var statearr_73314_73390 = state_73278__$1;
(statearr_73314_73390[(2)] = inst_73217);

(statearr_73314_73390[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (34))){
var inst_73226 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
var statearr_73315_73391 = state_73278__$1;
(statearr_73315_73391[(2)] = inst_73226);

(statearr_73315_73391[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (17))){
var inst_73167 = (state_73278[(24)]);
var state_73278__$1 = state_73278;
var statearr_73316_73392 = state_73278__$1;
(statearr_73316_73392[(2)] = inst_73167);

(statearr_73316_73392[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (3))){
var inst_73276 = (state_73278[(2)]);
var state_73278__$1 = state_73278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73278__$1,inst_73276);
} else {
if((state_val_73279 === (12))){
var inst_73194 = cljs.core.PersistentHashMap.EMPTY;
var state_73278__$1 = state_73278;
var statearr_73317_73393 = state_73278__$1;
(statearr_73317_73393[(2)] = inst_73194);

(statearr_73317_73393[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (2))){
var _ = (function (){var statearr_73318 = state_73278;
(statearr_73318[(4)] = cljs.core.cons.call(null,(5),(state_73278[(4)])));

return statearr_73318;
})();
var inst_73164 = query_map;
var inst_73165 = cljs.core.__destructure_map.call(null,inst_73164);
var inst_73166 = cljs.core.get.call(null,inst_73165,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_73167 = cljs.core.get.call(null,inst_73165,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_73168 = cljs.core.get.call(null,inst_73165,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73169 = cljs.core.get.call(null,inst_73165,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_73170 = cljs.core.get.call(null,inst_73165,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_73171 = cljs.core.get.call(null,inst_73165,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_73172 = cljs.core.get.call(null,inst_73165,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_73173 = cljs.core.get.call(null,inst_73165,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_73174 = cljs.core.get.call(null,inst_73165,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_73175 = cljs.core.get.call(null,inst_73165,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_73278__$1 = (function (){var statearr_73319 = state_73278;
(statearr_73319[(25)] = inst_73170);

(statearr_73319[(18)] = inst_73174);

(statearr_73319[(17)] = inst_73169);

(statearr_73319[(24)] = inst_73167);

(statearr_73319[(9)] = inst_73172);

(statearr_73319[(15)] = inst_73173);

(statearr_73319[(10)] = inst_73166);

(statearr_73319[(8)] = inst_73168);

(statearr_73319[(14)] = inst_73171);

(statearr_73319[(11)] = inst_73175);

return statearr_73319;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73278__$1,(6),sources);
} else {
if((state_val_73279 === (23))){
var inst_73171 = (state_73278[(14)]);
var state_73278__$1 = state_73278;
var statearr_73320_73394 = state_73278__$1;
(statearr_73320_73394[(2)] = inst_73171);

(statearr_73320_73394[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (47))){
var inst_73204 = (state_73278[(26)]);
var inst_73251 = (state_73278[(27)]);
var inst_73197 = (state_73278[(20)]);
var inst_73186 = (state_73278[(23)]);
var inst_73257 = (state_73278[(2)]);
var inst_73258 = cljs.core.deref.call(null,inst_73197);
var inst_73259 = fluree.db.util.core.response_time_formatted.call(null,inst_73204);
var inst_73260 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_73186);
var inst_73261 = [(200),inst_73257,inst_73258,inst_73259,inst_73260];
var inst_73262 = cljs.core.PersistentHashMap.fromArrays(inst_73251,inst_73261);
var state_73278__$1 = state_73278;
var statearr_73321_73395 = state_73278__$1;
(statearr_73321_73395[(2)] = inst_73262);

(statearr_73321_73395[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (35))){
var inst_73232 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73233 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73234 = cljs.core.PersistentHashMap.fromArrays(inst_73232,inst_73233);
var state_73278__$1 = state_73278;
var statearr_73322_73396 = state_73278__$1;
(statearr_73322_73396[(2)] = inst_73234);

(statearr_73322_73396[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (19))){
var inst_73221 = (state_73278[(28)]);
var inst_73221__$1 = (state_73278[(2)]);
var state_73278__$1 = (function (){var statearr_73323 = state_73278;
(statearr_73323[(28)] = inst_73221__$1);

return statearr_73323;
})();
if(cljs.core.truth_(inst_73221__$1)){
var statearr_73324_73397 = state_73278__$1;
(statearr_73324_73397[(1)] = (29));

} else {
var statearr_73325_73398 = state_73278__$1;
(statearr_73325_73398[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (11))){
var inst_73170 = (state_73278[(25)]);
var inst_73187 = (state_73278[(29)]);
var inst_73186 = (state_73278[(23)]);
var inst_73189 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_73186);
var inst_73190 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_73187);
var inst_73191 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_73186);
var inst_73192 = fluree.db.api_js.get_sources.call(null,inst_73187,inst_73189,inst_73190,inst_73191,inst_73170,db_fn);
var state_73278__$1 = state_73278;
var statearr_73327_73399 = state_73278__$1;
(statearr_73327_73399[(2)] = inst_73192);

(statearr_73327_73399[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (9))){
var inst_73170 = (state_73278[(25)]);
var inst_73186 = (state_73278[(23)]);
var inst_73186__$1 = (state_73278[(2)]);
var inst_73187 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_73186__$1);
var state_73278__$1 = (function (){var statearr_73328 = state_73278;
(statearr_73328[(29)] = inst_73187);

(statearr_73328[(23)] = inst_73186__$1);

return statearr_73328;
})();
if(cljs.core.truth_(inst_73170)){
var statearr_73329_73400 = state_73278__$1;
(statearr_73329_73400[(1)] = (11));

} else {
var statearr_73330_73401 = state_73278__$1;
(statearr_73330_73401[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (5))){
var _ = (function (){var statearr_73331 = state_73278;
(statearr_73331[(4)] = cljs.core.rest.call(null,(state_73278[(4)])));

return statearr_73331;
})();
var state_73278__$1 = state_73278;
var ex73326 = (state_73278__$1[(2)]);
var statearr_73332_73402 = state_73278__$1;
(statearr_73332_73402[(5)] = ex73326);


var statearr_73333_73403 = state_73278__$1;
(statearr_73333_73403[(1)] = (4));

(statearr_73333_73403[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (14))){
var inst_73198 = (state_73278[(19)]);
var state_73278__$1 = state_73278;
var statearr_73334_73404 = state_73278__$1;
(statearr_73334_73404[(2)] = inst_73198);

(statearr_73334_73404[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (45))){
var inst_73240 = (state_73278[(12)]);
var inst_73254 = cljs.core.doall.call(null,inst_73240);
var state_73278__$1 = state_73278;
var statearr_73335_73405 = state_73278__$1;
(statearr_73335_73405[(2)] = inst_73254);

(statearr_73335_73405[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (26))){
var inst_73175 = (state_73278[(11)]);
var state_73278__$1 = state_73278;
var statearr_73336_73406 = state_73278__$1;
(statearr_73336_73406[(2)] = inst_73175);

(statearr_73336_73406[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (16))){
var inst_73174 = (state_73278[(18)]);
var inst_73197 = (state_73278[(20)]);
var inst_73167 = (state_73278[(24)]);
var inst_73196 = (state_73278[(21)]);
var inst_73202 = (state_73278[(2)]);
var inst_73203 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_73174);
var inst_73204 = fluree.db.util.core.current_time_millis.call(null);
var inst_73205 = cljs.core.assoc.call(null,inst_73174,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_73196,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_73202,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_73197);
var state_73278__$1 = (function (){var statearr_73337 = state_73278;
(statearr_73337[(16)] = inst_73203);

(statearr_73337[(26)] = inst_73204);

(statearr_73337[(22)] = inst_73205);

return statearr_73337;
})();
if(cljs.core.truth_(inst_73167)){
var statearr_73338_73407 = state_73278__$1;
(statearr_73338_73407[(1)] = (17));

} else {
var statearr_73339_73408 = state_73278__$1;
(statearr_73339_73408[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (38))){
var inst_73240 = (state_73278[(12)]);
var inst_73239 = (state_73278[(2)]);
var inst_73240__$1 = fluree.db.util.async.throw_err.call(null,inst_73239);
var inst_73241 = (inst_73240__$1 instanceof cljs.core.ExceptionInfo);
var state_73278__$1 = (function (){var statearr_73340 = state_73278;
(statearr_73340[(12)] = inst_73240__$1);

return statearr_73340;
})();
if(cljs.core.truth_(inst_73241)){
var statearr_73341_73409 = state_73278__$1;
(statearr_73341_73409[(1)] = (39));

} else {
var statearr_73342_73410 = state_73278__$1;
(statearr_73342_73410[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (30))){
var inst_73221 = (state_73278[(28)]);
var state_73278__$1 = state_73278;
var statearr_73343_73411 = state_73278__$1;
(statearr_73343_73411[(2)] = inst_73221);

(statearr_73343_73411[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (10))){
var inst_73182 = (state_73278[(2)]);
var inst_73183 = fluree.db.util.async.throw_err.call(null,inst_73182);
var state_73278__$1 = state_73278;
var statearr_73344_73412 = state_73278__$1;
(statearr_73344_73412[(2)] = inst_73183);

(statearr_73344_73412[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (18))){
var inst_73172 = (state_73278[(9)]);
var state_73278__$1 = state_73278;
if(cljs.core.truth_(inst_73172)){
var statearr_73345_73413 = state_73278__$1;
(statearr_73345_73413[(1)] = (20));

} else {
var statearr_73346_73414 = state_73278__$1;
(statearr_73346_73414[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (42))){
var inst_73240 = (state_73278[(12)]);
var inst_73251 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73252 = cljs.core.sequential_QMARK_.call(null,inst_73240);
var state_73278__$1 = (function (){var statearr_73347 = state_73278;
(statearr_73347[(27)] = inst_73251);

return statearr_73347;
})();
if(inst_73252){
var statearr_73348_73415 = state_73278__$1;
(statearr_73348_73415[(1)] = (45));

} else {
var statearr_73349_73416 = state_73278__$1;
(statearr_73349_73416[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (37))){
var inst_73273 = (state_73278[(2)]);
var _ = (function (){var statearr_73350 = state_73278;
(statearr_73350[(4)] = cljs.core.rest.call(null,(state_73278[(4)])));

return statearr_73350;
})();
var state_73278__$1 = state_73278;
var statearr_73351_73417 = state_73278__$1;
(statearr_73351_73417[(2)] = inst_73273);

(statearr_73351_73417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (8))){
var inst_73178 = (state_73278[(7)]);
var state_73278__$1 = state_73278;
var statearr_73352_73418 = state_73278__$1;
(statearr_73352_73418[(2)] = inst_73178);

(statearr_73352_73418[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73279 === (49))){
var state_73278__$1 = state_73278;
var statearr_73353_73419 = state_73278__$1;
(statearr_73353_73419[(2)] = null);

(statearr_73353_73419[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_73354 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73354[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_73354[(1)] = (1));

return statearr_73354;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_73278){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_73278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73355){var ex__2687__auto__ = e73355;
var statearr_73356_73420 = state_73278;
(statearr_73356_73420[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_73278[(4)]))){
var statearr_73357_73421 = state_73278;
(statearr_73357_73421[(1)] = cljs.core.first.call(null,(state_73278[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73422 = state_73278;
state_73278 = G__73422;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_73278){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_73278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73358 = f__2707__auto__.call(null);
(statearr_73358[(6)] = c__2706__auto__);

return statearr_73358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__73423_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__73423_SHARP_);
}));

var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73445){
var state_val_73446 = (state_73445[(1)]);
if((state_val_73446 === (1))){
var inst_73427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73428 = [resp_chan,timeout_chan];
var inst_73429 = (new cljs.core.PersistentVector(null,2,(5),inst_73427,inst_73428,null));
var state_73445__$1 = state_73445;
return cljs.core.async.ioc_alts_BANG_.call(null,state_73445__$1,(2),inst_73429);
} else {
if((state_val_73446 === (2))){
var inst_73431 = (state_73445[(2)]);
var inst_73432 = cljs.core.nth.call(null,inst_73431,(0),null);
var inst_73433 = cljs.core.nth.call(null,inst_73431,(1),null);
var inst_73434 = cljs.core._EQ_.call(null,timeout_chan,inst_73433);
var state_73445__$1 = (function (){var statearr_73447 = state_73445;
(statearr_73447[(7)] = inst_73432);

return statearr_73447;
})();
if(inst_73434){
var statearr_73448_73458 = state_73445__$1;
(statearr_73448_73458[(1)] = (3));

} else {
var statearr_73449_73459 = state_73445__$1;
(statearr_73449_73459[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73446 === (3))){
var inst_73436 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_73437 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_73438 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_73439 = [tid,(408),inst_73438];
var inst_73440 = cljs.core.PersistentHashMap.fromArrays(inst_73437,inst_73439);
var state_73445__$1 = (function (){var statearr_73450 = state_73445;
(statearr_73450[(8)] = inst_73436);

return statearr_73450;
})();
var statearr_73451_73460 = state_73445__$1;
(statearr_73451_73460[(2)] = inst_73440);

(statearr_73451_73460[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73446 === (4))){
var inst_73432 = (state_73445[(7)]);
var state_73445__$1 = state_73445;
var statearr_73452_73461 = state_73445__$1;
(statearr_73452_73461[(2)] = inst_73432);

(statearr_73452_73461[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73446 === (5))){
var inst_73443 = (state_73445[(2)]);
var state_73445__$1 = state_73445;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73445__$1,inst_73443);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0 = (function (){
var statearr_73453 = [null,null,null,null,null,null,null,null,null];
(statearr_73453[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__);

(statearr_73453[(1)] = (1));

return statearr_73453;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1 = (function (state_73445){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_73445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73454){var ex__2687__auto__ = e73454;
var statearr_73455_73462 = state_73445;
(statearr_73455_73462[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_73445[(4)]))){
var statearr_73456_73463 = state_73445;
(statearr_73456_73463[(1)] = cljs.core.first.call(null,(state_73445[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73464 = state_73445;
state_73445 = G__73464;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__ = function(state_73445){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1.call(this,state_73445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73457 = f__2707__auto__.call(null);
(statearr_73457[(6)] = c__2706__auto__);

return statearr_73457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__73466 = arguments.length;
switch (G__73466) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__73467 = opts;
var map__73467__$1 = cljs.core.__destructure_map.call(null,map__73467);
var auth = cljs.core.get.call(null,map__73467__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__73467__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__73467__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__73467__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__73468 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__73468,(0),null);
var authority = cljs.core.nth.call(null,vec__73468,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e73471){var e = e73471;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__73474 = arguments.length;
switch (G__73474) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73543){
var state_val_73544 = (state_73543[(1)]);
if((state_val_73544 === (7))){
var inst_73494 = (state_73543[(7)]);
var inst_73499 = (state_73543[(8)]);
var inst_73497 = (state_73543[(9)]);
var inst_73498 = (state_73543[(10)]);
var inst_73496 = (state_73543[(11)]);
var inst_73512 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_73513 = [ledger,txn,inst_73494,inst_73496,inst_73497,inst_73498,inst_73499];
var inst_73514 = cljs.core.PersistentHashMap.fromArrays(inst_73512,inst_73513);
var inst_73515 = fluree.db.util.core.without_nils.call(null,inst_73514);
var inst_73516 = fluree.db.operations.transact_async.call(null,conn,inst_73515);
var state_73543__$1 = state_73543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73543__$1,(13),inst_73516);
} else {
if((state_val_73544 === (20))){
var inst_73534 = (state_73543[(2)]);
var state_73543__$1 = state_73543;
var statearr_73545_73581 = state_73543__$1;
(statearr_73545_73581[(2)] = inst_73534);

(statearr_73545_73581[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (1))){
var state_73543__$1 = state_73543;
var statearr_73546_73582 = state_73543__$1;
(statearr_73546_73582[(2)] = null);

(statearr_73546_73582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (4))){
var inst_73475 = (state_73543[(2)]);
var inst_73476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73477 = [inst_73475];
var inst_73478 = (new cljs.core.PersistentVector(null,1,(5),inst_73476,inst_73477,null));
var inst_73479 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73478);
var inst_73480 = cljs.core.ex_data.call(null,inst_73475);
var inst_73481 = cljs.core.ex_message.call(null,inst_73475);
var inst_73482 = cljs.core.assoc.call(null,inst_73480,new cljs.core.Keyword(null,"message","message",-406056002),inst_73481);
var state_73543__$1 = (function (){var statearr_73547 = state_73543;
(statearr_73547[(12)] = inst_73479);

return statearr_73547;
})();
var statearr_73548_73583 = state_73543__$1;
(statearr_73548_73583[(2)] = inst_73482);

(statearr_73548_73583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (15))){
var inst_73518 = (state_73543[(13)]);
var inst_73493 = (state_73543[(14)]);
var inst_73521 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_73518,inst_73493);
var state_73543__$1 = state_73543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73543__$1,(17),inst_73521);
} else {
if((state_val_73544 === (13))){
var inst_73492 = (state_73543[(15)]);
var inst_73518 = (state_73543[(2)]);
var state_73543__$1 = (function (){var statearr_73549 = state_73543;
(statearr_73549[(13)] = inst_73518);

return statearr_73549;
})();
if(cljs.core.truth_(inst_73492)){
var statearr_73550_73584 = state_73543__$1;
(statearr_73550_73584[(1)] = (14));

} else {
var statearr_73551_73585 = state_73543__$1;
(statearr_73551_73585[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (6))){
var inst_73491 = (state_73543[(16)]);
var inst_73492 = (state_73543[(15)]);
var inst_73501 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_73491,opts);
var inst_73502 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_73501);
var inst_73503 = fluree.db.operations.command_async.call(null,conn,inst_73501);
var state_73543__$1 = (function (){var statearr_73552 = state_73543;
(statearr_73552[(17)] = inst_73503);

(statearr_73552[(18)] = inst_73502);

return statearr_73552;
})();
if(cljs.core.truth_(inst_73492)){
var statearr_73553_73586 = state_73543__$1;
(statearr_73553_73586[(1)] = (9));

} else {
var statearr_73554_73587 = state_73543__$1;
(statearr_73554_73587[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (17))){
var inst_73523 = (state_73543[(19)]);
var inst_73523__$1 = (state_73543[(2)]);
var inst_73524 = (inst_73523__$1 instanceof cljs.core.ExceptionInfo);
var state_73543__$1 = (function (){var statearr_73555 = state_73543;
(statearr_73555[(19)] = inst_73523__$1);

return statearr_73555;
})();
if(cljs.core.truth_(inst_73524)){
var statearr_73556_73588 = state_73543__$1;
(statearr_73556_73588[(1)] = (18));

} else {
var statearr_73557_73589 = state_73543__$1;
(statearr_73557_73589[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (3))){
var inst_73541 = (state_73543[(2)]);
var state_73543__$1 = state_73543;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73543__$1,inst_73541);
} else {
if((state_val_73544 === (12))){
var inst_73508 = (state_73543[(2)]);
var state_73543__$1 = state_73543;
var statearr_73558_73590 = state_73543__$1;
(statearr_73558_73590[(2)] = inst_73508);

(statearr_73558_73590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (2))){
var inst_73491 = (state_73543[(16)]);
var _ = (function (){var statearr_73559 = state_73543;
(statearr_73559[(4)] = cljs.core.cons.call(null,(5),(state_73543[(4)])));

return statearr_73559;
})();
var inst_73489 = opts;
var inst_73490 = cljs.core.__destructure_map.call(null,inst_73489);
var inst_73491__$1 = cljs.core.get.call(null,inst_73490,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_73492 = cljs.core.get.call(null,inst_73490,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_73493 = cljs.core.get.call(null,inst_73490,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_73494 = cljs.core.get.call(null,inst_73490,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_73495 = fluree.db.util.core.current_time_millis.call(null);
var inst_73496 = cljs.core.get.call(null,inst_73490,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_73495);
var inst_73497 = cljs.core.get.call(null,inst_73490,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_73498 = cljs.core.get.call(null,inst_73490,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_73499 = cljs.core.get.call(null,inst_73490,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_73543__$1 = (function (){var statearr_73560 = state_73543;
(statearr_73560[(7)] = inst_73494);

(statearr_73560[(16)] = inst_73491__$1);

(statearr_73560[(8)] = inst_73499);

(statearr_73560[(9)] = inst_73497);

(statearr_73560[(10)] = inst_73498);

(statearr_73560[(15)] = inst_73492);

(statearr_73560[(14)] = inst_73493);

(statearr_73560[(11)] = inst_73496);

return statearr_73560;
})();
if(cljs.core.truth_(inst_73491__$1)){
var statearr_73561_73591 = state_73543__$1;
(statearr_73561_73591[(1)] = (6));

} else {
var statearr_73562_73592 = state_73543__$1;
(statearr_73562_73592[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (19))){
var inst_73523 = (state_73543[(19)]);
var state_73543__$1 = state_73543;
var statearr_73563_73593 = state_73543__$1;
(statearr_73563_73593[(2)] = inst_73523);

(statearr_73563_73593[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (11))){
var inst_73510 = (state_73543[(2)]);
var state_73543__$1 = state_73543;
var statearr_73565_73594 = state_73543__$1;
(statearr_73565_73594[(2)] = inst_73510);

(statearr_73565_73594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (9))){
var inst_73503 = (state_73543[(17)]);
var state_73543__$1 = state_73543;
var statearr_73566_73595 = state_73543__$1;
(statearr_73566_73595[(2)] = inst_73503);

(statearr_73566_73595[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (5))){
var _ = (function (){var statearr_73567 = state_73543;
(statearr_73567[(4)] = cljs.core.rest.call(null,(state_73543[(4)])));

return statearr_73567;
})();
var state_73543__$1 = state_73543;
var ex73564 = (state_73543__$1[(2)]);
var statearr_73568_73596 = state_73543__$1;
(statearr_73568_73596[(5)] = ex73564);


var statearr_73569_73597 = state_73543__$1;
(statearr_73569_73597[(1)] = (4));

(statearr_73569_73597[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (14))){
var inst_73518 = (state_73543[(13)]);
var state_73543__$1 = state_73543;
var statearr_73570_73598 = state_73543__$1;
(statearr_73570_73598[(2)] = inst_73518);

(statearr_73570_73598[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (16))){
var inst_73536 = (state_73543[(2)]);
var state_73543__$1 = state_73543;
var statearr_73571_73599 = state_73543__$1;
(statearr_73571_73599[(2)] = inst_73536);

(statearr_73571_73599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (10))){
var inst_73502 = (state_73543[(18)]);
var inst_73493 = (state_73543[(14)]);
var inst_73506 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_73502,inst_73493);
var state_73543__$1 = state_73543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73543__$1,(12),inst_73506);
} else {
if((state_val_73544 === (18))){
var inst_73523 = (state_73543[(19)]);
var inst_73526 = cljs.core.ex_data.call(null,inst_73523);
var inst_73527 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73528 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73526);
var inst_73529 = cljs.core.ex_message.call(null,inst_73523);
var inst_73530 = [inst_73528,inst_73529,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_73531 = cljs.core.PersistentHashMap.fromArrays(inst_73527,inst_73530);
var state_73543__$1 = state_73543;
var statearr_73572_73600 = state_73543__$1;
(statearr_73572_73600[(2)] = inst_73531);

(statearr_73572_73600[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73544 === (8))){
var inst_73538 = (state_73543[(2)]);
var _ = (function (){var statearr_73573 = state_73543;
(statearr_73573[(4)] = cljs.core.rest.call(null,(state_73543[(4)])));

return statearr_73573;
})();
var state_73543__$1 = state_73543;
var statearr_73574_73601 = state_73543__$1;
(statearr_73574_73601[(2)] = inst_73538);

(statearr_73574_73601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_73575 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73575[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_73575[(1)] = (1));

return statearr_73575;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_73543){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_73543);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73576){var ex__2687__auto__ = e73576;
var statearr_73577_73602 = state_73543;
(statearr_73577_73602[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_73543[(4)]))){
var statearr_73578_73603 = state_73543;
(statearr_73578_73603[(1)] = cljs.core.first.call(null,(state_73543[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73604 = state_73543;
state_73543 = G__73604;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_73543){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_73543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73579 = f__2707__auto__.call(null);
(statearr_73579[(6)] = c__2706__auto__);

return statearr_73579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___73606 = arguments.length;
var i__5770__auto___73607 = (0);
while(true){
if((i__5770__auto___73607 < len__5769__auto___73606)){
args__5775__auto__.push((arguments[i__5770__auto___73607]));

var G__73608 = (i__5770__auto___73607 + (1));
i__5770__auto___73607 = G__73608;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq73605){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq73605));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73640){
var state_val_73641 = (state_73640[(1)]);
if((state_val_73641 === (1))){
var inst_73609 = cljs.core.first.call(null,flakes);
var inst_73610 = cljs.core.rest.call(null,flakes);
var inst_73611 = cljs.core.PersistentVector.EMPTY;
var inst_73612 = inst_73609;
var inst_73613 = inst_73610;
var inst_73614 = inst_73611;
var state_73640__$1 = (function (){var statearr_73642 = state_73640;
(statearr_73642[(7)] = inst_73614);

(statearr_73642[(8)] = inst_73613);

(statearr_73642[(9)] = inst_73612);

return statearr_73642;
})();
var statearr_73643_73656 = state_73640__$1;
(statearr_73643_73656[(2)] = null);

(statearr_73643_73656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73641 === (2))){
var inst_73612 = (state_73640[(9)]);
var inst_73616 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_73617 = cljs.core.PersistentHashMap.EMPTY;
var inst_73618 = [true,inst_73617];
var inst_73619 = cljs.core.PersistentHashMap.fromArrays(inst_73616,inst_73618);
var inst_73620 = cljs.core.PersistentHashMap.EMPTY;
var inst_73621 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_73619,inst_73620,inst_73612);
var state_73640__$1 = state_73640;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73640__$1,(4),inst_73621);
} else {
if((state_val_73641 === (3))){
var inst_73638 = (state_73640[(2)]);
var state_73640__$1 = state_73640;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73640__$1,inst_73638);
} else {
if((state_val_73641 === (4))){
var inst_73614 = (state_73640[(7)]);
var inst_73613 = (state_73640[(8)]);
var inst_73623 = (state_73640[(2)]);
var inst_73624 = fluree.db.util.async.throw_err.call(null,inst_73623);
var inst_73625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73626 = [inst_73624];
var inst_73627 = (new cljs.core.PersistentVector(null,1,(5),inst_73625,inst_73626,null));
var inst_73628 = cljs.core.concat.call(null,inst_73614,inst_73627);
var inst_73629 = cljs.core.first.call(null,inst_73613);
var state_73640__$1 = (function (){var statearr_73644 = state_73640;
(statearr_73644[(10)] = inst_73628);

return statearr_73644;
})();
if(cljs.core.truth_(inst_73629)){
var statearr_73645_73657 = state_73640__$1;
(statearr_73645_73657[(1)] = (5));

} else {
var statearr_73646_73658 = state_73640__$1;
(statearr_73646_73658[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73641 === (5))){
var inst_73628 = (state_73640[(10)]);
var inst_73613 = (state_73640[(8)]);
var inst_73631 = cljs.core.first.call(null,inst_73613);
var inst_73632 = cljs.core.rest.call(null,inst_73613);
var inst_73612 = inst_73631;
var inst_73613__$1 = inst_73632;
var inst_73614 = inst_73628;
var state_73640__$1 = (function (){var statearr_73647 = state_73640;
(statearr_73647[(7)] = inst_73614);

(statearr_73647[(8)] = inst_73613__$1);

(statearr_73647[(9)] = inst_73612);

return statearr_73647;
})();
var statearr_73648_73659 = state_73640__$1;
(statearr_73648_73659[(2)] = null);

(statearr_73648_73659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73641 === (6))){
var inst_73628 = (state_73640[(10)]);
var state_73640__$1 = state_73640;
var statearr_73649_73660 = state_73640__$1;
(statearr_73649_73660[(2)] = inst_73628);

(statearr_73649_73660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73641 === (7))){
var inst_73636 = (state_73640[(2)]);
var state_73640__$1 = state_73640;
var statearr_73650_73661 = state_73640__$1;
(statearr_73650_73661[(2)] = inst_73636);

(statearr_73650_73661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_73651 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73651[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__);

(statearr_73651[(1)] = (1));

return statearr_73651;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1 = (function (state_73640){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_73640);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73652){var ex__2687__auto__ = e73652;
var statearr_73653_73662 = state_73640;
(statearr_73653_73662[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_73640[(4)]))){
var statearr_73654_73663 = state_73640;
(statearr_73654_73663[(1)] = cljs.core.first.call(null,(state_73640[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73664 = state_73640;
state_73640 = G__73664;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__ = function(state_73640){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1.call(this,state_73640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73655 = f__2707__auto__.call(null);
(statearr_73655[(6)] = c__2706__auto__);

return statearr_73655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73732){
var state_val_73733 = (state_73732[(1)]);
if((state_val_73733 === (7))){
var inst_73692 = (state_73732[(2)]);
var inst_73693 = fluree.db.util.async.throw_err.call(null,inst_73692);
var state_73732__$1 = state_73732;
var statearr_73734_73760 = state_73732__$1;
(statearr_73734_73760[(2)] = inst_73693);

(statearr_73734_73760[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (1))){
var inst_73669 = cljs.core.volatile_BANG_.call(null,(0));
var inst_73670 = cljs.core.PersistentHashMap.EMPTY;
var inst_73671 = cljs.core.volatile_BANG_.call(null,inst_73670);
var inst_73672 = cljs.core.first.call(null,resp);
var inst_73673 = cljs.core.rest.call(null,resp);
var inst_73674 = cljs.core.PersistentVector.EMPTY;
var inst_73675 = inst_73669;
var inst_73676 = inst_73671;
var inst_73677 = inst_73672;
var inst_73678 = inst_73673;
var inst_73679 = inst_73674;
var state_73732__$1 = (function (){var statearr_73735 = state_73732;
(statearr_73735[(7)] = inst_73675);

(statearr_73735[(8)] = inst_73677);

(statearr_73735[(9)] = inst_73676);

(statearr_73735[(10)] = inst_73678);

(statearr_73735[(11)] = inst_73679);

return statearr_73735;
})();
var statearr_73736_73761 = state_73732__$1;
(statearr_73736_73761[(2)] = null);

(statearr_73736_73761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (4))){
var inst_73675 = (state_73732[(7)]);
var inst_73677 = (state_73732[(8)]);
var inst_73683 = (state_73732[(12)]);
var inst_73681 = (state_73732[(13)]);
var inst_73676 = (state_73732[(9)]);
var inst_73678 = (state_73732[(10)]);
var inst_73679 = (state_73732[(11)]);
var inst_73687 = (function (){var fuel = inst_73675;
var cache = inst_73676;
var curr_block = inst_73677;
var rest_blocks = inst_73678;
var acc = inst_73679;
var flakes = inst_73681;
var asserted = inst_73683;
return (function (p1__73666_SHARP_){
return p1__73666_SHARP_.s;
});
})();
var inst_73688 = cljs.core.group_by.call(null,inst_73687,inst_73683);
var inst_73689 = cljs.core.vals.call(null,inst_73688);
var inst_73690 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_73676,inst_73675,inst_73689);
var state_73732__$1 = state_73732;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73732__$1,(7),inst_73690);
} else {
if((state_val_73733 === (13))){
var inst_73720 = (state_73732[(14)]);
var state_73732__$1 = state_73732;
var statearr_73737_73762 = state_73732__$1;
(statearr_73737_73762[(2)] = inst_73720);

(statearr_73737_73762[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (6))){
var inst_73675 = (state_73732[(7)]);
var inst_73698 = (state_73732[(15)]);
var inst_73677 = (state_73732[(8)]);
var inst_73683 = (state_73732[(12)]);
var inst_73681 = (state_73732[(13)]);
var inst_73676 = (state_73732[(9)]);
var inst_73696 = (state_73732[(16)]);
var inst_73678 = (state_73732[(10)]);
var inst_73679 = (state_73732[(11)]);
var inst_73696__$1 = (state_73732[(2)]);
var inst_73697 = (function (){var fuel = inst_73675;
var cache = inst_73676;
var curr_block = inst_73677;
var rest_blocks = inst_73678;
var acc = inst_73679;
var flakes = inst_73681;
var asserted = inst_73683;
var asserted_SINGLEQUOTE_ = inst_73696__$1;
return (function (p1__73667_SHARP_){
return p1__73667_SHARP_.op === false;
});
})();
var inst_73698__$1 = cljs.core.filter.call(null,inst_73697,inst_73681);
var inst_73699 = cljs.core.empty_QMARK_.call(null,inst_73698__$1);
var inst_73700 = (!(inst_73699));
var state_73732__$1 = (function (){var statearr_73740 = state_73732;
(statearr_73740[(15)] = inst_73698__$1);

(statearr_73740[(16)] = inst_73696__$1);

return statearr_73740;
})();
if(inst_73700){
var statearr_73741_73763 = state_73732__$1;
(statearr_73741_73763[(1)] = (8));

} else {
var statearr_73742_73764 = state_73732__$1;
(statearr_73742_73764[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (3))){
var inst_73730 = (state_73732[(2)]);
var state_73732__$1 = state_73732;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73732__$1,inst_73730);
} else {
if((state_val_73733 === (12))){
var inst_73675 = (state_73732[(7)]);
var inst_73720 = (state_73732[(14)]);
var inst_73676 = (state_73732[(9)]);
var inst_73678 = (state_73732[(10)]);
var inst_73723 = cljs.core.first.call(null,inst_73678);
var inst_73724 = cljs.core.rest.call(null,inst_73678);
var tmp73738 = inst_73675;
var tmp73739 = inst_73676;
var inst_73675__$1 = tmp73738;
var inst_73676__$1 = tmp73739;
var inst_73677 = inst_73723;
var inst_73678__$1 = inst_73724;
var inst_73679 = inst_73720;
var state_73732__$1 = (function (){var statearr_73743 = state_73732;
(statearr_73743[(7)] = inst_73675__$1);

(statearr_73743[(8)] = inst_73677);

(statearr_73743[(9)] = inst_73676__$1);

(statearr_73743[(10)] = inst_73678__$1);

(statearr_73743[(11)] = inst_73679);

return statearr_73743;
})();
var statearr_73744_73765 = state_73732__$1;
(statearr_73744_73765[(2)] = null);

(statearr_73744_73765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (2))){
var inst_73675 = (state_73732[(7)]);
var inst_73677 = (state_73732[(8)]);
var inst_73683 = (state_73732[(12)]);
var inst_73681 = (state_73732[(13)]);
var inst_73676 = (state_73732[(9)]);
var inst_73678 = (state_73732[(10)]);
var inst_73679 = (state_73732[(11)]);
var inst_73681__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_73677);
var inst_73682 = (function (){var fuel = inst_73675;
var cache = inst_73676;
var curr_block = inst_73677;
var rest_blocks = inst_73678;
var acc = inst_73679;
var flakes = inst_73681__$1;
return (function (p1__73665_SHARP_){
return p1__73665_SHARP_.op;
});
})();
var inst_73683__$1 = cljs.core.filter.call(null,inst_73682,inst_73681__$1);
var inst_73684 = cljs.core.empty_QMARK_.call(null,inst_73683__$1);
var inst_73685 = (!(inst_73684));
var state_73732__$1 = (function (){var statearr_73745 = state_73732;
(statearr_73745[(12)] = inst_73683__$1);

(statearr_73745[(13)] = inst_73681__$1);

return statearr_73745;
})();
if(inst_73685){
var statearr_73746_73766 = state_73732__$1;
(statearr_73746_73766[(1)] = (4));

} else {
var statearr_73747_73767 = state_73732__$1;
(statearr_73747_73767[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (11))){
var inst_73708 = (state_73732[(2)]);
var inst_73709 = fluree.db.util.async.throw_err.call(null,inst_73708);
var state_73732__$1 = state_73732;
var statearr_73748_73768 = state_73732__$1;
(statearr_73748_73768[(2)] = inst_73709);

(statearr_73748_73768[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (9))){
var state_73732__$1 = state_73732;
var statearr_73749_73769 = state_73732__$1;
(statearr_73749_73769[(2)] = null);

(statearr_73749_73769[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (5))){
var state_73732__$1 = state_73732;
var statearr_73750_73770 = state_73732__$1;
(statearr_73750_73770[(2)] = null);

(statearr_73750_73770[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (14))){
var inst_73728 = (state_73732[(2)]);
var state_73732__$1 = state_73732;
var statearr_73751_73771 = state_73732__$1;
(statearr_73751_73771[(2)] = inst_73728);

(statearr_73751_73771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (10))){
var inst_73677 = (state_73732[(8)]);
var inst_73696 = (state_73732[(16)]);
var inst_73678 = (state_73732[(10)]);
var inst_73679 = (state_73732[(11)]);
var inst_73712 = (state_73732[(2)]);
var inst_73713 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_73714 = [inst_73696,inst_73712];
var inst_73715 = cljs.core.PersistentHashMap.fromArrays(inst_73713,inst_73714);
var inst_73716 = cljs.core.assoc.call(null,inst_73677,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_73715);
var inst_73717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73718 = [inst_73716];
var inst_73719 = (new cljs.core.PersistentVector(null,1,(5),inst_73717,inst_73718,null));
var inst_73720 = cljs.core.concat.call(null,inst_73679,inst_73719);
var inst_73721 = cljs.core.first.call(null,inst_73678);
var state_73732__$1 = (function (){var statearr_73752 = state_73732;
(statearr_73752[(14)] = inst_73720);

return statearr_73752;
})();
if(cljs.core.truth_(inst_73721)){
var statearr_73753_73772 = state_73732__$1;
(statearr_73753_73772[(1)] = (12));

} else {
var statearr_73754_73773 = state_73732__$1;
(statearr_73754_73773[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (8))){
var inst_73675 = (state_73732[(7)]);
var inst_73698 = (state_73732[(15)]);
var inst_73677 = (state_73732[(8)]);
var inst_73683 = (state_73732[(12)]);
var inst_73681 = (state_73732[(13)]);
var inst_73676 = (state_73732[(9)]);
var inst_73696 = (state_73732[(16)]);
var inst_73678 = (state_73732[(10)]);
var inst_73679 = (state_73732[(11)]);
var inst_73702 = (function (){var flakes = inst_73681;
var rest_blocks = inst_73678;
var curr_block = inst_73677;
var asserted_SINGLEQUOTE_ = inst_73696;
var acc = inst_73679;
var fuel = inst_73675;
var cache = inst_73676;
var retracted = inst_73698;
var asserted = inst_73683;
return (function (p1__73668_SHARP_){
return p1__73668_SHARP_.s;
});
})();
var inst_73703 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_73698);
var inst_73704 = cljs.core.group_by.call(null,inst_73702,inst_73703);
var inst_73705 = cljs.core.vals.call(null,inst_73704);
var inst_73706 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_73676,inst_73675,inst_73705);
var state_73732__$1 = state_73732;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73732__$1,(11),inst_73706);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_73755 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73755[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__);

(statearr_73755[(1)] = (1));

return statearr_73755;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1 = (function (state_73732){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_73732);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73756){var ex__2687__auto__ = e73756;
var statearr_73757_73774 = state_73732;
(statearr_73757_73774[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_73732[(4)]))){
var statearr_73758_73775 = state_73732;
(statearr_73758_73775[(1)] = cljs.core.first.call(null,(state_73732[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73776 = state_73732;
state_73732 = G__73776;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__ = function(state_73732){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1.call(this,state_73732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73759 = f__2707__auto__.call(null);
(statearr_73759[(6)] = c__2706__auto__);

return statearr_73759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73876){
var state_val_73877 = (state_73876[(1)]);
if((state_val_73877 === (7))){
var inst_73841 = (state_73876[(7)]);
var inst_73848 = (state_73876[(8)]);
var inst_73847 = cljs.core.seq.call(null,inst_73841);
var inst_73848__$1 = cljs.core.first.call(null,inst_73847);
var inst_73849 = cljs.core.next.call(null,inst_73847);
var state_73876__$1 = (function (){var statearr_73878 = state_73876;
(statearr_73878[(8)] = inst_73848__$1);

(statearr_73878[(9)] = inst_73849);

return statearr_73878;
})();
if(cljs.core.truth_(inst_73848__$1)){
var statearr_73879_73916 = state_73876__$1;
(statearr_73879_73916[(1)] = (9));

} else {
var statearr_73880_73917 = state_73876__$1;
(statearr_73880_73917[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73877 === (1))){
var state_73876__$1 = state_73876;
var statearr_73881_73918 = state_73876__$1;
(statearr_73881_73918[(2)] = null);

(statearr_73881_73918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73877 === (4))){
var inst_73778 = (state_73876[(2)]);
var state_73876__$1 = state_73876;
var statearr_73882_73919 = state_73876__$1;
(statearr_73882_73919[(2)] = inst_73778);

(statearr_73882_73919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73877 === (6))){
var inst_73827 = (state_73876[(2)]);
var inst_73828 = fluree.db.util.async.throw_err.call(null,inst_73827);
var inst_73836 = resp;
var inst_73837 = cljs.core.seq.call(null,inst_73836);
var inst_73838 = cljs.core.first.call(null,inst_73837);
var inst_73839 = cljs.core.next.call(null,inst_73837);
var inst_73840 = cljs.core.PersistentHashMap.EMPTY;
var inst_73841 = inst_73836;
var inst_73842 = inst_73840;
var state_73876__$1 = (function (){var statearr_73883 = state_73876;
(statearr_73883[(10)] = inst_73839);

(statearr_73883[(7)] = inst_73841);

(statearr_73883[(11)] = inst_73838);

(statearr_73883[(12)] = inst_73842);

(statearr_73883[(13)] = inst_73828);

return statearr_73883;
})();
var statearr_73884_73920 = state_73876__$1;
(statearr_73884_73920[(2)] = null);

(statearr_73884_73920[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73877 === (3))){
var inst_73874 = (state_73876[(2)]);
var state_73876__$1 = state_73876;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73876__$1,inst_73874);
} else {
if((state_val_73877 === (2))){
var _ = (function (){var statearr_73885 = state_73876;
(statearr_73885[(4)] = cljs.core.cons.call(null,(5),(state_73876[(4)])));

return statearr_73885;
})();
var inst_73784 = (function (){return (function (p1__73777_SHARP_){
return p1__73777_SHARP_.t;
});
})();
var inst_73785 = cljs.core.map.call(null,inst_73784,resp);
var inst_73786 = cljs.core.set.call(null,inst_73785);
var inst_73823 = cljs.core.async.chan.call(null,(1));
var inst_73824 = (function (){var ts = inst_73786;
var c__2706__auto____$1 = inst_73823;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73821){
var state_val_73822 = (state_73821[(1)]);
if((state_val_73822 === (1))){
var inst_73794 = ts;
var inst_73795 = cljs.core.seq.call(null,inst_73794);
var inst_73796 = cljs.core.first.call(null,inst_73795);
var inst_73797 = cljs.core.next.call(null,inst_73795);
var inst_73798 = cljs.core.PersistentHashMap.EMPTY;
var inst_73799 = inst_73794;
var inst_73800 = inst_73798;
var state_73821__$1 = (function (){var statearr_73886 = state_73821;
(statearr_73886[(7)] = inst_73800);

(statearr_73886[(8)] = inst_73796);

(statearr_73886[(9)] = inst_73797);

(statearr_73886[(10)] = inst_73799);

return statearr_73886;
})();
var statearr_73887_73921 = state_73821__$1;
(statearr_73887_73921[(2)] = null);

(statearr_73887_73921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73822 === (2))){
var inst_73806 = (state_73821[(11)]);
var inst_73799 = (state_73821[(10)]);
var inst_73805 = cljs.core.seq.call(null,inst_73799);
var inst_73806__$1 = cljs.core.first.call(null,inst_73805);
var inst_73807 = cljs.core.next.call(null,inst_73805);
var state_73821__$1 = (function (){var statearr_73888 = state_73821;
(statearr_73888[(11)] = inst_73806__$1);

(statearr_73888[(12)] = inst_73807);

return statearr_73888;
})();
if(cljs.core.truth_(inst_73806__$1)){
var statearr_73889_73922 = state_73821__$1;
(statearr_73889_73922[(1)] = (4));

} else {
var statearr_73890_73923 = state_73821__$1;
(statearr_73890_73923[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73822 === (3))){
var inst_73819 = (state_73821[(2)]);
var state_73821__$1 = state_73821;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73821__$1,inst_73819);
} else {
if((state_val_73822 === (4))){
var inst_73806 = (state_73821[(11)]);
var inst_73809 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_73806);
var state_73821__$1 = state_73821;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73821__$1,(7),inst_73809);
} else {
if((state_val_73822 === (5))){
var inst_73800 = (state_73821[(7)]);
var state_73821__$1 = state_73821;
var statearr_73891_73924 = state_73821__$1;
(statearr_73891_73924[(2)] = inst_73800);

(statearr_73891_73924[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73822 === (6))){
var inst_73817 = (state_73821[(2)]);
var state_73821__$1 = state_73821;
var statearr_73892_73925 = state_73821__$1;
(statearr_73892_73925[(2)] = inst_73817);

(statearr_73892_73925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73822 === (7))){
var inst_73800 = (state_73821[(7)]);
var inst_73806 = (state_73821[(11)]);
var inst_73807 = (state_73821[(12)]);
var inst_73811 = (state_73821[(2)]);
var inst_73812 = fluree.db.util.async.throw_err.call(null,inst_73811);
var inst_73813 = cljs.core.assoc.call(null,inst_73800,inst_73806,inst_73812);
var inst_73799 = inst_73807;
var inst_73800__$1 = inst_73813;
var state_73821__$1 = (function (){var statearr_73893 = state_73821;
(statearr_73893[(7)] = inst_73800__$1);

(statearr_73893[(10)] = inst_73799);

return statearr_73893;
})();
var statearr_73894_73926 = state_73821__$1;
(statearr_73894_73926[(2)] = null);

(statearr_73894_73926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_73895 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73895[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__);

(statearr_73895[(1)] = (1));

return statearr_73895;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1 = (function (state_73821){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_73821);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73896){var ex__2687__auto__ = e73896;
var statearr_73897_73927 = state_73821;
(statearr_73897_73927[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_73821[(4)]))){
var statearr_73898_73928 = state_73821;
(statearr_73898_73928[(1)] = cljs.core.first.call(null,(state_73821[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73929 = state_73821;
state_73821 = G__73929;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = function(state_73821){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1.call(this,state_73821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73899 = f__2707__auto__.call(null);
(statearr_73899[(6)] = c__2706__auto____$1);

return statearr_73899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
});
})();
var inst_73825 = cljs.core.async.impl.dispatch.run.call(null,inst_73824);
var state_73876__$1 = (function (){var statearr_73900 = state_73876;
(statearr_73900[(14)] = inst_73825);

return statearr_73900;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73876__$1,(6),inst_73823);
} else {
if((state_val_73877 === (11))){
var inst_73868 = (state_73876[(2)]);
var state_73876__$1 = state_73876;
var statearr_73902_73930 = state_73876__$1;
(statearr_73902_73930[(2)] = inst_73868);

(statearr_73902_73930[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73877 === (9))){
var inst_73842 = (state_73876[(12)]);
var inst_73828 = (state_73876[(13)]);
var inst_73848 = (state_73876[(8)]);
var inst_73849 = (state_73876[(9)]);
var inst_73851 = inst_73848.t;
var inst_73852 = cljs.core.get.call(null,inst_73828,inst_73851);
var inst_73853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73854 = [inst_73852,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73855 = (new cljs.core.PersistentVector(null,2,(5),inst_73853,inst_73854,null));
var inst_73856 = cljs.core.assoc_in.call(null,inst_73842,inst_73855,inst_73852);
var inst_73857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73858 = [inst_73852,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_73859 = (new cljs.core.PersistentVector(null,2,(5),inst_73857,inst_73858,null));
var inst_73860 = cljs.core.update_in.call(null,inst_73856,inst_73859,cljs.core.conj,inst_73848);
var inst_73861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73862 = [inst_73852,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_73863 = (new cljs.core.PersistentVector(null,2,(5),inst_73861,inst_73862,null));
var inst_73864 = cljs.core.update_in.call(null,inst_73860,inst_73863,fluree.db.api_js.min_safe,inst_73851);
var inst_73841 = inst_73849;
var inst_73842__$1 = inst_73864;
var state_73876__$1 = (function (){var statearr_73903 = state_73876;
(statearr_73903[(7)] = inst_73841);

(statearr_73903[(12)] = inst_73842__$1);

return statearr_73903;
})();
var statearr_73904_73931 = state_73876__$1;
(statearr_73904_73931[(2)] = null);

(statearr_73904_73931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73877 === (5))){
var _ = (function (){var statearr_73905 = state_73876;
(statearr_73905[(4)] = cljs.core.rest.call(null,(state_73876[(4)])));

return statearr_73905;
})();
var state_73876__$1 = state_73876;
var ex73901 = (state_73876__$1[(2)]);
var statearr_73906_73932 = state_73876__$1;
(statearr_73906_73932[(5)] = ex73901);


if((ex73901 instanceof Error)){
var statearr_73907_73933 = state_73876__$1;
(statearr_73907_73933[(1)] = (4));

(statearr_73907_73933[(5)] = null);

} else {
throw ex73901;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73877 === (10))){
var inst_73842 = (state_73876[(12)]);
var state_73876__$1 = state_73876;
var statearr_73908_73934 = state_73876__$1;
(statearr_73908_73934[(2)] = inst_73842);

(statearr_73908_73934[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73877 === (8))){
var inst_73870 = (state_73876[(2)]);
var inst_73871 = cljs.core.vals.call(null,inst_73870);
var _ = (function (){var statearr_73909 = state_73876;
(statearr_73909[(4)] = cljs.core.rest.call(null,(state_73876[(4)])));

return statearr_73909;
})();
var state_73876__$1 = state_73876;
var statearr_73910_73935 = state_73876__$1;
(statearr_73910_73935[(2)] = inst_73871);

(statearr_73910_73935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_73911 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73911[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__);

(statearr_73911[(1)] = (1));

return statearr_73911;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1 = (function (state_73876){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_73876);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73912){var ex__2687__auto__ = e73912;
var statearr_73913_73936 = state_73876;
(statearr_73913_73936[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_73876[(4)]))){
var statearr_73914_73937 = state_73876;
(statearr_73914_73937[(1)] = cljs.core.first.call(null,(state_73876[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73938 = state_73876;
state_73876 = G__73938;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = function(state_73876){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1.call(this,state_73876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73915 = f__2707__auto__.call(null);
(statearr_73915[(6)] = c__2706__auto__);

return statearr_73915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74086){
var state_val_74087 = (state_74086[(1)]);
if((state_val_74087 === (7))){
var inst_73966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73967 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73968 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73969 = [inst_73967,inst_73968];
var inst_73970 = (new cljs.core.PersistentVector(null,2,(5),inst_73966,inst_73969,null));
var state_74086__$1 = state_74086;
var statearr_74088_74159 = state_74086__$1;
(statearr_74088_74159[(2)] = inst_73970);

(statearr_74088_74159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (20))){
var inst_73996 = (state_74086[(7)]);
var state_74086__$1 = state_74086;
var statearr_74089_74160 = state_74086__$1;
(statearr_74089_74160[(2)] = inst_73996);

(statearr_74089_74160[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (27))){
var state_74086__$1 = state_74086;
var statearr_74090_74161 = state_74086__$1;
(statearr_74090_74161[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (1))){
var state_74086__$1 = state_74086;
var statearr_74092_74162 = state_74086__$1;
(statearr_74092_74162[(2)] = null);

(statearr_74092_74162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (24))){
var inst_73995 = (state_74086[(8)]);
var state_74086__$1 = state_74086;
if(cljs.core.truth_(inst_73995)){
var statearr_74093_74163 = state_74086__$1;
(statearr_74093_74163[(1)] = (26));

} else {
var statearr_74094_74164 = state_74086__$1;
(statearr_74094_74164[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (39))){
var inst_74041 = (state_74086[(9)]);
var inst_74042 = (state_74086[(10)]);
var inst_74067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74068 = [inst_74041,inst_74042];
var inst_74069 = (new cljs.core.PersistentVector(null,2,(5),inst_74067,inst_74068,null));
var state_74086__$1 = state_74086;
var statearr_74095_74165 = state_74086__$1;
(statearr_74095_74165[(2)] = inst_74069);

(statearr_74095_74165[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (4))){
var inst_73939 = (state_74086[(2)]);
var inst_73940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73941 = [inst_73939];
var inst_73942 = (new cljs.core.PersistentVector(null,1,(5),inst_73940,inst_73941,null));
var inst_73943 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73942);
var inst_73944 = cljs.core.ex_data.call(null,inst_73939);
var inst_73945 = cljs.core.ex_message.call(null,inst_73939);
var inst_73946 = cljs.core.assoc.call(null,inst_73944,new cljs.core.Keyword(null,"message","message",-406056002),inst_73945);
var state_74086__$1 = (function (){var statearr_74096 = state_74086;
(statearr_74096[(11)] = inst_73943);

return statearr_74096;
})();
var statearr_74097_74166 = state_74086__$1;
(statearr_74097_74166[(2)] = inst_73946);

(statearr_74097_74166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (15))){
var inst_73980 = (state_74086[(12)]);
var inst_73975 = (state_74086[(13)]);
var inst_73989 = (state_74086[(2)]);
var inst_73990 = [inst_73980,inst_73989];
var inst_73991 = (new cljs.core.PersistentVector(null,2,(5),inst_73975,inst_73990,null));
var state_74086__$1 = state_74086;
var statearr_74098_74167 = state_74086__$1;
(statearr_74098_74167[(2)] = inst_73991);

(statearr_74098_74167[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (21))){
var inst_73995 = (state_74086[(8)]);
var state_74086__$1 = state_74086;
var statearr_74099_74168 = state_74086__$1;
(statearr_74099_74168[(2)] = inst_73995);

(statearr_74099_74168[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (31))){
var inst_74036 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74100_74169 = state_74086__$1;
(statearr_74100_74169[(2)] = inst_74036);

(statearr_74100_74169[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (32))){
var inst_74042 = (state_74086[(10)]);
var inst_74045 = cljs.core.pos_int_QMARK_.call(null,inst_74042);
var state_74086__$1 = state_74086;
var statearr_74101_74170 = state_74086__$1;
(statearr_74101_74170[(2)] = inst_74045);

(statearr_74101_74170[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (40))){
var inst_74073 = (state_74086[(14)]);
var inst_73997 = (state_74086[(15)]);
var inst_74071 = (state_74086[(2)]);
var inst_74072 = cljs.core.nth.call(null,inst_74071,(0),null);
var inst_74073__$1 = cljs.core.nth.call(null,inst_74071,(1),null);
var inst_74074 = (inst_74073__$1 > inst_73997);
var state_74086__$1 = (function (){var statearr_74102 = state_74086;
(statearr_74102[(14)] = inst_74073__$1);

(statearr_74102[(16)] = inst_74072);

return statearr_74102;
})();
if(cljs.core.truth_(inst_74074)){
var statearr_74103_74171 = state_74086__$1;
(statearr_74103_74171[(1)] = (41));

} else {
var statearr_74104_74172 = state_74086__$1;
(statearr_74104_74172[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (33))){
var inst_74043 = (state_74086[(17)]);
var state_74086__$1 = state_74086;
var statearr_74105_74173 = state_74086__$1;
(statearr_74105_74173[(2)] = inst_74043);

(statearr_74105_74173[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (13))){
var inst_73981 = (state_74086[(18)]);
var inst_73983 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_73981);
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74086__$1,(16),inst_73983);
} else {
if((state_val_74087 === (22))){
var inst_74014 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
if(cljs.core.truth_(inst_74014)){
var statearr_74106_74174 = state_74086__$1;
(statearr_74106_74174[(1)] = (23));

} else {
var statearr_74107_74175 = state_74086__$1;
(statearr_74107_74175[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (36))){
var state_74086__$1 = state_74086;
var statearr_74108_74176 = state_74086__$1;
(statearr_74108_74176[(2)] = null);

(statearr_74108_74176[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (41))){
var inst_73997 = (state_74086[(15)]);
var state_74086__$1 = state_74086;
var statearr_74109_74177 = state_74086__$1;
(statearr_74109_74177[(2)] = inst_73997);

(statearr_74109_74177[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (43))){
var inst_74072 = (state_74086[(16)]);
var inst_74078 = (state_74086[(2)]);
var inst_74079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74080 = [inst_74072,inst_74078];
var inst_74081 = (new cljs.core.PersistentVector(null,2,(5),inst_74079,inst_74080,null));
var _ = (function (){var statearr_74110 = state_74086;
(statearr_74110[(4)] = cljs.core.rest.call(null,(state_74086[(4)])));

return statearr_74110;
})();
var state_74086__$1 = state_74086;
var statearr_74111_74178 = state_74086__$1;
(statearr_74111_74178[(2)] = inst_74081);

(statearr_74111_74178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (29))){
var inst_73972 = (state_74086[(19)]);
var inst_74027 = cljs.core.pr_str.call(null,inst_73972);
var inst_74028 = ["Invalid block range provided: ",inst_74027].join('');
var inst_74029 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74030 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74031 = cljs.core.PersistentHashMap.fromArrays(inst_74029,inst_74030);
var inst_74032 = cljs.core.ex_info.call(null,inst_74028,inst_74031);
var inst_74033 = (function(){throw inst_74032})();
var state_74086__$1 = state_74086;
var statearr_74112_74179 = state_74086__$1;
(statearr_74112_74179[(2)] = inst_74033);

(statearr_74112_74179[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (6))){
var inst_73964 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_74086__$1 = state_74086;
var statearr_74113_74180 = state_74086__$1;
(statearr_74113_74180[(2)] = inst_73964);

(statearr_74113_74180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (28))){
var inst_74038 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74114_74181 = state_74086__$1;
(statearr_74114_74181[(2)] = inst_74038);

(statearr_74114_74181[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (25))){
var inst_74041 = (state_74086[(9)]);
var inst_74043 = (state_74086[(17)]);
var inst_74040 = (state_74086[(2)]);
var inst_74041__$1 = cljs.core.nth.call(null,inst_74040,(0),null);
var inst_74042 = cljs.core.nth.call(null,inst_74040,(1),null);
var inst_74043__$1 = cljs.core.pos_int_QMARK_.call(null,inst_74041__$1);
var state_74086__$1 = (function (){var statearr_74115 = state_74086;
(statearr_74115[(9)] = inst_74041__$1);

(statearr_74115[(17)] = inst_74043__$1);

(statearr_74115[(10)] = inst_74042);

return statearr_74115;
})();
if(inst_74043__$1){
var statearr_74116_74182 = state_74086__$1;
(statearr_74116_74182[(1)] = (32));

} else {
var statearr_74117_74183 = state_74086__$1;
(statearr_74117_74183[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (34))){
var inst_74048 = (state_74086[(2)]);
var inst_74049 = cljs.core.not.call(null,inst_74048);
var state_74086__$1 = state_74086;
if(inst_74049){
var statearr_74118_74184 = state_74086__$1;
(statearr_74118_74184[(1)] = (35));

} else {
var statearr_74119_74185 = state_74086__$1;
(statearr_74119_74185[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (17))){
var inst_73995 = (state_74086[(8)]);
var inst_73997 = (state_74086[(15)]);
var inst_74000 = cljs.core.pr_str.call(null,inst_73995);
var inst_74001 = cljs.core.pr_str.call(null,inst_73997);
var inst_74002 = ["Start block is out of range for this ledger. Start block provided: ",inst_74000,". Database block: ",inst_74001].join('');
var inst_74003 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74004 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74005 = cljs.core.PersistentHashMap.fromArrays(inst_74003,inst_74004);
var inst_74006 = cljs.core.ex_info.call(null,inst_74002,inst_74005);
var inst_74007 = (function(){throw inst_74006})();
var state_74086__$1 = state_74086;
var statearr_74120_74186 = state_74086__$1;
(statearr_74120_74186[(2)] = inst_74007);

(statearr_74120_74186[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (3))){
var inst_74084 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74086__$1,inst_74084);
} else {
if((state_val_74087 === (12))){
var inst_73981 = (state_74086[(18)]);
var inst_73972 = (state_74086[(19)]);
var inst_73979 = (state_74086[(2)]);
var inst_73980 = fluree.db.util.async.throw_err.call(null,inst_73979);
var inst_73981__$1 = cljs.core.second.call(null,inst_73972);
var state_74086__$1 = (function (){var statearr_74121 = state_74086;
(statearr_74121[(18)] = inst_73981__$1);

(statearr_74121[(12)] = inst_73980);

return statearr_74121;
})();
if(cljs.core.truth_(inst_73981__$1)){
var statearr_74122_74187 = state_74086__$1;
(statearr_74122_74187[(1)] = (13));

} else {
var statearr_74123_74188 = state_74086__$1;
(statearr_74123_74188[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (2))){
var _ = (function (){var statearr_74124 = state_74086;
(statearr_74124[(4)] = cljs.core.cons.call(null,(5),(state_74086[(4)])));

return statearr_74124;
})();
var inst_73961 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73962 = cljs.core.sequential_QMARK_.call(null,inst_73961);
var state_74086__$1 = state_74086;
if(inst_73962){
var statearr_74125_74189 = state_74086__$1;
(statearr_74125_74189[(1)] = (6));

} else {
var statearr_74126_74190 = state_74086__$1;
(statearr_74126_74190[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (23))){
var inst_73995 = (state_74086[(8)]);
var inst_73996 = (state_74086[(7)]);
var inst_74016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74017 = [inst_73995,inst_73996];
var inst_74018 = (new cljs.core.PersistentVector(null,2,(5),inst_74016,inst_74017,null));
var state_74086__$1 = state_74086;
var statearr_74127_74191 = state_74086__$1;
(statearr_74127_74191[(2)] = inst_74018);

(statearr_74127_74191[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (35))){
var inst_73972 = (state_74086[(19)]);
var inst_74051 = cljs.core.pr_str.call(null,inst_73972);
var inst_74052 = ["Invalid block range provided: ",inst_74051].join('');
var inst_74053 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74054 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74055 = cljs.core.PersistentHashMap.fromArrays(inst_74053,inst_74054);
var inst_74056 = cljs.core.ex_info.call(null,inst_74052,inst_74055);
var inst_74057 = (function(){throw inst_74056})();
var state_74086__$1 = state_74086;
var statearr_74128_74192 = state_74086__$1;
(statearr_74128_74192[(2)] = inst_74057);

(statearr_74128_74192[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (19))){
var inst_73995 = (state_74086[(8)]);
var inst_74010 = (state_74086[(2)]);
var state_74086__$1 = (function (){var statearr_74129 = state_74086;
(statearr_74129[(20)] = inst_74010);

return statearr_74129;
})();
if(cljs.core.truth_(inst_73995)){
var statearr_74130_74193 = state_74086__$1;
(statearr_74130_74193[(1)] = (20));

} else {
var statearr_74131_74194 = state_74086__$1;
(statearr_74131_74194[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (11))){
var inst_73995 = (state_74086[(8)]);
var inst_73997 = (state_74086[(15)]);
var inst_73994 = (state_74086[(2)]);
var inst_73995__$1 = cljs.core.nth.call(null,inst_73994,(0),null);
var inst_73996 = cljs.core.nth.call(null,inst_73994,(1),null);
var inst_73997__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73998 = (inst_73995__$1 > inst_73997__$1);
var state_74086__$1 = (function (){var statearr_74133 = state_74086;
(statearr_74133[(8)] = inst_73995__$1);

(statearr_74133[(7)] = inst_73996);

(statearr_74133[(15)] = inst_73997__$1);

return statearr_74133;
})();
if(cljs.core.truth_(inst_73998)){
var statearr_74134_74195 = state_74086__$1;
(statearr_74134_74195[(1)] = (17));

} else {
var statearr_74135_74196 = state_74086__$1;
(statearr_74135_74196[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (9))){
var inst_73972 = (state_74086[(19)]);
var inst_73975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73976 = cljs.core.first.call(null,inst_73972);
var inst_73977 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_73976);
var state_74086__$1 = (function (){var statearr_74136 = state_74086;
(statearr_74136[(13)] = inst_73975);

return statearr_74136;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74086__$1,(12),inst_73977);
} else {
if((state_val_74087 === (5))){
var _ = (function (){var statearr_74137 = state_74086;
(statearr_74137[(4)] = cljs.core.rest.call(null,(state_74086[(4)])));

return statearr_74137;
})();
var state_74086__$1 = state_74086;
var ex74132 = (state_74086__$1[(2)]);
var statearr_74138_74197 = state_74086__$1;
(statearr_74138_74197[(5)] = ex74132);


var statearr_74139_74198 = state_74086__$1;
(statearr_74139_74198[(1)] = (4));

(statearr_74139_74198[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (14))){
var state_74086__$1 = state_74086;
var statearr_74140_74199 = state_74086__$1;
(statearr_74140_74199[(2)] = null);

(statearr_74140_74199[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (26))){
var inst_73995 = (state_74086[(8)]);
var inst_74021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74022 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_74023 = [inst_73995,inst_74022];
var inst_74024 = (new cljs.core.PersistentVector(null,2,(5),inst_74021,inst_74023,null));
var state_74086__$1 = state_74086;
var statearr_74141_74200 = state_74086__$1;
(statearr_74141_74200[(2)] = inst_74024);

(statearr_74141_74200[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (16))){
var inst_73985 = (state_74086[(2)]);
var inst_73986 = fluree.db.util.async.throw_err.call(null,inst_73985);
var state_74086__$1 = state_74086;
var statearr_74142_74201 = state_74086__$1;
(statearr_74142_74201[(2)] = inst_73986);

(statearr_74142_74201[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (38))){
var inst_74041 = (state_74086[(9)]);
var inst_74042 = (state_74086[(10)]);
var inst_74063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74064 = [inst_74042,inst_74041];
var inst_74065 = (new cljs.core.PersistentVector(null,2,(5),inst_74063,inst_74064,null));
var state_74086__$1 = state_74086;
var statearr_74143_74202 = state_74086__$1;
(statearr_74143_74202[(2)] = inst_74065);

(statearr_74143_74202[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (30))){
var state_74086__$1 = state_74086;
var statearr_74144_74203 = state_74086__$1;
(statearr_74144_74203[(2)] = null);

(statearr_74144_74203[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (10))){
var inst_73972 = (state_74086[(19)]);
var state_74086__$1 = state_74086;
var statearr_74145_74204 = state_74086__$1;
(statearr_74145_74204[(2)] = inst_73972);

(statearr_74145_74204[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (18))){
var state_74086__$1 = state_74086;
var statearr_74146_74205 = state_74086__$1;
(statearr_74146_74205[(2)] = null);

(statearr_74146_74205[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (42))){
var inst_74073 = (state_74086[(14)]);
var state_74086__$1 = state_74086;
var statearr_74147_74206 = state_74086__$1;
(statearr_74147_74206[(2)] = inst_74073);

(statearr_74147_74206[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (37))){
var inst_74041 = (state_74086[(9)]);
var inst_74042 = (state_74086[(10)]);
var inst_74060 = (state_74086[(2)]);
var inst_74061 = (inst_74042 < inst_74041);
var state_74086__$1 = (function (){var statearr_74148 = state_74086;
(statearr_74148[(21)] = inst_74060);

return statearr_74148;
})();
if(cljs.core.truth_(inst_74061)){
var statearr_74149_74207 = state_74086__$1;
(statearr_74149_74207[(1)] = (38));

} else {
var statearr_74150_74208 = state_74086__$1;
(statearr_74150_74208[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (8))){
var inst_73972 = (state_74086[(19)]);
var inst_73972__$1 = (state_74086[(2)]);
var inst_73973 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_73972__$1);
var state_74086__$1 = (function (){var statearr_74151 = state_74086;
(statearr_74151[(19)] = inst_73972__$1);

return statearr_74151;
})();
if(cljs.core.truth_(inst_73973)){
var statearr_74152_74209 = state_74086__$1;
(statearr_74152_74209[(1)] = (9));

} else {
var statearr_74153_74210 = state_74086__$1;
(statearr_74153_74210[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0 = (function (){
var statearr_74154 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74154[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__);

(statearr_74154[(1)] = (1));

return statearr_74154;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1 = (function (state_74086){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_74086);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74155){var ex__2687__auto__ = e74155;
var statearr_74156_74211 = state_74086;
(statearr_74156_74211[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_74086[(4)]))){
var statearr_74157_74212 = state_74086;
(statearr_74157_74212[(1)] = cljs.core.first.call(null,(state_74086[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74213 = state_74086;
state_74086 = G__74213;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__ = function(state_74086){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1.call(this,state_74086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74158 = f__2707__auto__.call(null);
(statearr_74158[(6)] = c__2706__auto__);

return statearr_74158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__74215 = arguments.length;
switch (G__74215) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74309){
var state_val_74310 = (state_74309[(1)]);
if((state_val_74310 === (7))){
var inst_74241 = (state_74309[(7)]);
var inst_74244 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_74241);
var state_74309__$1 = state_74309;
var statearr_74311_74362 = state_74309__$1;
(statearr_74311_74362[(2)] = inst_74244);

(statearr_74311_74362[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (20))){
var inst_74280 = (state_74309[(8)]);
var inst_74283 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_74280);
var state_74309__$1 = state_74309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74309__$1,(23),inst_74283);
} else {
if((state_val_74310 === (27))){
var inst_74289 = (state_74309[(9)]);
var inst_74295 = cljs.core.doall.call(null,inst_74289);
var state_74309__$1 = state_74309;
var statearr_74312_74363 = state_74309__$1;
(statearr_74312_74363[(2)] = inst_74295);

(statearr_74312_74363[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (1))){
var state_74309__$1 = state_74309;
var statearr_74313_74364 = state_74309__$1;
(statearr_74313_74364[(2)] = null);

(statearr_74313_74364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (24))){
var inst_74289 = (state_74309[(9)]);
var inst_74292 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_74293 = cljs.core.sequential_QMARK_.call(null,inst_74289);
var state_74309__$1 = (function (){var statearr_74314 = state_74309;
(statearr_74314[(10)] = inst_74292);

return statearr_74314;
})();
if(inst_74293){
var statearr_74315_74365 = state_74309__$1;
(statearr_74315_74365[(1)] = (27));

} else {
var statearr_74316_74366 = state_74309__$1;
(statearr_74316_74366[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (4))){
var inst_74216 = (state_74309[(2)]);
var inst_74217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74218 = [inst_74216];
var inst_74219 = (new cljs.core.PersistentVector(null,1,(5),inst_74217,inst_74218,null));
var inst_74220 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74219);
var inst_74221 = cljs.core.ex_data.call(null,inst_74216);
var inst_74222 = cljs.core.ex_message.call(null,inst_74216);
var inst_74223 = cljs.core.assoc.call(null,inst_74221,new cljs.core.Keyword(null,"message","message",-406056002),inst_74222);
var state_74309__$1 = (function (){var statearr_74317 = state_74309;
(statearr_74317[(11)] = inst_74220);

return statearr_74317;
})();
var statearr_74318_74367 = state_74309__$1;
(statearr_74318_74367[(2)] = inst_74223);

(statearr_74318_74367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (15))){
var inst_74241 = (state_74309[(7)]);
var inst_74254 = (state_74309[(2)]);
var inst_74255 = cljs.core.ex_info.call(null,inst_74254,inst_74241);
var inst_74256 = (function(){throw inst_74255})();
var state_74309__$1 = state_74309;
var statearr_74319_74368 = state_74309__$1;
(statearr_74319_74368[(2)] = inst_74256);

(statearr_74319_74368[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (21))){
var inst_74280 = (state_74309[(8)]);
var state_74309__$1 = state_74309;
var statearr_74320_74369 = state_74309__$1;
(statearr_74320_74369[(2)] = inst_74280);

(statearr_74320_74369[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (13))){
var inst_74249 = (state_74309[(12)]);
var state_74309__$1 = state_74309;
var statearr_74321_74370 = state_74309__$1;
(statearr_74321_74370[(2)] = inst_74249);

(statearr_74321_74370[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (22))){
var inst_74289 = (state_74309[(2)]);
var inst_74290 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_74309__$1 = (function (){var statearr_74322 = state_74309;
(statearr_74322[(9)] = inst_74289);

return statearr_74322;
})();
if(cljs.core.truth_(inst_74290)){
var statearr_74323_74371 = state_74309__$1;
(statearr_74323_74371[(1)] = (24));

} else {
var statearr_74324_74372 = state_74309__$1;
(statearr_74324_74372[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (29))){
var inst_74233 = (state_74309[(13)]);
var inst_74292 = (state_74309[(10)]);
var inst_74298 = (state_74309[(2)]);
var inst_74299 = fluree.db.util.core.response_time_formatted.call(null,inst_74233);
var inst_74300 = [(200),inst_74298,(100),inst_74299];
var inst_74301 = cljs.core.PersistentHashMap.fromArrays(inst_74292,inst_74300);
var state_74309__$1 = state_74309;
var statearr_74325_74373 = state_74309__$1;
(statearr_74325_74373[(2)] = inst_74301);

(statearr_74325_74373[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (6))){
var inst_74242 = (state_74309[(14)]);
var inst_74241 = (state_74309[(7)]);
var inst_74240 = (state_74309[(2)]);
var inst_74241__$1 = fluree.db.util.async.throw_err.call(null,inst_74240);
var inst_74242__$1 = cljs.core.map_QMARK_.call(null,inst_74241__$1);
var state_74309__$1 = (function (){var statearr_74326 = state_74309;
(statearr_74326[(14)] = inst_74242__$1);

(statearr_74326[(7)] = inst_74241__$1);

return statearr_74326;
})();
if(inst_74242__$1){
var statearr_74327_74374 = state_74309__$1;
(statearr_74327_74374[(1)] = (7));

} else {
var statearr_74328_74375 = state_74309__$1;
(statearr_74328_74375[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (28))){
var inst_74289 = (state_74309[(9)]);
var state_74309__$1 = state_74309;
var statearr_74329_74376 = state_74309__$1;
(statearr_74329_74376[(2)] = inst_74289);

(statearr_74329_74376[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (25))){
var inst_74289 = (state_74309[(9)]);
var state_74309__$1 = state_74309;
var statearr_74330_74377 = state_74309__$1;
(statearr_74330_74377[(2)] = inst_74289);

(statearr_74330_74377[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (17))){
var inst_74272 = cljs.core.pr_str.call(null,query_map);
var inst_74273 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_74272].join('');
var inst_74274 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74275 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74276 = cljs.core.PersistentHashMap.fromArrays(inst_74274,inst_74275);
var inst_74277 = cljs.core.ex_info.call(null,inst_74273,inst_74276);
var inst_74278 = (function(){throw inst_74277})();
var state_74309__$1 = state_74309;
var statearr_74331_74378 = state_74309__$1;
(statearr_74331_74378[(2)] = inst_74278);

(statearr_74331_74378[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (3))){
var inst_74307 = (state_74309[(2)]);
var state_74309__$1 = state_74309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74309__$1,inst_74307);
} else {
if((state_val_74310 === (12))){
var inst_74241 = (state_74309[(7)]);
var inst_74259 = (state_74309[(2)]);
var inst_74260 = cljs.core.nth.call(null,inst_74241,(0),null);
var inst_74261 = cljs.core.nth.call(null,inst_74241,(1),null);
var inst_74262 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_74263 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_74264 = cljs.core.keys.call(null,inst_74263);
var inst_74265 = cljs.core._EQ_.call(null,inst_74262,inst_74264);
var state_74309__$1 = (function (){var statearr_74332 = state_74309;
(statearr_74332[(15)] = inst_74260);

(statearr_74332[(16)] = inst_74259);

(statearr_74332[(17)] = inst_74261);

return statearr_74332;
})();
if(inst_74265){
var statearr_74333_74379 = state_74309__$1;
(statearr_74333_74379[(1)] = (16));

} else {
var statearr_74334_74380 = state_74309__$1;
(statearr_74334_74380[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (2))){
var _ = (function (){var statearr_74335 = state_74309;
(statearr_74335[(4)] = cljs.core.cons.call(null,(5),(state_74309[(4)])));

return statearr_74335;
})();
var inst_74233 = fluree.db.util.core.current_time_millis.call(null);
var inst_74234 = db;
var inst_74235 = cljs.core.__destructure_map.call(null,inst_74234);
var inst_74236 = cljs.core.get.call(null,inst_74235,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_74237 = cljs.core.get.call(null,inst_74235,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_74238 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_74309__$1 = (function (){var statearr_74336 = state_74309;
(statearr_74336[(13)] = inst_74233);

(statearr_74336[(18)] = inst_74236);

(statearr_74336[(19)] = inst_74237);

return statearr_74336;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74309__$1,(6),inst_74238);
} else {
if((state_val_74310 === (23))){
var inst_74285 = (state_74309[(2)]);
var inst_74286 = fluree.db.util.async.throw_err.call(null,inst_74285);
var state_74309__$1 = state_74309;
var statearr_74337_74381 = state_74309__$1;
(statearr_74337_74381[(2)] = inst_74286);

(statearr_74337_74381[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (19))){
var inst_74269 = (state_74309[(2)]);
var inst_74270 = fluree.db.util.async.throw_err.call(null,inst_74269);
var state_74309__$1 = state_74309;
var statearr_74338_74382 = state_74309__$1;
(statearr_74338_74382[(2)] = inst_74270);

(statearr_74338_74382[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (11))){
var state_74309__$1 = state_74309;
var statearr_74340_74383 = state_74309__$1;
(statearr_74340_74383[(2)] = null);

(statearr_74340_74383[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (9))){
var inst_74247 = (state_74309[(2)]);
var state_74309__$1 = state_74309;
if(cljs.core.truth_(inst_74247)){
var statearr_74341_74384 = state_74309__$1;
(statearr_74341_74384[(1)] = (10));

} else {
var statearr_74342_74385 = state_74309__$1;
(statearr_74342_74385[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (5))){
var _ = (function (){var statearr_74343 = state_74309;
(statearr_74343[(4)] = cljs.core.rest.call(null,(state_74309[(4)])));

return statearr_74343;
})();
var state_74309__$1 = state_74309;
var ex74339 = (state_74309__$1[(2)]);
var statearr_74344_74386 = state_74309__$1;
(statearr_74344_74386[(5)] = ex74339);


var statearr_74345_74387 = state_74309__$1;
(statearr_74345_74387[(1)] = (4));

(statearr_74345_74387[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (14))){
var inst_74236 = (state_74309[(18)]);
var inst_74237 = (state_74309[(19)]);
var inst_74252 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74236),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74237)].join('');
var state_74309__$1 = state_74309;
var statearr_74346_74388 = state_74309__$1;
(statearr_74346_74388[(2)] = inst_74252);

(statearr_74346_74388[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (26))){
var inst_74304 = (state_74309[(2)]);
var _ = (function (){var statearr_74347 = state_74309;
(statearr_74347[(4)] = cljs.core.rest.call(null,(state_74309[(4)])));

return statearr_74347;
})();
var state_74309__$1 = state_74309;
var statearr_74348_74389 = state_74309__$1;
(statearr_74348_74389[(2)] = inst_74304);

(statearr_74348_74389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (16))){
var inst_74260 = (state_74309[(15)]);
var inst_74261 = (state_74309[(17)]);
var inst_74267 = fluree.db.query.block.block_range.call(null,db,inst_74260,inst_74261,opts);
var state_74309__$1 = state_74309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74309__$1,(19),inst_74267);
} else {
if((state_val_74310 === (10))){
var inst_74249 = (state_74309[(12)]);
var inst_74241 = (state_74309[(7)]);
var inst_74249__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_74241);
var state_74309__$1 = (function (){var statearr_74349 = state_74309;
(statearr_74349[(12)] = inst_74249__$1);

return statearr_74349;
})();
if(cljs.core.truth_(inst_74249__$1)){
var statearr_74350_74390 = state_74309__$1;
(statearr_74350_74390[(1)] = (13));

} else {
var statearr_74351_74391 = state_74309__$1;
(statearr_74351_74391[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (18))){
var inst_74280 = (state_74309[(2)]);
var inst_74281 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_74309__$1 = (function (){var statearr_74352 = state_74309;
(statearr_74352[(8)] = inst_74280);

return statearr_74352;
})();
if(cljs.core.truth_(inst_74281)){
var statearr_74353_74392 = state_74309__$1;
(statearr_74353_74392[(1)] = (20));

} else {
var statearr_74354_74393 = state_74309__$1;
(statearr_74354_74393[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74310 === (8))){
var inst_74242 = (state_74309[(14)]);
var state_74309__$1 = state_74309;
var statearr_74355_74394 = state_74309__$1;
(statearr_74355_74394[(2)] = inst_74242);

(statearr_74355_74394[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_74356 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74356[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_74356[(1)] = (1));

return statearr_74356;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_74309){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_74309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74357){var ex__2687__auto__ = e74357;
var statearr_74358_74395 = state_74309;
(statearr_74358_74395[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_74309[(4)]))){
var statearr_74359_74396 = state_74309;
(statearr_74359_74396[(1)] = cljs.core.first.call(null,(state_74309[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74397 = state_74309;
state_74309 = G__74397;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_74309){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_74309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74360 = f__2707__auto__.call(null);
(statearr_74360[(6)] = c__2706__auto__);

return statearr_74360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__74399 = arguments.length;
switch (G__74399) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74594){
var state_val_74595 = (state_74594[(1)]);
if((state_val_74595 === (62))){
var inst_74592 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74594__$1,inst_74592);
} else {
if((state_val_74595 === (7))){
var inst_74420 = (state_74594[(7)]);
var inst_74430 = cljs.core.not_EQ_.call(null,(1),inst_74420);
var state_74594__$1 = state_74594;
var statearr_74596_74687 = state_74594__$1;
(statearr_74596_74687[(2)] = inst_74430);

(statearr_74596_74687[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (59))){
var inst_74580 = (state_74594[(2)]);
var inst_74581 = fluree.db.util.async.throw_err.call(null,inst_74580);
var state_74594__$1 = state_74594;
var statearr_74597_74688 = state_74594__$1;
(statearr_74597_74688[(2)] = inst_74581);

(statearr_74597_74688[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (20))){
var inst_74488 = (state_74594[(8)]);
var inst_74496 = (state_74594[(9)]);
var inst_74488__$1 = (state_74594[(2)]);
var inst_74489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74490 = cljs.core.get.call(null,inst_74488__$1,(0));
var inst_74491 = cljs.core.get.call(null,inst_74488__$1,(1));
var inst_74492 = cljs.core.get.call(null,inst_74488__$1,(2));
var inst_74493 = cljs.core.get.call(null,inst_74488__$1,(3));
var inst_74494 = [inst_74490,inst_74491,inst_74492,inst_74493];
var inst_74495 = (new cljs.core.PersistentVector(null,4,(5),inst_74489,inst_74494,null));
var inst_74496__$1 = cljs.core.nth.call(null,inst_74495,(0),null);
var inst_74497 = cljs.core.nth.call(null,inst_74495,(1),null);
var inst_74498 = cljs.core.nth.call(null,inst_74495,(2),null);
var inst_74499 = cljs.core.nth.call(null,inst_74495,(3),null);
var inst_74500 = (inst_74496__$1 == null);
var inst_74501 = cljs.core.not.call(null,inst_74500);
var state_74594__$1 = (function (){var statearr_74598 = state_74594;
(statearr_74598[(10)] = inst_74498);

(statearr_74598[(11)] = inst_74497);

(statearr_74598[(12)] = inst_74499);

(statearr_74598[(8)] = inst_74488__$1);

(statearr_74598[(9)] = inst_74496__$1);

return statearr_74598;
})();
if(inst_74501){
var statearr_74599_74689 = state_74594__$1;
(statearr_74599_74689[(1)] = (30));

} else {
var statearr_74600_74690 = state_74594__$1;
(statearr_74600_74690[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (58))){
var inst_74428 = (state_74594[(13)]);
var inst_74584 = (state_74594[(2)]);
var state_74594__$1 = (function (){var statearr_74601 = state_74594;
(statearr_74601[(14)] = inst_74584);

return statearr_74601;
})();
if(cljs.core.truth_(inst_74428)){
var statearr_74602_74691 = state_74594__$1;
(statearr_74602_74691[(1)] = (60));

} else {
var statearr_74603_74692 = state_74594__$1;
(statearr_74603_74692[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (60))){
var inst_74584 = (state_74594[(14)]);
var inst_74572 = (state_74594[(15)]);
var inst_74586 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_74587 = cljs.core.count.call(null,inst_74572);
var inst_74588 = [inst_74584,inst_74587,(200)];
var inst_74589 = cljs.core.PersistentHashMap.fromArrays(inst_74586,inst_74588);
var state_74594__$1 = state_74594;
var statearr_74604_74693 = state_74594__$1;
(statearr_74604_74693[(2)] = inst_74589);

(statearr_74604_74693[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (27))){
var inst_74407 = (state_74594[(16)]);
var inst_74476 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74407)].join('');
var inst_74477 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74478 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74479 = cljs.core.PersistentHashMap.fromArrays(inst_74477,inst_74478);
var inst_74480 = cljs.core.ex_info.call(null,inst_74476,inst_74479);
var inst_74481 = (function(){throw inst_74480})();
var state_74594__$1 = state_74594;
var statearr_74605_74694 = state_74594__$1;
(statearr_74605_74694[(2)] = inst_74481);

(statearr_74605_74694[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (1))){
var inst_74404 = query_map;
var inst_74405 = cljs.core.__destructure_map.call(null,inst_74404);
var inst_74406 = cljs.core.get.call(null,inst_74405,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74407 = cljs.core.get.call(null,inst_74405,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_74408 = cljs.core.get.call(null,inst_74405,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_74594__$1 = (function (){var statearr_74606 = state_74594;
(statearr_74606[(16)] = inst_74407);

(statearr_74606[(17)] = inst_74408);

(statearr_74606[(18)] = inst_74406);

return statearr_74606;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74594__$1,(2),sources);
} else {
if((state_val_74595 === (24))){
var inst_74407 = (state_74594[(16)]);
var inst_74465 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74407)].join('');
var inst_74466 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74467 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74468 = cljs.core.PersistentHashMap.fromArrays(inst_74466,inst_74467);
var inst_74469 = cljs.core.ex_info.call(null,inst_74465,inst_74468);
var inst_74470 = (function(){throw inst_74469})();
var state_74594__$1 = state_74594;
var statearr_74607_74695 = state_74594__$1;
(statearr_74607_74695[(2)] = inst_74470);

(statearr_74607_74695[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (55))){
var inst_74408 = (state_74594[(17)]);
var inst_74575 = (state_74594[(2)]);
var inst_74576 = fluree.db.util.async.throw_err.call(null,inst_74575);
var state_74594__$1 = (function (){var statearr_74608 = state_74594;
(statearr_74608[(19)] = inst_74576);

return statearr_74608;
})();
if(cljs.core.truth_(inst_74408)){
var statearr_74609_74696 = state_74594__$1;
(statearr_74609_74696[(1)] = (56));

} else {
var statearr_74610_74697 = state_74594__$1;
(statearr_74610_74697[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (39))){
var inst_74498 = (state_74594[(10)]);
var inst_74497 = (state_74594[(11)]);
var inst_74499 = (state_74594[(12)]);
var inst_74496 = (state_74594[(9)]);
var inst_74520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74522 = [inst_74497,inst_74496,inst_74498,inst_74499];
var inst_74523 = (new cljs.core.PersistentVector(null,4,(5),inst_74521,inst_74522,null));
var inst_74524 = [inst_74523,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_74525 = (new cljs.core.PersistentVector(null,2,(5),inst_74520,inst_74524,null));
var state_74594__$1 = state_74594;
var statearr_74611_74698 = state_74594__$1;
(statearr_74611_74698[(2)] = inst_74525);

(statearr_74611_74698[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (46))){
var inst_74530 = (state_74594[(20)]);
var state_74594__$1 = state_74594;
var statearr_74612_74699 = state_74594__$1;
(statearr_74612_74699[(2)] = inst_74530);

(statearr_74612_74699[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (4))){
var state_74594__$1 = state_74594;
var statearr_74613_74700 = state_74594__$1;
(statearr_74613_74700[(2)] = null);

(statearr_74613_74700[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (54))){
var inst_74572 = (state_74594[(15)]);
var inst_74411 = (state_74594[(21)]);
var inst_74571 = (state_74594[(2)]);
var inst_74572__$1 = fluree.db.util.async.throw_err.call(null,inst_74571);
var inst_74573 = fluree.db.api_js.format_history_resp.call(null,inst_74411,inst_74572__$1);
var state_74594__$1 = (function (){var statearr_74614 = state_74594;
(statearr_74614[(15)] = inst_74572__$1);

return statearr_74614;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74594__$1,(55),inst_74573);
} else {
if((state_val_74595 === (15))){
var inst_74411 = (state_74594[(21)]);
var inst_74452 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74411);
var state_74594__$1 = state_74594;
var statearr_74615_74701 = state_74594__$1;
(statearr_74615_74701[(2)] = inst_74452);

(statearr_74615_74701[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (48))){
var inst_74498 = (state_74594[(10)]);
var inst_74497 = (state_74594[(11)]);
var inst_74499 = (state_74594[(12)]);
var inst_74496 = (state_74594[(9)]);
var inst_74541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74543 = [inst_74497,inst_74498,inst_74496,inst_74499];
var inst_74544 = (new cljs.core.PersistentVector(null,4,(5),inst_74542,inst_74543,null));
var inst_74545 = [inst_74544,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_74546 = (new cljs.core.PersistentVector(null,2,(5),inst_74541,inst_74545,null));
var state_74594__$1 = state_74594;
var statearr_74616_74702 = state_74594__$1;
(statearr_74616_74702[(2)] = inst_74546);

(statearr_74616_74702[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (50))){
var inst_74559 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
var statearr_74617_74703 = state_74594__$1;
(statearr_74617_74703[(2)] = inst_74559);

(statearr_74617_74703[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (21))){
var inst_74407 = (state_74594[(16)]);
var inst_74463 = cljs.core.empty_QMARK_.call(null,inst_74407);
var state_74594__$1 = state_74594;
if(inst_74463){
var statearr_74618_74704 = state_74594__$1;
(statearr_74618_74704[(1)] = (24));

} else {
var statearr_74619_74705 = state_74594__$1;
(statearr_74619_74705[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (31))){
var inst_74507 = (state_74594[(22)]);
var inst_74496 = (state_74594[(9)]);
var inst_74507__$1 = (inst_74496 == null);
var state_74594__$1 = (function (){var statearr_74620 = state_74594;
(statearr_74620[(22)] = inst_74507__$1);

return statearr_74620;
})();
if(cljs.core.truth_(inst_74507__$1)){
var statearr_74621_74706 = state_74594__$1;
(statearr_74621_74706[(1)] = (33));

} else {
var statearr_74622_74707 = state_74594__$1;
(statearr_74622_74707[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (32))){
var inst_74454 = (state_74594[(23)]);
var inst_74444 = (state_74594[(24)]);
var inst_74411 = (state_74594[(21)]);
var inst_74563 = (state_74594[(2)]);
var inst_74564 = cljs.core.nth.call(null,inst_74563,(0),null);
var inst_74565 = cljs.core.nth.call(null,inst_74563,(1),null);
var inst_74566 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_74567 = [inst_74444,inst_74454];
var inst_74568 = cljs.core.PersistentHashMap.fromArrays(inst_74566,inst_74567);
var inst_74569 = fluree.db.query.range.time_range.call(null,inst_74411,inst_74565,cljs.core._EQ_,inst_74564,inst_74568);
var state_74594__$1 = state_74594;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74594__$1,(54),inst_74569);
} else {
if((state_val_74595 === (40))){
var inst_74527 = (state_74594[(25)]);
var inst_74496 = (state_74594[(9)]);
var inst_74527__$1 = (inst_74496 == null);
var state_74594__$1 = (function (){var statearr_74623 = state_74594;
(statearr_74623[(25)] = inst_74527__$1);

return statearr_74623;
})();
if(cljs.core.truth_(inst_74527__$1)){
var statearr_74624_74708 = state_74594__$1;
(statearr_74624_74708[(1)] = (42));

} else {
var statearr_74625_74709 = state_74594__$1;
(statearr_74625_74709[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (56))){
var inst_74576 = (state_74594[(19)]);
var inst_74411 = (state_74594[(21)]);
var inst_74578 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_74411,inst_74576);
var state_74594__$1 = state_74594;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74594__$1,(59),inst_74578);
} else {
if((state_val_74595 === (33))){
var inst_74497 = (state_74594[(11)]);
var inst_74510 = (state_74594[(26)]);
var inst_74509 = (inst_74497 == null);
var inst_74510__$1 = cljs.core.not.call(null,inst_74509);
var state_74594__$1 = (function (){var statearr_74626 = state_74594;
(statearr_74626[(26)] = inst_74510__$1);

return statearr_74626;
})();
if(inst_74510__$1){
var statearr_74627_74710 = state_74594__$1;
(statearr_74627_74710[(1)] = (36));

} else {
var statearr_74628_74711 = state_74594__$1;
(statearr_74628_74711[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (13))){
var inst_74438 = (state_74594[(2)]);
var inst_74439 = fluree.db.util.async.throw_err.call(null,inst_74438);
var inst_74440 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74439);
var inst_74441 = (inst_74440 - (1));
var state_74594__$1 = state_74594;
var statearr_74629_74712 = state_74594__$1;
(statearr_74629_74712[(2)] = inst_74441);

(statearr_74629_74712[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (22))){
var state_74594__$1 = state_74594;
var statearr_74630_74713 = state_74594__$1;
(statearr_74630_74713[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (36))){
var inst_74498 = (state_74594[(10)]);
var inst_74512 = (inst_74498 == null);
var state_74594__$1 = state_74594;
var statearr_74632_74714 = state_74594__$1;
(statearr_74632_74714[(2)] = inst_74512);

(statearr_74632_74714[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (41))){
var inst_74561 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
var statearr_74633_74715 = state_74594__$1;
(statearr_74633_74715[(2)] = inst_74561);

(statearr_74633_74715[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (43))){
var inst_74527 = (state_74594[(25)]);
var state_74594__$1 = state_74594;
var statearr_74634_74716 = state_74594__$1;
(statearr_74634_74716[(2)] = inst_74527);

(statearr_74634_74716[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (61))){
var inst_74584 = (state_74594[(14)]);
var state_74594__$1 = state_74594;
var statearr_74635_74717 = state_74594__$1;
(statearr_74635_74717[(2)] = inst_74584);

(statearr_74635_74717[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (29))){
var inst_74484 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
var statearr_74636_74718 = state_74594__$1;
(statearr_74636_74718[(2)] = inst_74484);

(statearr_74636_74718[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (44))){
var inst_74539 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
if(cljs.core.truth_(inst_74539)){
var statearr_74637_74719 = state_74594__$1;
(statearr_74637_74719[(1)] = (48));

} else {
var statearr_74638_74720 = state_74594__$1;
(statearr_74638_74720[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (6))){
var inst_74415 = (state_74594[(2)]);
var inst_74416 = fluree.db.util.async.throw_err.call(null,inst_74415);
var state_74594__$1 = state_74594;
var statearr_74639_74721 = state_74594__$1;
(statearr_74639_74721[(2)] = inst_74416);

(statearr_74639_74721[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (28))){
var state_74594__$1 = state_74594;
var statearr_74640_74722 = state_74594__$1;
(statearr_74640_74722[(2)] = null);

(statearr_74640_74722[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (51))){
var inst_74407 = (state_74594[(16)]);
var inst_74549 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74407)].join('');
var inst_74550 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74551 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74552 = cljs.core.PersistentHashMap.fromArrays(inst_74550,inst_74551);
var inst_74553 = cljs.core.ex_info.call(null,inst_74549,inst_74552);
var inst_74554 = (function(){throw inst_74553})();
var state_74594__$1 = state_74594;
var statearr_74641_74723 = state_74594__$1;
(statearr_74641_74723[(2)] = inst_74554);

(statearr_74641_74723[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (25))){
var inst_74407 = (state_74594[(16)]);
var state_74594__$1 = state_74594;
var statearr_74642_74724 = state_74594__$1;
(statearr_74642_74724[(2)] = inst_74407);

(statearr_74642_74724[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (34))){
var inst_74507 = (state_74594[(22)]);
var state_74594__$1 = state_74594;
var statearr_74643_74725 = state_74594__$1;
(statearr_74643_74725[(2)] = inst_74507);

(statearr_74643_74725[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (17))){
var inst_74448 = (state_74594[(2)]);
var inst_74449 = fluree.db.util.async.throw_err.call(null,inst_74448);
var inst_74450 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74449);
var state_74594__$1 = state_74594;
var statearr_74644_74726 = state_74594__$1;
(statearr_74644_74726[(2)] = inst_74450);

(statearr_74644_74726[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (3))){
var inst_74411 = (state_74594[(21)]);
var inst_74413 = fluree.db.api_js.resolve_block_range.call(null,inst_74411,query_map);
var state_74594__$1 = state_74594;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74594__$1,(6),inst_74413);
} else {
if((state_val_74595 === (12))){
var inst_74421 = (state_74594[(27)]);
var inst_74444 = (state_74594[(2)]);
var state_74594__$1 = (function (){var statearr_74645 = state_74594;
(statearr_74645[(24)] = inst_74444);

return statearr_74645;
})();
if(cljs.core.truth_(inst_74421)){
var statearr_74646_74727 = state_74594__$1;
(statearr_74646_74727[(1)] = (14));

} else {
var statearr_74647_74728 = state_74594__$1;
(statearr_74647_74728[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (2))){
var inst_74406 = (state_74594[(18)]);
var inst_74410 = (state_74594[(2)]);
var inst_74411 = fluree.db.util.async.throw_err.call(null,inst_74410);
var state_74594__$1 = (function (){var statearr_74648 = state_74594;
(statearr_74648[(21)] = inst_74411);

return statearr_74648;
})();
if(cljs.core.truth_(inst_74406)){
var statearr_74649_74729 = state_74594__$1;
(statearr_74649_74729[(1)] = (3));

} else {
var statearr_74650_74730 = state_74594__$1;
(statearr_74650_74730[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (23))){
var inst_74486 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
var statearr_74651_74731 = state_74594__$1;
(statearr_74651_74731[(2)] = inst_74486);

(statearr_74651_74731[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (47))){
var inst_74536 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
var statearr_74652_74732 = state_74594__$1;
(statearr_74652_74732[(2)] = inst_74536);

(statearr_74652_74732[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (35))){
var inst_74518 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
if(cljs.core.truth_(inst_74518)){
var statearr_74653_74733 = state_74594__$1;
(statearr_74653_74733[(1)] = (39));

} else {
var statearr_74654_74734 = state_74594__$1;
(statearr_74654_74734[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (19))){
var inst_74407 = (state_74594[(16)]);
var inst_74461 = cljs.core.sequential_QMARK_.call(null,inst_74407);
var state_74594__$1 = state_74594;
if(inst_74461){
var statearr_74655_74735 = state_74594__$1;
(statearr_74655_74735[(1)] = (21));

} else {
var statearr_74656_74736 = state_74594__$1;
(statearr_74656_74736[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (57))){
var inst_74576 = (state_74594[(19)]);
var state_74594__$1 = state_74594;
var statearr_74657_74737 = state_74594__$1;
(statearr_74657_74737[(2)] = inst_74576);

(statearr_74657_74737[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (11))){
var state_74594__$1 = state_74594;
var statearr_74658_74738 = state_74594__$1;
(statearr_74658_74738[(2)] = (-1));

(statearr_74658_74738[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (9))){
var inst_74433 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
if(cljs.core.truth_(inst_74433)){
var statearr_74659_74739 = state_74594__$1;
(statearr_74659_74739[(1)] = (10));

} else {
var statearr_74660_74740 = state_74594__$1;
(statearr_74660_74740[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (5))){
var inst_74420 = (state_74594[(7)]);
var inst_74419 = (state_74594[(2)]);
var inst_74420__$1 = cljs.core.nth.call(null,inst_74419,(0),null);
var inst_74421 = cljs.core.nth.call(null,inst_74419,(1),null);
var inst_74428 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_74594__$1 = (function (){var statearr_74661 = state_74594;
(statearr_74661[(7)] = inst_74420__$1);

(statearr_74661[(27)] = inst_74421);

(statearr_74661[(13)] = inst_74428);

return statearr_74661;
})();
if(cljs.core.truth_(inst_74420__$1)){
var statearr_74662_74741 = state_74594__$1;
(statearr_74662_74741[(1)] = (7));

} else {
var statearr_74663_74742 = state_74594__$1;
(statearr_74663_74742[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (14))){
var inst_74421 = (state_74594[(27)]);
var inst_74411 = (state_74594[(21)]);
var inst_74446 = fluree.db.time_travel.as_of_block.call(null,inst_74411,inst_74421);
var state_74594__$1 = state_74594;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74594__$1,(17),inst_74446);
} else {
if((state_val_74595 === (45))){
var inst_74498 = (state_74594[(10)]);
var inst_74532 = (inst_74498 == null);
var inst_74533 = cljs.core.not.call(null,inst_74532);
var state_74594__$1 = state_74594;
var statearr_74664_74743 = state_74594__$1;
(statearr_74664_74743[(2)] = inst_74533);

(statearr_74664_74743[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (53))){
var inst_74557 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
var statearr_74665_74744 = state_74594__$1;
(statearr_74665_74744[(2)] = inst_74557);

(statearr_74665_74744[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (26))){
var inst_74473 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
var statearr_74666_74745 = state_74594__$1;
(statearr_74666_74745[(2)] = inst_74473);

(statearr_74666_74745[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (16))){
var inst_74407 = (state_74594[(16)]);
var inst_74454 = (state_74594[(2)]);
var inst_74455 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_74407);
var state_74594__$1 = (function (){var statearr_74667 = state_74594;
(statearr_74667[(23)] = inst_74454);

return statearr_74667;
})();
if(inst_74455){
var statearr_74668_74746 = state_74594__$1;
(statearr_74668_74746[(1)] = (18));

} else {
var statearr_74669_74747 = state_74594__$1;
(statearr_74669_74747[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (38))){
var inst_74515 = (state_74594[(2)]);
var state_74594__$1 = state_74594;
var statearr_74670_74748 = state_74594__$1;
(statearr_74670_74748[(2)] = inst_74515);

(statearr_74670_74748[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (30))){
var inst_74488 = (state_74594[(8)]);
var inst_74503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74504 = [inst_74488,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_74505 = (new cljs.core.PersistentVector(null,2,(5),inst_74503,inst_74504,null));
var state_74594__$1 = state_74594;
var statearr_74671_74749 = state_74594__$1;
(statearr_74671_74749[(2)] = inst_74505);

(statearr_74671_74749[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (10))){
var inst_74420 = (state_74594[(7)]);
var inst_74411 = (state_74594[(21)]);
var inst_74435 = (inst_74420 - (1));
var inst_74436 = fluree.db.time_travel.as_of_block.call(null,inst_74411,inst_74435);
var state_74594__$1 = state_74594;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74594__$1,(13),inst_74436);
} else {
if((state_val_74595 === (18))){
var inst_74407 = (state_74594[(16)]);
var inst_74457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74458 = [inst_74407];
var inst_74459 = (new cljs.core.PersistentVector(null,1,(5),inst_74457,inst_74458,null));
var state_74594__$1 = state_74594;
var statearr_74672_74750 = state_74594__$1;
(statearr_74672_74750[(2)] = inst_74459);

(statearr_74672_74750[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (52))){
var state_74594__$1 = state_74594;
var statearr_74673_74751 = state_74594__$1;
(statearr_74673_74751[(2)] = null);

(statearr_74673_74751[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (42))){
var inst_74497 = (state_74594[(11)]);
var inst_74530 = (state_74594[(20)]);
var inst_74529 = (inst_74497 == null);
var inst_74530__$1 = cljs.core.not.call(null,inst_74529);
var state_74594__$1 = (function (){var statearr_74674 = state_74594;
(statearr_74674[(20)] = inst_74530__$1);

return statearr_74674;
})();
if(inst_74530__$1){
var statearr_74675_74752 = state_74594__$1;
(statearr_74675_74752[(1)] = (45));

} else {
var statearr_74676_74753 = state_74594__$1;
(statearr_74676_74753[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (37))){
var inst_74510 = (state_74594[(26)]);
var state_74594__$1 = state_74594;
var statearr_74677_74754 = state_74594__$1;
(statearr_74677_74754[(2)] = inst_74510);

(statearr_74677_74754[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (8))){
var inst_74420 = (state_74594[(7)]);
var state_74594__$1 = state_74594;
var statearr_74678_74755 = state_74594__$1;
(statearr_74678_74755[(2)] = inst_74420);

(statearr_74678_74755[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74595 === (49))){
var state_74594__$1 = state_74594;
var statearr_74679_74756 = state_74594__$1;
(statearr_74679_74756[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_74681 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74681[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_74681[(1)] = (1));

return statearr_74681;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_74594){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_74594);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74682){var ex__2687__auto__ = e74682;
var statearr_74683_74757 = state_74594;
(statearr_74683_74757[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_74594[(4)]))){
var statearr_74684_74758 = state_74594;
(statearr_74684_74758[(1)] = cljs.core.first.call(null,(state_74594[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74759 = state_74594;
state_74594 = G__74759;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_74594){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_74594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74685 = f__2707__auto__.call(null);
(statearr_74685[(6)] = c__2706__auto__);

return statearr_74685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__74767 = arguments.length;
switch (G__74767) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__74760_SHARP_){
return cljs.core.dissoc.call(null,p1__74760_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74856){
var state_val_74857 = (state_74856[(1)]);
if((state_val_74857 === (7))){
var inst_74807 = (state_74856[(7)]);
var inst_74817 = (state_74856[(8)]);
var inst_74810 = (state_74856[(9)]);
var inst_74813 = (state_74856[(10)]);
var inst_74823 = (function (){var responses = inst_74807;
var responses_STAR_ = inst_74810;
var statuses = inst_74813;
var fuel = inst_74817;
return (function (p1__74763_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__74763_SHARP_);
});
})();
var inst_74824 = cljs.core.some.call(null,inst_74823,inst_74813);
var state_74856__$1 = state_74856;
if(cljs.core.truth_(inst_74824)){
var statearr_74858_74906 = state_74856__$1;
(statearr_74858_74906[(1)] = (9));

} else {
var statearr_74859_74907 = state_74856__$1;
(statearr_74859_74907[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (20))){
var inst_74851 = (state_74856[(2)]);
var state_74856__$1 = state_74856;
var statearr_74860_74908 = state_74856__$1;
(statearr_74860_74908[(2)] = inst_74851);

(statearr_74860_74908[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (1))){
var inst_74802 = cljs.core.async.chan.call(null,(1));
var inst_74803 = (function (){var c__2706__auto____$1 = inst_74802;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74800){
var state_val_74801 = (state_74800[(1)]);
if((state_val_74801 === (1))){
var inst_74768 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_74769 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_74770 = cljs.core.assoc.call(null,inst_74769,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_74771 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_74772 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_74773 = cljs.core.PersistentHashMap.EMPTY;
var inst_74774 = inst_74768;
var inst_74775 = inst_74770;
var inst_74776 = inst_74771;
var inst_74777 = inst_74772;
var inst_74778 = inst_74773;
var state_74800__$1 = (function (){var statearr_74861 = state_74800;
(statearr_74861[(7)] = inst_74775);

(statearr_74861[(8)] = inst_74778);

(statearr_74861[(9)] = inst_74776);

(statearr_74861[(10)] = inst_74777);

(statearr_74861[(11)] = inst_74774);

return statearr_74861;
})();
var statearr_74862_74909 = state_74800__$1;
(statearr_74862_74909[(2)] = null);

(statearr_74862_74909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74801 === (2))){
var inst_74775 = (state_74800[(7)]);
var inst_74780 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_74775);
var inst_74781 = cljs.core.merge.call(null,opts,inst_74780);
var inst_74782 = cljs.core.assoc.call(null,inst_74775,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74781);
var inst_74783 = fluree.db.api_js.query_async.call(null,db,inst_74782,db_fn);
var state_74800__$1 = state_74800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74800__$1,(4),inst_74783);
} else {
if((state_val_74801 === (3))){
var inst_74798 = (state_74800[(2)]);
var state_74800__$1 = state_74800;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74800__$1,inst_74798);
} else {
if((state_val_74801 === (4))){
var inst_74778 = (state_74800[(8)]);
var inst_74776 = (state_74800[(9)]);
var inst_74774 = (state_74800[(11)]);
var inst_74785 = (state_74800[(2)]);
var inst_74786 = cljs.core.assoc.call(null,inst_74778,inst_74774,inst_74785);
var inst_74787 = cljs.core.first.call(null,inst_74776);
var state_74800__$1 = (function (){var statearr_74863 = state_74800;
(statearr_74863[(12)] = inst_74786);

return statearr_74863;
})();
if(cljs.core.truth_(inst_74787)){
var statearr_74864_74910 = state_74800__$1;
(statearr_74864_74910[(1)] = (5));

} else {
var statearr_74865_74911 = state_74800__$1;
(statearr_74865_74911[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74801 === (5))){
var inst_74776 = (state_74800[(9)]);
var inst_74786 = (state_74800[(12)]);
var inst_74777 = (state_74800[(10)]);
var inst_74789 = cljs.core.first.call(null,inst_74776);
var inst_74790 = cljs.core.first.call(null,inst_74777);
var inst_74791 = cljs.core.rest.call(null,inst_74776);
var inst_74792 = cljs.core.rest.call(null,inst_74777);
var inst_74774 = inst_74789;
var inst_74775 = inst_74790;
var inst_74776__$1 = inst_74791;
var inst_74777__$1 = inst_74792;
var inst_74778 = inst_74786;
var state_74800__$1 = (function (){var statearr_74866 = state_74800;
(statearr_74866[(7)] = inst_74775);

(statearr_74866[(8)] = inst_74778);

(statearr_74866[(9)] = inst_74776__$1);

(statearr_74866[(10)] = inst_74777__$1);

(statearr_74866[(11)] = inst_74774);

return statearr_74866;
})();
var statearr_74867_74912 = state_74800__$1;
(statearr_74867_74912[(2)] = null);

(statearr_74867_74912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74801 === (6))){
var inst_74786 = (state_74800[(12)]);
var state_74800__$1 = state_74800;
var statearr_74868_74913 = state_74800__$1;
(statearr_74868_74913[(2)] = inst_74786);

(statearr_74868_74913[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74801 === (7))){
var inst_74796 = (state_74800[(2)]);
var state_74800__$1 = state_74800;
var statearr_74869_74914 = state_74800__$1;
(statearr_74869_74914[(2)] = inst_74796);

(statearr_74869_74914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_74870 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74870[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_74870[(1)] = (1));

return statearr_74870;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_74800){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_74800);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74871){var ex__2687__auto__ = e74871;
var statearr_74872_74915 = state_74800;
(statearr_74872_74915[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_74800[(4)]))){
var statearr_74873_74916 = state_74800;
(statearr_74873_74916[(1)] = cljs.core.first.call(null,(state_74800[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74917 = state_74800;
state_74800 = G__74917;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_74800){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_74800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74874 = f__2707__auto__.call(null);
(statearr_74874[(6)] = c__2706__auto____$1);

return statearr_74874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
});
})();
var inst_74804 = cljs.core.async.impl.dispatch.run.call(null,inst_74803);
var state_74856__$1 = (function (){var statearr_74875 = state_74856;
(statearr_74875[(11)] = inst_74804);

return statearr_74875;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74856__$1,(2),inst_74802);
} else {
if((state_val_74857 === (4))){
var inst_74807 = (state_74856[(7)]);
var state_74856__$1 = state_74856;
var statearr_74876_74918 = state_74856__$1;
(statearr_74876_74918[(2)] = inst_74807);

(statearr_74876_74918[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (15))){
var state_74856__$1 = state_74856;
var statearr_74877_74919 = state_74856__$1;
(statearr_74877_74919[(2)] = (400));

(statearr_74877_74919[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (13))){
var state_74856__$1 = state_74856;
var statearr_74878_74920 = state_74856__$1;
(statearr_74878_74920[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (6))){
var inst_74813 = (state_74856[(10)]);
var inst_74821 = cljs.core.first.call(null,inst_74813);
var state_74856__$1 = state_74856;
var statearr_74880_74921 = state_74856__$1;
(statearr_74880_74921[(2)] = inst_74821);

(statearr_74880_74921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (17))){
var inst_74834 = (state_74856[(2)]);
var state_74856__$1 = state_74856;
var statearr_74881_74922 = state_74856__$1;
(statearr_74881_74922[(2)] = inst_74834);

(statearr_74881_74922[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (3))){
var inst_74807 = (state_74856[(7)]);
var inst_74817 = (state_74856[(8)]);
var inst_74810 = (state_74856[(9)]);
var inst_74813 = (state_74856[(10)]);
var inst_74812 = cljs.core.vals.call(null,inst_74807);
var inst_74813__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74812);
var inst_74814 = (function (){var responses = inst_74807;
var responses_STAR_ = inst_74810;
var statuses = inst_74813__$1;
return (function (p1__74761_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__74761_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_74815 = cljs.core.vals.call(null,inst_74807);
var inst_74816 = cljs.core.map.call(null,inst_74814,inst_74815);
var inst_74817__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_74816);
var inst_74818 = (function (){var responses = inst_74807;
var responses_STAR_ = inst_74810;
var statuses = inst_74813__$1;
var fuel = inst_74817__$1;
return (function (p1__74762_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__74762_SHARP_);
});
})();
var inst_74819 = cljs.core.every_QMARK_.call(null,inst_74818,inst_74813__$1);
var state_74856__$1 = (function (){var statearr_74882 = state_74856;
(statearr_74882[(8)] = inst_74817__$1);

(statearr_74882[(10)] = inst_74813__$1);

return statearr_74882;
})();
if(inst_74819){
var statearr_74883_74923 = state_74856__$1;
(statearr_74883_74923[(1)] = (6));

} else {
var statearr_74884_74924 = state_74856__$1;
(statearr_74884_74924[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (12))){
var state_74856__$1 = state_74856;
var statearr_74885_74925 = state_74856__$1;
(statearr_74885_74925[(2)] = (500));

(statearr_74885_74925[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (2))){
var inst_74807 = (state_74856[(7)]);
var inst_74806 = (state_74856[(2)]);
var inst_74807__$1 = fluree.db.util.async.throw_err.call(null,inst_74806);
var inst_74808 = (function (){var responses = inst_74807__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_74809 = cljs.core.PersistentHashMap.EMPTY;
var inst_74810 = cljs.core.reduce_kv.call(null,inst_74808,inst_74809,inst_74807__$1);
var state_74856__$1 = (function (){var statearr_74886 = state_74856;
(statearr_74886[(7)] = inst_74807__$1);

(statearr_74886[(9)] = inst_74810);

return statearr_74886;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_74887_74926 = state_74856__$1;
(statearr_74887_74926[(1)] = (3));

} else {
var statearr_74888_74927 = state_74856__$1;
(statearr_74888_74927[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (19))){
var inst_74817 = (state_74856[(8)]);
var inst_74810 = (state_74856[(9)]);
var inst_74840 = (state_74856[(12)]);
var inst_74849 = cljs.core.assoc.call(null,inst_74810,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74840,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74817);
var state_74856__$1 = state_74856;
var statearr_74889_74928 = state_74856__$1;
(statearr_74889_74928[(2)] = inst_74849);

(statearr_74889_74928[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (11))){
var inst_74838 = (state_74856[(2)]);
var state_74856__$1 = state_74856;
var statearr_74890_74929 = state_74856__$1;
(statearr_74890_74929[(2)] = inst_74838);

(statearr_74890_74929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (9))){
var state_74856__$1 = state_74856;
var statearr_74891_74930 = state_74856__$1;
(statearr_74891_74930[(2)] = (207));

(statearr_74891_74930[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (5))){
var inst_74854 = (state_74856[(2)]);
var state_74856__$1 = state_74856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74856__$1,inst_74854);
} else {
if((state_val_74857 === (14))){
var inst_74836 = (state_74856[(2)]);
var state_74856__$1 = state_74856;
var statearr_74892_74931 = state_74856__$1;
(statearr_74892_74931[(2)] = inst_74836);

(statearr_74892_74931[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (16))){
var state_74856__$1 = state_74856;
var statearr_74893_74932 = state_74856__$1;
(statearr_74893_74932[(2)] = null);

(statearr_74893_74932[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (10))){
var inst_74807 = (state_74856[(7)]);
var inst_74817 = (state_74856[(8)]);
var inst_74810 = (state_74856[(9)]);
var inst_74813 = (state_74856[(10)]);
var inst_74827 = (function (){var responses = inst_74807;
var responses_STAR_ = inst_74810;
var statuses = inst_74813;
var fuel = inst_74817;
return (function (p1__74764_SHARP_){
return ((499) < p1__74764_SHARP_);
});
})();
var inst_74828 = cljs.core.some.call(null,inst_74827,inst_74813);
var state_74856__$1 = state_74856;
if(cljs.core.truth_(inst_74828)){
var statearr_74894_74933 = state_74856__$1;
(statearr_74894_74933[(1)] = (12));

} else {
var statearr_74895_74934 = state_74856__$1;
(statearr_74895_74934[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (18))){
var inst_74817 = (state_74856[(8)]);
var inst_74810 = (state_74856[(9)]);
var inst_74845 = (state_74856[(13)]);
var inst_74840 = (state_74856[(12)]);
var inst_74847 = cljs.core.assoc.call(null,inst_74810,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74840,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74817,new cljs.core.Keyword(null,"block","block",664686210),inst_74845);
var state_74856__$1 = state_74856;
var statearr_74896_74935 = state_74856__$1;
(statearr_74896_74935[(2)] = inst_74847);

(statearr_74896_74935[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74857 === (8))){
var inst_74807 = (state_74856[(7)]);
var inst_74817 = (state_74856[(8)]);
var inst_74810 = (state_74856[(9)]);
var inst_74845 = (state_74856[(13)]);
var inst_74840 = (state_74856[(12)]);
var inst_74813 = (state_74856[(10)]);
var inst_74840__$1 = (state_74856[(2)]);
var inst_74841 = (function (){var responses = inst_74807;
var responses_STAR_ = inst_74810;
var statuses = inst_74813;
var fuel = inst_74817;
var status = inst_74840__$1;
return (function (p1__74765_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__74765_SHARP_));
});
})();
var inst_74842 = cljs.core.vals.call(null,inst_74807);
var inst_74843 = cljs.core.filter.call(null,inst_74841,inst_74842);
var inst_74844 = cljs.core.first.call(null,inst_74843);
var inst_74845__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74844);
var state_74856__$1 = (function (){var statearr_74897 = state_74856;
(statearr_74897[(13)] = inst_74845__$1);

(statearr_74897[(12)] = inst_74840__$1);

return statearr_74897;
})();
if(cljs.core.truth_(inst_74845__$1)){
var statearr_74898_74936 = state_74856__$1;
(statearr_74898_74936[(1)] = (18));

} else {
var statearr_74899_74937 = state_74856__$1;
(statearr_74899_74937[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_74900 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74900[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_74900[(1)] = (1));

return statearr_74900;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_74856){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_74856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e74901){var ex__2687__auto__ = e74901;
var statearr_74902_74938 = state_74856;
(statearr_74902_74938[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_74856[(4)]))){
var statearr_74903_74939 = state_74856;
(statearr_74903_74939[(1)] = cljs.core.first.call(null,(state_74856[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74940 = state_74856;
state_74856 = G__74940;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_74856){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_74856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_74904 = f__2707__auto__.call(null);
(statearr_74904[(6)] = c__2706__auto__);

return statearr_74904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__74942 = arguments.length;
switch (G__74942) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__74943 = opts;
var map__74943__$1 = cljs.core.__destructure_map.call(null,map__74943);
var auth = cljs.core.get.call(null,map__74943__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__74943__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__74943__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__74943__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__74944 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__74944,(0),null);
var authority = cljs.core.nth.call(null,vec__74944,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e74947){var e = e74947;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__74950 = arguments.length;
switch (G__74950) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_74984){
var state_val_74985 = (state_74984[(1)]);
if((state_val_74985 === (7))){
var state_74984__$1 = state_74984;
var statearr_74986_75007 = state_74984__$1;
(statearr_74986_75007[(2)] = opts);

(statearr_74986_75007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74985 === (1))){
var state_74984__$1 = state_74984;
var statearr_74987_75008 = state_74984__$1;
(statearr_74987_75008[(2)] = null);

(statearr_74987_75008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74985 === (4))){
var inst_74951 = (state_74984[(2)]);
var inst_74952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74953 = [inst_74951];
var inst_74954 = (new cljs.core.PersistentVector(null,1,(5),inst_74952,inst_74953,null));
var inst_74955 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74954);
var inst_74956 = cljs.core.ex_data.call(null,inst_74951);
var inst_74957 = cljs.core.ex_message.call(null,inst_74951);
var inst_74958 = cljs.core.assoc.call(null,inst_74956,new cljs.core.Keyword(null,"message","message",-406056002),inst_74957);
var state_74984__$1 = (function (){var statearr_74988 = state_74984;
(statearr_74988[(7)] = inst_74955);

return statearr_74988;
})();
var statearr_74989_75009 = state_74984__$1;
(statearr_74989_75009[(2)] = inst_74958);

(statearr_74989_75009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74985 === (6))){
var inst_74968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74969 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_74970 = (new cljs.core.PersistentVector(null,1,(5),inst_74968,inst_74969,null));
var inst_74971 = cljs.core.assoc_in.call(null,opts,inst_74970,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_74984__$1 = state_74984;
var statearr_74990_75010 = state_74984__$1;
(statearr_74990_75010[(2)] = inst_74971);

(statearr_74990_75010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74985 === (3))){
var inst_74982 = (state_74984[(2)]);
var state_74984__$1 = state_74984;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74984__$1,inst_74982);
} else {
if((state_val_74985 === (2))){
var _ = (function (){var statearr_74992 = state_74984;
(statearr_74992[(4)] = cljs.core.cons.call(null,(5),(state_74984[(4)])));

return statearr_74992;
})();
var inst_74964 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74965 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74966 = (inst_74965 == null);
var state_74984__$1 = (function (){var statearr_74993 = state_74984;
(statearr_74993[(8)] = inst_74964);

return statearr_74993;
})();
if(cljs.core.truth_(inst_74966)){
var statearr_74994_75011 = state_74984__$1;
(statearr_74994_75011[(1)] = (6));

} else {
var statearr_74995_75012 = state_74984__$1;
(statearr_74995_75012[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74985 === (9))){
var inst_74978 = (state_74984[(2)]);
var inst_74979 = fluree.db.util.async.throw_err.call(null,inst_74978);
var _ = (function (){var statearr_74996 = state_74984;
(statearr_74996[(4)] = cljs.core.rest.call(null,(state_74984[(4)])));

return statearr_74996;
})();
var state_74984__$1 = state_74984;
var statearr_74997_75013 = state_74984__$1;
(statearr_74997_75013[(2)] = inst_74979);

(statearr_74997_75013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74985 === (5))){
var _ = (function (){var statearr_74998 = state_74984;
(statearr_74998[(4)] = cljs.core.rest.call(null,(state_74984[(4)])));

return statearr_74998;
})();
var state_74984__$1 = state_74984;
var ex74991 = (state_74984__$1[(2)]);
var statearr_74999_75014 = state_74984__$1;
(statearr_74999_75014[(5)] = ex74991);


var statearr_75000_75015 = state_74984__$1;
(statearr_75000_75015[(1)] = (4));

(statearr_75000_75015[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74985 === (8))){
var inst_74964 = (state_74984[(8)]);
var inst_74974 = (state_74984[(2)]);
var inst_74975 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_74964,inst_74974);
var inst_74976 = fluree.db.operations.command_async.call(null,conn,inst_74975);
var state_74984__$1 = state_74984;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74984__$1,(9),inst_74976);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_75001 = [null,null,null,null,null,null,null,null,null];
(statearr_75001[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_75001[(1)] = (1));

return statearr_75001;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_74984){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_74984);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e75002){var ex__2687__auto__ = e75002;
var statearr_75003_75016 = state_74984;
(statearr_75003_75016[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_74984[(4)]))){
var statearr_75004_75017 = state_74984;
(statearr_75004_75017[(1)] = cljs.core.first.call(null,(state_74984[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75018 = state_74984;
state_74984 = G__75018;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_74984){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_74984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_75005 = f__2707__auto__.call(null);
(statearr_75005[(6)] = c__2706__auto__);

return statearr_75005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

