// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__71303_71484 = cljs.core.seq.call(null,servers);
var chunk__71304_71485 = null;
var count__71305_71486 = (0);
var i__71306_71487 = (0);
while(true){
if((i__71306_71487 < count__71305_71486)){
var server_71488 = cljs.core._nth.call(null,chunk__71304_71485,i__71306_71487);
var healthcheck_uri_71489 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71488),"/fdb/health"].join('');
var resp_chan_71490 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_71489,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___71491 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,c__2706__auto___71491,healthcheck_uri_71489,resp_chan_71490,server_71488){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,c__2706__auto___71491,healthcheck_uri_71489,resp_chan_71490,server_71488){
return (function (state_71376){
var state_val_71377 = (state_71376[(1)]);
if((state_val_71377 === (1))){
var state_71376__$1 = state_71376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71376__$1,(2),resp_chan_71490);
} else {
if((state_val_71377 === (2))){
var inst_71362 = (state_71376[(7)]);
var inst_71362__$1 = (state_71376[(2)]);
var inst_71363 = fluree.db.util.core.exception_QMARK_.call(null,inst_71362__$1);
var state_71376__$1 = (function (){var statearr_71378 = state_71376;
(statearr_71378[(7)] = inst_71362__$1);

return statearr_71378;
})();
if(inst_71363){
var statearr_71379_71492 = state_71376__$1;
(statearr_71379_71492[(1)] = (3));

} else {
var statearr_71380_71493 = state_71376__$1;
(statearr_71380_71493[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71377 === (3))){
var inst_71362 = (state_71376[(7)]);
var inst_71365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71366 = cljs.core.ex_message.call(null,inst_71362);
var inst_71367 = cljs.core.ex_data.call(null,inst_71362);
var inst_71368 = ["Server contact error: ",inst_71366,inst_71367];
var inst_71369 = (new cljs.core.PersistentVector(null,3,(5),inst_71365,inst_71368,null));
var inst_71370 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71369);
var state_71376__$1 = state_71376;
var statearr_71381_71494 = state_71376__$1;
(statearr_71381_71494[(2)] = inst_71370);

(statearr_71381_71494[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71377 === (4))){
var inst_71372 = cljs.core.async.put_BANG_.call(null,promise_chan,server_71488);
var state_71376__$1 = state_71376;
var statearr_71382_71495 = state_71376__$1;
(statearr_71382_71495[(2)] = inst_71372);

(statearr_71382_71495[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71377 === (5))){
var inst_71374 = (state_71376[(2)]);
var state_71376__$1 = state_71376;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71376__$1,inst_71374);
} else {
return null;
}
}
}
}
}
});})(seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,c__2706__auto___71491,healthcheck_uri_71489,resp_chan_71490,server_71488))
;
return ((function (seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,switch__2683__auto__,c__2706__auto___71491,healthcheck_uri_71489,resp_chan_71490,server_71488){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_71383 = [null,null,null,null,null,null,null,null];
(statearr_71383[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_71383[(1)] = (1));

return statearr_71383;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_71376){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_71376);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71384){var ex__2687__auto__ = e71384;
var statearr_71385_71496 = state_71376;
(statearr_71385_71496[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_71376[(4)]))){
var statearr_71386_71497 = state_71376;
(statearr_71386_71497[(1)] = cljs.core.first.call(null,(state_71376[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71498 = state_71376;
state_71376 = G__71498;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_71376){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_71376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,switch__2683__auto__,c__2706__auto___71491,healthcheck_uri_71489,resp_chan_71490,server_71488))
})();
var state__2708__auto__ = (function (){var statearr_71387 = f__2707__auto__.call(null);
(statearr_71387[(6)] = c__2706__auto___71491);

return statearr_71387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
});})(seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,c__2706__auto___71491,healthcheck_uri_71489,resp_chan_71490,server_71488))
);



var G__71499 = seq__71303_71484;
var G__71500 = chunk__71304_71485;
var G__71501 = count__71305_71486;
var G__71502 = (i__71306_71487 + (1));
seq__71303_71484 = G__71499;
chunk__71304_71485 = G__71500;
count__71305_71486 = G__71501;
i__71306_71487 = G__71502;
continue;
} else {
var temp__5804__auto___71503 = cljs.core.seq.call(null,seq__71303_71484);
if(temp__5804__auto___71503){
var seq__71303_71504__$1 = temp__5804__auto___71503;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71303_71504__$1)){
var c__5568__auto___71505 = cljs.core.chunk_first.call(null,seq__71303_71504__$1);
var G__71506 = cljs.core.chunk_rest.call(null,seq__71303_71504__$1);
var G__71507 = c__5568__auto___71505;
var G__71508 = cljs.core.count.call(null,c__5568__auto___71505);
var G__71509 = (0);
seq__71303_71484 = G__71506;
chunk__71304_71485 = G__71507;
count__71305_71486 = G__71508;
i__71306_71487 = G__71509;
continue;
} else {
var server_71510 = cljs.core.first.call(null,seq__71303_71504__$1);
var healthcheck_uri_71511 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71510),"/fdb/health"].join('');
var resp_chan_71512 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_71511,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___71513 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,c__2706__auto___71513,healthcheck_uri_71511,resp_chan_71512,server_71510,seq__71303_71504__$1,temp__5804__auto___71503){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,c__2706__auto___71513,healthcheck_uri_71511,resp_chan_71512,server_71510,seq__71303_71504__$1,temp__5804__auto___71503){
return (function (state_71403){
var state_val_71404 = (state_71403[(1)]);
if((state_val_71404 === (1))){
var state_71403__$1 = state_71403;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71403__$1,(2),resp_chan_71512);
} else {
if((state_val_71404 === (2))){
var inst_71389 = (state_71403[(7)]);
var inst_71389__$1 = (state_71403[(2)]);
var inst_71390 = fluree.db.util.core.exception_QMARK_.call(null,inst_71389__$1);
var state_71403__$1 = (function (){var statearr_71405 = state_71403;
(statearr_71405[(7)] = inst_71389__$1);

return statearr_71405;
})();
if(inst_71390){
var statearr_71406_71514 = state_71403__$1;
(statearr_71406_71514[(1)] = (3));

} else {
var statearr_71407_71515 = state_71403__$1;
(statearr_71407_71515[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71404 === (3))){
var inst_71389 = (state_71403[(7)]);
var inst_71392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71393 = cljs.core.ex_message.call(null,inst_71389);
var inst_71394 = cljs.core.ex_data.call(null,inst_71389);
var inst_71395 = ["Server contact error: ",inst_71393,inst_71394];
var inst_71396 = (new cljs.core.PersistentVector(null,3,(5),inst_71392,inst_71395,null));
var inst_71397 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71396);
var state_71403__$1 = state_71403;
var statearr_71408_71516 = state_71403__$1;
(statearr_71408_71516[(2)] = inst_71397);

(statearr_71408_71516[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71404 === (4))){
var inst_71399 = cljs.core.async.put_BANG_.call(null,promise_chan,server_71510);
var state_71403__$1 = state_71403;
var statearr_71409_71517 = state_71403__$1;
(statearr_71409_71517[(2)] = inst_71399);

(statearr_71409_71517[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71404 === (5))){
var inst_71401 = (state_71403[(2)]);
var state_71403__$1 = state_71403;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71403__$1,inst_71401);
} else {
return null;
}
}
}
}
}
});})(seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,c__2706__auto___71513,healthcheck_uri_71511,resp_chan_71512,server_71510,seq__71303_71504__$1,temp__5804__auto___71503))
;
return ((function (seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,switch__2683__auto__,c__2706__auto___71513,healthcheck_uri_71511,resp_chan_71512,server_71510,seq__71303_71504__$1,temp__5804__auto___71503){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_71410 = [null,null,null,null,null,null,null,null];
(statearr_71410[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_71410[(1)] = (1));

return statearr_71410;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_71403){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_71403);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71411){var ex__2687__auto__ = e71411;
var statearr_71412_71518 = state_71403;
(statearr_71412_71518[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_71403[(4)]))){
var statearr_71413_71519 = state_71403;
(statearr_71413_71519[(1)] = cljs.core.first.call(null,(state_71403[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71520 = state_71403;
state_71403 = G__71520;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_71403){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_71403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,switch__2683__auto__,c__2706__auto___71513,healthcheck_uri_71511,resp_chan_71512,server_71510,seq__71303_71504__$1,temp__5804__auto___71503))
})();
var state__2708__auto__ = (function (){var statearr_71414 = f__2707__auto__.call(null);
(statearr_71414[(6)] = c__2706__auto___71513);

return statearr_71414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
});})(seq__71303_71484,chunk__71304_71485,count__71305_71486,i__71306_71487,c__2706__auto___71513,healthcheck_uri_71511,resp_chan_71512,server_71510,seq__71303_71504__$1,temp__5804__auto___71503))
);



var G__71521 = cljs.core.next.call(null,seq__71303_71504__$1);
var G__71522 = null;
var G__71523 = (0);
var G__71524 = (0);
seq__71303_71484 = G__71521;
chunk__71304_71485 = G__71522;
count__71305_71486 = G__71523;
i__71306_71487 = G__71524;
continue;
}
} else {
}
}
break;
}

var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71458){
var state_val_71459 = (state_71458[(1)]);
if((state_val_71459 === (7))){
var inst_71430 = (state_71458[(7)]);
var inst_71437 = cljs.core._EQ_.call(null,inst_71430,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_71458__$1 = state_71458;
if(inst_71437){
var statearr_71460_71525 = state_71458__$1;
(statearr_71460_71525[(1)] = (9));

} else {
var statearr_71461_71526 = state_71458__$1;
(statearr_71461_71526[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (1))){
var inst_71423 = (state_71458[(8)]);
var inst_71422 = (state_71458[(9)]);
var inst_71422__$1 = promise_chan;
var inst_71423__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_71424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71425 = [inst_71422__$1,inst_71423__$1];
var inst_71426 = (new cljs.core.PersistentVector(null,2,(5),inst_71424,inst_71425,null));
var state_71458__$1 = (function (){var statearr_71462 = state_71458;
(statearr_71462[(8)] = inst_71423__$1);

(statearr_71462[(9)] = inst_71422__$1);

return statearr_71462;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71458__$1,(2),inst_71426);
} else {
if((state_val_71459 === (4))){
var inst_71423 = (state_71458[(8)]);
var inst_71430 = (state_71458[(7)]);
var inst_71434 = cljs.core._EQ_.call(null,inst_71430,inst_71423);
var state_71458__$1 = state_71458;
if(inst_71434){
var statearr_71463_71527 = state_71458__$1;
(statearr_71463_71527[(1)] = (6));

} else {
var statearr_71464_71528 = state_71458__$1;
(statearr_71464_71528[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (13))){
var state_71458__$1 = state_71458;
var statearr_71465_71529 = state_71458__$1;
(statearr_71465_71529[(2)] = null);

(statearr_71465_71529[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (6))){
var state_71458__$1 = state_71458;
var statearr_71466_71530 = state_71458__$1;
(statearr_71466_71530[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_71466_71530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (3))){
var state_71458__$1 = state_71458;
var statearr_71467_71531 = state_71458__$1;
(statearr_71467_71531[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_71467_71531[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (12))){
var inst_71448 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_71449 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71450 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_71451 = cljs.core.PersistentHashMap.fromArrays(inst_71449,inst_71450);
var inst_71452 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_71451);
var inst_71453 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_71452);
var state_71458__$1 = (function (){var statearr_71468 = state_71458;
(statearr_71468[(10)] = inst_71448);

return statearr_71468;
})();
var statearr_71469_71532 = state_71458__$1;
(statearr_71469_71532[(2)] = inst_71453);

(statearr_71469_71532[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (2))){
var inst_71430 = (state_71458[(7)]);
var inst_71422 = (state_71458[(9)]);
var inst_71428 = (state_71458[(2)]);
var inst_71429 = cljs.core.nth.call(null,inst_71428,(0),null);
var inst_71430__$1 = cljs.core.nth.call(null,inst_71428,(1),null);
var inst_71431 = cljs.core._EQ_.call(null,inst_71430__$1,inst_71422);
var state_71458__$1 = (function (){var statearr_71470 = state_71458;
(statearr_71470[(7)] = inst_71430__$1);

(statearr_71470[(11)] = inst_71429);

return statearr_71470;
})();
if(inst_71431){
var statearr_71471_71533 = state_71458__$1;
(statearr_71471_71533[(1)] = (3));

} else {
var statearr_71472_71534 = state_71458__$1;
(statearr_71472_71534[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (11))){
var inst_71441 = (state_71458[(2)]);
var state_71458__$1 = state_71458;
var statearr_71473_71535 = state_71458__$1;
(statearr_71473_71535[(2)] = inst_71441);

(statearr_71473_71535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (9))){
var inst_71429 = (state_71458[(11)]);
var state_71458__$1 = state_71458;
var statearr_71474_71536 = state_71458__$1;
(statearr_71474_71536[(2)] = inst_71429);

(statearr_71474_71536[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (5))){
var inst_71445 = (state_71458[(2)]);
var inst_71446 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_71445);
var state_71458__$1 = state_71458;
if(inst_71446){
var statearr_71475_71537 = state_71458__$1;
(statearr_71475_71537[(1)] = (12));

} else {
var statearr_71476_71538 = state_71458__$1;
(statearr_71476_71538[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (14))){
var inst_71456 = (state_71458[(2)]);
var state_71458__$1 = state_71458;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71458__$1,inst_71456);
} else {
if((state_val_71459 === (10))){
var state_71458__$1 = state_71458;
var statearr_71477_71539 = state_71458__$1;
(statearr_71477_71539[(2)] = null);

(statearr_71477_71539[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71459 === (8))){
var inst_71443 = (state_71458[(2)]);
var state_71458__$1 = state_71458;
var statearr_71478_71540 = state_71458__$1;
(statearr_71478_71540[(2)] = inst_71443);

(statearr_71478_71540[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_71479 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71479[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_71479[(1)] = (1));

return statearr_71479;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_71458){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_71458);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71480){var ex__2687__auto__ = e71480;
var statearr_71481_71541 = state_71458;
(statearr_71481_71541[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_71458[(4)]))){
var statearr_71482_71542 = state_71458;
(statearr_71482_71542[(1)] = cljs.core.first.call(null,(state_71458[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71543 = state_71458;
state_71458 = G__71543;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_71458){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_71458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71483 = f__2707__auto__.call(null);
(statearr_71483[(6)] = c__2706__auto__);

return statearr_71483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71587){
var state_val_71588 = (state_71587[(1)]);
if((state_val_71588 === (7))){
var state_71587__$1 = state_71587;
var statearr_71589_71615 = state_71587__$1;
(statearr_71589_71615[(2)] = null);

(statearr_71589_71615[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71588 === (1))){
var state_71587__$1 = state_71587;
var statearr_71590_71616 = state_71587__$1;
(statearr_71590_71616[(2)] = null);

(statearr_71590_71616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71588 === (4))){
var inst_71544 = (state_71587[(2)]);
var state_71587__$1 = state_71587;
var statearr_71591_71617 = state_71587__$1;
(statearr_71591_71617[(2)] = inst_71544);

(statearr_71591_71617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71588 === (6))){
var inst_71566 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_71587__$1 = state_71587;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71587__$1,(9),inst_71566);
} else {
if((state_val_71588 === (3))){
var inst_71585 = (state_71587[(2)]);
var state_71587__$1 = state_71587;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71587__$1,inst_71585);
} else {
if((state_val_71588 === (12))){
var inst_71579 = (state_71587[(2)]);
var state_71587__$1 = state_71587;
var statearr_71592_71618 = state_71587__$1;
(statearr_71592_71618[(2)] = inst_71579);

(statearr_71592_71618[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71588 === (2))){
var inst_71550 = (state_71587[(7)]);
var inst_71555 = (state_71587[(8)]);
var inst_71560 = (state_71587[(9)]);
var _ = (function (){var statearr_71593 = state_71587;
(statearr_71593[(4)] = cljs.core.cons.call(null,(5),(state_71587[(4)])));

return statearr_71593;
})();
var inst_71550__$1 = cljs.core.random_uuid.call(null);
var inst_71551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71552 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_71553 = (new cljs.core.PersistentVector(null,2,(5),inst_71551,inst_71552,null));
var inst_71554 = (function (){var lock_id = inst_71550__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_71555__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_71553,inst_71554);
var inst_71556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71557 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_71558 = (new cljs.core.PersistentVector(null,3,(5),inst_71556,inst_71557,null));
var inst_71559 = cljs.core.get_in.call(null,inst_71555__$1,inst_71558);
var inst_71560__$1 = cljs.core._EQ_.call(null,inst_71550__$1,inst_71559);
var inst_71561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71562 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71563 = (new cljs.core.PersistentVector(null,3,(5),inst_71561,inst_71562,null));
var inst_71564 = cljs.core.get_in.call(null,inst_71555__$1,inst_71563);
var state_71587__$1 = (function (){var statearr_71594 = state_71587;
(statearr_71594[(7)] = inst_71550__$1);

(statearr_71594[(8)] = inst_71555__$1);

(statearr_71594[(9)] = inst_71560__$1);

(statearr_71594[(10)] = inst_71564);

return statearr_71594;
})();
if(inst_71560__$1){
var statearr_71595_71619 = state_71587__$1;
(statearr_71595_71619[(1)] = (6));

} else {
var statearr_71596_71620 = state_71587__$1;
(statearr_71596_71620[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71588 === (11))){
var inst_71571 = (state_71587[(11)]);
var inst_71570 = (state_71587[(12)]);
var inst_71564 = (state_71587[(10)]);
var inst_71577 = fluree.db.util.xhttp.try_socket.call(null,inst_71570,sub_chan,pub_chan,inst_71564,(60000),inst_71571);
var state_71587__$1 = state_71587;
var statearr_71598_71621 = state_71587__$1;
(statearr_71598_71621[(2)] = inst_71577);

(statearr_71598_71621[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71588 === (9))){
var inst_71568 = (state_71587[(13)]);
var inst_71550 = (state_71587[(7)]);
var inst_71555 = (state_71587[(8)]);
var inst_71570 = (state_71587[(12)]);
var inst_71560 = (state_71587[(9)]);
var inst_71564 = (state_71587[(10)]);
var inst_71568__$1 = (state_71587[(2)]);
var inst_71569 = clojure.string.replace.call(null,inst_71568__$1,"http","ws");
var inst_71570__$1 = [inst_71569,"/fdb/ws"].join('');
var inst_71571 = (function (){var lock_id = inst_71550;
var state = inst_71555;
var have_lock_QMARK_ = inst_71560;
var resp_chan = inst_71564;
var healthy_server = inst_71568__$1;
var ws_url = inst_71570__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_71572 = fluree.db.util.core.exception_QMARK_.call(null,inst_71568__$1);
var state_71587__$1 = (function (){var statearr_71599 = state_71587;
(statearr_71599[(11)] = inst_71571);

(statearr_71599[(13)] = inst_71568__$1);

(statearr_71599[(12)] = inst_71570__$1);

return statearr_71599;
})();
if(inst_71572){
var statearr_71600_71622 = state_71587__$1;
(statearr_71600_71622[(1)] = (10));

} else {
var statearr_71601_71623 = state_71587__$1;
(statearr_71601_71623[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71588 === (5))){
var _ = (function (){var statearr_71602 = state_71587;
(statearr_71602[(4)] = cljs.core.rest.call(null,(state_71587[(4)])));

return statearr_71602;
})();
var state_71587__$1 = state_71587;
var ex71597 = (state_71587__$1[(2)]);
var statearr_71603_71624 = state_71587__$1;
(statearr_71603_71624[(5)] = ex71597);


if((ex71597 instanceof Error)){
var statearr_71604_71625 = state_71587__$1;
(statearr_71604_71625[(1)] = (4));

(statearr_71604_71625[(5)] = null);

} else {
throw ex71597;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71588 === (10))){
var inst_71568 = (state_71587[(13)]);
var inst_71564 = (state_71587[(10)]);
var inst_71574 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_71575 = cljs.core.async.put_BANG_.call(null,inst_71564,inst_71568);
var state_71587__$1 = (function (){var statearr_71605 = state_71587;
(statearr_71605[(14)] = inst_71574);

return statearr_71605;
})();
var statearr_71606_71626 = state_71587__$1;
(statearr_71606_71626[(2)] = inst_71575);

(statearr_71606_71626[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71588 === (8))){
var inst_71564 = (state_71587[(10)]);
var inst_71582 = (state_71587[(2)]);
var _ = (function (){var statearr_71607 = state_71587;
(statearr_71607[(4)] = cljs.core.rest.call(null,(state_71587[(4)])));

return statearr_71607;
})();
var state_71587__$1 = (function (){var statearr_71608 = state_71587;
(statearr_71608[(15)] = inst_71582);

return statearr_71608;
})();
var statearr_71609_71627 = state_71587__$1;
(statearr_71609_71627[(2)] = inst_71564);

(statearr_71609_71627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_71610 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71610[(0)] = fluree$db$connection$establish_socket_$_state_machine__2684__auto__);

(statearr_71610[(1)] = (1));

return statearr_71610;
});
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____1 = (function (state_71587){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_71587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71611){var ex__2687__auto__ = e71611;
var statearr_71612_71628 = state_71587;
(statearr_71612_71628[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_71587[(4)]))){
var statearr_71613_71629 = state_71587;
(statearr_71613_71629[(1)] = cljs.core.first.call(null,(state_71587[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71630 = state_71587;
state_71587 = G__71630;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = function(state_71587){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____1.call(this,state_71587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71614 = f__2707__auto__.call(null);
(statearr_71614[(6)] = c__2706__auto__);

return statearr_71614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k71632,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__71636 = k71632;
var G__71636__$1 = (((G__71636 instanceof cljs.core.Keyword))?G__71636.fqn:null);
switch (G__71636__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k71632,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__71637){
var vec__71638 = p__71637;
var k__5367__auto__ = cljs.core.nth.call(null,vec__71638,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__71638,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__71631){
var self__ = this;
var G__71631__$1 = this;
return (new cljs.core.RecordIter((0),G__71631__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this71633,other71634){
var self__ = this;
var this71633__$1 = this;
return (((!((other71634 == null)))) && ((((this71633__$1.constructor === other71634.constructor)) && (((cljs.core._EQ_.call(null,this71633__$1.id,other71634.id)) && (((cljs.core._EQ_.call(null,this71633__$1.servers,other71634.servers)) && (((cljs.core._EQ_.call(null,this71633__$1.state,other71634.state)) && (((cljs.core._EQ_.call(null,this71633__$1.req_chan,other71634.req_chan)) && (((cljs.core._EQ_.call(null,this71633__$1.sub_chan,other71634.sub_chan)) && (((cljs.core._EQ_.call(null,this71633__$1.pub_chan,other71634.pub_chan)) && (((cljs.core._EQ_.call(null,this71633__$1.group,other71634.group)) && (((cljs.core._EQ_.call(null,this71633__$1.storage_read,other71634.storage_read)) && (((cljs.core._EQ_.call(null,this71633__$1.storage_list,other71634.storage_list)) && (((cljs.core._EQ_.call(null,this71633__$1.storage_write,other71634.storage_write)) && (((cljs.core._EQ_.call(null,this71633__$1.storage_exists,other71634.storage_exists)) && (((cljs.core._EQ_.call(null,this71633__$1.storage_rename,other71634.storage_rename)) && (((cljs.core._EQ_.call(null,this71633__$1.storage_delete,other71634.storage_delete)) && (((cljs.core._EQ_.call(null,this71633__$1.object_cache,other71634.object_cache)) && (((cljs.core._EQ_.call(null,this71633__$1.async_cache,other71634.async_cache)) && (((cljs.core._EQ_.call(null,this71633__$1.parallelism,other71634.parallelism)) && (((cljs.core._EQ_.call(null,this71633__$1.serializer,other71634.serializer)) && (((cljs.core._EQ_.call(null,this71633__$1.default_network,other71634.default_network)) && (((cljs.core._EQ_.call(null,this71633__$1.transactor_QMARK_,other71634.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this71633__$1.publish,other71634.publish)) && (((cljs.core._EQ_.call(null,this71633__$1.transact_handler,other71634.transact_handler)) && (((cljs.core._EQ_.call(null,this71633__$1.tx_private_key,other71634.tx_private_key)) && (((cljs.core._EQ_.call(null,this71633__$1.tx_key_id,other71634.tx_key_id)) && (((cljs.core._EQ_.call(null,this71633__$1.meta,other71634.meta)) && (((cljs.core._EQ_.call(null,this71633__$1.add_listener,other71634.add_listener)) && (((cljs.core._EQ_.call(null,this71633__$1.remove_listener,other71634.remove_listener)) && (((cljs.core._EQ_.call(null,this71633__$1.close,other71634.close)) && (cljs.core._EQ_.call(null,this71633__$1.__extmap,other71634.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__71641){
var self__ = this;
var map__71642 = p__71641;
var map__71642__$1 = cljs.core.__destructure_map.call(null,map__71642);
var node = map__71642__$1;
var id__$1 = cljs.core.get.call(null,map__71642__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__71642__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.call(null,map__71642__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf.call(null,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),(function (_){
return fluree.db.storage.core.resolve_index_node.call(null,conn__$1,node,(function (){
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),null);
}));
}));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k71632){
var self__ = this;
var this__5350__auto____$1 = this;
var G__71643 = k71632;
var G__71643__$1 = (((G__71643 instanceof cljs.core.Keyword))?G__71643.fqn:null);
switch (G__71643__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k71632);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__71631){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__71644 = cljs.core.keyword_identical_QMARK_;
var expr__71645 = k__5352__auto__;
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__71645))){
return (new fluree.db.connection.Connection(G__71631,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,G__71631,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__71631,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__71631,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__71631,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__71631,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__71631,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__71631,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__71631,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__71631,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__71631,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__71631,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__71631,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__71631,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__71631,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__71631,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__71631,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__71631,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__71631,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__71631,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__71631,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__71631,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__71631,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__71631,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__71631,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__71631,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71644.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__71645))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__71631,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__71631),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_read.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return self__.storage_write.call(null,k,data);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_exists.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return self__.storage_rename.call(null,old_key,new_key);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return self__.storage_list.call(null,d);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_delete.call(null,k);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__71631){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__71631,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__71635){
var extmap__5385__auto__ = (function (){var G__71647 = cljs.core.dissoc.call(null,G__71635,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__71635)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__71647);
} else {
return G__71647;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__71635),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__71635),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__71653 = servers_STAR_;
var vec__71654 = G__71653;
var seq__71655 = cljs.core.seq.call(null,vec__71654);
var first__71656 = cljs.core.first.call(null,seq__71655);
var seq__71655__$1 = cljs.core.next.call(null,seq__71655);
var server = first__71656;
var r = seq__71655__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__71653__$1 = G__71653;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__71660 = G__71653__$1;
var seq__71661 = cljs.core.seq.call(null,vec__71660);
var first__71662 = cljs.core.first.call(null,seq__71661);
var seq__71661__$1 = cljs.core.next.call(null,seq__71661);
var server__$1 = first__71662;
var r__$1 = seq__71661__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__71663 = r__$1;
var G__71664 = is_https_QMARK_;
var G__71665 = result_STAR_;
G__71653__$1 = G__71663;
https_QMARK___$1 = G__71664;
result__$1 = G__71665;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__71666 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__71666 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__71666);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71695){
var state_val_71696 = (state_71695[(1)]);
if((state_val_71696 === (7))){
var inst_71681 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71682 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71683 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71684 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71685 = fluree.db.connection.establish_socket.call(null,inst_71681,inst_71682,inst_71683,inst_71684);
var state_71695__$1 = state_71695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71695__$1,(9),inst_71685);
} else {
if((state_val_71696 === (1))){
var state_71695__$1 = state_71695;
var statearr_71697_71716 = state_71695__$1;
(statearr_71697_71716[(2)] = null);

(statearr_71697_71716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (4))){
var inst_71667 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
var statearr_71698_71717 = state_71695__$1;
(statearr_71698_71717[(2)] = inst_71667);

(statearr_71698_71717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (6))){
var inst_71678 = (state_71695[(7)]);
var state_71695__$1 = state_71695;
var statearr_71699_71718 = state_71695__$1;
(statearr_71699_71718[(2)] = inst_71678);

(statearr_71699_71718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (3))){
var inst_71693 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71695__$1,inst_71693);
} else {
if((state_val_71696 === (2))){
var inst_71678 = (state_71695[(7)]);
var _ = (function (){var statearr_71701 = state_71695;
(statearr_71701[(4)] = cljs.core.cons.call(null,(5),(state_71695[(4)])));

return statearr_71701;
})();
var inst_71673 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_71674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71675 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71676 = [inst_71675,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71677 = (new cljs.core.PersistentVector(null,3,(5),inst_71674,inst_71676,null));
var inst_71678__$1 = cljs.core.get_in.call(null,inst_71673,inst_71677);
var state_71695__$1 = (function (){var statearr_71702 = state_71695;
(statearr_71702[(7)] = inst_71678__$1);

return statearr_71702;
})();
if(cljs.core.truth_(inst_71678__$1)){
var statearr_71703_71719 = state_71695__$1;
(statearr_71703_71719[(1)] = (6));

} else {
var statearr_71704_71720 = state_71695__$1;
(statearr_71704_71720[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (9))){
var inst_71687 = (state_71695[(2)]);
var inst_71688 = fluree.db.util.async.throw_err.call(null,inst_71687);
var state_71695__$1 = state_71695;
var statearr_71705_71721 = state_71695__$1;
(statearr_71705_71721[(2)] = inst_71688);

(statearr_71705_71721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (5))){
var _ = (function (){var statearr_71706 = state_71695;
(statearr_71706[(4)] = cljs.core.rest.call(null,(state_71695[(4)])));

return statearr_71706;
})();
var state_71695__$1 = state_71695;
var ex71700 = (state_71695__$1[(2)]);
var statearr_71707_71722 = state_71695__$1;
(statearr_71707_71722[(5)] = ex71700);


if((ex71700 instanceof Error)){
var statearr_71708_71723 = state_71695__$1;
(statearr_71708_71723[(1)] = (4));

(statearr_71708_71723[(5)] = null);

} else {
throw ex71700;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (8))){
var inst_71690 = (state_71695[(2)]);
var _ = (function (){var statearr_71709 = state_71695;
(statearr_71709[(4)] = cljs.core.rest.call(null,(state_71695[(4)])));

return statearr_71709;
})();
var state_71695__$1 = state_71695;
var statearr_71710_71724 = state_71695__$1;
(statearr_71710_71724[(2)] = inst_71690);

(statearr_71710_71724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_71711 = [null,null,null,null,null,null,null,null];
(statearr_71711[(0)] = fluree$db$connection$get_socket_$_state_machine__2684__auto__);

(statearr_71711[(1)] = (1));

return statearr_71711;
});
var fluree$db$connection$get_socket_$_state_machine__2684__auto____1 = (function (state_71695){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_71695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71712){var ex__2687__auto__ = e71712;
var statearr_71713_71725 = state_71695;
(statearr_71713_71725[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_71695[(4)]))){
var statearr_71714_71726 = state_71695;
(statearr_71714_71726[(1)] = cljs.core.first.call(null,(state_71695[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71727 = state_71695;
state_71695 = G__71727;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2684__auto__ = function(state_71695){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____1.call(this,state_71695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2684__auto____0;
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71715 = f__2707__auto__.call(null);
(statearr_71715[(6)] = c__2706__auto__);

return statearr_71715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e71728){var e = e71728;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__71730){
var map__71731 = p__71730;
var map__71731__$1 = cljs.core.__destructure_map.call(null,map__71731);
var conn = map__71731__$1;
var state = cljs.core.get.call(null,map__71731__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.call(null,map__71731__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.call(null,map__71731__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71877){
var state_val_71878 = (state_71877[(1)]);
if((state_val_71878 === (7))){
var inst_71873 = (state_71877[(2)]);
var state_71877__$1 = state_71877;
var statearr_71880_71954 = state_71877__$1;
(statearr_71880_71954[(2)] = inst_71873);

(statearr_71880_71954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (20))){
var _ = (function (){var statearr_71881 = state_71877;
(statearr_71881[(4)] = cljs.core.rest.call(null,(state_71877[(4)])));

return statearr_71881;
})();
var state_71877__$1 = state_71877;
var ex71879 = (state_71877__$1[(2)]);
var statearr_71882_71955 = state_71877__$1;
(statearr_71882_71955[(5)] = ex71879);


var statearr_71883_71956 = state_71877__$1;
(statearr_71883_71956[(1)] = (10));

(statearr_71883_71956[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (27))){
var inst_71834 = (state_71877[(7)]);
var inst_71834__$1 = (state_71877[(2)]);
var inst_71835 = inst_71834__$1 === true;
var state_71877__$1 = (function (){var statearr_71884 = state_71877;
(statearr_71884[(7)] = inst_71834__$1);

return statearr_71884;
})();
if(cljs.core.truth_(inst_71835)){
var statearr_71885_71957 = state_71877__$1;
(statearr_71885_71957[(1)] = (28));

} else {
var statearr_71886_71958 = state_71877__$1;
(statearr_71886_71958[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (1))){
var inst_71732 = (0);
var state_71877__$1 = (function (){var statearr_71887 = state_71877;
(statearr_71887[(8)] = inst_71732);

return statearr_71887;
})();
var statearr_71888_71959 = state_71877__$1;
(statearr_71888_71959[(2)] = null);

(statearr_71888_71959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (24))){
var inst_71824 = (state_71877[(9)]);
var state_71877__$1 = state_71877;
var statearr_71889_71960 = state_71877__$1;
(statearr_71889_71960[(2)] = inst_71824);

(statearr_71889_71960[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (39))){
var inst_71859 = (state_71877[(2)]);
var state_71877__$1 = state_71877;
var statearr_71890_71961 = state_71877__$1;
(statearr_71890_71961[(2)] = inst_71859);

(statearr_71890_71961[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (4))){
var inst_71735 = (state_71877[(10)]);
var inst_71735__$1 = (state_71877[(2)]);
var state_71877__$1 = (function (){var statearr_71891 = state_71877;
(statearr_71891[(10)] = inst_71735__$1);

return statearr_71891;
})();
if(cljs.core.truth_(inst_71735__$1)){
var statearr_71892_71962 = state_71877__$1;
(statearr_71892_71962[(1)] = (5));

} else {
var statearr_71893_71963 = state_71877__$1;
(statearr_71893_71963[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (15))){
var inst_71748 = (state_71877[(11)]);
var state_71877__$1 = state_71877;
var statearr_71894_71964 = state_71877__$1;
(statearr_71894_71964[(2)] = inst_71748);

(statearr_71894_71964[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (21))){
var inst_71735 = (state_71877[(10)]);
var inst_71780 = (state_71877[(12)]);
var inst_71785 = (state_71877[(13)]);
var inst_71777 = (state_71877[(14)]);
var inst_71779 = (state_71877[(15)]);
var inst_71782 = (state_71877[(16)]);
var inst_71781 = (state_71877[(17)]);
var inst_71786 = (state_71877[(18)]);
var inst_71778 = (state_71877[(19)]);
var inst_71732 = (state_71877[(8)]);
var inst_71788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71789 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_71785];
var inst_71790 = (new cljs.core.PersistentVector(null,2,(5),inst_71788,inst_71789,null));
var inst_71791 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_71790,inst_71780);
var inst_71818 = cljs.core.async.chan.call(null,(1));
var inst_71819 = (function (){var resp_chan = inst_71780;
var timeout = inst_71786;
var i = inst_71732;
var data = inst_71779;
var _ = inst_71777;
var req_id = inst_71785;
var operation = inst_71778;
var msg = inst_71735;
var temp__5804__auto__ = inst_71735;
var vec__71770 = inst_71735;
var c__2706__auto____$1 = inst_71818;
var opts = inst_71781;
var map__71773 = inst_71782;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71816){
var state_val_71817 = (state_71816[(1)]);
if((state_val_71817 === (1))){
var inst_71795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71796 = cljs.core.async.timeout.call(null,timeout);
var inst_71797 = [resp_chan,inst_71796];
var inst_71798 = (new cljs.core.PersistentVector(null,2,(5),inst_71795,inst_71797,null));
var state_71816__$1 = state_71816;
return cljs.core.async.ioc_alts_BANG_.call(null,state_71816__$1,(2),inst_71798);
} else {
if((state_val_71817 === (2))){
var inst_71801 = (state_71816[(7)]);
var inst_71800 = (state_71816[(2)]);
var inst_71801__$1 = cljs.core.nth.call(null,inst_71800,(0),null);
var inst_71802 = cljs.core.nth.call(null,inst_71800,(1),null);
var inst_71803 = (function (){var vec__71792 = inst_71800;
var resp = inst_71801__$1;
var c = inst_71802;
return (function (p1__71729_SHARP_){
return cljs.core.dissoc.call(null,p1__71729_SHARP_,req_id);
});
})();
var inst_71804 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_71803);
var inst_71805 = cljs.core._EQ_.call(null,inst_71802,resp_chan);
var state_71816__$1 = (function (){var statearr_71895 = state_71816;
(statearr_71895[(7)] = inst_71801__$1);

(statearr_71895[(8)] = inst_71804);

return statearr_71895;
})();
if(inst_71805){
var statearr_71896_71965 = state_71816__$1;
(statearr_71896_71965[(1)] = (3));

} else {
var statearr_71897_71966 = state_71816__$1;
(statearr_71897_71966[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71817 === (3))){
var inst_71801 = (state_71816[(7)]);
var state_71816__$1 = state_71816;
var statearr_71898_71967 = state_71816__$1;
(statearr_71898_71967[(2)] = inst_71801);

(statearr_71898_71967[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71817 === (4))){
var inst_71808 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_71809 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71810 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_71811 = cljs.core.PersistentHashMap.fromArrays(inst_71809,inst_71810);
var inst_71812 = cljs.core.ex_info.call(null,inst_71808,inst_71811);
var state_71816__$1 = state_71816;
var statearr_71899_71968 = state_71816__$1;
(statearr_71899_71968[(2)] = inst_71812);

(statearr_71899_71968[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71817 === (5))){
var inst_71814 = (state_71816[(2)]);
var state_71816__$1 = state_71816;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71816__$1,inst_71814);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_71900 = [null,null,null,null,null,null,null,null,null];
(statearr_71900[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_71900[(1)] = (1));

return statearr_71900;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_71816){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_71816);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71901){var ex__2687__auto__ = e71901;
var statearr_71902_71969 = state_71816;
(statearr_71902_71969[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_71816[(4)]))){
var statearr_71903_71970 = state_71816;
(statearr_71903_71970[(1)] = cljs.core.first.call(null,(state_71816[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71971 = state_71816;
state_71816 = G__71971;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_71816){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_71816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71904 = f__2707__auto__.call(null);
(statearr_71904[(6)] = c__2706__auto____$1);

return statearr_71904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
});
})();
var inst_71820 = cljs.core.async.impl.dispatch.run.call(null,inst_71819);
var state_71877__$1 = (function (){var statearr_71905 = state_71877;
(statearr_71905[(20)] = inst_71820);

(statearr_71905[(21)] = inst_71791);

return statearr_71905;
})();
var statearr_71906_71972 = state_71877__$1;
(statearr_71906_71972[(2)] = inst_71818);

(statearr_71906_71972[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (31))){
var inst_71834 = (state_71877[(7)]);
var inst_71840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71841 = [inst_71834,"Error processing message in producer."];
var inst_71842 = (new cljs.core.PersistentVector(null,2,(5),inst_71840,inst_71841,null));
var inst_71843 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71842);
var state_71877__$1 = state_71877;
var statearr_71907_71973 = state_71877__$1;
(statearr_71907_71973[(2)] = inst_71843);

(statearr_71907_71973[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (32))){
var inst_71834 = (state_71877[(7)]);
var inst_71845 = (inst_71834 == null);
var state_71877__$1 = state_71877;
if(cljs.core.truth_(inst_71845)){
var statearr_71908_71974 = state_71877__$1;
(statearr_71908_71974[(1)] = (34));

} else {
var statearr_71909_71975 = state_71877__$1;
(statearr_71909_71975[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (33))){
var inst_71863 = (state_71877[(2)]);
var state_71877__$1 = state_71877;
var statearr_71910_71976 = state_71877__$1;
(statearr_71910_71976[(2)] = inst_71863);

(statearr_71910_71976[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (13))){
var inst_71748 = (state_71877[(11)]);
var inst_71745 = (state_71877[(2)]);
var inst_71746 = cljs.core.nth.call(null,inst_71745,(0),null);
var inst_71747 = cljs.core.nth.call(null,inst_71745,(1),null);
var inst_71748__$1 = cljs.core.nth.call(null,inst_71745,(2),null);
var state_71877__$1 = (function (){var statearr_71911 = state_71877;
(statearr_71911[(11)] = inst_71748__$1);

(statearr_71911[(22)] = inst_71746);

(statearr_71911[(23)] = inst_71747);

return statearr_71911;
})();
if(cljs.core.truth_(inst_71748__$1)){
var statearr_71912_71977 = state_71877__$1;
(statearr_71912_71977[(1)] = (14));

} else {
var statearr_71913_71978 = state_71877__$1;
(statearr_71913_71978[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (22))){
var state_71877__$1 = state_71877;
var statearr_71914_71979 = state_71877__$1;
(statearr_71914_71979[(2)] = null);

(statearr_71914_71979[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (36))){
var inst_71861 = (state_71877[(2)]);
var state_71877__$1 = state_71877;
var statearr_71915_71980 = state_71877__$1;
(statearr_71915_71980[(2)] = inst_71861);

(statearr_71915_71980[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (29))){
var inst_71834 = (state_71877[(7)]);
var inst_71838 = fluree.db.util.core.exception_QMARK_.call(null,inst_71834);
var state_71877__$1 = state_71877;
if(inst_71838){
var statearr_71916_71981 = state_71877__$1;
(statearr_71916_71981[(1)] = (31));

} else {
var statearr_71917_71982 = state_71877__$1;
(statearr_71917_71982[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (6))){
var state_71877__$1 = state_71877;
var statearr_71918_71983 = state_71877__$1;
(statearr_71918_71983[(2)] = null);

(statearr_71918_71983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (28))){
var state_71877__$1 = state_71877;
var statearr_71919_71984 = state_71877__$1;
(statearr_71919_71984[(2)] = null);

(statearr_71919_71984[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (25))){
var state_71877__$1 = state_71877;
var statearr_71920_71985 = state_71877__$1;
(statearr_71920_71985[(2)] = fluree.db.connection.default_publish_fn);

(statearr_71920_71985[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (34))){
var inst_71847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71848 = ["Error processing message in producer. Socket closed."];
var inst_71849 = (new cljs.core.PersistentVector(null,1,(5),inst_71847,inst_71848,null));
var inst_71850 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71849);
var state_71877__$1 = state_71877;
var statearr_71921_71986 = state_71877__$1;
(statearr_71921_71986[(2)] = inst_71850);

(statearr_71921_71986[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (17))){
var inst_71748 = (state_71877[(11)]);
var inst_71737 = (state_71877[(24)]);
var inst_71755 = cljs.core.async.put_BANG_.call(null,inst_71748,inst_71737);
var state_71877__$1 = state_71877;
var statearr_71922_71987 = state_71877__$1;
(statearr_71922_71987[(2)] = inst_71755);

(statearr_71922_71987[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (3))){
var inst_71875 = (state_71877[(2)]);
var state_71877__$1 = state_71877;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71877__$1,inst_71875);
} else {
if((state_val_71878 === (12))){
var state_71877__$1 = state_71877;
var statearr_71923_71988 = state_71877__$1;
(statearr_71923_71988[(2)] = null);

(statearr_71923_71988[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (2))){
var state_71877__$1 = state_71877;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71877__$1,(4),req_chan);
} else {
if((state_val_71878 === (23))){
var inst_71824 = (state_71877[(9)]);
var inst_71823 = (state_71877[(2)]);
var inst_71824__$1 = publish;
var state_71877__$1 = (function (){var statearr_71924 = state_71877;
(statearr_71924[(25)] = inst_71823);

(statearr_71924[(9)] = inst_71824__$1);

return statearr_71924;
})();
if(cljs.core.truth_(inst_71824__$1)){
var statearr_71925_71989 = state_71877__$1;
(statearr_71925_71989[(1)] = (24));

} else {
var statearr_71926_71990 = state_71877__$1;
(statearr_71926_71990[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (35))){
var state_71877__$1 = state_71877;
var statearr_71927_71991 = state_71877__$1;
(statearr_71927_71991[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (19))){
var inst_71764 = (state_71877[(2)]);
var state_71877__$1 = state_71877;
var statearr_71929_71992 = state_71877__$1;
(statearr_71929_71992[(2)] = inst_71764);

(statearr_71929_71992[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (11))){
var inst_71735 = (state_71877[(10)]);
var state_71877__$1 = state_71877;
var statearr_71930_71993 = state_71877__$1;
(statearr_71930_71993[(2)] = inst_71735);

(statearr_71930_71993[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (9))){
var inst_71732 = (state_71877[(8)]);
var inst_71868 = (state_71877[(2)]);
var inst_71869 = (inst_71732 + (1));
var inst_71732__$1 = inst_71869;
var state_71877__$1 = (function (){var statearr_71931 = state_71877;
(statearr_71931[(26)] = inst_71868);

(statearr_71931[(8)] = inst_71732__$1);

return statearr_71931;
})();
var statearr_71932_71994 = state_71877__$1;
(statearr_71932_71994[(2)] = null);

(statearr_71932_71994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (5))){
var state_71877__$1 = state_71877;
var statearr_71933_71995 = state_71877__$1;
(statearr_71933_71995[(2)] = null);

(statearr_71933_71995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (14))){
var inst_71748 = (state_71877[(11)]);
var inst_71750 = fluree.db.util.async.channel_QMARK_.call(null,inst_71748);
var state_71877__$1 = state_71877;
var statearr_71934_71996 = state_71877__$1;
(statearr_71934_71996[(2)] = inst_71750);

(statearr_71934_71996[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (26))){
var inst_71785 = (state_71877[(13)]);
var inst_71779 = (state_71877[(15)]);
var inst_71778 = (state_71877[(19)]);
var inst_71828 = (state_71877[(2)]);
var inst_71829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71830 = [inst_71778,inst_71785,inst_71779];
var inst_71831 = (new cljs.core.PersistentVector(null,3,(5),inst_71829,inst_71830,null));
var inst_71832 = inst_71828.call(null,conn,inst_71831);
var state_71877__$1 = state_71877;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71877__$1,(27),inst_71832);
} else {
if((state_val_71878 === (16))){
var inst_71753 = (state_71877[(2)]);
var state_71877__$1 = state_71877;
if(cljs.core.truth_(inst_71753)){
var statearr_71935_71997 = state_71877__$1;
(statearr_71935_71997[(1)] = (17));

} else {
var statearr_71936_71998 = state_71877__$1;
(statearr_71936_71998[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (38))){
var state_71877__$1 = state_71877;
var statearr_71937_71999 = state_71877__$1;
(statearr_71937_71999[(2)] = null);

(statearr_71937_71999[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (30))){
var inst_71865 = (state_71877[(2)]);
var _ = (function (){var statearr_71938 = state_71877;
(statearr_71938[(4)] = cljs.core.rest.call(null,(state_71877[(4)])));

return statearr_71938;
})();
var state_71877__$1 = state_71877;
var statearr_71939_72000 = state_71877__$1;
(statearr_71939_72000[(2)] = inst_71865);

(statearr_71939_72000[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (10))){
var inst_71735 = (state_71877[(10)]);
var inst_71737 = (state_71877[(2)]);
var inst_71741 = cljs.core.sequential_QMARK_.call(null,inst_71735);
var state_71877__$1 = (function (){var statearr_71940 = state_71877;
(statearr_71940[(24)] = inst_71737);

return statearr_71940;
})();
if(inst_71741){
var statearr_71941_72001 = state_71877__$1;
(statearr_71941_72001[(1)] = (11));

} else {
var statearr_71942_72002 = state_71877__$1;
(statearr_71942_72002[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (18))){
var inst_71735 = (state_71877[(10)]);
var inst_71737 = (state_71877[(24)]);
var inst_71757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71758 = cljs.core.pr_str.call(null,inst_71735);
var inst_71759 = ["Error processing ledger request, no valid return channel: ",inst_71758].join('');
var inst_71760 = [inst_71737,inst_71759];
var inst_71761 = (new cljs.core.PersistentVector(null,2,(5),inst_71757,inst_71760,null));
var inst_71762 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71761);
var state_71877__$1 = state_71877;
var statearr_71943_72003 = state_71877__$1;
(statearr_71943_72003[(2)] = inst_71762);

(statearr_71943_72003[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (37))){
var inst_71834 = (state_71877[(7)]);
var inst_71853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71854 = ["Error processing message in producer. Socket closed. Published result",inst_71834];
var inst_71855 = (new cljs.core.PersistentVector(null,2,(5),inst_71853,inst_71854,null));
var inst_71856 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71855);
var state_71877__$1 = state_71877;
var statearr_71944_72004 = state_71877__$1;
(statearr_71944_72004[(2)] = inst_71856);

(statearr_71944_72004[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71878 === (8))){
var inst_71735 = (state_71877[(10)]);
var inst_71780 = (state_71877[(12)]);
var inst_71782 = (state_71877[(16)]);
var inst_71781 = (state_71877[(17)]);
var _ = (function (){var statearr_71945 = state_71877;
(statearr_71945[(4)] = cljs.core.cons.call(null,(20),(state_71877[(4)])));

return statearr_71945;
})();
var inst_71774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71775 = ["Outgoing message to websocket: ",inst_71735];
var inst_71776 = (new cljs.core.PersistentVector(null,2,(5),inst_71774,inst_71775,null));
var inst_71777 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_71776);
var inst_71778 = cljs.core.nth.call(null,inst_71735,(0),null);
var inst_71779 = cljs.core.nth.call(null,inst_71735,(1),null);
var inst_71780__$1 = cljs.core.nth.call(null,inst_71735,(2),null);
var inst_71781__$1 = cljs.core.nth.call(null,inst_71735,(3),null);
var inst_71782__$1 = cljs.core.__destructure_map.call(null,inst_71781__$1);
var inst_71783 = cljs.core.random_uuid.call(null);
var inst_71784 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71783);
var inst_71785 = cljs.core.get.call(null,inst_71782__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_71784);
var inst_71786 = cljs.core.get.call(null,inst_71782__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_71877__$1 = (function (){var statearr_71946 = state_71877;
(statearr_71946[(12)] = inst_71780__$1);

(statearr_71946[(13)] = inst_71785);

(statearr_71946[(14)] = inst_71777);

(statearr_71946[(15)] = inst_71779);

(statearr_71946[(16)] = inst_71782__$1);

(statearr_71946[(17)] = inst_71781__$1);

(statearr_71946[(18)] = inst_71786);

(statearr_71946[(19)] = inst_71778);

return statearr_71946;
})();
if(cljs.core.truth_(inst_71780__$1)){
var statearr_71947_72005 = state_71877__$1;
(statearr_71947_72005[(1)] = (21));

} else {
var statearr_71948_72006 = state_71877__$1;
(statearr_71948_72006[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_71949 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71949[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_71949[(1)] = (1));

return statearr_71949;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_71877){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_71877);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71950){var ex__2687__auto__ = e71950;
var statearr_71951_72007 = state_71877;
(statearr_71951_72007[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_71877[(4)]))){
var statearr_71952_72008 = state_71877;
(statearr_71952_72008[(1)] = cljs.core.first.call(null,(state_71877[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72009 = state_71877;
state_71877 = G__72009;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_71877){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_71877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71953 = f__2707__auto__.call(null);
(statearr_71953[(6)] = c__2706__auto__);

return statearr_71953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72047){
var state_val_72048 = (state_72047[(1)]);
if((state_val_72048 === (7))){
var inst_72018 = (state_72047[(7)]);
var state_72047__$1 = state_72047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72047__$1,(9),inst_72018);
} else {
if((state_val_72048 === (1))){
var inst_72010 = (1);
var state_72047__$1 = (function (){var statearr_72049 = state_72047;
(statearr_72049[(8)] = inst_72010);

return statearr_72049;
})();
var statearr_72050_72073 = state_72047__$1;
(statearr_72050_72073[(2)] = null);

(statearr_72050_72073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72048 === (4))){
var inst_72015 = (state_72047[(2)]);
var inst_72016 = fluree.db.connection.get_socket.call(null,conn);
var state_72047__$1 = (function (){var statearr_72051 = state_72047;
(statearr_72051[(9)] = inst_72015);

return statearr_72051;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72047__$1,(5),inst_72016);
} else {
if((state_val_72048 === (15))){
var inst_72043 = (state_72047[(2)]);
var state_72047__$1 = state_72047;
var statearr_72052_72074 = state_72047__$1;
(statearr_72052_72074[(2)] = inst_72043);

(statearr_72052_72074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72048 === (13))){
var inst_72010 = (state_72047[(8)]);
var inst_72025 = (state_72047[(10)]);
var inst_72033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72034 = [inst_72025,"Cannot establish connection to a healthy server, backing off:",inst_72010,"s."];
var inst_72035 = (new cljs.core.PersistentVector(null,4,(5),inst_72033,inst_72034,null));
var inst_72036 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72035);
var inst_72037 = ((2) * inst_72010);
var inst_72038 = ((60) * (2));
var inst_72039 = ((inst_72037 < inst_72038) ? inst_72037 : inst_72038);
var inst_72010__$1 = inst_72039;
var state_72047__$1 = (function (){var statearr_72053 = state_72047;
(statearr_72053[(8)] = inst_72010__$1);

(statearr_72053[(11)] = inst_72036);

return statearr_72053;
})();
var statearr_72054_72075 = state_72047__$1;
(statearr_72054_72075[(2)] = null);

(statearr_72054_72075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72048 === (6))){
var inst_72018 = (state_72047[(7)]);
var state_72047__$1 = state_72047;
var statearr_72055_72076 = state_72047__$1;
(statearr_72055_72076[(2)] = inst_72018);

(statearr_72055_72076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72048 === (3))){
var inst_72045 = (state_72047[(2)]);
var state_72047__$1 = state_72047;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72047__$1,inst_72045);
} else {
if((state_val_72048 === (12))){
var inst_72031 = (state_72047[(2)]);
var state_72047__$1 = state_72047;
if(cljs.core.truth_(inst_72031)){
var statearr_72056_72077 = state_72047__$1;
(statearr_72056_72077[(1)] = (13));

} else {
var statearr_72057_72078 = state_72047__$1;
(statearr_72057_72078[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72048 === (2))){
var inst_72010 = (state_72047[(8)]);
var inst_72012 = (inst_72010 * (1000));
var inst_72013 = cljs.core.async.timeout.call(null,inst_72012);
var state_72047__$1 = state_72047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72047__$1,(4),inst_72013);
} else {
if((state_val_72048 === (11))){
var inst_72025 = (state_72047[(10)]);
var inst_72029 = fluree.db.util.core.exception_QMARK_.call(null,inst_72025);
var state_72047__$1 = state_72047;
var statearr_72058_72079 = state_72047__$1;
(statearr_72058_72079[(2)] = inst_72029);

(statearr_72058_72079[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72048 === (9))){
var inst_72023 = (state_72047[(2)]);
var state_72047__$1 = state_72047;
var statearr_72059_72080 = state_72047__$1;
(statearr_72059_72080[(2)] = inst_72023);

(statearr_72059_72080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72048 === (5))){
var inst_72018 = (state_72047[(7)]);
var inst_72018__$1 = (state_72047[(2)]);
var inst_72019 = fluree.db.util.core.exception_QMARK_.call(null,inst_72018__$1);
var state_72047__$1 = (function (){var statearr_72060 = state_72047;
(statearr_72060[(7)] = inst_72018__$1);

return statearr_72060;
})();
if(inst_72019){
var statearr_72061_72081 = state_72047__$1;
(statearr_72061_72081[(1)] = (6));

} else {
var statearr_72062_72082 = state_72047__$1;
(statearr_72062_72082[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72048 === (14))){
var inst_72025 = (state_72047[(10)]);
var state_72047__$1 = state_72047;
var statearr_72063_72083 = state_72047__$1;
(statearr_72063_72083[(2)] = inst_72025);

(statearr_72063_72083[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72048 === (10))){
var inst_72026 = (state_72047[(12)]);
var state_72047__$1 = state_72047;
var statearr_72064_72084 = state_72047__$1;
(statearr_72064_72084[(2)] = inst_72026);

(statearr_72064_72084[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72048 === (8))){
var inst_72025 = (state_72047[(10)]);
var inst_72026 = (state_72047[(12)]);
var inst_72025__$1 = (state_72047[(2)]);
var inst_72026__$1 = (inst_72025__$1 == null);
var state_72047__$1 = (function (){var statearr_72065 = state_72047;
(statearr_72065[(10)] = inst_72025__$1);

(statearr_72065[(12)] = inst_72026__$1);

return statearr_72065;
})();
if(cljs.core.truth_(inst_72026__$1)){
var statearr_72066_72085 = state_72047__$1;
(statearr_72066_72085[(1)] = (10));

} else {
var statearr_72067_72086 = state_72047__$1;
(statearr_72067_72086[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0 = (function (){
var statearr_72068 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72068[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__);

(statearr_72068[(1)] = (1));

return statearr_72068;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1 = (function (state_72047){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_72047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72069){var ex__2687__auto__ = e72069;
var statearr_72070_72087 = state_72047;
(statearr_72070_72087[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_72047[(4)]))){
var statearr_72071_72088 = state_72047;
(statearr_72071_72088[(1)] = cljs.core.first.call(null,(state_72047[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72089 = state_72047;
state_72047 = G__72089;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__ = function(state_72047){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1.call(this,state_72047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72072 = f__2707__auto__.call(null);
(statearr_72072[(6)] = c__2706__auto__);

return statearr_72072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__72090){
var map__72091 = p__72090;
var map__72091__$1 = cljs.core.__destructure_map.call(null,map__72091);
var conn = map__72091__$1;
var sub_chan = cljs.core.get.call(null,map__72091__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.call(null,map__72091__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.call(null,map__72091__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.call(null,map__72091__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72202){
var state_val_72203 = (state_72202[(1)]);
if((state_val_72203 === (7))){
var inst_72198 = (state_72202[(2)]);
var state_72202__$1 = state_72202;
var statearr_72204_72260 = state_72202__$1;
(statearr_72204_72260[(2)] = inst_72198);

(statearr_72204_72260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (20))){
var inst_72149 = (state_72202[(2)]);
var state_72202__$1 = state_72202;
var statearr_72205_72261 = state_72202__$1;
(statearr_72205_72261[(2)] = inst_72149);

(statearr_72205_72261[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (27))){
var inst_72167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72168 = ["Connection closed."];
var inst_72169 = (new cljs.core.PersistentVector(null,1,(5),inst_72167,inst_72168,null));
var inst_72170 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_72169);
var state_72202__$1 = state_72202;
var statearr_72206_72262 = state_72202__$1;
(statearr_72206_72262[(2)] = inst_72170);

(statearr_72206_72262[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (1))){
var inst_72092 = (0);
var state_72202__$1 = (function (){var statearr_72207 = state_72202;
(statearr_72207[(7)] = inst_72092);

return statearr_72207;
})();
var statearr_72208_72263 = state_72202__$1;
(statearr_72208_72263[(2)] = null);

(statearr_72208_72263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (24))){
var inst_72136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72137 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_72138 = [keep_alive_fn];
var inst_72139 = cljs.core.PersistentHashMap.fromArrays(inst_72137,inst_72138);
var inst_72140 = ["Unsupported callback registered",inst_72139];
var inst_72141 = (new cljs.core.PersistentVector(null,2,(5),inst_72136,inst_72140,null));
var inst_72142 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_72141);
var state_72202__$1 = state_72202;
var statearr_72209_72264 = state_72202__$1;
(statearr_72209_72264[(2)] = inst_72142);

(statearr_72209_72264[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (4))){
var inst_72097 = (state_72202[(8)]);
var inst_72102 = (state_72202[(2)]);
var inst_72103 = cljs.core.nth.call(null,inst_72102,(0),null);
var inst_72104 = cljs.core.nth.call(null,inst_72102,(1),null);
var inst_72105 = cljs.core._EQ_.call(null,inst_72104,inst_72097);
var state_72202__$1 = (function (){var statearr_72210 = state_72202;
(statearr_72210[(9)] = inst_72103);

return statearr_72210;
})();
if(inst_72105){
var statearr_72211_72265 = state_72202__$1;
(statearr_72211_72265[(1)] = (5));

} else {
var statearr_72212_72266 = state_72202__$1;
(statearr_72212_72266[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (15))){
var inst_72122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72123 = ["No keep-alive callback is registered"];
var inst_72124 = (new cljs.core.PersistentVector(null,1,(5),inst_72122,inst_72123,null));
var inst_72125 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_72124);
var state_72202__$1 = state_72202;
var statearr_72213_72267 = state_72202__$1;
(statearr_72213_72267[(2)] = inst_72125);

(statearr_72213_72267[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (21))){
var inst_72133 = cljs.core.eval.call(null,keep_alive_fn);
var state_72202__$1 = state_72202;
var statearr_72214_72268 = state_72202__$1;
(statearr_72214_72268[(2)] = inst_72133);

(statearr_72214_72268[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (31))){
var state_72202__$1 = state_72202;
var statearr_72215_72269 = state_72202__$1;
(statearr_72215_72269[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (32))){
var inst_72194 = (state_72202[(2)]);
var state_72202__$1 = state_72202;
var statearr_72217_72270 = state_72202__$1;
(statearr_72217_72270[(2)] = inst_72194);

(statearr_72217_72270[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (33))){
var inst_72103 = (state_72202[(9)]);
var inst_72181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72182 = fluree.db.util.json.parse.call(null,inst_72103);
var inst_72183 = cljs.core.pr_str.call(null,inst_72182);
var inst_72184 = ["Received message:",inst_72183];
var inst_72185 = (new cljs.core.PersistentVector(null,2,(5),inst_72181,inst_72184,null));
var inst_72186 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_72185);
var inst_72187 = fluree.db.util.json.parse.call(null,inst_72103);
var inst_72188 = fluree.db.conn_events.process_events.call(null,conn,inst_72187);
var inst_72092 = (0);
var state_72202__$1 = (function (){var statearr_72218 = state_72202;
(statearr_72218[(10)] = inst_72188);

(statearr_72218[(11)] = inst_72186);

(statearr_72218[(7)] = inst_72092);

return statearr_72218;
})();
var statearr_72219_72271 = state_72202__$1;
(statearr_72219_72271[(2)] = null);

(statearr_72219_72271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (13))){
var inst_72157 = (state_72202[(2)]);
var state_72202__$1 = state_72202;
var statearr_72220_72272 = state_72202__$1;
(statearr_72220_72272[(2)] = inst_72157);

(statearr_72220_72272[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (22))){
var state_72202__$1 = state_72202;
var statearr_72221_72273 = state_72202__$1;
(statearr_72221_72273[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (29))){
var inst_72196 = (state_72202[(2)]);
var state_72202__$1 = state_72202;
var statearr_72223_72274 = state_72202__$1;
(statearr_72223_72274[(2)] = inst_72196);

(statearr_72223_72274[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (6))){
var inst_72103 = (state_72202[(9)]);
var inst_72165 = (inst_72103 == null);
var state_72202__$1 = state_72202;
if(cljs.core.truth_(inst_72165)){
var statearr_72224_72275 = state_72202__$1;
(statearr_72224_72275[(1)] = (27));

} else {
var statearr_72225_72276 = state_72202__$1;
(statearr_72225_72276[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (28))){
var inst_72103 = (state_72202[(9)]);
var inst_72172 = fluree.db.util.core.exception_QMARK_.call(null,inst_72103);
var state_72202__$1 = state_72202;
if(inst_72172){
var statearr_72226_72277 = state_72202__$1;
(statearr_72226_72277[(1)] = (30));

} else {
var statearr_72227_72278 = state_72202__$1;
(statearr_72227_72278[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (25))){
var state_72202__$1 = state_72202;
var statearr_72228_72279 = state_72202__$1;
(statearr_72228_72279[(2)] = null);

(statearr_72228_72279[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (34))){
var state_72202__$1 = state_72202;
var statearr_72229_72280 = state_72202__$1;
(statearr_72229_72280[(2)] = null);

(statearr_72229_72280[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (17))){
var inst_72151 = (state_72202[(2)]);
var inst_72152 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72153 = fluree.db.connection.close_websocket.call(null,inst_72152);
var inst_72154 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72155 = fluree.db.session.close_all_sessions.call(null,inst_72154);
var state_72202__$1 = (function (){var statearr_72230 = state_72202;
(statearr_72230[(12)] = inst_72153);

(statearr_72230[(13)] = inst_72151);

return statearr_72230;
})();
var statearr_72231_72281 = state_72202__$1;
(statearr_72231_72281[(2)] = inst_72155);

(statearr_72231_72281[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (3))){
var inst_72200 = (state_72202[(2)]);
var state_72202__$1 = state_72202;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72202__$1,inst_72200);
} else {
if((state_val_72203 === (12))){
var inst_72115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72116 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_72117 = (new cljs.core.PersistentVector(null,1,(5),inst_72115,inst_72116,null));
var inst_72118 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_72117);
var inst_72119 = keep_alive_fn;
var inst_72120 = (keep_alive_fn == null);
var state_72202__$1 = (function (){var statearr_72232 = state_72202;
(statearr_72232[(14)] = inst_72118);

(statearr_72232[(15)] = inst_72119);

return statearr_72232;
})();
if(cljs.core.truth_(inst_72120)){
var statearr_72233_72282 = state_72202__$1;
(statearr_72233_72282[(1)] = (15));

} else {
var statearr_72234_72283 = state_72202__$1;
(statearr_72234_72283[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (2))){
var inst_72097 = (state_72202[(8)]);
var inst_72097__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_72098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72099 = [sub_chan,inst_72097__$1];
var inst_72100 = (new cljs.core.PersistentVector(null,2,(5),inst_72098,inst_72099,null));
var state_72202__$1 = (function (){var statearr_72235 = state_72202;
(statearr_72235[(8)] = inst_72097__$1);

return statearr_72235;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_72202__$1,(4),inst_72100);
} else {
if((state_val_72203 === (23))){
var inst_72147 = (state_72202[(2)]);
var state_72202__$1 = state_72202;
var statearr_72236_72284 = state_72202__$1;
(statearr_72236_72284[(2)] = inst_72147);

(statearr_72236_72284[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (35))){
var inst_72192 = (state_72202[(2)]);
var state_72202__$1 = state_72202;
var statearr_72237_72285 = state_72202__$1;
(statearr_72237_72285[(2)] = inst_72192);

(statearr_72237_72285[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (19))){
var inst_72131 = typeof keep_alive_fn === 'string';
var state_72202__$1 = state_72202;
if(cljs.core.truth_(inst_72131)){
var statearr_72238_72286 = state_72202__$1;
(statearr_72238_72286[(1)] = (21));

} else {
var statearr_72239_72287 = state_72202__$1;
(statearr_72239_72287[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (11))){
var inst_72110 = fluree.db.connection.reconnect_conn.call(null,conn);
var state_72202__$1 = state_72202;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72202__$1,(14),inst_72110);
} else {
if((state_val_72203 === (9))){
var inst_72092 = (state_72202[(7)]);
var inst_72159 = fluree.db.connection.ping_transactor.call(null,req_chan);
var inst_72160 = (inst_72092 + (1));
var inst_72092__$1 = inst_72160;
var state_72202__$1 = (function (){var statearr_72240 = state_72202;
(statearr_72240[(7)] = inst_72092__$1);

(statearr_72240[(16)] = inst_72159);

return statearr_72240;
})();
var statearr_72241_72288 = state_72202__$1;
(statearr_72241_72288[(2)] = null);

(statearr_72241_72288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (5))){
var inst_72092 = (state_72202[(7)]);
var inst_72107 = cljs.core._EQ_.call(null,(2),inst_72092);
var state_72202__$1 = state_72202;
if(inst_72107){
var statearr_72242_72289 = state_72202__$1;
(statearr_72242_72289[(1)] = (8));

} else {
var statearr_72243_72290 = state_72202__$1;
(statearr_72243_72290[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (14))){
var inst_72112 = (state_72202[(2)]);
var inst_72092 = (0);
var state_72202__$1 = (function (){var statearr_72244 = state_72202;
(statearr_72244[(7)] = inst_72092);

(statearr_72244[(17)] = inst_72112);

return statearr_72244;
})();
var statearr_72245_72291 = state_72202__$1;
(statearr_72245_72291[(2)] = null);

(statearr_72245_72291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (26))){
var inst_72145 = (state_72202[(2)]);
var state_72202__$1 = state_72202;
var statearr_72246_72292 = state_72202__$1;
(statearr_72246_72292[(2)] = inst_72145);

(statearr_72246_72292[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (16))){
var inst_72127 = cljs.core.fn_QMARK_.call(null,keep_alive_fn);
var state_72202__$1 = state_72202;
if(inst_72127){
var statearr_72247_72293 = state_72202__$1;
(statearr_72247_72293[(1)] = (18));

} else {
var statearr_72248_72294 = state_72202__$1;
(statearr_72248_72294[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (30))){
var inst_72103 = (state_72202[(9)]);
var inst_72174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72175 = [inst_72103];
var inst_72176 = (new cljs.core.PersistentVector(null,1,(5),inst_72174,inst_72175,null));
var inst_72177 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72176);
var inst_72092 = (0);
var state_72202__$1 = (function (){var statearr_72249 = state_72202;
(statearr_72249[(7)] = inst_72092);

(statearr_72249[(18)] = inst_72177);

return statearr_72249;
})();
var statearr_72250_72295 = state_72202__$1;
(statearr_72250_72295[(2)] = null);

(statearr_72250_72295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (10))){
var inst_72163 = (state_72202[(2)]);
var state_72202__$1 = state_72202;
var statearr_72251_72296 = state_72202__$1;
(statearr_72251_72296[(2)] = inst_72163);

(statearr_72251_72296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (18))){
var inst_72129 = keep_alive_fn.call(null);
var state_72202__$1 = state_72202;
var statearr_72252_72297 = state_72202__$1;
(statearr_72252_72297[(2)] = inst_72129);

(statearr_72252_72297[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72203 === (8))){
var state_72202__$1 = state_72202;
if(cljs.core.truth_(keep_alive)){
var statearr_72253_72298 = state_72202__$1;
(statearr_72253_72298[(1)] = (11));

} else {
var statearr_72254_72299 = state_72202__$1;
(statearr_72254_72299[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0 = (function (){
var statearr_72255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72255[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2684__auto__);

(statearr_72255[(1)] = (1));

return statearr_72255;
});
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1 = (function (state_72202){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_72202);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72256){var ex__2687__auto__ = e72256;
var statearr_72257_72300 = state_72202;
(statearr_72257_72300[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_72202[(4)]))){
var statearr_72258_72301 = state_72202;
(statearr_72258_72301[(1)] = cljs.core.first.call(null,(state_72202[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72302 = state_72202;
state_72202 = G__72302;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = function(state_72202){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1.call(this,state_72202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72259 = f__2707__auto__.call(null);
(statearr_72259[(6)] = c__2706__auto__);

return statearr_72259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__72304 = arguments.length;
switch (G__72304) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__72305 = opts;
var map__72305__$1 = cljs.core.__destructure_map.call(null,map__72305);
var private$ = cljs.core.get.call(null,map__72305__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__72305__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72357){
var state_val_72358 = (state_72357[(1)]);
if((state_val_72358 === (7))){
var inst_72315 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_72316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72317 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72318 = (new cljs.core.PersistentVector(null,2,(5),inst_72316,inst_72317,null));
var inst_72319 = cljs.core.get_in.call(null,inst_72315,inst_72318);
var state_72357__$1 = state_72357;
var statearr_72359_72390 = state_72357__$1;
(statearr_72359_72390[(2)] = inst_72319);

(statearr_72359_72390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (1))){
var state_72357__$1 = state_72357;
var statearr_72360_72391 = state_72357__$1;
(statearr_72360_72391[(2)] = null);

(statearr_72360_72391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (4))){
var inst_72306 = (state_72357[(2)]);
var state_72357__$1 = state_72357;
var statearr_72361_72392 = state_72357__$1;
(statearr_72361_72392[(2)] = inst_72306);

(statearr_72361_72392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (15))){
var inst_72326 = (state_72357[(7)]);
var inst_72345 = (state_72357[(2)]);
var inst_72346 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_72347 = [(5000),inst_72345,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_72348 = cljs.core.PersistentHashMap.fromArrays(inst_72346,inst_72347);
var inst_72349 = fluree.db.util.xhttp.get.call(null,inst_72326,inst_72348);
var state_72357__$1 = state_72357;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72357__$1,(16),inst_72349);
} else {
if((state_val_72358 === (13))){
var inst_72336 = (state_72357[(8)]);
var inst_72326 = (state_72357[(7)]);
var inst_72338 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_72339 = [inst_72336];
var inst_72340 = cljs.core.PersistentHashMap.fromArrays(inst_72338,inst_72339);
var inst_72341 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_72326,inst_72340,private$);
var inst_72342 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_72341);
var state_72357__$1 = state_72357;
var statearr_72362_72393 = state_72357__$1;
(statearr_72362_72393[(2)] = inst_72342);

(statearr_72362_72393[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (6))){
var inst_72312 = (state_72357[(9)]);
var state_72357__$1 = state_72357;
var statearr_72363_72394 = state_72357__$1;
(statearr_72363_72394[(2)] = inst_72312);

(statearr_72363_72394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (3))){
var inst_72355 = (state_72357[(2)]);
var state_72357__$1 = state_72357;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72357__$1,inst_72355);
} else {
if((state_val_72358 === (12))){
var inst_72336 = (state_72357[(2)]);
var state_72357__$1 = (function (){var statearr_72364 = state_72357;
(statearr_72364[(8)] = inst_72336);

return statearr_72364;
})();
if(cljs.core.truth_(private$)){
var statearr_72365_72395 = state_72357__$1;
(statearr_72365_72395[(1)] = (13));

} else {
var statearr_72366_72396 = state_72357__$1;
(statearr_72366_72396[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (2))){
var inst_72312 = (state_72357[(9)]);
var _ = (function (){var statearr_72367 = state_72357;
(statearr_72367[(4)] = cljs.core.cons.call(null,(5),(state_72357[(4)])));

return statearr_72367;
})();
var inst_72312__$1 = jwt;
var state_72357__$1 = (function (){var statearr_72368 = state_72357;
(statearr_72368[(9)] = inst_72312__$1);

return statearr_72368;
})();
if(cljs.core.truth_(inst_72312__$1)){
var statearr_72369_72397 = state_72357__$1;
(statearr_72369_72397[(1)] = (6));

} else {
var statearr_72370_72398 = state_72357__$1;
(statearr_72370_72398[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (11))){
var inst_72330 = (state_72357[(10)]);
var state_72357__$1 = state_72357;
var statearr_72372_72399 = state_72357__$1;
(statearr_72372_72399[(2)] = inst_72330);

(statearr_72372_72399[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (9))){
var inst_72321 = (state_72357[(11)]);
var inst_72322 = (state_72357[(12)]);
var inst_72325 = (state_72357[(2)]);
var inst_72326 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72325),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72322)].join('');
var inst_72328 = ["Accept"];
var inst_72329 = ["application/json"];
var inst_72330 = cljs.core.PersistentHashMap.fromArrays(inst_72328,inst_72329);
var state_72357__$1 = (function (){var statearr_72373 = state_72357;
(statearr_72373[(10)] = inst_72330);

(statearr_72373[(7)] = inst_72326);

return statearr_72373;
})();
if(cljs.core.truth_(inst_72321)){
var statearr_72374_72400 = state_72357__$1;
(statearr_72374_72400[(1)] = (10));

} else {
var statearr_72375_72401 = state_72357__$1;
(statearr_72375_72401[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (5))){
var _ = (function (){var statearr_72376 = state_72357;
(statearr_72376[(4)] = cljs.core.rest.call(null,(state_72357[(4)])));

return statearr_72376;
})();
var state_72357__$1 = state_72357;
var ex72371 = (state_72357__$1[(2)]);
var statearr_72377_72402 = state_72357__$1;
(statearr_72377_72402[(5)] = ex72371);


if((ex72371 instanceof Error)){
var statearr_72378_72403 = state_72357__$1;
(statearr_72378_72403[(1)] = (4));

(statearr_72378_72403[(5)] = null);

} else {
throw ex72371;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (14))){
var inst_72336 = (state_72357[(8)]);
var state_72357__$1 = state_72357;
var statearr_72379_72404 = state_72357__$1;
(statearr_72379_72404[(2)] = inst_72336);

(statearr_72379_72404[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (16))){
var inst_72351 = (state_72357[(2)]);
var inst_72352 = fluree.db.util.async.throw_err.call(null,inst_72351);
var _ = (function (){var statearr_72380 = state_72357;
(statearr_72380[(4)] = cljs.core.rest.call(null,(state_72357[(4)])));

return statearr_72380;
})();
var state_72357__$1 = state_72357;
var statearr_72381_72405 = state_72357__$1;
(statearr_72381_72405[(2)] = inst_72352);

(statearr_72381_72405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (10))){
var inst_72330 = (state_72357[(10)]);
var inst_72321 = (state_72357[(11)]);
var inst_72332 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72321)].join('');
var inst_72333 = cljs.core.assoc.call(null,inst_72330,"Authorization",inst_72332);
var state_72357__$1 = state_72357;
var statearr_72382_72406 = state_72357__$1;
(statearr_72382_72406[(2)] = inst_72333);

(statearr_72382_72406[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72358 === (8))){
var inst_72321 = (state_72357[(2)]);
var inst_72322 = clojure.string.replace.call(null,k,"_","/");
var inst_72323 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_72357__$1 = (function (){var statearr_72383 = state_72357;
(statearr_72383[(11)] = inst_72321);

(statearr_72383[(12)] = inst_72322);

return statearr_72383;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72357__$1,(9),inst_72323);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_72384 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72384[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_72384[(1)] = (1));

return statearr_72384;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_72357){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_72357);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72385){var ex__2687__auto__ = e72385;
var statearr_72386_72407 = state_72357;
(statearr_72386_72407[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_72357[(4)]))){
var statearr_72387_72408 = state_72357;
(statearr_72387_72408[(1)] = cljs.core.first.call(null,(state_72357[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72409 = state_72357;
state_72357 = G__72409;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_72357){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_72357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72388 = f__2707__auto__.call(null);
(statearr_72388[(6)] = c__2706__auto__);

return statearr_72388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.call(null);
var temp__5802__auto___72434 = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___72434)){
var v_72435 = temp__5802__auto___72434;
cljs.core.async.put_BANG_.call(null,out,v_72435);
} else {
var c__2706__auto___72436 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72421){
var state_val_72422 = (state_72421[(1)]);
if((state_val_72422 === (1))){
var inst_72410 = value_fn.call(null,k);
var state_72421__$1 = state_72421;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72421__$1,(2),inst_72410);
} else {
if((state_val_72422 === (2))){
var inst_72412 = (state_72421[(7)]);
var inst_72412__$1 = (state_72421[(2)]);
var inst_72413 = fluree.db.util.core.exception_QMARK_.call(null,inst_72412__$1);
var state_72421__$1 = (function (){var statearr_72423 = state_72421;
(statearr_72423[(7)] = inst_72412__$1);

return statearr_72423;
})();
if(inst_72413){
var statearr_72424_72437 = state_72421__$1;
(statearr_72424_72437[(1)] = (3));

} else {
var statearr_72425_72438 = state_72421__$1;
(statearr_72425_72438[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72422 === (3))){
var state_72421__$1 = state_72421;
var statearr_72426_72439 = state_72421__$1;
(statearr_72426_72439[(2)] = null);

(statearr_72426_72439[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72422 === (4))){
var inst_72412 = (state_72421[(7)]);
var inst_72416 = cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,inst_72412);
var state_72421__$1 = state_72421;
var statearr_72427_72440 = state_72421__$1;
(statearr_72427_72440[(2)] = inst_72416);

(statearr_72427_72440[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72422 === (5))){
var inst_72412 = (state_72421[(7)]);
var inst_72418 = (state_72421[(2)]);
var inst_72419 = cljs.core.async.put_BANG_.call(null,out,inst_72412);
var state_72421__$1 = (function (){var statearr_72428 = state_72421;
(statearr_72428[(8)] = inst_72418);

return statearr_72428;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72421__$1,inst_72419);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_72429 = [null,null,null,null,null,null,null,null,null];
(statearr_72429[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__);

(statearr_72429[(1)] = (1));

return statearr_72429;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1 = (function (state_72421){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_72421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72430){var ex__2687__auto__ = e72430;
var statearr_72431_72441 = state_72421;
(statearr_72431_72441[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_72421[(4)]))){
var statearr_72432_72442 = state_72421;
(statearr_72432_72442[(1)] = cljs.core.first.call(null,(state_72421[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72443 = state_72421;
state_72421 = G__72443;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__ = function(state_72421){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1.call(this,state_72421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72433 = f__2707__auto__.call(null);
(statearr_72433[(6)] = c__2706__auto___72436);

return statearr_72433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__72444_SHARP_){
if(cljs.core.truth_(p1__72444_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__72445_SHARP_){
var or__5045__auto__ = p1__72445_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e72446){var e = e72446;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__72447 = opts;
var map__72447__$1 = cljs.core.__destructure_map.call(null,map__72447);
var sub_chan = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__72447__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___72491 = arguments.length;
var i__5770__auto___72492 = (0);
while(true){
if((i__5770__auto___72492 < len__5769__auto___72491)){
args__5775__auto__.push((arguments[i__5770__auto___72492]));

var G__72493 = (i__5770__auto___72492 + (1));
i__5770__auto___72492 = G__72493;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__72450){
var vec__72451 = p__72450;
var opts = cljs.core.nth.call(null,vec__72451,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2706__auto___72494 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72474){
var state_val_72475 = (state_72474[(1)]);
if((state_val_72475 === (1))){
var inst_72454 = fluree.db.connection.get_socket.call(null,conn);
var state_72474__$1 = state_72474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72474__$1,(2),inst_72454);
} else {
if((state_val_72475 === (2))){
var inst_72456 = (state_72474[(7)]);
var inst_72457 = (state_72474[(8)]);
var inst_72456__$1 = (state_72474[(2)]);
var inst_72457__$1 = (inst_72456__$1 == null);
var state_72474__$1 = (function (){var statearr_72476 = state_72474;
(statearr_72476[(7)] = inst_72456__$1);

(statearr_72476[(8)] = inst_72457__$1);

return statearr_72476;
})();
if(cljs.core.truth_(inst_72457__$1)){
var statearr_72477_72495 = state_72474__$1;
(statearr_72477_72495[(1)] = (3));

} else {
var statearr_72478_72496 = state_72474__$1;
(statearr_72478_72496[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72475 === (3))){
var inst_72457 = (state_72474[(8)]);
var state_72474__$1 = state_72474;
var statearr_72479_72497 = state_72474__$1;
(statearr_72479_72497[(2)] = inst_72457);

(statearr_72479_72497[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72475 === (4))){
var inst_72456 = (state_72474[(7)]);
var inst_72460 = fluree.db.util.core.exception_QMARK_.call(null,inst_72456);
var state_72474__$1 = state_72474;
var statearr_72480_72498 = state_72474__$1;
(statearr_72480_72498[(2)] = inst_72460);

(statearr_72480_72498[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72475 === (5))){
var inst_72462 = (state_72474[(2)]);
var state_72474__$1 = state_72474;
if(cljs.core.truth_(inst_72462)){
var statearr_72481_72499 = state_72474__$1;
(statearr_72481_72499[(1)] = (6));

} else {
var statearr_72482_72500 = state_72474__$1;
(statearr_72482_72500[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72475 === (6))){
var inst_72456 = (state_72474[(7)]);
var inst_72464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72465 = [inst_72456,"Cannot establish connection to a healthy server, disconnecting."];
var inst_72466 = (new cljs.core.PersistentVector(null,2,(5),inst_72464,inst_72465,null));
var inst_72467 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72466);
var inst_72468 = cljs.core.async.close_BANG_.call(null,conn);
var state_72474__$1 = (function (){var statearr_72483 = state_72474;
(statearr_72483[(9)] = inst_72467);

return statearr_72483;
})();
var statearr_72484_72501 = state_72474__$1;
(statearr_72484_72501[(2)] = inst_72468);

(statearr_72484_72501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72475 === (7))){
var inst_72470 = fluree.db.connection.msg_consumer.call(null,conn);
var state_72474__$1 = state_72474;
var statearr_72485_72502 = state_72474__$1;
(statearr_72485_72502[(2)] = inst_72470);

(statearr_72485_72502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72475 === (8))){
var inst_72472 = (state_72474[(2)]);
var state_72474__$1 = state_72474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72474__$1,inst_72472);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_72486 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72486[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_72486[(1)] = (1));

return statearr_72486;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_72474){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_72474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72487){var ex__2687__auto__ = e72487;
var statearr_72488_72503 = state_72474;
(statearr_72488_72503[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_72474[(4)]))){
var statearr_72489_72504 = state_72474;
(statearr_72489_72504[(1)] = cljs.core.first.call(null,(state_72474[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72505 = state_72474;
state_72474 = G__72505;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_72474){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_72474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72490 = f__2707__auto__.call(null);
(statearr_72490[(6)] = c__2706__auto___72494);

return statearr_72490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq72448){
var G__72449 = cljs.core.first.call(null,seq72448);
var seq72448__$1 = cljs.core.next.call(null,seq72448);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72449,seq72448__$1);
}));

