// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___63120 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63157){
var state_val_63158 = (state_63157[(1)]);
if((state_val_63158 === (7))){
var inst_63152 = (state_63157[(2)]);
var _ = (function (){var statearr_63159 = state_63157;
(statearr_63159[(4)] = cljs.core.rest.call(null,(state_63157[(4)])));

return statearr_63159;
})();
var state_63157__$1 = state_63157;
var statearr_63160_63187 = state_63157__$1;
(statearr_63160_63187[(2)] = inst_63152);

(statearr_63160_63187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (1))){
var state_63157__$1 = state_63157;
var statearr_63161_63188 = state_63157__$1;
(statearr_63161_63188[(2)] = null);

(statearr_63161_63188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (4))){
var inst_63121 = (state_63157[(2)]);
var state_63157__$1 = state_63157;
var statearr_63162_63189 = state_63157__$1;
(statearr_63162_63189[(2)] = inst_63121);

(statearr_63162_63189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (13))){
var inst_63148 = (state_63157[(2)]);
var state_63157__$1 = state_63157;
var statearr_63163_63190 = state_63157__$1;
(statearr_63163_63190[(2)] = inst_63148);

(statearr_63163_63190[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (6))){
var inst_63129 = (state_63157[(7)]);
var inst_63127 = (state_63157[(8)]);
var inst_63132 = cljs.core._EQ_.call(null,inst_63129,inst_63127);
var state_63157__$1 = state_63157;
if(inst_63132){
var statearr_63164_63191 = state_63157__$1;
(statearr_63164_63191[(1)] = (8));

} else {
var statearr_63165_63192 = state_63157__$1;
(statearr_63165_63192[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (3))){
var inst_63155 = (state_63157[(2)]);
var state_63157__$1 = state_63157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63157__$1,inst_63155);
} else {
if((state_val_63158 === (12))){
var inst_63130 = (state_63157[(9)]);
var inst_63136 = (state_63157[(10)]);
var inst_63135 = (state_63157[(11)]);
var inst_63145 = cljs.core.conj.call(null,inst_63130,inst_63135);
var inst_63129 = inst_63136;
var inst_63130__$1 = inst_63145;
var state_63157__$1 = (function (){var statearr_63166 = state_63157;
(statearr_63166[(7)] = inst_63129);

(statearr_63166[(9)] = inst_63130__$1);

return statearr_63166;
})();
var statearr_63167_63193 = state_63157__$1;
(statearr_63167_63193[(2)] = null);

(statearr_63167_63193[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (2))){
var _ = (function (){var statearr_63168 = state_63157;
(statearr_63168[(4)] = cljs.core.cons.call(null,(5),(state_63157[(4)])));

return statearr_63168;
})();
var inst_63127 = cljs.core.count.call(null,args);
var inst_63128 = cljs.core.PersistentVector.EMPTY;
var inst_63129 = (0);
var inst_63130 = inst_63128;
var state_63157__$1 = (function (){var statearr_63169 = state_63157;
(statearr_63169[(7)] = inst_63129);

(statearr_63169[(9)] = inst_63130);

(statearr_63169[(8)] = inst_63127);

return statearr_63169;
})();
var statearr_63170_63194 = state_63157__$1;
(statearr_63170_63194[(2)] = null);

(statearr_63170_63194[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (11))){
var inst_63135 = (state_63157[(11)]);
var state_63157__$1 = state_63157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63157__$1,(14),inst_63135);
} else {
if((state_val_63158 === (9))){
var inst_63129 = (state_63157[(7)]);
var inst_63135 = (state_63157[(11)]);
var inst_63135__$1 = cljs.core.nth.call(null,args,inst_63129);
var inst_63136 = (inst_63129 + (1));
var inst_63137 = fluree.db.util.async.channel_QMARK_.call(null,inst_63135__$1);
var state_63157__$1 = (function (){var statearr_63172 = state_63157;
(statearr_63172[(10)] = inst_63136);

(statearr_63172[(11)] = inst_63135__$1);

return statearr_63172;
})();
if(inst_63137){
var statearr_63173_63195 = state_63157__$1;
(statearr_63173_63195[(1)] = (11));

} else {
var statearr_63174_63196 = state_63157__$1;
(statearr_63174_63196[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (5))){
var _ = (function (){var statearr_63175 = state_63157;
(statearr_63175[(4)] = cljs.core.rest.call(null,(state_63157[(4)])));

return statearr_63175;
})();
var state_63157__$1 = state_63157;
var ex63171 = (state_63157__$1[(2)]);
var statearr_63176_63197 = state_63157__$1;
(statearr_63176_63197[(5)] = ex63171);


if((ex63171 instanceof Error)){
var statearr_63177_63198 = state_63157__$1;
(statearr_63177_63198[(1)] = (4));

(statearr_63177_63198[(5)] = null);

} else {
throw ex63171;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (14))){
var inst_63130 = (state_63157[(9)]);
var inst_63136 = (state_63157[(10)]);
var inst_63140 = (state_63157[(2)]);
var inst_63141 = fluree.db.util.async.throw_err.call(null,inst_63140);
var inst_63142 = cljs.core.conj.call(null,inst_63130,inst_63141);
var inst_63129 = inst_63136;
var inst_63130__$1 = inst_63142;
var state_63157__$1 = (function (){var statearr_63178 = state_63157;
(statearr_63178[(7)] = inst_63129);

(statearr_63178[(9)] = inst_63130__$1);

return statearr_63178;
})();
var statearr_63179_63199 = state_63157__$1;
(statearr_63179_63199[(2)] = null);

(statearr_63179_63199[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (10))){
var inst_63150 = (state_63157[(2)]);
var state_63157__$1 = state_63157;
var statearr_63180_63200 = state_63157__$1;
(statearr_63180_63200[(2)] = inst_63150);

(statearr_63180_63200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (8))){
var inst_63130 = (state_63157[(9)]);
var state_63157__$1 = state_63157;
var statearr_63181_63201 = state_63157__$1;
(statearr_63181_63201[(2)] = inst_63130);

(statearr_63181_63201[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0 = (function (){
var statearr_63182 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63182[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__);

(statearr_63182[(1)] = (1));

return statearr_63182;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1 = (function (state_63157){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63183){var ex__2687__auto__ = e63183;
var statearr_63184_63202 = state_63157;
(statearr_63184_63202[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63157[(4)]))){
var statearr_63185_63203 = state_63157;
(statearr_63185_63203[(1)] = cljs.core.first.call(null,(state_63157[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63204 = state_63157;
state_63157 = G__63204;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__ = function(state_63157){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1.call(this,state_63157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63186 = f__2707__auto__.call(null);
(statearr_63186[(6)] = c__2706__auto__);

return statearr_63186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__63206 = entry;
var res = cljs.core.nth.call(null,vec__63206,(0),null);
var cost = cljs.core.nth.call(null,vec__63206,(1),null);
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__63205_SHARP_){
return cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,p1__63205_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63254){
var state_val_63255 = (state_63254[(1)]);
if((state_val_63255 === (7))){
var state_63254__$1 = state_63254;
var statearr_63256_63285 = state_63254__$1;
(statearr_63256_63285[(2)] = coll);

(statearr_63256_63285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (1))){
var state_63254__$1 = state_63254;
var statearr_63257_63286 = state_63254__$1;
(statearr_63257_63286[(2)] = null);

(statearr_63257_63286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (4))){
var inst_63209 = (state_63254[(2)]);
var state_63254__$1 = state_63254;
var statearr_63258_63287 = state_63254__$1;
(statearr_63258_63287[(2)] = inst_63209);

(statearr_63258_63287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (15))){
var inst_63228 = (state_63254[(7)]);
var inst_63236 = (state_63254[(2)]);
var inst_63237 = fluree.db.dbfunctions.internal.nth.call(null,inst_63228,inst_63236);
var inst_63238 = cljs.core.count.call(null,inst_63228);
var inst_63239 = ((9) + inst_63238);
var inst_63240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63241 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63243 = [inst_63228,inst_63236];
var inst_63244 = (new cljs.core.PersistentVector(null,2,(5),inst_63242,inst_63243,null));
var inst_63245 = ["nth",inst_63244,inst_63237];
var inst_63246 = cljs.core.PersistentHashMap.fromArrays(inst_63241,inst_63245);
var inst_63247 = [inst_63246,inst_63239];
var inst_63248 = (new cljs.core.PersistentVector(null,2,(5),inst_63240,inst_63247,null));
var inst_63249 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63248);
var _ = (function (){var statearr_63259 = state_63254;
(statearr_63259[(4)] = cljs.core.rest.call(null,(state_63254[(4)])));

return statearr_63259;
})();
var state_63254__$1 = (function (){var statearr_63260 = state_63254;
(statearr_63260[(8)] = inst_63249);

return statearr_63260;
})();
var statearr_63261_63288 = state_63254__$1;
(statearr_63261_63288[(2)] = inst_63237);

(statearr_63261_63288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (13))){
var state_63254__$1 = state_63254;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63254__$1,(16),key);
} else {
if((state_val_63255 === (6))){
var state_63254__$1 = state_63254;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63254__$1,(9),coll);
} else {
if((state_val_63255 === (3))){
var inst_63252 = (state_63254[(2)]);
var state_63254__$1 = state_63254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63254__$1,inst_63252);
} else {
if((state_val_63255 === (12))){
var inst_63228 = (state_63254[(2)]);
var inst_63229 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_63254__$1 = (function (){var statearr_63262 = state_63254;
(statearr_63262[(7)] = inst_63228);

return statearr_63262;
})();
if(inst_63229){
var statearr_63263_63289 = state_63254__$1;
(statearr_63263_63289[(1)] = (13));

} else {
var statearr_63264_63290 = state_63254__$1;
(statearr_63264_63290[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (2))){
var _ = (function (){var statearr_63265 = state_63254;
(statearr_63265[(4)] = cljs.core.cons.call(null,(5),(state_63254[(4)])));

return statearr_63265;
})();
var inst_63215 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_63254__$1 = state_63254;
if(inst_63215){
var statearr_63266_63291 = state_63254__$1;
(statearr_63266_63291[(1)] = (6));

} else {
var statearr_63267_63292 = state_63254__$1;
(statearr_63267_63292[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (11))){
var inst_63222 = (state_63254[(9)]);
var state_63254__$1 = state_63254;
var statearr_63269_63293 = state_63254__$1;
(statearr_63269_63293[(2)] = inst_63222);

(statearr_63269_63293[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (9))){
var inst_63218 = (state_63254[(2)]);
var inst_63219 = fluree.db.util.async.throw_err.call(null,inst_63218);
var state_63254__$1 = state_63254;
var statearr_63270_63294 = state_63254__$1;
(statearr_63270_63294[(2)] = inst_63219);

(statearr_63270_63294[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (5))){
var _ = (function (){var statearr_63271 = state_63254;
(statearr_63271[(4)] = cljs.core.rest.call(null,(state_63254[(4)])));

return statearr_63271;
})();
var state_63254__$1 = state_63254;
var ex63268 = (state_63254__$1[(2)]);
var statearr_63272_63295 = state_63254__$1;
(statearr_63272_63295[(5)] = ex63268);


if((ex63268 instanceof Error)){
var statearr_63273_63296 = state_63254__$1;
(statearr_63273_63296[(1)] = (4));

(statearr_63273_63296[(5)] = null);

} else {
throw ex63268;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (14))){
var state_63254__$1 = state_63254;
var statearr_63274_63297 = state_63254__$1;
(statearr_63274_63297[(2)] = key);

(statearr_63274_63297[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (16))){
var inst_63232 = (state_63254[(2)]);
var inst_63233 = fluree.db.util.async.throw_err.call(null,inst_63232);
var state_63254__$1 = state_63254;
var statearr_63275_63298 = state_63254__$1;
(statearr_63275_63298[(2)] = inst_63233);

(statearr_63275_63298[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (10))){
var inst_63222 = (state_63254[(9)]);
var inst_63225 = cljs.core.vec.call(null,inst_63222);
var state_63254__$1 = state_63254;
var statearr_63276_63299 = state_63254__$1;
(statearr_63276_63299[(2)] = inst_63225);

(statearr_63276_63299[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63255 === (8))){
var inst_63222 = (state_63254[(9)]);
var inst_63222__$1 = (state_63254[(2)]);
var inst_63223 = cljs.core.set_QMARK_.call(null,inst_63222__$1);
var state_63254__$1 = (function (){var statearr_63277 = state_63254;
(statearr_63277[(9)] = inst_63222__$1);

return statearr_63277;
})();
if(inst_63223){
var statearr_63278_63300 = state_63254__$1;
(statearr_63278_63300[(1)] = (10));

} else {
var statearr_63279_63301 = state_63254__$1;
(statearr_63279_63301[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0 = (function (){
var statearr_63280 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63280[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__);

(statearr_63280[(1)] = (1));

return statearr_63280;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1 = (function (state_63254){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63281){var ex__2687__auto__ = e63281;
var statearr_63282_63302 = state_63254;
(statearr_63282_63302[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63254[(4)]))){
var statearr_63283_63303 = state_63254;
(statearr_63283_63303[(1)] = cljs.core.first.call(null,(state_63254[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63304 = state_63254;
state_63254 = G__63304;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__ = function(state_63254){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1.call(this,state_63254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63284 = f__2707__auto__.call(null);
(statearr_63284[(6)] = c__2706__auto__);

return statearr_63284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the first item in a collection
 */
fluree.db.dbfunctions.fns.first = (function fluree$db$dbfunctions$fns$first(_QMARK_ctx,coll){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63340){
var state_val_63341 = (state_63340[(1)]);
if((state_val_63341 === (7))){
var state_63340__$1 = state_63340;
var statearr_63342_63366 = state_63340__$1;
(statearr_63342_63366[(2)] = coll);

(statearr_63342_63366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63341 === (1))){
var state_63340__$1 = state_63340;
var statearr_63343_63367 = state_63340__$1;
(statearr_63343_63367[(2)] = null);

(statearr_63343_63367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63341 === (4))){
var inst_63305 = (state_63340[(2)]);
var state_63340__$1 = state_63340;
var statearr_63344_63368 = state_63340__$1;
(statearr_63344_63368[(2)] = inst_63305);

(statearr_63344_63368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63341 === (6))){
var state_63340__$1 = state_63340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63340__$1,(9),coll);
} else {
if((state_val_63341 === (3))){
var inst_63338 = (state_63340[(2)]);
var state_63340__$1 = state_63340;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63340__$1,inst_63338);
} else {
if((state_val_63341 === (12))){
var inst_63324 = (state_63340[(2)]);
var inst_63325 = fluree.db.dbfunctions.internal.first.call(null,inst_63324);
var inst_63326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63327 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63329 = [inst_63324];
var inst_63330 = (new cljs.core.PersistentVector(null,1,(5),inst_63328,inst_63329,null));
var inst_63331 = ["first",inst_63330,inst_63325];
var inst_63332 = cljs.core.PersistentHashMap.fromArrays(inst_63327,inst_63331);
var inst_63333 = [inst_63332,(10)];
var inst_63334 = (new cljs.core.PersistentVector(null,2,(5),inst_63326,inst_63333,null));
var inst_63335 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63334);
var _ = (function (){var statearr_63345 = state_63340;
(statearr_63345[(4)] = cljs.core.rest.call(null,(state_63340[(4)])));

return statearr_63345;
})();
var state_63340__$1 = (function (){var statearr_63346 = state_63340;
(statearr_63346[(7)] = inst_63335);

return statearr_63346;
})();
var statearr_63347_63369 = state_63340__$1;
(statearr_63347_63369[(2)] = inst_63325);

(statearr_63347_63369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63341 === (2))){
var _ = (function (){var statearr_63348 = state_63340;
(statearr_63348[(4)] = cljs.core.cons.call(null,(5),(state_63340[(4)])));

return statearr_63348;
})();
var inst_63311 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_63340__$1 = state_63340;
if(inst_63311){
var statearr_63349_63370 = state_63340__$1;
(statearr_63349_63370[(1)] = (6));

} else {
var statearr_63350_63371 = state_63340__$1;
(statearr_63350_63371[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63341 === (11))){
var inst_63318 = (state_63340[(8)]);
var state_63340__$1 = state_63340;
var statearr_63352_63372 = state_63340__$1;
(statearr_63352_63372[(2)] = inst_63318);

(statearr_63352_63372[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63341 === (9))){
var inst_63314 = (state_63340[(2)]);
var inst_63315 = fluree.db.util.async.throw_err.call(null,inst_63314);
var state_63340__$1 = state_63340;
var statearr_63353_63373 = state_63340__$1;
(statearr_63353_63373[(2)] = inst_63315);

(statearr_63353_63373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63341 === (5))){
var _ = (function (){var statearr_63354 = state_63340;
(statearr_63354[(4)] = cljs.core.rest.call(null,(state_63340[(4)])));

return statearr_63354;
})();
var state_63340__$1 = state_63340;
var ex63351 = (state_63340__$1[(2)]);
var statearr_63355_63374 = state_63340__$1;
(statearr_63355_63374[(5)] = ex63351);


if((ex63351 instanceof Error)){
var statearr_63356_63375 = state_63340__$1;
(statearr_63356_63375[(1)] = (4));

(statearr_63356_63375[(5)] = null);

} else {
throw ex63351;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63341 === (10))){
var inst_63318 = (state_63340[(8)]);
var inst_63321 = cljs.core.vec.call(null,inst_63318);
var state_63340__$1 = state_63340;
var statearr_63357_63376 = state_63340__$1;
(statearr_63357_63376[(2)] = inst_63321);

(statearr_63357_63376[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63341 === (8))){
var inst_63318 = (state_63340[(8)]);
var inst_63318__$1 = (state_63340[(2)]);
var inst_63319 = cljs.core.set_QMARK_.call(null,inst_63318__$1);
var state_63340__$1 = (function (){var statearr_63358 = state_63340;
(statearr_63358[(8)] = inst_63318__$1);

return statearr_63358;
})();
if(inst_63319){
var statearr_63359_63377 = state_63340__$1;
(statearr_63359_63377[(1)] = (10));

} else {
var statearr_63360_63378 = state_63340__$1;
(statearr_63360_63378[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____0 = (function (){
var statearr_63361 = [null,null,null,null,null,null,null,null,null];
(statearr_63361[(0)] = fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__);

(statearr_63361[(1)] = (1));

return statearr_63361;
});
var fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____1 = (function (state_63340){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63340);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63362){var ex__2687__auto__ = e63362;
var statearr_63363_63379 = state_63340;
(statearr_63363_63379[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63340[(4)]))){
var statearr_63364_63380 = state_63340;
(statearr_63364_63380[(1)] = cljs.core.first.call(null,(state_63340[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63381 = state_63340;
state_63340 = G__63381;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__ = function(state_63340){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____1.call(this,state_63340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63365 = f__2707__auto__.call(null);
(statearr_63365[(6)] = c__2706__auto__);

return statearr_63365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63442){
var state_val_63443 = (state_63442[(1)]);
if((state_val_63443 === (7))){
var state_63442__$1 = state_63442;
var statearr_63444_63478 = state_63442__$1;
(statearr_63444_63478[(2)] = test);

(statearr_63444_63478[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (20))){
var inst_63416 = (state_63442[(2)]);
var inst_63417 = fluree.db.util.async.throw_err.call(null,inst_63416);
var state_63442__$1 = state_63442;
var statearr_63445_63479 = state_63442__$1;
(statearr_63445_63479[(2)] = inst_63417);

(statearr_63445_63479[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (1))){
var state_63442__$1 = state_63442;
var statearr_63446_63480 = state_63442__$1;
(statearr_63446_63480[(2)] = null);

(statearr_63446_63480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (4))){
var inst_63382 = (state_63442[(2)]);
var state_63442__$1 = state_63442;
var statearr_63447_63481 = state_63442__$1;
(statearr_63447_63481[(2)] = inst_63382);

(statearr_63447_63481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (15))){
var inst_63400 = (state_63442[(7)]);
var inst_63408 = (state_63442[(2)]);
var inst_63409 = [inst_63408,f];
var inst_63410 = (new cljs.core.PersistentVector(null,2,(5),inst_63400,inst_63409,null));
var state_63442__$1 = state_63442;
var statearr_63448_63482 = state_63442__$1;
(statearr_63448_63482[(2)] = inst_63410);

(statearr_63448_63482[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (13))){
var state_63442__$1 = state_63442;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63442__$1,(16),t);
} else {
if((state_val_63443 === (6))){
var state_63442__$1 = state_63442;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63442__$1,(9),test);
} else {
if((state_val_63443 === (17))){
var state_63442__$1 = state_63442;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63442__$1,(20),f);
} else {
if((state_val_63443 === (3))){
var inst_63440 = (state_63442[(2)]);
var state_63442__$1 = state_63442;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63442__$1,inst_63440);
} else {
if((state_val_63443 === (12))){
var inst_63398 = (state_63442[(8)]);
var inst_63424 = (state_63442[(2)]);
var inst_63425 = cljs.core.nth.call(null,inst_63424,(0),null);
var inst_63426 = cljs.core.nth.call(null,inst_63424,(1),null);
var inst_63427 = fluree.db.dbfunctions.internal.if_else.call(null,inst_63398,inst_63425,inst_63426);
var inst_63428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63429 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63431 = [inst_63398,inst_63425,inst_63426];
var inst_63432 = (new cljs.core.PersistentVector(null,3,(5),inst_63430,inst_63431,null));
var inst_63433 = ["if-else",inst_63432,inst_63427];
var inst_63434 = cljs.core.PersistentHashMap.fromArrays(inst_63429,inst_63433);
var inst_63435 = [inst_63434,(10)];
var inst_63436 = (new cljs.core.PersistentVector(null,2,(5),inst_63428,inst_63435,null));
var inst_63437 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63436);
var _ = (function (){var statearr_63449 = state_63442;
(statearr_63449[(4)] = cljs.core.rest.call(null,(state_63442[(4)])));

return statearr_63449;
})();
var state_63442__$1 = (function (){var statearr_63450 = state_63442;
(statearr_63450[(9)] = inst_63437);

return statearr_63450;
})();
var statearr_63451_63483 = state_63442__$1;
(statearr_63451_63483[(2)] = inst_63427);

(statearr_63451_63483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (2))){
var _ = (function (){var statearr_63452 = state_63442;
(statearr_63452[(4)] = cljs.core.cons.call(null,(5),(state_63442[(4)])));

return statearr_63452;
})();
var inst_63391 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_63442__$1 = state_63442;
if(inst_63391){
var statearr_63453_63484 = state_63442__$1;
(statearr_63453_63484[(1)] = (6));

} else {
var statearr_63454_63485 = state_63442__$1;
(statearr_63454_63485[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (19))){
var inst_63412 = (state_63442[(10)]);
var inst_63420 = (state_63442[(2)]);
var inst_63421 = [f,inst_63420];
var inst_63422 = (new cljs.core.PersistentVector(null,2,(5),inst_63412,inst_63421,null));
var state_63442__$1 = state_63442;
var statearr_63455_63486 = state_63442__$1;
(statearr_63455_63486[(2)] = inst_63422);

(statearr_63455_63486[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (11))){
var inst_63412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63413 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_63442__$1 = (function (){var statearr_63457 = state_63442;
(statearr_63457[(10)] = inst_63412);

return statearr_63457;
})();
if(inst_63413){
var statearr_63458_63487 = state_63442__$1;
(statearr_63458_63487[(1)] = (17));

} else {
var statearr_63459_63488 = state_63442__$1;
(statearr_63459_63488[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (9))){
var inst_63394 = (state_63442[(2)]);
var inst_63395 = fluree.db.util.async.throw_err.call(null,inst_63394);
var state_63442__$1 = state_63442;
var statearr_63460_63489 = state_63442__$1;
(statearr_63460_63489[(2)] = inst_63395);

(statearr_63460_63489[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (5))){
var _ = (function (){var statearr_63461 = state_63442;
(statearr_63461[(4)] = cljs.core.rest.call(null,(state_63442[(4)])));

return statearr_63461;
})();
var state_63442__$1 = state_63442;
var ex63456 = (state_63442__$1[(2)]);
var statearr_63462_63490 = state_63442__$1;
(statearr_63462_63490[(5)] = ex63456);


if((ex63456 instanceof Error)){
var statearr_63463_63491 = state_63442__$1;
(statearr_63463_63491[(1)] = (4));

(statearr_63463_63491[(5)] = null);

} else {
throw ex63456;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (14))){
var state_63442__$1 = state_63442;
var statearr_63464_63492 = state_63442__$1;
(statearr_63464_63492[(2)] = t);

(statearr_63464_63492[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (16))){
var inst_63404 = (state_63442[(2)]);
var inst_63405 = fluree.db.util.async.throw_err.call(null,inst_63404);
var state_63442__$1 = state_63442;
var statearr_63465_63493 = state_63442__$1;
(statearr_63465_63493[(2)] = inst_63405);

(statearr_63465_63493[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (10))){
var inst_63400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63401 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_63442__$1 = (function (){var statearr_63466 = state_63442;
(statearr_63466[(7)] = inst_63400);

return statearr_63466;
})();
if(inst_63401){
var statearr_63467_63494 = state_63442__$1;
(statearr_63467_63494[(1)] = (13));

} else {
var statearr_63468_63495 = state_63442__$1;
(statearr_63468_63495[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (18))){
var state_63442__$1 = state_63442;
var statearr_63469_63496 = state_63442__$1;
(statearr_63469_63496[(2)] = f);

(statearr_63469_63496[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63443 === (8))){
var inst_63398 = (state_63442[(8)]);
var inst_63398__$1 = (state_63442[(2)]);
var state_63442__$1 = (function (){var statearr_63470 = state_63442;
(statearr_63470[(8)] = inst_63398__$1);

return statearr_63470;
})();
if(cljs.core.truth_(inst_63398__$1)){
var statearr_63471_63497 = state_63442__$1;
(statearr_63471_63497[(1)] = (10));

} else {
var statearr_63472_63498 = state_63442__$1;
(statearr_63472_63498[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0 = (function (){
var statearr_63473 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63473[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__);

(statearr_63473[(1)] = (1));

return statearr_63473;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1 = (function (state_63442){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63442);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63474){var ex__2687__auto__ = e63474;
var statearr_63475_63499 = state_63442;
(statearr_63475_63499[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63442[(4)]))){
var statearr_63476_63500 = state_63442;
(statearr_63476_63500[(1)] = cljs.core.first.call(null,(state_63442[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63501 = state_63442;
state_63442 = G__63501;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__ = function(state_63442){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1.call(this,state_63442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63477 = f__2707__auto__.call(null);
(statearr_63477[(6)] = c__2706__auto__);

return statearr_63477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63531){
var state_val_63532 = (state_63531[(1)]);
if((state_val_63532 === (7))){
var state_63531__$1 = state_63531;
var statearr_63533_63552 = state_63531__$1;
(statearr_63533_63552[(2)] = arg);

(statearr_63533_63552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63532 === (1))){
var state_63531__$1 = state_63531;
var statearr_63534_63553 = state_63531__$1;
(statearr_63534_63553[(2)] = null);

(statearr_63534_63553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63532 === (4))){
var inst_63502 = (state_63531[(2)]);
var state_63531__$1 = state_63531;
var statearr_63535_63554 = state_63531__$1;
(statearr_63535_63554[(2)] = inst_63502);

(statearr_63535_63554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63532 === (6))){
var state_63531__$1 = state_63531;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63531__$1,(9),arg);
} else {
if((state_val_63532 === (3))){
var inst_63529 = (state_63531[(2)]);
var state_63531__$1 = state_63531;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63531__$1,inst_63529);
} else {
if((state_val_63532 === (2))){
var _ = (function (){var statearr_63537 = state_63531;
(statearr_63537[(4)] = cljs.core.cons.call(null,(5),(state_63531[(4)])));

return statearr_63537;
})();
var inst_63508 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_63531__$1 = state_63531;
if(inst_63508){
var statearr_63538_63555 = state_63531__$1;
(statearr_63538_63555[(1)] = (6));

} else {
var statearr_63539_63556 = state_63531__$1;
(statearr_63539_63556[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63532 === (9))){
var inst_63511 = (state_63531[(2)]);
var inst_63512 = fluree.db.util.async.throw_err.call(null,inst_63511);
var state_63531__$1 = state_63531;
var statearr_63540_63557 = state_63531__$1;
(statearr_63540_63557[(2)] = inst_63512);

(statearr_63540_63557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63532 === (5))){
var _ = (function (){var statearr_63541 = state_63531;
(statearr_63541[(4)] = cljs.core.rest.call(null,(state_63531[(4)])));

return statearr_63541;
})();
var state_63531__$1 = state_63531;
var ex63536 = (state_63531__$1[(2)]);
var statearr_63542_63558 = state_63531__$1;
(statearr_63542_63558[(5)] = ex63536);


if((ex63536 instanceof Error)){
var statearr_63543_63559 = state_63531__$1;
(statearr_63543_63559[(1)] = (4));

(statearr_63543_63559[(5)] = null);

} else {
throw ex63536;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63532 === (8))){
var inst_63515 = (state_63531[(2)]);
var inst_63516 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_63515);
var inst_63517 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63518 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63520 = [inst_63515];
var inst_63521 = (new cljs.core.PersistentVector(null,1,(5),inst_63519,inst_63520,null));
var inst_63522 = ["nil?",inst_63521,inst_63516];
var inst_63523 = cljs.core.PersistentHashMap.fromArrays(inst_63518,inst_63522);
var inst_63524 = [inst_63523,(10)];
var inst_63525 = (new cljs.core.PersistentVector(null,2,(5),inst_63517,inst_63524,null));
var inst_63526 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63525);
var _ = (function (){var statearr_63544 = state_63531;
(statearr_63544[(4)] = cljs.core.rest.call(null,(state_63531[(4)])));

return statearr_63544;
})();
var state_63531__$1 = (function (){var statearr_63545 = state_63531;
(statearr_63545[(7)] = inst_63526);

return statearr_63545;
})();
var statearr_63546_63560 = state_63531__$1;
(statearr_63546_63560[(2)] = inst_63516);

(statearr_63546_63560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_63547 = [null,null,null,null,null,null,null,null];
(statearr_63547[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__);

(statearr_63547[(1)] = (1));

return statearr_63547;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1 = (function (state_63531){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63531);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63548){var ex__2687__auto__ = e63548;
var statearr_63549_63561 = state_63531;
(statearr_63549_63561[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63531[(4)]))){
var statearr_63550_63562 = state_63531;
(statearr_63550_63562[(1)] = cljs.core.first.call(null,(state_63531[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63563 = state_63531;
state_63531 = G__63563;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__ = function(state_63531){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1.call(this,state_63531);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63551 = f__2707__auto__.call(null);
(statearr_63551[(6)] = c__2706__auto__);

return statearr_63551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63593){
var state_val_63594 = (state_63593[(1)]);
if((state_val_63594 === (7))){
var state_63593__$1 = state_63593;
var statearr_63595_63614 = state_63593__$1;
(statearr_63595_63614[(2)] = arg);

(statearr_63595_63614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63594 === (1))){
var state_63593__$1 = state_63593;
var statearr_63596_63615 = state_63593__$1;
(statearr_63596_63615[(2)] = null);

(statearr_63596_63615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63594 === (4))){
var inst_63564 = (state_63593[(2)]);
var state_63593__$1 = state_63593;
var statearr_63597_63616 = state_63593__$1;
(statearr_63597_63616[(2)] = inst_63564);

(statearr_63597_63616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63594 === (6))){
var state_63593__$1 = state_63593;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63593__$1,(9),arg);
} else {
if((state_val_63594 === (3))){
var inst_63591 = (state_63593[(2)]);
var state_63593__$1 = state_63593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63593__$1,inst_63591);
} else {
if((state_val_63594 === (2))){
var _ = (function (){var statearr_63599 = state_63593;
(statearr_63599[(4)] = cljs.core.cons.call(null,(5),(state_63593[(4)])));

return statearr_63599;
})();
var inst_63570 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_63593__$1 = state_63593;
if(inst_63570){
var statearr_63600_63617 = state_63593__$1;
(statearr_63600_63617[(1)] = (6));

} else {
var statearr_63601_63618 = state_63593__$1;
(statearr_63601_63618[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63594 === (9))){
var inst_63573 = (state_63593[(2)]);
var inst_63574 = fluree.db.util.async.throw_err.call(null,inst_63573);
var state_63593__$1 = state_63593;
var statearr_63602_63619 = state_63593__$1;
(statearr_63602_63619[(2)] = inst_63574);

(statearr_63602_63619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63594 === (5))){
var _ = (function (){var statearr_63603 = state_63593;
(statearr_63603[(4)] = cljs.core.rest.call(null,(state_63593[(4)])));

return statearr_63603;
})();
var state_63593__$1 = state_63593;
var ex63598 = (state_63593__$1[(2)]);
var statearr_63604_63620 = state_63593__$1;
(statearr_63604_63620[(5)] = ex63598);


if((ex63598 instanceof Error)){
var statearr_63605_63621 = state_63593__$1;
(statearr_63605_63621[(1)] = (4));

(statearr_63605_63621[(5)] = null);

} else {
throw ex63598;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63594 === (8))){
var inst_63577 = (state_63593[(2)]);
var inst_63578 = fluree.db.dbfunctions.internal.not.call(null,inst_63577);
var inst_63579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63580 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63582 = [inst_63577];
var inst_63583 = (new cljs.core.PersistentVector(null,1,(5),inst_63581,inst_63582,null));
var inst_63584 = ["not",inst_63583,inst_63578];
var inst_63585 = cljs.core.PersistentHashMap.fromArrays(inst_63580,inst_63584);
var inst_63586 = [inst_63585,(10)];
var inst_63587 = (new cljs.core.PersistentVector(null,2,(5),inst_63579,inst_63586,null));
var inst_63588 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63587);
var _ = (function (){var statearr_63606 = state_63593;
(statearr_63606[(4)] = cljs.core.rest.call(null,(state_63593[(4)])));

return statearr_63606;
})();
var state_63593__$1 = (function (){var statearr_63607 = state_63593;
(statearr_63607[(7)] = inst_63588);

return statearr_63607;
})();
var statearr_63608_63622 = state_63593__$1;
(statearr_63608_63622[(2)] = inst_63578);

(statearr_63608_63622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0 = (function (){
var statearr_63609 = [null,null,null,null,null,null,null,null];
(statearr_63609[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__);

(statearr_63609[(1)] = (1));

return statearr_63609;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1 = (function (state_63593){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63610){var ex__2687__auto__ = e63610;
var statearr_63611_63623 = state_63593;
(statearr_63611_63623[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63593[(4)]))){
var statearr_63612_63624 = state_63593;
(statearr_63612_63624[(1)] = cljs.core.first.call(null,(state_63593[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63625 = state_63593;
state_63593 = G__63625;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__ = function(state_63593){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1.call(this,state_63593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63613 = f__2707__auto__.call(null);
(statearr_63613[(6)] = c__2706__auto__);

return statearr_63613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63655){
var state_val_63656 = (state_63655[(1)]);
if((state_val_63656 === (7))){
var state_63655__$1 = state_63655;
var statearr_63657_63676 = state_63655__$1;
(statearr_63657_63676[(2)] = arg);

(statearr_63657_63676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63656 === (1))){
var state_63655__$1 = state_63655;
var statearr_63658_63677 = state_63655__$1;
(statearr_63658_63677[(2)] = null);

(statearr_63658_63677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63656 === (4))){
var inst_63626 = (state_63655[(2)]);
var state_63655__$1 = state_63655;
var statearr_63659_63678 = state_63655__$1;
(statearr_63659_63678[(2)] = inst_63626);

(statearr_63659_63678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63656 === (6))){
var state_63655__$1 = state_63655;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63655__$1,(9),arg);
} else {
if((state_val_63656 === (3))){
var inst_63653 = (state_63655[(2)]);
var state_63655__$1 = state_63655;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63655__$1,inst_63653);
} else {
if((state_val_63656 === (2))){
var _ = (function (){var statearr_63661 = state_63655;
(statearr_63661[(4)] = cljs.core.cons.call(null,(5),(state_63655[(4)])));

return statearr_63661;
})();
var inst_63632 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_63655__$1 = state_63655;
if(inst_63632){
var statearr_63662_63679 = state_63655__$1;
(statearr_63662_63679[(1)] = (6));

} else {
var statearr_63663_63680 = state_63655__$1;
(statearr_63663_63680[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63656 === (9))){
var inst_63635 = (state_63655[(2)]);
var inst_63636 = fluree.db.util.async.throw_err.call(null,inst_63635);
var state_63655__$1 = state_63655;
var statearr_63664_63681 = state_63655__$1;
(statearr_63664_63681[(2)] = inst_63636);

(statearr_63664_63681[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63656 === (5))){
var _ = (function (){var statearr_63665 = state_63655;
(statearr_63665[(4)] = cljs.core.rest.call(null,(state_63655[(4)])));

return statearr_63665;
})();
var state_63655__$1 = state_63655;
var ex63660 = (state_63655__$1[(2)]);
var statearr_63666_63682 = state_63655__$1;
(statearr_63666_63682[(5)] = ex63660);


if((ex63660 instanceof Error)){
var statearr_63667_63683 = state_63655__$1;
(statearr_63667_63683[(1)] = (4));

(statearr_63667_63683[(5)] = null);

} else {
throw ex63660;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63656 === (8))){
var inst_63639 = (state_63655[(2)]);
var inst_63640 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_63639);
var inst_63641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63642 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63644 = [inst_63639];
var inst_63645 = (new cljs.core.PersistentVector(null,1,(5),inst_63643,inst_63644,null));
var inst_63646 = ["empty?",inst_63645,inst_63640];
var inst_63647 = cljs.core.PersistentHashMap.fromArrays(inst_63642,inst_63646);
var inst_63648 = [inst_63647,(10)];
var inst_63649 = (new cljs.core.PersistentVector(null,2,(5),inst_63641,inst_63648,null));
var inst_63650 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63649);
var _ = (function (){var statearr_63668 = state_63655;
(statearr_63668[(4)] = cljs.core.rest.call(null,(state_63655[(4)])));

return statearr_63668;
})();
var state_63655__$1 = (function (){var statearr_63669 = state_63655;
(statearr_63669[(7)] = inst_63650);

return statearr_63669;
})();
var statearr_63670_63684 = state_63655__$1;
(statearr_63670_63684[(2)] = inst_63640);

(statearr_63670_63684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_63671 = [null,null,null,null,null,null,null,null];
(statearr_63671[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__);

(statearr_63671[(1)] = (1));

return statearr_63671;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1 = (function (state_63655){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63655);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63672){var ex__2687__auto__ = e63672;
var statearr_63673_63685 = state_63655;
(statearr_63673_63685[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63655[(4)]))){
var statearr_63674_63686 = state_63655;
(statearr_63674_63686[(1)] = cljs.core.first.call(null,(state_63655[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63687 = state_63655;
state_63655 = G__63687;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__ = function(state_63655){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1.call(this,state_63655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63675 = f__2707__auto__.call(null);
(statearr_63675[(6)] = c__2706__auto__);

return statearr_63675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___63732 = arguments.length;
var i__5770__auto___63733 = (0);
while(true){
if((i__5770__auto___63733 < len__5769__auto___63732)){
args__5775__auto__.push((arguments[i__5770__auto___63733]));

var G__63734 = (i__5770__auto___63733 + (1));
i__5770__auto___63733 = G__63734;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63715){
var state_val_63716 = (state_63715[(1)]);
if((state_val_63716 === (1))){
var state_63715__$1 = state_63715;
var statearr_63717_63735 = state_63715__$1;
(statearr_63717_63735[(2)] = null);

(statearr_63717_63735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63716 === (2))){
var _ = (function (){var statearr_63718 = state_63715;
(statearr_63718[(4)] = cljs.core.cons.call(null,(5),(state_63715[(4)])));

return statearr_63718;
})();
var inst_63696 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63715__$1 = state_63715;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63715__$1,(6),inst_63696);
} else {
if((state_val_63716 === (3))){
var inst_63713 = (state_63715[(2)]);
var state_63715__$1 = state_63715;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63715__$1,inst_63713);
} else {
if((state_val_63716 === (4))){
var inst_63690 = (state_63715[(2)]);
var state_63715__$1 = state_63715;
var statearr_63720_63736 = state_63715__$1;
(statearr_63720_63736[(2)] = inst_63690);

(statearr_63720_63736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63716 === (5))){
var _ = (function (){var statearr_63721 = state_63715;
(statearr_63721[(4)] = cljs.core.rest.call(null,(state_63715[(4)])));

return statearr_63721;
})();
var state_63715__$1 = state_63715;
var ex63719 = (state_63715__$1[(2)]);
var statearr_63722_63737 = state_63715__$1;
(statearr_63722_63737[(5)] = ex63719);


if((ex63719 instanceof Error)){
var statearr_63723_63738 = state_63715__$1;
(statearr_63723_63738[(1)] = (4));

(statearr_63723_63738[(5)] = null);

} else {
throw ex63719;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63716 === (6))){
var inst_63698 = (state_63715[(2)]);
var inst_63699 = fluree.db.util.async.throw_err.call(null,inst_63698);
var inst_63700 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_63699);
var inst_63701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63702 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63704 = [inst_63699];
var inst_63705 = (new cljs.core.PersistentVector(null,1,(5),inst_63703,inst_63704,null));
var inst_63706 = ["str",inst_63705,inst_63700];
var inst_63707 = cljs.core.PersistentHashMap.fromArrays(inst_63702,inst_63706);
var inst_63708 = [inst_63707,(10)];
var inst_63709 = (new cljs.core.PersistentVector(null,2,(5),inst_63701,inst_63708,null));
var inst_63710 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63709);
var _ = (function (){var statearr_63724 = state_63715;
(statearr_63724[(4)] = cljs.core.rest.call(null,(state_63715[(4)])));

return statearr_63724;
})();
var state_63715__$1 = (function (){var statearr_63725 = state_63715;
(statearr_63725[(7)] = inst_63710);

return statearr_63725;
})();
var statearr_63726_63739 = state_63715__$1;
(statearr_63726_63739[(2)] = inst_63700);

(statearr_63726_63739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_63727 = [null,null,null,null,null,null,null,null];
(statearr_63727[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_63727[(1)] = (1));

return statearr_63727;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_63715){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63715);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63728){var ex__2687__auto__ = e63728;
var statearr_63729_63740 = state_63715;
(statearr_63729_63740[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63715[(4)]))){
var statearr_63730_63741 = state_63715;
(statearr_63730_63741[(1)] = cljs.core.first.call(null,(state_63715[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63742 = state_63715;
state_63715 = G__63742;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_63715){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_63715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63731 = f__2707__auto__.call(null);
(statearr_63731[(6)] = c__2706__auto__);

return statearr_63731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq63688){
var G__63689 = cljs.core.first.call(null,seq63688);
var seq63688__$1 = cljs.core.next.call(null,seq63688);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63689,seq63688__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63768){
var state_val_63769 = (state_63768[(1)]);
if((state_val_63769 === (1))){
var state_63768__$1 = state_63768;
var statearr_63770_63785 = state_63768__$1;
(statearr_63770_63785[(2)] = null);

(statearr_63770_63785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (2))){
var _ = (function (){var statearr_63771 = state_63768;
(statearr_63771[(4)] = cljs.core.cons.call(null,(5),(state_63768[(4)])));

return statearr_63771;
})();
var inst_63749 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63768__$1 = state_63768;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63768__$1,(6),inst_63749);
} else {
if((state_val_63769 === (3))){
var inst_63766 = (state_63768[(2)]);
var state_63768__$1 = state_63768;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63768__$1,inst_63766);
} else {
if((state_val_63769 === (4))){
var inst_63743 = (state_63768[(2)]);
var state_63768__$1 = state_63768;
var statearr_63773_63786 = state_63768__$1;
(statearr_63773_63786[(2)] = inst_63743);

(statearr_63773_63786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (5))){
var _ = (function (){var statearr_63774 = state_63768;
(statearr_63774[(4)] = cljs.core.rest.call(null,(state_63768[(4)])));

return statearr_63774;
})();
var state_63768__$1 = state_63768;
var ex63772 = (state_63768__$1[(2)]);
var statearr_63775_63787 = state_63768__$1;
(statearr_63775_63787[(5)] = ex63772);


if((ex63772 instanceof Error)){
var statearr_63776_63788 = state_63768__$1;
(statearr_63776_63788[(1)] = (4));

(statearr_63776_63788[(5)] = null);

} else {
throw ex63772;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (6))){
var inst_63751 = (state_63768[(2)]);
var inst_63752 = fluree.db.util.async.throw_err.call(null,inst_63751);
var inst_63753 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_63752);
var inst_63754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63755 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63757 = [inst_63752];
var inst_63758 = (new cljs.core.PersistentVector(null,1,(5),inst_63756,inst_63757,null));
var inst_63759 = ["subs",inst_63758,inst_63753];
var inst_63760 = cljs.core.PersistentHashMap.fromArrays(inst_63755,inst_63759);
var inst_63761 = [inst_63760,(30)];
var inst_63762 = (new cljs.core.PersistentVector(null,2,(5),inst_63754,inst_63761,null));
var inst_63763 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63762);
var _ = (function (){var statearr_63777 = state_63768;
(statearr_63777[(4)] = cljs.core.rest.call(null,(state_63768[(4)])));

return statearr_63777;
})();
var state_63768__$1 = (function (){var statearr_63778 = state_63768;
(statearr_63778[(7)] = inst_63763);

return statearr_63778;
})();
var statearr_63779_63789 = state_63768__$1;
(statearr_63779_63789[(2)] = inst_63753);

(statearr_63779_63789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0 = (function (){
var statearr_63780 = [null,null,null,null,null,null,null,null];
(statearr_63780[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__);

(statearr_63780[(1)] = (1));

return statearr_63780;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1 = (function (state_63768){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63768);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63781){var ex__2687__auto__ = e63781;
var statearr_63782_63790 = state_63768;
(statearr_63782_63790[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63768[(4)]))){
var statearr_63783_63791 = state_63768;
(statearr_63783_63791[(1)] = cljs.core.first.call(null,(state_63768[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63792 = state_63768;
state_63768 = G__63792;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__ = function(state_63768){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1.call(this,state_63768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63784 = f__2707__auto__.call(null);
(statearr_63784[(6)] = c__2706__auto__);

return statearr_63784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63822){
var state_val_63823 = (state_63822[(1)]);
if((state_val_63823 === (7))){
var state_63822__$1 = state_63822;
var statearr_63824_63843 = state_63822__$1;
(statearr_63824_63843[(2)] = str);

(statearr_63824_63843[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63823 === (1))){
var state_63822__$1 = state_63822;
var statearr_63825_63844 = state_63822__$1;
(statearr_63825_63844[(2)] = null);

(statearr_63825_63844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63823 === (4))){
var inst_63793 = (state_63822[(2)]);
var state_63822__$1 = state_63822;
var statearr_63826_63845 = state_63822__$1;
(statearr_63826_63845[(2)] = inst_63793);

(statearr_63826_63845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63823 === (6))){
var state_63822__$1 = state_63822;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63822__$1,(9),str);
} else {
if((state_val_63823 === (3))){
var inst_63820 = (state_63822[(2)]);
var state_63822__$1 = state_63822;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63822__$1,inst_63820);
} else {
if((state_val_63823 === (2))){
var _ = (function (){var statearr_63828 = state_63822;
(statearr_63828[(4)] = cljs.core.cons.call(null,(5),(state_63822[(4)])));

return statearr_63828;
})();
var inst_63799 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_63822__$1 = state_63822;
if(inst_63799){
var statearr_63829_63846 = state_63822__$1;
(statearr_63829_63846[(1)] = (6));

} else {
var statearr_63830_63847 = state_63822__$1;
(statearr_63830_63847[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63823 === (9))){
var inst_63802 = (state_63822[(2)]);
var inst_63803 = fluree.db.util.async.throw_err.call(null,inst_63802);
var state_63822__$1 = state_63822;
var statearr_63831_63848 = state_63822__$1;
(statearr_63831_63848[(2)] = inst_63803);

(statearr_63831_63848[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63823 === (5))){
var _ = (function (){var statearr_63832 = state_63822;
(statearr_63832[(4)] = cljs.core.rest.call(null,(state_63822[(4)])));

return statearr_63832;
})();
var state_63822__$1 = state_63822;
var ex63827 = (state_63822__$1[(2)]);
var statearr_63833_63849 = state_63822__$1;
(statearr_63833_63849[(5)] = ex63827);


if((ex63827 instanceof Error)){
var statearr_63834_63850 = state_63822__$1;
(statearr_63834_63850[(1)] = (4));

(statearr_63834_63850[(5)] = null);

} else {
throw ex63827;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63823 === (8))){
var inst_63806 = (state_63822[(2)]);
var inst_63807 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_63806);
var inst_63808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63809 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63811 = [inst_63806];
var inst_63812 = (new cljs.core.PersistentVector(null,1,(5),inst_63810,inst_63811,null));
var inst_63813 = ["lower-case",inst_63812,inst_63807];
var inst_63814 = cljs.core.PersistentHashMap.fromArrays(inst_63809,inst_63813);
var inst_63815 = [inst_63814,(10)];
var inst_63816 = (new cljs.core.PersistentVector(null,2,(5),inst_63808,inst_63815,null));
var inst_63817 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63816);
var _ = (function (){var statearr_63835 = state_63822;
(statearr_63835[(4)] = cljs.core.rest.call(null,(state_63822[(4)])));

return statearr_63835;
})();
var state_63822__$1 = (function (){var statearr_63836 = state_63822;
(statearr_63836[(7)] = inst_63817);

return statearr_63836;
})();
var statearr_63837_63851 = state_63822__$1;
(statearr_63837_63851[(2)] = inst_63807);

(statearr_63837_63851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0 = (function (){
var statearr_63838 = [null,null,null,null,null,null,null,null];
(statearr_63838[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__);

(statearr_63838[(1)] = (1));

return statearr_63838;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1 = (function (state_63822){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63822);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63839){var ex__2687__auto__ = e63839;
var statearr_63840_63852 = state_63822;
(statearr_63840_63852[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63822[(4)]))){
var statearr_63841_63853 = state_63822;
(statearr_63841_63853[(1)] = cljs.core.first.call(null,(state_63822[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63854 = state_63822;
state_63822 = G__63854;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__ = function(state_63822){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1.call(this,state_63822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63842 = f__2707__auto__.call(null);
(statearr_63842[(6)] = c__2706__auto__);

return statearr_63842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63884){
var state_val_63885 = (state_63884[(1)]);
if((state_val_63885 === (7))){
var state_63884__$1 = state_63884;
var statearr_63886_63905 = state_63884__$1;
(statearr_63886_63905[(2)] = str);

(statearr_63886_63905[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63885 === (1))){
var state_63884__$1 = state_63884;
var statearr_63887_63906 = state_63884__$1;
(statearr_63887_63906[(2)] = null);

(statearr_63887_63906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63885 === (4))){
var inst_63855 = (state_63884[(2)]);
var state_63884__$1 = state_63884;
var statearr_63888_63907 = state_63884__$1;
(statearr_63888_63907[(2)] = inst_63855);

(statearr_63888_63907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63885 === (6))){
var state_63884__$1 = state_63884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63884__$1,(9),str);
} else {
if((state_val_63885 === (3))){
var inst_63882 = (state_63884[(2)]);
var state_63884__$1 = state_63884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63884__$1,inst_63882);
} else {
if((state_val_63885 === (2))){
var _ = (function (){var statearr_63890 = state_63884;
(statearr_63890[(4)] = cljs.core.cons.call(null,(5),(state_63884[(4)])));

return statearr_63890;
})();
var inst_63861 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_63884__$1 = state_63884;
if(inst_63861){
var statearr_63891_63908 = state_63884__$1;
(statearr_63891_63908[(1)] = (6));

} else {
var statearr_63892_63909 = state_63884__$1;
(statearr_63892_63909[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63885 === (9))){
var inst_63864 = (state_63884[(2)]);
var inst_63865 = fluree.db.util.async.throw_err.call(null,inst_63864);
var state_63884__$1 = state_63884;
var statearr_63893_63910 = state_63884__$1;
(statearr_63893_63910[(2)] = inst_63865);

(statearr_63893_63910[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63885 === (5))){
var _ = (function (){var statearr_63894 = state_63884;
(statearr_63894[(4)] = cljs.core.rest.call(null,(state_63884[(4)])));

return statearr_63894;
})();
var state_63884__$1 = state_63884;
var ex63889 = (state_63884__$1[(2)]);
var statearr_63895_63911 = state_63884__$1;
(statearr_63895_63911[(5)] = ex63889);


if((ex63889 instanceof Error)){
var statearr_63896_63912 = state_63884__$1;
(statearr_63896_63912[(1)] = (4));

(statearr_63896_63912[(5)] = null);

} else {
throw ex63889;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63885 === (8))){
var inst_63868 = (state_63884[(2)]);
var inst_63869 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_63868);
var inst_63870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63871 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63873 = [inst_63868];
var inst_63874 = (new cljs.core.PersistentVector(null,1,(5),inst_63872,inst_63873,null));
var inst_63875 = ["upper-case",inst_63874,inst_63869];
var inst_63876 = cljs.core.PersistentHashMap.fromArrays(inst_63871,inst_63875);
var inst_63877 = [inst_63876,(10)];
var inst_63878 = (new cljs.core.PersistentVector(null,2,(5),inst_63870,inst_63877,null));
var inst_63879 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63878);
var _ = (function (){var statearr_63897 = state_63884;
(statearr_63897[(4)] = cljs.core.rest.call(null,(state_63884[(4)])));

return statearr_63897;
})();
var state_63884__$1 = (function (){var statearr_63898 = state_63884;
(statearr_63898[(7)] = inst_63879);

return statearr_63898;
})();
var statearr_63899_63913 = state_63884__$1;
(statearr_63899_63913[(2)] = inst_63869);

(statearr_63899_63913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0 = (function (){
var statearr_63900 = [null,null,null,null,null,null,null,null];
(statearr_63900[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__);

(statearr_63900[(1)] = (1));

return statearr_63900;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1 = (function (state_63884){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63901){var ex__2687__auto__ = e63901;
var statearr_63902_63914 = state_63884;
(statearr_63902_63914[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63884[(4)]))){
var statearr_63903_63915 = state_63884;
(statearr_63903_63915[(1)] = cljs.core.first.call(null,(state_63884[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63916 = state_63884;
state_63884 = G__63916;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__ = function(state_63884){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1.call(this,state_63884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63904 = f__2707__auto__.call(null);
(statearr_63904[(6)] = c__2706__auto__);

return statearr_63904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__63918 = arguments.length;
switch (G__63918) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_63946){
var state_val_63947 = (state_63946[(1)]);
if((state_val_63947 === (1))){
var state_63946__$1 = state_63946;
var statearr_63948_63964 = state_63946__$1;
(statearr_63948_63964[(2)] = null);

(statearr_63948_63964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63947 === (2))){
var _ = (function (){var statearr_63949 = state_63946;
(statearr_63949[(4)] = cljs.core.cons.call(null,(5),(state_63946[(4)])));

return statearr_63949;
})();
var inst_63928 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_63946__$1 = state_63946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63946__$1,(6),inst_63928);
} else {
if((state_val_63947 === (3))){
var inst_63944 = (state_63946[(2)]);
var state_63946__$1 = state_63946;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63946__$1,inst_63944);
} else {
if((state_val_63947 === (4))){
var inst_63919 = (state_63946[(2)]);
var state_63946__$1 = state_63946;
var statearr_63951_63965 = state_63946__$1;
(statearr_63951_63965[(2)] = inst_63919);

(statearr_63951_63965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63947 === (5))){
var _ = (function (){var statearr_63952 = state_63946;
(statearr_63952[(4)] = cljs.core.rest.call(null,(state_63946[(4)])));

return statearr_63952;
})();
var state_63946__$1 = state_63946;
var ex63950 = (state_63946__$1[(2)]);
var statearr_63953_63966 = state_63946__$1;
(statearr_63953_63966[(5)] = ex63950);


if((ex63950 instanceof Error)){
var statearr_63954_63967 = state_63946__$1;
(statearr_63954_63967[(1)] = (4));

(statearr_63954_63967[(5)] = null);

} else {
throw ex63950;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63947 === (6))){
var inst_63930 = (state_63946[(2)]);
var inst_63931 = fluree.db.util.async.throw_err.call(null,inst_63930);
var inst_63932 = cljs.core.nth.call(null,inst_63931,(0),null);
var inst_63933 = cljs.core.nth.call(null,inst_63931,(1),null);
var inst_63934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63935 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63936 = ["?s","?ctx",inst_63932];
var inst_63937 = cljs.core.PersistentHashMap.fromArrays(inst_63935,inst_63936);
var inst_63938 = ((10) + inst_63933);
var inst_63939 = [inst_63937,inst_63938];
var inst_63940 = (new cljs.core.PersistentVector(null,2,(5),inst_63934,inst_63939,null));
var inst_63941 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63940);
var _ = (function (){var statearr_63955 = state_63946;
(statearr_63955[(4)] = cljs.core.rest.call(null,(state_63946[(4)])));

return statearr_63955;
})();
var state_63946__$1 = (function (){var statearr_63956 = state_63946;
(statearr_63956[(7)] = inst_63941);

return statearr_63956;
})();
var statearr_63957_63968 = state_63946__$1;
(statearr_63957_63968[(2)] = inst_63932);

(statearr_63957_63968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_63958 = [null,null,null,null,null,null,null,null];
(statearr_63958[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_63958[(1)] = (1));

return statearr_63958;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_63946){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_63946);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e63959){var ex__2687__auto__ = e63959;
var statearr_63960_63969 = state_63946;
(statearr_63960_63969[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_63946[(4)]))){
var statearr_63961_63970 = state_63946;
(statearr_63961_63970[(1)] = cljs.core.first.call(null,(state_63946[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63971 = state_63946;
state_63946 = G__63971;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_63946){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_63946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_63962 = f__2707__auto__.call(null);
(statearr_63962[(6)] = c__2706__auto__);

return statearr_63962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__63973 = arguments.length;
switch (G__63973) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64011){
var state_val_64012 = (state_64011[(1)]);
if((state_val_64012 === (7))){
var inst_64004 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_64011__$1 = state_64011;
var statearr_64013_64033 = state_64011__$1;
(statearr_64013_64033[(2)] = inst_64004);

(statearr_64013_64033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64012 === (1))){
var state_64011__$1 = state_64011;
var statearr_64014_64034 = state_64011__$1;
(statearr_64014_64034[(2)] = null);

(statearr_64014_64034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64012 === (4))){
var inst_63974 = (state_64011[(2)]);
var state_64011__$1 = state_64011;
var statearr_64015_64035 = state_64011__$1;
(statearr_64015_64035[(2)] = inst_63974);

(statearr_64015_64035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64012 === (6))){
var inst_63985 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_64011__$1 = state_64011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64011__$1,(10),inst_63985);
} else {
if((state_val_64012 === (3))){
var inst_64009 = (state_64011[(2)]);
var state_64011__$1 = state_64011;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64011__$1,inst_64009);
} else {
if((state_val_64012 === (2))){
var _ = (function (){var statearr_64017 = state_64011;
(statearr_64017[(4)] = cljs.core.cons.call(null,(5),(state_64011[(4)])));

return statearr_64017;
})();
var inst_63980 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64011__$1 = state_64011;
if(cljs.core.truth_(inst_63980)){
var statearr_64018_64036 = state_64011__$1;
(statearr_64018_64036[(1)] = (6));

} else {
var statearr_64019_64037 = state_64011__$1;
(statearr_64019_64037[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64012 === (9))){
var inst_63991 = (state_64011[(2)]);
var inst_63992 = fluree.db.util.async.throw_err.call(null,inst_63991);
var inst_63993 = cljs.core.nth.call(null,inst_63992,(0),null);
var inst_63994 = cljs.core.nth.call(null,inst_63992,(1),null);
var inst_63995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63996 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63997 = ["?p","?ctx",inst_63993];
var inst_63998 = cljs.core.PersistentHashMap.fromArrays(inst_63996,inst_63997);
var inst_63999 = ((10) + inst_63994);
var inst_64000 = [inst_63998,inst_63999];
var inst_64001 = (new cljs.core.PersistentVector(null,2,(5),inst_63995,inst_64000,null));
var inst_64002 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64001);
var state_64011__$1 = (function (){var statearr_64020 = state_64011;
(statearr_64020[(7)] = inst_64002);

return statearr_64020;
})();
var statearr_64021_64038 = state_64011__$1;
(statearr_64021_64038[(2)] = inst_63993);

(statearr_64021_64038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64012 === (5))){
var _ = (function (){var statearr_64022 = state_64011;
(statearr_64022[(4)] = cljs.core.rest.call(null,(state_64011[(4)])));

return statearr_64022;
})();
var state_64011__$1 = state_64011;
var ex64016 = (state_64011__$1[(2)]);
var statearr_64023_64039 = state_64011__$1;
(statearr_64023_64039[(5)] = ex64016);


if((ex64016 instanceof Error)){
var statearr_64024_64040 = state_64011__$1;
(statearr_64024_64040[(1)] = (4));

(statearr_64024_64040[(5)] = null);

} else {
throw ex64016;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64012 === (10))){
var inst_63987 = (state_64011[(2)]);
var inst_63988 = fluree.db.util.async.throw_err.call(null,inst_63987);
var inst_63989 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_63988);
var state_64011__$1 = state_64011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64011__$1,(9),inst_63989);
} else {
if((state_val_64012 === (8))){
var inst_64006 = (state_64011[(2)]);
var _ = (function (){var statearr_64025 = state_64011;
(statearr_64025[(4)] = cljs.core.rest.call(null,(state_64011[(4)])));

return statearr_64025;
})();
var state_64011__$1 = state_64011;
var statearr_64026_64041 = state_64011__$1;
(statearr_64026_64041[(2)] = inst_64006);

(statearr_64026_64041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_64027 = [null,null,null,null,null,null,null,null];
(statearr_64027[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_64027[(1)] = (1));

return statearr_64027;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_64011){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64011);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64028){var ex__2687__auto__ = e64028;
var statearr_64029_64042 = state_64011;
(statearr_64029_64042[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64011[(4)]))){
var statearr_64030_64043 = state_64011;
(statearr_64030_64043[(1)] = cljs.core.first.call(null,(state_64011[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64044 = state_64011;
state_64011 = G__64044;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_64011){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_64011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64031 = f__2707__auto__.call(null);
(statearr_64031[(6)] = c__2706__auto__);

return statearr_64031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64093 = arguments.length;
var i__5770__auto___64094 = (0);
while(true){
if((i__5770__auto___64094 < len__5769__auto___64093)){
args__5775__auto__.push((arguments[i__5770__auto___64094]));

var G__64095 = (i__5770__auto___64094 + (1));
i__5770__auto___64094 = G__64095;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64076){
var state_val_64077 = (state_64076[(1)]);
if((state_val_64077 === (1))){
var state_64076__$1 = state_64076;
var statearr_64078_64096 = state_64076__$1;
(statearr_64078_64096[(2)] = null);

(statearr_64078_64096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64077 === (2))){
var _ = (function (){var statearr_64079 = state_64076;
(statearr_64079[(4)] = cljs.core.cons.call(null,(5),(state_64076[(4)])));

return statearr_64079;
})();
var inst_64053 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64076__$1 = state_64076;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64076__$1,(6),inst_64053);
} else {
if((state_val_64077 === (3))){
var inst_64074 = (state_64076[(2)]);
var state_64076__$1 = state_64076;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64076__$1,inst_64074);
} else {
if((state_val_64077 === (4))){
var inst_64047 = (state_64076[(2)]);
var state_64076__$1 = state_64076;
var statearr_64081_64097 = state_64076__$1;
(statearr_64081_64097[(2)] = inst_64047);

(statearr_64081_64097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64077 === (5))){
var _ = (function (){var statearr_64082 = state_64076;
(statearr_64082[(4)] = cljs.core.rest.call(null,(state_64076[(4)])));

return statearr_64082;
})();
var state_64076__$1 = state_64076;
var ex64080 = (state_64076__$1[(2)]);
var statearr_64083_64098 = state_64076__$1;
(statearr_64083_64098[(5)] = ex64080);


if((ex64080 instanceof Error)){
var statearr_64084_64099 = state_64076__$1;
(statearr_64084_64099[(1)] = (4));

(statearr_64084_64099[(5)] = null);

} else {
throw ex64080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64077 === (6))){
var inst_64055 = (state_64076[(2)]);
var inst_64056 = fluree.db.util.async.throw_err.call(null,inst_64055);
var inst_64057 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_64056);
var inst_64058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64059 = [inst_64056];
var inst_64060 = (new cljs.core.PersistentVector(null,1,(5),inst_64058,inst_64059,null));
var inst_64061 = cljs.core.count.call(null,inst_64060);
var inst_64062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64063 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64065 = [inst_64056];
var inst_64066 = (new cljs.core.PersistentVector(null,1,(5),inst_64064,inst_64065,null));
var inst_64067 = ["and",inst_64066,inst_64057];
var inst_64068 = cljs.core.PersistentHashMap.fromArrays(inst_64063,inst_64067);
var inst_64069 = [inst_64068,inst_64061];
var inst_64070 = (new cljs.core.PersistentVector(null,2,(5),inst_64062,inst_64069,null));
var inst_64071 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64070);
var _ = (function (){var statearr_64085 = state_64076;
(statearr_64085[(4)] = cljs.core.rest.call(null,(state_64076[(4)])));

return statearr_64085;
})();
var state_64076__$1 = (function (){var statearr_64086 = state_64076;
(statearr_64086[(7)] = inst_64071);

return statearr_64086;
})();
var statearr_64087_64100 = state_64076__$1;
(statearr_64087_64100[(2)] = inst_64057);

(statearr_64087_64100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_64088 = [null,null,null,null,null,null,null,null];
(statearr_64088[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_64088[(1)] = (1));

return statearr_64088;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_64076){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64076);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64089){var ex__2687__auto__ = e64089;
var statearr_64090_64101 = state_64076;
(statearr_64090_64101[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64076[(4)]))){
var statearr_64091_64102 = state_64076;
(statearr_64091_64102[(1)] = cljs.core.first.call(null,(state_64076[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64103 = state_64076;
state_64076 = G__64103;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_64076){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_64076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64092 = f__2707__auto__.call(null);
(statearr_64092[(6)] = c__2706__auto__);

return statearr_64092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq64045){
var G__64046 = cljs.core.first.call(null,seq64045);
var seq64045__$1 = cljs.core.next.call(null,seq64045);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64046,seq64045__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64152 = arguments.length;
var i__5770__auto___64153 = (0);
while(true){
if((i__5770__auto___64153 < len__5769__auto___64152)){
args__5775__auto__.push((arguments[i__5770__auto___64153]));

var G__64154 = (i__5770__auto___64153 + (1));
i__5770__auto___64153 = G__64154;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64135){
var state_val_64136 = (state_64135[(1)]);
if((state_val_64136 === (1))){
var state_64135__$1 = state_64135;
var statearr_64137_64155 = state_64135__$1;
(statearr_64137_64155[(2)] = null);

(statearr_64137_64155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64136 === (2))){
var _ = (function (){var statearr_64138 = state_64135;
(statearr_64138[(4)] = cljs.core.cons.call(null,(5),(state_64135[(4)])));

return statearr_64138;
})();
var inst_64112 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64135__$1 = state_64135;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64135__$1,(6),inst_64112);
} else {
if((state_val_64136 === (3))){
var inst_64133 = (state_64135[(2)]);
var state_64135__$1 = state_64135;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64135__$1,inst_64133);
} else {
if((state_val_64136 === (4))){
var inst_64106 = (state_64135[(2)]);
var state_64135__$1 = state_64135;
var statearr_64140_64156 = state_64135__$1;
(statearr_64140_64156[(2)] = inst_64106);

(statearr_64140_64156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64136 === (5))){
var _ = (function (){var statearr_64141 = state_64135;
(statearr_64141[(4)] = cljs.core.rest.call(null,(state_64135[(4)])));

return statearr_64141;
})();
var state_64135__$1 = state_64135;
var ex64139 = (state_64135__$1[(2)]);
var statearr_64142_64157 = state_64135__$1;
(statearr_64142_64157[(5)] = ex64139);


if((ex64139 instanceof Error)){
var statearr_64143_64158 = state_64135__$1;
(statearr_64143_64158[(1)] = (4));

(statearr_64143_64158[(5)] = null);

} else {
throw ex64139;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64136 === (6))){
var inst_64114 = (state_64135[(2)]);
var inst_64115 = fluree.db.util.async.throw_err.call(null,inst_64114);
var inst_64116 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_64115);
var inst_64117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64118 = [inst_64115];
var inst_64119 = (new cljs.core.PersistentVector(null,1,(5),inst_64117,inst_64118,null));
var inst_64120 = cljs.core.count.call(null,inst_64119);
var inst_64121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64122 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64124 = [inst_64115];
var inst_64125 = (new cljs.core.PersistentVector(null,1,(5),inst_64123,inst_64124,null));
var inst_64126 = ["or",inst_64125,inst_64116];
var inst_64127 = cljs.core.PersistentHashMap.fromArrays(inst_64122,inst_64126);
var inst_64128 = [inst_64127,inst_64120];
var inst_64129 = (new cljs.core.PersistentVector(null,2,(5),inst_64121,inst_64128,null));
var inst_64130 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64129);
var _ = (function (){var statearr_64144 = state_64135;
(statearr_64144[(4)] = cljs.core.rest.call(null,(state_64135[(4)])));

return statearr_64144;
})();
var state_64135__$1 = (function (){var statearr_64145 = state_64135;
(statearr_64145[(7)] = inst_64130);

return statearr_64145;
})();
var statearr_64146_64159 = state_64135__$1;
(statearr_64146_64159[(2)] = inst_64116);

(statearr_64146_64159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_64147 = [null,null,null,null,null,null,null,null];
(statearr_64147[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_64147[(1)] = (1));

return statearr_64147;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_64135){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64135);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64148){var ex__2687__auto__ = e64148;
var statearr_64149_64160 = state_64135;
(statearr_64149_64160[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64135[(4)]))){
var statearr_64150_64161 = state_64135;
(statearr_64150_64161[(1)] = cljs.core.first.call(null,(state_64135[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64162 = state_64135;
state_64135 = G__64162;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_64135){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_64135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64151 = f__2707__auto__.call(null);
(statearr_64151[(6)] = c__2706__auto__);

return statearr_64151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq64104){
var G__64105 = cljs.core.first.call(null,seq64104);
var seq64104__$1 = cljs.core.next.call(null,seq64104);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64105,seq64104__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64200){
var state_val_64201 = (state_64200[(1)]);
if((state_val_64201 === (7))){
var inst_64176 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_64200__$1 = state_64200;
if(inst_64176){
var statearr_64202_64225 = state_64200__$1;
(statearr_64202_64225[(1)] = (10));

} else {
var statearr_64203_64226 = state_64200__$1;
(statearr_64203_64226[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64201 === (1))){
var state_64200__$1 = state_64200;
var statearr_64204_64227 = state_64200__$1;
(statearr_64204_64227[(2)] = null);

(statearr_64204_64227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64201 === (4))){
var inst_64163 = (state_64200[(2)]);
var state_64200__$1 = state_64200;
var statearr_64205_64228 = state_64200__$1;
(statearr_64205_64228[(2)] = inst_64163);

(statearr_64205_64228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64201 === (13))){
var inst_64179 = (state_64200[(2)]);
var inst_64180 = fluree.db.util.async.throw_err.call(null,inst_64179);
var state_64200__$1 = state_64200;
var statearr_64206_64229 = state_64200__$1;
(statearr_64206_64229[(2)] = inst_64180);

(statearr_64206_64229[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64201 === (6))){
var inst_64171 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_64200__$1 = state_64200;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64200__$1,(9),inst_64171);
} else {
if((state_val_64201 === (3))){
var inst_64198 = (state_64200[(2)]);
var state_64200__$1 = state_64200;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64200__$1,inst_64198);
} else {
if((state_val_64201 === (12))){
var inst_64183 = (state_64200[(2)]);
var state_64200__$1 = state_64200;
var statearr_64207_64230 = state_64200__$1;
(statearr_64207_64230[(2)] = inst_64183);

(statearr_64207_64230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64201 === (2))){
var _ = (function (){var statearr_64208 = state_64200;
(statearr_64208[(4)] = cljs.core.cons.call(null,(5),(state_64200[(4)])));

return statearr_64208;
})();
var inst_64169 = cljs.core.vector_QMARK_.call(null,coll);
var state_64200__$1 = state_64200;
if(inst_64169){
var statearr_64209_64231 = state_64200__$1;
(statearr_64209_64231[(1)] = (6));

} else {
var statearr_64210_64232 = state_64200__$1;
(statearr_64210_64232[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64201 === (11))){
var state_64200__$1 = state_64200;
var statearr_64212_64233 = state_64200__$1;
(statearr_64212_64233[(2)] = coll);

(statearr_64212_64233[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64201 === (9))){
var inst_64173 = (state_64200[(2)]);
var inst_64174 = fluree.db.util.async.throw_err.call(null,inst_64173);
var state_64200__$1 = state_64200;
var statearr_64213_64234 = state_64200__$1;
(statearr_64213_64234[(2)] = inst_64174);

(statearr_64213_64234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64201 === (5))){
var _ = (function (){var statearr_64214 = state_64200;
(statearr_64214[(4)] = cljs.core.rest.call(null,(state_64200[(4)])));

return statearr_64214;
})();
var state_64200__$1 = state_64200;
var ex64211 = (state_64200__$1[(2)]);
var statearr_64215_64235 = state_64200__$1;
(statearr_64215_64235[(5)] = ex64211);


if((ex64211 instanceof Error)){
var statearr_64216_64236 = state_64200__$1;
(statearr_64216_64236[(1)] = (4));

(statearr_64216_64236[(5)] = null);

} else {
throw ex64211;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64201 === (10))){
var state_64200__$1 = state_64200;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64200__$1,(13),coll);
} else {
if((state_val_64201 === (8))){
var inst_64185 = (state_64200[(2)]);
var inst_64186 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_64185);
var inst_64187 = cljs.core.count.call(null,inst_64186);
var inst_64188 = ((9) + inst_64187);
var inst_64189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64190 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64191 = ["count",inst_64185,inst_64187];
var inst_64192 = cljs.core.PersistentHashMap.fromArrays(inst_64190,inst_64191);
var inst_64193 = [inst_64192,inst_64188];
var inst_64194 = (new cljs.core.PersistentVector(null,2,(5),inst_64189,inst_64193,null));
var inst_64195 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64194);
var _ = (function (){var statearr_64217 = state_64200;
(statearr_64217[(4)] = cljs.core.rest.call(null,(state_64200[(4)])));

return statearr_64217;
})();
var state_64200__$1 = (function (){var statearr_64218 = state_64200;
(statearr_64218[(7)] = inst_64195);

return statearr_64218;
})();
var statearr_64219_64237 = state_64200__$1;
(statearr_64219_64237[(2)] = inst_64187);

(statearr_64219_64237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0 = (function (){
var statearr_64220 = [null,null,null,null,null,null,null,null];
(statearr_64220[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__);

(statearr_64220[(1)] = (1));

return statearr_64220;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1 = (function (state_64200){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64200);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64221){var ex__2687__auto__ = e64221;
var statearr_64222_64238 = state_64200;
(statearr_64222_64238[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64200[(4)]))){
var statearr_64223_64239 = state_64200;
(statearr_64223_64239[(1)] = cljs.core.first.call(null,(state_64200[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64240 = state_64200;
state_64200 = G__64240;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__ = function(state_64200){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1.call(this,state_64200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64224 = f__2707__auto__.call(null);
(statearr_64224[(6)] = c__2706__auto__);

return statearr_64224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__64241,subject,pred){
var map__64242 = p__64241;
var map__64242__$1 = cljs.core.__destructure_map.call(null,map__64242);
var _QMARK_ctx = map__64242__$1;
var cache = cljs.core.get.call(null,map__64242__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.call(null,map__64242__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64333){
var state_val_64334 = (state_64333[(1)]);
if((state_val_64334 === (7))){
var state_64333__$1 = state_64333;
var statearr_64335_64391 = state_64333__$1;
(statearr_64335_64391[(2)] = subject);

(statearr_64335_64391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (20))){
var state_64333__$1 = state_64333;
var statearr_64336_64392 = state_64333__$1;
(statearr_64336_64392[(2)] = cache);

(statearr_64336_64392[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (27))){
var inst_64276 = (state_64333[(7)]);
var inst_64264 = (state_64333[(8)]);
var inst_64290 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_64276,inst_64264);
var state_64333__$1 = state_64333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64333__$1,(29),inst_64290);
} else {
if((state_val_64334 === (1))){
var state_64333__$1 = state_64333;
var statearr_64337_64393 = state_64333__$1;
(statearr_64337_64393[(2)] = null);

(statearr_64337_64393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (24))){
var inst_64276 = (state_64333[(7)]);
var inst_64303 = cljs.core.int_QMARK_.call(null,inst_64276);
var state_64333__$1 = state_64333;
if(inst_64303){
var statearr_64338_64394 = state_64333__$1;
(statearr_64338_64394[(1)] = (30));

} else {
var statearr_64339_64395 = state_64333__$1;
(statearr_64339_64395[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (4))){
var inst_64243 = (state_64333[(2)]);
var state_64333__$1 = state_64333;
var statearr_64340_64396 = state_64333__$1;
(statearr_64340_64396[(2)] = inst_64243);

(statearr_64340_64396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (15))){
var inst_64256 = (state_64333[(9)]);
var state_64333__$1 = state_64333;
var statearr_64341_64397 = state_64333__$1;
(statearr_64341_64397[(2)] = inst_64256);

(statearr_64341_64397[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (21))){
var inst_64277 = (state_64333[(10)]);
var state_64333__$1 = state_64333;
var statearr_64342_64398 = state_64333__$1;
(statearr_64342_64398[(2)] = inst_64277);

(statearr_64342_64398[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (31))){
var state_64333__$1 = state_64333;
var statearr_64343_64399 = state_64333__$1;
(statearr_64343_64399[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (32))){
var inst_64316 = (state_64333[(2)]);
var state_64333__$1 = state_64333;
var statearr_64345_64400 = state_64333__$1;
(statearr_64345_64400[(2)] = inst_64316);

(statearr_64345_64400[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (33))){
var inst_64307 = (state_64333[(2)]);
var inst_64308 = fluree.db.util.async.throw_err.call(null,inst_64307);
var state_64333__$1 = state_64333;
var statearr_64346_64401 = state_64333__$1;
(statearr_64346_64401[(2)] = inst_64308);

(statearr_64346_64401[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (13))){
var inst_64260 = (state_64333[(2)]);
var inst_64261 = fluree.db.util.async.throw_err.call(null,inst_64260);
var state_64333__$1 = state_64333;
var statearr_64347_64402 = state_64333__$1;
(statearr_64347_64402[(2)] = inst_64261);

(statearr_64347_64402[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (22))){
var inst_64281 = (state_64333[(2)]);
var state_64333__$1 = state_64333;
if(cljs.core.truth_(inst_64281)){
var statearr_64348_64403 = state_64333__$1;
(statearr_64348_64403[(1)] = (23));

} else {
var statearr_64349_64404 = state_64333__$1;
(statearr_64349_64404[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (36))){
var inst_64314 = (state_64333[(2)]);
var state_64333__$1 = state_64333;
var statearr_64350_64405 = state_64333__$1;
(statearr_64350_64405[(2)] = inst_64314);

(statearr_64350_64405[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (29))){
var inst_64276 = (state_64333[(7)]);
var inst_64264 = (state_64333[(8)]);
var inst_64292 = (state_64333[(2)]);
var inst_64293 = fluree.db.util.async.throw_err.call(null,inst_64292);
var inst_64294 = cljs.core._deref.call(null,cache);
var inst_64295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64296 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_64276,inst_64264];
var inst_64297 = (new cljs.core.PersistentVector(null,3,(5),inst_64295,inst_64296,null));
var inst_64298 = cljs.core.assoc_in.call(null,inst_64294,inst_64297,inst_64293);
var inst_64299 = cljs.core._vreset_BANG_.call(null,cache,inst_64298);
var state_64333__$1 = (function (){var statearr_64351 = state_64333;
(statearr_64351[(11)] = inst_64299);

return statearr_64351;
})();
var statearr_64352_64406 = state_64333__$1;
(statearr_64352_64406[(2)] = inst_64293);

(statearr_64352_64406[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (6))){
var state_64333__$1 = state_64333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64333__$1,(9),subject);
} else {
if((state_val_64334 === (28))){
var inst_64301 = (state_64333[(2)]);
var state_64333__$1 = state_64333;
var statearr_64353_64407 = state_64333__$1;
(statearr_64353_64407[(2)] = inst_64301);

(statearr_64353_64407[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (25))){
var inst_64264 = (state_64333[(8)]);
var inst_64256 = (state_64333[(9)]);
var inst_64318 = (state_64333[(2)]);
var inst_64319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64320 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64322 = [inst_64256,inst_64264];
var inst_64323 = (new cljs.core.PersistentVector(null,2,(5),inst_64321,inst_64322,null));
var inst_64324 = ["get",inst_64323,inst_64318];
var inst_64325 = cljs.core.PersistentHashMap.fromArrays(inst_64320,inst_64324);
var inst_64326 = [inst_64325,(10)];
var inst_64327 = (new cljs.core.PersistentVector(null,2,(5),inst_64319,inst_64326,null));
var inst_64328 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64327);
var _ = (function (){var statearr_64354 = state_64333;
(statearr_64354[(4)] = cljs.core.rest.call(null,(state_64333[(4)])));

return statearr_64354;
})();
var state_64333__$1 = (function (){var statearr_64355 = state_64333;
(statearr_64355[(12)] = inst_64328);

return statearr_64355;
})();
var statearr_64356_64408 = state_64333__$1;
(statearr_64356_64408[(2)] = inst_64318);

(statearr_64356_64408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (34))){
var inst_64276 = (state_64333[(7)]);
var inst_64264 = (state_64333[(8)]);
var inst_64311 = fluree.db.dbfunctions.internal.get.call(null,inst_64276,inst_64264);
var state_64333__$1 = state_64333;
var statearr_64357_64409 = state_64333__$1;
(statearr_64357_64409[(2)] = inst_64311);

(statearr_64357_64409[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (17))){
var inst_64256 = (state_64333[(9)]);
var inst_64270 = cljs.core.first.call(null,inst_64256);
var state_64333__$1 = state_64333;
var statearr_64358_64410 = state_64333__$1;
(statearr_64358_64410[(2)] = inst_64270);

(statearr_64358_64410[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (3))){
var inst_64331 = (state_64333[(2)]);
var state_64333__$1 = state_64333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64333__$1,inst_64331);
} else {
if((state_val_64334 === (12))){
var inst_64256 = (state_64333[(9)]);
var inst_64264 = (state_64333[(2)]);
var inst_64265 = cljs.core.vector_QMARK_.call(null,inst_64256);
var state_64333__$1 = (function (){var statearr_64359 = state_64333;
(statearr_64359[(8)] = inst_64264);

return statearr_64359;
})();
if(inst_64265){
var statearr_64360_64411 = state_64333__$1;
(statearr_64360_64411[(1)] = (14));

} else {
var statearr_64361_64412 = state_64333__$1;
(statearr_64361_64412[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (2))){
var _ = (function (){var statearr_64362 = state_64333;
(statearr_64362[(4)] = cljs.core.cons.call(null,(5),(state_64333[(4)])));

return statearr_64362;
})();
var inst_64249 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_64333__$1 = state_64333;
if(inst_64249){
var statearr_64363_64413 = state_64333__$1;
(statearr_64363_64413[(1)] = (6));

} else {
var statearr_64364_64414 = state_64333__$1;
(statearr_64364_64414[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (23))){
var inst_64276 = (state_64333[(7)]);
var inst_64264 = (state_64333[(8)]);
var inst_64287 = (state_64333[(13)]);
var inst_64283 = cljs.core.deref.call(null,cache);
var inst_64284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64285 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_64276,inst_64264];
var inst_64286 = (new cljs.core.PersistentVector(null,3,(5),inst_64284,inst_64285,null));
var inst_64287__$1 = cljs.core.get_in.call(null,inst_64283,inst_64286);
var state_64333__$1 = (function (){var statearr_64365 = state_64333;
(statearr_64365[(13)] = inst_64287__$1);

return statearr_64365;
})();
if(cljs.core.truth_(inst_64287__$1)){
var statearr_64366_64415 = state_64333__$1;
(statearr_64366_64415[(1)] = (26));

} else {
var statearr_64367_64416 = state_64333__$1;
(statearr_64367_64416[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (35))){
var state_64333__$1 = state_64333;
var statearr_64368_64417 = state_64333__$1;
(statearr_64368_64417[(2)] = null);

(statearr_64368_64417[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (19))){
var inst_64273 = (state_64333[(2)]);
var state_64333__$1 = state_64333;
var statearr_64369_64418 = state_64333__$1;
(statearr_64369_64418[(2)] = inst_64273);

(statearr_64369_64418[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (11))){
var state_64333__$1 = state_64333;
var statearr_64371_64419 = state_64333__$1;
(statearr_64371_64419[(2)] = pred);

(statearr_64371_64419[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (9))){
var inst_64252 = (state_64333[(2)]);
var inst_64253 = fluree.db.util.async.throw_err.call(null,inst_64252);
var state_64333__$1 = state_64333;
var statearr_64372_64420 = state_64333__$1;
(statearr_64372_64420[(2)] = inst_64253);

(statearr_64372_64420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (5))){
var _ = (function (){var statearr_64373 = state_64333;
(statearr_64373[(4)] = cljs.core.rest.call(null,(state_64333[(4)])));

return statearr_64373;
})();
var state_64333__$1 = state_64333;
var ex64370 = (state_64333__$1[(2)]);
var statearr_64374_64421 = state_64333__$1;
(statearr_64374_64421[(5)] = ex64370);


if((ex64370 instanceof Error)){
var statearr_64375_64422 = state_64333__$1;
(statearr_64375_64422[(1)] = (4));

(statearr_64375_64422[(5)] = null);

} else {
throw ex64370;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (14))){
var inst_64256 = (state_64333[(9)]);
var inst_64267 = cljs.core.count.call(null,inst_64256);
var inst_64268 = cljs.core._EQ_.call(null,(1),inst_64267);
var state_64333__$1 = state_64333;
if(inst_64268){
var statearr_64376_64423 = state_64333__$1;
(statearr_64376_64423[(1)] = (17));

} else {
var statearr_64377_64424 = state_64333__$1;
(statearr_64377_64424[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (26))){
var inst_64287 = (state_64333[(13)]);
var state_64333__$1 = state_64333;
var statearr_64378_64425 = state_64333__$1;
(statearr_64378_64425[(2)] = inst_64287);

(statearr_64378_64425[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (16))){
var inst_64277 = (state_64333[(10)]);
var inst_64276 = (state_64333[(7)]);
var inst_64276__$1 = (state_64333[(2)]);
var inst_64277__$1 = cljs.core.int_QMARK_.call(null,inst_64276__$1);
var state_64333__$1 = (function (){var statearr_64379 = state_64333;
(statearr_64379[(10)] = inst_64277__$1);

(statearr_64379[(7)] = inst_64276__$1);

return statearr_64379;
})();
if(inst_64277__$1){
var statearr_64380_64426 = state_64333__$1;
(statearr_64380_64426[(1)] = (20));

} else {
var statearr_64381_64427 = state_64333__$1;
(statearr_64381_64427[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (30))){
var inst_64276 = (state_64333[(7)]);
var inst_64264 = (state_64333[(8)]);
var inst_64305 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_64276,inst_64264);
var state_64333__$1 = state_64333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64333__$1,(33),inst_64305);
} else {
if((state_val_64334 === (10))){
var state_64333__$1 = state_64333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64333__$1,(13),pred);
} else {
if((state_val_64334 === (18))){
var inst_64256 = (state_64333[(9)]);
var state_64333__$1 = state_64333;
var statearr_64382_64428 = state_64333__$1;
(statearr_64382_64428[(2)] = inst_64256);

(statearr_64382_64428[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64334 === (8))){
var inst_64256 = (state_64333[(2)]);
var inst_64257 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_64333__$1 = (function (){var statearr_64383 = state_64333;
(statearr_64383[(9)] = inst_64256);

return statearr_64383;
})();
if(inst_64257){
var statearr_64384_64429 = state_64333__$1;
(statearr_64384_64429[(1)] = (10));

} else {
var statearr_64385_64430 = state_64333__$1;
(statearr_64385_64430[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0 = (function (){
var statearr_64386 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64386[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__);

(statearr_64386[(1)] = (1));

return statearr_64386;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1 = (function (state_64333){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64387){var ex__2687__auto__ = e64387;
var statearr_64388_64431 = state_64333;
(statearr_64388_64431[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64333[(4)]))){
var statearr_64389_64432 = state_64333;
(statearr_64389_64432[(1)] = cljs.core.first.call(null,(state_64333[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64433 = state_64333;
state_64333 = G__64433;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__ = function(state_64333){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1.call(this,state_64333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64390 = f__2707__auto__.call(null);
(statearr_64390[(6)] = c__2706__auto__);

return statearr_64390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64472){
var state_val_64473 = (state_64472[(1)]);
if((state_val_64473 === (7))){
var inst_64440 = (state_64472[(7)]);
var state_64472__$1 = state_64472;
var statearr_64474_64498 = state_64472__$1;
(statearr_64474_64498[(2)] = inst_64440);

(statearr_64474_64498[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (1))){
var state_64472__$1 = state_64472;
var statearr_64475_64499 = state_64472__$1;
(statearr_64475_64499[(2)] = null);

(statearr_64475_64499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (4))){
var inst_64434 = (state_64472[(2)]);
var state_64472__$1 = state_64472;
var statearr_64476_64500 = state_64472__$1;
(statearr_64476_64500[(2)] = inst_64434);

(statearr_64476_64500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (6))){
var inst_64442 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64472__$1 = state_64472;
var statearr_64477_64501 = state_64472__$1;
(statearr_64477_64501[(2)] = inst_64442);

(statearr_64477_64501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (3))){
var inst_64470 = (state_64472[(2)]);
var state_64472__$1 = state_64472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64472__$1,inst_64470);
} else {
if((state_val_64473 === (12))){
var inst_64452 = (state_64472[(2)]);
var inst_64453 = fluree.db.util.async.throw_err.call(null,inst_64452);
var inst_64454 = cljs.core.nth.call(null,inst_64453,(0),null);
var inst_64455 = cljs.core.nth.call(null,inst_64453,(1),null);
var inst_64456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64457 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64458 = ["?pO","?ctx",inst_64454];
var inst_64459 = cljs.core.PersistentHashMap.fromArrays(inst_64457,inst_64458);
var inst_64460 = ((10) + inst_64455);
var inst_64461 = [inst_64459,inst_64460];
var inst_64462 = (new cljs.core.PersistentVector(null,2,(5),inst_64456,inst_64461,null));
var inst_64463 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64462);
var state_64472__$1 = (function (){var statearr_64478 = state_64472;
(statearr_64478[(8)] = inst_64463);

return statearr_64478;
})();
var statearr_64479_64502 = state_64472__$1;
(statearr_64479_64502[(2)] = inst_64454);

(statearr_64479_64502[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (2))){
var inst_64440 = (state_64472[(7)]);
var _ = (function (){var statearr_64480 = state_64472;
(statearr_64480[(4)] = cljs.core.cons.call(null,(5),(state_64472[(4)])));

return statearr_64480;
})();
var inst_64440__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64472__$1 = (function (){var statearr_64481 = state_64472;
(statearr_64481[(7)] = inst_64440__$1);

return statearr_64481;
})();
if(cljs.core.truth_(inst_64440__$1)){
var statearr_64482_64503 = state_64472__$1;
(statearr_64482_64503[(1)] = (6));

} else {
var statearr_64483_64504 = state_64472__$1;
(statearr_64483_64504[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (11))){
var inst_64467 = (state_64472[(2)]);
var _ = (function (){var statearr_64485 = state_64472;
(statearr_64485[(4)] = cljs.core.rest.call(null,(state_64472[(4)])));

return statearr_64485;
})();
var state_64472__$1 = state_64472;
var statearr_64486_64505 = state_64472__$1;
(statearr_64486_64505[(2)] = inst_64467);

(statearr_64486_64505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (9))){
var inst_64450 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_64472__$1 = state_64472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64472__$1,(12),inst_64450);
} else {
if((state_val_64473 === (5))){
var _ = (function (){var statearr_64487 = state_64472;
(statearr_64487[(4)] = cljs.core.rest.call(null,(state_64472[(4)])));

return statearr_64487;
})();
var state_64472__$1 = state_64472;
var ex64484 = (state_64472__$1[(2)]);
var statearr_64488_64506 = state_64472__$1;
(statearr_64488_64506[(5)] = ex64484);


if((ex64484 instanceof Error)){
var statearr_64489_64507 = state_64472__$1;
(statearr_64489_64507[(1)] = (4));

(statearr_64489_64507[(5)] = null);

} else {
throw ex64484;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (10))){
var inst_64465 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_64472__$1 = state_64472;
var statearr_64490_64508 = state_64472__$1;
(statearr_64490_64508[(2)] = inst_64465);

(statearr_64490_64508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64473 === (8))){
var inst_64445 = (state_64472[(2)]);
var state_64472__$1 = state_64472;
if(cljs.core.truth_(inst_64445)){
var statearr_64491_64509 = state_64472__$1;
(statearr_64491_64509[(1)] = (9));

} else {
var statearr_64492_64510 = state_64472__$1;
(statearr_64492_64510[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0 = (function (){
var statearr_64493 = [null,null,null,null,null,null,null,null,null];
(statearr_64493[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__);

(statearr_64493[(1)] = (1));

return statearr_64493;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1 = (function (state_64472){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64494){var ex__2687__auto__ = e64494;
var statearr_64495_64511 = state_64472;
(statearr_64495_64511[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64472[(4)]))){
var statearr_64496_64512 = state_64472;
(statearr_64496_64512[(1)] = cljs.core.first.call(null,(state_64472[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64513 = state_64472;
state_64472 = G__64513;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__ = function(state_64472){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1.call(this,state_64472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64497 = f__2707__auto__.call(null);
(statearr_64497[(6)] = c__2706__auto__);

return statearr_64497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64582){
var state_val_64583 = (state_64582[(1)]);
if((state_val_64583 === (7))){
var state_64582__$1 = state_64582;
var statearr_64584_64622 = state_64582__$1;
(statearr_64584_64622[(2)] = subject);

(statearr_64584_64622[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (20))){
var inst_64538 = (state_64582[(7)]);
var inst_64550 = (state_64582[(8)]);
var inst_64553 = fluree.db.dbfunctions.internal.follow_subject.call(null,_QMARK_ctx,inst_64550,inst_64538);
var state_64582__$1 = state_64582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64582__$1,(23),inst_64553);
} else {
if((state_val_64583 === (1))){
var state_64582__$1 = state_64582;
var statearr_64585_64623 = state_64582__$1;
(statearr_64585_64623[(2)] = null);

(statearr_64585_64623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (4))){
var inst_64514 = (state_64582[(2)]);
var state_64582__$1 = state_64582;
var statearr_64586_64624 = state_64582__$1;
(statearr_64586_64624[(2)] = inst_64514);

(statearr_64586_64624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (15))){
var inst_64530 = (state_64582[(9)]);
var state_64582__$1 = state_64582;
var statearr_64587_64625 = state_64582__$1;
(statearr_64587_64625[(2)] = inst_64530);

(statearr_64587_64625[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (21))){
var inst_64538 = (state_64582[(7)]);
var inst_64550 = (state_64582[(8)]);
var inst_64558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64559 = fluree.db.dbfunctions.internal.get_all.call(null,inst_64550,inst_64538);
var inst_64560 = cljs.core.count.call(null,inst_64538);
var inst_64561 = ((9) + inst_64560);
var inst_64562 = [inst_64559,inst_64561];
var inst_64563 = (new cljs.core.PersistentVector(null,2,(5),inst_64558,inst_64562,null));
var state_64582__$1 = state_64582;
var statearr_64588_64626 = state_64582__$1;
(statearr_64588_64626[(2)] = inst_64563);

(statearr_64588_64626[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (13))){
var inst_64534 = (state_64582[(2)]);
var inst_64535 = fluree.db.util.async.throw_err.call(null,inst_64534);
var state_64582__$1 = state_64582;
var statearr_64589_64627 = state_64582__$1;
(statearr_64589_64627[(2)] = inst_64535);

(statearr_64589_64627[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (22))){
var inst_64538 = (state_64582[(7)]);
var inst_64530 = (state_64582[(9)]);
var inst_64565 = (state_64582[(2)]);
var inst_64566 = cljs.core.nth.call(null,inst_64565,(0),null);
var inst_64567 = cljs.core.nth.call(null,inst_64565,(1),null);
var inst_64568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64569 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64571 = [inst_64530,inst_64538];
var inst_64572 = (new cljs.core.PersistentVector(null,2,(5),inst_64570,inst_64571,null));
var inst_64573 = ["get-all",inst_64572,inst_64566];
var inst_64574 = cljs.core.PersistentHashMap.fromArrays(inst_64569,inst_64573);
var inst_64575 = [inst_64574,inst_64567];
var inst_64576 = (new cljs.core.PersistentVector(null,2,(5),inst_64568,inst_64575,null));
var inst_64577 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64576);
var _ = (function (){var statearr_64590 = state_64582;
(statearr_64590[(4)] = cljs.core.rest.call(null,(state_64582[(4)])));

return statearr_64590;
})();
var state_64582__$1 = (function (){var statearr_64591 = state_64582;
(statearr_64591[(10)] = inst_64577);

return statearr_64591;
})();
var statearr_64592_64628 = state_64582__$1;
(statearr_64592_64628[(2)] = inst_64566);

(statearr_64592_64628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (6))){
var state_64582__$1 = state_64582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64582__$1,(9),subject);
} else {
if((state_val_64583 === (17))){
var inst_64530 = (state_64582[(9)]);
var inst_64544 = cljs.core.first.call(null,inst_64530);
var state_64582__$1 = state_64582;
var statearr_64593_64629 = state_64582__$1;
(statearr_64593_64629[(2)] = inst_64544);

(statearr_64593_64629[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (3))){
var inst_64580 = (state_64582[(2)]);
var state_64582__$1 = state_64582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64582__$1,inst_64580);
} else {
if((state_val_64583 === (12))){
var inst_64530 = (state_64582[(9)]);
var inst_64538 = (state_64582[(2)]);
var inst_64539 = cljs.core.vector_QMARK_.call(null,inst_64530);
var state_64582__$1 = (function (){var statearr_64594 = state_64582;
(statearr_64594[(7)] = inst_64538);

return statearr_64594;
})();
if(inst_64539){
var statearr_64595_64630 = state_64582__$1;
(statearr_64595_64630[(1)] = (14));

} else {
var statearr_64596_64631 = state_64582__$1;
(statearr_64596_64631[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (2))){
var _ = (function (){var statearr_64597 = state_64582;
(statearr_64597[(4)] = cljs.core.cons.call(null,(5),(state_64582[(4)])));

return statearr_64597;
})();
var inst_64523 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_64582__$1 = state_64582;
if(inst_64523){
var statearr_64598_64632 = state_64582__$1;
(statearr_64598_64632[(1)] = (6));

} else {
var statearr_64599_64633 = state_64582__$1;
(statearr_64599_64633[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (23))){
var inst_64555 = (state_64582[(2)]);
var inst_64556 = fluree.db.util.async.throw_err.call(null,inst_64555);
var state_64582__$1 = state_64582;
var statearr_64600_64634 = state_64582__$1;
(statearr_64600_64634[(2)] = inst_64556);

(statearr_64600_64634[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (19))){
var inst_64547 = (state_64582[(2)]);
var state_64582__$1 = state_64582;
var statearr_64601_64635 = state_64582__$1;
(statearr_64601_64635[(2)] = inst_64547);

(statearr_64601_64635[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (11))){
var state_64582__$1 = state_64582;
var statearr_64603_64636 = state_64582__$1;
(statearr_64603_64636[(2)] = path);

(statearr_64603_64636[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (9))){
var inst_64526 = (state_64582[(2)]);
var inst_64527 = fluree.db.util.async.throw_err.call(null,inst_64526);
var state_64582__$1 = state_64582;
var statearr_64604_64637 = state_64582__$1;
(statearr_64604_64637[(2)] = inst_64527);

(statearr_64604_64637[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (5))){
var _ = (function (){var statearr_64605 = state_64582;
(statearr_64605[(4)] = cljs.core.rest.call(null,(state_64582[(4)])));

return statearr_64605;
})();
var state_64582__$1 = state_64582;
var ex64602 = (state_64582__$1[(2)]);
var statearr_64606_64638 = state_64582__$1;
(statearr_64606_64638[(5)] = ex64602);


if((ex64602 instanceof Error)){
var statearr_64607_64639 = state_64582__$1;
(statearr_64607_64639[(1)] = (4));

(statearr_64607_64639[(5)] = null);

} else {
throw ex64602;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (14))){
var inst_64530 = (state_64582[(9)]);
var inst_64541 = cljs.core.count.call(null,inst_64530);
var inst_64542 = cljs.core._EQ_.call(null,(1),inst_64541);
var state_64582__$1 = state_64582;
if(inst_64542){
var statearr_64608_64640 = state_64582__$1;
(statearr_64608_64640[(1)] = (17));

} else {
var statearr_64609_64641 = state_64582__$1;
(statearr_64609_64641[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (16))){
var inst_64550 = (state_64582[(8)]);
var inst_64550__$1 = (state_64582[(2)]);
var inst_64551 = cljs.core.int_QMARK_.call(null,inst_64550__$1);
var state_64582__$1 = (function (){var statearr_64610 = state_64582;
(statearr_64610[(8)] = inst_64550__$1);

return statearr_64610;
})();
if(inst_64551){
var statearr_64611_64642 = state_64582__$1;
(statearr_64611_64642[(1)] = (20));

} else {
var statearr_64612_64643 = state_64582__$1;
(statearr_64612_64643[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (10))){
var state_64582__$1 = state_64582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64582__$1,(13),path);
} else {
if((state_val_64583 === (18))){
var inst_64530 = (state_64582[(9)]);
var state_64582__$1 = state_64582;
var statearr_64613_64644 = state_64582__$1;
(statearr_64613_64644[(2)] = inst_64530);

(statearr_64613_64644[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64583 === (8))){
var inst_64530 = (state_64582[(2)]);
var inst_64531 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_64582__$1 = (function (){var statearr_64614 = state_64582;
(statearr_64614[(9)] = inst_64530);

return statearr_64614;
})();
if(inst_64531){
var statearr_64615_64645 = state_64582__$1;
(statearr_64615_64645[(1)] = (10));

} else {
var statearr_64616_64646 = state_64582__$1;
(statearr_64616_64646[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0 = (function (){
var statearr_64617 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64617[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__);

(statearr_64617[(1)] = (1));

return statearr_64617;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1 = (function (state_64582){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64618){var ex__2687__auto__ = e64618;
var statearr_64619_64647 = state_64582;
(statearr_64619_64647[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64582[(4)]))){
var statearr_64620_64648 = state_64582;
(statearr_64620_64648[(1)] = cljs.core.first.call(null,(state_64582[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64649 = state_64582;
state_64582 = G__64649;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__ = function(state_64582){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1.call(this,state_64582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64621 = f__2707__auto__.call(null);
(statearr_64621[(6)] = c__2706__auto__);

return statearr_64621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64688){
var state_val_64689 = (state_64688[(1)]);
if((state_val_64689 === (7))){
var state_64688__$1 = state_64688;
var statearr_64690_64714 = state_64688__$1;
(statearr_64690_64714[(2)] = subject);

(statearr_64690_64714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64689 === (1))){
var state_64688__$1 = state_64688;
var statearr_64691_64715 = state_64688__$1;
(statearr_64691_64715[(2)] = null);

(statearr_64691_64715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64689 === (4))){
var inst_64650 = (state_64688[(2)]);
var state_64688__$1 = state_64688;
var statearr_64692_64716 = state_64688__$1;
(statearr_64692_64716[(2)] = inst_64650);

(statearr_64692_64716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64689 === (13))){
var inst_64667 = (state_64688[(2)]);
var inst_64668 = fluree.db.util.async.throw_err.call(null,inst_64667);
var state_64688__$1 = state_64688;
var statearr_64693_64717 = state_64688__$1;
(statearr_64693_64717[(2)] = inst_64668);

(statearr_64693_64717[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64689 === (6))){
var state_64688__$1 = state_64688;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64688__$1,(9),subject);
} else {
if((state_val_64689 === (3))){
var inst_64686 = (state_64688[(2)]);
var state_64688__$1 = state_64688;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64688__$1,inst_64686);
} else {
if((state_val_64689 === (12))){
var inst_64663 = (state_64688[(7)]);
var inst_64671 = (state_64688[(2)]);
var inst_64672 = fluree.db.dbfunctions.internal.get_in.call(null,inst_64663,inst_64671);
var inst_64673 = cljs.core.count.call(null,inst_64671);
var inst_64674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64675 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64677 = [inst_64663,inst_64671];
var inst_64678 = (new cljs.core.PersistentVector(null,2,(5),inst_64676,inst_64677,null));
var inst_64679 = ["get-in",inst_64678,inst_64672];
var inst_64680 = cljs.core.PersistentHashMap.fromArrays(inst_64675,inst_64679);
var inst_64681 = [inst_64680,inst_64673];
var inst_64682 = (new cljs.core.PersistentVector(null,2,(5),inst_64674,inst_64681,null));
var inst_64683 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64682);
var _ = (function (){var statearr_64694 = state_64688;
(statearr_64694[(4)] = cljs.core.rest.call(null,(state_64688[(4)])));

return statearr_64694;
})();
var state_64688__$1 = (function (){var statearr_64695 = state_64688;
(statearr_64695[(8)] = inst_64683);

return statearr_64695;
})();
var statearr_64696_64718 = state_64688__$1;
(statearr_64696_64718[(2)] = inst_64672);

(statearr_64696_64718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64689 === (2))){
var _ = (function (){var statearr_64697 = state_64688;
(statearr_64697[(4)] = cljs.core.cons.call(null,(5),(state_64688[(4)])));

return statearr_64697;
})();
var inst_64656 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_64688__$1 = state_64688;
if(inst_64656){
var statearr_64698_64719 = state_64688__$1;
(statearr_64698_64719[(1)] = (6));

} else {
var statearr_64699_64720 = state_64688__$1;
(statearr_64699_64720[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64689 === (11))){
var state_64688__$1 = state_64688;
var statearr_64701_64721 = state_64688__$1;
(statearr_64701_64721[(2)] = path);

(statearr_64701_64721[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64689 === (9))){
var inst_64659 = (state_64688[(2)]);
var inst_64660 = fluree.db.util.async.throw_err.call(null,inst_64659);
var state_64688__$1 = state_64688;
var statearr_64702_64722 = state_64688__$1;
(statearr_64702_64722[(2)] = inst_64660);

(statearr_64702_64722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64689 === (5))){
var _ = (function (){var statearr_64703 = state_64688;
(statearr_64703[(4)] = cljs.core.rest.call(null,(state_64688[(4)])));

return statearr_64703;
})();
var state_64688__$1 = state_64688;
var ex64700 = (state_64688__$1[(2)]);
var statearr_64704_64723 = state_64688__$1;
(statearr_64704_64723[(5)] = ex64700);


if((ex64700 instanceof Error)){
var statearr_64705_64724 = state_64688__$1;
(statearr_64705_64724[(1)] = (4));

(statearr_64705_64724[(5)] = null);

} else {
throw ex64700;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64689 === (10))){
var state_64688__$1 = state_64688;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64688__$1,(13),path);
} else {
if((state_val_64689 === (8))){
var inst_64663 = (state_64688[(2)]);
var inst_64664 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_64688__$1 = (function (){var statearr_64706 = state_64688;
(statearr_64706[(7)] = inst_64663);

return statearr_64706;
})();
if(inst_64664){
var statearr_64707_64725 = state_64688__$1;
(statearr_64707_64725[(1)] = (10));

} else {
var statearr_64708_64726 = state_64688__$1;
(statearr_64708_64726[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0 = (function (){
var statearr_64709 = [null,null,null,null,null,null,null,null,null];
(statearr_64709[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__);

(statearr_64709[(1)] = (1));

return statearr_64709;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1 = (function (state_64688){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64688);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64710){var ex__2687__auto__ = e64710;
var statearr_64711_64727 = state_64688;
(statearr_64711_64727[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64688[(4)]))){
var statearr_64712_64728 = state_64688;
(statearr_64712_64728[(1)] = cljs.core.first.call(null,(state_64688[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64729 = state_64688;
state_64688 = G__64729;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__ = function(state_64688){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1.call(this,state_64688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64713 = f__2707__auto__.call(null);
(statearr_64713[(6)] = c__2706__auto__);

return statearr_64713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__64730,key_or_ks){
var map__64731 = p__64730;
var map__64731__$1 = cljs.core.__destructure_map.call(null,map__64731);
var _QMARK_ctx = map__64731__$1;
var db = cljs.core.get.call(null,map__64731__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_.call(null,key_or_ks)){
return cljs.core.get_in.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64776){
var state_val_64777 = (state_64776[(1)]);
if((state_val_64777 === (7))){
var state_64776__$1 = state_64776;
var statearr_64778_64807 = state_64776__$1;
(statearr_64778_64807[(2)] = coll);

(statearr_64778_64807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (1))){
var state_64776__$1 = state_64776;
var statearr_64779_64808 = state_64776__$1;
(statearr_64779_64808[(2)] = null);

(statearr_64779_64808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (4))){
var inst_64732 = (state_64776[(2)]);
var state_64776__$1 = state_64776;
var statearr_64780_64809 = state_64776__$1;
(statearr_64780_64809[(2)] = inst_64732);

(statearr_64780_64809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (15))){
var inst_64752 = (state_64776[(7)]);
var inst_64760 = (state_64776[(2)]);
var inst_64761 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_64752,inst_64760);
var inst_64762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64763 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64765 = [inst_64752,inst_64760];
var inst_64766 = (new cljs.core.PersistentVector(null,2,(5),inst_64764,inst_64765,null));
var inst_64767 = ["contains?",inst_64766,inst_64761];
var inst_64768 = cljs.core.PersistentHashMap.fromArrays(inst_64763,inst_64767);
var inst_64769 = [inst_64768,(10)];
var inst_64770 = (new cljs.core.PersistentVector(null,2,(5),inst_64762,inst_64769,null));
var inst_64771 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64770);
var _ = (function (){var statearr_64781 = state_64776;
(statearr_64781[(4)] = cljs.core.rest.call(null,(state_64776[(4)])));

return statearr_64781;
})();
var state_64776__$1 = (function (){var statearr_64782 = state_64776;
(statearr_64782[(8)] = inst_64771);

return statearr_64782;
})();
var statearr_64783_64810 = state_64776__$1;
(statearr_64783_64810[(2)] = inst_64761);

(statearr_64783_64810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (13))){
var state_64776__$1 = state_64776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64776__$1,(16),key);
} else {
if((state_val_64777 === (6))){
var state_64776__$1 = state_64776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64776__$1,(9),coll);
} else {
if((state_val_64777 === (3))){
var inst_64774 = (state_64776[(2)]);
var state_64776__$1 = state_64776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64776__$1,inst_64774);
} else {
if((state_val_64777 === (12))){
var inst_64752 = (state_64776[(2)]);
var inst_64753 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_64776__$1 = (function (){var statearr_64784 = state_64776;
(statearr_64784[(7)] = inst_64752);

return statearr_64784;
})();
if(inst_64753){
var statearr_64785_64811 = state_64776__$1;
(statearr_64785_64811[(1)] = (13));

} else {
var statearr_64786_64812 = state_64776__$1;
(statearr_64786_64812[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (2))){
var _ = (function (){var statearr_64787 = state_64776;
(statearr_64787[(4)] = cljs.core.cons.call(null,(5),(state_64776[(4)])));

return statearr_64787;
})();
var inst_64738 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_64776__$1 = state_64776;
if(inst_64738){
var statearr_64788_64813 = state_64776__$1;
(statearr_64788_64813[(1)] = (6));

} else {
var statearr_64789_64814 = state_64776__$1;
(statearr_64789_64814[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (11))){
var inst_64745 = (state_64776[(9)]);
var inst_64749 = cljs.core.flatten.call(null,inst_64745);
var inst_64750 = cljs.core.set.call(null,inst_64749);
var state_64776__$1 = state_64776;
var statearr_64791_64815 = state_64776__$1;
(statearr_64791_64815[(2)] = inst_64750);

(statearr_64791_64815[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (9))){
var inst_64741 = (state_64776[(2)]);
var inst_64742 = fluree.db.util.async.throw_err.call(null,inst_64741);
var state_64776__$1 = state_64776;
var statearr_64792_64816 = state_64776__$1;
(statearr_64792_64816[(2)] = inst_64742);

(statearr_64792_64816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (5))){
var _ = (function (){var statearr_64793 = state_64776;
(statearr_64793[(4)] = cljs.core.rest.call(null,(state_64776[(4)])));

return statearr_64793;
})();
var state_64776__$1 = state_64776;
var ex64790 = (state_64776__$1[(2)]);
var statearr_64794_64817 = state_64776__$1;
(statearr_64794_64817[(5)] = ex64790);


if((ex64790 instanceof Error)){
var statearr_64795_64818 = state_64776__$1;
(statearr_64795_64818[(1)] = (4));

(statearr_64795_64818[(5)] = null);

} else {
throw ex64790;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (14))){
var state_64776__$1 = state_64776;
var statearr_64796_64819 = state_64776__$1;
(statearr_64796_64819[(2)] = key);

(statearr_64796_64819[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (16))){
var inst_64756 = (state_64776[(2)]);
var inst_64757 = fluree.db.util.async.throw_err.call(null,inst_64756);
var state_64776__$1 = state_64776;
var statearr_64797_64820 = state_64776__$1;
(statearr_64797_64820[(2)] = inst_64757);

(statearr_64797_64820[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (10))){
var inst_64745 = (state_64776[(9)]);
var state_64776__$1 = state_64776;
var statearr_64798_64821 = state_64776__$1;
(statearr_64798_64821[(2)] = inst_64745);

(statearr_64798_64821[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64777 === (8))){
var inst_64745 = (state_64776[(9)]);
var inst_64745__$1 = (state_64776[(2)]);
var inst_64746 = cljs.core.set_QMARK_.call(null,inst_64745__$1);
var state_64776__$1 = (function (){var statearr_64799 = state_64776;
(statearr_64799[(9)] = inst_64745__$1);

return statearr_64799;
})();
if(inst_64746){
var statearr_64800_64822 = state_64776__$1;
(statearr_64800_64822[(1)] = (10));

} else {
var statearr_64801_64823 = state_64776__$1;
(statearr_64801_64823[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_64802 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64802[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__);

(statearr_64802[(1)] = (1));

return statearr_64802;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1 = (function (state_64776){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64803){var ex__2687__auto__ = e64803;
var statearr_64804_64824 = state_64776;
(statearr_64804_64824[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64776[(4)]))){
var statearr_64805_64825 = state_64776;
(statearr_64805_64825[(1)] = cljs.core.first.call(null,(state_64776[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64826 = state_64776;
state_64776 = G__64826;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__ = function(state_64776){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1.call(this,state_64776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64806 = f__2707__auto__.call(null);
(statearr_64806[(6)] = c__2706__auto__);

return statearr_64806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64898 = arguments.length;
var i__5770__auto___64899 = (0);
while(true){
if((i__5770__auto___64899 < len__5769__auto___64898)){
args__5775__auto__.push((arguments[i__5770__auto___64899]));

var G__64900 = (i__5770__auto___64899 + (1));
i__5770__auto___64899 = G__64900;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64872){
var state_val_64873 = (state_64872[(1)]);
if((state_val_64873 === (7))){
var inst_64838 = (state_64872[(7)]);
var inst_64842 = cljs.core.first.call(null,inst_64838);
var inst_64843 = cljs.core.coll_QMARK_.call(null,inst_64842);
var state_64872__$1 = state_64872;
var statearr_64874_64901 = state_64872__$1;
(statearr_64874_64901[(2)] = inst_64843);

(statearr_64874_64901[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64873 === (1))){
var state_64872__$1 = state_64872;
var statearr_64875_64902 = state_64872__$1;
(statearr_64875_64902[(2)] = null);

(statearr_64875_64902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64873 === (4))){
var inst_64829 = (state_64872[(2)]);
var state_64872__$1 = state_64872;
var statearr_64876_64903 = state_64872__$1;
(statearr_64876_64903[(2)] = inst_64829);

(statearr_64876_64903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64873 === (6))){
var inst_64838 = (state_64872[(7)]);
var inst_64840 = (state_64872[(8)]);
var inst_64837 = (state_64872[(2)]);
var inst_64838__$1 = fluree.db.util.async.throw_err.call(null,inst_64837);
var inst_64839 = cljs.core.count.call(null,inst_64838__$1);
var inst_64840__$1 = cljs.core._EQ_.call(null,(1),inst_64839);
var state_64872__$1 = (function (){var statearr_64877 = state_64872;
(statearr_64877[(7)] = inst_64838__$1);

(statearr_64877[(8)] = inst_64840__$1);

return statearr_64877;
})();
if(inst_64840__$1){
var statearr_64878_64904 = state_64872__$1;
(statearr_64878_64904[(1)] = (7));

} else {
var statearr_64879_64905 = state_64872__$1;
(statearr_64879_64905[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64873 === (3))){
var inst_64870 = (state_64872[(2)]);
var state_64872__$1 = state_64872;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64872__$1,inst_64870);
} else {
if((state_val_64873 === (12))){
var inst_64851 = (state_64872[(2)]);
var inst_64852 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_64851);
var inst_64853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64854 = [inst_64851];
var inst_64855 = (new cljs.core.PersistentVector(null,1,(5),inst_64853,inst_64854,null));
var inst_64856 = cljs.core.count.call(null,inst_64855);
var inst_64857 = ((9) + inst_64856);
var inst_64858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64859 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64861 = [inst_64851];
var inst_64862 = (new cljs.core.PersistentVector(null,1,(5),inst_64860,inst_64861,null));
var inst_64863 = ["hash-set",inst_64862,inst_64852];
var inst_64864 = cljs.core.PersistentHashMap.fromArrays(inst_64859,inst_64863);
var inst_64865 = [inst_64864,inst_64857];
var inst_64866 = (new cljs.core.PersistentVector(null,2,(5),inst_64858,inst_64865,null));
var inst_64867 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64866);
var _ = (function (){var statearr_64880 = state_64872;
(statearr_64880[(4)] = cljs.core.rest.call(null,(state_64872[(4)])));

return statearr_64880;
})();
var state_64872__$1 = (function (){var statearr_64881 = state_64872;
(statearr_64881[(9)] = inst_64867);

return statearr_64881;
})();
var statearr_64882_64906 = state_64872__$1;
(statearr_64882_64906[(2)] = inst_64852);

(statearr_64882_64906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64873 === (2))){
var _ = (function (){var statearr_64883 = state_64872;
(statearr_64883[(4)] = cljs.core.cons.call(null,(5),(state_64872[(4)])));

return statearr_64883;
})();
var inst_64835 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64872__$1 = state_64872;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64872__$1,(6),inst_64835);
} else {
if((state_val_64873 === (11))){
var inst_64838 = (state_64872[(7)]);
var state_64872__$1 = state_64872;
var statearr_64885_64907 = state_64872__$1;
(statearr_64885_64907[(2)] = inst_64838);

(statearr_64885_64907[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64873 === (9))){
var inst_64846 = (state_64872[(2)]);
var state_64872__$1 = state_64872;
if(cljs.core.truth_(inst_64846)){
var statearr_64886_64908 = state_64872__$1;
(statearr_64886_64908[(1)] = (10));

} else {
var statearr_64887_64909 = state_64872__$1;
(statearr_64887_64909[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64873 === (5))){
var _ = (function (){var statearr_64888 = state_64872;
(statearr_64888[(4)] = cljs.core.rest.call(null,(state_64872[(4)])));

return statearr_64888;
})();
var state_64872__$1 = state_64872;
var ex64884 = (state_64872__$1[(2)]);
var statearr_64889_64910 = state_64872__$1;
(statearr_64889_64910[(5)] = ex64884);


if((ex64884 instanceof Error)){
var statearr_64890_64911 = state_64872__$1;
(statearr_64890_64911[(1)] = (4));

(statearr_64890_64911[(5)] = null);

} else {
throw ex64884;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64873 === (10))){
var inst_64838 = (state_64872[(7)]);
var inst_64848 = cljs.core.first.call(null,inst_64838);
var state_64872__$1 = state_64872;
var statearr_64891_64912 = state_64872__$1;
(statearr_64891_64912[(2)] = inst_64848);

(statearr_64891_64912[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64873 === (8))){
var inst_64840 = (state_64872[(8)]);
var state_64872__$1 = state_64872;
var statearr_64892_64913 = state_64872__$1;
(statearr_64892_64913[(2)] = inst_64840);

(statearr_64892_64913[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_64893 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64893[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_64893[(1)] = (1));

return statearr_64893;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_64872){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64872);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64894){var ex__2687__auto__ = e64894;
var statearr_64895_64914 = state_64872;
(statearr_64895_64914[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64872[(4)]))){
var statearr_64896_64915 = state_64872;
(statearr_64896_64915[(1)] = cljs.core.first.call(null,(state_64872[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64916 = state_64872;
state_64872 = G__64916;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_64872){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_64872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64897 = f__2707__auto__.call(null);
(statearr_64897[(6)] = c__2706__auto__);

return statearr_64897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq64827){
var G__64828 = cljs.core.first.call(null,seq64827);
var seq64827__$1 = cljs.core.next.call(null,seq64827);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64828,seq64827__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64966 = arguments.length;
var i__5770__auto___64967 = (0);
while(true){
if((i__5770__auto___64967 < len__5769__auto___64966)){
args__5775__auto__.push((arguments[i__5770__auto___64967]));

var G__64968 = (i__5770__auto___64967 + (1));
i__5770__auto___64967 = G__64968;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64949){
var state_val_64950 = (state_64949[(1)]);
if((state_val_64950 === (1))){
var state_64949__$1 = state_64949;
var statearr_64951_64969 = state_64949__$1;
(statearr_64951_64969[(2)] = null);

(statearr_64951_64969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64950 === (2))){
var _ = (function (){var statearr_64952 = state_64949;
(statearr_64952[(4)] = cljs.core.cons.call(null,(5),(state_64949[(4)])));

return statearr_64952;
})();
var inst_64925 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64949__$1 = state_64949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64949__$1,(6),inst_64925);
} else {
if((state_val_64950 === (3))){
var inst_64947 = (state_64949[(2)]);
var state_64949__$1 = state_64949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64949__$1,inst_64947);
} else {
if((state_val_64950 === (4))){
var inst_64919 = (state_64949[(2)]);
var state_64949__$1 = state_64949;
var statearr_64954_64970 = state_64949__$1;
(statearr_64954_64970[(2)] = inst_64919);

(statearr_64954_64970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64950 === (5))){
var _ = (function (){var statearr_64955 = state_64949;
(statearr_64955[(4)] = cljs.core.rest.call(null,(state_64949[(4)])));

return statearr_64955;
})();
var state_64949__$1 = state_64949;
var ex64953 = (state_64949__$1[(2)]);
var statearr_64956_64971 = state_64949__$1;
(statearr_64956_64971[(5)] = ex64953);


if((ex64953 instanceof Error)){
var statearr_64957_64972 = state_64949__$1;
(statearr_64957_64972[(1)] = (4));

(statearr_64957_64972[(5)] = null);

} else {
throw ex64953;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64950 === (6))){
var inst_64927 = (state_64949[(2)]);
var inst_64928 = fluree.db.util.async.throw_err.call(null,inst_64927);
var inst_64929 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_64928);
var inst_64930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64931 = [inst_64928];
var inst_64932 = (new cljs.core.PersistentVector(null,1,(5),inst_64930,inst_64931,null));
var inst_64933 = cljs.core.count.call(null,inst_64932);
var inst_64934 = ((9) + inst_64933);
var inst_64935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64936 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64938 = [inst_64928];
var inst_64939 = (new cljs.core.PersistentVector(null,1,(5),inst_64937,inst_64938,null));
var inst_64940 = ["==",inst_64939,inst_64929];
var inst_64941 = cljs.core.PersistentHashMap.fromArrays(inst_64936,inst_64940);
var inst_64942 = [inst_64941,inst_64934];
var inst_64943 = (new cljs.core.PersistentVector(null,2,(5),inst_64935,inst_64942,null));
var inst_64944 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64943);
var _ = (function (){var statearr_64958 = state_64949;
(statearr_64958[(4)] = cljs.core.rest.call(null,(state_64949[(4)])));

return statearr_64958;
})();
var state_64949__$1 = (function (){var statearr_64959 = state_64949;
(statearr_64959[(7)] = inst_64944);

return statearr_64959;
})();
var statearr_64960_64973 = state_64949__$1;
(statearr_64960_64973[(2)] = inst_64929);

(statearr_64960_64973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_64961 = [null,null,null,null,null,null,null,null];
(statearr_64961[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_64961[(1)] = (1));

return statearr_64961;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_64949){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_64949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64962){var ex__2687__auto__ = e64962;
var statearr_64963_64974 = state_64949;
(statearr_64963_64974[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_64949[(4)]))){
var statearr_64964_64975 = state_64949;
(statearr_64964_64975[(1)] = cljs.core.first.call(null,(state_64949[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64976 = state_64949;
state_64949 = G__64976;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_64949){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_64949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64965 = f__2707__auto__.call(null);
(statearr_64965[(6)] = c__2706__auto__);

return statearr_64965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq64917){
var G__64918 = cljs.core.first.call(null,seq64917);
var seq64917__$1 = cljs.core.next.call(null,seq64917);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64918,seq64917__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65026 = arguments.length;
var i__5770__auto___65027 = (0);
while(true){
if((i__5770__auto___65027 < len__5769__auto___65026)){
args__5775__auto__.push((arguments[i__5770__auto___65027]));

var G__65028 = (i__5770__auto___65027 + (1));
i__5770__auto___65027 = G__65028;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65009){
var state_val_65010 = (state_65009[(1)]);
if((state_val_65010 === (1))){
var state_65009__$1 = state_65009;
var statearr_65011_65029 = state_65009__$1;
(statearr_65011_65029[(2)] = null);

(statearr_65011_65029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65010 === (2))){
var _ = (function (){var statearr_65012 = state_65009;
(statearr_65012[(4)] = cljs.core.cons.call(null,(5),(state_65009[(4)])));

return statearr_65012;
})();
var inst_64985 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65009__$1 = state_65009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65009__$1,(6),inst_64985);
} else {
if((state_val_65010 === (3))){
var inst_65007 = (state_65009[(2)]);
var state_65009__$1 = state_65009;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65009__$1,inst_65007);
} else {
if((state_val_65010 === (4))){
var inst_64979 = (state_65009[(2)]);
var state_65009__$1 = state_65009;
var statearr_65014_65030 = state_65009__$1;
(statearr_65014_65030[(2)] = inst_64979);

(statearr_65014_65030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65010 === (5))){
var _ = (function (){var statearr_65015 = state_65009;
(statearr_65015[(4)] = cljs.core.rest.call(null,(state_65009[(4)])));

return statearr_65015;
})();
var state_65009__$1 = state_65009;
var ex65013 = (state_65009__$1[(2)]);
var statearr_65016_65031 = state_65009__$1;
(statearr_65016_65031[(5)] = ex65013);


if((ex65013 instanceof Error)){
var statearr_65017_65032 = state_65009__$1;
(statearr_65017_65032[(1)] = (4));

(statearr_65017_65032[(5)] = null);

} else {
throw ex65013;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65010 === (6))){
var inst_64987 = (state_65009[(2)]);
var inst_64988 = fluree.db.util.async.throw_err.call(null,inst_64987);
var inst_64989 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_64988);
var inst_64990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64991 = [inst_64988];
var inst_64992 = (new cljs.core.PersistentVector(null,1,(5),inst_64990,inst_64991,null));
var inst_64993 = cljs.core.count.call(null,inst_64992);
var inst_64994 = ((9) + inst_64993);
var inst_64995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64996 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64998 = [inst_64988];
var inst_64999 = (new cljs.core.PersistentVector(null,1,(5),inst_64997,inst_64998,null));
var inst_65000 = [">",inst_64999,inst_64989];
var inst_65001 = cljs.core.PersistentHashMap.fromArrays(inst_64996,inst_65000);
var inst_65002 = [inst_65001,inst_64994];
var inst_65003 = (new cljs.core.PersistentVector(null,2,(5),inst_64995,inst_65002,null));
var inst_65004 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65003);
var _ = (function (){var statearr_65018 = state_65009;
(statearr_65018[(4)] = cljs.core.rest.call(null,(state_65009[(4)])));

return statearr_65018;
})();
var state_65009__$1 = (function (){var statearr_65019 = state_65009;
(statearr_65019[(7)] = inst_65004);

return statearr_65019;
})();
var statearr_65020_65033 = state_65009__$1;
(statearr_65020_65033[(2)] = inst_64989);

(statearr_65020_65033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65021 = [null,null,null,null,null,null,null,null];
(statearr_65021[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65021[(1)] = (1));

return statearr_65021;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65009){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65009);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65022){var ex__2687__auto__ = e65022;
var statearr_65023_65034 = state_65009;
(statearr_65023_65034[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65009[(4)]))){
var statearr_65024_65035 = state_65009;
(statearr_65024_65035[(1)] = cljs.core.first.call(null,(state_65009[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65036 = state_65009;
state_65009 = G__65036;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65009){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65025 = f__2707__auto__.call(null);
(statearr_65025[(6)] = c__2706__auto__);

return statearr_65025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq64977){
var G__64978 = cljs.core.first.call(null,seq64977);
var seq64977__$1 = cljs.core.next.call(null,seq64977);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64978,seq64977__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65086 = arguments.length;
var i__5770__auto___65087 = (0);
while(true){
if((i__5770__auto___65087 < len__5769__auto___65086)){
args__5775__auto__.push((arguments[i__5770__auto___65087]));

var G__65088 = (i__5770__auto___65087 + (1));
i__5770__auto___65087 = G__65088;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65069){
var state_val_65070 = (state_65069[(1)]);
if((state_val_65070 === (1))){
var state_65069__$1 = state_65069;
var statearr_65071_65089 = state_65069__$1;
(statearr_65071_65089[(2)] = null);

(statearr_65071_65089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (2))){
var _ = (function (){var statearr_65072 = state_65069;
(statearr_65072[(4)] = cljs.core.cons.call(null,(5),(state_65069[(4)])));

return statearr_65072;
})();
var inst_65045 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65069__$1 = state_65069;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65069__$1,(6),inst_65045);
} else {
if((state_val_65070 === (3))){
var inst_65067 = (state_65069[(2)]);
var state_65069__$1 = state_65069;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65069__$1,inst_65067);
} else {
if((state_val_65070 === (4))){
var inst_65039 = (state_65069[(2)]);
var state_65069__$1 = state_65069;
var statearr_65074_65090 = state_65069__$1;
(statearr_65074_65090[(2)] = inst_65039);

(statearr_65074_65090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (5))){
var _ = (function (){var statearr_65075 = state_65069;
(statearr_65075[(4)] = cljs.core.rest.call(null,(state_65069[(4)])));

return statearr_65075;
})();
var state_65069__$1 = state_65069;
var ex65073 = (state_65069__$1[(2)]);
var statearr_65076_65091 = state_65069__$1;
(statearr_65076_65091[(5)] = ex65073);


if((ex65073 instanceof Error)){
var statearr_65077_65092 = state_65069__$1;
(statearr_65077_65092[(1)] = (4));

(statearr_65077_65092[(5)] = null);

} else {
throw ex65073;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (6))){
var inst_65047 = (state_65069[(2)]);
var inst_65048 = fluree.db.util.async.throw_err.call(null,inst_65047);
var inst_65049 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_65048);
var inst_65050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65051 = [inst_65048];
var inst_65052 = (new cljs.core.PersistentVector(null,1,(5),inst_65050,inst_65051,null));
var inst_65053 = cljs.core.count.call(null,inst_65052);
var inst_65054 = ((9) + inst_65053);
var inst_65055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65056 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65058 = [inst_65048];
var inst_65059 = (new cljs.core.PersistentVector(null,1,(5),inst_65057,inst_65058,null));
var inst_65060 = ["<",inst_65059,inst_65049];
var inst_65061 = cljs.core.PersistentHashMap.fromArrays(inst_65056,inst_65060);
var inst_65062 = [inst_65061,inst_65054];
var inst_65063 = (new cljs.core.PersistentVector(null,2,(5),inst_65055,inst_65062,null));
var inst_65064 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65063);
var _ = (function (){var statearr_65078 = state_65069;
(statearr_65078[(4)] = cljs.core.rest.call(null,(state_65069[(4)])));

return statearr_65078;
})();
var state_65069__$1 = (function (){var statearr_65079 = state_65069;
(statearr_65079[(7)] = inst_65064);

return statearr_65079;
})();
var statearr_65080_65093 = state_65069__$1;
(statearr_65080_65093[(2)] = inst_65049);

(statearr_65080_65093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65081 = [null,null,null,null,null,null,null,null];
(statearr_65081[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65081[(1)] = (1));

return statearr_65081;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65069){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65069);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65082){var ex__2687__auto__ = e65082;
var statearr_65083_65094 = state_65069;
(statearr_65083_65094[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65069[(4)]))){
var statearr_65084_65095 = state_65069;
(statearr_65084_65095[(1)] = cljs.core.first.call(null,(state_65069[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65096 = state_65069;
state_65069 = G__65096;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65069){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65085 = f__2707__auto__.call(null);
(statearr_65085[(6)] = c__2706__auto__);

return statearr_65085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq65037){
var G__65038 = cljs.core.first.call(null,seq65037);
var seq65037__$1 = cljs.core.next.call(null,seq65037);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65038,seq65037__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65146 = arguments.length;
var i__5770__auto___65147 = (0);
while(true){
if((i__5770__auto___65147 < len__5769__auto___65146)){
args__5775__auto__.push((arguments[i__5770__auto___65147]));

var G__65148 = (i__5770__auto___65147 + (1));
i__5770__auto___65147 = G__65148;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65129){
var state_val_65130 = (state_65129[(1)]);
if((state_val_65130 === (1))){
var state_65129__$1 = state_65129;
var statearr_65131_65149 = state_65129__$1;
(statearr_65131_65149[(2)] = null);

(statearr_65131_65149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65130 === (2))){
var _ = (function (){var statearr_65132 = state_65129;
(statearr_65132[(4)] = cljs.core.cons.call(null,(5),(state_65129[(4)])));

return statearr_65132;
})();
var inst_65105 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65129__$1 = state_65129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65129__$1,(6),inst_65105);
} else {
if((state_val_65130 === (3))){
var inst_65127 = (state_65129[(2)]);
var state_65129__$1 = state_65129;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65129__$1,inst_65127);
} else {
if((state_val_65130 === (4))){
var inst_65099 = (state_65129[(2)]);
var state_65129__$1 = state_65129;
var statearr_65134_65150 = state_65129__$1;
(statearr_65134_65150[(2)] = inst_65099);

(statearr_65134_65150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65130 === (5))){
var _ = (function (){var statearr_65135 = state_65129;
(statearr_65135[(4)] = cljs.core.rest.call(null,(state_65129[(4)])));

return statearr_65135;
})();
var state_65129__$1 = state_65129;
var ex65133 = (state_65129__$1[(2)]);
var statearr_65136_65151 = state_65129__$1;
(statearr_65136_65151[(5)] = ex65133);


if((ex65133 instanceof Error)){
var statearr_65137_65152 = state_65129__$1;
(statearr_65137_65152[(1)] = (4));

(statearr_65137_65152[(5)] = null);

} else {
throw ex65133;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65130 === (6))){
var inst_65107 = (state_65129[(2)]);
var inst_65108 = fluree.db.util.async.throw_err.call(null,inst_65107);
var inst_65109 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_65108);
var inst_65110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65111 = [inst_65108];
var inst_65112 = (new cljs.core.PersistentVector(null,1,(5),inst_65110,inst_65111,null));
var inst_65113 = cljs.core.count.call(null,inst_65112);
var inst_65114 = ((9) + inst_65113);
var inst_65115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65116 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65118 = [inst_65108];
var inst_65119 = (new cljs.core.PersistentVector(null,1,(5),inst_65117,inst_65118,null));
var inst_65120 = ["<=",inst_65119,inst_65109];
var inst_65121 = cljs.core.PersistentHashMap.fromArrays(inst_65116,inst_65120);
var inst_65122 = [inst_65121,inst_65114];
var inst_65123 = (new cljs.core.PersistentVector(null,2,(5),inst_65115,inst_65122,null));
var inst_65124 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65123);
var _ = (function (){var statearr_65138 = state_65129;
(statearr_65138[(4)] = cljs.core.rest.call(null,(state_65129[(4)])));

return statearr_65138;
})();
var state_65129__$1 = (function (){var statearr_65139 = state_65129;
(statearr_65139[(7)] = inst_65124);

return statearr_65139;
})();
var statearr_65140_65153 = state_65129__$1;
(statearr_65140_65153[(2)] = inst_65109);

(statearr_65140_65153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65141 = [null,null,null,null,null,null,null,null];
(statearr_65141[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65141[(1)] = (1));

return statearr_65141;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65129){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65129);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65142){var ex__2687__auto__ = e65142;
var statearr_65143_65154 = state_65129;
(statearr_65143_65154[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65129[(4)]))){
var statearr_65144_65155 = state_65129;
(statearr_65144_65155[(1)] = cljs.core.first.call(null,(state_65129[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65156 = state_65129;
state_65129 = G__65156;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65129){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65145 = f__2707__auto__.call(null);
(statearr_65145[(6)] = c__2706__auto__);

return statearr_65145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq65097){
var G__65098 = cljs.core.first.call(null,seq65097);
var seq65097__$1 = cljs.core.next.call(null,seq65097);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65098,seq65097__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65206 = arguments.length;
var i__5770__auto___65207 = (0);
while(true){
if((i__5770__auto___65207 < len__5769__auto___65206)){
args__5775__auto__.push((arguments[i__5770__auto___65207]));

var G__65208 = (i__5770__auto___65207 + (1));
i__5770__auto___65207 = G__65208;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65189){
var state_val_65190 = (state_65189[(1)]);
if((state_val_65190 === (1))){
var state_65189__$1 = state_65189;
var statearr_65191_65209 = state_65189__$1;
(statearr_65191_65209[(2)] = null);

(statearr_65191_65209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65190 === (2))){
var _ = (function (){var statearr_65192 = state_65189;
(statearr_65192[(4)] = cljs.core.cons.call(null,(5),(state_65189[(4)])));

return statearr_65192;
})();
var inst_65165 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65189__$1 = state_65189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65189__$1,(6),inst_65165);
} else {
if((state_val_65190 === (3))){
var inst_65187 = (state_65189[(2)]);
var state_65189__$1 = state_65189;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65189__$1,inst_65187);
} else {
if((state_val_65190 === (4))){
var inst_65159 = (state_65189[(2)]);
var state_65189__$1 = state_65189;
var statearr_65194_65210 = state_65189__$1;
(statearr_65194_65210[(2)] = inst_65159);

(statearr_65194_65210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65190 === (5))){
var _ = (function (){var statearr_65195 = state_65189;
(statearr_65195[(4)] = cljs.core.rest.call(null,(state_65189[(4)])));

return statearr_65195;
})();
var state_65189__$1 = state_65189;
var ex65193 = (state_65189__$1[(2)]);
var statearr_65196_65211 = state_65189__$1;
(statearr_65196_65211[(5)] = ex65193);


if((ex65193 instanceof Error)){
var statearr_65197_65212 = state_65189__$1;
(statearr_65197_65212[(1)] = (4));

(statearr_65197_65212[(5)] = null);

} else {
throw ex65193;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65190 === (6))){
var inst_65167 = (state_65189[(2)]);
var inst_65168 = fluree.db.util.async.throw_err.call(null,inst_65167);
var inst_65169 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_65168);
var inst_65170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65171 = [inst_65168];
var inst_65172 = (new cljs.core.PersistentVector(null,1,(5),inst_65170,inst_65171,null));
var inst_65173 = cljs.core.count.call(null,inst_65172);
var inst_65174 = ((9) + inst_65173);
var inst_65175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65176 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65178 = [inst_65168];
var inst_65179 = (new cljs.core.PersistentVector(null,1,(5),inst_65177,inst_65178,null));
var inst_65180 = [">=",inst_65179,inst_65169];
var inst_65181 = cljs.core.PersistentHashMap.fromArrays(inst_65176,inst_65180);
var inst_65182 = [inst_65181,inst_65174];
var inst_65183 = (new cljs.core.PersistentVector(null,2,(5),inst_65175,inst_65182,null));
var inst_65184 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65183);
var _ = (function (){var statearr_65198 = state_65189;
(statearr_65198[(4)] = cljs.core.rest.call(null,(state_65189[(4)])));

return statearr_65198;
})();
var state_65189__$1 = (function (){var statearr_65199 = state_65189;
(statearr_65199[(7)] = inst_65184);

return statearr_65199;
})();
var statearr_65200_65213 = state_65189__$1;
(statearr_65200_65213[(2)] = inst_65169);

(statearr_65200_65213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65201 = [null,null,null,null,null,null,null,null];
(statearr_65201[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65201[(1)] = (1));

return statearr_65201;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65189){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65202){var ex__2687__auto__ = e65202;
var statearr_65203_65214 = state_65189;
(statearr_65203_65214[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65189[(4)]))){
var statearr_65204_65215 = state_65189;
(statearr_65204_65215[(1)] = cljs.core.first.call(null,(state_65189[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65216 = state_65189;
state_65189 = G__65216;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65189){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65205 = f__2707__auto__.call(null);
(statearr_65205[(6)] = c__2706__auto__);

return statearr_65205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq65157){
var G__65158 = cljs.core.first.call(null,seq65157);
var seq65157__$1 = cljs.core.next.call(null,seq65157);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65158,seq65157__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65266 = arguments.length;
var i__5770__auto___65267 = (0);
while(true){
if((i__5770__auto___65267 < len__5769__auto___65266)){
args__5775__auto__.push((arguments[i__5770__auto___65267]));

var G__65268 = (i__5770__auto___65267 + (1));
i__5770__auto___65267 = G__65268;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65249){
var state_val_65250 = (state_65249[(1)]);
if((state_val_65250 === (1))){
var state_65249__$1 = state_65249;
var statearr_65251_65269 = state_65249__$1;
(statearr_65251_65269[(2)] = null);

(statearr_65251_65269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65250 === (2))){
var _ = (function (){var statearr_65252 = state_65249;
(statearr_65252[(4)] = cljs.core.cons.call(null,(5),(state_65249[(4)])));

return statearr_65252;
})();
var inst_65225 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65249__$1 = state_65249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65249__$1,(6),inst_65225);
} else {
if((state_val_65250 === (3))){
var inst_65247 = (state_65249[(2)]);
var state_65249__$1 = state_65249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65249__$1,inst_65247);
} else {
if((state_val_65250 === (4))){
var inst_65219 = (state_65249[(2)]);
var state_65249__$1 = state_65249;
var statearr_65254_65270 = state_65249__$1;
(statearr_65254_65270[(2)] = inst_65219);

(statearr_65254_65270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65250 === (5))){
var _ = (function (){var statearr_65255 = state_65249;
(statearr_65255[(4)] = cljs.core.rest.call(null,(state_65249[(4)])));

return statearr_65255;
})();
var state_65249__$1 = state_65249;
var ex65253 = (state_65249__$1[(2)]);
var statearr_65256_65271 = state_65249__$1;
(statearr_65256_65271[(5)] = ex65253);


if((ex65253 instanceof Error)){
var statearr_65257_65272 = state_65249__$1;
(statearr_65257_65272[(1)] = (4));

(statearr_65257_65272[(5)] = null);

} else {
throw ex65253;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65250 === (6))){
var inst_65227 = (state_65249[(2)]);
var inst_65228 = fluree.db.util.async.throw_err.call(null,inst_65227);
var inst_65229 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_65228);
var inst_65230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65231 = [inst_65228];
var inst_65232 = (new cljs.core.PersistentVector(null,1,(5),inst_65230,inst_65231,null));
var inst_65233 = cljs.core.count.call(null,inst_65232);
var inst_65234 = ((9) + inst_65233);
var inst_65235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65236 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65238 = [inst_65228];
var inst_65239 = (new cljs.core.PersistentVector(null,1,(5),inst_65237,inst_65238,null));
var inst_65240 = ["not=",inst_65239,inst_65229];
var inst_65241 = cljs.core.PersistentHashMap.fromArrays(inst_65236,inst_65240);
var inst_65242 = [inst_65241,inst_65234];
var inst_65243 = (new cljs.core.PersistentVector(null,2,(5),inst_65235,inst_65242,null));
var inst_65244 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65243);
var _ = (function (){var statearr_65258 = state_65249;
(statearr_65258[(4)] = cljs.core.rest.call(null,(state_65249[(4)])));

return statearr_65258;
})();
var state_65249__$1 = (function (){var statearr_65259 = state_65249;
(statearr_65259[(7)] = inst_65244);

return statearr_65259;
})();
var statearr_65260_65273 = state_65249__$1;
(statearr_65260_65273[(2)] = inst_65229);

(statearr_65260_65273[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65261 = [null,null,null,null,null,null,null,null];
(statearr_65261[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65261[(1)] = (1));

return statearr_65261;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65249){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65262){var ex__2687__auto__ = e65262;
var statearr_65263_65274 = state_65249;
(statearr_65263_65274[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65249[(4)]))){
var statearr_65264_65275 = state_65249;
(statearr_65264_65275[(1)] = cljs.core.first.call(null,(state_65249[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65276 = state_65249;
state_65249 = G__65276;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65249){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65265 = f__2707__auto__.call(null);
(statearr_65265[(6)] = c__2706__auto__);

return statearr_65265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq65217){
var G__65218 = cljs.core.first.call(null,seq65217);
var seq65217__$1 = cljs.core.next.call(null,seq65217);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65218,seq65217__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65326 = arguments.length;
var i__5770__auto___65327 = (0);
while(true){
if((i__5770__auto___65327 < len__5769__auto___65326)){
args__5775__auto__.push((arguments[i__5770__auto___65327]));

var G__65328 = (i__5770__auto___65327 + (1));
i__5770__auto___65327 = G__65328;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65309){
var state_val_65310 = (state_65309[(1)]);
if((state_val_65310 === (1))){
var state_65309__$1 = state_65309;
var statearr_65311_65329 = state_65309__$1;
(statearr_65311_65329[(2)] = null);

(statearr_65311_65329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65310 === (2))){
var _ = (function (){var statearr_65312 = state_65309;
(statearr_65312[(4)] = cljs.core.cons.call(null,(5),(state_65309[(4)])));

return statearr_65312;
})();
var inst_65285 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65309__$1 = state_65309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65309__$1,(6),inst_65285);
} else {
if((state_val_65310 === (3))){
var inst_65307 = (state_65309[(2)]);
var state_65309__$1 = state_65309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65309__$1,inst_65307);
} else {
if((state_val_65310 === (4))){
var inst_65279 = (state_65309[(2)]);
var state_65309__$1 = state_65309;
var statearr_65314_65330 = state_65309__$1;
(statearr_65314_65330[(2)] = inst_65279);

(statearr_65314_65330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65310 === (5))){
var _ = (function (){var statearr_65315 = state_65309;
(statearr_65315[(4)] = cljs.core.rest.call(null,(state_65309[(4)])));

return statearr_65315;
})();
var state_65309__$1 = state_65309;
var ex65313 = (state_65309__$1[(2)]);
var statearr_65316_65331 = state_65309__$1;
(statearr_65316_65331[(5)] = ex65313);


if((ex65313 instanceof Error)){
var statearr_65317_65332 = state_65309__$1;
(statearr_65317_65332[(1)] = (4));

(statearr_65317_65332[(5)] = null);

} else {
throw ex65313;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65310 === (6))){
var inst_65287 = (state_65309[(2)]);
var inst_65288 = fluree.db.util.async.throw_err.call(null,inst_65287);
var inst_65289 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_65288);
var inst_65290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65291 = [inst_65288];
var inst_65292 = (new cljs.core.PersistentVector(null,1,(5),inst_65290,inst_65291,null));
var inst_65293 = cljs.core.count.call(null,inst_65292);
var inst_65294 = ((9) + inst_65293);
var inst_65295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65296 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65298 = [inst_65288];
var inst_65299 = (new cljs.core.PersistentVector(null,1,(5),inst_65297,inst_65298,null));
var inst_65300 = ["max",inst_65299,inst_65289];
var inst_65301 = cljs.core.PersistentHashMap.fromArrays(inst_65296,inst_65300);
var inst_65302 = [inst_65301,inst_65294];
var inst_65303 = (new cljs.core.PersistentVector(null,2,(5),inst_65295,inst_65302,null));
var inst_65304 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65303);
var _ = (function (){var statearr_65318 = state_65309;
(statearr_65318[(4)] = cljs.core.rest.call(null,(state_65309[(4)])));

return statearr_65318;
})();
var state_65309__$1 = (function (){var statearr_65319 = state_65309;
(statearr_65319[(7)] = inst_65304);

return statearr_65319;
})();
var statearr_65320_65333 = state_65309__$1;
(statearr_65320_65333[(2)] = inst_65289);

(statearr_65320_65333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65321 = [null,null,null,null,null,null,null,null];
(statearr_65321[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65321[(1)] = (1));

return statearr_65321;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65309){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65322){var ex__2687__auto__ = e65322;
var statearr_65323_65334 = state_65309;
(statearr_65323_65334[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65309[(4)]))){
var statearr_65324_65335 = state_65309;
(statearr_65324_65335[(1)] = cljs.core.first.call(null,(state_65309[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65336 = state_65309;
state_65309 = G__65336;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65309){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65325 = f__2707__auto__.call(null);
(statearr_65325[(6)] = c__2706__auto__);

return statearr_65325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq65277){
var G__65278 = cljs.core.first.call(null,seq65277);
var seq65277__$1 = cljs.core.next.call(null,seq65277);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65278,seq65277__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65386 = arguments.length;
var i__5770__auto___65387 = (0);
while(true){
if((i__5770__auto___65387 < len__5769__auto___65386)){
args__5775__auto__.push((arguments[i__5770__auto___65387]));

var G__65388 = (i__5770__auto___65387 + (1));
i__5770__auto___65387 = G__65388;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65369){
var state_val_65370 = (state_65369[(1)]);
if((state_val_65370 === (1))){
var state_65369__$1 = state_65369;
var statearr_65371_65389 = state_65369__$1;
(statearr_65371_65389[(2)] = null);

(statearr_65371_65389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65370 === (2))){
var _ = (function (){var statearr_65372 = state_65369;
(statearr_65372[(4)] = cljs.core.cons.call(null,(5),(state_65369[(4)])));

return statearr_65372;
})();
var inst_65345 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65369__$1 = state_65369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65369__$1,(6),inst_65345);
} else {
if((state_val_65370 === (3))){
var inst_65367 = (state_65369[(2)]);
var state_65369__$1 = state_65369;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65369__$1,inst_65367);
} else {
if((state_val_65370 === (4))){
var inst_65339 = (state_65369[(2)]);
var state_65369__$1 = state_65369;
var statearr_65374_65390 = state_65369__$1;
(statearr_65374_65390[(2)] = inst_65339);

(statearr_65374_65390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65370 === (5))){
var _ = (function (){var statearr_65375 = state_65369;
(statearr_65375[(4)] = cljs.core.rest.call(null,(state_65369[(4)])));

return statearr_65375;
})();
var state_65369__$1 = state_65369;
var ex65373 = (state_65369__$1[(2)]);
var statearr_65376_65391 = state_65369__$1;
(statearr_65376_65391[(5)] = ex65373);


if((ex65373 instanceof Error)){
var statearr_65377_65392 = state_65369__$1;
(statearr_65377_65392[(1)] = (4));

(statearr_65377_65392[(5)] = null);

} else {
throw ex65373;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65370 === (6))){
var inst_65347 = (state_65369[(2)]);
var inst_65348 = fluree.db.util.async.throw_err.call(null,inst_65347);
var inst_65349 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_65348);
var inst_65350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65351 = [inst_65348];
var inst_65352 = (new cljs.core.PersistentVector(null,1,(5),inst_65350,inst_65351,null));
var inst_65353 = cljs.core.count.call(null,inst_65352);
var inst_65354 = ((9) + inst_65353);
var inst_65355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65356 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65358 = [inst_65348];
var inst_65359 = (new cljs.core.PersistentVector(null,1,(5),inst_65357,inst_65358,null));
var inst_65360 = ["min",inst_65359,inst_65349];
var inst_65361 = cljs.core.PersistentHashMap.fromArrays(inst_65356,inst_65360);
var inst_65362 = [inst_65361,inst_65354];
var inst_65363 = (new cljs.core.PersistentVector(null,2,(5),inst_65355,inst_65362,null));
var inst_65364 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65363);
var _ = (function (){var statearr_65378 = state_65369;
(statearr_65378[(4)] = cljs.core.rest.call(null,(state_65369[(4)])));

return statearr_65378;
})();
var state_65369__$1 = (function (){var statearr_65379 = state_65369;
(statearr_65379[(7)] = inst_65364);

return statearr_65379;
})();
var statearr_65380_65393 = state_65369__$1;
(statearr_65380_65393[(2)] = inst_65349);

(statearr_65380_65393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65381 = [null,null,null,null,null,null,null,null];
(statearr_65381[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65381[(1)] = (1));

return statearr_65381;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65369){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65369);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65382){var ex__2687__auto__ = e65382;
var statearr_65383_65394 = state_65369;
(statearr_65383_65394[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65369[(4)]))){
var statearr_65384_65395 = state_65369;
(statearr_65384_65395[(1)] = cljs.core.first.call(null,(state_65369[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65396 = state_65369;
state_65369 = G__65396;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65369){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65385 = f__2707__auto__.call(null);
(statearr_65385[(6)] = c__2706__auto__);

return statearr_65385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq65337){
var G__65338 = cljs.core.first.call(null,seq65337);
var seq65337__$1 = cljs.core.next.call(null,seq65337);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65338,seq65337__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__65398 = arguments.length;
switch (G__65398) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65443){
var state_val_65444 = (state_65443[(1)]);
if((state_val_65444 === (7))){
var state_65443__$1 = state_65443;
var statearr_65445_65582 = state_65443__$1;
(statearr_65445_65582[(2)] = query_map);

(statearr_65445_65582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65444 === (1))){
var state_65443__$1 = state_65443;
var statearr_65446_65583 = state_65443__$1;
(statearr_65446_65583[(2)] = null);

(statearr_65446_65583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65444 === (4))){
var inst_65399 = (state_65443[(2)]);
var state_65443__$1 = state_65443;
var statearr_65447_65584 = state_65443__$1;
(statearr_65447_65584[(2)] = inst_65399);

(statearr_65447_65584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65444 === (13))){
var inst_65421 = (state_65443[(7)]);
var inst_65425 = (state_65443[(2)]);
var inst_65426 = fluree.db.util.async.throw_err.call(null,inst_65425);
var inst_65427 = cljs.core.nth.call(null,inst_65426,(0),null);
var inst_65428 = cljs.core.nth.call(null,inst_65426,(1),null);
var inst_65429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65430 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65432 = [inst_65421];
var inst_65433 = (new cljs.core.PersistentVector(null,1,(5),inst_65431,inst_65432,null));
var inst_65434 = ["query",inst_65433,inst_65427];
var inst_65435 = cljs.core.PersistentHashMap.fromArrays(inst_65430,inst_65434);
var inst_65436 = [inst_65435,inst_65428];
var inst_65437 = (new cljs.core.PersistentVector(null,2,(5),inst_65429,inst_65436,null));
var inst_65438 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65437);
var _ = (function (){var statearr_65448 = state_65443;
(statearr_65448[(4)] = cljs.core.rest.call(null,(state_65443[(4)])));

return statearr_65448;
})();
var state_65443__$1 = (function (){var statearr_65449 = state_65443;
(statearr_65449[(8)] = inst_65438);

return statearr_65449;
})();
var statearr_65450_65585 = state_65443__$1;
(statearr_65450_65585[(2)] = inst_65427);

(statearr_65450_65585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65444 === (6))){
var state_65443__$1 = state_65443;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65443__$1,(9),query_map);
} else {
if((state_val_65444 === (3))){
var inst_65441 = (state_65443[(2)]);
var state_65443__$1 = state_65443;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65443__$1,inst_65441);
} else {
if((state_val_65444 === (12))){
var inst_65421 = (state_65443[(7)]);
var inst_65421__$1 = (state_65443[(2)]);
var inst_65422 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65423 = fluree.db.dbfunctions.internal.query.call(null,inst_65422,inst_65421__$1);
var state_65443__$1 = (function (){var statearr_65451 = state_65443;
(statearr_65451[(7)] = inst_65421__$1);

return statearr_65451;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65443__$1,(13),inst_65423);
} else {
if((state_val_65444 === (2))){
var _ = (function (){var statearr_65452 = state_65443;
(statearr_65452[(4)] = cljs.core.cons.call(null,(5),(state_65443[(4)])));

return statearr_65452;
})();
var inst_65408 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_65443__$1 = state_65443;
if(inst_65408){
var statearr_65453_65586 = state_65443__$1;
(statearr_65453_65586[(1)] = (6));

} else {
var statearr_65454_65587 = state_65443__$1;
(statearr_65454_65587[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65444 === (11))){
var inst_65415 = (state_65443[(9)]);
var state_65443__$1 = state_65443;
var statearr_65456_65588 = state_65443__$1;
(statearr_65456_65588[(2)] = inst_65415);

(statearr_65456_65588[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65444 === (9))){
var inst_65411 = (state_65443[(2)]);
var inst_65412 = fluree.db.util.async.throw_err.call(null,inst_65411);
var state_65443__$1 = state_65443;
var statearr_65457_65589 = state_65443__$1;
(statearr_65457_65589[(2)] = inst_65412);

(statearr_65457_65589[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65444 === (5))){
var _ = (function (){var statearr_65458 = state_65443;
(statearr_65458[(4)] = cljs.core.rest.call(null,(state_65443[(4)])));

return statearr_65458;
})();
var state_65443__$1 = state_65443;
var ex65455 = (state_65443__$1[(2)]);
var statearr_65459_65590 = state_65443__$1;
(statearr_65459_65590[(5)] = ex65455);


if((ex65455 instanceof Error)){
var statearr_65460_65591 = state_65443__$1;
(statearr_65460_65591[(1)] = (4));

(statearr_65460_65591[(5)] = null);

} else {
throw ex65455;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65444 === (10))){
var inst_65415 = (state_65443[(9)]);
var inst_65418 = fluree.db.util.json.parse.call(null,inst_65415);
var state_65443__$1 = state_65443;
var statearr_65461_65592 = state_65443__$1;
(statearr_65461_65592[(2)] = inst_65418);

(statearr_65461_65592[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65444 === (8))){
var inst_65415 = (state_65443[(9)]);
var inst_65415__$1 = (state_65443[(2)]);
var inst_65416 = typeof inst_65415__$1 === 'string';
var state_65443__$1 = (function (){var statearr_65462 = state_65443;
(statearr_65462[(9)] = inst_65415__$1);

return statearr_65462;
})();
if(cljs.core.truth_(inst_65416)){
var statearr_65463_65593 = state_65443__$1;
(statearr_65463_65593[(1)] = (10));

} else {
var statearr_65464_65594 = state_65443__$1;
(statearr_65464_65594[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65465 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65465[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65465[(1)] = (1));

return statearr_65465;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65443){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65443);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65466){var ex__2687__auto__ = e65466;
var statearr_65467_65595 = state_65443;
(statearr_65467_65595[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65443[(4)]))){
var statearr_65468_65596 = state_65443;
(statearr_65468_65596[(1)] = cljs.core.first.call(null,(state_65443[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65597 = state_65443;
state_65443 = G__65597;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65443){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65469 = f__2707__auto__.call(null);
(statearr_65469[(6)] = c__2706__auto__);

return statearr_65469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65540){
var state_val_65541 = (state_65540[(1)]);
if((state_val_65541 === (7))){
var state_65540__$1 = state_65540;
var statearr_65542_65598 = state_65540__$1;
(statearr_65542_65598[(2)] = select);

(statearr_65542_65598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (20))){
var inst_65510 = (state_65540[(2)]);
var inst_65511 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_65540__$1 = (function (){var statearr_65543 = state_65540;
(statearr_65543[(7)] = inst_65510);

return statearr_65543;
})();
if(inst_65511){
var statearr_65544_65599 = state_65540__$1;
(statearr_65544_65599[(1)] = (22));

} else {
var statearr_65545_65600 = state_65540__$1;
(statearr_65545_65600[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (1))){
var state_65540__$1 = state_65540;
var statearr_65546_65601 = state_65540__$1;
(statearr_65546_65601[(2)] = null);

(statearr_65546_65601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (24))){
var inst_65502 = (state_65540[(8)]);
var inst_65486 = (state_65540[(9)]);
var inst_65510 = (state_65540[(7)]);
var inst_65494 = (state_65540[(10)]);
var inst_65518 = (state_65540[(2)]);
var inst_65519 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65520 = fluree.db.dbfunctions.internal.query.call(null,inst_65519,inst_65486,inst_65494,inst_65502,inst_65510,inst_65518);
var state_65540__$1 = state_65540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65540__$1,(26),inst_65520);
} else {
if((state_val_65541 === (4))){
var inst_65470 = (state_65540[(2)]);
var state_65540__$1 = state_65540;
var statearr_65547_65602 = state_65540__$1;
(statearr_65547_65602[(2)] = inst_65470);

(statearr_65547_65602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (15))){
var state_65540__$1 = state_65540;
var statearr_65548_65603 = state_65540__$1;
(statearr_65548_65603[(2)] = where);

(statearr_65548_65603[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (21))){
var inst_65506 = (state_65540[(2)]);
var inst_65507 = fluree.db.util.async.throw_err.call(null,inst_65506);
var state_65540__$1 = state_65540;
var statearr_65549_65604 = state_65540__$1;
(statearr_65549_65604[(2)] = inst_65507);

(statearr_65549_65604[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (13))){
var inst_65490 = (state_65540[(2)]);
var inst_65491 = fluree.db.util.async.throw_err.call(null,inst_65490);
var state_65540__$1 = state_65540;
var statearr_65550_65605 = state_65540__$1;
(statearr_65550_65605[(2)] = inst_65491);

(statearr_65550_65605[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (22))){
var state_65540__$1 = state_65540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65540__$1,(25),limit);
} else {
if((state_val_65541 === (6))){
var state_65540__$1 = state_65540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65540__$1,(9),select);
} else {
if((state_val_65541 === (25))){
var inst_65514 = (state_65540[(2)]);
var inst_65515 = fluree.db.util.async.throw_err.call(null,inst_65514);
var state_65540__$1 = state_65540;
var statearr_65551_65606 = state_65540__$1;
(statearr_65551_65606[(2)] = inst_65515);

(statearr_65551_65606[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (17))){
var inst_65498 = (state_65540[(2)]);
var inst_65499 = fluree.db.util.async.throw_err.call(null,inst_65498);
var state_65540__$1 = state_65540;
var statearr_65552_65607 = state_65540__$1;
(statearr_65552_65607[(2)] = inst_65499);

(statearr_65552_65607[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (3))){
var inst_65538 = (state_65540[(2)]);
var state_65540__$1 = state_65540;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65540__$1,inst_65538);
} else {
if((state_val_65541 === (12))){
var inst_65494 = (state_65540[(2)]);
var inst_65495 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_65540__$1 = (function (){var statearr_65553 = state_65540;
(statearr_65553[(10)] = inst_65494);

return statearr_65553;
})();
if(inst_65495){
var statearr_65554_65608 = state_65540__$1;
(statearr_65554_65608[(1)] = (14));

} else {
var statearr_65555_65609 = state_65540__$1;
(statearr_65555_65609[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (2))){
var _ = (function (){var statearr_65556 = state_65540;
(statearr_65556[(4)] = cljs.core.cons.call(null,(5),(state_65540[(4)])));

return statearr_65556;
})();
var inst_65479 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_65540__$1 = state_65540;
if(inst_65479){
var statearr_65557_65610 = state_65540__$1;
(statearr_65557_65610[(1)] = (6));

} else {
var statearr_65558_65611 = state_65540__$1;
(statearr_65558_65611[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (23))){
var state_65540__$1 = state_65540;
var statearr_65559_65612 = state_65540__$1;
(statearr_65559_65612[(2)] = limit);

(statearr_65559_65612[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (19))){
var state_65540__$1 = state_65540;
var statearr_65560_65613 = state_65540__$1;
(statearr_65560_65613[(2)] = block);

(statearr_65560_65613[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (11))){
var state_65540__$1 = state_65540;
var statearr_65562_65614 = state_65540__$1;
(statearr_65562_65614[(2)] = from);

(statearr_65562_65614[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (9))){
var inst_65482 = (state_65540[(2)]);
var inst_65483 = fluree.db.util.async.throw_err.call(null,inst_65482);
var state_65540__$1 = state_65540;
var statearr_65563_65615 = state_65540__$1;
(statearr_65563_65615[(2)] = inst_65483);

(statearr_65563_65615[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (5))){
var _ = (function (){var statearr_65564 = state_65540;
(statearr_65564[(4)] = cljs.core.rest.call(null,(state_65540[(4)])));

return statearr_65564;
})();
var state_65540__$1 = state_65540;
var ex65561 = (state_65540__$1[(2)]);
var statearr_65565_65616 = state_65540__$1;
(statearr_65565_65616[(5)] = ex65561);


if((ex65561 instanceof Error)){
var statearr_65566_65617 = state_65540__$1;
(statearr_65566_65617[(1)] = (4));

(statearr_65566_65617[(5)] = null);

} else {
throw ex65561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (14))){
var state_65540__$1 = state_65540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65540__$1,(17),where);
} else {
if((state_val_65541 === (26))){
var inst_65502 = (state_65540[(8)]);
var inst_65486 = (state_65540[(9)]);
var inst_65510 = (state_65540[(7)]);
var inst_65494 = (state_65540[(10)]);
var inst_65522 = (state_65540[(2)]);
var inst_65523 = fluree.db.util.async.throw_err.call(null,inst_65522);
var inst_65524 = cljs.core.nth.call(null,inst_65523,(0),null);
var inst_65525 = cljs.core.nth.call(null,inst_65523,(1),null);
var inst_65526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65527 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65529 = [inst_65486,inst_65494,inst_65502,inst_65510];
var inst_65530 = (new cljs.core.PersistentVector(null,4,(5),inst_65528,inst_65529,null));
var inst_65531 = ["query",inst_65530,inst_65524];
var inst_65532 = cljs.core.PersistentHashMap.fromArrays(inst_65527,inst_65531);
var inst_65533 = [inst_65532,inst_65525];
var inst_65534 = (new cljs.core.PersistentVector(null,2,(5),inst_65526,inst_65533,null));
var inst_65535 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65534);
var _ = (function (){var statearr_65567 = state_65540;
(statearr_65567[(4)] = cljs.core.rest.call(null,(state_65540[(4)])));

return statearr_65567;
})();
var state_65540__$1 = (function (){var statearr_65568 = state_65540;
(statearr_65568[(11)] = inst_65535);

return statearr_65568;
})();
var statearr_65569_65618 = state_65540__$1;
(statearr_65569_65618[(2)] = inst_65524);

(statearr_65569_65618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (16))){
var inst_65502 = (state_65540[(2)]);
var inst_65503 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_65540__$1 = (function (){var statearr_65570 = state_65540;
(statearr_65570[(8)] = inst_65502);

return statearr_65570;
})();
if(inst_65503){
var statearr_65571_65619 = state_65540__$1;
(statearr_65571_65619[(1)] = (18));

} else {
var statearr_65572_65620 = state_65540__$1;
(statearr_65572_65620[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (10))){
var state_65540__$1 = state_65540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65540__$1,(13),from);
} else {
if((state_val_65541 === (18))){
var state_65540__$1 = state_65540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65540__$1,(21),block);
} else {
if((state_val_65541 === (8))){
var inst_65486 = (state_65540[(2)]);
var inst_65487 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_65540__$1 = (function (){var statearr_65573 = state_65540;
(statearr_65573[(9)] = inst_65486);

return statearr_65573;
})();
if(inst_65487){
var statearr_65574_65621 = state_65540__$1;
(statearr_65574_65621[(1)] = (10));

} else {
var statearr_65575_65622 = state_65540__$1;
(statearr_65575_65622[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65576 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65576[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65576[(1)] = (1));

return statearr_65576;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65540){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65540);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65577){var ex__2687__auto__ = e65577;
var statearr_65578_65623 = state_65540;
(statearr_65578_65623[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65540[(4)]))){
var statearr_65579_65624 = state_65540;
(statearr_65579_65624[(1)] = cljs.core.first.call(null,(state_65540[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65625 = state_65540;
state_65540 = G__65625;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65540){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65580 = f__2707__auto__.call(null);
(statearr_65580[(6)] = c__2706__auto__);

return statearr_65580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65681){
var state_val_65682 = (state_65681[(1)]);
if((state_val_65682 === (7))){
var state_65681__$1 = state_65681;
var statearr_65683_65714 = state_65681__$1;
(statearr_65683_65714[(2)] = startSubject);

(statearr_65683_65714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (1))){
var state_65681__$1 = state_65681;
var statearr_65684_65715 = state_65681__$1;
(statearr_65684_65715[(2)] = null);

(statearr_65684_65715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (4))){
var inst_65626 = (state_65681[(2)]);
var state_65681__$1 = state_65681;
var statearr_65685_65716 = state_65681__$1;
(statearr_65685_65716[(2)] = inst_65626);

(statearr_65685_65716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (15))){
var inst_65658 = (state_65681[(2)]);
var inst_65659 = fluree.db.util.async.throw_err.call(null,inst_65658);
var inst_65660 = cljs.core.nth.call(null,inst_65659,(0),null);
var inst_65661 = cljs.core.nth.call(null,inst_65659,(1),null);
var inst_65662 = cljs.core.empty_QMARK_.call(null,inst_65660);
var state_65681__$1 = (function (){var statearr_65686 = state_65681;
(statearr_65686[(7)] = inst_65661);

return statearr_65686;
})();
if(inst_65662){
var statearr_65687_65717 = state_65681__$1;
(statearr_65687_65717[(1)] = (16));

} else {
var statearr_65688_65718 = state_65681__$1;
(statearr_65688_65718[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (13))){
var inst_65654 = (state_65681[(8)]);
var inst_65646 = (state_65681[(9)]);
var inst_65642 = (state_65681[(10)]);
var inst_65654__$1 = (state_65681[(2)]);
var inst_65655 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65656 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_65655,inst_65642,inst_65646,inst_65654__$1);
var state_65681__$1 = (function (){var statearr_65689 = state_65681;
(statearr_65689[(8)] = inst_65654__$1);

return statearr_65689;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65681__$1,(15),inst_65656);
} else {
if((state_val_65682 === (6))){
var state_65681__$1 = state_65681;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65681__$1,(9),startSubject);
} else {
if((state_val_65682 === (17))){
var state_65681__$1 = state_65681;
var statearr_65690_65719 = state_65681__$1;
(statearr_65690_65719[(2)] = true);

(statearr_65690_65719[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (3))){
var inst_65679 = (state_65681[(2)]);
var state_65681__$1 = state_65681;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65681__$1,inst_65679);
} else {
if((state_val_65682 === (12))){
var state_65681__$1 = state_65681;
var statearr_65691_65720 = state_65681__$1;
(statearr_65691_65720[(2)] = endSubject);

(statearr_65691_65720[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (2))){
var _ = (function (){var statearr_65692 = state_65681;
(statearr_65692[(4)] = cljs.core.cons.call(null,(5),(state_65681[(4)])));

return statearr_65692;
})();
var inst_65635 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_65681__$1 = state_65681;
if(inst_65635){
var statearr_65693_65721 = state_65681__$1;
(statearr_65693_65721[(1)] = (6));

} else {
var statearr_65694_65722 = state_65681__$1;
(statearr_65694_65722[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (11))){
var state_65681__$1 = state_65681;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65681__$1,(14),endSubject);
} else {
if((state_val_65682 === (9))){
var inst_65638 = (state_65681[(2)]);
var inst_65639 = fluree.db.util.async.throw_err.call(null,inst_65638);
var state_65681__$1 = state_65681;
var statearr_65696_65723 = state_65681__$1;
(statearr_65696_65723[(2)] = inst_65639);

(statearr_65696_65723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (5))){
var _ = (function (){var statearr_65697 = state_65681;
(statearr_65697[(4)] = cljs.core.rest.call(null,(state_65681[(4)])));

return statearr_65697;
})();
var state_65681__$1 = state_65681;
var ex65695 = (state_65681__$1[(2)]);
var statearr_65698_65724 = state_65681__$1;
(statearr_65698_65724[(5)] = ex65695);


if((ex65695 instanceof Error)){
var statearr_65699_65725 = state_65681__$1;
(statearr_65699_65725[(1)] = (4));

(statearr_65699_65725[(5)] = null);

} else {
throw ex65695;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (14))){
var inst_65650 = (state_65681[(2)]);
var inst_65651 = fluree.db.util.async.throw_err.call(null,inst_65650);
var state_65681__$1 = state_65681;
var statearr_65700_65726 = state_65681__$1;
(statearr_65700_65726[(2)] = inst_65651);

(statearr_65700_65726[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (16))){
var state_65681__$1 = state_65681;
var statearr_65701_65727 = state_65681__$1;
(statearr_65701_65727[(2)] = false);

(statearr_65701_65727[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (10))){
var inst_65645 = (state_65681[(2)]);
var inst_65646 = fluree.db.util.async.throw_err.call(null,inst_65645);
var inst_65647 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_65681__$1 = (function (){var statearr_65702 = state_65681;
(statearr_65702[(9)] = inst_65646);

return statearr_65702;
})();
if(inst_65647){
var statearr_65703_65728 = state_65681__$1;
(statearr_65703_65728[(1)] = (11));

} else {
var statearr_65704_65729 = state_65681__$1;
(statearr_65704_65729[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (18))){
var inst_65654 = (state_65681[(8)]);
var inst_65661 = (state_65681[(7)]);
var inst_65646 = (state_65681[(9)]);
var inst_65642 = (state_65681[(10)]);
var inst_65666 = (state_65681[(2)]);
var inst_65667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65668 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65670 = [inst_65642,inst_65646,inst_65654];
var inst_65671 = (new cljs.core.PersistentVector(null,3,(5),inst_65669,inst_65670,null));
var inst_65672 = ["relationship?",inst_65671,inst_65666];
var inst_65673 = cljs.core.PersistentHashMap.fromArrays(inst_65668,inst_65672);
var inst_65674 = [inst_65673,inst_65661];
var inst_65675 = (new cljs.core.PersistentVector(null,2,(5),inst_65667,inst_65674,null));
var inst_65676 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65675);
var _ = (function (){var statearr_65705 = state_65681;
(statearr_65705[(4)] = cljs.core.rest.call(null,(state_65681[(4)])));

return statearr_65705;
})();
var state_65681__$1 = (function (){var statearr_65706 = state_65681;
(statearr_65706[(11)] = inst_65676);

return statearr_65706;
})();
var statearr_65707_65730 = state_65681__$1;
(statearr_65707_65730[(2)] = inst_65666);

(statearr_65707_65730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65682 === (8))){
var inst_65642 = (state_65681[(2)]);
var inst_65643 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_65681__$1 = (function (){var statearr_65708 = state_65681;
(statearr_65708[(10)] = inst_65642);

return statearr_65708;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65681__$1,(10),inst_65643);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_65709 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65709[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__);

(statearr_65709[(1)] = (1));

return statearr_65709;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1 = (function (state_65681){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65681);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65710){var ex__2687__auto__ = e65710;
var statearr_65711_65731 = state_65681;
(statearr_65711_65731[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65681[(4)]))){
var statearr_65712_65732 = state_65681;
(statearr_65712_65732[(1)] = cljs.core.first.call(null,(state_65681[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65733 = state_65681;
state_65681 = G__65733;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__ = function(state_65681){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1.call(this,state_65681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65713 = f__2707__auto__.call(null);
(statearr_65713[(6)] = c__2706__auto__);

return statearr_65713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65770){
var state_val_65771 = (state_65770[(1)]);
if((state_val_65771 === (7))){
var state_65770__$1 = state_65770;
var statearr_65772_65792 = state_65770__$1;
(statearr_65772_65792[(2)] = pred_name);

(statearr_65772_65792[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65771 === (1))){
var state_65770__$1 = state_65770;
var statearr_65773_65793 = state_65770__$1;
(statearr_65773_65793[(2)] = null);

(statearr_65773_65793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65771 === (4))){
var inst_65734 = (state_65770[(2)]);
var state_65770__$1 = state_65770;
var statearr_65774_65794 = state_65770__$1;
(statearr_65774_65794[(2)] = inst_65734);

(statearr_65774_65794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65771 === (6))){
var state_65770__$1 = state_65770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65770__$1,(9),pred_name);
} else {
if((state_val_65771 === (3))){
var inst_65768 = (state_65770[(2)]);
var state_65770__$1 = state_65770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65770__$1,inst_65768);
} else {
if((state_val_65771 === (2))){
var _ = (function (){var statearr_65776 = state_65770;
(statearr_65776[(4)] = cljs.core.cons.call(null,(5),(state_65770[(4)])));

return statearr_65776;
})();
var inst_65743 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_65770__$1 = state_65770;
if(inst_65743){
var statearr_65777_65795 = state_65770__$1;
(statearr_65777_65795[(1)] = (6));

} else {
var statearr_65778_65796 = state_65770__$1;
(statearr_65778_65796[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65771 === (9))){
var inst_65746 = (state_65770[(2)]);
var inst_65747 = fluree.db.util.async.throw_err.call(null,inst_65746);
var state_65770__$1 = state_65770;
var statearr_65779_65797 = state_65770__$1;
(statearr_65779_65797[(2)] = inst_65747);

(statearr_65779_65797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65771 === (5))){
var _ = (function (){var statearr_65780 = state_65770;
(statearr_65780[(4)] = cljs.core.rest.call(null,(state_65770[(4)])));

return statearr_65780;
})();
var state_65770__$1 = state_65770;
var ex65775 = (state_65770__$1[(2)]);
var statearr_65781_65798 = state_65770__$1;
(statearr_65781_65798[(5)] = ex65775);


if((ex65775 instanceof Error)){
var statearr_65782_65799 = state_65770__$1;
(statearr_65782_65799[(1)] = (4));

(statearr_65782_65799[(5)] = null);

} else {
throw ex65775;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65771 === (10))){
var inst_65750 = (state_65770[(7)]);
var inst_65754 = (state_65770[(2)]);
var inst_65755 = fluree.db.util.async.throw_err.call(null,inst_65754);
var inst_65756 = cljs.core.nth.call(null,inst_65755,(0),null);
var inst_65757 = cljs.core.nth.call(null,inst_65755,(1),null);
var inst_65758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65759 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65760 = ["max-pred-val",inst_65750,inst_65756];
var inst_65761 = cljs.core.PersistentHashMap.fromArrays(inst_65759,inst_65760);
var inst_65762 = (inst_65757 + (10));
var inst_65763 = [inst_65761,inst_65762];
var inst_65764 = (new cljs.core.PersistentVector(null,2,(5),inst_65758,inst_65763,null));
var inst_65765 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65764);
var _ = (function (){var statearr_65783 = state_65770;
(statearr_65783[(4)] = cljs.core.rest.call(null,(state_65770[(4)])));

return statearr_65783;
})();
var state_65770__$1 = (function (){var statearr_65784 = state_65770;
(statearr_65784[(8)] = inst_65765);

return statearr_65784;
})();
var statearr_65785_65800 = state_65770__$1;
(statearr_65785_65800[(2)] = inst_65756);

(statearr_65785_65800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65771 === (8))){
var inst_65750 = (state_65770[(7)]);
var inst_65750__$1 = (state_65770[(2)]);
var inst_65751 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65752 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_65751,inst_65750__$1,null);
var state_65770__$1 = (function (){var statearr_65786 = state_65770;
(statearr_65786[(7)] = inst_65750__$1);

return statearr_65786;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65770__$1,(10),inst_65752);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0 = (function (){
var statearr_65787 = [null,null,null,null,null,null,null,null,null];
(statearr_65787[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__);

(statearr_65787[(1)] = (1));

return statearr_65787;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1 = (function (state_65770){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65788){var ex__2687__auto__ = e65788;
var statearr_65789_65801 = state_65770;
(statearr_65789_65801[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65770[(4)]))){
var statearr_65790_65802 = state_65770;
(statearr_65790_65802[(1)] = cljs.core.first.call(null,(state_65770[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65803 = state_65770;
state_65770 = G__65803;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__ = function(state_65770){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1.call(this,state_65770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65791 = f__2707__auto__.call(null);
(statearr_65791[(6)] = c__2706__auto__);

return statearr_65791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65830){
var state_val_65831 = (state_65830[(1)]);
if((state_val_65831 === (7))){
var state_65830__$1 = state_65830;
var statearr_65832_65851 = state_65830__$1;
(statearr_65832_65851[(2)] = n);

(statearr_65832_65851[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65831 === (1))){
var state_65830__$1 = state_65830;
var statearr_65833_65852 = state_65830__$1;
(statearr_65833_65852[(2)] = null);

(statearr_65833_65852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65831 === (4))){
var inst_65804 = (state_65830[(2)]);
var state_65830__$1 = state_65830;
var statearr_65834_65853 = state_65830__$1;
(statearr_65834_65853[(2)] = inst_65804);

(statearr_65834_65853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65831 === (6))){
var state_65830__$1 = state_65830;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65830__$1,(9),n);
} else {
if((state_val_65831 === (3))){
var inst_65828 = (state_65830[(2)]);
var state_65830__$1 = state_65830;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65830__$1,inst_65828);
} else {
if((state_val_65831 === (2))){
var _ = (function (){var statearr_65836 = state_65830;
(statearr_65836[(4)] = cljs.core.cons.call(null,(5),(state_65830[(4)])));

return statearr_65836;
})();
var inst_65810 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_65830__$1 = state_65830;
if(inst_65810){
var statearr_65837_65854 = state_65830__$1;
(statearr_65837_65854[(1)] = (6));

} else {
var statearr_65838_65855 = state_65830__$1;
(statearr_65838_65855[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65831 === (9))){
var inst_65813 = (state_65830[(2)]);
var inst_65814 = fluree.db.util.async.throw_err.call(null,inst_65813);
var state_65830__$1 = state_65830;
var statearr_65839_65856 = state_65830__$1;
(statearr_65839_65856[(2)] = inst_65814);

(statearr_65839_65856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65831 === (5))){
var _ = (function (){var statearr_65840 = state_65830;
(statearr_65840[(4)] = cljs.core.rest.call(null,(state_65830[(4)])));

return statearr_65840;
})();
var state_65830__$1 = state_65830;
var ex65835 = (state_65830__$1[(2)]);
var statearr_65841_65857 = state_65830__$1;
(statearr_65841_65857[(5)] = ex65835);


if((ex65835 instanceof Error)){
var statearr_65842_65858 = state_65830__$1;
(statearr_65842_65858[(1)] = (4));

(statearr_65842_65858[(5)] = null);

} else {
throw ex65835;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65831 === (8))){
var inst_65817 = (state_65830[(2)]);
var inst_65818 = fluree.db.dbfunctions.internal.inc.call(null,inst_65817);
var inst_65819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65820 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65821 = ["inc",inst_65817,inst_65818];
var inst_65822 = cljs.core.PersistentHashMap.fromArrays(inst_65820,inst_65821);
var inst_65823 = [inst_65822,(10)];
var inst_65824 = (new cljs.core.PersistentVector(null,2,(5),inst_65819,inst_65823,null));
var inst_65825 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65824);
var _ = (function (){var statearr_65843 = state_65830;
(statearr_65843[(4)] = cljs.core.rest.call(null,(state_65830[(4)])));

return statearr_65843;
})();
var state_65830__$1 = (function (){var statearr_65844 = state_65830;
(statearr_65844[(7)] = inst_65825);

return statearr_65844;
})();
var statearr_65845_65859 = state_65830__$1;
(statearr_65845_65859[(2)] = inst_65818);

(statearr_65845_65859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0 = (function (){
var statearr_65846 = [null,null,null,null,null,null,null,null];
(statearr_65846[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__);

(statearr_65846[(1)] = (1));

return statearr_65846;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1 = (function (state_65830){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65830);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65847){var ex__2687__auto__ = e65847;
var statearr_65848_65860 = state_65830;
(statearr_65848_65860[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65830[(4)]))){
var statearr_65849_65861 = state_65830;
(statearr_65849_65861[(1)] = cljs.core.first.call(null,(state_65830[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65862 = state_65830;
state_65830 = G__65862;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__ = function(state_65830){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1.call(this,state_65830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65850 = f__2707__auto__.call(null);
(statearr_65850[(6)] = c__2706__auto__);

return statearr_65850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65889){
var state_val_65890 = (state_65889[(1)]);
if((state_val_65890 === (7))){
var state_65889__$1 = state_65889;
var statearr_65891_65910 = state_65889__$1;
(statearr_65891_65910[(2)] = n);

(statearr_65891_65910[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (1))){
var state_65889__$1 = state_65889;
var statearr_65892_65911 = state_65889__$1;
(statearr_65892_65911[(2)] = null);

(statearr_65892_65911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (4))){
var inst_65863 = (state_65889[(2)]);
var state_65889__$1 = state_65889;
var statearr_65893_65912 = state_65889__$1;
(statearr_65893_65912[(2)] = inst_65863);

(statearr_65893_65912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (6))){
var state_65889__$1 = state_65889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65889__$1,(9),n);
} else {
if((state_val_65890 === (3))){
var inst_65887 = (state_65889[(2)]);
var state_65889__$1 = state_65889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65889__$1,inst_65887);
} else {
if((state_val_65890 === (2))){
var _ = (function (){var statearr_65895 = state_65889;
(statearr_65895[(4)] = cljs.core.cons.call(null,(5),(state_65889[(4)])));

return statearr_65895;
})();
var inst_65869 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_65889__$1 = state_65889;
if(inst_65869){
var statearr_65896_65913 = state_65889__$1;
(statearr_65896_65913[(1)] = (6));

} else {
var statearr_65897_65914 = state_65889__$1;
(statearr_65897_65914[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (9))){
var inst_65872 = (state_65889[(2)]);
var inst_65873 = fluree.db.util.async.throw_err.call(null,inst_65872);
var state_65889__$1 = state_65889;
var statearr_65898_65915 = state_65889__$1;
(statearr_65898_65915[(2)] = inst_65873);

(statearr_65898_65915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (5))){
var _ = (function (){var statearr_65899 = state_65889;
(statearr_65899[(4)] = cljs.core.rest.call(null,(state_65889[(4)])));

return statearr_65899;
})();
var state_65889__$1 = state_65889;
var ex65894 = (state_65889__$1[(2)]);
var statearr_65900_65916 = state_65889__$1;
(statearr_65900_65916[(5)] = ex65894);


if((ex65894 instanceof Error)){
var statearr_65901_65917 = state_65889__$1;
(statearr_65901_65917[(1)] = (4));

(statearr_65901_65917[(5)] = null);

} else {
throw ex65894;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65890 === (8))){
var inst_65876 = (state_65889[(2)]);
var inst_65877 = fluree.db.dbfunctions.internal.dec.call(null,inst_65876);
var inst_65878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65879 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65880 = ["dec",inst_65876,inst_65877];
var inst_65881 = cljs.core.PersistentHashMap.fromArrays(inst_65879,inst_65880);
var inst_65882 = [inst_65881,(10)];
var inst_65883 = (new cljs.core.PersistentVector(null,2,(5),inst_65878,inst_65882,null));
var inst_65884 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65883);
var _ = (function (){var statearr_65902 = state_65889;
(statearr_65902[(4)] = cljs.core.rest.call(null,(state_65889[(4)])));

return statearr_65902;
})();
var state_65889__$1 = (function (){var statearr_65903 = state_65889;
(statearr_65903[(7)] = inst_65884);

return statearr_65903;
})();
var statearr_65904_65918 = state_65889__$1;
(statearr_65904_65918[(2)] = inst_65877);

(statearr_65904_65918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0 = (function (){
var statearr_65905 = [null,null,null,null,null,null,null,null];
(statearr_65905[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__);

(statearr_65905[(1)] = (1));

return statearr_65905;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1 = (function (state_65889){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65906){var ex__2687__auto__ = e65906;
var statearr_65907_65919 = state_65889;
(statearr_65907_65919[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65889[(4)]))){
var statearr_65908_65920 = state_65889;
(statearr_65908_65920[(1)] = cljs.core.first.call(null,(state_65889[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65921 = state_65889;
state_65889 = G__65921;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__ = function(state_65889){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1.call(this,state_65889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65909 = f__2707__auto__.call(null);
(statearr_65909[(6)] = c__2706__auto__);

return statearr_65909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65971 = arguments.length;
var i__5770__auto___65972 = (0);
while(true){
if((i__5770__auto___65972 < len__5769__auto___65971)){
args__5775__auto__.push((arguments[i__5770__auto___65972]));

var G__65973 = (i__5770__auto___65972 + (1));
i__5770__auto___65972 = G__65973;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65954){
var state_val_65955 = (state_65954[(1)]);
if((state_val_65955 === (1))){
var state_65954__$1 = state_65954;
var statearr_65956_65974 = state_65954__$1;
(statearr_65956_65974[(2)] = null);

(statearr_65956_65974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65955 === (2))){
var _ = (function (){var statearr_65957 = state_65954;
(statearr_65957[(4)] = cljs.core.cons.call(null,(5),(state_65954[(4)])));

return statearr_65957;
})();
var inst_65930 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65954__$1 = state_65954;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65954__$1,(6),inst_65930);
} else {
if((state_val_65955 === (3))){
var inst_65952 = (state_65954[(2)]);
var state_65954__$1 = state_65954;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65954__$1,inst_65952);
} else {
if((state_val_65955 === (4))){
var inst_65924 = (state_65954[(2)]);
var state_65954__$1 = state_65954;
var statearr_65959_65975 = state_65954__$1;
(statearr_65959_65975[(2)] = inst_65924);

(statearr_65959_65975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65955 === (5))){
var _ = (function (){var statearr_65960 = state_65954;
(statearr_65960[(4)] = cljs.core.rest.call(null,(state_65954[(4)])));

return statearr_65960;
})();
var state_65954__$1 = state_65954;
var ex65958 = (state_65954__$1[(2)]);
var statearr_65961_65976 = state_65954__$1;
(statearr_65961_65976[(5)] = ex65958);


if((ex65958 instanceof Error)){
var statearr_65962_65977 = state_65954__$1;
(statearr_65962_65977[(1)] = (4));

(statearr_65962_65977[(5)] = null);

} else {
throw ex65958;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65955 === (6))){
var inst_65932 = (state_65954[(2)]);
var inst_65933 = fluree.db.util.async.throw_err.call(null,inst_65932);
var inst_65934 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_65933);
var inst_65935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65936 = [inst_65933];
var inst_65937 = (new cljs.core.PersistentVector(null,1,(5),inst_65935,inst_65936,null));
var inst_65938 = cljs.core.count.call(null,inst_65937);
var inst_65939 = ((9) + inst_65938);
var inst_65940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65941 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65943 = [inst_65933];
var inst_65944 = (new cljs.core.PersistentVector(null,1,(5),inst_65942,inst_65943,null));
var inst_65945 = ["+",inst_65944,inst_65934];
var inst_65946 = cljs.core.PersistentHashMap.fromArrays(inst_65941,inst_65945);
var inst_65947 = [inst_65946,inst_65939];
var inst_65948 = (new cljs.core.PersistentVector(null,2,(5),inst_65940,inst_65947,null));
var inst_65949 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65948);
var _ = (function (){var statearr_65963 = state_65954;
(statearr_65963[(4)] = cljs.core.rest.call(null,(state_65954[(4)])));

return statearr_65963;
})();
var state_65954__$1 = (function (){var statearr_65964 = state_65954;
(statearr_65964[(7)] = inst_65949);

return statearr_65964;
})();
var statearr_65965_65978 = state_65954__$1;
(statearr_65965_65978[(2)] = inst_65934);

(statearr_65965_65978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65966 = [null,null,null,null,null,null,null,null];
(statearr_65966[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65966[(1)] = (1));

return statearr_65966;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65954){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_65954);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65967){var ex__2687__auto__ = e65967;
var statearr_65968_65979 = state_65954;
(statearr_65968_65979[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_65954[(4)]))){
var statearr_65969_65980 = state_65954;
(statearr_65969_65980[(1)] = cljs.core.first.call(null,(state_65954[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65981 = state_65954;
state_65954 = G__65981;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65954){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65970 = f__2707__auto__.call(null);
(statearr_65970[(6)] = c__2706__auto__);

return statearr_65970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq65922){
var G__65923 = cljs.core.first.call(null,seq65922);
var seq65922__$1 = cljs.core.next.call(null,seq65922);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65923,seq65922__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66031 = arguments.length;
var i__5770__auto___66032 = (0);
while(true){
if((i__5770__auto___66032 < len__5769__auto___66031)){
args__5775__auto__.push((arguments[i__5770__auto___66032]));

var G__66033 = (i__5770__auto___66032 + (1));
i__5770__auto___66032 = G__66033;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66014){
var state_val_66015 = (state_66014[(1)]);
if((state_val_66015 === (1))){
var state_66014__$1 = state_66014;
var statearr_66016_66034 = state_66014__$1;
(statearr_66016_66034[(2)] = null);

(statearr_66016_66034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66015 === (2))){
var _ = (function (){var statearr_66017 = state_66014;
(statearr_66017[(4)] = cljs.core.cons.call(null,(5),(state_66014[(4)])));

return statearr_66017;
})();
var inst_65990 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66014__$1 = state_66014;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66014__$1,(6),inst_65990);
} else {
if((state_val_66015 === (3))){
var inst_66012 = (state_66014[(2)]);
var state_66014__$1 = state_66014;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66014__$1,inst_66012);
} else {
if((state_val_66015 === (4))){
var inst_65984 = (state_66014[(2)]);
var state_66014__$1 = state_66014;
var statearr_66019_66035 = state_66014__$1;
(statearr_66019_66035[(2)] = inst_65984);

(statearr_66019_66035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66015 === (5))){
var _ = (function (){var statearr_66020 = state_66014;
(statearr_66020[(4)] = cljs.core.rest.call(null,(state_66014[(4)])));

return statearr_66020;
})();
var state_66014__$1 = state_66014;
var ex66018 = (state_66014__$1[(2)]);
var statearr_66021_66036 = state_66014__$1;
(statearr_66021_66036[(5)] = ex66018);


if((ex66018 instanceof Error)){
var statearr_66022_66037 = state_66014__$1;
(statearr_66022_66037[(1)] = (4));

(statearr_66022_66037[(5)] = null);

} else {
throw ex66018;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66015 === (6))){
var inst_65992 = (state_66014[(2)]);
var inst_65993 = fluree.db.util.async.throw_err.call(null,inst_65992);
var inst_65994 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_65993);
var inst_65995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65996 = [inst_65993];
var inst_65997 = (new cljs.core.PersistentVector(null,1,(5),inst_65995,inst_65996,null));
var inst_65998 = cljs.core.count.call(null,inst_65997);
var inst_65999 = ((9) + inst_65998);
var inst_66000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66001 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66003 = [inst_65993];
var inst_66004 = (new cljs.core.PersistentVector(null,1,(5),inst_66002,inst_66003,null));
var inst_66005 = ["-",inst_66004,inst_65994];
var inst_66006 = cljs.core.PersistentHashMap.fromArrays(inst_66001,inst_66005);
var inst_66007 = [inst_66006,inst_65999];
var inst_66008 = (new cljs.core.PersistentVector(null,2,(5),inst_66000,inst_66007,null));
var inst_66009 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66008);
var _ = (function (){var statearr_66023 = state_66014;
(statearr_66023[(4)] = cljs.core.rest.call(null,(state_66014[(4)])));

return statearr_66023;
})();
var state_66014__$1 = (function (){var statearr_66024 = state_66014;
(statearr_66024[(7)] = inst_66009);

return statearr_66024;
})();
var statearr_66025_66038 = state_66014__$1;
(statearr_66025_66038[(2)] = inst_65994);

(statearr_66025_66038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66026 = [null,null,null,null,null,null,null,null];
(statearr_66026[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66026[(1)] = (1));

return statearr_66026;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66014){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66014);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66027){var ex__2687__auto__ = e66027;
var statearr_66028_66039 = state_66014;
(statearr_66028_66039[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66014[(4)]))){
var statearr_66029_66040 = state_66014;
(statearr_66029_66040[(1)] = cljs.core.first.call(null,(state_66014[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66041 = state_66014;
state_66014 = G__66041;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66014){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66030 = f__2707__auto__.call(null);
(statearr_66030[(6)] = c__2706__auto__);

return statearr_66030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq65982){
var G__65983 = cljs.core.first.call(null,seq65982);
var seq65982__$1 = cljs.core.next.call(null,seq65982);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65983,seq65982__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66091 = arguments.length;
var i__5770__auto___66092 = (0);
while(true){
if((i__5770__auto___66092 < len__5769__auto___66091)){
args__5775__auto__.push((arguments[i__5770__auto___66092]));

var G__66093 = (i__5770__auto___66092 + (1));
i__5770__auto___66092 = G__66093;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66074){
var state_val_66075 = (state_66074[(1)]);
if((state_val_66075 === (1))){
var state_66074__$1 = state_66074;
var statearr_66076_66094 = state_66074__$1;
(statearr_66076_66094[(2)] = null);

(statearr_66076_66094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66075 === (2))){
var _ = (function (){var statearr_66077 = state_66074;
(statearr_66077[(4)] = cljs.core.cons.call(null,(5),(state_66074[(4)])));

return statearr_66077;
})();
var inst_66050 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66074__$1 = state_66074;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66074__$1,(6),inst_66050);
} else {
if((state_val_66075 === (3))){
var inst_66072 = (state_66074[(2)]);
var state_66074__$1 = state_66074;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66074__$1,inst_66072);
} else {
if((state_val_66075 === (4))){
var inst_66044 = (state_66074[(2)]);
var state_66074__$1 = state_66074;
var statearr_66079_66095 = state_66074__$1;
(statearr_66079_66095[(2)] = inst_66044);

(statearr_66079_66095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66075 === (5))){
var _ = (function (){var statearr_66080 = state_66074;
(statearr_66080[(4)] = cljs.core.rest.call(null,(state_66074[(4)])));

return statearr_66080;
})();
var state_66074__$1 = state_66074;
var ex66078 = (state_66074__$1[(2)]);
var statearr_66081_66096 = state_66074__$1;
(statearr_66081_66096[(5)] = ex66078);


if((ex66078 instanceof Error)){
var statearr_66082_66097 = state_66074__$1;
(statearr_66082_66097[(1)] = (4));

(statearr_66082_66097[(5)] = null);

} else {
throw ex66078;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66075 === (6))){
var inst_66052 = (state_66074[(2)]);
var inst_66053 = fluree.db.util.async.throw_err.call(null,inst_66052);
var inst_66054 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_66053);
var inst_66055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66056 = [inst_66053];
var inst_66057 = (new cljs.core.PersistentVector(null,1,(5),inst_66055,inst_66056,null));
var inst_66058 = cljs.core.count.call(null,inst_66057);
var inst_66059 = ((9) + inst_66058);
var inst_66060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66061 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66063 = [inst_66053];
var inst_66064 = (new cljs.core.PersistentVector(null,1,(5),inst_66062,inst_66063,null));
var inst_66065 = ["*",inst_66064,inst_66054];
var inst_66066 = cljs.core.PersistentHashMap.fromArrays(inst_66061,inst_66065);
var inst_66067 = [inst_66066,inst_66059];
var inst_66068 = (new cljs.core.PersistentVector(null,2,(5),inst_66060,inst_66067,null));
var inst_66069 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66068);
var _ = (function (){var statearr_66083 = state_66074;
(statearr_66083[(4)] = cljs.core.rest.call(null,(state_66074[(4)])));

return statearr_66083;
})();
var state_66074__$1 = (function (){var statearr_66084 = state_66074;
(statearr_66084[(7)] = inst_66069);

return statearr_66084;
})();
var statearr_66085_66098 = state_66074__$1;
(statearr_66085_66098[(2)] = inst_66054);

(statearr_66085_66098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66086 = [null,null,null,null,null,null,null,null];
(statearr_66086[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66086[(1)] = (1));

return statearr_66086;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66074){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66087){var ex__2687__auto__ = e66087;
var statearr_66088_66099 = state_66074;
(statearr_66088_66099[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66074[(4)]))){
var statearr_66089_66100 = state_66074;
(statearr_66089_66100[(1)] = cljs.core.first.call(null,(state_66074[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66101 = state_66074;
state_66074 = G__66101;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66074){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66090 = f__2707__auto__.call(null);
(statearr_66090[(6)] = c__2706__auto__);

return statearr_66090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq66042){
var G__66043 = cljs.core.first.call(null,seq66042);
var seq66042__$1 = cljs.core.next.call(null,seq66042);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66043,seq66042__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66151 = arguments.length;
var i__5770__auto___66152 = (0);
while(true){
if((i__5770__auto___66152 < len__5769__auto___66151)){
args__5775__auto__.push((arguments[i__5770__auto___66152]));

var G__66153 = (i__5770__auto___66152 + (1));
i__5770__auto___66152 = G__66153;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66134){
var state_val_66135 = (state_66134[(1)]);
if((state_val_66135 === (1))){
var state_66134__$1 = state_66134;
var statearr_66136_66154 = state_66134__$1;
(statearr_66136_66154[(2)] = null);

(statearr_66136_66154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66135 === (2))){
var _ = (function (){var statearr_66137 = state_66134;
(statearr_66137[(4)] = cljs.core.cons.call(null,(5),(state_66134[(4)])));

return statearr_66137;
})();
var inst_66110 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66134__$1 = state_66134;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66134__$1,(6),inst_66110);
} else {
if((state_val_66135 === (3))){
var inst_66132 = (state_66134[(2)]);
var state_66134__$1 = state_66134;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66134__$1,inst_66132);
} else {
if((state_val_66135 === (4))){
var inst_66104 = (state_66134[(2)]);
var state_66134__$1 = state_66134;
var statearr_66139_66155 = state_66134__$1;
(statearr_66139_66155[(2)] = inst_66104);

(statearr_66139_66155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66135 === (5))){
var _ = (function (){var statearr_66140 = state_66134;
(statearr_66140[(4)] = cljs.core.rest.call(null,(state_66134[(4)])));

return statearr_66140;
})();
var state_66134__$1 = state_66134;
var ex66138 = (state_66134__$1[(2)]);
var statearr_66141_66156 = state_66134__$1;
(statearr_66141_66156[(5)] = ex66138);


if((ex66138 instanceof Error)){
var statearr_66142_66157 = state_66134__$1;
(statearr_66142_66157[(1)] = (4));

(statearr_66142_66157[(5)] = null);

} else {
throw ex66138;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66135 === (6))){
var inst_66112 = (state_66134[(2)]);
var inst_66113 = fluree.db.util.async.throw_err.call(null,inst_66112);
var inst_66114 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_66113);
var inst_66115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66116 = [inst_66113];
var inst_66117 = (new cljs.core.PersistentVector(null,1,(5),inst_66115,inst_66116,null));
var inst_66118 = cljs.core.count.call(null,inst_66117);
var inst_66119 = ((9) + inst_66118);
var inst_66120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66121 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66123 = [inst_66113];
var inst_66124 = (new cljs.core.PersistentVector(null,1,(5),inst_66122,inst_66123,null));
var inst_66125 = ["/",inst_66124,inst_66114];
var inst_66126 = cljs.core.PersistentHashMap.fromArrays(inst_66121,inst_66125);
var inst_66127 = [inst_66126,inst_66119];
var inst_66128 = (new cljs.core.PersistentVector(null,2,(5),inst_66120,inst_66127,null));
var inst_66129 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66128);
var _ = (function (){var statearr_66143 = state_66134;
(statearr_66143[(4)] = cljs.core.rest.call(null,(state_66134[(4)])));

return statearr_66143;
})();
var state_66134__$1 = (function (){var statearr_66144 = state_66134;
(statearr_66144[(7)] = inst_66129);

return statearr_66144;
})();
var statearr_66145_66158 = state_66134__$1;
(statearr_66145_66158[(2)] = inst_66114);

(statearr_66145_66158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66146 = [null,null,null,null,null,null,null,null];
(statearr_66146[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66146[(1)] = (1));

return statearr_66146;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66134){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66134);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66147){var ex__2687__auto__ = e66147;
var statearr_66148_66159 = state_66134;
(statearr_66148_66159[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66134[(4)]))){
var statearr_66149_66160 = state_66134;
(statearr_66149_66160[(1)] = cljs.core.first.call(null,(state_66134[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66161 = state_66134;
state_66134 = G__66161;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66134){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66150 = f__2707__auto__.call(null);
(statearr_66150[(6)] = c__2706__auto__);

return statearr_66150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq66102){
var G__66103 = cljs.core.first.call(null,seq66102);
var seq66102__$1 = cljs.core.next.call(null,seq66102);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66103,seq66102__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66199){
var state_val_66200 = (state_66199[(1)]);
if((state_val_66200 === (7))){
var state_66199__$1 = state_66199;
var statearr_66201_66225 = state_66199__$1;
(statearr_66201_66225[(2)] = n);

(statearr_66201_66225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66200 === (1))){
var state_66199__$1 = state_66199;
var statearr_66202_66226 = state_66199__$1;
(statearr_66202_66226[(2)] = null);

(statearr_66202_66226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66200 === (4))){
var inst_66162 = (state_66199[(2)]);
var state_66199__$1 = state_66199;
var statearr_66203_66227 = state_66199__$1;
(statearr_66203_66227[(2)] = inst_66162);

(statearr_66203_66227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66200 === (13))){
var inst_66179 = (state_66199[(2)]);
var inst_66180 = fluree.db.util.async.throw_err.call(null,inst_66179);
var state_66199__$1 = state_66199;
var statearr_66204_66228 = state_66199__$1;
(statearr_66204_66228[(2)] = inst_66180);

(statearr_66204_66228[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66200 === (6))){
var state_66199__$1 = state_66199;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66199__$1,(9),n);
} else {
if((state_val_66200 === (3))){
var inst_66197 = (state_66199[(2)]);
var state_66199__$1 = state_66199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66199__$1,inst_66197);
} else {
if((state_val_66200 === (12))){
var inst_66175 = (state_66199[(7)]);
var inst_66183 = (state_66199[(2)]);
var inst_66184 = fluree.db.dbfunctions.internal.quot.call(null,inst_66175,inst_66183);
var inst_66185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66186 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66188 = [inst_66175,inst_66183];
var inst_66189 = (new cljs.core.PersistentVector(null,2,(5),inst_66187,inst_66188,null));
var inst_66190 = ["quot",inst_66189,inst_66184];
var inst_66191 = cljs.core.PersistentHashMap.fromArrays(inst_66186,inst_66190);
var inst_66192 = [inst_66191,(2)];
var inst_66193 = (new cljs.core.PersistentVector(null,2,(5),inst_66185,inst_66192,null));
var inst_66194 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66193);
var _ = (function (){var statearr_66205 = state_66199;
(statearr_66205[(4)] = cljs.core.rest.call(null,(state_66199[(4)])));

return statearr_66205;
})();
var state_66199__$1 = (function (){var statearr_66206 = state_66199;
(statearr_66206[(8)] = inst_66194);

return statearr_66206;
})();
var statearr_66207_66229 = state_66199__$1;
(statearr_66207_66229[(2)] = inst_66184);

(statearr_66207_66229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66200 === (2))){
var _ = (function (){var statearr_66208 = state_66199;
(statearr_66208[(4)] = cljs.core.cons.call(null,(5),(state_66199[(4)])));

return statearr_66208;
})();
var inst_66168 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_66199__$1 = state_66199;
if(inst_66168){
var statearr_66209_66230 = state_66199__$1;
(statearr_66209_66230[(1)] = (6));

} else {
var statearr_66210_66231 = state_66199__$1;
(statearr_66210_66231[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66200 === (11))){
var state_66199__$1 = state_66199;
var statearr_66212_66232 = state_66199__$1;
(statearr_66212_66232[(2)] = d);

(statearr_66212_66232[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66200 === (9))){
var inst_66171 = (state_66199[(2)]);
var inst_66172 = fluree.db.util.async.throw_err.call(null,inst_66171);
var state_66199__$1 = state_66199;
var statearr_66213_66233 = state_66199__$1;
(statearr_66213_66233[(2)] = inst_66172);

(statearr_66213_66233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66200 === (5))){
var _ = (function (){var statearr_66214 = state_66199;
(statearr_66214[(4)] = cljs.core.rest.call(null,(state_66199[(4)])));

return statearr_66214;
})();
var state_66199__$1 = state_66199;
var ex66211 = (state_66199__$1[(2)]);
var statearr_66215_66234 = state_66199__$1;
(statearr_66215_66234[(5)] = ex66211);


if((ex66211 instanceof Error)){
var statearr_66216_66235 = state_66199__$1;
(statearr_66216_66235[(1)] = (4));

(statearr_66216_66235[(5)] = null);

} else {
throw ex66211;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66200 === (10))){
var state_66199__$1 = state_66199;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66199__$1,(13),d);
} else {
if((state_val_66200 === (8))){
var inst_66175 = (state_66199[(2)]);
var inst_66176 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_66199__$1 = (function (){var statearr_66217 = state_66199;
(statearr_66217[(7)] = inst_66175);

return statearr_66217;
})();
if(inst_66176){
var statearr_66218_66236 = state_66199__$1;
(statearr_66218_66236[(1)] = (10));

} else {
var statearr_66219_66237 = state_66199__$1;
(statearr_66219_66237[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0 = (function (){
var statearr_66220 = [null,null,null,null,null,null,null,null,null];
(statearr_66220[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__);

(statearr_66220[(1)] = (1));

return statearr_66220;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1 = (function (state_66199){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66221){var ex__2687__auto__ = e66221;
var statearr_66222_66238 = state_66199;
(statearr_66222_66238[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66199[(4)]))){
var statearr_66223_66239 = state_66199;
(statearr_66223_66239[(1)] = cljs.core.first.call(null,(state_66199[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66240 = state_66199;
state_66199 = G__66240;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__ = function(state_66199){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1.call(this,state_66199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66224 = f__2707__auto__.call(null);
(statearr_66224[(6)] = c__2706__auto__);

return statearr_66224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66278){
var state_val_66279 = (state_66278[(1)]);
if((state_val_66279 === (7))){
var state_66278__$1 = state_66278;
var statearr_66280_66304 = state_66278__$1;
(statearr_66280_66304[(2)] = n);

(statearr_66280_66304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66279 === (1))){
var state_66278__$1 = state_66278;
var statearr_66281_66305 = state_66278__$1;
(statearr_66281_66305[(2)] = null);

(statearr_66281_66305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66279 === (4))){
var inst_66241 = (state_66278[(2)]);
var state_66278__$1 = state_66278;
var statearr_66282_66306 = state_66278__$1;
(statearr_66282_66306[(2)] = inst_66241);

(statearr_66282_66306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66279 === (13))){
var inst_66258 = (state_66278[(2)]);
var inst_66259 = fluree.db.util.async.throw_err.call(null,inst_66258);
var state_66278__$1 = state_66278;
var statearr_66283_66307 = state_66278__$1;
(statearr_66283_66307[(2)] = inst_66259);

(statearr_66283_66307[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66279 === (6))){
var state_66278__$1 = state_66278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66278__$1,(9),n);
} else {
if((state_val_66279 === (3))){
var inst_66276 = (state_66278[(2)]);
var state_66278__$1 = state_66278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66278__$1,inst_66276);
} else {
if((state_val_66279 === (12))){
var inst_66254 = (state_66278[(7)]);
var inst_66262 = (state_66278[(2)]);
var inst_66263 = fluree.db.dbfunctions.internal.mod.call(null,inst_66254,inst_66262);
var inst_66264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66265 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66267 = [inst_66254,inst_66262];
var inst_66268 = (new cljs.core.PersistentVector(null,2,(5),inst_66266,inst_66267,null));
var inst_66269 = ["mod",inst_66268,inst_66263];
var inst_66270 = cljs.core.PersistentHashMap.fromArrays(inst_66265,inst_66269);
var inst_66271 = [inst_66270,(2)];
var inst_66272 = (new cljs.core.PersistentVector(null,2,(5),inst_66264,inst_66271,null));
var inst_66273 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66272);
var _ = (function (){var statearr_66284 = state_66278;
(statearr_66284[(4)] = cljs.core.rest.call(null,(state_66278[(4)])));

return statearr_66284;
})();
var state_66278__$1 = (function (){var statearr_66285 = state_66278;
(statearr_66285[(8)] = inst_66273);

return statearr_66285;
})();
var statearr_66286_66308 = state_66278__$1;
(statearr_66286_66308[(2)] = inst_66263);

(statearr_66286_66308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66279 === (2))){
var _ = (function (){var statearr_66287 = state_66278;
(statearr_66287[(4)] = cljs.core.cons.call(null,(5),(state_66278[(4)])));

return statearr_66287;
})();
var inst_66247 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_66278__$1 = state_66278;
if(inst_66247){
var statearr_66288_66309 = state_66278__$1;
(statearr_66288_66309[(1)] = (6));

} else {
var statearr_66289_66310 = state_66278__$1;
(statearr_66289_66310[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66279 === (11))){
var state_66278__$1 = state_66278;
var statearr_66291_66311 = state_66278__$1;
(statearr_66291_66311[(2)] = d);

(statearr_66291_66311[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66279 === (9))){
var inst_66250 = (state_66278[(2)]);
var inst_66251 = fluree.db.util.async.throw_err.call(null,inst_66250);
var state_66278__$1 = state_66278;
var statearr_66292_66312 = state_66278__$1;
(statearr_66292_66312[(2)] = inst_66251);

(statearr_66292_66312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66279 === (5))){
var _ = (function (){var statearr_66293 = state_66278;
(statearr_66293[(4)] = cljs.core.rest.call(null,(state_66278[(4)])));

return statearr_66293;
})();
var state_66278__$1 = state_66278;
var ex66290 = (state_66278__$1[(2)]);
var statearr_66294_66313 = state_66278__$1;
(statearr_66294_66313[(5)] = ex66290);


if((ex66290 instanceof Error)){
var statearr_66295_66314 = state_66278__$1;
(statearr_66295_66314[(1)] = (4));

(statearr_66295_66314[(5)] = null);

} else {
throw ex66290;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66279 === (10))){
var state_66278__$1 = state_66278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66278__$1,(13),d);
} else {
if((state_val_66279 === (8))){
var inst_66254 = (state_66278[(2)]);
var inst_66255 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_66278__$1 = (function (){var statearr_66296 = state_66278;
(statearr_66296[(7)] = inst_66254);

return statearr_66296;
})();
if(inst_66255){
var statearr_66297_66315 = state_66278__$1;
(statearr_66297_66315[(1)] = (10));

} else {
var statearr_66298_66316 = state_66278__$1;
(statearr_66298_66316[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0 = (function (){
var statearr_66299 = [null,null,null,null,null,null,null,null,null];
(statearr_66299[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__);

(statearr_66299[(1)] = (1));

return statearr_66299;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1 = (function (state_66278){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66300){var ex__2687__auto__ = e66300;
var statearr_66301_66317 = state_66278;
(statearr_66301_66317[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66278[(4)]))){
var statearr_66302_66318 = state_66278;
(statearr_66302_66318[(1)] = cljs.core.first.call(null,(state_66278[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66319 = state_66278;
state_66278 = G__66319;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__ = function(state_66278){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1.call(this,state_66278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66303 = f__2707__auto__.call(null);
(statearr_66303[(6)] = c__2706__auto__);

return statearr_66303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66357){
var state_val_66358 = (state_66357[(1)]);
if((state_val_66358 === (7))){
var state_66357__$1 = state_66357;
var statearr_66359_66383 = state_66357__$1;
(statearr_66359_66383[(2)] = n);

(statearr_66359_66383[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66358 === (1))){
var state_66357__$1 = state_66357;
var statearr_66360_66384 = state_66357__$1;
(statearr_66360_66384[(2)] = null);

(statearr_66360_66384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66358 === (4))){
var inst_66320 = (state_66357[(2)]);
var state_66357__$1 = state_66357;
var statearr_66361_66385 = state_66357__$1;
(statearr_66361_66385[(2)] = inst_66320);

(statearr_66361_66385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66358 === (13))){
var inst_66337 = (state_66357[(2)]);
var inst_66338 = fluree.db.util.async.throw_err.call(null,inst_66337);
var state_66357__$1 = state_66357;
var statearr_66362_66386 = state_66357__$1;
(statearr_66362_66386[(2)] = inst_66338);

(statearr_66362_66386[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66358 === (6))){
var state_66357__$1 = state_66357;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66357__$1,(9),n);
} else {
if((state_val_66358 === (3))){
var inst_66355 = (state_66357[(2)]);
var state_66357__$1 = state_66357;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66357__$1,inst_66355);
} else {
if((state_val_66358 === (12))){
var inst_66333 = (state_66357[(7)]);
var inst_66341 = (state_66357[(2)]);
var inst_66342 = fluree.db.dbfunctions.internal.rem.call(null,inst_66333,inst_66341);
var inst_66343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66344 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66346 = [inst_66333,inst_66341];
var inst_66347 = (new cljs.core.PersistentVector(null,2,(5),inst_66345,inst_66346,null));
var inst_66348 = ["rem",inst_66347,inst_66342];
var inst_66349 = cljs.core.PersistentHashMap.fromArrays(inst_66344,inst_66348);
var inst_66350 = [inst_66349,(2)];
var inst_66351 = (new cljs.core.PersistentVector(null,2,(5),inst_66343,inst_66350,null));
var inst_66352 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66351);
var _ = (function (){var statearr_66363 = state_66357;
(statearr_66363[(4)] = cljs.core.rest.call(null,(state_66357[(4)])));

return statearr_66363;
})();
var state_66357__$1 = (function (){var statearr_66364 = state_66357;
(statearr_66364[(8)] = inst_66352);

return statearr_66364;
})();
var statearr_66365_66387 = state_66357__$1;
(statearr_66365_66387[(2)] = inst_66342);

(statearr_66365_66387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66358 === (2))){
var _ = (function (){var statearr_66366 = state_66357;
(statearr_66366[(4)] = cljs.core.cons.call(null,(5),(state_66357[(4)])));

return statearr_66366;
})();
var inst_66326 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_66357__$1 = state_66357;
if(inst_66326){
var statearr_66367_66388 = state_66357__$1;
(statearr_66367_66388[(1)] = (6));

} else {
var statearr_66368_66389 = state_66357__$1;
(statearr_66368_66389[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66358 === (11))){
var state_66357__$1 = state_66357;
var statearr_66370_66390 = state_66357__$1;
(statearr_66370_66390[(2)] = d);

(statearr_66370_66390[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66358 === (9))){
var inst_66329 = (state_66357[(2)]);
var inst_66330 = fluree.db.util.async.throw_err.call(null,inst_66329);
var state_66357__$1 = state_66357;
var statearr_66371_66391 = state_66357__$1;
(statearr_66371_66391[(2)] = inst_66330);

(statearr_66371_66391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66358 === (5))){
var _ = (function (){var statearr_66372 = state_66357;
(statearr_66372[(4)] = cljs.core.rest.call(null,(state_66357[(4)])));

return statearr_66372;
})();
var state_66357__$1 = state_66357;
var ex66369 = (state_66357__$1[(2)]);
var statearr_66373_66392 = state_66357__$1;
(statearr_66373_66392[(5)] = ex66369);


if((ex66369 instanceof Error)){
var statearr_66374_66393 = state_66357__$1;
(statearr_66374_66393[(1)] = (4));

(statearr_66374_66393[(5)] = null);

} else {
throw ex66369;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66358 === (10))){
var state_66357__$1 = state_66357;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66357__$1,(13),d);
} else {
if((state_val_66358 === (8))){
var inst_66333 = (state_66357[(2)]);
var inst_66334 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_66357__$1 = (function (){var statearr_66375 = state_66357;
(statearr_66375[(7)] = inst_66333);

return statearr_66375;
})();
if(inst_66334){
var statearr_66376_66394 = state_66357__$1;
(statearr_66376_66394[(1)] = (10));

} else {
var statearr_66377_66395 = state_66357__$1;
(statearr_66377_66395[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0 = (function (){
var statearr_66378 = [null,null,null,null,null,null,null,null,null];
(statearr_66378[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__);

(statearr_66378[(1)] = (1));

return statearr_66378;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1 = (function (state_66357){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66357);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66379){var ex__2687__auto__ = e66379;
var statearr_66380_66396 = state_66357;
(statearr_66380_66396[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66357[(4)]))){
var statearr_66381_66397 = state_66357;
(statearr_66381_66397[(1)] = cljs.core.first.call(null,(state_66357[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66398 = state_66357;
state_66357 = G__66398;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__ = function(state_66357){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1.call(this,state_66357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66382 = f__2707__auto__.call(null);
(statearr_66382[(6)] = c__2706__auto__);

return statearr_66382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66425){
var state_val_66426 = (state_66425[(1)]);
if((state_val_66426 === (7))){
var state_66425__$1 = state_66425;
var statearr_66427_66446 = state_66425__$1;
(statearr_66427_66446[(2)] = x);

(statearr_66427_66446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66426 === (1))){
var state_66425__$1 = state_66425;
var statearr_66428_66447 = state_66425__$1;
(statearr_66428_66447[(2)] = null);

(statearr_66428_66447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66426 === (4))){
var inst_66399 = (state_66425[(2)]);
var state_66425__$1 = state_66425;
var statearr_66429_66448 = state_66425__$1;
(statearr_66429_66448[(2)] = inst_66399);

(statearr_66429_66448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66426 === (6))){
var state_66425__$1 = state_66425;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66425__$1,(9),x);
} else {
if((state_val_66426 === (3))){
var inst_66423 = (state_66425[(2)]);
var state_66425__$1 = state_66425;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66425__$1,inst_66423);
} else {
if((state_val_66426 === (2))){
var _ = (function (){var statearr_66431 = state_66425;
(statearr_66431[(4)] = cljs.core.cons.call(null,(5),(state_66425[(4)])));

return statearr_66431;
})();
var inst_66405 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_66425__$1 = state_66425;
if(inst_66405){
var statearr_66432_66449 = state_66425__$1;
(statearr_66432_66449[(1)] = (6));

} else {
var statearr_66433_66450 = state_66425__$1;
(statearr_66433_66450[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66426 === (9))){
var inst_66408 = (state_66425[(2)]);
var inst_66409 = fluree.db.util.async.throw_err.call(null,inst_66408);
var state_66425__$1 = state_66425;
var statearr_66434_66451 = state_66425__$1;
(statearr_66434_66451[(2)] = inst_66409);

(statearr_66434_66451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66426 === (5))){
var _ = (function (){var statearr_66435 = state_66425;
(statearr_66435[(4)] = cljs.core.rest.call(null,(state_66425[(4)])));

return statearr_66435;
})();
var state_66425__$1 = state_66425;
var ex66430 = (state_66425__$1[(2)]);
var statearr_66436_66452 = state_66425__$1;
(statearr_66436_66452[(5)] = ex66430);


if((ex66430 instanceof Error)){
var statearr_66437_66453 = state_66425__$1;
(statearr_66437_66453[(1)] = (4));

(statearr_66437_66453[(5)] = null);

} else {
throw ex66430;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66426 === (8))){
var inst_66412 = (state_66425[(2)]);
var inst_66413 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_66412);
var inst_66414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66415 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66416 = ["boolean",inst_66412,inst_66413];
var inst_66417 = cljs.core.PersistentHashMap.fromArrays(inst_66415,inst_66416);
var inst_66418 = [inst_66417,(10)];
var inst_66419 = (new cljs.core.PersistentVector(null,2,(5),inst_66414,inst_66418,null));
var inst_66420 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66419);
var _ = (function (){var statearr_66438 = state_66425;
(statearr_66438[(4)] = cljs.core.rest.call(null,(state_66425[(4)])));

return statearr_66438;
})();
var state_66425__$1 = (function (){var statearr_66439 = state_66425;
(statearr_66439[(7)] = inst_66420);

return statearr_66439;
})();
var statearr_66440_66454 = state_66425__$1;
(statearr_66440_66454[(2)] = inst_66413);

(statearr_66440_66454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0 = (function (){
var statearr_66441 = [null,null,null,null,null,null,null,null];
(statearr_66441[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__);

(statearr_66441[(1)] = (1));

return statearr_66441;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1 = (function (state_66425){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66425);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66442){var ex__2687__auto__ = e66442;
var statearr_66443_66455 = state_66425;
(statearr_66443_66455[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66425[(4)]))){
var statearr_66444_66456 = state_66425;
(statearr_66444_66456[(1)] = cljs.core.first.call(null,(state_66425[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66457 = state_66425;
state_66425 = G__66457;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__ = function(state_66425){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1.call(this,state_66425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66445 = f__2707__auto__.call(null);
(statearr_66445[(6)] = c__2706__auto__);

return statearr_66445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66495){
var state_val_66496 = (state_66495[(1)]);
if((state_val_66496 === (7))){
var state_66495__$1 = state_66495;
var statearr_66497_66521 = state_66495__$1;
(statearr_66497_66521[(2)] = pattern);

(statearr_66497_66521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66496 === (1))){
var state_66495__$1 = state_66495;
var statearr_66498_66522 = state_66495__$1;
(statearr_66498_66522[(2)] = null);

(statearr_66498_66522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66496 === (4))){
var inst_66458 = (state_66495[(2)]);
var state_66495__$1 = state_66495;
var statearr_66499_66523 = state_66495__$1;
(statearr_66499_66523[(2)] = inst_66458);

(statearr_66499_66523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66496 === (13))){
var inst_66475 = (state_66495[(2)]);
var inst_66476 = fluree.db.util.async.throw_err.call(null,inst_66475);
var state_66495__$1 = state_66495;
var statearr_66500_66524 = state_66495__$1;
(statearr_66500_66524[(2)] = inst_66476);

(statearr_66500_66524[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66496 === (6))){
var state_66495__$1 = state_66495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66495__$1,(9),pattern);
} else {
if((state_val_66496 === (3))){
var inst_66493 = (state_66495[(2)]);
var state_66495__$1 = state_66495;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66495__$1,inst_66493);
} else {
if((state_val_66496 === (12))){
var inst_66471 = (state_66495[(7)]);
var inst_66479 = (state_66495[(2)]);
var inst_66480 = fluree.db.dbfunctions.internal.re_find.call(null,inst_66471,inst_66479);
var inst_66481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66482 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66484 = [inst_66471,inst_66479];
var inst_66485 = (new cljs.core.PersistentVector(null,2,(5),inst_66483,inst_66484,null));
var inst_66486 = ["re-find",inst_66485,inst_66480];
var inst_66487 = cljs.core.PersistentHashMap.fromArrays(inst_66482,inst_66486);
var inst_66488 = [inst_66487,(10)];
var inst_66489 = (new cljs.core.PersistentVector(null,2,(5),inst_66481,inst_66488,null));
var inst_66490 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66489);
var _ = (function (){var statearr_66501 = state_66495;
(statearr_66501[(4)] = cljs.core.rest.call(null,(state_66495[(4)])));

return statearr_66501;
})();
var state_66495__$1 = (function (){var statearr_66502 = state_66495;
(statearr_66502[(8)] = inst_66490);

return statearr_66502;
})();
var statearr_66503_66525 = state_66495__$1;
(statearr_66503_66525[(2)] = inst_66480);

(statearr_66503_66525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66496 === (2))){
var _ = (function (){var statearr_66504 = state_66495;
(statearr_66504[(4)] = cljs.core.cons.call(null,(5),(state_66495[(4)])));

return statearr_66504;
})();
var inst_66464 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_66495__$1 = state_66495;
if(inst_66464){
var statearr_66505_66526 = state_66495__$1;
(statearr_66505_66526[(1)] = (6));

} else {
var statearr_66506_66527 = state_66495__$1;
(statearr_66506_66527[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66496 === (11))){
var state_66495__$1 = state_66495;
var statearr_66508_66528 = state_66495__$1;
(statearr_66508_66528[(2)] = string);

(statearr_66508_66528[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66496 === (9))){
var inst_66467 = (state_66495[(2)]);
var inst_66468 = fluree.db.util.async.throw_err.call(null,inst_66467);
var state_66495__$1 = state_66495;
var statearr_66509_66529 = state_66495__$1;
(statearr_66509_66529[(2)] = inst_66468);

(statearr_66509_66529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66496 === (5))){
var _ = (function (){var statearr_66510 = state_66495;
(statearr_66510[(4)] = cljs.core.rest.call(null,(state_66495[(4)])));

return statearr_66510;
})();
var state_66495__$1 = state_66495;
var ex66507 = (state_66495__$1[(2)]);
var statearr_66511_66530 = state_66495__$1;
(statearr_66511_66530[(5)] = ex66507);


if((ex66507 instanceof Error)){
var statearr_66512_66531 = state_66495__$1;
(statearr_66512_66531[(1)] = (4));

(statearr_66512_66531[(5)] = null);

} else {
throw ex66507;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66496 === (10))){
var state_66495__$1 = state_66495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66495__$1,(13),string);
} else {
if((state_val_66496 === (8))){
var inst_66471 = (state_66495[(2)]);
var inst_66472 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_66495__$1 = (function (){var statearr_66513 = state_66495;
(statearr_66513[(7)] = inst_66471);

return statearr_66513;
})();
if(inst_66472){
var statearr_66514_66532 = state_66495__$1;
(statearr_66514_66532[(1)] = (10));

} else {
var statearr_66515_66533 = state_66495__$1;
(statearr_66515_66533[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0 = (function (){
var statearr_66516 = [null,null,null,null,null,null,null,null,null];
(statearr_66516[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__);

(statearr_66516[(1)] = (1));

return statearr_66516;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1 = (function (state_66495){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66495);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66517){var ex__2687__auto__ = e66517;
var statearr_66518_66534 = state_66495;
(statearr_66518_66534[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66495[(4)]))){
var statearr_66519_66535 = state_66495;
(statearr_66519_66535[(1)] = cljs.core.first.call(null,(state_66495[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66536 = state_66495;
state_66495 = G__66536;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__ = function(state_66495){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1.call(this,state_66495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66520 = f__2707__auto__.call(null);
(statearr_66520[(6)] = c__2706__auto__);

return statearr_66520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66563){
var state_val_66564 = (state_66563[(1)]);
if((state_val_66564 === (7))){
var state_66563__$1 = state_66563;
var statearr_66565_66584 = state_66563__$1;
(statearr_66565_66584[(2)] = email);

(statearr_66565_66584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (1))){
var state_66563__$1 = state_66563;
var statearr_66566_66585 = state_66563__$1;
(statearr_66566_66585[(2)] = null);

(statearr_66566_66585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (4))){
var inst_66537 = (state_66563[(2)]);
var state_66563__$1 = state_66563;
var statearr_66567_66586 = state_66563__$1;
(statearr_66567_66586[(2)] = inst_66537);

(statearr_66567_66586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (6))){
var state_66563__$1 = state_66563;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66563__$1,(9),email);
} else {
if((state_val_66564 === (3))){
var inst_66561 = (state_66563[(2)]);
var state_66563__$1 = state_66563;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66563__$1,inst_66561);
} else {
if((state_val_66564 === (2))){
var _ = (function (){var statearr_66569 = state_66563;
(statearr_66569[(4)] = cljs.core.cons.call(null,(5),(state_66563[(4)])));

return statearr_66569;
})();
var inst_66543 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_66563__$1 = state_66563;
if(inst_66543){
var statearr_66570_66587 = state_66563__$1;
(statearr_66570_66587[(1)] = (6));

} else {
var statearr_66571_66588 = state_66563__$1;
(statearr_66571_66588[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (9))){
var inst_66546 = (state_66563[(2)]);
var inst_66547 = fluree.db.util.async.throw_err.call(null,inst_66546);
var state_66563__$1 = state_66563;
var statearr_66572_66589 = state_66563__$1;
(statearr_66572_66589[(2)] = inst_66547);

(statearr_66572_66589[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (5))){
var _ = (function (){var statearr_66573 = state_66563;
(statearr_66573[(4)] = cljs.core.rest.call(null,(state_66563[(4)])));

return statearr_66573;
})();
var state_66563__$1 = state_66563;
var ex66568 = (state_66563__$1[(2)]);
var statearr_66574_66590 = state_66563__$1;
(statearr_66574_66590[(5)] = ex66568);


if((ex66568 instanceof Error)){
var statearr_66575_66591 = state_66563__$1;
(statearr_66575_66591[(1)] = (4));

(statearr_66575_66591[(5)] = null);

} else {
throw ex66568;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (8))){
var inst_66550 = (state_66563[(2)]);
var inst_66551 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_66550);
var inst_66552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66553 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66554 = ["re-find",inst_66550,inst_66551];
var inst_66555 = cljs.core.PersistentHashMap.fromArrays(inst_66553,inst_66554);
var inst_66556 = [inst_66555,(10)];
var inst_66557 = (new cljs.core.PersistentVector(null,2,(5),inst_66552,inst_66556,null));
var inst_66558 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66557);
var _ = (function (){var statearr_66576 = state_66563;
(statearr_66576[(4)] = cljs.core.rest.call(null,(state_66563[(4)])));

return statearr_66576;
})();
var state_66563__$1 = (function (){var statearr_66577 = state_66563;
(statearr_66577[(7)] = inst_66558);

return statearr_66577;
})();
var statearr_66578_66592 = state_66563__$1;
(statearr_66578_66592[(2)] = inst_66551);

(statearr_66578_66592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_66579 = [null,null,null,null,null,null,null,null];
(statearr_66579[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__);

(statearr_66579[(1)] = (1));

return statearr_66579;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1 = (function (state_66563){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66563);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66580){var ex__2687__auto__ = e66580;
var statearr_66581_66593 = state_66563;
(statearr_66581_66593[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66563[(4)]))){
var statearr_66582_66594 = state_66563;
(statearr_66582_66594[(1)] = cljs.core.first.call(null,(state_66563[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66595 = state_66563;
state_66563 = G__66595;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__ = function(state_66563){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1.call(this,state_66563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66583 = f__2707__auto__.call(null);
(statearr_66583[(6)] = c__2706__auto__);

return statearr_66583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66642){
var state_val_66643 = (state_66642[(1)]);
if((state_val_66643 === (7))){
var inst_66612 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66642__$1 = state_66642;
if(cljs.core.truth_(inst_66612)){
var statearr_66644_66671 = state_66642__$1;
(statearr_66644_66671[(1)] = (9));

} else {
var statearr_66645_66672 = state_66642__$1;
(statearr_66645_66672[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (1))){
var state_66642__$1 = state_66642;
var statearr_66646_66673 = state_66642__$1;
(statearr_66646_66673[(2)] = null);

(statearr_66646_66673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (4))){
var inst_66596 = (state_66642[(2)]);
var state_66642__$1 = state_66642;
var statearr_66647_66674 = state_66642__$1;
(statearr_66647_66674[(2)] = inst_66596);

(statearr_66647_66674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (15))){
var inst_66623 = (state_66642[(2)]);
var state_66642__$1 = state_66642;
var statearr_66648_66675 = state_66642__$1;
(statearr_66648_66675[(2)] = inst_66623);

(statearr_66648_66675[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (13))){
var inst_66620 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_66642__$1 = state_66642;
var statearr_66649_66676 = state_66642__$1;
(statearr_66649_66676[(2)] = inst_66620);

(statearr_66649_66676[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (6))){
var inst_66607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66608 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66609 = [inst_66608,(0)];
var inst_66610 = (new cljs.core.PersistentVector(null,2,(5),inst_66607,inst_66609,null));
var state_66642__$1 = state_66642;
var statearr_66650_66677 = state_66642__$1;
(statearr_66650_66677[(2)] = inst_66610);

(statearr_66650_66677[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (3))){
var inst_66640 = (state_66642[(2)]);
var state_66642__$1 = state_66642;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66642__$1,inst_66640);
} else {
if((state_val_66643 === (12))){
var inst_66616 = (state_66642[(2)]);
var inst_66617 = fluree.db.util.async.throw_err.call(null,inst_66616);
var state_66642__$1 = state_66642;
var statearr_66651_66678 = state_66642__$1;
(statearr_66651_66678[(2)] = inst_66617);

(statearr_66651_66678[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (2))){
var _ = (function (){var statearr_66652 = state_66642;
(statearr_66652[(4)] = cljs.core.cons.call(null,(5),(state_66642[(4)])));

return statearr_66652;
})();
var inst_66605 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66642__$1 = state_66642;
if(cljs.core.truth_(inst_66605)){
var statearr_66653_66679 = state_66642__$1;
(statearr_66653_66679[(1)] = (6));

} else {
var statearr_66654_66680 = state_66642__$1;
(statearr_66654_66680[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (11))){
var inst_66625 = (state_66642[(2)]);
var state_66642__$1 = state_66642;
var statearr_66656_66681 = state_66642__$1;
(statearr_66656_66681[(2)] = inst_66625);

(statearr_66656_66681[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (9))){
var inst_66614 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_66642__$1 = state_66642;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66642__$1,(12),inst_66614);
} else {
if((state_val_66643 === (5))){
var _ = (function (){var statearr_66657 = state_66642;
(statearr_66657[(4)] = cljs.core.rest.call(null,(state_66642[(4)])));

return statearr_66657;
})();
var state_66642__$1 = state_66642;
var ex66655 = (state_66642__$1[(2)]);
var statearr_66658_66682 = state_66642__$1;
(statearr_66658_66682[(5)] = ex66655);


if((ex66655 instanceof Error)){
var statearr_66659_66683 = state_66642__$1;
(statearr_66659_66683[(1)] = (4));

(statearr_66659_66683[(5)] = null);

} else {
throw ex66655;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (14))){
var state_66642__$1 = state_66642;
var statearr_66660_66684 = state_66642__$1;
(statearr_66660_66684[(2)] = null);

(statearr_66660_66684[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (10))){
var state_66642__$1 = state_66642;
var statearr_66661_66685 = state_66642__$1;
(statearr_66661_66685[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66643 === (8))){
var inst_66627 = (state_66642[(2)]);
var inst_66628 = cljs.core.nth.call(null,inst_66627,(0),null);
var inst_66629 = cljs.core.nth.call(null,inst_66627,(1),null);
var inst_66630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66631 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66632 = ["?user_id","?ctx",inst_66628];
var inst_66633 = cljs.core.PersistentHashMap.fromArrays(inst_66631,inst_66632);
var inst_66634 = ((10) + inst_66629);
var inst_66635 = [inst_66633,inst_66634];
var inst_66636 = (new cljs.core.PersistentVector(null,2,(5),inst_66630,inst_66635,null));
var inst_66637 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66636);
var _ = (function (){var statearr_66663 = state_66642;
(statearr_66663[(4)] = cljs.core.rest.call(null,(state_66642[(4)])));

return statearr_66663;
})();
var state_66642__$1 = (function (){var statearr_66664 = state_66642;
(statearr_66664[(7)] = inst_66637);

return statearr_66664;
})();
var statearr_66665_66686 = state_66642__$1;
(statearr_66665_66686[(2)] = inst_66628);

(statearr_66665_66686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0 = (function (){
var statearr_66666 = [null,null,null,null,null,null,null,null];
(statearr_66666[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__);

(statearr_66666[(1)] = (1));

return statearr_66666;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1 = (function (state_66642){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66642);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66667){var ex__2687__auto__ = e66667;
var statearr_66668_66687 = state_66642;
(statearr_66668_66687[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66642[(4)]))){
var statearr_66669_66688 = state_66642;
(statearr_66669_66688[(1)] = cljs.core.first.call(null,(state_66642[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66689 = state_66642;
state_66642 = G__66689;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__ = function(state_66642){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1.call(this,state_66642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66670 = f__2707__auto__.call(null);
(statearr_66670[(6)] = c__2706__auto__);

return statearr_66670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66717){
var state_val_66718 = (state_66717[(1)]);
if((state_val_66718 === (7))){
var inst_66710 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_66717__$1 = state_66717;
var statearr_66719_66738 = state_66717__$1;
(statearr_66719_66738[(2)] = inst_66710);

(statearr_66719_66738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66718 === (1))){
var state_66717__$1 = state_66717;
var statearr_66720_66739 = state_66717__$1;
(statearr_66720_66739[(2)] = null);

(statearr_66720_66739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66718 === (4))){
var inst_66690 = (state_66717[(2)]);
var state_66717__$1 = state_66717;
var statearr_66721_66740 = state_66717__$1;
(statearr_66721_66740[(2)] = inst_66690);

(statearr_66721_66740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66718 === (6))){
var inst_66698 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_66717__$1 = state_66717;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66717__$1,(9),inst_66698);
} else {
if((state_val_66718 === (3))){
var inst_66715 = (state_66717[(2)]);
var state_66717__$1 = state_66717;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66717__$1,inst_66715);
} else {
if((state_val_66718 === (2))){
var _ = (function (){var statearr_66723 = state_66717;
(statearr_66723[(4)] = cljs.core.cons.call(null,(5),(state_66717[(4)])));

return statearr_66723;
})();
var inst_66696 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66717__$1 = state_66717;
if(cljs.core.truth_(inst_66696)){
var statearr_66724_66741 = state_66717__$1;
(statearr_66724_66741[(1)] = (6));

} else {
var statearr_66725_66742 = state_66717__$1;
(statearr_66725_66742[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66718 === (9))){
var inst_66700 = (state_66717[(2)]);
var inst_66701 = fluree.db.util.async.throw_err.call(null,inst_66700);
var inst_66702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66703 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66704 = ["?auth_id","?ctx",inst_66701];
var inst_66705 = cljs.core.PersistentHashMap.fromArrays(inst_66703,inst_66704);
var inst_66706 = [inst_66705,(10)];
var inst_66707 = (new cljs.core.PersistentVector(null,2,(5),inst_66702,inst_66706,null));
var inst_66708 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66707);
var state_66717__$1 = (function (){var statearr_66726 = state_66717;
(statearr_66726[(7)] = inst_66708);

return statearr_66726;
})();
var statearr_66727_66743 = state_66717__$1;
(statearr_66727_66743[(2)] = inst_66701);

(statearr_66727_66743[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66718 === (5))){
var _ = (function (){var statearr_66728 = state_66717;
(statearr_66728[(4)] = cljs.core.rest.call(null,(state_66717[(4)])));

return statearr_66728;
})();
var state_66717__$1 = state_66717;
var ex66722 = (state_66717__$1[(2)]);
var statearr_66729_66744 = state_66717__$1;
(statearr_66729_66744[(5)] = ex66722);


if((ex66722 instanceof Error)){
var statearr_66730_66745 = state_66717__$1;
(statearr_66730_66745[(1)] = (4));

(statearr_66730_66745[(5)] = null);

} else {
throw ex66722;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66718 === (8))){
var inst_66712 = (state_66717[(2)]);
var _ = (function (){var statearr_66731 = state_66717;
(statearr_66731[(4)] = cljs.core.rest.call(null,(state_66717[(4)])));

return statearr_66731;
})();
var state_66717__$1 = state_66717;
var statearr_66732_66746 = state_66717__$1;
(statearr_66732_66746[(2)] = inst_66712);

(statearr_66732_66746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0 = (function (){
var statearr_66733 = [null,null,null,null,null,null,null,null];
(statearr_66733[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__);

(statearr_66733[(1)] = (1));

return statearr_66733;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1 = (function (state_66717){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66717);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66734){var ex__2687__auto__ = e66734;
var statearr_66735_66747 = state_66717;
(statearr_66735_66747[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66717[(4)]))){
var statearr_66736_66748 = state_66717;
(statearr_66736_66748[(1)] = cljs.core.first.call(null,(state_66717[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66749 = state_66717;
state_66717 = G__66749;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__ = function(state_66717){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1.call(this,state_66717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66737 = f__2707__auto__.call(null);
(statearr_66737[(6)] = c__2706__auto__);

return statearr_66737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__66751 = arguments.length;
switch (G__66751) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66793){
var state_val_66794 = (state_66793[(1)]);
if((state_val_66794 === (7))){
var state_66793__$1 = state_66793;
var statearr_66795_66825 = state_66793__$1;
(statearr_66795_66825[(2)] = seed);

(statearr_66795_66825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (1))){
var state_66793__$1 = state_66793;
var statearr_66796_66826 = state_66793__$1;
(statearr_66796_66826[(2)] = null);

(statearr_66796_66826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (4))){
var inst_66752 = (state_66793[(2)]);
var state_66793__$1 = state_66793;
var statearr_66797_66827 = state_66793__$1;
(statearr_66797_66827[(2)] = inst_66752);

(statearr_66797_66827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (15))){
var state_66793__$1 = state_66793;
var statearr_66798_66828 = state_66793__$1;
(statearr_66798_66828[(2)] = (10));

(statearr_66798_66828[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (13))){
var inst_66769 = (state_66793[(2)]);
var inst_66770 = fluree.db.util.async.throw_err.call(null,inst_66769);
var state_66793__$1 = state_66793;
var statearr_66799_66829 = state_66793__$1;
(statearr_66799_66829[(2)] = inst_66770);

(statearr_66799_66829[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (6))){
var state_66793__$1 = state_66793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66793__$1,(9),seed);
} else {
if((state_val_66794 === (3))){
var inst_66791 = (state_66793[(2)]);
var state_66793__$1 = state_66793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66793__$1,inst_66791);
} else {
if((state_val_66794 === (12))){
var inst_66773 = (state_66793[(7)]);
var inst_66773__$1 = (state_66793[(2)]);
var state_66793__$1 = (function (){var statearr_66800 = state_66793;
(statearr_66800[(7)] = inst_66773__$1);

return statearr_66800;
})();
if(cljs.core.truth_(inst_66773__$1)){
var statearr_66801_66830 = state_66793__$1;
(statearr_66801_66830[(1)] = (14));

} else {
var statearr_66802_66831 = state_66793__$1;
(statearr_66802_66831[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (2))){
var _ = (function (){var statearr_66803 = state_66793;
(statearr_66803[(4)] = cljs.core.cons.call(null,(5),(state_66793[(4)])));

return statearr_66803;
})();
var inst_66758 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_66793__$1 = state_66793;
if(inst_66758){
var statearr_66804_66832 = state_66793__$1;
(statearr_66804_66832[(1)] = (6));

} else {
var statearr_66805_66833 = state_66793__$1;
(statearr_66805_66833[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (11))){
var state_66793__$1 = state_66793;
var statearr_66807_66834 = state_66793__$1;
(statearr_66807_66834[(2)] = max);

(statearr_66807_66834[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (9))){
var inst_66761 = (state_66793[(2)]);
var inst_66762 = fluree.db.util.async.throw_err.call(null,inst_66761);
var state_66793__$1 = state_66793;
var statearr_66808_66835 = state_66793__$1;
(statearr_66808_66835[(2)] = inst_66762);

(statearr_66808_66835[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (5))){
var _ = (function (){var statearr_66809 = state_66793;
(statearr_66809[(4)] = cljs.core.rest.call(null,(state_66793[(4)])));

return statearr_66809;
})();
var state_66793__$1 = state_66793;
var ex66806 = (state_66793__$1[(2)]);
var statearr_66810_66836 = state_66793__$1;
(statearr_66810_66836[(5)] = ex66806);


if((ex66806 instanceof Error)){
var statearr_66811_66837 = state_66793__$1;
(statearr_66811_66837[(1)] = (4));

(statearr_66811_66837[(5)] = null);

} else {
throw ex66806;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (14))){
var inst_66773 = (state_66793[(7)]);
var state_66793__$1 = state_66793;
var statearr_66812_66838 = state_66793__$1;
(statearr_66812_66838[(2)] = inst_66773);

(statearr_66812_66838[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (16))){
var inst_66765 = (state_66793[(8)]);
var inst_66777 = (state_66793[(2)]);
var inst_66778 = fluree.db.dbfunctions.internal.rand.call(null,inst_66765,inst_66777);
var inst_66779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66780 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66782 = [max,seed];
var inst_66783 = (new cljs.core.PersistentVector(null,2,(5),inst_66781,inst_66782,null));
var inst_66784 = ["rand",inst_66783,inst_66778];
var inst_66785 = cljs.core.PersistentHashMap.fromArrays(inst_66780,inst_66784);
var inst_66786 = [inst_66785,(10)];
var inst_66787 = (new cljs.core.PersistentVector(null,2,(5),inst_66779,inst_66786,null));
var inst_66788 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66787);
var _ = (function (){var statearr_66813 = state_66793;
(statearr_66813[(4)] = cljs.core.rest.call(null,(state_66793[(4)])));

return statearr_66813;
})();
var state_66793__$1 = (function (){var statearr_66814 = state_66793;
(statearr_66814[(9)] = inst_66788);

return statearr_66814;
})();
var statearr_66815_66839 = state_66793__$1;
(statearr_66815_66839[(2)] = inst_66778);

(statearr_66815_66839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66794 === (10))){
var state_66793__$1 = state_66793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66793__$1,(13),max);
} else {
if((state_val_66794 === (8))){
var inst_66765 = (state_66793[(2)]);
var inst_66766 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_66793__$1 = (function (){var statearr_66816 = state_66793;
(statearr_66816[(8)] = inst_66765);

return statearr_66816;
})();
if(inst_66766){
var statearr_66817_66840 = state_66793__$1;
(statearr_66817_66840[(1)] = (10));

} else {
var statearr_66818_66841 = state_66793__$1;
(statearr_66818_66841[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66819 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66819[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66819[(1)] = (1));

return statearr_66819;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66793){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66820){var ex__2687__auto__ = e66820;
var statearr_66821_66842 = state_66793;
(statearr_66821_66842[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66793[(4)]))){
var statearr_66822_66843 = state_66793;
(statearr_66822_66843[(1)] = cljs.core.first.call(null,(state_66793[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66844 = state_66793;
state_66793 = G__66844;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66793){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66823 = f__2707__auto__.call(null);
(statearr_66823[(6)] = c__2706__auto__);

return statearr_66823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66865){
var state_val_66866 = (state_66865[(1)]);
if((state_val_66866 === (1))){
var state_66865__$1 = state_66865;
var statearr_66867_66882 = state_66865__$1;
(statearr_66867_66882[(2)] = null);

(statearr_66867_66882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66866 === (2))){
var _ = (function (){var statearr_66868 = state_66865;
(statearr_66868[(4)] = cljs.core.cons.call(null,(5),(state_66865[(4)])));

return statearr_66868;
})();
var inst_66851 = cljs.core.random_uuid.call(null);
var inst_66852 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66851);
var inst_66853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66854 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66855 = cljs.core.PersistentVector.EMPTY;
var inst_66856 = ["uuid",inst_66855,inst_66852];
var inst_66857 = cljs.core.PersistentHashMap.fromArrays(inst_66854,inst_66856);
var inst_66858 = [inst_66857,(10)];
var inst_66859 = (new cljs.core.PersistentVector(null,2,(5),inst_66853,inst_66858,null));
var inst_66860 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66859);
var ___$1 = (function (){var statearr_66869 = state_66865;
(statearr_66869[(4)] = cljs.core.rest.call(null,(state_66865[(4)])));

return statearr_66869;
})();
var state_66865__$1 = (function (){var statearr_66870 = state_66865;
(statearr_66870[(7)] = inst_66860);

return statearr_66870;
})();
var statearr_66871_66883 = state_66865__$1;
(statearr_66871_66883[(2)] = inst_66852);

(statearr_66871_66883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66866 === (3))){
var inst_66863 = (state_66865[(2)]);
var state_66865__$1 = state_66865;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66865__$1,inst_66863);
} else {
if((state_val_66866 === (4))){
var inst_66845 = (state_66865[(2)]);
var state_66865__$1 = state_66865;
var statearr_66873_66884 = state_66865__$1;
(statearr_66873_66884[(2)] = inst_66845);

(statearr_66873_66884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66866 === (5))){
var _ = (function (){var statearr_66874 = state_66865;
(statearr_66874[(4)] = cljs.core.rest.call(null,(state_66865[(4)])));

return statearr_66874;
})();
var state_66865__$1 = state_66865;
var ex66872 = (state_66865__$1[(2)]);
var statearr_66875_66885 = state_66865__$1;
(statearr_66875_66885[(5)] = ex66872);


if((ex66872 instanceof Error)){
var statearr_66876_66886 = state_66865__$1;
(statearr_66876_66886[(1)] = (4));

(statearr_66876_66886[(5)] = null);

} else {
throw ex66872;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0 = (function (){
var statearr_66877 = [null,null,null,null,null,null,null,null];
(statearr_66877[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__);

(statearr_66877[(1)] = (1));

return statearr_66877;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1 = (function (state_66865){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66865);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66878){var ex__2687__auto__ = e66878;
var statearr_66879_66887 = state_66865;
(statearr_66879_66887[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66865[(4)]))){
var statearr_66880_66888 = state_66865;
(statearr_66880_66888[(1)] = cljs.core.first.call(null,(state_66865[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66889 = state_66865;
state_66865 = G__66889;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__ = function(state_66865){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1.call(this,state_66865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66881 = f__2707__auto__.call(null);
(statearr_66881[(6)] = c__2706__auto__);

return statearr_66881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66919){
var state_val_66920 = (state_66919[(1)]);
if((state_val_66920 === (7))){
var state_66919__$1 = state_66919;
var statearr_66921_66940 = state_66919__$1;
(statearr_66921_66940[(2)] = num);

(statearr_66921_66940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66920 === (1))){
var state_66919__$1 = state_66919;
var statearr_66922_66941 = state_66919__$1;
(statearr_66922_66941[(2)] = null);

(statearr_66922_66941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66920 === (4))){
var inst_66890 = (state_66919[(2)]);
var state_66919__$1 = state_66919;
var statearr_66923_66942 = state_66919__$1;
(statearr_66923_66942[(2)] = inst_66890);

(statearr_66923_66942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66920 === (6))){
var state_66919__$1 = state_66919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66919__$1,(9),num);
} else {
if((state_val_66920 === (3))){
var inst_66917 = (state_66919[(2)]);
var state_66919__$1 = state_66919;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66919__$1,inst_66917);
} else {
if((state_val_66920 === (2))){
var _ = (function (){var statearr_66925 = state_66919;
(statearr_66925[(4)] = cljs.core.cons.call(null,(5),(state_66919[(4)])));

return statearr_66925;
})();
var inst_66896 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_66919__$1 = state_66919;
if(inst_66896){
var statearr_66926_66943 = state_66919__$1;
(statearr_66926_66943[(1)] = (6));

} else {
var statearr_66927_66944 = state_66919__$1;
(statearr_66927_66944[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66920 === (9))){
var inst_66899 = (state_66919[(2)]);
var inst_66900 = fluree.db.util.async.throw_err.call(null,inst_66899);
var state_66919__$1 = state_66919;
var statearr_66928_66945 = state_66919__$1;
(statearr_66928_66945[(2)] = inst_66900);

(statearr_66928_66945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66920 === (5))){
var _ = (function (){var statearr_66929 = state_66919;
(statearr_66929[(4)] = cljs.core.rest.call(null,(state_66919[(4)])));

return statearr_66929;
})();
var state_66919__$1 = state_66919;
var ex66924 = (state_66919__$1[(2)]);
var statearr_66930_66946 = state_66919__$1;
(statearr_66930_66946[(5)] = ex66924);


if((ex66924 instanceof Error)){
var statearr_66931_66947 = state_66919__$1;
(statearr_66931_66947[(1)] = (4));

(statearr_66931_66947[(5)] = null);

} else {
throw ex66924;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66920 === (8))){
var inst_66903 = (state_66919[(2)]);
var inst_66904 = fluree.db.dbfunctions.internal.ceil.call(null,inst_66903);
var inst_66905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66906 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66908 = [fluree.db.dbfunctions.fns.ceil];
var inst_66909 = (new cljs.core.PersistentVector(null,1,(5),inst_66907,inst_66908,null));
var inst_66910 = ["",inst_66909,inst_66904];
var inst_66911 = cljs.core.PersistentHashMap.fromArrays(inst_66906,inst_66910);
var inst_66912 = [inst_66911,(10)];
var inst_66913 = (new cljs.core.PersistentVector(null,2,(5),inst_66905,inst_66912,null));
var inst_66914 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66913);
var _ = (function (){var statearr_66932 = state_66919;
(statearr_66932[(4)] = cljs.core.rest.call(null,(state_66919[(4)])));

return statearr_66932;
})();
var state_66919__$1 = (function (){var statearr_66933 = state_66919;
(statearr_66933[(7)] = inst_66914);

return statearr_66933;
})();
var statearr_66934_66948 = state_66919__$1;
(statearr_66934_66948[(2)] = inst_66904);

(statearr_66934_66948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0 = (function (){
var statearr_66935 = [null,null,null,null,null,null,null,null];
(statearr_66935[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__);

(statearr_66935[(1)] = (1));

return statearr_66935;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1 = (function (state_66919){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66919);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66936){var ex__2687__auto__ = e66936;
var statearr_66937_66949 = state_66919;
(statearr_66937_66949[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66919[(4)]))){
var statearr_66938_66950 = state_66919;
(statearr_66938_66950[(1)] = cljs.core.first.call(null,(state_66919[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66951 = state_66919;
state_66919 = G__66951;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__ = function(state_66919){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1.call(this,state_66919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66939 = f__2707__auto__.call(null);
(statearr_66939[(6)] = c__2706__auto__);

return statearr_66939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66981){
var state_val_66982 = (state_66981[(1)]);
if((state_val_66982 === (7))){
var state_66981__$1 = state_66981;
var statearr_66983_67002 = state_66981__$1;
(statearr_66983_67002[(2)] = num);

(statearr_66983_67002[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (1))){
var state_66981__$1 = state_66981;
var statearr_66984_67003 = state_66981__$1;
(statearr_66984_67003[(2)] = null);

(statearr_66984_67003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (4))){
var inst_66952 = (state_66981[(2)]);
var state_66981__$1 = state_66981;
var statearr_66985_67004 = state_66981__$1;
(statearr_66985_67004[(2)] = inst_66952);

(statearr_66985_67004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (6))){
var state_66981__$1 = state_66981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66981__$1,(9),num);
} else {
if((state_val_66982 === (3))){
var inst_66979 = (state_66981[(2)]);
var state_66981__$1 = state_66981;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66981__$1,inst_66979);
} else {
if((state_val_66982 === (2))){
var _ = (function (){var statearr_66987 = state_66981;
(statearr_66987[(4)] = cljs.core.cons.call(null,(5),(state_66981[(4)])));

return statearr_66987;
})();
var inst_66958 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_66981__$1 = state_66981;
if(inst_66958){
var statearr_66988_67005 = state_66981__$1;
(statearr_66988_67005[(1)] = (6));

} else {
var statearr_66989_67006 = state_66981__$1;
(statearr_66989_67006[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (9))){
var inst_66961 = (state_66981[(2)]);
var inst_66962 = fluree.db.util.async.throw_err.call(null,inst_66961);
var state_66981__$1 = state_66981;
var statearr_66990_67007 = state_66981__$1;
(statearr_66990_67007[(2)] = inst_66962);

(statearr_66990_67007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (5))){
var _ = (function (){var statearr_66991 = state_66981;
(statearr_66991[(4)] = cljs.core.rest.call(null,(state_66981[(4)])));

return statearr_66991;
})();
var state_66981__$1 = state_66981;
var ex66986 = (state_66981__$1[(2)]);
var statearr_66992_67008 = state_66981__$1;
(statearr_66992_67008[(5)] = ex66986);


if((ex66986 instanceof Error)){
var statearr_66993_67009 = state_66981__$1;
(statearr_66993_67009[(1)] = (4));

(statearr_66993_67009[(5)] = null);

} else {
throw ex66986;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (8))){
var inst_66965 = (state_66981[(2)]);
var inst_66966 = fluree.db.dbfunctions.internal.floor.call(null,inst_66965);
var inst_66967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66968 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66970 = [fluree.db.dbfunctions.fns.floor];
var inst_66971 = (new cljs.core.PersistentVector(null,1,(5),inst_66969,inst_66970,null));
var inst_66972 = ["",inst_66971,inst_66966];
var inst_66973 = cljs.core.PersistentHashMap.fromArrays(inst_66968,inst_66972);
var inst_66974 = [inst_66973,(10)];
var inst_66975 = (new cljs.core.PersistentVector(null,2,(5),inst_66967,inst_66974,null));
var inst_66976 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66975);
var _ = (function (){var statearr_66994 = state_66981;
(statearr_66994[(4)] = cljs.core.rest.call(null,(state_66981[(4)])));

return statearr_66994;
})();
var state_66981__$1 = (function (){var statearr_66995 = state_66981;
(statearr_66995[(7)] = inst_66976);

return statearr_66995;
})();
var statearr_66996_67010 = state_66981__$1;
(statearr_66996_67010[(2)] = inst_66966);

(statearr_66996_67010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0 = (function (){
var statearr_66997 = [null,null,null,null,null,null,null,null];
(statearr_66997[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__);

(statearr_66997[(1)] = (1));

return statearr_66997;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1 = (function (state_66981){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_66981);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66998){var ex__2687__auto__ = e66998;
var statearr_66999_67011 = state_66981;
(statearr_66999_67011[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_66981[(4)]))){
var statearr_67000_67012 = state_66981;
(statearr_67000_67012[(1)] = cljs.core.first.call(null,(state_66981[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67013 = state_66981;
state_66981 = G__67013;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__ = function(state_66981){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1.call(this,state_66981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67001 = f__2707__auto__.call(null);
(statearr_67001[(6)] = c__2706__auto__);

return statearr_67001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67038){
var state_val_67039 = (state_67038[(1)]);
if((state_val_67039 === (1))){
var state_67038__$1 = state_67038;
var statearr_67040_67055 = state_67038__$1;
(statearr_67040_67055[(2)] = null);

(statearr_67040_67055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67039 === (2))){
var _ = (function (){var statearr_67041 = state_67038;
(statearr_67041[(4)] = cljs.core.cons.call(null,(5),(state_67038[(4)])));

return statearr_67041;
})();
var inst_67020 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_67038__$1 = state_67038;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67038__$1,(6),inst_67020);
} else {
if((state_val_67039 === (3))){
var inst_67036 = (state_67038[(2)]);
var state_67038__$1 = state_67038;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67038__$1,inst_67036);
} else {
if((state_val_67039 === (4))){
var inst_67014 = (state_67038[(2)]);
var state_67038__$1 = state_67038;
var statearr_67043_67056 = state_67038__$1;
(statearr_67043_67056[(2)] = inst_67014);

(statearr_67043_67056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67039 === (5))){
var _ = (function (){var statearr_67044 = state_67038;
(statearr_67044[(4)] = cljs.core.rest.call(null,(state_67038[(4)])));

return statearr_67044;
})();
var state_67038__$1 = state_67038;
var ex67042 = (state_67038__$1[(2)]);
var statearr_67045_67057 = state_67038__$1;
(statearr_67045_67057[(5)] = ex67042);


if((ex67042 instanceof Error)){
var statearr_67046_67058 = state_67038__$1;
(statearr_67046_67058[(1)] = (4));

(statearr_67046_67058[(5)] = null);

} else {
throw ex67042;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67039 === (6))){
var inst_67022 = (state_67038[(2)]);
var inst_67023 = fluree.db.util.async.throw_err.call(null,inst_67022);
var inst_67024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67025 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67027 = [compare_val,new_val];
var inst_67028 = (new cljs.core.PersistentVector(null,2,(5),inst_67026,inst_67027,null));
var inst_67029 = ["",inst_67028,inst_67023];
var inst_67030 = cljs.core.PersistentHashMap.fromArrays(inst_67025,inst_67029);
var inst_67031 = [inst_67030,(10)];
var inst_67032 = (new cljs.core.PersistentVector(null,2,(5),inst_67024,inst_67031,null));
var inst_67033 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67032);
var _ = (function (){var statearr_67047 = state_67038;
(statearr_67047[(4)] = cljs.core.rest.call(null,(state_67038[(4)])));

return statearr_67047;
})();
var state_67038__$1 = (function (){var statearr_67048 = state_67038;
(statearr_67048[(7)] = inst_67033);

return statearr_67048;
})();
var statearr_67049_67059 = state_67038__$1;
(statearr_67049_67059[(2)] = inst_67023);

(statearr_67049_67059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0 = (function (){
var statearr_67050 = [null,null,null,null,null,null,null,null];
(statearr_67050[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__);

(statearr_67050[(1)] = (1));

return statearr_67050;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1 = (function (state_67038){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_67038);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67051){var ex__2687__auto__ = e67051;
var statearr_67052_67060 = state_67038;
(statearr_67052_67060[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_67038[(4)]))){
var statearr_67053_67061 = state_67038;
(statearr_67053_67061[(1)] = cljs.core.first.call(null,(state_67038[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67062 = state_67038;
state_67038 = G__67062;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__ = function(state_67038){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1.call(this,state_67038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67054 = f__2707__auto__.call(null);
(statearr_67054[(6)] = c__2706__auto__);

return statearr_67054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
