// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36604 = arguments.length;
var i__5770__auto___36605 = (0);
while(true){
if((i__5770__auto___36605 < len__5769__auto___36604)){
args__5775__auto__.push((arguments[i__5770__auto___36605]));

var G__36606 = (i__5770__auto___36605 + (1));
i__5770__auto___36605 = G__36606;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq36601){
var G__36602 = cljs.core.first.call(null,seq36601);
var seq36601__$1 = cljs.core.next.call(null,seq36601);
var G__36603 = cljs.core.first.call(null,seq36601__$1);
var seq36601__$2 = cljs.core.next.call(null,seq36601__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36602,G__36603,seq36601__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e36607){var e = e36607;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e36608){var e = e36608;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e36609){var e = e36609;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e36610){var e = e36610;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e36611){var e = e36611;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36614 = arguments.length;
var i__5770__auto___36615 = (0);
while(true){
if((i__5770__auto___36615 < len__5769__auto___36614)){
args__5775__auto__.push((arguments[i__5770__auto___36615]));

var G__36616 = (i__5770__auto___36615 + (1));
i__5770__auto___36615 = G__36616;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e36613){var e = e36613;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq36612){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36612));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36619 = arguments.length;
var i__5770__auto___36620 = (0);
while(true){
if((i__5770__auto___36620 < len__5769__auto___36619)){
args__5775__auto__.push((arguments[i__5770__auto___36620]));

var G__36621 = (i__5770__auto___36620 + (1));
i__5770__auto___36620 = G__36621;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e36618){var e = e36618;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq36617){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36617));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e36622){var e = e36622;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36625 = arguments.length;
var i__5770__auto___36626 = (0);
while(true){
if((i__5770__auto___36626 < len__5769__auto___36625)){
args__5775__auto__.push((arguments[i__5770__auto___36626]));

var G__36627 = (i__5770__auto___36626 + (1));
i__5770__auto___36626 = G__36627;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e36624){var e = e36624;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq36623){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36623));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36630 = arguments.length;
var i__5770__auto___36631 = (0);
while(true){
if((i__5770__auto___36631 < len__5769__auto___36630)){
args__5775__auto__.push((arguments[i__5770__auto___36631]));

var G__36632 = (i__5770__auto___36631 + (1));
i__5770__auto___36631 = G__36632;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e36629){var e = e36629;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq36628){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36628));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e36633){var e = e36633;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e36634){var e = e36634;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36637 = arguments.length;
var i__5770__auto___36638 = (0);
while(true){
if((i__5770__auto___36638 < len__5769__auto___36637)){
args__5775__auto__.push((arguments[i__5770__auto___36638]));

var G__36639 = (i__5770__auto___36638 + (1));
i__5770__auto___36638 = G__36639;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e36636){var e = e36636;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq36635){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36635));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36642 = arguments.length;
var i__5770__auto___36643 = (0);
while(true){
if((i__5770__auto___36643 < len__5769__auto___36642)){
args__5775__auto__.push((arguments[i__5770__auto___36643]));

var G__36644 = (i__5770__auto___36643 + (1));
i__5770__auto___36643 = G__36644;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e36641){var e = e36641;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq36640){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36640));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36647 = arguments.length;
var i__5770__auto___36648 = (0);
while(true){
if((i__5770__auto___36648 < len__5769__auto___36647)){
args__5775__auto__.push((arguments[i__5770__auto___36648]));

var G__36649 = (i__5770__auto___36648 + (1));
i__5770__auto___36648 = G__36649;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e36646){var e = e36646;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq36645){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36645));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36652 = arguments.length;
var i__5770__auto___36653 = (0);
while(true){
if((i__5770__auto___36653 < len__5769__auto___36652)){
args__5775__auto__.push((arguments[i__5770__auto___36653]));

var G__36654 = (i__5770__auto___36653 + (1));
i__5770__auto___36653 = G__36654;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e36651){var e = e36651;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq36650){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36650));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36657 = arguments.length;
var i__5770__auto___36658 = (0);
while(true){
if((i__5770__auto___36658 < len__5769__auto___36657)){
args__5775__auto__.push((arguments[i__5770__auto___36658]));

var G__36659 = (i__5770__auto___36658 + (1));
i__5770__auto___36658 = G__36659;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e36656){var e = e36656;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq36655){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36655));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36662 = arguments.length;
var i__5770__auto___36663 = (0);
while(true){
if((i__5770__auto___36663 < len__5769__auto___36662)){
args__5775__auto__.push((arguments[i__5770__auto___36663]));

var G__36664 = (i__5770__auto___36663 + (1));
i__5770__auto___36663 = G__36664;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e36661){var e = e36661;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq36660){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36660));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36667 = arguments.length;
var i__5770__auto___36668 = (0);
while(true){
if((i__5770__auto___36668 < len__5769__auto___36667)){
args__5775__auto__.push((arguments[i__5770__auto___36668]));

var G__36669 = (i__5770__auto___36668 + (1));
i__5770__auto___36668 = G__36669;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e36666){var e = e36666;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq36665){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36665));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__36671 = arguments.length;
switch (G__36671) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_36699){
var state_val_36700 = (state_36699[(1)]);
if((state_val_36700 === (7))){
var inst_36684 = (state_36699[(7)]);
var inst_36687 = fluree.db.dbfunctions.internal.function_error.call(null,inst_36684,"query",query_map);
var state_36699__$1 = state_36699;
var statearr_36701_36787 = state_36699__$1;
(statearr_36701_36787[(2)] = inst_36687);

(statearr_36701_36787[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36700 === (1))){
var state_36699__$1 = state_36699;
var statearr_36702_36788 = state_36699__$1;
(statearr_36702_36788[(2)] = null);

(statearr_36702_36788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36700 === (4))){
var inst_36672 = (state_36699[(2)]);
var state_36699__$1 = state_36699;
var statearr_36703_36789 = state_36699__$1;
(statearr_36703_36789[(2)] = inst_36672);

(statearr_36703_36789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36700 === (6))){
var inst_36684 = (state_36699[(7)]);
var inst_36684__$1 = (state_36699[(2)]);
var inst_36685 = fluree.db.util.core.exception_QMARK_.call(null,inst_36684__$1);
var state_36699__$1 = (function (){var statearr_36704 = state_36699;
(statearr_36704[(7)] = inst_36684__$1);

return statearr_36704;
})();
if(inst_36685){
var statearr_36705_36790 = state_36699__$1;
(statearr_36705_36790[(1)] = (7));

} else {
var statearr_36706_36791 = state_36699__$1;
(statearr_36706_36791[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36700 === (3))){
var inst_36697 = (state_36699[(2)]);
var state_36699__$1 = state_36699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36699__$1,inst_36697);
} else {
if((state_val_36700 === (2))){
var inst_36678 = (state_36699[(8)]);
var _ = (function (){var statearr_36708 = state_36699;
(statearr_36708[(4)] = cljs.core.cons.call(null,(5),(state_36699[(4)])));

return statearr_36708;
})();
var inst_36678__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_36679 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_36680 = cljs.core.assoc.call(null,inst_36679,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_36678__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_36681 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_36680);
var inst_36682 = fluree.db.query.fql.query.call(null,db,inst_36681);
var state_36699__$1 = (function (){var statearr_36709 = state_36699;
(statearr_36709[(8)] = inst_36678__$1);

return statearr_36709;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36699__$1,(6),inst_36682);
} else {
if((state_val_36700 === (9))){
var inst_36694 = (state_36699[(2)]);
var _ = (function (){var statearr_36710 = state_36699;
(statearr_36710[(4)] = cljs.core.rest.call(null,(state_36699[(4)])));

return statearr_36710;
})();
var state_36699__$1 = state_36699;
var statearr_36711_36792 = state_36699__$1;
(statearr_36711_36792[(2)] = inst_36694);

(statearr_36711_36792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36700 === (5))){
var _ = (function (){var statearr_36712 = state_36699;
(statearr_36712[(4)] = cljs.core.rest.call(null,(state_36699[(4)])));

return statearr_36712;
})();
var state_36699__$1 = state_36699;
var ex36707 = (state_36699__$1[(2)]);
var statearr_36713_36793 = state_36699__$1;
(statearr_36713_36793[(5)] = ex36707);


if((ex36707 instanceof Error)){
var statearr_36714_36794 = state_36699__$1;
(statearr_36714_36794[(1)] = (4));

(statearr_36714_36794[(5)] = null);

} else {
throw ex36707;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36700 === (8))){
var inst_36684 = (state_36699[(7)]);
var inst_36678 = (state_36699[(8)]);
var inst_36689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36690 = cljs.core.deref.call(null,inst_36678);
var inst_36691 = [inst_36684,inst_36690];
var inst_36692 = (new cljs.core.PersistentVector(null,2,(5),inst_36689,inst_36691,null));
var state_36699__$1 = state_36699;
var statearr_36715_36795 = state_36699__$1;
(statearr_36715_36795[(2)] = inst_36692);

(statearr_36715_36795[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_36716 = [null,null,null,null,null,null,null,null,null];
(statearr_36716[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_36716[(1)] = (1));

return statearr_36716;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_36699){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_36699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e36717){var ex__2687__auto__ = e36717;
var statearr_36718_36796 = state_36699;
(statearr_36718_36796[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_36699[(4)]))){
var statearr_36719_36797 = state_36699;
(statearr_36719_36797[(1)] = cljs.core.first.call(null,(state_36699[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36798 = state_36699;
state_36699 = G__36798;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_36699){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_36699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_36720 = f__2707__auto__.call(null);
(statearr_36720[(6)] = c__2706__auto__);

return statearr_36720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_36765){
var state_val_36766 = (state_36765[(1)]);
if((state_val_36766 === (7))){
var inst_36751 = (state_36765[(2)]);
var inst_36752 = fluree.db.query.fql.query.call(null,db,inst_36751);
var state_36765__$1 = state_36765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36765__$1,(8),inst_36752);
} else {
if((state_val_36766 === (1))){
var inst_36721 = typeof select === 'string';
var state_36765__$1 = state_36765;
if(cljs.core.truth_(inst_36721)){
var statearr_36767_36799 = state_36765__$1;
(statearr_36767_36799[(1)] = (2));

} else {
var statearr_36768_36800 = state_36765__$1;
(statearr_36768_36800[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36766 === (4))){
var inst_36727 = (state_36765[(7)]);
var inst_36734 = (state_36765[(8)]);
var inst_36726 = (state_36765[(2)]);
var inst_36727__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_36728 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_36729 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_36730 = [inst_36727__$1,(100000)];
var inst_36731 = cljs.core.PersistentHashMap.fromArrays(inst_36729,inst_36730);
var inst_36732 = [inst_36726,from,where,block,limit,inst_36731];
var inst_36733 = cljs.core.PersistentHashMap.fromArrays(inst_36728,inst_36732);
var inst_36734__$1 = fluree.db.util.core.without_nils.call(null,inst_36733);
var inst_36735 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_36734__$1);
var inst_36736 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_36734__$1);
var inst_36737 = cljs.core.first.call(null,inst_36736);
var inst_36738 = fluree.db.dbfunctions.internal.str.call(null,inst_36737);
var inst_36739 = cljs.core._EQ_.call(null,"[",inst_36738);
var inst_36740 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_36734__$1);
var inst_36741 = cljs.core.last.call(null,inst_36740);
var inst_36742 = fluree.db.dbfunctions.internal.str.call(null,inst_36741);
var inst_36743 = cljs.core._EQ_.call(null,"]",inst_36742);
var inst_36744 = fluree.db.dbfunctions.internal.and.call(null,inst_36735,inst_36739,inst_36743);
var state_36765__$1 = (function (){var statearr_36769 = state_36765;
(statearr_36769[(7)] = inst_36727__$1);

(statearr_36769[(8)] = inst_36734__$1);

return statearr_36769;
})();
if(cljs.core.truth_(inst_36744)){
var statearr_36770_36801 = state_36765__$1;
(statearr_36770_36801[(1)] = (5));

} else {
var statearr_36771_36802 = state_36765__$1;
(statearr_36771_36802[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36766 === (6))){
var inst_36734 = (state_36765[(8)]);
var state_36765__$1 = state_36765;
var statearr_36772_36803 = state_36765__$1;
(statearr_36772_36803[(2)] = inst_36734);

(statearr_36772_36803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36766 === (3))){
var state_36765__$1 = state_36765;
var statearr_36773_36804 = state_36765__$1;
(statearr_36773_36804[(2)] = select);

(statearr_36773_36804[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36766 === (2))){
var inst_36723 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_36765__$1 = state_36765;
var statearr_36774_36805 = state_36765__$1;
(statearr_36774_36805[(2)] = inst_36723);

(statearr_36774_36805[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36766 === (11))){
var inst_36763 = (state_36765[(2)]);
var state_36765__$1 = state_36765;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36765__$1,inst_36763);
} else {
if((state_val_36766 === (9))){
var inst_36754 = (state_36765[(9)]);
var state_36765__$1 = state_36765;
var statearr_36775_36806 = state_36765__$1;
(statearr_36775_36806[(2)] = inst_36754);

(statearr_36775_36806[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36766 === (5))){
var inst_36734 = (state_36765[(8)]);
var inst_36746 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_36734);
var inst_36747 = cljs.reader.read_string.call(null,inst_36746);
var inst_36748 = cljs.core.assoc.call(null,inst_36734,new cljs.core.Keyword(null,"where","where",-2044795965),inst_36747);
var state_36765__$1 = state_36765;
var statearr_36776_36807 = state_36765__$1;
(statearr_36776_36807[(2)] = inst_36748);

(statearr_36776_36807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36766 === (10))){
var inst_36727 = (state_36765[(7)]);
var inst_36754 = (state_36765[(9)]);
var inst_36758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36759 = cljs.core.deref.call(null,inst_36727);
var inst_36760 = [inst_36754,inst_36759];
var inst_36761 = (new cljs.core.PersistentVector(null,2,(5),inst_36758,inst_36760,null));
var state_36765__$1 = state_36765;
var statearr_36777_36808 = state_36765__$1;
(statearr_36777_36808[(2)] = inst_36761);

(statearr_36777_36808[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36766 === (8))){
var inst_36754 = (state_36765[(9)]);
var inst_36754__$1 = (state_36765[(2)]);
var inst_36755 = fluree.db.util.core.exception_QMARK_.call(null,inst_36754__$1);
var state_36765__$1 = (function (){var statearr_36778 = state_36765;
(statearr_36778[(9)] = inst_36754__$1);

return statearr_36778;
})();
if(inst_36755){
var statearr_36779_36809 = state_36765__$1;
(statearr_36779_36809[(1)] = (9));

} else {
var statearr_36780_36810 = state_36765__$1;
(statearr_36780_36810[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_36781 = [null,null,null,null,null,null,null,null,null,null];
(statearr_36781[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_36781[(1)] = (1));

return statearr_36781;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_36765){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_36765);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e36782){var ex__2687__auto__ = e36782;
var statearr_36783_36811 = state_36765;
(statearr_36783_36811[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_36765[(4)]))){
var statearr_36784_36812 = state_36765;
(statearr_36784_36812[(1)] = cljs.core.first.call(null,(state_36765[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36813 = state_36765;
state_36765 = G__36813;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_36765){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_36765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_36785 = f__2707__auto__.call(null);
(statearr_36785[(6)] = c__2706__auto__);

return statearr_36785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__36817 = path;
var vec__36818 = G__36817;
var seq__36819 = cljs.core.seq.call(null,vec__36818);
var first__36820 = cljs.core.first.call(null,seq__36819);
var seq__36819__$1 = cljs.core.next.call(null,seq__36819);
var var$ = first__36820;
var r = seq__36819__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__36817__$1 = G__36817;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__36824 = G__36817__$1;
var seq__36825 = cljs.core.seq.call(null,vec__36824);
var first__36826 = cljs.core.first.call(null,seq__36825);
var seq__36825__$1 = cljs.core.next.call(null,seq__36825);
var var$__$1 = first__36826;
var r__$1 = seq__36825__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__36827 = r__$1;
var G__36828 = n__$2;
var G__36829 = next_clauses;
G__36817__$1 = G__36827;
n__$1 = G__36828;
where_clauses__$1 = G__36829;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__36830 = r__$1;
var G__36831 = next_n;
var G__36832 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__36817__$1 = G__36830;
n__$1 = G__36831;
where_clauses__$1 = G__36832;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_36869){
var state_val_36870 = (state_36869[(1)]);
if((state_val_36870 === (7))){
var inst_36842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36843 = [path];
var inst_36844 = (new cljs.core.PersistentVector(null,1,(5),inst_36842,inst_36843,null));
var state_36869__$1 = state_36869;
var statearr_36871_36899 = state_36869__$1;
(statearr_36871_36899[(2)] = inst_36844);

(statearr_36871_36899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36870 === (1))){
var state_36869__$1 = state_36869;
var statearr_36872_36900 = state_36869__$1;
(statearr_36872_36900[(2)] = null);

(statearr_36872_36900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36870 === (4))){
var inst_36833 = (state_36869[(2)]);
var state_36869__$1 = state_36869;
var statearr_36873_36901 = state_36869__$1;
(statearr_36873_36901[(2)] = inst_36833);

(statearr_36873_36901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36870 === (13))){
var inst_36860 = (state_36869[(2)]);
var inst_36861 = fluree.db.util.async.throw_err.call(null,inst_36860);
var _ = (function (){var statearr_36874 = state_36869;
(statearr_36874[(4)] = cljs.core.rest.call(null,(state_36869[(4)])));

return statearr_36874;
})();
var state_36869__$1 = state_36869;
var statearr_36875_36902 = state_36869__$1;
(statearr_36875_36902[(2)] = inst_36861);

(statearr_36875_36902[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36870 === (6))){
var state_36869__$1 = state_36869;
var statearr_36877_36903 = state_36869__$1;
(statearr_36877_36903[(2)] = path);

(statearr_36877_36903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36870 === (3))){
var inst_36867 = (state_36869[(2)]);
var state_36869__$1 = state_36869;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36869__$1,inst_36867);
} else {
if((state_val_36870 === (12))){
var _ = (function (){var statearr_36878 = state_36869;
(statearr_36878[(4)] = cljs.core.rest.call(null,(state_36869[(4)])));

return statearr_36878;
})();
var state_36869__$1 = state_36869;
var ex36876 = (state_36869__$1[(2)]);
var statearr_36879_36904 = state_36869__$1;
(statearr_36879_36904[(5)] = ex36876);


var statearr_36880_36905 = state_36869__$1;
(statearr_36880_36905[(1)] = (11));

(statearr_36880_36905[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36870 === (2))){
var _ = (function (){var statearr_36881 = state_36869;
(statearr_36881[(4)] = cljs.core.cons.call(null,(5),(state_36869[(4)])));

return statearr_36881;
})();
var inst_36839 = cljs.core.vector_QMARK_.call(null,path);
var state_36869__$1 = state_36869;
if(inst_36839){
var statearr_36882_36906 = state_36869__$1;
(statearr_36882_36906[(1)] = (6));

} else {
var statearr_36883_36907 = state_36869__$1;
(statearr_36883_36907[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36870 === (11))){
var inst_36846 = (state_36869[(7)]);
var inst_36851 = (state_36869[(2)]);
var inst_36852 = fluree.db.dbfunctions.internal.function_error.call(null,inst_36851,"relationship?",startSubject,inst_36846,endSubject);
var state_36869__$1 = state_36869;
var statearr_36885_36908 = state_36869__$1;
(statearr_36885_36908[(2)] = inst_36852);

(statearr_36885_36908[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36870 === (9))){
var inst_36850 = (state_36869[(8)]);
var _ = (function (){var statearr_36886 = state_36869;
(statearr_36886[(4)] = cljs.core.cons.call(null,(12),(state_36869[(4)])));

return statearr_36886;
})();
var inst_36858 = fluree.db.dbfunctions.internal.query.call(null,db,inst_36850);
var state_36869__$1 = state_36869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36869__$1,(13),inst_36858);
} else {
if((state_val_36870 === (5))){
var _ = (function (){var statearr_36887 = state_36869;
(statearr_36887[(4)] = cljs.core.rest.call(null,(state_36869[(4)])));

return statearr_36887;
})();
var state_36869__$1 = state_36869;
var ex36884 = (state_36869__$1[(2)]);
var statearr_36888_36909 = state_36869__$1;
(statearr_36888_36909[(5)] = ex36884);


if((ex36884 instanceof Error)){
var statearr_36889_36910 = state_36869__$1;
(statearr_36889_36910[(1)] = (4));

(statearr_36889_36910[(5)] = null);

} else {
throw ex36884;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36870 === (10))){
var inst_36864 = (state_36869[(2)]);
var _ = (function (){var statearr_36890 = state_36869;
(statearr_36890[(4)] = cljs.core.rest.call(null,(state_36869[(4)])));

return statearr_36890;
})();
var state_36869__$1 = state_36869;
var statearr_36891_36911 = state_36869__$1;
(statearr_36891_36911[(2)] = inst_36864);

(statearr_36891_36911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36870 === (8))){
var inst_36846 = (state_36869[(7)]);
var inst_36846__$1 = (state_36869[(2)]);
var inst_36847 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_36846__$1,endSubject);
var inst_36848 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_36849 = ["?var1",inst_36847];
var inst_36850 = cljs.core.PersistentHashMap.fromArrays(inst_36848,inst_36849);
var state_36869__$1 = (function (){var statearr_36892 = state_36869;
(statearr_36892[(7)] = inst_36846__$1);

(statearr_36892[(8)] = inst_36850);

return statearr_36892;
})();
var statearr_36893_36912 = state_36869__$1;
(statearr_36893_36912[(2)] = null);

(statearr_36893_36912[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_36894 = [null,null,null,null,null,null,null,null,null];
(statearr_36894[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__);

(statearr_36894[(1)] = (1));

return statearr_36894;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1 = (function (state_36869){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_36869);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e36895){var ex__2687__auto__ = e36895;
var statearr_36896_36913 = state_36869;
(statearr_36896_36913[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_36869[(4)]))){
var statearr_36897_36914 = state_36869;
(statearr_36897_36914[(1)] = cljs.core.first.call(null,(state_36869[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36915 = state_36869;
state_36869 = G__36915;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__ = function(state_36869){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1.call(this,state_36869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_36898 = f__2707__auto__.call(null);
(statearr_36898[(6)] = c__2706__auto__);

return statearr_36898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e36916){var e = e36916;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e36917){var e = e36917;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e36918){var e = e36918;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_36972){
var state_val_36973 = (state_36972[(1)]);
if((state_val_36973 === (7))){
var state_36972__$1 = state_36972;
var statearr_36974_37012 = state_36972__$1;
(statearr_36974_37012[(2)] = pred);

(statearr_36974_37012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (20))){
var inst_36951 = (state_36972[(7)]);
var inst_36955 = (state_36972[(8)]);
var inst_36959 = cljs.core.mapv.call(null,inst_36955,inst_36951);
var state_36972__$1 = state_36972;
var statearr_36975_37013 = state_36972__$1;
(statearr_36975_37013[(2)] = inst_36959);

(statearr_36975_37013[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (1))){
var state_36972__$1 = state_36972;
var statearr_36976_37014 = state_36972__$1;
(statearr_36976_37014[(2)] = null);

(statearr_36976_37014[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (4))){
var inst_36919 = (state_36972[(2)]);
var state_36972__$1 = state_36972;
var statearr_36977_37015 = state_36972__$1;
(statearr_36977_37015[(2)] = inst_36919);

(statearr_36977_37015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (15))){
var state_36972__$1 = state_36972;
var statearr_36978_37016 = state_36972__$1;
(statearr_36978_37016[(2)] = fluree.db.flake.o);

(statearr_36978_37016[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (21))){
var inst_36951 = (state_36972[(7)]);
var inst_36955 = (state_36972[(8)]);
var inst_36961 = cljs.core.first.call(null,inst_36951);
var inst_36962 = inst_36955.call(null,inst_36961);
var state_36972__$1 = state_36972;
var statearr_36979_37017 = state_36972__$1;
(statearr_36979_37017[(2)] = inst_36962);

(statearr_36979_37017[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (13))){
var inst_36948 = (state_36972[(2)]);
var inst_36949 = fluree.db.util.async.throw_err.call(null,inst_36948);
var state_36972__$1 = state_36972;
var statearr_36980_37018 = state_36972__$1;
(statearr_36980_37018[(2)] = inst_36949);

(statearr_36980_37018[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (22))){
var inst_36964 = (state_36972[(2)]);
var state_36972__$1 = state_36972;
var statearr_36981_37019 = state_36972__$1;
(statearr_36981_37019[(2)] = inst_36964);

(statearr_36981_37019[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (6))){
var inst_36929 = clojure.string.replace.call(null,pred,"/_","/");
var state_36972__$1 = state_36972;
var statearr_36982_37020 = state_36972__$1;
(statearr_36982_37020[(2)] = inst_36929);

(statearr_36982_37020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (17))){
var inst_36933 = (state_36972[(9)]);
var state_36972__$1 = state_36972;
if(cljs.core.truth_(inst_36933)){
var statearr_36983_37021 = state_36972__$1;
(statearr_36983_37021[(1)] = (20));

} else {
var statearr_36984_37022 = state_36972__$1;
(statearr_36984_37022[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (3))){
var inst_36970 = (state_36972[(2)]);
var state_36972__$1 = state_36972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36972__$1,inst_36970);
} else {
if((state_val_36973 === (12))){
var inst_36940 = (state_36972[(2)]);
var inst_36941 = fluree.db.util.async.throw_err.call(null,inst_36940);
var state_36972__$1 = state_36972;
var statearr_36985_37023 = state_36972__$1;
(statearr_36985_37023[(2)] = inst_36941);

(statearr_36985_37023[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (2))){
var inst_36927 = (state_36972[(10)]);
var _ = (function (){var statearr_36986 = state_36972;
(statearr_36986[(4)] = cljs.core.cons.call(null,(5),(state_36972[(4)])));

return statearr_36986;
})();
var inst_36925 = typeof pred === 'string';
var inst_36926 = cljs.core.re_matches.call(null,/.+\/_.+/,pred);
var inst_36927__$1 = fluree.db.dbfunctions.internal.and.call(null,inst_36925,inst_36926);
var state_36972__$1 = (function (){var statearr_36987 = state_36972;
(statearr_36987[(10)] = inst_36927__$1);

return statearr_36987;
})();
if(cljs.core.truth_(inst_36927__$1)){
var statearr_36988_37024 = state_36972__$1;
(statearr_36988_37024[(1)] = (6));

} else {
var statearr_36989_37025 = state_36972__$1;
(statearr_36989_37025[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (19))){
var inst_36967 = (state_36972[(2)]);
var _ = (function (){var statearr_36990 = state_36972;
(statearr_36990[(4)] = cljs.core.rest.call(null,(state_36972[(4)])));

return statearr_36990;
})();
var state_36972__$1 = state_36972;
var statearr_36991_37026 = state_36972__$1;
(statearr_36991_37026[(2)] = inst_36967);

(statearr_36991_37026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (11))){
var inst_36927 = (state_36972[(10)]);
var inst_36951 = (state_36972[(2)]);
var state_36972__$1 = (function (){var statearr_36993 = state_36972;
(statearr_36993[(7)] = inst_36951);

return statearr_36993;
})();
if(cljs.core.truth_(inst_36927)){
var statearr_36994_37027 = state_36972__$1;
(statearr_36994_37027[(1)] = (14));

} else {
var statearr_36995_37028 = state_36972__$1;
(statearr_36995_37028[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (9))){
var inst_36932 = (state_36972[(11)]);
var inst_36935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36936 = [sid,inst_36932];
var inst_36937 = (new cljs.core.PersistentVector(null,2,(5),inst_36935,inst_36936,null));
var inst_36938 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_36937);
var state_36972__$1 = state_36972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36972__$1,(12),inst_36938);
} else {
if((state_val_36973 === (5))){
var _ = (function (){var statearr_36996 = state_36972;
(statearr_36996[(4)] = cljs.core.rest.call(null,(state_36972[(4)])));

return statearr_36996;
})();
var state_36972__$1 = state_36972;
var ex36992 = (state_36972__$1[(2)]);
var statearr_36997_37029 = state_36972__$1;
(statearr_36997_37029[(5)] = ex36992);


if((ex36992 instanceof Error)){
var statearr_36998_37030 = state_36972__$1;
(statearr_36998_37030[(1)] = (4));

(statearr_36998_37030[(5)] = null);

} else {
throw ex36992;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (14))){
var state_36972__$1 = state_36972;
var statearr_36999_37031 = state_36972__$1;
(statearr_36999_37031[(2)] = fluree.db.flake.s);

(statearr_36999_37031[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (16))){
var inst_36951 = (state_36972[(7)]);
var inst_36955 = (state_36972[(2)]);
var inst_36956 = cljs.core.seq.call(null,inst_36951);
var state_36972__$1 = (function (){var statearr_37000 = state_36972;
(statearr_37000[(8)] = inst_36955);

return statearr_37000;
})();
if(inst_36956){
var statearr_37001_37032 = state_36972__$1;
(statearr_37001_37032[(1)] = (17));

} else {
var statearr_37002_37033 = state_36972__$1;
(statearr_37002_37033[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (10))){
var inst_36932 = (state_36972[(11)]);
var inst_36943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36944 = [sid,inst_36932];
var inst_36945 = (new cljs.core.PersistentVector(null,2,(5),inst_36943,inst_36944,null));
var inst_36946 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_36945);
var state_36972__$1 = state_36972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36972__$1,(13),inst_36946);
} else {
if((state_val_36973 === (18))){
var state_36972__$1 = state_36972;
var statearr_37003_37034 = state_36972__$1;
(statearr_37003_37034[(2)] = null);

(statearr_37003_37034[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36973 === (8))){
var inst_36932 = (state_36972[(11)]);
var inst_36927 = (state_36972[(10)]);
var inst_36932__$1 = (state_36972[(2)]);
var inst_36933 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_36932__$1);
var state_36972__$1 = (function (){var statearr_37004 = state_36972;
(statearr_37004[(11)] = inst_36932__$1);

(statearr_37004[(9)] = inst_36933);

return statearr_37004;
})();
if(cljs.core.truth_(inst_36927)){
var statearr_37005_37035 = state_36972__$1;
(statearr_37005_37035[(1)] = (9));

} else {
var statearr_37006_37036 = state_36972__$1;
(statearr_37006_37036[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0 = (function (){
var statearr_37007 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37007[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__);

(statearr_37007[(1)] = (1));

return statearr_37007;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1 = (function (state_36972){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_36972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e37008){var ex__2687__auto__ = e37008;
var statearr_37009_37037 = state_36972;
(statearr_37009_37037[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_36972[(4)]))){
var statearr_37010_37038 = state_36972;
(statearr_37010_37038[(1)] = cljs.core.first.call(null,(state_36972[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37039 = state_36972;
state_36972 = G__37039;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__ = function(state_36972){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1.call(this,state_36972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_37011 = f__2707__auto__.call(null);
(statearr_37011[(6)] = c__2706__auto__);

return statearr_37011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e37040){var e = e37040;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37043 = arguments.length;
var i__5770__auto___37044 = (0);
while(true){
if((i__5770__auto___37044 < len__5769__auto___37043)){
args__5775__auto__.push((arguments[i__5770__auto___37044]));

var G__37045 = (i__5770__auto___37044 + (1));
i__5770__auto___37044 = G__37045;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e37042){var e = e37042;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq37041){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37041));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37048 = arguments.length;
var i__5770__auto___37049 = (0);
while(true){
if((i__5770__auto___37049 < len__5769__auto___37048)){
args__5775__auto__.push((arguments[i__5770__auto___37049]));

var G__37050 = (i__5770__auto___37049 + (1));
i__5770__auto___37049 = G__37050;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e37047){var e = e37047;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq37046){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37046));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37053 = arguments.length;
var i__5770__auto___37054 = (0);
while(true){
if((i__5770__auto___37054 < len__5769__auto___37053)){
args__5775__auto__.push((arguments[i__5770__auto___37054]));

var G__37055 = (i__5770__auto___37054 + (1));
i__5770__auto___37054 = G__37055;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e37052){var e = e37052;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq37051){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37051));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37058 = arguments.length;
var i__5770__auto___37059 = (0);
while(true){
if((i__5770__auto___37059 < len__5769__auto___37058)){
args__5775__auto__.push((arguments[i__5770__auto___37059]));

var G__37060 = (i__5770__auto___37059 + (1));
i__5770__auto___37059 = G__37060;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e37057){var e = e37057;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq37056){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37056));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e37061){var e = e37061;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e37062){var e = e37062;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e37063){var e = e37063;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e37064){var e = e37064;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e37065){var e = e37065;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__37071 = path;
var vec__37072 = G__37071;
var seq__37073 = cljs.core.seq.call(null,vec__37072);
var first__37074 = cljs.core.first.call(null,seq__37073);
var seq__37073__$1 = cljs.core.next.call(null,seq__37073);
var pred = first__37074;
var r = seq__37073__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__37071__$1 = G__37071;
var subjects__$1 = subjects;
while(true){
var vec__37078 = G__37071__$1;
var seq__37079 = cljs.core.seq.call(null,vec__37078);
var first__37080 = cljs.core.first.call(null,seq__37079);
var seq__37079__$1 = cljs.core.next.call(null,seq__37079);
var pred__$1 = first__37080;
var r__$1 = seq__37079__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__37071__$1,subjects__$1,vec__37078,seq__37079,first__37080,seq__37079__$1,pred__$1,r__$1,subjects__$2,G__37071,vec__37072,seq__37073,first__37074,seq__37073__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__37071__$1,subjects__$1,vec__37078,seq__37079,first__37080,seq__37079__$1,pred__$1,r__$1,subjects__$2,G__37071,vec__37072,seq__37073,first__37074,seq__37073__$1,pred,r,subjects){
return (function (p1__37066_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__37066_SHARP_,pred__$1);
});})(G__37071__$1,subjects__$1,vec__37078,seq__37079,first__37080,seq__37079__$1,pred__$1,r__$1,subjects__$2,G__37071,vec__37072,seq__37073,first__37074,seq__37073__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__37071__$1,subjects__$1,vec__37078,seq__37079,first__37080,seq__37079__$1,pred__$1,r__$1,subjects__$2,G__37071,vec__37072,seq__37073,first__37074,seq__37073__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__37081 = r__$1;
var G__37082 = next_subjects;
G__37071__$1 = G__37081;
subjects__$1 = G__37082;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e37067){var e = e37067;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.call(null,(1),fluree.db.dbfunctions.internal.count.call(null,path))){
return path;
} else {
var r_path = cljs.core.reverse.call(null,path);
return cljs.core.reduce.call(null,(function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first.call(null,r_path),cljs.core.rest.call(null,r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_37125){
var state_val_37126 = (state_37125[(1)]);
if((state_val_37126 === (7))){
var state_37125__$1 = state_37125;
var statearr_37127_37148 = state_37125__$1;
(statearr_37127_37148[(2)] = path);

(statearr_37127_37148[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (1))){
var state_37125__$1 = state_37125;
var statearr_37128_37149 = state_37125__$1;
(statearr_37128_37149[(2)] = null);

(statearr_37128_37149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (4))){
var inst_37083 = (state_37125[(2)]);
var inst_37084 = fluree.db.dbfunctions.internal.function_error.call(null,inst_37083,"follow-subject",sid,path);
var state_37125__$1 = state_37125;
var statearr_37129_37150 = state_37125__$1;
(statearr_37129_37150[(2)] = inst_37084);

(statearr_37129_37150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (6))){
var inst_37104 = (state_37125[(7)]);
var inst_37102 = (state_37125[(2)]);
var inst_37103 = fluree.db.util.async.throw_err.call(null,inst_37102);
var inst_37104__$1 = cljs.core.nth.call(null,inst_37103,(0),null);
var inst_37105 = cljs.core.nth.call(null,inst_37103,(1),null);
var inst_37106 = fluree.db.util.log.debug.call(null,"follow-subject results:",inst_37104__$1);
var inst_37107 = cljs.core.last.call(null,path);
var inst_37108 = cljs.core._EQ_.call(null,"_id",inst_37107);
var state_37125__$1 = (function (){var statearr_37130 = state_37125;
(statearr_37130[(7)] = inst_37104__$1);

(statearr_37130[(8)] = inst_37106);

(statearr_37130[(9)] = inst_37105);

return statearr_37130;
})();
if(inst_37108){
var statearr_37131_37151 = state_37125__$1;
(statearr_37131_37151[(1)] = (7));

} else {
var statearr_37132_37152 = state_37125__$1;
(statearr_37132_37152[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (3))){
var inst_37123 = (state_37125[(2)]);
var state_37125__$1 = state_37125;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37125__$1,inst_37123);
} else {
if((state_val_37126 === (2))){
var _ = (function (){var statearr_37134 = state_37125;
(statearr_37134[(4)] = cljs.core.cons.call(null,(5),(state_37125[(4)])));

return statearr_37134;
})();
var inst_37093 = fluree.db.dbfunctions.internal.select_from_path.call(null,path);
var inst_37094 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_37095 = cljs.core.PersistentHashMap.EMPTY;
var inst_37096 = [inst_37093,sid,inst_37095];
var inst_37097 = cljs.core.PersistentHashMap.fromArrays(inst_37094,inst_37096);
var inst_37098 = fluree.db.util.log.debug.call(null,"follow-subject query:",inst_37097);
var inst_37099 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37100 = fluree.db.dbfunctions.internal.query.call(null,inst_37099,inst_37097);
var state_37125__$1 = (function (){var statearr_37135 = state_37125;
(statearr_37135[(10)] = inst_37098);

return statearr_37135;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37125__$1,(6),inst_37100);
} else {
if((state_val_37126 === (9))){
var inst_37104 = (state_37125[(7)]);
var inst_37105 = (state_37125[(9)]);
var inst_37113 = (state_37125[(2)]);
var inst_37114 = fluree.db.dbfunctions.internal.get_all.call(null,inst_37104,inst_37113);
var inst_37115 = fluree.db.util.log.debug.call(null,"follow-subject res*:",inst_37114);
var inst_37116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37117 = fluree.db.dbfunctions.internal.count.call(null,path);
var inst_37118 = fluree.db.dbfunctions.internal._PLUS_.call(null,inst_37105,inst_37117,(9));
var inst_37119 = [inst_37114,inst_37118];
var inst_37120 = (new cljs.core.PersistentVector(null,2,(5),inst_37116,inst_37119,null));
var _ = (function (){var statearr_37136 = state_37125;
(statearr_37136[(4)] = cljs.core.rest.call(null,(state_37125[(4)])));

return statearr_37136;
})();
var state_37125__$1 = (function (){var statearr_37137 = state_37125;
(statearr_37137[(11)] = inst_37115);

return statearr_37137;
})();
var statearr_37138_37153 = state_37125__$1;
(statearr_37138_37153[(2)] = inst_37120);

(statearr_37138_37153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (5))){
var _ = (function (){var statearr_37139 = state_37125;
(statearr_37139[(4)] = cljs.core.rest.call(null,(state_37125[(4)])));

return statearr_37139;
})();
var state_37125__$1 = state_37125;
var ex37133 = (state_37125__$1[(2)]);
var statearr_37140_37154 = state_37125__$1;
(statearr_37140_37154[(5)] = ex37133);


var statearr_37141_37155 = state_37125__$1;
(statearr_37141_37155[(1)] = (4));

(statearr_37141_37155[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (8))){
var inst_37111 = cljs.core.conj.call(null,path,"_id");
var state_37125__$1 = state_37125;
var statearr_37142_37156 = state_37125__$1;
(statearr_37142_37156[(2)] = inst_37111);

(statearr_37142_37156[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0 = (function (){
var statearr_37143 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37143[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__);

(statearr_37143[(1)] = (1));

return statearr_37143;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1 = (function (state_37125){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_37125);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e37144){var ex__2687__auto__ = e37144;
var statearr_37145_37157 = state_37125;
(statearr_37145_37157[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_37125[(4)]))){
var statearr_37146_37158 = state_37125;
(statearr_37146_37158[(1)] = cljs.core.first.call(null,(state_37125[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37159 = state_37125;
state_37125 = G__37159;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__ = function(state_37125){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1.call(this,state_37125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_37147 = f__2707__auto__.call(null);
(statearr_37147[(6)] = c__2706__auto__);

return statearr_37147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e37160){var e = e37160;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_.call(null,key)){
return cljs.core.some.call(null,(function (p1__37161_SHARP_){
return fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__37161_SHARP_);
}),key);
} else {
return cljs.core.contains_QMARK_.call(null,coll,key);
}
}catch (e37162){var e = e37162;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37165 = arguments.length;
var i__5770__auto___37166 = (0);
while(true){
if((i__5770__auto___37166 < len__5769__auto___37165)){
args__5775__auto__.push((arguments[i__5770__auto___37166]));

var G__37167 = (i__5770__auto___37166 + (1));
i__5770__auto___37166 = G__37167;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e37164){var e = e37164;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq37163){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37163));
}));

/**
 * Returns the nth element in coll.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e37168){var e = e37168;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Returns the first element in coll.
 */
fluree.db.dbfunctions.internal.first = (function fluree$db$dbfunctions$internal$first(coll){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.vec.call(null,coll):coll);
return cljs.core.first.call(null,coll_SINGLEQUOTE_);
}catch (e37169){var e = e37169;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"first",coll);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37172 = arguments.length;
var i__5770__auto___37173 = (0);
while(true){
if((i__5770__auto___37173 < len__5769__auto___37172)){
args__5775__auto__.push((arguments[i__5770__auto___37173]));

var G__37174 = (i__5770__auto___37173 + (1));
i__5770__auto___37173 = G__37174;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e37171){var e = e37171;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq37170){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37170));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e37175){var e = e37175;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_37232){
var state_val_37233 = (state_37232[(1)]);
if((state_val_37233 === (7))){
var inst_37178 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
var statearr_37234_37268 = state_37232__$1;
(statearr_37234_37268[(2)] = inst_37178);

(statearr_37234_37268[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (1))){
var state_37232__$1 = state_37232;
var statearr_37235_37269 = state_37232__$1;
(statearr_37235_37269[(2)] = null);

(statearr_37235_37269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (4))){
var inst_37177 = (state_37232[(2)]);
var state_37232__$1 = (function (){var statearr_37236 = state_37232;
(statearr_37236[(7)] = inst_37177);

return statearr_37236;
})();
var statearr_37237_37270 = state_37232__$1;
(statearr_37237_37270[(2)] = null);

(statearr_37237_37270[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (15))){
var inst_37212 = (state_37232[(8)]);
var inst_37202 = (state_37232[(9)]);
var inst_37203 = (state_37232[(10)]);
var inst_37215 = (state_37232[(11)]);
var inst_37213 = (state_37232[(12)]);
var inst_37200 = (state_37232[(13)]);
var inst_37219 = (function (){var db = inst_37200;
var prevT = inst_37202;
var db_SINGLEQUOTE_ = inst_37203;
var prev_vals = inst_37212;
var fuel = inst_37213;
var G__37214 = inst_37215;
return (function (p1__37176_SHARP_){
var f = p1__37176_SHARP_;
return fluree.db.flake.o.call(null,f);
});
})();
var inst_37220 = inst_37219.call(null,inst_37215);
var state_37232__$1 = state_37232;
var statearr_37238_37271 = state_37232__$1;
(statearr_37238_37271[(2)] = inst_37220);

(statearr_37238_37271[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (13))){
var inst_37212 = (state_37232[(8)]);
var inst_37215 = (state_37232[(11)]);
var inst_37211 = (state_37232[(2)]);
var inst_37212__$1 = fluree.db.util.async.throw_err.call(null,inst_37211);
var inst_37213 = fluree.db.dbfunctions.internal.count.call(null,inst_37212__$1);
var inst_37215__$1 = cljs.core.first.call(null,inst_37212__$1);
var inst_37216 = (inst_37215__$1 == null);
var state_37232__$1 = (function (){var statearr_37239 = state_37232;
(statearr_37239[(8)] = inst_37212__$1);

(statearr_37239[(11)] = inst_37215__$1);

(statearr_37239[(12)] = inst_37213);

return statearr_37239;
})();
if(cljs.core.truth_(inst_37216)){
var statearr_37240_37272 = state_37232__$1;
(statearr_37240_37272[(1)] = (14));

} else {
var statearr_37241_37273 = state_37232__$1;
(statearr_37241_37273[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (6))){
var inst_37187 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
var statearr_37242_37274 = state_37232__$1;
(statearr_37242_37274[(2)] = inst_37187);

(statearr_37242_37274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (3))){
var inst_37230 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37232__$1,inst_37230);
} else {
if((state_val_37233 === (12))){
var inst_37227 = (state_37232[(2)]);
var _ = (function (){var statearr_37243 = state_37232;
(statearr_37243[(4)] = cljs.core.rest.call(null,(state_37232[(4)])));

return statearr_37243;
})();
var state_37232__$1 = state_37232;
var statearr_37244_37275 = state_37232__$1;
(statearr_37244_37275[(2)] = inst_37227);

(statearr_37244_37275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (2))){
var _ = (function (){var statearr_37246 = state_37232;
(statearr_37246[(4)] = cljs.core.cons.call(null,(9),(state_37232[(4)])));

return statearr_37246;
})();
var inst_37193 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37194 = typeof inst_37193 === 'string';
var state_37232__$1 = state_37232;
if(cljs.core.truth_(inst_37194)){
var statearr_37247_37276 = state_37232__$1;
(statearr_37247_37276[(1)] = (10));

} else {
var statearr_37248_37277 = state_37232__$1;
(statearr_37248_37277[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (11))){
var inst_37202 = (state_37232[(9)]);
var inst_37203 = (state_37232[(10)]);
var inst_37200 = (state_37232[(13)]);
var inst_37200__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37201 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_37200__$1);
var inst_37202__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_37201);
var inst_37203__$1 = cljs.core.assoc.call(null,inst_37200__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_37202__$1);
var inst_37204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37205 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37206 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37207 = [inst_37205,inst_37206];
var inst_37208 = (new cljs.core.PersistentVector(null,2,(5),inst_37204,inst_37207,null));
var inst_37209 = fluree.db.dbproto._search.call(null,inst_37203__$1,inst_37208);
var state_37232__$1 = (function (){var statearr_37249 = state_37232;
(statearr_37249[(9)] = inst_37202__$1);

(statearr_37249[(10)] = inst_37203__$1);

(statearr_37249[(13)] = inst_37200__$1);

return statearr_37249;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37232__$1,(13),inst_37209);
} else {
if((state_val_37233 === (9))){
var _ = (function (){var statearr_37250 = state_37232;
(statearr_37250[(4)] = cljs.core.rest.call(null,(state_37232[(4)])));

return statearr_37250;
})();
var state_37232__$1 = state_37232;
var ex37245 = (state_37232__$1[(2)]);
var statearr_37251_37278 = state_37232__$1;
(statearr_37251_37278[(5)] = ex37245);


var statearr_37252_37279 = state_37232__$1;
(statearr_37252_37279[(1)] = (4));

(statearr_37252_37279[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (5))){
var inst_37177 = (state_37232[(7)]);
var _ = (function (){var statearr_37253 = state_37232;
(statearr_37253[(4)] = cljs.core.cons.call(null,(8),(state_37232[(4)])));

return statearr_37253;
})();
var inst_37184 = fluree.db.dbfunctions.internal.function_error.call(null,inst_37177,"?pO","Context Object");
var ___$1 = (function (){var statearr_37254 = state_37232;
(statearr_37254[(4)] = cljs.core.rest.call(null,(state_37232[(4)])));

return statearr_37254;
})();
var state_37232__$1 = state_37232;
var statearr_37255_37280 = state_37232__$1;
(statearr_37255_37280[(2)] = inst_37184);

(statearr_37255_37280[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (14))){
var state_37232__$1 = state_37232;
var statearr_37256_37281 = state_37232__$1;
(statearr_37256_37281[(2)] = null);

(statearr_37256_37281[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (16))){
var inst_37213 = (state_37232[(12)]);
var inst_37222 = (state_37232[(2)]);
var inst_37223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37224 = [inst_37222,inst_37213];
var inst_37225 = (new cljs.core.PersistentVector(null,2,(5),inst_37223,inst_37224,null));
var state_37232__$1 = state_37232;
var statearr_37258_37282 = state_37232__$1;
(statearr_37258_37282[(2)] = inst_37225);

(statearr_37258_37282[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (10))){
var inst_37196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37197 = [null,(0)];
var inst_37198 = (new cljs.core.PersistentVector(null,2,(5),inst_37196,inst_37197,null));
var state_37232__$1 = state_37232;
var statearr_37259_37283 = state_37232__$1;
(statearr_37259_37283[(2)] = inst_37198);

(statearr_37259_37283[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (8))){
var _ = (function (){var statearr_37260 = state_37232;
(statearr_37260[(4)] = cljs.core.rest.call(null,(state_37232[(4)])));

return statearr_37260;
})();
var state_37232__$1 = state_37232;
var ex37257 = (state_37232__$1[(2)]);
var statearr_37261_37284 = state_37232__$1;
(statearr_37261_37284[(5)] = ex37257);


var statearr_37262_37285 = state_37232__$1;
(statearr_37262_37285[(1)] = (7));

(statearr_37262_37285[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0 = (function (){
var statearr_37263 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37263[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__);

(statearr_37263[(1)] = (1));

return statearr_37263;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1 = (function (state_37232){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_37232);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e37264){var ex__2687__auto__ = e37264;
var statearr_37265_37286 = state_37232;
(statearr_37265_37286[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_37232[(4)]))){
var statearr_37266_37287 = state_37232;
(statearr_37266_37287[(1)] = cljs.core.first.call(null,(state_37232[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37288 = state_37232;
state_37232 = G__37288;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__ = function(state_37232){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1.call(this,state_37232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_37267 = f__2707__auto__.call(null);
(statearr_37267[(6)] = c__2706__auto__);

return statearr_37267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_37340){
var state_val_37341 = (state_37340[(1)]);
if((state_val_37341 === (7))){
var inst_37290 = (state_37340[(2)]);
var state_37340__$1 = state_37340;
var statearr_37342_37371 = state_37340__$1;
(statearr_37342_37371[(2)] = inst_37290);

(statearr_37342_37371[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37341 === (1))){
var state_37340__$1 = state_37340;
var statearr_37343_37372 = state_37340__$1;
(statearr_37343_37372[(2)] = null);

(statearr_37343_37372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37341 === (4))){
var inst_37289 = (state_37340[(2)]);
var state_37340__$1 = (function (){var statearr_37344 = state_37340;
(statearr_37344[(7)] = inst_37289);

return statearr_37344;
})();
var statearr_37345_37373 = state_37340__$1;
(statearr_37345_37373[(2)] = null);

(statearr_37345_37373[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37341 === (13))){
var inst_37335 = (state_37340[(2)]);
var _ = (function (){var statearr_37346 = state_37340;
(statearr_37346[(4)] = cljs.core.rest.call(null,(state_37340[(4)])));

return statearr_37346;
})();
var state_37340__$1 = state_37340;
var statearr_37347_37374 = state_37340__$1;
(statearr_37347_37374[(2)] = inst_37335);

(statearr_37347_37374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37341 === (6))){
var inst_37299 = (state_37340[(2)]);
var state_37340__$1 = state_37340;
var statearr_37348_37375 = state_37340__$1;
(statearr_37348_37375[(2)] = inst_37299);

(statearr_37348_37375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37341 === (3))){
var inst_37338 = (state_37340[(2)]);
var state_37340__$1 = state_37340;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37340__$1,inst_37338);
} else {
if((state_val_37341 === (12))){
var inst_37322 = (state_37340[(8)]);
var inst_37331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37332 = [null,inst_37322];
var inst_37333 = (new cljs.core.PersistentVector(null,2,(5),inst_37331,inst_37332,null));
var state_37340__$1 = state_37340;
var statearr_37349_37376 = state_37340__$1;
(statearr_37349_37376[(2)] = inst_37333);

(statearr_37349_37376[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37341 === (2))){
var _ = (function (){var statearr_37351 = state_37340;
(statearr_37351[(4)] = cljs.core.cons.call(null,(9),(state_37340[(4)])));

return statearr_37351;
})();
var inst_37308 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_37309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37311 = [null,pred_name,"?o"];
var inst_37312 = (new cljs.core.PersistentVector(null,3,(5),inst_37310,inst_37311,null));
var inst_37313 = [inst_37312];
var inst_37314 = (new cljs.core.PersistentVector(null,1,(5),inst_37309,inst_37313,null));
var inst_37315 = ["?o",inst_37314,opts];
var inst_37316 = cljs.core.PersistentHashMap.fromArrays(inst_37308,inst_37315);
var inst_37317 = fluree.db.dbfunctions.internal.query.call(null,db,inst_37316);
var state_37340__$1 = state_37340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37340__$1,(10),inst_37317);
} else {
if((state_val_37341 === (11))){
var inst_37321 = (state_37340[(9)]);
var inst_37322 = (state_37340[(8)]);
var inst_37326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37327 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_37321);
var inst_37328 = [inst_37327,inst_37322];
var inst_37329 = (new cljs.core.PersistentVector(null,2,(5),inst_37326,inst_37328,null));
var state_37340__$1 = state_37340;
var statearr_37352_37377 = state_37340__$1;
(statearr_37352_37377[(2)] = inst_37329);

(statearr_37352_37377[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37341 === (9))){
var _ = (function (){var statearr_37353 = state_37340;
(statearr_37353[(4)] = cljs.core.rest.call(null,(state_37340[(4)])));

return statearr_37353;
})();
var state_37340__$1 = state_37340;
var ex37350 = (state_37340__$1[(2)]);
var statearr_37354_37378 = state_37340__$1;
(statearr_37354_37378[(5)] = ex37350);


var statearr_37355_37379 = state_37340__$1;
(statearr_37355_37379[(1)] = (4));

(statearr_37355_37379[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37341 === (5))){
var inst_37289 = (state_37340[(7)]);
var _ = (function (){var statearr_37357 = state_37340;
(statearr_37357[(4)] = cljs.core.cons.call(null,(8),(state_37340[(4)])));

return statearr_37357;
})();
var inst_37296 = fluree.db.dbfunctions.internal.function_error.call(null,inst_37289,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_37358 = state_37340;
(statearr_37358[(4)] = cljs.core.rest.call(null,(state_37340[(4)])));

return statearr_37358;
})();
var state_37340__$1 = state_37340;
var statearr_37359_37380 = state_37340__$1;
(statearr_37359_37380[(2)] = inst_37296);

(statearr_37359_37380[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37341 === (10))){
var inst_37321 = (state_37340[(9)]);
var inst_37319 = (state_37340[(2)]);
var inst_37320 = fluree.db.util.async.throw_err.call(null,inst_37319);
var inst_37321__$1 = cljs.core.nth.call(null,inst_37320,(0),null);
var inst_37322 = cljs.core.nth.call(null,inst_37320,(1),null);
var inst_37323 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_37321__$1);
var inst_37324 = cljs.core.not.call(null,inst_37323);
var state_37340__$1 = (function (){var statearr_37360 = state_37340;
(statearr_37360[(9)] = inst_37321__$1);

(statearr_37360[(8)] = inst_37322);

return statearr_37360;
})();
if(inst_37324){
var statearr_37361_37381 = state_37340__$1;
(statearr_37361_37381[(1)] = (11));

} else {
var statearr_37362_37382 = state_37340__$1;
(statearr_37362_37382[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37341 === (8))){
var _ = (function (){var statearr_37363 = state_37340;
(statearr_37363[(4)] = cljs.core.rest.call(null,(state_37340[(4)])));

return statearr_37363;
})();
var state_37340__$1 = state_37340;
var ex37356 = (state_37340__$1[(2)]);
var statearr_37364_37383 = state_37340__$1;
(statearr_37364_37383[(5)] = ex37356);


var statearr_37365_37384 = state_37340__$1;
(statearr_37365_37384[(1)] = (7));

(statearr_37365_37384[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0 = (function (){
var statearr_37366 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37366[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__);

(statearr_37366[(1)] = (1));

return statearr_37366;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1 = (function (state_37340){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_37340);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e37367){var ex__2687__auto__ = e37367;
var statearr_37368_37385 = state_37340;
(statearr_37368_37385[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_37340[(4)]))){
var statearr_37369_37386 = state_37340;
(statearr_37369_37386[(1)] = cljs.core.first.call(null,(state_37340[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37387 = state_37340;
state_37340 = G__37387;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__ = function(state_37340){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1.call(this,state_37340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_37370 = f__2707__auto__.call(null);
(statearr_37370[(6)] = c__2706__auto__);

return statearr_37370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e37388){var e = e37388;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__37390 = arguments.length;
switch (G__37390) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_37460){
var state_val_37461 = (state_37460[(1)]);
if((state_val_37461 === (7))){
var inst_37392 = (state_37460[(2)]);
var state_37460__$1 = state_37460;
var statearr_37462_37506 = state_37460__$1;
(statearr_37462_37506[(2)] = inst_37392);

(statearr_37462_37506[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (20))){
var inst_37436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37437 = ["*"];
var inst_37438 = (new cljs.core.PersistentVector(null,1,(5),inst_37436,inst_37437,null));
var state_37460__$1 = state_37460;
var statearr_37463_37507 = state_37460__$1;
(statearr_37463_37507[(2)] = inst_37438);

(statearr_37463_37507[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (1))){
var state_37460__$1 = state_37460;
var statearr_37464_37508 = state_37460__$1;
(statearr_37464_37508[(2)] = null);

(statearr_37464_37508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (4))){
var inst_37391 = (state_37460[(2)]);
var state_37460__$1 = (function (){var statearr_37465 = state_37460;
(statearr_37465[(7)] = inst_37391);

return statearr_37465;
})();
var statearr_37466_37509 = state_37460__$1;
(statearr_37466_37509[(2)] = null);

(statearr_37466_37509[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (15))){
var inst_37455 = (state_37460[(2)]);
var _ = (function (){var statearr_37467 = state_37460;
(statearr_37467[(4)] = cljs.core.rest.call(null,(state_37460[(4)])));

return statearr_37467;
})();
var state_37460__$1 = state_37460;
var statearr_37468_37510 = state_37460__$1;
(statearr_37468_37510[(2)] = inst_37455);

(statearr_37468_37510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (21))){
var inst_37419 = (state_37460[(8)]);
var inst_37426 = (state_37460[(9)]);
var inst_37440 = (state_37460[(2)]);
var inst_37441 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_37442 = cljs.core.PersistentHashMap.EMPTY;
var inst_37443 = [inst_37440,inst_37426,inst_37442];
var inst_37444 = cljs.core.PersistentHashMap.fromArrays(inst_37441,inst_37443);
var inst_37445 = fluree.db.dbfunctions.internal.query.call(null,inst_37419,inst_37444);
var state_37460__$1 = state_37460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37460__$1,(22),inst_37445);
} else {
if((state_val_37461 === (13))){
var inst_37414 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_37460__$1 = state_37460;
var statearr_37469_37511 = state_37460__$1;
(statearr_37469_37511[(2)] = inst_37414);

(statearr_37469_37511[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (22))){
var inst_37447 = (state_37460[(2)]);
var inst_37448 = fluree.db.util.async.throw_err.call(null,inst_37447);
var inst_37449 = cljs.core.nth.call(null,inst_37448,(0),null);
var inst_37450 = cljs.core.nth.call(null,inst_37448,(1),null);
var inst_37451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37452 = [inst_37449,inst_37450];
var inst_37453 = (new cljs.core.PersistentVector(null,2,(5),inst_37451,inst_37452,null));
var state_37460__$1 = state_37460;
var statearr_37470_37512 = state_37460__$1;
(statearr_37470_37512[(2)] = inst_37453);

(statearr_37470_37512[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (6))){
var inst_37401 = (state_37460[(2)]);
var state_37460__$1 = state_37460;
var statearr_37471_37513 = state_37460__$1;
(statearr_37471_37513[(2)] = inst_37401);

(statearr_37471_37513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (17))){
var inst_37423 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37424 = fluree.db.dbfunctions.internal.get.call(null,inst_37423,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_37460__$1 = state_37460;
var statearr_37472_37514 = state_37460__$1;
(statearr_37472_37514[(2)] = inst_37424);

(statearr_37472_37514[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (3))){
var inst_37458 = (state_37460[(2)]);
var state_37460__$1 = state_37460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37460__$1,inst_37458);
} else {
if((state_val_37461 === (12))){
var inst_37412 = (state_37460[(2)]);
var state_37460__$1 = state_37460;
if(cljs.core.truth_(inst_37412)){
var statearr_37473_37515 = state_37460__$1;
(statearr_37473_37515[(1)] = (13));

} else {
var statearr_37474_37516 = state_37460__$1;
(statearr_37474_37516[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (2))){
var inst_37407 = (state_37460[(10)]);
var _ = (function (){var statearr_37475 = state_37460;
(statearr_37475[(4)] = cljs.core.cons.call(null,(9),(state_37460[(4)])));

return statearr_37475;
})();
var inst_37407__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_37460__$1 = (function (){var statearr_37476 = state_37460;
(statearr_37476[(10)] = inst_37407__$1);

return statearr_37476;
})();
if(cljs.core.truth_(inst_37407__$1)){
var statearr_37477_37517 = state_37460__$1;
(statearr_37477_37517[(1)] = (10));

} else {
var statearr_37478_37518 = state_37460__$1;
(statearr_37478_37518[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (19))){
var inst_37428 = cljs.core.PersistentVector.EMPTY;
var inst_37429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37430 = ["*"];
var inst_37431 = (new cljs.core.PersistentVector(null,1,(5),inst_37429,inst_37430,null));
var inst_37432 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_37433 = cljs.core.concat.call(null,inst_37431,inst_37432);
var inst_37434 = cljs.core.into.call(null,inst_37428,inst_37433);
var state_37460__$1 = state_37460;
var statearr_37480_37519 = state_37460__$1;
(statearr_37480_37519[(2)] = inst_37434);

(statearr_37480_37519[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (11))){
var inst_37407 = (state_37460[(10)]);
var state_37460__$1 = state_37460;
var statearr_37481_37520 = state_37460__$1;
(statearr_37481_37520[(2)] = inst_37407);

(statearr_37481_37520[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (9))){
var _ = (function (){var statearr_37482 = state_37460;
(statearr_37482[(4)] = cljs.core.rest.call(null,(state_37460[(4)])));

return statearr_37482;
})();
var state_37460__$1 = state_37460;
var ex37479 = (state_37460__$1[(2)]);
var statearr_37483_37521 = state_37460__$1;
(statearr_37483_37521[(5)] = ex37479);


var statearr_37484_37522 = state_37460__$1;
(statearr_37484_37522[(1)] = (4));

(statearr_37484_37522[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (5))){
var inst_37391 = (state_37460[(7)]);
var _ = (function (){var statearr_37485 = state_37460;
(statearr_37485[(4)] = cljs.core.cons.call(null,(8),(state_37460[(4)])));

return statearr_37485;
})();
var inst_37398 = fluree.db.dbfunctions.internal.function_error.call(null,inst_37391,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_37486 = state_37460;
(statearr_37486[(4)] = cljs.core.rest.call(null,(state_37460[(4)])));

return statearr_37486;
})();
var state_37460__$1 = state_37460;
var statearr_37487_37523 = state_37460__$1;
(statearr_37487_37523[(2)] = inst_37398);

(statearr_37487_37523[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (14))){
var inst_37420 = (state_37460[(11)]);
var inst_37419 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37420__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_37460__$1 = (function (){var statearr_37488 = state_37460;
(statearr_37488[(8)] = inst_37419);

(statearr_37488[(11)] = inst_37420__$1);

return statearr_37488;
})();
if(cljs.core.truth_(inst_37420__$1)){
var statearr_37489_37524 = state_37460__$1;
(statearr_37489_37524[(1)] = (16));

} else {
var statearr_37490_37525 = state_37460__$1;
(statearr_37490_37525[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (16))){
var inst_37420 = (state_37460[(11)]);
var state_37460__$1 = state_37460;
var statearr_37491_37526 = state_37460__$1;
(statearr_37491_37526[(2)] = inst_37420);

(statearr_37491_37526[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (10))){
var inst_37409 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_37460__$1 = state_37460;
var statearr_37493_37527 = state_37460__$1;
(statearr_37493_37527[(2)] = inst_37409);

(statearr_37493_37527[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (18))){
var inst_37426 = (state_37460[(2)]);
var state_37460__$1 = (function (){var statearr_37494 = state_37460;
(statearr_37494[(9)] = inst_37426);

return statearr_37494;
})();
if(cljs.core.truth_(additional_params)){
var statearr_37495_37528 = state_37460__$1;
(statearr_37495_37528[(1)] = (19));

} else {
var statearr_37496_37529 = state_37460__$1;
(statearr_37496_37529[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37461 === (8))){
var _ = (function (){var statearr_37497 = state_37460;
(statearr_37497[(4)] = cljs.core.rest.call(null,(state_37460[(4)])));

return statearr_37497;
})();
var state_37460__$1 = state_37460;
var ex37492 = (state_37460__$1[(2)]);
var statearr_37498_37530 = state_37460__$1;
(statearr_37498_37530[(5)] = ex37492);


var statearr_37499_37531 = state_37460__$1;
(statearr_37499_37531[(1)] = (7));

(statearr_37499_37531[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_37500 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37500[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_37500[(1)] = (1));

return statearr_37500;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_37460){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_37460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e37501){var ex__2687__auto__ = e37501;
var statearr_37502_37532 = state_37460;
(statearr_37502_37532[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_37460[(4)]))){
var statearr_37503_37533 = state_37460;
(statearr_37503_37533[(1)] = cljs.core.first.call(null,(state_37460[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37534 = state_37460;
state_37460 = G__37534;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_37460){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_37460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_37504 = f__2707__auto__.call(null);
(statearr_37504[(6)] = c__2706__auto__);

return statearr_37504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__37536 = arguments.length;
switch (G__37536) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_37580){
var state_val_37581 = (state_37580[(1)]);
if((state_val_37581 === (7))){
var inst_37558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37559 = ["*"];
var inst_37560 = (new cljs.core.PersistentVector(null,1,(5),inst_37558,inst_37559,null));
var state_37580__$1 = state_37580;
var statearr_37582_37602 = state_37580__$1;
(statearr_37582_37602[(2)] = inst_37560);

(statearr_37582_37602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37581 === (1))){
var state_37580__$1 = state_37580;
var statearr_37583_37603 = state_37580__$1;
(statearr_37583_37603[(2)] = null);

(statearr_37583_37603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37581 === (4))){
var inst_37537 = (state_37580[(2)]);
var inst_37538 = fluree.db.dbfunctions.internal.function_error.call(null,inst_37537,"?p","Context Object",additional_params);
var state_37580__$1 = state_37580;
var statearr_37584_37604 = state_37580__$1;
(statearr_37584_37604[(2)] = inst_37538);

(statearr_37584_37604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37581 === (6))){
var inst_37550 = cljs.core.PersistentVector.EMPTY;
var inst_37551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37552 = ["*"];
var inst_37553 = (new cljs.core.PersistentVector(null,1,(5),inst_37551,inst_37552,null));
var inst_37554 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_37555 = cljs.core.concat.call(null,inst_37553,inst_37554);
var inst_37556 = cljs.core.into.call(null,inst_37550,inst_37555);
var state_37580__$1 = state_37580;
var statearr_37585_37605 = state_37580__$1;
(statearr_37585_37605[(2)] = inst_37556);

(statearr_37585_37605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37581 === (3))){
var inst_37578 = (state_37580[(2)]);
var state_37580__$1 = state_37580;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37580__$1,inst_37578);
} else {
if((state_val_37581 === (2))){
var _ = (function (){var statearr_37587 = state_37580;
(statearr_37587[(4)] = cljs.core.cons.call(null,(5),(state_37580[(4)])));

return statearr_37587;
})();
var inst_37547 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37548 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_37580__$1 = (function (){var statearr_37588 = state_37580;
(statearr_37588[(7)] = inst_37548);

(statearr_37588[(8)] = inst_37547);

return statearr_37588;
})();
if(cljs.core.truth_(additional_params)){
var statearr_37589_37606 = state_37580__$1;
(statearr_37589_37606[(1)] = (6));

} else {
var statearr_37590_37607 = state_37580__$1;
(statearr_37590_37607[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37581 === (9))){
var inst_37569 = (state_37580[(2)]);
var inst_37570 = fluree.db.util.async.throw_err.call(null,inst_37569);
var inst_37571 = cljs.core.nth.call(null,inst_37570,(0),null);
var inst_37572 = cljs.core.nth.call(null,inst_37570,(1),null);
var inst_37573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37574 = [inst_37571,inst_37572];
var inst_37575 = (new cljs.core.PersistentVector(null,2,(5),inst_37573,inst_37574,null));
var _ = (function (){var statearr_37591 = state_37580;
(statearr_37591[(4)] = cljs.core.rest.call(null,(state_37580[(4)])));

return statearr_37591;
})();
var state_37580__$1 = state_37580;
var statearr_37592_37608 = state_37580__$1;
(statearr_37592_37608[(2)] = inst_37575);

(statearr_37592_37608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37581 === (5))){
var _ = (function (){var statearr_37593 = state_37580;
(statearr_37593[(4)] = cljs.core.rest.call(null,(state_37580[(4)])));

return statearr_37593;
})();
var state_37580__$1 = state_37580;
var ex37586 = (state_37580__$1[(2)]);
var statearr_37594_37609 = state_37580__$1;
(statearr_37594_37609[(5)] = ex37586);


var statearr_37595_37610 = state_37580__$1;
(statearr_37595_37610[(1)] = (4));

(statearr_37595_37610[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37581 === (8))){
var inst_37548 = (state_37580[(7)]);
var inst_37547 = (state_37580[(8)]);
var inst_37562 = (state_37580[(2)]);
var inst_37563 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_37564 = cljs.core.PersistentHashMap.EMPTY;
var inst_37565 = [inst_37562,inst_37548,inst_37564];
var inst_37566 = cljs.core.PersistentHashMap.fromArrays(inst_37563,inst_37565);
var inst_37567 = fluree.db.dbfunctions.internal.query.call(null,inst_37547,inst_37566);
var state_37580__$1 = state_37580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37580__$1,(9),inst_37567);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_37596 = [null,null,null,null,null,null,null,null,null];
(statearr_37596[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_37596[(1)] = (1));

return statearr_37596;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_37580){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_37580);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e37597){var ex__2687__auto__ = e37597;
var statearr_37598_37611 = state_37580;
(statearr_37598_37611[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_37580[(4)]))){
var statearr_37599_37612 = state_37580;
(statearr_37599_37612[(1)] = cljs.core.first.call(null,(state_37580[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37613 = state_37580;
state_37580 = G__37613;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_37580){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_37580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_37600 = f__2707__auto__.call(null);
(statearr_37600[(6)] = c__2706__auto__);

return statearr_37600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_37657){
var state_val_37658 = (state_37657[(1)]);
if((state_val_37658 === (1))){
var state_37657__$1 = state_37657;
var statearr_37659_37673 = state_37657__$1;
(statearr_37659_37673[(2)] = null);

(statearr_37659_37673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (2))){
var _ = (function (){var statearr_37660 = state_37657;
(statearr_37660[(4)] = cljs.core.cons.call(null,(5),(state_37657[(4)])));

return statearr_37660;
})();
var inst_37624 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_37625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37626 = ["_user/_auth"];
var inst_37627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37628 = ["*"];
var inst_37629 = (new cljs.core.PersistentVector(null,1,(5),inst_37627,inst_37628,null));
var inst_37630 = [inst_37629];
var inst_37631 = cljs.core.PersistentHashMap.fromArrays(inst_37626,inst_37630);
var inst_37632 = [inst_37631];
var inst_37633 = (new cljs.core.PersistentVector(null,1,(5),inst_37625,inst_37632,null));
var inst_37634 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37635 = cljs.core.PersistentHashMap.EMPTY;
var inst_37636 = [inst_37633,inst_37634,inst_37635];
var inst_37637 = cljs.core.PersistentHashMap.fromArrays(inst_37624,inst_37636);
var inst_37638 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37639 = fluree.db.dbfunctions.internal.query.call(null,inst_37638,inst_37637);
var state_37657__$1 = state_37657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37657__$1,(6),inst_37639);
} else {
if((state_val_37658 === (3))){
var inst_37655 = (state_37657[(2)]);
var state_37657__$1 = state_37657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37657__$1,inst_37655);
} else {
if((state_val_37658 === (4))){
var inst_37614 = (state_37657[(2)]);
var inst_37615 = fluree.db.dbfunctions.internal.function_error.call(null,inst_37614,"?user_id-from-auth","Context Object");
var state_37657__$1 = state_37657;
var statearr_37662_37674 = state_37657__$1;
(statearr_37662_37674[(2)] = inst_37615);

(statearr_37662_37674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (5))){
var _ = (function (){var statearr_37663 = state_37657;
(statearr_37663[(4)] = cljs.core.rest.call(null,(state_37657[(4)])));

return statearr_37663;
})();
var state_37657__$1 = state_37657;
var ex37661 = (state_37657__$1[(2)]);
var statearr_37664_37675 = state_37657__$1;
(statearr_37664_37675[(5)] = ex37661);


var statearr_37665_37676 = state_37657__$1;
(statearr_37665_37676[(1)] = (4));

(statearr_37665_37676[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (6))){
var inst_37641 = (state_37657[(2)]);
var inst_37642 = fluree.db.util.async.throw_err.call(null,inst_37641);
var inst_37643 = cljs.core.nth.call(null,inst_37642,(0),null);
var inst_37644 = cljs.core.nth.call(null,inst_37642,(1),null);
var inst_37645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37646 = ["_user/_auth","_id"];
var inst_37647 = (new cljs.core.PersistentVector(null,2,(5),inst_37645,inst_37646,null));
var inst_37648 = fluree.db.dbfunctions.internal.get_in.call(null,inst_37643,inst_37647);
var inst_37649 = cljs.core.first.call(null,inst_37648);
var inst_37650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37651 = [inst_37649,inst_37644];
var inst_37652 = (new cljs.core.PersistentVector(null,2,(5),inst_37650,inst_37651,null));
var _ = (function (){var statearr_37666 = state_37657;
(statearr_37666[(4)] = cljs.core.rest.call(null,(state_37657[(4)])));

return statearr_37666;
})();
var state_37657__$1 = state_37657;
var statearr_37667_37677 = state_37657__$1;
(statearr_37667_37677[(2)] = inst_37652);

(statearr_37667_37677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0 = (function (){
var statearr_37668 = [null,null,null,null,null,null,null];
(statearr_37668[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__);

(statearr_37668[(1)] = (1));

return statearr_37668;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1 = (function (state_37657){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_37657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e37669){var ex__2687__auto__ = e37669;
var statearr_37670_37678 = state_37657;
(statearr_37670_37678[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_37657[(4)]))){
var statearr_37671_37679 = state_37657;
(statearr_37671_37679[(1)] = cljs.core.first.call(null,(state_37657[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37680 = state_37657;
state_37657 = G__37680;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__ = function(state_37657){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1.call(this,state_37657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_37672 = f__2707__auto__.call(null);
(statearr_37672[(6)] = c__2706__auto__);

return statearr_37672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_37702){
var state_val_37703 = (state_37702[(1)]);
if((state_val_37703 === (7))){
var inst_37687 = (state_37702[(7)]);
var inst_37691 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37692 = fluree.db.dbproto._subid.call(null,inst_37691,inst_37687);
var state_37702__$1 = state_37702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37702__$1,(9),inst_37692);
} else {
if((state_val_37703 === (1))){
var state_37702__$1 = state_37702;
var statearr_37704_37723 = state_37702__$1;
(statearr_37704_37723[(2)] = null);

(statearr_37704_37723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (4))){
var inst_37681 = (state_37702[(2)]);
var state_37702__$1 = state_37702;
var statearr_37705_37724 = state_37702__$1;
(statearr_37705_37724[(2)] = inst_37681);

(statearr_37705_37724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (6))){
var inst_37687 = (state_37702[(7)]);
var state_37702__$1 = state_37702;
var statearr_37706_37725 = state_37702__$1;
(statearr_37706_37725[(2)] = inst_37687);

(statearr_37706_37725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (3))){
var inst_37700 = (state_37702[(2)]);
var state_37702__$1 = state_37702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37702__$1,inst_37700);
} else {
if((state_val_37703 === (2))){
var inst_37687 = (state_37702[(7)]);
var _ = (function (){var statearr_37708 = state_37702;
(statearr_37708[(4)] = cljs.core.cons.call(null,(5),(state_37702[(4)])));

return statearr_37708;
})();
var inst_37687__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37688 = typeof inst_37687__$1 === 'number';
var state_37702__$1 = (function (){var statearr_37709 = state_37702;
(statearr_37709[(7)] = inst_37687__$1);

return statearr_37709;
})();
if(cljs.core.truth_(inst_37688)){
var statearr_37710_37726 = state_37702__$1;
(statearr_37710_37726[(1)] = (6));

} else {
var statearr_37711_37727 = state_37702__$1;
(statearr_37711_37727[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (9))){
var inst_37694 = (state_37702[(2)]);
var inst_37695 = fluree.db.util.async.throw_err.call(null,inst_37694);
var state_37702__$1 = state_37702;
var statearr_37712_37728 = state_37702__$1;
(statearr_37712_37728[(2)] = inst_37695);

(statearr_37712_37728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (5))){
var _ = (function (){var statearr_37713 = state_37702;
(statearr_37713[(4)] = cljs.core.rest.call(null,(state_37702[(4)])));

return statearr_37713;
})();
var state_37702__$1 = state_37702;
var ex37707 = (state_37702__$1[(2)]);
var statearr_37714_37729 = state_37702__$1;
(statearr_37714_37729[(5)] = ex37707);


if((ex37707 instanceof Error)){
var statearr_37715_37730 = state_37702__$1;
(statearr_37715_37730[(1)] = (4));

(statearr_37715_37730[(5)] = null);

} else {
throw ex37707;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (8))){
var inst_37697 = (state_37702[(2)]);
var _ = (function (){var statearr_37716 = state_37702;
(statearr_37716[(4)] = cljs.core.rest.call(null,(state_37702[(4)])));

return statearr_37716;
})();
var state_37702__$1 = state_37702;
var statearr_37717_37731 = state_37702__$1;
(statearr_37717_37731[(2)] = inst_37697);

(statearr_37717_37731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0 = (function (){
var statearr_37718 = [null,null,null,null,null,null,null,null];
(statearr_37718[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__);

(statearr_37718[(1)] = (1));

return statearr_37718;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1 = (function (state_37702){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_37702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e37719){var ex__2687__auto__ = e37719;
var statearr_37720_37732 = state_37702;
(statearr_37720_37732[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_37702[(4)]))){
var statearr_37721_37733 = state_37702;
(statearr_37721_37733[(1)] = cljs.core.first.call(null,(state_37702[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37734 = state_37702;
state_37702 = G__37734;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__ = function(state_37702){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1.call(this,state_37702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_37722 = f__2707__auto__.call(null);
(statearr_37722[(6)] = c__2706__auto__);

return statearr_37722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__37735_SHARP_){
return fluree.db.flake.op.call(null,p1__37735_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__37736_SHARP_){
return fluree.db.flake.o.call(null,p1__37736_SHARP_);
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e37737){var e = e37737;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__37738_SHARP_){
return fluree.db.flake.op.call(null,p1__37738_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__37739_SHARP_){
return fluree.db.flake.o.call(null,p1__37739_SHARP_);
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e37740){var e = e37740;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e37741){var e = e37741;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_37821){
var state_val_37822 = (state_37821[(1)]);
if((state_val_37822 === (7))){
var inst_37760 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_37761 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37762 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_37763 = cljs.core.PersistentHashMap.fromArrays(inst_37761,inst_37762);
var inst_37764 = cljs.core.ex_info.call(null,inst_37760,inst_37763);
var inst_37765 = (function(){throw inst_37764})();
var state_37821__$1 = state_37821;
var statearr_37823_37858 = state_37821__$1;
(statearr_37823_37858[(2)] = inst_37765);

(statearr_37823_37858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (1))){
var state_37821__$1 = state_37821;
var statearr_37824_37859 = state_37821__$1;
(statearr_37824_37859[(2)] = null);

(statearr_37824_37859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (4))){
var inst_37742 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
var statearr_37825_37860 = state_37821__$1;
(statearr_37825_37860[(2)] = inst_37742);

(statearr_37825_37860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (15))){
var inst_37805 = (state_37821[(7)]);
var inst_37801 = (state_37821[(2)]);
var inst_37802 = fluree.db.util.async.throw_err.call(null,inst_37801);
var inst_37803 = cljs.core.nth.call(null,inst_37802,(0),null);
var inst_37804 = cljs.core.nth.call(null,inst_37802,(1),null);
var inst_37805__$1 = cljs.core.first.call(null,inst_37803);
var inst_37806 = cljs.core._EQ_.call(null,inst_37805__$1,compare_val);
var state_37821__$1 = (function (){var statearr_37826 = state_37821;
(statearr_37826[(8)] = inst_37804);

(statearr_37826[(7)] = inst_37805__$1);

return statearr_37826;
})();
if(inst_37806){
var statearr_37827_37861 = state_37821__$1;
(statearr_37827_37861[(1)] = (16));

} else {
var statearr_37828_37862 = state_37821__$1;
(statearr_37828_37862[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (13))){
var state_37821__$1 = state_37821;
var statearr_37829_37863 = state_37821__$1;
(statearr_37829_37863[(2)] = null);

(statearr_37829_37863[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (6))){
var state_37821__$1 = state_37821;
var statearr_37830_37864 = state_37821__$1;
(statearr_37830_37864[(2)] = null);

(statearr_37830_37864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (17))){
var inst_37805 = (state_37821[(7)]);
var inst_37809 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37805)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_37810 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37811 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_37812 = cljs.core.PersistentHashMap.fromArrays(inst_37810,inst_37811);
var inst_37813 = cljs.core.ex_info.call(null,inst_37809,inst_37812);
var inst_37814 = (function(){throw inst_37813})();
var state_37821__$1 = state_37821;
var statearr_37831_37865 = state_37821__$1;
(statearr_37831_37865[(2)] = inst_37814);

(statearr_37831_37865[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (3))){
var inst_37819 = (state_37821[(2)]);
var state_37821__$1 = state_37821;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37821__$1,inst_37819);
} else {
if((state_val_37822 === (12))){
var inst_37757 = (state_37821[(9)]);
var inst_37780 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_37757);
var inst_37781 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37782 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_37783 = cljs.core.PersistentHashMap.fromArrays(inst_37781,inst_37782);
var inst_37784 = cljs.core.ex_info.call(null,inst_37780,inst_37783);
var inst_37785 = (function(){throw inst_37784})();
var state_37821__$1 = state_37821;
var statearr_37832_37866 = state_37821__$1;
(statearr_37832_37866[(2)] = inst_37785);

(statearr_37832_37866[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (2))){
var inst_37755 = (state_37821[(10)]);
var inst_37754 = (state_37821[(11)]);
var inst_37756 = (state_37821[(12)]);
var _ = (function (){var statearr_37833 = state_37821;
(statearr_37833[(4)] = cljs.core.cons.call(null,(5),(state_37821[(4)])));

return statearr_37833;
})();
var inst_37752 = _QMARK_ctx;
var inst_37753 = cljs.core.__destructure_map.call(null,inst_37752);
var inst_37754__$1 = cljs.core.get.call(null,inst_37753,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_37755__$1 = cljs.core.get.call(null,inst_37753,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_37756__$1 = cljs.core.get.call(null,inst_37753,new cljs.core.Keyword(null,"db","db",993250759));
var inst_37757 = fluree.db.dbproto._p_prop.call(null,inst_37756__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_37755__$1);
var state_37821__$1 = (function (){var statearr_37834 = state_37821;
(statearr_37834[(10)] = inst_37755__$1);

(statearr_37834[(9)] = inst_37757);

(statearr_37834[(11)] = inst_37754__$1);

(statearr_37834[(12)] = inst_37756__$1);

return statearr_37834;
})();
if(cljs.core.truth_(inst_37754__$1)){
var statearr_37835_37867 = state_37821__$1;
(statearr_37835_37867[(1)] = (6));

} else {
var statearr_37836_37868 = state_37821__$1;
(statearr_37836_37868[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (11))){
var inst_37755 = (state_37821[(10)]);
var inst_37756 = (state_37821[(12)]);
var inst_37777 = (state_37821[(2)]);
var inst_37778 = fluree.db.dbproto._p_prop.call(null,inst_37756,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_37755);
var state_37821__$1 = (function (){var statearr_37838 = state_37821;
(statearr_37838[(13)] = inst_37777);

return statearr_37838;
})();
if(cljs.core.truth_(inst_37778)){
var statearr_37839_37869 = state_37821__$1;
(statearr_37839_37869[(1)] = (12));

} else {
var statearr_37840_37870 = state_37821__$1;
(statearr_37840_37870[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (9))){
var state_37821__$1 = state_37821;
var statearr_37841_37871 = state_37821__$1;
(statearr_37841_37871[(2)] = null);

(statearr_37841_37871[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (5))){
var _ = (function (){var statearr_37842 = state_37821;
(statearr_37842[(4)] = cljs.core.rest.call(null,(state_37821[(4)])));

return statearr_37842;
})();
var state_37821__$1 = state_37821;
var ex37837 = (state_37821__$1[(2)]);
var statearr_37843_37872 = state_37821__$1;
(statearr_37843_37872[(5)] = ex37837);


if((ex37837 instanceof Error)){
var statearr_37844_37873 = state_37821__$1;
(statearr_37844_37873[(1)] = (4));

(statearr_37844_37873[(5)] = null);

} else {
throw ex37837;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (14))){
var inst_37757 = (state_37821[(9)]);
var inst_37754 = (state_37821[(11)]);
var inst_37756 = (state_37821[(12)]);
var inst_37788 = (state_37821[(2)]);
var inst_37789 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_37790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37792 = [inst_37754,inst_37757,"?current-val"];
var inst_37793 = (new cljs.core.PersistentVector(null,3,(5),inst_37791,inst_37792,null));
var inst_37794 = [inst_37793];
var inst_37795 = (new cljs.core.PersistentVector(null,1,(5),inst_37790,inst_37794,null));
var inst_37796 = cljs.core.PersistentHashMap.EMPTY;
var inst_37797 = ["?current-val",inst_37795,inst_37796];
var inst_37798 = cljs.core.PersistentHashMap.fromArrays(inst_37789,inst_37797);
var inst_37799 = fluree.db.dbfunctions.internal.query.call(null,inst_37756,inst_37798);
var state_37821__$1 = (function (){var statearr_37845 = state_37821;
(statearr_37845[(14)] = inst_37788);

return statearr_37845;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37821__$1,(15),inst_37799);
} else {
if((state_val_37822 === (16))){
var state_37821__$1 = state_37821;
var statearr_37846_37874 = state_37821__$1;
(statearr_37846_37874[(2)] = new_val);

(statearr_37846_37874[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (10))){
var inst_37770 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_37771 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37772 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_37773 = cljs.core.PersistentHashMap.fromArrays(inst_37771,inst_37772);
var inst_37774 = cljs.core.ex_info.call(null,inst_37770,inst_37773);
var inst_37775 = (function(){throw inst_37774})();
var state_37821__$1 = state_37821;
var statearr_37847_37875 = state_37821__$1;
(statearr_37847_37875[(2)] = inst_37775);

(statearr_37847_37875[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (18))){
var inst_37816 = (state_37821[(2)]);
var _ = (function (){var statearr_37848 = state_37821;
(statearr_37848[(4)] = cljs.core.rest.call(null,(state_37821[(4)])));

return statearr_37848;
})();
var state_37821__$1 = state_37821;
var statearr_37849_37876 = state_37821__$1;
(statearr_37849_37876[(2)] = inst_37816);

(statearr_37849_37876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37822 === (8))){
var inst_37757 = (state_37821[(9)]);
var inst_37767 = (state_37821[(2)]);
var state_37821__$1 = (function (){var statearr_37850 = state_37821;
(statearr_37850[(15)] = inst_37767);

return statearr_37850;
})();
if(cljs.core.truth_(inst_37757)){
var statearr_37851_37877 = state_37821__$1;
(statearr_37851_37877[(1)] = (9));

} else {
var statearr_37852_37878 = state_37821__$1;
(statearr_37852_37878[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0 = (function (){
var statearr_37853 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37853[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__);

(statearr_37853[(1)] = (1));

return statearr_37853;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1 = (function (state_37821){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_37821);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e37854){var ex__2687__auto__ = e37854;
var statearr_37855_37879 = state_37821;
(statearr_37855_37879[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_37821[(4)]))){
var statearr_37856_37880 = state_37821;
(statearr_37856_37880[(1)] = cljs.core.first.call(null,(state_37821[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37881 = state_37821;
state_37821 = G__37881;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__ = function(state_37821){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1.call(this,state_37821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_37857 = f__2707__auto__.call(null);
(statearr_37857[(6)] = c__2706__auto__);

return statearr_37857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
