// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18177 = arguments.length;
switch (G__18177) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,ledger){
return fluree.db.operations.formulate_op_header.call(null,operation,ledger,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,ledger,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18180 = arguments.length;
switch (G__18180) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2706__auto___18233 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18211){
var state_val_18212 = (state_18211[(1)]);
if((state_val_18212 === (1))){
var state_18211__$1 = state_18211;
var statearr_18213_18234 = state_18211__$1;
(statearr_18213_18234[(2)] = null);

(statearr_18213_18234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (2))){
var _ = (function (){var statearr_18214 = state_18211;
(statearr_18214[(4)] = cljs.core.cons.call(null,(5),(state_18211[(4)])));

return statearr_18214;
})();
var inst_18188 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_18211__$1 = state_18211;
if(cljs.core.truth_(inst_18188)){
var statearr_18215_18235 = state_18211__$1;
(statearr_18215_18235[(1)] = (6));

} else {
var statearr_18216_18236 = state_18211__$1;
(statearr_18216_18236[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (3))){
var inst_18209 = (state_18211[(2)]);
var state_18211__$1 = state_18211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18211__$1,inst_18209);
} else {
if((state_val_18212 === (4))){
var inst_18181 = (state_18211[(2)]);
var inst_18182 = cljs.core.async.put_BANG_.call(null,pc,inst_18181);
var state_18211__$1 = state_18211;
var statearr_18218_18237 = state_18211__$1;
(statearr_18218_18237[(2)] = inst_18182);

(statearr_18218_18237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (5))){
var _ = (function (){var statearr_18219 = state_18211;
(statearr_18219[(4)] = cljs.core.rest.call(null,(state_18211[(4)])));

return statearr_18219;
})();
var state_18211__$1 = state_18211;
var ex18217 = (state_18211__$1[(2)]);
var statearr_18220_18238 = state_18211__$1;
(statearr_18220_18238[(5)] = ex18217);


var statearr_18221_18239 = state_18211__$1;
(statearr_18221_18239[(1)] = (4));

(statearr_18221_18239[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (6))){
var inst_18190 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18191 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18192 = cljs.core.PersistentHashMap.fromArrays(inst_18190,inst_18191);
var inst_18193 = cljs.core.ex_info.call(null,"Connection was closed.",inst_18192);
var inst_18194 = (function(){throw inst_18193})();
var state_18211__$1 = state_18211;
var statearr_18222_18240 = state_18211__$1;
(statearr_18222_18240[(2)] = inst_18194);

(statearr_18222_18240[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (7))){
var inst_18196 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18198 = [operation,data,pc,opts];
var inst_18199 = (new cljs.core.PersistentVector(null,4,(5),inst_18197,inst_18198,null));
var inst_18200 = cljs.core.async.put_BANG_.call(null,inst_18196,inst_18199);
var inst_18201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18202 = [operation,data,pc,opts];
var inst_18203 = (new cljs.core.PersistentVector(null,4,(5),inst_18201,inst_18202,null));
var inst_18204 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_18203);
var state_18211__$1 = (function (){var statearr_18223 = state_18211;
(statearr_18223[(7)] = inst_18200);

return statearr_18223;
})();
var statearr_18224_18241 = state_18211__$1;
(statearr_18224_18241[(2)] = inst_18204);

(statearr_18224_18241[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (8))){
var inst_18206 = (state_18211[(2)]);
var _ = (function (){var statearr_18225 = state_18211;
(statearr_18225[(4)] = cljs.core.rest.call(null,(state_18211[(4)])));

return statearr_18225;
})();
var state_18211__$1 = state_18211;
var statearr_18226_18242 = state_18211__$1;
(statearr_18226_18242[(2)] = inst_18206);

(statearr_18226_18242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2684__auto__ = null;
var fluree$db$operations$state_machine__2684__auto____0 = (function (){
var statearr_18227 = [null,null,null,null,null,null,null,null];
(statearr_18227[(0)] = fluree$db$operations$state_machine__2684__auto__);

(statearr_18227[(1)] = (1));

return statearr_18227;
});
var fluree$db$operations$state_machine__2684__auto____1 = (function (state_18211){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_18211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18228){var ex__2687__auto__ = e18228;
var statearr_18229_18243 = state_18211;
(statearr_18229_18243[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_18211[(4)]))){
var statearr_18230_18244 = state_18211;
(statearr_18230_18244[(1)] = cljs.core.first.call(null,(state_18211[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18245 = state_18211;
state_18211 = G__18245;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2684__auto__ = function(state_18211){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2684__auto____1.call(this,state_18211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2684__auto____0;
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2684__auto____1;
return fluree$db$operations$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18231 = f__2707__auto__.call(null);
(statearr_18231[(6)] = c__2706__auto___18233);

return statearr_18231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18247 = arguments.length;
switch (G__18247) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18248){
var map__18249 = p__18248;
var map__18249__$1 = cljs.core.__destructure_map.call(null,map__18249);
var opts = map__18249__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__18249__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18250 = session;
var map__18250__$1 = cljs.core.__destructure_map.call(null,map__18250);
var ledger_id = cljs.core.get.call(null,map__18250__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var network = cljs.core.get.call(null,map__18250__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__18250__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5775__auto__ = [];
var len__5769__auto___18277 = arguments.length;
var i__5770__auto___18278 = (0);
while(true){
if((i__5770__auto___18278 < len__5769__auto___18277)){
args__5775__auto__.push((arguments[i__5770__auto___18278]));

var G__18279 = (i__5770__auto___18278 + (1));
i__5770__auto___18278 = G__18279;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18254){
var vec__18255 = p__18254;
var map__18258 = cljs.core.nth.call(null,vec__18255,(0),null);
var map__18258__$1 = cljs.core.__destructure_map.call(null,map__18258);
var toBlock = cljs.core.get.call(null,map__18258__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__18258__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18255;
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18270){
var state_val_18271 = (state_18270[(1)]);
if((state_val_18271 === (1))){
var inst_18260 = session;
var inst_18261 = cljs.core.__destructure_map.call(null,inst_18260);
var inst_18262 = cljs.core.get.call(null,inst_18261,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18263 = cljs.core.get.call(null,inst_18261,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_18264 = cljs.core.get.call(null,inst_18261,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18265 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18266 = [inst_18262,inst_18263,toBlock,toTime];
var inst_18267 = cljs.core.PersistentHashMap.fromArrays(inst_18265,inst_18266);
var inst_18268 = fluree.db.operations.send_operation.call(null,inst_18264,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18267);
var state_18270__$1 = state_18270;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18270__$1,inst_18268);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2684__auto__ = null;
var fluree$db$operations$state_machine__2684__auto____0 = (function (){
var statearr_18272 = [null,null,null,null,null,null,null];
(statearr_18272[(0)] = fluree$db$operations$state_machine__2684__auto__);

(statearr_18272[(1)] = (1));

return statearr_18272;
});
var fluree$db$operations$state_machine__2684__auto____1 = (function (state_18270){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_18270);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18273){var ex__2687__auto__ = e18273;
var statearr_18274_18280 = state_18270;
(statearr_18274_18280[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_18270[(4)]))){
var statearr_18275_18281 = state_18270;
(statearr_18275_18281[(1)] = cljs.core.first.call(null,(state_18270[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18282 = state_18270;
state_18270 = G__18282;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2684__auto__ = function(state_18270){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2684__auto____1.call(this,state_18270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2684__auto____0;
fluree$db$operations$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2684__auto____1;
return fluree$db$operations$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18276 = f__2707__auto__.call(null);
(statearr_18276[(6)] = c__2706__auto__);

return statearr_18276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18252){
var G__18253 = cljs.core.first.call(null,seq18252);
var seq18252__$1 = cljs.core.next.call(null,seq18252);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18253,seq18252__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18283 = session;
var map__18283__$1 = cljs.core.__destructure_map.call(null,map__18283);
var network = cljs.core.get.call(null,map__18283__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__18283__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var conn = cljs.core.get.call(null,map__18283__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18285 = arguments.length;
switch (G__18285) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18286 = opts;
var map__18286__$1 = cljs.core.__destructure_map.call(null,map__18286);
var auth = cljs.core.get.call(null,map__18286__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__18286__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsubscribe","unsubscribe",632650147),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null));
});
