// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e22981){var e = e22981;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__22982_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__22982_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__22982_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__22982_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__22983_SHARP_){
return cljs.core.conj.call(null,p1__22983_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__22984_SHARP_){
return cljs.core.conj.call(null,p1__22984_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(2));
if(and__5043__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,key);
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__22989 = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__22989,(0),null);
var _ = cljs.core.nth.call(null,vec__22989,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__22985_SHARP_){
return cljs.core.conj.call(null,p1__22985_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__5043__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__22992 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__22992,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__22992,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__22986_SHARP_){
return cljs.core.conj.call(null,p1__22986_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__22987_SHARP_){
return cljs.core.conj.call(null,p1__22987_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__22988_SHARP_){
return cljs.core.conj.call(null,p1__22988_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
/**
 * Returns an updated list of tuples that only contains tuple indexes from idx.
 *   e.g.:
 *   idx is a list of indexes, eg. [2 0 4]
 *   Thus, the return will be 3-tuples of nth 2, 0, 4 respectively.
 */
fluree.db.query.analytical.transform_tuples_to_idxs = (function fluree$db$query$analytical$transform_tuples_to_idxs(idxs,tuples){
return cljs.core.map.call(null,(function (tuple){
return cljs.core.map.call(null,(function (p1__22995_SHARP_){
return cljs.core.nth.call(null,tuple,p1__22995_SHARP_);
}),idxs);
}),tuples);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
/**
 * Returns index positions of vars within headers.
 *   e.g. if vars were:
 *   ['?e '?name]
 *   and headers were:
 *   ['?email '?name '?x '?e]
 *   The return value would be: [3 1]
 */
fluree.db.query.analytical.get_tuple_indexes = (function fluree$db$query$analytical$get_tuple_indexes(vars,headers){
return cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,headers,var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. ","Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var idxs = fluree.db.query.analytical.get_tuple_indexes.call(null,vars,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
return fluree.db.query.analytical.transform_tuples_to_idxs.call(null,idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5802__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__22998,optional_QMARK_,fuel,max_fuel){
var map__22999 = p__22998;
var map__22999__$1 = cljs.core.__destructure_map.call(null,map__22999);
var res = map__22999__$1;
var vars = cljs.core.get.call(null,map__22999__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23065){
var state_val_23066 = (state_23065[(1)]);
if((state_val_23066 === (7))){
var inst_23054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23055 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_23056 = cljs.core.conj.call(null,inst_23055,clause);
var inst_23057 = [null,inst_23056];
var inst_23058 = (new cljs.core.PersistentVector(null,2,(5),inst_23054,inst_23057,null));
var state_23065__$1 = state_23065;
var statearr_23067_23095 = state_23065__$1;
(statearr_23067_23095[(2)] = inst_23058);

(statearr_23067_23095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (1))){
var state_23065__$1 = state_23065;
var statearr_23068_23096 = state_23065__$1;
(statearr_23068_23096[(2)] = null);

(statearr_23068_23096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (4))){
var inst_23000 = (state_23065[(2)]);
var state_23065__$1 = state_23065;
var statearr_23069_23097 = state_23065__$1;
(statearr_23069_23097[(2)] = inst_23000);

(statearr_23069_23097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (15))){
var inst_23043 = (state_23065[(2)]);
var inst_23044 = fluree.db.util.async.throw_err.call(null,inst_23043);
var inst_23045 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_23044);
var inst_23046 = cljs.core.count.call(null,inst_23045);
var inst_23047 = fluree.db.query.analytical.add_fuel.call(null,inst_23046,fuel,max_fuel);
var inst_23048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23049 = [inst_23044,r];
var inst_23050 = (new cljs.core.PersistentVector(null,2,(5),inst_23048,inst_23049,null));
var state_23065__$1 = (function (){var statearr_23070 = state_23065;
(statearr_23070[(7)] = inst_23047);

return statearr_23070;
})();
var statearr_23071_23098 = state_23065__$1;
(statearr_23071_23098[(2)] = inst_23050);

(statearr_23071_23098[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (13))){
var inst_23009 = (state_23065[(8)]);
var inst_23022 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_23023 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_23022);
var inst_23024 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_23009);
var inst_23025 = cljs.core.apply.call(null,cljs.core.concat,inst_23024);
var inst_23026 = cljs.core.set.call(null,inst_23025);
var inst_23027 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_23023);
var inst_23028 = cljs.core.apply.call(null,cljs.core.concat,inst_23027);
var inst_23029 = cljs.core.into.call(null,inst_23026,inst_23028);
var inst_23030 = (function (){var all_wd = inst_23009;
var optional = inst_23023;
var all_wd_vars = inst_23026;
var all_vars = inst_23029;
return (function (p1__22996_SHARP_){
return all_vars.call(null,p1__22996_SHARP_);
});
})();
var inst_23031 = cljs.core.keys.call(null,vars);
var inst_23032 = cljs.core.map.call(null,inst_23030,inst_23031);
var inst_23033 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_23032);
var inst_23034 = cljs.core.set.call(null,inst_23033);
var inst_23035 = (function (){var all_wd = inst_23009;
var optional = inst_23023;
var all_wd_vars = inst_23026;
var all_vars = inst_23029;
var intersecting_vars = inst_23034;
return (function (p1__22997_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__22997_SHARP_);
});
})();
var inst_23036 = cljs.core.map.call(null,inst_23035,inst_23009);
var inst_23037 = cljs.core.apply.call(null,cljs.core.concat,inst_23036);
var inst_23038 = fluree.db.query.analytical.select_from_tuples.call(null,inst_23037,res);
var inst_23039 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_23009,inst_23034,vars);
var inst_23040 = cljs.core.remove.call(null,inst_23034,inst_23029);
var inst_23041 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_23039,inst_23037,inst_23038,inst_23040,inst_23023);
var state_23065__$1 = state_23065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23065__$1,(15),inst_23041);
} else {
if((state_val_23066 === (6))){
var inst_23010 = (state_23065[(9)]);
var inst_23008 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_23009 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_23008);
var inst_23010__$1 = optional_QMARK_;
var state_23065__$1 = (function (){var statearr_23072 = state_23065;
(statearr_23072[(8)] = inst_23009);

(statearr_23072[(9)] = inst_23010__$1);

return statearr_23072;
})();
if(cljs.core.truth_(inst_23010__$1)){
var statearr_23073_23099 = state_23065__$1;
(statearr_23073_23099[(1)] = (9));

} else {
var statearr_23074_23100 = state_23065__$1;
(statearr_23074_23100[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (3))){
var inst_23063 = (state_23065[(2)]);
var state_23065__$1 = state_23065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23065__$1,inst_23063);
} else {
if((state_val_23066 === (12))){
var inst_23018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23019 = [null,r];
var inst_23020 = (new cljs.core.PersistentVector(null,2,(5),inst_23018,inst_23019,null));
var state_23065__$1 = state_23065;
var statearr_23075_23101 = state_23065__$1;
(statearr_23075_23101[(2)] = inst_23020);

(statearr_23075_23101[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (2))){
var _ = (function (){var statearr_23076 = state_23065;
(statearr_23076[(4)] = cljs.core.cons.call(null,(5),(state_23065[(4)])));

return statearr_23076;
})();
var inst_23006 = (r == null);
var state_23065__$1 = state_23065;
if(cljs.core.truth_(inst_23006)){
var statearr_23077_23102 = state_23065__$1;
(statearr_23077_23102[(1)] = (6));

} else {
var statearr_23078_23103 = state_23065__$1;
(statearr_23078_23103[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (11))){
var inst_23016 = (state_23065[(2)]);
var state_23065__$1 = state_23065;
if(cljs.core.truth_(inst_23016)){
var statearr_23080_23104 = state_23065__$1;
(statearr_23080_23104[(1)] = (12));

} else {
var statearr_23081_23105 = state_23065__$1;
(statearr_23081_23105[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (9))){
var inst_23009 = (state_23065[(8)]);
var inst_23012 = cljs.core.empty_QMARK_.call(null,inst_23009);
var inst_23013 = (!(inst_23012));
var state_23065__$1 = state_23065;
var statearr_23082_23106 = state_23065__$1;
(statearr_23082_23106[(2)] = inst_23013);

(statearr_23082_23106[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (5))){
var _ = (function (){var statearr_23083 = state_23065;
(statearr_23083[(4)] = cljs.core.rest.call(null,(state_23065[(4)])));

return statearr_23083;
})();
var state_23065__$1 = state_23065;
var ex23079 = (state_23065__$1[(2)]);
var statearr_23084_23107 = state_23065__$1;
(statearr_23084_23107[(5)] = ex23079);


if((ex23079 instanceof Error)){
var statearr_23085_23108 = state_23065__$1;
(statearr_23085_23108[(1)] = (4));

(statearr_23085_23108[(5)] = null);

} else {
throw ex23079;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (14))){
var inst_23052 = (state_23065[(2)]);
var state_23065__$1 = state_23065;
var statearr_23086_23109 = state_23065__$1;
(statearr_23086_23109[(2)] = inst_23052);

(statearr_23086_23109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (10))){
var inst_23010 = (state_23065[(9)]);
var state_23065__$1 = state_23065;
var statearr_23087_23110 = state_23065__$1;
(statearr_23087_23110[(2)] = inst_23010);

(statearr_23087_23110[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23066 === (8))){
var inst_23060 = (state_23065[(2)]);
var _ = (function (){var statearr_23088 = state_23065;
(statearr_23088[(4)] = cljs.core.rest.call(null,(state_23065[(4)])));

return statearr_23088;
})();
var state_23065__$1 = state_23065;
var statearr_23089_23111 = state_23065__$1;
(statearr_23089_23111[(2)] = inst_23060);

(statearr_23089_23111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_23090 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23090[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__);

(statearr_23090[(1)] = (1));

return statearr_23090;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1 = (function (state_23065){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_23065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23091){var ex__2687__auto__ = e23091;
var statearr_23092_23112 = state_23065;
(statearr_23092_23112[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_23065[(4)]))){
var statearr_23093_23113 = state_23065;
(statearr_23093_23113[(1)] = cljs.core.first.call(null,(state_23065[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23114 = state_23065;
state_23065 = G__23114;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__ = function(state_23065){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1.call(this,state_23065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23094 = f__2707__auto__.call(null);
(statearr_23094[(6)] = c__2706__auto__);

return statearr_23094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find.call(null,/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__23116 = arguments.length;
switch (G__23116) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23210){
var state_val_23211 = (state_23210[(1)]);
if((state_val_23211 === (7))){
var inst_23123 = (state_23210[(7)]);
var inst_23133 = clojure.string.starts_with_QMARK_.call(null,inst_23123,"$fdb");
var state_23210__$1 = state_23210;
if(inst_23133){
var statearr_23212_23261 = state_23210__$1;
(statearr_23212_23261[(1)] = (9));

} else {
var statearr_23213_23262 = state_23210__$1;
(statearr_23213_23262[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (20))){
var state_23210__$1 = state_23210;
var statearr_23214_23263 = state_23210__$1;
(statearr_23214_23263[(2)] = null);

(statearr_23214_23263[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (27))){
var inst_23173 = (state_23210[(8)]);
var state_23210__$1 = state_23210;
var statearr_23215_23264 = state_23210__$1;
(statearr_23215_23264[(2)] = inst_23173);

(statearr_23215_23264[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (1))){
var state_23210__$1 = state_23210;
var statearr_23216_23265 = state_23210__$1;
(statearr_23216_23265[(2)] = null);

(statearr_23216_23265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (24))){
var inst_23196 = (state_23210[(2)]);
var state_23210__$1 = state_23210;
var statearr_23217_23266 = state_23210__$1;
(statearr_23217_23266[(2)] = inst_23196);

(statearr_23217_23266[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (4))){
var inst_23117 = (state_23210[(2)]);
var state_23210__$1 = state_23210;
var statearr_23218_23267 = state_23210__$1;
(statearr_23218_23267[(2)] = inst_23117);

(statearr_23218_23267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (15))){
var inst_23140 = (state_23210[(9)]);
var inst_23146 = (state_23210[(2)]);
var inst_23147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23148 = cljs.core.PersistentVector.EMPTY;
var inst_23149 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_23150 = cljs.core.into.call(null,inst_23148,inst_23149);
var inst_23151 = [inst_23140,inst_23150];
var inst_23152 = (new cljs.core.PersistentVector(null,2,(5),inst_23147,inst_23151,null));
var state_23210__$1 = (function (){var statearr_23219 = state_23210;
(statearr_23219[(10)] = inst_23146);

return statearr_23219;
})();
var statearr_23220_23268 = state_23210__$1;
(statearr_23220_23268[(2)] = inst_23152);

(statearr_23220_23268[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (21))){
var inst_23199 = (state_23210[(2)]);
var state_23210__$1 = state_23210;
var statearr_23221_23269 = state_23210__$1;
(statearr_23221_23269[(2)] = inst_23199);

(statearr_23221_23269[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (13))){
var inst_23140 = (state_23210[(9)]);
var inst_23143 = (function(){throw inst_23140})();
var state_23210__$1 = state_23210;
var statearr_23222_23270 = state_23210__$1;
(statearr_23222_23270[(2)] = inst_23143);

(statearr_23222_23270[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (22))){
var inst_23162 = (state_23210[(11)]);
var inst_23164 = (state_23210[(12)]);
var inst_23166 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_23162);
var inst_23167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23168 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_23164];
var inst_23169 = (new cljs.core.PersistentVector(null,2,(5),inst_23167,inst_23168,null));
var inst_23170 = cljs.core.get_in.call(null,opts,inst_23169);
var state_23210__$1 = (function (){var statearr_23223 = state_23210;
(statearr_23223[(13)] = inst_23166);

return statearr_23223;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23210__$1,(25),inst_23170);
} else {
if((state_val_23211 === (29))){
var inst_23177 = (state_23210[(2)]);
var inst_23178 = fluree.db.util.async.throw_err.call(null,inst_23177);
var state_23210__$1 = state_23210;
var statearr_23224_23271 = state_23210__$1;
(statearr_23224_23271[(2)] = inst_23178);

(statearr_23224_23271[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (6))){
var inst_23126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23127 = cljs.core.PersistentVector.EMPTY;
var inst_23128 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_23129 = cljs.core.into.call(null,inst_23127,inst_23128);
var inst_23130 = [db,inst_23129];
var inst_23131 = (new cljs.core.PersistentVector(null,2,(5),inst_23126,inst_23130,null));
var state_23210__$1 = state_23210;
var statearr_23225_23272 = state_23210__$1;
(statearr_23225_23272[(2)] = inst_23131);

(statearr_23225_23272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (28))){
var inst_23181 = (state_23210[(2)]);
var inst_23182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23183 = cljs.core.PersistentVector.EMPTY;
var inst_23184 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_23185 = cljs.core.into.call(null,inst_23183,inst_23184);
var inst_23186 = [inst_23181,inst_23185];
var inst_23187 = (new cljs.core.PersistentVector(null,2,(5),inst_23182,inst_23186,null));
var state_23210__$1 = state_23210;
var statearr_23226_23273 = state_23210__$1;
(statearr_23226_23273[(2)] = inst_23187);

(statearr_23226_23273[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (25))){
var inst_23166 = (state_23210[(13)]);
var inst_23172 = (state_23210[(2)]);
var inst_23173 = fluree.db.util.async.throw_err.call(null,inst_23172);
var state_23210__$1 = (function (){var statearr_23227 = state_23210;
(statearr_23227[(8)] = inst_23173);

return statearr_23227;
})();
if(cljs.core.truth_(inst_23166)){
var statearr_23228_23274 = state_23210__$1;
(statearr_23228_23274[(1)] = (26));

} else {
var statearr_23229_23275 = state_23210__$1;
(statearr_23229_23275[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (17))){
var state_23210__$1 = state_23210;
var statearr_23230_23276 = state_23210__$1;
(statearr_23230_23276[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (3))){
var inst_23208 = (state_23210[(2)]);
var state_23210__$1 = state_23210;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23210__$1,inst_23208);
} else {
if((state_val_23211 === (12))){
var inst_23140 = (state_23210[(9)]);
var inst_23139 = (state_23210[(2)]);
var inst_23140__$1 = fluree.db.util.async.throw_err.call(null,inst_23139);
var inst_23141 = fluree.db.util.core.exception_QMARK_.call(null,inst_23140__$1);
var state_23210__$1 = (function (){var statearr_23232 = state_23210;
(statearr_23232[(9)] = inst_23140__$1);

return statearr_23232;
})();
if(inst_23141){
var statearr_23233_23277 = state_23210__$1;
(statearr_23233_23277[(1)] = (13));

} else {
var statearr_23234_23278 = state_23210__$1;
(statearr_23234_23278[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (2))){
var inst_23123 = (state_23210[(7)]);
var _ = (function (){var statearr_23235 = state_23210;
(statearr_23235[(4)] = cljs.core.cons.call(null,(5),(state_23210[(4)])));

return statearr_23235;
})();
var inst_23123__$1 = cljs.core.first.call(null,clause);
var inst_23124 = cljs.core._EQ_.call(null,"$fdb",inst_23123__$1);
var state_23210__$1 = (function (){var statearr_23236 = state_23210;
(statearr_23236[(7)] = inst_23123__$1);

return statearr_23236;
})();
if(inst_23124){
var statearr_23237_23279 = state_23210__$1;
(statearr_23237_23279[(1)] = (6));

} else {
var statearr_23238_23280 = state_23210__$1;
(statearr_23238_23280[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (23))){
var inst_23123 = (state_23210[(7)]);
var inst_23189 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23123)," is not supported in Fluree"].join('');
var inst_23190 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23191 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23192 = cljs.core.PersistentHashMap.fromArrays(inst_23190,inst_23191);
var inst_23193 = cljs.core.ex_info.call(null,inst_23189,inst_23192);
var inst_23194 = (function(){throw inst_23193})();
var state_23210__$1 = state_23210;
var statearr_23239_23281 = state_23210__$1;
(statearr_23239_23281[(2)] = inst_23194);

(statearr_23239_23281[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (19))){
var inst_23164 = (state_23210[(12)]);
var inst_23123 = (state_23210[(7)]);
var inst_23161 = fluree.db.query.analytical.isolate_source_name.call(null,inst_23123);
var inst_23162 = fluree.db.query.analytical.isolate_source_block.call(null,inst_23123);
var inst_23163 = cljs.core.keyword.call(null,inst_23161);
var inst_23164__$1 = cljs.core.get.call(null,prefixes,inst_23163);
var state_23210__$1 = (function (){var statearr_23240 = state_23210;
(statearr_23240[(11)] = inst_23162);

(statearr_23240[(12)] = inst_23164__$1);

return statearr_23240;
})();
if(cljs.core.truth_(inst_23164__$1)){
var statearr_23241_23282 = state_23210__$1;
(statearr_23241_23282[(1)] = (22));

} else {
var statearr_23242_23283 = state_23210__$1;
(statearr_23242_23283[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (11))){
var inst_23203 = (state_23210[(2)]);
var state_23210__$1 = state_23210;
var statearr_23244_23284 = state_23210__$1;
(statearr_23244_23284[(2)] = inst_23203);

(statearr_23244_23284[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (9))){
var inst_23123 = (state_23210[(7)]);
var inst_23135 = cljs.core.subs.call(null,inst_23123,(4));
var inst_23136 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_23135);
var inst_23137 = fluree.db.time_travel.as_of_block.call(null,db,inst_23136);
var state_23210__$1 = state_23210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23210__$1,(12),inst_23137);
} else {
if((state_val_23211 === (5))){
var _ = (function (){var statearr_23245 = state_23210;
(statearr_23245[(4)] = cljs.core.rest.call(null,(state_23210[(4)])));

return statearr_23245;
})();
var state_23210__$1 = state_23210;
var ex23243 = (state_23210__$1[(2)]);
var statearr_23246_23285 = state_23210__$1;
(statearr_23246_23285[(5)] = ex23243);


if((ex23243 instanceof Error)){
var statearr_23247_23286 = state_23210__$1;
(statearr_23247_23286[(1)] = (4));

(statearr_23247_23286[(5)] = null);

} else {
throw ex23243;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (14))){
var state_23210__$1 = state_23210;
var statearr_23248_23287 = state_23210__$1;
(statearr_23248_23287[(2)] = null);

(statearr_23248_23287[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (26))){
var inst_23166 = (state_23210[(13)]);
var inst_23173 = (state_23210[(8)]);
var inst_23175 = fluree.db.time_travel.as_of_block.call(null,inst_23173,inst_23166);
var state_23210__$1 = state_23210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23210__$1,(29),inst_23175);
} else {
if((state_val_23211 === (16))){
var inst_23156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23157 = ["$wd",clause];
var inst_23158 = (new cljs.core.PersistentVector(null,2,(5),inst_23156,inst_23157,null));
var state_23210__$1 = state_23210;
var statearr_23249_23288 = state_23210__$1;
(statearr_23249_23288[(2)] = inst_23158);

(statearr_23249_23288[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (10))){
var inst_23123 = (state_23210[(7)]);
var inst_23154 = cljs.core._EQ_.call(null,"$wd",inst_23123);
var state_23210__$1 = state_23210;
if(inst_23154){
var statearr_23250_23289 = state_23210__$1;
(statearr_23250_23289[(1)] = (16));

} else {
var statearr_23251_23290 = state_23210__$1;
(statearr_23251_23290[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (18))){
var inst_23201 = (state_23210[(2)]);
var state_23210__$1 = state_23210;
var statearr_23252_23291 = state_23210__$1;
(statearr_23252_23291[(2)] = inst_23201);

(statearr_23252_23291[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23211 === (8))){
var inst_23205 = (state_23210[(2)]);
var _ = (function (){var statearr_23253 = state_23210;
(statearr_23253[(4)] = cljs.core.rest.call(null,(state_23210[(4)])));

return statearr_23253;
})();
var state_23210__$1 = state_23210;
var statearr_23254_23292 = state_23210__$1;
(statearr_23254_23292[(2)] = inst_23205);

(statearr_23254_23292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2684__auto__ = null;
var fluree$db$query$analytical$state_machine__2684__auto____0 = (function (){
var statearr_23255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23255[(0)] = fluree$db$query$analytical$state_machine__2684__auto__);

(statearr_23255[(1)] = (1));

return statearr_23255;
});
var fluree$db$query$analytical$state_machine__2684__auto____1 = (function (state_23210){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_23210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23256){var ex__2687__auto__ = e23256;
var statearr_23257_23293 = state_23210;
(statearr_23257_23293[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_23210[(4)]))){
var statearr_23258_23294 = state_23210;
(statearr_23258_23294[(1)] = cljs.core.first.call(null,(state_23210[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23295 = state_23210;
state_23210 = G__23295;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2684__auto__ = function(state_23210){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2684__auto____1.call(this,state_23210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2684__auto____0;
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2684__auto____1;
return fluree$db$query$analytical$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23259 = f__2707__auto__.call(null);
(statearr_23259[(6)] = c__2706__auto__);

return statearr_23259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__23296){
var vec__23297 = p__23296;
var sub = cljs.core.nth.call(null,vec__23297,(0),null);
var obj = cljs.core.nth.call(null,vec__23297,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__23300_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__23300_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__23304 = subjects;
var vec__23305 = G__23304;
var seq__23306 = cljs.core.seq.call(null,vec__23305);
var first__23307 = cljs.core.first.call(null,seq__23306);
var seq__23306__$1 = cljs.core.next.call(null,seq__23306);
var subject = first__23307;
var r = seq__23306__$1;
var acc = expanded_map;
var G__23304__$1 = G__23304;
var acc__$1 = acc;
while(true){
var vec__23311 = G__23304__$1;
var seq__23312 = cljs.core.seq.call(null,vec__23311);
var first__23313 = cljs.core.first.call(null,seq__23312);
var seq__23312__$1 = cljs.core.next.call(null,seq__23312);
var subject__$1 = first__23313;
var r__$1 = seq__23312__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__23314 = r__$1;
var G__23315 = acc__$2;
G__23304__$1 = G__23314;
acc__$1 = G__23315;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__23304__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__23311,seq__23312,first__23313,seq__23312__$1,subject__$1,r__$1,acc__$2,G__23304,vec__23305,seq__23306,first__23307,seq__23306__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__23304__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__23311,seq__23312,first__23313,seq__23312__$1,subject__$1,r__$1,acc__$2,G__23304,vec__23305,seq__23306,first__23307,seq__23306__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__23304__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__23311,seq__23312,first__23313,seq__23312__$1,subject__$1,r__$1,acc__$2,G__23304,vec__23305,seq__23306,first__23307,seq__23306__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__23304__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__23311,seq__23312,first__23313,seq__23312__$1,subject__$1,r__$1,acc__$2,G__23304,vec__23305,seq__23306,first__23307,seq__23306__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__23304__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__23311,seq__23312,first__23313,seq__23312__$1,subject__$1,r__$1,acc__$2,G__23304,vec__23305,seq__23306,first__23307,seq__23306__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__23304__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__23311,seq__23312,first__23313,seq__23312__$1,subject__$1,r__$1,acc__$2,G__23304,vec__23305,seq__23306,first__23307,seq__23306__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__23316 = r__$1;
var G__23317 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__23304__$1 = G__23316;
acc__$1 = G__23317;
continue;
} else {
var G__23318 = subjects;
var G__23319 = acc_STAR_;
G__23304__$1 = G__23318;
acc__$1 = G__23319;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__23320_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__23320_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23411){
var state_val_23412 = (state_23411[(1)]);
if((state_val_23412 === (7))){
var state_23411__$1 = state_23411;
var statearr_23413_23459 = state_23411__$1;
(statearr_23413_23459[(2)] = (100));

(statearr_23413_23459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (20))){
var inst_23360 = (state_23411[(7)]);
var state_23411__$1 = state_23411;
var statearr_23414_23460 = state_23411__$1;
(statearr_23414_23460[(2)] = inst_23360);

(statearr_23414_23460[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (1))){
var state_23411__$1 = state_23411;
var statearr_23415_23461 = state_23411__$1;
(statearr_23415_23461[(2)] = null);

(statearr_23415_23461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (24))){
var inst_23332 = (state_23411[(8)]);
var inst_23397 = (state_23411[(9)]);
var inst_23398 = (state_23411[(10)]);
var inst_23399 = (state_23411[(11)]);
var inst_23402 = (function (){var max_depth = inst_23332;
var recur_map__$1 = inst_23398;
var subjects = inst_23397;
var tuples = inst_23399;
return (function (p1__23321_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__23321_SHARP_)],null));
});
})();
var inst_23403 = cljs.core.map.call(null,inst_23402,inst_23399);
var inst_23404 = cljs.core.distinct.call(null,inst_23403);
var state_23411__$1 = state_23411;
var statearr_23416_23462 = state_23411__$1;
(statearr_23416_23462[(2)] = inst_23404);

(statearr_23416_23462[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (4))){
var inst_23322 = (state_23411[(2)]);
var state_23411__$1 = state_23411;
var statearr_23417_23463 = state_23411__$1;
(statearr_23417_23463[(2)] = inst_23322);

(statearr_23417_23463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (15))){
var inst_23345 = (state_23411[(12)]);
var inst_23356 = cljs.core.PersistentVector.EMPTY;
var inst_23357 = cljs.core.seq.call(null,inst_23345);
var inst_23358 = cljs.core.first.call(null,inst_23357);
var inst_23359 = cljs.core.next.call(null,inst_23357);
var inst_23360 = inst_23356;
var inst_23361 = inst_23345;
var state_23411__$1 = (function (){var statearr_23418 = state_23411;
(statearr_23418[(13)] = inst_23359);

(statearr_23418[(14)] = inst_23358);

(statearr_23418[(15)] = inst_23361);

(statearr_23418[(7)] = inst_23360);

return statearr_23418;
})();
var statearr_23419_23464 = state_23411__$1;
(statearr_23419_23464[(2)] = null);

(statearr_23419_23464[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (21))){
var inst_23381 = (state_23411[(2)]);
var state_23411__$1 = state_23411;
var statearr_23420_23465 = state_23411__$1;
(statearr_23420_23465[(2)] = inst_23381);

(statearr_23420_23465[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (13))){
var inst_23394 = (state_23411[(2)]);
var state_23411__$1 = state_23411;
var statearr_23421_23466 = state_23411__$1;
(statearr_23421_23466[(2)] = inst_23394);

(statearr_23421_23466[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (22))){
var inst_23368 = (state_23411[(16)]);
var inst_23360 = (state_23411[(7)]);
var inst_23375 = (state_23411[(2)]);
var inst_23376 = fluree.db.util.async.throw_err.call(null,inst_23375);
var inst_23377 = cljs.core.concat.call(null,inst_23360,inst_23376);
var inst_23360__$1 = inst_23377;
var inst_23361 = inst_23368;
var state_23411__$1 = (function (){var statearr_23422 = state_23411;
(statearr_23422[(15)] = inst_23361);

(statearr_23422[(7)] = inst_23360__$1);

return statearr_23422;
})();
var statearr_23423_23467 = state_23411__$1;
(statearr_23423_23467[(2)] = null);

(statearr_23423_23467[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (6))){
var inst_23328 = (state_23411[(17)]);
var state_23411__$1 = state_23411;
var statearr_23424_23468 = state_23411__$1;
(statearr_23424_23468[(2)] = inst_23328);

(statearr_23424_23468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (25))){
var inst_23406 = (state_23411[(2)]);
var _ = (function (){var statearr_23425 = state_23411;
(statearr_23425[(4)] = cljs.core.rest.call(null,(state_23411[(4)])));

return statearr_23425;
})();
var state_23411__$1 = state_23411;
var statearr_23426_23469 = state_23411__$1;
(statearr_23426_23469[(2)] = inst_23406);

(statearr_23426_23469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (17))){
var inst_23367 = (state_23411[(18)]);
var inst_23361 = (state_23411[(15)]);
var inst_23366 = cljs.core.seq.call(null,inst_23361);
var inst_23367__$1 = cljs.core.first.call(null,inst_23366);
var inst_23368 = cljs.core.next.call(null,inst_23366);
var state_23411__$1 = (function (){var statearr_23427 = state_23411;
(statearr_23427[(18)] = inst_23367__$1);

(statearr_23427[(16)] = inst_23368);

return statearr_23427;
})();
if(cljs.core.truth_(inst_23367__$1)){
var statearr_23428_23470 = state_23411__$1;
(statearr_23428_23470[(1)] = (19));

} else {
var statearr_23429_23471 = state_23411__$1;
(statearr_23429_23471[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (3))){
var inst_23409 = (state_23411[(2)]);
var state_23411__$1 = state_23411;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23411__$1,inst_23409);
} else {
if((state_val_23412 === (12))){
var inst_23334 = (state_23411[(19)]);
var inst_23345 = (state_23411[(12)]);
var inst_23340 = cljs.core.vals.call(null,inst_23334);
var inst_23341 = cljs.core.flatten.call(null,inst_23340);
var inst_23342 = cljs.core.set.call(null,inst_23341);
var inst_23343 = cljs.core.keys.call(null,inst_23334);
var inst_23344 = cljs.core.set.call(null,inst_23343);
var inst_23345__$1 = clojure.set.difference.call(null,inst_23342,inst_23344);
var inst_23346 = cljs.core.empty_QMARK_.call(null,inst_23345__$1);
var state_23411__$1 = (function (){var statearr_23430 = state_23411;
(statearr_23430[(12)] = inst_23345__$1);

return statearr_23430;
})();
if(inst_23346){
var statearr_23431_23472 = state_23411__$1;
(statearr_23431_23472[(1)] = (14));

} else {
var statearr_23432_23473 = state_23411__$1;
(statearr_23432_23473[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (2))){
var inst_23328 = (state_23411[(17)]);
var _ = (function (){var statearr_23433 = state_23411;
(statearr_23433[(4)] = cljs.core.cons.call(null,(5),(state_23411[(4)])));

return statearr_23433;
})();
var inst_23328__$1 = depth;
var state_23411__$1 = (function (){var statearr_23434 = state_23411;
(statearr_23434[(17)] = inst_23328__$1);

return statearr_23434;
})();
if(cljs.core.truth_(inst_23328__$1)){
var statearr_23435_23474 = state_23411__$1;
(statearr_23435_23474[(1)] = (6));

} else {
var statearr_23436_23475 = state_23411__$1;
(statearr_23436_23475[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (23))){
var inst_23399 = (state_23411[(11)]);
var state_23411__$1 = state_23411;
var statearr_23437_23476 = state_23411__$1;
(statearr_23437_23476[(2)] = inst_23399);

(statearr_23437_23476[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (19))){
var inst_23367 = (state_23411[(18)]);
var inst_23370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23371 = [inst_23367,predicate];
var inst_23372 = (new cljs.core.PersistentVector(null,2,(5),inst_23370,inst_23371,null));
var inst_23373 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23372);
var state_23411__$1 = state_23411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23411__$1,(22),inst_23373);
} else {
if((state_val_23412 === (11))){
var inst_23334 = (state_23411[(19)]);
var state_23411__$1 = state_23411;
var statearr_23439_23477 = state_23411__$1;
(statearr_23439_23477[(2)] = inst_23334);

(statearr_23439_23477[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (9))){
var inst_23335 = (state_23411[(20)]);
var inst_23332 = (state_23411[(8)]);
var inst_23337 = (inst_23335 >= inst_23332);
var state_23411__$1 = state_23411;
if(cljs.core.truth_(inst_23337)){
var statearr_23440_23478 = state_23411__$1;
(statearr_23440_23478[(1)] = (11));

} else {
var statearr_23441_23479 = state_23411__$1;
(statearr_23441_23479[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (5))){
var _ = (function (){var statearr_23442 = state_23411;
(statearr_23442[(4)] = cljs.core.rest.call(null,(state_23411[(4)])));

return statearr_23442;
})();
var state_23411__$1 = state_23411;
var ex23438 = (state_23411__$1[(2)]);
var statearr_23443_23480 = state_23411__$1;
(statearr_23443_23480[(5)] = ex23438);


if((ex23438 instanceof Error)){
var statearr_23444_23481 = state_23411__$1;
(statearr_23444_23481[(1)] = (4));

(statearr_23444_23481[(5)] = null);

} else {
throw ex23438;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (14))){
var inst_23334 = (state_23411[(19)]);
var state_23411__$1 = state_23411;
var statearr_23445_23482 = state_23411__$1;
(statearr_23445_23482[(2)] = inst_23334);

(statearr_23445_23482[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (16))){
var inst_23392 = (state_23411[(2)]);
var state_23411__$1 = state_23411;
var statearr_23446_23483 = state_23411__$1;
(statearr_23446_23483[(2)] = inst_23392);

(statearr_23446_23483[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (10))){
var inst_23397 = (state_23411[(9)]);
var inst_23398 = (state_23411[(10)]);
var inst_23396 = (state_23411[(2)]);
var inst_23397__$1 = cljs.core.keys.call(null,inst_23396);
var inst_23398__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_23397__$1,inst_23396);
var inst_23399 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_23397__$1,inst_23398__$1);
var state_23411__$1 = (function (){var statearr_23447 = state_23411;
(statearr_23447[(9)] = inst_23397__$1);

(statearr_23447[(10)] = inst_23398__$1);

(statearr_23447[(11)] = inst_23399);

return statearr_23447;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_23448_23484 = state_23411__$1;
(statearr_23448_23484[(1)] = (23));

} else {
var statearr_23449_23485 = state_23411__$1;
(statearr_23449_23485[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (18))){
var inst_23334 = (state_23411[(19)]);
var inst_23335 = (state_23411[(20)]);
var inst_23383 = (state_23411[(2)]);
var inst_23384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23385 = [(0),(2)];
var inst_23386 = (new cljs.core.PersistentVector(null,2,(5),inst_23384,inst_23385,null));
var inst_23387 = fluree.db.query.analytical.transform_tuples_to_idxs.call(null,inst_23386,inst_23383);
var inst_23388 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_23334,inst_23387);
var inst_23389 = (inst_23335 + (1));
var inst_23334__$1 = inst_23388;
var inst_23335__$1 = inst_23389;
var state_23411__$1 = (function (){var statearr_23450 = state_23411;
(statearr_23450[(19)] = inst_23334__$1);

(statearr_23450[(20)] = inst_23335__$1);

return statearr_23450;
})();
var statearr_23451_23486 = state_23411__$1;
(statearr_23451_23486[(2)] = null);

(statearr_23451_23486[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23412 === (8))){
var inst_23332 = (state_23411[(2)]);
var inst_23333 = recur_map;
var inst_23334 = inst_23333;
var inst_23335 = (1);
var state_23411__$1 = (function (){var statearr_23452 = state_23411;
(statearr_23452[(19)] = inst_23334);

(statearr_23452[(20)] = inst_23335);

(statearr_23452[(8)] = inst_23332);

return statearr_23452;
})();
var statearr_23453_23487 = state_23411__$1;
(statearr_23453_23487[(2)] = null);

(statearr_23453_23487[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0 = (function (){
var statearr_23454 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23454[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__);

(statearr_23454[(1)] = (1));

return statearr_23454;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1 = (function (state_23411){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_23411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23455){var ex__2687__auto__ = e23455;
var statearr_23456_23488 = state_23411;
(statearr_23456_23488[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_23411[(4)]))){
var statearr_23457_23489 = state_23411;
(statearr_23457_23489[(1)] = cljs.core.first.call(null,(state_23411[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23490 = state_23411;
state_23411 = G__23490;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__ = function(state_23411){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1.call(this,state_23411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23458 = f__2707__auto__.call(null);
(statearr_23458[(6)] = c__2706__auto__);

return statearr_23458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__23491,clause,fuel,max_fuel,opts){
var map__23492 = p__23491;
var map__23492__$1 = cljs.core.__destructure_map.call(null,map__23492);
var res = map__23492__$1;
var headers = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23609){
var state_val_23610 = (state_23609[(1)]);
if((state_val_23610 === (7))){
var inst_23509 = (state_23609[(7)]);
var state_23609__$1 = state_23609;
var statearr_23611_23669 = state_23609__$1;
(statearr_23611_23669[(2)] = inst_23509);

(statearr_23611_23669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (20))){
var inst_23519 = (state_23609[(8)]);
var inst_23562 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23519)].join('');
var inst_23563 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23564 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23565 = cljs.core.PersistentHashMap.fromArrays(inst_23563,inst_23564);
var inst_23566 = cljs.core.ex_info.call(null,inst_23562,inst_23565);
var inst_23567 = (function(){throw inst_23566})();
var state_23609__$1 = state_23609;
var statearr_23612_23670 = state_23609__$1;
(statearr_23612_23670[(2)] = inst_23567);

(statearr_23612_23670[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (27))){
var inst_23591 = (state_23609[(2)]);
var state_23609__$1 = state_23609;
var statearr_23613_23671 = state_23609__$1;
(statearr_23613_23671[(2)] = inst_23591);

(statearr_23613_23671[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (1))){
var state_23609__$1 = state_23609;
var statearr_23614_23672 = state_23609__$1;
(statearr_23614_23672[(2)] = null);

(statearr_23614_23672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (24))){
var inst_23545 = (state_23609[(9)]);
var inst_23510 = (state_23609[(10)]);
var inst_23546 = (state_23609[(11)]);
var inst_23593 = (state_23609[(2)]);
var inst_23594 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_23546,inst_23593,inst_23510,inst_23545);
var state_23609__$1 = state_23609;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23609__$1,(31),inst_23594);
} else {
if((state_val_23610 === (4))){
var inst_23493 = (state_23609[(2)]);
var state_23609__$1 = state_23609;
var statearr_23615_23673 = state_23609__$1;
(statearr_23615_23673[(2)] = inst_23493);

(statearr_23615_23673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (15))){
var inst_23507 = (state_23609[(12)]);
var inst_23600 = (state_23609[(2)]);
var inst_23601 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_23602 = cljs.core.keys.call(null,inst_23507);
var inst_23603 = [inst_23602,vars,inst_23600];
var inst_23604 = cljs.core.PersistentHashMap.fromArrays(inst_23601,inst_23603);
var _ = (function (){var statearr_23616 = state_23609;
(statearr_23616[(4)] = cljs.core.rest.call(null,(state_23609[(4)])));

return statearr_23616;
})();
var state_23609__$1 = state_23609;
var statearr_23617_23674 = state_23609__$1;
(statearr_23617_23674[(2)] = inst_23604);

(statearr_23617_23674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (21))){
var inst_23545 = (state_23609[(9)]);
var inst_23569 = (state_23609[(2)]);
var state_23609__$1 = (function (){var statearr_23618 = state_23609;
(statearr_23618[(13)] = inst_23569);

return statearr_23618;
})();
if(cljs.core.truth_(inst_23545)){
var statearr_23619_23675 = state_23609__$1;
(statearr_23619_23675[(1)] = (22));

} else {
var statearr_23620_23676 = state_23609__$1;
(statearr_23620_23676[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (31))){
var inst_23596 = (state_23609[(2)]);
var inst_23597 = fluree.db.util.async.throw_err.call(null,inst_23596);
var state_23609__$1 = state_23609;
var statearr_23621_23677 = state_23609__$1;
(statearr_23621_23677[(2)] = inst_23597);

(statearr_23621_23677[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (13))){
var inst_23519 = (state_23609[(8)]);
var inst_23546 = (state_23609[(11)]);
var inst_23543 = cljs.core.first.call(null,inst_23519);
var inst_23544 = cljs.core.first.call(null,clause);
var inst_23545 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_23544);
var inst_23546__$1 = cljs.core.nth.call(null,inst_23519,(1));
var inst_23547 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_23546__$1);
var state_23609__$1 = (function (){var statearr_23622 = state_23609;
(statearr_23622[(14)] = inst_23543);

(statearr_23622[(9)] = inst_23545);

(statearr_23622[(11)] = inst_23546__$1);

return statearr_23622;
})();
if(cljs.core.truth_(inst_23547)){
var statearr_23623_23678 = state_23609__$1;
(statearr_23623_23678[(1)] = (16));

} else {
var statearr_23624_23679 = state_23609__$1;
(statearr_23624_23679[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (22))){
var inst_23541 = (state_23609[(15)]);
var inst_23571 = cljs.core.PersistentHashMap.EMPTY;
var inst_23572 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_23571,inst_23541);
var state_23609__$1 = state_23609;
var statearr_23625_23680 = state_23609__$1;
(statearr_23625_23680[(2)] = inst_23572);

(statearr_23625_23680[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (29))){
var state_23609__$1 = state_23609;
var statearr_23626_23681 = state_23609__$1;
(statearr_23626_23681[(2)] = null);

(statearr_23626_23681[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (6))){
var inst_23521 = (state_23609[(16)]);
var state_23609__$1 = state_23609;
var statearr_23627_23682 = state_23609__$1;
(statearr_23627_23682[(2)] = inst_23521);

(statearr_23627_23682[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (28))){
var inst_23537 = (state_23609[(17)]);
var inst_23541 = (state_23609[(15)]);
var inst_23582 = cljs.core.PersistentHashMap.EMPTY;
var inst_23583 = cljs.core.first.call(null,inst_23537);
var inst_23584 = cljs.core.first.call(null,inst_23583);
var inst_23585 = cljs.core.flatten.call(null,inst_23541);
var inst_23586 = cljs.core.assoc.call(null,inst_23582,inst_23584,inst_23585);
var state_23609__$1 = state_23609;
var statearr_23628_23683 = state_23609__$1;
(statearr_23628_23683[(2)] = inst_23586);

(statearr_23628_23683[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (25))){
var inst_23543 = (state_23609[(14)]);
var inst_23541 = (state_23609[(15)]);
var inst_23576 = cljs.core.PersistentHashMap.EMPTY;
var inst_23577 = cljs.core.flatten.call(null,inst_23541);
var inst_23578 = cljs.core.assoc.call(null,inst_23576,inst_23543,inst_23577);
var state_23609__$1 = state_23609;
var statearr_23629_23684 = state_23609__$1;
(statearr_23629_23684[(2)] = inst_23578);

(statearr_23629_23684[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (17))){
var state_23609__$1 = state_23609;
var statearr_23630_23685 = state_23609__$1;
(statearr_23630_23685[(2)] = null);

(statearr_23630_23685[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (3))){
var inst_23607 = (state_23609[(2)]);
var state_23609__$1 = state_23609;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23609__$1,inst_23607);
} else {
if((state_val_23610 === (12))){
var inst_23537 = (state_23609[(17)]);
var inst_23507 = (state_23609[(12)]);
var inst_23510 = (state_23609[(10)]);
var inst_23537__$1 = (state_23609[(2)]);
var inst_23538 = cljs.core.count.call(null,inst_23537__$1);
var inst_23539 = fluree.db.query.analytical.add_fuel.call(null,inst_23538,fuel,max_fuel);
var inst_23540 = cljs.core.vals.call(null,inst_23507);
var inst_23541 = fluree.db.query.analytical.transform_tuples_to_idxs.call(null,inst_23540,inst_23537__$1);
var state_23609__$1 = (function (){var statearr_23631 = state_23609;
(statearr_23631[(17)] = inst_23537__$1);

(statearr_23631[(15)] = inst_23541);

(statearr_23631[(18)] = inst_23539);

return statearr_23631;
})();
if(cljs.core.truth_(inst_23510)){
var statearr_23632_23686 = state_23609__$1;
(statearr_23632_23686[(1)] = (13));

} else {
var statearr_23633_23687 = state_23609__$1;
(statearr_23633_23687[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (2))){
var inst_23507 = (state_23609[(12)]);
var inst_23509 = (state_23609[(7)]);
var inst_23510 = (state_23609[(10)]);
var inst_23521 = (state_23609[(16)]);
var _ = (function (){var statearr_23634 = state_23609;
(statearr_23634[(4)] = cljs.core.cons.call(null,(5),(state_23609[(4)])));

return statearr_23634;
})();
var inst_23503 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_23504 = cljs.core.__destructure_map.call(null,inst_23503);
var inst_23505 = cljs.core.get.call(null,inst_23504,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_23506 = cljs.core.get.call(null,inst_23504,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_23507__$1 = cljs.core.get.call(null,inst_23504,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_23508 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_23509__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_23505);
var inst_23510__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23505);
var inst_23512 = (function (){var map__23499 = inst_23504;
var search_opts = inst_23505;
var search = inst_23506;
var rel = inst_23507__$1;
var common_keys = inst_23508;
var object_fn = inst_23509__$1;
var recur_depth = inst_23510__$1;
return (function (p__23511,common_key){
var vec__23635 = p__23511;
var acc = cljs.core.nth.call(null,vec__23635,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__23635,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__23638 = cljs.core._EQ_;
var expr__23639 = idx_of;
if(cljs.core.truth_(pred__23638.call(null,(0),expr__23639))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__23638.call(null,(1),expr__23639))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__23638.call(null,(2),expr__23639))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__23639)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.transform_tuples_to_idxs.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_23513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23514 = cljs.core.PersistentHashMap.EMPTY;
var inst_23515 = [inst_23514,inst_23506];
var inst_23516 = (new cljs.core.PersistentVector(null,2,(5),inst_23513,inst_23515,null));
var inst_23517 = cljs.core.reduce.call(null,inst_23512,inst_23516,inst_23508);
var inst_23518 = cljs.core.nth.call(null,inst_23517,(0),null);
var inst_23519 = cljs.core.nth.call(null,inst_23517,(1),null);
var inst_23520 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_23521__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_23518);
var state_23609__$1 = (function (){var statearr_23641 = state_23609;
(statearr_23641[(19)] = inst_23520);

(statearr_23641[(12)] = inst_23507__$1);

(statearr_23641[(7)] = inst_23509__$1);

(statearr_23641[(8)] = inst_23519);

(statearr_23641[(10)] = inst_23510__$1);

(statearr_23641[(16)] = inst_23521__$1);

return statearr_23641;
})();
if(cljs.core.truth_(inst_23521__$1)){
var statearr_23642_23688 = state_23609__$1;
(statearr_23642_23688[(1)] = (6));

} else {
var statearr_23643_23689 = state_23609__$1;
(statearr_23643_23689[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (23))){
var inst_23543 = (state_23609[(14)]);
var inst_23574 = typeof inst_23543 === 'number';
var state_23609__$1 = state_23609;
if(cljs.core.truth_(inst_23574)){
var statearr_23644_23690 = state_23609__$1;
(statearr_23644_23690[(1)] = (25));

} else {
var statearr_23645_23691 = state_23609__$1;
(statearr_23645_23691[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (19))){
var state_23609__$1 = state_23609;
var statearr_23646_23692 = state_23609__$1;
(statearr_23646_23692[(2)] = null);

(statearr_23646_23692[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (11))){
var inst_23531 = (state_23609[(20)]);
var state_23609__$1 = state_23609;
var statearr_23648_23693 = state_23609__$1;
(statearr_23648_23693[(2)] = inst_23531);

(statearr_23648_23693[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (9))){
var inst_23530 = (state_23609[(2)]);
var inst_23531 = fluree.db.util.async.throw_err.call(null,inst_23530);
var inst_23532 = new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877).cljs$core$IFn$_invoke$arity$1(opts);
var state_23609__$1 = (function (){var statearr_23649 = state_23609;
(statearr_23649[(20)] = inst_23531);

return statearr_23649;
})();
if(cljs.core.truth_(inst_23532)){
var statearr_23650_23694 = state_23609__$1;
(statearr_23650_23694[(1)] = (10));

} else {
var statearr_23651_23695 = state_23609__$1;
(statearr_23651_23695[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (5))){
var _ = (function (){var statearr_23652 = state_23609;
(statearr_23652[(4)] = cljs.core.rest.call(null,(state_23609[(4)])));

return statearr_23652;
})();
var state_23609__$1 = state_23609;
var ex23647 = (state_23609__$1[(2)]);
var statearr_23653_23696 = state_23609__$1;
(statearr_23653_23696[(5)] = ex23647);


if((ex23647 instanceof Error)){
var statearr_23654_23697 = state_23609__$1;
(statearr_23654_23697[(1)] = (4));

(statearr_23654_23697[(5)] = null);

} else {
throw ex23647;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (14))){
var inst_23541 = (state_23609[(15)]);
var state_23609__$1 = state_23609;
var statearr_23655_23698 = state_23609__$1;
(statearr_23655_23698[(2)] = inst_23541);

(statearr_23655_23698[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (26))){
var inst_23543 = (state_23609[(14)]);
var inst_23580 = cljs.core.coll_QMARK_.call(null,inst_23543);
var state_23609__$1 = state_23609;
if(inst_23580){
var statearr_23656_23699 = state_23609__$1;
(statearr_23656_23699[(1)] = (28));

} else {
var statearr_23657_23700 = state_23609__$1;
(statearr_23657_23700[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (16))){
var inst_23519 = (state_23609[(8)]);
var inst_23549 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23519)].join('');
var inst_23550 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23551 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23552 = cljs.core.PersistentHashMap.fromArrays(inst_23550,inst_23551);
var inst_23553 = cljs.core.ex_info.call(null,inst_23549,inst_23552);
var inst_23554 = (function(){throw inst_23553})();
var state_23609__$1 = state_23609;
var statearr_23658_23701 = state_23609__$1;
(statearr_23658_23701[(2)] = inst_23554);

(statearr_23658_23701[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (30))){
var inst_23589 = (state_23609[(2)]);
var state_23609__$1 = state_23609;
var statearr_23659_23702 = state_23609__$1;
(statearr_23659_23702[(2)] = inst_23589);

(statearr_23659_23702[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (10))){
var inst_23531 = (state_23609[(20)]);
var inst_23534 = fluree.db.util.json.parse_json_flakes.call(null,db,inst_23531);
var state_23609__$1 = state_23609;
var statearr_23660_23703 = state_23609__$1;
(statearr_23660_23703[(2)] = inst_23534);

(statearr_23660_23703[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (18))){
var inst_23557 = (state_23609[(2)]);
var inst_23558 = cljs.core.nth.call(null,clause,(2));
var inst_23559 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_23558);
var state_23609__$1 = (function (){var statearr_23661 = state_23609;
(statearr_23661[(21)] = inst_23557);

return statearr_23661;
})();
if(cljs.core.truth_(inst_23559)){
var statearr_23662_23704 = state_23609__$1;
(statearr_23662_23704[(1)] = (19));

} else {
var statearr_23663_23705 = state_23609__$1;
(statearr_23663_23705[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23610 === (8))){
var inst_23520 = (state_23609[(19)]);
var inst_23519 = (state_23609[(8)]);
var inst_23525 = (state_23609[(2)]);
var inst_23526 = [inst_23525];
var inst_23527 = cljs.core.PersistentHashMap.fromArrays(inst_23520,inst_23526);
var inst_23528 = fluree.db.query.range.search.call(null,db,inst_23519,inst_23527);
var state_23609__$1 = state_23609;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23609__$1,(9),inst_23528);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_23664 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23664[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__);

(statearr_23664[(1)] = (1));

return statearr_23664;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1 = (function (state_23609){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_23609);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23665){var ex__2687__auto__ = e23665;
var statearr_23666_23706 = state_23609;
(statearr_23666_23706[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_23609[(4)]))){
var statearr_23667_23707 = state_23609;
(statearr_23667_23707[(1)] = cljs.core.first.call(null,(state_23609[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23708 = state_23609;
state_23609 = G__23708;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__ = function(state_23609){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1.call(this,state_23609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23668 = f__2707__auto__.call(null);
(statearr_23668[(6)] = c__2706__auto__);

return statearr_23668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__23709,res,clause){
var map__23710 = p__23709;
var map__23710__$1 = cljs.core.__destructure_map.call(null,map__23710);
var db = map__23710__$1;
var conn = cljs.core.get.call(null,map__23710__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__23710__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__23710__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23824){
var state_val_23825 = (state_23824[(1)]);
if((state_val_23825 === (7))){
var inst_23719 = (state_23824[(7)]);
var state_23824__$1 = state_23824;
var statearr_23826_23871 = state_23824__$1;
(statearr_23826_23871[(2)] = inst_23719);

(statearr_23826_23871[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (20))){
var inst_23756 = (state_23824[(8)]);
var inst_23755 = (state_23824[(9)]);
var inst_23721 = (state_23824[(10)]);
var inst_23753 = (state_23824[(11)]);
var inst_23719 = (state_23824[(7)]);
var inst_23771 = (state_23824[(2)]);
var inst_23772 = (function (){var subject_var = inst_23719;
var object_var = inst_23721;
var partition = inst_23753;
var max_sid = inst_23755;
var min_sid = inst_23756;
var flakes = inst_23771;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_23773 = cljs.core.map.call(null,inst_23772);
var inst_23774 = cljs.core.distinct.call(null);
var inst_23775 = cljs.core.comp.call(null,inst_23773,inst_23774);
var inst_23776 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_23777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23778 = [inst_23719];
var inst_23779 = (new cljs.core.PersistentVector(null,1,(5),inst_23777,inst_23778,null));
var inst_23780 = cljs.core.sequence.call(null,inst_23775,inst_23771);
var inst_23781 = cljs.core.PersistentHashMap.EMPTY;
var inst_23782 = [inst_23779,inst_23780,inst_23781];
var inst_23783 = cljs.core.PersistentHashMap.fromArrays(inst_23776,inst_23782);
var state_23824__$1 = state_23824;
var statearr_23827_23872 = state_23824__$1;
(statearr_23827_23872[(2)] = inst_23783);

(statearr_23827_23872[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (27))){
var inst_23721 = (state_23824[(10)]);
var inst_23797 = (state_23824[(2)]);
var inst_23798 = fluree.db.flake.sid__GT_cid.call(null,inst_23797);
var inst_23799 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_23798);
var inst_23800 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_23801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23802 = [inst_23721];
var inst_23803 = (new cljs.core.PersistentVector(null,1,(5),inst_23801,inst_23802,null));
var inst_23804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23806 = [inst_23799];
var inst_23807 = (new cljs.core.PersistentVector(null,1,(5),inst_23805,inst_23806,null));
var inst_23808 = [inst_23807];
var inst_23809 = (new cljs.core.PersistentVector(null,1,(5),inst_23804,inst_23808,null));
var inst_23810 = cljs.core.PersistentHashMap.EMPTY;
var inst_23811 = [inst_23803,inst_23809,inst_23810];
var inst_23812 = cljs.core.PersistentHashMap.fromArrays(inst_23800,inst_23811);
var state_23824__$1 = state_23824;
var statearr_23828_23873 = state_23824__$1;
(statearr_23828_23873[(2)] = inst_23812);

(statearr_23828_23873[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (1))){
var state_23824__$1 = state_23824;
var statearr_23829_23874 = state_23824__$1;
(statearr_23829_23874[(2)] = null);

(statearr_23829_23874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (24))){
var inst_23815 = (state_23824[(2)]);
var state_23824__$1 = state_23824;
var statearr_23830_23875 = state_23824__$1;
(statearr_23830_23875[(2)] = inst_23815);

(statearr_23830_23875[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (4))){
var inst_23712 = (state_23824[(2)]);
var state_23824__$1 = state_23824;
var statearr_23831_23876 = state_23824__$1;
(statearr_23831_23876[(2)] = inst_23712);

(statearr_23831_23876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (15))){
var inst_23721 = (state_23824[(10)]);
var inst_23719 = (state_23824[(7)]);
var inst_23740 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_23741 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_23742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23743 = [inst_23719];
var inst_23744 = (new cljs.core.PersistentVector(null,1,(5),inst_23742,inst_23743,null));
var inst_23745 = (function (){var subject_var = inst_23719;
var object_var = inst_23721;
var min_sid = inst_23740;
var max_sid = (0);
return (function (p1__23711_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__23711_SHARP_);
});
})();
var inst_23746 = cljs.core.range.call(null,inst_23740,(0));
var inst_23747 = cljs.core.map.call(null,inst_23745,inst_23746);
var inst_23748 = cljs.core.PersistentHashMap.EMPTY;
var inst_23749 = [inst_23744,inst_23747,inst_23748];
var inst_23750 = cljs.core.PersistentHashMap.fromArrays(inst_23741,inst_23749);
var state_23824__$1 = state_23824;
var statearr_23832_23877 = state_23824__$1;
(statearr_23832_23877[(2)] = inst_23750);

(statearr_23832_23877[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (21))){
var inst_23766 = (state_23824[(2)]);
var inst_23767 = fluree.db.util.async.throw_err.call(null,inst_23766);
var state_23824__$1 = state_23824;
var statearr_23833_23878 = state_23824__$1;
(statearr_23833_23878[(2)] = inst_23767);

(statearr_23833_23878[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (13))){
var inst_23721 = (state_23824[(10)]);
var state_23824__$1 = state_23824;
if(cljs.core.truth_(inst_23721)){
var statearr_23834_23879 = state_23824__$1;
(statearr_23834_23879[(1)] = (22));

} else {
var statearr_23835_23880 = state_23824__$1;
(statearr_23835_23880[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (22))){
var inst_23788 = (state_23824[(12)]);
var inst_23788__$1 = cljs.core.first.call(null,clause);
var inst_23789 = typeof inst_23788__$1 === 'number';
var state_23824__$1 = (function (){var statearr_23836 = state_23824;
(statearr_23836[(12)] = inst_23788__$1);

return statearr_23836;
})();
if(cljs.core.truth_(inst_23789)){
var statearr_23837_23881 = state_23824__$1;
(statearr_23837_23881[(1)] = (25));

} else {
var statearr_23838_23882 = state_23824__$1;
(statearr_23838_23882[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (6))){
var inst_23721 = (state_23824[(10)]);
var state_23824__$1 = state_23824;
var statearr_23839_23883 = state_23824__$1;
(statearr_23839_23883[(2)] = inst_23721);

(statearr_23839_23883[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (28))){
var inst_23794 = (state_23824[(2)]);
var inst_23795 = fluree.db.util.async.throw_err.call(null,inst_23794);
var state_23824__$1 = state_23824;
var statearr_23840_23884 = state_23824__$1;
(statearr_23840_23884[(2)] = inst_23795);

(statearr_23840_23884[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (25))){
var inst_23788 = (state_23824[(12)]);
var state_23824__$1 = state_23824;
var statearr_23841_23885 = state_23824__$1;
(statearr_23841_23885[(2)] = inst_23788);

(statearr_23841_23885[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (17))){
var inst_23785 = (state_23824[(2)]);
var state_23824__$1 = state_23824;
var statearr_23842_23886 = state_23824__$1;
(statearr_23842_23886[(2)] = inst_23785);

(statearr_23842_23886[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (3))){
var inst_23822 = (state_23824[(2)]);
var state_23824__$1 = state_23824;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23824__$1,inst_23822);
} else {
if((state_val_23825 === (12))){
var inst_23734 = ["_tx",null,"_block",null];
var inst_23735 = (new cljs.core.PersistentArrayMap(null,2,inst_23734,null));
var inst_23736 = (new cljs.core.PersistentHashSet(null,inst_23735,null));
var inst_23737 = cljs.core.last.call(null,clause);
var inst_23738 = inst_23736.call(null,inst_23737);
var state_23824__$1 = state_23824;
if(cljs.core.truth_(inst_23738)){
var statearr_23843_23887 = state_23824__$1;
(statearr_23843_23887[(1)] = (15));

} else {
var statearr_23844_23888 = state_23824__$1;
(statearr_23844_23888[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (2))){
var inst_23719 = (state_23824[(7)]);
var _ = (function (){var statearr_23845 = state_23824;
(statearr_23845[(4)] = cljs.core.cons.call(null,(5),(state_23824[(4)])));

return statearr_23845;
})();
var inst_23718 = cljs.core.first.call(null,clause);
var inst_23719__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_23718);
var inst_23720 = cljs.core.last.call(null,clause);
var inst_23721 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_23720);
var state_23824__$1 = (function (){var statearr_23846 = state_23824;
(statearr_23846[(10)] = inst_23721);

(statearr_23846[(7)] = inst_23719__$1);

return statearr_23846;
})();
if(cljs.core.truth_(inst_23719__$1)){
var statearr_23847_23889 = state_23824__$1;
(statearr_23847_23889[(1)] = (6));

} else {
var statearr_23848_23890 = state_23824__$1;
(statearr_23848_23890[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (23))){
var state_23824__$1 = state_23824;
var statearr_23849_23891 = state_23824__$1;
(statearr_23849_23891[(2)] = null);

(statearr_23849_23891[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (19))){
var inst_23769 = cljs.core.PersistentVector.EMPTY;
var state_23824__$1 = state_23824;
var statearr_23850_23892 = state_23824__$1;
(statearr_23850_23892[(2)] = inst_23769);

(statearr_23850_23892[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (11))){
var inst_23819 = (state_23824[(2)]);
var _ = (function (){var statearr_23852 = state_23824;
(statearr_23852[(4)] = cljs.core.rest.call(null,(state_23824[(4)])));

return statearr_23852;
})();
var state_23824__$1 = state_23824;
var statearr_23853_23893 = state_23824__$1;
(statearr_23853_23893[(2)] = inst_23819);

(statearr_23853_23893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (9))){
var inst_23727 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23728 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23729 = cljs.core.PersistentHashMap.fromArrays(inst_23727,inst_23728);
var inst_23730 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_23729);
var inst_23731 = (function(){throw inst_23730})();
var state_23824__$1 = state_23824;
var statearr_23854_23894 = state_23824__$1;
(statearr_23854_23894[(2)] = inst_23731);

(statearr_23854_23894[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (5))){
var _ = (function (){var statearr_23855 = state_23824;
(statearr_23855[(4)] = cljs.core.rest.call(null,(state_23824[(4)])));

return statearr_23855;
})();
var state_23824__$1 = state_23824;
var ex23851 = (state_23824__$1[(2)]);
var statearr_23856_23895 = state_23824__$1;
(statearr_23856_23895[(5)] = ex23851);


if((ex23851 instanceof Error)){
var statearr_23857_23896 = state_23824__$1;
(statearr_23857_23896[(1)] = (4));

(statearr_23857_23896[(5)] = null);

} else {
throw ex23851;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (14))){
var inst_23817 = (state_23824[(2)]);
var state_23824__$1 = state_23824;
var statearr_23858_23897 = state_23824__$1;
(statearr_23858_23897[(2)] = inst_23817);

(statearr_23858_23897[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (26))){
var inst_23788 = (state_23824[(12)]);
var inst_23792 = fluree.db.dbproto._subid.call(null,db,inst_23788);
var state_23824__$1 = state_23824;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23824__$1,(28),inst_23792);
} else {
if((state_val_23825 === (16))){
var inst_23755 = (state_23824[(9)]);
var inst_23753 = (state_23824[(11)]);
var inst_23752 = cljs.core.last.call(null,clause);
var inst_23753__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_23752);
var inst_23754 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_23755__$1 = cljs.core.get.call(null,inst_23754,inst_23753__$1);
var inst_23756 = fluree.db.flake.min_subject_id.call(null,inst_23753__$1);
var state_23824__$1 = (function (){var statearr_23859 = state_23824;
(statearr_23859[(8)] = inst_23756);

(statearr_23859[(9)] = inst_23755__$1);

(statearr_23859[(11)] = inst_23753__$1);

return statearr_23859;
})();
if(cljs.core.truth_(inst_23755__$1)){
var statearr_23860_23898 = state_23824__$1;
(statearr_23860_23898[(1)] = (18));

} else {
var statearr_23861_23899 = state_23824__$1;
(statearr_23861_23899[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (10))){
var inst_23719 = (state_23824[(7)]);
var state_23824__$1 = state_23824;
if(cljs.core.truth_(inst_23719)){
var statearr_23862_23900 = state_23824__$1;
(statearr_23862_23900[(1)] = (12));

} else {
var statearr_23863_23901 = state_23824__$1;
(statearr_23863_23901[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23825 === (18))){
var inst_23756 = (state_23824[(8)]);
var inst_23755 = (state_23824[(9)]);
var inst_23758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23759 = [inst_23755];
var inst_23760 = (new cljs.core.PersistentVector(null,1,(5),inst_23758,inst_23759,null));
var inst_23761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23762 = [inst_23756];
var inst_23763 = (new cljs.core.PersistentVector(null,1,(5),inst_23761,inst_23762,null));
var inst_23764 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_23760,cljs.core._LT__EQ_,inst_23763);
var state_23824__$1 = state_23824;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23824__$1,(21),inst_23764);
} else {
if((state_val_23825 === (8))){
var inst_23725 = (state_23824[(2)]);
var state_23824__$1 = state_23824;
if(cljs.core.truth_(inst_23725)){
var statearr_23864_23902 = state_23824__$1;
(statearr_23864_23902[(1)] = (9));

} else {
var statearr_23865_23903 = state_23824__$1;
(statearr_23865_23903[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_23866 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23866[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__);

(statearr_23866[(1)] = (1));

return statearr_23866;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1 = (function (state_23824){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_23824);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23867){var ex__2687__auto__ = e23867;
var statearr_23868_23904 = state_23824;
(statearr_23868_23904[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_23824[(4)]))){
var statearr_23869_23905 = state_23824;
(statearr_23869_23905[(1)] = cljs.core.first.call(null,(state_23824[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23906 = state_23824;
state_23824 = G__23906;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__ = function(state_23824){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1.call(this,state_23824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23870 = f__2707__auto__.call(null);
(statearr_23870[(6)] = c__2706__auto__);

return statearr_23870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__23912 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__23912 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__23912;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__23913(s__23914){
return (new cljs.core.LazySeq(null,(function (){
var s__23914__$1 = s__23914;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__23914__$1);
if(temp__5804__auto__){
var s__23914__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23914__$2)){
var c__5521__auto__ = cljs.core.chunk_first.call(null,s__23914__$2);
var size__5522__auto__ = cljs.core.count.call(null,c__5521__auto__);
var b__23916 = cljs.core.chunk_buffer.call(null,size__5522__auto__);
if((function (){var i__23915 = (0);
while(true){
if((i__23915 < size__5522__auto__)){
var x = cljs.core._nth.call(null,c__5521__auto__,i__23915);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__23916,(delta * delta));

var G__23917 = (i__23915 + (1));
i__23915 = G__23917;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23916),fluree$db$query$analytical$variance_$_iter__23913.call(null,cljs.core.chunk_rest.call(null,s__23914__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23916),null);
}
} else {
var x = cljs.core.first.call(null,s__23914__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__23913.call(null,cljs.core.rest.call(null,s__23914__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__23918 = null;
var G__23918__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__23918__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__23918 = function(n,coll){
switch(arguments.length){
case 1:
return G__23918__1.call(this,n);
case 2:
return G__23918__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23918.cljs$core$IFn$_invoke$arity$1 = G__23918__1;
G__23918.cljs$core$IFn$_invoke$arity$2 = G__23918__2;
return G__23918;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__23919 = null;
var G__23919__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__23919__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__23919 = function(n,coll){
switch(arguments.length){
case 1:
return G__23919__1.call(this,n);
case 2:
return G__23919__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23919.cljs$core$IFn$_invoke$arity$1 = G__23919__1;
G__23919.cljs$core$IFn$_invoke$arity$2 = G__23919__2;
return G__23919;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__23920 = null;
var G__23920__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__23920__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__23920 = function(n,coll){
switch(arguments.length){
case 1:
return G__23920__1.call(this,n);
case 2:
return G__23920__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23920.cljs$core$IFn$_invoke$arity$1 = G__23920__1;
G__23920.cljs$core$IFn$_invoke$arity$2 = G__23920__2;
return G__23920;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Returns map of aggregate function executable code or error if invalid aggregate function.
 */
fluree.db.query.analytical.parse_aggregate_STAR_ = (function fluree$db$query$analytical$parse_aggregate_STAR_(parsed_code,as,valid_var){
var list_count = cljs.core.count.call(null,parsed_code);
var vec__23921 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parsed_code),cljs.core.second.call(null,parsed_code),cljs.core.last.call(null,parsed_code)], null):((cljs.core._EQ_.call(null,(2),list_count))?((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,parsed_code)))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parsed_code),null,cljs.core.last.call(null,parsed_code)], null)):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var fun = cljs.core.nth.call(null,vec__23921,(0),null);
var arg = cljs.core.nth.call(null,vec__23921,(1),null);
var var$ = cljs.core.nth.call(null,vec__23921,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__23924 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__23924,(0),null);
var variable = cljs.core.nth.call(null,vec__23924,(1),null);
var fn_str = ["(fn [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"] ",cljs.core.pr_str.call(null,parsed_code),")"].join('');
if(cljs.core.truth_(valid_var.call(null,variable))){
} else {
throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Parses string aggregate function and returns execution map if valid.
 */
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(code_str,valid_var){
var list_agg = cljs.reader.read_string.call(null,code_str);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var code_parsed = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
return fluree.db.query.analytical.parse_aggregate_STAR_.call(null,code_parsed,as,valid_var);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(tuples,aggregate_fn_map){
var map__23927 = aggregate_fn_map;
var map__23927__$1 = cljs.core.__destructure_map.call(null,map__23927);
var variable = cljs.core.get.call(null,map__23927__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__23927__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.call(null,map__23927__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),tuples));
var agg_result = function$.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__23929 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__23929,(0),null);
var agg_result = cljs.core.nth.call(null,vec__23929,(1),null);
var map__23932 = res__$1;
var map__23932__$1 = cljs.core.__destructure_map.call(null,map__23932);
var headers = cljs.core.get.call(null,map__23932__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__23932__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__23928_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__23928_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__23933_SHARP_){
return cljs.core.nth.call(null,tuple,p1__23933_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__23934_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__23934_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.call(null,(function (p1__23935_SHARP_,p2__23936_SHARP_){
return cljs.core.conj.call(null,p1__23935_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__23936_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__23937_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__23937_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__23940,row,b_tuple){
var vec__23941 = p__23940;
var acc = cljs.core.nth.call(null,vec__23941,(0),null);
var b_rows = cljs.core.nth.call(null,vec__23941,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__23938_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__23938_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__23939_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__23939_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__23944_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__23944_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__23945_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__23945_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__23947_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__23947_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__23946_SHARP_){
return cljs.core.range.call(null,(0),p1__23946_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__23948_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__23948_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__23949_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__23949_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__23950_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__23950_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__23952_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__23952_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__23951_SHARP_){
return cljs.core.range.call(null,(0),p1__23951_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__23953_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__23953_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__23955 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__23955,(0),null);
var _ = cljs.core.nth.call(null,vec__23955,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__23954_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__23954_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var vec__23960 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filt,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__23960,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__23960,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__23958_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__23958_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__23959_SHARP_){
return cljs.core.nth.call(null,clause,p1__23959_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__23963,filters,optional_QMARK_){
var map__23964 = p__23963;
var map__23964__$1 = cljs.core.__destructure_map.call(null,map__23964);
var tuple_map = map__23964__$1;
var headers = cljs.core.get.call(null,map__23964__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__23964__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__23964__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__23965 = clause;
var k = cljs.core.nth.call(null,vec__23965,(0),null);
var v = cljs.core.nth.call(null,vec__23965,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__23968 = res;
var map__23968__$1 = cljs.core.__destructure_map.call(null,map__23968);
var headers = cljs.core.get.call(null,map__23968__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__23968__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5802__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24024){
var state_val_24025 = (state_24024[(1)]);
if((state_val_24025 === (7))){
var inst_23998 = (state_24024[(7)]);
var inst_23996 = (state_24024[(2)]);
var inst_23997 = fluree.db.util.async.throw_err.call(null,inst_23996);
var inst_23998__$1 = cljs.core.nth.call(null,inst_23997,(0),null);
var inst_23999 = cljs.core.nth.call(null,inst_23997,(1),null);
var inst_24000 = (inst_23998__$1 == null);
var state_24024__$1 = (function (){var statearr_24026 = state_24024;
(statearr_24026[(7)] = inst_23998__$1);

(statearr_24026[(8)] = inst_23999);

return statearr_24026;
})();
if(cljs.core.truth_(inst_24000)){
var statearr_24027_24056 = state_24024__$1;
(statearr_24027_24056[(1)] = (8));

} else {
var statearr_24028_24057 = state_24024__$1;
(statearr_24028_24057[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (1))){
var inst_23976 = optional_clauses;
var inst_23977 = cljs.core.seq.call(null,inst_23976);
var inst_23978 = cljs.core.first.call(null,inst_23977);
var inst_23979 = cljs.core.next.call(null,inst_23977);
var inst_23980 = where_tuples;
var inst_23981 = inst_23976;
var inst_23982 = inst_23980;
var state_24024__$1 = (function (){var statearr_24029 = state_24024;
(statearr_24029[(9)] = inst_23982);

(statearr_24029[(10)] = inst_23979);

(statearr_24029[(11)] = inst_23978);

(statearr_24029[(12)] = inst_23981);

return statearr_24029;
})();
var statearr_24030_24058 = state_24024__$1;
(statearr_24030_24058[(2)] = null);

(statearr_24030_24058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (4))){
var inst_23988 = (state_24024[(13)]);
var inst_23982 = (state_24024[(9)]);
var inst_23989 = (state_24024[(14)]);
var inst_23994 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_23982,inst_23988,inst_23989,true,fuel,max_fuel,opts);
var state_24024__$1 = state_24024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24024__$1,(7),inst_23994);
} else {
if((state_val_24025 === (15))){
var state_24024__$1 = state_24024;
var statearr_24031_24059 = state_24024__$1;
(statearr_24031_24059[(2)] = null);

(statearr_24031_24059[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (13))){
var inst_24015 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
var statearr_24032_24060 = state_24024__$1;
(statearr_24032_24060[(2)] = inst_24015);

(statearr_24032_24060[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (6))){
var inst_24020 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
var statearr_24033_24061 = state_24024__$1;
(statearr_24033_24061[(2)] = inst_24020);

(statearr_24033_24061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (3))){
var inst_24022 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24024__$1,inst_24022);
} else {
if((state_val_24025 === (12))){
var state_24024__$1 = state_24024;
var statearr_24034_24062 = state_24024__$1;
(statearr_24034_24062[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (2))){
var inst_23988 = (state_24024[(13)]);
var inst_23981 = (state_24024[(12)]);
var inst_23987 = cljs.core.seq.call(null,inst_23981);
var inst_23988__$1 = cljs.core.first.call(null,inst_23987);
var inst_23989 = cljs.core.next.call(null,inst_23987);
var state_24024__$1 = (function (){var statearr_24036 = state_24024;
(statearr_24036[(13)] = inst_23988__$1);

(statearr_24036[(14)] = inst_23989);

return statearr_24036;
})();
if(cljs.core.truth_(inst_23988__$1)){
var statearr_24037_24063 = state_24024__$1;
(statearr_24037_24063[(1)] = (4));

} else {
var statearr_24038_24064 = state_24024__$1;
(statearr_24038_24064[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (11))){
var inst_23998 = (state_24024[(7)]);
var inst_23999 = (state_24024[(8)]);
var inst_23981 = inst_23999;
var inst_23982 = inst_23998;
var state_24024__$1 = (function (){var statearr_24039 = state_24024;
(statearr_24039[(9)] = inst_23982);

(statearr_24039[(12)] = inst_23981);

return statearr_24039;
})();
var statearr_24040_24065 = state_24024__$1;
(statearr_24040_24065[(2)] = null);

(statearr_24040_24065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (9))){
var inst_23988 = (state_24024[(13)]);
var inst_24004 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_23988);
var state_24024__$1 = state_24024;
if(cljs.core.truth_(inst_24004)){
var statearr_24041_24066 = state_24024__$1;
(statearr_24041_24066[(1)] = (11));

} else {
var statearr_24042_24067 = state_24024__$1;
(statearr_24042_24067[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (5))){
var inst_23982 = (state_24024[(9)]);
var state_24024__$1 = state_24024;
var statearr_24043_24068 = state_24024__$1;
(statearr_24043_24068[(2)] = inst_23982);

(statearr_24043_24068[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (14))){
var inst_23982 = (state_24024[(9)]);
var inst_23998 = (state_24024[(7)]);
var inst_23999 = (state_24024[(8)]);
var inst_24009 = fluree.db.query.analytical.left_outer_join.call(null,inst_23982,inst_23998);
var inst_23981 = inst_23999;
var inst_23982__$1 = inst_24009;
var state_24024__$1 = (function (){var statearr_24044 = state_24024;
(statearr_24044[(9)] = inst_23982__$1);

(statearr_24044[(12)] = inst_23981);

return statearr_24044;
})();
var statearr_24045_24069 = state_24024__$1;
(statearr_24045_24069[(2)] = null);

(statearr_24045_24069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (16))){
var inst_24013 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
var statearr_24047_24070 = state_24024__$1;
(statearr_24047_24070[(2)] = inst_24013);

(statearr_24047_24070[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (10))){
var inst_24017 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
var statearr_24048_24071 = state_24024__$1;
(statearr_24048_24071[(2)] = inst_24017);

(statearr_24048_24071[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (8))){
var inst_23982 = (state_24024[(9)]);
var inst_23999 = (state_24024[(8)]);
var tmp24046 = inst_23982;
var inst_23981 = inst_23999;
var inst_23982__$1 = tmp24046;
var state_24024__$1 = (function (){var statearr_24049 = state_24024;
(statearr_24049[(9)] = inst_23982__$1);

(statearr_24049[(12)] = inst_23981);

return statearr_24049;
})();
var statearr_24050_24072 = state_24024__$1;
(statearr_24050_24072[(2)] = null);

(statearr_24050_24072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0 = (function (){
var statearr_24051 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24051[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__);

(statearr_24051[(1)] = (1));

return statearr_24051;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1 = (function (state_24024){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_24024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24052){var ex__2687__auto__ = e24052;
var statearr_24053_24073 = state_24024;
(statearr_24053_24073[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_24024[(4)]))){
var statearr_24054_24074 = state_24024;
(statearr_24054_24074[(1)] = cljs.core.first.call(null,(state_24024[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24075 = state_24024;
state_24024 = G__24075;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__ = function(state_24024){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1.call(this,state_24024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24055 = f__2707__auto__.call(null);
(statearr_24055[(6)] = c__2706__auto__);

return statearr_24055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__24077){
var vec__24078 = p__24077;
var var_name = cljs.core.nth.call(null,vec__24078,(0),null);
var var_val = cljs.core.nth.call(null,vec__24078,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__24076_SHARP_){
return cljs.core.conj.call(null,p1__24076_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__24082,p__24083,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__24084 = p__24082;
var map__24084__$1 = cljs.core.__destructure_map.call(null,map__24084);
var q_map = map__24084__$1;
var prefixes = cljs.core.get.call(null,map__24084__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__24085 = p__24083;
var map__24085__$1 = cljs.core.__destructure_map.call(null,map__24085);
var res = map__24085__$1;
var vars = cljs.core.get.call(null,map__24085__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24322){
var state_val_24323 = (state_24322[(1)]);
if((state_val_24323 === (65))){
var inst_24272 = (state_24322[(7)]);
var inst_24271 = (state_24322[(8)]);
var inst_24283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24284 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_24271,res,inst_24272);
var inst_24285 = [inst_24284,r];
var inst_24286 = (new cljs.core.PersistentVector(null,2,(5),inst_24283,inst_24285,null));
var state_24322__$1 = state_24322;
var statearr_24324_24429 = state_24322__$1;
(statearr_24324_24429[(2)] = inst_24286);

(statearr_24324_24429[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (70))){
var inst_24298 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24325_24430 = state_24322__$1;
(statearr_24325_24430[(2)] = inst_24298);

(statearr_24325_24430[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (62))){
var inst_24272 = (state_24322[(7)]);
var inst_24280 = cljs.core.second.call(null,inst_24272);
var inst_24281 = clojure.string.starts_with_QMARK_.call(null,inst_24280,"fullText:");
var state_24322__$1 = state_24322;
if(inst_24281){
var statearr_24326_24431 = state_24322__$1;
(statearr_24326_24431[(1)] = (65));

} else {
var statearr_24327_24432 = state_24322__$1;
(statearr_24327_24432[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (7))){
var inst_24191 = (state_24322[(9)]);
var inst_24190 = cljs.core.count.call(null,clause);
var inst_24191__$1 = cljs.core._EQ_.call(null,(3),inst_24190);
var state_24322__$1 = (function (){var statearr_24328 = state_24322;
(statearr_24328[(9)] = inst_24191__$1);

return statearr_24328;
})();
if(inst_24191__$1){
var statearr_24329_24433 = state_24322__$1;
(statearr_24329_24433[(1)] = (31));

} else {
var statearr_24330_24434 = state_24322__$1;
(statearr_24330_24434[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (59))){
var inst_24305 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24331_24435 = state_24322__$1;
(statearr_24331_24435[(2)] = inst_24305);

(statearr_24331_24435[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (20))){
var inst_24154 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24332_24436 = state_24322__$1;
(statearr_24332_24436[(2)] = inst_24154);

(statearr_24332_24436[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (58))){
var state_24322__$1 = state_24322;
var statearr_24333_24437 = state_24322__$1;
(statearr_24333_24437[(2)] = null);

(statearr_24333_24437[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (60))){
var inst_24271 = (state_24322[(8)]);
var inst_24269 = (state_24322[(2)]);
var inst_24270 = fluree.db.util.async.throw_err.call(null,inst_24269);
var inst_24271__$1 = cljs.core.nth.call(null,inst_24270,(0),null);
var inst_24272 = cljs.core.nth.call(null,inst_24270,(1),null);
var inst_24273 = cljs.core._EQ_.call(null,"$wd",inst_24271__$1);
var state_24322__$1 = (function (){var statearr_24334 = state_24322;
(statearr_24334[(7)] = inst_24272);

(statearr_24334[(8)] = inst_24271__$1);

return statearr_24334;
})();
if(inst_24273){
var statearr_24335_24438 = state_24322__$1;
(statearr_24335_24438[(1)] = (61));

} else {
var statearr_24336_24439 = state_24322__$1;
(statearr_24336_24439[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (27))){
var inst_24184 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24337_24440 = state_24322__$1;
(statearr_24337_24440[(2)] = inst_24184);

(statearr_24337_24440[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (1))){
var state_24322__$1 = state_24322;
var statearr_24338_24441 = state_24322__$1;
(statearr_24338_24441[(2)] = null);

(statearr_24338_24441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (69))){
var state_24322__$1 = state_24322;
var statearr_24339_24442 = state_24322__$1;
(statearr_24339_24442[(2)] = null);

(statearr_24339_24442[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (24))){
var inst_24148 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24340_24443 = state_24322__$1;
(statearr_24340_24443[(2)] = inst_24148);

(statearr_24340_24443[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (55))){
var inst_24254 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_24255 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24256 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24257 = cljs.core.PersistentHashMap.fromArrays(inst_24255,inst_24256);
var inst_24258 = cljs.core.ex_info.call(null,inst_24254,inst_24257);
var inst_24259 = (function(){throw inst_24258})();
var state_24322__$1 = state_24322;
var statearr_24341_24444 = state_24322__$1;
(statearr_24341_24444[(2)] = inst_24259);

(statearr_24341_24444[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (39))){
var inst_24211 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
if(cljs.core.truth_(inst_24211)){
var statearr_24342_24445 = state_24322__$1;
(statearr_24342_24445[(1)] = (40));

} else {
var statearr_24343_24446 = state_24322__$1;
(statearr_24343_24446[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (46))){
var inst_24311 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24344_24447 = state_24322__$1;
(statearr_24344_24447[(2)] = inst_24311);

(statearr_24344_24447[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (4))){
var inst_24086 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24345_24448 = state_24322__$1;
(statearr_24345_24448[(2)] = inst_24086);

(statearr_24345_24448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (54))){
var inst_24247 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_24248 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24249 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24250 = cljs.core.PersistentHashMap.fromArrays(inst_24248,inst_24249);
var inst_24251 = cljs.core.ex_info.call(null,inst_24247,inst_24250);
var inst_24252 = (function(){throw inst_24251})();
var state_24322__$1 = state_24322;
var statearr_24346_24449 = state_24322__$1;
(statearr_24346_24449[(2)] = inst_24252);

(statearr_24346_24449[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (15))){
var inst_24186 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24347_24450 = state_24322__$1;
(statearr_24347_24450[(2)] = inst_24186);

(statearr_24347_24450[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (48))){
var inst_24235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24236 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_24237 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_24236);
var inst_24238 = [inst_24237,r];
var inst_24239 = (new cljs.core.PersistentVector(null,2,(5),inst_24235,inst_24238,null));
var state_24322__$1 = state_24322;
var statearr_24348_24451 = state_24322__$1;
(statearr_24348_24451[(2)] = inst_24239);

(statearr_24348_24451[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (50))){
var inst_24309 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24349_24452 = state_24322__$1;
(statearr_24349_24452[(2)] = inst_24309);

(statearr_24349_24452[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (21))){
var inst_24095 = (state_24322[(10)]);
var inst_24124 = (state_24322[(11)]);
var inst_24099 = (state_24322[(12)]);
var inst_24131 = (state_24322[(13)]);
var inst_24123 = (state_24322[(14)]);
var inst_24120 = (state_24322[(15)]);
var inst_24122 = (state_24322[(16)]);
var inst_24132 = (state_24322[(17)]);
var inst_24125 = (state_24322[(18)]);
var inst_24136 = (state_24322[(2)]);
var inst_24137 = fluree.db.util.async.throw_err.call(null,inst_24136);
var inst_24138 = (function (){var expr__24097 = inst_24095;
var new_res = inst_24137;
var rest = inst_24132;
var pred__24096 = inst_24099;
var tuples = inst_24125;
var vec__24127 = inst_24124;
var seq__24128 = inst_24132;
var seq__24118 = inst_24123;
var first__24119 = inst_24122;
var segment_type = inst_24095;
var first__24129 = inst_24131;
var clause_group = inst_24131;
var G__24116 = inst_24124;
var vec__24117 = inst_24120;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_24139 = cljs.core.keys.call(null,vars);
var inst_24140 = cljs.core.reduce.call(null,inst_24138,inst_24137,inst_24139);
var inst_24141 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_24140);
var state_24322__$1 = (function (){var statearr_24350 = state_24322;
(statearr_24350[(19)] = inst_24141);

return statearr_24350;
})();
if(cljs.core.truth_(inst_24125)){
var statearr_24351_24453 = state_24322__$1;
(statearr_24351_24453[(1)] = (22));

} else {
var statearr_24352_24454 = state_24322__$1;
(statearr_24352_24454[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (31))){
var inst_24193 = cljs.core.second.call(null,clause);
var inst_24194 = clojure.string.starts_with_QMARK_.call(null,inst_24193,"fullText:");
var state_24322__$1 = state_24322;
var statearr_24353_24455 = state_24322__$1;
(statearr_24353_24455[(2)] = inst_24194);

(statearr_24353_24455[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (32))){
var inst_24191 = (state_24322[(9)]);
var state_24322__$1 = state_24322;
var statearr_24354_24456 = state_24322__$1;
(statearr_24354_24456[(2)] = inst_24191);

(statearr_24354_24456[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (40))){
var inst_24213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24214 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_24322__$1 = (function (){var statearr_24355 = state_24322;
(statearr_24355[(20)] = inst_24213);

return statearr_24355;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24322__$1,(43),inst_24214);
} else {
if((state_val_24323 === (56))){
var inst_24261 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24356_24457 = state_24322__$1;
(statearr_24356_24457[(2)] = inst_24261);

(statearr_24356_24457[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (33))){
var inst_24197 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
if(cljs.core.truth_(inst_24197)){
var statearr_24357_24458 = state_24322__$1;
(statearr_24357_24458[(1)] = (34));

} else {
var statearr_24358_24459 = state_24322__$1;
(statearr_24358_24459[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (13))){
var inst_24120 = (state_24322[(15)]);
var inst_24120__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_24121 = cljs.core.seq.call(null,inst_24120__$1);
var inst_24122 = cljs.core.first.call(null,inst_24121);
var inst_24123 = cljs.core.next.call(null,inst_24121);
var inst_24124 = inst_24120__$1;
var inst_24125 = null;
var state_24322__$1 = (function (){var statearr_24359 = state_24322;
(statearr_24359[(11)] = inst_24124);

(statearr_24359[(14)] = inst_24123);

(statearr_24359[(15)] = inst_24120__$1);

(statearr_24359[(16)] = inst_24122);

(statearr_24359[(18)] = inst_24125);

return statearr_24359;
})();
var statearr_24360_24460 = state_24322__$1;
(statearr_24360_24460[(2)] = null);

(statearr_24360_24460[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (22))){
var inst_24141 = (state_24322[(19)]);
var inst_24132 = (state_24322[(17)]);
var inst_24125 = (state_24322[(18)]);
var inst_24143 = fluree.db.query.union.results.call(null,inst_24125,inst_24141);
var inst_24124 = inst_24132;
var inst_24125__$1 = inst_24143;
var state_24322__$1 = (function (){var statearr_24361 = state_24322;
(statearr_24361[(11)] = inst_24124);

(statearr_24361[(18)] = inst_24125__$1);

return statearr_24361;
})();
var statearr_24362_24461 = state_24322__$1;
(statearr_24362_24461[(2)] = null);

(statearr_24362_24461[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (36))){
var inst_24315 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24363_24462 = state_24322__$1;
(statearr_24363_24462[(2)] = inst_24315);

(statearr_24363_24462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (41))){
var inst_24221 = cljs.core.count.call(null,clause);
var inst_24222 = cljs.core._EQ_.call(null,(3),inst_24221);
var state_24322__$1 = state_24322;
if(inst_24222){
var statearr_24364_24463 = state_24322__$1;
(statearr_24364_24463[(1)] = (44));

} else {
var statearr_24365_24464 = state_24322__$1;
(statearr_24365_24464[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (43))){
var inst_24213 = (state_24322[(20)]);
var inst_24216 = (state_24322[(2)]);
var inst_24217 = fluree.db.util.async.throw_err.call(null,inst_24216);
var inst_24218 = [inst_24217,r];
var inst_24219 = (new cljs.core.PersistentVector(null,2,(5),inst_24213,inst_24218,null));
var state_24322__$1 = state_24322;
var statearr_24366_24465 = state_24322__$1;
(statearr_24366_24465[(2)] = inst_24219);

(statearr_24366_24465[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (61))){
var inst_24272 = (state_24322[(7)]);
var inst_24275 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_24272,r,res,optional_QMARK_,fuel,max_fuel);
var state_24322__$1 = state_24322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24322__$1,(64),inst_24275);
} else {
if((state_val_24323 === (29))){
var inst_24095 = (state_24322[(10)]);
var inst_24178 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24095)].join('');
var inst_24179 = (new Error(inst_24178));
var inst_24180 = (function(){throw inst_24179})();
var state_24322__$1 = state_24322;
var statearr_24367_24466 = state_24322__$1;
(statearr_24367_24466[(2)] = inst_24180);

(statearr_24367_24466[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (44))){
var inst_24224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24225 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel,opts);
var state_24322__$1 = (function (){var statearr_24368 = state_24322;
(statearr_24368[(21)] = inst_24224);

return statearr_24368;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24322__$1,(47),inst_24225);
} else {
if((state_val_24323 === (6))){
var inst_24095 = (state_24322[(10)]);
var inst_24099 = (state_24322[(12)]);
var inst_24094 = cljs.core.keys.call(null,clause);
var inst_24095__$1 = cljs.core.first.call(null,inst_24094);
var inst_24099__$1 = cljs.core._EQ_;
var inst_24100 = inst_24099__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_24095__$1);
var state_24322__$1 = (function (){var statearr_24369 = state_24322;
(statearr_24369[(10)] = inst_24095__$1);

(statearr_24369[(12)] = inst_24099__$1);

return statearr_24369;
})();
if(cljs.core.truth_(inst_24100)){
var statearr_24370_24467 = state_24322__$1;
(statearr_24370_24467[(1)] = (9));

} else {
var statearr_24371_24468 = state_24322__$1;
(statearr_24371_24468[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (28))){
var inst_24172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24173 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_24174 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_24173,optional_QMARK_);
var inst_24175 = [inst_24174,r];
var inst_24176 = (new cljs.core.PersistentVector(null,2,(5),inst_24172,inst_24175,null));
var state_24322__$1 = state_24322;
var statearr_24372_24469 = state_24322__$1;
(statearr_24372_24469[(2)] = inst_24176);

(statearr_24372_24469[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (64))){
var inst_24277 = (state_24322[(2)]);
var inst_24278 = fluree.db.util.async.throw_err.call(null,inst_24277);
var state_24322__$1 = state_24322;
var statearr_24373_24470 = state_24322__$1;
(statearr_24373_24470[(2)] = inst_24278);

(statearr_24373_24470[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (51))){
var inst_24244 = cljs.core.first.call(null,clause);
var inst_24245 = cljs.core.sequential_QMARK_.call(null,inst_24244);
var state_24322__$1 = state_24322;
if(inst_24245){
var statearr_24374_24471 = state_24322__$1;
(statearr_24374_24471[(1)] = (54));

} else {
var statearr_24375_24472 = state_24322__$1;
(statearr_24375_24472[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (25))){
var inst_24095 = (state_24322[(10)]);
var inst_24099 = (state_24322[(12)]);
var inst_24160 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_24161 = (function (){var segment_type = inst_24095;
var pred__24096 = inst_24099;
var expr__24097 = inst_24095;
var bindings = inst_24160;
return (function (p1__24081_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__24081_SHARP_);
});
})();
var inst_24162 = cljs.core.map.call(null,inst_24161,inst_24160);
var inst_24163 = cljs.core.PersistentHashMap.EMPTY;
var inst_24164 = cljs.core.into.call(null,inst_24163,inst_24162);
var inst_24165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24166 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_24164);
var inst_24167 = [inst_24166,r];
var inst_24168 = (new cljs.core.PersistentVector(null,2,(5),inst_24165,inst_24167,null));
var state_24322__$1 = state_24322;
var statearr_24376_24473 = state_24322__$1;
(statearr_24376_24473[(2)] = inst_24168);

(statearr_24376_24473[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (34))){
var inst_24199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24200 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_24201 = [inst_24200,r];
var inst_24202 = (new cljs.core.PersistentVector(null,2,(5),inst_24199,inst_24201,null));
var state_24322__$1 = state_24322;
var statearr_24377_24474 = state_24322__$1;
(statearr_24377_24474[(2)] = inst_24202);

(statearr_24377_24474[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (17))){
var inst_24156 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24378_24475 = state_24322__$1;
(statearr_24378_24475[(2)] = inst_24156);

(statearr_24378_24475[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (3))){
var inst_24320 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24322__$1,inst_24320);
} else {
if((state_val_24323 === (12))){
var inst_24102 = (state_24322[(22)]);
var inst_24106 = (state_24322[(2)]);
var inst_24107 = fluree.db.util.async.throw_err.call(null,inst_24106);
var inst_24108 = [inst_24107,r];
var inst_24109 = (new cljs.core.PersistentVector(null,2,(5),inst_24102,inst_24108,null));
var state_24322__$1 = state_24322;
var statearr_24379_24476 = state_24322__$1;
(statearr_24379_24476[(2)] = inst_24109);

(statearr_24379_24476[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (2))){
var _ = (function (){var statearr_24380 = state_24322;
(statearr_24380[(4)] = cljs.core.cons.call(null,(5),(state_24322[(4)])));

return statearr_24380;
})();
var inst_24092 = cljs.core.map_QMARK_.call(null,clause);
var state_24322__$1 = state_24322;
if(inst_24092){
var statearr_24381_24477 = state_24322__$1;
(statearr_24381_24477[(1)] = (6));

} else {
var statearr_24382_24478 = state_24322__$1;
(statearr_24382_24478[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (66))){
var state_24322__$1 = state_24322;
var statearr_24383_24479 = state_24322__$1;
(statearr_24383_24479[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (23))){
var inst_24141 = (state_24322[(19)]);
var inst_24132 = (state_24322[(17)]);
var inst_24124 = inst_24132;
var inst_24125 = inst_24141;
var state_24322__$1 = (function (){var statearr_24385 = state_24322;
(statearr_24385[(11)] = inst_24124);

(statearr_24385[(18)] = inst_24125);

return statearr_24385;
})();
var statearr_24386_24480 = state_24322__$1;
(statearr_24386_24480[(2)] = null);

(statearr_24386_24480[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (47))){
var inst_24224 = (state_24322[(21)]);
var inst_24227 = (state_24322[(2)]);
var inst_24228 = fluree.db.util.async.throw_err.call(null,inst_24227);
var inst_24229 = [inst_24228,r];
var inst_24230 = (new cljs.core.PersistentVector(null,2,(5),inst_24224,inst_24229,null));
var state_24322__$1 = state_24322;
var statearr_24387_24481 = state_24322__$1;
(statearr_24387_24481[(2)] = inst_24230);

(statearr_24387_24481[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (35))){
var inst_24205 = (state_24322[(23)]);
var inst_24204 = cljs.core.count.call(null,clause);
var inst_24205__$1 = cljs.core._EQ_.call(null,(3),inst_24204);
var state_24322__$1 = (function (){var statearr_24388 = state_24322;
(statearr_24388[(23)] = inst_24205__$1);

return statearr_24388;
})();
if(inst_24205__$1){
var statearr_24389_24482 = state_24322__$1;
(statearr_24389_24482[(1)] = (37));

} else {
var statearr_24390_24483 = state_24322__$1;
(statearr_24390_24483[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (19))){
var inst_24125 = (state_24322[(18)]);
var inst_24150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24151 = [inst_24125,r];
var inst_24152 = (new cljs.core.PersistentVector(null,2,(5),inst_24150,inst_24151,null));
var state_24322__$1 = state_24322;
var statearr_24391_24484 = state_24322__$1;
(statearr_24391_24484[(2)] = inst_24152);

(statearr_24391_24484[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (57))){
var inst_24267 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_24322__$1 = state_24322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24322__$1,(60),inst_24267);
} else {
if((state_val_24323 === (68))){
var inst_24272 = (state_24322[(7)]);
var inst_24271 = (state_24322[(8)]);
var inst_24289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24290 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_24271,res,inst_24272,fuel,max_fuel,opts);
var state_24322__$1 = (function (){var statearr_24392 = state_24322;
(statearr_24392[(24)] = inst_24289);

return statearr_24392;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24322__$1,(71),inst_24290);
} else {
if((state_val_24323 === (11))){
var inst_24188 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24394_24485 = state_24322__$1;
(statearr_24394_24485[(2)] = inst_24188);

(statearr_24394_24485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (9))){
var inst_24102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24103 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_24104 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_24103,res,fuel,max_fuel,opts);
var state_24322__$1 = (function (){var statearr_24395 = state_24322;
(statearr_24395[(22)] = inst_24102);

return statearr_24395;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24322__$1,(12),inst_24104);
} else {
if((state_val_24323 === (5))){
var _ = (function (){var statearr_24396 = state_24322;
(statearr_24396[(4)] = cljs.core.rest.call(null,(state_24322[(4)])));

return statearr_24396;
})();
var state_24322__$1 = state_24322;
var ex24393 = (state_24322__$1[(2)]);
var statearr_24397_24486 = state_24322__$1;
(statearr_24397_24486[(5)] = ex24393);


if((ex24393 instanceof Error)){
var statearr_24398_24487 = state_24322__$1;
(statearr_24398_24487[(1)] = (4));

(statearr_24398_24487[(5)] = null);

} else {
throw ex24393;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (14))){
var inst_24095 = (state_24322[(10)]);
var inst_24099 = (state_24322[(12)]);
var inst_24158 = inst_24099.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_24095);
var state_24322__$1 = state_24322;
if(cljs.core.truth_(inst_24158)){
var statearr_24399_24488 = state_24322__$1;
(statearr_24399_24488[(1)] = (25));

} else {
var statearr_24400_24489 = state_24322__$1;
(statearr_24400_24489[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (45))){
var inst_24232 = cljs.core.count.call(null,clause);
var inst_24233 = cljs.core._EQ_.call(null,(2),inst_24232);
var state_24322__$1 = state_24322;
if(inst_24233){
var statearr_24401_24490 = state_24322__$1;
(statearr_24401_24490[(1)] = (48));

} else {
var statearr_24402_24491 = state_24322__$1;
(statearr_24402_24491[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (53))){
var inst_24307 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24403_24492 = state_24322__$1;
(statearr_24403_24492[(2)] = inst_24307);

(statearr_24403_24492[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (26))){
var inst_24095 = (state_24322[(10)]);
var inst_24099 = (state_24322[(12)]);
var inst_24170 = inst_24099.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_24095);
var state_24322__$1 = state_24322;
if(cljs.core.truth_(inst_24170)){
var statearr_24404_24493 = state_24322__$1;
(statearr_24404_24493[(1)] = (28));

} else {
var statearr_24405_24494 = state_24322__$1;
(statearr_24405_24494[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (16))){
var inst_24124 = (state_24322[(11)]);
var inst_24131 = (state_24322[(13)]);
var inst_24130 = cljs.core.seq.call(null,inst_24124);
var inst_24131__$1 = cljs.core.first.call(null,inst_24130);
var inst_24132 = cljs.core.next.call(null,inst_24130);
var state_24322__$1 = (function (){var statearr_24406 = state_24322;
(statearr_24406[(13)] = inst_24131__$1);

(statearr_24406[(17)] = inst_24132);

return statearr_24406;
})();
if(cljs.core.truth_(inst_24131__$1)){
var statearr_24407_24495 = state_24322__$1;
(statearr_24407_24495[(1)] = (18));

} else {
var statearr_24408_24496 = state_24322__$1;
(statearr_24408_24496[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (38))){
var inst_24205 = (state_24322[(23)]);
var state_24322__$1 = state_24322;
var statearr_24409_24497 = state_24322__$1;
(statearr_24409_24497[(2)] = inst_24205);

(statearr_24409_24497[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (30))){
var inst_24182 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24410_24498 = state_24322__$1;
(statearr_24410_24498[(2)] = inst_24182);

(statearr_24410_24498[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (10))){
var inst_24095 = (state_24322[(10)]);
var inst_24099 = (state_24322[(12)]);
var inst_24111 = inst_24099.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_24095);
var state_24322__$1 = state_24322;
if(cljs.core.truth_(inst_24111)){
var statearr_24411_24499 = state_24322__$1;
(statearr_24411_24499[(1)] = (13));

} else {
var statearr_24412_24500 = state_24322__$1;
(statearr_24412_24500[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (18))){
var inst_24131 = (state_24322[(13)]);
var inst_24134 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_24131,q_map,vars,fuel,max_fuel,opts);
var state_24322__$1 = state_24322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24322__$1,(21),inst_24134);
} else {
if((state_val_24323 === (52))){
var state_24322__$1 = state_24322;
var statearr_24413_24501 = state_24322__$1;
(statearr_24413_24501[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (67))){
var inst_24300 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24415_24502 = state_24322__$1;
(statearr_24415_24502[(2)] = inst_24300);

(statearr_24415_24502[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (71))){
var inst_24289 = (state_24322[(24)]);
var inst_24292 = (state_24322[(2)]);
var inst_24293 = fluree.db.util.async.throw_err.call(null,inst_24292);
var inst_24294 = [inst_24293,r];
var inst_24295 = (new cljs.core.PersistentVector(null,2,(5),inst_24289,inst_24294,null));
var state_24322__$1 = state_24322;
var statearr_24416_24503 = state_24322__$1;
(statearr_24416_24503[(2)] = inst_24295);

(statearr_24416_24503[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (42))){
var inst_24313 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24417_24504 = state_24322__$1;
(statearr_24417_24504[(2)] = inst_24313);

(statearr_24417_24504[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (37))){
var inst_24207 = cljs.core.second.call(null,clause);
var inst_24208 = cljs.core._EQ_.call(null,inst_24207,"rdf:type");
var state_24322__$1 = state_24322;
var statearr_24418_24505 = state_24322__$1;
(statearr_24418_24505[(2)] = inst_24208);

(statearr_24418_24505[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (63))){
var inst_24302 = (state_24322[(2)]);
var state_24322__$1 = state_24322;
var statearr_24419_24506 = state_24322__$1;
(statearr_24419_24506[(2)] = inst_24302);

(statearr_24419_24506[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (8))){
var inst_24317 = (state_24322[(2)]);
var _ = (function (){var statearr_24420 = state_24322;
(statearr_24420[(4)] = cljs.core.rest.call(null,(state_24322[(4)])));

return statearr_24420;
})();
var state_24322__$1 = state_24322;
var statearr_24421_24507 = state_24322__$1;
(statearr_24421_24507[(2)] = inst_24317);

(statearr_24421_24507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24323 === (49))){
var inst_24241 = cljs.core.count.call(null,clause);
var inst_24242 = cljs.core._EQ_.call(null,(1),inst_24241);
var state_24322__$1 = state_24322;
if(inst_24242){
var statearr_24422_24508 = state_24322__$1;
(statearr_24422_24508[(1)] = (51));

} else {
var statearr_24423_24509 = state_24322__$1;
(statearr_24423_24509[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_24424 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24424[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__);

(statearr_24424[(1)] = (1));

return statearr_24424;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1 = (function (state_24322){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_24322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24425){var ex__2687__auto__ = e24425;
var statearr_24426_24510 = state_24322;
(statearr_24426_24510[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_24322[(4)]))){
var statearr_24427_24511 = state_24322;
(statearr_24427_24511[(1)] = cljs.core.first.call(null,(state_24322[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24512 = state_24322;
state_24322 = G__24512;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__ = function(state_24322){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1.call(this,state_24322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24428 = f__2707__auto__.call(null);
(statearr_24428[(6)] = c__2706__auto__);

return statearr_24428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__24514 = arguments.length;
switch (G__24514) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24593){
var state_val_24594 = (state_24593[(1)]);
if((state_val_24594 === (7))){
var inst_24588 = (state_24593[(2)]);
var _ = (function (){var statearr_24595 = state_24593;
(statearr_24595[(4)] = cljs.core.rest.call(null,(state_24593[(4)])));

return statearr_24595;
})();
var state_24593__$1 = state_24593;
var statearr_24596_24644 = state_24593__$1;
(statearr_24596_24644[(2)] = inst_24588);

(statearr_24596_24644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (20))){
var inst_24553 = (state_24593[(7)]);
var inst_24565 = (state_24593[(2)]);
var inst_24535 = inst_24553;
var inst_24536 = inst_24565;
var state_24593__$1 = (function (){var statearr_24597 = state_24593;
(statearr_24597[(8)] = inst_24536);

(statearr_24597[(9)] = inst_24535);

return statearr_24597;
})();
var statearr_24598_24645 = state_24593__$1;
(statearr_24598_24645[(2)] = null);

(statearr_24598_24645[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (1))){
var state_24593__$1 = state_24593;
var statearr_24599_24646 = state_24593__$1;
(statearr_24599_24646[(2)] = null);

(statearr_24599_24646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (24))){
var inst_24536 = (state_24593[(8)]);
var inst_24552 = (state_24593[(10)]);
var inst_24553 = (state_24593[(7)]);
var inst_24573 = fluree.db.query.analytical.inner_join.call(null,inst_24536,inst_24552);
var inst_24535 = inst_24553;
var inst_24536__$1 = inst_24573;
var state_24593__$1 = (function (){var statearr_24600 = state_24593;
(statearr_24600[(8)] = inst_24536__$1);

(statearr_24600[(9)] = inst_24535);

return statearr_24600;
})();
var statearr_24601_24647 = state_24593__$1;
(statearr_24601_24647[(2)] = null);

(statearr_24601_24647[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (4))){
var inst_24515 = (state_24593[(2)]);
var state_24593__$1 = state_24593;
var statearr_24603_24648 = state_24593__$1;
(statearr_24603_24648[(2)] = inst_24515);

(statearr_24603_24648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (15))){
var inst_24552 = (state_24593[(10)]);
var state_24593__$1 = state_24593;
if(cljs.core.truth_(inst_24552)){
var statearr_24604_24649 = state_24593__$1;
(statearr_24604_24649[(1)] = (18));

} else {
var statearr_24605_24650 = state_24593__$1;
(statearr_24605_24650[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (21))){
var inst_24536 = (state_24593[(8)]);
var inst_24553 = (state_24593[(7)]);
var tmp24602 = inst_24536;
var inst_24535 = inst_24553;
var inst_24536__$1 = tmp24602;
var state_24593__$1 = (function (){var statearr_24606 = state_24593;
(statearr_24606[(8)] = inst_24536__$1);

(statearr_24606[(9)] = inst_24535);

return statearr_24606;
})();
var statearr_24607_24651 = state_24593__$1;
(statearr_24607_24651[(2)] = null);

(statearr_24607_24651[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (13))){
var inst_24536 = (state_24593[(8)]);
var inst_24559 = cljs.core.dissoc.call(null,inst_24536,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_24560 = cljs.core.empty_QMARK_.call(null,inst_24559);
var state_24593__$1 = state_24593;
if(inst_24560){
var statearr_24608_24652 = state_24593__$1;
(statearr_24608_24652[(1)] = (15));

} else {
var statearr_24609_24653 = state_24593__$1;
(statearr_24609_24653[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (22))){
var state_24593__$1 = state_24593;
var statearr_24610_24654 = state_24593__$1;
(statearr_24610_24654[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (6))){
var inst_24535 = (state_24593[(9)]);
var inst_24542 = (state_24593[(11)]);
var inst_24541 = cljs.core.seq.call(null,inst_24535);
var inst_24542__$1 = cljs.core.first.call(null,inst_24541);
var inst_24543 = cljs.core.next.call(null,inst_24541);
var state_24593__$1 = (function (){var statearr_24612 = state_24593;
(statearr_24612[(12)] = inst_24543);

(statearr_24612[(11)] = inst_24542__$1);

return statearr_24612;
})();
if(cljs.core.truth_(inst_24542__$1)){
var statearr_24613_24655 = state_24593__$1;
(statearr_24613_24655[(1)] = (8));

} else {
var statearr_24614_24656 = state_24593__$1;
(statearr_24614_24656[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (25))){
var state_24593__$1 = state_24593;
var statearr_24615_24657 = state_24593__$1;
(statearr_24615_24657[(2)] = null);

(statearr_24615_24657[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (17))){
var inst_24581 = (state_24593[(2)]);
var state_24593__$1 = state_24593;
var statearr_24616_24658 = state_24593__$1;
(statearr_24616_24658[(2)] = inst_24581);

(statearr_24616_24658[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (3))){
var inst_24591 = (state_24593[(2)]);
var state_24593__$1 = state_24593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24593__$1,inst_24591);
} else {
if((state_val_24594 === (12))){
var inst_24552 = (state_24593[(10)]);
var inst_24553 = (state_24593[(7)]);
var inst_24535 = inst_24553;
var inst_24536 = inst_24552;
var state_24593__$1 = (function (){var statearr_24617 = state_24593;
(statearr_24617[(8)] = inst_24536);

(statearr_24617[(9)] = inst_24535);

return statearr_24617;
})();
var statearr_24618_24659 = state_24593__$1;
(statearr_24618_24659[(2)] = null);

(statearr_24618_24659[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (2))){
var _ = (function (){var statearr_24619 = state_24593;
(statearr_24619[(4)] = cljs.core.cons.call(null,(5),(state_24593[(4)])));

return statearr_24619;
})();
var inst_24528 = where;
var inst_24529 = cljs.core.seq.call(null,inst_24528);
var inst_24530 = cljs.core.first.call(null,inst_24529);
var inst_24531 = cljs.core.next.call(null,inst_24529);
var inst_24532 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_24533 = [vars];
var inst_24534 = cljs.core.PersistentHashMap.fromArrays(inst_24532,inst_24533);
var inst_24535 = inst_24528;
var inst_24536 = inst_24534;
var state_24593__$1 = (function (){var statearr_24620 = state_24593;
(statearr_24620[(8)] = inst_24536);

(statearr_24620[(9)] = inst_24535);

(statearr_24620[(13)] = inst_24531);

(statearr_24620[(14)] = inst_24530);

return statearr_24620;
})();
var statearr_24621_24660 = state_24593__$1;
(statearr_24621_24660[(2)] = null);

(statearr_24621_24660[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (23))){
var inst_24579 = (state_24593[(2)]);
var state_24593__$1 = state_24593;
var statearr_24622_24661 = state_24593__$1;
(statearr_24622_24661[(2)] = inst_24579);

(statearr_24622_24661[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (19))){
var inst_24536 = (state_24593[(8)]);
var state_24593__$1 = state_24593;
var statearr_24623_24662 = state_24593__$1;
(statearr_24623_24662[(2)] = inst_24536);

(statearr_24623_24662[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (11))){
var inst_24542 = (state_24593[(11)]);
var inst_24550 = (state_24593[(2)]);
var inst_24551 = fluree.db.util.async.throw_err.call(null,inst_24550);
var inst_24552 = cljs.core.nth.call(null,inst_24551,(0),null);
var inst_24553 = cljs.core.nth.call(null,inst_24551,(1),null);
var inst_24554 = cljs.core.count.call(null,inst_24542);
var inst_24555 = cljs.core._EQ_.call(null,(2),inst_24554);
var state_24593__$1 = (function (){var statearr_24625 = state_24593;
(statearr_24625[(10)] = inst_24552);

(statearr_24625[(7)] = inst_24553);

return statearr_24625;
})();
if(inst_24555){
var statearr_24626_24663 = state_24593__$1;
(statearr_24626_24663[(1)] = (12));

} else {
var statearr_24627_24664 = state_24593__$1;
(statearr_24627_24664[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (9))){
var inst_24536 = (state_24593[(8)]);
var state_24593__$1 = state_24593;
var statearr_24628_24665 = state_24593__$1;
(statearr_24628_24665[(2)] = inst_24536);

(statearr_24628_24665[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (5))){
var _ = (function (){var statearr_24629 = state_24593;
(statearr_24629[(4)] = cljs.core.rest.call(null,(state_24593[(4)])));

return statearr_24629;
})();
var state_24593__$1 = state_24593;
var ex24624 = (state_24593__$1[(2)]);
var statearr_24630_24666 = state_24593__$1;
(statearr_24630_24666[(5)] = ex24624);


if((ex24624 instanceof Error)){
var statearr_24631_24667 = state_24593__$1;
(statearr_24631_24667[(1)] = (4));

(statearr_24631_24667[(5)] = null);

} else {
throw ex24624;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (14))){
var inst_24583 = (state_24593[(2)]);
var state_24593__$1 = state_24593;
var statearr_24632_24668 = state_24593__$1;
(statearr_24632_24668[(2)] = inst_24583);

(statearr_24632_24668[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (26))){
var inst_24577 = (state_24593[(2)]);
var state_24593__$1 = state_24593;
var statearr_24633_24669 = state_24593__$1;
(statearr_24633_24669[(2)] = inst_24577);

(statearr_24633_24669[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (16))){
var inst_24552 = (state_24593[(10)]);
var inst_24568 = (inst_24552 == null);
var state_24593__$1 = state_24593;
if(cljs.core.truth_(inst_24568)){
var statearr_24634_24670 = state_24593__$1;
(statearr_24634_24670[(1)] = (21));

} else {
var statearr_24635_24671 = state_24593__$1;
(statearr_24635_24671[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (10))){
var inst_24586 = (state_24593[(2)]);
var state_24593__$1 = state_24593;
var statearr_24636_24672 = state_24593__$1;
(statearr_24636_24672[(2)] = inst_24586);

(statearr_24636_24672[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (18))){
var inst_24552 = (state_24593[(10)]);
var state_24593__$1 = state_24593;
var statearr_24637_24673 = state_24593__$1;
(statearr_24637_24673[(2)] = inst_24552);

(statearr_24637_24673[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24594 === (8))){
var inst_24536 = (state_24593[(8)]);
var inst_24543 = (state_24593[(12)]);
var inst_24542 = (state_24593[(11)]);
var inst_24548 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_24536,inst_24542,inst_24543,false,fuel,max_fuel,opts);
var state_24593__$1 = state_24593;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24593__$1,(11),inst_24548);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2684__auto__ = null;
var fluree$db$query$analytical$state_machine__2684__auto____0 = (function (){
var statearr_24638 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24638[(0)] = fluree$db$query$analytical$state_machine__2684__auto__);

(statearr_24638[(1)] = (1));

return statearr_24638;
});
var fluree$db$query$analytical$state_machine__2684__auto____1 = (function (state_24593){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_24593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24639){var ex__2687__auto__ = e24639;
var statearr_24640_24674 = state_24593;
(statearr_24640_24674[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_24593[(4)]))){
var statearr_24641_24675 = state_24593;
(statearr_24641_24675[(1)] = cljs.core.first.call(null,(state_24593[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24676 = state_24593;
state_24593 = G__24676;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2684__auto__ = function(state_24593){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2684__auto____1.call(this,state_24593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2684__auto____0;
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2684__auto____1;
return fluree$db$query$analytical$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24642 = f__2707__auto__.call(null);
(statearr_24642[(6)] = c__2706__auto__);

return statearr_24642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(p__24677){
var map__24678 = p__24677;
var map__24678__$1 = cljs.core.__destructure_map.call(null,map__24678);
var opts = map__24678__$1;
var vars = cljs.core.get.call(null,map__24678__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var query_map = cljs.core.get.call(null,map__24678__$1,new cljs.core.Keyword(null,"query-map","query-map",-808576972));
var fuel = cljs.core.get.call(null,map__24678__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.call(null,map__24678__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var db = cljs.core.get.call(null,map__24678__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24712){
var state_val_24713 = (state_24712[(1)]);
if((state_val_24713 === (7))){
var inst_24689 = (state_24712[(7)]);
var inst_24694 = (state_24712[(8)]);
var inst_24696 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,query_map,inst_24689,inst_24694,fuel,max_fuel,opts);
var state_24712__$1 = state_24712;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24712__$1,(10),inst_24696);
} else {
if((state_val_24713 === (1))){
var state_24712__$1 = state_24712;
var statearr_24714_24739 = state_24712__$1;
(statearr_24714_24739[(2)] = null);

(statearr_24714_24739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24713 === (4))){
var inst_24679 = (state_24712[(2)]);
var state_24712__$1 = state_24712;
var statearr_24715_24740 = state_24712__$1;
(statearr_24715_24740[(2)] = inst_24679);

(statearr_24715_24740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24713 === (13))){
var inst_24707 = (state_24712[(2)]);
var _ = (function (){var statearr_24716 = state_24712;
(statearr_24716[(4)] = cljs.core.rest.call(null,(state_24712[(4)])));

return statearr_24716;
})();
var state_24712__$1 = state_24712;
var statearr_24717_24741 = state_24712__$1;
(statearr_24717_24741[(2)] = inst_24707);

(statearr_24717_24741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24713 === (6))){
var inst_24689 = (state_24712[(7)]);
var inst_24693 = (state_24712[(2)]);
var inst_24694 = fluree.db.util.async.throw_err.call(null,inst_24693);
var state_24712__$1 = (function (){var statearr_24718 = state_24712;
(statearr_24718[(8)] = inst_24694);

return statearr_24718;
})();
if(cljs.core.truth_(inst_24689)){
var statearr_24719_24742 = state_24712__$1;
(statearr_24719_24742[(1)] = (7));

} else {
var statearr_24720_24743 = state_24712__$1;
(statearr_24720_24743[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24713 === (3))){
var inst_24710 = (state_24712[(2)]);
var state_24712__$1 = state_24712;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24712__$1,inst_24710);
} else {
if((state_val_24713 === (12))){
var inst_24702 = (state_24712[(9)]);
var state_24712__$1 = state_24712;
var statearr_24721_24744 = state_24712__$1;
(statearr_24721_24744[(2)] = inst_24702);

(statearr_24721_24744[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24713 === (2))){
var _ = (function (){var statearr_24722 = state_24712;
(statearr_24722[(4)] = cljs.core.cons.call(null,(5),(state_24712[(4)])));

return statearr_24722;
})();
var inst_24686 = query_map;
var inst_24687 = cljs.core.__destructure_map.call(null,inst_24686);
var inst_24688 = cljs.core.get.call(null,inst_24687,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_24689 = cljs.core.get.call(null,inst_24687,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_24690 = cljs.core.get.call(null,inst_24687,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_24691 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_24688,query_map,vars,fuel,max_fuel,opts);
var state_24712__$1 = (function (){var statearr_24723 = state_24712;
(statearr_24723[(7)] = inst_24689);

(statearr_24723[(10)] = inst_24690);

return statearr_24723;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24712__$1,(6),inst_24691);
} else {
if((state_val_24713 === (11))){
var inst_24702 = (state_24712[(9)]);
var inst_24690 = (state_24712[(10)]);
var inst_24704 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_24702,inst_24690,null);
var state_24712__$1 = state_24712;
var statearr_24725_24745 = state_24712__$1;
(statearr_24725_24745[(2)] = inst_24704);

(statearr_24725_24745[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24713 === (9))){
var inst_24690 = (state_24712[(10)]);
var inst_24702 = (state_24712[(2)]);
var state_24712__$1 = (function (){var statearr_24726 = state_24712;
(statearr_24726[(9)] = inst_24702);

return statearr_24726;
})();
if(cljs.core.truth_(inst_24690)){
var statearr_24727_24746 = state_24712__$1;
(statearr_24727_24746[(1)] = (11));

} else {
var statearr_24728_24747 = state_24712__$1;
(statearr_24728_24747[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24713 === (5))){
var _ = (function (){var statearr_24729 = state_24712;
(statearr_24729[(4)] = cljs.core.rest.call(null,(state_24712[(4)])));

return statearr_24729;
})();
var state_24712__$1 = state_24712;
var ex24724 = (state_24712__$1[(2)]);
var statearr_24730_24748 = state_24712__$1;
(statearr_24730_24748[(5)] = ex24724);


if((ex24724 instanceof Error)){
var statearr_24731_24749 = state_24712__$1;
(statearr_24731_24749[(1)] = (4));

(statearr_24731_24749[(5)] = null);

} else {
throw ex24724;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24713 === (10))){
var inst_24698 = (state_24712[(2)]);
var inst_24699 = fluree.db.util.async.throw_err.call(null,inst_24698);
var state_24712__$1 = state_24712;
var statearr_24732_24750 = state_24712__$1;
(statearr_24732_24750[(2)] = inst_24699);

(statearr_24732_24750[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24713 === (8))){
var inst_24694 = (state_24712[(8)]);
var state_24712__$1 = state_24712;
var statearr_24733_24751 = state_24712__$1;
(statearr_24733_24751[(2)] = inst_24694);

(statearr_24733_24751[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2684__auto____0 = (function (){
var statearr_24734 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24734[(0)] = fluree$db$query$analytical$q_$_state_machine__2684__auto__);

(statearr_24734[(1)] = (1));

return statearr_24734;
});
var fluree$db$query$analytical$q_$_state_machine__2684__auto____1 = (function (state_24712){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_24712);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24735){var ex__2687__auto__ = e24735;
var statearr_24736_24752 = state_24712;
(statearr_24736_24752[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_24712[(4)]))){
var statearr_24737_24753 = state_24712;
(statearr_24737_24753[(1)] = cljs.core.first.call(null,(state_24712[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24754 = state_24712;
state_24712 = G__24754;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2684__auto__ = function(state_24712){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2684__auto____1.call(this,state_24712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2684__auto____0;
fluree$db$query$analytical$q_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24738 = f__2707__auto__.call(null);
(statearr_24738[(6)] = c__2706__auto__);

return statearr_24738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
