// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__22763_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__22763_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__22767 = coll;
var vec__22768 = G__22767;
var seq__22769 = cljs.core.seq.call(null,vec__22768);
var first__22770 = cljs.core.first.call(null,seq__22769);
var seq__22769__$1 = cljs.core.next.call(null,seq__22769);
var clause = first__22770;
var r = seq__22769__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__22767__$1 = G__22767;
var res__$1 = res;
while(true){
var vec__22774 = G__22767__$1;
var seq__22775 = cljs.core.seq.call(null,vec__22774);
var first__22776 = cljs.core.first.call(null,seq__22775);
var seq__22775__$1 = cljs.core.next.call(null,seq__22775);
var clause__$1 = first__22776;
var r__$1 = seq__22775__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__22777 = r__$1;
var G__22778 = cljs.core.conj.call(null,res__$2,clause__$1);
G__22767__$1 = G__22777;
res__$1 = G__22778;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__22779){
var map__22780 = p__22779;
var map__22780__$1 = cljs.core.__destructure_map.call(null,map__22780);
var optional = cljs.core.get.call(null,map__22780__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__22784 = coll;
var vec__22785 = G__22784;
var seq__22786 = cljs.core.seq.call(null,vec__22785);
var first__22787 = cljs.core.first.call(null,seq__22786);
var seq__22786__$1 = cljs.core.next.call(null,seq__22786);
var clause = first__22787;
var r = seq__22786__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__22784__$1 = G__22784;
var res__$1 = res;
while(true){
var vec__22791 = G__22784__$1;
var seq__22792 = cljs.core.seq.call(null,vec__22791);
var first__22793 = cljs.core.first.call(null,seq__22792);
var seq__22792__$1 = cljs.core.next.call(null,seq__22792);
var clause__$1 = first__22793;
var r__$1 = seq__22792__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__22794 = r__$1;
var G__22795 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__22784__$1 = G__22794;
res__$1 = G__22795;
continue;
} else {
var G__22796 = r__$1;
var G__22797 = res__$2;
G__22784__$1 = G__22796;
res__$1 = G__22797;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__22801 = coll;
var vec__22802 = G__22801;
var seq__22803 = cljs.core.seq.call(null,vec__22802);
var first__22804 = cljs.core.first.call(null,seq__22803);
var seq__22803__$1 = cljs.core.next.call(null,seq__22803);
var clause = first__22804;
var r = seq__22803__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__22801__$1 = G__22801;
var res__$1 = res;
while(true){
var vec__22808 = G__22801__$1;
var seq__22809 = cljs.core.seq.call(null,vec__22808);
var first__22810 = cljs.core.first.call(null,seq__22809);
var seq__22809__$1 = cljs.core.next.call(null,seq__22809);
var clause__$1 = first__22810;
var r__$1 = seq__22809__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__22811 = r__$1;
var G__22812 = res__$2;
G__22801__$1 = G__22811;
res__$1 = G__22812;
continue;
} else {
var G__22813 = r__$1;
var G__22814 = cljs.core.conj.call(null,res__$2,clause__$1);
G__22801__$1 = G__22813;
res__$1 = G__22814;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__22817 = clause;
var G__22817__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__22817):G__22817);
var G__22817__$2 = clojure.string.join.call(null," ",G__22817__$1)
;
var G__22817__$3 = (function (p1__22815_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__22815_SHARP_)," ."].join('');
}).call(null,G__22817__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__22816_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__22816_SHARP_),"}"].join('');
}).call(null,G__22817__$3);
} else {
return G__22817__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__22821 = opts;
var map__22821__$1 = cljs.core.__destructure_map.call(null,map__22821);
var limit = cljs.core.get.call(null,map__22821__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__22821__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__22821__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__22821__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__22821__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__22818_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__22818_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__22819_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__22819_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__22820_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__22820_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22835){
var state_val_22836 = (state_22835[(1)]);
if((state_val_22836 === (1))){
var inst_22822 = fluree.db.util.core.url_encode.call(null,query);
var inst_22823 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_22822)].join('');
var inst_22824 = ["User-Agent","Accept"];
var inst_22825 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_22826 = cljs.core.PersistentHashMap.fromArrays(inst_22824,inst_22825);
var inst_22827 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_22828 = [inst_22826,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_22829 = cljs.core.PersistentHashMap.fromArrays(inst_22827,inst_22828);
var inst_22830 = fluree.db.util.xhttp.get.call(null,inst_22823,inst_22829);
var state_22835__$1 = state_22835;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22835__$1,(2),inst_22830);
} else {
if((state_val_22836 === (2))){
var inst_22832 = (state_22835[(2)]);
var inst_22833 = fluree.db.util.async.throw_err.call(null,inst_22832);
var state_22835__$1 = state_22835;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22835__$1,inst_22833);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0 = (function (){
var statearr_22837 = [null,null,null,null,null,null,null];
(statearr_22837[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__);

(statearr_22837[(1)] = (1));

return statearr_22837;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1 = (function (state_22835){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_22835);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22838){var ex__2687__auto__ = e22838;
var statearr_22839_22842 = state_22835;
(statearr_22839_22842[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_22835[(4)]))){
var statearr_22840_22843 = state_22835;
(statearr_22840_22843[(1)] = cljs.core.first.call(null,(state_22835[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22844 = state_22835;
state_22835 = G__22844;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__ = function(state_22835){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1.call(this,state_22835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22841 = f__2707__auto__.call(null);
(statearr_22841[(6)] = c__2706__auto__);

return statearr_22841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22862){
var state_val_22863 = (state_22862[(1)]);
if((state_val_22863 === (1))){
var inst_22845 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_22862__$1 = state_22862;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22862__$1,(2),inst_22845);
} else {
if((state_val_22863 === (2))){
var inst_22848 = (state_22862[(7)]);
var inst_22847 = (state_22862[(2)]);
var inst_22848__$1 = fluree.db.util.async.throw_err.call(null,inst_22847);
var inst_22849 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_22848__$1);
var inst_22850 = cljs.core.not_EQ_.call(null,(200),inst_22849);
var state_22862__$1 = (function (){var statearr_22864 = state_22862;
(statearr_22864[(7)] = inst_22848__$1);

return statearr_22864;
})();
if(inst_22850){
var statearr_22865_22874 = state_22862__$1;
(statearr_22865_22874[(1)] = (3));

} else {
var statearr_22866_22875 = state_22862__$1;
(statearr_22866_22875[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22863 === (3))){
var inst_22848 = (state_22862[(7)]);
var state_22862__$1 = state_22862;
var statearr_22867_22876 = state_22862__$1;
(statearr_22867_22876[(2)] = inst_22848);

(statearr_22867_22876[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22863 === (4))){
var inst_22848 = (state_22862[(7)]);
var inst_22853 = (function (){var body = inst_22848;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_22854 = cljs.core.second.call(null,inst_22848);
var inst_22855 = cljs.core.second.call(null,inst_22854);
var inst_22856 = cljs.core.first.call(null,inst_22855);
var inst_22857 = cljs.core.second.call(null,inst_22856);
var inst_22858 = cljs.core.mapv.call(null,inst_22853,inst_22857);
var state_22862__$1 = state_22862;
var statearr_22868_22877 = state_22862__$1;
(statearr_22868_22877[(2)] = inst_22858);

(statearr_22868_22877[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22863 === (5))){
var inst_22860 = (state_22862[(2)]);
var state_22862__$1 = state_22862;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22862__$1,inst_22860);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0 = (function (){
var statearr_22869 = [null,null,null,null,null,null,null,null];
(statearr_22869[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__);

(statearr_22869[(1)] = (1));

return statearr_22869;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1 = (function (state_22862){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_22862);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22870){var ex__2687__auto__ = e22870;
var statearr_22871_22878 = state_22862;
(statearr_22871_22878[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_22862[(4)]))){
var statearr_22872_22879 = state_22862;
(statearr_22872_22879[(1)] = cljs.core.first.call(null,(state_22862[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22880 = state_22862;
state_22862 = G__22880;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__ = function(state_22862){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1.call(this,state_22862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22873 = f__2707__auto__.call(null);
(statearr_22873[(6)] = c__2706__auto__);

return statearr_22873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__22881_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__22881_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__22882_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__22882_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__22883_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__22883_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22929){
var state_val_22930 = (state_22929[(1)]);
if((state_val_22930 === (7))){
var inst_22894 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_22929__$1 = state_22929;
var statearr_22931_22959 = state_22929__$1;
(statearr_22931_22959[(2)] = inst_22894);

(statearr_22931_22959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (1))){
var state_22929__$1 = state_22929;
var statearr_22932_22960 = state_22929__$1;
(statearr_22932_22960[(2)] = null);

(statearr_22932_22960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (4))){
var inst_22884 = (state_22929[(2)]);
var state_22929__$1 = state_22929;
var statearr_22933_22961 = state_22929__$1;
(statearr_22933_22961[(2)] = inst_22884);

(statearr_22933_22961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (15))){
var inst_22903 = (state_22929[(7)]);
var inst_22902 = (state_22929[(8)]);
var inst_22908 = (state_22929[(9)]);
var inst_22913 = (state_22929[(2)]);
var inst_22914 = cljs.core.subs.call(null,inst_22908,(0),inst_22913);
var inst_22915 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22916 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_22902);
var inst_22917 = [inst_22903,inst_22916];
var inst_22918 = cljs.core.PersistentHashMap.fromArrays(inst_22915,inst_22917);
var inst_22919 = cljs.core.ex_info.call(null,inst_22914,inst_22918);
var inst_22920 = (function(){throw inst_22919})();
var state_22929__$1 = state_22929;
var statearr_22934_22962 = state_22929__$1;
(statearr_22934_22962[(2)] = inst_22920);

(statearr_22934_22962[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (13))){
var inst_22907 = (state_22929[(10)]);
var state_22929__$1 = state_22929;
var statearr_22935_22963 = state_22929__$1;
(statearr_22935_22963[(2)] = inst_22907);

(statearr_22935_22963[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (6))){
var state_22929__$1 = state_22929;
var statearr_22936_22964 = state_22929__$1;
(statearr_22936_22964[(2)] = null);

(statearr_22936_22964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (3))){
var inst_22927 = (state_22929[(2)]);
var state_22929__$1 = state_22929;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22929__$1,inst_22927);
} else {
if((state_val_22930 === (12))){
var inst_22924 = (state_22929[(2)]);
var _ = (function (){var statearr_22937 = state_22929;
(statearr_22937[(4)] = cljs.core.rest.call(null,(state_22929[(4)])));

return statearr_22937;
})();
var state_22929__$1 = state_22929;
var statearr_22938_22965 = state_22929__$1;
(statearr_22938_22965[(2)] = inst_22924);

(statearr_22938_22965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (2))){
var _ = (function (){var statearr_22939 = state_22929;
(statearr_22939[(4)] = cljs.core.cons.call(null,(5),(state_22929[(4)])));

return statearr_22939;
})();
var inst_22891 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_22929__$1 = state_22929;
if(inst_22891){
var statearr_22940_22966 = state_22929__$1;
(statearr_22940_22966[(1)] = (6));

} else {
var statearr_22941_22967 = state_22929__$1;
(statearr_22941_22967[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (11))){
var inst_22902 = (state_22929[(8)]);
var inst_22922 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_22902,all_vars);
var state_22929__$1 = state_22929;
var statearr_22943_22968 = state_22929__$1;
(statearr_22943_22968[(2)] = inst_22922);

(statearr_22943_22968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (9))){
var inst_22903 = (state_22929[(7)]);
var inst_22902 = (state_22929[(8)]);
var inst_22900 = (state_22929[(2)]);
var inst_22901 = fluree.db.util.async.throw_err.call(null,inst_22900);
var inst_22902__$1 = cljs.core.__destructure_map.call(null,inst_22901);
var inst_22903__$1 = cljs.core.get.call(null,inst_22902__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_22904 = cljs.core.get.call(null,inst_22902__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_22905 = cljs.core._EQ_.call(null,(400),inst_22903__$1);
var state_22929__$1 = (function (){var statearr_22944 = state_22929;
(statearr_22944[(7)] = inst_22903__$1);

(statearr_22944[(8)] = inst_22902__$1);

(statearr_22944[(11)] = inst_22904);

return statearr_22944;
})();
if(inst_22905){
var statearr_22945_22969 = state_22929__$1;
(statearr_22945_22969[(1)] = (10));

} else {
var statearr_22946_22970 = state_22929__$1;
(statearr_22946_22970[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (5))){
var _ = (function (){var statearr_22947 = state_22929;
(statearr_22947[(4)] = cljs.core.rest.call(null,(state_22929[(4)])));

return statearr_22947;
})();
var state_22929__$1 = state_22929;
var ex22942 = (state_22929__$1[(2)]);
var statearr_22948_22971 = state_22929__$1;
(statearr_22948_22971[(5)] = ex22942);


if((ex22942 instanceof Error)){
var statearr_22949_22972 = state_22929__$1;
(statearr_22949_22972[(1)] = (4));

(statearr_22949_22972[(5)] = null);

} else {
throw ex22942;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (14))){
var state_22929__$1 = state_22929;
var statearr_22950_22973 = state_22929__$1;
(statearr_22950_22973[(2)] = (1000));

(statearr_22950_22973[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (10))){
var inst_22907 = (state_22929[(10)]);
var inst_22902 = (state_22929[(8)]);
var inst_22904 = (state_22929[(11)]);
var inst_22907__$1 = cljs.core.count.call(null,inst_22904);
var inst_22908 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_22902);
var inst_22909 = (inst_22907__$1 < (1000));
var state_22929__$1 = (function (){var statearr_22951 = state_22929;
(statearr_22951[(10)] = inst_22907__$1);

(statearr_22951[(9)] = inst_22908);

return statearr_22951;
})();
if(cljs.core.truth_(inst_22909)){
var statearr_22952_22974 = state_22929__$1;
(statearr_22952_22974[(1)] = (13));

} else {
var statearr_22953_22975 = state_22929__$1;
(statearr_22953_22975[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22930 === (8))){
var inst_22896 = (state_22929[(2)]);
var inst_22897 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_22896,optional_clauses);
var inst_22898 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_22897);
var state_22929__$1 = state_22929;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22929__$1,(9),inst_22898);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_22954 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22954[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__);

(statearr_22954[(1)] = (1));

return statearr_22954;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1 = (function (state_22929){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_22929);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22955){var ex__2687__auto__ = e22955;
var statearr_22956_22976 = state_22929;
(statearr_22956_22976[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_22929[(4)]))){
var statearr_22957_22977 = state_22929;
(statearr_22957_22977[(1)] = cljs.core.first.call(null,(state_22929[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22978 = state_22929;
state_22929 = G__22978;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__ = function(state_22929){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1.call(this,state_22929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22958 = f__2707__auto__.call(null);
(statearr_22958[(6)] = c__2706__auto__);

return statearr_22958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
