// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__18443 = arguments.length;
switch (G__18443) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,opts,reverse_refs_specs){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18604){
var state_val_18605 = (state_18604[(1)]);
if((state_val_18605 === (7))){
var inst_18599 = (state_18604[(2)]);
var _ = (function (){var statearr_18606 = state_18604;
(statearr_18606[(4)] = cljs.core.rest.call(null,(state_18604[(4)])));

return statearr_18606;
})();
var state_18604__$1 = state_18604;
var statearr_18607_18689 = state_18604__$1;
(statearr_18607_18689[(2)] = inst_18599);

(statearr_18607_18689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (20))){
var inst_18526 = (state_18604[(7)]);
var state_18604__$1 = state_18604;
var statearr_18608_18690 = state_18604__$1;
(statearr_18608_18690[(2)] = inst_18526);

(statearr_18608_18690[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (27))){
var inst_18481 = (state_18604[(8)]);
var state_18604__$1 = state_18604;
if(cljs.core.truth_(inst_18481)){
var statearr_18609_18691 = state_18604__$1;
(statearr_18609_18691[(1)] = (29));

} else {
var statearr_18610_18692 = state_18604__$1;
(statearr_18610_18692[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (1))){
var state_18604__$1 = state_18604;
var statearr_18611_18693 = state_18604__$1;
(statearr_18611_18693[(2)] = null);

(statearr_18611_18693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (24))){
var inst_18482 = (state_18604[(9)]);
var state_18604__$1 = state_18604;
var statearr_18612_18694 = state_18604__$1;
(statearr_18612_18694[(2)] = inst_18482);

(statearr_18612_18694[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (39))){
var inst_18518 = (state_18604[(10)]);
var state_18604__$1 = state_18604;
var statearr_18613_18695 = state_18604__$1;
(statearr_18613_18695[(2)] = inst_18518);

(statearr_18613_18695[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (46))){
var inst_18483 = (state_18604[(11)]);
var state_18604__$1 = state_18604;
var statearr_18614_18696 = state_18604__$1;
(statearr_18614_18696[(2)] = inst_18483);

(statearr_18614_18696[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (4))){
var inst_18445 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
var statearr_18615_18697 = state_18604__$1;
(statearr_18615_18697[(2)] = inst_18445);

(statearr_18615_18697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (15))){
var inst_18494 = (state_18604[(12)]);
var inst_18500 = cljs.core.count.call(null,inst_18494);
var inst_18501 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_18500,max_fuel);
var state_18604__$1 = state_18604;
var statearr_18616_18698 = state_18604__$1;
(statearr_18616_18698[(2)] = inst_18501);

(statearr_18616_18698[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (48))){
var inst_18585 = (state_18604[(13)]);
var inst_18463 = (state_18604[(14)]);
var inst_18470 = (state_18604[(15)]);
var inst_18593 = (state_18604[(2)]);
var inst_18594 = cljs.core.assoc.call(null,inst_18463,inst_18593,inst_18585);
var inst_18462 = inst_18470;
var inst_18463__$1 = inst_18594;
var state_18604__$1 = (function (){var statearr_18617 = state_18604;
(statearr_18617[(16)] = inst_18462);

(statearr_18617[(14)] = inst_18463__$1);

return statearr_18617;
})();
var statearr_18618_18699 = state_18604__$1;
(statearr_18618_18699[(2)] = null);

(statearr_18618_18699[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (50))){
var inst_18485 = (state_18604[(17)]);
var state_18604__$1 = state_18604;
var statearr_18619_18700 = state_18604__$1;
(statearr_18619_18700[(2)] = inst_18485);

(statearr_18619_18700[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (21))){
var inst_18482 = (state_18604[(9)]);
var state_18604__$1 = state_18604;
if(cljs.core.truth_(inst_18482)){
var statearr_18621_18701 = state_18604__$1;
(statearr_18621_18701[(1)] = (23));

} else {
var statearr_18622_18702 = state_18604__$1;
(statearr_18622_18702[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (31))){
var inst_18542 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
if(cljs.core.truth_(inst_18542)){
var statearr_18623_18703 = state_18604__$1;
(statearr_18623_18703[(1)] = (32));

} else {
var statearr_18624_18704 = state_18604__$1;
(statearr_18624_18704[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (32))){
var inst_18525 = (state_18604[(18)]);
var inst_18517 = (state_18604[(19)]);
var inst_18518 = (state_18604[(10)]);
var inst_18544 = (inst_18517 + (1));
var tmp18620 = inst_18518;
var inst_18516 = inst_18525;
var inst_18517__$1 = inst_18544;
var inst_18518__$1 = tmp18620;
var state_18604__$1 = (function (){var statearr_18625 = state_18604;
(statearr_18625[(20)] = inst_18516);

(statearr_18625[(19)] = inst_18517__$1);

(statearr_18625[(10)] = inst_18518__$1);

return statearr_18625;
})();
var statearr_18626_18705 = state_18604__$1;
(statearr_18626_18705[(2)] = null);

(statearr_18626_18705[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (40))){
var state_18604__$1 = state_18604;
if(cljs.core.truth_(fuel)){
var statearr_18627_18706 = state_18604__$1;
(statearr_18627_18706[(1)] = (42));

} else {
var statearr_18628_18707 = state_18604__$1;
(statearr_18628_18707[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (33))){
var state_18604__$1 = state_18604;
var statearr_18629_18708 = state_18604__$1;
(statearr_18629_18708[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (13))){
var inst_18494 = (state_18604[(12)]);
var state_18604__$1 = state_18604;
var statearr_18631_18709 = state_18604__$1;
(statearr_18631_18709[(2)] = inst_18494);

(statearr_18631_18709[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (22))){
var inst_18535 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
if(cljs.core.truth_(inst_18535)){
var statearr_18632_18710 = state_18604__$1;
(statearr_18632_18710[(1)] = (26));

} else {
var statearr_18633_18711 = state_18604__$1;
(statearr_18633_18711[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (36))){
var state_18604__$1 = state_18604;
var statearr_18634_18712 = state_18604__$1;
(statearr_18634_18712[(2)] = null);

(statearr_18634_18712[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (41))){
var inst_18525 = (state_18604[(18)]);
var inst_18517 = (state_18604[(19)]);
var inst_18574 = (state_18604[(2)]);
var inst_18575 = (inst_18517 + (1));
var inst_18516 = inst_18525;
var inst_18517__$1 = inst_18575;
var inst_18518 = inst_18574;
var state_18604__$1 = (function (){var statearr_18635 = state_18604;
(statearr_18635[(20)] = inst_18516);

(statearr_18635[(19)] = inst_18517__$1);

(statearr_18635[(10)] = inst_18518);

return statearr_18635;
})();
var statearr_18636_18713 = state_18604__$1;
(statearr_18636_18713[(2)] = null);

(statearr_18636_18713[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (43))){
var state_18604__$1 = state_18604;
var statearr_18637_18714 = state_18604__$1;
(statearr_18637_18714[(2)] = null);

(statearr_18637_18714[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (29))){
var inst_18481 = (state_18604[(8)]);
var inst_18517 = (state_18604[(19)]);
var inst_18539 = (inst_18517 < inst_18481);
var state_18604__$1 = state_18604;
var statearr_18638_18715 = state_18604__$1;
(statearr_18638_18715[(2)] = inst_18539);

(statearr_18638_18715[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (44))){
var inst_18554 = (state_18604[(21)]);
var inst_18558 = (state_18604[(22)]);
var inst_18567 = (state_18604[(2)]);
var inst_18568 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_18558,opts,inst_18554);
var state_18604__$1 = (function (){var statearr_18639 = state_18604;
(statearr_18639[(23)] = inst_18567);

return statearr_18639;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18604__$1,(45),inst_18568);
} else {
if((state_val_18605 === (6))){
var inst_18462 = (state_18604[(16)]);
var inst_18469 = (state_18604[(24)]);
var inst_18468 = cljs.core.seq.call(null,inst_18462);
var inst_18469__$1 = cljs.core.first.call(null,inst_18468);
var inst_18470 = cljs.core.next.call(null,inst_18468);
var inst_18471 = cljs.core.not.call(null,inst_18469__$1);
var state_18604__$1 = (function (){var statearr_18640 = state_18604;
(statearr_18640[(24)] = inst_18469__$1);

(statearr_18640[(15)] = inst_18470);

return statearr_18640;
})();
if(inst_18471){
var statearr_18641_18716 = state_18604__$1;
(statearr_18641_18716[(1)] = (8));

} else {
var statearr_18642_18717 = state_18604__$1;
(statearr_18642_18717[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (28))){
var inst_18583 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
var statearr_18643_18718 = state_18604__$1;
(statearr_18643_18718[(2)] = inst_18583);

(statearr_18643_18718[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (51))){
var inst_18591 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
var statearr_18644_18719 = state_18604__$1;
(statearr_18644_18719[(2)] = inst_18591);

(statearr_18644_18719[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (25))){
var inst_18533 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
var statearr_18645_18720 = state_18604__$1;
(statearr_18645_18720[(2)] = inst_18533);

(statearr_18645_18720[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (34))){
var inst_18581 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
var statearr_18646_18721 = state_18604__$1;
(statearr_18646_18721[(2)] = inst_18581);

(statearr_18646_18721[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (17))){
var inst_18494 = (state_18604[(12)]);
var inst_18504 = (state_18604[(2)]);
var inst_18512 = cljs.core.seq.call(null,inst_18494);
var inst_18513 = cljs.core.first.call(null,inst_18512);
var inst_18514 = cljs.core.next.call(null,inst_18512);
var inst_18515 = cljs.core.PersistentVector.EMPTY;
var inst_18516 = inst_18494;
var inst_18517 = (0);
var inst_18518 = inst_18515;
var state_18604__$1 = (function (){var statearr_18647 = state_18604;
(statearr_18647[(25)] = inst_18514);

(statearr_18647[(20)] = inst_18516);

(statearr_18647[(26)] = inst_18513);

(statearr_18647[(19)] = inst_18517);

(statearr_18647[(27)] = inst_18504);

(statearr_18647[(10)] = inst_18518);

return statearr_18647;
})();
var statearr_18648_18722 = state_18604__$1;
(statearr_18648_18722[(2)] = null);

(statearr_18648_18722[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (3))){
var inst_18602 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18604__$1,inst_18602);
} else {
if((state_val_18605 === (12))){
var state_18604__$1 = state_18604;
var statearr_18649_18723 = state_18604__$1;
(statearr_18649_18723[(2)] = fuel);

(statearr_18649_18723[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (2))){
var _ = (function (){var statearr_18650 = state_18604;
(statearr_18650[(4)] = cljs.core.cons.call(null,(5),(state_18604[(4)])));

return statearr_18650;
})();
var inst_18458 = reverse_refs_specs;
var inst_18459 = cljs.core.seq.call(null,inst_18458);
var inst_18460 = cljs.core.first.call(null,inst_18459);
var inst_18461 = cljs.core.next.call(null,inst_18459);
var inst_18462 = inst_18458;
var inst_18463 = null;
var state_18604__$1 = (function (){var statearr_18651 = state_18604;
(statearr_18651[(16)] = inst_18462);

(statearr_18651[(28)] = inst_18461);

(statearr_18651[(14)] = inst_18463);

(statearr_18651[(29)] = inst_18460);

return statearr_18651;
})();
var statearr_18652_18724 = state_18604__$1;
(statearr_18652_18724[(2)] = null);

(statearr_18652_18724[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (23))){
var inst_18482 = (state_18604[(9)]);
var inst_18517 = (state_18604[(19)]);
var inst_18530 = (inst_18517 >= inst_18482);
var state_18604__$1 = state_18604;
var statearr_18653_18725 = state_18604__$1;
(statearr_18653_18725[(2)] = inst_18530);

(statearr_18653_18725[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (47))){
var inst_18484 = (state_18604[(30)]);
var state_18604__$1 = state_18604;
if(cljs.core.truth_(inst_18484)){
var statearr_18654_18726 = state_18604__$1;
(statearr_18654_18726[(1)] = (49));

} else {
var statearr_18655_18727 = state_18604__$1;
(statearr_18655_18727[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (35))){
var inst_18524 = (state_18604[(31)]);
var inst_18548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18549 = [inst_18524];
var inst_18550 = (new cljs.core.PersistentVector(null,1,(5),inst_18548,inst_18549,null));
var inst_18551 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_18550);
var state_18604__$1 = state_18604;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18604__$1,(38),inst_18551);
} else {
if((state_val_18605 === (19))){
var inst_18483 = (state_18604[(11)]);
var inst_18585 = (state_18604[(2)]);
var state_18604__$1 = (function (){var statearr_18656 = state_18604;
(statearr_18656[(13)] = inst_18585);

return statearr_18656;
})();
if(cljs.core.truth_(inst_18483)){
var statearr_18657_18728 = state_18604__$1;
(statearr_18657_18728[(1)] = (46));

} else {
var statearr_18658_18729 = state_18604__$1;
(statearr_18658_18729[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (11))){
var inst_18494 = (state_18604[(12)]);
var inst_18491 = (state_18604[(2)]);
var inst_18492 = fluree.db.util.async.throw_err.call(null,inst_18491);
var inst_18493 = cljs.core.map.call(null,fluree.db.flake.s,inst_18492);
var inst_18494__$1 = cljs.core.not_empty.call(null,inst_18493);
var state_18604__$1 = (function (){var statearr_18660 = state_18604;
(statearr_18660[(12)] = inst_18494__$1);

return statearr_18660;
})();
if(cljs.core.truth_(inst_18494__$1)){
var statearr_18661_18730 = state_18604__$1;
(statearr_18661_18730[(1)] = (12));

} else {
var statearr_18662_18731 = state_18604__$1;
(statearr_18662_18731[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (9))){
var inst_18469 = (state_18604[(24)]);
var inst_18479 = (state_18604[(32)]);
var inst_18478 = cljs.core.nth.call(null,inst_18469,(0),null);
var inst_18479__$1 = cljs.core.nth.call(null,inst_18469,(1),null);
var inst_18480 = cljs.core.__destructure_map.call(null,inst_18479__$1);
var inst_18481 = cljs.core.get.call(null,inst_18480,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_18482 = cljs.core.get.call(null,inst_18480,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_18483 = cljs.core.get.call(null,inst_18480,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_18484 = cljs.core.get.call(null,inst_18480,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_18485 = cljs.core.get.call(null,inst_18480,new cljs.core.Keyword(null,"p","p",151049309));
var inst_18486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18487 = [subject_id,inst_18478];
var inst_18488 = (new cljs.core.PersistentVector(null,2,(5),inst_18486,inst_18487,null));
var inst_18489 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_18488);
var state_18604__$1 = (function (){var statearr_18663 = state_18604;
(statearr_18663[(30)] = inst_18484);

(statearr_18663[(8)] = inst_18481);

(statearr_18663[(11)] = inst_18483);

(statearr_18663[(17)] = inst_18485);

(statearr_18663[(9)] = inst_18482);

(statearr_18663[(32)] = inst_18479__$1);

return statearr_18663;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18604__$1,(11),inst_18489);
} else {
if((state_val_18605 === (5))){
var _ = (function (){var statearr_18664 = state_18604;
(statearr_18664[(4)] = cljs.core.rest.call(null,(state_18604[(4)])));

return statearr_18664;
})();
var state_18604__$1 = state_18604;
var ex18659 = (state_18604__$1[(2)]);
var statearr_18665_18732 = state_18604__$1;
(statearr_18665_18732[(5)] = ex18659);


if((ex18659 instanceof Error)){
var statearr_18666_18733 = state_18604__$1;
(statearr_18666_18733[(1)] = (4));

(statearr_18666_18733[(5)] = null);

} else {
throw ex18659;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (14))){
var inst_18498 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
if(cljs.core.truth_(inst_18498)){
var statearr_18667_18734 = state_18604__$1;
(statearr_18667_18734[(1)] = (15));

} else {
var statearr_18668_18735 = state_18604__$1;
(statearr_18668_18735[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (45))){
var inst_18518 = (state_18604[(10)]);
var inst_18570 = (state_18604[(2)]);
var inst_18571 = fluree.db.util.async.throw_err.call(null,inst_18570);
var inst_18572 = cljs.core.conj.call(null,inst_18518,inst_18571);
var state_18604__$1 = state_18604;
var statearr_18669_18736 = state_18604__$1;
(statearr_18669_18736[(2)] = inst_18572);

(statearr_18669_18736[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (26))){
var inst_18518 = (state_18604[(10)]);
var state_18604__$1 = state_18604;
var statearr_18670_18737 = state_18604__$1;
(statearr_18670_18737[(2)] = inst_18518);

(statearr_18670_18737[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (16))){
var state_18604__$1 = state_18604;
var statearr_18671_18738 = state_18604__$1;
(statearr_18671_18738[(2)] = null);

(statearr_18671_18738[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (38))){
var inst_18554 = (state_18604[(21)]);
var inst_18479 = (state_18604[(32)]);
var inst_18553 = (state_18604[(2)]);
var inst_18554__$1 = fluree.db.util.async.throw_err.call(null,inst_18553);
var inst_18555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18556 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_18557 = (new cljs.core.PersistentVector(null,4,(5),inst_18555,inst_18556,null));
var inst_18558 = cljs.core.select_keys.call(null,inst_18479,inst_18557);
var inst_18559 = cljs.core.empty_QMARK_.call(null,inst_18554__$1);
var state_18604__$1 = (function (){var statearr_18672 = state_18604;
(statearr_18672[(21)] = inst_18554__$1);

(statearr_18672[(22)] = inst_18558);

return statearr_18672;
})();
if(inst_18559){
var statearr_18673_18739 = state_18604__$1;
(statearr_18673_18739[(1)] = (39));

} else {
var statearr_18674_18740 = state_18604__$1;
(statearr_18674_18740[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (30))){
var inst_18481 = (state_18604[(8)]);
var state_18604__$1 = state_18604;
var statearr_18675_18741 = state_18604__$1;
(statearr_18675_18741[(2)] = inst_18481);

(statearr_18675_18741[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (10))){
var inst_18597 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
var statearr_18676_18742 = state_18604__$1;
(statearr_18676_18742[(2)] = inst_18597);

(statearr_18676_18742[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (18))){
var inst_18526 = (state_18604[(7)]);
var inst_18516 = (state_18604[(20)]);
var inst_18524 = (state_18604[(31)]);
var inst_18523 = cljs.core.seq.call(null,inst_18516);
var inst_18524__$1 = cljs.core.first.call(null,inst_18523);
var inst_18525 = cljs.core.next.call(null,inst_18523);
var inst_18526__$1 = cljs.core.not.call(null,inst_18524__$1);
var state_18604__$1 = (function (){var statearr_18677 = state_18604;
(statearr_18677[(18)] = inst_18525);

(statearr_18677[(7)] = inst_18526__$1);

(statearr_18677[(31)] = inst_18524__$1);

return statearr_18677;
})();
if(inst_18526__$1){
var statearr_18678_18743 = state_18604__$1;
(statearr_18678_18743[(1)] = (20));

} else {
var statearr_18679_18744 = state_18604__$1;
(statearr_18679_18744[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (42))){
var inst_18554 = (state_18604[(21)]);
var inst_18563 = cljs.core.count.call(null,inst_18554);
var inst_18564 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_18563,max_fuel);
var state_18604__$1 = state_18604;
var statearr_18680_18745 = state_18604__$1;
(statearr_18680_18745[(2)] = inst_18564);

(statearr_18680_18745[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (37))){
var inst_18579 = (state_18604[(2)]);
var state_18604__$1 = state_18604;
var statearr_18681_18746 = state_18604__$1;
(statearr_18681_18746[(2)] = inst_18579);

(statearr_18681_18746[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (8))){
var inst_18463 = (state_18604[(14)]);
var state_18604__$1 = state_18604;
var statearr_18682_18747 = state_18604__$1;
(statearr_18682_18747[(2)] = inst_18463);

(statearr_18682_18747[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18605 === (49))){
var inst_18484 = (state_18604[(30)]);
var state_18604__$1 = state_18604;
var statearr_18683_18748 = state_18604__$1;
(statearr_18683_18748[(2)] = inst_18484);

(statearr_18683_18748[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____0 = (function (){
var statearr_18684 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18684[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__);

(statearr_18684[(1)] = (1));

return statearr_18684;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____1 = (function (state_18604){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_18604);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18685){var ex__2687__auto__ = e18685;
var statearr_18686_18749 = state_18604;
(statearr_18686_18749[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_18604[(4)]))){
var statearr_18687_18750 = state_18604;
(statearr_18687_18750[(1)] = cljs.core.first.call(null,(state_18604[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18751 = state_18604;
state_18604 = G__18751;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__ = function(state_18604){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____1.call(this,state_18604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18688 = f__2707__auto__.call(null);
(statearr_18688[(6)] = c__2706__auto__);

return statearr_18688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__18753 = arguments.length;
switch (G__18753) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__18755 = null;
var G__18755__0 = (function (){
return xf.call(null);
});
var G__18755__1 = (function (result){
return xf.call(null,result);
});
var G__18755__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__18755 = function(result,flake){
switch(arguments.length){
case 0:
return G__18755__0.call(this);
case 1:
return G__18755__1.call(this,result);
case 2:
return G__18755__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18755.cljs$core$IFn$_invoke$arity$0 = G__18755__0;
G__18755.cljs$core$IFn$_invoke$arity$1 = G__18755__1;
G__18755.cljs$core$IFn$_invoke$arity$2 = G__18755__2;
return G__18755;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o.call(null,flake);
var recur_pred = fluree.db.flake.p.call(null,flake);
var map__18756 = select_spec;
var map__18756__$1 = cljs.core.__destructure_map.call(null,map__18756);
var recur_seen = cljs.core.get.call(null,map__18756__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__18756__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18870){
var state_val_18871 = (state_18870[(1)]);
if((state_val_18871 === (7))){
var inst_18782 = flakes;
var inst_18783 = cljs.core.seq.call(null,inst_18782);
var inst_18784 = cljs.core.first.call(null,inst_18783);
var inst_18785 = cljs.core.next.call(null,inst_18783);
var inst_18786 = cljs.core.PersistentVector.EMPTY;
var inst_18787 = inst_18782;
var inst_18788 = (0);
var inst_18789 = inst_18786;
var state_18870__$1 = (function (){var statearr_18872 = state_18870;
(statearr_18872[(7)] = inst_18789);

(statearr_18872[(8)] = inst_18787);

(statearr_18872[(9)] = inst_18788);

(statearr_18872[(10)] = inst_18785);

(statearr_18872[(11)] = inst_18784);

return statearr_18872;
})();
var statearr_18873_18939 = state_18870__$1;
(statearr_18873_18939[(2)] = null);

(statearr_18873_18939[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (20))){
var state_18870__$1 = state_18870;
var statearr_18874_18940 = state_18870__$1;
(statearr_18874_18940[(2)] = results);

(statearr_18874_18940[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (27))){
var state_18870__$1 = state_18870;
var statearr_18875_18941 = state_18870__$1;
(statearr_18875_18941[(2)] = null);

(statearr_18875_18941[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (1))){
var state_18870__$1 = state_18870;
var statearr_18876_18942 = state_18870__$1;
(statearr_18876_18942[(2)] = null);

(statearr_18876_18942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (24))){
var state_18870__$1 = state_18870;
var statearr_18877_18943 = state_18870__$1;
(statearr_18877_18943[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (39))){
var inst_18851 = (state_18870[(12)]);
var inst_18789 = (state_18870[(7)]);
var inst_18796 = (state_18870[(13)]);
var inst_18854 = (state_18870[(2)]);
var inst_18855 = fluree.db.util.async.throw_err.call(null,inst_18854);
var inst_18856 = cljs.core.conj.call(null,inst_18789,inst_18855);
var inst_18787 = inst_18796;
var inst_18788 = inst_18851;
var inst_18789__$1 = inst_18856;
var state_18870__$1 = (function (){var statearr_18879 = state_18870;
(statearr_18879[(7)] = inst_18789__$1);

(statearr_18879[(8)] = inst_18787);

(statearr_18879[(9)] = inst_18788);

return statearr_18879;
})();
var statearr_18880_18944 = state_18870__$1;
(statearr_18880_18944[(2)] = null);

(statearr_18880_18944[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (4))){
var inst_18757 = (state_18870[(2)]);
var state_18870__$1 = state_18870;
var statearr_18881_18945 = state_18870__$1;
(statearr_18881_18945[(2)] = inst_18757);

(statearr_18881_18945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (15))){
var inst_18770 = (state_18870[(14)]);
var state_18870__$1 = state_18870;
var statearr_18882_18946 = state_18870__$1;
(statearr_18882_18946[(2)] = inst_18770);

(statearr_18882_18946[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (21))){
var inst_18766 = (state_18870[(15)]);
var state_18870__$1 = state_18870;
if(cljs.core.truth_(inst_18766)){
var statearr_18883_18947 = state_18870__$1;
(statearr_18883_18947[(1)] = (23));

} else {
var statearr_18884_18948 = state_18870__$1;
(statearr_18884_18948[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (31))){
var inst_18834 = (state_18870[(16)]);
var state_18870__$1 = state_18870;
var statearr_18885_18949 = state_18870__$1;
(statearr_18885_18949[(2)] = inst_18834);

(statearr_18885_18949[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (32))){
var inst_18826 = (state_18870[(17)]);
var inst_18840 = (state_18870[(2)]);
var state_18870__$1 = (function (){var statearr_18886 = state_18870;
(statearr_18886[(18)] = inst_18840);

return statearr_18886;
})();
if(cljs.core.truth_(inst_18826)){
var statearr_18887_18950 = state_18870__$1;
(statearr_18887_18950[(1)] = (33));

} else {
var statearr_18888_18951 = state_18870__$1;
(statearr_18888_18951[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (33))){
var inst_18826 = (state_18870[(17)]);
var state_18870__$1 = state_18870;
var statearr_18889_18952 = state_18870__$1;
(statearr_18889_18952[(2)] = inst_18826);

(statearr_18889_18952[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (13))){
var inst_18806 = (state_18870[(2)]);
var state_18870__$1 = state_18870;
if(cljs.core.truth_(inst_18806)){
var statearr_18891_18953 = state_18870__$1;
(statearr_18891_18953[(1)] = (17));

} else {
var statearr_18892_18954 = state_18870__$1;
(statearr_18892_18954[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (22))){
var inst_18823 = (state_18870[(2)]);
var state_18870__$1 = state_18870;
var statearr_18893_18955 = state_18870__$1;
(statearr_18893_18955[(2)] = inst_18823);

(statearr_18893_18955[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (36))){
var inst_18789 = (state_18870[(7)]);
var inst_18788 = (state_18870[(9)]);
var inst_18796 = (state_18870[(13)]);
var inst_18848 = (inst_18788 + (1));
var tmp18890 = inst_18789;
var inst_18787 = inst_18796;
var inst_18788__$1 = inst_18848;
var inst_18789__$1 = tmp18890;
var state_18870__$1 = (function (){var statearr_18894 = state_18870;
(statearr_18894[(7)] = inst_18789__$1);

(statearr_18894[(8)] = inst_18787);

(statearr_18894[(9)] = inst_18788__$1);

return statearr_18894;
})();
var statearr_18895_18956 = state_18870__$1;
(statearr_18895_18956[(2)] = null);

(statearr_18895_18956[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (29))){
var inst_18833 = (state_18870[(2)]);
var inst_18834 = fluree.db.util.async.throw_err.call(null,inst_18833);
var state_18870__$1 = (function (){var statearr_18896 = state_18870;
(statearr_18896[(16)] = inst_18834);

return statearr_18896;
})();
if(cljs.core.truth_(fuel)){
var statearr_18897_18957 = state_18870__$1;
(statearr_18897_18957[(1)] = (30));

} else {
var statearr_18898_18958 = state_18870__$1;
(statearr_18898_18958[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (6))){
var state_18870__$1 = state_18870;
var statearr_18899_18959 = state_18870__$1;
(statearr_18899_18959[(2)] = results);

(statearr_18899_18959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (28))){
var inst_18819 = (state_18870[(2)]);
var state_18870__$1 = state_18870;
var statearr_18900_18960 = state_18870__$1;
(statearr_18900_18960[(2)] = inst_18819);

(statearr_18900_18960[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (25))){
var inst_18821 = (state_18870[(2)]);
var state_18870__$1 = state_18870;
var statearr_18901_18961 = state_18870__$1;
(statearr_18901_18961[(2)] = inst_18821);

(statearr_18901_18961[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (34))){
var inst_18840 = (state_18870[(18)]);
var inst_18843 = cljs.core.empty_QMARK_.call(null,inst_18840);
var state_18870__$1 = state_18870;
var statearr_18902_18962 = state_18870__$1;
(statearr_18902_18962[(2)] = inst_18843);

(statearr_18902_18962[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (17))){
var inst_18789 = (state_18870[(7)]);
var inst_18808 = cljs.core.empty_QMARK_.call(null,inst_18789);
var state_18870__$1 = state_18870;
if(inst_18808){
var statearr_18903_18963 = state_18870__$1;
(statearr_18903_18963[(1)] = (20));

} else {
var statearr_18904_18964 = state_18870__$1;
(statearr_18904_18964[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (3))){
var inst_18868 = (state_18870[(2)]);
var state_18870__$1 = state_18870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18870__$1,inst_18868);
} else {
if((state_val_18871 === (12))){
var inst_18770 = (state_18870[(14)]);
var state_18870__$1 = state_18870;
if(cljs.core.truth_(inst_18770)){
var statearr_18905_18965 = state_18870__$1;
(statearr_18905_18965[(1)] = (14));

} else {
var statearr_18906_18966 = state_18870__$1;
(statearr_18906_18966[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (2))){
var _ = (function (){var statearr_18907 = state_18870;
(statearr_18907[(4)] = cljs.core.cons.call(null,(5),(state_18870[(4)])));

return statearr_18907;
})();
var inst_18764 = select_spec;
var inst_18765 = cljs.core.__destructure_map.call(null,inst_18764);
var inst_18766 = cljs.core.get.call(null,inst_18765,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_18767 = cljs.core.get.call(null,inst_18765,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_18768 = cljs.core.get.call(null,inst_18765,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_18769 = cljs.core.get.call(null,inst_18765,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_18770 = cljs.core.get.call(null,inst_18765,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_18771 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_18772 = (inst_18769 > inst_18771);
var state_18870__$1 = (function (){var statearr_18908 = state_18870;
(statearr_18908[(19)] = inst_18768);

(statearr_18908[(20)] = inst_18767);

(statearr_18908[(14)] = inst_18770);

(statearr_18908[(15)] = inst_18766);

return statearr_18908;
})();
if(cljs.core.truth_(inst_18772)){
var statearr_18909_18967 = state_18870__$1;
(statearr_18909_18967[(1)] = (6));

} else {
var statearr_18910_18968 = state_18870__$1;
(statearr_18910_18968[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (23))){
var inst_18789 = (state_18870[(7)]);
var inst_18767 = (state_18870[(20)]);
var inst_18812 = cljs.core.assoc.call(null,results,inst_18767,inst_18789);
var state_18870__$1 = state_18870;
var statearr_18911_18969 = state_18870__$1;
(statearr_18911_18969[(2)] = inst_18812);

(statearr_18911_18969[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (35))){
var inst_18795 = (state_18870[(21)]);
var inst_18845 = (state_18870[(2)]);
var inst_18846 = fluree.db.query.fql_resp.recur_select_spec.call(null,select_spec,inst_18795);
var state_18870__$1 = (function (){var statearr_18912 = state_18870;
(statearr_18912[(22)] = inst_18846);

return statearr_18912;
})();
if(cljs.core.truth_(inst_18845)){
var statearr_18913_18970 = state_18870__$1;
(statearr_18913_18970[(1)] = (36));

} else {
var statearr_18914_18971 = state_18870__$1;
(statearr_18914_18971[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (19))){
var inst_18861 = (state_18870[(2)]);
var state_18870__$1 = state_18870;
var statearr_18915_18972 = state_18870__$1;
(statearr_18915_18972[(2)] = inst_18861);

(statearr_18915_18972[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (11))){
var inst_18797 = (state_18870[(23)]);
var state_18870__$1 = state_18870;
var statearr_18917_18973 = state_18870__$1;
(statearr_18917_18973[(2)] = inst_18797);

(statearr_18917_18973[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (9))){
var inst_18795 = (state_18870[(21)]);
var inst_18787 = (state_18870[(8)]);
var inst_18797 = (state_18870[(23)]);
var inst_18794 = cljs.core.seq.call(null,inst_18787);
var inst_18795__$1 = cljs.core.first.call(null,inst_18794);
var inst_18796 = cljs.core.next.call(null,inst_18794);
var inst_18797__$1 = cljs.core.not.call(null,inst_18795__$1);
var state_18870__$1 = (function (){var statearr_18918 = state_18870;
(statearr_18918[(21)] = inst_18795__$1);

(statearr_18918[(13)] = inst_18796);

(statearr_18918[(23)] = inst_18797__$1);

return statearr_18918;
})();
if(inst_18797__$1){
var statearr_18919_18974 = state_18870__$1;
(statearr_18919_18974[(1)] = (11));

} else {
var statearr_18920_18975 = state_18870__$1;
(statearr_18920_18975[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (5))){
var _ = (function (){var statearr_18921 = state_18870;
(statearr_18921[(4)] = cljs.core.rest.call(null,(state_18870[(4)])));

return statearr_18921;
})();
var state_18870__$1 = state_18870;
var ex18916 = (state_18870__$1[(2)]);
var statearr_18922_18976 = state_18870__$1;
(statearr_18922_18976[(5)] = ex18916);


if((ex18916 instanceof Error)){
var statearr_18923_18977 = state_18870__$1;
(statearr_18923_18977[(1)] = (4));

(statearr_18923_18977[(5)] = null);

} else {
throw ex18916;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (14))){
var inst_18788 = (state_18870[(9)]);
var inst_18770 = (state_18870[(14)]);
var inst_18801 = (inst_18788 < inst_18770);
var state_18870__$1 = state_18870;
var statearr_18924_18978 = state_18870__$1;
(statearr_18924_18978[(2)] = inst_18801);

(statearr_18924_18978[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (26))){
var inst_18789 = (state_18870[(7)]);
var inst_18767 = (state_18870[(20)]);
var inst_18815 = cljs.core.first.call(null,inst_18789);
var inst_18816 = cljs.core.assoc.call(null,results,inst_18767,inst_18815);
var state_18870__$1 = state_18870;
var statearr_18925_18979 = state_18870__$1;
(statearr_18925_18979[(2)] = inst_18816);

(statearr_18925_18979[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (16))){
var inst_18804 = (state_18870[(2)]);
var state_18870__$1 = state_18870;
var statearr_18926_18980 = state_18870__$1;
(statearr_18926_18980[(2)] = inst_18804);

(statearr_18926_18980[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (38))){
var inst_18859 = (state_18870[(2)]);
var state_18870__$1 = state_18870;
var statearr_18927_18981 = state_18870__$1;
(statearr_18927_18981[(2)] = inst_18859);

(statearr_18927_18981[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (30))){
var inst_18834 = (state_18870[(16)]);
var inst_18836 = fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_18837 = cljs.core.sequence.call(null,inst_18836,inst_18834);
var state_18870__$1 = state_18870;
var statearr_18928_18982 = state_18870__$1;
(statearr_18928_18982[(2)] = inst_18837);

(statearr_18928_18982[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (10))){
var inst_18863 = (state_18870[(2)]);
var state_18870__$1 = state_18870;
var statearr_18929_18983 = state_18870__$1;
(statearr_18929_18983[(2)] = inst_18863);

(statearr_18929_18983[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18871 === (18))){
var inst_18795 = (state_18870[(21)]);
var inst_18768 = (state_18870[(19)]);
var inst_18825 = fluree.db.flake.o.call(null,inst_18795);
var inst_18826 = cljs.core.contains_QMARK_.call(null,inst_18768,inst_18825);
var inst_18828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18829 = [inst_18825];
var inst_18830 = (new cljs.core.PersistentVector(null,1,(5),inst_18828,inst_18829,null));
var inst_18831 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_18830);
var state_18870__$1 = (function (){var statearr_18930 = state_18870;
(statearr_18930[(17)] = inst_18826);

return statearr_18930;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18870__$1,(29),inst_18831);
} else {
if((state_val_18871 === (37))){
var inst_18846 = (state_18870[(22)]);
var inst_18840 = (state_18870[(18)]);
var inst_18788 = (state_18870[(9)]);
var inst_18851 = (inst_18788 + (1));
var inst_18852 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_18846,opts,inst_18840);
var state_18870__$1 = (function (){var statearr_18931 = state_18870;
(statearr_18931[(12)] = inst_18851);

return statearr_18931;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18870__$1,(39),inst_18852);
} else {
if((state_val_18871 === (8))){
var inst_18865 = (state_18870[(2)]);
var _ = (function (){var statearr_18932 = state_18870;
(statearr_18932[(4)] = cljs.core.rest.call(null,(state_18870[(4)])));

return statearr_18932;
})();
var state_18870__$1 = state_18870;
var statearr_18933_18984 = state_18870__$1;
(statearr_18933_18984[(2)] = inst_18865);

(statearr_18933_18984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____0 = (function (){
var statearr_18934 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18934[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__);

(statearr_18934[(1)] = (1));

return statearr_18934;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____1 = (function (state_18870){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_18870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18935){var ex__2687__auto__ = e18935;
var statearr_18936_18985 = state_18870;
(statearr_18936_18985[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_18870[(4)]))){
var statearr_18937_18986 = state_18870;
(statearr_18937_18986[(1)] = cljs.core.first.call(null,(state_18870[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18987 = state_18870;
state_18870 = G__18987;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__ = function(state_18870){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____1.call(this,state_18870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18938 = f__2707__auto__.call(null);
(statearr_18938[(6)] = c__2706__auto__);

return statearr_18938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19428){
var state_val_19429 = (state_19428[(1)]);
if((state_val_19429 === (121))){
var inst_19351 = (state_19428[(2)]);
var inst_19352 = fluree.db.util.async.throw_err.call(null,inst_19351);
var inst_19353 = cljs.core.seq.call(null,inst_19352);
var state_19428__$1 = state_19428;
if(inst_19353){
var statearr_19430_19643 = state_19428__$1;
(statearr_19430_19643[(1)] = (122));

} else {
var statearr_19431_19644 = state_19428__$1;
(statearr_19431_19644[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (65))){
var inst_19144 = (state_19428[(7)]);
var inst_19143 = (state_19428[(2)]);
var inst_19144__$1 = fluree.db.util.async.throw_err.call(null,inst_19143);
var inst_19145 = cljs.core.seq.call(null,inst_19144__$1);
var state_19428__$1 = (function (){var statearr_19432 = state_19428;
(statearr_19432[(7)] = inst_19144__$1);

return statearr_19432;
})();
if(inst_19145){
var statearr_19433_19645 = state_19428__$1;
(statearr_19433_19645[(1)] = (66));

} else {
var statearr_19434_19646 = state_19428__$1;
(statearr_19434_19646[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (70))){
var inst_19144 = (state_19428[(7)]);
var inst_19155 = cljs.core.count.call(null,inst_19144);
var inst_19156 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_19155);
var state_19428__$1 = state_19428;
var statearr_19435_19647 = state_19428__$1;
(statearr_19435_19647[(2)] = inst_19156);

(statearr_19435_19647[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (62))){
var inst_19134 = (state_19428[(8)]);
var inst_19137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19138 = fluree.db.flake.o.call(null,inst_19134);
var inst_19139 = [inst_19138];
var inst_19140 = (new cljs.core.PersistentVector(null,1,(5),inst_19137,inst_19139,null));
var inst_19141 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19140);
var state_19428__$1 = state_19428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19428__$1,(65),inst_19141);
} else {
if((state_val_19429 === (74))){
var inst_19128 = (state_19428[(9)]);
var state_19428__$1 = state_19428;
var statearr_19436_19648 = state_19428__$1;
(statearr_19436_19648[(2)] = inst_19128);

(statearr_19436_19648[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (110))){
var inst_19313 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_19314 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_19313);
var inst_19315 = inst_19314 === true;
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19315)){
var statearr_19437_19649 = state_19428__$1;
(statearr_19437_19649[(1)] = (113));

} else {
var statearr_19438_19650 = state_19428__$1;
(statearr_19438_19650[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (130))){
var inst_19423 = (state_19428[(2)]);
var _ = (function (){var statearr_19439 = state_19428;
(statearr_19439[(4)] = cljs.core.rest.call(null,(state_19428[(4)])));

return statearr_19439;
})();
var state_19428__$1 = state_19428;
var statearr_19440_19651 = state_19428__$1;
(statearr_19440_19651[(2)] = inst_19423);

(statearr_19440_19651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (128))){
var inst_19398 = (state_19428[(10)]);
var inst_19401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19402 = [acc,inst_19398];
var inst_19403 = (new cljs.core.PersistentVector(null,2,(5),inst_19401,inst_19402,null));
var state_19428__$1 = state_19428;
var statearr_19441_19652 = state_19428__$1;
(statearr_19441_19652[(2)] = inst_19403);

(statearr_19441_19652[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (7))){
var inst_19001 = (state_19428[(11)]);
var state_19428__$1 = state_19428;
var statearr_19442_19653 = state_19428__$1;
(statearr_19442_19653[(2)] = inst_19001);

(statearr_19442_19653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (59))){
var inst_19392 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19443_19654 = state_19428__$1;
(statearr_19443_19654[(2)] = inst_19392);

(statearr_19443_19654[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (86))){
var inst_19222 = (state_19428[(12)]);
var inst_19222__$1 = (state_19428[(2)]);
var state_19428__$1 = (function (){var statearr_19444 = state_19428;
(statearr_19444[(12)] = inst_19222__$1);

return statearr_19444;
})();
if(cljs.core.truth_(inst_19222__$1)){
var statearr_19445_19655 = state_19428__$1;
(statearr_19445_19655[(1)] = (88));

} else {
var statearr_19446_19656 = state_19428__$1;
(statearr_19446_19656[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (20))){
var inst_19043 = (state_19428[(13)]);
var inst_19042 = (state_19428[(14)]);
var inst_19030 = (state_19428[(15)]);
var inst_19041 = (state_19428[(2)]);
var inst_19042__$1 = cljs.core.__destructure_map.call(null,inst_19030);
var inst_19043__$1 = cljs.core.get.call(null,inst_19042__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_19044 = cljs.core.get.call(null,inst_19042__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_19045 = cljs.core.get.call(null,inst_19042__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_19046 = cljs.core.get.call(null,inst_19042__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_19047 = cljs.core.get.call(null,inst_19042__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_19048 = cljs.core.get.call(null,inst_19042__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_19428__$1 = (function (){var statearr_19447 = state_19428;
(statearr_19447[(16)] = inst_19047);

(statearr_19447[(13)] = inst_19043__$1);

(statearr_19447[(17)] = inst_19041);

(statearr_19447[(18)] = inst_19045);

(statearr_19447[(14)] = inst_19042__$1);

(statearr_19447[(19)] = inst_19046);

(statearr_19447[(20)] = inst_19048);

(statearr_19447[(21)] = inst_19044);

return statearr_19447;
})();
if(cljs.core.truth_(inst_19043__$1)){
var statearr_19448_19657 = state_19428__$1;
(statearr_19448_19657[(1)] = (24));

} else {
var statearr_19449_19658 = state_19428__$1;
(statearr_19449_19658[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (72))){
var inst_19153 = (state_19428[(22)]);
var inst_19159 = (state_19428[(2)]);
var inst_19160 = cljs.core.seq.call(null,inst_19153);
var state_19428__$1 = (function (){var statearr_19450 = state_19428;
(statearr_19450[(23)] = inst_19159);

return statearr_19450;
})();
if(inst_19160){
var statearr_19451_19659 = state_19428__$1;
(statearr_19451_19659[(1)] = (73));

} else {
var statearr_19452_19660 = state_19428__$1;
(statearr_19452_19660[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (58))){
var inst_19030 = (state_19428[(15)]);
var inst_19175 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_19030);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19175)){
var statearr_19453_19661 = state_19428__$1;
(statearr_19453_19661[(1)] = (76));

} else {
var statearr_19454_19662 = state_19428__$1;
(statearr_19454_19662[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (60))){
var inst_19134 = (state_19428[(8)]);
var inst_19127 = (state_19428[(24)]);
var inst_19133 = cljs.core.seq.call(null,inst_19127);
var inst_19134__$1 = cljs.core.first.call(null,inst_19133);
var inst_19135 = cljs.core.next.call(null,inst_19133);
var state_19428__$1 = (function (){var statearr_19455 = state_19428;
(statearr_19455[(8)] = inst_19134__$1);

(statearr_19455[(25)] = inst_19135);

return statearr_19455;
})();
if(cljs.core.truth_(inst_19134__$1)){
var statearr_19456_19663 = state_19428__$1;
(statearr_19456_19663[(1)] = (62));

} else {
var statearr_19457_19664 = state_19428__$1;
(statearr_19457_19664[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (27))){
var inst_19047 = (state_19428[(16)]);
var inst_19051 = (state_19428[(26)]);
var inst_19051__$1 = cljs.core.not_EQ_.call(null,(0),inst_19047);
var state_19428__$1 = (function (){var statearr_19458 = state_19428;
(statearr_19458[(26)] = inst_19051__$1);

return statearr_19458;
})();
if(inst_19051__$1){
var statearr_19459_19665 = state_19428__$1;
(statearr_19459_19665[(1)] = (30));

} else {
var statearr_19460_19666 = state_19428__$1;
(statearr_19460_19666[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (1))){
var state_19428__$1 = state_19428;
var statearr_19461_19667 = state_19428__$1;
(statearr_19461_19667[(2)] = null);

(statearr_19461_19667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (69))){
var inst_19149 = (state_19428[(2)]);
var inst_19150 = fluree.db.util.async.throw_err.call(null,inst_19149);
var state_19428__$1 = state_19428;
var statearr_19462_19668 = state_19428__$1;
(statearr_19462_19668[(2)] = inst_19150);

(statearr_19462_19668[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (101))){
var inst_19306 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19463_19669 = state_19428__$1;
(statearr_19463_19669[(2)] = inst_19306);

(statearr_19463_19669[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (24))){
var inst_19047 = (state_19428[(16)]);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19047)){
var statearr_19464_19670 = state_19428__$1;
(statearr_19464_19670[(1)] = (27));

} else {
var statearr_19465_19671 = state_19428__$1;
(statearr_19465_19671[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (102))){
var inst_19278 = (state_19428[(27)]);
var inst_19277 = (state_19428[(2)]);
var inst_19278__$1 = fluree.db.util.async.throw_err.call(null,inst_19277);
var inst_19279 = cljs.core.empty_QMARK_.call(null,inst_19278__$1);
var state_19428__$1 = (function (){var statearr_19466 = state_19428;
(statearr_19466[(27)] = inst_19278__$1);

return statearr_19466;
})();
if(inst_19279){
var statearr_19467_19672 = state_19428__$1;
(statearr_19467_19672[(1)] = (103));

} else {
var statearr_19468_19673 = state_19428__$1;
(statearr_19468_19673[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (135))){
var state_19428__$1 = state_19428;
var statearr_19469_19674 = state_19428__$1;
(statearr_19469_19674[(2)] = null);

(statearr_19469_19674[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (55))){
var inst_19030 = (state_19428[(15)]);
var inst_19103 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_19030);
var state_19428__$1 = state_19428;
var statearr_19470_19675 = state_19428__$1;
(statearr_19470_19675[(2)] = inst_19103);

(statearr_19470_19675[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (85))){
var inst_19197 = (state_19428[(28)]);
var inst_19030 = (state_19428[(15)]);
var inst_19209 = fluree.db.flake.o.call(null,inst_19197);
var inst_19210 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_19030);
var inst_19211 = fluree.db.dbproto._tag.call(null,db,inst_19209,inst_19210);
var state_19428__$1 = state_19428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19428__$1,(87),inst_19211);
} else {
if((state_val_19429 === (39))){
var inst_19078 = (state_19428[(29)]);
var inst_19046 = (state_19428[(19)]);
var inst_19078__$1 = cljs.core.not.call(null,inst_19046);
var state_19428__$1 = (function (){var statearr_19471 = state_19428;
(statearr_19471[(29)] = inst_19078__$1);

return statearr_19471;
})();
if(inst_19078__$1){
var statearr_19472_19676 = state_19428__$1;
(statearr_19472_19676[(1)] = (42));

} else {
var statearr_19473_19677 = state_19428__$1;
(statearr_19473_19677[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (88))){
var inst_19191 = (state_19428[(30)]);
var inst_19222 = (state_19428[(12)]);
var inst_19224 = cljs.core.conj.call(null,inst_19191,inst_19222);
var state_19428__$1 = state_19428;
var statearr_19474_19678 = state_19428__$1;
(statearr_19474_19678[(2)] = inst_19224);

(statearr_19474_19678[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (46))){
var inst_19045 = (state_19428[(18)]);
var state_19428__$1 = state_19428;
var statearr_19475_19679 = state_19428__$1;
(statearr_19475_19679[(2)] = inst_19045);

(statearr_19475_19679[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (4))){
var inst_18990 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19476_19680 = state_19428__$1;
(statearr_19476_19680[(2)] = inst_18990);

(statearr_19476_19680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (77))){
var inst_19237 = (state_19428[(31)]);
var inst_19237__$1 = componentFollow_QMARK_;
var state_19428__$1 = (function (){var statearr_19477 = state_19428;
(statearr_19477[(31)] = inst_19237__$1);

return statearr_19477;
})();
if(cljs.core.truth_(inst_19237__$1)){
var statearr_19478_19681 = state_19428__$1;
(statearr_19478_19681[(1)] = (91));

} else {
var statearr_19479_19682 = state_19428__$1;
(statearr_19479_19682[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (106))){
var inst_19258 = (state_19428[(32)]);
var inst_19292 = (state_19428[(2)]);
var inst_19293 = fluree.db.util.async.throw_err.call(null,inst_19292);
var inst_19294 = cljs.core.conj.call(null,inst_19258,inst_19293);
var state_19428__$1 = state_19428;
var statearr_19480_19683 = state_19428__$1;
(statearr_19480_19683[(2)] = inst_19294);

(statearr_19480_19683[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (119))){
var inst_19336 = (state_19428[(33)]);
var inst_19366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19367 = [inst_19336,offset_map];
var inst_19368 = (new cljs.core.PersistentVector(null,2,(5),inst_19366,inst_19367,null));
var state_19428__$1 = state_19428;
var statearr_19481_19684 = state_19428__$1;
(statearr_19481_19684[(2)] = inst_19368);

(statearr_19481_19684[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (95))){
var inst_19044 = (state_19428[(21)]);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19044)){
var statearr_19482_19685 = state_19428__$1;
(statearr_19482_19685[(1)] = (110));

} else {
var statearr_19483_19686 = state_19428__$1;
(statearr_19483_19686[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (54))){
var inst_19100 = (state_19428[(34)]);
var state_19428__$1 = state_19428;
var statearr_19484_19687 = state_19428__$1;
(statearr_19484_19687[(2)] = inst_19100);

(statearr_19484_19687[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (92))){
var inst_19237 = (state_19428[(31)]);
var state_19428__$1 = state_19428;
var statearr_19485_19688 = state_19428__$1;
(statearr_19485_19688[(2)] = inst_19237);

(statearr_19485_19688[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (104))){
var inst_19000 = (state_19428[(35)]);
var inst_19278 = (state_19428[(27)]);
var inst_19287 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_19288 = [true,inst_19000];
var inst_19289 = cljs.core.PersistentHashMap.fromArrays(inst_19287,inst_19288);
var inst_19290 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_19289,opts,inst_19278);
var state_19428__$1 = state_19428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19428__$1,(106),inst_19290);
} else {
if((state_val_19429 === (15))){
var inst_19000 = (state_19428[(35)]);
var inst_19023 = (state_19428[(36)]);
var inst_19027 = cljs.core.assoc.call(null,inst_19023,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_19000);
var state_19428__$1 = state_19428;
var statearr_19486_19689 = state_19428__$1;
(statearr_19486_19689[(2)] = inst_19027);

(statearr_19486_19689[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (48))){
var inst_19094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19095 = [null,offset_map];
var inst_19096 = (new cljs.core.PersistentVector(null,2,(5),inst_19094,inst_19095,null));
var state_19428__$1 = state_19428;
var statearr_19487_19690 = state_19428__$1;
(statearr_19487_19690[(2)] = inst_19096);

(statearr_19487_19690[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (50))){
var inst_19394 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19488_19691 = state_19428__$1;
(statearr_19488_19691[(2)] = inst_19394);

(statearr_19488_19691[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (116))){
var inst_19342 = (state_19428[(37)]);
var inst_19335 = (state_19428[(38)]);
var inst_19341 = cljs.core.seq.call(null,inst_19335);
var inst_19342__$1 = cljs.core.first.call(null,inst_19341);
var inst_19343 = cljs.core.next.call(null,inst_19341);
var state_19428__$1 = (function (){var statearr_19489 = state_19428;
(statearr_19489[(37)] = inst_19342__$1);

(statearr_19489[(39)] = inst_19343);

return statearr_19489;
})();
if(cljs.core.truth_(inst_19342__$1)){
var statearr_19490_19692 = state_19428__$1;
(statearr_19490_19692[(1)] = (118));

} else {
var statearr_19491_19693 = state_19428__$1;
(statearr_19491_19693[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (75))){
var inst_19135 = (state_19428[(25)]);
var inst_19165 = (state_19428[(2)]);
var inst_19127 = inst_19135;
var inst_19128 = inst_19165;
var state_19428__$1 = (function (){var statearr_19492 = state_19428;
(statearr_19492[(9)] = inst_19128);

(statearr_19492[(24)] = inst_19127);

return statearr_19492;
})();
var statearr_19493_19694 = state_19428__$1;
(statearr_19493_19694[(2)] = null);

(statearr_19493_19694[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (99))){
var inst_19264 = (state_19428[(40)]);
var inst_19030 = (state_19428[(15)]);
var inst_19267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19268 = fluree.db.flake.o.call(null,inst_19264);
var inst_19269 = [inst_19268];
var inst_19270 = (new cljs.core.PersistentVector(null,1,(5),inst_19267,inst_19269,null));
var inst_19271 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_19272 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_19030);
var inst_19273 = [inst_19272];
var inst_19274 = cljs.core.PersistentHashMap.fromArrays(inst_19271,inst_19273);
var inst_19275 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19270,inst_19274);
var state_19428__$1 = state_19428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19428__$1,(102),inst_19275);
} else {
if((state_val_19429 === (21))){
var inst_19034 = (state_19428[(41)]);
var state_19428__$1 = state_19428;
var statearr_19494_19695 = state_19428__$1;
(statearr_19494_19695[(2)] = inst_19034);

(statearr_19494_19695[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (31))){
var inst_19051 = (state_19428[(26)]);
var state_19428__$1 = state_19428;
var statearr_19495_19696 = state_19428__$1;
(statearr_19495_19696[(2)] = inst_19051);

(statearr_19495_19696[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (113))){
var inst_19047 = (state_19428[(16)]);
var inst_19043 = (state_19428[(13)]);
var inst_19000 = (state_19428[(35)]);
var inst_19015 = (state_19428[(42)]);
var inst_19041 = (state_19428[(17)]);
var inst_19045 = (state_19428[(18)]);
var inst_19042 = (state_19428[(14)]);
var inst_19046 = (state_19428[(19)]);
var inst_19048 = (state_19428[(20)]);
var inst_19030 = (state_19428[(15)]);
var inst_19044 = (state_19428[(21)]);
var inst_19317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19318 = (function (){var p = inst_19048;
var pred_spec__$1 = inst_19015;
var orderBy = inst_19046;
var map__18996 = inst_19042;
var multi_QMARK_ = inst_19043;
var limit = inst_19045;
var offset = inst_19047;
var k = inst_19041;
var compact_QMARK_ = inst_19000;
var pred_spec_SINGLEQUOTE_ = inst_19030;
var ref_QMARK_ = inst_19044;
return (function (p1__18988_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o.call(null,p1__18988_SHARP_)]);
});
})();
var inst_19319 = cljs.core.mapv.call(null,inst_19318,flakes);
var inst_19320 = [inst_19319,offset_map];
var inst_19321 = (new cljs.core.PersistentVector(null,2,(5),inst_19317,inst_19320,null));
var state_19428__$1 = state_19428;
var statearr_19496_19697 = state_19428__$1;
(statearr_19496_19697[(2)] = inst_19321);

(statearr_19496_19697[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (32))){
var inst_19057 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19497_19698 = state_19428__$1;
(statearr_19497_19698[(2)] = inst_19057);

(statearr_19497_19698[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (136))){
var inst_19419 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19498_19699 = state_19428__$1;
(statearr_19498_19699[(2)] = inst_19419);

(statearr_19498_19699[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (40))){
var inst_19043 = (state_19428[(13)]);
var state_19428__$1 = state_19428;
var statearr_19499_19700 = state_19428__$1;
(statearr_19499_19700[(2)] = inst_19043);

(statearr_19499_19700[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (129))){
var inst_19043 = (state_19428[(13)]);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19043)){
var statearr_19500_19701 = state_19428__$1;
(statearr_19500_19701[(1)] = (131));

} else {
var statearr_19501_19702 = state_19428__$1;
(statearr_19501_19702[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (91))){
var inst_19030 = (state_19428[(15)]);
var inst_19239 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_19030);
var state_19428__$1 = state_19428;
var statearr_19502_19703 = state_19428__$1;
(statearr_19502_19703[(2)] = inst_19239);

(statearr_19502_19703[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (117))){
var inst_19372 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19503_19704 = state_19428__$1;
(statearr_19503_19704[(2)] = inst_19372);

(statearr_19503_19704[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (108))){
var state_19428__$1 = state_19428;
var statearr_19504_19705 = state_19428__$1;
(statearr_19504_19705[(2)] = null);

(statearr_19504_19705[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (56))){
var inst_19105 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19505_19706 = state_19428__$1;
(statearr_19505_19706[(2)] = inst_19105);

(statearr_19505_19706[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (33))){
var inst_19048 = (state_19428[(20)]);
var inst_19065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19066 = cljs.core.get.call(null,offset_map,inst_19048);
var state_19428__$1 = (function (){var statearr_19506 = state_19428;
(statearr_19506[(43)] = inst_19065);

return statearr_19506;
})();
if(cljs.core.truth_(inst_19066)){
var statearr_19507_19707 = state_19428__$1;
(statearr_19507_19707[(1)] = (36));

} else {
var statearr_19508_19708 = state_19428__$1;
(statearr_19508_19708[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (13))){
var inst_19015 = (state_19428[(42)]);
var state_19428__$1 = state_19428;
var statearr_19509_19709 = state_19428__$1;
(statearr_19509_19709[(2)] = inst_19015);

(statearr_19509_19709[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (22))){
var inst_19030 = (state_19428[(15)]);
var inst_19037 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_19030);
var state_19428__$1 = state_19428;
var statearr_19510_19710 = state_19428__$1;
(statearr_19510_19710[(2)] = inst_19037);

(statearr_19510_19710[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (90))){
var inst_19198 = (state_19428[(44)]);
var inst_19227 = (state_19428[(2)]);
var inst_19190 = inst_19198;
var inst_19191 = inst_19227;
var state_19428__$1 = (function (){var statearr_19511 = state_19428;
(statearr_19511[(30)] = inst_19191);

(statearr_19511[(45)] = inst_19190);

return statearr_19511;
})();
var statearr_19512_19711 = state_19428__$1;
(statearr_19512_19711[(2)] = null);

(statearr_19512_19711[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (109))){
var inst_19296 = (state_19428[(46)]);
var inst_19265 = (state_19428[(47)]);
var inst_19302 = (state_19428[(2)]);
var inst_19257 = inst_19265;
var inst_19258 = inst_19296;
var state_19428__$1 = (function (){var statearr_19513 = state_19428;
(statearr_19513[(48)] = inst_19257);

(statearr_19513[(32)] = inst_19258);

(statearr_19513[(49)] = inst_19302);

return statearr_19513;
})();
var statearr_19514_19712 = state_19428__$1;
(statearr_19514_19712[(2)] = null);

(statearr_19514_19712[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (36))){
var inst_19048 = (state_19428[(20)]);
var inst_19068 = cljs.core.update.call(null,offset_map,inst_19048,cljs.core.dec);
var state_19428__$1 = state_19428;
var statearr_19515_19713 = state_19428__$1;
(statearr_19515_19713[(2)] = inst_19068);

(statearr_19515_19713[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (41))){
var inst_19092 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19092)){
var statearr_19516_19714 = state_19428__$1;
(statearr_19516_19714[(1)] = (48));

} else {
var statearr_19517_19715 = state_19428__$1;
(statearr_19517_19715[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (118))){
var inst_19342 = (state_19428[(37)]);
var inst_19345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19346 = fluree.db.flake.o.call(null,inst_19342);
var inst_19347 = [inst_19346];
var inst_19348 = (new cljs.core.PersistentVector(null,1,(5),inst_19345,inst_19347,null));
var inst_19349 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19348);
var state_19428__$1 = state_19428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19428__$1,(121),inst_19349);
} else {
if((state_val_19429 === (89))){
var inst_19191 = (state_19428[(30)]);
var state_19428__$1 = state_19428;
var statearr_19518_19716 = state_19428__$1;
(statearr_19518_19716[(2)] = inst_19191);

(statearr_19518_19716[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (100))){
var inst_19258 = (state_19428[(32)]);
var state_19428__$1 = state_19428;
var statearr_19519_19717 = state_19428__$1;
(statearr_19519_19717[(2)] = inst_19258);

(statearr_19519_19717[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (131))){
var inst_19041 = (state_19428[(17)]);
var inst_19397 = (state_19428[(50)]);
var inst_19398 = (state_19428[(10)]);
var inst_19406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19407 = cljs.core.assoc.call(null,acc,inst_19041,inst_19397);
var inst_19408 = [inst_19407,inst_19398];
var inst_19409 = (new cljs.core.PersistentVector(null,2,(5),inst_19406,inst_19408,null));
var state_19428__$1 = state_19428;
var statearr_19520_19718 = state_19428__$1;
(statearr_19520_19718[(2)] = inst_19409);

(statearr_19520_19718[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (122))){
var inst_19336 = (state_19428[(33)]);
var inst_19342 = (state_19428[(37)]);
var inst_19343 = (state_19428[(39)]);
var inst_19355 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_19356 = fluree.db.flake.o.call(null,inst_19342);
var inst_19357 = [inst_19356];
var inst_19358 = cljs.core.PersistentHashMap.fromArrays(inst_19355,inst_19357);
var inst_19359 = cljs.core.conj.call(null,inst_19336,inst_19358);
var inst_19335 = inst_19343;
var inst_19336__$1 = inst_19359;
var state_19428__$1 = (function (){var statearr_19521 = state_19428;
(statearr_19521[(33)] = inst_19336__$1);

(statearr_19521[(38)] = inst_19335);

return statearr_19521;
})();
var statearr_19522_19719 = state_19428__$1;
(statearr_19522_19719[(2)] = null);

(statearr_19522_19719[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (43))){
var inst_19078 = (state_19428[(29)]);
var state_19428__$1 = state_19428;
var statearr_19523_19720 = state_19428__$1;
(statearr_19523_19720[(2)] = inst_19078);

(statearr_19523_19720[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (61))){
var inst_19114 = (state_19428[(51)]);
var inst_19171 = (state_19428[(2)]);
var inst_19172 = [inst_19171,offset_map];
var inst_19173 = (new cljs.core.PersistentVector(null,2,(5),inst_19114,inst_19172,null));
var state_19428__$1 = state_19428;
var statearr_19524_19721 = state_19428__$1;
(statearr_19524_19721[(2)] = inst_19173);

(statearr_19524_19721[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (29))){
var inst_19060 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19525_19722 = state_19428__$1;
(statearr_19525_19722[(2)] = inst_19060);

(statearr_19525_19722[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (44))){
var inst_19089 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19526_19723 = state_19428__$1;
(statearr_19526_19723[(2)] = inst_19089);

(statearr_19526_19723[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (93))){
var inst_19242 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19242)){
var statearr_19527_19724 = state_19428__$1;
(statearr_19527_19724[(1)] = (94));

} else {
var statearr_19528_19725 = state_19428__$1;
(statearr_19528_19725[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (6))){
var inst_19003 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_19004 = (inst_19003 == null);
var state_19428__$1 = state_19428;
var statearr_19529_19726 = state_19428__$1;
(statearr_19529_19726[(2)] = inst_19004);

(statearr_19529_19726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (111))){
var state_19428__$1 = state_19428;
var statearr_19530_19727 = state_19428__$1;
(statearr_19530_19727[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (28))){
var inst_19047 = (state_19428[(16)]);
var state_19428__$1 = state_19428;
var statearr_19532_19728 = state_19428__$1;
(statearr_19532_19728[(2)] = inst_19047);

(statearr_19532_19728[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (134))){
var inst_19041 = (state_19428[(17)]);
var inst_19397 = (state_19428[(50)]);
var inst_19398 = (state_19428[(10)]);
var inst_19412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19413 = cljs.core.first.call(null,inst_19397);
var inst_19414 = cljs.core.assoc.call(null,acc,inst_19041,inst_19413);
var inst_19415 = [inst_19414,inst_19398];
var inst_19416 = (new cljs.core.PersistentVector(null,2,(5),inst_19412,inst_19415,null));
var state_19428__$1 = state_19428;
var statearr_19533_19729 = state_19428__$1;
(statearr_19533_19729[(2)] = inst_19416);

(statearr_19533_19729[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (64))){
var inst_19169 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19534_19730 = state_19428__$1;
(statearr_19534_19730[(2)] = inst_19169);

(statearr_19534_19730[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (103))){
var inst_19264 = (state_19428[(40)]);
var inst_19258 = (state_19428[(32)]);
var inst_19281 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_19282 = fluree.db.flake.o.call(null,inst_19264);
var inst_19283 = [inst_19282];
var inst_19284 = cljs.core.PersistentHashMap.fromArrays(inst_19281,inst_19283);
var inst_19285 = cljs.core.conj.call(null,inst_19258,inst_19284);
var state_19428__$1 = state_19428;
var statearr_19535_19731 = state_19428__$1;
(statearr_19535_19731[(2)] = inst_19285);

(statearr_19535_19731[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (51))){
var inst_19100 = (state_19428[(34)]);
var inst_19030 = (state_19428[(15)]);
var inst_19100__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_19030);
var state_19428__$1 = (function (){var statearr_19536 = state_19428;
(statearr_19536[(34)] = inst_19100__$1);

return statearr_19536;
})();
if(cljs.core.truth_(inst_19100__$1)){
var statearr_19537_19732 = state_19428__$1;
(statearr_19537_19732[(1)] = (54));

} else {
var statearr_19538_19733 = state_19428__$1;
(statearr_19538_19733[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (25))){
var inst_19043 = (state_19428[(13)]);
var state_19428__$1 = state_19428;
var statearr_19539_19734 = state_19428__$1;
(statearr_19539_19734[(2)] = inst_19043);

(statearr_19539_19734[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (34))){
var inst_19043 = (state_19428[(13)]);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19043)){
var statearr_19540_19735 = state_19428__$1;
(statearr_19540_19735[(1)] = (39));

} else {
var statearr_19541_19736 = state_19428__$1;
(statearr_19541_19736[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (125))){
var inst_19047 = (state_19428[(16)]);
var inst_19043 = (state_19428[(13)]);
var inst_19000 = (state_19428[(35)]);
var inst_19015 = (state_19428[(42)]);
var inst_19041 = (state_19428[(17)]);
var inst_19045 = (state_19428[(18)]);
var inst_19042 = (state_19428[(14)]);
var inst_19046 = (state_19428[(19)]);
var inst_19048 = (state_19428[(20)]);
var inst_19030 = (state_19428[(15)]);
var inst_19044 = (state_19428[(21)]);
var inst_19377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19378 = (function (){var p = inst_19048;
var pred_spec__$1 = inst_19015;
var orderBy = inst_19046;
var map__18996 = inst_19042;
var multi_QMARK_ = inst_19043;
var limit = inst_19045;
var offset = inst_19047;
var k = inst_19041;
var compact_QMARK_ = inst_19000;
var pred_spec_SINGLEQUOTE_ = inst_19030;
var ref_QMARK_ = inst_19044;
return (function (p1__18989_SHARP_){
return fluree.db.flake.o.call(null,p1__18989_SHARP_);
});
})();
var inst_19379 = cljs.core.mapv.call(null,inst_19378,flakes);
var inst_19380 = [inst_19379,offset_map];
var inst_19381 = (new cljs.core.PersistentVector(null,2,(5),inst_19377,inst_19380,null));
var state_19428__$1 = state_19428;
var statearr_19542_19737 = state_19428__$1;
(statearr_19542_19737[(2)] = inst_19381);

(statearr_19542_19737[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (17))){
var inst_19031 = (state_19428[(52)]);
var inst_19030 = (state_19428[(15)]);
var inst_19030__$1 = (state_19428[(2)]);
var inst_19031__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_19030__$1);
var state_19428__$1 = (function (){var statearr_19543 = state_19428;
(statearr_19543[(52)] = inst_19031__$1);

(statearr_19543[(15)] = inst_19030__$1);

return statearr_19543;
})();
if(cljs.core.truth_(inst_19031__$1)){
var statearr_19544_19738 = state_19428__$1;
(statearr_19544_19738[(1)] = (18));

} else {
var statearr_19545_19739 = state_19428__$1;
(statearr_19545_19739[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (3))){
var inst_19426 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19428__$1,inst_19426);
} else {
if((state_val_19429 === (12))){
var inst_19015 = (state_19428[(42)]);
var inst_19020 = cljs.core.assoc.call(null,inst_19015,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_19428__$1 = state_19428;
var statearr_19546_19740 = state_19428__$1;
(statearr_19546_19740[(2)] = inst_19020);

(statearr_19546_19740[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (2))){
var inst_19001 = (state_19428[(11)]);
var _ = (function (){var statearr_19547 = state_19428;
(statearr_19547[(4)] = cljs.core.cons.call(null,(5),(state_19428[(4)])));

return statearr_19547;
})();
var inst_19000 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_19001__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_19428__$1 = (function (){var statearr_19548 = state_19428;
(statearr_19548[(35)] = inst_19000);

(statearr_19548[(11)] = inst_19001__$1);

return statearr_19548;
})();
if(cljs.core.truth_(inst_19001__$1)){
var statearr_19549_19741 = state_19428__$1;
(statearr_19549_19741[(1)] = (6));

} else {
var statearr_19550_19742 = state_19428__$1;
(statearr_19550_19742[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (66))){
var inst_19113 = (state_19428[(53)]);
var inst_19144 = (state_19428[(7)]);
var inst_19147 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_19113,opts,inst_19144);
var state_19428__$1 = state_19428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19428__$1,(69),inst_19147);
} else {
if((state_val_19429 === (107))){
var inst_19278 = (state_19428[(27)]);
var inst_19298 = cljs.core.count.call(null,inst_19278);
var inst_19299 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_19298);
var state_19428__$1 = state_19428;
var statearr_19551_19743 = state_19428__$1;
(statearr_19551_19743[(2)] = inst_19299);

(statearr_19551_19743[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (23))){
var inst_19039 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19552_19744 = state_19428__$1;
(statearr_19552_19744[(2)] = inst_19039);

(statearr_19552_19744[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (47))){
var inst_19086 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19553_19745 = state_19428__$1;
(statearr_19553_19745[(2)] = inst_19086);

(statearr_19553_19745[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (35))){
var inst_19397 = (state_19428[(50)]);
var inst_19396 = (state_19428[(2)]);
var inst_19397__$1 = cljs.core.nth.call(null,inst_19396,(0),null);
var inst_19398 = cljs.core.nth.call(null,inst_19396,(1),null);
var inst_19399 = cljs.core.empty_QMARK_.call(null,inst_19397__$1);
var state_19428__$1 = (function (){var statearr_19554 = state_19428;
(statearr_19554[(50)] = inst_19397__$1);

(statearr_19554[(10)] = inst_19398);

return statearr_19554;
})();
if(inst_19399){
var statearr_19555_19746 = state_19428__$1;
(statearr_19555_19746[(1)] = (128));

} else {
var statearr_19556_19747 = state_19428__$1;
(statearr_19556_19747[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (127))){
var inst_19384 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19557_19748 = state_19428__$1;
(statearr_19557_19748[(2)] = inst_19384);

(statearr_19557_19748[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (82))){
var inst_19191 = (state_19428[(30)]);
var state_19428__$1 = state_19428;
var statearr_19558_19749 = state_19428__$1;
(statearr_19558_19749[(2)] = inst_19191);

(statearr_19558_19749[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (76))){
var inst_19177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19185 = flakes;
var inst_19186 = cljs.core.seq.call(null,inst_19185);
var inst_19187 = cljs.core.first.call(null,inst_19186);
var inst_19188 = cljs.core.next.call(null,inst_19186);
var inst_19189 = cljs.core.PersistentVector.EMPTY;
var inst_19190 = inst_19185;
var inst_19191 = inst_19189;
var state_19428__$1 = (function (){var statearr_19559 = state_19428;
(statearr_19559[(30)] = inst_19191);

(statearr_19559[(54)] = inst_19177);

(statearr_19559[(45)] = inst_19190);

(statearr_19559[(55)] = inst_19187);

(statearr_19559[(56)] = inst_19188);

return statearr_19559;
})();
var statearr_19560_19750 = state_19428__$1;
(statearr_19560_19750[(2)] = null);

(statearr_19560_19750[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (97))){
var inst_19257 = (state_19428[(48)]);
var inst_19264 = (state_19428[(40)]);
var inst_19263 = cljs.core.seq.call(null,inst_19257);
var inst_19264__$1 = cljs.core.first.call(null,inst_19263);
var inst_19265 = cljs.core.next.call(null,inst_19263);
var state_19428__$1 = (function (){var statearr_19561 = state_19428;
(statearr_19561[(40)] = inst_19264__$1);

(statearr_19561[(47)] = inst_19265);

return statearr_19561;
})();
if(cljs.core.truth_(inst_19264__$1)){
var statearr_19562_19751 = state_19428__$1;
(statearr_19562_19751[(1)] = (99));

} else {
var statearr_19563_19752 = state_19428__$1;
(statearr_19563_19752[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (19))){
var inst_19034 = (state_19428[(41)]);
var inst_19030 = (state_19428[(15)]);
var inst_19034__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_19030);
var state_19428__$1 = (function (){var statearr_19564 = state_19428;
(statearr_19564[(41)] = inst_19034__$1);

return statearr_19564;
})();
if(cljs.core.truth_(inst_19034__$1)){
var statearr_19565_19753 = state_19428__$1;
(statearr_19565_19753[(1)] = (21));

} else {
var statearr_19566_19754 = state_19428__$1;
(statearr_19566_19754[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (57))){
var inst_19030 = (state_19428[(15)]);
var inst_19110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19111 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_19112 = (new cljs.core.PersistentVector(null,3,(5),inst_19110,inst_19111,null));
var inst_19113 = cljs.core.select_keys.call(null,inst_19030,inst_19112);
var inst_19114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19122 = flakes;
var inst_19123 = cljs.core.seq.call(null,inst_19122);
var inst_19124 = cljs.core.first.call(null,inst_19123);
var inst_19125 = cljs.core.next.call(null,inst_19123);
var inst_19126 = cljs.core.PersistentVector.EMPTY;
var inst_19127 = inst_19122;
var inst_19128 = inst_19126;
var state_19428__$1 = (function (){var statearr_19567 = state_19428;
(statearr_19567[(53)] = inst_19113);

(statearr_19567[(9)] = inst_19128);

(statearr_19567[(57)] = inst_19124);

(statearr_19567[(51)] = inst_19114);

(statearr_19567[(24)] = inst_19127);

(statearr_19567[(58)] = inst_19125);

return statearr_19567;
})();
var statearr_19568_19755 = state_19428__$1;
(statearr_19568_19755[(2)] = null);

(statearr_19568_19755[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (68))){
var inst_19153 = (state_19428[(2)]);
var state_19428__$1 = (function (){var statearr_19569 = state_19428;
(statearr_19569[(22)] = inst_19153);

return statearr_19569;
})();
if(cljs.core.truth_(fuel)){
var statearr_19570_19756 = state_19428__$1;
(statearr_19570_19756[(1)] = (70));

} else {
var statearr_19571_19757 = state_19428__$1;
(statearr_19571_19757[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (11))){
var inst_19015 = (state_19428[(42)]);
var inst_19015__$1 = (state_19428[(2)]);
var inst_19017 = cljs.core.contains_QMARK_.call(null,inst_19015__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_19018 = (!(inst_19017));
var state_19428__$1 = (function (){var statearr_19572 = state_19428;
(statearr_19572[(42)] = inst_19015__$1);

return statearr_19572;
})();
if(inst_19018){
var statearr_19573_19758 = state_19428__$1;
(statearr_19573_19758[(1)] = (12));

} else {
var statearr_19574_19759 = state_19428__$1;
(statearr_19574_19759[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (115))){
var inst_19374 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19576_19760 = state_19428__$1;
(statearr_19576_19760[(2)] = inst_19374);

(statearr_19576_19760[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (9))){
var inst_19009 = cljs.core.first.call(null,flakes);
var inst_19010 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_19009);
var inst_19011 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_19012 = fluree.db.query.fql_resp.wildcard_pred_spec.call(null,db,cache,inst_19010,inst_19011);
var state_19428__$1 = state_19428;
var statearr_19577_19761 = state_19428__$1;
(statearr_19577_19761[(2)] = inst_19012);

(statearr_19577_19761[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (5))){
var _ = (function (){var statearr_19578 = state_19428;
(statearr_19578[(4)] = cljs.core.rest.call(null,(state_19428[(4)])));

return statearr_19578;
})();
var state_19428__$1 = state_19428;
var ex19575 = (state_19428__$1[(2)]);
var statearr_19579_19762 = state_19428__$1;
(statearr_19579_19762[(5)] = ex19575);


if((ex19575 instanceof Error)){
var statearr_19580_19763 = state_19428__$1;
(statearr_19580_19763[(1)] = (4));

(statearr_19580_19763[(5)] = null);

} else {
throw ex19575;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (112))){
var inst_19386 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19581_19764 = state_19428__$1;
(statearr_19581_19764[(2)] = inst_19386);

(statearr_19581_19764[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (83))){
var inst_19231 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19582_19765 = state_19428__$1;
(statearr_19582_19765[(2)] = inst_19231);

(statearr_19582_19765[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (14))){
var inst_19015 = (state_19428[(42)]);
var inst_19023 = (state_19428[(2)]);
var inst_19024 = cljs.core.contains_QMARK_.call(null,inst_19015,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_19025 = (!(inst_19024));
var state_19428__$1 = (function (){var statearr_19583 = state_19428;
(statearr_19583[(36)] = inst_19023);

return statearr_19583;
})();
if(inst_19025){
var statearr_19584_19766 = state_19428__$1;
(statearr_19584_19766[(1)] = (15));

} else {
var statearr_19585_19767 = state_19428__$1;
(statearr_19585_19767[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (45))){
var inst_19041 = (state_19428[(17)]);
var inst_19045 = (state_19428[(18)]);
var inst_19081 = cljs.core.get.call(null,acc,inst_19041);
var inst_19082 = cljs.core.count.call(null,inst_19081);
var inst_19083 = (inst_19082 >= inst_19045);
var state_19428__$1 = state_19428;
var statearr_19586_19768 = state_19428__$1;
(statearr_19586_19768[(2)] = inst_19083);

(statearr_19586_19768[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (53))){
var inst_19108 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19108)){
var statearr_19587_19769 = state_19428__$1;
(statearr_19587_19769[(1)] = (57));

} else {
var statearr_19588_19770 = state_19428__$1;
(statearr_19588_19770[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (78))){
var inst_19390 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19589_19771 = state_19428__$1;
(statearr_19589_19771[(2)] = inst_19390);

(statearr_19589_19771[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (132))){
var state_19428__$1 = state_19428;
var statearr_19591_19772 = state_19428__$1;
(statearr_19591_19772[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (26))){
var inst_19063 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19063)){
var statearr_19593_19773 = state_19428__$1;
(statearr_19593_19773[(1)] = (33));

} else {
var statearr_19594_19774 = state_19428__$1;
(statearr_19594_19774[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (123))){
var inst_19336 = (state_19428[(33)]);
var inst_19343 = (state_19428[(39)]);
var tmp19590 = inst_19336;
var inst_19335 = inst_19343;
var inst_19336__$1 = tmp19590;
var state_19428__$1 = (function (){var statearr_19595 = state_19428;
(statearr_19595[(33)] = inst_19336__$1);

(statearr_19595[(38)] = inst_19335);

return statearr_19595;
})();
var statearr_19596_19775 = state_19428__$1;
(statearr_19596_19775[(2)] = null);

(statearr_19596_19775[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (16))){
var inst_19023 = (state_19428[(36)]);
var state_19428__$1 = state_19428;
var statearr_19597_19776 = state_19428__$1;
(statearr_19597_19776[(2)] = inst_19023);

(statearr_19597_19776[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (133))){
var inst_19421 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19598_19777 = state_19428__$1;
(statearr_19598_19777[(2)] = inst_19421);

(statearr_19598_19777[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (81))){
var inst_19197 = (state_19428[(28)]);
var inst_19030 = (state_19428[(15)]);
var inst_19206 = (state_19428[(59)]);
var inst_19200 = cljs.core.deref.call(null,cache);
var inst_19201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19202 = fluree.db.flake.o.call(null,inst_19197);
var inst_19203 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_19030);
var inst_19204 = [inst_19202,inst_19203];
var inst_19205 = (new cljs.core.PersistentVector(null,2,(5),inst_19201,inst_19204,null));
var inst_19206__$1 = cljs.core.get.call(null,inst_19200,inst_19205);
var state_19428__$1 = (function (){var statearr_19599 = state_19428;
(statearr_19599[(59)] = inst_19206__$1);

return statearr_19599;
})();
if(cljs.core.truth_(inst_19206__$1)){
var statearr_19600_19778 = state_19428__$1;
(statearr_19600_19778[(1)] = (84));

} else {
var statearr_19601_19779 = state_19428__$1;
(statearr_19601_19779[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (120))){
var inst_19370 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19602_19780 = state_19428__$1;
(statearr_19602_19780[(2)] = inst_19370);

(statearr_19602_19780[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (79))){
var inst_19197 = (state_19428[(28)]);
var inst_19190 = (state_19428[(45)]);
var inst_19196 = cljs.core.seq.call(null,inst_19190);
var inst_19197__$1 = cljs.core.first.call(null,inst_19196);
var inst_19198 = cljs.core.next.call(null,inst_19196);
var state_19428__$1 = (function (){var statearr_19603 = state_19428;
(statearr_19603[(28)] = inst_19197__$1);

(statearr_19603[(44)] = inst_19198);

return statearr_19603;
})();
if(cljs.core.truth_(inst_19197__$1)){
var statearr_19604_19781 = state_19428__$1;
(statearr_19604_19781[(1)] = (81));

} else {
var statearr_19605_19782 = state_19428__$1;
(statearr_19605_19782[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (38))){
var inst_19065 = (state_19428[(43)]);
var inst_19073 = (state_19428[(2)]);
var inst_19074 = [null,inst_19073];
var inst_19075 = (new cljs.core.PersistentVector(null,2,(5),inst_19065,inst_19074,null));
var state_19428__$1 = state_19428;
var statearr_19606_19783 = state_19428__$1;
(statearr_19606_19783[(2)] = inst_19075);

(statearr_19606_19783[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (126))){
var state_19428__$1 = state_19428;
var statearr_19607_19784 = state_19428__$1;
(statearr_19607_19784[(2)] = null);

(statearr_19607_19784[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (98))){
var inst_19244 = (state_19428[(60)]);
var inst_19308 = (state_19428[(2)]);
var inst_19309 = [inst_19308,offset_map];
var inst_19310 = (new cljs.core.PersistentVector(null,2,(5),inst_19244,inst_19309,null));
var state_19428__$1 = state_19428;
var statearr_19608_19785 = state_19428__$1;
(statearr_19608_19785[(2)] = inst_19310);

(statearr_19608_19785[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (124))){
var inst_19364 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19609_19786 = state_19428__$1;
(statearr_19609_19786[(2)] = inst_19364);

(statearr_19609_19786[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (87))){
var inst_19197 = (state_19428[(28)]);
var inst_19030 = (state_19428[(15)]);
var inst_19213 = (state_19428[(2)]);
var inst_19214 = fluree.db.util.async.throw_err.call(null,inst_19213);
var inst_19215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19216 = fluree.db.flake.o.call(null,inst_19197);
var inst_19217 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_19030);
var inst_19218 = [inst_19216,inst_19217];
var inst_19219 = (new cljs.core.PersistentVector(null,2,(5),inst_19215,inst_19218,null));
var inst_19220 = fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_19219,inst_19214);
var state_19428__$1 = (function (){var statearr_19610 = state_19428;
(statearr_19610[(61)] = inst_19220);

return statearr_19610;
})();
var statearr_19611_19787 = state_19428__$1;
(statearr_19611_19787[(2)] = inst_19214);

(statearr_19611_19787[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (30))){
var inst_19048 = (state_19428[(20)]);
var inst_19053 = cljs.core.get.call(null,offset_map,inst_19048);
var inst_19054 = cljs.core.not_EQ_.call(null,(0),inst_19053);
var state_19428__$1 = state_19428;
var statearr_19612_19788 = state_19428__$1;
(statearr_19612_19788[(2)] = inst_19054);

(statearr_19612_19788[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (73))){
var inst_19153 = (state_19428[(22)]);
var inst_19128 = (state_19428[(9)]);
var inst_19162 = cljs.core.conj.call(null,inst_19128,inst_19153);
var state_19428__$1 = state_19428;
var statearr_19613_19789 = state_19428__$1;
(statearr_19613_19789[(2)] = inst_19162);

(statearr_19613_19789[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (96))){
var inst_19388 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
var statearr_19614_19790 = state_19428__$1;
(statearr_19614_19790[(2)] = inst_19388);

(statearr_19614_19790[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (10))){
var state_19428__$1 = state_19428;
var statearr_19615_19791 = state_19428__$1;
(statearr_19615_19791[(2)] = pred_spec);

(statearr_19615_19791[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (18))){
var inst_19031 = (state_19428[(52)]);
var state_19428__$1 = state_19428;
var statearr_19616_19792 = state_19428__$1;
(statearr_19616_19792[(2)] = inst_19031);

(statearr_19616_19792[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (105))){
var inst_19296 = (state_19428[(2)]);
var state_19428__$1 = (function (){var statearr_19617 = state_19428;
(statearr_19617[(46)] = inst_19296);

return statearr_19617;
})();
if(cljs.core.truth_(fuel)){
var statearr_19618_19793 = state_19428__$1;
(statearr_19618_19793[(1)] = (107));

} else {
var statearr_19619_19794 = state_19428__$1;
(statearr_19619_19794[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (52))){
var inst_19098 = (state_19428[(62)]);
var state_19428__$1 = state_19428;
var statearr_19620_19795 = state_19428__$1;
(statearr_19620_19795[(2)] = inst_19098);

(statearr_19620_19795[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (114))){
var inst_19330 = flakes;
var inst_19331 = cljs.core.seq.call(null,inst_19330);
var inst_19332 = cljs.core.first.call(null,inst_19331);
var inst_19333 = cljs.core.next.call(null,inst_19331);
var inst_19334 = cljs.core.PersistentVector.EMPTY;
var inst_19335 = inst_19330;
var inst_19336 = inst_19334;
var state_19428__$1 = (function (){var statearr_19621 = state_19428;
(statearr_19621[(33)] = inst_19336);

(statearr_19621[(63)] = inst_19333);

(statearr_19621[(38)] = inst_19335);

(statearr_19621[(64)] = inst_19332);

return statearr_19621;
})();
var statearr_19622_19796 = state_19428__$1;
(statearr_19622_19796[(2)] = null);

(statearr_19622_19796[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (67))){
var state_19428__$1 = state_19428;
var statearr_19623_19797 = state_19428__$1;
(statearr_19623_19797[(2)] = null);

(statearr_19623_19797[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (71))){
var state_19428__$1 = state_19428;
var statearr_19624_19798 = state_19428__$1;
(statearr_19624_19798[(2)] = null);

(statearr_19624_19798[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (42))){
var inst_19045 = (state_19428[(18)]);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19045)){
var statearr_19625_19799 = state_19428__$1;
(statearr_19625_19799[(1)] = (45));

} else {
var statearr_19626_19800 = state_19428__$1;
(statearr_19626_19800[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (80))){
var inst_19177 = (state_19428[(54)]);
var inst_19233 = (state_19428[(2)]);
var inst_19234 = [inst_19233,offset_map];
var inst_19235 = (new cljs.core.PersistentVector(null,2,(5),inst_19177,inst_19234,null));
var state_19428__$1 = state_19428;
var statearr_19627_19801 = state_19428__$1;
(statearr_19627_19801[(2)] = inst_19235);

(statearr_19627_19801[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (37))){
var inst_19047 = (state_19428[(16)]);
var inst_19048 = (state_19428[(20)]);
var inst_19070 = (inst_19047 - (1));
var inst_19071 = cljs.core.assoc.call(null,offset_map,inst_19048,inst_19070);
var state_19428__$1 = state_19428;
var statearr_19628_19802 = state_19428__$1;
(statearr_19628_19802[(2)] = inst_19071);

(statearr_19628_19802[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (63))){
var inst_19128 = (state_19428[(9)]);
var state_19428__$1 = state_19428;
var statearr_19629_19803 = state_19428__$1;
(statearr_19629_19803[(2)] = inst_19128);

(statearr_19629_19803[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (94))){
var inst_19244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19252 = flakes;
var inst_19253 = cljs.core.seq.call(null,inst_19252);
var inst_19254 = cljs.core.first.call(null,inst_19253);
var inst_19255 = cljs.core.next.call(null,inst_19253);
var inst_19256 = cljs.core.PersistentVector.EMPTY;
var inst_19257 = inst_19252;
var inst_19258 = inst_19256;
var state_19428__$1 = (function (){var statearr_19630 = state_19428;
(statearr_19630[(48)] = inst_19257);

(statearr_19630[(65)] = inst_19254);

(statearr_19630[(66)] = inst_19255);

(statearr_19630[(32)] = inst_19258);

(statearr_19630[(60)] = inst_19244);

return statearr_19630;
})();
var statearr_19631_19804 = state_19428__$1;
(statearr_19631_19804[(2)] = null);

(statearr_19631_19804[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (8))){
var inst_19007 = (state_19428[(2)]);
var state_19428__$1 = state_19428;
if(cljs.core.truth_(inst_19007)){
var statearr_19632_19805 = state_19428__$1;
(statearr_19632_19805[(1)] = (9));

} else {
var statearr_19633_19806 = state_19428__$1;
(statearr_19633_19806[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (49))){
var inst_19098 = (state_19428[(62)]);
var inst_19098__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_19428__$1 = (function (){var statearr_19634 = state_19428;
(statearr_19634[(62)] = inst_19098__$1);

return statearr_19634;
})();
if(inst_19098__$1){
var statearr_19635_19807 = state_19428__$1;
(statearr_19635_19807[(1)] = (51));

} else {
var statearr_19636_19808 = state_19428__$1;
(statearr_19636_19808[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19429 === (84))){
var inst_19206 = (state_19428[(59)]);
var state_19428__$1 = state_19428;
var statearr_19637_19809 = state_19428__$1;
(statearr_19637_19809[(2)] = inst_19206);

(statearr_19637_19809[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____0 = (function (){
var statearr_19638 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19638[(0)] = fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__);

(statearr_19638[(1)] = (1));

return statearr_19638;
});
var fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____1 = (function (state_19428){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_19428);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19639){var ex__2687__auto__ = e19639;
var statearr_19640_19810 = state_19428;
(statearr_19640_19810[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_19428[(4)]))){
var statearr_19641_19811 = state_19428;
(statearr_19641_19811[(1)] = cljs.core.first.call(null,(state_19428[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19812 = state_19428;
state_19428 = G__19812;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__ = function(state_19428){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____1.call(this,state_19428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19642 = f__2707__auto__.call(null);
(statearr_19642[(6)] = c__2706__auto__);

return statearr_19642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__19814 = res;
var G__19814__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__19813_SHARP_){
return cljs.core.get.call(null,p1__19813_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__19814):G__19814);
var G__19814__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__19814__$1):G__19814__$1);
var G__19814__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__19814__$2):G__19814__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__19814__$3);
} else {
return G__19814__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,p__19815,flakes){
var map__19816 = p__19815;
var map__19816__$1 = cljs.core.__destructure_map.call(null,map__19816);
var opts = map__19816__$1;
var parse_json_QMARK_ = cljs.core.get.call(null,map__19816__$1,new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20011){
var state_val_20012 = (state_20011[(1)]);
if((state_val_20012 === (7))){
var state_20011__$1 = state_20011;
var statearr_20013_20105 = state_20011__$1;
(statearr_20013_20105[(2)] = null);

(statearr_20013_20105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (20))){
var inst_19858 = cljs.core.PersistentHashMap.EMPTY;
var state_20011__$1 = state_20011;
var statearr_20014_20106 = state_20011__$1;
(statearr_20014_20106[(2)] = inst_19858);

(statearr_20014_20106[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (27))){
var inst_19860 = (state_20011[(7)]);
var inst_19838 = (state_20011[(8)]);
var inst_19845 = (state_20011[(9)]);
var inst_19877 = (state_20011[(10)]);
var inst_19989 = (state_20011[(2)]);
var inst_19990 = fluree.db.util.log.debug.call(null,"flakes->res result:",inst_19989);
var inst_19991 = (function (){var top_level_subject = inst_19838;
var _ = inst_19990;
var select_spec = inst_19845;
var base_acc = inst_19860;
var acc_PLUS_refs = inst_19877;
var result = inst_19989;
return (function (acc,spec){
fluree.db.util.log.debug.call(null,"flakes->res sort-preds acc:",acc);

if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_19992 = cljs.core.PersistentVector.EMPTY;
var inst_19993 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_19845);
var inst_19994 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_19993);
var inst_19995 = cljs.core.vals.call(null,inst_19994);
var inst_19996 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_19845);
var inst_19997 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_19996);
var inst_19998 = cljs.core.vals.call(null,inst_19997);
var inst_19999 = cljs.core.concat.call(null,inst_19995,inst_19998);
var inst_20000 = cljs.core.reduce.call(null,inst_19991,inst_19992,inst_19999);
var inst_20002 = (function (){var top_level_subject = inst_19838;
var _ = inst_19990;
var select_spec = inst_19845;
var base_acc = inst_19860;
var acc_PLUS_refs = inst_19877;
var result = inst_19989;
var sort_preds = inst_20000;
return (function (acc,p__20001){
var vec__20015 = p__20001;
var select_pred = cljs.core.nth.call(null,vec__20015,(0),null);
var sort_order = cljs.core.nth.call(null,vec__20015,(1),null);
var sort_pred = cljs.core.nth.call(null,vec__20015,(2),null);
var limit = cljs.core.nth.call(null,vec__20015,(3),null);
fluree.db.util.log.debug.call(null,"flakes->res return acc:",acc);

return cljs.core.assoc.call(null,acc,select_pred,fluree.db.query.fql_resp.sort_offset_and_limit_res.call(null,sort_pred,sort_order,(0),limit,cljs.core.get.call(null,acc,select_pred)));
});
})();
var inst_20003 = cljs.core.reduce.call(null,inst_20002,inst_19989,inst_20000);
var state_20011__$1 = state_20011;
var statearr_20018_20107 = state_20011__$1;
(statearr_20018_20107[(2)] = inst_20003);

(statearr_20018_20107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (1))){
var state_20011__$1 = state_20011;
var statearr_20019_20108 = state_20011__$1;
(statearr_20019_20108[(2)] = null);

(statearr_20019_20108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (24))){
var inst_19877 = (state_20011[(10)]);
var inst_19877__$1 = (state_20011[(2)]);
var inst_19878 = fluree.db.util.log.debug.call(null,"flakes->res acc+refs:",inst_19877__$1);
var inst_19879 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_19880 = cljs.core.PersistentHashMap.EMPTY;
var inst_19881 = inst_19879;
var inst_19882 = inst_19877__$1;
var inst_19883 = inst_19880;
var state_20011__$1 = (function (){var statearr_20020 = state_20011;
(statearr_20020[(11)] = inst_19883);

(statearr_20020[(12)] = inst_19878);

(statearr_20020[(13)] = inst_19881);

(statearr_20020[(14)] = inst_19882);

(statearr_20020[(10)] = inst_19877__$1);

return statearr_20020;
})();
var statearr_20021_20109 = state_20011__$1;
(statearr_20021_20109[(2)] = null);

(statearr_20021_20109[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (39))){
var inst_19845 = (state_20011[(9)]);
var inst_19932 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_19845);
var state_20011__$1 = state_20011;
if(cljs.core.truth_(inst_19932)){
var statearr_20022_20110 = state_20011__$1;
(statearr_20022_20110[(1)] = (42));

} else {
var statearr_20023_20111 = state_20011__$1;
(statearr_20023_20111[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (46))){
var inst_19845 = (state_20011[(9)]);
var inst_19948 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_19845);
var state_20011__$1 = state_20011;
var statearr_20024_20112 = state_20011__$1;
(statearr_20024_20112[(2)] = inst_19948);

(statearr_20024_20112[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (4))){
var inst_19817 = (state_20011[(2)]);
var state_20011__$1 = state_20011;
var statearr_20025_20113 = state_20011__$1;
(statearr_20025_20113[(2)] = inst_19817);

(statearr_20025_20113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (54))){
var inst_19970 = (state_20011[(2)]);
var state_20011__$1 = state_20011;
var statearr_20026_20114 = state_20011__$1;
(statearr_20026_20114[(2)] = inst_19970);

(statearr_20026_20114[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (15))){
var inst_19845 = (state_20011[(9)]);
var inst_19847 = (state_20011[(15)]);
var inst_19845__$1 = (state_20011[(2)]);
var inst_19846 = fluree.db.util.log.debug.call(null,"flakes->res select-spec:",inst_19845__$1);
var inst_19847__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_19845__$1);
var state_20011__$1 = (function (){var statearr_20027 = state_20011;
(statearr_20027[(16)] = inst_19846);

(statearr_20027[(9)] = inst_19845__$1);

(statearr_20027[(15)] = inst_19847__$1);

return statearr_20027;
})();
if(cljs.core.truth_(inst_19847__$1)){
var statearr_20028_20115 = state_20011__$1;
(statearr_20028_20115[(1)] = (16));

} else {
var statearr_20029_20116 = state_20011__$1;
(statearr_20029_20116[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (48))){
var inst_19951 = (state_20011[(2)]);
var state_20011__$1 = state_20011;
if(cljs.core.truth_(inst_19951)){
var statearr_20030_20117 = state_20011__$1;
(statearr_20030_20117[(1)] = (49));

} else {
var statearr_20031_20118 = state_20011__$1;
(statearr_20031_20118[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (50))){
var state_20011__$1 = state_20011;
var statearr_20032_20119 = state_20011__$1;
(statearr_20032_20119[(1)] = (52));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (21))){
var inst_19860 = (state_20011[(7)]);
var inst_19845 = (state_20011[(9)]);
var inst_19860__$1 = (state_20011[(2)]);
var inst_19861 = fluree.db.util.log.debug.call(null,"flakes->res base-acc:",inst_19860__$1);
var inst_19862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19863 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_19864 = (new cljs.core.PersistentVector(null,2,(5),inst_19862,inst_19863,null));
var inst_19865 = cljs.core.get_in.call(null,inst_19845,inst_19864);
var state_20011__$1 = (function (){var statearr_20034 = state_20011;
(statearr_20034[(7)] = inst_19860__$1);

(statearr_20034[(17)] = inst_19861);

return statearr_20034;
})();
if(cljs.core.truth_(inst_19865)){
var statearr_20035_20120 = state_20011__$1;
(statearr_20035_20120[(1)] = (22));

} else {
var statearr_20036_20121 = state_20011__$1;
(statearr_20036_20121[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (31))){
var inst_19891 = (state_20011[(18)]);
var inst_19894 = fluree.db.util.json.parse_json_flakes.call(null,db,inst_19891);
var state_20011__$1 = state_20011;
var statearr_20037_20122 = state_20011__$1;
(statearr_20037_20122[(2)] = inst_19894);

(statearr_20037_20122[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (32))){
var inst_19891 = (state_20011[(18)]);
var state_20011__$1 = state_20011;
var statearr_20038_20123 = state_20011__$1;
(statearr_20038_20123[(2)] = inst_19891);

(statearr_20038_20123[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (40))){
var inst_19976 = (state_20011[(2)]);
var state_20011__$1 = state_20011;
var statearr_20039_20124 = state_20011__$1;
(statearr_20039_20124[(2)] = inst_19976);

(statearr_20039_20124[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (33))){
var inst_19897 = (state_20011[(19)]);
var inst_19903 = (state_20011[(20)]);
var inst_19845 = (state_20011[(9)]);
var inst_19897__$1 = (state_20011[(2)]);
var inst_19898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19899 = cljs.core.first.call(null,inst_19897__$1);
var inst_19900 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_19899);
var inst_19901 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_19900];
var inst_19902 = (new cljs.core.PersistentVector(null,3,(5),inst_19898,inst_19901,null));
var inst_19903__$1 = cljs.core.get_in.call(null,inst_19845,inst_19902);
var inst_19904 = fluree.db.util.log.debug.call(null,"flakes->res pred-spec:",inst_19903__$1);
var inst_19905 = fluree.db.query.fql_resp.component_follow_QMARK_.call(null,inst_19903__$1,inst_19845);
var inst_19906 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_19903__$1);
var state_20011__$1 = (function (){var statearr_20040 = state_20011;
(statearr_20040[(19)] = inst_19897__$1);

(statearr_20040[(20)] = inst_19903__$1);

(statearr_20040[(21)] = inst_19905);

(statearr_20040[(22)] = inst_19904);

return statearr_20040;
})();
if(cljs.core.truth_(inst_19906)){
var statearr_20041_20125 = state_20011__$1;
(statearr_20041_20125[(1)] = (34));

} else {
var statearr_20042_20126 = state_20011__$1;
(statearr_20042_20126[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (13))){
var inst_19838 = (state_20011[(8)]);
var inst_19842 = fluree.db.query.fql_resp.full_select_spec.call(null,db,cache,base_select_spec,inst_19838);
var state_20011__$1 = state_20011;
var statearr_20043_20127 = state_20011__$1;
(statearr_20043_20127[(2)] = inst_19842);

(statearr_20043_20127[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (22))){
var inst_19845 = (state_20011[(9)]);
var inst_19867 = cljs.core.first.call(null,flakes);
var inst_19868 = fluree.db.flake.s.call(null,inst_19867);
var inst_19869 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs.call(null,inst_19845);
var inst_19870 = fluree.db.query.fql_resp.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_19868,opts,inst_19869);
var state_20011__$1 = state_20011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20011__$1,(25),inst_19870);
} else {
if((state_val_20012 === (36))){
var inst_19897 = (state_20011[(19)]);
var inst_19978 = (state_20011[(2)]);
var inst_19979 = cljs.core.nth.call(null,inst_19978,(0),null);
var inst_19980 = cljs.core.nth.call(null,inst_19978,(1),null);
var inst_19981 = cljs.core.nth.call(null,inst_19978,(2),null);
var inst_19982 = cljs.core.first.call(null,inst_19897);
var inst_19983 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_19982);
var inst_19984 = cljs.core.assoc.call(null,inst_19979,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_19983);
var inst_19881 = inst_19980;
var inst_19882 = inst_19984;
var inst_19883 = inst_19981;
var state_20011__$1 = (function (){var statearr_20044 = state_20011;
(statearr_20044[(11)] = inst_19883);

(statearr_20044[(13)] = inst_19881);

(statearr_20044[(14)] = inst_19882);

return statearr_20044;
})();
var statearr_20045_20128 = state_20011__$1;
(statearr_20045_20128[(2)] = null);

(statearr_20045_20128[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (41))){
var inst_19881 = (state_20011[(13)]);
var inst_19923 = (state_20011[(2)]);
var inst_19924 = fluree.db.util.async.throw_err.call(null,inst_19923);
var inst_19925 = cljs.core.nth.call(null,inst_19924,(0),null);
var inst_19926 = cljs.core.nth.call(null,inst_19924,(1),null);
var inst_19927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19928 = cljs.core.rest.call(null,inst_19881);
var inst_19929 = [inst_19925,inst_19928,inst_19926];
var inst_19930 = (new cljs.core.PersistentVector(null,3,(5),inst_19927,inst_19929,null));
var state_20011__$1 = state_20011;
var statearr_20046_20129 = state_20011__$1;
(statearr_20046_20129[(2)] = inst_19930);

(statearr_20046_20129[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (43))){
var inst_19946 = (state_20011[(23)]);
var inst_19845 = (state_20011[(9)]);
var inst_19945 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_19845);
var inst_19946__$1 = cljs.core.empty_QMARK_.call(null,inst_19945);
var state_20011__$1 = (function (){var statearr_20047 = state_20011;
(statearr_20047[(23)] = inst_19946__$1);

return statearr_20047;
})();
if(inst_19946__$1){
var statearr_20048_20130 = state_20011__$1;
(statearr_20048_20130[(1)] = (46));

} else {
var statearr_20049_20131 = state_20011__$1;
(statearr_20049_20131[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (29))){
var inst_19881 = (state_20011[(13)]);
var inst_19891 = (state_20011[(18)]);
var inst_19891__$1 = cljs.core.first.call(null,inst_19881);
var inst_19892 = fluree.db.util.log.debug.call(null,"flakes->res loop flakes:",inst_19891__$1);
var state_20011__$1 = (function (){var statearr_20050 = state_20011;
(statearr_20050[(24)] = inst_19892);

(statearr_20050[(18)] = inst_19891__$1);

return statearr_20050;
})();
if(cljs.core.truth_(parse_json_QMARK_)){
var statearr_20051_20132 = state_20011__$1;
(statearr_20051_20132[(1)] = (31));

} else {
var statearr_20052_20133 = state_20011__$1;
(statearr_20052_20133[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (44))){
var inst_19974 = (state_20011[(2)]);
var state_20011__$1 = state_20011;
var statearr_20053_20134 = state_20011__$1;
(statearr_20053_20134[(2)] = inst_19974);

(statearr_20053_20134[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (6))){
var inst_19825 = fluree.db.util.log.debug.call(null,"flakes->res flakes:",flakes);
var state_20011__$1 = (function (){var statearr_20054 = state_20011;
(statearr_20054[(25)] = inst_19825);

return statearr_20054;
})();
var statearr_20055_20135 = state_20011__$1;
(statearr_20055_20135[(2)] = null);

(statearr_20055_20135[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (28))){
var inst_19882 = (state_20011[(14)]);
var state_20011__$1 = state_20011;
var statearr_20056_20136 = state_20011__$1;
(statearr_20056_20136[(2)] = inst_19882);

(statearr_20056_20136[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (51))){
var inst_19972 = (state_20011[(2)]);
var state_20011__$1 = state_20011;
var statearr_20057_20137 = state_20011__$1;
(statearr_20057_20137[(2)] = inst_19972);

(statearr_20057_20137[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (25))){
var inst_19860 = (state_20011[(7)]);
var inst_19872 = (state_20011[(2)]);
var inst_19873 = fluree.db.util.async.throw_err.call(null,inst_19872);
var inst_19874 = cljs.core.merge.call(null,inst_19860,inst_19873);
var state_20011__$1 = state_20011;
var statearr_20058_20138 = state_20011__$1;
(statearr_20058_20138[(2)] = inst_19874);

(statearr_20058_20138[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (34))){
var inst_19897 = (state_20011[(19)]);
var inst_19903 = (state_20011[(20)]);
var inst_19882 = (state_20011[(14)]);
var inst_19908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19909 = fluree.db.query.fql_resp.flake__GT_recur.call(null,db,inst_19897,inst_19903,inst_19882,fuel,max_fuel,cache,opts);
var state_20011__$1 = (function (){var statearr_20059 = state_20011;
(statearr_20059[(26)] = inst_19908);

return statearr_20059;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20011__$1,(37),inst_19909);
} else {
if((state_val_20012 === (17))){
var inst_19845 = (state_20011[(9)]);
var inst_19850 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_19845);
var state_20011__$1 = state_20011;
var statearr_20061_20139 = state_20011__$1;
(statearr_20061_20139[(2)] = inst_19850);

(statearr_20061_20139[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (3))){
var inst_20009 = (state_20011[(2)]);
var state_20011__$1 = state_20011;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20011__$1,inst_20009);
} else {
if((state_val_20012 === (12))){
var _ = (function (){var statearr_20062 = state_20011;
(statearr_20062[(4)] = cljs.core.rest.call(null,(state_20011[(4)])));

return statearr_20062;
})();
var state_20011__$1 = state_20011;
var ex20060 = (state_20011__$1[(2)]);
var statearr_20063_20140 = state_20011__$1;
(statearr_20063_20140[(5)] = ex20060);


var statearr_20064_20141 = state_20011__$1;
(statearr_20064_20141[(1)] = (11));

(statearr_20064_20141[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (2))){
var _ = (function (){var statearr_20065 = state_20011;
(statearr_20065[(4)] = cljs.core.cons.call(null,(5),(state_20011[(4)])));

return statearr_20065;
})();
var inst_19823 = cljs.core.not_empty.call(null,flakes);
var state_20011__$1 = state_20011;
if(cljs.core.truth_(inst_19823)){
var statearr_20066_20142 = state_20011__$1;
(statearr_20066_20142[(1)] = (6));

} else {
var statearr_20067_20143 = state_20011__$1;
(statearr_20067_20143[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (23))){
var inst_19860 = (state_20011[(7)]);
var state_20011__$1 = state_20011;
var statearr_20068_20144 = state_20011__$1;
(statearr_20068_20144[(2)] = inst_19860);

(statearr_20068_20144[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (47))){
var inst_19946 = (state_20011[(23)]);
var state_20011__$1 = state_20011;
var statearr_20069_20145 = state_20011__$1;
(statearr_20069_20145[(2)] = inst_19946);

(statearr_20069_20145[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (35))){
var inst_19903 = (state_20011[(20)]);
var state_20011__$1 = state_20011;
if(cljs.core.truth_(inst_19903)){
var statearr_20070_20146 = state_20011__$1;
(statearr_20070_20146[(1)] = (38));

} else {
var statearr_20071_20147 = state_20011__$1;
(statearr_20071_20147[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (19))){
var inst_19838 = (state_20011[(8)]);
var inst_19854 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_19855 = [inst_19838];
var inst_19856 = cljs.core.PersistentHashMap.fromArrays(inst_19854,inst_19855);
var state_20011__$1 = state_20011;
var statearr_20072_20148 = state_20011__$1;
(statearr_20072_20148[(2)] = inst_19856);

(statearr_20072_20148[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (11))){
var inst_19826 = (state_20011[(2)]);
var inst_19827 = fluree.db.util.log.error.call(null,inst_19826);
var inst_19828 = (function(){throw inst_19826})();
var state_20011__$1 = (function (){var statearr_20074 = state_20011;
(statearr_20074[(27)] = inst_19827);

return statearr_20074;
})();
var statearr_20075_20149 = state_20011__$1;
(statearr_20075_20149[(2)] = inst_19828);

(statearr_20075_20149[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (9))){
var _ = (function (){var statearr_20076 = state_20011;
(statearr_20076[(4)] = cljs.core.cons.call(null,(12),(state_20011[(4)])));

return statearr_20076;
})();
var inst_19834 = cljs.core.first.call(null,flakes);
var inst_19835 = fluree.db.flake.s.call(null,inst_19834);
var ___$1 = (function (){var statearr_20077 = state_20011;
(statearr_20077[(4)] = cljs.core.rest.call(null,(state_20011[(4)])));

return statearr_20077;
})();
var state_20011__$1 = state_20011;
var statearr_20078_20150 = state_20011__$1;
(statearr_20078_20150[(2)] = inst_19835);

(statearr_20078_20150[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (5))){
var _ = (function (){var statearr_20079 = state_20011;
(statearr_20079[(4)] = cljs.core.rest.call(null,(state_20011[(4)])));

return statearr_20079;
})();
var state_20011__$1 = state_20011;
var ex20073 = (state_20011__$1[(2)]);
var statearr_20080_20151 = state_20011__$1;
(statearr_20080_20151[(5)] = ex20073);


if((ex20073 instanceof Error)){
var statearr_20081_20152 = state_20011__$1;
(statearr_20081_20152[(1)] = (4));

(statearr_20081_20152[(5)] = null);

} else {
throw ex20073;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (14))){
var state_20011__$1 = state_20011;
var statearr_20082_20153 = state_20011__$1;
(statearr_20082_20153[(2)] = base_select_spec);

(statearr_20082_20153[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (45))){
var inst_19883 = (state_20011[(11)]);
var inst_19881 = (state_20011[(13)]);
var inst_19934 = (state_20011[(28)]);
var inst_19938 = (state_20011[(2)]);
var inst_19939 = fluree.db.util.async.throw_err.call(null,inst_19938);
var inst_19940 = cljs.core.first.call(null,inst_19939);
var inst_19941 = cljs.core.rest.call(null,inst_19881);
var inst_19942 = [inst_19940,inst_19941,inst_19883];
var inst_19943 = (new cljs.core.PersistentVector(null,3,(5),inst_19934,inst_19942,null));
var state_20011__$1 = state_20011;
var statearr_20083_20154 = state_20011__$1;
(statearr_20083_20154[(2)] = inst_19943);

(statearr_20083_20154[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (53))){
var state_20011__$1 = state_20011;
var statearr_20084_20155 = state_20011__$1;
(statearr_20084_20155[(2)] = null);

(statearr_20084_20155[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (26))){
var inst_19881 = (state_20011[(13)]);
var inst_19885 = cljs.core.empty_QMARK_.call(null,inst_19881);
var state_20011__$1 = state_20011;
if(inst_19885){
var statearr_20085_20156 = state_20011__$1;
(statearr_20085_20156[(1)] = (28));

} else {
var statearr_20086_20157 = state_20011__$1;
(statearr_20086_20157[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (16))){
var inst_19847 = (state_20011[(15)]);
var state_20011__$1 = state_20011;
var statearr_20087_20158 = state_20011__$1;
(statearr_20087_20158[(2)] = inst_19847);

(statearr_20087_20158[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (38))){
var inst_19897 = (state_20011[(19)]);
var inst_19883 = (state_20011[(11)]);
var inst_19903 = (state_20011[(20)]);
var inst_19882 = (state_20011[(14)]);
var inst_19905 = (state_20011[(21)]);
var inst_19921 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_19882,inst_19903,inst_19897,inst_19905,false,inst_19883,opts);
var state_20011__$1 = state_20011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20011__$1,(41),inst_19921);
} else {
if((state_val_20012 === (30))){
var inst_19987 = (state_20011[(2)]);
var state_20011__$1 = state_20011;
var statearr_20088_20159 = state_20011__$1;
(statearr_20088_20159[(2)] = inst_19987);

(statearr_20088_20159[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (10))){
var inst_19838 = (state_20011[(8)]);
var inst_19838__$1 = (state_20011[(2)]);
var inst_19839 = fluree.db.util.log.debug.call(null,"flakes->res top-level-subject:",inst_19838__$1);
var inst_19840 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_20011__$1 = (function (){var statearr_20089 = state_20011;
(statearr_20089[(8)] = inst_19838__$1);

(statearr_20089[(29)] = inst_19839);

return statearr_20089;
})();
if(cljs.core.truth_(inst_19840)){
var statearr_20090_20160 = state_20011__$1;
(statearr_20090_20160[(1)] = (13));

} else {
var statearr_20091_20161 = state_20011__$1;
(statearr_20091_20161[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (18))){
var inst_19852 = (state_20011[(2)]);
var state_20011__$1 = state_20011;
if(cljs.core.truth_(inst_19852)){
var statearr_20092_20162 = state_20011__$1;
(statearr_20092_20162[(1)] = (19));

} else {
var statearr_20093_20163 = state_20011__$1;
(statearr_20093_20163[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (52))){
var inst_19883 = (state_20011[(11)]);
var inst_19881 = (state_20011[(13)]);
var inst_19882 = (state_20011[(14)]);
var inst_19964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19965 = cljs.core.rest.call(null,inst_19881);
var inst_19966 = [inst_19882,inst_19965,inst_19883];
var inst_19967 = (new cljs.core.PersistentVector(null,3,(5),inst_19964,inst_19966,null));
var state_20011__$1 = state_20011;
var statearr_20094_20164 = state_20011__$1;
(statearr_20094_20164[(2)] = inst_19967);

(statearr_20094_20164[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (42))){
var inst_19897 = (state_20011[(19)]);
var inst_19882 = (state_20011[(14)]);
var inst_19905 = (state_20011[(21)]);
var inst_19845 = (state_20011[(9)]);
var inst_19934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19935 = cljs.core.PersistentHashMap.EMPTY;
var inst_19936 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_19882,inst_19845,inst_19897,inst_19905,false,inst_19935,opts);
var state_20011__$1 = (function (){var statearr_20095 = state_20011;
(statearr_20095[(28)] = inst_19934);

return statearr_20095;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20011__$1,(45),inst_19936);
} else {
if((state_val_20012 === (37))){
var inst_19883 = (state_20011[(11)]);
var inst_19881 = (state_20011[(13)]);
var inst_19908 = (state_20011[(26)]);
var inst_19911 = (state_20011[(2)]);
var inst_19912 = fluree.db.util.async.throw_err.call(null,inst_19911);
var inst_19913 = cljs.core.rest.call(null,inst_19881);
var inst_19914 = [inst_19912,inst_19913,inst_19883];
var inst_19915 = (new cljs.core.PersistentVector(null,3,(5),inst_19908,inst_19914,null));
var state_20011__$1 = state_20011;
var statearr_20096_20165 = state_20011__$1;
(statearr_20096_20165[(2)] = inst_19915);

(statearr_20096_20165[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (8))){
var inst_20006 = (state_20011[(2)]);
var _ = (function (){var statearr_20097 = state_20011;
(statearr_20097[(4)] = cljs.core.rest.call(null,(state_20011[(4)])));

return statearr_20097;
})();
var state_20011__$1 = state_20011;
var statearr_20098_20166 = state_20011__$1;
(statearr_20098_20166[(2)] = inst_20006);

(statearr_20098_20166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20012 === (49))){
var inst_19897 = (state_20011[(19)]);
var inst_19883 = (state_20011[(11)]);
var inst_19881 = (state_20011[(13)]);
var inst_19953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19954 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_19955 = cljs.core.first.call(null,inst_19897);
var inst_19956 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_19955);
var inst_19957 = [inst_19956];
var inst_19958 = cljs.core.PersistentHashMap.fromArrays(inst_19954,inst_19957);
var inst_19959 = cljs.core.rest.call(null,inst_19881);
var inst_19960 = [inst_19958,inst_19959,inst_19883];
var inst_19961 = (new cljs.core.PersistentVector(null,3,(5),inst_19953,inst_19960,null));
var state_20011__$1 = state_20011;
var statearr_20099_20167 = state_20011__$1;
(statearr_20099_20167[(2)] = inst_19961);

(statearr_20099_20167[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____0 = (function (){
var statearr_20100 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20100[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__);

(statearr_20100[(1)] = (1));

return statearr_20100;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____1 = (function (state_20011){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_20011);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20101){var ex__2687__auto__ = e20101;
var statearr_20102_20168 = state_20011;
(statearr_20102_20168[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_20011[(4)]))){
var statearr_20103_20169 = state_20011;
(statearr_20103_20169[(1)] = cljs.core.first.call(null,(state_20011[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20170 = state_20011;
state_20011 = G__20170;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__ = function(state_20011){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____1.call(this,state_20011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20104 = f__2707__auto__.call(null);
(statearr_20104[(6)] = c__2706__auto__);

return statearr_20104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
