// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15966){
var state_val_15967 = (state_15966[(1)]);
if((state_val_15967 === (1))){
var state_15966__$1 = state_15966;
var statearr_15968_15982 = state_15966__$1;
(statearr_15968_15982[(2)] = null);

(statearr_15968_15982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15967 === (2))){
var _ = (function (){var statearr_15969 = state_15966;
(statearr_15969[(4)] = cljs.core.cons.call(null,(5),(state_15966[(4)])));

return statearr_15969;
})();
var inst_15957 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_15966__$1 = state_15966;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15966__$1,(6),inst_15957);
} else {
if((state_val_15967 === (3))){
var inst_15964 = (state_15966[(2)]);
var state_15966__$1 = state_15966;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15966__$1,inst_15964);
} else {
if((state_val_15967 === (4))){
var inst_15951 = (state_15966[(2)]);
var state_15966__$1 = state_15966;
var statearr_15971_15983 = state_15966__$1;
(statearr_15971_15983[(2)] = inst_15951);

(statearr_15971_15983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15967 === (5))){
var _ = (function (){var statearr_15972 = state_15966;
(statearr_15972[(4)] = cljs.core.rest.call(null,(state_15966[(4)])));

return statearr_15972;
})();
var state_15966__$1 = state_15966;
var ex15970 = (state_15966__$1[(2)]);
var statearr_15973_15984 = state_15966__$1;
(statearr_15973_15984[(5)] = ex15970);


if((ex15970 instanceof Error)){
var statearr_15974_15985 = state_15966__$1;
(statearr_15974_15985[(1)] = (4));

(statearr_15974_15985[(5)] = null);

} else {
throw ex15970;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15967 === (6))){
var inst_15959 = (state_15966[(2)]);
var inst_15960 = fluree.db.util.async.throw_err.call(null,inst_15959);
var inst_15961 = cljs.core.keyword.call(null,inst_15960);
var _ = (function (){var statearr_15975 = state_15966;
(statearr_15975[(4)] = cljs.core.rest.call(null,(state_15966[(4)])));

return statearr_15975;
})();
var state_15966__$1 = state_15966;
var statearr_15976_15986 = state_15966__$1;
(statearr_15976_15986[(2)] = inst_15961);

(statearr_15976_15986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0 = (function (){
var statearr_15977 = [null,null,null,null,null,null,null];
(statearr_15977[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__);

(statearr_15977[(1)] = (1));

return statearr_15977;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1 = (function (state_15966){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_15966);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15978){var ex__2687__auto__ = e15978;
var statearr_15979_15987 = state_15966;
(statearr_15979_15987[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_15966[(4)]))){
var statearr_15980_15988 = state_15966;
(statearr_15980_15988[(1)] = cljs.core.first.call(null,(state_15966[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15989 = state_15966;
state_15966 = G__15989;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__ = function(state_15966){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1.call(this,state_15966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15981 = f__2707__auto__.call(null);
(statearr_15981[(6)] = c__2706__auto__);

return statearr_15981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16021){
var state_val_16022 = (state_16021[(1)]);
if((state_val_16022 === (7))){
var inst_16005 = (state_16021[(7)]);
var inst_16007 = cljs.core.empty_QMARK_.call(null,inst_16005);
var inst_16008 = (!(inst_16007));
var state_16021__$1 = state_16021;
var statearr_16023_16047 = state_16021__$1;
(statearr_16023_16047[(2)] = inst_16008);

(statearr_16023_16047[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16022 === (1))){
var state_16021__$1 = state_16021;
var statearr_16024_16048 = state_16021__$1;
(statearr_16024_16048[(2)] = null);

(statearr_16024_16048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16022 === (4))){
var inst_15991 = (state_16021[(2)]);
var state_16021__$1 = state_16021;
var statearr_16025_16049 = state_16021__$1;
(statearr_16025_16049[(2)] = inst_15991);

(statearr_16025_16049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16022 === (6))){
var inst_16005 = (state_16021[(7)]);
var inst_15997 = (state_16021[(8)]);
var inst_16003 = (state_16021[(2)]);
var inst_16004 = fluree.db.util.async.throw_err.call(null,inst_16003);
var inst_16005__$1 = cljs.core.map.call(null,inst_15997,inst_16004);
var state_16021__$1 = (function (){var statearr_16026 = state_16021;
(statearr_16026[(7)] = inst_16005__$1);

return statearr_16026;
})();
if(cljs.core.truth_(inst_16005__$1)){
var statearr_16027_16050 = state_16021__$1;
(statearr_16027_16050[(1)] = (7));

} else {
var statearr_16028_16051 = state_16021__$1;
(statearr_16028_16051[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16022 === (3))){
var inst_16019 = (state_16021[(2)]);
var state_16021__$1 = state_16021;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16021__$1,inst_16019);
} else {
if((state_val_16022 === (12))){
var inst_16016 = (state_16021[(2)]);
var _ = (function (){var statearr_16029 = state_16021;
(statearr_16029[(4)] = cljs.core.rest.call(null,(state_16021[(4)])));

return statearr_16029;
})();
var state_16021__$1 = state_16021;
var statearr_16030_16052 = state_16021__$1;
(statearr_16030_16052[(2)] = inst_16016);

(statearr_16030_16052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16022 === (2))){
var _ = (function (){var statearr_16031 = state_16021;
(statearr_16031[(4)] = cljs.core.cons.call(null,(5),(state_16021[(4)])));

return statearr_16031;
})();
var inst_15997 = (function (){return (function (p1__15990_SHARP_){
return fluree.db.flake.o.call(null,p1__15990_SHARP_);
});
})();
var inst_15998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15999 = [pred_id];
var inst_16000 = (new cljs.core.PersistentVector(null,1,(5),inst_15998,inst_15999,null));
var inst_16001 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16000);
var state_16021__$1 = (function (){var statearr_16032 = state_16021;
(statearr_16032[(8)] = inst_15997);

return statearr_16032;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16021__$1,(6),inst_16001);
} else {
if((state_val_16022 === (11))){
var state_16021__$1 = state_16021;
var statearr_16034_16053 = state_16021__$1;
(statearr_16034_16053[(2)] = true);

(statearr_16034_16053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16022 === (9))){
var inst_16011 = (state_16021[(2)]);
var state_16021__$1 = state_16021;
if(cljs.core.truth_(inst_16011)){
var statearr_16035_16054 = state_16021__$1;
(statearr_16035_16054[(1)] = (10));

} else {
var statearr_16036_16055 = state_16021__$1;
(statearr_16036_16055[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16022 === (5))){
var _ = (function (){var statearr_16037 = state_16021;
(statearr_16037[(4)] = cljs.core.rest.call(null,(state_16021[(4)])));

return statearr_16037;
})();
var state_16021__$1 = state_16021;
var ex16033 = (state_16021__$1[(2)]);
var statearr_16038_16056 = state_16021__$1;
(statearr_16038_16056[(5)] = ex16033);


if((ex16033 instanceof Error)){
var statearr_16039_16057 = state_16021__$1;
(statearr_16039_16057[(1)] = (4));

(statearr_16039_16057[(5)] = null);

} else {
throw ex16033;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16022 === (10))){
var inst_16005 = (state_16021[(7)]);
var inst_16013 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_16005);
var state_16021__$1 = state_16021;
var statearr_16040_16058 = state_16021__$1;
(statearr_16040_16058[(2)] = inst_16013);

(statearr_16040_16058[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16022 === (8))){
var inst_16005 = (state_16021[(7)]);
var state_16021__$1 = state_16021;
var statearr_16041_16059 = state_16021__$1;
(statearr_16041_16059[(2)] = inst_16005);

(statearr_16041_16059[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_16042 = [null,null,null,null,null,null,null,null,null];
(statearr_16042[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__);

(statearr_16042[(1)] = (1));

return statearr_16042;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1 = (function (state_16021){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_16021);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16043){var ex__2687__auto__ = e16043;
var statearr_16044_16060 = state_16021;
(statearr_16044_16060[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_16021[(4)]))){
var statearr_16045_16061 = state_16021;
(statearr_16045_16061[(1)] = cljs.core.first.call(null,(state_16021[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16062 = state_16021;
state_16021 = G__16062;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__ = function(state_16021){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1.call(this,state_16021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16046 = f__2707__auto__.call(null);
(statearr_16046[(6)] = c__2706__auto__);

return statearr_16046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16143){
var state_val_16144 = (state_16143[(1)]);
if((state_val_16144 === (7))){
var state_16143__$1 = state_16143;
var statearr_16145_16182 = state_16143__$1;
(statearr_16145_16182[(2)] = flakes);

(statearr_16145_16182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (20))){
var inst_16100 = (state_16143[(7)]);
var inst_16133 = (state_16143[(2)]);
var inst_16092 = inst_16100;
var inst_16093 = inst_16133;
var state_16143__$1 = (function (){var statearr_16146 = state_16143;
(statearr_16146[(8)] = inst_16092);

(statearr_16146[(9)] = inst_16093);

return statearr_16146;
})();
var statearr_16147_16183 = state_16143__$1;
(statearr_16147_16183[(2)] = null);

(statearr_16147_16183[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (1))){
var state_16143__$1 = state_16143;
var statearr_16148_16184 = state_16143__$1;
(statearr_16148_16184[(2)] = null);

(statearr_16148_16184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (4))){
var inst_16065 = (state_16143[(2)]);
var state_16143__$1 = state_16143;
var statearr_16149_16185 = state_16143__$1;
(statearr_16149_16185[(2)] = inst_16065);

(statearr_16149_16185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (15))){
var inst_16099 = (state_16143[(10)]);
var inst_16117 = fluree.db.flake.o.call(null,inst_16099);
var state_16143__$1 = state_16143;
var statearr_16150_16186 = state_16143__$1;
(statearr_16150_16186[(2)] = inst_16117);

(statearr_16150_16186[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (13))){
var inst_16136 = (state_16143[(2)]);
var state_16143__$1 = state_16143;
var statearr_16151_16187 = state_16143__$1;
(statearr_16151_16187[(2)] = inst_16136);

(statearr_16151_16187[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (6))){
var inst_16072 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16143__$1 = state_16143;
var statearr_16152_16188 = state_16143__$1;
(statearr_16152_16188[(2)] = inst_16072);

(statearr_16152_16188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (17))){
var inst_16114 = (state_16143[(2)]);
var inst_16115 = fluree.db.util.async.throw_err.call(null,inst_16114);
var state_16143__$1 = state_16143;
var statearr_16153_16189 = state_16143__$1;
(statearr_16153_16189[(2)] = inst_16115);

(statearr_16153_16189[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (3))){
var inst_16141 = (state_16143[(2)]);
var state_16143__$1 = state_16143;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16143__$1,inst_16141);
} else {
if((state_val_16144 === (12))){
var inst_16106 = (state_16143[(11)]);
var inst_16099 = (state_16143[(10)]);
var inst_16104 = fluree.db.flake.p.call(null,inst_16099);
var inst_16105 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16104);
var inst_16106__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_16105);
var inst_16107 = fluree.db.flake.op.call(null,inst_16099);
var inst_16108 = inst_16107 === false;
var inst_16109 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_16106__$1);
var state_16143__$1 = (function (){var statearr_16154 = state_16143;
(statearr_16154[(11)] = inst_16106__$1);

(statearr_16154[(12)] = inst_16108);

return statearr_16154;
})();
if(inst_16109){
var statearr_16155_16190 = state_16143__$1;
(statearr_16155_16190[(1)] = (14));

} else {
var statearr_16156_16191 = state_16143__$1;
(statearr_16156_16191[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (2))){
var _ = (function (){var statearr_16157 = state_16143;
(statearr_16157[(4)] = cljs.core.cons.call(null,(5),(state_16143[(4)])));

return statearr_16157;
})();
var state_16143__$1 = state_16143;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16158_16192 = state_16143__$1;
(statearr_16158_16192[(1)] = (6));

} else {
var statearr_16159_16193 = state_16143__$1;
(statearr_16159_16193[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (19))){
var inst_16093 = (state_16143[(9)]);
var inst_16106 = (state_16143[(11)]);
var inst_16119 = (state_16143[(13)]);
var inst_16099 = (state_16143[(10)]);
var inst_16127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16128 = fluree.db.flake.s.call(null,inst_16099);
var inst_16129 = [inst_16128,inst_16106,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16130 = (new cljs.core.PersistentVector(null,3,(5),inst_16127,inst_16129,null));
var inst_16131 = cljs.core.assoc_in.call(null,inst_16093,inst_16130,inst_16119);
var state_16143__$1 = state_16143;
var statearr_16160_16194 = state_16143__$1;
(statearr_16160_16194[(2)] = inst_16131);

(statearr_16160_16194[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (11))){
var inst_16093 = (state_16143[(9)]);
var state_16143__$1 = state_16143;
var statearr_16162_16195 = state_16143__$1;
(statearr_16162_16195[(2)] = inst_16093);

(statearr_16162_16195[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (9))){
var inst_16092 = (state_16143[(8)]);
var inst_16099 = (state_16143[(10)]);
var inst_16098 = cljs.core.seq.call(null,inst_16092);
var inst_16099__$1 = cljs.core.first.call(null,inst_16098);
var inst_16100 = cljs.core.next.call(null,inst_16098);
var inst_16101 = cljs.core.not.call(null,inst_16099__$1);
var state_16143__$1 = (function (){var statearr_16163 = state_16143;
(statearr_16163[(10)] = inst_16099__$1);

(statearr_16163[(7)] = inst_16100);

return statearr_16163;
})();
if(inst_16101){
var statearr_16164_16196 = state_16143__$1;
(statearr_16164_16196[(1)] = (11));

} else {
var statearr_16165_16197 = state_16143__$1;
(statearr_16165_16197[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (5))){
var _ = (function (){var statearr_16166 = state_16143;
(statearr_16166[(4)] = cljs.core.rest.call(null,(state_16143[(4)])));

return statearr_16166;
})();
var state_16143__$1 = state_16143;
var ex16161 = (state_16143__$1[(2)]);
var statearr_16167_16198 = state_16143__$1;
(statearr_16167_16198[(5)] = ex16161);


if((ex16161 instanceof Error)){
var statearr_16168_16199 = state_16143__$1;
(statearr_16168_16199[(1)] = (4));

(statearr_16168_16199[(5)] = null);

} else {
throw ex16161;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (14))){
var inst_16099 = (state_16143[(10)]);
var inst_16111 = fluree.db.flake.o.call(null,inst_16099);
var inst_16112 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_16111,db);
var state_16143__$1 = state_16143;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16143__$1,(17),inst_16112);
} else {
if((state_val_16144 === (16))){
var inst_16108 = (state_16143[(12)]);
var inst_16119 = (state_16143[(2)]);
var state_16143__$1 = (function (){var statearr_16169 = state_16143;
(statearr_16169[(13)] = inst_16119);

return statearr_16169;
})();
if(cljs.core.truth_(inst_16108)){
var statearr_16170_16200 = state_16143__$1;
(statearr_16170_16200[(1)] = (18));

} else {
var statearr_16171_16201 = state_16143__$1;
(statearr_16171_16201[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (10))){
var inst_16138 = (state_16143[(2)]);
var _ = (function (){var statearr_16172 = state_16143;
(statearr_16172[(4)] = cljs.core.rest.call(null,(state_16143[(4)])));

return statearr_16172;
})();
var state_16143__$1 = state_16143;
var statearr_16173_16202 = state_16143__$1;
(statearr_16173_16202[(2)] = inst_16138);

(statearr_16173_16202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (18))){
var inst_16093 = (state_16143[(9)]);
var inst_16106 = (state_16143[(11)]);
var inst_16119 = (state_16143[(13)]);
var inst_16099 = (state_16143[(10)]);
var inst_16121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16122 = fluree.db.flake.s.call(null,inst_16099);
var inst_16123 = [inst_16122,inst_16106,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16124 = (new cljs.core.PersistentVector(null,3,(5),inst_16121,inst_16123,null));
var inst_16125 = cljs.core.assoc_in.call(null,inst_16093,inst_16124,inst_16119);
var state_16143__$1 = state_16143;
var statearr_16174_16203 = state_16143__$1;
(statearr_16174_16203[(2)] = inst_16125);

(statearr_16174_16203[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16144 === (8))){
var inst_16075 = (state_16143[(2)]);
var inst_16076 = cljs.core.PersistentHashSet.EMPTY;
var inst_16077 = cljs.core.vals.call(null,tempids);
var inst_16078 = cljs.core.into.call(null,inst_16076,inst_16077);
var inst_16079 = (function (){var pred_flakes = inst_16075;
var is_new_QMARK_ = inst_16078;
return (function (p1__16064_SHARP_,p2__16063_SHARP_){
var f = p2__16063_SHARP_;
return cljs.core.assoc_in.call(null,p1__16064_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s.call(null,f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,fluree.db.flake.s.call(null,f))));
});
})();
var inst_16080 = cljs.core.PersistentHashMap.EMPTY;
var inst_16081 = cljs.core.reduce.call(null,inst_16079,inst_16080,inst_16075);
var inst_16089 = cljs.core.seq.call(null,inst_16075);
var inst_16090 = cljs.core.first.call(null,inst_16089);
var inst_16091 = cljs.core.next.call(null,inst_16089);
var inst_16092 = inst_16075;
var inst_16093 = inst_16081;
var state_16143__$1 = (function (){var statearr_16175 = state_16143;
(statearr_16175[(8)] = inst_16092);

(statearr_16175[(9)] = inst_16093);

(statearr_16175[(14)] = inst_16091);

(statearr_16175[(15)] = inst_16090);

return statearr_16175;
})();
var statearr_16176_16204 = state_16143__$1;
(statearr_16176_16204[(2)] = null);

(statearr_16176_16204[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0 = (function (){
var statearr_16177 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16177[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__);

(statearr_16177[(1)] = (1));

return statearr_16177;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1 = (function (state_16143){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_16143);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16178){var ex__2687__auto__ = e16178;
var statearr_16179_16205 = state_16143;
(statearr_16179_16205[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_16143[(4)]))){
var statearr_16180_16206 = state_16143;
(statearr_16180_16206[(1)] = cljs.core.first.call(null,(state_16143[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16207 = state_16143;
state_16143 = G__16207;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__ = function(state_16143){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1.call(this,state_16143);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16181 = f__2707__auto__.call(null);
(statearr_16181[(6)] = c__2706__auto__);

return statearr_16181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16209 = arguments.length;
switch (G__16209) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16212 = arguments.length;
switch (G__16212) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16524){
var state_val_16525 = (state_16524[(1)]);
if((state_val_16525 === (121))){
var inst_16479 = (state_16524[(7)]);
var state_16524__$1 = state_16524;
var statearr_16526_16719 = state_16524__$1;
(statearr_16526_16719[(2)] = inst_16479);

(statearr_16526_16719[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (65))){
var inst_16378 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16378)){
var statearr_16527_16720 = state_16524__$1;
(statearr_16527_16720[(1)] = (66));

} else {
var statearr_16528_16721 = state_16524__$1;
(statearr_16528_16721[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (70))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16388 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16389 = inst_16384.call(null,cljs.core.PersistentArrayMap,null,3,inst_16388,null);
var inst_16390 = inst_16384.call(null,cljs.core.PersistentHashSet,null,inst_16389,null);
var inst_16391 = inst_16390.call(null,inst_16383);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16391)){
var statearr_16529_16722 = state_16524__$1;
(statearr_16529_16722[(1)] = (72));

} else {
var statearr_16530_16723 = state_16524__$1;
(statearr_16530_16723[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (62))){
var inst_16368 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16531_16724 = state_16524__$1;
(statearr_16531_16724[(2)] = inst_16368);

(statearr_16531_16724[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (74))){
var inst_16474 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16532_16725 = state_16524__$1;
(statearr_16532_16725[(2)] = inst_16474);

(statearr_16532_16725[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (110))){
var inst_16501 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16501)){
var statearr_16533_16726 = state_16524__$1;
(statearr_16533_16726[(1)] = (117));

} else {
var statearr_16534_16727 = state_16524__$1;
(statearr_16534_16727[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (7))){
var inst_16519 = (state_16524[(2)]);
var _ = (function (){var statearr_16535 = state_16524;
(statearr_16535[(4)] = cljs.core.rest.call(null,(state_16524[(4)])));

return statearr_16535;
})();
var state_16524__$1 = state_16524;
var statearr_16536_16728 = state_16524__$1;
(statearr_16536_16728[(2)] = inst_16519);

(statearr_16536_16728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (59))){
var inst_16372 = (state_16524[(10)]);
var inst_16252 = (state_16524[(11)]);
var inst_16371 = (state_16524[(2)]);
var inst_16372__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16252);
var state_16524__$1 = (function (){var statearr_16537 = state_16524;
(statearr_16537[(10)] = inst_16372__$1);

(statearr_16537[(12)] = inst_16371);

return statearr_16537;
})();
if(cljs.core.truth_(inst_16372__$1)){
var statearr_16538_16729 = state_16524__$1;
(statearr_16538_16729[(1)] = (63));

} else {
var statearr_16539_16730 = state_16524__$1;
(statearr_16539_16730[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (86))){
var inst_16414 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16540_16731 = state_16524__$1;
(statearr_16540_16731[(2)] = inst_16414);

(statearr_16540_16731[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (20))){
var inst_16252 = (state_16524[(11)]);
var inst_16278 = (state_16524[(13)]);
var inst_16278__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16252);
var state_16524__$1 = (function (){var statearr_16541 = state_16524;
(statearr_16541[(13)] = inst_16278__$1);

return statearr_16541;
})();
if(cljs.core.truth_(inst_16278__$1)){
var statearr_16542_16732 = state_16524__$1;
(statearr_16542_16732[(1)] = (23));

} else {
var statearr_16543_16733 = state_16524__$1;
(statearr_16543_16733[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (72))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16393 = fluree.db.query.schema.type_error.call(null,inst_16383,inst_16384,throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16544_16734 = state_16524__$1;
(statearr_16544_16734[(2)] = inst_16393);

(statearr_16544_16734[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (58))){
var inst_16333 = (state_16524[(14)]);
var state_16524__$1 = state_16524;
var statearr_16545_16735 = state_16524__$1;
(statearr_16545_16735[(2)] = inst_16333);

(statearr_16545_16735[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (60))){
var inst_16240 = (state_16524[(15)]);
var inst_16251 = (state_16524[(16)]);
var inst_16359 = fluree.db.dbproto._p_prop.call(null,inst_16240,new cljs.core.Keyword(null,"name","name",1843675177),inst_16251);
var inst_16360 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16359)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16361 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16362 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16363 = cljs.core.PersistentHashMap.fromArrays(inst_16361,inst_16362);
var inst_16364 = cljs.core.ex_info.call(null,inst_16360,inst_16363);
var inst_16365 = (function(){throw inst_16364})();
var state_16524__$1 = state_16524;
var statearr_16546_16736 = state_16524__$1;
(statearr_16546_16736[(2)] = inst_16365);

(statearr_16546_16736[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (27))){
var inst_16281 = (state_16524[(17)]);
var state_16524__$1 = state_16524;
var statearr_16547_16737 = state_16524__$1;
(statearr_16547_16737[(2)] = inst_16281);

(statearr_16547_16737[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (1))){
var state_16524__$1 = state_16524;
var statearr_16548_16738 = state_16524__$1;
(statearr_16548_16738[(2)] = null);

(statearr_16548_16738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (69))){
var inst_16371 = (state_16524[(12)]);
var state_16524__$1 = state_16524;
var statearr_16549_16739 = state_16524__$1;
(statearr_16549_16739[(2)] = inst_16371);

(statearr_16549_16739[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (101))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16452 = fluree.db.query.schema.type_error.call(null,inst_16383,inst_16384,throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16550_16740 = state_16524__$1;
(statearr_16550_16740[(2)] = inst_16452);

(statearr_16550_16740[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (24))){
var inst_16278 = (state_16524[(13)]);
var state_16524__$1 = state_16524;
var statearr_16551_16741 = state_16524__$1;
(statearr_16551_16741[(2)] = inst_16278);

(statearr_16551_16741[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (102))){
var inst_16454 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16552_16742 = state_16524__$1;
(statearr_16552_16742[(2)] = inst_16454);

(statearr_16552_16742[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (55))){
var inst_16350 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16553_16743 = state_16524__$1;
(statearr_16553_16743[(2)] = inst_16350);

(statearr_16553_16743[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (85))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16412 = fluree.db.query.schema.type_error.call(null,inst_16383,inst_16384,throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16554_16744 = state_16524__$1;
(statearr_16554_16744[(2)] = inst_16412);

(statearr_16554_16744[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (39))){
var inst_16315 = (state_16524[(18)]);
var state_16524__$1 = state_16524;
var statearr_16555_16745 = state_16524__$1;
(statearr_16555_16745[(2)] = inst_16315);

(statearr_16555_16745[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (88))){
var inst_16371 = (state_16524[(12)]);
var state_16524__$1 = state_16524;
var statearr_16556_16746 = state_16524__$1;
(statearr_16556_16746[(2)] = inst_16371);

(statearr_16556_16746[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (46))){
var inst_16334 = (state_16524[(19)]);
var inst_16252 = (state_16524[(11)]);
var inst_16333 = (state_16524[(2)]);
var inst_16334__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16252);
var state_16524__$1 = (function (){var statearr_16557 = state_16524;
(statearr_16557[(14)] = inst_16333);

(statearr_16557[(19)] = inst_16334__$1);

return statearr_16557;
})();
if(cljs.core.truth_(inst_16334__$1)){
var statearr_16558_16747 = state_16524__$1;
(statearr_16558_16747[(1)] = (47));

} else {
var statearr_16559_16748 = state_16524__$1;
(statearr_16559_16748[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (4))){
var inst_16213 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16560_16749 = state_16524__$1;
(statearr_16560_16749[(2)] = inst_16213);

(statearr_16560_16749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (77))){
var inst_16472 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16561_16750 = state_16524__$1;
(statearr_16561_16750[(2)] = inst_16472);

(statearr_16561_16750[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (106))){
var inst_16464 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16562_16751 = state_16524__$1;
(statearr_16562_16751[(2)] = inst_16464);

(statearr_16562_16751[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (119))){
var inst_16250 = (state_16524[(20)]);
var inst_16514 = (state_16524[(2)]);
var inst_16239 = inst_16250;
var inst_16240 = inst_16514;
var state_16524__$1 = (function (){var statearr_16563 = state_16524;
(statearr_16563[(15)] = inst_16240);

(statearr_16563[(21)] = inst_16239);

return statearr_16563;
})();
var statearr_16564_16752 = state_16524__$1;
(statearr_16564_16752[(2)] = null);

(statearr_16564_16752[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (95))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16436 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16437 = inst_16384.call(null,cljs.core.PersistentArrayMap,null,5,inst_16436,null);
var inst_16438 = inst_16384.call(null,cljs.core.PersistentHashSet,null,inst_16437,null);
var inst_16439 = inst_16438.call(null,inst_16383);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16439)){
var statearr_16565_16753 = state_16524__$1;
(statearr_16565_16753[(1)] = (96));

} else {
var statearr_16566_16754 = state_16524__$1;
(statearr_16566_16754[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (54))){
var inst_16341 = (state_16524[(22)]);
var state_16524__$1 = state_16524;
var statearr_16567_16755 = state_16524__$1;
(statearr_16567_16755[(2)] = inst_16341);

(statearr_16567_16755[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (92))){
var inst_16371 = (state_16524[(12)]);
var state_16524__$1 = state_16524;
var statearr_16568_16756 = state_16524__$1;
(statearr_16568_16756[(2)] = inst_16371);

(statearr_16568_16756[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (104))){
var inst_16371 = (state_16524[(12)]);
var state_16524__$1 = state_16524;
var statearr_16569_16757 = state_16524__$1;
(statearr_16569_16757[(2)] = inst_16371);

(statearr_16569_16757[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (15))){
var inst_16260 = (state_16524[(23)]);
var state_16524__$1 = state_16524;
var statearr_16570_16758 = state_16524__$1;
(statearr_16570_16758[(2)] = inst_16260);

(statearr_16570_16758[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (48))){
var inst_16334 = (state_16524[(19)]);
var state_16524__$1 = state_16524;
var statearr_16571_16759 = state_16524__$1;
(statearr_16571_16759[(2)] = inst_16334);

(statearr_16571_16759[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (50))){
var inst_16341 = (state_16524[(22)]);
var inst_16252 = (state_16524[(11)]);
var inst_16339 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16340 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16341__$1 = inst_16340 === true;
var state_16524__$1 = (function (){var statearr_16572 = state_16524;
(statearr_16572[(22)] = inst_16341__$1);

return statearr_16572;
})();
if(cljs.core.truth_(inst_16341__$1)){
var statearr_16573_16760 = state_16524__$1;
(statearr_16573_16760[(1)] = (53));

} else {
var statearr_16574_16761 = state_16524__$1;
(statearr_16574_16761[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (116))){
var inst_16495 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16575_16762 = state_16524__$1;
(statearr_16575_16762[(2)] = inst_16495);

(statearr_16575_16762[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (75))){
var inst_16384 = (state_16524[(9)]);
var state_16524__$1 = state_16524;
var G__16576_16763 = inst_16384;
var G__16576_16764__$1 = (((G__16576_16763 instanceof cljs.core.Keyword))?G__16576_16763.fqn:null);
switch (G__16576_16764__$1) {
case "long":
var statearr_16577_16766 = state_16524__$1;
(statearr_16577_16766[(1)] = (79));


break;
case "bigint":
var statearr_16578_16767 = state_16524__$1;
(statearr_16578_16767[(1)] = (83));


break;
case "double":
var statearr_16579_16768 = state_16524__$1;
(statearr_16579_16768[(1)] = (87));


break;
case "float":
var statearr_16580_16769 = state_16524__$1;
(statearr_16580_16769[(1)] = (91));


break;
case "bigdec":
var statearr_16581_16770 = state_16524__$1;
(statearr_16581_16770[(1)] = (95));


break;
case "string":
var statearr_16582_16771 = state_16524__$1;
(statearr_16582_16771[(1)] = (99));


break;
case "instant":
var statearr_16583_16772 = state_16524__$1;
(statearr_16583_16772[(1)] = (103));


break;
default:
var statearr_16584_16773 = state_16524__$1;
(statearr_16584_16773[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (99))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16446 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16447 = inst_16384.call(null,cljs.core.PersistentArrayMap,null,5,inst_16446,null);
var inst_16448 = inst_16384.call(null,cljs.core.PersistentHashSet,null,inst_16447,null);
var inst_16449 = inst_16448.call(null,inst_16383);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16449)){
var statearr_16585_16774 = state_16524__$1;
(statearr_16585_16774[(1)] = (100));

} else {
var statearr_16586_16775 = state_16524__$1;
(statearr_16586_16775[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (21))){
var inst_16276 = (state_16524[(24)]);
var state_16524__$1 = state_16524;
var statearr_16587_16776 = state_16524__$1;
(statearr_16587_16776[(2)] = inst_16276);

(statearr_16587_16776[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (31))){
var inst_16292 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16588_16777 = state_16524__$1;
(statearr_16588_16777[(2)] = inst_16292);

(statearr_16588_16777[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (113))){
var inst_16498 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16589_16778 = state_16524__$1;
(statearr_16589_16778[(2)] = inst_16498);

(statearr_16589_16778[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (32))){
var state_16524__$1 = state_16524;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16590_16779 = state_16524__$1;
(statearr_16590_16779[(1)] = (35));

} else {
var statearr_16591_16780 = state_16524__$1;
(statearr_16591_16780[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (40))){
var inst_16328 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16328)){
var statearr_16592_16781 = state_16524__$1;
(statearr_16592_16781[(1)] = (44));

} else {
var statearr_16593_16782 = state_16524__$1;
(statearr_16593_16782[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (91))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16426 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16427 = inst_16384.call(null,cljs.core.PersistentArrayMap,null,3,inst_16426,null);
var inst_16428 = inst_16384.call(null,cljs.core.PersistentHashSet,null,inst_16427,null);
var inst_16429 = inst_16428.call(null,inst_16383);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16429)){
var statearr_16594_16783 = state_16524__$1;
(statearr_16594_16783[(1)] = (92));

} else {
var statearr_16595_16784 = state_16524__$1;
(statearr_16595_16784[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (117))){
var state_16524__$1 = state_16524;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16596_16785 = state_16524__$1;
(statearr_16596_16785[(1)] = (120));

} else {
var statearr_16597_16786 = state_16524__$1;
(statearr_16597_16786[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (108))){
var inst_16252 = (state_16524[(11)]);
var inst_16483 = (state_16524[(25)]);
var inst_16483__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16252);
var state_16524__$1 = (function (){var statearr_16598 = state_16524;
(statearr_16598[(25)] = inst_16483__$1);

return statearr_16598;
})();
if(cljs.core.truth_(inst_16483__$1)){
var statearr_16599_16787 = state_16524__$1;
(statearr_16599_16787[(1)] = (111));

} else {
var statearr_16600_16788 = state_16524__$1;
(statearr_16600_16788[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (56))){
var inst_16345 = (state_16524[(2)]);
var inst_16346 = fluree.db.util.async.throw_err.call(null,inst_16345);
var inst_16347 = cljs.core.not.call(null,inst_16346);
var state_16524__$1 = state_16524;
var statearr_16601_16789 = state_16524__$1;
(statearr_16601_16789[(2)] = inst_16347);

(statearr_16601_16789[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (33))){
var inst_16275 = (state_16524[(26)]);
var state_16524__$1 = state_16524;
var statearr_16602_16790 = state_16524__$1;
(statearr_16602_16790[(2)] = inst_16275);

(statearr_16602_16790[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (13))){
var inst_16270 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16270)){
var statearr_16603_16791 = state_16524__$1;
(statearr_16603_16791[(1)] = (17));

} else {
var statearr_16604_16792 = state_16524__$1;
(statearr_16604_16792[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (22))){
var inst_16301 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16301)){
var statearr_16605_16793 = state_16524__$1;
(statearr_16605_16793[(1)] = (32));

} else {
var statearr_16606_16794 = state_16524__$1;
(statearr_16606_16794[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (90))){
var inst_16424 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16607_16795 = state_16524__$1;
(statearr_16607_16795[(2)] = inst_16424);

(statearr_16607_16795[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (109))){
var inst_16481 = (state_16524[(27)]);
var state_16524__$1 = state_16524;
var statearr_16608_16796 = state_16524__$1;
(statearr_16608_16796[(2)] = inst_16481);

(statearr_16608_16796[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (36))){
var inst_16275 = (state_16524[(26)]);
var state_16524__$1 = state_16524;
var statearr_16609_16797 = state_16524__$1;
(statearr_16609_16797[(2)] = inst_16275);

(statearr_16609_16797[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (41))){
var inst_16252 = (state_16524[(11)]);
var inst_16320 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16321 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16320);
var inst_16322 = inst_16321 === true;
var state_16524__$1 = state_16524;
var statearr_16610_16798 = state_16524__$1;
(statearr_16610_16798[(2)] = inst_16322);

(statearr_16610_16798[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (118))){
var inst_16479 = (state_16524[(7)]);
var state_16524__$1 = state_16524;
var statearr_16611_16799 = state_16524__$1;
(statearr_16611_16799[(2)] = inst_16479);

(statearr_16611_16799[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (89))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16422 = fluree.db.query.schema.type_error.call(null,inst_16383,inst_16384,throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16612_16800 = state_16524__$1;
(statearr_16612_16800[(2)] = inst_16422);

(statearr_16612_16800[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (100))){
var inst_16371 = (state_16524[(12)]);
var state_16524__$1 = state_16524;
var statearr_16613_16801 = state_16524__$1;
(statearr_16613_16801[(2)] = inst_16371);

(statearr_16613_16801[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (122))){
var inst_16511 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16614_16802 = state_16524__$1;
(statearr_16614_16802[(2)] = inst_16511);

(statearr_16614_16802[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (43))){
var inst_16325 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16615_16803 = state_16524__$1;
(statearr_16615_16803[(2)] = inst_16325);

(statearr_16615_16803[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (61))){
var inst_16333 = (state_16524[(14)]);
var state_16524__$1 = state_16524;
var statearr_16616_16804 = state_16524__$1;
(statearr_16616_16804[(2)] = inst_16333);

(statearr_16616_16804[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (29))){
var inst_16252 = (state_16524[(11)]);
var inst_16287 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16288 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16287);
var inst_16289 = inst_16288 === true;
var state_16524__$1 = state_16524;
var statearr_16617_16805 = state_16524__$1;
(statearr_16617_16805[(2)] = inst_16289);

(statearr_16617_16805[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (44))){
var inst_16314 = (state_16524[(28)]);
var inst_16330 = fluree.db.query.schema.type_error.call(null,inst_16314,"a component","a non-component",throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16618_16806 = state_16524__$1;
(statearr_16618_16806[(2)] = inst_16330);

(statearr_16618_16806[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (93))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16432 = fluree.db.query.schema.type_error.call(null,inst_16383,inst_16384,throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16619_16807 = state_16524__$1;
(statearr_16619_16807[(2)] = inst_16432);

(statearr_16619_16807[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (6))){
var inst_16239 = (state_16524[(21)]);
var inst_16251 = (state_16524[(16)]);
var inst_16248 = cljs.core.seq.call(null,inst_16239);
var inst_16249 = cljs.core.first.call(null,inst_16248);
var inst_16250 = cljs.core.next.call(null,inst_16248);
var inst_16251__$1 = cljs.core.nth.call(null,inst_16249,(0),null);
var inst_16252 = cljs.core.nth.call(null,inst_16249,(1),null);
var inst_16253 = cljs.core.not.call(null,inst_16251__$1);
var state_16524__$1 = (function (){var statearr_16620 = state_16524;
(statearr_16620[(11)] = inst_16252);

(statearr_16620[(16)] = inst_16251__$1);

(statearr_16620[(20)] = inst_16250);

return statearr_16620;
})();
if(inst_16253){
var statearr_16621_16808 = state_16524__$1;
(statearr_16621_16808[(1)] = (8));

} else {
var statearr_16622_16809 = state_16524__$1;
(statearr_16622_16809[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (111))){
var inst_16252 = (state_16524[(11)]);
var inst_16487 = (state_16524[(29)]);
var inst_16485 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16486 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16485);
var inst_16487__$1 = inst_16486 === true;
var state_16524__$1 = (function (){var statearr_16623 = state_16524;
(statearr_16623[(29)] = inst_16487__$1);

return statearr_16623;
})();
if(cljs.core.truth_(inst_16487__$1)){
var statearr_16624_16810 = state_16524__$1;
(statearr_16624_16810[(1)] = (114));

} else {
var statearr_16625_16811 = state_16524__$1;
(statearr_16625_16811[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (28))){
var inst_16295 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16626_16812 = state_16524__$1;
(statearr_16626_16812[(2)] = inst_16295);

(statearr_16626_16812[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (64))){
var inst_16372 = (state_16524[(10)]);
var state_16524__$1 = state_16524;
var statearr_16627_16813 = state_16524__$1;
(statearr_16627_16813[(2)] = inst_16372);

(statearr_16627_16813[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (103))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16456 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16457 = inst_16384.call(null,cljs.core.PersistentArrayMap,null,2,inst_16456,null);
var inst_16458 = inst_16384.call(null,cljs.core.PersistentHashSet,null,inst_16457,null);
var inst_16459 = inst_16458.call(null,inst_16383);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16459)){
var statearr_16628_16814 = state_16524__$1;
(statearr_16628_16814[(1)] = (104));

} else {
var statearr_16629_16815 = state_16524__$1;
(statearr_16629_16815[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (51))){
var inst_16337 = (state_16524[(30)]);
var state_16524__$1 = state_16524;
var statearr_16630_16816 = state_16524__$1;
(statearr_16630_16816[(2)] = inst_16337);

(statearr_16630_16816[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (25))){
var inst_16298 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16631_16817 = state_16524__$1;
(statearr_16631_16817[(2)] = inst_16298);

(statearr_16631_16817[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (34))){
var inst_16315 = (state_16524[(18)]);
var inst_16252 = (state_16524[(11)]);
var inst_16314 = (state_16524[(2)]);
var inst_16315__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16252);
var state_16524__$1 = (function (){var statearr_16632 = state_16524;
(statearr_16632[(18)] = inst_16315__$1);

(statearr_16632[(28)] = inst_16314);

return statearr_16632;
})();
if(cljs.core.truth_(inst_16315__$1)){
var statearr_16633_16818 = state_16524__$1;
(statearr_16633_16818[(1)] = (38));

} else {
var statearr_16634_16819 = state_16524__$1;
(statearr_16634_16819[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (17))){
var inst_16240 = (state_16524[(15)]);
var inst_16272 = fluree.db.query.schema.type_error.call(null,inst_16240,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16635_16820 = state_16524__$1;
(statearr_16635_16820[(2)] = inst_16272);

(statearr_16635_16820[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (3))){
var inst_16522 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16524__$1,inst_16522);
} else {
if((state_val_16525 === (12))){
var inst_16256 = (state_16524[(31)]);
var state_16524__$1 = state_16524;
var statearr_16636_16821 = state_16524__$1;
(statearr_16636_16821[(2)] = inst_16256);

(statearr_16636_16821[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (2))){
var _ = (function (){var statearr_16637 = state_16524;
(statearr_16637[(4)] = cljs.core.cons.call(null,(5),(state_16524[(4)])));

return statearr_16637;
})();
var inst_16232 = pred_changes;
var inst_16233 = cljs.core.seq.call(null,inst_16232);
var inst_16234 = cljs.core.first.call(null,inst_16233);
var inst_16235 = cljs.core.next.call(null,inst_16233);
var inst_16236 = cljs.core.nth.call(null,inst_16234,(0),null);
var inst_16237 = cljs.core.nth.call(null,inst_16234,(1),null);
var inst_16238 = db;
var inst_16239 = inst_16232;
var inst_16240 = inst_16238;
var state_16524__$1 = (function (){var statearr_16638 = state_16524;
(statearr_16638[(15)] = inst_16240);

(statearr_16638[(21)] = inst_16239);

(statearr_16638[(32)] = inst_16237);

(statearr_16638[(33)] = inst_16235);

(statearr_16638[(34)] = inst_16236);

return statearr_16638;
})();
var statearr_16639_16822 = state_16524__$1;
(statearr_16639_16822[(2)] = null);

(statearr_16639_16822[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (66))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16252 = (state_16524[(11)]);
var inst_16381 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16382 = cljs.core.__destructure_map.call(null,inst_16381);
var inst_16383__$1 = cljs.core.get.call(null,inst_16382,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16384__$1 = cljs.core.get.call(null,inst_16382,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16385 = cljs.core._EQ_.call(null,inst_16384__$1,inst_16383__$1);
var state_16524__$1 = (function (){var statearr_16640 = state_16524;
(statearr_16640[(8)] = inst_16383__$1);

(statearr_16640[(9)] = inst_16384__$1);

return statearr_16640;
})();
if(inst_16385){
var statearr_16641_16823 = state_16524__$1;
(statearr_16641_16823[(1)] = (69));

} else {
var statearr_16642_16824 = state_16524__$1;
(statearr_16642_16824[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (107))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16466 = fluree.db.query.schema.type_error.call(null,inst_16383,inst_16384,throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16643_16825 = state_16524__$1;
(statearr_16643_16825[(2)] = inst_16466);

(statearr_16643_16825[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (23))){
var inst_16281 = (state_16524[(17)]);
var inst_16252 = (state_16524[(11)]);
var inst_16280 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16281__$1 = inst_16280 === true;
var state_16524__$1 = (function (){var statearr_16644 = state_16524;
(statearr_16644[(17)] = inst_16281__$1);

return statearr_16644;
})();
if(cljs.core.truth_(inst_16281__$1)){
var statearr_16645_16826 = state_16524__$1;
(statearr_16645_16826[(1)] = (26));

} else {
var statearr_16646_16827 = state_16524__$1;
(statearr_16646_16827[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (47))){
var inst_16337 = (state_16524[(30)]);
var inst_16252 = (state_16524[(11)]);
var inst_16336 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16337__$1 = cljs.core.not.call(null,inst_16336);
var state_16524__$1 = (function (){var statearr_16647 = state_16524;
(statearr_16647[(30)] = inst_16337__$1);

return statearr_16647;
})();
if(inst_16337__$1){
var statearr_16648_16828 = state_16524__$1;
(statearr_16648_16828[(1)] = (50));

} else {
var statearr_16649_16829 = state_16524__$1;
(statearr_16649_16829[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (35))){
var inst_16304 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16305 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16306 = cljs.core.PersistentHashMap.fromArrays(inst_16304,inst_16305);
var inst_16307 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_16306);
var inst_16308 = (function(){throw inst_16307})();
var state_16524__$1 = state_16524;
var statearr_16650_16830 = state_16524__$1;
(statearr_16650_16830[(2)] = inst_16308);

(statearr_16650_16830[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (82))){
var inst_16404 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16651_16831 = state_16524__$1;
(statearr_16651_16831[(2)] = inst_16404);

(statearr_16651_16831[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (76))){
var state_16524__$1 = state_16524;
var statearr_16652_16832 = state_16524__$1;
(statearr_16652_16832[(2)] = null);

(statearr_16652_16832[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (97))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16442 = fluree.db.query.schema.type_error.call(null,inst_16383,inst_16384,throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16653_16833 = state_16524__$1;
(statearr_16653_16833[(2)] = inst_16442);

(statearr_16653_16833[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (19))){
var inst_16276 = (state_16524[(24)]);
var inst_16252 = (state_16524[(11)]);
var inst_16275 = (state_16524[(2)]);
var inst_16276__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16252);
var state_16524__$1 = (function (){var statearr_16654 = state_16524;
(statearr_16654[(24)] = inst_16276__$1);

(statearr_16654[(26)] = inst_16275);

return statearr_16654;
})();
if(cljs.core.truth_(inst_16276__$1)){
var statearr_16655_16834 = state_16524__$1;
(statearr_16655_16834[(1)] = (20));

} else {
var statearr_16656_16835 = state_16524__$1;
(statearr_16656_16835[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (57))){
var state_16524__$1 = state_16524;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16657_16836 = state_16524__$1;
(statearr_16657_16836[(1)] = (60));

} else {
var statearr_16658_16837 = state_16524__$1;
(statearr_16658_16837[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (68))){
var inst_16481 = (state_16524[(27)]);
var inst_16252 = (state_16524[(11)]);
var inst_16479 = (state_16524[(2)]);
var inst_16480 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16481__$1 = inst_16480 === true;
var state_16524__$1 = (function (){var statearr_16659 = state_16524;
(statearr_16659[(27)] = inst_16481__$1);

(statearr_16659[(7)] = inst_16479);

return statearr_16659;
})();
if(cljs.core.truth_(inst_16481__$1)){
var statearr_16660_16838 = state_16524__$1;
(statearr_16660_16838[(1)] = (108));

} else {
var statearr_16661_16839 = state_16524__$1;
(statearr_16661_16839[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (11))){
var inst_16260 = (state_16524[(23)]);
var inst_16252 = (state_16524[(11)]);
var inst_16258 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16259 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16258);
var inst_16260__$1 = inst_16259 === false;
var state_16524__$1 = (function (){var statearr_16662 = state_16524;
(statearr_16662[(23)] = inst_16260__$1);

return statearr_16662;
})();
if(cljs.core.truth_(inst_16260__$1)){
var statearr_16663_16840 = state_16524__$1;
(statearr_16663_16840[(1)] = (14));

} else {
var statearr_16664_16841 = state_16524__$1;
(statearr_16664_16841[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (115))){
var inst_16487 = (state_16524[(29)]);
var state_16524__$1 = state_16524;
var statearr_16666_16842 = state_16524__$1;
(statearr_16666_16842[(2)] = inst_16487);

(statearr_16666_16842[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (9))){
var inst_16252 = (state_16524[(11)]);
var inst_16256 = (state_16524[(31)]);
var inst_16256__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16252);
var state_16524__$1 = (function (){var statearr_16667 = state_16524;
(statearr_16667[(31)] = inst_16256__$1);

return statearr_16667;
})();
if(cljs.core.truth_(inst_16256__$1)){
var statearr_16668_16843 = state_16524__$1;
(statearr_16668_16843[(1)] = (11));

} else {
var statearr_16669_16844 = state_16524__$1;
(statearr_16669_16844[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (5))){
var _ = (function (){var statearr_16670 = state_16524;
(statearr_16670[(4)] = cljs.core.rest.call(null,(state_16524[(4)])));

return statearr_16670;
})();
var state_16524__$1 = state_16524;
var ex16665 = (state_16524__$1[(2)]);
var statearr_16671_16845 = state_16524__$1;
(statearr_16671_16845[(5)] = ex16665);


if((ex16665 instanceof Error)){
var statearr_16672_16846 = state_16524__$1;
(statearr_16672_16846[(1)] = (4));

(statearr_16672_16846[(5)] = null);

} else {
throw ex16665;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (112))){
var inst_16483 = (state_16524[(25)]);
var state_16524__$1 = state_16524;
var statearr_16673_16847 = state_16524__$1;
(statearr_16673_16847[(2)] = inst_16483);

(statearr_16673_16847[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (83))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16406 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16407 = inst_16384.call(null,cljs.core.PersistentArrayMap,null,3,inst_16406,null);
var inst_16408 = inst_16384.call(null,cljs.core.PersistentHashSet,null,inst_16407,null);
var inst_16409 = inst_16408.call(null,inst_16383);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16409)){
var statearr_16674_16848 = state_16524__$1;
(statearr_16674_16848[(1)] = (84));

} else {
var statearr_16675_16849 = state_16524__$1;
(statearr_16675_16849[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (14))){
var inst_16252 = (state_16524[(11)]);
var inst_16262 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16263 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16262);
var inst_16264 = inst_16263 === true;
var state_16524__$1 = state_16524;
var statearr_16676_16850 = state_16524__$1;
(statearr_16676_16850[(2)] = inst_16264);

(statearr_16676_16850[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (45))){
var inst_16314 = (state_16524[(28)]);
var state_16524__$1 = state_16524;
var statearr_16677_16851 = state_16524__$1;
(statearr_16677_16851[(2)] = inst_16314);

(statearr_16677_16851[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (53))){
var inst_16240 = (state_16524[(15)]);
var inst_16251 = (state_16524[(16)]);
var inst_16343 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_16240,inst_16251);
var state_16524__$1 = state_16524;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16524__$1,(56),inst_16343);
} else {
if((state_val_16525 === (78))){
var inst_16469 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16678_16852 = state_16524__$1;
(statearr_16678_16852[(2)] = inst_16469);

(statearr_16678_16852[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (26))){
var inst_16252 = (state_16524[(11)]);
var inst_16285 = (state_16524[(35)]);
var inst_16283 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16284 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16283);
var inst_16285__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16284);
var state_16524__$1 = (function (){var statearr_16679 = state_16524;
(statearr_16679[(35)] = inst_16285__$1);

return statearr_16679;
})();
if(inst_16285__$1){
var statearr_16680_16853 = state_16524__$1;
(statearr_16680_16853[(1)] = (29));

} else {
var statearr_16681_16854 = state_16524__$1;
(statearr_16681_16854[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (16))){
var inst_16267 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16682_16855 = state_16524__$1;
(statearr_16682_16855[(2)] = inst_16267);

(statearr_16682_16855[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (81))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16402 = fluree.db.query.schema.type_error.call(null,inst_16383,inst_16384,throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16683_16856 = state_16524__$1;
(statearr_16683_16856[(2)] = inst_16402);

(statearr_16683_16856[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (120))){
var inst_16504 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16505 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16506 = cljs.core.PersistentHashMap.fromArrays(inst_16504,inst_16505);
var inst_16507 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_16506);
var inst_16508 = (function(){throw inst_16507})();
var state_16524__$1 = state_16524;
var statearr_16684_16857 = state_16524__$1;
(statearr_16684_16857[(2)] = inst_16508);

(statearr_16684_16857[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (79))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16396 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16397 = inst_16384.call(null,cljs.core.PersistentArrayMap,null,2,inst_16396,null);
var inst_16398 = inst_16384.call(null,cljs.core.PersistentHashSet,null,inst_16397,null);
var inst_16399 = inst_16398.call(null,inst_16383);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16399)){
var statearr_16685_16858 = state_16524__$1;
(statearr_16685_16858[(1)] = (80));

} else {
var statearr_16686_16859 = state_16524__$1;
(statearr_16686_16859[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (38))){
var inst_16318 = (state_16524[(36)]);
var inst_16252 = (state_16524[(11)]);
var inst_16317 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16318__$1 = cljs.core.not.call(null,inst_16317);
var state_16524__$1 = (function (){var statearr_16687 = state_16524;
(statearr_16687[(36)] = inst_16318__$1);

return statearr_16687;
})();
if(inst_16318__$1){
var statearr_16688_16860 = state_16524__$1;
(statearr_16688_16860[(1)] = (41));

} else {
var statearr_16689_16861 = state_16524__$1;
(statearr_16689_16861[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (98))){
var inst_16444 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16690_16862 = state_16524__$1;
(statearr_16690_16862[(2)] = inst_16444);

(statearr_16690_16862[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (87))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16416 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16417 = inst_16384.call(null,cljs.core.PersistentArrayMap,null,3,inst_16416,null);
var inst_16418 = inst_16384.call(null,cljs.core.PersistentHashSet,null,inst_16417,null);
var inst_16419 = inst_16418.call(null,inst_16383);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16419)){
var statearr_16691_16863 = state_16524__$1;
(statearr_16691_16863[(1)] = (88));

} else {
var statearr_16692_16864 = state_16524__$1;
(statearr_16692_16864[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (30))){
var inst_16285 = (state_16524[(35)]);
var state_16524__$1 = state_16524;
var statearr_16693_16865 = state_16524__$1;
(statearr_16693_16865[(2)] = inst_16285);

(statearr_16693_16865[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (73))){
var state_16524__$1 = state_16524;
var statearr_16694_16866 = state_16524__$1;
(statearr_16694_16866[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (96))){
var inst_16371 = (state_16524[(12)]);
var state_16524__$1 = state_16524;
var statearr_16696_16867 = state_16524__$1;
(statearr_16696_16867[(2)] = inst_16371);

(statearr_16696_16867[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (10))){
var inst_16517 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16697_16868 = state_16524__$1;
(statearr_16697_16868[(2)] = inst_16517);

(statearr_16697_16868[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (18))){
var inst_16240 = (state_16524[(15)]);
var state_16524__$1 = state_16524;
var statearr_16698_16869 = state_16524__$1;
(statearr_16698_16869[(2)] = inst_16240);

(statearr_16698_16869[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (105))){
var inst_16383 = (state_16524[(8)]);
var inst_16384 = (state_16524[(9)]);
var inst_16462 = fluree.db.query.schema.type_error.call(null,inst_16383,inst_16384,throw_QMARK_);
var state_16524__$1 = state_16524;
var statearr_16699_16870 = state_16524__$1;
(statearr_16699_16870[(2)] = inst_16462);

(statearr_16699_16870[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (52))){
var inst_16353 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16700_16871 = state_16524__$1;
(statearr_16700_16871[(2)] = inst_16353);

(statearr_16700_16871[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (114))){
var inst_16252 = (state_16524[(11)]);
var inst_16489 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16490 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16489);
var inst_16491 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16490);
var inst_16492 = (!(inst_16491));
var state_16524__$1 = state_16524;
var statearr_16701_16872 = state_16524__$1;
(statearr_16701_16872[(2)] = inst_16492);

(statearr_16701_16872[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (67))){
var inst_16371 = (state_16524[(12)]);
var state_16524__$1 = state_16524;
var statearr_16702_16873 = state_16524__$1;
(statearr_16702_16873[(2)] = inst_16371);

(statearr_16702_16873[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (71))){
var inst_16476 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16703_16874 = state_16524__$1;
(statearr_16703_16874[(2)] = inst_16476);

(statearr_16703_16874[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (42))){
var inst_16318 = (state_16524[(36)]);
var state_16524__$1 = state_16524;
var statearr_16704_16875 = state_16524__$1;
(statearr_16704_16875[(2)] = inst_16318);

(statearr_16704_16875[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (80))){
var inst_16371 = (state_16524[(12)]);
var state_16524__$1 = state_16524;
var statearr_16705_16876 = state_16524__$1;
(statearr_16705_16876[(2)] = inst_16371);

(statearr_16705_16876[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (37))){
var inst_16311 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16706_16877 = state_16524__$1;
(statearr_16706_16877[(2)] = inst_16311);

(statearr_16706_16877[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (63))){
var inst_16252 = (state_16524[(11)]);
var inst_16374 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16252);
var inst_16375 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16374);
var state_16524__$1 = state_16524;
var statearr_16707_16878 = state_16524__$1;
(statearr_16707_16878[(2)] = inst_16375);

(statearr_16707_16878[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (94))){
var inst_16434 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16708_16879 = state_16524__$1;
(statearr_16708_16879[(2)] = inst_16434);

(statearr_16708_16879[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (8))){
var inst_16240 = (state_16524[(15)]);
var state_16524__$1 = state_16524;
var statearr_16709_16880 = state_16524__$1;
(statearr_16709_16880[(2)] = inst_16240);

(statearr_16709_16880[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (49))){
var inst_16356 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16356)){
var statearr_16710_16881 = state_16524__$1;
(statearr_16710_16881[(1)] = (57));

} else {
var statearr_16711_16882 = state_16524__$1;
(statearr_16711_16882[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (84))){
var inst_16371 = (state_16524[(12)]);
var state_16524__$1 = state_16524;
var statearr_16712_16883 = state_16524__$1;
(statearr_16712_16883[(2)] = inst_16371);

(statearr_16712_16883[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2684__auto__ = null;
var fluree$db$query$schema$state_machine__2684__auto____0 = (function (){
var statearr_16713 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16713[(0)] = fluree$db$query$schema$state_machine__2684__auto__);

(statearr_16713[(1)] = (1));

return statearr_16713;
});
var fluree$db$query$schema$state_machine__2684__auto____1 = (function (state_16524){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_16524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16714){var ex__2687__auto__ = e16714;
var statearr_16715_16884 = state_16524;
(statearr_16715_16884[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_16524[(4)]))){
var statearr_16716_16885 = state_16524;
(statearr_16716_16885[(1)] = cljs.core.first.call(null,(state_16524[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16886 = state_16524;
state_16524 = G__16886;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2684__auto__ = function(state_16524){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2684__auto____1.call(this,state_16524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2684__auto____0;
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2684__auto____1;
return fluree$db$query$schema$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16717 = f__2707__auto__.call(null);
(statearr_16717[(6)] = c__2706__auto__);

return statearr_16717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16888 = arguments.length;
switch (G__16888) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16912){
var state_val_16913 = (state_16912[(1)]);
if((state_val_16913 === (7))){
var state_16912__$1 = state_16912;
var statearr_16914_16934 = state_16912__$1;
(statearr_16914_16934[(2)] = db);

(statearr_16914_16934[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16913 === (1))){
var state_16912__$1 = state_16912;
var statearr_16915_16935 = state_16912__$1;
(statearr_16915_16935[(2)] = null);

(statearr_16915_16935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16913 === (4))){
var inst_16889 = (state_16912[(2)]);
var state_16912__$1 = state_16912;
var statearr_16916_16936 = state_16912__$1;
(statearr_16916_16936[(2)] = inst_16889);

(statearr_16916_16936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16913 === (6))){
var inst_16898 = (state_16912[(7)]);
var inst_16897 = (state_16912[(2)]);
var inst_16898__$1 = fluree.db.util.async.throw_err.call(null,inst_16897);
var inst_16899 = cljs.core.empty_QMARK_.call(null,inst_16898__$1);
var state_16912__$1 = (function (){var statearr_16917 = state_16912;
(statearr_16917[(7)] = inst_16898__$1);

return statearr_16917;
})();
if(inst_16899){
var statearr_16918_16937 = state_16912__$1;
(statearr_16918_16937[(1)] = (7));

} else {
var statearr_16919_16938 = state_16912__$1;
(statearr_16919_16938[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16913 === (3))){
var inst_16910 = (state_16912[(2)]);
var state_16912__$1 = state_16912;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16912__$1,inst_16910);
} else {
if((state_val_16913 === (2))){
var _ = (function (){var statearr_16921 = state_16912;
(statearr_16921[(4)] = cljs.core.cons.call(null,(5),(state_16912[(4)])));

return statearr_16921;
})();
var inst_16895 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_16912__$1 = state_16912;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16912__$1,(6),inst_16895);
} else {
if((state_val_16913 === (9))){
var inst_16907 = (state_16912[(2)]);
var _ = (function (){var statearr_16922 = state_16912;
(statearr_16922[(4)] = cljs.core.rest.call(null,(state_16912[(4)])));

return statearr_16922;
})();
var state_16912__$1 = state_16912;
var statearr_16923_16939 = state_16912__$1;
(statearr_16923_16939[(2)] = inst_16907);

(statearr_16923_16939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16913 === (5))){
var _ = (function (){var statearr_16924 = state_16912;
(statearr_16924[(4)] = cljs.core.rest.call(null,(state_16912[(4)])));

return statearr_16924;
})();
var state_16912__$1 = state_16912;
var ex16920 = (state_16912__$1[(2)]);
var statearr_16925_16940 = state_16912__$1;
(statearr_16925_16940[(5)] = ex16920);


if((ex16920 instanceof Error)){
var statearr_16926_16941 = state_16912__$1;
(statearr_16926_16941[(1)] = (4));

(statearr_16926_16941[(5)] = null);

} else {
throw ex16920;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16913 === (10))){
var inst_16904 = (state_16912[(2)]);
var inst_16905 = fluree.db.util.async.throw_err.call(null,inst_16904);
var state_16912__$1 = state_16912;
var statearr_16927_16942 = state_16912__$1;
(statearr_16927_16942[(2)] = inst_16905);

(statearr_16927_16942[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16913 === (8))){
var inst_16898 = (state_16912[(7)]);
var inst_16902 = fluree.db.query.schema.predicate_change_error.call(null,inst_16898,db,true);
var state_16912__$1 = state_16912;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16912__$1,(10),inst_16902);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2684__auto__ = null;
var fluree$db$query$schema$state_machine__2684__auto____0 = (function (){
var statearr_16928 = [null,null,null,null,null,null,null,null];
(statearr_16928[(0)] = fluree$db$query$schema$state_machine__2684__auto__);

(statearr_16928[(1)] = (1));

return statearr_16928;
});
var fluree$db$query$schema$state_machine__2684__auto____1 = (function (state_16912){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_16912);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16929){var ex__2687__auto__ = e16929;
var statearr_16930_16943 = state_16912;
(statearr_16930_16943[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_16912[(4)]))){
var statearr_16931_16944 = state_16912;
(statearr_16931_16944[(1)] = cljs.core.first.call(null,(state_16912[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16945 = state_16912;
state_16912 = G__16945;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2684__auto__ = function(state_16912){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2684__auto____1.call(this,state_16912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2684__auto____0;
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2684__auto____1;
return fluree$db$query$schema$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16932 = f__2707__auto__.call(null);
(statearr_16932[(6)] = c__2706__auto__);

return statearr_16932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16947 = arguments.length;
switch (G__16947) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16949 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__16949,(0),null);
var ns = cljs.core.nth.call(null,vec__16949,(1),null);
var name = cljs.core.nth.call(null,vec__16949,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = fluree.db.flake.p.call(null,flake);
var o = fluree.db.flake.o.call(null,flake);
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__16952_SHARP_,p2__16953_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16952_SHARP_,p2__16953_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__16954_SHARP_){
var f = p1__16954_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,fluree.db.flake.p.call(null,f))){
return fluree.db.flake.o.call(null,f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17020){
var state_val_17021 = (state_17020[(1)]);
if((state_val_17021 === (1))){
var state_17020__$1 = state_17020;
var statearr_17022_17039 = state_17020__$1;
(statearr_17022_17039[(2)] = null);

(statearr_17022_17039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17021 === (2))){
var _ = (function (){var statearr_17023 = state_17020;
(statearr_17023[(4)] = cljs.core.cons.call(null,(5),(state_17020[(4)])));

return statearr_17023;
})();
var inst_16972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16973 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_16974 = [inst_16973];
var inst_16975 = (new cljs.core.PersistentVector(null,1,(5),inst_16972,inst_16974,null));
var inst_16976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16977 = [(0)];
var inst_16978 = (new cljs.core.PersistentVector(null,1,(5),inst_16976,inst_16977,null));
var inst_16979 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16975,cljs.core._LT__EQ_,inst_16978);
var state_17020__$1 = state_17020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17020__$1,(6),inst_16979);
} else {
if((state_val_17021 === (3))){
var inst_17018 = (state_17020[(2)]);
var state_17020__$1 = state_17020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17020__$1,inst_17018);
} else {
if((state_val_17021 === (4))){
var inst_16960 = (state_17020[(2)]);
var state_17020__$1 = state_17020;
var statearr_17025_17040 = state_17020__$1;
(statearr_17025_17040[(2)] = inst_16960);

(statearr_17025_17040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17021 === (5))){
var _ = (function (){var statearr_17026 = state_17020;
(statearr_17026[(4)] = cljs.core.rest.call(null,(state_17020[(4)])));

return statearr_17026;
})();
var state_17020__$1 = state_17020;
var ex17024 = (state_17020__$1[(2)]);
var statearr_17027_17041 = state_17020__$1;
(statearr_17027_17041[(5)] = ex17024);


if((ex17024 instanceof Error)){
var statearr_17028_17042 = state_17020__$1;
(statearr_17028_17042[(1)] = (4));

(statearr_17028_17042[(5)] = null);

} else {
throw ex17024;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17021 === (6))){
var inst_16981 = (state_17020[(2)]);
var inst_16982 = fluree.db.util.async.throw_err.call(null,inst_16981);
var inst_16983 = (function (){var schema_flakes = inst_16982;
return (function (p1__16955_SHARP_){
return (fluree.db.flake.s.call(null,p1__16955_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16984 = cljs.core.partition_by.call(null,inst_16983,inst_16982);
var inst_16985 = cljs.core.nth.call(null,inst_16984,(0),null);
var inst_16986 = cljs.core.nth.call(null,inst_16984,(1),null);
var inst_16987 = (function (){var schema_flakes = inst_16982;
var vec__16966 = inst_16984;
var collection_flakes = inst_16985;
var predicate_flakes = inst_16986;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = fluree.db.flake.s.call(null,first_flake);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__16958_SHARP_,p2__16957_SHARP_){
var f = p2__16957_SHARP_;
return cljs.core.assoc.call(null,p1__16958_SHARP_,fluree.db.flake.p.call(null,f),fluree.db.flake.o.call(null,f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_16988 = [(-1),"_tx"];
var inst_16989 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16990 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16991 = cljs.core.PersistentHashMap.fromArrays(inst_16989,inst_16990);
var inst_16992 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16993 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16994 = cljs.core.PersistentHashMap.fromArrays(inst_16992,inst_16993);
var inst_16995 = [inst_16991,inst_16994];
var inst_16996 = cljs.core.PersistentHashMap.fromArrays(inst_16988,inst_16995);
var inst_16997 = (function (){var schema_flakes = inst_16982;
var vec__16966 = inst_16984;
var collection_flakes = inst_16985;
var predicate_flakes = inst_16986;
return (function (p1__16956_SHARP_){
return fluree.db.flake.s.call(null,p1__16956_SHARP_);
});
})();
var inst_16998 = cljs.core.partition_by.call(null,inst_16997,inst_16985);
var inst_16999 = cljs.core.reduce.call(null,inst_16987,inst_16996,inst_16998);
var inst_17001 = (function (){var schema_flakes = inst_16982;
var vec__16966 = inst_16984;
var collection_flakes = inst_16985;
var predicate_flakes = inst_16986;
var coll = inst_16999;
return (function (p__17000,pred_flakes){
var vec__17029 = p__17000;
var pred = cljs.core.nth.call(null,vec__17029,(0),null);
var fullText = cljs.core.nth.call(null,vec__17029,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = fluree.db.flake.s.call(null,first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_17002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17003 = cljs.core.PersistentHashMap.EMPTY;
var inst_17004 = cljs.core.PersistentHashSet.EMPTY;
var inst_17005 = [inst_17003,inst_17004];
var inst_17006 = (new cljs.core.PersistentVector(null,2,(5),inst_17002,inst_17005,null));
var inst_17007 = (function (){var schema_flakes = inst_16982;
var vec__16966 = inst_16984;
var collection_flakes = inst_16985;
var predicate_flakes = inst_16986;
var coll = inst_16999;
return (function (p1__16959_SHARP_){
return fluree.db.flake.s.call(null,p1__16959_SHARP_);
});
})();
var inst_17008 = cljs.core.partition_by.call(null,inst_17007,inst_16986);
var inst_17009 = cljs.core.reduce.call(null,inst_17001,inst_17006,inst_17008);
var inst_17010 = cljs.core.nth.call(null,inst_17009,(0),null);
var inst_17011 = cljs.core.nth.call(null,inst_17009,(1),null);
var inst_17012 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17013 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17014 = [inst_17013,inst_16999,inst_17010,inst_17011];
var inst_17015 = cljs.core.PersistentHashMap.fromArrays(inst_17012,inst_17014);
var _ = (function (){var statearr_17032 = state_17020;
(statearr_17032[(4)] = cljs.core.rest.call(null,(state_17020[(4)])));

return statearr_17032;
})();
var state_17020__$1 = state_17020;
var statearr_17033_17043 = state_17020__$1;
(statearr_17033_17043[(2)] = inst_17015);

(statearr_17033_17043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0 = (function (){
var statearr_17034 = [null,null,null,null,null,null,null];
(statearr_17034[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2684__auto__);

(statearr_17034[(1)] = (1));

return statearr_17034;
});
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1 = (function (state_17020){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17035){var ex__2687__auto__ = e17035;
var statearr_17036_17044 = state_17020;
(statearr_17036_17044[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17020[(4)]))){
var statearr_17037_17045 = state_17020;
(statearr_17037_17045[(1)] = cljs.core.first.call(null,(state_17020[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17046 = state_17020;
state_17020 = G__17046;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__ = function(state_17020){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1.call(this,state_17020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17038 = f__2707__auto__.call(null);
(statearr_17038[(6)] = c__2706__auto__);

return statearr_17038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17088){
var state_val_17089 = (state_17088[(1)]);
if((state_val_17089 === (7))){
var inst_17071 = (state_17088[(2)]);
var inst_17072 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_17071);
var inst_17073 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17074 = cljs.core.get.call(null,inst_17072,(114));
var inst_17075 = cljs.core.boolean$.call(null,inst_17074);
var inst_17076 = cljs.core.get.call(null,inst_17072,(110));
var inst_17077 = cljs.core.get.call(null,inst_17072,(117));
var inst_17078 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_17077);
var inst_17079 = cljs.core.get.call(null,inst_17072,(111));
var inst_17080 = cljs.core.get.call(null,inst_17072,(115));
var inst_17081 = cljs.core.get.call(null,inst_17072,(112));
var inst_17082 = [inst_17075,inst_17076,inst_17078,inst_17079,inst_17080,inst_17081];
var inst_17083 = cljs.core.PersistentHashMap.fromArrays(inst_17073,inst_17082);
var _ = (function (){var statearr_17090 = state_17088;
(statearr_17090[(4)] = cljs.core.rest.call(null,(state_17088[(4)])));

return statearr_17090;
})();
var state_17088__$1 = state_17088;
var statearr_17091_17114 = state_17088__$1;
(statearr_17091_17114[(2)] = inst_17083);

(statearr_17091_17114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17089 === (1))){
var state_17088__$1 = state_17088;
var statearr_17092_17115 = state_17088__$1;
(statearr_17092_17115[(2)] = null);

(statearr_17092_17115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17089 === (4))){
var inst_17047 = (state_17088[(2)]);
var state_17088__$1 = state_17088;
var statearr_17093_17116 = state_17088__$1;
(statearr_17093_17116[(2)] = inst_17047);

(statearr_17093_17116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17089 === (6))){
var _ = (function (){var statearr_17094 = state_17088;
(statearr_17094[(4)] = cljs.core.cons.call(null,(9),(state_17088[(4)])));

return statearr_17094;
})();
var inst_17059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17061 = ["_setting/id","root"];
var inst_17062 = (new cljs.core.PersistentVector(null,2,(5),inst_17060,inst_17061,null));
var inst_17063 = [inst_17062];
var inst_17064 = (new cljs.core.PersistentVector(null,1,(5),inst_17059,inst_17063,null));
var inst_17065 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17064);
var state_17088__$1 = state_17088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17088__$1,(10),inst_17065);
} else {
if((state_val_17089 === (3))){
var inst_17086 = (state_17088[(2)]);
var state_17088__$1 = state_17088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17088__$1,inst_17086);
} else {
if((state_val_17089 === (2))){
var _ = (function (){var statearr_17097 = state_17088;
(statearr_17097[(4)] = cljs.core.cons.call(null,(5),(state_17088[(4)])));

return statearr_17097;
})();
var state_17088__$1 = state_17088;
var statearr_17098_17117 = state_17088__$1;
(statearr_17098_17117[(2)] = null);

(statearr_17098_17117[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17089 === (9))){
var _ = (function (){var statearr_17099 = state_17088;
(statearr_17099[(4)] = cljs.core.rest.call(null,(state_17088[(4)])));

return statearr_17099;
})();
var state_17088__$1 = state_17088;
var ex17095 = (state_17088__$1[(2)]);
var statearr_17100_17118 = state_17088__$1;
(statearr_17100_17118[(5)] = ex17095);


var statearr_17101_17119 = state_17088__$1;
(statearr_17101_17119[(1)] = (8));

(statearr_17101_17119[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17089 === (5))){
var _ = (function (){var statearr_17102 = state_17088;
(statearr_17102[(4)] = cljs.core.rest.call(null,(state_17088[(4)])));

return statearr_17102;
})();
var state_17088__$1 = state_17088;
var ex17096 = (state_17088__$1[(2)]);
var statearr_17103_17120 = state_17088__$1;
(statearr_17103_17120[(5)] = ex17096);


if((ex17096 instanceof Error)){
var statearr_17104_17121 = state_17088__$1;
(statearr_17104_17121[(1)] = (4));

(statearr_17104_17121[(5)] = null);

} else {
throw ex17096;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17089 === (10))){
var inst_17067 = (state_17088[(2)]);
var inst_17068 = fluree.db.util.async.throw_err.call(null,inst_17067);
var _ = (function (){var statearr_17105 = state_17088;
(statearr_17105[(4)] = cljs.core.rest.call(null,(state_17088[(4)])));

return statearr_17105;
})();
var state_17088__$1 = state_17088;
var statearr_17106_17122 = state_17088__$1;
(statearr_17106_17122[(2)] = inst_17068);

(statearr_17106_17122[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17089 === (8))){
var inst_17053 = (state_17088[(2)]);
var state_17088__$1 = (function (){var statearr_17107 = state_17088;
(statearr_17107[(7)] = inst_17053);

return statearr_17107;
})();
var statearr_17108_17123 = state_17088__$1;
(statearr_17108_17123[(2)] = null);

(statearr_17108_17123[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0 = (function (){
var statearr_17109 = [null,null,null,null,null,null,null,null];
(statearr_17109[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2684__auto__);

(statearr_17109[(1)] = (1));

return statearr_17109;
});
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1 = (function (state_17088){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17110){var ex__2687__auto__ = e17110;
var statearr_17111_17124 = state_17088;
(statearr_17111_17124[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17088[(4)]))){
var statearr_17112_17125 = state_17088;
(statearr_17112_17125[(1)] = cljs.core.first.call(null,(state_17088[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17126 = state_17088;
state_17088 = G__17126;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__ = function(state_17088){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1.call(this,state_17088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17113 = f__2707__auto__.call(null);
(statearr_17113[(6)] = c__2706__auto__);

return statearr_17113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
