// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_17143 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k);
} else {
var m__5392__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_17143.call(null,s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_17144 = (function (s,d){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,d);
} else {
var m__5392__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,d);
} else {
throw cljs.core.missing_protocol.call(null,"Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_17144.call(null,s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_17145 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k);
} else {
var m__5392__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_17145.call(null,s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_17146 = (function (s,k,data){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k,data);
} else {
var m__5392__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k,data);
} else {
throw cljs.core.missing_protocol.call(null,"Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_17146.call(null,s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_17147 = (function (s,old_key,new_key){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,old_key,new_key);
} else {
var m__5392__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,old_key,new_key);
} else {
throw cljs.core.missing_protocol.call(null,"Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_17147.call(null,s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_17148 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k);
} else {
var m__5392__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_17148.call(null,s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.call(null,"_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix.call(null,network,ldgr_id);
return clojure.string.join.call(null,"_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17170){
var state_val_17171 = (state_17170[(1)]);
if((state_val_17171 === (7))){
var inst_17159 = (state_17170[(7)]);
var inst_17161 = fluree.db.storage.core.serde.call(null,conn);
var inst_17162 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17161,inst_17159);
var state_17170__$1 = state_17170;
var statearr_17172_17191 = state_17170__$1;
(statearr_17172_17191[(2)] = inst_17162);

(statearr_17172_17191[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17171 === (1))){
var state_17170__$1 = state_17170;
var statearr_17173_17192 = state_17170__$1;
(statearr_17173_17192[(2)] = null);

(statearr_17173_17192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17171 === (4))){
var inst_17149 = (state_17170[(2)]);
var state_17170__$1 = state_17170;
var statearr_17174_17193 = state_17170__$1;
(statearr_17174_17193[(2)] = inst_17149);

(statearr_17174_17193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17171 === (6))){
var inst_17159 = (state_17170[(7)]);
var inst_17158 = (state_17170[(2)]);
var inst_17159__$1 = fluree.db.util.async.throw_err.call(null,inst_17158);
var state_17170__$1 = (function (){var statearr_17175 = state_17170;
(statearr_17175[(7)] = inst_17159__$1);

return statearr_17175;
})();
if(cljs.core.truth_(inst_17159__$1)){
var statearr_17176_17194 = state_17170__$1;
(statearr_17176_17194[(1)] = (7));

} else {
var statearr_17177_17195 = state_17170__$1;
(statearr_17177_17195[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17171 === (3))){
var inst_17168 = (state_17170[(2)]);
var state_17170__$1 = state_17170;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17170__$1,inst_17168);
} else {
if((state_val_17171 === (2))){
var _ = (function (){var statearr_17179 = state_17170;
(statearr_17179[(4)] = cljs.core.cons.call(null,(5),(state_17170[(4)])));

return statearr_17179;
})();
var inst_17155 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17156 = fluree.db.storage.core.read.call(null,conn,inst_17155);
var state_17170__$1 = state_17170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17170__$1,(6),inst_17156);
} else {
if((state_val_17171 === (9))){
var inst_17165 = (state_17170[(2)]);
var _ = (function (){var statearr_17180 = state_17170;
(statearr_17180[(4)] = cljs.core.rest.call(null,(state_17170[(4)])));

return statearr_17180;
})();
var state_17170__$1 = state_17170;
var statearr_17181_17196 = state_17170__$1;
(statearr_17181_17196[(2)] = inst_17165);

(statearr_17181_17196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17171 === (5))){
var _ = (function (){var statearr_17182 = state_17170;
(statearr_17182[(4)] = cljs.core.rest.call(null,(state_17170[(4)])));

return statearr_17182;
})();
var state_17170__$1 = state_17170;
var ex17178 = (state_17170__$1[(2)]);
var statearr_17183_17197 = state_17170__$1;
(statearr_17183_17197[(5)] = ex17178);


if((ex17178 instanceof Error)){
var statearr_17184_17198 = state_17170__$1;
(statearr_17184_17198[(1)] = (4));

(statearr_17184_17198[(5)] = null);

} else {
throw ex17178;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17171 === (8))){
var state_17170__$1 = state_17170;
var statearr_17185_17199 = state_17170__$1;
(statearr_17185_17199[(2)] = null);

(statearr_17185_17199[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2684__auto____0 = (function (){
var statearr_17186 = [null,null,null,null,null,null,null,null];
(statearr_17186[(0)] = fluree$db$storage$core$read_block_$_state_machine__2684__auto__);

(statearr_17186[(1)] = (1));

return statearr_17186;
});
var fluree$db$storage$core$read_block_$_state_machine__2684__auto____1 = (function (state_17170){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17170);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17187){var ex__2687__auto__ = e17187;
var statearr_17188_17200 = state_17170;
(statearr_17188_17200[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17170[(4)]))){
var statearr_17189_17201 = state_17170;
(statearr_17189_17201[(1)] = cljs.core.first.call(null,(state_17170[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17202 = state_17170;
state_17170 = G__17202;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2684__auto__ = function(state_17170){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2684__auto____1.call(this,state_17170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17190 = f__2707__auto__.call(null);
(statearr_17190[(6)] = c__2706__auto__);

return statearr_17190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17225){
var state_val_17226 = (state_17225[(1)]);
if((state_val_17226 === (7))){
var inst_17214 = (state_17225[(7)]);
var inst_17216 = fluree.db.storage.core.serde.call(null,conn);
var inst_17217 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17216,inst_17214);
var state_17225__$1 = state_17225;
var statearr_17227_17246 = state_17225__$1;
(statearr_17227_17246[(2)] = inst_17217);

(statearr_17227_17246[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17226 === (1))){
var state_17225__$1 = state_17225;
var statearr_17228_17247 = state_17225__$1;
(statearr_17228_17247[(2)] = null);

(statearr_17228_17247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17226 === (4))){
var inst_17203 = (state_17225[(2)]);
var state_17225__$1 = state_17225;
var statearr_17229_17248 = state_17225__$1;
(statearr_17229_17248[(2)] = inst_17203);

(statearr_17229_17248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17226 === (6))){
var inst_17214 = (state_17225[(7)]);
var inst_17213 = (state_17225[(2)]);
var inst_17214__$1 = fluree.db.util.async.throw_err.call(null,inst_17213);
var state_17225__$1 = (function (){var statearr_17230 = state_17225;
(statearr_17230[(7)] = inst_17214__$1);

return statearr_17230;
})();
if(cljs.core.truth_(inst_17214__$1)){
var statearr_17231_17249 = state_17225__$1;
(statearr_17231_17249[(1)] = (7));

} else {
var statearr_17232_17250 = state_17225__$1;
(statearr_17232_17250[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17226 === (3))){
var inst_17223 = (state_17225[(2)]);
var state_17225__$1 = state_17225;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17225__$1,inst_17223);
} else {
if((state_val_17226 === (2))){
var _ = (function (){var statearr_17234 = state_17225;
(statearr_17234[(4)] = cljs.core.cons.call(null,(5),(state_17225[(4)])));

return statearr_17234;
})();
var inst_17209 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17210 = [inst_17209,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17211 = fluree.db.storage.core.read.call(null,conn,inst_17210);
var state_17225__$1 = state_17225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17225__$1,(6),inst_17211);
} else {
if((state_val_17226 === (9))){
var inst_17220 = (state_17225[(2)]);
var _ = (function (){var statearr_17235 = state_17225;
(statearr_17235[(4)] = cljs.core.rest.call(null,(state_17225[(4)])));

return statearr_17235;
})();
var state_17225__$1 = state_17225;
var statearr_17236_17251 = state_17225__$1;
(statearr_17236_17251[(2)] = inst_17220);

(statearr_17236_17251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17226 === (5))){
var _ = (function (){var statearr_17237 = state_17225;
(statearr_17237[(4)] = cljs.core.rest.call(null,(state_17225[(4)])));

return statearr_17237;
})();
var state_17225__$1 = state_17225;
var ex17233 = (state_17225__$1[(2)]);
var statearr_17238_17252 = state_17225__$1;
(statearr_17238_17252[(5)] = ex17233);


if((ex17233 instanceof Error)){
var statearr_17239_17253 = state_17225__$1;
(statearr_17239_17253[(1)] = (4));

(statearr_17239_17253[(5)] = null);

} else {
throw ex17233;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17226 === (8))){
var state_17225__$1 = state_17225;
var statearr_17240_17254 = state_17225__$1;
(statearr_17240_17254[(2)] = null);

(statearr_17240_17254[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0 = (function (){
var statearr_17241 = [null,null,null,null,null,null,null,null];
(statearr_17241[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__);

(statearr_17241[(1)] = (1));

return statearr_17241;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1 = (function (state_17225){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17225);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17242){var ex__2687__auto__ = e17242;
var statearr_17243_17255 = state_17225;
(statearr_17243_17255[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17225[(4)]))){
var statearr_17244_17256 = state_17225;
(statearr_17244_17256[(1)] = cljs.core.first.call(null,(state_17225[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17257 = state_17225;
state_17225 = G__17257;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__ = function(state_17225){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1.call(this,state_17225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17245 = f__2707__auto__.call(null);
(statearr_17245[(6)] = c__2706__auto__);

return statearr_17245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17281){
var state_val_17282 = (state_17281[(1)]);
if((state_val_17282 === (1))){
var state_17281__$1 = state_17281;
var statearr_17283_17297 = state_17281__$1;
(statearr_17283_17297[(2)] = null);

(statearr_17283_17297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17282 === (2))){
var _ = (function (){var statearr_17284 = state_17281;
(statearr_17284[(4)] = cljs.core.cons.call(null,(5),(state_17281[(4)])));

return statearr_17284;
})();
var inst_17264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17265 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17266 = (new cljs.core.PersistentVector(null,3,(5),inst_17264,inst_17265,null));
var inst_17267 = cljs.core.select_keys.call(null,block_data,inst_17266);
var inst_17268 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17267);
var inst_17269 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,inst_17268);
var inst_17270 = [inst_17269,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17271 = fluree.db.storage.core.serde.call(null,conn);
var inst_17272 = fluree.db.serde.protocol._serialize_block.call(null,inst_17271,inst_17267);
var inst_17273 = fluree.db.storage.core.write.call(null,conn,inst_17270,inst_17272);
var state_17281__$1 = state_17281;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17281__$1,(6),inst_17273);
} else {
if((state_val_17282 === (3))){
var inst_17279 = (state_17281[(2)]);
var state_17281__$1 = state_17281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17281__$1,inst_17279);
} else {
if((state_val_17282 === (4))){
var inst_17258 = (state_17281[(2)]);
var state_17281__$1 = state_17281;
var statearr_17286_17298 = state_17281__$1;
(statearr_17286_17298[(2)] = inst_17258);

(statearr_17286_17298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17282 === (5))){
var _ = (function (){var statearr_17287 = state_17281;
(statearr_17287[(4)] = cljs.core.rest.call(null,(state_17281[(4)])));

return statearr_17287;
})();
var state_17281__$1 = state_17281;
var ex17285 = (state_17281__$1[(2)]);
var statearr_17288_17299 = state_17281__$1;
(statearr_17288_17299[(5)] = ex17285);


if((ex17285 instanceof Error)){
var statearr_17289_17300 = state_17281__$1;
(statearr_17289_17300[(1)] = (4));

(statearr_17289_17300[(5)] = null);

} else {
throw ex17285;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17282 === (6))){
var inst_17275 = (state_17281[(2)]);
var inst_17276 = fluree.db.util.async.throw_err.call(null,inst_17275);
var _ = (function (){var statearr_17290 = state_17281;
(statearr_17290[(4)] = cljs.core.rest.call(null,(state_17281[(4)])));

return statearr_17290;
})();
var state_17281__$1 = state_17281;
var statearr_17291_17301 = state_17281__$1;
(statearr_17291_17301[(2)] = inst_17276);

(statearr_17291_17301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0 = (function (){
var statearr_17292 = [null,null,null,null,null,null,null];
(statearr_17292[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__);

(statearr_17292[(1)] = (1));

return statearr_17292;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1 = (function (state_17281){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17293){var ex__2687__auto__ = e17293;
var statearr_17294_17302 = state_17281;
(statearr_17294_17302[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17281[(4)]))){
var statearr_17295_17303 = state_17281;
(statearr_17295_17303[(1)] = cljs.core.first.call(null,(state_17281[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17304 = state_17281;
state_17281 = G__17304;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__ = function(state_17281){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1.call(this,state_17281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17296 = f__2707__auto__.call(null);
(statearr_17296[(6)] = c__2706__auto__);

return statearr_17296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17327){
var state_val_17328 = (state_17327[(1)]);
if((state_val_17328 === (1))){
var state_17327__$1 = state_17327;
var statearr_17329_17343 = state_17327__$1;
(statearr_17329_17343[(2)] = null);

(statearr_17329_17343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17328 === (2))){
var _ = (function (){var statearr_17330 = state_17327;
(statearr_17330[(4)] = cljs.core.cons.call(null,(5),(state_17327[(4)])));

return statearr_17330;
})();
var inst_17311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17312 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17313 = (new cljs.core.PersistentVector(null,3,(5),inst_17311,inst_17312,null));
var inst_17314 = cljs.core.select_keys.call(null,block_data,inst_17313);
var inst_17315 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17314);
var inst_17316 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,inst_17315);
var inst_17317 = fluree.db.storage.core.serde.call(null,conn);
var inst_17318 = fluree.db.serde.protocol._serialize_block.call(null,inst_17317,inst_17314);
var inst_17319 = fluree.db.storage.core.write.call(null,conn,inst_17316,inst_17318);
var state_17327__$1 = state_17327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17327__$1,(6),inst_17319);
} else {
if((state_val_17328 === (3))){
var inst_17325 = (state_17327[(2)]);
var state_17327__$1 = state_17327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17327__$1,inst_17325);
} else {
if((state_val_17328 === (4))){
var inst_17305 = (state_17327[(2)]);
var state_17327__$1 = state_17327;
var statearr_17332_17344 = state_17327__$1;
(statearr_17332_17344[(2)] = inst_17305);

(statearr_17332_17344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17328 === (5))){
var _ = (function (){var statearr_17333 = state_17327;
(statearr_17333[(4)] = cljs.core.rest.call(null,(state_17327[(4)])));

return statearr_17333;
})();
var state_17327__$1 = state_17327;
var ex17331 = (state_17327__$1[(2)]);
var statearr_17334_17345 = state_17327__$1;
(statearr_17334_17345[(5)] = ex17331);


if((ex17331 instanceof Error)){
var statearr_17335_17346 = state_17327__$1;
(statearr_17335_17346[(1)] = (4));

(statearr_17335_17346[(5)] = null);

} else {
throw ex17331;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17328 === (6))){
var inst_17321 = (state_17327[(2)]);
var inst_17322 = fluree.db.util.async.throw_err.call(null,inst_17321);
var _ = (function (){var statearr_17336 = state_17327;
(statearr_17336[(4)] = cljs.core.rest.call(null,(state_17327[(4)])));

return statearr_17336;
})();
var state_17327__$1 = state_17327;
var statearr_17337_17347 = state_17327__$1;
(statearr_17337_17347[(2)] = inst_17322);

(statearr_17337_17347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2684__auto____0 = (function (){
var statearr_17338 = [null,null,null,null,null,null,null];
(statearr_17338[(0)] = fluree$db$storage$core$write_block_$_state_machine__2684__auto__);

(statearr_17338[(1)] = (1));

return statearr_17338;
});
var fluree$db$storage$core$write_block_$_state_machine__2684__auto____1 = (function (state_17327){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17339){var ex__2687__auto__ = e17339;
var statearr_17340_17348 = state_17327;
(statearr_17340_17348[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17327[(4)]))){
var statearr_17341_17349 = state_17327;
(statearr_17341_17349[(1)] = cljs.core.first.call(null,(state_17327[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17350 = state_17327;
state_17327 = G__17350;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2684__auto__ = function(state_17327){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2684__auto____1.call(this,state_17327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17342 = f__2707__auto__.call(null);
(statearr_17342[(6)] = c__2706__auto__);

return statearr_17342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key.call(null,network,ledger_id,idx,cljs.core.random_uuid.call(null),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__17352 = arguments.length;
switch (G__17352) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id.call(null,network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.call(null,conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__17353){
var map__17354 = p__17353;
var map__17354__$1 = cljs.core.__destructure_map.call(null,map__17354);
var leaf = map__17354__$1;
var flakes = cljs.core.get.call(null,map__17354__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17375){
var state_val_17376 = (state_17375[(1)]);
if((state_val_17376 === (1))){
var state_17375__$1 = state_17375;
var statearr_17377_17393 = state_17375__$1;
(statearr_17377_17393[(2)] = null);

(statearr_17377_17393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17376 === (2))){
var _ = (function (){var statearr_17378 = state_17375;
(statearr_17378[(4)] = cljs.core.cons.call(null,(5),(state_17375[(4)])));

return statearr_17378;
})();
var inst_17361 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17362 = [flakes];
var inst_17363 = cljs.core.PersistentHashMap.fromArrays(inst_17361,inst_17362);
var inst_17364 = fluree.db.storage.core.serde.call(null,conn);
var inst_17365 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_17364,inst_17363);
var inst_17366 = fluree.db.storage.core.write.call(null,conn,leaf_id,inst_17365);
var state_17375__$1 = state_17375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17375__$1,(6),inst_17366);
} else {
if((state_val_17376 === (3))){
var inst_17373 = (state_17375[(2)]);
var state_17375__$1 = state_17375;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17375__$1,inst_17373);
} else {
if((state_val_17376 === (4))){
var inst_17355 = (state_17375[(2)]);
var state_17375__$1 = state_17375;
var statearr_17380_17394 = state_17375__$1;
(statearr_17380_17394[(2)] = inst_17355);

(statearr_17380_17394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17376 === (5))){
var _ = (function (){var statearr_17381 = state_17375;
(statearr_17381[(4)] = cljs.core.rest.call(null,(state_17375[(4)])));

return statearr_17381;
})();
var state_17375__$1 = state_17375;
var ex17379 = (state_17375__$1[(2)]);
var statearr_17382_17395 = state_17375__$1;
(statearr_17382_17395[(5)] = ex17379);


if((ex17379 instanceof Error)){
var statearr_17383_17396 = state_17375__$1;
(statearr_17383_17396[(1)] = (4));

(statearr_17383_17396[(5)] = null);

} else {
throw ex17379;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17376 === (6))){
var inst_17368 = (state_17375[(2)]);
var inst_17369 = fluree.db.util.async.throw_err.call(null,inst_17368);
var inst_17370 = cljs.core.assoc.call(null,leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_17384 = state_17375;
(statearr_17384[(4)] = cljs.core.rest.call(null,(state_17375[(4)])));

return statearr_17384;
})();
var state_17375__$1 = (function (){var statearr_17385 = state_17375;
(statearr_17385[(7)] = inst_17369);

return statearr_17385;
})();
var statearr_17386_17397 = state_17375__$1;
(statearr_17386_17397[(2)] = inst_17370);

(statearr_17386_17397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_17387 = [null,null,null,null,null,null,null,null];
(statearr_17387[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_17387[(1)] = (1));

return statearr_17387;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_17375){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17375);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17388){var ex__2687__auto__ = e17388;
var statearr_17389_17398 = state_17375;
(statearr_17389_17398[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17375[(4)]))){
var statearr_17390_17399 = state_17375;
(statearr_17390_17399[(1)] = cljs.core.first.call(null,(state_17375[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17400 = state_17375;
state_17375 = G__17400;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_17375){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_17375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17391 = f__2707__auto__.call(null);
(statearr_17391[(6)] = c__2706__auto__);

return statearr_17391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17417){
var state_val_17418 = (state_17417[(1)]);
if((state_val_17418 === (1))){
var state_17417__$1 = state_17417;
var statearr_17419_17434 = state_17417__$1;
(statearr_17419_17434[(2)] = null);

(statearr_17419_17434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (2))){
var _ = (function (){var statearr_17420 = state_17417;
(statearr_17420[(4)] = cljs.core.cons.call(null,(5),(state_17417[(4)])));

return statearr_17420;
})();
var inst_17407 = fluree.db.storage.core.serde.call(null,conn);
var inst_17408 = fluree.db.serde.protocol._serialize_branch.call(null,inst_17407,data);
var inst_17409 = fluree.db.storage.core.write.call(null,conn,key,inst_17408);
var state_17417__$1 = state_17417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17417__$1,(6),inst_17409);
} else {
if((state_val_17418 === (3))){
var inst_17415 = (state_17417[(2)]);
var state_17417__$1 = state_17417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17417__$1,inst_17415);
} else {
if((state_val_17418 === (4))){
var inst_17401 = (state_17417[(2)]);
var state_17417__$1 = state_17417;
var statearr_17422_17435 = state_17417__$1;
(statearr_17422_17435[(2)] = inst_17401);

(statearr_17422_17435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (5))){
var _ = (function (){var statearr_17423 = state_17417;
(statearr_17423[(4)] = cljs.core.rest.call(null,(state_17417[(4)])));

return statearr_17423;
})();
var state_17417__$1 = state_17417;
var ex17421 = (state_17417__$1[(2)]);
var statearr_17424_17436 = state_17417__$1;
(statearr_17424_17436[(5)] = ex17421);


if((ex17421 instanceof Error)){
var statearr_17425_17437 = state_17417__$1;
(statearr_17425_17437[(1)] = (4));

(statearr_17425_17437[(5)] = null);

} else {
throw ex17421;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17418 === (6))){
var inst_17411 = (state_17417[(2)]);
var inst_17412 = fluree.db.util.async.throw_err.call(null,inst_17411);
var _ = (function (){var statearr_17426 = state_17417;
(statearr_17426[(4)] = cljs.core.rest.call(null,(state_17417[(4)])));

return statearr_17426;
})();
var state_17417__$1 = (function (){var statearr_17427 = state_17417;
(statearr_17427[(7)] = inst_17412);

return statearr_17427;
})();
var statearr_17428_17438 = state_17417__$1;
(statearr_17428_17438[(2)] = key);

(statearr_17428_17438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0 = (function (){
var statearr_17429 = [null,null,null,null,null,null,null,null];
(statearr_17429[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__);

(statearr_17429[(1)] = (1));

return statearr_17429;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1 = (function (state_17417){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17430){var ex__2687__auto__ = e17430;
var statearr_17431_17439 = state_17417;
(statearr_17431_17439[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17417[(4)]))){
var statearr_17432_17440 = state_17417;
(statearr_17432_17440[(1)] = cljs.core.first.call(null,(state_17417[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17441 = state_17417;
state_17417 = G__17441;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__ = function(state_17417){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1.call(this,state_17417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17433 = f__2707__auto__.call(null);
(statearr_17433[(6)] = c__2706__auto__);

return statearr_17433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key.call(null,network,ledger_id,idx,cljs.core.random_uuid.call(null),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__17443 = arguments.length;
switch (G__17443) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id.call(null,network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.call(null,conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__17444){
var map__17445 = p__17444;
var map__17445__$1 = cljs.core.__destructure_map.call(null,map__17445);
var branch = map__17445__$1;
var children = cljs.core.get.call(null,map__17445__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17471){
var state_val_17472 = (state_17471[(1)]);
if((state_val_17472 === (1))){
var state_17471__$1 = state_17471;
var statearr_17473_17490 = state_17471__$1;
(statearr_17473_17490[(2)] = null);

(statearr_17473_17490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17472 === (2))){
var _ = (function (){var statearr_17474 = state_17471;
(statearr_17474[(4)] = cljs.core.cons.call(null,(5),(state_17471[(4)])));

return statearr_17474;
})();
var inst_17452 = cljs.core.map.call(null,cljs.core.val,children);
var inst_17453 = cljs.core.mapv.call(null,fluree.db.storage.core.child_data,inst_17452);
var inst_17454 = cljs.core.first.call(null,inst_17453);
var inst_17455 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_17454);
var inst_17456 = cljs.core.rseq.call(null,inst_17453);
var inst_17457 = cljs.core.first.call(null,inst_17456);
var inst_17458 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_17457);
var inst_17459 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_17460 = [inst_17453];
var inst_17461 = cljs.core.PersistentHashMap.fromArrays(inst_17459,inst_17460);
var inst_17462 = fluree.db.storage.core.write_branch_data.call(null,conn,branch_id,inst_17461);
var state_17471__$1 = (function (){var statearr_17475 = state_17471;
(statearr_17475[(7)] = inst_17455);

(statearr_17475[(8)] = inst_17458);

return statearr_17475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17471__$1,(6),inst_17462);
} else {
if((state_val_17472 === (3))){
var inst_17469 = (state_17471[(2)]);
var state_17471__$1 = state_17471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17471__$1,inst_17469);
} else {
if((state_val_17472 === (4))){
var inst_17446 = (state_17471[(2)]);
var state_17471__$1 = state_17471;
var statearr_17477_17491 = state_17471__$1;
(statearr_17477_17491[(2)] = inst_17446);

(statearr_17477_17491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17472 === (5))){
var _ = (function (){var statearr_17478 = state_17471;
(statearr_17478[(4)] = cljs.core.rest.call(null,(state_17471[(4)])));

return statearr_17478;
})();
var state_17471__$1 = state_17471;
var ex17476 = (state_17471__$1[(2)]);
var statearr_17479_17492 = state_17471__$1;
(statearr_17479_17492[(5)] = ex17476);


if((ex17476 instanceof Error)){
var statearr_17480_17493 = state_17471__$1;
(statearr_17480_17493[(1)] = (4));

(statearr_17480_17493[(5)] = null);

} else {
throw ex17476;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17472 === (6))){
var inst_17464 = (state_17471[(2)]);
var inst_17465 = fluree.db.util.async.throw_err.call(null,inst_17464);
var inst_17466 = cljs.core.assoc.call(null,branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_17481 = state_17471;
(statearr_17481[(4)] = cljs.core.rest.call(null,(state_17471[(4)])));

return statearr_17481;
})();
var state_17471__$1 = (function (){var statearr_17482 = state_17471;
(statearr_17482[(9)] = inst_17465);

return statearr_17482;
})();
var statearr_17483_17494 = state_17471__$1;
(statearr_17483_17494[(2)] = inst_17466);

(statearr_17483_17494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_17484 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17484[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_17484[(1)] = (1));

return statearr_17484;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_17471){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17485){var ex__2687__auto__ = e17485;
var statearr_17486_17495 = state_17471;
(statearr_17486_17495[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17471[(4)]))){
var statearr_17487_17496 = state_17471;
(statearr_17487_17496[(1)] = cljs.core.first.call(null,(state_17471[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17497 = state_17471;
state_17471 = G__17497;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_17471){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_17471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17488 = f__2707__auto__.call(null);
(statearr_17488[(6)] = c__2706__auto__);

return statearr_17488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17525){
var state_val_17526 = (state_17525[(1)]);
if((state_val_17526 === (1))){
var state_17525__$1 = state_17525;
var statearr_17527_17543 = state_17525__$1;
(statearr_17527_17543[(2)] = null);

(statearr_17527_17543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17526 === (2))){
var inst_17511 = (state_17525[(7)]);
var _ = (function (){var statearr_17528 = state_17525;
(statearr_17528[(4)] = cljs.core.cons.call(null,(5),(state_17525[(4)])));

return statearr_17528;
})();
var inst_17505 = db;
var inst_17506 = cljs.core.__destructure_map.call(null,inst_17505);
var inst_17507 = cljs.core.get.call(null,inst_17506,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17508 = cljs.core.get.call(null,inst_17506,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17509 = cljs.core.get.call(null,inst_17506,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17510 = cljs.core.get.call(null,inst_17506,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17511__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_17508,inst_17509,inst_17510);
var inst_17512 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17513 = [inst_17509,inst_17510,garbage];
var inst_17514 = cljs.core.PersistentHashMap.fromArrays(inst_17512,inst_17513);
var inst_17515 = fluree.db.storage.core.serde.call(null,inst_17507);
var inst_17516 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_17515,inst_17514);
var inst_17517 = fluree.db.storage.core.write.call(null,inst_17507,inst_17511__$1,inst_17516);
var state_17525__$1 = (function (){var statearr_17529 = state_17525;
(statearr_17529[(7)] = inst_17511__$1);

return statearr_17529;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17525__$1,(6),inst_17517);
} else {
if((state_val_17526 === (3))){
var inst_17523 = (state_17525[(2)]);
var state_17525__$1 = state_17525;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17525__$1,inst_17523);
} else {
if((state_val_17526 === (4))){
var inst_17498 = (state_17525[(2)]);
var state_17525__$1 = state_17525;
var statearr_17531_17544 = state_17525__$1;
(statearr_17531_17544[(2)] = inst_17498);

(statearr_17531_17544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17526 === (5))){
var _ = (function (){var statearr_17532 = state_17525;
(statearr_17532[(4)] = cljs.core.rest.call(null,(state_17525[(4)])));

return statearr_17532;
})();
var state_17525__$1 = state_17525;
var ex17530 = (state_17525__$1[(2)]);
var statearr_17533_17545 = state_17525__$1;
(statearr_17533_17545[(5)] = ex17530);


if((ex17530 instanceof Error)){
var statearr_17534_17546 = state_17525__$1;
(statearr_17534_17546[(1)] = (4));

(statearr_17534_17546[(5)] = null);

} else {
throw ex17530;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17526 === (6))){
var inst_17511 = (state_17525[(7)]);
var inst_17519 = (state_17525[(2)]);
var inst_17520 = fluree.db.util.async.throw_err.call(null,inst_17519);
var _ = (function (){var statearr_17535 = state_17525;
(statearr_17535[(4)] = cljs.core.rest.call(null,(state_17525[(4)])));

return statearr_17535;
})();
var state_17525__$1 = (function (){var statearr_17536 = state_17525;
(statearr_17536[(8)] = inst_17520);

return statearr_17536;
})();
var statearr_17537_17547 = state_17525__$1;
(statearr_17537_17547[(2)] = inst_17511);

(statearr_17537_17547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0 = (function (){
var statearr_17538 = [null,null,null,null,null,null,null,null,null];
(statearr_17538[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__);

(statearr_17538[(1)] = (1));

return statearr_17538;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1 = (function (state_17525){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17525);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17539){var ex__2687__auto__ = e17539;
var statearr_17540_17548 = state_17525;
(statearr_17540_17548[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17525[(4)]))){
var statearr_17541_17549 = state_17525;
(statearr_17541_17549[(1)] = cljs.core.first.call(null,(state_17525[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17550 = state_17525;
state_17525 = G__17550;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__ = function(state_17525){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1.call(this,state_17525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17542 = f__2707__auto__.call(null);
(statearr_17542[(6)] = c__2706__auto__);

return statearr_17542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17552 = arguments.length;
switch (G__17552) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17610){
var state_val_17611 = (state_17610[(1)]);
if((state_val_17611 === (7))){
var state_17610__$1 = state_17610;
var statearr_17612_17638 = state_17610__$1;
(statearr_17612_17638[(2)] = (0));

(statearr_17612_17638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (1))){
var state_17610__$1 = state_17610;
var statearr_17613_17639 = state_17610__$1;
(statearr_17613_17639[(2)] = null);

(statearr_17613_17639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (4))){
var inst_17553 = (state_17610[(2)]);
var state_17610__$1 = state_17610;
var statearr_17614_17640 = state_17610__$1;
(statearr_17614_17640[(2)] = inst_17553);

(statearr_17614_17640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (6))){
var inst_17579 = (state_17610[(7)]);
var state_17610__$1 = state_17610;
var statearr_17615_17641 = state_17610__$1;
(statearr_17615_17641[(2)] = inst_17579);

(statearr_17615_17641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (3))){
var inst_17608 = (state_17610[(2)]);
var state_17610__$1 = state_17610;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17610__$1,inst_17608);
} else {
if((state_val_17611 === (12))){
var inst_17576 = (state_17610[(8)]);
var inst_17604 = (state_17610[(2)]);
var inst_17605 = fluree.db.util.async.throw_err.call(null,inst_17604);
var _ = (function (){var statearr_17616 = state_17610;
(statearr_17616[(4)] = cljs.core.rest.call(null,(state_17610[(4)])));

return statearr_17616;
})();
var state_17610__$1 = (function (){var statearr_17617 = state_17610;
(statearr_17617[(9)] = inst_17605);

return statearr_17617;
})();
var statearr_17618_17642 = state_17610__$1;
(statearr_17618_17642[(2)] = inst_17576);

(statearr_17618_17642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (2))){
var inst_17568 = (state_17610[(10)]);
var inst_17571 = (state_17610[(11)]);
var inst_17579 = (state_17610[(7)]);
var inst_17566 = (state_17610[(12)]);
var _ = (function (){var statearr_17619 = state_17610;
(statearr_17619[(4)] = cljs.core.cons.call(null,(5),(state_17610[(4)])));

return statearr_17619;
})();
var inst_17560 = db;
var inst_17561 = cljs.core.__destructure_map.call(null,inst_17560);
var inst_17562 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17563 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17564 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17565 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17566__$1 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17567 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17568__$1 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17569 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17570 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_17571__$1 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17572 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17573 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17574 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17575 = cljs.core.get.call(null,inst_17561,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17576 = fluree.db.storage.core.ledger_root_key.call(null,inst_17562,inst_17571__$1,inst_17568__$1);
var inst_17577 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17578 = fluree.db.storage.core.child_data.call(null,inst_17569);
var inst_17579__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17566__$1);
var state_17610__$1 = (function (){var statearr_17620 = state_17610;
(statearr_17620[(13)] = inst_17563);

(statearr_17620[(8)] = inst_17576);

(statearr_17620[(10)] = inst_17568__$1);

(statearr_17620[(11)] = inst_17571__$1);

(statearr_17620[(14)] = inst_17570);

(statearr_17620[(15)] = inst_17564);

(statearr_17620[(16)] = inst_17572);

(statearr_17620[(17)] = inst_17573);

(statearr_17620[(18)] = inst_17565);

(statearr_17620[(19)] = inst_17567);

(statearr_17620[(20)] = inst_17575);

(statearr_17620[(21)] = inst_17577);

(statearr_17620[(22)] = inst_17578);

(statearr_17620[(7)] = inst_17579__$1);

(statearr_17620[(23)] = inst_17574);

(statearr_17620[(12)] = inst_17566__$1);

return statearr_17620;
})();
if(cljs.core.truth_(inst_17579__$1)){
var statearr_17621_17643 = state_17610__$1;
(statearr_17621_17643[(1)] = (6));

} else {
var statearr_17622_17644 = state_17610__$1;
(statearr_17622_17644[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (11))){
var inst_17563 = (state_17610[(13)]);
var inst_17576 = (state_17610[(8)]);
var inst_17568 = (state_17610[(10)]);
var inst_17584 = (state_17610[(24)]);
var inst_17571 = (state_17610[(11)]);
var inst_17564 = (state_17610[(15)]);
var inst_17573 = (state_17610[(17)]);
var inst_17583 = (state_17610[(25)]);
var inst_17565 = (state_17610[(18)]);
var inst_17567 = (state_17610[(19)]);
var inst_17575 = (state_17610[(20)]);
var inst_17577 = (state_17610[(21)]);
var inst_17578 = (state_17610[(22)]);
var inst_17574 = (state_17610[(23)]);
var inst_17566 = (state_17610[(12)]);
var inst_17589 = (state_17610[(2)]);
var inst_17590 = fluree.db.storage.core.child_data.call(null,inst_17573);
var inst_17591 = fluree.db.storage.core.child_data.call(null,inst_17575);
var inst_17592 = fluree.db.util.core.current_time_millis.call(null);
var inst_17593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17594 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17595 = (new cljs.core.PersistentVector(null,2,(5),inst_17593,inst_17594,null));
var inst_17596 = cljs.core.select_keys.call(null,inst_17566,inst_17595);
var inst_17597 = fluree.db.storage.core.child_data.call(null,inst_17565);
var inst_17598 = [inst_17568,inst_17578,inst_17583,inst_17571,inst_17584,inst_17589,inst_17590,inst_17591,inst_17563,inst_17592,inst_17564,inst_17574,inst_17596,inst_17597];
var inst_17599 = cljs.core.PersistentHashMap.fromArrays(inst_17577,inst_17598);
var inst_17600 = fluree.db.storage.core.serde.call(null,inst_17567);
var inst_17601 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_17600,inst_17599);
var inst_17602 = fluree.db.storage.core.write.call(null,inst_17567,inst_17576,inst_17601);
var state_17610__$1 = state_17610;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17610__$1,(12),inst_17602);
} else {
if((state_val_17611 === (9))){
var inst_17585 = (state_17610[(26)]);
var state_17610__$1 = state_17610;
var statearr_17624_17645 = state_17610__$1;
(statearr_17624_17645[(2)] = inst_17585);

(statearr_17624_17645[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (5))){
var _ = (function (){var statearr_17625 = state_17610;
(statearr_17625[(4)] = cljs.core.rest.call(null,(state_17610[(4)])));

return statearr_17625;
})();
var state_17610__$1 = state_17610;
var ex17623 = (state_17610__$1[(2)]);
var statearr_17626_17646 = state_17610__$1;
(statearr_17626_17646[(5)] = ex17623);


if((ex17623 instanceof Error)){
var statearr_17627_17647 = state_17610__$1;
(statearr_17627_17647[(1)] = (4));

(statearr_17627_17647[(5)] = null);

} else {
throw ex17623;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (10))){
var inst_17572 = (state_17610[(16)]);
var state_17610__$1 = state_17610;
var statearr_17628_17648 = state_17610__$1;
(statearr_17628_17648[(2)] = inst_17572);

(statearr_17628_17648[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (8))){
var inst_17570 = (state_17610[(14)]);
var inst_17585 = (state_17610[(26)]);
var inst_17583 = (state_17610[(2)]);
var inst_17584 = fluree.db.storage.core.child_data.call(null,inst_17570);
var inst_17585__$1 = custom_ecount;
var state_17610__$1 = (function (){var statearr_17629 = state_17610;
(statearr_17629[(24)] = inst_17584);

(statearr_17629[(25)] = inst_17583);

(statearr_17629[(26)] = inst_17585__$1);

return statearr_17629;
})();
if(cljs.core.truth_(inst_17585__$1)){
var statearr_17630_17649 = state_17610__$1;
(statearr_17630_17649[(1)] = (9));

} else {
var statearr_17631_17650 = state_17610__$1;
(statearr_17631_17650[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_17632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17632[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_17632[(1)] = (1));

return statearr_17632;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_17610){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17610);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17633){var ex__2687__auto__ = e17633;
var statearr_17634_17651 = state_17610;
(statearr_17634_17651[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17610[(4)]))){
var statearr_17635_17652 = state_17610;
(statearr_17635_17652[(1)] = cljs.core.first.call(null,(state_17610[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17653 = state_17610;
state_17610 = G__17653;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_17610){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_17610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17636 = f__2707__auto__.call(null);
(statearr_17636[(6)] = c__2706__auto__);

return statearr_17636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__17654,key){
var map__17655 = p__17654;
var map__17655__$1 = cljs.core.__destructure_map.call(null,map__17655);
var conn = map__17655__$1;
var serializer = cljs.core.get.call(null,map__17655__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17675){
var state_val_17676 = (state_17675[(1)]);
if((state_val_17676 === (7))){
var inst_17665 = (state_17675[(7)]);
var inst_17667 = fluree.db.serde.protocol._deserialize_branch.call(null,serializer,inst_17665);
var state_17675__$1 = state_17675;
var statearr_17677_17696 = state_17675__$1;
(statearr_17677_17696[(2)] = inst_17667);

(statearr_17677_17696[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (1))){
var state_17675__$1 = state_17675;
var statearr_17678_17697 = state_17675__$1;
(statearr_17678_17697[(2)] = null);

(statearr_17678_17697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (4))){
var inst_17656 = (state_17675[(2)]);
var state_17675__$1 = state_17675;
var statearr_17679_17698 = state_17675__$1;
(statearr_17679_17698[(2)] = inst_17656);

(statearr_17679_17698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (6))){
var inst_17665 = (state_17675[(7)]);
var inst_17664 = (state_17675[(2)]);
var inst_17665__$1 = fluree.db.util.async.throw_err.call(null,inst_17664);
var state_17675__$1 = (function (){var statearr_17680 = state_17675;
(statearr_17680[(7)] = inst_17665__$1);

return statearr_17680;
})();
if(cljs.core.truth_(inst_17665__$1)){
var statearr_17681_17699 = state_17675__$1;
(statearr_17681_17699[(1)] = (7));

} else {
var statearr_17682_17700 = state_17675__$1;
(statearr_17682_17700[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (3))){
var inst_17673 = (state_17675[(2)]);
var state_17675__$1 = state_17675;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17675__$1,inst_17673);
} else {
if((state_val_17676 === (2))){
var _ = (function (){var statearr_17684 = state_17675;
(statearr_17684[(4)] = cljs.core.cons.call(null,(5),(state_17675[(4)])));

return statearr_17684;
})();
var inst_17662 = fluree.db.storage.core.read.call(null,conn,key);
var state_17675__$1 = state_17675;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17675__$1,(6),inst_17662);
} else {
if((state_val_17676 === (9))){
var inst_17670 = (state_17675[(2)]);
var _ = (function (){var statearr_17685 = state_17675;
(statearr_17685[(4)] = cljs.core.rest.call(null,(state_17675[(4)])));

return statearr_17685;
})();
var state_17675__$1 = state_17675;
var statearr_17686_17701 = state_17675__$1;
(statearr_17686_17701[(2)] = inst_17670);

(statearr_17686_17701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (5))){
var _ = (function (){var statearr_17687 = state_17675;
(statearr_17687[(4)] = cljs.core.rest.call(null,(state_17675[(4)])));

return statearr_17687;
})();
var state_17675__$1 = state_17675;
var ex17683 = (state_17675__$1[(2)]);
var statearr_17688_17702 = state_17675__$1;
(statearr_17688_17702[(5)] = ex17683);


if((ex17683 instanceof Error)){
var statearr_17689_17703 = state_17675__$1;
(statearr_17689_17703[(1)] = (4));

(statearr_17689_17703[(5)] = null);

} else {
throw ex17683;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (8))){
var state_17675__$1 = state_17675;
var statearr_17690_17704 = state_17675__$1;
(statearr_17690_17704[(2)] = null);

(statearr_17690_17704[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0 = (function (){
var statearr_17691 = [null,null,null,null,null,null,null,null];
(statearr_17691[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2684__auto__);

(statearr_17691[(1)] = (1));

return statearr_17691;
});
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1 = (function (state_17675){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17675);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17692){var ex__2687__auto__ = e17692;
var statearr_17693_17705 = state_17675;
(statearr_17693_17705[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17675[(4)]))){
var statearr_17694_17706 = state_17675;
(statearr_17694_17706[(1)] = cljs.core.first.call(null,(state_17675[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17707 = state_17675;
state_17675 = G__17707;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__ = function(state_17675){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1.call(this,state_17675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17695 = f__2707__auto__.call(null);
(statearr_17695[(6)] = c__2706__auto__);

return statearr_17695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__17708,key){
var map__17709 = p__17708;
var map__17709__$1 = cljs.core.__destructure_map.call(null,map__17709);
var conn = map__17709__$1;
var serializer = cljs.core.get.call(null,map__17709__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17729){
var state_val_17730 = (state_17729[(1)]);
if((state_val_17730 === (7))){
var inst_17719 = (state_17729[(7)]);
var inst_17721 = fluree.db.serde.protocol._deserialize_leaf.call(null,serializer,inst_17719);
var state_17729__$1 = state_17729;
var statearr_17731_17750 = state_17729__$1;
(statearr_17731_17750[(2)] = inst_17721);

(statearr_17731_17750[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17730 === (1))){
var state_17729__$1 = state_17729;
var statearr_17732_17751 = state_17729__$1;
(statearr_17732_17751[(2)] = null);

(statearr_17732_17751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17730 === (4))){
var inst_17710 = (state_17729[(2)]);
var state_17729__$1 = state_17729;
var statearr_17733_17752 = state_17729__$1;
(statearr_17733_17752[(2)] = inst_17710);

(statearr_17733_17752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17730 === (6))){
var inst_17719 = (state_17729[(7)]);
var inst_17718 = (state_17729[(2)]);
var inst_17719__$1 = fluree.db.util.async.throw_err.call(null,inst_17718);
var state_17729__$1 = (function (){var statearr_17734 = state_17729;
(statearr_17734[(7)] = inst_17719__$1);

return statearr_17734;
})();
if(cljs.core.truth_(inst_17719__$1)){
var statearr_17735_17753 = state_17729__$1;
(statearr_17735_17753[(1)] = (7));

} else {
var statearr_17736_17754 = state_17729__$1;
(statearr_17736_17754[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17730 === (3))){
var inst_17727 = (state_17729[(2)]);
var state_17729__$1 = state_17729;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17729__$1,inst_17727);
} else {
if((state_val_17730 === (2))){
var _ = (function (){var statearr_17738 = state_17729;
(statearr_17738[(4)] = cljs.core.cons.call(null,(5),(state_17729[(4)])));

return statearr_17738;
})();
var inst_17716 = fluree.db.storage.core.read.call(null,conn,key);
var state_17729__$1 = state_17729;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17729__$1,(6),inst_17716);
} else {
if((state_val_17730 === (9))){
var inst_17724 = (state_17729[(2)]);
var _ = (function (){var statearr_17739 = state_17729;
(statearr_17739[(4)] = cljs.core.rest.call(null,(state_17729[(4)])));

return statearr_17739;
})();
var state_17729__$1 = state_17729;
var statearr_17740_17755 = state_17729__$1;
(statearr_17740_17755[(2)] = inst_17724);

(statearr_17740_17755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17730 === (5))){
var _ = (function (){var statearr_17741 = state_17729;
(statearr_17741[(4)] = cljs.core.rest.call(null,(state_17729[(4)])));

return statearr_17741;
})();
var state_17729__$1 = state_17729;
var ex17737 = (state_17729__$1[(2)]);
var statearr_17742_17756 = state_17729__$1;
(statearr_17742_17756[(5)] = ex17737);


if((ex17737 instanceof Error)){
var statearr_17743_17757 = state_17729__$1;
(statearr_17743_17757[(1)] = (4));

(statearr_17743_17757[(5)] = null);

} else {
throw ex17737;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17730 === (8))){
var state_17729__$1 = state_17729;
var statearr_17744_17758 = state_17729__$1;
(statearr_17744_17758[(2)] = null);

(statearr_17744_17758[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0 = (function (){
var statearr_17745 = [null,null,null,null,null,null,null,null];
(statearr_17745[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__);

(statearr_17745[(1)] = (1));

return statearr_17745;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1 = (function (state_17729){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17729);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17746){var ex__2687__auto__ = e17746;
var statearr_17747_17759 = state_17729;
(statearr_17747_17759[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17729[(4)]))){
var statearr_17748_17760 = state_17729;
(statearr_17748_17760[(1)] = cljs.core.first.call(null,(state_17729[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17761 = state_17729;
state_17729 = G__17761;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__ = function(state_17729){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1.call(this,state_17729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17749 = f__2707__auto__.call(null);
(statearr_17749[(6)] = c__2706__auto__);

return statearr_17749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__17762,index,index_data){
var map__17763 = p__17762;
var map__17763__$1 = cljs.core.__destructure_map.call(null,map__17763);
var network = cljs.core.get.call(null,map__17763__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__17763__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.call(null,map__17763__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.call(null,map__17763__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__17763__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__5045__auto__ = cljs.core.get.call(null,comparators,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db index root: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__17764 = index_data;
var G__17764__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.call(null,G__17764,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__17764);
var G__17764__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.call(null,G__17764__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__17764__$1);
return cljs.core.assoc.call(null,G__17764__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true);

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17765 = root_data;
var map__17765__$1 = cljs.core.__destructure_map.call(null,map__17765);
var block = cljs.core.get.call(null,map__17765__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__17765__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__17765__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__17765__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root.call(null,conn,db,idx,cljs.core.get.call(null,root_data,idx));
return cljs.core.assoc.call(null,db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17787){
var state_val_17788 = (state_17787[(1)]);
if((state_val_17788 === (7))){
var state_17787__$1 = state_17787;
var statearr_17789_17809 = state_17787__$1;
(statearr_17789_17809[(2)] = null);

(statearr_17789_17809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17788 === (1))){
var state_17787__$1 = state_17787;
var statearr_17790_17810 = state_17787__$1;
(statearr_17790_17810[(2)] = null);

(statearr_17790_17810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17788 === (4))){
var inst_17766 = (state_17787[(2)]);
var state_17787__$1 = state_17787;
var statearr_17791_17811 = state_17787__$1;
(statearr_17791_17811[(2)] = inst_17766);

(statearr_17791_17811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17788 === (6))){
var inst_17773 = (state_17787[(7)]);
var inst_17775 = fluree.db.storage.core.serde.call(null,conn);
var state_17787__$1 = (function (){var statearr_17792 = state_17787;
(statearr_17792[(8)] = inst_17775);

return statearr_17792;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17787__$1,(9),inst_17773);
} else {
if((state_val_17788 === (3))){
var inst_17785 = (state_17787[(2)]);
var state_17787__$1 = state_17787;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17787__$1,inst_17785);
} else {
if((state_val_17788 === (2))){
var inst_17773 = (state_17787[(7)]);
var _ = (function (){var statearr_17794 = state_17787;
(statearr_17794[(4)] = cljs.core.cons.call(null,(5),(state_17787[(4)])));

return statearr_17794;
})();
var inst_17772 = fluree.db.storage.core.ledger_garbage_key.call(null,network,ledger_id,block);
var inst_17773__$1 = fluree.db.storage.core.read.call(null,conn,inst_17772);
var state_17787__$1 = (function (){var statearr_17795 = state_17787;
(statearr_17795[(7)] = inst_17773__$1);

return statearr_17795;
})();
if(cljs.core.truth_(inst_17773__$1)){
var statearr_17796_17812 = state_17787__$1;
(statearr_17796_17812[(1)] = (6));

} else {
var statearr_17797_17813 = state_17787__$1;
(statearr_17797_17813[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17788 === (9))){
var inst_17775 = (state_17787[(8)]);
var inst_17777 = (state_17787[(2)]);
var inst_17778 = fluree.db.util.async.throw_err.call(null,inst_17777);
var inst_17779 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_17775,inst_17778);
var state_17787__$1 = state_17787;
var statearr_17798_17814 = state_17787__$1;
(statearr_17798_17814[(2)] = inst_17779);

(statearr_17798_17814[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17788 === (5))){
var _ = (function (){var statearr_17799 = state_17787;
(statearr_17799[(4)] = cljs.core.rest.call(null,(state_17787[(4)])));

return statearr_17799;
})();
var state_17787__$1 = state_17787;
var ex17793 = (state_17787__$1[(2)]);
var statearr_17800_17815 = state_17787__$1;
(statearr_17800_17815[(5)] = ex17793);


if((ex17793 instanceof Error)){
var statearr_17801_17816 = state_17787__$1;
(statearr_17801_17816[(1)] = (4));

(statearr_17801_17816[(5)] = null);

} else {
throw ex17793;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17788 === (8))){
var inst_17782 = (state_17787[(2)]);
var _ = (function (){var statearr_17802 = state_17787;
(statearr_17802[(4)] = cljs.core.rest.call(null,(state_17787[(4)])));

return statearr_17802;
})();
var state_17787__$1 = state_17787;
var statearr_17803_17817 = state_17787__$1;
(statearr_17803_17817[(2)] = inst_17782);

(statearr_17803_17817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0 = (function (){
var statearr_17804 = [null,null,null,null,null,null,null,null,null];
(statearr_17804[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__);

(statearr_17804[(1)] = (1));

return statearr_17804;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1 = (function (state_17787){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17787);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17805){var ex__2687__auto__ = e17805;
var statearr_17806_17818 = state_17787;
(statearr_17806_17818[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17787[(4)]))){
var statearr_17807_17819 = state_17787;
(statearr_17807_17819[(1)] = cljs.core.first.call(null,(state_17787[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17820 = state_17787;
state_17787 = G__17820;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__ = function(state_17787){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1.call(this,state_17787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17808 = f__2707__auto__.call(null);
(statearr_17808[(6)] = c__2706__auto__);

return statearr_17808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17842){
var state_val_17843 = (state_17842[(1)]);
if((state_val_17843 === (7))){
var inst_17831 = (state_17842[(7)]);
var inst_17833 = fluree.db.storage.core.serde.call(null,conn);
var inst_17834 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_17833,inst_17831);
var state_17842__$1 = state_17842;
var statearr_17844_17863 = state_17842__$1;
(statearr_17844_17863[(2)] = inst_17834);

(statearr_17844_17863[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17843 === (1))){
var state_17842__$1 = state_17842;
var statearr_17845_17864 = state_17842__$1;
(statearr_17845_17864[(2)] = null);

(statearr_17845_17864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17843 === (4))){
var inst_17821 = (state_17842[(2)]);
var state_17842__$1 = state_17842;
var statearr_17846_17865 = state_17842__$1;
(statearr_17846_17865[(2)] = inst_17821);

(statearr_17846_17865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17843 === (6))){
var inst_17831 = (state_17842[(7)]);
var inst_17830 = (state_17842[(2)]);
var inst_17831__$1 = fluree.db.util.async.throw_err.call(null,inst_17830);
var state_17842__$1 = (function (){var statearr_17847 = state_17842;
(statearr_17847[(7)] = inst_17831__$1);

return statearr_17847;
})();
if(cljs.core.truth_(inst_17831__$1)){
var statearr_17848_17866 = state_17842__$1;
(statearr_17848_17866[(1)] = (7));

} else {
var statearr_17849_17867 = state_17842__$1;
(statearr_17849_17867[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17843 === (3))){
var inst_17840 = (state_17842[(2)]);
var state_17842__$1 = state_17842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17842__$1,inst_17840);
} else {
if((state_val_17843 === (2))){
var _ = (function (){var statearr_17851 = state_17842;
(statearr_17851[(4)] = cljs.core.cons.call(null,(5),(state_17842[(4)])));

return statearr_17851;
})();
var inst_17827 = fluree.db.storage.core.ledger_root_key.call(null,network,ledger_id,block);
var inst_17828 = fluree.db.storage.core.read.call(null,conn,inst_17827);
var state_17842__$1 = state_17842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17842__$1,(6),inst_17828);
} else {
if((state_val_17843 === (9))){
var inst_17837 = (state_17842[(2)]);
var _ = (function (){var statearr_17852 = state_17842;
(statearr_17852[(4)] = cljs.core.rest.call(null,(state_17842[(4)])));

return statearr_17852;
})();
var state_17842__$1 = state_17842;
var statearr_17853_17868 = state_17842__$1;
(statearr_17853_17868[(2)] = inst_17837);

(statearr_17853_17868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17843 === (5))){
var _ = (function (){var statearr_17854 = state_17842;
(statearr_17854[(4)] = cljs.core.rest.call(null,(state_17842[(4)])));

return statearr_17854;
})();
var state_17842__$1 = state_17842;
var ex17850 = (state_17842__$1[(2)]);
var statearr_17855_17869 = state_17842__$1;
(statearr_17855_17869[(5)] = ex17850);


if((ex17850 instanceof Error)){
var statearr_17856_17870 = state_17842__$1;
(statearr_17856_17870[(1)] = (4));

(statearr_17856_17870[(5)] = null);

} else {
throw ex17850;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17843 === (8))){
var state_17842__$1 = state_17842;
var statearr_17857_17871 = state_17842__$1;
(statearr_17857_17871[(2)] = null);

(statearr_17857_17871[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0 = (function (){
var statearr_17858 = [null,null,null,null,null,null,null,null];
(statearr_17858[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__);

(statearr_17858[(1)] = (1));

return statearr_17858;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1 = (function (state_17842){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17859){var ex__2687__auto__ = e17859;
var statearr_17860_17872 = state_17842;
(statearr_17860_17872[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17842[(4)]))){
var statearr_17861_17873 = state_17842;
(statearr_17861_17873[(1)] = cljs.core.first.call(null,(state_17842[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17874 = state_17842;
state_17842 = G__17874;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__ = function(state_17842){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1.call(this,state_17842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17862 = f__2707__auto__.call(null);
(statearr_17862[(6)] = c__2706__auto__);

return statearr_17862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17911){
var state_val_17912 = (state_17911[(1)]);
if((state_val_17912 === (7))){
var inst_17881 = (state_17911[(7)]);
var state_17911__$1 = state_17911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17911__$1,(9),inst_17881);
} else {
if((state_val_17912 === (1))){
var state_17911__$1 = state_17911;
var statearr_17913_17934 = state_17911__$1;
(statearr_17913_17934[(2)] = null);

(statearr_17913_17934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17912 === (4))){
var inst_17875 = (state_17911[(2)]);
var state_17911__$1 = state_17911;
var statearr_17914_17935 = state_17911__$1;
(statearr_17914_17935[(2)] = inst_17875);

(statearr_17914_17935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17912 === (6))){
var inst_17884 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_17885 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17886 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_17887 = cljs.core.PersistentHashMap.fromArrays(inst_17885,inst_17886);
var inst_17888 = cljs.core.ex_info.call(null,inst_17884,inst_17887);
var inst_17889 = (function(){throw inst_17888})();
var state_17911__$1 = state_17911;
var statearr_17915_17936 = state_17911__$1;
(statearr_17915_17936[(2)] = inst_17889);

(statearr_17915_17936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17912 === (3))){
var inst_17909 = (state_17911[(2)]);
var state_17911__$1 = state_17911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17911__$1,inst_17909);
} else {
if((state_val_17912 === (2))){
var inst_17881 = (state_17911[(7)]);
var _ = (function (){var statearr_17916 = state_17911;
(statearr_17916[(4)] = cljs.core.cons.call(null,(5),(state_17911[(4)])));

return statearr_17916;
})();
var inst_17881__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,ledger_id,index);
var inst_17882 = cljs.core.not.call(null,inst_17881__$1);
var state_17911__$1 = (function (){var statearr_17917 = state_17911;
(statearr_17917[(7)] = inst_17881__$1);

return statearr_17917;
})();
if(inst_17882){
var statearr_17918_17937 = state_17911__$1;
(statearr_17918_17937[(1)] = (6));

} else {
var statearr_17919_17938 = state_17911__$1;
(statearr_17919_17938[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17912 === (11))){
var inst_17899 = (state_17911[(8)]);
var inst_17902 = (state_17911[(2)]);
var inst_17903 = fluree.db.util.async.throw_err.call(null,inst_17902);
var inst_17904 = cljs.core.assoc.call(null,inst_17899,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_17903);
var state_17911__$1 = state_17911;
var statearr_17921_17939 = state_17911__$1;
(statearr_17921_17939[(2)] = inst_17904);

(statearr_17921_17939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17912 === (9))){
var inst_17894 = (state_17911[(9)]);
var inst_17892 = (state_17911[(2)]);
var inst_17893 = fluree.db.util.async.throw_err.call(null,inst_17892);
var inst_17894__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_17893);
var inst_17895 = fluree.db.query.schema.schema_map.call(null,inst_17894__$1);
var state_17911__$1 = (function (){var statearr_17922 = state_17911;
(statearr_17922[(9)] = inst_17894__$1);

return statearr_17922;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17911__$1,(10),inst_17895);
} else {
if((state_val_17912 === (5))){
var _ = (function (){var statearr_17923 = state_17911;
(statearr_17923[(4)] = cljs.core.rest.call(null,(state_17911[(4)])));

return statearr_17923;
})();
var state_17911__$1 = state_17911;
var ex17920 = (state_17911__$1[(2)]);
var statearr_17924_17940 = state_17911__$1;
(statearr_17924_17940[(5)] = ex17920);


if((ex17920 instanceof Error)){
var statearr_17925_17941 = state_17911__$1;
(statearr_17925_17941[(1)] = (4));

(statearr_17925_17941[(5)] = null);

} else {
throw ex17920;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17912 === (10))){
var inst_17894 = (state_17911[(9)]);
var inst_17899 = (state_17911[(8)]);
var inst_17897 = (state_17911[(2)]);
var inst_17898 = fluree.db.util.async.throw_err.call(null,inst_17897);
var inst_17899__$1 = cljs.core.assoc.call(null,inst_17894,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_17898);
var inst_17900 = fluree.db.query.schema.setting_map.call(null,inst_17899__$1);
var state_17911__$1 = (function (){var statearr_17926 = state_17911;
(statearr_17926[(8)] = inst_17899__$1);

return statearr_17926;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17911__$1,(11),inst_17900);
} else {
if((state_val_17912 === (8))){
var inst_17906 = (state_17911[(2)]);
var _ = (function (){var statearr_17927 = state_17911;
(statearr_17927[(4)] = cljs.core.rest.call(null,(state_17911[(4)])));

return statearr_17927;
})();
var state_17911__$1 = state_17911;
var statearr_17928_17942 = state_17911__$1;
(statearr_17928_17942[(2)] = inst_17906);

(statearr_17928_17942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0 = (function (){
var statearr_17929 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17929[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2684__auto__);

(statearr_17929[(1)] = (1));

return statearr_17929;
});
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1 = (function (state_17911){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17930){var ex__2687__auto__ = e17930;
var statearr_17931_17943 = state_17911;
(statearr_17931_17943[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17911[(4)]))){
var statearr_17932_17944 = state_17911;
(statearr_17932_17944[(1)] = cljs.core.first.call(null,(state_17911[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17945 = state_17911;
state_17911 = G__17945;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__ = function(state_17911){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1.call(this,state_17911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17933 = f__2707__auto__.call(null);
(statearr_17933[(6)] = c__2706__auto__);

return statearr_17933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__17946){
var map__17947 = p__17946;
var map__17947__$1 = cljs.core.__destructure_map.call(null,map__17947);
var branch = map__17947__$1;
var id = cljs.core.get.call(null,map__17947__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.call(null,map__17947__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.call(null,map__17947__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17984){
var state_val_17985 = (state_17984[(1)]);
if((state_val_17985 === (7))){
var inst_17957 = (state_17984[(7)]);
var inst_17960 = cljs.core.__destructure_map.call(null,inst_17957);
var inst_17961 = cljs.core.get.call(null,inst_17960,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_17962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17963 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_17964 = (new cljs.core.PersistentVector(null,7,(5),inst_17962,inst_17963,null));
var inst_17965 = cljs.core.select_keys.call(null,branch,inst_17964);
var inst_17966 = (function (){var temp__5802__auto__ = inst_17957;
var map__17959 = inst_17960;
var children = inst_17961;
var branch_metadata = inst_17965;
return (function (i,child){
return cljs.core.merge.call(null,cljs.core.assoc.call(null,branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (i === (0));
} else {
return and__5043__auto__;
}
})()),child);
});
})();
var inst_17967 = cljs.core.map_indexed.call(null,inst_17966,inst_17961);
var inst_17968 = cljs.core.juxt.call(null,new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_17969 = cljs.core.mapcat.call(null,inst_17968,inst_17967);
var inst_17970 = cljs.core.apply.call(null,fluree.db.flake.sorted_map_by,comparator,inst_17969);
var state_17984__$1 = state_17984;
var statearr_17986_18005 = state_17984__$1;
(statearr_17986_18005[(2)] = inst_17970);

(statearr_17986_18005[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17985 === (1))){
var state_17984__$1 = state_17984;
var statearr_17987_18006 = state_17984__$1;
(statearr_17987_18006[(2)] = null);

(statearr_17987_18006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17985 === (4))){
var inst_17948 = (state_17984[(2)]);
var state_17984__$1 = state_17984;
var statearr_17988_18007 = state_17984__$1;
(statearr_17988_18007[(2)] = inst_17948);

(statearr_17988_18007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17985 === (6))){
var inst_17957 = (state_17984[(7)]);
var inst_17956 = (state_17984[(2)]);
var inst_17957__$1 = fluree.db.util.async.throw_err.call(null,inst_17956);
var state_17984__$1 = (function (){var statearr_17989 = state_17984;
(statearr_17989[(7)] = inst_17957__$1);

return statearr_17989;
})();
if(cljs.core.truth_(inst_17957__$1)){
var statearr_17990_18008 = state_17984__$1;
(statearr_17990_18008[(1)] = (7));

} else {
var statearr_17991_18009 = state_17984__$1;
(statearr_17991_18009[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17985 === (3))){
var inst_17982 = (state_17984[(2)]);
var state_17984__$1 = state_17984;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17984__$1,inst_17982);
} else {
if((state_val_17985 === (2))){
var _ = (function (){var statearr_17993 = state_17984;
(statearr_17993[(4)] = cljs.core.cons.call(null,(5),(state_17984[(4)])));

return statearr_17993;
})();
var inst_17954 = fluree.db.storage.core.read_branch.call(null,conn,id);
var state_17984__$1 = state_17984;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17984__$1,(6),inst_17954);
} else {
if((state_val_17985 === (9))){
var inst_17979 = (state_17984[(2)]);
var _ = (function (){var statearr_17994 = state_17984;
(statearr_17994[(4)] = cljs.core.rest.call(null,(state_17984[(4)])));

return statearr_17994;
})();
var state_17984__$1 = state_17984;
var statearr_17995_18010 = state_17984__$1;
(statearr_17995_18010[(2)] = inst_17979);

(statearr_17995_18010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17985 === (5))){
var _ = (function (){var statearr_17996 = state_17984;
(statearr_17996[(4)] = cljs.core.rest.call(null,(state_17984[(4)])));

return statearr_17996;
})();
var state_17984__$1 = state_17984;
var ex17992 = (state_17984__$1[(2)]);
var statearr_17997_18011 = state_17984__$1;
(statearr_17997_18011[(5)] = ex17992);


if((ex17992 instanceof Error)){
var statearr_17998_18012 = state_17984__$1;
(statearr_17998_18012[(1)] = (4));

(statearr_17998_18012[(5)] = null);

} else {
throw ex17992;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17985 === (8))){
var inst_17972 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_17973 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17974 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_17975 = cljs.core.PersistentHashMap.fromArrays(inst_17973,inst_17974);
var inst_17976 = cljs.core.ex_info.call(null,inst_17972,inst_17975);
var inst_17977 = (function(){throw inst_17976})();
var state_17984__$1 = state_17984;
var statearr_17999_18013 = state_17984__$1;
(statearr_17999_18013[(2)] = inst_17977);

(statearr_17999_18013[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____0 = (function (){
var statearr_18000 = [null,null,null,null,null,null,null,null];
(statearr_18000[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__);

(statearr_18000[(1)] = (1));

return statearr_18000;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____1 = (function (state_17984){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_17984);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18001){var ex__2687__auto__ = e18001;
var statearr_18002_18014 = state_17984;
(statearr_18002_18014[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_17984[(4)]))){
var statearr_18003_18015 = state_17984;
(statearr_18003_18015[(1)] = cljs.core.first.call(null,(state_17984[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18016 = state_17984;
state_17984 = G__18016;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__ = function(state_17984){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____1.call(this,state_17984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18004 = f__2707__auto__.call(null);
(statearr_18004[(6)] = c__2706__auto__);

return statearr_18004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__18017){
var map__18018 = p__18017;
var map__18018__$1 = cljs.core.__destructure_map.call(null,map__18018);
var id = cljs.core.get.call(null,map__18018__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.call(null,map__18018__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18047){
var state_val_18048 = (state_18047[(1)]);
if((state_val_18048 === (7))){
var inst_18028 = (state_18047[(7)]);
var inst_18031 = cljs.core.__destructure_map.call(null,inst_18028);
var inst_18032 = cljs.core.get.call(null,inst_18031,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18033 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,comparator,inst_18032);
var state_18047__$1 = state_18047;
var statearr_18049_18068 = state_18047__$1;
(statearr_18049_18068[(2)] = inst_18033);

(statearr_18049_18068[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18048 === (1))){
var state_18047__$1 = state_18047;
var statearr_18050_18069 = state_18047__$1;
(statearr_18050_18069[(2)] = null);

(statearr_18050_18069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18048 === (4))){
var inst_18019 = (state_18047[(2)]);
var state_18047__$1 = state_18047;
var statearr_18051_18070 = state_18047__$1;
(statearr_18051_18070[(2)] = inst_18019);

(statearr_18051_18070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18048 === (6))){
var inst_18028 = (state_18047[(7)]);
var inst_18027 = (state_18047[(2)]);
var inst_18028__$1 = fluree.db.util.async.throw_err.call(null,inst_18027);
var state_18047__$1 = (function (){var statearr_18052 = state_18047;
(statearr_18052[(7)] = inst_18028__$1);

return statearr_18052;
})();
if(cljs.core.truth_(inst_18028__$1)){
var statearr_18053_18071 = state_18047__$1;
(statearr_18053_18071[(1)] = (7));

} else {
var statearr_18054_18072 = state_18047__$1;
(statearr_18054_18072[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18048 === (3))){
var inst_18045 = (state_18047[(2)]);
var state_18047__$1 = state_18047;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18047__$1,inst_18045);
} else {
if((state_val_18048 === (2))){
var _ = (function (){var statearr_18056 = state_18047;
(statearr_18056[(4)] = cljs.core.cons.call(null,(5),(state_18047[(4)])));

return statearr_18056;
})();
var inst_18025 = fluree.db.storage.core.read_leaf.call(null,conn,id);
var state_18047__$1 = state_18047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18047__$1,(6),inst_18025);
} else {
if((state_val_18048 === (9))){
var inst_18042 = (state_18047[(2)]);
var _ = (function (){var statearr_18057 = state_18047;
(statearr_18057[(4)] = cljs.core.rest.call(null,(state_18047[(4)])));

return statearr_18057;
})();
var state_18047__$1 = state_18047;
var statearr_18058_18073 = state_18047__$1;
(statearr_18058_18073[(2)] = inst_18042);

(statearr_18058_18073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18048 === (5))){
var _ = (function (){var statearr_18059 = state_18047;
(statearr_18059[(4)] = cljs.core.rest.call(null,(state_18047[(4)])));

return statearr_18059;
})();
var state_18047__$1 = state_18047;
var ex18055 = (state_18047__$1[(2)]);
var statearr_18060_18074 = state_18047__$1;
(statearr_18060_18074[(5)] = ex18055);


if((ex18055 instanceof Error)){
var statearr_18061_18075 = state_18047__$1;
(statearr_18061_18075[(1)] = (4));

(statearr_18061_18075[(5)] = null);

} else {
throw ex18055;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18048 === (8))){
var inst_18035 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_18036 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18037 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18038 = cljs.core.PersistentHashMap.fromArrays(inst_18036,inst_18037);
var inst_18039 = cljs.core.ex_info.call(null,inst_18035,inst_18038);
var inst_18040 = (function(){throw inst_18039})();
var state_18047__$1 = state_18047;
var statearr_18062_18076 = state_18047__$1;
(statearr_18062_18076[(2)] = inst_18040);

(statearr_18062_18076[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____0 = (function (){
var statearr_18063 = [null,null,null,null,null,null,null,null];
(statearr_18063[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__);

(statearr_18063[(1)] = (1));

return statearr_18063;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____1 = (function (state_18047){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_18047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18064){var ex__2687__auto__ = e18064;
var statearr_18065_18077 = state_18047;
(statearr_18065_18077[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_18047[(4)]))){
var statearr_18066_18078 = state_18047;
(statearr_18066_18078[(1)] = cljs.core.first.call(null,(state_18047[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18079 = state_18047;
state_18047 = G__18079;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__ = function(state_18047){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____1.call(this,state_18047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18067 = f__2707__auto__.call(null);
(statearr_18067[(6)] = c__2706__auto__);

return statearr_18067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__18081 = arguments.length;
switch (G__18081) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.call(null,node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__18082,error_fn){
var map__18083 = p__18082;
var map__18083__$1 = cljs.core.__destructure_map.call(null,map__18083);
var node = map__18083__$1;
var comparator = cljs.core.get.call(null,map__18083__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.call(null,map__18083__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.call(null);
var c__2706__auto___18155 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18127){
var state_val_18128 = (state_18127[(1)]);
if((state_val_18128 === (7))){
var inst_18092 = (state_18127[(2)]);
var state_18127__$1 = state_18127;
var statearr_18129_18156 = state_18127__$1;
(statearr_18129_18156[(2)] = inst_18092);

(statearr_18129_18156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18128 === (1))){
var state_18127__$1 = state_18127;
var statearr_18130_18157 = state_18127__$1;
(statearr_18130_18157[(2)] = null);

(statearr_18130_18157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18128 === (4))){
var inst_18084 = (state_18127[(7)]);
var inst_18084__$1 = (state_18127[(2)]);
var inst_18085 = fluree.db.util.log.error.call(null,inst_18084__$1,"Error resolving index node");
var state_18127__$1 = (function (){var statearr_18131 = state_18127;
(statearr_18131[(7)] = inst_18084__$1);

(statearr_18131[(8)] = inst_18085);

return statearr_18131;
})();
if(cljs.core.truth_(error_fn)){
var statearr_18132_18158 = state_18127__$1;
(statearr_18132_18158[(1)] = (5));

} else {
var statearr_18133_18159 = state_18127__$1;
(statearr_18133_18159[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18128 === (13))){
var inst_18110 = (state_18127[(9)]);
var inst_18113 = (state_18127[(2)]);
var inst_18114 = fluree.db.util.async.throw_err.call(null,inst_18113);
var inst_18115 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_18114];
var inst_18116 = (new cljs.core.PersistentVector(null,2,(5),inst_18110,inst_18115,null));
var state_18127__$1 = state_18127;
var statearr_18134_18160 = state_18127__$1;
(statearr_18134_18160[(2)] = inst_18116);

(statearr_18134_18160[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18128 === (6))){
var state_18127__$1 = state_18127;
var statearr_18135_18161 = state_18127__$1;
(statearr_18135_18161[(2)] = null);

(statearr_18135_18161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18128 === (3))){
var inst_18125 = (state_18127[(2)]);
var state_18127__$1 = state_18127;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18127__$1,inst_18125);
} else {
if((state_val_18128 === (12))){
var inst_18102 = (state_18127[(10)]);
var inst_18105 = (state_18127[(2)]);
var inst_18106 = fluree.db.util.async.throw_err.call(null,inst_18105);
var inst_18107 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18106];
var inst_18108 = (new cljs.core.PersistentVector(null,2,(5),inst_18102,inst_18107,null));
var state_18127__$1 = state_18127;
var statearr_18136_18162 = state_18127__$1;
(statearr_18136_18162[(2)] = inst_18108);

(statearr_18136_18162[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18128 === (2))){
var _ = (function (){var statearr_18137 = state_18127;
(statearr_18137[(4)] = cljs.core.cons.call(null,(8),(state_18127[(4)])));

return statearr_18137;
})();
var state_18127__$1 = state_18127;
if(cljs.core.truth_(leaf)){
var statearr_18138_18163 = state_18127__$1;
(statearr_18138_18163[(1)] = (9));

} else {
var statearr_18139_18164 = state_18127__$1;
(statearr_18139_18164[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18128 === (11))){
var inst_18118 = (state_18127[(2)]);
var inst_18119 = cljs.core.nth.call(null,inst_18118,(0),null);
var inst_18120 = cljs.core.nth.call(null,inst_18118,(1),null);
var inst_18121 = cljs.core.assoc.call(null,node,inst_18119,inst_18120);
var inst_18122 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18121);
var _ = (function (){var statearr_18140 = state_18127;
(statearr_18140[(4)] = cljs.core.rest.call(null,(state_18127[(4)])));

return statearr_18140;
})();
var state_18127__$1 = state_18127;
var statearr_18141_18165 = state_18127__$1;
(statearr_18141_18165[(2)] = inst_18122);

(statearr_18141_18165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18128 === (9))){
var inst_18102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18103 = fluree.db.storage.core.fetch_leaf_flakes.call(null,conn,node);
var state_18127__$1 = (function (){var statearr_18142 = state_18127;
(statearr_18142[(10)] = inst_18102);

return statearr_18142;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18127__$1,(12),inst_18103);
} else {
if((state_val_18128 === (5))){
var inst_18084 = (state_18127[(7)]);
var inst_18087 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18084);
var inst_18088 = cljs.core.async.close_BANG_.call(null,return_ch);
var inst_18089 = error_fn.call(null,inst_18087,inst_18088);
var state_18127__$1 = state_18127;
var statearr_18144_18166 = state_18127__$1;
(statearr_18144_18166[(2)] = inst_18089);

(statearr_18144_18166[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18128 === (10))){
var inst_18110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18111 = fluree.db.storage.core.fetch_child_attributes.call(null,conn,node);
var state_18127__$1 = (function (){var statearr_18145 = state_18127;
(statearr_18145[(9)] = inst_18110);

return statearr_18145;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18127__$1,(13),inst_18111);
} else {
if((state_val_18128 === (8))){
var _ = (function (){var statearr_18146 = state_18127;
(statearr_18146[(4)] = cljs.core.rest.call(null,(state_18127[(4)])));

return statearr_18146;
})();
var state_18127__$1 = state_18127;
var ex18143 = (state_18127__$1[(2)]);
var statearr_18147_18167 = state_18127__$1;
(statearr_18147_18167[(5)] = ex18143);


var statearr_18148_18168 = state_18127__$1;
(statearr_18148_18168[(1)] = (4));

(statearr_18148_18168[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_18149 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18149[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_18149[(1)] = (1));

return statearr_18149;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_18127){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_18127);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18150){var ex__2687__auto__ = e18150;
var statearr_18151_18169 = state_18127;
(statearr_18151_18169[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_18127[(4)]))){
var statearr_18152_18170 = state_18127;
(statearr_18152_18170[(1)] = cljs.core.first.call(null,(state_18127[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18171 = state_18127;
state_18127 = G__18171;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_18127){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_18127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18153 = f__2707__auto__.call(null);
(statearr_18153[(6)] = c__2706__auto___18155);

return statearr_18153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__18172){
var map__18173 = p__18172;
var map__18173__$1 = cljs.core.__destructure_map.call(null,map__18173);
var node = map__18173__$1;
var comparator = cljs.core.get.call(null,map__18173__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.call(null);
var empty_set = fluree.db.flake.sorted_set_by.call(null,comparator);
var empty_node = cljs.core.assoc.call(null,node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.call(null,ch,empty_node);

return ch;
});
