// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_12256){
var state_val_12257 = (state_12256[(1)]);
if((state_val_12257 === (7))){
var inst_12251 = (state_12256[(2)]);
var _ = (function (){var statearr_12258 = state_12256;
(statearr_12258[(4)] = cljs.core.rest.call(null,(state_12256[(4)])));

return statearr_12258;
})();
var state_12256__$1 = state_12256;
var statearr_12259_12281 = state_12256__$1;
(statearr_12259_12281[(2)] = inst_12251);

(statearr_12259_12281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12257 === (1))){
var state_12256__$1 = state_12256;
var statearr_12260_12282 = state_12256__$1;
(statearr_12260_12282[(2)] = null);

(statearr_12260_12282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12257 === (4))){
var inst_12213 = (state_12256[(2)]);
var state_12256__$1 = state_12256;
var statearr_12261_12283 = state_12256__$1;
(statearr_12261_12283[(2)] = inst_12213);

(statearr_12261_12283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12257 === (6))){
var inst_12238 = (state_12256[(7)]);
var inst_12231 = (state_12256[(8)]);
var inst_12237 = cljs.core.seq.call(null,inst_12231);
var inst_12238__$1 = cljs.core.first.call(null,inst_12237);
var inst_12239 = cljs.core.next.call(null,inst_12237);
var inst_12240 = cljs.core.not.call(null,inst_12238__$1);
var state_12256__$1 = (function (){var statearr_12262 = state_12256;
(statearr_12262[(9)] = inst_12239);

(statearr_12262[(7)] = inst_12238__$1);

return statearr_12262;
})();
if(inst_12240){
var statearr_12263_12284 = state_12256__$1;
(statearr_12263_12284[(1)] = (8));

} else {
var statearr_12264_12285 = state_12256__$1;
(statearr_12264_12285[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12257 === (3))){
var inst_12254 = (state_12256[(2)]);
var state_12256__$1 = state_12256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12256__$1,inst_12254);
} else {
if((state_val_12257 === (2))){
var _ = (function (){var statearr_12265 = state_12256;
(statearr_12265[(4)] = cljs.core.cons.call(null,(5),(state_12256[(4)])));

return statearr_12265;
})();
var inst_12226 = chs;
var inst_12227 = cljs.core.seq.call(null,inst_12226);
var inst_12228 = cljs.core.first.call(null,inst_12227);
var inst_12229 = cljs.core.next.call(null,inst_12227);
var inst_12230 = coll;
var inst_12231 = inst_12226;
var inst_12232 = inst_12230;
var state_12256__$1 = (function (){var statearr_12266 = state_12256;
(statearr_12266[(10)] = inst_12232);

(statearr_12266[(11)] = inst_12228);

(statearr_12266[(12)] = inst_12229);

(statearr_12266[(8)] = inst_12231);

return statearr_12266;
})();
var statearr_12267_12286 = state_12256__$1;
(statearr_12267_12286[(2)] = null);

(statearr_12267_12286[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12257 === (11))){
var inst_12239 = (state_12256[(9)]);
var inst_12232 = (state_12256[(10)]);
var inst_12244 = (state_12256[(2)]);
var inst_12245 = fluree.db.util.async.throw_err.call(null,inst_12244);
var inst_12246 = cljs.core.conj.call(null,inst_12232,inst_12245);
var inst_12231 = inst_12239;
var inst_12232__$1 = inst_12246;
var state_12256__$1 = (function (){var statearr_12269 = state_12256;
(statearr_12269[(10)] = inst_12232__$1);

(statearr_12269[(8)] = inst_12231);

return statearr_12269;
})();
var statearr_12270_12287 = state_12256__$1;
(statearr_12270_12287[(2)] = null);

(statearr_12270_12287[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12257 === (9))){
var inst_12238 = (state_12256[(7)]);
var state_12256__$1 = state_12256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12256__$1,(11),inst_12238);
} else {
if((state_val_12257 === (5))){
var _ = (function (){var statearr_12271 = state_12256;
(statearr_12271[(4)] = cljs.core.rest.call(null,(state_12256[(4)])));

return statearr_12271;
})();
var state_12256__$1 = state_12256;
var ex12268 = (state_12256__$1[(2)]);
var statearr_12272_12288 = state_12256__$1;
(statearr_12272_12288[(5)] = ex12268);


var statearr_12273_12289 = state_12256__$1;
(statearr_12273_12289[(1)] = (4));

(statearr_12273_12289[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12257 === (10))){
var inst_12249 = (state_12256[(2)]);
var state_12256__$1 = state_12256;
var statearr_12274_12290 = state_12256__$1;
(statearr_12274_12290[(2)] = inst_12249);

(statearr_12274_12290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12257 === (8))){
var inst_12232 = (state_12256[(10)]);
var state_12256__$1 = state_12256;
var statearr_12275_12291 = state_12256__$1;
(statearr_12275_12291[(2)] = inst_12232);

(statearr_12275_12291[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_12276 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12276[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__);

(statearr_12276[(1)] = (1));

return statearr_12276;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____1 = (function (state_12256){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_12256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e12277){var ex__2687__auto__ = e12277;
var statearr_12278_12292 = state_12256;
(statearr_12278_12292[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_12256[(4)]))){
var statearr_12279_12293 = state_12256;
(statearr_12279_12293[(1)] = cljs.core.first.call(null,(state_12256[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12294 = state_12256;
state_12256 = G__12294;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__ = function(state_12256){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____1.call(this,state_12256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_12280 = f__2707__auto__.call(null);
(statearr_12280[(6)] = c__2706__auto__);

return statearr_12280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_12320){
var state_val_12321 = (state_12320[(1)]);
if((state_val_12321 === (7))){
var inst_12315 = (state_12320[(2)]);
var _ = (function (){var statearr_12322 = state_12320;
(statearr_12322[(4)] = cljs.core.rest.call(null,(state_12320[(4)])));

return statearr_12322;
})();
var state_12320__$1 = state_12320;
var statearr_12323_12345 = state_12320__$1;
(statearr_12323_12345[(2)] = inst_12315);

(statearr_12323_12345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12321 === (1))){
var state_12320__$1 = state_12320;
var statearr_12324_12346 = state_12320__$1;
(statearr_12324_12346[(2)] = null);

(statearr_12324_12346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12321 === (4))){
var inst_12295 = (state_12320[(2)]);
var state_12320__$1 = state_12320;
var statearr_12325_12347 = state_12320__$1;
(statearr_12325_12347[(2)] = inst_12295);

(statearr_12325_12347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12321 === (6))){
var state_12320__$1 = state_12320;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12320__$1,(8),chan);
} else {
if((state_val_12321 === (3))){
var inst_12318 = (state_12320[(2)]);
var state_12320__$1 = state_12320;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12320__$1,inst_12318);
} else {
if((state_val_12321 === (2))){
var _ = (function (){var statearr_12326 = state_12320;
(statearr_12326[(4)] = cljs.core.cons.call(null,(5),(state_12320[(4)])));

return statearr_12326;
})();
var inst_12301 = coll;
var inst_12302 = inst_12301;
var state_12320__$1 = (function (){var statearr_12327 = state_12320;
(statearr_12327[(7)] = inst_12302);

return statearr_12327;
})();
var statearr_12328_12348 = state_12320__$1;
(statearr_12328_12348[(2)] = null);

(statearr_12328_12348[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12321 === (11))){
var inst_12313 = (state_12320[(2)]);
var state_12320__$1 = state_12320;
var statearr_12330_12349 = state_12320__$1;
(statearr_12330_12349[(2)] = inst_12313);

(statearr_12330_12349[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12321 === (9))){
var inst_12302 = (state_12320[(7)]);
var state_12320__$1 = state_12320;
var statearr_12331_12350 = state_12320__$1;
(statearr_12331_12350[(2)] = inst_12302);

(statearr_12331_12350[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12321 === (5))){
var _ = (function (){var statearr_12332 = state_12320;
(statearr_12332[(4)] = cljs.core.rest.call(null,(state_12320[(4)])));

return statearr_12332;
})();
var state_12320__$1 = state_12320;
var ex12329 = (state_12320__$1[(2)]);
var statearr_12333_12351 = state_12320__$1;
(statearr_12333_12351[(5)] = ex12329);


var statearr_12334_12352 = state_12320__$1;
(statearr_12334_12352[(1)] = (4));

(statearr_12334_12352[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12321 === (10))){
var inst_12302 = (state_12320[(7)]);
var inst_12306 = (state_12320[(8)]);
var inst_12310 = cljs.core.conj.call(null,inst_12302,inst_12306);
var inst_12302__$1 = inst_12310;
var state_12320__$1 = (function (){var statearr_12335 = state_12320;
(statearr_12335[(7)] = inst_12302__$1);

return statearr_12335;
})();
var statearr_12336_12353 = state_12320__$1;
(statearr_12336_12353[(2)] = null);

(statearr_12336_12353[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12321 === (8))){
var inst_12306 = (state_12320[(8)]);
var inst_12305 = (state_12320[(2)]);
var inst_12306__$1 = fluree.db.util.async.throw_err.call(null,inst_12305);
var inst_12307 = (inst_12306__$1 == null);
var state_12320__$1 = (function (){var statearr_12337 = state_12320;
(statearr_12337[(8)] = inst_12306__$1);

return statearr_12337;
})();
if(cljs.core.truth_(inst_12307)){
var statearr_12338_12354 = state_12320__$1;
(statearr_12338_12354[(1)] = (9));

} else {
var statearr_12339_12355 = state_12320__$1;
(statearr_12339_12355[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_12340 = [null,null,null,null,null,null,null,null,null];
(statearr_12340[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__);

(statearr_12340[(1)] = (1));

return statearr_12340;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____1 = (function (state_12320){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_12320);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e12341){var ex__2687__auto__ = e12341;
var statearr_12342_12356 = state_12320;
(statearr_12342_12356[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_12320[(4)]))){
var statearr_12343_12357 = state_12320;
(statearr_12343_12357[(1)] = cljs.core.first.call(null,(state_12320[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12358 = state_12320;
state_12320 = G__12358;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__ = function(state_12320){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____1.call(this,state_12320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2684__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_12344 = f__2707__auto__.call(null);
(statearr_12344[(6)] = c__2706__auto__);

return statearr_12344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
