// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('sci.impl.evaluator');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('sci.impl.deftype');
goog.require('sci.impl.interop');
goog.require('sci.impl.macros');
goog.require('sci.impl.records');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');
sci.impl.evaluator.macros = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Symbol(null,"fn","fn",465265323,null),"null",new cljs.core.Symbol(null,"do","do",1686842252,null),"null",new cljs.core.Symbol(null,"defn","defn",-126010802,null),"null",new cljs.core.Symbol(null,"syntax-quote","syntax-quote",407366680,null),"null",new cljs.core.Symbol(null,"def","def",597100991,null),"null"], null), null);
/**
 * The and macro from clojure.core. Note: and is unrolled in the analyzer, this is a fallback.
 */
sci.impl.evaluator.eval_and = (function sci$impl$evaluator$eval_and(ctx,bindings,args){
var args__$1 = cljs.core.seq.call(null,args);
while(true){
if(args__$1){
var x = cljs.core.first.call(null,args__$1);
var v = sci.impl.types.eval.call(null,x,ctx,bindings);
if(cljs.core.truth_(v)){
var xs = cljs.core.next.call(null,args__$1);
if(xs){
var G__31972 = xs;
args__$1 = G__31972;
continue;
} else {
return v;
}
} else {
return v;
}
} else {
return true;
}
break;
}
});
/**
 * The or macro from clojure.core. Note: or is unrolled in the analyzer, this is a fallback.
 */
sci.impl.evaluator.eval_or = (function sci$impl$evaluator$eval_or(ctx,bindings,args){
var args__$1 = cljs.core.seq.call(null,args);
while(true){
if(args__$1){
var x = cljs.core.first.call(null,args__$1);
var v = sci.impl.types.eval.call(null,x,ctx,bindings);
var or__5045__auto__ = v;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var G__31973 = cljs.core.next.call(null,args__$1);
args__$1 = G__31973;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * The let macro from clojure.core
 */
sci.impl.evaluator.eval_let = (function sci$impl$evaluator$eval_let(ctx,bindings,let_bindings,exprs,idxs){
var vec__31974 = (function (){var ctx__$1 = ctx;
var bindings__$1 = bindings;
var let_bindings__$1 = let_bindings;
var idx = (0);
while(true){
var let_name = cljs.core.first.call(null,let_bindings__$1);
if(cljs.core.truth_(let_name)){
var let_bindings__$2 = cljs.core.rest.call(null,let_bindings__$1);
var let_val = cljs.core.first.call(null,let_bindings__$2);
var rest_let_bindings = cljs.core.next.call(null,let_bindings__$2);
var v = sci.impl.types.eval.call(null,let_val,ctx__$1,bindings__$1);
(bindings__$1[cljs.core.nth.call(null,idxs,idx)] = v);

var G__31977 = ctx__$1;
var G__31978 = bindings__$1;
var G__31979 = rest_let_bindings;
var G__31980 = (idx + (1));
ctx__$1 = G__31977;
bindings__$1 = G__31978;
let_bindings__$1 = G__31979;
idx = G__31980;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ctx__$1,bindings__$1], null);
}
break;
}
})();
var ctx__$1 = cljs.core.nth.call(null,vec__31974,(0),null);
var bindings__$1 = cljs.core.nth.call(null,vec__31974,(1),null);
return sci.impl.types.eval.call(null,exprs,ctx__$1,bindings__$1);
});
sci.impl.evaluator.eval_def = (function sci$impl$evaluator$eval_def(ctx,bindings,var_name,init,m){
var init__$1 = sci.impl.types.eval.call(null,init,ctx,bindings);
var m__$1 = sci.impl.types.eval.call(null,m,ctx,bindings);
var cnn = sci.impl.types.getName.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m__$1));
var assoc_in_env = (function (env){
var the_current_ns = cljs.core.get.call(null,cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)),cnn);
var prev = cljs.core.get.call(null,the_current_ns,var_name);
var prev__$1 = (((!(sci.impl.utils.var_QMARK_.call(null,prev))))?(new sci.lang.Var(prev,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnn),cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_name)),cljs.core.meta.call(null,prev),false,false)):prev);
var v = (((sci.impl.utils.var_unbound === init__$1))?(function (){var G__31981 = prev__$1;
cljs.core.alter_meta_BANG_.call(null,G__31981,cljs.core.merge,m__$1);

return G__31981;
})():(function (){
sci.impl.vars.bindRoot.call(null,prev__$1,init__$1);

cljs.core.alter_meta_BANG_.call(null,prev__$1,cljs.core.merge,m__$1);

return prev__$1;
})()
);
var the_current_ns__$1 = cljs.core.assoc.call(null,the_current_ns,var_name,v);
return cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});
var env = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),assoc_in_env);
return cljs.core.get.call(null,cljs.core.get.call(null,cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)),cnn),var_name);
});
var ret__5824__auto___31982 = sci.impl.evaluator.resolve_symbol = (function sci$impl$evaluator$resolve_symbol(_AMPERSAND_form,_AMPERSAND_env,bindings,sym){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,".get",".get",1446963300,null),null,(1),null)),(new cljs.core.List(null,cljs.core.with_meta.call(null,bindings,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"java.util.Map","java.util.Map",981564201,null)], null)),null,(1),null)),(new cljs.core.List(null,sym,null,(1),null)))));
});
(sci.impl.evaluator.resolve_symbol.cljs$lang$macro = true);

sci.impl.evaluator.eval_case = (function sci$impl$evaluator$eval_case(var_args){
var G__31984 = arguments.length;
switch (G__31984) {
case 4:
return sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$4 = (function (ctx,bindings,case_map,case_val){
var v = sci.impl.types.eval.call(null,case_val,ctx,bindings);
var temp__5802__auto__ = cljs.core.find.call(null,case_map,v);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__31985 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__31985,(0),null);
var found = cljs.core.nth.call(null,vec__31985,(1),null);
return sci.impl.types.eval.call(null,found,ctx,bindings);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')));
}
}));

(sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$5 = (function (ctx,bindings,case_map,case_val,case_default){
var v = sci.impl.types.eval.call(null,case_val,ctx,bindings);
var temp__5802__auto__ = cljs.core.find.call(null,case_map,v);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__31988 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__31988,(0),null);
var found = cljs.core.nth.call(null,vec__31988,(1),null);
return sci.impl.types.eval.call(null,found,ctx,bindings);
} else {
return sci.impl.types.eval.call(null,case_default,ctx,bindings);
}
}));

(sci.impl.evaluator.eval_case.cljs$lang$maxFixedArity = 5);

sci.impl.evaluator.eval_try = (function sci$impl$evaluator$eval_try(ctx,bindings,body,catches,finally$,sci_error){
try{var _STAR_in_try_STAR__orig_val__31996 = sci.impl.utils._STAR_in_try_STAR_;
var _STAR_in_try_STAR__temp_val__31997 = (function (){var or__5045__auto__ = ((cljs.core.not.call(null,sci_error)) && (cljs.core.seq.call(null,catches)));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return sci.impl.utils._STAR_in_try_STAR_;
}
})();
(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__temp_val__31997);

try{return sci.impl.types.eval.call(null,body,ctx,bindings);
}finally {(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__orig_val__31996);
}}catch (e31992){var e = e31992;
var temp__5802__auto__ = cljs.core.reduce.call(null,(function (_,c){
var clazz = new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(c);
if(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.keyword_identical_QMARK_.call(null,new cljs.core.Keyword(null,"default","default",-1987822328),clazz);
if(or__5045__auto__){
return or__5045__auto__;
} else {
if((clazz instanceof sci.impl.types.NodeR)){
var c__5078__auto__ = sci.impl.types.eval.call(null,clazz,ctx,bindings);
var x__5079__auto__ = e;
return (x__5079__auto__ instanceof c__5078__auto__);
} else {
return (e instanceof clazz);
}
}
})())){
return cljs.core.reduced.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sci.impl.evaluator","try-result","sci.impl.evaluator/try-result",-1394897780),(function (){
(bindings[new cljs.core.Keyword(null,"ex-idx","ex-idx",795118805).cljs$core$IFn$_invoke$arity$1(c)] = e);

return sci.impl.types.eval.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(c),ctx,bindings);
})()
], null));
} else {
return null;
}
}),null,catches);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__31993 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__31993,(0),null);
var r = cljs.core.nth.call(null,vec__31993,(1),null);
return r;
} else {
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e,body);
}
}finally {sci.impl.types.eval.call(null,finally$,ctx,bindings);
}});
sci.impl.evaluator.eval_static_method_invocation = (function sci$impl$evaluator$eval_static_method_invocation(ctx,bindings,expr){
return sci.impl.interop.invoke_static_method.call(null,cljs.core.first.call(null,expr),cljs.core.map.call(null,(function (p1__31998_SHARP_){
return sci.impl.types.eval.call(null,p1__31998_SHARP_,ctx,bindings);
}),cljs.core.rest.call(null,expr)));
});
sci.impl.evaluator.eval_instance_method_invocation = (function sci$impl$evaluator$eval_instance_method_invocation(ctx,bindings,instance_expr,method_str,field_access,args,allowed){
var instance_meta = cljs.core.meta.call(null,instance_expr);
var tag_class = new cljs.core.Keyword(null,"tag-class","tag-class",714967874).cljs$core$IFn$_invoke$arity$1(instance_meta);
var instance_expr_STAR_ = sci.impl.types.eval.call(null,instance_expr,ctx,bindings);
if((instance_expr_STAR_ instanceof sci.impl.records.SciRecord)){
return cljs.core.get.call(null,instance_expr_STAR_,cljs.core.keyword.call(null,method_str));
} else {
if((instance_expr_STAR_ instanceof sci.impl.deftype.SciType)){
return cljs.core.get.call(null,sci.impl.types.getVal.call(null,instance_expr_STAR_),cljs.core.symbol.call(null,method_str));
} else {
var instance_class = (function (){var or__5045__auto__ = tag_class;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.type.call(null,instance_expr_STAR_);
}
})();
var env = cljs.core.deref.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx));
var class__GT_opts = new cljs.core.Keyword(null,"class->opts","class->opts",2061906477).cljs$core$IFn$_invoke$arity$1(env);
var allowed_QMARK_ = (function (){var or__5045__auto__ = allowed;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.call(null,class__GT_opts,new cljs.core.Keyword(null,"allow","allow",-1857325745));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = (function (){var instance_class_name = instance_class.name;
var instance_class_symbol = cljs.core.symbol.call(null,instance_class_name);
return cljs.core.get.call(null,class__GT_opts,instance_class_symbol);
})();
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return console.log(cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str));
}
}
}
})();
var target_class = (cljs.core.truth_(allowed_QMARK_)?instance_class:(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"public-class","public-class",1127293019).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_(temp__5804__auto__)){
var f = temp__5804__auto__;
return f.call(null,instance_expr_STAR_);
} else {
return null;
}
})());
if(cljs.core.truth_(allowed_QMARK_)){
} else {
sci.impl.utils.throw_error_with_location.call(null,["Method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str)," on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance_class)," not allowed!"].join(''),instance_expr);
}

if(cljs.core.truth_(field_access)){
return sci.impl.interop.invoke_instance_field.call(null,instance_expr_STAR_,target_class,method_str);
} else {
var args__$1 = cljs.core.map.call(null,(function (p1__32000_SHARP_){
return sci.impl.types.eval.call(null,p1__32000_SHARP_,ctx,bindings);
}),args);
return sci.impl.interop.invoke_instance_method.call(null,instance_expr_STAR_,target_class,method_str,args__$1);
}
}
}
});
sci.impl.evaluator.eval_resolve = (function sci$impl$evaluator$eval_resolve(var_args){
var G__32002 = arguments.length;
switch (G__32002) {
case 3:
return sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$3 = (function (ctx,bindings,sym){
return sci.impl.evaluator.eval_resolve.call(null,ctx,bindings,null,sym);
}));

(sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$4 = (function (ctx,bindings,env,sym){
if(((cljs.core.not.call(null,env)) || ((!(cljs.core.contains_QMARK_.call(null,env,sym)))))){
var sym__$1 = sci.impl.types.eval.call(null,sym,ctx,bindings);
var res = cljs.core.second.call(null,cljs.core.deref.call(null,sci.impl.utils.lookup).call(null,ctx,sym__$1,false));
if((res instanceof sci.impl.types.NodeR)){
return null;
} else {
return res;
}
} else {
return null;
}
}));

(sci.impl.evaluator.eval_resolve.cljs$lang$maxFixedArity = 4);

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_resolve_state,sci.impl.evaluator.eval_resolve);
sci.impl.evaluator.eval_import = (function sci$impl$evaluator$eval_import(var_args){
var args__5775__auto__ = [];
var len__5769__auto___32010 = arguments.length;
var i__5770__auto___32011 = (0);
while(true){
if((i__5770__auto___32011 < len__5769__auto___32010)){
args__5775__auto__.push((arguments[i__5770__auto___32011]));

var G__32012 = (i__5770__auto___32011 + (1));
i__5770__auto___32011 = G__32012;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return sci.impl.evaluator.eval_import.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(sci.impl.evaluator.eval_import.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,import_symbols_or_lists){
var specs = cljs.core.map.call(null,(function (p1__32004_SHARP_){
if(((cljs.core.seq_QMARK_.call(null,p1__32004_SHARP_)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,p1__32004_SHARP_))))){
return cljs.core.second.call(null,p1__32004_SHARP_);
} else {
return p1__32004_SHARP_;
}
}),import_symbols_or_lists);
var env = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
return cljs.core.reduce.call(null,(function (_,spec){
var vec__32007 = (((spec instanceof cljs.core.Symbol))?(function (){var s = cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec);
var last_dot = clojure.string.last_index_of.call(null,s,".");
var package_PLUS_class_name = (cljs.core.truth_(last_dot)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,cljs.core.subs.call(null,s,(0),last_dot)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,cljs.core.subs.call(null,s,(last_dot + (1)),((s).length)))], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec], null)], null));
return package_PLUS_class_name;
})():(function (){var p = cljs.core.first.call(null,spec);
var cs = cljs.core.rest.call(null,spec);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cs], null);
})());
var package$ = cljs.core.nth.call(null,vec__32007,(0),null);
var classes = cljs.core.nth.call(null,vec__32007,(1),null);
return cljs.core.reduce.call(null,(function (___$1,class$){
var fq_class_name = cljs.core.symbol.call(null,(cljs.core.truth_(package$)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(package$),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)].join(''):class$));
var temp__5802__auto__ = sci.impl.interop.resolve_class.call(null,ctx,fq_class_name);
if(cljs.core.truth_(temp__5802__auto__)){
var clazz = temp__5802__auto__;
var cnn = sci.impl.utils.current_ns_name.call(null);
cljs.core.swap_BANG_.call(null,env,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"imports","imports",-1249933394),class$], null),fq_class_name);

return clazz;
} else {
var temp__5802__auto____$1 = (function (){var rec_ns = cljs.core.symbol.call(null,sci.impl.utils.demunge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(package$)));
var rec_var = cljs.core.get_in.call(null,cljs.core.deref.call(null,env),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),rec_ns,class$], null));
return rec_var;
})();
if(cljs.core.truth_(temp__5802__auto____$1)){
var rec_var = temp__5802__auto____$1;
var cnn = sci.impl.utils.current_ns_name.call(null);
cljs.core.swap_BANG_.call(null,env,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"refers","refers",158076809),class$], null),rec_var);

return cljs.core.deref.call(null,rec_var);
} else {
throw (new Error(["Unable to resolve classname: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fq_class_name)].join('')));
}
}
}),null,classes);
}),null,specs);
}));

(sci.impl.evaluator.eval_import.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.evaluator.eval_import.cljs$lang$applyTo = (function (seq32005){
var G__32006 = cljs.core.first.call(null,seq32005);
var seq32005__$1 = cljs.core.next.call(null,seq32005);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32006,seq32005__$1);
}));

/**
 * Note: various arities of do have already been unrolled in the analyzer.
 */
sci.impl.evaluator.eval_do = (function sci$impl$evaluator$eval_do(ctx,bindings,exprs){
var exprs__$1 = cljs.core.seq.call(null,exprs);
var exprs__$2 = exprs__$1;
while(true){
if(exprs__$2){
var ret = sci.impl.types.eval.call(null,cljs.core.first.call(null,exprs__$2),ctx,bindings);
var temp__5802__auto__ = cljs.core.next.call(null,exprs__$2);
if(temp__5802__auto__){
var exprs__$3 = temp__5802__auto__;
var G__32013 = exprs__$3;
exprs__$2 = G__32013;
continue;
} else {
return ret;
}
} else {
return null;
}
break;
}
});
cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_do_STAR_,sci.impl.evaluator.eval_do);
sci.impl.evaluator.fn_call = (function sci$impl$evaluator$fn_call(ctx,bindings,f,args){
var G__32208 = cljs.core.count.call(null,args);
switch (G__32208) {
case (0):
return f.call(null);

break;
case (1):
var arg32018 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
return f.call(null,arg32018);

break;
case (2):
var arg32019 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32020 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
return f.call(null,arg32019,arg32020);

break;
case (3):
var arg32021 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32022 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32023 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
return f.call(null,arg32021,arg32022,arg32023);

break;
case (4):
var arg32024 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32025 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32026 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32027 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
return f.call(null,arg32024,arg32025,arg32026,arg32027);

break;
case (5):
var arg32028 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32029 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32030 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32031 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32032 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
return f.call(null,arg32028,arg32029,arg32030,arg32031,arg32032);

break;
case (6):
var arg32033 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32034 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32035 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32036 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32037 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32038 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
return f.call(null,arg32033,arg32034,arg32035,arg32036,arg32037,arg32038);

break;
case (7):
var arg32039 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32040 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32041 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32042 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32043 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32044 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32045 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
return f.call(null,arg32039,arg32040,arg32041,arg32042,arg32043,arg32044,arg32045);

break;
case (8):
var arg32046 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32047 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32048 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32049 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32050 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32051 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32052 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32053 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
return f.call(null,arg32046,arg32047,arg32048,arg32049,arg32050,arg32051,arg32052,arg32053);

break;
case (9):
var arg32054 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32055 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32056 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32057 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32058 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32059 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32060 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32061 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32062 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
return f.call(null,arg32054,arg32055,arg32056,arg32057,arg32058,arg32059,arg32060,arg32061,arg32062);

break;
case (10):
var arg32063 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32064 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32065 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32066 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32067 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32068 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32069 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32070 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32071 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg32072 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
return f.call(null,arg32063,arg32064,arg32065,arg32066,arg32067,arg32068,arg32069,arg32070,arg32071,arg32072);

break;
case (11):
var arg32073 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32074 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32075 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32076 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32077 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32078 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32079 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32080 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32081 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg32082 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg32083 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
return f.call(null,arg32073,arg32074,arg32075,arg32076,arg32077,arg32078,arg32079,arg32080,arg32081,arg32082,arg32083);

break;
case (12):
var arg32084 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32085 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32086 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32087 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32088 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32089 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32090 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32091 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32092 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg32093 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg32094 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg32095 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
return f.call(null,arg32084,arg32085,arg32086,arg32087,arg32088,arg32089,arg32090,arg32091,arg32092,arg32093,arg32094,arg32095);

break;
case (13):
var arg32096 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32097 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32098 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32099 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32100 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32101 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32102 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32103 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32104 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg32105 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg32106 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg32107 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg32108 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
return f.call(null,arg32096,arg32097,arg32098,arg32099,arg32100,arg32101,arg32102,arg32103,arg32104,arg32105,arg32106,arg32107,arg32108);

break;
case (14):
var arg32109 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32110 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32111 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32112 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32113 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32114 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32115 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32116 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32117 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg32118 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg32119 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg32120 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg32121 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg32122 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
return f.call(null,arg32109,arg32110,arg32111,arg32112,arg32113,arg32114,arg32115,arg32116,arg32117,arg32118,arg32119,arg32120,arg32121,arg32122);

break;
case (15):
var arg32123 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32124 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32125 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32126 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32127 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32128 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32129 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32130 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32131 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg32132 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg32133 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg32134 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg32135 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg32136 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg32137 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
return f.call(null,arg32123,arg32124,arg32125,arg32126,arg32127,arg32128,arg32129,arg32130,arg32131,arg32132,arg32133,arg32134,arg32135,arg32136,arg32137);

break;
case (16):
var arg32138 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32139 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32140 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32141 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32142 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32143 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32144 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32145 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32146 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg32147 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg32148 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg32149 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg32150 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg32151 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg32152 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg32153 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
return f.call(null,arg32138,arg32139,arg32140,arg32141,arg32142,arg32143,arg32144,arg32145,arg32146,arg32147,arg32148,arg32149,arg32150,arg32151,arg32152,arg32153);

break;
case (17):
var arg32154 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32155 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32156 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32157 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32158 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32159 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32160 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32161 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32162 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg32163 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg32164 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg32165 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg32166 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg32167 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg32168 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg32169 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg32170 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
return f.call(null,arg32154,arg32155,arg32156,arg32157,arg32158,arg32159,arg32160,arg32161,arg32162,arg32163,arg32164,arg32165,arg32166,arg32167,arg32168,arg32169,arg32170);

break;
case (18):
var arg32171 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32172 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32173 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32174 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32175 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32176 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32177 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32178 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32179 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg32180 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg32181 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg32182 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg32183 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg32184 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg32185 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg32186 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg32187 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
var arg32188 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$17),ctx,bindings);
var args__$18 = cljs.core.rest.call(null,args__$17);
return f.call(null,arg32171,arg32172,arg32173,arg32174,arg32175,arg32176,arg32177,arg32178,arg32179,arg32180,arg32181,arg32182,arg32183,arg32184,arg32185,arg32186,arg32187,arg32188);

break;
case (19):
var arg32189 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg32190 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg32191 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg32192 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg32193 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg32194 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg32195 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg32196 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg32197 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg32198 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg32199 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg32200 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg32201 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg32202 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg32203 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg32204 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg32205 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
var arg32206 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$17),ctx,bindings);
var args__$18 = cljs.core.rest.call(null,args__$17);
var arg32207 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$18),ctx,bindings);
var args__$19 = cljs.core.rest.call(null,args__$18);
return f.call(null,arg32189,arg32190,arg32191,arg32192,arg32193,arg32194,arg32195,arg32196,arg32197,arg32198,arg32199,arg32200,arg32201,arg32202,arg32203,arg32204,arg32205,arg32206,arg32207);

break;
default:
var args__$1 = cljs.core.mapv.call(null,(function (p1__31728_SHARP_){
return sci.impl.types.eval.call(null,p1__31728_SHARP_,ctx,bindings);
}),args);
return cljs.core.apply.call(null,f,args__$1);

}
});
