// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('sci.impl.records');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('sci.impl.protocols');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');
goog.require('sci.lang');
if((typeof sci !== 'undefined') && (typeof sci.impl !== 'undefined') && (typeof sci.impl.records !== 'undefined') && (typeof sci.impl.records.to_string !== 'undefined')){
} else {
sci.impl.records.to_string = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"sci.impl.records","to-string"),sci.impl.types.type_impl,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.core._add_method.call(null,sci.impl.records.to_string,new cljs.core.Keyword(null,"default","default",-1987822328),(function (this$){
var t = sci.impl.types.type_impl.call(null,this$);
return [cljs.core.namespace.call(null,t),".",cljs.core.name.call(null,t),"@",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.hash.call(null,this$).toString((16)))].join('');
}));
sci.impl.records.clojure_str = (function sci$impl$records$clojure_str(v){
var t = sci.impl.types.type_impl.call(null,v);
return ["#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(t),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,v))].join('');
});

/**
 * @interface
 */
sci.impl.records.SciPrintMethod = function(){};

var sci$impl$records$SciPrintMethod$_sci_print_method$dyn_29751 = (function (x,w){
var x__5393__auto__ = (((x == null))?null:x);
var m__5394__auto__ = (sci.impl.records._sci_print_method[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,x,w);
} else {
var m__5392__auto__ = (sci.impl.records._sci_print_method["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,x,w);
} else {
throw cljs.core.missing_protocol.call(null,"SciPrintMethod.-sci-print-method",x);
}
}
});
sci.impl.records._sci_print_method = (function sci$impl$records$_sci_print_method(x,w){
if((((!((x == null)))) && ((!((x.sci$impl$records$SciPrintMethod$_sci_print_method$arity$2 == null)))))){
return x.sci$impl$records$SciPrintMethod$_sci_print_method$arity$2(x,w);
} else {
return sci$impl$records$SciPrintMethod$_sci_print_method$dyn_29751.call(null,x,w);
}
});

/**
 * TODO: now that we are using our own record implementation, we can move away from metadata.
 */
sci.impl.records.preserve_own_meta = (function sci$impl$records$preserve_own_meta(m,old_meta){
if(cljs.core.truth_(new cljs.core.Keyword("sci.impl","record","sci.impl/record",-1939193950).cljs$core$IFn$_invoke$arity$1(m))){
return m;
} else {
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(old_meta),new cljs.core.Keyword("sci.impl","record","sci.impl/record",-1939193950),new cljs.core.Keyword("sci.impl","record","sci.impl/record",-1939193950).cljs$core$IFn$_invoke$arity$1(old_meta),new cljs.core.Keyword("sci.impl","constructor","sci.impl/constructor",1320345666),new cljs.core.Keyword("sci.impl","constructor","sci.impl/constructor",1320345666).cljs$core$IFn$_invoke$arity$1(old_meta),new cljs.core.Keyword("sci.impl","var","sci.impl/var",-2041185552),new cljs.core.Keyword("sci.imp","record-var","sci.imp/record-var",1157861212).cljs$core$IFn$_invoke$arity$1(old_meta),new cljs.core.Keyword("sci.impl.record","map-constructor","sci.impl.record/map-constructor",1072184780),new cljs.core.Keyword("sci.impl.record","map-constructor","sci.impl.record/map-constructor",1072184780).cljs$core$IFn$_invoke$arity$1(old_meta));
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {sci.impl.records.Object}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
sci.impl.records.SciRecord = (function (rec_name,var$,ext_map,my_hash){
this.rec_name = rec_name;
this.var$ = var$;
this.ext_map = ext_map;
this.my_hash = my_hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(sci.impl.records.SciRecord.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return sci.impl.records.to_string.call(null,this$);
}));

(sci.impl.records.SciRecord.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return cljs.core._lookup.call(null,self__.ext_map,k);
}));

(sci.impl.records.SciRecord.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (_,k,else$){
var self__ = this;
var ___$1 = this;
return cljs.core._lookup.call(null,self__.ext_map,k,else$);
}));

(sci.impl.records.SciRecord.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this$,f,init){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.call(null,(function (ret,p__29752){
var vec__29753 = p__29752;
var k = cljs.core.nth.call(null,vec__29753,(0),null);
var v = cljs.core.nth.call(null,vec__29753,(1),null);
return f.call(null,ret,k,v);
}),init,this$__$1);
}));

(sci.impl.records.SciRecord.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,w,opts){
var self__ = this;
var this$__$1 = this;
var temp__5802__auto__ = self__.var$;
if(cljs.core.truth_(temp__5802__auto__)){
var rv = temp__5802__auto__;
var m = cljs.core.meta.call(null,rv);
var temp__5802__auto____$1 = new cljs.core.Keyword("sci.impl","print-method","sci.impl/print-method",281191566).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5802__auto____$1)){
var pm = temp__5802__auto____$1;
return pm.call(null,this$__$1,w,opts);
} else {
return cljs.core.write_all.call(null,w,sci.impl.records.clojure_str.call(null,this$__$1));
}
} else {
return cljs.core.write_all.call(null,w,sci.impl.records.clojure_str.call(null,this$__$1));
}
}));

(sci.impl.records.SciRecord.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core._iterator.call(null,self__.ext_map);
}));

(sci.impl.records.SciRecord.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.meta.call(null,self__.ext_map);
}));

(sci.impl.records.SciRecord.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new sci.impl.records.SciRecord(self__.rec_name,self__.var$,self__.ext_map,self__.my_hash));
}));

(sci.impl.records.SciRecord.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.count.call(null,self__.ext_map);
}));

(sci.impl.records.SciRecord.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var hq = self__.my_hash;
if((!((hq == null)))){
var type_hash = cljs.core.hash.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge.call(null,self__.rec_name)));
var h = (type_hash ^ cljs.core.hash_unordered_coll.call(null,self__.ext_map));
(self__.my_hash = h);

return h;
} else {
return hq;
}
}));

(sci.impl.records.SciRecord.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return (((!((other == null)))) && ((((this$__$1.constructor === other.constructor)) && (((cljs.core._EQ_.call(null,self__.rec_name,other.rec_name)) && (cljs.core._EQ_.call(null,this$__$1.ext_map,other.ext_map)))))));
}));

(sci.impl.records.SciRecord.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (new sci.impl.records.SciRecord(self__.rec_name,self__.var$,cljs.core.dissoc.call(null,self__.ext_map,k),null));
}));

(sci.impl.records.SciRecord.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return cljs.core._contains_key_QMARK_.call(null,self__.ext_map,k);
}));

(sci.impl.records.SciRecord.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (_,k,v){
var self__ = this;
var ___$1 = this;
return (new sci.impl.records.SciRecord(self__.rec_name,self__.var$,cljs.core.assoc.call(null,self__.ext_map,k,v),null));
}));

(sci.impl.records.SciRecord.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core._seq.call(null,self__.ext_map);
}));

(sci.impl.records.SciRecord.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return (new sci.impl.records.SciRecord(self__.rec_name,self__.var$,cljs.core.with_meta.call(null,self__.ext_map,sci.impl.records.preserve_own_meta.call(null,m,cljs.core.meta.call(null,self__.ext_map))),self__.my_hash));
}));

(sci.impl.records.SciRecord.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,this$__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this$__$1,entry);
}
}));

(sci.impl.records.SciRecord.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"rec-name","rec-name",407587896,null),new cljs.core.Symbol(null,"var","var",870848730,null),new cljs.core.Symbol(null,"ext-map","ext-map",-1560591553,null),cljs.core.with_meta(new cljs.core.Symbol(null,"my_hash","my_hash",-1166068909,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(sci.impl.records.SciRecord.cljs$lang$type = true);

(sci.impl.records.SciRecord.cljs$lang$ctorStr = "sci.impl.records/SciRecord");

(sci.impl.records.SciRecord.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"sci.impl.records/SciRecord");
}));

/**
 * Positional factory function for sci.impl.records/SciRecord.
 */
sci.impl.records.__GT_SciRecord = (function sci$impl$records$__GT_SciRecord(rec_name,var$,ext_map,my_hash){
return (new sci.impl.records.SciRecord(rec_name,var$,ext_map,my_hash));
});

sci.impl.records.__GT_record_impl = (function sci$impl$records$__GT_record_impl(rec_name,var$,m){
return (new sci.impl.records.SciRecord(rec_name,var$,m,null));
});
sci.impl.records.defrecord = (function sci$impl$records$defrecord(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29778 = arguments.length;
var i__5770__auto___29779 = (0);
while(true){
if((i__5770__auto___29779 < len__5769__auto___29778)){
args__5775__auto__.push((arguments[i__5770__auto___29779]));

var G__29780 = (i__5770__auto___29779 + (1));
i__5770__auto___29779 = G__29780;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((5) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((5)),(0),null)):null);
return sci.impl.records.defrecord.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5776__auto__);
});

(sci.impl.records.defrecord.cljs$core$IFn$_invoke$arity$variadic = (function (p__29766,_,ctx,record_name,fields,raw_protocol_impls){
var vec__29767 = p__29766;
var seq__29768 = cljs.core.seq.call(null,vec__29767);
var first__29769 = cljs.core.first.call(null,seq__29768);
var seq__29768__$1 = cljs.core.next.call(null,seq__29768);
var fname = first__29769;
var ___$1 = seq__29768__$1;
var form = vec__29767;
if(cljs.core.truth_(new cljs.core.Keyword("sci.impl","macroexpanding","sci.impl/macroexpanding",2113471825).cljs$core$IFn$_invoke$arity$1(ctx))){
return cljs.core.cons.call(null,new cljs.core.Symbol("clojure.core","defrecord","clojure.core/defrecord",581689476,null),cljs.core.rest.call(null,form));
} else {
var factory_fn_str = ["->",cljs.core.str.cljs$core$IFn$_invoke$arity$1(record_name)].join('');
var factory_fn_sym = cljs.core.symbol.call(null,factory_fn_str);
var map_factory_sym = cljs.core.symbol.call(null,["map",factory_fn_str].join(''));
var keys = cljs.core.mapv.call(null,cljs.core.keyword,fields);
var rec_type = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge.call(null,sci.impl.utils.current_ns_name.call(null))),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(record_name)].join(''));
var protocol_impls = sci.impl.utils.split_when.call(null,cljs.core.symbol_QMARK_,raw_protocol_impls);
var field_set = cljs.core.set.call(null,fields);
var protocol_impls__$1 = cljs.core.mapcat.call(null,(function (p__29770,expr){
var vec__29771 = p__29770;
var seq__29772 = cljs.core.seq.call(null,vec__29771);
var first__29773 = cljs.core.first.call(null,seq__29772);
var seq__29772__$1 = cljs.core.next.call(null,seq__29772);
var protocol_name = first__29773;
var impls = seq__29772__$1;
var impls__$1 = cljs.core.group_by.call(null,cljs.core.first,impls);
var protocol = cljs.core.deref.call(null,sci.impl.utils.eval_resolve_state).call(null,ctx,new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx),protocol_name);
var protocol__$1 = (function (){var or__5045__auto__ = protocol;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"Object","Object",61210754,null),protocol_name)){
return new cljs.core.Keyword("sci.impl.records","object","sci.impl.records/object",-590699738);
} else {
return null;
}
}
})();
var ___$2 = (cljs.core.truth_(protocol__$1)?null:sci.impl.utils.throw_error_with_location.call(null,["Protocol not found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_name)].join(''),expr));
var protocol__$2 = ((sci.impl.utils.var_QMARK_.call(null,protocol__$1))?cljs.core.deref.call(null,protocol__$1):protocol__$1);
var protocol_var = new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(protocol__$2);
var ___$3 = (cljs.core.truth_(protocol_var)?sci.impl.vars.alter_var_root.call(null,protocol_var,cljs.core.update,new cljs.core.Keyword(null,"satisfies","satisfies",-311664218),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),sci.impl.protocols.type__GT_str.call(null,rec_type)):null);
var protocol_ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(protocol__$2);
var pns = (cljs.core.truth_(protocol_ns)?cljs.core.str.cljs$core$IFn$_invoke$arity$1(sci.impl.types.getName.call(null,protocol_ns)):((cljs.core._EQ_.call(null,new cljs.core.Keyword("sci.impl.records","object","sci.impl.records/object",-590699738),protocol__$2))?"sci.impl.records":null));
var fq_meth_name = (function (p1__29756_SHARP_){
if(cljs.core.simple_symbol_QMARK_.call(null,p1__29756_SHARP_)){
return cljs.core.symbol.call(null,pns,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__29756_SHARP_));
} else {
return p1__29756_SHARP_;
}
});
return cljs.core.map.call(null,(function (p__29774){
var vec__29775 = p__29774;
var method_name = cljs.core.nth.call(null,vec__29775,(0),null);
var bodies = cljs.core.nth.call(null,vec__29775,(1),null);
var bodies__$1 = cljs.core.map.call(null,cljs.core.rest,bodies);
var bodies__$2 = cljs.core.mapv.call(null,(function (impl){
var args = cljs.core.first.call(null,impl);
var body = cljs.core.rest.call(null,impl);
var destr = sci.impl.utils.maybe_destructured.call(null,args,body);
var args__$1 = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(destr);
var body__$1 = new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(destr);
var orig_this_sym = cljs.core.first.call(null,args__$1);
var rest_args = cljs.core.rest.call(null,args__$1);
var shadows_this_QMARK_ = cljs.core.some.call(null,(function (p1__29757_SHARP_){
return cljs.core._EQ_.call(null,orig_this_sym,p1__29757_SHARP_);
}),rest_args);
var this_sym = (cljs.core.truth_(shadows_this_QMARK_)?cljs.core.gensym.call(null,"this_"):orig_this_sym);
var args__$2 = (cljs.core.truth_(shadows_this_QMARK_)?cljs.core.vec.call(null,cljs.core.cons.call(null,this_sym,rest_args)):args__$1);
var bindings = cljs.core.mapcat.call(null,(function (field){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [field,(new cljs.core.List(null,cljs.core.keyword.call(null,field),(new cljs.core.List(null,this_sym,null,(1),null)),(2),null))], null);
}),cljs.core.reduce.call(null,cljs.core.disj,field_set,args__$2));
var bindings__$1 = (cljs.core.truth_(shadows_this_QMARK_)?cljs.core.concat.call(null,bindings,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [orig_this_sym,this_sym], null)):bindings);
var bindings__$2 = cljs.core.vec.call(null,bindings__$1);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,args__$2,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,bindings__$2,null,(1),null)),body__$1))),null,(1),null)))));
}),bodies__$1);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","defmethod","cljs.core/defmethod",-180785162,null),null,(1),null)),(new cljs.core.List(null,fq_meth_name.call(null,method_name),null,(1),null)),(new cljs.core.List(null,rec_type,null,(1),null)),bodies__$2)));
}),impls__$1);
}),protocol_impls,raw_protocol_impls);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"do","do",1686842252,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","declare","cljs.core/declare",1312638100,null),null,(1),null)),(new cljs.core.List(null,record_name,null,(1),null)),(new cljs.core.List(null,factory_fn_sym,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","declare","cljs.core/declare",1312638100,null),null,(1),null)),(new cljs.core.List(null,map_factory_sym,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"def","def",597100991,null),null,(1),null)),(new cljs.core.List(null,cljs.core.with_meta.call(null,record_name,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("sci","record","sci/record",-778731026),true], null)),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.records","-create-record-type","sci.impl.records/-create-record-type",558578550,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("sci.impl","type-name","sci.impl/type-name",-1528979388),(new cljs.core.List(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),(new cljs.core.List(null,rec_type,null,(1),null)),(2),null)),new cljs.core.Keyword("sci.impl","record","sci.impl/record",-1939193950),true,new cljs.core.Keyword("sci.impl","constructor","sci.impl/constructor",1320345666),(new cljs.core.List(null,new cljs.core.Symbol(null,"var","var",870848730,null),(new cljs.core.List(null,factory_fn_sym,null,(1),null)),(2),null)),new cljs.core.Keyword("sci.impl","var","sci.impl/var",-2041185552),(new cljs.core.List(null,new cljs.core.Symbol(null,"var","var",870848730,null),(new cljs.core.List(null,record_name,null,(1),null)),(2),null)),new cljs.core.Keyword("sci.impl.record","map-constructor","sci.impl.record/map-constructor",1072184780),(new cljs.core.List(null,new cljs.core.Symbol(null,"var","var",870848730,null),(new cljs.core.List(null,map_factory_sym,null,(1),null)),(2),null))], null),null,(1),null))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","defn","cljs.core/defn",-1606493717,null),null,(1),null)),(new cljs.core.List(null,factory_fn_sym,null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"&","&",-2144855648,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"args__29758__auto__","args__29758__auto__",-894663836,null),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","vary-meta","cljs.core/vary-meta",-938366546,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.records","->record-impl","sci.impl.records/->record-impl",-1005013370,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),null,(1),null)),(new cljs.core.List(null,rec_type,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"var","var",870848730,null),null,(1),null)),(new cljs.core.List(null,record_name,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","zipmap","cljs.core/zipmap",-1902130674,null),null,(1),null)),(new cljs.core.List(null,keys,null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"args__29758__auto__","args__29758__auto__",-894663836,null),null,(1),null))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","assoc","cljs.core/assoc",322326297,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword("sci.impl","record","sci.impl/record",-1939193950),null,(1),null)),(new cljs.core.List(null,true,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"type","type",1174270348),null,(1),null)),(new cljs.core.List(null,rec_type,null,(1),null))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","defn","cljs.core/defn",-1606493717,null),null,(1),null)),(new cljs.core.List(null,map_factory_sym,null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"m__29759__auto__","m__29759__auto__",-965748243,null),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","vary-meta","cljs.core/vary-meta",-938366546,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.records","->record-impl","sci.impl.records/->record-impl",-1005013370,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),null,(1),null)),(new cljs.core.List(null,rec_type,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"var","var",870848730,null),null,(1),null)),(new cljs.core.List(null,record_name,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"m__29759__auto__","m__29759__auto__",-965748243,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","assoc","cljs.core/assoc",322326297,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword("sci.impl","record","sci.impl/record",-1939193950),null,(1),null)),(new cljs.core.List(null,true,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"type","type",1174270348),null,(1),null)),(new cljs.core.List(null,rec_type,null,(1),null))))),null,(1),null))))),null,(1),null)),protocol_impls__$1,(new cljs.core.List(null,record_name,null,(1),null)))));
}
}));

(sci.impl.records.defrecord.cljs$lang$maxFixedArity = (5));

/** @this {Function} */
(sci.impl.records.defrecord.cljs$lang$applyTo = (function (seq29760){
var G__29761 = cljs.core.first.call(null,seq29760);
var seq29760__$1 = cljs.core.next.call(null,seq29760);
var G__29762 = cljs.core.first.call(null,seq29760__$1);
var seq29760__$2 = cljs.core.next.call(null,seq29760__$1);
var G__29763 = cljs.core.first.call(null,seq29760__$2);
var seq29760__$3 = cljs.core.next.call(null,seq29760__$2);
var G__29764 = cljs.core.first.call(null,seq29760__$3);
var seq29760__$4 = cljs.core.next.call(null,seq29760__$3);
var G__29765 = cljs.core.first.call(null,seq29760__$4);
var seq29760__$5 = cljs.core.next.call(null,seq29760__$4);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29761,G__29762,G__29763,G__29764,G__29765,seq29760__$5);
}));

sci.impl.records.sci_record_QMARK_ = (function sci$impl$records$sci_record_QMARK_(x){
var or__5045__auto__ = ((cljs.core.map_QMARK_.call(null,x))?(function (){var G__29781 = x;
var G__29781__$1 = (((G__29781 == null))?null:cljs.core.meta.call(null,G__29781));
if((G__29781__$1 == null)){
return null;
} else {
return new cljs.core.Keyword("sci.impl","record","sci.impl/record",-1939193950).cljs$core$IFn$_invoke$arity$1(G__29781__$1);
}
})():null);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.record_QMARK_.call(null,x);
}
});
/**
 * A record class is represented by a symbol with metadata (currently). This is only an implementation detail.
 * A protocol is represented by a map with :ns, :methods and optionally :class. This is also an implementation detail.
 */
sci.impl.records.resolve_record_or_protocol_class = (function sci$impl$records$resolve_record_or_protocol_class(var_args){
var G__29783 = arguments.length;
switch (G__29783) {
case 2:
return sci.impl.records.resolve_record_or_protocol_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sci.impl.records.resolve_record_or_protocol_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.records.resolve_record_or_protocol_class.cljs$core$IFn$_invoke$arity$2 = (function (ctx,sym){
var sym_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym);
var last_dot = clojure.string.last_index_of.call(null,sym_str,".");
var class_name = (cljs.core.truth_(last_dot)?cljs.core.subs.call(null,sym_str,(last_dot + (1)),((sym_str).length)):sym_str);
var namespace = (cljs.core.truth_(last_dot)?cljs.core.symbol.call(null,cljs.core.subs.call(null,sym_str,(0),last_dot)):sci.impl.utils.current_ns_name.call(null));
return sci.impl.records.resolve_record_or_protocol_class.call(null,ctx,namespace,cljs.core.symbol.call(null,class_name));
}));

(sci.impl.records.resolve_record_or_protocol_class.cljs$core$IFn$_invoke$arity$3 = (function (ctx,package$,class$){
var namespace = cljs.core.symbol.call(null,clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(package$),"_","-"));
var temp__5804__auto__ = (function (){var ns = cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),namespace], null));
var or__5045__auto__ = cljs.core.get.call(null,ns,class$);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(ns),class$);
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var sci_var = temp__5804__auto__;
if(sci.impl.utils.var_QMARK_.call(null,sci_var)){
return cljs.core.deref.call(null,sci_var);
} else {
return sci_var;
}
} else {
return null;
}
}));

(sci.impl.records.resolve_record_or_protocol_class.cljs$lang$maxFixedArity = 3);

sci.impl.records.resolve_record_class = (function sci$impl$records$resolve_record_class(ctx,class_sym){
var temp__5804__auto__ = sci.impl.records.resolve_record_or_protocol_class.call(null,ctx,class_sym);
if(cljs.core.truth_(temp__5804__auto__)){
var x = temp__5804__auto__;
if((x instanceof sci.lang.Type)){
return x;
} else {
return null;
}
} else {
return null;
}
});
