// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__70750 = arguments.length;
switch (G__70750) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___70789 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70771){
var state_val_70772 = (state_70771[(1)]);
if((state_val_70772 === (1))){
var state_70771__$1 = state_70771;
var statearr_70773_70790 = state_70771__$1;
(statearr_70773_70790[(2)] = null);

(statearr_70773_70790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70772 === (2))){
var _ = (function (){var statearr_70774 = state_70771;
(statearr_70774[(4)] = cljs.core.cons((5),(state_70771[(4)])));

return statearr_70774;
})();
var inst_70757 = fluree.db.session.db(conn,ledger,null);
var state_70771__$1 = state_70771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70771__$1,(7),inst_70757);
} else {
if((state_val_70772 === (3))){
var inst_70767 = (state_70771[(2)]);
var inst_70768 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_70767);
var inst_70769 = cljs.core.async.close_BANG_(pc);
var state_70771__$1 = (function (){var statearr_70776 = state_70771;
(statearr_70776[(7)] = inst_70768);

return statearr_70776;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_70771__$1,inst_70769);
} else {
if((state_val_70772 === (4))){
var inst_70751 = (state_70771[(2)]);
var state_70771__$1 = state_70771;
var statearr_70777_70791 = state_70771__$1;
(statearr_70777_70791[(2)] = inst_70751);

(statearr_70777_70791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70772 === (5))){
var _ = (function (){var statearr_70778 = state_70771;
(statearr_70778[(4)] = cljs.core.rest((state_70771[(4)])));

return statearr_70778;
})();
var state_70771__$1 = state_70771;
var ex70775 = (state_70771__$1[(2)]);
var statearr_70779_70792 = state_70771__$1;
(statearr_70779_70792[(5)] = ex70775);


var statearr_70780_70793 = state_70771__$1;
(statearr_70780_70793[(1)] = (4));

(statearr_70780_70793[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70772 === (6))){
var inst_70763 = (state_70771[(2)]);
var inst_70764 = fluree.db.util.async.throw_err(inst_70763);
var _ = (function (){var statearr_70781 = state_70771;
(statearr_70781[(4)] = cljs.core.rest((state_70771[(4)])));

return statearr_70781;
})();
var state_70771__$1 = state_70771;
var statearr_70782_70794 = state_70771__$1;
(statearr_70782_70794[(2)] = inst_70764);

(statearr_70782_70794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70772 === (7))){
var inst_70759 = (state_70771[(2)]);
var inst_70760 = fluree.db.util.async.throw_err(inst_70759);
var inst_70761 = fluree.db.time_travel.as_of_block(inst_70760,block);
var state_70771__$1 = state_70771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70771__$1,(6),inst_70761);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_70783 = [null,null,null,null,null,null,null,null];
(statearr_70783[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_70783[(1)] = (1));

return statearr_70783;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_70771){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70771);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70784){var ex__2687__auto__ = e70784;
var statearr_70785_70795 = state_70771;
(statearr_70785_70795[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70771[(4)]))){
var statearr_70786_70796 = state_70771;
(statearr_70786_70796[(1)] = cljs.core.first((state_70771[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70797 = state_70771;
state_70771 = G__70797;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_70771){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_70771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70787 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70787[(6)] = c__2706__auto___70789);

return statearr_70787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70838){
var state_val_70839 = (state_70838[(1)]);
if((state_val_70839 === (7))){
var inst_70807 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_70838__$1 = state_70838;
if(inst_70807){
var statearr_70840_70871 = state_70838__$1;
(statearr_70840_70871[(1)] = (9));

} else {
var statearr_70841_70872 = state_70838__$1;
(statearr_70841_70872[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (1))){
var state_70838__$1 = state_70838;
var statearr_70842_70873 = state_70838__$1;
(statearr_70842_70873[(2)] = null);

(statearr_70842_70873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (4))){
var inst_70798 = (state_70838[(2)]);
var state_70838__$1 = state_70838;
var statearr_70843_70874 = state_70838__$1;
(statearr_70843_70874[(2)] = inst_70798);

(statearr_70843_70874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (15))){
var inst_70815 = (state_70838[(7)]);
var inst_70814 = (state_70838[(2)]);
var inst_70815__$1 = fluree.db.util.async.throw_err(inst_70814);
var state_70838__$1 = (function (){var statearr_70844 = state_70838;
(statearr_70844[(7)] = inst_70815__$1);

return statearr_70844;
})();
if(cljs.core.truth_(inst_70815__$1)){
var statearr_70845_70875 = state_70838__$1;
(statearr_70845_70875[(1)] = (16));

} else {
var statearr_70846_70876 = state_70838__$1;
(statearr_70846_70876[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (13))){
var state_70838__$1 = state_70838;
var statearr_70847_70877 = state_70838__$1;
(statearr_70847_70877[(2)] = null);

(statearr_70847_70877[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (6))){
var state_70838__$1 = state_70838;
var statearr_70848_70878 = state_70838__$1;
(statearr_70848_70878[(2)] = db);

(statearr_70848_70878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (17))){
var inst_70819 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_70820 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70821 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_70822 = cljs.core.PersistentHashMap.fromArrays(inst_70820,inst_70821);
var inst_70823 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70819,inst_70822);
var inst_70824 = (function(){throw inst_70823})();
var state_70838__$1 = state_70838;
var statearr_70849_70879 = state_70838__$1;
(statearr_70849_70879[(2)] = inst_70824);

(statearr_70849_70879[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (3))){
var inst_70836 = (state_70838[(2)]);
var state_70838__$1 = state_70838;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70838__$1,inst_70836);
} else {
if((state_val_70839 === (12))){
var inst_70812 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_70838__$1 = state_70838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70838__$1,(15),inst_70812);
} else {
if((state_val_70839 === (2))){
var _ = (function (){var statearr_70850 = state_70838;
(statearr_70850[(4)] = cljs.core.cons((5),(state_70838[(4)])));

return statearr_70850;
})();
var inst_70804 = cljs.core.not(auth);
var state_70838__$1 = state_70838;
if(inst_70804){
var statearr_70851_70880 = state_70838__$1;
(statearr_70851_70880[(1)] = (6));

} else {
var statearr_70852_70881 = state_70838__$1;
(statearr_70852_70881[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (11))){
var inst_70831 = (state_70838[(2)]);
var state_70838__$1 = state_70838;
var statearr_70854_70882 = state_70838__$1;
(statearr_70854_70882[(2)] = inst_70831);

(statearr_70854_70882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (9))){
var inst_70809 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_70838__$1 = state_70838;
var statearr_70855_70883 = state_70838__$1;
(statearr_70855_70883[(2)] = inst_70809);

(statearr_70855_70883[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (5))){
var _ = (function (){var statearr_70856 = state_70838;
(statearr_70856[(4)] = cljs.core.rest((state_70838[(4)])));

return statearr_70856;
})();
var state_70838__$1 = state_70838;
var ex70853 = (state_70838__$1[(2)]);
var statearr_70857_70884 = state_70838__$1;
(statearr_70857_70884[(5)] = ex70853);


if((ex70853 instanceof Error)){
var statearr_70858_70885 = state_70838__$1;
(statearr_70858_70885[(1)] = (4));

(statearr_70858_70885[(5)] = null);

} else {
throw ex70853;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (14))){
var inst_70829 = (state_70838[(2)]);
var state_70838__$1 = state_70838;
var statearr_70859_70886 = state_70838__$1;
(statearr_70859_70886[(2)] = inst_70829);

(statearr_70859_70886[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (16))){
var inst_70815 = (state_70838[(7)]);
var inst_70817 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_70815);
var state_70838__$1 = state_70838;
var statearr_70860_70887 = state_70838__$1;
(statearr_70860_70887[(2)] = inst_70817);

(statearr_70860_70887[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (10))){
var state_70838__$1 = state_70838;
var statearr_70861_70888 = state_70838__$1;
(statearr_70861_70888[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (18))){
var inst_70826 = (state_70838[(2)]);
var state_70838__$1 = state_70838;
var statearr_70863_70889 = state_70838__$1;
(statearr_70863_70889[(2)] = inst_70826);

(statearr_70863_70889[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70839 === (8))){
var inst_70833 = (state_70838[(2)]);
var _ = (function (){var statearr_70864 = state_70838;
(statearr_70864[(4)] = cljs.core.rest((state_70838[(4)])));

return statearr_70864;
})();
var state_70838__$1 = state_70838;
var statearr_70865_70890 = state_70838__$1;
(statearr_70865_70890[(2)] = inst_70833);

(statearr_70865_70890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0 = (function (){
var statearr_70866 = [null,null,null,null,null,null,null,null];
(statearr_70866[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__);

(statearr_70866[(1)] = (1));

return statearr_70866;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1 = (function (state_70838){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70838);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70867){var ex__2687__auto__ = e70867;
var statearr_70868_70891 = state_70838;
(statearr_70868_70891[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70838[(4)]))){
var statearr_70869_70892 = state_70838;
(statearr_70869_70892[(1)] = cljs.core.first((state_70838[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70893 = state_70838;
state_70838 = G__70893;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = function(state_70838){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1.call(this,state_70838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70870 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70870[(6)] = c__2706__auto__);

return statearr_70870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70965){
var state_val_70966 = (state_70965[(1)]);
if((state_val_70966 === (7))){
var inst_70903 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_70965__$1 = state_70965;
if(inst_70903){
var statearr_70967_71021 = state_70965__$1;
(statearr_70967_71021[(1)] = (9));

} else {
var statearr_70968_71022 = state_70965__$1;
(statearr_70968_71022[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (20))){
var inst_70927 = (state_70965[(7)]);
var state_70965__$1 = state_70965;
if(cljs.core.truth_(inst_70927)){
var statearr_70969_71023 = state_70965__$1;
(statearr_70969_71023[(1)] = (22));

} else {
var statearr_70970_71024 = state_70965__$1;
(statearr_70970_71024[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (27))){
var state_70965__$1 = state_70965;
var statearr_70971_71025 = state_70965__$1;
(statearr_70971_71025[(2)] = null);

(statearr_70971_71025[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (1))){
var state_70965__$1 = state_70965;
var statearr_70972_71026 = state_70965__$1;
(statearr_70972_71026[(2)] = null);

(statearr_70972_71026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (24))){
var inst_70941 = (state_70965[(2)]);
var state_70965__$1 = state_70965;
var statearr_70973_71027 = state_70965__$1;
(statearr_70973_71027[(2)] = inst_70941);

(statearr_70973_71027[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (4))){
var inst_70894 = (state_70965[(2)]);
var state_70965__$1 = state_70965;
var statearr_70974_71028 = state_70965__$1;
(statearr_70974_71028[(2)] = inst_70894);

(statearr_70974_71028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (15))){
var inst_70910 = (state_70965[(8)]);
var inst_70909 = (state_70965[(2)]);
var inst_70910__$1 = fluree.db.util.async.throw_err(inst_70909);
var state_70965__$1 = (function (){var statearr_70975 = state_70965;
(statearr_70975[(8)] = inst_70910__$1);

return statearr_70975;
})();
if(cljs.core.truth_(inst_70910__$1)){
var statearr_70976_71029 = state_70965__$1;
(statearr_70976_71029[(1)] = (16));

} else {
var statearr_70977_71030 = state_70965__$1;
(statearr_70977_71030[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (21))){
var inst_70943 = (state_70965[(9)]);
var inst_70943__$1 = (state_70965[(2)]);
var state_70965__$1 = (function (){var statearr_70978 = state_70965;
(statearr_70978[(9)] = inst_70943__$1);

return statearr_70978;
})();
if(cljs.core.truth_(inst_70943__$1)){
var statearr_70979_71031 = state_70965__$1;
(statearr_70979_71031[(1)] = (29));

} else {
var statearr_70980_71032 = state_70965__$1;
(statearr_70980_71032[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (31))){
var inst_70943 = (state_70965[(9)]);
var inst_70951 = (state_70965[(2)]);
var state_70965__$1 = (function (){var statearr_70981 = state_70965;
(statearr_70981[(10)] = inst_70951);

return statearr_70981;
})();
if(cljs.core.truth_(inst_70943)){
var statearr_70982_71033 = state_70965__$1;
(statearr_70982_71033[(1)] = (33));

} else {
var statearr_70983_71034 = state_70965__$1;
(statearr_70983_71034[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (32))){
var inst_70947 = (state_70965[(2)]);
var inst_70948 = fluree.db.util.async.throw_err(inst_70947);
var state_70965__$1 = state_70965;
var statearr_70984_71035 = state_70965__$1;
(statearr_70984_71035[(2)] = inst_70948);

(statearr_70984_71035[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (33))){
var inst_70943 = (state_70965[(9)]);
var inst_70953 = fluree.db.permissions.permission_map(db,inst_70943,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_70965__$1 = state_70965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70965__$1,(36),inst_70953);
} else {
if((state_val_70966 === (13))){
var state_70965__$1 = state_70965;
var statearr_70985_71036 = state_70965__$1;
(statearr_70985_71036[(2)] = null);

(statearr_70985_71036[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (22))){
var inst_70927 = (state_70965[(7)]);
var inst_70931 = fluree.db.auth.roles(db,inst_70927);
var state_70965__$1 = state_70965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70965__$1,(25),inst_70931);
} else {
if((state_val_70966 === (36))){
var inst_70955 = (state_70965[(2)]);
var inst_70956 = fluree.db.util.async.throw_err(inst_70955);
var state_70965__$1 = state_70965;
var statearr_70986_71037 = state_70965__$1;
(statearr_70986_71037[(2)] = inst_70956);

(statearr_70986_71037[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (29))){
var inst_70943 = (state_70965[(9)]);
var inst_70927 = (state_70965[(7)]);
var inst_70945 = fluree.db.dbfunctions.ctx.build(db,inst_70927,inst_70943);
var state_70965__$1 = state_70965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70965__$1,(32),inst_70945);
} else {
if((state_val_70966 === (6))){
var state_70965__$1 = state_70965;
var statearr_70987_71038 = state_70965__$1;
(statearr_70987_71038[(2)] = null);

(statearr_70987_71038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (28))){
var inst_70939 = (state_70965[(2)]);
var state_70965__$1 = state_70965;
var statearr_70988_71039 = state_70965__$1;
(statearr_70988_71039[(2)] = inst_70939);

(statearr_70988_71039[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (25))){
var inst_70933 = (state_70965[(2)]);
var inst_70934 = fluree.db.util.async.throw_err(inst_70933);
var state_70965__$1 = state_70965;
var statearr_70989_71040 = state_70965__$1;
(statearr_70989_71040[(2)] = inst_70934);

(statearr_70989_71040[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (34))){
var state_70965__$1 = state_70965;
var statearr_70990_71041 = state_70965__$1;
(statearr_70990_71041[(2)] = null);

(statearr_70990_71041[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (17))){
var inst_70913 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_70914 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70915 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_70916 = cljs.core.PersistentHashMap.fromArrays(inst_70914,inst_70915);
var inst_70917 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70913,inst_70916);
var inst_70918 = (function(){throw inst_70917})();
var state_70965__$1 = state_70965;
var statearr_70991_71042 = state_70965__$1;
(statearr_70991_71042[(2)] = inst_70918);

(statearr_70991_71042[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (3))){
var inst_70963 = (state_70965[(2)]);
var state_70965__$1 = state_70965;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70965__$1,inst_70963);
} else {
if((state_val_70966 === (12))){
var inst_70907 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_70965__$1 = state_70965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70965__$1,(15),inst_70907);
} else {
if((state_val_70966 === (2))){
var _ = (function (){var statearr_70992 = state_70965;
(statearr_70992[(4)] = cljs.core.cons((5),(state_70965[(4)])));

return statearr_70992;
})();
var inst_70900 = (auth == null);
var state_70965__$1 = state_70965;
if(cljs.core.truth_(inst_70900)){
var statearr_70993_71043 = state_70965__$1;
(statearr_70993_71043[(1)] = (6));

} else {
var statearr_70994_71044 = state_70965__$1;
(statearr_70994_71044[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (23))){
var state_70965__$1 = state_70965;
var statearr_70995_71045 = state_70965__$1;
(statearr_70995_71045[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (35))){
var inst_70943 = (state_70965[(9)]);
var inst_70927 = (state_70965[(7)]);
var inst_70951 = (state_70965[(10)]);
var inst_70959 = (state_70965[(2)]);
var inst_70960 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_70927,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"auth-id","auth-id",444160740),auth,new cljs.core.Keyword(null,"roles","roles",143379530),inst_70943,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_70959,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_70951], 0));
var _ = (function (){var statearr_70997 = state_70965;
(statearr_70997[(4)] = cljs.core.rest((state_70965[(4)])));

return statearr_70997;
})();
var state_70965__$1 = state_70965;
var statearr_70998_71046 = state_70965__$1;
(statearr_70998_71046[(2)] = inst_70960);

(statearr_70998_71046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (19))){
var state_70965__$1 = state_70965;
var statearr_70999_71047 = state_70965__$1;
(statearr_70999_71047[(2)] = roles);

(statearr_70999_71047[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (11))){
var inst_70925 = (state_70965[(2)]);
var state_70965__$1 = state_70965;
var statearr_71001_71048 = state_70965__$1;
(statearr_71001_71048[(2)] = inst_70925);

(statearr_71001_71048[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (9))){
var state_70965__$1 = state_70965;
var statearr_71002_71049 = state_70965__$1;
(statearr_71002_71049[(2)] = (0));

(statearr_71002_71049[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (5))){
var _ = (function (){var statearr_71003 = state_70965;
(statearr_71003[(4)] = cljs.core.rest((state_70965[(4)])));

return statearr_71003;
})();
var state_70965__$1 = state_70965;
var ex71000 = (state_70965__$1[(2)]);
var statearr_71004_71050 = state_70965__$1;
(statearr_71004_71050[(5)] = ex71000);


if((ex71000 instanceof Error)){
var statearr_71005_71051 = state_70965__$1;
(statearr_71005_71051[(1)] = (4));

(statearr_71005_71051[(5)] = null);

} else {
throw ex71000;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (14))){
var inst_70923 = (state_70965[(2)]);
var state_70965__$1 = state_70965;
var statearr_71006_71052 = state_70965__$1;
(statearr_71006_71052[(2)] = inst_70923);

(statearr_71006_71052[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (26))){
var state_70965__$1 = state_70965;
var statearr_71007_71053 = state_70965__$1;
(statearr_71007_71053[(2)] = null);

(statearr_71007_71053[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (16))){
var inst_70910 = (state_70965[(8)]);
var state_70965__$1 = state_70965;
var statearr_71008_71054 = state_70965__$1;
(statearr_71008_71054[(2)] = inst_70910);

(statearr_71008_71054[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (30))){
var state_70965__$1 = state_70965;
var statearr_71009_71055 = state_70965__$1;
(statearr_71009_71055[(2)] = null);

(statearr_71009_71055[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (10))){
var state_70965__$1 = state_70965;
if(cljs.core.truth_(auth)){
var statearr_71010_71056 = state_70965__$1;
(statearr_71010_71056[(1)] = (12));

} else {
var statearr_71011_71057 = state_70965__$1;
(statearr_71011_71057[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (18))){
var inst_70920 = (state_70965[(2)]);
var state_70965__$1 = state_70965;
var statearr_71012_71058 = state_70965__$1;
(statearr_71012_71058[(2)] = inst_70920);

(statearr_71012_71058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70966 === (8))){
var inst_70927 = (state_70965[(2)]);
var state_70965__$1 = (function (){var statearr_71013 = state_70965;
(statearr_71013[(7)] = inst_70927);

return statearr_71013;
})();
if(cljs.core.truth_(roles)){
var statearr_71014_71059 = state_70965__$1;
(statearr_71014_71059[(1)] = (19));

} else {
var statearr_71015_71060 = state_70965__$1;
(statearr_71015_71060[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0 = (function (){
var statearr_71016 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71016[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__);

(statearr_71016[(1)] = (1));

return statearr_71016;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1 = (function (state_70965){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70965);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71017){var ex__2687__auto__ = e71017;
var statearr_71018_71061 = state_70965;
(statearr_71018_71061[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70965[(4)]))){
var statearr_71019_71062 = state_70965;
(statearr_71019_71062[(1)] = cljs.core.first((state_70965[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71063 = state_70965;
state_70965 = G__71063;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = function(state_70965){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1.call(this,state_70965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71020 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71020[(6)] = c__2706__auto__);

return statearr_71020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__71064 = db;
var map__71064__$1 = cljs.core.__destructure_map(map__71064);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71064__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71064__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71064__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71071){
var state_val_71072 = (state_71071[(1)]);
if((state_val_71072 === (1))){
var inst_71065 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_71066 = fluree.db.session.db(conn,inst_71065,null);
var state_71071__$1 = state_71071;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71071__$1,(2),inst_71066);
} else {
if((state_val_71072 === (2))){
var inst_71068 = (state_71071[(2)]);
var inst_71069 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_71068);
var state_71071__$1 = state_71071;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71071__$1,inst_71069);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_71073 = [null,null,null,null,null,null,null];
(statearr_71073[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_71073[(1)] = (1));

return statearr_71073;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_71071){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71071);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71074){var ex__2687__auto__ = e71074;
var statearr_71075_71102 = state_71071;
(statearr_71075_71102[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71071[(4)]))){
var statearr_71076_71103 = state_71071;
(statearr_71076_71103[(1)] = cljs.core.first((state_71071[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71104 = state_71071;
state_71071 = G__71104;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_71071){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_71071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71077 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71077[(6)] = c__2706__auto__);

return statearr_71077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71090){
var state_val_71091 = (state_71090[(1)]);
if((state_val_71091 === (1))){
var inst_71078 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_71079 = fluree.db.session.db(conn,inst_71078,null);
var state_71090__$1 = state_71090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71090__$1,(2),inst_71079);
} else {
if((state_val_71091 === (2))){
var inst_71081 = (state_71090[(7)]);
var inst_71081__$1 = (state_71090[(2)]);
var inst_71082 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_71081__$1);
var inst_71083 = newer_block_QMARK_(inst_71082);
var state_71090__$1 = (function (){var statearr_71092 = state_71090;
(statearr_71092[(7)] = inst_71081__$1);

return statearr_71092;
})();
if(inst_71083){
var statearr_71093_71105 = state_71090__$1;
(statearr_71093_71105[(1)] = (3));

} else {
var statearr_71094_71106 = state_71090__$1;
(statearr_71094_71106[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71091 === (3))){
var inst_71081 = (state_71090[(7)]);
var inst_71085 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_71081);
var state_71090__$1 = state_71090;
var statearr_71095_71107 = state_71090__$1;
(statearr_71095_71107[(2)] = inst_71085);

(statearr_71095_71107[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71091 === (4))){
var state_71090__$1 = state_71090;
var statearr_71096_71108 = state_71090__$1;
(statearr_71096_71108[(2)] = null);

(statearr_71096_71108[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71091 === (5))){
var inst_71088 = (state_71090[(2)]);
var state_71090__$1 = state_71090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71090__$1,inst_71088);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_71097 = [null,null,null,null,null,null,null,null];
(statearr_71097[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_71097[(1)] = (1));

return statearr_71097;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_71090){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71090);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71098){var ex__2687__auto__ = e71098;
var statearr_71099_71109 = state_71090;
(statearr_71099_71109[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71090[(4)]))){
var statearr_71100_71110 = state_71090;
(statearr_71100_71110[(1)] = cljs.core.first((state_71090[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71111 = state_71090;
state_71090 = G__71111;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_71090){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_71090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71101 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71101[(6)] = c__2706__auto__);

return statearr_71101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__71112 = db;
var map__71112__$1 = cljs.core.__destructure_map(map__71112);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71112__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71112__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71112__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2706__auto___71188 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71162){
var state_val_71163 = (state_71162[(1)]);
if((state_val_71163 === (7))){
var inst_71128 = (state_71162[(7)]);
var inst_71139 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71128,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_71162__$1 = state_71162;
if(inst_71139){
var statearr_71164_71189 = state_71162__$1;
(statearr_71164_71189[(1)] = (9));

} else {
var statearr_71165_71190 = state_71162__$1;
(statearr_71165_71190[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (1))){
var inst_71113 = (state_71162[(8)]);
var inst_71121 = (state_71162[(9)]);
var inst_71113__$1 = cljs.core.async.timeout(timeout);
var inst_71121__$1 = res_port;
var inst_71122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71123 = [inst_71113__$1,inst_71121__$1];
var inst_71124 = (new cljs.core.PersistentVector(null,2,(5),inst_71122,inst_71123,null));
var state_71162__$1 = (function (){var statearr_71166 = state_71162;
(statearr_71166[(8)] = inst_71113__$1);

(statearr_71166[(9)] = inst_71121__$1);

return statearr_71166;
})();
return cljs.core.async.ioc_alts_BANG_(state_71162__$1,(2),inst_71124);
} else {
if((state_val_71163 === (4))){
var inst_71128 = (state_71162[(7)]);
var inst_71121 = (state_71162[(9)]);
var inst_71132 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71128,inst_71121);
var state_71162__$1 = state_71162;
if(inst_71132){
var statearr_71167_71191 = state_71162__$1;
(statearr_71167_71191[(1)] = (6));

} else {
var statearr_71168_71192 = state_71162__$1;
(statearr_71168_71192[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (13))){
var inst_71147 = (state_71162[(10)]);
var inst_71158 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_71147);
var state_71162__$1 = state_71162;
var statearr_71169_71193 = state_71162__$1;
(statearr_71169_71193[(2)] = inst_71158);

(statearr_71169_71193[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (6))){
var inst_71126 = (state_71162[(11)]);
var inst_71137 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71126,(0),null);
var state_71162__$1 = state_71162;
var statearr_71170_71194 = state_71162__$1;
(statearr_71170_71194[(2)] = inst_71137);

(statearr_71170_71194[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (3))){
var state_71162__$1 = state_71162;
var statearr_71171_71195 = state_71162__$1;
(statearr_71171_71195[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_71171_71195[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (12))){
var inst_71151 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_71152 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71153 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_71154 = cljs.core.PersistentHashMap.fromArrays(inst_71152,inst_71153);
var inst_71155 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71151,inst_71154);
var inst_71156 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_71155);
var state_71162__$1 = state_71162;
var statearr_71172_71196 = state_71162__$1;
(statearr_71172_71196[(2)] = inst_71156);

(statearr_71172_71196[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (2))){
var inst_71128 = (state_71162[(7)]);
var inst_71113 = (state_71162[(8)]);
var inst_71126 = (state_71162[(11)]);
var inst_71126__$1 = (state_71162[(2)]);
var inst_71127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71126__$1,(0),null);
var inst_71128__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71126__$1,(1),null);
var inst_71129 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71128__$1,inst_71113);
var state_71162__$1 = (function (){var statearr_71173 = state_71162;
(statearr_71173[(12)] = inst_71127);

(statearr_71173[(7)] = inst_71128__$1);

(statearr_71173[(11)] = inst_71126__$1);

return statearr_71173;
})();
if(inst_71129){
var statearr_71174_71197 = state_71162__$1;
(statearr_71174_71197[(1)] = (3));

} else {
var statearr_71175_71198 = state_71162__$1;
(statearr_71175_71198[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (11))){
var inst_71143 = (state_71162[(2)]);
var state_71162__$1 = state_71162;
var statearr_71176_71199 = state_71162__$1;
(statearr_71176_71199[(2)] = inst_71143);

(statearr_71176_71199[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (9))){
var inst_71127 = (state_71162[(12)]);
var state_71162__$1 = state_71162;
var statearr_71177_71200 = state_71162__$1;
(statearr_71177_71200[(2)] = inst_71127);

(statearr_71177_71200[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (5))){
var inst_71147 = (state_71162[(10)]);
var inst_71147__$1 = (state_71162[(2)]);
var inst_71148 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_71149 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_71147__$1);
var state_71162__$1 = (function (){var statearr_71178 = state_71162;
(statearr_71178[(10)] = inst_71147__$1);

(statearr_71178[(13)] = inst_71148);

return statearr_71178;
})();
if(inst_71149){
var statearr_71179_71201 = state_71162__$1;
(statearr_71179_71201[(1)] = (12));

} else {
var statearr_71180_71202 = state_71162__$1;
(statearr_71180_71202[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (14))){
var inst_71160 = (state_71162[(2)]);
var state_71162__$1 = state_71162;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71162__$1,inst_71160);
} else {
if((state_val_71163 === (10))){
var state_71162__$1 = state_71162;
var statearr_71181_71203 = state_71162__$1;
(statearr_71181_71203[(2)] = null);

(statearr_71181_71203[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71163 === (8))){
var inst_71145 = (state_71162[(2)]);
var state_71162__$1 = state_71162;
var statearr_71182_71204 = state_71162__$1;
(statearr_71182_71204[(2)] = inst_71145);

(statearr_71182_71204[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0 = (function (){
var statearr_71183 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71183[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__);

(statearr_71183[(1)] = (1));

return statearr_71183;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1 = (function (state_71162){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71162);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71184){var ex__2687__auto__ = e71184;
var statearr_71185_71205 = state_71162;
(statearr_71185_71205[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71162[(4)]))){
var statearr_71186_71206 = state_71162;
(statearr_71186_71206[(1)] = cljs.core.first((state_71162[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71207 = state_71162;
state_71162 = G__71207;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = function(state_71162){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1.call(this,state_71162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71187 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71187[(6)] = c__2706__auto___71188);

return statearr_71187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__71209 = arguments.length;
switch (G__71209) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__71210){
var map__71211 = p__71210;
var map__71211__$1 = cljs.core.__destructure_map(map__71211);
var opts = map__71211__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71211__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71211__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71211__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71211__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71211__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2706__auto___71300 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71262){
var state_val_71263 = (state_71262[(1)]);
if((state_val_71263 === (7))){
var inst_71224 = (state_71262[(7)]);
var inst_71226 = fluree.db.api.ledger.syncTo_db(inst_71224,syncTo,syncTimeout);
var state_71262__$1 = state_71262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71262__$1,(10),inst_71226);
} else {
if((state_val_71263 === (20))){
var inst_71248 = (state_71262[(8)]);
var state_71262__$1 = state_71262;
var statearr_71264_71301 = state_71262__$1;
(statearr_71264_71301[(2)] = inst_71248);

(statearr_71264_71301[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (1))){
var state_71262__$1 = state_71262;
var statearr_71265_71302 = state_71262__$1;
(statearr_71265_71302[(2)] = null);

(statearr_71265_71302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (4))){
var inst_71212 = (state_71262[(2)]);
var inst_71213 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_71212);
var inst_71214 = cljs.core.async.close_BANG_(pc);
var state_71262__$1 = (function (){var statearr_71266 = state_71262;
(statearr_71266[(9)] = inst_71213);

return statearr_71266;
})();
var statearr_71267_71303 = state_71262__$1;
(statearr_71267_71303[(2)] = inst_71214);

(statearr_71267_71303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (15))){
var inst_71240 = (state_71262[(10)]);
var inst_71242 = fluree.db.api.ledger.add_db_permissions(inst_71240,auth,roles);
var state_71262__$1 = state_71262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71262__$1,(18),inst_71242);
} else {
if((state_val_71263 === (21))){
var inst_71256 = (state_71262[(2)]);
var inst_71257 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_71256);
var _ = (function (){var statearr_71268 = state_71262;
(statearr_71268[(4)] = cljs.core.rest((state_71262[(4)])));

return statearr_71268;
})();
var state_71262__$1 = state_71262;
var statearr_71269_71304 = state_71262__$1;
(statearr_71269_71304[(2)] = inst_71257);

(statearr_71269_71304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (13))){
var inst_71240 = (state_71262[(2)]);
var state_71262__$1 = (function (){var statearr_71270 = state_71262;
(statearr_71270[(10)] = inst_71240);

return statearr_71270;
})();
if(cljs.core.truth_(roles)){
var statearr_71271_71305 = state_71262__$1;
(statearr_71271_71305[(1)] = (15));

} else {
var statearr_71272_71306 = state_71262__$1;
(statearr_71272_71306[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (22))){
var inst_71252 = (state_71262[(2)]);
var inst_71253 = fluree.db.util.async.throw_err(inst_71252);
var state_71262__$1 = state_71262;
var statearr_71273_71307 = state_71262__$1;
(statearr_71273_71307[(2)] = inst_71253);

(statearr_71273_71307[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (6))){
var inst_71223 = (state_71262[(2)]);
var inst_71224 = fluree.db.util.async.throw_err(inst_71223);
var state_71262__$1 = (function (){var statearr_71274 = state_71262;
(statearr_71274[(7)] = inst_71224);

return statearr_71274;
})();
if(cljs.core.truth_(syncTo)){
var statearr_71275_71308 = state_71262__$1;
(statearr_71275_71308[(1)] = (7));

} else {
var statearr_71276_71309 = state_71262__$1;
(statearr_71276_71309[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (17))){
var inst_71248 = (state_71262[(2)]);
var state_71262__$1 = (function (){var statearr_71277 = state_71262;
(statearr_71277[(8)] = inst_71248);

return statearr_71277;
})();
if(cljs.core.truth_(auth)){
var statearr_71278_71310 = state_71262__$1;
(statearr_71278_71310[(1)] = (19));

} else {
var statearr_71279_71311 = state_71262__$1;
(statearr_71279_71311[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (3))){
var inst_71260 = (state_71262[(2)]);
var state_71262__$1 = state_71262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71262__$1,inst_71260);
} else {
if((state_val_71263 === (12))){
var inst_71232 = (state_71262[(11)]);
var state_71262__$1 = state_71262;
var statearr_71280_71312 = state_71262__$1;
(statearr_71280_71312[(2)] = inst_71232);

(statearr_71280_71312[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (2))){
var _ = (function (){var statearr_71281 = state_71262;
(statearr_71281[(4)] = cljs.core.cons((5),(state_71262[(4)])));

return statearr_71281;
})();
var inst_71221 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_71262__$1 = state_71262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71262__$1,(6),inst_71221);
} else {
if((state_val_71263 === (19))){
var inst_71248 = (state_71262[(8)]);
var inst_71250 = fluree.db.api.ledger.add_db_permissions(inst_71248,auth,roles);
var state_71262__$1 = state_71262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71262__$1,(22),inst_71250);
} else {
if((state_val_71263 === (11))){
var inst_71232 = (state_71262[(11)]);
var inst_71234 = fluree.db.time_travel.as_of_block(inst_71232,block);
var state_71262__$1 = state_71262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71262__$1,(14),inst_71234);
} else {
if((state_val_71263 === (9))){
var inst_71232 = (state_71262[(2)]);
var state_71262__$1 = (function (){var statearr_71283 = state_71262;
(statearr_71283[(11)] = inst_71232);

return statearr_71283;
})();
if(cljs.core.truth_(block)){
var statearr_71284_71313 = state_71262__$1;
(statearr_71284_71313[(1)] = (11));

} else {
var statearr_71285_71314 = state_71262__$1;
(statearr_71285_71314[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (5))){
var _ = (function (){var statearr_71286 = state_71262;
(statearr_71286[(4)] = cljs.core.rest((state_71262[(4)])));

return statearr_71286;
})();
var state_71262__$1 = state_71262;
var ex71282 = (state_71262__$1[(2)]);
var statearr_71287_71315 = state_71262__$1;
(statearr_71287_71315[(5)] = ex71282);


var statearr_71288_71316 = state_71262__$1;
(statearr_71288_71316[(1)] = (4));

(statearr_71288_71316[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (14))){
var inst_71236 = (state_71262[(2)]);
var inst_71237 = fluree.db.util.async.throw_err(inst_71236);
var state_71262__$1 = state_71262;
var statearr_71289_71317 = state_71262__$1;
(statearr_71289_71317[(2)] = inst_71237);

(statearr_71289_71317[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (16))){
var inst_71240 = (state_71262[(10)]);
var state_71262__$1 = state_71262;
var statearr_71290_71318 = state_71262__$1;
(statearr_71290_71318[(2)] = inst_71240);

(statearr_71290_71318[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (10))){
var inst_71228 = (state_71262[(2)]);
var inst_71229 = fluree.db.util.async.throw_err(inst_71228);
var state_71262__$1 = state_71262;
var statearr_71291_71319 = state_71262__$1;
(statearr_71291_71319[(2)] = inst_71229);

(statearr_71291_71319[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (18))){
var inst_71244 = (state_71262[(2)]);
var inst_71245 = fluree.db.util.async.throw_err(inst_71244);
var state_71262__$1 = state_71262;
var statearr_71292_71320 = state_71262__$1;
(statearr_71292_71320[(2)] = inst_71245);

(statearr_71292_71320[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71263 === (8))){
var inst_71224 = (state_71262[(7)]);
var state_71262__$1 = state_71262;
var statearr_71293_71321 = state_71262__$1;
(statearr_71293_71321[(2)] = inst_71224);

(statearr_71293_71321[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_71294 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71294[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_71294[(1)] = (1));

return statearr_71294;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_71262){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71262);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71295){var ex__2687__auto__ = e71295;
var statearr_71296_71322 = state_71262;
(statearr_71296_71322[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71262[(4)]))){
var statearr_71297_71323 = state_71262;
(statearr_71297_71323[(1)] = cljs.core.first((state_71262[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71324 = state_71262;
state_71262 = G__71324;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_71262){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_71262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71298 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71298[(6)] = c__2706__auto___71300);

return statearr_71298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

