// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__66398 = arguments.length;
switch (G__66398) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___66546 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66485){
var state_val_66486 = (state_66485[(1)]);
if((state_val_66486 === (7))){
var inst_66416 = (state_66485[(7)]);
var inst_66419 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_66416);
var state_66485__$1 = state_66485;
var statearr_66487_66547 = state_66485__$1;
(statearr_66487_66547[(2)] = inst_66419);

(statearr_66487_66547[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (20))){
var inst_66440 = (state_66485[(8)]);
var inst_66411 = (state_66485[(9)]);
var inst_66444 = fluree.db.auth.roles(inst_66411,inst_66440);
var state_66485__$1 = state_66485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66485__$1,(23),inst_66444);
} else {
if((state_val_66486 === (27))){
var inst_66411 = (state_66485[(9)]);
var inst_66459 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_66460 = fluree.db.time_travel.as_of_block(inst_66411,inst_66459);
var state_66485__$1 = state_66485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66485__$1,(30),inst_66460);
} else {
if((state_val_66486 === (1))){
var state_66485__$1 = state_66485;
var statearr_66488_66548 = state_66485__$1;
(statearr_66488_66548[(2)] = null);

(statearr_66488_66548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (24))){
var inst_66411 = (state_66485[(9)]);
var inst_66452 = (state_66485[(10)]);
var inst_66454 = fluree.db.permissions.permission_map(inst_66411,inst_66452,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_66485__$1 = state_66485;
var statearr_66489_66549 = state_66485__$1;
(statearr_66489_66549[(2)] = inst_66454);

(statearr_66489_66549[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (4))){
var inst_66399 = (state_66485[(2)]);
var inst_66400 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66399);
var inst_66401 = cljs.core.async.close_BANG_(pc);
var state_66485__$1 = (function (){var statearr_66490 = state_66485;
(statearr_66490[(11)] = inst_66400);

return statearr_66490;
})();
var statearr_66491_66550 = state_66485__$1;
(statearr_66491_66550[(2)] = inst_66401);

(statearr_66491_66550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (15))){
var inst_66416 = (state_66485[(7)]);
var inst_66430 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66416)," unknown."].join('');
var inst_66431 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66432 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_66433 = cljs.core.PersistentHashMap.fromArrays(inst_66431,inst_66432);
var inst_66434 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66430,inst_66433);
var inst_66435 = (function(){throw inst_66434})();
var state_66485__$1 = state_66485;
var statearr_66492_66551 = state_66485__$1;
(statearr_66492_66551[(2)] = inst_66435);

(statearr_66492_66551[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (21))){
var state_66485__$1 = state_66485;
var statearr_66493_66552 = state_66485__$1;
(statearr_66493_66552[(2)] = null);

(statearr_66493_66552[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (31))){
var inst_66466 = (state_66485[(12)]);
var inst_66416 = (state_66485[(7)]);
var inst_66468 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66466,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_66416);
var state_66485__$1 = state_66485;
var statearr_66494_66553 = state_66485__$1;
(statearr_66494_66553[(2)] = inst_66468);

(statearr_66494_66553[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (32))){
var inst_66466 = (state_66485[(12)]);
var state_66485__$1 = state_66485;
var statearr_66495_66554 = state_66485__$1;
(statearr_66495_66554[(2)] = inst_66466);

(statearr_66495_66554[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (33))){
var inst_66452 = (state_66485[(10)]);
var inst_66471 = (state_66485[(2)]);
var state_66485__$1 = (function (){var statearr_66496 = state_66485;
(statearr_66496[(13)] = inst_66471);

return statearr_66496;
})();
if(cljs.core.truth_(inst_66452)){
var statearr_66497_66555 = state_66485__$1;
(statearr_66497_66555[(1)] = (34));

} else {
var statearr_66498_66556 = state_66485__$1;
(statearr_66498_66556[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (13))){
var inst_66427 = (state_66485[(14)]);
var inst_66426 = (state_66485[(2)]);
var inst_66427__$1 = fluree.db.util.async.throw_err(inst_66426);
var state_66485__$1 = (function (){var statearr_66499 = state_66485;
(statearr_66499[(14)] = inst_66427__$1);

return statearr_66499;
})();
if(cljs.core.truth_(inst_66427__$1)){
var statearr_66500_66557 = state_66485__$1;
(statearr_66500_66557[(1)] = (14));

} else {
var statearr_66501_66558 = state_66485__$1;
(statearr_66501_66558[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (22))){
var inst_66450 = (state_66485[(2)]);
var state_66485__$1 = state_66485;
var statearr_66502_66559 = state_66485__$1;
(statearr_66502_66559[(2)] = inst_66450);

(statearr_66502_66559[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (36))){
var inst_66479 = (state_66485[(2)]);
var inst_66480 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66479);
var _ = (function (){var statearr_66503 = state_66485;
(statearr_66503[(4)] = cljs.core.rest((state_66485[(4)])));

return statearr_66503;
})();
var state_66485__$1 = state_66485;
var statearr_66504_66560 = state_66485__$1;
(statearr_66504_66560[(2)] = inst_66480);

(statearr_66504_66560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (29))){
var inst_66416 = (state_66485[(7)]);
var inst_66466 = (state_66485[(2)]);
var state_66485__$1 = (function (){var statearr_66505 = state_66485;
(statearr_66505[(12)] = inst_66466);

return statearr_66505;
})();
if(cljs.core.truth_(inst_66416)){
var statearr_66506_66561 = state_66485__$1;
(statearr_66506_66561[(1)] = (31));

} else {
var statearr_66507_66562 = state_66485__$1;
(statearr_66507_66562[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (6))){
var inst_66416 = (state_66485[(7)]);
var inst_66410 = (state_66485[(2)]);
var inst_66411 = fluree.db.util.async.throw_err(inst_66410);
var inst_66412 = opts;
var inst_66413 = cljs.core.__destructure_map(inst_66412);
var inst_66414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66413,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_66415 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66413,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_66416__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66413,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_66417 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66413,new cljs.core.Keyword(null,"block","block",664686210));
var state_66485__$1 = (function (){var statearr_66508 = state_66485;
(statearr_66508[(15)] = inst_66414);

(statearr_66508[(9)] = inst_66411);

(statearr_66508[(16)] = inst_66415);

(statearr_66508[(17)] = inst_66417);

(statearr_66508[(7)] = inst_66416__$1);

return statearr_66508;
})();
if(cljs.core.truth_(inst_66416__$1)){
var statearr_66509_66563 = state_66485__$1;
(statearr_66509_66563[(1)] = (7));

} else {
var statearr_66510_66564 = state_66485__$1;
(statearr_66510_66564[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (28))){
var inst_66411 = (state_66485[(9)]);
var state_66485__$1 = state_66485;
var statearr_66511_66565 = state_66485__$1;
(statearr_66511_66565[(2)] = inst_66411);

(statearr_66511_66565[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (25))){
var state_66485__$1 = state_66485;
var statearr_66512_66566 = state_66485__$1;
(statearr_66512_66566[(2)] = null);

(statearr_66512_66566[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (34))){
var inst_66457 = (state_66485[(18)]);
var state_66485__$1 = state_66485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66485__$1,(37),inst_66457);
} else {
if((state_val_66486 === (17))){
var inst_66414 = (state_66485[(15)]);
var state_66485__$1 = state_66485;
var statearr_66513_66567 = state_66485__$1;
(statearr_66513_66567[(2)] = inst_66414);

(statearr_66513_66567[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (3))){
var inst_66483 = (state_66485[(2)]);
var state_66485__$1 = state_66485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66485__$1,inst_66483);
} else {
if((state_val_66486 === (12))){
var inst_66414 = (state_66485[(15)]);
var inst_66440 = (state_66485[(2)]);
var state_66485__$1 = (function (){var statearr_66514 = state_66485;
(statearr_66514[(8)] = inst_66440);

return statearr_66514;
})();
if(cljs.core.truth_(inst_66414)){
var statearr_66515_66568 = state_66485__$1;
(statearr_66515_66568[(1)] = (17));

} else {
var statearr_66516_66569 = state_66485__$1;
(statearr_66516_66569[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (2))){
var _ = (function (){var statearr_66517 = state_66485;
(statearr_66517[(4)] = cljs.core.cons((5),(state_66485[(4)])));

return statearr_66517;
})();
var inst_66408 = fluree.db.session.db(conn,ledger,null);
var state_66485__$1 = state_66485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66485__$1,(6),inst_66408);
} else {
if((state_val_66486 === (23))){
var inst_66446 = (state_66485[(2)]);
var inst_66447 = fluree.db.util.async.throw_err(inst_66446);
var state_66485__$1 = state_66485;
var statearr_66518_66570 = state_66485__$1;
(statearr_66518_66570[(2)] = inst_66447);

(statearr_66518_66570[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (35))){
var inst_66471 = (state_66485[(13)]);
var state_66485__$1 = state_66485;
var statearr_66519_66571 = state_66485__$1;
(statearr_66519_66571[(2)] = inst_66471);

(statearr_66519_66571[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (19))){
var inst_66452 = (state_66485[(10)]);
var inst_66452__$1 = (state_66485[(2)]);
var state_66485__$1 = (function (){var statearr_66520 = state_66485;
(statearr_66520[(10)] = inst_66452__$1);

return statearr_66520;
})();
if(cljs.core.truth_(inst_66452__$1)){
var statearr_66521_66572 = state_66485__$1;
(statearr_66521_66572[(1)] = (24));

} else {
var statearr_66522_66573 = state_66485__$1;
(statearr_66522_66573[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (11))){
var state_66485__$1 = state_66485;
var statearr_66524_66574 = state_66485__$1;
(statearr_66524_66574[(2)] = null);

(statearr_66524_66574[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (9))){
var inst_66422 = (state_66485[(2)]);
var state_66485__$1 = state_66485;
if(cljs.core.truth_(inst_66422)){
var statearr_66525_66575 = state_66485__$1;
(statearr_66525_66575[(1)] = (10));

} else {
var statearr_66526_66576 = state_66485__$1;
(statearr_66526_66576[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (5))){
var _ = (function (){var statearr_66527 = state_66485;
(statearr_66527[(4)] = cljs.core.rest((state_66485[(4)])));

return statearr_66527;
})();
var state_66485__$1 = state_66485;
var ex66523 = (state_66485__$1[(2)]);
var statearr_66528_66577 = state_66485__$1;
(statearr_66528_66577[(5)] = ex66523);


var statearr_66529_66578 = state_66485__$1;
(statearr_66529_66578[(1)] = (4));

(statearr_66529_66578[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (14))){
var inst_66427 = (state_66485[(14)]);
var state_66485__$1 = state_66485;
var statearr_66530_66579 = state_66485__$1;
(statearr_66530_66579[(2)] = inst_66427);

(statearr_66530_66579[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (26))){
var inst_66417 = (state_66485[(17)]);
var inst_66457 = (state_66485[(2)]);
var state_66485__$1 = (function (){var statearr_66531 = state_66485;
(statearr_66531[(18)] = inst_66457);

return statearr_66531;
})();
if(cljs.core.truth_(inst_66417)){
var statearr_66532_66580 = state_66485__$1;
(statearr_66532_66580[(1)] = (27));

} else {
var statearr_66533_66581 = state_66485__$1;
(statearr_66533_66581[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (16))){
var inst_66437 = (state_66485[(2)]);
var state_66485__$1 = state_66485;
var statearr_66534_66582 = state_66485__$1;
(statearr_66534_66582[(2)] = inst_66437);

(statearr_66534_66582[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (30))){
var inst_66462 = (state_66485[(2)]);
var inst_66463 = fluree.db.util.async.throw_err(inst_66462);
var state_66485__$1 = state_66485;
var statearr_66535_66583 = state_66485__$1;
(statearr_66535_66583[(2)] = inst_66463);

(statearr_66535_66583[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (10))){
var inst_66411 = (state_66485[(9)]);
var inst_66416 = (state_66485[(7)]);
var inst_66424 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_66411,inst_66416);
var state_66485__$1 = state_66485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66485__$1,(13),inst_66424);
} else {
if((state_val_66486 === (18))){
var inst_66440 = (state_66485[(8)]);
var state_66485__$1 = state_66485;
if(cljs.core.truth_(inst_66440)){
var statearr_66536_66584 = state_66485__$1;
(statearr_66536_66584[(1)] = (20));

} else {
var statearr_66537_66585 = state_66485__$1;
(statearr_66537_66585[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (37))){
var inst_66471 = (state_66485[(13)]);
var inst_66474 = (state_66485[(2)]);
var inst_66475 = fluree.db.util.async.throw_err(inst_66474);
var inst_66476 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66471,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_66475);
var state_66485__$1 = state_66485;
var statearr_66538_66586 = state_66485__$1;
(statearr_66538_66586[(2)] = inst_66476);

(statearr_66538_66586[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66486 === (8))){
var inst_66416 = (state_66485[(7)]);
var state_66485__$1 = state_66485;
var statearr_66539_66587 = state_66485__$1;
(statearr_66539_66587[(2)] = inst_66416);

(statearr_66539_66587[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2684__auto__ = null;
var fluree$db$api$query$state_machine__2684__auto____0 = (function (){
var statearr_66540 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66540[(0)] = fluree$db$api$query$state_machine__2684__auto__);

(statearr_66540[(1)] = (1));

return statearr_66540;
});
var fluree$db$api$query$state_machine__2684__auto____1 = (function (state_66485){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66485);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66541){var ex__2687__auto__ = e66541;
var statearr_66542_66588 = state_66485;
(statearr_66542_66588[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66485[(4)]))){
var statearr_66543_66589 = state_66485;
(statearr_66543_66589[(1)] = cljs.core.first((state_66485[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66590 = state_66485;
state_66485 = G__66590;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2684__auto__ = function(state_66485){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2684__auto____1.call(this,state_66485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2684__auto____0;
fluree$db$api$query$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2684__auto____1;
return fluree$db$api$query$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66544 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66544[(6)] = c__2706__auto___66546);

return statearr_66544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66731){
var state_val_66732 = (state_66731[(1)]);
if((state_val_66732 === (7))){
var inst_66611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66612 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_66613 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_66614 = [inst_66612,inst_66613];
var inst_66615 = (new cljs.core.PersistentVector(null,2,(5),inst_66611,inst_66614,null));
var state_66731__$1 = state_66731;
var statearr_66733_66803 = state_66731__$1;
(statearr_66733_66803[(2)] = inst_66615);

(statearr_66733_66803[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (20))){
var inst_66641 = (state_66731[(7)]);
var state_66731__$1 = state_66731;
var statearr_66734_66804 = state_66731__$1;
(statearr_66734_66804[(2)] = inst_66641);

(statearr_66734_66804[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (27))){
var state_66731__$1 = state_66731;
var statearr_66735_66805 = state_66731__$1;
(statearr_66735_66805[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (1))){
var state_66731__$1 = state_66731;
var statearr_66737_66806 = state_66731__$1;
(statearr_66737_66806[(2)] = null);

(statearr_66737_66806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (24))){
var inst_66640 = (state_66731[(8)]);
var state_66731__$1 = state_66731;
if(cljs.core.truth_(inst_66640)){
var statearr_66738_66807 = state_66731__$1;
(statearr_66738_66807[(1)] = (26));

} else {
var statearr_66739_66808 = state_66731__$1;
(statearr_66739_66808[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (39))){
var inst_66687 = (state_66731[(9)]);
var inst_66686 = (state_66731[(10)]);
var inst_66712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66713 = [inst_66686,inst_66687];
var inst_66714 = (new cljs.core.PersistentVector(null,2,(5),inst_66712,inst_66713,null));
var state_66731__$1 = state_66731;
var statearr_66740_66809 = state_66731__$1;
(statearr_66740_66809[(2)] = inst_66714);

(statearr_66740_66809[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (4))){
var inst_66591 = (state_66731[(2)]);
var state_66731__$1 = state_66731;
var statearr_66741_66810 = state_66731__$1;
(statearr_66741_66810[(2)] = inst_66591);

(statearr_66741_66810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (15))){
var inst_66620 = (state_66731[(11)]);
var inst_66625 = (state_66731[(12)]);
var inst_66634 = (state_66731[(2)]);
var inst_66635 = [inst_66625,inst_66634];
var inst_66636 = (new cljs.core.PersistentVector(null,2,(5),inst_66620,inst_66635,null));
var state_66731__$1 = state_66731;
var statearr_66742_66811 = state_66731__$1;
(statearr_66742_66811[(2)] = inst_66636);

(statearr_66742_66811[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (21))){
var inst_66640 = (state_66731[(8)]);
var state_66731__$1 = state_66731;
var statearr_66743_66812 = state_66731__$1;
(statearr_66743_66812[(2)] = inst_66640);

(statearr_66743_66812[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (31))){
var inst_66681 = (state_66731[(2)]);
var state_66731__$1 = state_66731;
var statearr_66744_66813 = state_66731__$1;
(statearr_66744_66813[(2)] = inst_66681);

(statearr_66744_66813[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (32))){
var inst_66687 = (state_66731[(9)]);
var inst_66690 = cljs.core.pos_int_QMARK_(inst_66687);
var state_66731__$1 = state_66731;
var statearr_66745_66814 = state_66731__$1;
(statearr_66745_66814[(2)] = inst_66690);

(statearr_66745_66814[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (40))){
var inst_66642 = (state_66731[(13)]);
var inst_66718 = (state_66731[(14)]);
var inst_66716 = (state_66731[(2)]);
var inst_66717 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66716,(0),null);
var inst_66718__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66716,(1),null);
var inst_66719 = (inst_66718__$1 > inst_66642);
var state_66731__$1 = (function (){var statearr_66746 = state_66731;
(statearr_66746[(15)] = inst_66717);

(statearr_66746[(14)] = inst_66718__$1);

return statearr_66746;
})();
if(cljs.core.truth_(inst_66719)){
var statearr_66747_66815 = state_66731__$1;
(statearr_66747_66815[(1)] = (41));

} else {
var statearr_66748_66816 = state_66731__$1;
(statearr_66748_66816[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (33))){
var inst_66688 = (state_66731[(16)]);
var state_66731__$1 = state_66731;
var statearr_66749_66817 = state_66731__$1;
(statearr_66749_66817[(2)] = inst_66688);

(statearr_66749_66817[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (13))){
var inst_66626 = (state_66731[(17)]);
var inst_66628 = fluree.db.time_travel.block_to_int_format(db,inst_66626);
var state_66731__$1 = state_66731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66731__$1,(16),inst_66628);
} else {
if((state_val_66732 === (22))){
var inst_66659 = (state_66731[(2)]);
var state_66731__$1 = state_66731;
if(cljs.core.truth_(inst_66659)){
var statearr_66750_66818 = state_66731__$1;
(statearr_66750_66818[(1)] = (23));

} else {
var statearr_66751_66819 = state_66731__$1;
(statearr_66751_66819[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (36))){
var state_66731__$1 = state_66731;
var statearr_66752_66820 = state_66731__$1;
(statearr_66752_66820[(2)] = null);

(statearr_66752_66820[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (41))){
var inst_66642 = (state_66731[(13)]);
var state_66731__$1 = state_66731;
var statearr_66753_66821 = state_66731__$1;
(statearr_66753_66821[(2)] = inst_66642);

(statearr_66753_66821[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (43))){
var inst_66717 = (state_66731[(15)]);
var inst_66723 = (state_66731[(2)]);
var inst_66724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66725 = [inst_66717,inst_66723];
var inst_66726 = (new cljs.core.PersistentVector(null,2,(5),inst_66724,inst_66725,null));
var _ = (function (){var statearr_66754 = state_66731;
(statearr_66754[(4)] = cljs.core.rest((state_66731[(4)])));

return statearr_66754;
})();
var state_66731__$1 = state_66731;
var statearr_66755_66822 = state_66731__$1;
(statearr_66755_66822[(2)] = inst_66726);

(statearr_66755_66822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (29))){
var inst_66617 = (state_66731[(18)]);
var inst_66672 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66617], 0));
var inst_66673 = ["Invalid block range provided: ",inst_66672].join('');
var inst_66674 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66675 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66676 = cljs.core.PersistentHashMap.fromArrays(inst_66674,inst_66675);
var inst_66677 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66673,inst_66676);
var inst_66678 = (function(){throw inst_66677})();
var state_66731__$1 = state_66731;
var statearr_66756_66823 = state_66731__$1;
(statearr_66756_66823[(2)] = inst_66678);

(statearr_66756_66823[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (6))){
var inst_66609 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_66731__$1 = state_66731;
var statearr_66757_66824 = state_66731__$1;
(statearr_66757_66824[(2)] = inst_66609);

(statearr_66757_66824[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (28))){
var inst_66683 = (state_66731[(2)]);
var state_66731__$1 = state_66731;
var statearr_66758_66825 = state_66731__$1;
(statearr_66758_66825[(2)] = inst_66683);

(statearr_66758_66825[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (25))){
var inst_66686 = (state_66731[(10)]);
var inst_66688 = (state_66731[(16)]);
var inst_66685 = (state_66731[(2)]);
var inst_66686__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66685,(0),null);
var inst_66687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66685,(1),null);
var inst_66688__$1 = cljs.core.pos_int_QMARK_(inst_66686__$1);
var state_66731__$1 = (function (){var statearr_66759 = state_66731;
(statearr_66759[(9)] = inst_66687);

(statearr_66759[(10)] = inst_66686__$1);

(statearr_66759[(16)] = inst_66688__$1);

return statearr_66759;
})();
if(inst_66688__$1){
var statearr_66760_66826 = state_66731__$1;
(statearr_66760_66826[(1)] = (32));

} else {
var statearr_66761_66827 = state_66731__$1;
(statearr_66761_66827[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (34))){
var inst_66693 = (state_66731[(2)]);
var inst_66694 = cljs.core.not(inst_66693);
var state_66731__$1 = state_66731;
if(inst_66694){
var statearr_66762_66828 = state_66731__$1;
(statearr_66762_66828[(1)] = (35));

} else {
var statearr_66763_66829 = state_66731__$1;
(statearr_66763_66829[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (17))){
var inst_66642 = (state_66731[(13)]);
var inst_66640 = (state_66731[(8)]);
var inst_66645 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66640], 0));
var inst_66646 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66642], 0));
var inst_66647 = ["Start block is out of range for this ledger. Start block provided: ",inst_66645,". Database block: ",inst_66646].join('');
var inst_66648 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66649 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66650 = cljs.core.PersistentHashMap.fromArrays(inst_66648,inst_66649);
var inst_66651 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66647,inst_66650);
var inst_66652 = (function(){throw inst_66651})();
var state_66731__$1 = state_66731;
var statearr_66764_66830 = state_66731__$1;
(statearr_66764_66830[(2)] = inst_66652);

(statearr_66764_66830[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (3))){
var inst_66729 = (state_66731[(2)]);
var state_66731__$1 = state_66731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66731__$1,inst_66729);
} else {
if((state_val_66732 === (12))){
var inst_66626 = (state_66731[(17)]);
var inst_66617 = (state_66731[(18)]);
var inst_66624 = (state_66731[(2)]);
var inst_66625 = fluree.db.util.async.throw_err(inst_66624);
var inst_66626__$1 = cljs.core.second(inst_66617);
var state_66731__$1 = (function (){var statearr_66765 = state_66731;
(statearr_66765[(17)] = inst_66626__$1);

(statearr_66765[(12)] = inst_66625);

return statearr_66765;
})();
if(cljs.core.truth_(inst_66626__$1)){
var statearr_66766_66831 = state_66731__$1;
(statearr_66766_66831[(1)] = (13));

} else {
var statearr_66767_66832 = state_66731__$1;
(statearr_66767_66832[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (2))){
var _ = (function (){var statearr_66768 = state_66731;
(statearr_66768[(4)] = cljs.core.cons((5),(state_66731[(4)])));

return statearr_66768;
})();
var inst_66606 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_66607 = cljs.core.sequential_QMARK_(inst_66606);
var state_66731__$1 = state_66731;
if(inst_66607){
var statearr_66769_66833 = state_66731__$1;
(statearr_66769_66833[(1)] = (6));

} else {
var statearr_66770_66834 = state_66731__$1;
(statearr_66770_66834[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (23))){
var inst_66641 = (state_66731[(7)]);
var inst_66640 = (state_66731[(8)]);
var inst_66661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66662 = [inst_66640,inst_66641];
var inst_66663 = (new cljs.core.PersistentVector(null,2,(5),inst_66661,inst_66662,null));
var state_66731__$1 = state_66731;
var statearr_66771_66835 = state_66731__$1;
(statearr_66771_66835[(2)] = inst_66663);

(statearr_66771_66835[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (35))){
var inst_66617 = (state_66731[(18)]);
var inst_66696 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66617], 0));
var inst_66697 = ["Invalid block range provided: ",inst_66696].join('');
var inst_66698 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66699 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66700 = cljs.core.PersistentHashMap.fromArrays(inst_66698,inst_66699);
var inst_66701 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66697,inst_66700);
var inst_66702 = (function(){throw inst_66701})();
var state_66731__$1 = state_66731;
var statearr_66772_66836 = state_66731__$1;
(statearr_66772_66836[(2)] = inst_66702);

(statearr_66772_66836[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (19))){
var inst_66640 = (state_66731[(8)]);
var inst_66655 = (state_66731[(2)]);
var state_66731__$1 = (function (){var statearr_66773 = state_66731;
(statearr_66773[(19)] = inst_66655);

return statearr_66773;
})();
if(cljs.core.truth_(inst_66640)){
var statearr_66774_66837 = state_66731__$1;
(statearr_66774_66837[(1)] = (20));

} else {
var statearr_66775_66838 = state_66731__$1;
(statearr_66775_66838[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (11))){
var inst_66642 = (state_66731[(13)]);
var inst_66640 = (state_66731[(8)]);
var inst_66639 = (state_66731[(2)]);
var inst_66640__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66639,(0),null);
var inst_66641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66639,(1),null);
var inst_66642__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_66643 = (inst_66640__$1 > inst_66642__$1);
var state_66731__$1 = (function (){var statearr_66777 = state_66731;
(statearr_66777[(13)] = inst_66642__$1);

(statearr_66777[(7)] = inst_66641);

(statearr_66777[(8)] = inst_66640__$1);

return statearr_66777;
})();
if(cljs.core.truth_(inst_66643)){
var statearr_66778_66839 = state_66731__$1;
(statearr_66778_66839[(1)] = (17));

} else {
var statearr_66779_66840 = state_66731__$1;
(statearr_66779_66840[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (9))){
var inst_66617 = (state_66731[(18)]);
var inst_66620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66621 = cljs.core.first(inst_66617);
var inst_66622 = fluree.db.time_travel.block_to_int_format(db,inst_66621);
var state_66731__$1 = (function (){var statearr_66780 = state_66731;
(statearr_66780[(11)] = inst_66620);

return statearr_66780;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66731__$1,(12),inst_66622);
} else {
if((state_val_66732 === (5))){
var _ = (function (){var statearr_66781 = state_66731;
(statearr_66781[(4)] = cljs.core.rest((state_66731[(4)])));

return statearr_66781;
})();
var state_66731__$1 = state_66731;
var ex66776 = (state_66731__$1[(2)]);
var statearr_66782_66841 = state_66731__$1;
(statearr_66782_66841[(5)] = ex66776);


if((ex66776 instanceof Error)){
var statearr_66783_66842 = state_66731__$1;
(statearr_66783_66842[(1)] = (4));

(statearr_66783_66842[(5)] = null);

} else {
throw ex66776;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (14))){
var state_66731__$1 = state_66731;
var statearr_66784_66843 = state_66731__$1;
(statearr_66784_66843[(2)] = null);

(statearr_66784_66843[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (26))){
var inst_66640 = (state_66731[(8)]);
var inst_66666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66667 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_66668 = [inst_66640,inst_66667];
var inst_66669 = (new cljs.core.PersistentVector(null,2,(5),inst_66666,inst_66668,null));
var state_66731__$1 = state_66731;
var statearr_66785_66844 = state_66731__$1;
(statearr_66785_66844[(2)] = inst_66669);

(statearr_66785_66844[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (16))){
var inst_66630 = (state_66731[(2)]);
var inst_66631 = fluree.db.util.async.throw_err(inst_66630);
var state_66731__$1 = state_66731;
var statearr_66786_66845 = state_66731__$1;
(statearr_66786_66845[(2)] = inst_66631);

(statearr_66786_66845[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (38))){
var inst_66687 = (state_66731[(9)]);
var inst_66686 = (state_66731[(10)]);
var inst_66708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66709 = [inst_66687,inst_66686];
var inst_66710 = (new cljs.core.PersistentVector(null,2,(5),inst_66708,inst_66709,null));
var state_66731__$1 = state_66731;
var statearr_66787_66846 = state_66731__$1;
(statearr_66787_66846[(2)] = inst_66710);

(statearr_66787_66846[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (30))){
var state_66731__$1 = state_66731;
var statearr_66788_66847 = state_66731__$1;
(statearr_66788_66847[(2)] = null);

(statearr_66788_66847[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (10))){
var inst_66617 = (state_66731[(18)]);
var state_66731__$1 = state_66731;
var statearr_66789_66848 = state_66731__$1;
(statearr_66789_66848[(2)] = inst_66617);

(statearr_66789_66848[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (18))){
var state_66731__$1 = state_66731;
var statearr_66790_66849 = state_66731__$1;
(statearr_66790_66849[(2)] = null);

(statearr_66790_66849[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (42))){
var inst_66718 = (state_66731[(14)]);
var state_66731__$1 = state_66731;
var statearr_66791_66850 = state_66731__$1;
(statearr_66791_66850[(2)] = inst_66718);

(statearr_66791_66850[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (37))){
var inst_66687 = (state_66731[(9)]);
var inst_66686 = (state_66731[(10)]);
var inst_66705 = (state_66731[(2)]);
var inst_66706 = (inst_66687 < inst_66686);
var state_66731__$1 = (function (){var statearr_66792 = state_66731;
(statearr_66792[(20)] = inst_66705);

return statearr_66792;
})();
if(cljs.core.truth_(inst_66706)){
var statearr_66793_66851 = state_66731__$1;
(statearr_66793_66851[(1)] = (38));

} else {
var statearr_66794_66852 = state_66731__$1;
(statearr_66794_66852[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66732 === (8))){
var inst_66617 = (state_66731[(18)]);
var inst_66617__$1 = (state_66731[(2)]);
var inst_66618 = cljs.core.some(cljs.core.string_QMARK_,inst_66617__$1);
var state_66731__$1 = (function (){var statearr_66795 = state_66731;
(statearr_66795[(18)] = inst_66617__$1);

return statearr_66795;
})();
if(cljs.core.truth_(inst_66618)){
var statearr_66796_66853 = state_66731__$1;
(statearr_66796_66853[(1)] = (9));

} else {
var statearr_66797_66854 = state_66731__$1;
(statearr_66797_66854[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0 = (function (){
var statearr_66798 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66798[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__);

(statearr_66798[(1)] = (1));

return statearr_66798;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1 = (function (state_66731){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66731);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66799){var ex__2687__auto__ = e66799;
var statearr_66800_66855 = state_66731;
(statearr_66800_66855[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66731[(4)]))){
var statearr_66801_66856 = state_66731;
(statearr_66801_66856[(1)] = cljs.core.first((state_66731[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66857 = state_66731;
state_66731 = G__66857;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__ = function(state_66731){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1.call(this,state_66731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66802 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66802[(6)] = c__2706__auto__);

return statearr_66802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67009){
var state_val_67010 = (state_67009[(1)]);
if((state_val_67010 === (7))){
var inst_66919 = (state_67009[(2)]);
var inst_66920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66919,(0),null);
var inst_66921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66919,(1),null);
var inst_66929 = cljs.core.vals(inst_66921);
var inst_66930 = cljs.core.seq(inst_66929);
var inst_66931 = cljs.core.first(inst_66930);
var inst_66932 = cljs.core.next(inst_66930);
var inst_66933 = cljs.core.PersistentVector.EMPTY;
var inst_66934 = inst_66929;
var inst_66935 = inst_66933;
var state_67009__$1 = (function (){var statearr_67011 = state_67009;
(statearr_67011[(7)] = inst_66934);

(statearr_67011[(8)] = inst_66920);

(statearr_67011[(9)] = inst_66932);

(statearr_67011[(10)] = inst_66935);

(statearr_67011[(11)] = inst_66931);

return statearr_67011;
})();
var statearr_67012_67065 = state_67009__$1;
(statearr_67012_67065[(2)] = null);

(statearr_67012_67065[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (20))){
var inst_66941 = (state_67009[(12)]);
var inst_66946 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_66947 = cljs.core.PersistentHashMap.EMPTY;
var inst_66948 = [true,inst_66947];
var inst_66949 = cljs.core.PersistentHashMap.fromArrays(inst_66946,inst_66948);
var inst_66950 = cljs.core.PersistentHashMap.EMPTY;
var inst_66951 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_66949,inst_66950,inst_66941);
var state_67009__$1 = state_67009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67009__$1,(22),inst_66951);
} else {
if((state_val_67010 === (27))){
var inst_66997 = (state_67009[(2)]);
var state_67009__$1 = state_67009;
var statearr_67013_67066 = state_67009__$1;
(statearr_67013_67066[(2)] = inst_66997);

(statearr_67013_67066[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (1))){
var state_67009__$1 = state_67009;
var statearr_67014_67067 = state_67009__$1;
(statearr_67014_67067[(2)] = null);

(statearr_67014_67067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (24))){
var inst_66960 = (state_67009[(13)]);
var inst_66999 = (state_67009[(2)]);
var inst_67000 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_67001 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_67002 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_67003 = [inst_67001,inst_67002,inst_66960,inst_66999];
var inst_67004 = cljs.core.PersistentHashMap.fromArrays(inst_67000,inst_67003);
var _ = (function (){var statearr_67016 = state_67009;
(statearr_67016[(4)] = cljs.core.rest((state_67009[(4)])));

return statearr_67016;
})();
var state_67009__$1 = state_67009;
var statearr_67017_67068 = state_67009__$1;
(statearr_67017_67068[(2)] = inst_67004);

(statearr_67017_67068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (4))){
var inst_66860 = (state_67009[(2)]);
var state_67009__$1 = state_67009;
var statearr_67018_67069 = state_67009__$1;
(statearr_67018_67069[(2)] = inst_66860);

(statearr_67018_67069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (15))){
var inst_66883 = (state_67009[(14)]);
var inst_66882 = (state_67009[(15)]);
var inst_66884 = (state_67009[(16)]);
var inst_66898 = (state_67009[(17)]);
var inst_66900 = (state_67009[(18)]);
var inst_66879 = (state_67009[(19)]);
var inst_66876 = (state_67009[(20)]);
var inst_66891 = (state_67009[(21)]);
var inst_66905 = (state_67009[(22)]);
var inst_66890 = (state_67009[(23)]);
var inst_66878 = (state_67009[(24)]);
var inst_66911 = (function (){var subject = inst_66898;
var G__66872 = inst_66882;
var flake = inst_66890;
var seq__66887 = inst_66891;
var vec__66886 = inst_66882;
var vec__66873 = inst_66876;
var r = inst_66891;
var asserted_subjects = inst_66883;
var first__66888 = inst_66890;
var flake_SINGLEQUOTE_ = inst_66905;
var retracted_subjects = inst_66884;
var first__66875 = inst_66878;
var asserted_QMARK_ = inst_66900;
var seq__66874 = inst_66879;
return (function (p1__66859_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__66859_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_66912 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_66884,inst_66898,inst_66911);
var tmp67015 = inst_66883;
var inst_66882__$1 = inst_66891;
var inst_66883__$1 = tmp67015;
var inst_66884__$1 = inst_66912;
var state_67009__$1 = (function (){var statearr_67019 = state_67009;
(statearr_67019[(14)] = inst_66883__$1);

(statearr_67019[(15)] = inst_66882__$1);

(statearr_67019[(16)] = inst_66884__$1);

return statearr_67019;
})();
var statearr_67020_67070 = state_67009__$1;
(statearr_67020_67070[(2)] = null);

(statearr_67020_67070[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (21))){
var inst_66958 = (state_67009[(2)]);
var state_67009__$1 = state_67009;
var statearr_67021_67071 = state_67009__$1;
(statearr_67021_67071[(2)] = inst_66958);

(statearr_67021_67071[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (13))){
var inst_66900 = (state_67009[(18)]);
var inst_66905 = (state_67009[(2)]);
var state_67009__$1 = (function (){var statearr_67022 = state_67009;
(statearr_67022[(22)] = inst_66905);

return statearr_67022;
})();
if(cljs.core.truth_(inst_66900)){
var statearr_67023_67072 = state_67009__$1;
(statearr_67023_67072[(1)] = (14));

} else {
var statearr_67024_67073 = state_67009__$1;
(statearr_67024_67073[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (22))){
var inst_66935 = (state_67009[(10)]);
var inst_66942 = (state_67009[(25)]);
var inst_66953 = (state_67009[(2)]);
var inst_66954 = fluree.db.util.async.throw_err(inst_66953);
var inst_66955 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_66935,inst_66954);
var inst_66934 = inst_66942;
var inst_66935__$1 = inst_66955;
var state_67009__$1 = (function (){var statearr_67025 = state_67009;
(statearr_67025[(7)] = inst_66934);

(statearr_67025[(10)] = inst_66935__$1);

return statearr_67025;
})();
var statearr_67026_67074 = state_67009__$1;
(statearr_67026_67074[(2)] = null);

(statearr_67026_67074[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (6))){
var inst_66882 = (state_67009[(15)]);
var inst_66890 = (state_67009[(23)]);
var inst_66889 = cljs.core.seq(inst_66882);
var inst_66890__$1 = cljs.core.first(inst_66889);
var inst_66891 = cljs.core.next(inst_66889);
var inst_66892 = cljs.core.not(inst_66890__$1);
var state_67009__$1 = (function (){var statearr_67027 = state_67009;
(statearr_67027[(21)] = inst_66891);

(statearr_67027[(23)] = inst_66890__$1);

return statearr_67027;
})();
if(inst_66892){
var statearr_67028_67075 = state_67009__$1;
(statearr_67028_67075[(1)] = (8));

} else {
var statearr_67029_67076 = state_67009__$1;
(statearr_67029_67076[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (28))){
var inst_66981 = (state_67009[(26)]);
var inst_66974 = (state_67009[(27)]);
var inst_66992 = (state_67009[(2)]);
var inst_66993 = fluree.db.util.async.throw_err(inst_66992);
var inst_66994 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_66974,inst_66993);
var inst_66973 = inst_66981;
var inst_66974__$1 = inst_66994;
var state_67009__$1 = (function (){var statearr_67030 = state_67009;
(statearr_67030[(28)] = inst_66973);

(statearr_67030[(27)] = inst_66974__$1);

return statearr_67030;
})();
var statearr_67031_67077 = state_67009__$1;
(statearr_67031_67077[(2)] = null);

(statearr_67031_67077[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (25))){
var inst_66974 = (state_67009[(27)]);
var state_67009__$1 = state_67009;
var statearr_67032_67078 = state_67009__$1;
(statearr_67032_67078[(2)] = inst_66974);

(statearr_67032_67078[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (17))){
var inst_66934 = (state_67009[(7)]);
var inst_66941 = (state_67009[(12)]);
var inst_66940 = cljs.core.seq(inst_66934);
var inst_66941__$1 = cljs.core.first(inst_66940);
var inst_66942 = cljs.core.next(inst_66940);
var inst_66943 = cljs.core.not(inst_66941__$1);
var state_67009__$1 = (function (){var statearr_67033 = state_67009;
(statearr_67033[(25)] = inst_66942);

(statearr_67033[(12)] = inst_66941__$1);

return statearr_67033;
})();
if(inst_66943){
var statearr_67034_67079 = state_67009__$1;
(statearr_67034_67079[(1)] = (19));

} else {
var statearr_67035_67080 = state_67009__$1;
(statearr_67035_67080[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (3))){
var inst_67007 = (state_67009[(2)]);
var state_67009__$1 = state_67009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67009__$1,inst_67007);
} else {
if((state_val_67010 === (12))){
var inst_66890 = (state_67009[(23)]);
var inst_66903 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_66890);
var state_67009__$1 = state_67009;
var statearr_67036_67081 = state_67009__$1;
(statearr_67036_67081[(2)] = inst_66903);

(statearr_67036_67081[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (2))){
var inst_66876 = (state_67009[(20)]);
var _ = (function (){var statearr_67037 = state_67009;
(statearr_67037[(4)] = cljs.core.cons((5),(state_67009[(4)])));

return statearr_67037;
})();
var inst_66876__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_66877 = cljs.core.seq(inst_66876__$1);
var inst_66878 = cljs.core.first(inst_66877);
var inst_66879 = cljs.core.next(inst_66877);
var inst_66880 = cljs.core.PersistentHashMap.EMPTY;
var inst_66881 = cljs.core.PersistentHashMap.EMPTY;
var inst_66882 = inst_66876__$1;
var inst_66883 = inst_66880;
var inst_66884 = inst_66881;
var state_67009__$1 = (function (){var statearr_67038 = state_67009;
(statearr_67038[(14)] = inst_66883);

(statearr_67038[(15)] = inst_66882);

(statearr_67038[(16)] = inst_66884);

(statearr_67038[(19)] = inst_66879);

(statearr_67038[(20)] = inst_66876__$1);

(statearr_67038[(24)] = inst_66878);

return statearr_67038;
})();
var statearr_67039_67082 = state_67009__$1;
(statearr_67039_67082[(2)] = null);

(statearr_67039_67082[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (23))){
var inst_66980 = (state_67009[(29)]);
var inst_66973 = (state_67009[(28)]);
var inst_66979 = cljs.core.seq(inst_66973);
var inst_66980__$1 = cljs.core.first(inst_66979);
var inst_66981 = cljs.core.next(inst_66979);
var inst_66982 = cljs.core.not(inst_66980__$1);
var state_67009__$1 = (function (){var statearr_67040 = state_67009;
(statearr_67040[(29)] = inst_66980__$1);

(statearr_67040[(26)] = inst_66981);

return statearr_67040;
})();
if(inst_66982){
var statearr_67041_67083 = state_67009__$1;
(statearr_67041_67083[(1)] = (25));

} else {
var statearr_67042_67084 = state_67009__$1;
(statearr_67042_67084[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (19))){
var inst_66935 = (state_67009[(10)]);
var state_67009__$1 = state_67009;
var statearr_67043_67085 = state_67009__$1;
(statearr_67043_67085[(2)] = inst_66935);

(statearr_67043_67085[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (11))){
var inst_66890 = (state_67009[(23)]);
var state_67009__$1 = state_67009;
var statearr_67045_67086 = state_67009__$1;
(statearr_67045_67086[(2)] = inst_66890);

(statearr_67045_67086[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (9))){
var inst_66900 = (state_67009[(18)]);
var inst_66890 = (state_67009[(23)]);
var inst_66898 = fluree.db.flake.s(inst_66890);
var inst_66899 = fluree.db.flake.op(inst_66890);
var inst_66900__$1 = inst_66899 === true;
var state_67009__$1 = (function (){var statearr_67047 = state_67009;
(statearr_67047[(17)] = inst_66898);

(statearr_67047[(18)] = inst_66900__$1);

return statearr_67047;
})();
if(cljs.core.truth_(inst_66900__$1)){
var statearr_67048_67087 = state_67009__$1;
(statearr_67048_67087[(1)] = (11));

} else {
var statearr_67049_67088 = state_67009__$1;
(statearr_67049_67088[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (5))){
var _ = (function (){var statearr_67050 = state_67009;
(statearr_67050[(4)] = cljs.core.rest((state_67009[(4)])));

return statearr_67050;
})();
var state_67009__$1 = state_67009;
var ex67044 = (state_67009__$1[(2)]);
var statearr_67051_67089 = state_67009__$1;
(statearr_67051_67089[(5)] = ex67044);


if((ex67044 instanceof Error)){
var statearr_67052_67090 = state_67009__$1;
(statearr_67052_67090[(1)] = (4));

(statearr_67052_67090[(5)] = null);

} else {
throw ex67044;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (14))){
var inst_66883 = (state_67009[(14)]);
var inst_66882 = (state_67009[(15)]);
var inst_66884 = (state_67009[(16)]);
var inst_66898 = (state_67009[(17)]);
var inst_66900 = (state_67009[(18)]);
var inst_66879 = (state_67009[(19)]);
var inst_66876 = (state_67009[(20)]);
var inst_66891 = (state_67009[(21)]);
var inst_66905 = (state_67009[(22)]);
var inst_66890 = (state_67009[(23)]);
var inst_66878 = (state_67009[(24)]);
var inst_66907 = (function (){var subject = inst_66898;
var G__66872 = inst_66882;
var flake = inst_66890;
var seq__66887 = inst_66891;
var vec__66886 = inst_66882;
var vec__66873 = inst_66876;
var r = inst_66891;
var asserted_subjects = inst_66883;
var first__66888 = inst_66890;
var flake_SINGLEQUOTE_ = inst_66905;
var retracted_subjects = inst_66884;
var first__66875 = inst_66878;
var asserted_QMARK_ = inst_66900;
var seq__66874 = inst_66879;
return (function (p1__66858_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__66858_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_66908 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_66883,inst_66898,inst_66907);
var tmp67046 = inst_66884;
var inst_66882__$1 = inst_66891;
var inst_66883__$1 = inst_66908;
var inst_66884__$1 = tmp67046;
var state_67009__$1 = (function (){var statearr_67053 = state_67009;
(statearr_67053[(14)] = inst_66883__$1);

(statearr_67053[(15)] = inst_66882__$1);

(statearr_67053[(16)] = inst_66884__$1);

return statearr_67053;
})();
var statearr_67054_67091 = state_67009__$1;
(statearr_67054_67091[(2)] = null);

(statearr_67054_67091[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (26))){
var inst_66980 = (state_67009[(29)]);
var inst_66985 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_66986 = cljs.core.PersistentHashMap.EMPTY;
var inst_66987 = [true,inst_66986];
var inst_66988 = cljs.core.PersistentHashMap.fromArrays(inst_66985,inst_66987);
var inst_66989 = cljs.core.PersistentHashMap.EMPTY;
var inst_66990 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_66988,inst_66989,inst_66980);
var state_67009__$1 = state_67009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67009__$1,(28),inst_66990);
} else {
if((state_val_67010 === (16))){
var inst_66915 = (state_67009[(2)]);
var state_67009__$1 = state_67009;
var statearr_67055_67092 = state_67009__$1;
(statearr_67055_67092[(2)] = inst_66915);

(statearr_67055_67092[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (10))){
var inst_66917 = (state_67009[(2)]);
var state_67009__$1 = state_67009;
var statearr_67056_67093 = state_67009__$1;
(statearr_67056_67093[(2)] = inst_66917);

(statearr_67056_67093[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (18))){
var inst_66920 = (state_67009[(8)]);
var inst_66960 = (state_67009[(2)]);
var inst_66968 = cljs.core.vals(inst_66920);
var inst_66969 = cljs.core.seq(inst_66968);
var inst_66970 = cljs.core.first(inst_66969);
var inst_66971 = cljs.core.next(inst_66969);
var inst_66972 = cljs.core.PersistentVector.EMPTY;
var inst_66973 = inst_66968;
var inst_66974 = inst_66972;
var state_67009__$1 = (function (){var statearr_67057 = state_67009;
(statearr_67057[(28)] = inst_66973);

(statearr_67057[(30)] = inst_66971);

(statearr_67057[(31)] = inst_66970);

(statearr_67057[(27)] = inst_66974);

(statearr_67057[(13)] = inst_66960);

return statearr_67057;
})();
var statearr_67058_67094 = state_67009__$1;
(statearr_67058_67094[(2)] = null);

(statearr_67058_67094[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67010 === (8))){
var inst_66883 = (state_67009[(14)]);
var inst_66884 = (state_67009[(16)]);
var inst_66894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66895 = [inst_66883,inst_66884];
var inst_66896 = (new cljs.core.PersistentVector(null,2,(5),inst_66894,inst_66895,null));
var state_67009__$1 = state_67009;
var statearr_67059_67095 = state_67009__$1;
(statearr_67059_67095[(2)] = inst_66896);

(statearr_67059_67095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_67060 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67060[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__);

(statearr_67060[(1)] = (1));

return statearr_67060;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1 = (function (state_67009){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67009);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67061){var ex__2687__auto__ = e67061;
var statearr_67062_67096 = state_67009;
(statearr_67062_67096[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67009[(4)]))){
var statearr_67063_67097 = state_67009;
(statearr_67063_67097[(1)] = cljs.core.first((state_67009[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67098 = state_67009;
state_67009 = G__67098;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__ = function(state_67009){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1.call(this,state_67009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67064 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67064[(6)] = c__2706__auto__);

return statearr_67064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67130){
var state_val_67131 = (state_67130[(1)]);
if((state_val_67131 === (1))){
var inst_67099 = cljs.core.volatile_BANG_((0));
var inst_67100 = cljs.core.PersistentHashMap.EMPTY;
var inst_67101 = cljs.core.volatile_BANG_(inst_67100);
var inst_67102 = cljs.core.first(resp);
var inst_67103 = cljs.core.rest(resp);
var inst_67104 = cljs.core.PersistentVector.EMPTY;
var inst_67105 = inst_67099;
var inst_67106 = inst_67101;
var inst_67107 = inst_67102;
var inst_67108 = inst_67103;
var inst_67109 = inst_67104;
var state_67130__$1 = (function (){var statearr_67132 = state_67130;
(statearr_67132[(7)] = inst_67107);

(statearr_67132[(8)] = inst_67108);

(statearr_67132[(9)] = inst_67109);

(statearr_67132[(10)] = inst_67105);

(statearr_67132[(11)] = inst_67106);

return statearr_67132;
})();
var statearr_67133_67148 = state_67130__$1;
(statearr_67133_67148[(2)] = null);

(statearr_67133_67148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67131 === (2))){
var inst_67107 = (state_67130[(7)]);
var inst_67105 = (state_67130[(10)]);
var inst_67106 = (state_67130[(11)]);
var inst_67111 = fluree.db.api.query.format_block_resp_pretty(db,inst_67107,inst_67106,inst_67105);
var state_67130__$1 = state_67130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67130__$1,(4),inst_67111);
} else {
if((state_val_67131 === (3))){
var inst_67128 = (state_67130[(2)]);
var state_67130__$1 = state_67130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67130__$1,inst_67128);
} else {
if((state_val_67131 === (4))){
var inst_67108 = (state_67130[(8)]);
var inst_67109 = (state_67130[(9)]);
var inst_67113 = (state_67130[(2)]);
var inst_67114 = fluree.db.util.async.throw_err(inst_67113);
var inst_67115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67116 = [inst_67114];
var inst_67117 = (new cljs.core.PersistentVector(null,1,(5),inst_67115,inst_67116,null));
var inst_67118 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_67109,inst_67117);
var inst_67119 = cljs.core.first(inst_67108);
var state_67130__$1 = (function (){var statearr_67136 = state_67130;
(statearr_67136[(12)] = inst_67118);

return statearr_67136;
})();
if(cljs.core.truth_(inst_67119)){
var statearr_67137_67149 = state_67130__$1;
(statearr_67137_67149[(1)] = (5));

} else {
var statearr_67138_67150 = state_67130__$1;
(statearr_67138_67150[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67131 === (5))){
var inst_67108 = (state_67130[(8)]);
var inst_67118 = (state_67130[(12)]);
var inst_67105 = (state_67130[(10)]);
var inst_67106 = (state_67130[(11)]);
var inst_67121 = cljs.core.first(inst_67108);
var inst_67122 = cljs.core.rest(inst_67108);
var tmp67134 = inst_67105;
var tmp67135 = inst_67106;
var inst_67105__$1 = tmp67134;
var inst_67106__$1 = tmp67135;
var inst_67107 = inst_67121;
var inst_67108__$1 = inst_67122;
var inst_67109 = inst_67118;
var state_67130__$1 = (function (){var statearr_67139 = state_67130;
(statearr_67139[(7)] = inst_67107);

(statearr_67139[(8)] = inst_67108__$1);

(statearr_67139[(9)] = inst_67109);

(statearr_67139[(10)] = inst_67105__$1);

(statearr_67139[(11)] = inst_67106__$1);

return statearr_67139;
})();
var statearr_67140_67151 = state_67130__$1;
(statearr_67140_67151[(2)] = null);

(statearr_67140_67151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67131 === (6))){
var inst_67118 = (state_67130[(12)]);
var state_67130__$1 = state_67130;
var statearr_67141_67152 = state_67130__$1;
(statearr_67141_67152[(2)] = inst_67118);

(statearr_67141_67152[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67131 === (7))){
var inst_67126 = (state_67130[(2)]);
var state_67130__$1 = state_67130;
var statearr_67142_67153 = state_67130__$1;
(statearr_67142_67153[(2)] = inst_67126);

(statearr_67142_67153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_67143 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67143[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__);

(statearr_67143[(1)] = (1));

return statearr_67143;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1 = (function (state_67130){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67130);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67144){var ex__2687__auto__ = e67144;
var statearr_67145_67154 = state_67130;
(statearr_67145_67154[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67130[(4)]))){
var statearr_67146_67155 = state_67130;
(statearr_67146_67155[(1)] = cljs.core.first((state_67130[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67156 = state_67130;
state_67130 = G__67156;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__ = function(state_67130){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1.call(this,state_67130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67147 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67147[(6)] = c__2706__auto__);

return statearr_67147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__67158 = arguments.length;
switch (G__67158) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__67160){
var map__67161 = p__67160;
var map__67161__$1 = cljs.core.__destructure_map(map__67161);
var query = map__67161__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67161__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67246){
var state_val_67247 = (state_67246[(1)]);
if((state_val_67247 === (7))){
var inst_67172 = (state_67246[(7)]);
var inst_67176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67177 = ["_auth/id",inst_67172];
var inst_67178 = (new cljs.core.PersistentVector(null,2,(5),inst_67176,inst_67177,null));
var state_67246__$1 = state_67246;
var statearr_67248_67292 = state_67246__$1;
(statearr_67248_67292[(2)] = inst_67178);

(statearr_67248_67292[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (20))){
var inst_67226 = (state_67246[(2)]);
var inst_67227 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_67246__$1 = (function (){var statearr_67249 = state_67246;
(statearr_67249[(8)] = inst_67226);

return statearr_67249;
})();
if(cljs.core.truth_(inst_67227)){
var statearr_67250_67293 = state_67246__$1;
(statearr_67250_67293[(1)] = (22));

} else {
var statearr_67251_67294 = state_67246__$1;
(statearr_67251_67294[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (27))){
var inst_67173 = (state_67246[(9)]);
var inst_67229 = (state_67246[(10)]);
var inst_67235 = (state_67246[(2)]);
var inst_67236 = fluree.db.util.core.response_time_formatted(inst_67173);
var inst_67237 = [(200),inst_67235,(100),inst_67236];
var inst_67238 = cljs.core.PersistentHashMap.fromArrays(inst_67229,inst_67237);
var state_67246__$1 = state_67246;
var statearr_67252_67295 = state_67246__$1;
(statearr_67252_67295[(2)] = inst_67238);

(statearr_67252_67295[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (1))){
var state_67246__$1 = state_67246;
var statearr_67253_67296 = state_67246__$1;
(statearr_67253_67296[(2)] = null);

(statearr_67253_67296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (24))){
var inst_67241 = (state_67246[(2)]);
var _ = (function (){var statearr_67254 = state_67246;
(statearr_67254[(4)] = cljs.core.rest((state_67246[(4)])));

return statearr_67254;
})();
var state_67246__$1 = state_67246;
var statearr_67255_67297 = state_67246__$1;
(statearr_67255_67297[(2)] = inst_67241);

(statearr_67255_67297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (4))){
var inst_67162 = (state_67246[(2)]);
var state_67246__$1 = state_67246;
var statearr_67256_67298 = state_67246__$1;
(statearr_67256_67298[(2)] = inst_67162);

(statearr_67256_67298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (15))){
var inst_67213 = (state_67246[(11)]);
var state_67246__$1 = state_67246;
var statearr_67257_67299 = state_67246__$1;
(statearr_67257_67299[(2)] = inst_67213);

(statearr_67257_67299[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (21))){
var inst_67222 = (state_67246[(2)]);
var inst_67223 = fluree.db.util.async.throw_err(inst_67222);
var state_67246__$1 = state_67246;
var statearr_67258_67300 = state_67246__$1;
(statearr_67258_67300[(2)] = inst_67223);

(statearr_67258_67300[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (13))){
var inst_67171 = (state_67246[(12)]);
var inst_67213 = (state_67246[(11)]);
var inst_67212 = (state_67246[(2)]);
var inst_67213__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_67171);
var state_67246__$1 = (function (){var statearr_67259 = state_67246;
(statearr_67259[(13)] = inst_67212);

(statearr_67259[(11)] = inst_67213__$1);

return statearr_67259;
})();
if(cljs.core.truth_(inst_67213__$1)){
var statearr_67260_67301 = state_67246__$1;
(statearr_67260_67301[(1)] = (15));

} else {
var statearr_67261_67302 = state_67246__$1;
(statearr_67261_67302[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (22))){
var inst_67226 = (state_67246[(8)]);
var inst_67229 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_67230 = cljs.core.sequential_QMARK_(inst_67226);
var state_67246__$1 = (function (){var statearr_67262 = state_67246;
(statearr_67262[(10)] = inst_67229);

return statearr_67262;
})();
if(inst_67230){
var statearr_67263_67303 = state_67246__$1;
(statearr_67263_67303[(1)] = (25));

} else {
var statearr_67264_67304 = state_67246__$1;
(statearr_67264_67304[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (6))){
var inst_67171 = (state_67246[(12)]);
var inst_67187 = (state_67246[(14)]);
var inst_67186 = (state_67246[(2)]);
var inst_67187__$1 = fluree.db.util.async.throw_err(inst_67186);
var inst_67188 = fluree.db.api.query.resolve_block_range(inst_67187__$1,inst_67171);
var state_67246__$1 = (function (){var statearr_67265 = state_67246;
(statearr_67265[(14)] = inst_67187__$1);

return statearr_67265;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67246__$1,(10),inst_67188);
} else {
if((state_val_67247 === (25))){
var inst_67226 = (state_67246[(8)]);
var inst_67232 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_67226);
var state_67246__$1 = state_67246;
var statearr_67266_67305 = state_67246__$1;
(statearr_67266_67305[(2)] = inst_67232);

(statearr_67266_67305[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (17))){
var inst_67218 = (state_67246[(2)]);
var state_67246__$1 = state_67246;
if(cljs.core.truth_(inst_67218)){
var statearr_67267_67306 = state_67246__$1;
(statearr_67267_67306[(1)] = (18));

} else {
var statearr_67268_67307 = state_67246__$1;
(statearr_67268_67307[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (3))){
var inst_67244 = (state_67246[(2)]);
var state_67246__$1 = state_67246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67246__$1,inst_67244);
} else {
if((state_val_67247 === (12))){
var inst_67171 = (state_67246[(12)]);
var inst_67204 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67171], 0));
var inst_67205 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_67204].join('');
var inst_67206 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67207 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_67208 = cljs.core.PersistentHashMap.fromArrays(inst_67206,inst_67207);
var inst_67209 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67205,inst_67208);
var inst_67210 = (function(){throw inst_67209})();
var state_67246__$1 = state_67246;
var statearr_67269_67308 = state_67246__$1;
(statearr_67269_67308[(2)] = inst_67210);

(statearr_67269_67308[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (2))){
var inst_67172 = (state_67246[(7)]);
var _ = (function (){var statearr_67270 = state_67246;
(statearr_67270[(4)] = cljs.core.cons((5),(state_67246[(4)])));

return statearr_67270;
})();
var inst_67171 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_67172__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_67173 = fluree.db.util.core.current_time_millis();
var inst_67174 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_67246__$1 = (function (){var statearr_67271 = state_67246;
(statearr_67271[(9)] = inst_67173);

(statearr_67271[(15)] = inst_67174);

(statearr_67271[(12)] = inst_67171);

(statearr_67271[(7)] = inst_67172__$1);

return statearr_67271;
})();
if(cljs.core.truth_(inst_67172__$1)){
var statearr_67272_67309 = state_67246__$1;
(statearr_67272_67309[(1)] = (7));

} else {
var statearr_67273_67310 = state_67246__$1;
(statearr_67273_67310[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (23))){
var inst_67226 = (state_67246[(8)]);
var state_67246__$1 = state_67246;
var statearr_67274_67311 = state_67246__$1;
(statearr_67274_67311[(2)] = inst_67226);

(statearr_67274_67311[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (19))){
var inst_67212 = (state_67246[(13)]);
var state_67246__$1 = state_67246;
var statearr_67275_67312 = state_67246__$1;
(statearr_67275_67312[(2)] = inst_67212);

(statearr_67275_67312[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (11))){
var inst_67187 = (state_67246[(14)]);
var inst_67192 = (state_67246[(16)]);
var inst_67193 = (state_67246[(17)]);
var inst_67199 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_67187,inst_67192,inst_67193,opts);
var state_67246__$1 = state_67246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67246__$1,(14),inst_67199);
} else {
if((state_val_67247 === (9))){
var inst_67174 = (state_67246[(15)]);
var inst_67181 = (state_67246[(2)]);
var inst_67182 = [inst_67181];
var inst_67183 = cljs.core.PersistentHashMap.fromArrays(inst_67174,inst_67182);
var inst_67184 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_67183);
var state_67246__$1 = state_67246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67246__$1,(6),inst_67184);
} else {
if((state_val_67247 === (5))){
var _ = (function (){var statearr_67277 = state_67246;
(statearr_67277[(4)] = cljs.core.rest((state_67246[(4)])));

return statearr_67277;
})();
var state_67246__$1 = state_67246;
var ex67276 = (state_67246__$1[(2)]);
var statearr_67278_67313 = state_67246__$1;
(statearr_67278_67313[(5)] = ex67276);


if((ex67276 instanceof Error)){
var statearr_67279_67314 = state_67246__$1;
(statearr_67279_67314[(1)] = (4));

(statearr_67279_67314[(5)] = null);

} else {
throw ex67276;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (14))){
var inst_67201 = (state_67246[(2)]);
var inst_67202 = fluree.db.util.async.throw_err(inst_67201);
var state_67246__$1 = state_67246;
var statearr_67280_67315 = state_67246__$1;
(statearr_67280_67315[(2)] = inst_67202);

(statearr_67280_67315[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (26))){
var inst_67226 = (state_67246[(8)]);
var state_67246__$1 = state_67246;
var statearr_67281_67316 = state_67246__$1;
(statearr_67281_67316[(2)] = inst_67226);

(statearr_67281_67316[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (16))){
var inst_67171 = (state_67246[(12)]);
var inst_67216 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_67171);
var state_67246__$1 = state_67246;
var statearr_67282_67317 = state_67246__$1;
(statearr_67282_67317[(2)] = inst_67216);

(statearr_67282_67317[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (10))){
var inst_67171 = (state_67246[(12)]);
var inst_67190 = (state_67246[(2)]);
var inst_67191 = fluree.db.util.async.throw_err(inst_67190);
var inst_67192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67191,(0),null);
var inst_67193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67191,(1),null);
var inst_67194 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_67195 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_67171,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_67196 = cljs.core.keys(inst_67195);
var inst_67197 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67194,inst_67196);
var state_67246__$1 = (function (){var statearr_67283 = state_67246;
(statearr_67283[(16)] = inst_67192);

(statearr_67283[(17)] = inst_67193);

return statearr_67283;
})();
if(inst_67197){
var statearr_67284_67318 = state_67246__$1;
(statearr_67284_67318[(1)] = (11));

} else {
var statearr_67285_67319 = state_67246__$1;
(statearr_67285_67319[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67247 === (18))){
var inst_67212 = (state_67246[(13)]);
var inst_67187 = (state_67246[(14)]);
var inst_67220 = fluree.db.api.query.format_blocks_resp_pretty(inst_67187,inst_67212);
var state_67246__$1 = state_67246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67246__$1,(21),inst_67220);
} else {
if((state_val_67247 === (8))){
var state_67246__$1 = state_67246;
var statearr_67286_67320 = state_67246__$1;
(statearr_67286_67320[(2)] = null);

(statearr_67286_67320[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_67287 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67287[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2684__auto__);

(statearr_67287[(1)] = (1));

return statearr_67287;
});
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1 = (function (state_67246){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67246);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67288){var ex__2687__auto__ = e67288;
var statearr_67289_67321 = state_67246;
(statearr_67289_67321[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67246[(4)]))){
var statearr_67290_67322 = state_67246;
(statearr_67290_67322[(1)] = cljs.core.first((state_67246[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67323 = state_67246;
state_67246 = G__67323;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__ = function(state_67246){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1.call(this,state_67246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67291 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67291[(6)] = c__2706__auto__);

return statearr_67291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__67324 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67324,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67324,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67324,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67324,(3),null);
var vec__67327 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67327,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67327,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__67330 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t(flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67330,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67330,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67334 = arguments.length;
var i__5770__auto___67335 = (0);
while(true){
if((i__5770__auto___67335 < len__5769__auto___67334)){
args__5775__auto__.push((arguments[i__5770__auto___67335]));

var G__67336 = (i__5770__auto___67335 + (1));
i__5770__auto___67335 = G__67336;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq67333){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67333));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67532){
var state_val_67533 = (state_67532[(1)]);
if((state_val_67533 === (7))){
var inst_67452 = (state_67532[(7)]);
var inst_67459 = (state_67532[(8)]);
var inst_67458 = cljs.core.seq(inst_67452);
var inst_67459__$1 = cljs.core.first(inst_67458);
var inst_67460 = cljs.core.next(inst_67458);
var state_67532__$1 = (function (){var statearr_67534 = state_67532;
(statearr_67534[(8)] = inst_67459__$1);

(statearr_67534[(9)] = inst_67460);

return statearr_67534;
})();
if(cljs.core.truth_(inst_67459__$1)){
var statearr_67535_67635 = state_67532__$1;
(statearr_67535_67635[(1)] = (9));

} else {
var statearr_67536_67636 = state_67532__$1;
(statearr_67536_67636[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (20))){
var inst_67522 = (state_67532[(2)]);
var state_67532__$1 = state_67532;
var statearr_67537_67637 = state_67532__$1;
(statearr_67537_67637[(2)] = inst_67522);

(statearr_67537_67637[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (27))){
var inst_67498 = (state_67532[(10)]);
var inst_67480 = (state_67532[(11)]);
var inst_67477 = (state_67532[(12)]);
var inst_67500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67501 = [inst_67480,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_67502 = (new cljs.core.PersistentVector(null,2,(5),inst_67500,inst_67501,null));
var inst_67503 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_67498,inst_67502,fluree.db.api.query.min_safe,inst_67477);
var state_67532__$1 = state_67532;
var statearr_67538_67638 = state_67532__$1;
(statearr_67538_67638[(2)] = inst_67503);

(statearr_67538_67638[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (1))){
var state_67532__$1 = state_67532;
var statearr_67539_67639 = state_67532__$1;
(statearr_67539_67639[(2)] = null);

(statearr_67539_67639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (24))){
var inst_67490 = (state_67532[(13)]);
var inst_67459 = (state_67532[(8)]);
var inst_67480 = (state_67532[(11)]);
var inst_67492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67493 = [inst_67480,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_67494 = (new cljs.core.PersistentVector(null,2,(5),inst_67492,inst_67493,null));
var inst_67495 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_67490,inst_67494,cljs.core.conj,inst_67459);
var state_67532__$1 = state_67532;
var statearr_67541_67640 = state_67532__$1;
(statearr_67541_67640[(2)] = inst_67495);

(statearr_67541_67640[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (4))){
var inst_67338 = (state_67532[(2)]);
var state_67532__$1 = state_67532;
var statearr_67542_67641 = state_67532__$1;
(statearr_67542_67641[(2)] = inst_67338);

(statearr_67542_67641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (15))){
var inst_67460 = (state_67532[(9)]);
var inst_67453 = (state_67532[(14)]);
var tmp67540 = inst_67453;
var inst_67452 = inst_67460;
var inst_67453__$1 = tmp67540;
var state_67532__$1 = (function (){var statearr_67543 = state_67532;
(statearr_67543[(7)] = inst_67452);

(statearr_67543[(14)] = inst_67453__$1);

return statearr_67543;
})();
var statearr_67544_67642 = state_67532__$1;
(statearr_67544_67642[(2)] = null);

(statearr_67544_67642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (21))){
var inst_67480 = (state_67532[(11)]);
var inst_67453 = (state_67532[(14)]);
var inst_67484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67485 = [inst_67480,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_67486 = (new cljs.core.PersistentVector(null,2,(5),inst_67484,inst_67485,null));
var inst_67487 = cljs.core.assoc_in(inst_67453,inst_67486,inst_67480);
var state_67532__$1 = state_67532;
var statearr_67545_67643 = state_67532__$1;
(statearr_67545_67643[(2)] = inst_67487);

(statearr_67545_67643[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (31))){
var inst_67506 = (state_67532[(15)]);
var state_67532__$1 = state_67532;
var statearr_67546_67644 = state_67532__$1;
(statearr_67546_67644[(2)] = inst_67506);

(statearr_67546_67644[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (32))){
var inst_67460 = (state_67532[(9)]);
var inst_67514 = (state_67532[(2)]);
var inst_67452 = inst_67460;
var inst_67453 = inst_67514;
var state_67532__$1 = (function (){var statearr_67547 = state_67532;
(statearr_67547[(7)] = inst_67452);

(statearr_67547[(14)] = inst_67453);

return statearr_67547;
})();
var statearr_67548_67645 = state_67532__$1;
(statearr_67548_67645[(2)] = null);

(statearr_67548_67645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (33))){
var inst_67453 = (state_67532[(14)]);
var state_67532__$1 = state_67532;
var statearr_67549_67646 = state_67532__$1;
(statearr_67549_67646[(2)] = inst_67453);

(statearr_67549_67646[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (13))){
var inst_67462 = (state_67532[(16)]);
var state_67532__$1 = state_67532;
var statearr_67550_67647 = state_67532__$1;
(statearr_67550_67647[(2)] = inst_67462);

(statearr_67550_67647[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (22))){
var inst_67453 = (state_67532[(14)]);
var state_67532__$1 = state_67532;
var statearr_67551_67648 = state_67532__$1;
(statearr_67551_67648[(2)] = inst_67453);

(statearr_67551_67648[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (29))){
var inst_67506 = (state_67532[(2)]);
var state_67532__$1 = (function (){var statearr_67552 = state_67532;
(statearr_67552[(15)] = inst_67506);

return statearr_67552;
})();
if(cljs.core.truth_(show_auth)){
var statearr_67553_67649 = state_67532__$1;
(statearr_67553_67649[(1)] = (30));

} else {
var statearr_67554_67650 = state_67532__$1;
(statearr_67554_67650[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (6))){
var inst_67438 = (state_67532[(2)]);
var inst_67439 = fluree.db.util.async.throw_err(inst_67438);
var inst_67447 = resp;
var inst_67448 = cljs.core.seq(inst_67447);
var inst_67449 = cljs.core.first(inst_67448);
var inst_67450 = cljs.core.next(inst_67448);
var inst_67451 = cljs.core.PersistentHashMap.EMPTY;
var inst_67452 = inst_67447;
var inst_67453 = inst_67451;
var state_67532__$1 = (function (){var statearr_67555 = state_67532;
(statearr_67555[(7)] = inst_67452);

(statearr_67555[(17)] = inst_67439);

(statearr_67555[(14)] = inst_67453);

(statearr_67555[(18)] = inst_67450);

(statearr_67555[(19)] = inst_67449);

return statearr_67555;
})();
var statearr_67556_67651 = state_67532__$1;
(statearr_67556_67651[(2)] = null);

(statearr_67556_67651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (28))){
var inst_67498 = (state_67532[(10)]);
var state_67532__$1 = state_67532;
var statearr_67557_67652 = state_67532__$1;
(statearr_67557_67652[(2)] = inst_67498);

(statearr_67557_67652[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (25))){
var inst_67490 = (state_67532[(13)]);
var state_67532__$1 = state_67532;
var statearr_67558_67653 = state_67532__$1;
(statearr_67558_67653[(2)] = inst_67490);

(statearr_67558_67653[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (34))){
var state_67532__$1 = state_67532;
var statearr_67559_67654 = state_67532__$1;
(statearr_67559_67654[(2)] = null);

(statearr_67559_67654[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (17))){
var inst_67524 = (state_67532[(2)]);
var state_67532__$1 = state_67532;
var statearr_67560_67655 = state_67532__$1;
(statearr_67560_67655[(2)] = inst_67524);

(statearr_67560_67655[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (3))){
var inst_67530 = (state_67532[(2)]);
var state_67532__$1 = state_67532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67532__$1,inst_67530);
} else {
if((state_val_67533 === (12))){
var inst_67439 = (state_67532[(17)]);
var inst_67459 = (state_67532[(8)]);
var inst_67464 = fluree.db.api.query.auth_match(auth,inst_67439,inst_67459);
var inst_67465 = cljs.core.not(inst_67464);
var state_67532__$1 = state_67532;
var statearr_67561_67656 = state_67532__$1;
(statearr_67561_67656[(2)] = inst_67465);

(statearr_67561_67656[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (2))){
var _ = (function (){var statearr_67562 = state_67532;
(statearr_67562[(4)] = cljs.core.cons((5),(state_67532[(4)])));

return statearr_67562;
})();
var inst_67344 = (function (){return (function (p1__67337_SHARP_){
return fluree.db.flake.t(p1__67337_SHARP_);
});
})();
var inst_67345 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_67344,resp);
var inst_67346 = cljs.core.set(inst_67345);
var inst_67434 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_67435 = (function (){var ts = inst_67346;
var c__2706__auto____$1 = inst_67434;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67432){
var state_val_67433 = (state_67432[(1)]);
if((state_val_67433 === (7))){
var inst_67360 = (state_67432[(7)]);
var inst_67372 = (state_67432[(8)]);
var inst_67366 = (state_67432[(9)]);
var inst_67378 = (state_67432[(10)]);
var inst_67371 = (state_67432[(2)]);
var inst_67372__$1 = fluree.db.util.async.throw_err(inst_67371);
var inst_67374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67375 = [inst_67366,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_67376 = (new cljs.core.PersistentVector(null,2,(5),inst_67374,inst_67375,null));
var inst_67377 = cljs.core.assoc_in(inst_67360,inst_67376,inst_67372__$1);
var inst_67378__$1 = auth;
var state_67432__$1 = (function (){var statearr_67563 = state_67432;
(statearr_67563[(8)] = inst_67372__$1);

(statearr_67563[(11)] = inst_67377);

(statearr_67563[(10)] = inst_67378__$1);

return statearr_67563;
})();
if(cljs.core.truth_(inst_67378__$1)){
var statearr_67564_67657 = state_67432__$1;
(statearr_67564_67657[(1)] = (8));

} else {
var statearr_67565_67658 = state_67432__$1;
(statearr_67565_67658[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67433 === (1))){
var inst_67354 = (state_67432[(12)]);
var inst_67354__$1 = ts;
var inst_67355 = cljs.core.seq(inst_67354__$1);
var inst_67356 = cljs.core.first(inst_67355);
var inst_67357 = cljs.core.next(inst_67355);
var inst_67358 = cljs.core.PersistentHashMap.EMPTY;
var inst_67359 = inst_67354__$1;
var inst_67360 = inst_67358;
var state_67432__$1 = (function (){var statearr_67566 = state_67432;
(statearr_67566[(7)] = inst_67360);

(statearr_67566[(13)] = inst_67359);

(statearr_67566[(14)] = inst_67357);

(statearr_67566[(15)] = inst_67356);

(statearr_67566[(12)] = inst_67354__$1);

return statearr_67566;
})();
var statearr_67567_67659 = state_67432__$1;
(statearr_67567_67659[(2)] = null);

(statearr_67567_67659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67433 === (4))){
var inst_67366 = (state_67432[(9)]);
var inst_67369 = fluree.db.time_travel.non_border_t_to_block(db,inst_67366);
var state_67432__$1 = state_67432;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67432__$1,(7),inst_67369);
} else {
if((state_val_67433 === (13))){
var inst_67367 = (state_67432[(16)]);
var inst_67424 = (state_67432[(2)]);
var inst_67359 = inst_67367;
var inst_67360 = inst_67424;
var state_67432__$1 = (function (){var statearr_67568 = state_67432;
(statearr_67568[(7)] = inst_67360);

(statearr_67568[(13)] = inst_67359);

return statearr_67568;
})();
var statearr_67569_67660 = state_67432__$1;
(statearr_67569_67660[(2)] = null);

(statearr_67569_67660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67433 === (6))){
var inst_67428 = (state_67432[(2)]);
var state_67432__$1 = state_67432;
var statearr_67570_67661 = state_67432__$1;
(statearr_67570_67661[(2)] = inst_67428);

(statearr_67570_67661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67433 === (3))){
var inst_67430 = (state_67432[(2)]);
var state_67432__$1 = state_67432;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67432__$1,inst_67430);
} else {
if((state_val_67433 === (12))){
var inst_67377 = (state_67432[(11)]);
var state_67432__$1 = state_67432;
var statearr_67571_67662 = state_67432__$1;
(statearr_67571_67662[(2)] = inst_67377);

(statearr_67571_67662[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67433 === (2))){
var inst_67359 = (state_67432[(13)]);
var inst_67366 = (state_67432[(9)]);
var inst_67365 = cljs.core.seq(inst_67359);
var inst_67366__$1 = cljs.core.first(inst_67365);
var inst_67367 = cljs.core.next(inst_67365);
var state_67432__$1 = (function (){var statearr_67572 = state_67432;
(statearr_67572[(16)] = inst_67367);

(statearr_67572[(9)] = inst_67366__$1);

return statearr_67572;
})();
if(cljs.core.truth_(inst_67366__$1)){
var statearr_67573_67663 = state_67432__$1;
(statearr_67573_67663[(1)] = (4));

} else {
var statearr_67574_67664 = state_67432__$1;
(statearr_67574_67664[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67433 === (11))){
var inst_67360 = (state_67432[(7)]);
var inst_67359 = (state_67432[(13)]);
var inst_67357 = (state_67432[(14)]);
var inst_67356 = (state_67432[(15)]);
var inst_67354 = (state_67432[(12)]);
var inst_67367 = (state_67432[(16)]);
var inst_67372 = (state_67432[(8)]);
var inst_67377 = (state_67432[(11)]);
var inst_67366 = (state_67432[(9)]);
var inst_67384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67385 = [inst_67366,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_67386 = (new cljs.core.PersistentVector(null,2,(5),inst_67384,inst_67385,null));
var inst_67399 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_67400 = (function (){var t = inst_67366;
var first__67364 = inst_67366;
var vec__67362 = inst_67359;
var block = inst_67372;
var r = inst_67367;
var seq__67352 = inst_67357;
var first__67353 = inst_67356;
var seq__67363 = inst_67367;
var acc = inst_67360;
var G__67350 = inst_67359;
var c__2706__auto____$2 = inst_67399;
var G__67373 = inst_67377;
var vec__67351 = inst_67354;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67397){
var state_val_67398 = (state_67397[(1)]);
if((state_val_67398 === (1))){
var state_67397__$1 = state_67397;
var statearr_67575_67665 = state_67397__$1;
(statearr_67575_67665[(2)] = null);

(statearr_67575_67665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67398 === (2))){
var ___$1 = (function (){var statearr_67576 = state_67397;
(statearr_67576[(4)] = cljs.core.cons((5),(state_67397[(4)])));

return statearr_67576;
})();
var ___$2 = (function (){var statearr_67577 = state_67397;
(statearr_67577[(4)] = cljs.core.rest((state_67397[(4)])));

return statearr_67577;
})();
var state_67397__$1 = state_67397;
var statearr_67578_67666 = state_67397__$1;
(statearr_67578_67666[(2)] = db);

(statearr_67578_67666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67398 === (3))){
var inst_67395 = (state_67397[(2)]);
var state_67397__$1 = state_67397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67397__$1,inst_67395);
} else {
if((state_val_67398 === (4))){
var inst_67387 = (state_67397[(2)]);
var state_67397__$1 = state_67397;
var statearr_67580_67667 = state_67397__$1;
(statearr_67580_67667[(2)] = inst_67387);

(statearr_67580_67667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67398 === (5))){
var ___$1 = (function (){var statearr_67581 = state_67397;
(statearr_67581[(4)] = cljs.core.rest((state_67397[(4)])));

return statearr_67581;
})();
var state_67397__$1 = state_67397;
var ex67579 = (state_67397__$1[(2)]);
var statearr_67582_67668 = state_67397__$1;
(statearr_67582_67668[(5)] = ex67579);


if((ex67579 instanceof Error)){
var statearr_67583_67669 = state_67397__$1;
(statearr_67583_67669[(1)] = (4));

(statearr_67583_67669[(5)] = null);

} else {
throw ex67579;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_67584 = [null,null,null,null,null,null,null];
(statearr_67584[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_67584[(1)] = (1));

return statearr_67584;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_67397){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67397);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67585){var ex__2687__auto__ = e67585;
var statearr_67586_67670 = state_67397;
(statearr_67586_67670[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67397[(4)]))){
var statearr_67587_67671 = state_67397;
(statearr_67587_67671[(1)] = cljs.core.first((state_67397[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67672 = state_67397;
state_67397 = G__67672;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_67397){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_67397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67588 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67588[(6)] = c__2706__auto____$2);

return statearr_67588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_67401 = cljs.core.async.impl.dispatch.run(inst_67400);
var inst_67402 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_67403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67404 = ["?auth","?id"];
var inst_67405 = (new cljs.core.PersistentVector(null,2,(5),inst_67403,inst_67404,null));
var inst_67406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67408 = [inst_67366,"_tx/auth","?auth"];
var inst_67409 = (new cljs.core.PersistentVector(null,3,(5),inst_67407,inst_67408,null));
var inst_67410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67411 = ["?auth","_auth/id","?id"];
var inst_67412 = (new cljs.core.PersistentVector(null,3,(5),inst_67410,inst_67411,null));
var inst_67413 = [inst_67409,inst_67412];
var inst_67414 = (new cljs.core.PersistentVector(null,2,(5),inst_67406,inst_67413,null));
var inst_67415 = [inst_67405,inst_67414];
var inst_67416 = cljs.core.PersistentHashMap.fromArrays(inst_67402,inst_67415);
var inst_67417 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_67399,inst_67416) : fluree.db.api.query.query_async.call(null,inst_67399,inst_67416));
var state_67432__$1 = (function (){var statearr_67589 = state_67432;
(statearr_67589[(17)] = inst_67386);

(statearr_67589[(18)] = inst_67401);

return statearr_67589;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67432__$1,(14),inst_67417);
} else {
if((state_val_67433 === (9))){
var state_67432__$1 = state_67432;
var statearr_67590_67673 = state_67432__$1;
(statearr_67590_67673[(2)] = show_auth);

(statearr_67590_67673[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67433 === (5))){
var inst_67360 = (state_67432[(7)]);
var state_67432__$1 = state_67432;
var statearr_67591_67674 = state_67432__$1;
(statearr_67591_67674[(2)] = inst_67360);

(statearr_67591_67674[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67433 === (14))){
var inst_67377 = (state_67432[(11)]);
var inst_67386 = (state_67432[(17)]);
var inst_67419 = (state_67432[(2)]);
var inst_67420 = fluree.db.util.async.throw_err(inst_67419);
var inst_67421 = cljs.core.assoc_in(inst_67377,inst_67386,inst_67420);
var state_67432__$1 = state_67432;
var statearr_67592_67675 = state_67432__$1;
(statearr_67592_67675[(2)] = inst_67421);

(statearr_67592_67675[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67433 === (10))){
var inst_67382 = (state_67432[(2)]);
var state_67432__$1 = state_67432;
if(cljs.core.truth_(inst_67382)){
var statearr_67593_67676 = state_67432__$1;
(statearr_67593_67676[(1)] = (11));

} else {
var statearr_67594_67677 = state_67432__$1;
(statearr_67594_67677[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67433 === (8))){
var inst_67378 = (state_67432[(10)]);
var state_67432__$1 = state_67432;
var statearr_67595_67678 = state_67432__$1;
(statearr_67595_67678[(2)] = inst_67378);

(statearr_67595_67678[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_67596 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67596[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_67596[(1)] = (1));

return statearr_67596;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_67432){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67432);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67597){var ex__2687__auto__ = e67597;
var statearr_67598_67679 = state_67432;
(statearr_67598_67679[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67432[(4)]))){
var statearr_67599_67680 = state_67432;
(statearr_67599_67680[(1)] = cljs.core.first((state_67432[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67681 = state_67432;
state_67432 = G__67681;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_67432){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_67432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67600 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67600[(6)] = c__2706__auto____$1);

return statearr_67600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_67436 = cljs.core.async.impl.dispatch.run(inst_67435);
var state_67532__$1 = (function (){var statearr_67601 = state_67532;
(statearr_67601[(20)] = inst_67436);

return statearr_67601;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67532__$1,(6),inst_67434);
} else {
if((state_val_67533 === (23))){
var inst_67490 = (state_67532[(2)]);
var state_67532__$1 = (function (){var statearr_67602 = state_67532;
(statearr_67602[(13)] = inst_67490);

return statearr_67602;
})();
var statearr_67603_67682 = state_67532__$1;
(statearr_67603_67682[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (35))){
var inst_67520 = (state_67532[(2)]);
var state_67532__$1 = state_67532;
var statearr_67605_67683 = state_67532__$1;
(statearr_67605_67683[(2)] = inst_67520);

(statearr_67605_67683[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (19))){
var state_67532__$1 = state_67532;
var statearr_67606_67684 = state_67532__$1;
(statearr_67606_67684[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (11))){
var inst_67471 = (state_67532[(2)]);
var state_67532__$1 = state_67532;
if(cljs.core.truth_(inst_67471)){
var statearr_67609_67685 = state_67532__$1;
(statearr_67609_67685[(1)] = (15));

} else {
var statearr_67610_67686 = state_67532__$1;
(statearr_67610_67686[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (9))){
var inst_67462 = (state_67532[(16)]);
var inst_67462__$1 = auth;
var state_67532__$1 = (function (){var statearr_67611 = state_67532;
(statearr_67611[(16)] = inst_67462__$1);

return statearr_67611;
})();
if(cljs.core.truth_(inst_67462__$1)){
var statearr_67612_67687 = state_67532__$1;
(statearr_67612_67687[(1)] = (12));

} else {
var statearr_67613_67688 = state_67532__$1;
(statearr_67613_67688[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (5))){
var _ = (function (){var statearr_67614 = state_67532;
(statearr_67614[(4)] = cljs.core.rest((state_67532[(4)])));

return statearr_67614;
})();
var state_67532__$1 = state_67532;
var ex67608 = (state_67532__$1[(2)]);
var statearr_67615_67689 = state_67532__$1;
(statearr_67615_67689[(5)] = ex67608);


if((ex67608 instanceof Error)){
var statearr_67616_67690 = state_67532__$1;
(statearr_67616_67690[(1)] = (4));

(statearr_67616_67690[(5)] = null);

} else {
throw ex67608;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (14))){
var inst_67468 = (state_67532[(2)]);
var state_67532__$1 = state_67532;
var statearr_67617_67691 = state_67532__$1;
(statearr_67617_67691[(2)] = inst_67468);

(statearr_67617_67691[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (26))){
var inst_67498 = (state_67532[(2)]);
var state_67532__$1 = (function (){var statearr_67618 = state_67532;
(statearr_67618[(10)] = inst_67498);

return statearr_67618;
})();
var statearr_67619_67692 = state_67532__$1;
(statearr_67619_67692[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (16))){
var inst_67459 = (state_67532[(8)]);
var state_67532__$1 = state_67532;
if(cljs.core.truth_(inst_67459)){
var statearr_67621_67693 = state_67532__$1;
(statearr_67621_67693[(1)] = (18));

} else {
var statearr_67622_67694 = state_67532__$1;
(statearr_67622_67694[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (30))){
var inst_67506 = (state_67532[(15)]);
var inst_67480 = (state_67532[(11)]);
var inst_67481 = (state_67532[(21)]);
var inst_67508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67509 = [inst_67480,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_67510 = (new cljs.core.PersistentVector(null,2,(5),inst_67508,inst_67509,null));
var inst_67511 = cljs.core.assoc_in(inst_67506,inst_67510,inst_67481);
var state_67532__$1 = state_67532;
var statearr_67623_67695 = state_67532__$1;
(statearr_67623_67695[(2)] = inst_67511);

(statearr_67623_67695[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (10))){
var inst_67459 = (state_67532[(8)]);
var state_67532__$1 = state_67532;
var statearr_67624_67696 = state_67532__$1;
(statearr_67624_67696[(2)] = inst_67459);

(statearr_67624_67696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (18))){
var inst_67439 = (state_67532[(17)]);
var inst_67459 = (state_67532[(8)]);
var inst_67477 = (state_67532[(12)]);
var inst_67477__$1 = fluree.db.flake.t(inst_67459);
var inst_67478 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67439,inst_67477__$1);
var inst_67479 = cljs.core.__destructure_map(inst_67478);
var inst_67480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67479,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67481 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67479,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_67532__$1 = (function (){var statearr_67625 = state_67532;
(statearr_67625[(11)] = inst_67480);

(statearr_67625[(21)] = inst_67481);

(statearr_67625[(12)] = inst_67477__$1);

return statearr_67625;
})();
var statearr_67626_67697 = state_67532__$1;
(statearr_67626_67697[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67533 === (8))){
var inst_67526 = (state_67532[(2)]);
var inst_67527 = cljs.core.vals(inst_67526);
var _ = (function (){var statearr_67628 = state_67532;
(statearr_67628[(4)] = cljs.core.rest((state_67532[(4)])));

return statearr_67628;
})();
var state_67532__$1 = state_67532;
var statearr_67629_67698 = state_67532__$1;
(statearr_67629_67698[(2)] = inst_67527);

(statearr_67629_67698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_67630 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67630[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_67630[(1)] = (1));

return statearr_67630;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_67532){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67532);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67631){var ex__2687__auto__ = e67631;
var statearr_67632_67699 = state_67532;
(statearr_67632_67699[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67532[(4)]))){
var statearr_67633_67700 = state_67532;
(statearr_67633_67700[(1)] = cljs.core.first((state_67532[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67701 = state_67532;
state_67532 = G__67701;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_67532){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_67532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67634 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67634[(6)] = c__2706__auto__);

return statearr_67634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67825){
var state_val_67826 = (state_67825[(1)]);
if((state_val_67826 === (7))){
var inst_67724 = (state_67825[(7)]);
var inst_67726 = fluree.db.api.query.resolve_block_range(inst_67724,query_map);
var state_67825__$1 = state_67825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67825__$1,(10),inst_67726);
} else {
if((state_val_67826 === (20))){
var inst_67750 = (state_67825[(2)]);
var inst_67751 = fluree.db.util.async.throw_err(inst_67750);
var inst_67752 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_67751);
var inst_67753 = (inst_67752 - (1));
var state_67825__$1 = state_67825;
var statearr_67827_67890 = state_67825__$1;
(statearr_67827_67890[(2)] = inst_67753);

(statearr_67827_67890[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (27))){
var state_67825__$1 = state_67825;
var statearr_67828_67891 = state_67825__$1;
(statearr_67828_67891[(2)] = null);

(statearr_67828_67891[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (1))){
var state_67825__$1 = state_67825;
var statearr_67829_67892 = state_67825__$1;
(statearr_67829_67892[(2)] = null);

(statearr_67829_67892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (24))){
var inst_67760 = (state_67825[(2)]);
var inst_67761 = fluree.db.util.async.throw_err(inst_67760);
var inst_67762 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_67761);
var state_67825__$1 = state_67825;
var statearr_67830_67893 = state_67825__$1;
(statearr_67830_67893[(2)] = inst_67762);

(statearr_67830_67893[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (39))){
var inst_67797 = (state_67825[(2)]);
var inst_67798 = fluree.db.util.async.throw_err(inst_67797);
var state_67825__$1 = state_67825;
var statearr_67831_67894 = state_67825__$1;
(statearr_67831_67894[(2)] = inst_67798);

(statearr_67831_67894[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (4))){
var inst_67702 = (state_67825[(2)]);
var state_67825__$1 = state_67825;
var statearr_67832_67895 = state_67825__$1;
(statearr_67832_67895[(2)] = inst_67702);

(statearr_67832_67895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (15))){
var inst_67733 = (state_67825[(8)]);
var state_67825__$1 = state_67825;
var statearr_67833_67896 = state_67825__$1;
(statearr_67833_67896[(2)] = inst_67733);

(statearr_67833_67896[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (21))){
var inst_67724 = (state_67825[(7)]);
var inst_67734 = (state_67825[(9)]);
var inst_67758 = fluree.db.time_travel.as_of_block(inst_67724,inst_67734);
var state_67825__$1 = state_67825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67825__$1,(24),inst_67758);
} else {
if((state_val_67826 === (31))){
var inst_67718 = (state_67825[(10)]);
var state_67825__$1 = state_67825;
var statearr_67834_67897 = state_67825__$1;
(statearr_67834_67897[(2)] = inst_67718);

(statearr_67834_67897[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (32))){
var inst_67781 = (state_67825[(11)]);
var inst_67776 = (state_67825[(12)]);
var inst_67724 = (state_67825[(7)]);
var inst_67785 = (state_67825[(2)]);
var inst_67786 = fluree.db.api.query.format_history_resp(inst_67724,inst_67776,inst_67781,inst_67785);
var state_67825__$1 = state_67825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67825__$1,(29),inst_67786);
} else {
if((state_val_67826 === (40))){
var inst_67776 = (state_67825[(12)]);
var inst_67802 = (state_67825[(13)]);
var inst_67804 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_67805 = cljs.core.count(inst_67776);
var inst_67806 = [inst_67802,inst_67805,(200)];
var inst_67807 = cljs.core.PersistentHashMap.fromArrays(inst_67804,inst_67806);
var state_67825__$1 = state_67825;
var statearr_67835_67898 = state_67825__$1;
(statearr_67835_67898[(2)] = inst_67807);

(statearr_67835_67898[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (33))){
var inst_67717 = (state_67825[(14)]);
var state_67825__$1 = state_67825;
var statearr_67836_67899 = state_67825__$1;
(statearr_67836_67899[(2)] = inst_67717);

(statearr_67836_67899[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (13))){
var inst_67820 = (state_67825[(2)]);
var _ = (function (){var statearr_67837 = state_67825;
(statearr_67837[(4)] = cljs.core.rest((state_67825[(4)])));

return statearr_67837;
})();
var state_67825__$1 = state_67825;
var statearr_67838_67900 = state_67825__$1;
(statearr_67838_67900[(2)] = inst_67820);

(statearr_67838_67900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (22))){
var inst_67724 = (state_67825[(7)]);
var inst_67764 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_67724);
var state_67825__$1 = state_67825;
var statearr_67839_67901 = state_67825__$1;
(statearr_67839_67901[(2)] = inst_67764);

(statearr_67839_67901[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (36))){
var inst_67789 = (state_67825[(15)]);
var inst_67724 = (state_67825[(7)]);
var inst_67795 = fluree.db.api.query.format_blocks_resp_pretty(inst_67724,inst_67789);
var state_67825__$1 = state_67825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67825__$1,(39),inst_67795);
} else {
if((state_val_67826 === (41))){
var inst_67802 = (state_67825[(13)]);
var state_67825__$1 = state_67825;
var statearr_67840_67902 = state_67825__$1;
(statearr_67840_67902[(2)] = inst_67802);

(statearr_67840_67902[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (29))){
var inst_67717 = (state_67825[(14)]);
var inst_67788 = (state_67825[(2)]);
var inst_67789 = fluree.db.util.async.throw_err(inst_67788);
var state_67825__$1 = (function (){var statearr_67841 = state_67825;
(statearr_67841[(15)] = inst_67789);

return statearr_67841;
})();
if(cljs.core.truth_(inst_67717)){
var statearr_67842_67903 = state_67825__$1;
(statearr_67842_67903[(1)] = (33));

} else {
var statearr_67843_67904 = state_67825__$1;
(statearr_67843_67904[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (6))){
var inst_67714 = (state_67825[(16)]);
var inst_67723 = (state_67825[(2)]);
var inst_67724 = fluree.db.util.async.throw_err(inst_67723);
var state_67825__$1 = (function (){var statearr_67844 = state_67825;
(statearr_67844[(7)] = inst_67724);

return statearr_67844;
})();
if(cljs.core.truth_(inst_67714)){
var statearr_67845_67905 = state_67825__$1;
(statearr_67845_67905[(1)] = (7));

} else {
var statearr_67846_67906 = state_67825__$1;
(statearr_67846_67906[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (28))){
var inst_67719 = (state_67825[(17)]);
var inst_67781 = (state_67825[(2)]);
var state_67825__$1 = (function (){var statearr_67847 = state_67825;
(statearr_67847[(11)] = inst_67781);

return statearr_67847;
})();
if(cljs.core.truth_(inst_67719)){
var statearr_67848_67907 = state_67825__$1;
(statearr_67848_67907[(1)] = (30));

} else {
var statearr_67849_67908 = state_67825__$1;
(statearr_67849_67908[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (25))){
var inst_67720 = (state_67825[(18)]);
var inst_67775 = (state_67825[(2)]);
var inst_67776 = fluree.db.util.async.throw_err(inst_67775);
var state_67825__$1 = (function (){var statearr_67850 = state_67825;
(statearr_67850[(12)] = inst_67776);

return statearr_67850;
})();
if(cljs.core.truth_(inst_67720)){
var statearr_67851_67909 = state_67825__$1;
(statearr_67851_67909[(1)] = (26));

} else {
var statearr_67852_67910 = state_67825__$1;
(statearr_67852_67910[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (34))){
var inst_67716 = (state_67825[(19)]);
var state_67825__$1 = state_67825;
var statearr_67853_67911 = state_67825__$1;
(statearr_67853_67911[(2)] = inst_67716);

(statearr_67853_67911[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (17))){
var inst_67733 = (state_67825[(8)]);
var inst_67724 = (state_67825[(7)]);
var inst_67747 = (inst_67733 - (1));
var inst_67748 = fluree.db.time_travel.as_of_block(inst_67724,inst_67747);
var state_67825__$1 = state_67825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67825__$1,(20),inst_67748);
} else {
if((state_val_67826 === (3))){
var inst_67823 = (state_67825[(2)]);
var state_67825__$1 = state_67825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67825__$1,inst_67823);
} else {
if((state_val_67826 === (12))){
var inst_67812 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_67813 = ["History query not properly formatted. Provided ",inst_67812].join('');
var inst_67814 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67815 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_67816 = cljs.core.PersistentHashMap.fromArrays(inst_67814,inst_67815);
var inst_67817 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67813,inst_67816);
var inst_67818 = (function(){throw inst_67817})();
var state_67825__$1 = state_67825;
var statearr_67854_67912 = state_67825__$1;
(statearr_67854_67912[(2)] = inst_67818);

(statearr_67854_67912[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (2))){
var _ = (function (){var statearr_67855 = state_67825;
(statearr_67855[(4)] = cljs.core.cons((5),(state_67825[(4)])));

return statearr_67855;
})();
var inst_67712 = query_map;
var inst_67713 = cljs.core.__destructure_map(inst_67712);
var inst_67714 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67713,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67715 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67713,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_67716 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67713,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_67717 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67713,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_67718 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67713,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_67719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67713,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_67720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67713,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_67721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67713,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_67825__$1 = (function (){var statearr_67856 = state_67825;
(statearr_67856[(20)] = inst_67721);

(statearr_67856[(18)] = inst_67720);

(statearr_67856[(10)] = inst_67718);

(statearr_67856[(14)] = inst_67717);

(statearr_67856[(16)] = inst_67714);

(statearr_67856[(19)] = inst_67716);

(statearr_67856[(17)] = inst_67719);

(statearr_67856[(21)] = inst_67715);

return statearr_67856;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67825__$1,(6),sources);
} else {
if((state_val_67826 === (23))){
var inst_67756 = (state_67825[(22)]);
var inst_67724 = (state_67825[(7)]);
var inst_67715 = (state_67825[(21)]);
var inst_67766 = (state_67825[(2)]);
var inst_67767 = fluree.db.api.query.get_history_pattern(inst_67715);
var inst_67768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67767,(0),null);
var inst_67769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67767,(1),null);
var inst_67770 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_67771 = [inst_67756,inst_67766];
var inst_67772 = cljs.core.PersistentHashMap.fromArrays(inst_67770,inst_67771);
var inst_67773 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_67724,inst_67769,cljs.core._EQ_,inst_67768,inst_67772);
var state_67825__$1 = state_67825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67825__$1,(25),inst_67773);
} else {
if((state_val_67826 === (35))){
var inst_67793 = (state_67825[(2)]);
var state_67825__$1 = state_67825;
if(cljs.core.truth_(inst_67793)){
var statearr_67857_67913 = state_67825__$1;
(statearr_67857_67913[(1)] = (36));

} else {
var statearr_67858_67914 = state_67825__$1;
(statearr_67858_67914[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (19))){
var inst_67734 = (state_67825[(9)]);
var inst_67756 = (state_67825[(2)]);
var state_67825__$1 = (function (){var statearr_67859 = state_67825;
(statearr_67859[(22)] = inst_67756);

return statearr_67859;
})();
if(cljs.core.truth_(inst_67734)){
var statearr_67860_67915 = state_67825__$1;
(statearr_67860_67915[(1)] = (21));

} else {
var statearr_67861_67916 = state_67825__$1;
(statearr_67861_67916[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (11))){
var inst_67721 = (state_67825[(20)]);
var inst_67733 = (state_67825[(8)]);
var inst_67740 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_67721);
var state_67825__$1 = (function (){var statearr_67863 = state_67825;
(statearr_67863[(23)] = inst_67740);

return statearr_67863;
})();
if(cljs.core.truth_(inst_67733)){
var statearr_67864_67917 = state_67825__$1;
(statearr_67864_67917[(1)] = (14));

} else {
var statearr_67865_67918 = state_67825__$1;
(statearr_67865_67918[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (9))){
var inst_67732 = (state_67825[(2)]);
var inst_67733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67732,(0),null);
var inst_67734 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67732,(1),null);
var inst_67735 = cljs.core.contains_QMARK_(query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_67825__$1 = (function (){var statearr_67866 = state_67825;
(statearr_67866[(8)] = inst_67733);

(statearr_67866[(9)] = inst_67734);

return statearr_67866;
})();
if(inst_67735){
var statearr_67867_67919 = state_67825__$1;
(statearr_67867_67919[(1)] = (11));

} else {
var statearr_67868_67920 = state_67825__$1;
(statearr_67868_67920[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (5))){
var _ = (function (){var statearr_67869 = state_67825;
(statearr_67869[(4)] = cljs.core.rest((state_67825[(4)])));

return statearr_67869;
})();
var state_67825__$1 = state_67825;
var ex67862 = (state_67825__$1[(2)]);
var statearr_67870_67921 = state_67825__$1;
(statearr_67870_67921[(5)] = ex67862);


if((ex67862 instanceof Error)){
var statearr_67871_67922 = state_67825__$1;
(statearr_67871_67922[(1)] = (4));

(statearr_67871_67922[(5)] = null);

} else {
throw ex67862;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (14))){
var inst_67733 = (state_67825[(8)]);
var inst_67742 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_67733);
var state_67825__$1 = state_67825;
var statearr_67872_67923 = state_67825__$1;
(statearr_67872_67923[(2)] = inst_67742);

(statearr_67872_67923[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (26))){
var inst_67720 = (state_67825[(18)]);
var inst_67778 = cljs.core.set(inst_67720);
var state_67825__$1 = state_67825;
var statearr_67873_67924 = state_67825__$1;
(statearr_67873_67924[(2)] = inst_67778);

(statearr_67873_67924[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (16))){
var inst_67745 = (state_67825[(2)]);
var state_67825__$1 = state_67825;
if(cljs.core.truth_(inst_67745)){
var statearr_67874_67925 = state_67825__$1;
(statearr_67874_67925[(1)] = (17));

} else {
var statearr_67875_67926 = state_67825__$1;
(statearr_67875_67926[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (38))){
var inst_67740 = (state_67825[(23)]);
var inst_67802 = (state_67825[(2)]);
var state_67825__$1 = (function (){var statearr_67876 = state_67825;
(statearr_67876[(13)] = inst_67802);

return statearr_67876;
})();
if(cljs.core.truth_(inst_67740)){
var statearr_67877_67927 = state_67825__$1;
(statearr_67877_67927[(1)] = (40));

} else {
var statearr_67878_67928 = state_67825__$1;
(statearr_67878_67928[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (30))){
var inst_67719 = (state_67825[(17)]);
var state_67825__$1 = state_67825;
var statearr_67879_67929 = state_67825__$1;
(statearr_67879_67929[(2)] = inst_67719);

(statearr_67879_67929[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (10))){
var inst_67728 = (state_67825[(2)]);
var inst_67729 = fluree.db.util.async.throw_err(inst_67728);
var state_67825__$1 = state_67825;
var statearr_67880_67930 = state_67825__$1;
(statearr_67880_67930[(2)] = inst_67729);

(statearr_67880_67930[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (18))){
var state_67825__$1 = state_67825;
var statearr_67881_67931 = state_67825__$1;
(statearr_67881_67931[(2)] = (-1));

(statearr_67881_67931[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (42))){
var inst_67810 = (state_67825[(2)]);
var state_67825__$1 = state_67825;
var statearr_67882_67932 = state_67825__$1;
(statearr_67882_67932[(2)] = inst_67810);

(statearr_67882_67932[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (37))){
var inst_67789 = (state_67825[(15)]);
var inst_67800 = fluree.db.api.query.block_Flakes__GT_vector(inst_67789);
var state_67825__$1 = state_67825;
var statearr_67883_67933 = state_67825__$1;
(statearr_67883_67933[(2)] = inst_67800);

(statearr_67883_67933[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67826 === (8))){
var state_67825__$1 = state_67825;
var statearr_67884_67934 = state_67825__$1;
(statearr_67884_67934[(2)] = null);

(statearr_67884_67934[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_67885 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67885[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2684__auto__);

(statearr_67885[(1)] = (1));

return statearr_67885;
});
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1 = (function (state_67825){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67825);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67886){var ex__2687__auto__ = e67886;
var statearr_67887_67935 = state_67825;
(statearr_67887_67935[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67825[(4)]))){
var statearr_67888_67936 = state_67825;
(statearr_67888_67936[(1)] = cljs.core.first((state_67825[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67937 = state_67825;
state_67825 = G__67937;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__ = function(state_67825){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1.call(this,state_67825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67889 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67889[(6)] = c__2706__auto__);

return statearr_67889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68070){
var state_val_68071 = (state_68070[(1)]);
if((state_val_68071 === (7))){
var inst_67967 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_67968 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_67967].join('');
var inst_67969 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67970 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_67971 = cljs.core.PersistentHashMap.fromArrays(inst_67969,inst_67970);
var inst_67972 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67968,inst_67971);
var inst_67973 = (function(){throw inst_67972})();
var state_68070__$1 = state_68070;
var statearr_68072_68151 = state_68070__$1;
(statearr_68072_68151[(2)] = inst_67973);

(statearr_68072_68151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (20))){
var inst_68005 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
if(cljs.core.truth_(inst_68005)){
var statearr_68073_68152 = state_68070__$1;
(statearr_68073_68152[(1)] = (21));

} else {
var statearr_68074_68153 = state_68070__$1;
(statearr_68074_68153[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (27))){
var inst_67949 = (state_68070[(7)]);
var state_68070__$1 = state_68070;
var statearr_68075_68154 = state_68070__$1;
(statearr_68075_68154[(2)] = inst_67949);

(statearr_68075_68154[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (1))){
var state_68070__$1 = state_68070;
var statearr_68076_68155 = state_68070__$1;
(statearr_68076_68155[(2)] = null);

(statearr_68076_68155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (24))){
var inst_68011 = (state_68070[(8)]);
var state_68070__$1 = state_68070;
var statearr_68077_68156 = state_68070__$1;
(statearr_68077_68156[(2)] = inst_68011);

(statearr_68077_68156[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (39))){
var inst_67955 = (state_68070[(9)]);
var state_68070__$1 = state_68070;
if(cljs.core.truth_(inst_67955)){
var statearr_68078_68157 = state_68070__$1;
(statearr_68078_68157[(1)] = (42));

} else {
var statearr_68079_68158 = state_68070__$1;
(statearr_68079_68158[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (46))){
var inst_68043 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68044 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68045 = cljs.core.PersistentHashMap.fromArrays(inst_68043,inst_68044);
var inst_68046 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_68045);
var inst_68047 = (function(){throw inst_68046})();
var state_68070__$1 = state_68070;
var statearr_68080_68159 = state_68070__$1;
(statearr_68080_68159[(2)] = inst_68047);

(statearr_68080_68159[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (4))){
var inst_67939 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
var statearr_68081_68160 = state_68070__$1;
(statearr_68081_68160[(2)] = inst_67939);

(statearr_68081_68160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (15))){
var inst_67952 = (state_68070[(10)]);
var inst_67990 = (state_68070[(11)]);
var inst_67992 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_67990);
var inst_67993 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_67990);
var inst_67994 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_67990);
var inst_67995 = fluree.db.api.query.get_sources(inst_67992,inst_67993,inst_67994,inst_67952);
var state_68070__$1 = state_68070;
var statearr_68082_68161 = state_68070__$1;
(statearr_68082_68161[(2)] = inst_67995);

(statearr_68082_68161[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (48))){
var inst_68000 = (state_68070[(12)]);
var inst_68054 = (state_68070[(2)]);
var inst_68055 = fluree.db.util.async.throw_err(inst_68054);
var state_68070__$1 = (function (){var statearr_68083 = state_68070;
(statearr_68083[(13)] = inst_68055);

return statearr_68083;
})();
if(cljs.core.truth_(inst_68000)){
var statearr_68084_68162 = state_68070__$1;
(statearr_68084_68162[(1)] = (49));

} else {
var statearr_68085_68163 = state_68070__$1;
(statearr_68085_68163[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (50))){
var inst_68055 = (state_68070[(13)]);
var state_68070__$1 = state_68070;
var statearr_68086_68164 = state_68070__$1;
(statearr_68086_68164[(2)] = inst_68055);

(statearr_68086_68164[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (21))){
var inst_68007 = cljs.core.volatile_BANG_((0));
var state_68070__$1 = state_68070;
var statearr_68087_68165 = state_68070__$1;
(statearr_68087_68165[(2)] = inst_68007);

(statearr_68087_68165[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (31))){
var inst_67953 = (state_68070[(14)]);
var state_68070__$1 = state_68070;
if(cljs.core.truth_(inst_67953)){
var statearr_68088_68166 = state_68070__$1;
(statearr_68088_68166[(1)] = (33));

} else {
var statearr_68089_68167 = state_68070__$1;
(statearr_68089_68167[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (32))){
var inst_68030 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
var statearr_68090_68168 = state_68070__$1;
(statearr_68090_68168[(2)] = inst_68030);

(statearr_68090_68168[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (40))){
var inst_68032 = (state_68070[(15)]);
var state_68070__$1 = state_68070;
var statearr_68091_68169 = state_68070__$1;
(statearr_68091_68169[(2)] = inst_68032);

(statearr_68091_68169[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (33))){
var inst_67953 = (state_68070[(14)]);
var state_68070__$1 = state_68070;
var statearr_68092_68170 = state_68070__$1;
(statearr_68092_68170[(2)] = inst_67953);

(statearr_68092_68170[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (13))){
var inst_67950 = (state_68070[(16)]);
var inst_67979 = (state_68070[(2)]);
var inst_67980 = fluree.db.util.async.throw_err(inst_67979);
var inst_67981 = fluree.db.time_travel.as_of_block(inst_67980,inst_67950);
var state_68070__$1 = state_68070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68070__$1,(12),inst_67981);
} else {
if((state_val_68071 === (22))){
var state_68070__$1 = state_68070;
var statearr_68093_68171 = state_68070__$1;
(statearr_68093_68171[(2)] = null);

(statearr_68093_68171[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (36))){
var inst_67957 = (state_68070[(17)]);
var state_68070__$1 = state_68070;
var statearr_68094_68172 = state_68070__$1;
(statearr_68094_68172[(2)] = inst_67957);

(statearr_68094_68172[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (41))){
var inst_68040 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
if(cljs.core.truth_(inst_68040)){
var statearr_68095_68173 = state_68070__$1;
(statearr_68095_68173[(1)] = (45));

} else {
var statearr_68096_68174 = state_68070__$1;
(statearr_68096_68174[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (43))){
var inst_67951 = (state_68070[(18)]);
var state_68070__$1 = state_68070;
var statearr_68097_68175 = state_68070__$1;
(statearr_68097_68175[(2)] = inst_67951);

(statearr_68097_68175[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (29))){
var inst_68032 = (state_68070[(15)]);
var inst_68032__$1 = (state_68070[(2)]);
var state_68070__$1 = (function (){var statearr_68098 = state_68070;
(statearr_68098[(15)] = inst_68032__$1);

return statearr_68098;
})();
if(cljs.core.truth_(inst_68032__$1)){
var statearr_68099_68176 = state_68070__$1;
(statearr_68099_68176[(1)] = (39));

} else {
var statearr_68100_68177 = state_68070__$1;
(statearr_68100_68177[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (44))){
var inst_68037 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
var statearr_68101_68178 = state_68070__$1;
(statearr_68101_68178[(2)] = inst_68037);

(statearr_68101_68178[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (6))){
var state_68070__$1 = state_68070;
var statearr_68102_68179 = state_68070__$1;
(statearr_68102_68179[(2)] = null);

(statearr_68102_68179[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (28))){
var inst_67954 = (state_68070[(19)]);
var state_68070__$1 = state_68070;
if(cljs.core.truth_(inst_67954)){
var statearr_68103_68180 = state_68070__$1;
(statearr_68103_68180[(1)] = (30));

} else {
var statearr_68104_68181 = state_68070__$1;
(statearr_68104_68181[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (51))){
var inst_68065 = (state_68070[(2)]);
var _ = (function (){var statearr_68105 = state_68070;
(statearr_68105[(4)] = cljs.core.rest((state_68070[(4)])));

return statearr_68105;
})();
var state_68070__$1 = state_68070;
var statearr_68106_68182 = state_68070__$1;
(statearr_68106_68182[(2)] = inst_68065);

(statearr_68106_68182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (25))){
var state_68070__$1 = state_68070;
var statearr_68107_68183 = state_68070__$1;
(statearr_68107_68183[(2)] = (1000000));

(statearr_68107_68183[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (34))){
var inst_67957 = (state_68070[(17)]);
var state_68070__$1 = state_68070;
if(cljs.core.truth_(inst_67957)){
var statearr_68108_68184 = state_68070__$1;
(statearr_68108_68184[(1)] = (36));

} else {
var statearr_68109_68185 = state_68070__$1;
(statearr_68109_68185[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (17))){
var inst_67956 = (state_68070[(20)]);
var inst_68001 = (state_68070[(21)]);
var inst_67999 = (state_68070[(2)]);
var inst_68000 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_67956);
var inst_68001__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_67956);
var state_68070__$1 = (function (){var statearr_68110 = state_68070;
(statearr_68110[(12)] = inst_68000);

(statearr_68110[(22)] = inst_67999);

(statearr_68110[(21)] = inst_68001__$1);

return statearr_68110;
})();
if(cljs.core.truth_(inst_68001__$1)){
var statearr_68111_68186 = state_68070__$1;
(statearr_68111_68186[(1)] = (18));

} else {
var statearr_68112_68187 = state_68070__$1;
(statearr_68112_68187[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (3))){
var inst_68068 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68070__$1,inst_68068);
} else {
if((state_val_68071 === (12))){
var inst_67983 = (state_68070[(2)]);
var inst_67984 = fluree.db.util.async.throw_err(inst_67983);
var state_68070__$1 = state_68070;
var statearr_68113_68188 = state_68070__$1;
(statearr_68113_68188[(2)] = inst_67984);

(statearr_68113_68188[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (2))){
var inst_67954 = (state_68070[(19)]);
var inst_67957 = (state_68070[(17)]);
var inst_67952 = (state_68070[(10)]);
var inst_67948 = (state_68070[(23)]);
var inst_67951 = (state_68070[(18)]);
var inst_67953 = (state_68070[(14)]);
var inst_67949 = (state_68070[(7)]);
var inst_67950 = (state_68070[(16)]);
var inst_67955 = (state_68070[(9)]);
var inst_67956 = (state_68070[(20)]);
var _ = (function (){var statearr_68114 = state_68070;
(statearr_68114[(4)] = cljs.core.cons((5),(state_68070[(4)])));

return statearr_68114;
})();
var inst_67946 = flureeQL;
var inst_67947 = cljs.core.__destructure_map(inst_67946);
var inst_67948__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67947,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_67949__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67947,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_67950__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67947,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67951__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67947,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_67952__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67947,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_67953__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67947,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_67954__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67947,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_67955__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67947,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_67956__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67947,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_67957__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67947,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_67958 = (function (){var construct = inst_67948__$1;
var map__67945 = inst_67947;
var select = inst_67949__$1;
var block = inst_67950__$1;
var where = inst_67951__$1;
var prefixes = inst_67952__$1;
var selectDistinct = inst_67953__$1;
var selectOne = inst_67954__$1;
var from = inst_67955__$1;
var opts = inst_67956__$1;
var selectReduced = inst_67957__$1;
return (function (p1__67938_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__67938_SHARP_);
});
})();
var inst_67959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67960 = [inst_67949__$1,inst_67954__$1,inst_67953__$1,inst_67957__$1];
var inst_67961 = (new cljs.core.PersistentVector(null,4,(5),inst_67959,inst_67960,null));
var inst_67962 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_67961);
var inst_67963 = cljs.core.count(inst_67962);
var inst_67964 = (inst_67958.cljs$core$IFn$_invoke$arity$1 ? inst_67958.cljs$core$IFn$_invoke$arity$1(inst_67963) : inst_67958.call(null,inst_67963));
var state_68070__$1 = (function (){var statearr_68115 = state_68070;
(statearr_68115[(19)] = inst_67954__$1);

(statearr_68115[(17)] = inst_67957__$1);

(statearr_68115[(10)] = inst_67952__$1);

(statearr_68115[(23)] = inst_67948__$1);

(statearr_68115[(18)] = inst_67951__$1);

(statearr_68115[(14)] = inst_67953__$1);

(statearr_68115[(7)] = inst_67949__$1);

(statearr_68115[(16)] = inst_67950__$1);

(statearr_68115[(9)] = inst_67955__$1);

(statearr_68115[(20)] = inst_67956__$1);

return statearr_68115;
})();
if(cljs.core.truth_(inst_67964)){
var statearr_68116_68189 = state_68070__$1;
(statearr_68116_68189[(1)] = (6));

} else {
var statearr_68117_68190 = state_68070__$1;
(statearr_68117_68190[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (23))){
var inst_67956 = (state_68070[(20)]);
var inst_68011 = (state_68070[(8)]);
var inst_68010 = (state_68070[(2)]);
var inst_68011__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_67956);
var state_68070__$1 = (function (){var statearr_68118 = state_68070;
(statearr_68118[(24)] = inst_68010);

(statearr_68118[(8)] = inst_68011__$1);

return statearr_68118;
})();
if(cljs.core.truth_(inst_68011__$1)){
var statearr_68119_68191 = state_68070__$1;
(statearr_68119_68191[(1)] = (24));

} else {
var statearr_68120_68192 = state_68070__$1;
(statearr_68120_68192[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (47))){
var inst_68016 = (state_68070[(25)]);
var inst_67990 = (state_68070[(11)]);
var inst_68049 = (state_68070[(2)]);
var inst_68050 = fluree.db.util.core.current_time_millis();
var inst_68051 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_68016);
var inst_68052 = fluree.db.query.fql.query(inst_67990,inst_68051);
var state_68070__$1 = (function (){var statearr_68121 = state_68070;
(statearr_68121[(26)] = inst_68050);

(statearr_68121[(27)] = inst_68049);

return statearr_68121;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68070__$1,(48),inst_68052);
} else {
if((state_val_68071 === (35))){
var inst_68028 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
var statearr_68122_68193 = state_68070__$1;
(statearr_68122_68193[(2)] = inst_68028);

(statearr_68122_68193[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (19))){
var inst_68000 = (state_68070[(12)]);
var state_68070__$1 = state_68070;
var statearr_68123_68194 = state_68070__$1;
(statearr_68123_68194[(2)] = inst_68000);

(statearr_68123_68194[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (11))){
var inst_67952 = (state_68070[(10)]);
var inst_67990 = (state_68070[(2)]);
var state_68070__$1 = (function (){var statearr_68125 = state_68070;
(statearr_68125[(11)] = inst_67990);

return statearr_68125;
})();
if(cljs.core.truth_(inst_67952)){
var statearr_68126_68195 = state_68070__$1;
(statearr_68126_68195[(1)] = (15));

} else {
var statearr_68127_68196 = state_68070__$1;
(statearr_68127_68196[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (9))){
var inst_67976 = (state_68070[(28)]);
var state_68070__$1 = state_68070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68070__$1,(13),inst_67976);
} else {
if((state_val_68071 === (5))){
var _ = (function (){var statearr_68128 = state_68070;
(statearr_68128[(4)] = cljs.core.rest((state_68070[(4)])));

return statearr_68128;
})();
var state_68070__$1 = state_68070;
var ex68124 = (state_68070__$1[(2)]);
var statearr_68129_68197 = state_68070__$1;
(statearr_68129_68197[(5)] = ex68124);


if((ex68124 instanceof Error)){
var statearr_68130_68198 = state_68070__$1;
(statearr_68130_68198[(1)] = (4));

(statearr_68130_68198[(5)] = null);

} else {
throw ex68124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (14))){
var inst_67987 = (state_68070[(2)]);
var inst_67988 = fluree.db.util.async.throw_err(inst_67987);
var state_68070__$1 = state_68070;
var statearr_68131_68199 = state_68070__$1;
(statearr_68131_68199[(2)] = inst_67988);

(statearr_68131_68199[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (45))){
var state_68070__$1 = state_68070;
var statearr_68132_68200 = state_68070__$1;
(statearr_68132_68200[(2)] = null);

(statearr_68132_68200[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (26))){
var inst_67999 = (state_68070[(22)]);
var inst_67949 = (state_68070[(7)]);
var inst_67956 = (state_68070[(20)]);
var inst_68010 = (state_68070[(24)]);
var inst_68015 = (state_68070[(2)]);
var inst_68016 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_67956,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_67999,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_68015,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_68010], 0));
var state_68070__$1 = (function (){var statearr_68133 = state_68070;
(statearr_68133[(25)] = inst_68016);

return statearr_68133;
})();
if(cljs.core.truth_(inst_67949)){
var statearr_68134_68201 = state_68070__$1;
(statearr_68134_68201[(1)] = (27));

} else {
var statearr_68135_68202 = state_68070__$1;
(statearr_68135_68202[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (16))){
var inst_67997 = cljs.core.PersistentHashMap.EMPTY;
var state_68070__$1 = state_68070;
var statearr_68136_68203 = state_68070__$1;
(statearr_68136_68203[(2)] = inst_67997);

(statearr_68136_68203[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (38))){
var inst_68026 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
var statearr_68137_68204 = state_68070__$1;
(statearr_68137_68204[(2)] = inst_68026);

(statearr_68137_68204[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (30))){
var inst_67954 = (state_68070[(19)]);
var state_68070__$1 = state_68070;
var statearr_68138_68205 = state_68070__$1;
(statearr_68138_68205[(2)] = inst_67954);

(statearr_68138_68205[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (10))){
var inst_67976 = (state_68070[(28)]);
var state_68070__$1 = state_68070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68070__$1,(14),inst_67976);
} else {
if((state_val_68071 === (18))){
var inst_68001 = (state_68070[(21)]);
var state_68070__$1 = state_68070;
var statearr_68139_68206 = state_68070__$1;
(statearr_68139_68206[(2)] = inst_68001);

(statearr_68139_68206[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (42))){
var inst_67955 = (state_68070[(9)]);
var state_68070__$1 = state_68070;
var statearr_68140_68207 = state_68070__$1;
(statearr_68140_68207[(2)] = inst_67955);

(statearr_68140_68207[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (37))){
var inst_67948 = (state_68070[(23)]);
var state_68070__$1 = state_68070;
var statearr_68141_68208 = state_68070__$1;
(statearr_68141_68208[(2)] = inst_67948);

(statearr_68141_68208[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (8))){
var inst_67950 = (state_68070[(16)]);
var inst_67975 = (state_68070[(2)]);
var inst_67976 = sources;
var state_68070__$1 = (function (){var statearr_68142 = state_68070;
(statearr_68142[(28)] = inst_67976);

(statearr_68142[(29)] = inst_67975);

return statearr_68142;
})();
if(cljs.core.truth_(inst_67950)){
var statearr_68143_68209 = state_68070__$1;
(statearr_68143_68209[(1)] = (9));

} else {
var statearr_68144_68210 = state_68070__$1;
(statearr_68144_68210[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (49))){
var inst_67990 = (state_68070[(11)]);
var inst_68050 = (state_68070[(26)]);
var inst_68055 = (state_68070[(13)]);
var inst_68010 = (state_68070[(24)]);
var inst_68057 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_68058 = cljs.core.deref(inst_68010);
var inst_68059 = fluree.db.util.core.response_time_formatted(inst_68050);
var inst_68060 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_67990);
var inst_68061 = [(200),inst_68055,inst_68058,inst_68059,inst_68060];
var inst_68062 = cljs.core.PersistentHashMap.fromArrays(inst_68057,inst_68061);
var state_68070__$1 = state_68070;
var statearr_68145_68211 = state_68070__$1;
(statearr_68145_68211[(2)] = inst_68062);

(statearr_68145_68211[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_68146 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68146[(0)] = fluree$db$api$query$query_async_$_state_machine__2684__auto__);

(statearr_68146[(1)] = (1));

return statearr_68146;
});
var fluree$db$api$query$query_async_$_state_machine__2684__auto____1 = (function (state_68070){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68070);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68147){var ex__2687__auto__ = e68147;
var statearr_68148_68212 = state_68070;
(statearr_68148_68212[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68070[(4)]))){
var statearr_68149_68213 = state_68070;
(statearr_68149_68213[(1)] = cljs.core.first((state_68070[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68214 = state_68070;
state_68070 = G__68214;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2684__auto__ = function(state_68070){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2684__auto____1.call(this,state_68070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68150 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68150[(6)] = c__2706__auto__);

return statearr_68150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68355){
var state_val_68356 = (state_68355[(1)]);
if((state_val_68356 === (7))){
var inst_68350 = (state_68355[(2)]);
var _ = (function (){var statearr_68357 = state_68355;
(statearr_68357[(4)] = cljs.core.rest((state_68355[(4)])));

return statearr_68357;
})();
var state_68355__$1 = state_68355;
var statearr_68358_68434 = state_68355__$1;
(statearr_68358_68434[(2)] = inst_68350);

(statearr_68358_68434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (20))){
var inst_68322 = (state_68355[(2)]);
var state_68355__$1 = state_68355;
var statearr_68359_68435 = state_68355__$1;
(statearr_68359_68435[(2)] = inst_68322);

(statearr_68359_68435[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (27))){
var inst_68302 = (state_68355[(7)]);
var state_68355__$1 = state_68355;
var statearr_68360_68436 = state_68355__$1;
(statearr_68360_68436[(2)] = inst_68302);

(statearr_68360_68436[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (1))){
var state_68355__$1 = state_68355;
var statearr_68361_68437 = state_68355__$1;
(statearr_68361_68437[(2)] = null);

(statearr_68361_68437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (24))){
var inst_68299 = (state_68355[(8)]);
var state_68355__$1 = state_68355;
var statearr_68362_68438 = state_68355__$1;
(statearr_68362_68438[(2)] = inst_68299);

(statearr_68362_68438[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (39))){
var inst_68256 = (state_68355[(9)]);
var inst_68267 = (state_68355[(10)]);
var inst_68289 = (state_68355[(11)]);
var inst_68333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68334 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_68267];
var inst_68335 = (new cljs.core.PersistentVector(null,2,(5),inst_68333,inst_68334,null));
var inst_68336 = cljs.core.assoc_in(inst_68256,inst_68335,inst_68289);
var state_68355__$1 = state_68355;
var statearr_68363_68439 = state_68355__$1;
(statearr_68363_68439[(2)] = inst_68336);

(statearr_68363_68439[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (4))){
var inst_68215 = (state_68355[(2)]);
var state_68355__$1 = state_68355;
var statearr_68364_68440 = state_68355__$1;
(statearr_68364_68440[(2)] = inst_68215);

(statearr_68364_68440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (15))){
var inst_68254 = (state_68355[(12)]);
var inst_68289 = (state_68355[(11)]);
var inst_68292 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_68289);
var inst_68293 = (inst_68254 == null);
var state_68355__$1 = (function (){var statearr_68365 = state_68355;
(statearr_68365[(13)] = inst_68292);

return statearr_68365;
})();
if(cljs.core.truth_(inst_68293)){
var statearr_68366_68441 = state_68355__$1;
(statearr_68366_68441[(1)] = (18));

} else {
var statearr_68367_68442 = state_68355__$1;
(statearr_68367_68442[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (21))){
var inst_68292 = (state_68355[(13)]);
var state_68355__$1 = state_68355;
var statearr_68368_68443 = state_68355__$1;
(statearr_68368_68443[(2)] = inst_68292);

(statearr_68368_68443[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (31))){
var state_68355__$1 = state_68355;
var statearr_68369_68444 = state_68355__$1;
(statearr_68369_68444[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (32))){
var inst_68318 = (state_68355[(2)]);
var state_68355__$1 = state_68355;
var statearr_68371_68445 = state_68355__$1;
(statearr_68371_68445[(2)] = inst_68318);

(statearr_68371_68445[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (40))){
var inst_68287 = (state_68355[(14)]);
var state_68355__$1 = state_68355;
if(cljs.core.truth_(inst_68287)){
var statearr_68372_68446 = state_68355__$1;
(statearr_68372_68446[(1)] = (42));

} else {
var statearr_68373_68447 = state_68355__$1;
(statearr_68373_68447[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (33))){
var inst_68254 = (state_68355[(12)]);
var inst_68292 = (state_68355[(13)]);
var inst_68313 = ((inst_68292 > inst_68254) ? inst_68292 : inst_68254);
var state_68355__$1 = state_68355;
var statearr_68374_68448 = state_68355__$1;
(statearr_68374_68448[(2)] = inst_68313);

(statearr_68374_68448[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (13))){
var inst_68278 = (state_68355[(2)]);
var state_68355__$1 = state_68355;
var statearr_68375_68449 = state_68355__$1;
(statearr_68375_68449[(2)] = inst_68278);

(statearr_68375_68449[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (22))){
var inst_68299 = (state_68355[(8)]);
var inst_68292 = (state_68355[(13)]);
var inst_68299__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_68292);
var state_68355__$1 = (function (){var statearr_68376 = state_68355;
(statearr_68376[(8)] = inst_68299__$1);

return statearr_68376;
})();
if(inst_68299__$1){
var statearr_68377_68450 = state_68355__$1;
(statearr_68377_68450[(1)] = (24));

} else {
var statearr_68378_68451 = state_68355__$1;
(statearr_68378_68451[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (36))){
var inst_68255 = (state_68355[(15)]);
var inst_68289 = (state_68355[(11)]);
var inst_68327 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_68289,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_68328 = (inst_68255 + inst_68327);
var state_68355__$1 = state_68355;
var statearr_68379_68452 = state_68355__$1;
(statearr_68379_68452[(2)] = inst_68328);

(statearr_68379_68452[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (41))){
var inst_68266 = (state_68355[(16)]);
var inst_68325 = (state_68355[(17)]);
var inst_68331 = (state_68355[(18)]);
var inst_68345 = (state_68355[(2)]);
var inst_68253 = inst_68266;
var inst_68254 = inst_68325;
var inst_68255 = inst_68331;
var inst_68256 = inst_68345;
var state_68355__$1 = (function (){var statearr_68380 = state_68355;
(statearr_68380[(15)] = inst_68255);

(statearr_68380[(9)] = inst_68256);

(statearr_68380[(12)] = inst_68254);

(statearr_68380[(19)] = inst_68253);

return statearr_68380;
})();
var statearr_68381_68453 = state_68355__$1;
(statearr_68381_68453[(2)] = null);

(statearr_68381_68453[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (43))){
var inst_68289 = (state_68355[(11)]);
var state_68355__$1 = state_68355;
var statearr_68382_68454 = state_68355__$1;
(statearr_68382_68454[(2)] = inst_68289);

(statearr_68382_68454[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (29))){
var inst_68307 = (state_68355[(2)]);
var state_68355__$1 = state_68355;
var statearr_68383_68455 = state_68355__$1;
(statearr_68383_68455[(2)] = inst_68307);

(statearr_68383_68455[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (44))){
var inst_68256 = (state_68355[(9)]);
var inst_68267 = (state_68355[(10)]);
var inst_68342 = (state_68355[(2)]);
var inst_68343 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_68256,inst_68267,inst_68342);
var state_68355__$1 = state_68355;
var statearr_68384_68456 = state_68355__$1;
(statearr_68384_68456[(2)] = inst_68343);

(statearr_68384_68456[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (6))){
var inst_68268 = (state_68355[(20)]);
var inst_68253 = (state_68355[(19)]);
var inst_68264 = cljs.core.seq(inst_68253);
var inst_68265 = cljs.core.first(inst_68264);
var inst_68266 = cljs.core.next(inst_68264);
var inst_68267 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68265,(0),null);
var inst_68268__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68265,(1),null);
var inst_68269 = (inst_68268__$1 == null);
var state_68355__$1 = (function (){var statearr_68385 = state_68355;
(statearr_68385[(16)] = inst_68266);

(statearr_68385[(10)] = inst_68267);

(statearr_68385[(20)] = inst_68268__$1);

return statearr_68385;
})();
if(cljs.core.truth_(inst_68269)){
var statearr_68386_68457 = state_68355__$1;
(statearr_68386_68457[(1)] = (8));

} else {
var statearr_68387_68458 = state_68355__$1;
(statearr_68387_68458[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (28))){
var inst_68254 = (state_68355[(12)]);
var inst_68305 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_68254);
var state_68355__$1 = state_68355;
var statearr_68388_68459 = state_68355__$1;
(statearr_68388_68459[(2)] = inst_68305);

(statearr_68388_68459[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (25))){
var inst_68254 = (state_68355[(12)]);
var inst_68302 = (state_68355[(7)]);
var inst_68302__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_68254);
var state_68355__$1 = (function (){var statearr_68389 = state_68355;
(statearr_68389[(7)] = inst_68302__$1);

return statearr_68389;
})();
if(inst_68302__$1){
var statearr_68390_68460 = state_68355__$1;
(statearr_68390_68460[(1)] = (27));

} else {
var statearr_68391_68461 = state_68355__$1;
(statearr_68391_68461[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (34))){
var state_68355__$1 = state_68355;
var statearr_68392_68462 = state_68355__$1;
(statearr_68392_68462[(2)] = null);

(statearr_68392_68462[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (17))){
var inst_68286 = (state_68355[(21)]);
var inst_68325 = (state_68355[(2)]);
var state_68355__$1 = (function (){var statearr_68393 = state_68355;
(statearr_68393[(17)] = inst_68325);

return statearr_68393;
})();
if(cljs.core.truth_(inst_68286)){
var statearr_68394_68463 = state_68355__$1;
(statearr_68394_68463[(1)] = (36));

} else {
var statearr_68395_68464 = state_68355__$1;
(statearr_68395_68464[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (3))){
var inst_68353 = (state_68355[(2)]);
var state_68355__$1 = state_68355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68355__$1,inst_68353);
} else {
if((state_val_68356 === (12))){
var inst_68256 = (state_68355[(9)]);
var state_68355__$1 = state_68355;
var statearr_68396_68465 = state_68355__$1;
(statearr_68396_68465[(2)] = inst_68256);

(statearr_68396_68465[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (2))){
var inst_68230 = (state_68355[(22)]);
var inst_68225 = (state_68355[(23)]);
var inst_68229 = (state_68355[(24)]);
var _ = (function (){var statearr_68397 = state_68355;
(statearr_68397[(4)] = cljs.core.cons((5),(state_68355[(4)])));

return statearr_68397;
})();
var inst_68221 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_68222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68223 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_68224 = (new cljs.core.PersistentVector(null,2,(5),inst_68222,inst_68223,null));
var inst_68225__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_68224);
var inst_68226 = (function (){var global_block = inst_68221;
var global_meta_QMARK_ = inst_68225__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_68227 = cljs.core.PersistentHashMap.EMPTY;
var inst_68228 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_68229__$1 = cljs.core.reduce_kv(inst_68226,inst_68227,inst_68228);
var inst_68230__$1 = fluree.db.util.core.current_time_millis();
var inst_68232 = (function (){var global_block = inst_68221;
var global_meta_QMARK_ = inst_68225__$1;
var queries = inst_68229__$1;
var start_time = inst_68230__$1;
return (function (p__68231){
var vec__68398 = p__68231;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68398,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68398,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_68233 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_68232,inst_68229__$1);
var inst_68247 = cljs.core.seq(inst_68233);
var inst_68248 = cljs.core.first(inst_68247);
var inst_68249 = cljs.core.next(inst_68247);
var inst_68250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68248,(0),null);
var inst_68251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68248,(1),null);
var inst_68252 = cljs.core.PersistentHashMap.EMPTY;
var inst_68253 = inst_68233;
var inst_68254 = null;
var inst_68255 = (0);
var inst_68256 = inst_68252;
var state_68355__$1 = (function (){var statearr_68401 = state_68355;
(statearr_68401[(25)] = inst_68251);

(statearr_68401[(15)] = inst_68255);

(statearr_68401[(26)] = inst_68249);

(statearr_68401[(9)] = inst_68256);

(statearr_68401[(22)] = inst_68230__$1);

(statearr_68401[(23)] = inst_68225__$1);

(statearr_68401[(12)] = inst_68254);

(statearr_68401[(24)] = inst_68229__$1);

(statearr_68401[(27)] = inst_68250);

(statearr_68401[(19)] = inst_68253);

return statearr_68401;
})();
var statearr_68402_68466 = state_68355__$1;
(statearr_68402_68466[(2)] = null);

(statearr_68402_68466[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (23))){
var inst_68320 = (state_68355[(2)]);
var state_68355__$1 = state_68355;
var statearr_68403_68467 = state_68355__$1;
(statearr_68403_68467[(2)] = inst_68320);

(statearr_68403_68467[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (35))){
var inst_68316 = (state_68355[(2)]);
var state_68355__$1 = state_68355;
var statearr_68404_68468 = state_68355__$1;
(statearr_68404_68468[(2)] = inst_68316);

(statearr_68404_68468[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (19))){
var inst_68254 = (state_68355[(12)]);
var inst_68292 = (state_68355[(13)]);
var inst_68296 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68254,inst_68292);
var state_68355__$1 = state_68355;
if(inst_68296){
var statearr_68405_68469 = state_68355__$1;
(statearr_68405_68469[(1)] = (21));

} else {
var statearr_68406_68470 = state_68355__$1;
(statearr_68406_68470[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (11))){
var inst_68255 = (state_68355[(15)]);
var inst_68256 = (state_68355[(9)]);
var inst_68230 = (state_68355[(22)]);
var inst_68254 = (state_68355[(12)]);
var inst_68272 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_68273 = fluree.db.util.core.response_time_formatted(inst_68230);
var inst_68274 = [inst_68256,inst_68255,inst_68254,inst_68273];
var inst_68275 = cljs.core.PersistentHashMap.fromArrays(inst_68272,inst_68274);
var state_68355__$1 = state_68355;
var statearr_68408_68471 = state_68355__$1;
(statearr_68408_68471[(2)] = inst_68275);

(statearr_68408_68471[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (9))){
var inst_68267 = (state_68355[(10)]);
var inst_68229 = (state_68355[(24)]);
var inst_68268 = (state_68355[(20)]);
var inst_68281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68282 = [inst_68267,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_68283 = (new cljs.core.PersistentVector(null,2,(5),inst_68281,inst_68282,null));
var inst_68284 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68229,inst_68283);
var inst_68285 = cljs.core.__destructure_map(inst_68284);
var inst_68286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68285,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_68287 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68285,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_68355__$1 = (function (){var statearr_68409 = state_68355;
(statearr_68409[(14)] = inst_68287);

(statearr_68409[(21)] = inst_68286);

return statearr_68409;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68355__$1,(14),inst_68268);
} else {
if((state_val_68356 === (5))){
var _ = (function (){var statearr_68410 = state_68355;
(statearr_68410[(4)] = cljs.core.rest((state_68355[(4)])));

return statearr_68410;
})();
var state_68355__$1 = state_68355;
var ex68407 = (state_68355__$1[(2)]);
var statearr_68411_68472 = state_68355__$1;
(statearr_68411_68472[(5)] = ex68407);


var statearr_68412_68473 = state_68355__$1;
(statearr_68412_68473[(1)] = (4));

(statearr_68412_68473[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (14))){
var inst_68289 = (state_68355[(11)]);
var inst_68286 = (state_68355[(21)]);
var inst_68289__$1 = (state_68355[(2)]);
var inst_68290 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_68289__$1);
var state_68355__$1 = (function (){var statearr_68413 = state_68355;
(statearr_68413[(28)] = inst_68290);

(statearr_68413[(11)] = inst_68289__$1);

return statearr_68413;
})();
if(cljs.core.truth_(inst_68286)){
var statearr_68414_68474 = state_68355__$1;
(statearr_68414_68474[(1)] = (15));

} else {
var statearr_68415_68475 = state_68355__$1;
(statearr_68415_68475[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (26))){
var inst_68309 = (state_68355[(2)]);
var state_68355__$1 = state_68355;
if(cljs.core.truth_(inst_68309)){
var statearr_68416_68476 = state_68355__$1;
(statearr_68416_68476[(1)] = (30));

} else {
var statearr_68417_68477 = state_68355__$1;
(statearr_68417_68477[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (16))){
var state_68355__$1 = state_68355;
var statearr_68418_68478 = state_68355__$1;
(statearr_68418_68478[(2)] = null);

(statearr_68418_68478[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (38))){
var inst_68290 = (state_68355[(28)]);
var inst_68331 = (state_68355[(2)]);
var state_68355__$1 = (function (){var statearr_68419 = state_68355;
(statearr_68419[(18)] = inst_68331);

return statearr_68419;
})();
if(cljs.core.truth_(inst_68290)){
var statearr_68420_68479 = state_68355__$1;
(statearr_68420_68479[(1)] = (39));

} else {
var statearr_68421_68480 = state_68355__$1;
(statearr_68421_68480[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (30))){
var state_68355__$1 = state_68355;
var statearr_68422_68481 = state_68355__$1;
(statearr_68422_68481[(2)] = (207));

(statearr_68422_68481[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (10))){
var inst_68348 = (state_68355[(2)]);
var state_68355__$1 = state_68355;
var statearr_68423_68482 = state_68355__$1;
(statearr_68423_68482[(2)] = inst_68348);

(statearr_68423_68482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (18))){
var inst_68292 = (state_68355[(13)]);
var state_68355__$1 = state_68355;
var statearr_68424_68483 = state_68355__$1;
(statearr_68424_68483[(2)] = inst_68292);

(statearr_68424_68483[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (42))){
var inst_68289 = (state_68355[(11)]);
var inst_68339 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_68289);
var state_68355__$1 = state_68355;
var statearr_68425_68484 = state_68355__$1;
(statearr_68425_68484[(2)] = inst_68339);

(statearr_68425_68484[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (37))){
var state_68355__$1 = state_68355;
var statearr_68426_68485 = state_68355__$1;
(statearr_68426_68485[(2)] = null);

(statearr_68426_68485[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68356 === (8))){
var inst_68225 = (state_68355[(23)]);
var state_68355__$1 = state_68355;
if(cljs.core.truth_(inst_68225)){
var statearr_68427_68486 = state_68355__$1;
(statearr_68427_68486[(1)] = (11));

} else {
var statearr_68428_68487 = state_68355__$1;
(statearr_68428_68487[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_68429 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68429[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__);

(statearr_68429[(1)] = (1));

return statearr_68429;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1 = (function (state_68355){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68355);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68430){var ex__2687__auto__ = e68430;
var statearr_68431_68488 = state_68355;
(statearr_68431_68488[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68355[(4)]))){
var statearr_68432_68489 = state_68355;
(statearr_68432_68489[(1)] = cljs.core.first((state_68355[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68490 = state_68355;
state_68355 = G__68490;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__ = function(state_68355){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1.call(this,state_68355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68433 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68433[(6)] = c__2706__auto__);

return statearr_68433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__68491 = query_type;
var G__68491__$1 = (((G__68491 instanceof cljs.core.Keyword))?G__68491.fqn:null);
switch (G__68491__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__68491__$1)].join('')));

}
});
