// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__15938 = cljs.core.get_global_hierarchy;
return (fexpr__15938.cljs$core$IFn$_invoke$arity$0 ? fexpr__15938.cljs$core$IFn$_invoke$arity$0() : fexpr__15938.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("set websocket id:",ws_id) : fluree.db.util.log.trace.call(null,"set websocket id:",ws_id));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$3("process event:",event_type,event_data) : fluree.db.util.log.trace.call(null,"process event:",event_type,event_data));

var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__15939 = cljs.core.seq(callbacks);
var chunk__15940 = null;
var count__15941 = (0);
var i__15942 = (0);
while(true){
if((i__15942 < count__15941)){
var vec__15955 = chunk__15940.cljs$core$IIndexed$_nth$arity$2(null,i__15942);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15955,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15955,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e15958){var e_15967 = e15958;
var G__15959_15968 = e_15967;
var G__15960_15969 = ["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__15959_15968,G__15960_15969) : fluree.db.util.log.error.call(null,G__15959_15968,G__15960_15969));
}

var G__15970 = seq__15939;
var G__15971 = chunk__15940;
var G__15972 = count__15941;
var G__15973 = (i__15942 + (1));
seq__15939 = G__15970;
chunk__15940 = G__15971;
count__15941 = G__15972;
i__15942 = G__15973;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__15939);
if(temp__5804__auto__){
var seq__15939__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15939__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__15939__$1);
var G__15974 = cljs.core.chunk_rest(seq__15939__$1);
var G__15975 = c__5568__auto__;
var G__15976 = cljs.core.count(c__5568__auto__);
var G__15977 = (0);
seq__15939 = G__15974;
chunk__15940 = G__15975;
count__15941 = G__15976;
i__15942 = G__15977;
continue;
} else {
var vec__15961 = cljs.core.first(seq__15939__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15961,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15961,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e15964){var e_15978 = e15964;
var G__15965_15979 = e_15978;
var G__15966_15980 = ["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__15965_15979,G__15966_15980) : fluree.db.util.log.error.call(null,G__15965_15979,G__15966_15980));
}

var G__15981 = cljs.core.next(seq__15939__$1);
var G__15982 = null;
var G__15983 = (0);
var G__15984 = (0);
seq__15939 = G__15981;
chunk__15940 = G__15982;
count__15941 = G__15983;
i__15942 = G__15984;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Process events: ",msg) : fluree.db.util.log.trace.call(null,"Process events: ",msg));
var vec__15987 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15987,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15987,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15987,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15987,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__15990 = conn;
var map__15990__$1 = cljs.core.__destructure_map(map__15990);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15990__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__15991 = event_type__$1;
var G__15991__$1 = (((G__15991 instanceof cljs.core.Keyword))?G__15991.fqn:null);
switch (G__15991__$1) {
case "response":
var temp__5804__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5804__auto__)){
var res_chan = temp__5804__auto__;
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Found response channel for subject",subject) : fluree.db.util.log.trace.call(null,"Found response channel for subject",subject));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__15985_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__15985_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__15992 = error_data;
var map__15992__$1 = cljs.core.__destructure_map(map__15992);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15992__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e15986){var e = e15986;
return (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1(e) : fluree.db.util.log.error.call(null,e));
}});
