// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__68535_68716 = cljs.core.seq(servers);
var chunk__68536_68717 = null;
var count__68537_68718 = (0);
var i__68538_68719 = (0);
while(true){
if((i__68538_68719 < count__68537_68718)){
var server_68720 = chunk__68536_68717.cljs$core$IIndexed$_nth$arity$2(null,i__68538_68719);
var healthcheck_uri_68721 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_68720),"/fdb/health"].join('');
var resp_chan_68722 = fluree.db.util.xhttp.post_json(healthcheck_uri_68721,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___68723 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,c__2706__auto___68723,healthcheck_uri_68721,resp_chan_68722,server_68720){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,c__2706__auto___68723,healthcheck_uri_68721,resp_chan_68722,server_68720){
return (function (state_68608){
var state_val_68609 = (state_68608[(1)]);
if((state_val_68609 === (1))){
var state_68608__$1 = state_68608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68608__$1,(2),resp_chan_68722);
} else {
if((state_val_68609 === (2))){
var inst_68594 = (state_68608[(7)]);
var inst_68594__$1 = (state_68608[(2)]);
var inst_68595 = fluree.db.util.core.exception_QMARK_(inst_68594__$1);
var state_68608__$1 = (function (){var statearr_68610 = state_68608;
(statearr_68610[(7)] = inst_68594__$1);

return statearr_68610;
})();
if(inst_68595){
var statearr_68611_68724 = state_68608__$1;
(statearr_68611_68724[(1)] = (3));

} else {
var statearr_68612_68725 = state_68608__$1;
(statearr_68612_68725[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68609 === (3))){
var inst_68594 = (state_68608[(7)]);
var inst_68597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68598 = cljs.core.ex_message(inst_68594);
var inst_68599 = cljs.core.ex_data(inst_68594);
var inst_68600 = ["Server contact error: ",inst_68598,inst_68599];
var inst_68601 = (new cljs.core.PersistentVector(null,3,(5),inst_68597,inst_68600,null));
var inst_68602 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68601);
var state_68608__$1 = state_68608;
var statearr_68613_68726 = state_68608__$1;
(statearr_68613_68726[(2)] = inst_68602);

(statearr_68613_68726[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68609 === (4))){
var inst_68604 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_68720);
var state_68608__$1 = state_68608;
var statearr_68614_68727 = state_68608__$1;
(statearr_68614_68727[(2)] = inst_68604);

(statearr_68614_68727[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68609 === (5))){
var inst_68606 = (state_68608[(2)]);
var state_68608__$1 = state_68608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68608__$1,inst_68606);
} else {
return null;
}
}
}
}
}
});})(seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,c__2706__auto___68723,healthcheck_uri_68721,resp_chan_68722,server_68720))
;
return ((function (seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,switch__2683__auto__,c__2706__auto___68723,healthcheck_uri_68721,resp_chan_68722,server_68720){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_68615 = [null,null,null,null,null,null,null,null];
(statearr_68615[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_68615[(1)] = (1));

return statearr_68615;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_68608){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68608);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68616){var ex__2687__auto__ = e68616;
var statearr_68617_68728 = state_68608;
(statearr_68617_68728[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68608[(4)]))){
var statearr_68618_68729 = state_68608;
(statearr_68618_68729[(1)] = cljs.core.first((state_68608[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68730 = state_68608;
state_68608 = G__68730;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_68608){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_68608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,switch__2683__auto__,c__2706__auto___68723,healthcheck_uri_68721,resp_chan_68722,server_68720))
})();
var state__2708__auto__ = (function (){var statearr_68619 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68619[(6)] = c__2706__auto___68723);

return statearr_68619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});})(seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,c__2706__auto___68723,healthcheck_uri_68721,resp_chan_68722,server_68720))
);



var G__68731 = seq__68535_68716;
var G__68732 = chunk__68536_68717;
var G__68733 = count__68537_68718;
var G__68734 = (i__68538_68719 + (1));
seq__68535_68716 = G__68731;
chunk__68536_68717 = G__68732;
count__68537_68718 = G__68733;
i__68538_68719 = G__68734;
continue;
} else {
var temp__5804__auto___68735 = cljs.core.seq(seq__68535_68716);
if(temp__5804__auto___68735){
var seq__68535_68736__$1 = temp__5804__auto___68735;
if(cljs.core.chunked_seq_QMARK_(seq__68535_68736__$1)){
var c__5568__auto___68737 = cljs.core.chunk_first(seq__68535_68736__$1);
var G__68738 = cljs.core.chunk_rest(seq__68535_68736__$1);
var G__68739 = c__5568__auto___68737;
var G__68740 = cljs.core.count(c__5568__auto___68737);
var G__68741 = (0);
seq__68535_68716 = G__68738;
chunk__68536_68717 = G__68739;
count__68537_68718 = G__68740;
i__68538_68719 = G__68741;
continue;
} else {
var server_68742 = cljs.core.first(seq__68535_68736__$1);
var healthcheck_uri_68743 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_68742),"/fdb/health"].join('');
var resp_chan_68744 = fluree.db.util.xhttp.post_json(healthcheck_uri_68743,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___68745 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,c__2706__auto___68745,healthcheck_uri_68743,resp_chan_68744,server_68742,seq__68535_68736__$1,temp__5804__auto___68735){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,c__2706__auto___68745,healthcheck_uri_68743,resp_chan_68744,server_68742,seq__68535_68736__$1,temp__5804__auto___68735){
return (function (state_68635){
var state_val_68636 = (state_68635[(1)]);
if((state_val_68636 === (1))){
var state_68635__$1 = state_68635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68635__$1,(2),resp_chan_68744);
} else {
if((state_val_68636 === (2))){
var inst_68621 = (state_68635[(7)]);
var inst_68621__$1 = (state_68635[(2)]);
var inst_68622 = fluree.db.util.core.exception_QMARK_(inst_68621__$1);
var state_68635__$1 = (function (){var statearr_68637 = state_68635;
(statearr_68637[(7)] = inst_68621__$1);

return statearr_68637;
})();
if(inst_68622){
var statearr_68638_68746 = state_68635__$1;
(statearr_68638_68746[(1)] = (3));

} else {
var statearr_68639_68747 = state_68635__$1;
(statearr_68639_68747[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68636 === (3))){
var inst_68621 = (state_68635[(7)]);
var inst_68624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68625 = cljs.core.ex_message(inst_68621);
var inst_68626 = cljs.core.ex_data(inst_68621);
var inst_68627 = ["Server contact error: ",inst_68625,inst_68626];
var inst_68628 = (new cljs.core.PersistentVector(null,3,(5),inst_68624,inst_68627,null));
var inst_68629 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68628);
var state_68635__$1 = state_68635;
var statearr_68640_68748 = state_68635__$1;
(statearr_68640_68748[(2)] = inst_68629);

(statearr_68640_68748[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68636 === (4))){
var inst_68631 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_68742);
var state_68635__$1 = state_68635;
var statearr_68641_68749 = state_68635__$1;
(statearr_68641_68749[(2)] = inst_68631);

(statearr_68641_68749[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68636 === (5))){
var inst_68633 = (state_68635[(2)]);
var state_68635__$1 = state_68635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68635__$1,inst_68633);
} else {
return null;
}
}
}
}
}
});})(seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,c__2706__auto___68745,healthcheck_uri_68743,resp_chan_68744,server_68742,seq__68535_68736__$1,temp__5804__auto___68735))
;
return ((function (seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,switch__2683__auto__,c__2706__auto___68745,healthcheck_uri_68743,resp_chan_68744,server_68742,seq__68535_68736__$1,temp__5804__auto___68735){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_68642 = [null,null,null,null,null,null,null,null];
(statearr_68642[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_68642[(1)] = (1));

return statearr_68642;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_68635){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68635);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68643){var ex__2687__auto__ = e68643;
var statearr_68644_68750 = state_68635;
(statearr_68644_68750[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68635[(4)]))){
var statearr_68645_68751 = state_68635;
(statearr_68645_68751[(1)] = cljs.core.first((state_68635[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68752 = state_68635;
state_68635 = G__68752;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_68635){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_68635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,switch__2683__auto__,c__2706__auto___68745,healthcheck_uri_68743,resp_chan_68744,server_68742,seq__68535_68736__$1,temp__5804__auto___68735))
})();
var state__2708__auto__ = (function (){var statearr_68646 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68646[(6)] = c__2706__auto___68745);

return statearr_68646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});})(seq__68535_68716,chunk__68536_68717,count__68537_68718,i__68538_68719,c__2706__auto___68745,healthcheck_uri_68743,resp_chan_68744,server_68742,seq__68535_68736__$1,temp__5804__auto___68735))
);



var G__68753 = cljs.core.next(seq__68535_68736__$1);
var G__68754 = null;
var G__68755 = (0);
var G__68756 = (0);
seq__68535_68716 = G__68753;
chunk__68536_68717 = G__68754;
count__68537_68718 = G__68755;
i__68538_68719 = G__68756;
continue;
}
} else {
}
}
break;
}

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68690){
var state_val_68691 = (state_68690[(1)]);
if((state_val_68691 === (7))){
var inst_68662 = (state_68690[(7)]);
var inst_68669 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68662,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_68690__$1 = state_68690;
if(inst_68669){
var statearr_68692_68757 = state_68690__$1;
(statearr_68692_68757[(1)] = (9));

} else {
var statearr_68693_68758 = state_68690__$1;
(statearr_68693_68758[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (1))){
var inst_68654 = (state_68690[(8)]);
var inst_68655 = (state_68690[(9)]);
var inst_68654__$1 = promise_chan;
var inst_68655__$1 = cljs.core.async.timeout((60000));
var inst_68656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68657 = [inst_68654__$1,inst_68655__$1];
var inst_68658 = (new cljs.core.PersistentVector(null,2,(5),inst_68656,inst_68657,null));
var state_68690__$1 = (function (){var statearr_68694 = state_68690;
(statearr_68694[(8)] = inst_68654__$1);

(statearr_68694[(9)] = inst_68655__$1);

return statearr_68694;
})();
return cljs.core.async.ioc_alts_BANG_(state_68690__$1,(2),inst_68658);
} else {
if((state_val_68691 === (4))){
var inst_68662 = (state_68690[(7)]);
var inst_68655 = (state_68690[(9)]);
var inst_68666 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68662,inst_68655);
var state_68690__$1 = state_68690;
if(inst_68666){
var statearr_68695_68759 = state_68690__$1;
(statearr_68695_68759[(1)] = (6));

} else {
var statearr_68696_68760 = state_68690__$1;
(statearr_68696_68760[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (13))){
var state_68690__$1 = state_68690;
var statearr_68697_68761 = state_68690__$1;
(statearr_68697_68761[(2)] = null);

(statearr_68697_68761[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (6))){
var state_68690__$1 = state_68690;
var statearr_68698_68762 = state_68690__$1;
(statearr_68698_68762[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_68698_68762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (3))){
var state_68690__$1 = state_68690;
var statearr_68699_68763 = state_68690__$1;
(statearr_68699_68763[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_68699_68763[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (12))){
var inst_68680 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_68681 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68682 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_68683 = cljs.core.PersistentHashMap.fromArrays(inst_68681,inst_68682);
var inst_68684 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_68683);
var inst_68685 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_68684);
var state_68690__$1 = (function (){var statearr_68700 = state_68690;
(statearr_68700[(10)] = inst_68680);

return statearr_68700;
})();
var statearr_68701_68764 = state_68690__$1;
(statearr_68701_68764[(2)] = inst_68685);

(statearr_68701_68764[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (2))){
var inst_68654 = (state_68690[(8)]);
var inst_68662 = (state_68690[(7)]);
var inst_68660 = (state_68690[(2)]);
var inst_68661 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68660,(0),null);
var inst_68662__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68660,(1),null);
var inst_68663 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68662__$1,inst_68654);
var state_68690__$1 = (function (){var statearr_68702 = state_68690;
(statearr_68702[(7)] = inst_68662__$1);

(statearr_68702[(11)] = inst_68661);

return statearr_68702;
})();
if(inst_68663){
var statearr_68703_68765 = state_68690__$1;
(statearr_68703_68765[(1)] = (3));

} else {
var statearr_68704_68766 = state_68690__$1;
(statearr_68704_68766[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (11))){
var inst_68673 = (state_68690[(2)]);
var state_68690__$1 = state_68690;
var statearr_68705_68767 = state_68690__$1;
(statearr_68705_68767[(2)] = inst_68673);

(statearr_68705_68767[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (9))){
var inst_68661 = (state_68690[(11)]);
var state_68690__$1 = state_68690;
var statearr_68706_68768 = state_68690__$1;
(statearr_68706_68768[(2)] = inst_68661);

(statearr_68706_68768[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (5))){
var inst_68677 = (state_68690[(2)]);
var inst_68678 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_68677);
var state_68690__$1 = state_68690;
if(inst_68678){
var statearr_68707_68769 = state_68690__$1;
(statearr_68707_68769[(1)] = (12));

} else {
var statearr_68708_68770 = state_68690__$1;
(statearr_68708_68770[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (14))){
var inst_68688 = (state_68690[(2)]);
var state_68690__$1 = state_68690;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68690__$1,inst_68688);
} else {
if((state_val_68691 === (10))){
var state_68690__$1 = state_68690;
var statearr_68709_68771 = state_68690__$1;
(statearr_68709_68771[(2)] = null);

(statearr_68709_68771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68691 === (8))){
var inst_68675 = (state_68690[(2)]);
var state_68690__$1 = state_68690;
var statearr_68710_68772 = state_68690__$1;
(statearr_68710_68772[(2)] = inst_68675);

(statearr_68710_68772[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_68711 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68711[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_68711[(1)] = (1));

return statearr_68711;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_68690){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68690);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68712){var ex__2687__auto__ = e68712;
var statearr_68713_68773 = state_68690;
(statearr_68713_68773[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68690[(4)]))){
var statearr_68714_68774 = state_68690;
(statearr_68714_68774[(1)] = cljs.core.first((state_68690[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68775 = state_68690;
state_68690 = G__68775;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_68690){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_68690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68715 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68715[(6)] = c__2706__auto__);

return statearr_68715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68819){
var state_val_68820 = (state_68819[(1)]);
if((state_val_68820 === (7))){
var state_68819__$1 = state_68819;
var statearr_68821_68847 = state_68819__$1;
(statearr_68821_68847[(2)] = null);

(statearr_68821_68847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68820 === (1))){
var state_68819__$1 = state_68819;
var statearr_68822_68848 = state_68819__$1;
(statearr_68822_68848[(2)] = null);

(statearr_68822_68848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68820 === (4))){
var inst_68776 = (state_68819[(2)]);
var state_68819__$1 = state_68819;
var statearr_68823_68849 = state_68819__$1;
(statearr_68823_68849[(2)] = inst_68776);

(statearr_68823_68849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68820 === (6))){
var inst_68798 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_68819__$1 = state_68819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68819__$1,(9),inst_68798);
} else {
if((state_val_68820 === (3))){
var inst_68817 = (state_68819[(2)]);
var state_68819__$1 = state_68819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68819__$1,inst_68817);
} else {
if((state_val_68820 === (12))){
var inst_68811 = (state_68819[(2)]);
var state_68819__$1 = state_68819;
var statearr_68824_68850 = state_68819__$1;
(statearr_68824_68850[(2)] = inst_68811);

(statearr_68824_68850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68820 === (2))){
var inst_68787 = (state_68819[(7)]);
var inst_68782 = (state_68819[(8)]);
var inst_68792 = (state_68819[(9)]);
var _ = (function (){var statearr_68825 = state_68819;
(statearr_68825[(4)] = cljs.core.cons((5),(state_68819[(4)])));

return statearr_68825;
})();
var inst_68782__$1 = cljs.core.random_uuid();
var inst_68783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68784 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_68785 = (new cljs.core.PersistentVector(null,2,(5),inst_68783,inst_68784,null));
var inst_68786 = (function (){var lock_id = inst_68782__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_68787__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_68785,inst_68786);
var inst_68788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68789 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_68790 = (new cljs.core.PersistentVector(null,3,(5),inst_68788,inst_68789,null));
var inst_68791 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68787__$1,inst_68790);
var inst_68792__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68782__$1,inst_68791);
var inst_68793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68794 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_68795 = (new cljs.core.PersistentVector(null,3,(5),inst_68793,inst_68794,null));
var inst_68796 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68787__$1,inst_68795);
var state_68819__$1 = (function (){var statearr_68826 = state_68819;
(statearr_68826[(10)] = inst_68796);

(statearr_68826[(7)] = inst_68787__$1);

(statearr_68826[(8)] = inst_68782__$1);

(statearr_68826[(9)] = inst_68792__$1);

return statearr_68826;
})();
if(inst_68792__$1){
var statearr_68827_68851 = state_68819__$1;
(statearr_68827_68851[(1)] = (6));

} else {
var statearr_68828_68852 = state_68819__$1;
(statearr_68828_68852[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68820 === (11))){
var inst_68796 = (state_68819[(10)]);
var inst_68803 = (state_68819[(11)]);
var inst_68802 = (state_68819[(12)]);
var inst_68809 = fluree.db.util.xhttp.try_socket(inst_68802,sub_chan,pub_chan,inst_68796,(60000),inst_68803);
var state_68819__$1 = state_68819;
var statearr_68830_68853 = state_68819__$1;
(statearr_68830_68853[(2)] = inst_68809);

(statearr_68830_68853[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68820 === (9))){
var inst_68800 = (state_68819[(13)]);
var inst_68796 = (state_68819[(10)]);
var inst_68787 = (state_68819[(7)]);
var inst_68782 = (state_68819[(8)]);
var inst_68792 = (state_68819[(9)]);
var inst_68802 = (state_68819[(12)]);
var inst_68800__$1 = (state_68819[(2)]);
var inst_68801 = clojure.string.replace(inst_68800__$1,"http","ws");
var inst_68802__$1 = [inst_68801,"/fdb/ws"].join('');
var inst_68803 = (function (){var lock_id = inst_68782;
var state = inst_68787;
var have_lock_QMARK_ = inst_68792;
var resp_chan = inst_68796;
var healthy_server = inst_68800__$1;
var ws_url = inst_68802__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_68804 = fluree.db.util.core.exception_QMARK_(inst_68800__$1);
var state_68819__$1 = (function (){var statearr_68831 = state_68819;
(statearr_68831[(13)] = inst_68800__$1);

(statearr_68831[(11)] = inst_68803);

(statearr_68831[(12)] = inst_68802__$1);

return statearr_68831;
})();
if(inst_68804){
var statearr_68832_68854 = state_68819__$1;
(statearr_68832_68854[(1)] = (10));

} else {
var statearr_68833_68855 = state_68819__$1;
(statearr_68833_68855[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68820 === (5))){
var _ = (function (){var statearr_68834 = state_68819;
(statearr_68834[(4)] = cljs.core.rest((state_68819[(4)])));

return statearr_68834;
})();
var state_68819__$1 = state_68819;
var ex68829 = (state_68819__$1[(2)]);
var statearr_68835_68856 = state_68819__$1;
(statearr_68835_68856[(5)] = ex68829);


if((ex68829 instanceof Error)){
var statearr_68836_68857 = state_68819__$1;
(statearr_68836_68857[(1)] = (4));

(statearr_68836_68857[(5)] = null);

} else {
throw ex68829;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68820 === (10))){
var inst_68800 = (state_68819[(13)]);
var inst_68796 = (state_68819[(10)]);
var inst_68806 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_68807 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68796,inst_68800);
var state_68819__$1 = (function (){var statearr_68837 = state_68819;
(statearr_68837[(14)] = inst_68806);

return statearr_68837;
})();
var statearr_68838_68858 = state_68819__$1;
(statearr_68838_68858[(2)] = inst_68807);

(statearr_68838_68858[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68820 === (8))){
var inst_68796 = (state_68819[(10)]);
var inst_68814 = (state_68819[(2)]);
var _ = (function (){var statearr_68839 = state_68819;
(statearr_68839[(4)] = cljs.core.rest((state_68819[(4)])));

return statearr_68839;
})();
var state_68819__$1 = (function (){var statearr_68840 = state_68819;
(statearr_68840[(15)] = inst_68814);

return statearr_68840;
})();
var statearr_68841_68859 = state_68819__$1;
(statearr_68841_68859[(2)] = inst_68796);

(statearr_68841_68859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_68842 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68842[(0)] = fluree$db$connection$establish_socket_$_state_machine__2684__auto__);

(statearr_68842[(1)] = (1));

return statearr_68842;
});
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____1 = (function (state_68819){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68819);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68843){var ex__2687__auto__ = e68843;
var statearr_68844_68860 = state_68819;
(statearr_68844_68860[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68819[(4)]))){
var statearr_68845_68861 = state_68819;
(statearr_68845_68861[(1)] = cljs.core.first((state_68819[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68862 = state_68819;
state_68819 = G__68862;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = function(state_68819){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____1.call(this,state_68819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68846 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68846[(6)] = c__2706__auto__);

return statearr_68846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k68864,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__68868 = k68864;
var G__68868__$1 = (((G__68868 instanceof cljs.core.Keyword))?G__68868.fqn:null);
switch (G__68868__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k68864,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__68869){
var vec__68870 = p__68869;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68870,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68870,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__68863){
var self__ = this;
var G__68863__$1 = this;
return (new cljs.core.RecordIter((0),G__68863__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__68873 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__68873(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this68865,other68866){
var self__ = this;
var this68865__$1 = this;
return (((!((other68866 == null)))) && ((((this68865__$1.constructor === other68866.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.id,other68866.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.servers,other68866.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.state,other68866.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.req_chan,other68866.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.sub_chan,other68866.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.pub_chan,other68866.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.group,other68866.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.storage_read,other68866.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.storage_list,other68866.storage_list)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.storage_write,other68866.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.storage_exists,other68866.storage_exists)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.storage_rename,other68866.storage_rename)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.storage_delete,other68866.storage_delete)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.object_cache,other68866.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.async_cache,other68866.async_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.parallelism,other68866.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.serializer,other68866.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.default_network,other68866.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.transactor_QMARK_,other68866.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.publish,other68866.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.transact_handler,other68866.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.tx_private_key,other68866.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.tx_key_id,other68866.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.meta,other68866.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.add_listener,other68866.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.remove_listener,other68866.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.close,other68866.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68865__$1.__extmap,other68866.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__68874){
var self__ = this;
var map__68875 = p__68874;
var map__68875__$1 = cljs.core.__destructure_map(map__68875);
var node = map__68875__$1;
var id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68875__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68875__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68875__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf(node);
} else {
var G__68876 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__68877 = (function (_){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3(conn__$1,node,(function (){
var G__68878 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__68879 = null;
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__68878,G__68879) : self__.async_cache.call(null,G__68878,G__68879));
}));
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__68876,G__68877) : self__.async_cache.call(null,G__68876,G__68877));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k68864){
var self__ = this;
var this__5350__auto____$1 = this;
var G__68880 = k68864;
var G__68880__$1 = (((G__68880 instanceof cljs.core.Keyword))?G__68880.fqn:null);
switch (G__68880__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k68864);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__68863){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__68881 = cljs.core.keyword_identical_QMARK_;
var expr__68882 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__68884 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__68885 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68884,G__68885) : pred__68881.call(null,G__68884,G__68885));
})())){
return (new fluree.db.connection.Connection(G__68863,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68886 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__68887 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68886,G__68887) : pred__68881.call(null,G__68886,G__68887));
})())){
return (new fluree.db.connection.Connection(self__.id,G__68863,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68888 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__68889 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68888,G__68889) : pred__68881.call(null,G__68888,G__68889));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__68863,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68890 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__68891 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68890,G__68891) : pred__68881.call(null,G__68890,G__68891));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__68863,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68892 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__68893 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68892,G__68893) : pred__68881.call(null,G__68892,G__68893));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__68863,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68894 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__68895 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68894,G__68895) : pred__68881.call(null,G__68894,G__68895));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__68863,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68896 = new cljs.core.Keyword(null,"group","group",582596132);
var G__68897 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68896,G__68897) : pred__68881.call(null,G__68896,G__68897));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__68863,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68898 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__68899 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68898,G__68899) : pred__68881.call(null,G__68898,G__68899));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__68863,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68900 = new cljs.core.Keyword(null,"storage-list","storage-list",1202854328);
var G__68901 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68900,G__68901) : pred__68881.call(null,G__68900,G__68901));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__68863,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68902 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__68903 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68902,G__68903) : pred__68881.call(null,G__68902,G__68903));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__68863,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68904 = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075);
var G__68905 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68904,G__68905) : pred__68881.call(null,G__68904,G__68905));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__68863,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68906 = new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229);
var G__68907 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68906,G__68907) : pred__68881.call(null,G__68906,G__68907));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__68863,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68908 = new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532);
var G__68909 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68908,G__68909) : pred__68881.call(null,G__68908,G__68909));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__68863,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68910 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__68911 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68910,G__68911) : pred__68881.call(null,G__68910,G__68911));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__68863,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68912 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__68913 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68912,G__68913) : pred__68881.call(null,G__68912,G__68913));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__68863,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68914 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__68915 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68914,G__68915) : pred__68881.call(null,G__68914,G__68915));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__68863,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68916 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__68917 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68916,G__68917) : pred__68881.call(null,G__68916,G__68917));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__68863,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68918 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__68919 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68918,G__68919) : pred__68881.call(null,G__68918,G__68919));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__68863,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68920 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__68921 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68920,G__68921) : pred__68881.call(null,G__68920,G__68921));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__68863,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68922 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__68923 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68922,G__68923) : pred__68881.call(null,G__68922,G__68923));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__68863,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68924 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__68925 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68924,G__68925) : pred__68881.call(null,G__68924,G__68925));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__68863,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68926 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__68927 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68926,G__68927) : pred__68881.call(null,G__68926,G__68927));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__68863,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68928 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__68929 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68928,G__68929) : pred__68881.call(null,G__68928,G__68929));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__68863,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68930 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__68931 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68930,G__68931) : pred__68881.call(null,G__68930,G__68931));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__68863,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68932 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__68933 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68932,G__68933) : pred__68881.call(null,G__68932,G__68933));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__68863,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68934 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__68935 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68934,G__68935) : pred__68881.call(null,G__68934,G__68935));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__68863,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68936 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__68937 = expr__68882;
return (pred__68881.cljs$core$IFn$_invoke$arity$2 ? pred__68881.cljs$core$IFn$_invoke$arity$2(G__68936,G__68937) : pred__68881.call(null,G__68936,G__68937));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__68863,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__68863),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_read.cljs$core$IFn$_invoke$arity$1 ? self__.storage_read.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_read.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return (self__.storage_write.cljs$core$IFn$_invoke$arity$2 ? self__.storage_write.cljs$core$IFn$_invoke$arity$2(k,data) : self__.storage_write.call(null,k,data));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_exists.cljs$core$IFn$_invoke$arity$1 ? self__.storage_exists.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_exists.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return (self__.storage_rename.cljs$core$IFn$_invoke$arity$2 ? self__.storage_rename.cljs$core$IFn$_invoke$arity$2(old_key,new_key) : self__.storage_rename.call(null,old_key,new_key));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return (self__.storage_list.cljs$core$IFn$_invoke$arity$1 ? self__.storage_list.cljs$core$IFn$_invoke$arity$1(d) : self__.storage_list.call(null,d));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_delete.cljs$core$IFn$_invoke$arity$1 ? self__.storage_delete.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_delete.call(null,k));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__68863){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__68863,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__68867){
var extmap__5385__auto__ = (function (){var G__68938 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__68867,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__68867)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__68938);
} else {
return G__68938;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__68867),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__68867),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__68944 = servers_STAR_;
var vec__68945 = G__68944;
var seq__68946 = cljs.core.seq(vec__68945);
var first__68947 = cljs.core.first(seq__68946);
var seq__68946__$1 = cljs.core.next(seq__68946);
var server = first__68947;
var r = seq__68946__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__68944__$1 = G__68944;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__68951 = G__68944__$1;
var seq__68952 = cljs.core.seq(vec__68951);
var first__68953 = cljs.core.first(seq__68952);
var seq__68952__$1 = cljs.core.next(seq__68952);
var server__$1 = first__68953;
var r__$1 = seq__68952__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__68954 = r__$1;
var G__68955 = is_https_QMARK_;
var G__68956 = result_STAR_;
G__68944__$1 = G__68954;
https_QMARK___$1 = G__68955;
result__$1 = G__68956;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__68957 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__68957 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__68957);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68986){
var state_val_68987 = (state_68986[(1)]);
if((state_val_68987 === (7))){
var inst_68972 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68973 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68974 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68975 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68976 = fluree.db.connection.establish_socket(inst_68972,inst_68973,inst_68974,inst_68975);
var state_68986__$1 = state_68986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68986__$1,(9),inst_68976);
} else {
if((state_val_68987 === (1))){
var state_68986__$1 = state_68986;
var statearr_68988_69007 = state_68986__$1;
(statearr_68988_69007[(2)] = null);

(statearr_68988_69007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68987 === (4))){
var inst_68958 = (state_68986[(2)]);
var state_68986__$1 = state_68986;
var statearr_68989_69008 = state_68986__$1;
(statearr_68989_69008[(2)] = inst_68958);

(statearr_68989_69008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68987 === (6))){
var inst_68969 = (state_68986[(7)]);
var state_68986__$1 = state_68986;
var statearr_68990_69009 = state_68986__$1;
(statearr_68990_69009[(2)] = inst_68969);

(statearr_68990_69009[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68987 === (3))){
var inst_68984 = (state_68986[(2)]);
var state_68986__$1 = state_68986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68986__$1,inst_68984);
} else {
if((state_val_68987 === (2))){
var inst_68969 = (state_68986[(7)]);
var _ = (function (){var statearr_68992 = state_68986;
(statearr_68992[(4)] = cljs.core.cons((5),(state_68986[(4)])));

return statearr_68992;
})();
var inst_68964 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_68965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68966 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68967 = [inst_68966,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_68968 = (new cljs.core.PersistentVector(null,3,(5),inst_68965,inst_68967,null));
var inst_68969__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68964,inst_68968);
var state_68986__$1 = (function (){var statearr_68993 = state_68986;
(statearr_68993[(7)] = inst_68969__$1);

return statearr_68993;
})();
if(cljs.core.truth_(inst_68969__$1)){
var statearr_68994_69010 = state_68986__$1;
(statearr_68994_69010[(1)] = (6));

} else {
var statearr_68995_69011 = state_68986__$1;
(statearr_68995_69011[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68987 === (9))){
var inst_68978 = (state_68986[(2)]);
var inst_68979 = fluree.db.util.async.throw_err(inst_68978);
var state_68986__$1 = state_68986;
var statearr_68996_69012 = state_68986__$1;
(statearr_68996_69012[(2)] = inst_68979);

(statearr_68996_69012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68987 === (5))){
var _ = (function (){var statearr_68997 = state_68986;
(statearr_68997[(4)] = cljs.core.rest((state_68986[(4)])));

return statearr_68997;
})();
var state_68986__$1 = state_68986;
var ex68991 = (state_68986__$1[(2)]);
var statearr_68998_69013 = state_68986__$1;
(statearr_68998_69013[(5)] = ex68991);


if((ex68991 instanceof Error)){
var statearr_68999_69014 = state_68986__$1;
(statearr_68999_69014[(1)] = (4));

(statearr_68999_69014[(5)] = null);

} else {
throw ex68991;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68987 === (8))){
var inst_68981 = (state_68986[(2)]);
var _ = (function (){var statearr_69000 = state_68986;
(statearr_69000[(4)] = cljs.core.rest((state_68986[(4)])));

return statearr_69000;
})();
var state_68986__$1 = state_68986;
var statearr_69001_69015 = state_68986__$1;
(statearr_69001_69015[(2)] = inst_68981);

(statearr_69001_69015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_69002 = [null,null,null,null,null,null,null,null];
(statearr_69002[(0)] = fluree$db$connection$get_socket_$_state_machine__2684__auto__);

(statearr_69002[(1)] = (1));

return statearr_69002;
});
var fluree$db$connection$get_socket_$_state_machine__2684__auto____1 = (function (state_68986){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68986);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69003){var ex__2687__auto__ = e69003;
var statearr_69004_69016 = state_68986;
(statearr_69004_69016[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68986[(4)]))){
var statearr_69005_69017 = state_68986;
(statearr_69005_69017[(1)] = cljs.core.first((state_68986[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69018 = state_68986;
state_68986 = G__69018;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2684__auto__ = function(state_68986){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____1.call(this,state_68986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2684__auto____0;
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69006 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69006[(6)] = c__2706__auto__);

return statearr_69006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e69019){var e = e69019;
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__69021){
var map__69022 = p__69021;
var map__69022__$1 = cljs.core.__destructure_map(map__69022);
var conn = map__69022__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69022__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69022__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69022__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69168){
var state_val_69169 = (state_69168[(1)]);
if((state_val_69169 === (7))){
var inst_69164 = (state_69168[(2)]);
var state_69168__$1 = state_69168;
var statearr_69171_69245 = state_69168__$1;
(statearr_69171_69245[(2)] = inst_69164);

(statearr_69171_69245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (20))){
var _ = (function (){var statearr_69172 = state_69168;
(statearr_69172[(4)] = cljs.core.rest((state_69168[(4)])));

return statearr_69172;
})();
var state_69168__$1 = state_69168;
var ex69170 = (state_69168__$1[(2)]);
var statearr_69173_69246 = state_69168__$1;
(statearr_69173_69246[(5)] = ex69170);


var statearr_69174_69247 = state_69168__$1;
(statearr_69174_69247[(1)] = (10));

(statearr_69174_69247[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (27))){
var inst_69125 = (state_69168[(7)]);
var inst_69125__$1 = (state_69168[(2)]);
var inst_69126 = inst_69125__$1 === true;
var state_69168__$1 = (function (){var statearr_69175 = state_69168;
(statearr_69175[(7)] = inst_69125__$1);

return statearr_69175;
})();
if(cljs.core.truth_(inst_69126)){
var statearr_69176_69248 = state_69168__$1;
(statearr_69176_69248[(1)] = (28));

} else {
var statearr_69177_69249 = state_69168__$1;
(statearr_69177_69249[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (1))){
var inst_69023 = (0);
var state_69168__$1 = (function (){var statearr_69178 = state_69168;
(statearr_69178[(8)] = inst_69023);

return statearr_69178;
})();
var statearr_69179_69250 = state_69168__$1;
(statearr_69179_69250[(2)] = null);

(statearr_69179_69250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (24))){
var inst_69115 = (state_69168[(9)]);
var state_69168__$1 = state_69168;
var statearr_69180_69251 = state_69168__$1;
(statearr_69180_69251[(2)] = inst_69115);

(statearr_69180_69251[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (39))){
var inst_69150 = (state_69168[(2)]);
var state_69168__$1 = state_69168;
var statearr_69181_69252 = state_69168__$1;
(statearr_69181_69252[(2)] = inst_69150);

(statearr_69181_69252[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (4))){
var inst_69026 = (state_69168[(10)]);
var inst_69026__$1 = (state_69168[(2)]);
var state_69168__$1 = (function (){var statearr_69182 = state_69168;
(statearr_69182[(10)] = inst_69026__$1);

return statearr_69182;
})();
if(cljs.core.truth_(inst_69026__$1)){
var statearr_69183_69253 = state_69168__$1;
(statearr_69183_69253[(1)] = (5));

} else {
var statearr_69184_69254 = state_69168__$1;
(statearr_69184_69254[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (15))){
var inst_69039 = (state_69168[(11)]);
var state_69168__$1 = state_69168;
var statearr_69185_69255 = state_69168__$1;
(statearr_69185_69255[(2)] = inst_69039);

(statearr_69185_69255[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (21))){
var inst_69068 = (state_69168[(12)]);
var inst_69069 = (state_69168[(13)]);
var inst_69072 = (state_69168[(14)]);
var inst_69026 = (state_69168[(10)]);
var inst_69070 = (state_69168[(15)]);
var inst_69077 = (state_69168[(16)]);
var inst_69073 = (state_69168[(17)]);
var inst_69023 = (state_69168[(8)]);
var inst_69071 = (state_69168[(18)]);
var inst_69076 = (state_69168[(19)]);
var inst_69079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69080 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_69076];
var inst_69081 = (new cljs.core.PersistentVector(null,2,(5),inst_69079,inst_69080,null));
var inst_69082 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_69081,inst_69071);
var inst_69109 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_69110 = (function (){var resp_chan = inst_69071;
var timeout = inst_69077;
var i = inst_69023;
var data = inst_69070;
var map__69064 = inst_69073;
var _ = inst_69068;
var req_id = inst_69076;
var operation = inst_69069;
var msg = inst_69026;
var temp__5804__auto__ = inst_69026;
var c__2706__auto____$1 = inst_69109;
var opts = inst_69072;
var vec__69061 = inst_69026;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69107){
var state_val_69108 = (state_69107[(1)]);
if((state_val_69108 === (1))){
var inst_69086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69087 = cljs.core.async.timeout(timeout);
var inst_69088 = [resp_chan,inst_69087];
var inst_69089 = (new cljs.core.PersistentVector(null,2,(5),inst_69086,inst_69088,null));
var state_69107__$1 = state_69107;
return cljs.core.async.ioc_alts_BANG_(state_69107__$1,(2),inst_69089);
} else {
if((state_val_69108 === (2))){
var inst_69092 = (state_69107[(7)]);
var inst_69091 = (state_69107[(2)]);
var inst_69092__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69091,(0),null);
var inst_69093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69091,(1),null);
var inst_69094 = (function (){var vec__69083 = inst_69091;
var resp = inst_69092__$1;
var c = inst_69093;
return (function (p1__69020_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__69020_SHARP_,req_id);
});
})();
var inst_69095 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_69094);
var inst_69096 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69093,resp_chan);
var state_69107__$1 = (function (){var statearr_69186 = state_69107;
(statearr_69186[(7)] = inst_69092__$1);

(statearr_69186[(8)] = inst_69095);

return statearr_69186;
})();
if(inst_69096){
var statearr_69187_69256 = state_69107__$1;
(statearr_69187_69256[(1)] = (3));

} else {
var statearr_69188_69257 = state_69107__$1;
(statearr_69188_69257[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69108 === (3))){
var inst_69092 = (state_69107[(7)]);
var state_69107__$1 = state_69107;
var statearr_69189_69258 = state_69107__$1;
(statearr_69189_69258[(2)] = inst_69092);

(statearr_69189_69258[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69108 === (4))){
var inst_69099 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_69100 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69101 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_69102 = cljs.core.PersistentHashMap.fromArrays(inst_69100,inst_69101);
var inst_69103 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69099,inst_69102);
var state_69107__$1 = state_69107;
var statearr_69190_69259 = state_69107__$1;
(statearr_69190_69259[(2)] = inst_69103);

(statearr_69190_69259[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69108 === (5))){
var inst_69105 = (state_69107[(2)]);
var state_69107__$1 = state_69107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69107__$1,inst_69105);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_69191 = [null,null,null,null,null,null,null,null,null];
(statearr_69191[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_69191[(1)] = (1));

return statearr_69191;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_69107){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69107);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69192){var ex__2687__auto__ = e69192;
var statearr_69193_69260 = state_69107;
(statearr_69193_69260[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69107[(4)]))){
var statearr_69194_69261 = state_69107;
(statearr_69194_69261[(1)] = cljs.core.first((state_69107[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69262 = state_69107;
state_69107 = G__69262;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_69107){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_69107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69195 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69195[(6)] = c__2706__auto____$1);

return statearr_69195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_69111 = cljs.core.async.impl.dispatch.run(inst_69110);
var state_69168__$1 = (function (){var statearr_69196 = state_69168;
(statearr_69196[(20)] = inst_69111);

(statearr_69196[(21)] = inst_69082);

return statearr_69196;
})();
var statearr_69197_69263 = state_69168__$1;
(statearr_69197_69263[(2)] = inst_69109);

(statearr_69197_69263[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (31))){
var inst_69125 = (state_69168[(7)]);
var inst_69131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69132 = [inst_69125,"Error processing message in producer."];
var inst_69133 = (new cljs.core.PersistentVector(null,2,(5),inst_69131,inst_69132,null));
var inst_69134 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69133);
var state_69168__$1 = state_69168;
var statearr_69198_69264 = state_69168__$1;
(statearr_69198_69264[(2)] = inst_69134);

(statearr_69198_69264[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (32))){
var inst_69125 = (state_69168[(7)]);
var inst_69136 = (inst_69125 == null);
var state_69168__$1 = state_69168;
if(cljs.core.truth_(inst_69136)){
var statearr_69199_69265 = state_69168__$1;
(statearr_69199_69265[(1)] = (34));

} else {
var statearr_69200_69266 = state_69168__$1;
(statearr_69200_69266[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (33))){
var inst_69154 = (state_69168[(2)]);
var state_69168__$1 = state_69168;
var statearr_69201_69267 = state_69168__$1;
(statearr_69201_69267[(2)] = inst_69154);

(statearr_69201_69267[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (13))){
var inst_69039 = (state_69168[(11)]);
var inst_69036 = (state_69168[(2)]);
var inst_69037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69036,(0),null);
var inst_69038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69036,(1),null);
var inst_69039__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69036,(2),null);
var state_69168__$1 = (function (){var statearr_69202 = state_69168;
(statearr_69202[(22)] = inst_69037);

(statearr_69202[(23)] = inst_69038);

(statearr_69202[(11)] = inst_69039__$1);

return statearr_69202;
})();
if(cljs.core.truth_(inst_69039__$1)){
var statearr_69203_69268 = state_69168__$1;
(statearr_69203_69268[(1)] = (14));

} else {
var statearr_69204_69269 = state_69168__$1;
(statearr_69204_69269[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (22))){
var state_69168__$1 = state_69168;
var statearr_69205_69270 = state_69168__$1;
(statearr_69205_69270[(2)] = null);

(statearr_69205_69270[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (36))){
var inst_69152 = (state_69168[(2)]);
var state_69168__$1 = state_69168;
var statearr_69206_69271 = state_69168__$1;
(statearr_69206_69271[(2)] = inst_69152);

(statearr_69206_69271[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (29))){
var inst_69125 = (state_69168[(7)]);
var inst_69129 = fluree.db.util.core.exception_QMARK_(inst_69125);
var state_69168__$1 = state_69168;
if(inst_69129){
var statearr_69207_69272 = state_69168__$1;
(statearr_69207_69272[(1)] = (31));

} else {
var statearr_69208_69273 = state_69168__$1;
(statearr_69208_69273[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (6))){
var state_69168__$1 = state_69168;
var statearr_69209_69274 = state_69168__$1;
(statearr_69209_69274[(2)] = null);

(statearr_69209_69274[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (28))){
var state_69168__$1 = state_69168;
var statearr_69210_69275 = state_69168__$1;
(statearr_69210_69275[(2)] = null);

(statearr_69210_69275[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (25))){
var state_69168__$1 = state_69168;
var statearr_69211_69276 = state_69168__$1;
(statearr_69211_69276[(2)] = fluree.db.connection.default_publish_fn);

(statearr_69211_69276[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (34))){
var inst_69138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69139 = ["Error processing message in producer. Socket closed."];
var inst_69140 = (new cljs.core.PersistentVector(null,1,(5),inst_69138,inst_69139,null));
var inst_69141 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69140);
var state_69168__$1 = state_69168;
var statearr_69212_69277 = state_69168__$1;
(statearr_69212_69277[(2)] = inst_69141);

(statearr_69212_69277[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (17))){
var inst_69028 = (state_69168[(24)]);
var inst_69039 = (state_69168[(11)]);
var inst_69046 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69039,inst_69028);
var state_69168__$1 = state_69168;
var statearr_69213_69278 = state_69168__$1;
(statearr_69213_69278[(2)] = inst_69046);

(statearr_69213_69278[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (3))){
var inst_69166 = (state_69168[(2)]);
var state_69168__$1 = state_69168;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69168__$1,inst_69166);
} else {
if((state_val_69169 === (12))){
var state_69168__$1 = state_69168;
var statearr_69214_69279 = state_69168__$1;
(statearr_69214_69279[(2)] = null);

(statearr_69214_69279[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (2))){
var state_69168__$1 = state_69168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69168__$1,(4),req_chan);
} else {
if((state_val_69169 === (23))){
var inst_69115 = (state_69168[(9)]);
var inst_69114 = (state_69168[(2)]);
var inst_69115__$1 = publish;
var state_69168__$1 = (function (){var statearr_69215 = state_69168;
(statearr_69215[(25)] = inst_69114);

(statearr_69215[(9)] = inst_69115__$1);

return statearr_69215;
})();
if(cljs.core.truth_(inst_69115__$1)){
var statearr_69216_69280 = state_69168__$1;
(statearr_69216_69280[(1)] = (24));

} else {
var statearr_69217_69281 = state_69168__$1;
(statearr_69217_69281[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (35))){
var state_69168__$1 = state_69168;
var statearr_69218_69282 = state_69168__$1;
(statearr_69218_69282[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (19))){
var inst_69055 = (state_69168[(2)]);
var state_69168__$1 = state_69168;
var statearr_69220_69283 = state_69168__$1;
(statearr_69220_69283[(2)] = inst_69055);

(statearr_69220_69283[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (11))){
var inst_69026 = (state_69168[(10)]);
var state_69168__$1 = state_69168;
var statearr_69221_69284 = state_69168__$1;
(statearr_69221_69284[(2)] = inst_69026);

(statearr_69221_69284[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (9))){
var inst_69023 = (state_69168[(8)]);
var inst_69159 = (state_69168[(2)]);
var inst_69160 = (inst_69023 + (1));
var inst_69023__$1 = inst_69160;
var state_69168__$1 = (function (){var statearr_69222 = state_69168;
(statearr_69222[(26)] = inst_69159);

(statearr_69222[(8)] = inst_69023__$1);

return statearr_69222;
})();
var statearr_69223_69285 = state_69168__$1;
(statearr_69223_69285[(2)] = null);

(statearr_69223_69285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (5))){
var state_69168__$1 = state_69168;
var statearr_69224_69286 = state_69168__$1;
(statearr_69224_69286[(2)] = null);

(statearr_69224_69286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (14))){
var inst_69039 = (state_69168[(11)]);
var inst_69041 = fluree.db.util.async.channel_QMARK_(inst_69039);
var state_69168__$1 = state_69168;
var statearr_69225_69287 = state_69168__$1;
(statearr_69225_69287[(2)] = inst_69041);

(statearr_69225_69287[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (26))){
var inst_69069 = (state_69168[(13)]);
var inst_69070 = (state_69168[(15)]);
var inst_69076 = (state_69168[(19)]);
var inst_69119 = (state_69168[(2)]);
var inst_69120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69121 = [inst_69069,inst_69076,inst_69070];
var inst_69122 = (new cljs.core.PersistentVector(null,3,(5),inst_69120,inst_69121,null));
var inst_69123 = (inst_69119.cljs$core$IFn$_invoke$arity$2 ? inst_69119.cljs$core$IFn$_invoke$arity$2(conn,inst_69122) : inst_69119.call(null,conn,inst_69122));
var state_69168__$1 = state_69168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69168__$1,(27),inst_69123);
} else {
if((state_val_69169 === (16))){
var inst_69044 = (state_69168[(2)]);
var state_69168__$1 = state_69168;
if(cljs.core.truth_(inst_69044)){
var statearr_69226_69288 = state_69168__$1;
(statearr_69226_69288[(1)] = (17));

} else {
var statearr_69227_69289 = state_69168__$1;
(statearr_69227_69289[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (38))){
var state_69168__$1 = state_69168;
var statearr_69228_69290 = state_69168__$1;
(statearr_69228_69290[(2)] = null);

(statearr_69228_69290[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (30))){
var inst_69156 = (state_69168[(2)]);
var _ = (function (){var statearr_69229 = state_69168;
(statearr_69229[(4)] = cljs.core.rest((state_69168[(4)])));

return statearr_69229;
})();
var state_69168__$1 = state_69168;
var statearr_69230_69291 = state_69168__$1;
(statearr_69230_69291[(2)] = inst_69156);

(statearr_69230_69291[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (10))){
var inst_69026 = (state_69168[(10)]);
var inst_69028 = (state_69168[(2)]);
var inst_69032 = cljs.core.sequential_QMARK_(inst_69026);
var state_69168__$1 = (function (){var statearr_69231 = state_69168;
(statearr_69231[(24)] = inst_69028);

return statearr_69231;
})();
if(inst_69032){
var statearr_69232_69292 = state_69168__$1;
(statearr_69232_69292[(1)] = (11));

} else {
var statearr_69233_69293 = state_69168__$1;
(statearr_69233_69293[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (18))){
var inst_69028 = (state_69168[(24)]);
var inst_69026 = (state_69168[(10)]);
var inst_69048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69049 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69026], 0));
var inst_69050 = ["Error processing ledger request, no valid return channel: ",inst_69049].join('');
var inst_69051 = [inst_69028,inst_69050];
var inst_69052 = (new cljs.core.PersistentVector(null,2,(5),inst_69048,inst_69051,null));
var inst_69053 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69052);
var state_69168__$1 = state_69168;
var statearr_69234_69294 = state_69168__$1;
(statearr_69234_69294[(2)] = inst_69053);

(statearr_69234_69294[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (37))){
var inst_69125 = (state_69168[(7)]);
var inst_69144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69145 = ["Error processing message in producer. Socket closed. Published result",inst_69125];
var inst_69146 = (new cljs.core.PersistentVector(null,2,(5),inst_69144,inst_69145,null));
var inst_69147 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69146);
var state_69168__$1 = state_69168;
var statearr_69235_69295 = state_69168__$1;
(statearr_69235_69295[(2)] = inst_69147);

(statearr_69235_69295[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69169 === (8))){
var inst_69072 = (state_69168[(14)]);
var inst_69026 = (state_69168[(10)]);
var inst_69073 = (state_69168[(17)]);
var inst_69071 = (state_69168[(18)]);
var _ = (function (){var statearr_69236 = state_69168;
(statearr_69236[(4)] = cljs.core.cons((20),(state_69168[(4)])));

return statearr_69236;
})();
var inst_69065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69066 = ["Outgoing message to websocket: ",inst_69026];
var inst_69067 = (new cljs.core.PersistentVector(null,2,(5),inst_69065,inst_69066,null));
var inst_69068 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_69067);
var inst_69069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69026,(0),null);
var inst_69070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69026,(1),null);
var inst_69071__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69026,(2),null);
var inst_69072__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69026,(3),null);
var inst_69073__$1 = cljs.core.__destructure_map(inst_69072__$1);
var inst_69074 = cljs.core.random_uuid();
var inst_69075 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69074);
var inst_69076 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_69073__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_69075);
var inst_69077 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_69073__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_69168__$1 = (function (){var statearr_69237 = state_69168;
(statearr_69237[(12)] = inst_69068);

(statearr_69237[(13)] = inst_69069);

(statearr_69237[(14)] = inst_69072__$1);

(statearr_69237[(15)] = inst_69070);

(statearr_69237[(16)] = inst_69077);

(statearr_69237[(17)] = inst_69073__$1);

(statearr_69237[(18)] = inst_69071__$1);

(statearr_69237[(19)] = inst_69076);

return statearr_69237;
})();
if(cljs.core.truth_(inst_69071__$1)){
var statearr_69238_69296 = state_69168__$1;
(statearr_69238_69296[(1)] = (21));

} else {
var statearr_69239_69297 = state_69168__$1;
(statearr_69239_69297[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_69240 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69240[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_69240[(1)] = (1));

return statearr_69240;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_69168){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69168);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69241){var ex__2687__auto__ = e69241;
var statearr_69242_69298 = state_69168;
(statearr_69242_69298[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69168[(4)]))){
var statearr_69243_69299 = state_69168;
(statearr_69243_69299[(1)] = cljs.core.first((state_69168[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69300 = state_69168;
state_69168 = G__69300;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_69168){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_69168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69244 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69244[(6)] = c__2706__auto__);

return statearr_69244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69338){
var state_val_69339 = (state_69338[(1)]);
if((state_val_69339 === (7))){
var inst_69309 = (state_69338[(7)]);
var state_69338__$1 = state_69338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69338__$1,(9),inst_69309);
} else {
if((state_val_69339 === (1))){
var inst_69301 = (1);
var state_69338__$1 = (function (){var statearr_69340 = state_69338;
(statearr_69340[(8)] = inst_69301);

return statearr_69340;
})();
var statearr_69341_69364 = state_69338__$1;
(statearr_69341_69364[(2)] = null);

(statearr_69341_69364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69339 === (4))){
var inst_69306 = (state_69338[(2)]);
var inst_69307 = fluree.db.connection.get_socket(conn);
var state_69338__$1 = (function (){var statearr_69342 = state_69338;
(statearr_69342[(9)] = inst_69306);

return statearr_69342;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69338__$1,(5),inst_69307);
} else {
if((state_val_69339 === (15))){
var inst_69334 = (state_69338[(2)]);
var state_69338__$1 = state_69338;
var statearr_69343_69365 = state_69338__$1;
(statearr_69343_69365[(2)] = inst_69334);

(statearr_69343_69365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69339 === (13))){
var inst_69316 = (state_69338[(10)]);
var inst_69301 = (state_69338[(8)]);
var inst_69324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69325 = [inst_69316,"Cannot establish connection to a healthy server, backing off:",inst_69301,"s."];
var inst_69326 = (new cljs.core.PersistentVector(null,4,(5),inst_69324,inst_69325,null));
var inst_69327 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69326);
var inst_69328 = ((2) * inst_69301);
var inst_69329 = ((60) * (2));
var inst_69330 = ((inst_69328 < inst_69329) ? inst_69328 : inst_69329);
var inst_69301__$1 = inst_69330;
var state_69338__$1 = (function (){var statearr_69344 = state_69338;
(statearr_69344[(11)] = inst_69327);

(statearr_69344[(8)] = inst_69301__$1);

return statearr_69344;
})();
var statearr_69345_69366 = state_69338__$1;
(statearr_69345_69366[(2)] = null);

(statearr_69345_69366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69339 === (6))){
var inst_69309 = (state_69338[(7)]);
var state_69338__$1 = state_69338;
var statearr_69346_69367 = state_69338__$1;
(statearr_69346_69367[(2)] = inst_69309);

(statearr_69346_69367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69339 === (3))){
var inst_69336 = (state_69338[(2)]);
var state_69338__$1 = state_69338;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69338__$1,inst_69336);
} else {
if((state_val_69339 === (12))){
var inst_69322 = (state_69338[(2)]);
var state_69338__$1 = state_69338;
if(cljs.core.truth_(inst_69322)){
var statearr_69347_69368 = state_69338__$1;
(statearr_69347_69368[(1)] = (13));

} else {
var statearr_69348_69369 = state_69338__$1;
(statearr_69348_69369[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69339 === (2))){
var inst_69301 = (state_69338[(8)]);
var inst_69303 = (inst_69301 * (1000));
var inst_69304 = cljs.core.async.timeout(inst_69303);
var state_69338__$1 = state_69338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69338__$1,(4),inst_69304);
} else {
if((state_val_69339 === (11))){
var inst_69316 = (state_69338[(10)]);
var inst_69320 = fluree.db.util.core.exception_QMARK_(inst_69316);
var state_69338__$1 = state_69338;
var statearr_69349_69370 = state_69338__$1;
(statearr_69349_69370[(2)] = inst_69320);

(statearr_69349_69370[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69339 === (9))){
var inst_69314 = (state_69338[(2)]);
var state_69338__$1 = state_69338;
var statearr_69350_69371 = state_69338__$1;
(statearr_69350_69371[(2)] = inst_69314);

(statearr_69350_69371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69339 === (5))){
var inst_69309 = (state_69338[(7)]);
var inst_69309__$1 = (state_69338[(2)]);
var inst_69310 = fluree.db.util.core.exception_QMARK_(inst_69309__$1);
var state_69338__$1 = (function (){var statearr_69351 = state_69338;
(statearr_69351[(7)] = inst_69309__$1);

return statearr_69351;
})();
if(inst_69310){
var statearr_69352_69372 = state_69338__$1;
(statearr_69352_69372[(1)] = (6));

} else {
var statearr_69353_69373 = state_69338__$1;
(statearr_69353_69373[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69339 === (14))){
var inst_69316 = (state_69338[(10)]);
var state_69338__$1 = state_69338;
var statearr_69354_69374 = state_69338__$1;
(statearr_69354_69374[(2)] = inst_69316);

(statearr_69354_69374[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69339 === (10))){
var inst_69317 = (state_69338[(12)]);
var state_69338__$1 = state_69338;
var statearr_69355_69375 = state_69338__$1;
(statearr_69355_69375[(2)] = inst_69317);

(statearr_69355_69375[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69339 === (8))){
var inst_69316 = (state_69338[(10)]);
var inst_69317 = (state_69338[(12)]);
var inst_69316__$1 = (state_69338[(2)]);
var inst_69317__$1 = (inst_69316__$1 == null);
var state_69338__$1 = (function (){var statearr_69356 = state_69338;
(statearr_69356[(10)] = inst_69316__$1);

(statearr_69356[(12)] = inst_69317__$1);

return statearr_69356;
})();
if(cljs.core.truth_(inst_69317__$1)){
var statearr_69357_69376 = state_69338__$1;
(statearr_69357_69376[(1)] = (10));

} else {
var statearr_69358_69377 = state_69338__$1;
(statearr_69358_69377[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0 = (function (){
var statearr_69359 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69359[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__);

(statearr_69359[(1)] = (1));

return statearr_69359;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1 = (function (state_69338){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69338);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69360){var ex__2687__auto__ = e69360;
var statearr_69361_69378 = state_69338;
(statearr_69361_69378[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69338[(4)]))){
var statearr_69362_69379 = state_69338;
(statearr_69362_69379[(1)] = cljs.core.first((state_69338[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69380 = state_69338;
state_69338 = G__69380;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__ = function(state_69338){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1.call(this,state_69338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69363 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69363[(6)] = c__2706__auto__);

return statearr_69363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__69381){
var map__69382 = p__69381;
var map__69382__$1 = cljs.core.__destructure_map(map__69382);
var conn = map__69382__$1;
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69382__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69382__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69382__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69382__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69493){
var state_val_69494 = (state_69493[(1)]);
if((state_val_69494 === (7))){
var inst_69489 = (state_69493[(2)]);
var state_69493__$1 = state_69493;
var statearr_69495_69551 = state_69493__$1;
(statearr_69495_69551[(2)] = inst_69489);

(statearr_69495_69551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (20))){
var inst_69440 = (state_69493[(2)]);
var state_69493__$1 = state_69493;
var statearr_69496_69552 = state_69493__$1;
(statearr_69496_69552[(2)] = inst_69440);

(statearr_69496_69552[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (27))){
var inst_69458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69459 = ["Connection closed."];
var inst_69460 = (new cljs.core.PersistentVector(null,1,(5),inst_69458,inst_69459,null));
var inst_69461 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_69460);
var state_69493__$1 = state_69493;
var statearr_69497_69553 = state_69493__$1;
(statearr_69497_69553[(2)] = inst_69461);

(statearr_69497_69553[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (1))){
var inst_69383 = (0);
var state_69493__$1 = (function (){var statearr_69498 = state_69493;
(statearr_69498[(7)] = inst_69383);

return statearr_69498;
})();
var statearr_69499_69554 = state_69493__$1;
(statearr_69499_69554[(2)] = null);

(statearr_69499_69554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (24))){
var inst_69427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69428 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_69429 = [keep_alive_fn];
var inst_69430 = cljs.core.PersistentHashMap.fromArrays(inst_69428,inst_69429);
var inst_69431 = ["Unsupported callback registered",inst_69430];
var inst_69432 = (new cljs.core.PersistentVector(null,2,(5),inst_69427,inst_69431,null));
var inst_69433 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_69432);
var state_69493__$1 = state_69493;
var statearr_69500_69555 = state_69493__$1;
(statearr_69500_69555[(2)] = inst_69433);

(statearr_69500_69555[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (4))){
var inst_69388 = (state_69493[(8)]);
var inst_69393 = (state_69493[(2)]);
var inst_69394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69393,(0),null);
var inst_69395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69393,(1),null);
var inst_69396 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69395,inst_69388);
var state_69493__$1 = (function (){var statearr_69501 = state_69493;
(statearr_69501[(9)] = inst_69394);

return statearr_69501;
})();
if(inst_69396){
var statearr_69502_69556 = state_69493__$1;
(statearr_69502_69556[(1)] = (5));

} else {
var statearr_69503_69557 = state_69493__$1;
(statearr_69503_69557[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (15))){
var inst_69413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69414 = ["No keep-alive callback is registered"];
var inst_69415 = (new cljs.core.PersistentVector(null,1,(5),inst_69413,inst_69414,null));
var inst_69416 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_69415);
var state_69493__$1 = state_69493;
var statearr_69504_69558 = state_69493__$1;
(statearr_69504_69558[(2)] = inst_69416);

(statearr_69504_69558[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (21))){
var inst_69424 = cljs.core.eval(keep_alive_fn);
var state_69493__$1 = state_69493;
var statearr_69505_69559 = state_69493__$1;
(statearr_69505_69559[(2)] = inst_69424);

(statearr_69505_69559[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (31))){
var state_69493__$1 = state_69493;
var statearr_69506_69560 = state_69493__$1;
(statearr_69506_69560[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (32))){
var inst_69485 = (state_69493[(2)]);
var state_69493__$1 = state_69493;
var statearr_69508_69561 = state_69493__$1;
(statearr_69508_69561[(2)] = inst_69485);

(statearr_69508_69561[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (33))){
var inst_69394 = (state_69493[(9)]);
var inst_69472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69473 = fluree.db.util.json.parse(inst_69394);
var inst_69474 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69473], 0));
var inst_69475 = ["Received message:",inst_69474];
var inst_69476 = (new cljs.core.PersistentVector(null,2,(5),inst_69472,inst_69475,null));
var inst_69477 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_69476);
var inst_69478 = fluree.db.util.json.parse(inst_69394);
var inst_69479 = fluree.db.conn_events.process_events(conn,inst_69478);
var inst_69383 = (0);
var state_69493__$1 = (function (){var statearr_69509 = state_69493;
(statearr_69509[(10)] = inst_69477);

(statearr_69509[(11)] = inst_69479);

(statearr_69509[(7)] = inst_69383);

return statearr_69509;
})();
var statearr_69510_69562 = state_69493__$1;
(statearr_69510_69562[(2)] = null);

(statearr_69510_69562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (13))){
var inst_69448 = (state_69493[(2)]);
var state_69493__$1 = state_69493;
var statearr_69511_69563 = state_69493__$1;
(statearr_69511_69563[(2)] = inst_69448);

(statearr_69511_69563[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (22))){
var state_69493__$1 = state_69493;
var statearr_69512_69564 = state_69493__$1;
(statearr_69512_69564[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (29))){
var inst_69487 = (state_69493[(2)]);
var state_69493__$1 = state_69493;
var statearr_69514_69565 = state_69493__$1;
(statearr_69514_69565[(2)] = inst_69487);

(statearr_69514_69565[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (6))){
var inst_69394 = (state_69493[(9)]);
var inst_69456 = (inst_69394 == null);
var state_69493__$1 = state_69493;
if(cljs.core.truth_(inst_69456)){
var statearr_69515_69566 = state_69493__$1;
(statearr_69515_69566[(1)] = (27));

} else {
var statearr_69516_69567 = state_69493__$1;
(statearr_69516_69567[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (28))){
var inst_69394 = (state_69493[(9)]);
var inst_69463 = fluree.db.util.core.exception_QMARK_(inst_69394);
var state_69493__$1 = state_69493;
if(inst_69463){
var statearr_69517_69568 = state_69493__$1;
(statearr_69517_69568[(1)] = (30));

} else {
var statearr_69518_69569 = state_69493__$1;
(statearr_69518_69569[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (25))){
var state_69493__$1 = state_69493;
var statearr_69519_69570 = state_69493__$1;
(statearr_69519_69570[(2)] = null);

(statearr_69519_69570[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (34))){
var state_69493__$1 = state_69493;
var statearr_69520_69571 = state_69493__$1;
(statearr_69520_69571[(2)] = null);

(statearr_69520_69571[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (17))){
var inst_69442 = (state_69493[(2)]);
var inst_69443 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69444 = fluree.db.connection.close_websocket(inst_69443);
var inst_69445 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69446 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_69445);
var state_69493__$1 = (function (){var statearr_69521 = state_69493;
(statearr_69521[(12)] = inst_69442);

(statearr_69521[(13)] = inst_69444);

return statearr_69521;
})();
var statearr_69522_69572 = state_69493__$1;
(statearr_69522_69572[(2)] = inst_69446);

(statearr_69522_69572[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (3))){
var inst_69491 = (state_69493[(2)]);
var state_69493__$1 = state_69493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69493__$1,inst_69491);
} else {
if((state_val_69494 === (12))){
var inst_69406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69407 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_69408 = (new cljs.core.PersistentVector(null,1,(5),inst_69406,inst_69407,null));
var inst_69409 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_69408);
var inst_69410 = keep_alive_fn;
var inst_69411 = (keep_alive_fn == null);
var state_69493__$1 = (function (){var statearr_69523 = state_69493;
(statearr_69523[(14)] = inst_69410);

(statearr_69523[(15)] = inst_69409);

return statearr_69523;
})();
if(cljs.core.truth_(inst_69411)){
var statearr_69524_69573 = state_69493__$1;
(statearr_69524_69573[(1)] = (15));

} else {
var statearr_69525_69574 = state_69493__$1;
(statearr_69525_69574[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (2))){
var inst_69388 = (state_69493[(8)]);
var inst_69388__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_69389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69390 = [sub_chan,inst_69388__$1];
var inst_69391 = (new cljs.core.PersistentVector(null,2,(5),inst_69389,inst_69390,null));
var state_69493__$1 = (function (){var statearr_69526 = state_69493;
(statearr_69526[(8)] = inst_69388__$1);

return statearr_69526;
})();
return cljs.core.async.ioc_alts_BANG_(state_69493__$1,(4),inst_69391);
} else {
if((state_val_69494 === (23))){
var inst_69438 = (state_69493[(2)]);
var state_69493__$1 = state_69493;
var statearr_69527_69575 = state_69493__$1;
(statearr_69527_69575[(2)] = inst_69438);

(statearr_69527_69575[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (35))){
var inst_69483 = (state_69493[(2)]);
var state_69493__$1 = state_69493;
var statearr_69528_69576 = state_69493__$1;
(statearr_69528_69576[(2)] = inst_69483);

(statearr_69528_69576[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (19))){
var inst_69422 = typeof keep_alive_fn === 'string';
var state_69493__$1 = state_69493;
if(cljs.core.truth_(inst_69422)){
var statearr_69529_69577 = state_69493__$1;
(statearr_69529_69577[(1)] = (21));

} else {
var statearr_69530_69578 = state_69493__$1;
(statearr_69530_69578[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (11))){
var inst_69401 = fluree.db.connection.reconnect_conn(conn);
var state_69493__$1 = state_69493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69493__$1,(14),inst_69401);
} else {
if((state_val_69494 === (9))){
var inst_69383 = (state_69493[(7)]);
var inst_69450 = fluree.db.connection.ping_transactor(req_chan);
var inst_69451 = (inst_69383 + (1));
var inst_69383__$1 = inst_69451;
var state_69493__$1 = (function (){var statearr_69531 = state_69493;
(statearr_69531[(16)] = inst_69450);

(statearr_69531[(7)] = inst_69383__$1);

return statearr_69531;
})();
var statearr_69532_69579 = state_69493__$1;
(statearr_69532_69579[(2)] = null);

(statearr_69532_69579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (5))){
var inst_69383 = (state_69493[(7)]);
var inst_69398 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_69383);
var state_69493__$1 = state_69493;
if(inst_69398){
var statearr_69533_69580 = state_69493__$1;
(statearr_69533_69580[(1)] = (8));

} else {
var statearr_69534_69581 = state_69493__$1;
(statearr_69534_69581[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (14))){
var inst_69403 = (state_69493[(2)]);
var inst_69383 = (0);
var state_69493__$1 = (function (){var statearr_69535 = state_69493;
(statearr_69535[(17)] = inst_69403);

(statearr_69535[(7)] = inst_69383);

return statearr_69535;
})();
var statearr_69536_69582 = state_69493__$1;
(statearr_69536_69582[(2)] = null);

(statearr_69536_69582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (26))){
var inst_69436 = (state_69493[(2)]);
var state_69493__$1 = state_69493;
var statearr_69537_69583 = state_69493__$1;
(statearr_69537_69583[(2)] = inst_69436);

(statearr_69537_69583[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (16))){
var inst_69418 = cljs.core.fn_QMARK_(keep_alive_fn);
var state_69493__$1 = state_69493;
if(inst_69418){
var statearr_69538_69584 = state_69493__$1;
(statearr_69538_69584[(1)] = (18));

} else {
var statearr_69539_69585 = state_69493__$1;
(statearr_69539_69585[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (30))){
var inst_69394 = (state_69493[(9)]);
var inst_69465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69466 = [inst_69394];
var inst_69467 = (new cljs.core.PersistentVector(null,1,(5),inst_69465,inst_69466,null));
var inst_69468 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69467);
var inst_69383 = (0);
var state_69493__$1 = (function (){var statearr_69540 = state_69493;
(statearr_69540[(18)] = inst_69468);

(statearr_69540[(7)] = inst_69383);

return statearr_69540;
})();
var statearr_69541_69586 = state_69493__$1;
(statearr_69541_69586[(2)] = null);

(statearr_69541_69586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (10))){
var inst_69454 = (state_69493[(2)]);
var state_69493__$1 = state_69493;
var statearr_69542_69587 = state_69493__$1;
(statearr_69542_69587[(2)] = inst_69454);

(statearr_69542_69587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (18))){
var inst_69420 = (keep_alive_fn.cljs$core$IFn$_invoke$arity$0 ? keep_alive_fn.cljs$core$IFn$_invoke$arity$0() : keep_alive_fn.call(null));
var state_69493__$1 = state_69493;
var statearr_69543_69588 = state_69493__$1;
(statearr_69543_69588[(2)] = inst_69420);

(statearr_69543_69588[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69494 === (8))){
var state_69493__$1 = state_69493;
if(cljs.core.truth_(keep_alive)){
var statearr_69544_69589 = state_69493__$1;
(statearr_69544_69589[(1)] = (11));

} else {
var statearr_69545_69590 = state_69493__$1;
(statearr_69545_69590[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0 = (function (){
var statearr_69546 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69546[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2684__auto__);

(statearr_69546[(1)] = (1));

return statearr_69546;
});
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1 = (function (state_69493){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69493);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69547){var ex__2687__auto__ = e69547;
var statearr_69548_69591 = state_69493;
(statearr_69548_69591[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69493[(4)]))){
var statearr_69549_69592 = state_69493;
(statearr_69549_69592[(1)] = cljs.core.first((state_69493[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69593 = state_69493;
state_69493 = G__69593;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = function(state_69493){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1.call(this,state_69493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69550 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69550[(6)] = c__2706__auto__);

return statearr_69550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__69595 = arguments.length;
switch (G__69595) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__69596 = opts;
var map__69596__$1 = cljs.core.__destructure_map(map__69596);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69596__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69596__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69648){
var state_val_69649 = (state_69648[(1)]);
if((state_val_69649 === (7))){
var inst_69606 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_69607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69608 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_69609 = (new cljs.core.PersistentVector(null,2,(5),inst_69607,inst_69608,null));
var inst_69610 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_69606,inst_69609);
var state_69648__$1 = state_69648;
var statearr_69650_69681 = state_69648__$1;
(statearr_69650_69681[(2)] = inst_69610);

(statearr_69650_69681[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (1))){
var state_69648__$1 = state_69648;
var statearr_69651_69682 = state_69648__$1;
(statearr_69651_69682[(2)] = null);

(statearr_69651_69682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (4))){
var inst_69597 = (state_69648[(2)]);
var state_69648__$1 = state_69648;
var statearr_69652_69683 = state_69648__$1;
(statearr_69652_69683[(2)] = inst_69597);

(statearr_69652_69683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (15))){
var inst_69617 = (state_69648[(7)]);
var inst_69636 = (state_69648[(2)]);
var inst_69637 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_69638 = [(5000),inst_69636,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_69639 = cljs.core.PersistentHashMap.fromArrays(inst_69637,inst_69638);
var inst_69640 = fluree.db.util.xhttp.get(inst_69617,inst_69639);
var state_69648__$1 = state_69648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69648__$1,(16),inst_69640);
} else {
if((state_val_69649 === (13))){
var inst_69617 = (state_69648[(7)]);
var inst_69627 = (state_69648[(8)]);
var inst_69629 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_69630 = [inst_69627];
var inst_69631 = cljs.core.PersistentHashMap.fromArrays(inst_69629,inst_69630);
var inst_69632 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_69617,inst_69631,private$);
var inst_69633 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_69632);
var state_69648__$1 = state_69648;
var statearr_69653_69684 = state_69648__$1;
(statearr_69653_69684[(2)] = inst_69633);

(statearr_69653_69684[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (6))){
var inst_69603 = (state_69648[(9)]);
var state_69648__$1 = state_69648;
var statearr_69654_69685 = state_69648__$1;
(statearr_69654_69685[(2)] = inst_69603);

(statearr_69654_69685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (3))){
var inst_69646 = (state_69648[(2)]);
var state_69648__$1 = state_69648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69648__$1,inst_69646);
} else {
if((state_val_69649 === (12))){
var inst_69627 = (state_69648[(2)]);
var state_69648__$1 = (function (){var statearr_69655 = state_69648;
(statearr_69655[(8)] = inst_69627);

return statearr_69655;
})();
if(cljs.core.truth_(private$)){
var statearr_69656_69686 = state_69648__$1;
(statearr_69656_69686[(1)] = (13));

} else {
var statearr_69657_69687 = state_69648__$1;
(statearr_69657_69687[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (2))){
var inst_69603 = (state_69648[(9)]);
var _ = (function (){var statearr_69658 = state_69648;
(statearr_69658[(4)] = cljs.core.cons((5),(state_69648[(4)])));

return statearr_69658;
})();
var inst_69603__$1 = jwt;
var state_69648__$1 = (function (){var statearr_69659 = state_69648;
(statearr_69659[(9)] = inst_69603__$1);

return statearr_69659;
})();
if(cljs.core.truth_(inst_69603__$1)){
var statearr_69660_69688 = state_69648__$1;
(statearr_69660_69688[(1)] = (6));

} else {
var statearr_69661_69689 = state_69648__$1;
(statearr_69661_69689[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (11))){
var inst_69621 = (state_69648[(10)]);
var state_69648__$1 = state_69648;
var statearr_69663_69690 = state_69648__$1;
(statearr_69663_69690[(2)] = inst_69621);

(statearr_69663_69690[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (9))){
var inst_69613 = (state_69648[(11)]);
var inst_69612 = (state_69648[(12)]);
var inst_69616 = (state_69648[(2)]);
var inst_69617 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69616),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69613)].join('');
var inst_69619 = ["Accept"];
var inst_69620 = ["application/json"];
var inst_69621 = cljs.core.PersistentHashMap.fromArrays(inst_69619,inst_69620);
var state_69648__$1 = (function (){var statearr_69664 = state_69648;
(statearr_69664[(7)] = inst_69617);

(statearr_69664[(10)] = inst_69621);

return statearr_69664;
})();
if(cljs.core.truth_(inst_69612)){
var statearr_69665_69691 = state_69648__$1;
(statearr_69665_69691[(1)] = (10));

} else {
var statearr_69666_69692 = state_69648__$1;
(statearr_69666_69692[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (5))){
var _ = (function (){var statearr_69667 = state_69648;
(statearr_69667[(4)] = cljs.core.rest((state_69648[(4)])));

return statearr_69667;
})();
var state_69648__$1 = state_69648;
var ex69662 = (state_69648__$1[(2)]);
var statearr_69668_69693 = state_69648__$1;
(statearr_69668_69693[(5)] = ex69662);


if((ex69662 instanceof Error)){
var statearr_69669_69694 = state_69648__$1;
(statearr_69669_69694[(1)] = (4));

(statearr_69669_69694[(5)] = null);

} else {
throw ex69662;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (14))){
var inst_69627 = (state_69648[(8)]);
var state_69648__$1 = state_69648;
var statearr_69670_69695 = state_69648__$1;
(statearr_69670_69695[(2)] = inst_69627);

(statearr_69670_69695[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (16))){
var inst_69642 = (state_69648[(2)]);
var inst_69643 = fluree.db.util.async.throw_err(inst_69642);
var _ = (function (){var statearr_69671 = state_69648;
(statearr_69671[(4)] = cljs.core.rest((state_69648[(4)])));

return statearr_69671;
})();
var state_69648__$1 = state_69648;
var statearr_69672_69696 = state_69648__$1;
(statearr_69672_69696[(2)] = inst_69643);

(statearr_69672_69696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (10))){
var inst_69612 = (state_69648[(12)]);
var inst_69621 = (state_69648[(10)]);
var inst_69623 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69612)].join('');
var inst_69624 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_69621,"Authorization",inst_69623);
var state_69648__$1 = state_69648;
var statearr_69673_69697 = state_69648__$1;
(statearr_69673_69697[(2)] = inst_69624);

(statearr_69673_69697[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (8))){
var inst_69612 = (state_69648[(2)]);
var inst_69613 = clojure.string.replace(k,"_","/");
var inst_69614 = fluree.db.connection.get_server(conn_id,servers);
var state_69648__$1 = (function (){var statearr_69674 = state_69648;
(statearr_69674[(11)] = inst_69613);

(statearr_69674[(12)] = inst_69612);

return statearr_69674;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69648__$1,(9),inst_69614);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_69675 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69675[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_69675[(1)] = (1));

return statearr_69675;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_69648){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69648);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69676){var ex__2687__auto__ = e69676;
var statearr_69677_69698 = state_69648;
(statearr_69677_69698[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69648[(4)]))){
var statearr_69678_69699 = state_69648;
(statearr_69678_69699[(1)] = cljs.core.first((state_69648[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69700 = state_69648;
state_69648 = G__69700;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_69648){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_69648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69679 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69679[(6)] = c__2706__auto__);

return statearr_69679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var temp__5802__auto___69725 = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___69725)){
var v_69726 = temp__5802__auto___69725;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,v_69726);
} else {
var c__2706__auto___69727 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69712){
var state_val_69713 = (state_69712[(1)]);
if((state_val_69713 === (1))){
var inst_69701 = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
var state_69712__$1 = state_69712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69712__$1,(2),inst_69701);
} else {
if((state_val_69713 === (2))){
var inst_69703 = (state_69712[(7)]);
var inst_69703__$1 = (state_69712[(2)]);
var inst_69704 = fluree.db.util.core.exception_QMARK_(inst_69703__$1);
var state_69712__$1 = (function (){var statearr_69714 = state_69712;
(statearr_69714[(7)] = inst_69703__$1);

return statearr_69714;
})();
if(inst_69704){
var statearr_69715_69728 = state_69712__$1;
(statearr_69715_69728[(1)] = (3));

} else {
var statearr_69716_69729 = state_69712__$1;
(statearr_69716_69729[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (3))){
var state_69712__$1 = state_69712;
var statearr_69717_69730 = state_69712__$1;
(statearr_69717_69730[(2)] = null);

(statearr_69717_69730[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (4))){
var inst_69703 = (state_69712[(7)]);
var inst_69707 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,inst_69703);
var state_69712__$1 = state_69712;
var statearr_69718_69731 = state_69712__$1;
(statearr_69718_69731[(2)] = inst_69707);

(statearr_69718_69731[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69713 === (5))){
var inst_69703 = (state_69712[(7)]);
var inst_69709 = (state_69712[(2)]);
var inst_69710 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,inst_69703);
var state_69712__$1 = (function (){var statearr_69719 = state_69712;
(statearr_69719[(8)] = inst_69709);

return statearr_69719;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_69712__$1,inst_69710);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_69720 = [null,null,null,null,null,null,null,null,null];
(statearr_69720[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__);

(statearr_69720[(1)] = (1));

return statearr_69720;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1 = (function (state_69712){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69712);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69721){var ex__2687__auto__ = e69721;
var statearr_69722_69732 = state_69712;
(statearr_69722_69732[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69712[(4)]))){
var statearr_69723_69733 = state_69712;
(statearr_69723_69733[(1)] = cljs.core.first((state_69712[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69734 = state_69712;
state_69712 = G__69734;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__ = function(state_69712){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1.call(this,state_69712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69724 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69724[(6)] = c__2706__auto___69727);

return statearr_69724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__69735_SHARP_){
if(cljs.core.truth_(p1__69735_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__69736_SHARP_){
var or__5045__auto__ = p1__69736_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e69737){var e = e69737;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__69738 = opts;
var map__69738__$1 = cljs.core.__destructure_map(map__69738);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69738__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69738__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69738__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69738__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69738__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69738__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69738__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69738__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69738__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69738__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69738__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__69739_69740 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__69739_69740.cljs$core$IFn$_invoke$arity$0 ? fexpr__69739_69740.cljs$core$IFn$_invoke$arity$0() : fexpr__69739_69740.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69784 = arguments.length;
var i__5770__auto___69785 = (0);
while(true){
if((i__5770__auto___69785 < len__5769__auto___69784)){
args__5775__auto__.push((arguments[i__5770__auto___69785]));

var G__69786 = (i__5770__auto___69785 + (1));
i__5770__auto___69785 = G__69786;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__69743){
var vec__69744 = p__69743;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69744,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2706__auto___69787 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69767){
var state_val_69768 = (state_69767[(1)]);
if((state_val_69768 === (1))){
var inst_69747 = fluree.db.connection.get_socket(conn);
var state_69767__$1 = state_69767;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69767__$1,(2),inst_69747);
} else {
if((state_val_69768 === (2))){
var inst_69750 = (state_69767[(7)]);
var inst_69749 = (state_69767[(8)]);
var inst_69749__$1 = (state_69767[(2)]);
var inst_69750__$1 = (inst_69749__$1 == null);
var state_69767__$1 = (function (){var statearr_69769 = state_69767;
(statearr_69769[(7)] = inst_69750__$1);

(statearr_69769[(8)] = inst_69749__$1);

return statearr_69769;
})();
if(cljs.core.truth_(inst_69750__$1)){
var statearr_69770_69788 = state_69767__$1;
(statearr_69770_69788[(1)] = (3));

} else {
var statearr_69771_69789 = state_69767__$1;
(statearr_69771_69789[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69768 === (3))){
var inst_69750 = (state_69767[(7)]);
var state_69767__$1 = state_69767;
var statearr_69772_69790 = state_69767__$1;
(statearr_69772_69790[(2)] = inst_69750);

(statearr_69772_69790[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69768 === (4))){
var inst_69749 = (state_69767[(8)]);
var inst_69753 = fluree.db.util.core.exception_QMARK_(inst_69749);
var state_69767__$1 = state_69767;
var statearr_69773_69791 = state_69767__$1;
(statearr_69773_69791[(2)] = inst_69753);

(statearr_69773_69791[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69768 === (5))){
var inst_69755 = (state_69767[(2)]);
var state_69767__$1 = state_69767;
if(cljs.core.truth_(inst_69755)){
var statearr_69774_69792 = state_69767__$1;
(statearr_69774_69792[(1)] = (6));

} else {
var statearr_69775_69793 = state_69767__$1;
(statearr_69775_69793[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69768 === (6))){
var inst_69749 = (state_69767[(8)]);
var inst_69757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69758 = [inst_69749,"Cannot establish connection to a healthy server, disconnecting."];
var inst_69759 = (new cljs.core.PersistentVector(null,2,(5),inst_69757,inst_69758,null));
var inst_69760 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69759);
var inst_69761 = cljs.core.async.close_BANG_(conn);
var state_69767__$1 = (function (){var statearr_69776 = state_69767;
(statearr_69776[(9)] = inst_69760);

return statearr_69776;
})();
var statearr_69777_69794 = state_69767__$1;
(statearr_69777_69794[(2)] = inst_69761);

(statearr_69777_69794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69768 === (7))){
var inst_69763 = fluree.db.connection.msg_consumer(conn);
var state_69767__$1 = state_69767;
var statearr_69778_69795 = state_69767__$1;
(statearr_69778_69795[(2)] = inst_69763);

(statearr_69778_69795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69768 === (8))){
var inst_69765 = (state_69767[(2)]);
var state_69767__$1 = state_69767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69767__$1,inst_69765);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_69779 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69779[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_69779[(1)] = (1));

return statearr_69779;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_69767){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69767);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69780){var ex__2687__auto__ = e69780;
var statearr_69781_69796 = state_69767;
(statearr_69781_69796[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69767[(4)]))){
var statearr_69782_69797 = state_69767;
(statearr_69782_69797[(1)] = cljs.core.first((state_69767[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69798 = state_69767;
state_69767 = G__69798;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_69767){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_69767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69783 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69783[(6)] = c__2706__auto___69787);

return statearr_69783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq69741){
var G__69742 = cljs.core.first(seq69741);
var seq69741__$1 = cljs.core.next(seq69741);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69742,seq69741__$1);
}));

