// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__69809 = arguments.length;
switch (G__69809) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69854){
var state_val_69855 = (state_69854[(1)]);
if((state_val_69855 === (7))){
var inst_69824 = typeof user === 'string';
var state_69854__$1 = state_69854;
if(cljs.core.truth_(inst_69824)){
var statearr_69856_69885 = state_69854__$1;
(statearr_69856_69885[(1)] = (9));

} else {
var statearr_69857_69886 = state_69854__$1;
(statearr_69857_69886[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (1))){
var state_69854__$1 = state_69854;
var statearr_69858_69887 = state_69854__$1;
(statearr_69858_69887[(2)] = null);

(statearr_69858_69887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (4))){
var inst_69810 = (state_69854[(2)]);
var inst_69811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69812 = [inst_69810];
var inst_69813 = (new cljs.core.PersistentVector(null,1,(5),inst_69811,inst_69812,null));
var inst_69814 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69813);
var inst_69815 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69810) : reject.call(null,inst_69810));
var state_69854__$1 = (function (){var statearr_69859 = state_69854;
(statearr_69859[(7)] = inst_69814);

return statearr_69859;
})();
var statearr_69860_69888 = state_69854__$1;
(statearr_69860_69888[(2)] = inst_69815);

(statearr_69860_69888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (15))){
var inst_69843 = (state_69854[(2)]);
var inst_69844 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_69843);
var inst_69845 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69846 = cljs.core.constantly(inst_69844);
var inst_69847 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69845,inst_69846);
var inst_69848 = fluree.db.connection.add_token(conn,inst_69844);
var inst_69849 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_69843) : resolve.call(null,inst_69843));
var _ = (function (){var statearr_69861 = state_69854;
(statearr_69861[(4)] = cljs.core.rest((state_69854[(4)])));

return statearr_69861;
})();
var state_69854__$1 = (function (){var statearr_69862 = state_69854;
(statearr_69862[(8)] = inst_69847);

(statearr_69862[(9)] = inst_69848);

return statearr_69862;
})();
var statearr_69863_69889 = state_69854__$1;
(statearr_69863_69889[(2)] = inst_69849);

(statearr_69863_69889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (13))){
var state_69854__$1 = state_69854;
var statearr_69864_69890 = state_69854__$1;
(statearr_69864_69890[(2)] = null);

(statearr_69864_69890[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (6))){
var state_69854__$1 = state_69854;
var statearr_69865_69891 = state_69854__$1;
(statearr_69865_69891[(2)] = user);

(statearr_69865_69891[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (3))){
var inst_69852 = (state_69854[(2)]);
var state_69854__$1 = state_69854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69854__$1,inst_69852);
} else {
if((state_val_69855 === (12))){
var state_69854__$1 = state_69854;
var statearr_69866_69892 = state_69854__$1;
(statearr_69866_69892[(2)] = user);

(statearr_69866_69892[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (2))){
var _ = (function (){var statearr_69867 = state_69854;
(statearr_69867[(4)] = cljs.core.cons((5),(state_69854[(4)])));

return statearr_69867;
})();
var inst_69821 = typeof user === 'number';
var state_69854__$1 = state_69854;
if(cljs.core.truth_(inst_69821)){
var statearr_69868_69893 = state_69854__$1;
(statearr_69868_69893[(1)] = (6));

} else {
var statearr_69869_69894 = state_69854__$1;
(statearr_69869_69894[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (11))){
var inst_69835 = (state_69854[(2)]);
var state_69854__$1 = state_69854;
var statearr_69871_69895 = state_69854__$1;
(statearr_69871_69895[(2)] = inst_69835);

(statearr_69871_69895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (9))){
var inst_69826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69827 = ["_user/username",user];
var inst_69828 = (new cljs.core.PersistentVector(null,2,(5),inst_69826,inst_69827,null));
var state_69854__$1 = state_69854;
var statearr_69872_69896 = state_69854__$1;
(statearr_69872_69896[(2)] = inst_69828);

(statearr_69872_69896[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (5))){
var _ = (function (){var statearr_69873 = state_69854;
(statearr_69873[(4)] = cljs.core.rest((state_69854[(4)])));

return statearr_69873;
})();
var state_69854__$1 = state_69854;
var ex69870 = (state_69854__$1[(2)]);
var statearr_69874_69897 = state_69854__$1;
(statearr_69874_69897[(5)] = ex69870);


var statearr_69875_69898 = state_69854__$1;
(statearr_69875_69898[(1)] = (4));

(statearr_69875_69898[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (14))){
var inst_69833 = (state_69854[(2)]);
var state_69854__$1 = state_69854;
var statearr_69876_69899 = state_69854__$1;
(statearr_69876_69899[(2)] = inst_69833);

(statearr_69876_69899[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (10))){
var state_69854__$1 = state_69854;
var statearr_69877_69900 = state_69854__$1;
(statearr_69877_69900[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69855 === (8))){
var inst_69837 = (state_69854[(2)]);
var inst_69838 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_69839 = [account,inst_69837,password,expireSeconds,syncTo];
var inst_69840 = cljs.core.PersistentHashMap.fromArrays(inst_69838,inst_69839);
var inst_69841 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_69840);
var state_69854__$1 = state_69854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69854__$1,(15),inst_69841);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69879 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69879[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69879[(1)] = (1));

return statearr_69879;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69854){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69854);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69880){var ex__2687__auto__ = e69880;
var statearr_69881_69901 = state_69854;
(statearr_69881_69901[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69854[(4)]))){
var statearr_69882_69902 = state_69854;
(statearr_69882_69902[(1)] = cljs.core.first((state_69854[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69903 = state_69854;
state_69854 = G__69903;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69854){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69883 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69883[(6)] = c__2706__auto__);

return statearr_69883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__69905 = arguments.length;
switch (G__69905) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69914){
var state_val_69915 = (state_69914[(1)]);
if((state_val_69915 === (1))){
var inst_69906 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69908 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_69909 = (new cljs.core.PersistentVector(null,4,(5),inst_69907,inst_69908,null));
var inst_69910 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69906,inst_69909);
var inst_69911 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__69916 = cljs.core.seq(cljs.core.keys(x));
var chunk__69917 = null;
var count__69918 = (0);
var i__69919 = (0);
while(true){
if((i__69919 < count__69918)){
var k = chunk__69917.cljs$core$IIndexed$_nth$arity$2(null,i__69919);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__69927 = seq__69916;
var G__69928 = chunk__69917;
var G__69929 = count__69918;
var G__69930 = (i__69919 + (1));
seq__69916 = G__69927;
chunk__69917 = G__69928;
count__69918 = G__69929;
i__69919 = G__69930;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__69916);
if(temp__5804__auto__){
var seq__69916__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__69916__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__69916__$1);
var G__69931 = cljs.core.chunk_rest(seq__69916__$1);
var G__69932 = c__5568__auto__;
var G__69933 = cljs.core.count(c__5568__auto__);
var G__69934 = (0);
seq__69916 = G__69931;
chunk__69917 = G__69932;
count__69918 = G__69933;
i__69919 = G__69934;
continue;
} else {
var k = cljs.core.first(seq__69916__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__69935 = cljs.core.next(seq__69916__$1);
var G__69936 = null;
var G__69937 = (0);
var G__69938 = (0);
seq__69916 = G__69935;
chunk__69917 = G__69936;
count__69918 = G__69937;
i__69919 = G__69938;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_69912 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69911);
var state_69914__$1 = (function (){var statearr_69920 = state_69914;
(statearr_69920[(7)] = inst_69910);

return statearr_69920;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_69914__$1,inst_69912);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69921 = [null,null,null,null,null,null,null,null];
(statearr_69921[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69921[(1)] = (1));

return statearr_69921;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69914){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69914);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69922){var ex__2687__auto__ = e69922;
var statearr_69923_69939 = state_69914;
(statearr_69923_69939[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69914[(4)]))){
var statearr_69924_69940 = state_69914;
(statearr_69924_69940[(1)] = cljs.core.first((state_69914[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69941 = state_69914;
state_69914 = G__69941;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69914){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69925 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69925[(6)] = c__2706__auto__);

return statearr_69925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__69943 = arguments.length;
switch (G__69943) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69980){
var state_val_69981 = (state_69980[(1)]);
if((state_val_69981 === (1))){
var state_69980__$1 = state_69980;
var statearr_69982_70003 = state_69980__$1;
(statearr_69982_70003[(2)] = null);

(statearr_69982_70003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69981 === (2))){
var _ = (function (){var statearr_69983 = state_69980;
(statearr_69983[(4)] = cljs.core.cons((5),(state_69980[(4)])));

return statearr_69983;
})();
var inst_69955 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_69956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69957 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_69958 = (new cljs.core.PersistentVector(null,1,(5),inst_69956,inst_69957,null));
var inst_69959 = cljs.core.PersistentHashMap.EMPTY;
var inst_69960 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_69959);
var inst_69961 = cljs.core.assoc_in(inst_69955,inst_69958,inst_69960);
var inst_69962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69963 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_69964 = (new cljs.core.PersistentVector(null,1,(5),inst_69962,inst_69963,null));
var inst_69965 = cljs.core.PersistentHashMap.EMPTY;
var inst_69966 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_69965);
var inst_69967 = cljs.core.assoc_in(inst_69961,inst_69964,inst_69966);
var inst_69968 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_69969 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_69967);
var inst_69970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69971 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_69968,null];
var inst_69972 = (new cljs.core.PersistentVector(null,4,(5),inst_69970,inst_69971,null));
var inst_69973 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69969,inst_69972);
var inst_69974 = (function (){var conn = inst_69967;
var pc = inst_69968;
return (function (x){
if((x == null)){
} else {
var seq__69984_70004 = cljs.core.seq(cljs.core.keys(x));
var chunk__69985_70005 = null;
var count__69986_70006 = (0);
var i__69987_70007 = (0);
while(true){
if((i__69987_70007 < count__69986_70006)){
var k_70008 = chunk__69985_70005.cljs$core$IIndexed$_nth$arity$2(null,i__69987_70007);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_70008], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_70008,null));


var G__70009 = seq__69984_70004;
var G__70010 = chunk__69985_70005;
var G__70011 = count__69986_70006;
var G__70012 = (i__69987_70007 + (1));
seq__69984_70004 = G__70009;
chunk__69985_70005 = G__70010;
count__69986_70006 = G__70011;
i__69987_70007 = G__70012;
continue;
} else {
var temp__5804__auto___70013 = cljs.core.seq(seq__69984_70004);
if(temp__5804__auto___70013){
var seq__69984_70014__$1 = temp__5804__auto___70013;
if(cljs.core.chunked_seq_QMARK_(seq__69984_70014__$1)){
var c__5568__auto___70015 = cljs.core.chunk_first(seq__69984_70014__$1);
var G__70016 = cljs.core.chunk_rest(seq__69984_70014__$1);
var G__70017 = c__5568__auto___70015;
var G__70018 = cljs.core.count(c__5568__auto___70015);
var G__70019 = (0);
seq__69984_70004 = G__70016;
chunk__69985_70005 = G__70017;
count__69986_70006 = G__70018;
i__69987_70007 = G__70019;
continue;
} else {
var k_70020 = cljs.core.first(seq__69984_70014__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_70020], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_70020,null));


var G__70021 = cljs.core.next(seq__69984_70014__$1);
var G__70022 = null;
var G__70023 = (0);
var G__70024 = (0);
seq__69984_70004 = G__70021;
chunk__69985_70005 = G__70022;
count__69986_70006 = G__70023;
i__69987_70007 = G__70024;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_69975 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69968,inst_69974);
var ___$1 = (function (){var statearr_69988 = state_69980;
(statearr_69988[(4)] = cljs.core.rest((state_69980[(4)])));

return statearr_69988;
})();
var state_69980__$1 = (function (){var statearr_69989 = state_69980;
(statearr_69989[(7)] = inst_69973);

return statearr_69989;
})();
var statearr_69990_70025 = state_69980__$1;
(statearr_69990_70025[(2)] = inst_69975);

(statearr_69990_70025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69981 === (3))){
var inst_69978 = (state_69980[(2)]);
var state_69980__$1 = state_69980;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69980__$1,inst_69978);
} else {
if((state_val_69981 === (4))){
var inst_69944 = (state_69980[(2)]);
var inst_69945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69946 = [inst_69944];
var inst_69947 = (new cljs.core.PersistentVector(null,1,(5),inst_69945,inst_69946,null));
var inst_69948 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69947);
var inst_69949 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69944) : reject.call(null,inst_69944));
var state_69980__$1 = (function (){var statearr_69992 = state_69980;
(statearr_69992[(8)] = inst_69948);

return statearr_69992;
})();
var statearr_69993_70026 = state_69980__$1;
(statearr_69993_70026[(2)] = inst_69949);

(statearr_69993_70026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69981 === (5))){
var _ = (function (){var statearr_69994 = state_69980;
(statearr_69994[(4)] = cljs.core.rest((state_69980[(4)])));

return statearr_69994;
})();
var state_69980__$1 = state_69980;
var ex69991 = (state_69980__$1[(2)]);
var statearr_69995_70027 = state_69980__$1;
(statearr_69995_70027[(5)] = ex69991);


var statearr_69996_70028 = state_69980__$1;
(statearr_69996_70028[(1)] = (4));

(statearr_69996_70028[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69997 = [null,null,null,null,null,null,null,null,null];
(statearr_69997[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69997[(1)] = (1));

return statearr_69997;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69980){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69980);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69998){var ex__2687__auto__ = e69998;
var statearr_69999_70029 = state_69980;
(statearr_69999_70029[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69980[(4)]))){
var statearr_70000_70030 = state_69980;
(statearr_70000_70030[(1)] = cljs.core.first((state_69980[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70031 = state_69980;
state_69980 = G__70031;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69980){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70001 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70001[(6)] = c__2706__auto__);

return statearr_70001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__70033 = arguments.length;
switch (G__70033) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__70035 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70035,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70035,(1),null);
var cb_STAR_ = (function (header,data){
var G__70038 = cljs.core.clj__GT_js(header);
var G__70039 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__70038,G__70039) : callback.call(null,G__70038,G__70039));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__70040 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70040,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70040,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70093){
var state_val_70094 = (state_70093[(1)]);
if((state_val_70094 === (7))){
var inst_70054 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70055 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_70056 = cljs.core.PersistentHashMap.fromArrays(inst_70054,inst_70055);
var inst_70057 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_70056);
var inst_70058 = (function(){throw inst_70057})();
var state_70093__$1 = state_70093;
var statearr_70095_70127 = state_70093__$1;
(statearr_70095_70127[(2)] = inst_70058);

(statearr_70095_70127[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (1))){
var state_70093__$1 = state_70093;
var statearr_70096_70128 = state_70093__$1;
(statearr_70096_70128[(2)] = null);

(statearr_70096_70128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (4))){
var inst_70043 = (state_70093[(2)]);
var inst_70044 = cljs.core.clj__GT_js(inst_70043);
var inst_70045 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_70044) : reject.call(null,inst_70044));
var state_70093__$1 = state_70093;
var statearr_70097_70129 = state_70093__$1;
(statearr_70097_70129[(2)] = inst_70045);

(statearr_70097_70129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (13))){
var inst_70072 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70073 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_70074 = cljs.core.PersistentHashMap.fromArrays(inst_70072,inst_70073);
var inst_70075 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_70074);
var inst_70076 = (function(){throw inst_70075})();
var state_70093__$1 = state_70093;
var statearr_70098_70130 = state_70093__$1;
(statearr_70098_70130[(2)] = inst_70076);

(statearr_70098_70130[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (6))){
var state_70093__$1 = state_70093;
var statearr_70099_70131 = state_70093__$1;
(statearr_70099_70131[(2)] = null);

(statearr_70099_70131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (3))){
var inst_70091 = (state_70093[(2)]);
var state_70093__$1 = state_70093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70093__$1,inst_70091);
} else {
if((state_val_70094 === (12))){
var state_70093__$1 = state_70093;
var statearr_70100_70132 = state_70093__$1;
(statearr_70100_70132[(2)] = null);

(statearr_70100_70132[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (2))){
var _ = (function (){var statearr_70101 = state_70093;
(statearr_70101[(4)] = cljs.core.cons((5),(state_70093[(4)])));

return statearr_70101;
})();
var inst_70051 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_70093__$1 = state_70093;
if(cljs.core.truth_(inst_70051)){
var statearr_70102_70133 = state_70093__$1;
(statearr_70102_70133[(1)] = (6));

} else {
var statearr_70103_70134 = state_70093__$1;
(statearr_70103_70134[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (11))){
var inst_70069 = (state_70093[(2)]);
var state_70093__$1 = (function (){var statearr_70105 = state_70093;
(statearr_70105[(7)] = inst_70069);

return statearr_70105;
})();
if(cljs.core.truth_(password)){
var statearr_70106_70135 = state_70093__$1;
(statearr_70106_70135[(1)] = (12));

} else {
var statearr_70107_70136 = state_70093__$1;
(statearr_70107_70136[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (9))){
var state_70093__$1 = state_70093;
var statearr_70108_70137 = state_70093__$1;
(statearr_70108_70137[(2)] = null);

(statearr_70108_70137[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (5))){
var _ = (function (){var statearr_70109 = state_70093;
(statearr_70109[(4)] = cljs.core.rest((state_70093[(4)])));

return statearr_70109;
})();
var state_70093__$1 = state_70093;
var ex70104 = (state_70093__$1[(2)]);
var statearr_70110_70138 = state_70093__$1;
(statearr_70110_70138[(5)] = ex70104);


var statearr_70111_70139 = state_70093__$1;
(statearr_70111_70139[(1)] = (4));

(statearr_70111_70139[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (14))){
var inst_70078 = (state_70093[(2)]);
var inst_70079 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_70080 = fluree.db.util.core.without_nils(inst_70079);
var inst_70081 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_70082 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_70083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70084 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_70080,inst_70081,null];
var inst_70085 = (new cljs.core.PersistentVector(null,4,(5),inst_70083,inst_70084,null));
var inst_70086 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_70082,inst_70085);
var inst_70087 = (function (){var _ = inst_70078;
var data = inst_70080;
var pc = inst_70081;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__70112 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__70112) : reject.call(null,G__70112));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__70113 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__70113) : reject.call(null,G__70113));
} else {
var G__70114 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__70114) : resolve.call(null,G__70114));

}
}
});
})();
var inst_70088 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_70081,inst_70087);
var _ = (function (){var statearr_70115 = state_70093;
(statearr_70115[(4)] = cljs.core.rest((state_70093[(4)])));

return statearr_70115;
})();
var state_70093__$1 = (function (){var statearr_70116 = state_70093;
(statearr_70116[(8)] = inst_70086);

return statearr_70116;
})();
var statearr_70117_70140 = state_70093__$1;
(statearr_70117_70140[(2)] = inst_70088);

(statearr_70117_70140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (10))){
var inst_70063 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70064 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_70065 = cljs.core.PersistentHashMap.fromArrays(inst_70063,inst_70064);
var inst_70066 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_70065);
var inst_70067 = (function(){throw inst_70066})();
var state_70093__$1 = state_70093;
var statearr_70118_70141 = state_70093__$1;
(statearr_70118_70141[(2)] = inst_70067);

(statearr_70118_70141[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70094 === (8))){
var inst_70060 = (state_70093[(2)]);
var state_70093__$1 = (function (){var statearr_70119 = state_70093;
(statearr_70119[(9)] = inst_70060);

return statearr_70119;
})();
if(cljs.core.truth_(ledger)){
var statearr_70120_70142 = state_70093__$1;
(statearr_70120_70142[(1)] = (9));

} else {
var statearr_70121_70143 = state_70093__$1;
(statearr_70121_70143[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0 = (function (){
var statearr_70122 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70122[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2684__auto__);

(statearr_70122[(1)] = (1));

return statearr_70122;
});
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1 = (function (state_70093){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70093);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70123){var ex__2687__auto__ = e70123;
var statearr_70124_70144 = state_70093;
(statearr_70124_70144[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70093[(4)]))){
var statearr_70125_70145 = state_70093;
(statearr_70125_70145[(1)] = cljs.core.first((state_70093[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70146 = state_70093;
state_70093 = G__70146;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = function(state_70093){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1.call(this,state_70093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70126 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70126[(6)] = c__2706__auto__);

return statearr_70126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__70148 = arguments.length;
switch (G__70148) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70215){
var state_val_70216 = (state_70215[(1)]);
if((state_val_70216 === (7))){
var inst_70160 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70161 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_70162 = cljs.core.PersistentHashMap.fromArrays(inst_70160,inst_70161);
var inst_70163 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_70162);
var inst_70164 = (function(){throw inst_70163})();
var state_70215__$1 = state_70215;
var statearr_70217_70259 = state_70215__$1;
(statearr_70217_70259[(2)] = inst_70164);

(statearr_70217_70259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (20))){
var inst_70198 = (state_70215[(2)]);
var inst_70199 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_70200 = [ledger,password,user,auth,expire];
var inst_70201 = cljs.core.PersistentHashMap.fromArrays(inst_70199,inst_70200);
var inst_70202 = fluree.db.util.core.without_nils(inst_70201);
var inst_70203 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_70204 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_70205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70206 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_70202,inst_70203,null];
var inst_70207 = (new cljs.core.PersistentVector(null,4,(5),inst_70205,inst_70206,null));
var inst_70208 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_70204,inst_70207);
var inst_70209 = (function (){var _ = inst_70198;
var data = inst_70202;
var pc = inst_70203;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__70218 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__70218) : reject.call(null,G__70218));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__70219 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__70219) : reject.call(null,G__70219));
} else {
fluree.db.connection.add_token(conn,result);

var G__70220 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__70220) : resolve.call(null,G__70220));

}
}
});
})();
var inst_70210 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_70203,inst_70209);
var _ = (function (){var statearr_70221 = state_70215;
(statearr_70221[(4)] = cljs.core.rest((state_70215[(4)])));

return statearr_70221;
})();
var state_70215__$1 = (function (){var statearr_70222 = state_70215;
(statearr_70222[(7)] = inst_70208);

return statearr_70222;
})();
var statearr_70223_70260 = state_70215__$1;
(statearr_70223_70260[(2)] = inst_70210);

(statearr_70223_70260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (1))){
var state_70215__$1 = state_70215;
var statearr_70224_70261 = state_70215__$1;
(statearr_70224_70261[(2)] = null);

(statearr_70224_70261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (4))){
var inst_70149 = (state_70215[(2)]);
var inst_70150 = cljs.core.clj__GT_js(inst_70149);
var inst_70151 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_70150) : reject.call(null,inst_70150));
var state_70215__$1 = state_70215;
var statearr_70225_70262 = state_70215__$1;
(statearr_70225_70262[(2)] = inst_70151);

(statearr_70225_70262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (15))){
var inst_70185 = (state_70215[(8)]);
var state_70215__$1 = state_70215;
var statearr_70226_70263 = state_70215__$1;
(statearr_70226_70263[(2)] = inst_70185);

(statearr_70226_70263[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (13))){
var inst_70178 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70179 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_70180 = cljs.core.PersistentHashMap.fromArrays(inst_70178,inst_70179);
var inst_70181 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_70180);
var inst_70182 = (function(){throw inst_70181})();
var state_70215__$1 = state_70215;
var statearr_70227_70264 = state_70215__$1;
(statearr_70227_70264[(2)] = inst_70182);

(statearr_70227_70264[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (6))){
var state_70215__$1 = state_70215;
var statearr_70228_70265 = state_70215__$1;
(statearr_70228_70265[(2)] = null);

(statearr_70228_70265[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (17))){
var inst_70189 = (state_70215[(2)]);
var state_70215__$1 = state_70215;
if(cljs.core.truth_(inst_70189)){
var statearr_70229_70266 = state_70215__$1;
(statearr_70229_70266[(1)] = (18));

} else {
var statearr_70230_70267 = state_70215__$1;
(statearr_70230_70267[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (3))){
var inst_70213 = (state_70215[(2)]);
var state_70215__$1 = state_70215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70215__$1,inst_70213);
} else {
if((state_val_70216 === (12))){
var state_70215__$1 = state_70215;
var statearr_70231_70268 = state_70215__$1;
(statearr_70231_70268[(2)] = null);

(statearr_70231_70268[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (2))){
var _ = (function (){var statearr_70232 = state_70215;
(statearr_70232[(4)] = cljs.core.cons((5),(state_70215[(4)])));

return statearr_70232;
})();
var inst_70157 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_70215__$1 = state_70215;
if(cljs.core.truth_(inst_70157)){
var statearr_70233_70269 = state_70215__$1;
(statearr_70233_70269[(1)] = (6));

} else {
var statearr_70234_70270 = state_70215__$1;
(statearr_70234_70270[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (19))){
var inst_70192 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70193 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_70194 = cljs.core.PersistentHashMap.fromArrays(inst_70192,inst_70193);
var inst_70195 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_70194);
var inst_70196 = (function(){throw inst_70195})();
var state_70215__$1 = state_70215;
var statearr_70235_70271 = state_70215__$1;
(statearr_70235_70271[(2)] = inst_70196);

(statearr_70235_70271[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (11))){
var inst_70175 = (state_70215[(2)]);
var state_70215__$1 = (function (){var statearr_70237 = state_70215;
(statearr_70237[(9)] = inst_70175);

return statearr_70237;
})();
if(cljs.core.truth_(password)){
var statearr_70238_70272 = state_70215__$1;
(statearr_70238_70272[(1)] = (12));

} else {
var statearr_70239_70273 = state_70215__$1;
(statearr_70239_70273[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (9))){
var state_70215__$1 = state_70215;
var statearr_70240_70274 = state_70215__$1;
(statearr_70240_70274[(2)] = null);

(statearr_70240_70274[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (5))){
var _ = (function (){var statearr_70241 = state_70215;
(statearr_70241[(4)] = cljs.core.rest((state_70215[(4)])));

return statearr_70241;
})();
var state_70215__$1 = state_70215;
var ex70236 = (state_70215__$1[(2)]);
var statearr_70242_70275 = state_70215__$1;
(statearr_70242_70275[(5)] = ex70236);


var statearr_70243_70276 = state_70215__$1;
(statearr_70243_70276[(1)] = (4));

(statearr_70243_70276[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (14))){
var inst_70185 = (state_70215[(8)]);
var inst_70184 = (state_70215[(2)]);
var inst_70185__$1 = user;
var state_70215__$1 = (function (){var statearr_70244 = state_70215;
(statearr_70244[(10)] = inst_70184);

(statearr_70244[(8)] = inst_70185__$1);

return statearr_70244;
})();
if(cljs.core.truth_(inst_70185__$1)){
var statearr_70245_70277 = state_70215__$1;
(statearr_70245_70277[(1)] = (15));

} else {
var statearr_70246_70278 = state_70215__$1;
(statearr_70246_70278[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (16))){
var state_70215__$1 = state_70215;
var statearr_70247_70279 = state_70215__$1;
(statearr_70247_70279[(2)] = auth);

(statearr_70247_70279[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (10))){
var inst_70169 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70170 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_70171 = cljs.core.PersistentHashMap.fromArrays(inst_70169,inst_70170);
var inst_70172 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_70171);
var inst_70173 = (function(){throw inst_70172})();
var state_70215__$1 = state_70215;
var statearr_70248_70280 = state_70215__$1;
(statearr_70248_70280[(2)] = inst_70173);

(statearr_70248_70280[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (18))){
var state_70215__$1 = state_70215;
var statearr_70249_70281 = state_70215__$1;
(statearr_70249_70281[(2)] = null);

(statearr_70249_70281[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70216 === (8))){
var inst_70166 = (state_70215[(2)]);
var state_70215__$1 = (function (){var statearr_70250 = state_70215;
(statearr_70250[(11)] = inst_70166);

return statearr_70250;
})();
if(cljs.core.truth_(ledger)){
var statearr_70251_70282 = state_70215__$1;
(statearr_70251_70282[(1)] = (9));

} else {
var statearr_70252_70283 = state_70215__$1;
(statearr_70252_70283[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_70253 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70253[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_70253[(1)] = (1));

return statearr_70253;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_70215){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70215);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70254){var ex__2687__auto__ = e70254;
var statearr_70255_70284 = state_70215;
(statearr_70255_70284[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70215[(4)]))){
var statearr_70256_70285 = state_70215;
(statearr_70256_70285[(1)] = cljs.core.first((state_70215[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70286 = state_70215;
state_70215 = G__70286;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_70215){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_70215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70257 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70257[(6)] = c__2706__auto__);

return statearr_70257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__70288 = arguments.length;
switch (G__70288) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70323){
var state_val_70324 = (state_70323[(1)]);
if((state_val_70324 === (1))){
var state_70323__$1 = state_70323;
var statearr_70325_70347 = state_70323__$1;
(statearr_70325_70347[(2)] = null);

(statearr_70325_70347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70324 === (2))){
var _ = (function (){var statearr_70326 = state_70323;
(statearr_70326[(4)] = cljs.core.cons((5),(state_70323[(4)])));

return statearr_70326;
})();
var inst_70297 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_70323__$1 = state_70323;
if(cljs.core.truth_(inst_70297)){
var statearr_70327_70348 = state_70323__$1;
(statearr_70327_70348[(1)] = (6));

} else {
var statearr_70328_70349 = state_70323__$1;
(statearr_70328_70349[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70324 === (3))){
var inst_70321 = (state_70323[(2)]);
var state_70323__$1 = state_70323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70323__$1,inst_70321);
} else {
if((state_val_70324 === (4))){
var inst_70289 = (state_70323[(2)]);
var inst_70290 = cljs.core.clj__GT_js(inst_70289);
var inst_70291 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_70290) : reject.call(null,inst_70290));
var state_70323__$1 = state_70323;
var statearr_70330_70350 = state_70323__$1;
(statearr_70330_70350[(2)] = inst_70291);

(statearr_70330_70350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70324 === (5))){
var _ = (function (){var statearr_70331 = state_70323;
(statearr_70331[(4)] = cljs.core.rest((state_70323[(4)])));

return statearr_70331;
})();
var state_70323__$1 = state_70323;
var ex70329 = (state_70323__$1[(2)]);
var statearr_70332_70351 = state_70323__$1;
(statearr_70332_70351[(5)] = ex70329);


var statearr_70333_70352 = state_70323__$1;
(statearr_70333_70352[(1)] = (4));

(statearr_70333_70352[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70324 === (6))){
var state_70323__$1 = state_70323;
var statearr_70334_70353 = state_70323__$1;
(statearr_70334_70353[(2)] = null);

(statearr_70334_70353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70324 === (7))){
var inst_70300 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70301 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_70302 = cljs.core.PersistentHashMap.fromArrays(inst_70300,inst_70301);
var inst_70303 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_70302);
var inst_70304 = (function(){throw inst_70303})();
var state_70323__$1 = state_70323;
var statearr_70335_70354 = state_70323__$1;
(statearr_70335_70354[(2)] = inst_70304);

(statearr_70335_70354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70324 === (8))){
var inst_70306 = (state_70323[(2)]);
var inst_70307 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_70308 = [jwt,expire];
var inst_70309 = cljs.core.PersistentHashMap.fromArrays(inst_70307,inst_70308);
var inst_70310 = fluree.db.util.core.without_nils(inst_70309);
var inst_70311 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_70312 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_70313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70314 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_70310,inst_70311,null];
var inst_70315 = (new cljs.core.PersistentVector(null,4,(5),inst_70313,inst_70314,null));
var inst_70316 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_70312,inst_70315);
var inst_70317 = (function (){var _ = inst_70306;
var data = inst_70310;
var pc = inst_70311;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__70336 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__70336) : reject.call(null,G__70336));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__70337 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__70337) : resolve.call(null,G__70337));

}
});
})();
var inst_70318 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_70311,inst_70317);
var _ = (function (){var statearr_70338 = state_70323;
(statearr_70338[(4)] = cljs.core.rest((state_70323[(4)])));

return statearr_70338;
})();
var state_70323__$1 = (function (){var statearr_70339 = state_70323;
(statearr_70339[(7)] = inst_70316);

return statearr_70339;
})();
var statearr_70340_70355 = state_70323__$1;
(statearr_70340_70355[(2)] = inst_70318);

(statearr_70340_70355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_70341 = [null,null,null,null,null,null,null,null];
(statearr_70341[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_70341[(1)] = (1));

return statearr_70341;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_70323){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70323);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70342){var ex__2687__auto__ = e70342;
var statearr_70343_70356 = state_70323;
(statearr_70343_70356[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70323[(4)]))){
var statearr_70344_70357 = state_70323;
(statearr_70344_70357[(1)] = cljs.core.first((state_70323[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70358 = state_70323;
state_70323 = G__70358;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_70323){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_70323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70345 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70345[(6)] = c__2706__auto__);

return statearr_70345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

