// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('sci.core');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns true if the arg is a string containing a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(v){
var and__5043__auto__ = typeof v === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,v);
} else {
return and__5043__auto__;
}
});
fluree.db.dbfunctions.core.allowed_symbols = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),null,new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),null,new cljs.core.Symbol(null,"sid","sid",-839419355,null),null,new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),null,new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),null,new cljs.core.Symbol(null,"?a","?a",1314302913,null),null,new cljs.core.Symbol(null,"?db","?db",1493359450,null),null,new cljs.core.Symbol(null,"?s","?s",456183954,null),null,new cljs.core.Symbol(null,"?o","?o",-1814741084,null),null], null), null);
/**
 * Copies local fns ns public vars into SCI
 */
fluree.db.dbfunctions.core.load_local_fns_ns = (function fluree$db$dbfunctions$core$load_local_fns_ns(){
var ns_public_vars = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.fromArray([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("uuid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.uuid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,828,null,828,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("max-pred-val"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.max_pred_val;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,571,null,571,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("contains?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.contains_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,395,null,395,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("subs"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.subs;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,158,null,158,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("ctx"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.ctx;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","ctx","fluree.db.dbfunctions.fns/ctx",570947084,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,386,null,386,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null)),"Returns a value from the user's context if set. Provide the key or key sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.ctx)?fluree.db.dbfunctions.fns.ctx.cljs$lang$test:null),(1)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("query"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.query;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"query","query",352022017,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,529,null,529,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("first"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.first;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","first","fluree.db.dbfunctions.fns/first",1553832886,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"first","first",996428481,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,84,null,84,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns the first item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.first)?fluree.db.dbfunctions.fns.first.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("flakes"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.flakes;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,800,null,800,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("boolean"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.boolean$;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,709,null,709,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("dec"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.dec;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,595,null,595,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("<"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._LT_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<","<",993667236,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,451,null,451,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("floor"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.floor;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,850,null,850,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?o"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_o;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,326,null,326,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?sid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_sid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,194,null,194,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("objF"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.objF;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,788,null,788,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("ceil"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.ceil;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,838,null,838,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("<="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._LT__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,464,null,464,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("*"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._STAR_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"*","*",345799209,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,644,null,644,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("min"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.min;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"min","min",2085523049,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,516,null,516,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("get"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get","get",-971253014,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,295,null,295,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?pO"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_pO;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,338,null,338,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("empty?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.empty_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,134,null,134,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("quot"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.quot;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,670,null,670,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("now"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.now;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"now","now",-9994004,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,608,null,608,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("not="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.not_EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,490,null,490,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("if-else"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.if_else;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,98,null,98,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("rand"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.rand;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,812,null,812,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(">"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._GT_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">",">",1085014381,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,438,null,438,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("mod"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.mod;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,683,null,683,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("lower-case"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.lower_case;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,170,null,170,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("-"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"-","-",-471816912,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,631,null,631,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("hash-set"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.hash_set;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,409,null,409,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("or"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.or;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"or","or",1876275696,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,268,null,268,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("valid-email?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.valid_email_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,734,null,734,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?s"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_s;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,226,null,226,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("rem"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.rem;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("nth"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.nth;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,69,null,69,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("nil?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.nil_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("cas"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.cas;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,862,null,862,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("re-find"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.re_find;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,721,null,721,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("not"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.not;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not","not",1044554643,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("/"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._SLASH_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,657,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(">="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._GT__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,477,null,477,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("upper-case"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.upper_case;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,182,null,182,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("inc"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.inc;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,583,null,583,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("+"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._PLUS_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"+","+",-740910886,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,618,null,618,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("str"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.str;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,146,null,146,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("objT"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.objT;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,776,null,776,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("max"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.max;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max","max",1701898075,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,503,null,503,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("=="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._EQ__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,425,null,425,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("count"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.count;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"count","count",-514511684,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,281,null,281,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("get-all"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get_all;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,351,null,351,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path + query costs"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?p"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_p;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,239,null,239,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?auth_id"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_auth_id;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,764,null,764,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("extract"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.extract;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",18,1,14,true,14,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),"Resolves a value if a channel.\n  Must be used inside of a go-block.",(cljs.core.truth_(fluree.db.dbfunctions.fns.extract)?fluree.db.dbfunctions.fns.extract.cljs$lang$test:null)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?user_id"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_user_id;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,746,null,746,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("relationship?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.relationship_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,556,null,556,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("and"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.and;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"and","and",668631710,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,255,null,255,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?pid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_pid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,213,null,213,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("get-in"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get_in;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"/Users/wmorgan/dev/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,372,null,372,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))], null)], true));
var _ = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Loading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(ns_public_vars))," local fns"].join('')], null));
var sci_ns = sci.core.create_ns.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ns_map,p__64291){
var vec__64292 = p__64291;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64292,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64292,(1),null);
var m = cljs.core.meta(var$);
var no_doc = new cljs.core.Keyword(null,"no-doc","no-doc",1559921891).cljs$core$IFn$_invoke$arity$1(m);
var doc = new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m);
var arglists = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(no_doc)){
return ns_map;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ns_map,var_name,sci.core.new_var.cljs$core$IFn$_invoke$arity$3(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var_name),cljs.core.deref(var$),(function (){var G__64295 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ns","ns",441598760),sci_ns,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m)], null);
var G__64295__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__64295,new cljs.core.Keyword(null,"macro","macro",-867863404),true):G__64295);
var G__64295__$2 = (cljs.core.truth_(doc)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__64295__$1,new cljs.core.Keyword(null,"doc","doc",1913296891),doc):G__64295__$1);
if(cljs.core.truth_(arglists)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__64295__$2,new cljs.core.Keyword(null,"arglists","arglists",1661989754),arglists);
} else {
return G__64295__$2;
}
})()));
}
}),cljs.core.PersistentArrayMap.EMPTY,ns_public_vars);
});
fluree.db.dbfunctions.core.sci_ctx = (new cljs.core.Delay((function (){
var cfg = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),fluree.db.dbfunctions.core.load_local_fns_ns()], null)], null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI config:",cfg], null));

return sci.core.init(cfg);
}),null));
fluree.db.dbfunctions.core.parse_string = (function fluree$db$dbfunctions$core$parse_string(s){
return sci.core.parse_string(cljs.core.deref(fluree.db.dbfunctions.core.sci_ctx),s);
});
fluree.db.dbfunctions.core.eval_string = (function fluree$db$dbfunctions$core$eval_string(s){
return sci.core.eval_string_STAR_(cljs.core.deref(fluree.db.dbfunctions.core.sci_ctx),s);
});
fluree.db.dbfunctions.core.eval_form = (function fluree$db$dbfunctions$core$eval_form(f){
return sci.core.eval_form(cljs.core.deref(fluree.db.dbfunctions.core.sci_ctx),f);
});
/**
 * Given a collection of function strings, returns a combined function using
 *   the and function.
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
/**
 * Tries to resolve a local pre-defined fn with fn-name. Returns a fn-map if
 *   found, nil otherwise.
 */
fluree.db.dbfunctions.core.find_local_fn = (function fluree$db$dbfunctions$core$find_local_fn(fn_name){
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Looking for local fn:",fn_name], null));

var local_fns_ns = new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null);
var sci_vars = fluree.db.dbfunctions.core.eval_string(["(ns-publics '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(local_fns_ns),")"].join(''));
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI vars:",sci_vars], null));

if(cljs.core.truth_((function (){var G__64298 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name);
var fexpr__64297 = cljs.core.set(cljs.core.keys(sci_vars));
return (fexpr__64297.cljs$core$IFn$_invoke$arity$1 ? fexpr__64297.cljs$core$IFn$_invoke$arity$1(G__64298) : fexpr__64297.call(null,G__64298));
})())){
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Found local fn:",fn_name], null));

var fn_var = cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(local_fns_ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_name));
var map__64299 = fluree.db.dbfunctions.core.eval_string(["(meta #'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_var),")"].join(''));
var map__64299__$1 = cljs.core.__destructure_map(map__64299);
var sci_fn_meta = map__64299__$1;
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64299__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64299__$1,new cljs.core.Keyword("fdb","spec","fdb/spec",346638389));
if(cljs.core.truth_(sci_fn_meta)){
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI fn metadata:",sci_fn_meta], null));

var first_arglist = cljs.core.first(arglists);
var args_set = cljs.core.set(first_arglist);
var var_args_QMARK_ = cljs.core.boolean$((function (){var G__64300 = new cljs.core.Symbol(null,"&","&",-2144855648,null);
return (args_set.cljs$core$IFn$_invoke$arity$1 ? args_set.cljs$core$IFn$_invoke$arity$1(G__64300) : args_set.call(null,G__64300));
})());
var arity = ((var_args_QMARK_)?null:cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__64296_SHARP_){
return (cljs.core.count(p1__64296_SHARP_) - (1));
}),arglists)));
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"f","f",-1597136552),fn_var,new cljs.core.Keyword(null,"params","params",710516235),arglists,new cljs.core.Keyword(null,"arity","arity",-1808556135),arity,new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710),var_args_QMARK_,new cljs.core.Keyword(null,"spec","spec",347520401),spec], null);
} else {
return null;
}
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_db_fn = (function fluree$db$dbfunctions$core$find_db_fn(var_args){
var G__64302 = arguments.length;
switch (G__64302) {
case 2:
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,fn_type){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64393){
var state_val_64394 = (state_64393[(1)]);
if((state_val_64394 === (7))){
var inst_64329 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_64330 = ["Unknown function: ",inst_64329].join('');
var inst_64331 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64332 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_64333 = cljs.core.PersistentHashMap.fromArrays(inst_64331,inst_64332);
var inst_64334 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64330,inst_64333);
var inst_64335 = (function(){throw inst_64334})();
var state_64393__$1 = state_64393;
var statearr_64395_64428 = state_64393__$1;
(statearr_64395_64428[(2)] = inst_64335);

(statearr_64395_64428[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (1))){
var state_64393__$1 = state_64393;
var statearr_64396_64429 = state_64393__$1;
(statearr_64396_64429[(2)] = null);

(statearr_64396_64429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (4))){
var inst_64303 = (state_64393[(2)]);
var state_64393__$1 = state_64393;
var statearr_64397_64430 = state_64393__$1;
(statearr_64397_64430[(2)] = inst_64303);

(statearr_64397_64430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (15))){
var inst_64355 = (state_64393[(7)]);
var inst_64326 = (state_64393[(8)]);
var inst_64355__$1 = (state_64393[(2)]);
var inst_64356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64357 = ["Parsed params:",inst_64355__$1];
var inst_64358 = (new cljs.core.PersistentVector(null,2,(5),inst_64356,inst_64357,null));
var inst_64359 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64358);
var inst_64360 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64326,"_fn/code");
var inst_64361 = fluree.db.dbfunctions.core.parse_string(inst_64360);
var inst_64362 = (fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,inst_64361,fn_type,inst_64355__$1) : fluree.db.dbfunctions.core.validate_form.call(null,db,inst_64361,fn_type,inst_64355__$1));
var state_64393__$1 = (function (){var statearr_64398 = state_64393;
(statearr_64398[(9)] = inst_64359);

(statearr_64398[(7)] = inst_64355__$1);

return statearr_64398;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64393__$1,(16),inst_64362);
} else {
if((state_val_64394 === (13))){
var state_64393__$1 = state_64393;
var statearr_64399_64431 = state_64393__$1;
(statearr_64399_64431[(2)] = null);

(statearr_64399_64431[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (6))){
var inst_64326 = (state_64393[(8)]);
var inst_64325 = (state_64393[(2)]);
var inst_64326__$1 = fluree.db.util.async.throw_err(inst_64325);
var inst_64327 = cljs.core.empty_QMARK_(inst_64326__$1);
var state_64393__$1 = (function (){var statearr_64400 = state_64393;
(statearr_64400[(8)] = inst_64326__$1);

return statearr_64400;
})();
if(inst_64327){
var statearr_64401_64432 = state_64393__$1;
(statearr_64401_64432[(1)] = (7));

} else {
var statearr_64402_64433 = state_64393__$1;
(statearr_64402_64433[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (3))){
var inst_64391 = (state_64393[(2)]);
var state_64393__$1 = state_64393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64393__$1,inst_64391);
} else {
if((state_val_64394 === (12))){
var inst_64349 = (state_64393[(10)]);
var inst_64349__$1 = (state_64393[(2)]);
var inst_64350 = (inst_64349__$1 == null);
var state_64393__$1 = (function (){var statearr_64403 = state_64393;
(statearr_64403[(10)] = inst_64349__$1);

return statearr_64403;
})();
if(cljs.core.truth_(inst_64350)){
var statearr_64404_64434 = state_64393__$1;
(statearr_64404_64434[(1)] = (13));

} else {
var statearr_64405_64435 = state_64393__$1;
(statearr_64405_64435[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (2))){
var _ = (function (){var statearr_64406 = state_64393;
(statearr_64406[(4)] = cljs.core.cons((5),(state_64393[(4)])));

return statearr_64406;
})();
var inst_64309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64310 = ["Looking for custom db fn:",fn_name];
var inst_64311 = (new cljs.core.PersistentVector(null,2,(5),inst_64309,inst_64310,null));
var inst_64312 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64311);
var inst_64313 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_64314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64315 = ["_fn/params","_fn/code","_fn/spec"];
var inst_64316 = (new cljs.core.PersistentVector(null,3,(5),inst_64314,inst_64315,null));
var inst_64317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64318 = cljs.core.name(fn_name);
var inst_64319 = ["_fn/name",inst_64318];
var inst_64320 = (new cljs.core.PersistentVector(null,2,(5),inst_64317,inst_64319,null));
var inst_64321 = [inst_64316,inst_64320];
var inst_64322 = cljs.core.PersistentHashMap.fromArrays(inst_64313,inst_64321);
var inst_64323 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_64322);
var state_64393__$1 = (function (){var statearr_64407 = state_64393;
(statearr_64407[(11)] = inst_64312);

return statearr_64407;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64393__$1,(6),inst_64323);
} else {
if((state_val_64394 === (11))){
var inst_64326 = (state_64393[(8)]);
var inst_64347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64326,"_fn/params");
var state_64393__$1 = state_64393;
var statearr_64409_64436 = state_64393__$1;
(statearr_64409_64436[(2)] = inst_64347);

(statearr_64409_64436[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (9))){
var inst_64326 = (state_64393[(8)]);
var inst_64338 = (state_64393[(2)]);
var inst_64339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64340 = ["Custom db fn query results:",inst_64326];
var inst_64341 = (new cljs.core.PersistentVector(null,2,(5),inst_64339,inst_64340,null));
var inst_64342 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64341);
var inst_64344 = (inst_64326 == null);
var state_64393__$1 = (function (){var statearr_64410 = state_64393;
(statearr_64410[(12)] = inst_64342);

(statearr_64410[(13)] = inst_64338);

return statearr_64410;
})();
if(cljs.core.truth_(inst_64344)){
var statearr_64411_64437 = state_64393__$1;
(statearr_64411_64437[(1)] = (10));

} else {
var statearr_64412_64438 = state_64393__$1;
(statearr_64412_64438[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (5))){
var _ = (function (){var statearr_64413 = state_64393;
(statearr_64413[(4)] = cljs.core.rest((state_64393[(4)])));

return statearr_64413;
})();
var state_64393__$1 = state_64393;
var ex64408 = (state_64393__$1[(2)]);
var statearr_64414_64439 = state_64393__$1;
(statearr_64414_64439[(5)] = ex64408);


if((ex64408 instanceof Error)){
var statearr_64415_64440 = state_64393__$1;
(statearr_64415_64440[(1)] = (4));

(statearr_64415_64440[(5)] = null);

} else {
throw ex64408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (14))){
var inst_64349 = (state_64393[(10)]);
var inst_64353 = fluree.db.dbfunctions.core.parse_string(inst_64349);
var state_64393__$1 = state_64393;
var statearr_64416_64441 = state_64393__$1;
(statearr_64416_64441[(2)] = inst_64353);

(statearr_64416_64441[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (16))){
var inst_64355 = (state_64393[(7)]);
var inst_64326 = (state_64393[(8)]);
var inst_64364 = (state_64393[(2)]);
var inst_64365 = fluree.db.util.async.throw_err(inst_64364);
var inst_64366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64367 = ["Validated code:",inst_64365];
var inst_64368 = (new cljs.core.PersistentVector(null,2,(5),inst_64366,inst_64367,null));
var inst_64369 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64368);
var inst_64370 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64326,"_fn/spec");
var inst_64371 = cljs.core.PersistentVector.EMPTY;
var inst_64372 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_64373 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,inst_64355);
var inst_64374 = cljs.core.cons(inst_64372,inst_64373);
var inst_64375 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_64371,inst_64374);
var inst_64376 = ["(fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64375)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64365),")"].join('');
var inst_64377 = fluree.db.dbfunctions.core.parse_string(inst_64376);
var inst_64378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64379 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64377], 0));
var inst_64380 = ["Found custom db fn:",inst_64379];
var inst_64381 = (new cljs.core.PersistentVector(null,2,(5),inst_64378,inst_64380,null));
var inst_64382 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64381);
var inst_64383 = [new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"arity","arity",-1808556135),new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"code","code",1586293142)];
var inst_64384 = cljs.core.count(inst_64355);
var inst_64385 = [inst_64384];
var inst_64386 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_64385);
var inst_64387 = [inst_64377,inst_64355,inst_64386,false,inst_64370,null];
var inst_64388 = cljs.core.PersistentHashMap.fromArrays(inst_64383,inst_64387);
var _ = (function (){var statearr_64417 = state_64393;
(statearr_64417[(4)] = cljs.core.rest((state_64393[(4)])));

return statearr_64417;
})();
var state_64393__$1 = (function (){var statearr_64418 = state_64393;
(statearr_64418[(14)] = inst_64382);

(statearr_64418[(15)] = inst_64369);

return statearr_64418;
})();
var statearr_64419_64442 = state_64393__$1;
(statearr_64419_64442[(2)] = inst_64388);

(statearr_64419_64442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (10))){
var state_64393__$1 = state_64393;
var statearr_64420_64443 = state_64393__$1;
(statearr_64420_64443[(2)] = null);

(statearr_64420_64443[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64394 === (8))){
var state_64393__$1 = state_64393;
var statearr_64421_64444 = state_64393__$1;
(statearr_64421_64444[(2)] = null);

(statearr_64421_64444[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2684__auto____0 = (function (){
var statearr_64422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64422[(0)] = fluree$db$dbfunctions$core$state_machine__2684__auto__);

(statearr_64422[(1)] = (1));

return statearr_64422;
});
var fluree$db$dbfunctions$core$state_machine__2684__auto____1 = (function (state_64393){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64393);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64423){var ex__2687__auto__ = e64423;
var statearr_64424_64445 = state_64393;
(statearr_64424_64445[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64393[(4)]))){
var statearr_64425_64446 = state_64393;
(statearr_64425_64446[(1)] = cljs.core.first((state_64393[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64447 = state_64393;
state_64393 = G__64447;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2684__auto__ = function(state_64393){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2684__auto____1.call(this,state_64393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2684__auto____0;
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64426 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64426[(6)] = c__2706__auto__);

return statearr_64426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.core.find_db_fn.cljs$lang$maxFixedArity = 3);

/**
 * Is the symbol sym valid with the given form type & params?
 */
fluree.db.dbfunctions.core.valid_symbol_QMARK_ = (function fluree$db$dbfunctions$core$valid_symbol_QMARK_(type,params,sym){
var or__5045__auto__ = (fluree.db.dbfunctions.core.allowed_symbols.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.allowed_symbols.cljs$core$IFn$_invoke$arity$1(sym) : fluree.db.dbfunctions.core.allowed_symbols.call(null,sym));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = (function (){var fexpr__64448 = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,params));
return (fexpr__64448.cljs$core$IFn$_invoke$arity$1 ? fexpr__64448.cljs$core$IFn$_invoke$arity$1(sym) : fexpr__64448.call(null,sym));
})();
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
}
}
});
/**
 * Resolves local or custom db-stored fn from fn-name string
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(db,fn_name,type){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64468){
var state_val_64469 = (state_64468[(1)]);
if((state_val_64469 === (7))){
var inst_64458 = fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,type);
var state_64468__$1 = state_64468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64468__$1,(9),inst_64458);
} else {
if((state_val_64469 === (1))){
var state_64468__$1 = state_64468;
var statearr_64470_64489 = state_64468__$1;
(statearr_64470_64489[(2)] = null);

(statearr_64470_64489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (4))){
var inst_64449 = (state_64468[(2)]);
var state_64468__$1 = state_64468;
var statearr_64471_64490 = state_64468__$1;
(statearr_64471_64490[(2)] = inst_64449);

(statearr_64471_64490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (6))){
var inst_64455 = (state_64468[(7)]);
var state_64468__$1 = state_64468;
var statearr_64472_64491 = state_64468__$1;
(statearr_64472_64491[(2)] = inst_64455);

(statearr_64472_64491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (3))){
var inst_64466 = (state_64468[(2)]);
var state_64468__$1 = state_64468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64468__$1,inst_64466);
} else {
if((state_val_64469 === (2))){
var inst_64455 = (state_64468[(7)]);
var _ = (function (){var statearr_64474 = state_64468;
(statearr_64474[(4)] = cljs.core.cons((5),(state_64468[(4)])));

return statearr_64474;
})();
var inst_64455__$1 = fluree.db.dbfunctions.core.find_local_fn(fn_name);
var state_64468__$1 = (function (){var statearr_64475 = state_64468;
(statearr_64475[(7)] = inst_64455__$1);

return statearr_64475;
})();
if(cljs.core.truth_(inst_64455__$1)){
var statearr_64476_64492 = state_64468__$1;
(statearr_64476_64492[(1)] = (6));

} else {
var statearr_64477_64493 = state_64468__$1;
(statearr_64477_64493[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (9))){
var inst_64460 = (state_64468[(2)]);
var inst_64461 = fluree.db.util.async.throw_err(inst_64460);
var state_64468__$1 = state_64468;
var statearr_64478_64494 = state_64468__$1;
(statearr_64478_64494[(2)] = inst_64461);

(statearr_64478_64494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (5))){
var _ = (function (){var statearr_64479 = state_64468;
(statearr_64479[(4)] = cljs.core.rest((state_64468[(4)])));

return statearr_64479;
})();
var state_64468__$1 = state_64468;
var ex64473 = (state_64468__$1[(2)]);
var statearr_64480_64495 = state_64468__$1;
(statearr_64480_64495[(5)] = ex64473);


if((ex64473 instanceof Error)){
var statearr_64481_64496 = state_64468__$1;
(statearr_64481_64496[(1)] = (4));

(statearr_64481_64496[(5)] = null);

} else {
throw ex64473;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (8))){
var inst_64463 = (state_64468[(2)]);
var _ = (function (){var statearr_64482 = state_64468;
(statearr_64482[(4)] = cljs.core.rest((state_64468[(4)])));

return statearr_64482;
})();
var state_64468__$1 = state_64468;
var statearr_64483_64497 = state_64468__$1;
(statearr_64483_64497[(2)] = inst_64463);

(statearr_64483_64497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_64484 = [null,null,null,null,null,null,null,null];
(statearr_64484[(0)] = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto__);

(statearr_64484[(1)] = (1));

return statearr_64484;
});
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto____1 = (function (state_64468){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64468);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64485){var ex__2687__auto__ = e64485;
var statearr_64486_64498 = state_64468;
(statearr_64486_64498[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64468[(4)]))){
var statearr_64487_64499 = state_64468;
(statearr_64487_64499[(1)] = cljs.core.first((state_64468[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64500 = state_64468;
state_64468 = G__64500;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto__ = function(state_64468){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto____1.call(this,state_64468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64488 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64488[(6)] = c__2706__auto__);

return statearr_64488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.core.validate_form = (function fluree$db$dbfunctions$core$validate_form(var_args){
var G__64503 = arguments.length;
switch (G__64503) {
case 2:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64638){
var state_val_64639 = (state_64638[(1)]);
if((state_val_64639 === (7))){
var state_64638__$1 = state_64638;
var statearr_64640_64704 = state_64638__$1;
(statearr_64640_64704[(2)] = null);

(statearr_64640_64704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (20))){
var inst_64615 = (state_64638[(2)]);
var state_64638__$1 = state_64638;
var statearr_64641_64705 = state_64638__$1;
(statearr_64641_64705[(2)] = inst_64615);

(statearr_64641_64705[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (27))){
var inst_64604 = (state_64638[(2)]);
var state_64638__$1 = state_64638;
var statearr_64642_64706 = state_64638__$1;
(statearr_64642_64706[(2)] = inst_64604);

(statearr_64642_64706[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (1))){
var state_64638__$1 = state_64638;
var statearr_64643_64707 = state_64638__$1;
(statearr_64643_64707[(2)] = null);

(statearr_64643_64707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (24))){
var inst_64574 = (state_64638[(2)]);
var inst_64575 = fluree.db.util.async.throw_err(inst_64574);
var state_64638__$1 = state_64638;
var statearr_64644_64708 = state_64638__$1;
(statearr_64644_64708[(2)] = inst_64575);

(statearr_64644_64708[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (4))){
var inst_64504 = (state_64638[(2)]);
var state_64638__$1 = state_64638;
var statearr_64645_64709 = state_64638__$1;
(statearr_64645_64709[(2)] = inst_64504);

(statearr_64645_64709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (15))){
var inst_64530 = (state_64638[(2)]);
var inst_64531 = fluree.db.util.async.throw_err(inst_64530);
var state_64638__$1 = state_64638;
var statearr_64646_64710 = state_64638__$1;
(statearr_64646_64710[(2)] = inst_64531);

(statearr_64646_64710[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (21))){
var inst_64559 = (state_64638[(7)]);
var inst_64572 = fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,inst_64559,type,params);
var state_64638__$1 = state_64638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64638__$1,(24),inst_64572);
} else {
if((state_val_64639 === (31))){
var inst_64560 = (state_64638[(8)]);
var inst_64607 = (state_64638[(9)]);
var inst_64552 = inst_64560;
var inst_64553 = inst_64607;
var state_64638__$1 = (function (){var statearr_64647 = state_64638;
(statearr_64647[(10)] = inst_64552);

(statearr_64647[(11)] = inst_64553);

return statearr_64647;
})();
var statearr_64648_64711 = state_64638__$1;
(statearr_64648_64711[(2)] = null);

(statearr_64648_64711[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (32))){
var inst_64607 = (state_64638[(9)]);
var state_64638__$1 = state_64638;
var statearr_64649_64712 = state_64638__$1;
(statearr_64649_64712[(2)] = inst_64607);

(statearr_64649_64712[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (33))){
var inst_64613 = (state_64638[(2)]);
var state_64638__$1 = state_64638;
var statearr_64650_64713 = state_64638__$1;
(statearr_64650_64713[(2)] = inst_64613);

(statearr_64650_64713[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (13))){
var state_64638__$1 = state_64638;
var statearr_64651_64714 = state_64638__$1;
(statearr_64651_64714[(2)] = null);

(statearr_64651_64714[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (22))){
var inst_64559 = (state_64638[(7)]);
var inst_64577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64578 = [cljs.core.string_QMARK_,cljs.core.number_QMARK_,cljs.core.true_QMARK_,cljs.core.false_QMARK_,cljs.core.nil_QMARK_];
var inst_64579 = (new cljs.core.PersistentVector(null,5,(5),inst_64577,inst_64578,null));
var inst_64580 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.some_fn,inst_64579);
var inst_64581 = (inst_64580.cljs$core$IFn$_invoke$arity$1 ? inst_64580.cljs$core$IFn$_invoke$arity$1(inst_64559) : inst_64580.call(null,inst_64559));
var state_64638__$1 = state_64638;
if(cljs.core.truth_(inst_64581)){
var statearr_64652_64715 = state_64638__$1;
(statearr_64652_64715[(1)] = (25));

} else {
var statearr_64653_64716 = state_64638__$1;
(statearr_64653_64716[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (36))){
var inst_64633 = (state_64638[(2)]);
var _ = (function (){var statearr_64654 = state_64638;
(statearr_64654[(4)] = cljs.core.rest((state_64638[(4)])));

return statearr_64654;
})();
var state_64638__$1 = state_64638;
var statearr_64655_64717 = state_64638__$1;
(statearr_64655_64717[(2)] = inst_64633);

(statearr_64655_64717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (29))){
var inst_64559 = (state_64638[(7)]);
var inst_64592 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64559], 0));
var inst_64593 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_64559) : type.call(null,inst_64559));
var inst_64594 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_64595 = ["Invalid element (",inst_64592,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64593),") in form: ",inst_64594,"."].join('');
var inst_64596 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64597 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_64598 = cljs.core.PersistentHashMap.fromArrays(inst_64596,inst_64597);
var inst_64599 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64595,inst_64598);
var inst_64600 = (function(){throw inst_64599})();
var state_64638__$1 = state_64638;
var statearr_64656_64718 = state_64638__$1;
(statearr_64656_64718[(2)] = inst_64600);

(statearr_64656_64718[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (6))){
var inst_64517 = cljs.core.first(form);
var state_64638__$1 = state_64638;
var statearr_64657_64719 = state_64638__$1;
(statearr_64657_64719[(2)] = inst_64517);

(statearr_64657_64719[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (28))){
var inst_64559 = (state_64638[(7)]);
var state_64638__$1 = state_64638;
var statearr_64658_64720 = state_64638__$1;
(statearr_64658_64720[(2)] = inst_64559);

(statearr_64658_64720[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (25))){
var inst_64559 = (state_64638[(7)]);
var state_64638__$1 = state_64638;
var statearr_64659_64721 = state_64638__$1;
(statearr_64659_64721[(2)] = inst_64559);

(statearr_64659_64721[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (34))){
var inst_64618 = (state_64638[(12)]);
var inst_64536 = (state_64638[(13)]);
var inst_64620 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_64621 = cljs.core.cons(inst_64620,inst_64618);
var inst_64622 = cljs.core.cons(inst_64536,inst_64621);
var inst_64623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64624 = ["Validated fn form:",inst_64622];
var inst_64625 = (new cljs.core.PersistentVector(null,2,(5),inst_64623,inst_64624,null));
var inst_64626 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64625);
var state_64638__$1 = (function (){var statearr_64660 = state_64638;
(statearr_64660[(14)] = inst_64626);

return statearr_64660;
})();
var statearr_64661_64722 = state_64638__$1;
(statearr_64661_64722[(2)] = inst_64622);

(statearr_64661_64722[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (17))){
var state_64638__$1 = state_64638;
var statearr_64662_64723 = state_64638__$1;
(statearr_64662_64723[(2)] = null);

(statearr_64662_64723[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (3))){
var inst_64636 = (state_64638[(2)]);
var state_64638__$1 = state_64638;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64638__$1,inst_64636);
} else {
if((state_val_64639 === (12))){
var inst_64520 = (state_64638[(15)]);
var inst_64528 = fluree.db.dbfunctions.core.resolve_fn(db,inst_64520,type);
var state_64638__$1 = state_64638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64638__$1,(15),inst_64528);
} else {
if((state_val_64639 === (2))){
var _ = (function (){var statearr_64663 = state_64638;
(statearr_64663[(4)] = cljs.core.cons((5),(state_64638[(4)])));

return statearr_64663;
})();
var inst_64510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64511 = ["Validating form:",form,"- params:",params];
var inst_64512 = (new cljs.core.PersistentVector(null,4,(5),inst_64510,inst_64511,null));
var inst_64513 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64512);
var inst_64515 = cljs.core.list_QMARK_(form);
var state_64638__$1 = (function (){var statearr_64664 = state_64638;
(statearr_64664[(16)] = inst_64513);

return statearr_64664;
})();
if(inst_64515){
var statearr_64665_64724 = state_64638__$1;
(statearr_64665_64724[(1)] = (6));

} else {
var statearr_64666_64725 = state_64638__$1;
(statearr_64666_64725[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (23))){
var inst_64560 = (state_64638[(8)]);
var inst_64553 = (state_64638[(11)]);
var inst_64606 = (state_64638[(2)]);
var inst_64607 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_64553,inst_64606);
var inst_64608 = cljs.core.seq(inst_64560);
var state_64638__$1 = (function (){var statearr_64667 = state_64638;
(statearr_64667[(9)] = inst_64607);

return statearr_64667;
})();
if(inst_64608){
var statearr_64668_64726 = state_64638__$1;
(statearr_64668_64726[(1)] = (31));

} else {
var statearr_64669_64727 = state_64638__$1;
(statearr_64669_64727[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (35))){
var inst_64628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64629 = ["Validated non-fn form:",form];
var inst_64630 = (new cljs.core.PersistentVector(null,2,(5),inst_64628,inst_64629,null));
var inst_64631 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64630);
var state_64638__$1 = (function (){var statearr_64670 = state_64638;
(statearr_64670[(17)] = inst_64631);

return statearr_64670;
})();
var statearr_64671_64728 = state_64638__$1;
(statearr_64671_64728[(2)] = form);

(statearr_64671_64728[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (19))){
var inst_64559 = (state_64638[(7)]);
var inst_64552 = (state_64638[(10)]);
var inst_64558 = cljs.core.seq(inst_64552);
var inst_64559__$1 = cljs.core.first(inst_64558);
var inst_64560 = cljs.core.next(inst_64558);
var inst_64561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64562 = ["Validating arg:",inst_64559__$1];
var inst_64563 = (new cljs.core.PersistentVector(null,2,(5),inst_64561,inst_64562,null));
var inst_64564 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64563);
var inst_64566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64567 = [cljs.core.list_QMARK_,cljs.core.vector_QMARK_];
var inst_64568 = (new cljs.core.PersistentVector(null,2,(5),inst_64566,inst_64567,null));
var inst_64569 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.some_fn,inst_64568);
var inst_64570 = (inst_64569.cljs$core$IFn$_invoke$arity$1 ? inst_64569.cljs$core$IFn$_invoke$arity$1(inst_64559__$1) : inst_64569.call(null,inst_64559__$1));
var state_64638__$1 = (function (){var statearr_64672 = state_64638;
(statearr_64672[(8)] = inst_64560);

(statearr_64672[(7)] = inst_64559__$1);

(statearr_64672[(18)] = inst_64564);

return statearr_64672;
})();
if(cljs.core.truth_(inst_64570)){
var statearr_64673_64729 = state_64638__$1;
(statearr_64673_64729[(1)] = (21));

} else {
var statearr_64674_64730 = state_64638__$1;
(statearr_64674_64730[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (11))){
var inst_64520 = (state_64638[(15)]);
var inst_64525 = (state_64638[(19)]);
var inst_64525__$1 = (state_64638[(2)]);
var inst_64526 = cljs.core.count(inst_64525__$1);
var state_64638__$1 = (function (){var statearr_64676 = state_64638;
(statearr_64676[(19)] = inst_64525__$1);

(statearr_64676[(20)] = inst_64526);

return statearr_64676;
})();
if(cljs.core.truth_(inst_64520)){
var statearr_64677_64731 = state_64638__$1;
(statearr_64677_64731[(1)] = (12));

} else {
var statearr_64678_64732 = state_64638__$1;
(statearr_64678_64732[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (9))){
var inst_64522 = cljs.core.rest(form);
var state_64638__$1 = state_64638;
var statearr_64679_64733 = state_64638__$1;
(statearr_64679_64733[(2)] = inst_64522);

(statearr_64679_64733[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (5))){
var _ = (function (){var statearr_64680 = state_64638;
(statearr_64680[(4)] = cljs.core.rest((state_64638[(4)])));

return statearr_64680;
})();
var state_64638__$1 = state_64638;
var ex64675 = (state_64638__$1[(2)]);
var statearr_64681_64734 = state_64638__$1;
(statearr_64681_64734[(5)] = ex64675);


if((ex64675 instanceof Error)){
var statearr_64682_64735 = state_64638__$1;
(statearr_64682_64735[(1)] = (4));

(statearr_64682_64735[(5)] = null);

} else {
throw ex64675;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (14))){
var inst_64534 = (state_64638[(21)]);
var inst_64525 = (state_64638[(19)]);
var inst_64535 = (state_64638[(22)]);
var inst_64534__$1 = (state_64638[(2)]);
var inst_64535__$1 = cljs.core.__destructure_map(inst_64534__$1);
var inst_64536 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64535__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var inst_64537 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64535__$1,new cljs.core.Keyword(null,"arity","arity",-1808556135));
var inst_64538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64535__$1,new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710));
var inst_64539 = cljs.core.seq(inst_64525);
var state_64638__$1 = (function (){var statearr_64683 = state_64638;
(statearr_64683[(21)] = inst_64534__$1);

(statearr_64683[(23)] = inst_64538);

(statearr_64683[(22)] = inst_64535__$1);

(statearr_64683[(24)] = inst_64537);

(statearr_64683[(13)] = inst_64536);

return statearr_64683;
})();
if(inst_64539){
var statearr_64684_64736 = state_64638__$1;
(statearr_64684_64736[(1)] = (16));

} else {
var statearr_64685_64737 = state_64638__$1;
(statearr_64685_64737[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (26))){
var inst_64560 = (state_64638[(8)]);
var inst_64549 = (state_64638[(25)]);
var inst_64559 = (state_64638[(7)]);
var inst_64534 = (state_64638[(21)]);
var inst_64538 = (state_64638[(23)]);
var inst_64520 = (state_64638[(15)]);
var inst_64525 = (state_64638[(19)]);
var inst_64535 = (state_64638[(22)]);
var inst_64550 = (state_64638[(26)]);
var inst_64526 = (state_64638[(20)]);
var inst_64552 = (state_64638[(10)]);
var inst_64537 = (state_64638[(24)]);
var inst_64553 = (state_64638[(11)]);
var inst_64536 = (state_64638[(13)]);
var inst_64584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64585 = (function (){var map__64514 = inst_64535;
var arity = inst_64537;
var args_n = inst_64526;
var fn_map = inst_64534;
var args = inst_64525;
var r = inst_64560;
var vec__64555 = inst_64552;
var vec__64545 = inst_64525;
var seq__64556 = inst_64560;
var acc = inst_64553;
var var_args_QMARK_ = inst_64538;
var first__64557 = inst_64559;
var fn_name = inst_64520;
var G__64544 = inst_64552;
var expr__64565 = inst_64559;
var first__64547 = inst_64549;
var seq__64546 = inst_64550;
var arg = inst_64559;
var f = inst_64536;
return (function (p1__64501_SHARP_){
var and__5043__auto__ = (p1__64501_SHARP_ instanceof cljs.core.Symbol);
if(and__5043__auto__){
return fluree.db.dbfunctions.core.valid_symbol_QMARK_(type,params,p1__64501_SHARP_);
} else {
return and__5043__auto__;
}
});
})();
var inst_64586 = [inst_64585];
var inst_64587 = (new cljs.core.PersistentVector(null,1,(5),inst_64584,inst_64586,null));
var inst_64588 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.some_fn,inst_64587);
var inst_64589 = (inst_64588.cljs$core$IFn$_invoke$arity$1 ? inst_64588.cljs$core$IFn$_invoke$arity$1(inst_64559) : inst_64588.call(null,inst_64559));
var state_64638__$1 = state_64638;
if(cljs.core.truth_(inst_64589)){
var statearr_64686_64738 = state_64638__$1;
(statearr_64686_64738[(1)] = (28));

} else {
var statearr_64687_64739 = state_64638__$1;
(statearr_64687_64739[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (16))){
var inst_64525 = (state_64638[(19)]);
var inst_64548 = cljs.core.seq(inst_64525);
var inst_64549 = cljs.core.first(inst_64548);
var inst_64550 = cljs.core.next(inst_64548);
var inst_64551 = cljs.core.PersistentVector.EMPTY;
var inst_64552 = inst_64525;
var inst_64553 = inst_64551;
var state_64638__$1 = (function (){var statearr_64688 = state_64638;
(statearr_64688[(25)] = inst_64549);

(statearr_64688[(26)] = inst_64550);

(statearr_64688[(10)] = inst_64552);

(statearr_64688[(11)] = inst_64553);

return statearr_64688;
})();
var statearr_64689_64740 = state_64638__$1;
(statearr_64689_64740[(2)] = null);

(statearr_64689_64740[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (30))){
var inst_64602 = (state_64638[(2)]);
var state_64638__$1 = state_64638;
var statearr_64690_64741 = state_64638__$1;
(statearr_64690_64741[(2)] = inst_64602);

(statearr_64690_64741[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (10))){
var state_64638__$1 = state_64638;
var statearr_64691_64742 = state_64638__$1;
(statearr_64691_64742[(2)] = form);

(statearr_64691_64742[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (18))){
var inst_64520 = (state_64638[(15)]);
var inst_64618 = (state_64638[(2)]);
var state_64638__$1 = (function (){var statearr_64692 = state_64638;
(statearr_64692[(12)] = inst_64618);

return statearr_64692;
})();
if(cljs.core.truth_(inst_64520)){
var statearr_64693_64743 = state_64638__$1;
(statearr_64693_64743[(1)] = (34));

} else {
var statearr_64694_64744 = state_64638__$1;
(statearr_64694_64744[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64639 === (8))){
var inst_64520 = (state_64638[(15)]);
var inst_64520__$1 = (state_64638[(2)]);
var state_64638__$1 = (function (){var statearr_64695 = state_64638;
(statearr_64695[(15)] = inst_64520__$1);

return statearr_64695;
})();
if(cljs.core.truth_(inst_64520__$1)){
var statearr_64696_64745 = state_64638__$1;
(statearr_64696_64745[(1)] = (9));

} else {
var statearr_64697_64746 = state_64638__$1;
(statearr_64697_64746[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2684__auto____0 = (function (){
var statearr_64698 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64698[(0)] = fluree$db$dbfunctions$core$state_machine__2684__auto__);

(statearr_64698[(1)] = (1));

return statearr_64698;
});
var fluree$db$dbfunctions$core$state_machine__2684__auto____1 = (function (state_64638){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64638);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64699){var ex__2687__auto__ = e64699;
var statearr_64700_64747 = state_64638;
(statearr_64700_64747[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64638[(4)]))){
var statearr_64701_64748 = state_64638;
(statearr_64701_64748[(1)] = cljs.core.first((state_64638[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64749 = state_64638;
state_64638 = G__64749;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2684__auto__ = function(state_64638){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2684__auto____1.call(this,state_64638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2684__auto____0;
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64702 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64702[(6)] = c__2706__auto__);

return statearr_64702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.core.validate_form.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(db,fn_str,type,params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64785){
var state_val_64786 = (state_64785[(1)]);
if((state_val_64786 === (7))){
var inst_64756 = ["(fn [_] ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str),")"].join('');
var inst_64757 = fluree.db.dbfunctions.core.parse_string(inst_64756);
var state_64785__$1 = state_64785;
var statearr_64787_64811 = state_64785__$1;
(statearr_64787_64811[(2)] = inst_64757);

(statearr_64787_64811[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64786 === (1))){
var state_64785__$1 = state_64785;
var statearr_64788_64812 = state_64785__$1;
(statearr_64788_64812[(2)] = null);

(statearr_64788_64812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64786 === (4))){
var inst_64750 = (state_64785[(2)]);
var state_64785__$1 = state_64785;
var statearr_64789_64813 = state_64785__$1;
(statearr_64789_64813[(2)] = inst_64750);

(statearr_64789_64813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64786 === (6))){
var inst_64780 = (state_64785[(2)]);
var _ = (function (){var statearr_64790 = state_64785;
(statearr_64790[(4)] = cljs.core.rest((state_64785[(4)])));

return statearr_64790;
})();
var state_64785__$1 = state_64785;
var statearr_64791_64814 = state_64785__$1;
(statearr_64791_64814[(2)] = inst_64780);

(statearr_64791_64814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64786 === (3))){
var inst_64783 = (state_64785[(2)]);
var state_64785__$1 = state_64785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64785__$1,inst_64783);
} else {
if((state_val_64786 === (12))){
var inst_64764 = (state_64785[(2)]);
var inst_64765 = fluree.db.util.async.throw_err(inst_64764);
var inst_64766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64767 = ["Parsed & validated db fn:",inst_64765];
var inst_64768 = (new cljs.core.PersistentVector(null,2,(5),inst_64766,inst_64767,null));
var inst_64769 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64768);
var state_64785__$1 = (function (){var statearr_64792 = state_64785;
(statearr_64792[(7)] = inst_64769);

return statearr_64792;
})();
var statearr_64793_64815 = state_64785__$1;
(statearr_64793_64815[(2)] = inst_64765);

(statearr_64793_64815[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64786 === (2))){
var _ = (function (){var statearr_64794 = state_64785;
(statearr_64794[(4)] = cljs.core.cons((5),(state_64785[(4)])));

return statearr_64794;
})();
var state_64785__$1 = state_64785;
var G__64795_64816 = fn_str;
switch (G__64795_64816) {
case "true":
case "false":
var statearr_64796_64818 = state_64785__$1;
(statearr_64796_64818[(1)] = (7));


break;
default:
var statearr_64797_64819 = state_64785__$1;
(statearr_64797_64819[(1)] = (8));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64786 === (11))){
var inst_64777 = (state_64785[(2)]);
var state_64785__$1 = state_64785;
var statearr_64799_64820 = state_64785__$1;
(statearr_64799_64820[(2)] = inst_64777);

(statearr_64799_64820[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64786 === (9))){
var inst_64761 = fluree.db.dbfunctions.core.parse_string(fn_str);
var inst_64762 = fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,inst_64761,type,params);
var state_64785__$1 = state_64785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64785__$1,(12),inst_64762);
} else {
if((state_val_64786 === (5))){
var _ = (function (){var statearr_64800 = state_64785;
(statearr_64800[(4)] = cljs.core.rest((state_64785[(4)])));

return statearr_64800;
})();
var state_64785__$1 = state_64785;
var ex64798 = (state_64785__$1[(2)]);
var statearr_64801_64821 = state_64785__$1;
(statearr_64801_64821[(5)] = ex64798);


if((ex64798 instanceof Error)){
var statearr_64802_64822 = state_64785__$1;
(statearr_64802_64822[(1)] = (4));

(statearr_64802_64822[(5)] = null);

} else {
throw ex64798;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64786 === (10))){
var inst_64771 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64772 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_64773 = cljs.core.PersistentHashMap.fromArrays(inst_64771,inst_64772);
var inst_64774 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_64773);
var inst_64775 = (function(){throw inst_64774})();
var state_64785__$1 = state_64785;
var statearr_64803_64823 = state_64785__$1;
(statearr_64803_64823[(2)] = inst_64775);

(statearr_64803_64823[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64786 === (8))){
var inst_64759 = cljs.core.re_matches(/^\(.+\)$/,fn_str);
var state_64785__$1 = state_64785;
if(cljs.core.truth_(inst_64759)){
var statearr_64804_64824 = state_64785__$1;
(statearr_64804_64824[(1)] = (9));

} else {
var statearr_64805_64825 = state_64785__$1;
(statearr_64805_64825[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_64806 = [null,null,null,null,null,null,null,null];
(statearr_64806[(0)] = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto__);

(statearr_64806[(1)] = (1));

return statearr_64806;
});
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto____1 = (function (state_64785){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64785);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64807){var ex__2687__auto__ = e64807;
var statearr_64808_64826 = state_64785;
(statearr_64808_64826[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64785[(4)]))){
var statearr_64809_64827 = state_64785;
(statearr_64809_64827[(1)] = cljs.core.first((state_64785[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64828 = state_64785;
state_64785 = G__64828;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto__ = function(state_64785){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto____1.call(this,state_64785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64810 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64810[(6)] = c__2706__auto__);

return statearr_64810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.core.parse_and_wrap_fn = (function fluree$db$dbfunctions$core$parse_and_wrap_fn(var_args){
var G__64830 = arguments.length;
switch (G__64830) {
case 3:
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64873){
var state_val_64874 = (state_64873[(1)]);
if((state_val_64874 === (7))){
var inst_64856 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_64873__$1 = state_64873;
var statearr_64875_64899 = state_64873__$1;
(statearr_64875_64899[(2)] = inst_64856);

(statearr_64875_64899[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64874 === (1))){
var state_64873__$1 = state_64873;
var statearr_64876_64900 = state_64873__$1;
(statearr_64876_64900[(2)] = null);

(statearr_64876_64900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64874 === (4))){
var inst_64831 = (state_64873[(2)]);
var state_64873__$1 = state_64873;
var statearr_64877_64901 = state_64873__$1;
(statearr_64877_64901[(2)] = inst_64831);

(statearr_64877_64901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64874 === (6))){
var inst_64854 = (state_64873[(7)]);
var inst_64839 = (state_64873[(2)]);
var inst_64840 = fluree.db.util.async.throw_err(inst_64839);
var inst_64841 = new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null);
var inst_64842 = (new cljs.core.List(null,inst_64841,null,(1),null));
var inst_64843 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_64844 = (new cljs.core.List(null,inst_64843,null,(1),null));
var inst_64845 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_64844);
var inst_64846 = cljs.core.seq(inst_64845);
var inst_64847 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_64846);
var inst_64848 = cljs.core.vec(inst_64847);
var inst_64849 = (new cljs.core.List(null,inst_64848,null,(1),null));
var inst_64850 = (new cljs.core.List(null,inst_64840,null,(1),null));
var inst_64851 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_64842,inst_64849,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64850], 0));
var inst_64852 = cljs.core.seq(inst_64851);
var inst_64853 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_64852);
var inst_64854__$1 = params;
var state_64873__$1 = (function (){var statearr_64878 = state_64873;
(statearr_64878[(8)] = inst_64853);

(statearr_64878[(7)] = inst_64854__$1);

return statearr_64878;
})();
if(cljs.core.truth_(inst_64854__$1)){
var statearr_64879_64902 = state_64873__$1;
(statearr_64879_64902[(1)] = (7));

} else {
var statearr_64880_64903 = state_64873__$1;
(statearr_64880_64903[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64874 === (3))){
var inst_64871 = (state_64873[(2)]);
var state_64873__$1 = state_64873;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64873__$1,inst_64871);
} else {
if((state_val_64874 === (12))){
var inst_64864 = (state_64873[(2)]);
var inst_64865 = [new cljs.core.Keyword(null,"fnstr","fnstr",2092773532)];
var inst_64866 = [fn_str];
var inst_64867 = cljs.core.PersistentHashMap.fromArrays(inst_64865,inst_64866);
var inst_64868 = cljs.core.with_meta(inst_64864,inst_64867);
var _ = (function (){var statearr_64881 = state_64873;
(statearr_64881[(4)] = cljs.core.rest((state_64873[(4)])));

return statearr_64881;
})();
var state_64873__$1 = state_64873;
var statearr_64882_64904 = state_64873__$1;
(statearr_64882_64904[(2)] = inst_64868);

(statearr_64882_64904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64874 === (2))){
var _ = (function (){var statearr_64883 = state_64873;
(statearr_64883[(4)] = cljs.core.cons((5),(state_64873[(4)])));

return statearr_64883;
})();
var inst_64837 = fluree.db.dbfunctions.core.parse_fn(db,fn_str,type,params);
var state_64873__$1 = state_64873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64873__$1,(6),inst_64837);
} else {
if((state_val_64874 === (11))){
var inst_64853 = (state_64873[(8)]);
var inst_64862 = fluree.db.dbfunctions.core.eval_form(inst_64853);
var state_64873__$1 = state_64873;
var statearr_64885_64905 = state_64873__$1;
(statearr_64885_64905[(2)] = inst_64862);

(statearr_64885_64905[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64874 === (9))){
var inst_64859 = (state_64873[(2)]);
var state_64873__$1 = state_64873;
if(cljs.core.truth_(inst_64859)){
var statearr_64886_64906 = state_64873__$1;
(statearr_64886_64906[(1)] = (10));

} else {
var statearr_64887_64907 = state_64873__$1;
(statearr_64887_64907[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64874 === (5))){
var _ = (function (){var statearr_64888 = state_64873;
(statearr_64888[(4)] = cljs.core.rest((state_64873[(4)])));

return statearr_64888;
})();
var state_64873__$1 = state_64873;
var ex64884 = (state_64873__$1[(2)]);
var statearr_64889_64908 = state_64873__$1;
(statearr_64889_64908[(5)] = ex64884);


if((ex64884 instanceof Error)){
var statearr_64890_64909 = state_64873__$1;
(statearr_64890_64909[(1)] = (4));

(statearr_64890_64909[(5)] = null);

} else {
throw ex64884;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64874 === (10))){
var inst_64853 = (state_64873[(8)]);
var state_64873__$1 = state_64873;
var statearr_64891_64910 = state_64873__$1;
(statearr_64891_64910[(2)] = inst_64853);

(statearr_64891_64910[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64874 === (8))){
var inst_64854 = (state_64873[(7)]);
var state_64873__$1 = state_64873;
var statearr_64892_64911 = state_64873__$1;
(statearr_64892_64911[(2)] = inst_64854);

(statearr_64892_64911[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2684__auto____0 = (function (){
var statearr_64893 = [null,null,null,null,null,null,null,null,null];
(statearr_64893[(0)] = fluree$db$dbfunctions$core$state_machine__2684__auto__);

(statearr_64893[(1)] = (1));

return statearr_64893;
});
var fluree$db$dbfunctions$core$state_machine__2684__auto____1 = (function (state_64873){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64873);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64894){var ex__2687__auto__ = e64894;
var statearr_64895_64912 = state_64873;
(statearr_64895_64912[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64873[(4)]))){
var statearr_64896_64913 = state_64873;
(statearr_64896_64913[(1)] = cljs.core.first((state_64873[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64914 = state_64873;
state_64873 = G__64914;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2684__auto__ = function(state_64873){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2684__auto____1.call(this,state_64873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2684__auto____0;
fluree$db$dbfunctions$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64897 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64897[(6)] = c__2706__auto__);

return statearr_64897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(p__64915){
var map__64916 = p__64915;
var map__64916__$1 = cljs.core.__destructure_map(map__64916);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64916__$1,new cljs.core.Keyword(null,"db","db",993250759));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64916__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var _credits = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64916__$1,new cljs.core.Keyword(null,"_credits","_credits",1245712171));
var s = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64916__$1,new cljs.core.Keyword(null,"s","s",1705939918));
var p = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64916__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64916__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64916__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var block_instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64916__$1,new cljs.core.Keyword(null,"block-instant","block-instant",-641639021));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64950){
var state_val_64951 = (state_64950[(1)]);
if((state_val_64951 === (7))){
var inst_64937 = (state_64950[(7)]);
var state_64950__$1 = state_64950;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64950__$1,(10),inst_64937);
} else {
if((state_val_64951 === (1))){
var state_64950__$1 = state_64950;
var statearr_64952_64972 = state_64950__$1;
(statearr_64952_64972[(2)] = null);

(statearr_64952_64972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64951 === (4))){
var inst_64917 = (state_64950[(2)]);
var state_64950__$1 = state_64950;
var statearr_64953_64973 = state_64950__$1;
(statearr_64953_64973[(2)] = inst_64917);

(statearr_64953_64973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64951 === (6))){
var inst_64926 = (state_64950[(8)]);
var inst_64937 = (state_64950[(7)]);
var inst_64929 = (state_64950[(2)]);
var inst_64930 = fluree.db.util.async.throw_err(inst_64929);
var inst_64931 = (new cljs.core.List(null,inst_64926,null,(1),null));
var inst_64932 = (new cljs.core.List(null,inst_64930,inst_64931,(2),null));
var inst_64933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64934 = ["Evaluating fn call:",inst_64932];
var inst_64935 = (new cljs.core.PersistentVector(null,2,(5),inst_64933,inst_64934,null));
var inst_64936 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64935);
var inst_64937__$1 = fluree.db.dbfunctions.core.eval_form(inst_64932);
var inst_64938 = fluree.db.util.async.channel_QMARK_(inst_64937__$1);
var state_64950__$1 = (function (){var statearr_64954 = state_64950;
(statearr_64954[(7)] = inst_64937__$1);

(statearr_64954[(9)] = inst_64936);

return statearr_64954;
})();
if(inst_64938){
var statearr_64955_64974 = state_64950__$1;
(statearr_64955_64974[(1)] = (7));

} else {
var statearr_64956_64975 = state_64950__$1;
(statearr_64956_64975[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64951 === (3))){
var inst_64948 = (state_64950[(2)]);
var state_64950__$1 = state_64950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64950__$1,inst_64948);
} else {
if((state_val_64951 === (2))){
var _ = (function (){var statearr_64958 = state_64950;
(statearr_64958[(4)] = cljs.core.cons((5),(state_64950[(4)])));

return statearr_64958;
})();
var inst_64923 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_64924 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"state","state",-1988618099)];
var inst_64925 = [db,block_instant,s,p,auth,fuel];
var inst_64926 = cljs.core.PersistentHashMap.fromArrays(inst_64924,inst_64925);
var inst_64927 = fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3(db,inst_64923,"txn");
var state_64950__$1 = (function (){var statearr_64959 = state_64950;
(statearr_64959[(8)] = inst_64926);

return statearr_64959;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64950__$1,(6),inst_64927);
} else {
if((state_val_64951 === (9))){
var inst_64945 = (state_64950[(2)]);
var _ = (function (){var statearr_64960 = state_64950;
(statearr_64960[(4)] = cljs.core.rest((state_64950[(4)])));

return statearr_64960;
})();
var state_64950__$1 = state_64950;
var statearr_64961_64976 = state_64950__$1;
(statearr_64961_64976[(2)] = inst_64945);

(statearr_64961_64976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64951 === (5))){
var _ = (function (){var statearr_64962 = state_64950;
(statearr_64962[(4)] = cljs.core.rest((state_64950[(4)])));

return statearr_64962;
})();
var state_64950__$1 = state_64950;
var ex64957 = (state_64950__$1[(2)]);
var statearr_64963_64977 = state_64950__$1;
(statearr_64963_64977[(5)] = ex64957);


if((ex64957 instanceof Error)){
var statearr_64964_64978 = state_64950__$1;
(statearr_64964_64978[(1)] = (4));

(statearr_64964_64978[(5)] = null);

} else {
throw ex64957;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64951 === (10))){
var inst_64941 = (state_64950[(2)]);
var inst_64942 = fluree.db.util.async.throw_err(inst_64941);
var state_64950__$1 = state_64950;
var statearr_64965_64979 = state_64950__$1;
(statearr_64965_64979[(2)] = inst_64942);

(statearr_64965_64979[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64951 === (8))){
var inst_64937 = (state_64950[(7)]);
var state_64950__$1 = state_64950;
var statearr_64966_64980 = state_64950__$1;
(statearr_64966_64980[(2)] = inst_64937);

(statearr_64966_64980[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_64967 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64967[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__);

(statearr_64967[(1)] = (1));

return statearr_64967;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____1 = (function (state_64950){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64950);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64968){var ex__2687__auto__ = e64968;
var statearr_64969_64981 = state_64950;
(statearr_64969_64981[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64950[(4)]))){
var statearr_64970_64982 = state_64950;
(statearr_64970_64982[(1)] = cljs.core.first((state_64950[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64983 = state_64950;
state_64950 = G__64983;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__ = function(state_64950){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____1.call(this,state_64950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64971 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64971[(6)] = c__2706__auto__);

return statearr_64971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
