// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28284 = arguments.length;
var i__5770__auto___28285 = (0);
while(true){
if((i__5770__auto___28285 < len__5769__auto___28284)){
args__5775__auto__.push((arguments[i__5770__auto___28285]));

var G__28286 = (i__5770__auto___28285 + (1));
i__5770__auto___28285 = G__28286;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
var G__28279_28287 = e;
var G__28280_28288 = "Function Error: ";
var G__28281_28289 = function_name;
var G__28282_28290 = "args: ";
var G__28283_28291 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5(G__28279_28287,G__28280_28288,G__28281_28289,G__28282_28290,G__28283_28291) : fluree.db.util.log.error.call(null,G__28279_28287,G__28280_28288,G__28281_28289,G__28282_28290,G__28283_28291));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28276){
var G__28277 = cljs.core.first(seq28276);
var seq28276__$1 = cljs.core.next(seq28276);
var G__28278 = cljs.core.first(seq28276__$1);
var seq28276__$2 = cljs.core.next(seq28276__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28277,G__28278,seq28276__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28292){var e = e28292;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28293){var e = e28293;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28294){var e = e28294;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28295){var e = e28295;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28296){var e = e28296;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28299 = arguments.length;
var i__5770__auto___28300 = (0);
while(true){
if((i__5770__auto___28300 < len__5769__auto___28299)){
args__5775__auto__.push((arguments[i__5770__auto___28300]));

var G__28301 = (i__5770__auto___28300 + (1));
i__5770__auto___28300 = G__28301;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28298){var e = e28298;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28297){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28297));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28304 = arguments.length;
var i__5770__auto___28305 = (0);
while(true){
if((i__5770__auto___28305 < len__5769__auto___28304)){
args__5775__auto__.push((arguments[i__5770__auto___28305]));

var G__28306 = (i__5770__auto___28305 + (1));
i__5770__auto___28305 = G__28306;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28303){var e = e28303;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28302){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28302));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28307){var e = e28307;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28310 = arguments.length;
var i__5770__auto___28311 = (0);
while(true){
if((i__5770__auto___28311 < len__5769__auto___28310)){
args__5775__auto__.push((arguments[i__5770__auto___28311]));

var G__28312 = (i__5770__auto___28311 + (1));
i__5770__auto___28311 = G__28312;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28309){var e = e28309;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28308){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28308));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28315 = arguments.length;
var i__5770__auto___28316 = (0);
while(true){
if((i__5770__auto___28316 < len__5769__auto___28315)){
args__5775__auto__.push((arguments[i__5770__auto___28316]));

var G__28317 = (i__5770__auto___28316 + (1));
i__5770__auto___28316 = G__28317;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e28314){var e = e28314;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28313){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28313));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28318){var e = e28318;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28319){var e = e28319;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28322 = arguments.length;
var i__5770__auto___28323 = (0);
while(true){
if((i__5770__auto___28323 < len__5769__auto___28322)){
args__5775__auto__.push((arguments[i__5770__auto___28323]));

var G__28324 = (i__5770__auto___28323 + (1));
i__5770__auto___28323 = G__28324;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28321){var e = e28321;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28320){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28320));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28327 = arguments.length;
var i__5770__auto___28328 = (0);
while(true){
if((i__5770__auto___28328 < len__5769__auto___28327)){
args__5775__auto__.push((arguments[i__5770__auto___28328]));

var G__28329 = (i__5770__auto___28328 + (1));
i__5770__auto___28328 = G__28329;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28326){var e = e28326;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28325){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28325));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28332 = arguments.length;
var i__5770__auto___28333 = (0);
while(true){
if((i__5770__auto___28333 < len__5769__auto___28332)){
args__5775__auto__.push((arguments[i__5770__auto___28333]));

var G__28334 = (i__5770__auto___28333 + (1));
i__5770__auto___28333 = G__28334;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28331){var e = e28331;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28330){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28330));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28337 = arguments.length;
var i__5770__auto___28338 = (0);
while(true){
if((i__5770__auto___28338 < len__5769__auto___28337)){
args__5775__auto__.push((arguments[i__5770__auto___28338]));

var G__28339 = (i__5770__auto___28338 + (1));
i__5770__auto___28338 = G__28339;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28336){var e = e28336;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28335){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28335));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28342 = arguments.length;
var i__5770__auto___28343 = (0);
while(true){
if((i__5770__auto___28343 < len__5769__auto___28342)){
args__5775__auto__.push((arguments[i__5770__auto___28343]));

var G__28344 = (i__5770__auto___28343 + (1));
i__5770__auto___28343 = G__28344;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28341){var e = e28341;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28340){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28340));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28347 = arguments.length;
var i__5770__auto___28348 = (0);
while(true){
if((i__5770__auto___28348 < len__5769__auto___28347)){
args__5775__auto__.push((arguments[i__5770__auto___28348]));

var G__28349 = (i__5770__auto___28348 + (1));
i__5770__auto___28348 = G__28349;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28346){var e = e28346;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28345){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28345));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28352 = arguments.length;
var i__5770__auto___28353 = (0);
while(true){
if((i__5770__auto___28353 < len__5769__auto___28352)){
args__5775__auto__.push((arguments[i__5770__auto___28353]));

var G__28354 = (i__5770__auto___28353 + (1));
i__5770__auto___28353 = G__28354;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e28351){var e = e28351;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28350){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28350));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28356 = arguments.length;
switch (G__28356) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28384){
var state_val_28385 = (state_28384[(1)]);
if((state_val_28385 === (7))){
var inst_28369 = (state_28384[(7)]);
var inst_28372 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28369,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28384__$1 = state_28384;
var statearr_28386_28472 = state_28384__$1;
(statearr_28386_28472[(2)] = inst_28372);

(statearr_28386_28472[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28385 === (1))){
var state_28384__$1 = state_28384;
var statearr_28387_28473 = state_28384__$1;
(statearr_28387_28473[(2)] = null);

(statearr_28387_28473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28385 === (4))){
var inst_28357 = (state_28384[(2)]);
var state_28384__$1 = state_28384;
var statearr_28388_28474 = state_28384__$1;
(statearr_28388_28474[(2)] = inst_28357);

(statearr_28388_28474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28385 === (6))){
var inst_28369 = (state_28384[(7)]);
var inst_28369__$1 = (state_28384[(2)]);
var inst_28370 = fluree.db.util.core.exception_QMARK_(inst_28369__$1);
var state_28384__$1 = (function (){var statearr_28389 = state_28384;
(statearr_28389[(7)] = inst_28369__$1);

return statearr_28389;
})();
if(inst_28370){
var statearr_28390_28475 = state_28384__$1;
(statearr_28390_28475[(1)] = (7));

} else {
var statearr_28391_28476 = state_28384__$1;
(statearr_28391_28476[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28385 === (3))){
var inst_28382 = (state_28384[(2)]);
var state_28384__$1 = state_28384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28384__$1,inst_28382);
} else {
if((state_val_28385 === (2))){
var inst_28363 = (state_28384[(8)]);
var _ = (function (){var statearr_28393 = state_28384;
(statearr_28393[(4)] = cljs.core.cons((5),(state_28384[(4)])));

return statearr_28393;
})();
var inst_28363__$1 = cljs.core.volatile_BANG_((0));
var inst_28364 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28365 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28364,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28363__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28366 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28365);
var inst_28367 = fluree.db.query.fql.query(db,inst_28366);
var state_28384__$1 = (function (){var statearr_28394 = state_28384;
(statearr_28394[(8)] = inst_28363__$1);

return statearr_28394;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28384__$1,(6),inst_28367);
} else {
if((state_val_28385 === (9))){
var inst_28379 = (state_28384[(2)]);
var _ = (function (){var statearr_28395 = state_28384;
(statearr_28395[(4)] = cljs.core.rest((state_28384[(4)])));

return statearr_28395;
})();
var state_28384__$1 = state_28384;
var statearr_28396_28477 = state_28384__$1;
(statearr_28396_28477[(2)] = inst_28379);

(statearr_28396_28477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28385 === (5))){
var _ = (function (){var statearr_28397 = state_28384;
(statearr_28397[(4)] = cljs.core.rest((state_28384[(4)])));

return statearr_28397;
})();
var state_28384__$1 = state_28384;
var ex28392 = (state_28384__$1[(2)]);
var statearr_28398_28478 = state_28384__$1;
(statearr_28398_28478[(5)] = ex28392);


if((ex28392 instanceof Error)){
var statearr_28399_28479 = state_28384__$1;
(statearr_28399_28479[(1)] = (4));

(statearr_28399_28479[(5)] = null);

} else {
throw ex28392;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28385 === (8))){
var inst_28363 = (state_28384[(8)]);
var inst_28369 = (state_28384[(7)]);
var inst_28374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28375 = cljs.core.deref(inst_28363);
var inst_28376 = [inst_28369,inst_28375];
var inst_28377 = (new cljs.core.PersistentVector(null,2,(5),inst_28374,inst_28376,null));
var state_28384__$1 = state_28384;
var statearr_28400_28480 = state_28384__$1;
(statearr_28400_28480[(2)] = inst_28377);

(statearr_28400_28480[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_28401 = [null,null,null,null,null,null,null,null,null];
(statearr_28401[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_28401[(1)] = (1));

return statearr_28401;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_28384){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28384);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28402){var ex__2687__auto__ = e28402;
var statearr_28403_28481 = state_28384;
(statearr_28403_28481[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28384[(4)]))){
var statearr_28404_28482 = state_28384;
(statearr_28404_28482[(1)] = cljs.core.first((state_28384[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28483 = state_28384;
state_28384 = G__28483;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_28384){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_28384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28405 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28405[(6)] = c__2706__auto__);

return statearr_28405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28450){
var state_val_28451 = (state_28450[(1)]);
if((state_val_28451 === (7))){
var inst_28436 = (state_28450[(2)]);
var inst_28437 = fluree.db.query.fql.query(db,inst_28436);
var state_28450__$1 = state_28450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28450__$1,(8),inst_28437);
} else {
if((state_val_28451 === (1))){
var inst_28406 = typeof select === 'string';
var state_28450__$1 = state_28450;
if(cljs.core.truth_(inst_28406)){
var statearr_28452_28484 = state_28450__$1;
(statearr_28452_28484[(1)] = (2));

} else {
var statearr_28453_28485 = state_28450__$1;
(statearr_28453_28485[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28451 === (4))){
var inst_28412 = (state_28450[(7)]);
var inst_28419 = (state_28450[(8)]);
var inst_28411 = (state_28450[(2)]);
var inst_28412__$1 = cljs.core.volatile_BANG_((0));
var inst_28413 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28414 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28415 = [inst_28412__$1,(100000)];
var inst_28416 = cljs.core.PersistentHashMap.fromArrays(inst_28414,inst_28415);
var inst_28417 = [inst_28411,from,where,block,limit,inst_28416];
var inst_28418 = cljs.core.PersistentHashMap.fromArrays(inst_28413,inst_28417);
var inst_28419__$1 = fluree.db.util.core.without_nils(inst_28418);
var inst_28420 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28419__$1);
var inst_28421 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28419__$1);
var inst_28422 = cljs.core.first(inst_28421);
var inst_28423 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28422], 0));
var inst_28424 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28423);
var inst_28425 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28419__$1);
var inst_28426 = cljs.core.last(inst_28425);
var inst_28427 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28426], 0));
var inst_28428 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28427);
var inst_28429 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28420,inst_28424,inst_28428], 0));
var state_28450__$1 = (function (){var statearr_28454 = state_28450;
(statearr_28454[(7)] = inst_28412__$1);

(statearr_28454[(8)] = inst_28419__$1);

return statearr_28454;
})();
if(cljs.core.truth_(inst_28429)){
var statearr_28455_28486 = state_28450__$1;
(statearr_28455_28486[(1)] = (5));

} else {
var statearr_28456_28487 = state_28450__$1;
(statearr_28456_28487[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28451 === (6))){
var inst_28419 = (state_28450[(8)]);
var state_28450__$1 = state_28450;
var statearr_28457_28488 = state_28450__$1;
(statearr_28457_28488[(2)] = inst_28419);

(statearr_28457_28488[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28451 === (3))){
var state_28450__$1 = state_28450;
var statearr_28458_28489 = state_28450__$1;
(statearr_28458_28489[(2)] = select);

(statearr_28458_28489[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28451 === (2))){
var inst_28408 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28450__$1 = state_28450;
var statearr_28459_28490 = state_28450__$1;
(statearr_28459_28490[(2)] = inst_28408);

(statearr_28459_28490[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28451 === (11))){
var inst_28448 = (state_28450[(2)]);
var state_28450__$1 = state_28450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28450__$1,inst_28448);
} else {
if((state_val_28451 === (9))){
var inst_28439 = (state_28450[(9)]);
var state_28450__$1 = state_28450;
var statearr_28460_28491 = state_28450__$1;
(statearr_28460_28491[(2)] = inst_28439);

(statearr_28460_28491[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28451 === (5))){
var inst_28419 = (state_28450[(8)]);
var inst_28431 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28419);
var inst_28432 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28431);
var inst_28433 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28419,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28432);
var state_28450__$1 = state_28450;
var statearr_28461_28492 = state_28450__$1;
(statearr_28461_28492[(2)] = inst_28433);

(statearr_28461_28492[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28451 === (10))){
var inst_28439 = (state_28450[(9)]);
var inst_28412 = (state_28450[(7)]);
var inst_28443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28444 = cljs.core.deref(inst_28412);
var inst_28445 = [inst_28439,inst_28444];
var inst_28446 = (new cljs.core.PersistentVector(null,2,(5),inst_28443,inst_28445,null));
var state_28450__$1 = state_28450;
var statearr_28462_28493 = state_28450__$1;
(statearr_28462_28493[(2)] = inst_28446);

(statearr_28462_28493[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28451 === (8))){
var inst_28439 = (state_28450[(9)]);
var inst_28439__$1 = (state_28450[(2)]);
var inst_28440 = fluree.db.util.core.exception_QMARK_(inst_28439__$1);
var state_28450__$1 = (function (){var statearr_28463 = state_28450;
(statearr_28463[(9)] = inst_28439__$1);

return statearr_28463;
})();
if(inst_28440){
var statearr_28464_28494 = state_28450__$1;
(statearr_28464_28494[(1)] = (9));

} else {
var statearr_28465_28495 = state_28450__$1;
(statearr_28465_28495[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_28466 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28466[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_28466[(1)] = (1));

return statearr_28466;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_28450){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28450);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28467){var ex__2687__auto__ = e28467;
var statearr_28468_28496 = state_28450;
(statearr_28468_28496[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28450[(4)]))){
var statearr_28469_28497 = state_28450;
(statearr_28469_28497[(1)] = cljs.core.first((state_28450[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28498 = state_28450;
state_28450 = G__28498;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_28450){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_28450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28470 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28470[(6)] = c__2706__auto__);

return statearr_28470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28502 = path;
var vec__28503 = G__28502;
var seq__28504 = cljs.core.seq(vec__28503);
var first__28505 = cljs.core.first(seq__28504);
var seq__28504__$1 = cljs.core.next(seq__28504);
var var$ = first__28505;
var r = seq__28504__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28502__$1 = G__28502;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28509 = G__28502__$1;
var seq__28510 = cljs.core.seq(vec__28509);
var first__28511 = cljs.core.first(seq__28510);
var seq__28510__$1 = cljs.core.next(seq__28510);
var var$__$1 = first__28511;
var r__$1 = seq__28510__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28512 = r__$1;
var G__28513 = n__$2;
var G__28514 = next_clauses;
G__28502__$1 = G__28512;
n__$1 = G__28513;
where_clauses__$1 = G__28514;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28515 = r__$1;
var G__28516 = next_n;
var G__28517 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28502__$1 = G__28515;
n__$1 = G__28516;
where_clauses__$1 = G__28517;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28554){
var state_val_28555 = (state_28554[(1)]);
if((state_val_28555 === (7))){
var inst_28527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28528 = [path];
var inst_28529 = (new cljs.core.PersistentVector(null,1,(5),inst_28527,inst_28528,null));
var state_28554__$1 = state_28554;
var statearr_28556_28584 = state_28554__$1;
(statearr_28556_28584[(2)] = inst_28529);

(statearr_28556_28584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28555 === (1))){
var state_28554__$1 = state_28554;
var statearr_28557_28585 = state_28554__$1;
(statearr_28557_28585[(2)] = null);

(statearr_28557_28585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28555 === (4))){
var inst_28518 = (state_28554[(2)]);
var state_28554__$1 = state_28554;
var statearr_28558_28586 = state_28554__$1;
(statearr_28558_28586[(2)] = inst_28518);

(statearr_28558_28586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28555 === (13))){
var inst_28545 = (state_28554[(2)]);
var inst_28546 = fluree.db.util.async.throw_err(inst_28545);
var _ = (function (){var statearr_28559 = state_28554;
(statearr_28559[(4)] = cljs.core.rest((state_28554[(4)])));

return statearr_28559;
})();
var state_28554__$1 = state_28554;
var statearr_28560_28587 = state_28554__$1;
(statearr_28560_28587[(2)] = inst_28546);

(statearr_28560_28587[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28555 === (6))){
var state_28554__$1 = state_28554;
var statearr_28562_28588 = state_28554__$1;
(statearr_28562_28588[(2)] = path);

(statearr_28562_28588[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28555 === (3))){
var inst_28552 = (state_28554[(2)]);
var state_28554__$1 = state_28554;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28554__$1,inst_28552);
} else {
if((state_val_28555 === (12))){
var _ = (function (){var statearr_28563 = state_28554;
(statearr_28563[(4)] = cljs.core.rest((state_28554[(4)])));

return statearr_28563;
})();
var state_28554__$1 = state_28554;
var ex28561 = (state_28554__$1[(2)]);
var statearr_28564_28589 = state_28554__$1;
(statearr_28564_28589[(5)] = ex28561);


var statearr_28565_28590 = state_28554__$1;
(statearr_28565_28590[(1)] = (11));

(statearr_28565_28590[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28555 === (2))){
var _ = (function (){var statearr_28566 = state_28554;
(statearr_28566[(4)] = cljs.core.cons((5),(state_28554[(4)])));

return statearr_28566;
})();
var inst_28524 = cljs.core.vector_QMARK_(path);
var state_28554__$1 = state_28554;
if(inst_28524){
var statearr_28567_28591 = state_28554__$1;
(statearr_28567_28591[(1)] = (6));

} else {
var statearr_28568_28592 = state_28554__$1;
(statearr_28568_28592[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28555 === (11))){
var inst_28531 = (state_28554[(7)]);
var inst_28536 = (state_28554[(2)]);
var inst_28537 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28536,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_28531,endSubject], 0));
var state_28554__$1 = state_28554;
var statearr_28570_28593 = state_28554__$1;
(statearr_28570_28593[(2)] = inst_28537);

(statearr_28570_28593[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28555 === (9))){
var inst_28535 = (state_28554[(8)]);
var _ = (function (){var statearr_28571 = state_28554;
(statearr_28571[(4)] = cljs.core.cons((12),(state_28554[(4)])));

return statearr_28571;
})();
var inst_28543 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28535);
var state_28554__$1 = state_28554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28554__$1,(13),inst_28543);
} else {
if((state_val_28555 === (5))){
var _ = (function (){var statearr_28572 = state_28554;
(statearr_28572[(4)] = cljs.core.rest((state_28554[(4)])));

return statearr_28572;
})();
var state_28554__$1 = state_28554;
var ex28569 = (state_28554__$1[(2)]);
var statearr_28573_28594 = state_28554__$1;
(statearr_28573_28594[(5)] = ex28569);


if((ex28569 instanceof Error)){
var statearr_28574_28595 = state_28554__$1;
(statearr_28574_28595[(1)] = (4));

(statearr_28574_28595[(5)] = null);

} else {
throw ex28569;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28555 === (10))){
var inst_28549 = (state_28554[(2)]);
var _ = (function (){var statearr_28575 = state_28554;
(statearr_28575[(4)] = cljs.core.rest((state_28554[(4)])));

return statearr_28575;
})();
var state_28554__$1 = state_28554;
var statearr_28576_28596 = state_28554__$1;
(statearr_28576_28596[(2)] = inst_28549);

(statearr_28576_28596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28555 === (8))){
var inst_28531 = (state_28554[(7)]);
var inst_28531__$1 = (state_28554[(2)]);
var inst_28532 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_28531__$1,endSubject);
var inst_28533 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28534 = ["?var1",inst_28532];
var inst_28535 = cljs.core.PersistentHashMap.fromArrays(inst_28533,inst_28534);
var state_28554__$1 = (function (){var statearr_28577 = state_28554;
(statearr_28577[(7)] = inst_28531__$1);

(statearr_28577[(8)] = inst_28535);

return statearr_28577;
})();
var statearr_28578_28597 = state_28554__$1;
(statearr_28578_28597[(2)] = null);

(statearr_28578_28597[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_28579 = [null,null,null,null,null,null,null,null,null];
(statearr_28579[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__);

(statearr_28579[(1)] = (1));

return statearr_28579;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1 = (function (state_28554){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28554);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28580){var ex__2687__auto__ = e28580;
var statearr_28581_28598 = state_28554;
(statearr_28581_28598[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28554[(4)]))){
var statearr_28582_28599 = state_28554;
(statearr_28582_28599[(1)] = cljs.core.first((state_28554[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28600 = state_28554;
state_28554 = G__28600;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__ = function(state_28554){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1.call(this,state_28554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28583 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28583[(6)] = c__2706__auto__);

return statearr_28583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e28601){var e = e28601;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28602){var e = e28602;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e28603){var e = e28603;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28657){
var state_val_28658 = (state_28657[(1)]);
if((state_val_28658 === (7))){
var state_28657__$1 = state_28657;
var statearr_28659_28697 = state_28657__$1;
(statearr_28659_28697[(2)] = pred);

(statearr_28659_28697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (20))){
var inst_28640 = (state_28657[(7)]);
var inst_28636 = (state_28657[(8)]);
var inst_28644 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_28640,inst_28636);
var state_28657__$1 = state_28657;
var statearr_28660_28698 = state_28657__$1;
(statearr_28660_28698[(2)] = inst_28644);

(statearr_28660_28698[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (1))){
var state_28657__$1 = state_28657;
var statearr_28661_28699 = state_28657__$1;
(statearr_28661_28699[(2)] = null);

(statearr_28661_28699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (4))){
var inst_28604 = (state_28657[(2)]);
var state_28657__$1 = state_28657;
var statearr_28662_28700 = state_28657__$1;
(statearr_28662_28700[(2)] = inst_28604);

(statearr_28662_28700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (15))){
var state_28657__$1 = state_28657;
var statearr_28663_28701 = state_28657__$1;
(statearr_28663_28701[(2)] = fluree.db.flake.o);

(statearr_28663_28701[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (21))){
var inst_28640 = (state_28657[(7)]);
var inst_28636 = (state_28657[(8)]);
var inst_28646 = cljs.core.first(inst_28636);
var inst_28647 = (inst_28640.cljs$core$IFn$_invoke$arity$1 ? inst_28640.cljs$core$IFn$_invoke$arity$1(inst_28646) : inst_28640.call(null,inst_28646));
var state_28657__$1 = state_28657;
var statearr_28664_28702 = state_28657__$1;
(statearr_28664_28702[(2)] = inst_28647);

(statearr_28664_28702[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (13))){
var inst_28633 = (state_28657[(2)]);
var inst_28634 = fluree.db.util.async.throw_err(inst_28633);
var state_28657__$1 = state_28657;
var statearr_28665_28703 = state_28657__$1;
(statearr_28665_28703[(2)] = inst_28634);

(statearr_28665_28703[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (22))){
var inst_28649 = (state_28657[(2)]);
var state_28657__$1 = state_28657;
var statearr_28666_28704 = state_28657__$1;
(statearr_28666_28704[(2)] = inst_28649);

(statearr_28666_28704[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (6))){
var inst_28614 = clojure.string.replace(pred,"/_","/");
var state_28657__$1 = state_28657;
var statearr_28667_28705 = state_28657__$1;
(statearr_28667_28705[(2)] = inst_28614);

(statearr_28667_28705[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (17))){
var inst_28618 = (state_28657[(9)]);
var state_28657__$1 = state_28657;
if(cljs.core.truth_(inst_28618)){
var statearr_28668_28706 = state_28657__$1;
(statearr_28668_28706[(1)] = (20));

} else {
var statearr_28669_28707 = state_28657__$1;
(statearr_28669_28707[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (3))){
var inst_28655 = (state_28657[(2)]);
var state_28657__$1 = state_28657;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28657__$1,inst_28655);
} else {
if((state_val_28658 === (12))){
var inst_28625 = (state_28657[(2)]);
var inst_28626 = fluree.db.util.async.throw_err(inst_28625);
var state_28657__$1 = state_28657;
var statearr_28670_28708 = state_28657__$1;
(statearr_28670_28708[(2)] = inst_28626);

(statearr_28670_28708[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (2))){
var inst_28612 = (state_28657[(10)]);
var _ = (function (){var statearr_28671 = state_28657;
(statearr_28671[(4)] = cljs.core.cons((5),(state_28657[(4)])));

return statearr_28671;
})();
var inst_28610 = typeof pred === 'string';
var inst_28611 = cljs.core.re_matches(/.+\/_.+/,pred);
var inst_28612__$1 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28610,inst_28611], 0));
var state_28657__$1 = (function (){var statearr_28672 = state_28657;
(statearr_28672[(10)] = inst_28612__$1);

return statearr_28672;
})();
if(cljs.core.truth_(inst_28612__$1)){
var statearr_28673_28709 = state_28657__$1;
(statearr_28673_28709[(1)] = (6));

} else {
var statearr_28674_28710 = state_28657__$1;
(statearr_28674_28710[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (19))){
var inst_28652 = (state_28657[(2)]);
var _ = (function (){var statearr_28675 = state_28657;
(statearr_28675[(4)] = cljs.core.rest((state_28657[(4)])));

return statearr_28675;
})();
var state_28657__$1 = state_28657;
var statearr_28676_28711 = state_28657__$1;
(statearr_28676_28711[(2)] = inst_28652);

(statearr_28676_28711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (11))){
var inst_28612 = (state_28657[(10)]);
var inst_28636 = (state_28657[(2)]);
var state_28657__$1 = (function (){var statearr_28678 = state_28657;
(statearr_28678[(8)] = inst_28636);

return statearr_28678;
})();
if(cljs.core.truth_(inst_28612)){
var statearr_28679_28712 = state_28657__$1;
(statearr_28679_28712[(1)] = (14));

} else {
var statearr_28680_28713 = state_28657__$1;
(statearr_28680_28713[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (9))){
var inst_28617 = (state_28657[(11)]);
var inst_28620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28621 = [sid,inst_28617];
var inst_28622 = (new cljs.core.PersistentVector(null,2,(5),inst_28620,inst_28621,null));
var inst_28623 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_28622);
var state_28657__$1 = state_28657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28657__$1,(12),inst_28623);
} else {
if((state_val_28658 === (5))){
var _ = (function (){var statearr_28681 = state_28657;
(statearr_28681[(4)] = cljs.core.rest((state_28657[(4)])));

return statearr_28681;
})();
var state_28657__$1 = state_28657;
var ex28677 = (state_28657__$1[(2)]);
var statearr_28682_28714 = state_28657__$1;
(statearr_28682_28714[(5)] = ex28677);


if((ex28677 instanceof Error)){
var statearr_28683_28715 = state_28657__$1;
(statearr_28683_28715[(1)] = (4));

(statearr_28683_28715[(5)] = null);

} else {
throw ex28677;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (14))){
var state_28657__$1 = state_28657;
var statearr_28684_28716 = state_28657__$1;
(statearr_28684_28716[(2)] = fluree.db.flake.s);

(statearr_28684_28716[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (16))){
var inst_28636 = (state_28657[(8)]);
var inst_28640 = (state_28657[(2)]);
var inst_28641 = cljs.core.seq(inst_28636);
var state_28657__$1 = (function (){var statearr_28685 = state_28657;
(statearr_28685[(7)] = inst_28640);

return statearr_28685;
})();
if(inst_28641){
var statearr_28686_28717 = state_28657__$1;
(statearr_28686_28717[(1)] = (17));

} else {
var statearr_28687_28718 = state_28657__$1;
(statearr_28687_28718[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (10))){
var inst_28617 = (state_28657[(11)]);
var inst_28628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28629 = [sid,inst_28617];
var inst_28630 = (new cljs.core.PersistentVector(null,2,(5),inst_28628,inst_28629,null));
var inst_28631 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28630);
var state_28657__$1 = state_28657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28657__$1,(13),inst_28631);
} else {
if((state_val_28658 === (18))){
var state_28657__$1 = state_28657;
var statearr_28688_28719 = state_28657__$1;
(statearr_28688_28719[(2)] = null);

(statearr_28688_28719[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (8))){
var inst_28612 = (state_28657[(10)]);
var inst_28617 = (state_28657[(11)]);
var inst_28617__$1 = (state_28657[(2)]);
var inst_28618 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_28617__$1);
var state_28657__$1 = (function (){var statearr_28689 = state_28657;
(statearr_28689[(11)] = inst_28617__$1);

(statearr_28689[(9)] = inst_28618);

return statearr_28689;
})();
if(cljs.core.truth_(inst_28612)){
var statearr_28690_28720 = state_28657__$1;
(statearr_28690_28720[(1)] = (9));

} else {
var statearr_28691_28721 = state_28657__$1;
(statearr_28691_28721[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0 = (function (){
var statearr_28692 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28692[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__);

(statearr_28692[(1)] = (1));

return statearr_28692;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1 = (function (state_28657){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28657);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28693){var ex__2687__auto__ = e28693;
var statearr_28694_28722 = state_28657;
(statearr_28694_28722[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28657[(4)]))){
var statearr_28695_28723 = state_28657;
(statearr_28695_28723[(1)] = cljs.core.first((state_28657[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28724 = state_28657;
state_28657 = G__28724;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__ = function(state_28657){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1.call(this,state_28657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28696 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28696[(6)] = c__2706__auto__);

return statearr_28696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e28725){var e = e28725;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28728 = arguments.length;
var i__5770__auto___28729 = (0);
while(true){
if((i__5770__auto___28729 < len__5769__auto___28728)){
args__5775__auto__.push((arguments[i__5770__auto___28729]));

var G__28730 = (i__5770__auto___28729 + (1));
i__5770__auto___28729 = G__28730;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e28727){var e = e28727;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28726){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28726));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28733 = arguments.length;
var i__5770__auto___28734 = (0);
while(true){
if((i__5770__auto___28734 < len__5769__auto___28733)){
args__5775__auto__.push((arguments[i__5770__auto___28734]));

var G__28735 = (i__5770__auto___28734 + (1));
i__5770__auto___28734 = G__28735;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e28732){var e = e28732;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28731){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28731));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28738 = arguments.length;
var i__5770__auto___28739 = (0);
while(true){
if((i__5770__auto___28739 < len__5769__auto___28738)){
args__5775__auto__.push((arguments[i__5770__auto___28739]));

var G__28740 = (i__5770__auto___28739 + (1));
i__5770__auto___28739 = G__28740;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e28737){var e = e28737;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28736){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28736));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28743 = arguments.length;
var i__5770__auto___28744 = (0);
while(true){
if((i__5770__auto___28744 < len__5769__auto___28743)){
args__5775__auto__.push((arguments[i__5770__auto___28744]));

var G__28745 = (i__5770__auto___28744 + (1));
i__5770__auto___28744 = G__28745;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e28742){var e = e28742;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28741){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28741));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e28746){var e = e28746;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e28747){var e = e28747;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e28748){var e = e28748;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28749){var e = e28749;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28750){var e = e28750;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28756 = path;
var vec__28757 = G__28756;
var seq__28758 = cljs.core.seq(vec__28757);
var first__28759 = cljs.core.first(seq__28758);
var seq__28758__$1 = cljs.core.next(seq__28758);
var pred = first__28759;
var r = seq__28758__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28756__$1 = G__28756;
var subjects__$1 = subjects;
while(true){
var vec__28763 = G__28756__$1;
var seq__28764 = cljs.core.seq(vec__28763);
var first__28765 = cljs.core.first(seq__28764);
var seq__28764__$1 = cljs.core.next(seq__28764);
var pred__$1 = first__28765;
var r__$1 = seq__28764__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__28756__$1,subjects__$1,vec__28763,seq__28764,first__28765,seq__28764__$1,pred__$1,r__$1,subjects__$2,G__28756,vec__28757,seq__28758,first__28759,seq__28758__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__28756__$1,subjects__$1,vec__28763,seq__28764,first__28765,seq__28764__$1,pred__$1,r__$1,subjects__$2,G__28756,vec__28757,seq__28758,first__28759,seq__28758__$1,pred,r,subjects){
return (function (p1__28751_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__28751_SHARP_,pred__$1);
});})(G__28756__$1,subjects__$1,vec__28763,seq__28764,first__28765,seq__28764__$1,pred__$1,r__$1,subjects__$2,G__28756,vec__28757,seq__28758,first__28759,seq__28758__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__28756__$1,subjects__$1,vec__28763,seq__28764,first__28765,seq__28764__$1,pred__$1,r__$1,subjects__$2,G__28756,vec__28757,seq__28758,first__28759,seq__28758__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__28766 = r__$1;
var G__28767 = next_subjects;
G__28756__$1 = G__28766;
subjects__$1 = G__28767;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28752){var e = e28752;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),fluree.db.dbfunctions.internal.count(path))){
return path;
} else {
var r_path = cljs.core.reverse(path);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first(r_path),cljs.core.rest(r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28810){
var state_val_28811 = (state_28810[(1)]);
if((state_val_28811 === (7))){
var state_28810__$1 = state_28810;
var statearr_28812_28833 = state_28810__$1;
(statearr_28812_28833[(2)] = path);

(statearr_28812_28833[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28811 === (1))){
var state_28810__$1 = state_28810;
var statearr_28813_28834 = state_28810__$1;
(statearr_28813_28834[(2)] = null);

(statearr_28813_28834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28811 === (4))){
var inst_28768 = (state_28810[(2)]);
var inst_28769 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28768,"follow-subject",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([sid,path], 0));
var state_28810__$1 = state_28810;
var statearr_28814_28835 = state_28810__$1;
(statearr_28814_28835[(2)] = inst_28769);

(statearr_28814_28835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28811 === (6))){
var inst_28789 = (state_28810[(7)]);
var inst_28787 = (state_28810[(2)]);
var inst_28788 = fluree.db.util.async.throw_err(inst_28787);
var inst_28789__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28788,(0),null);
var inst_28790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28788,(1),null);
var inst_28791 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("follow-subject results:",inst_28789__$1) : fluree.db.util.log.debug.call(null,"follow-subject results:",inst_28789__$1));
var inst_28792 = cljs.core.last(path);
var inst_28793 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_28792);
var state_28810__$1 = (function (){var statearr_28815 = state_28810;
(statearr_28815[(8)] = inst_28790);

(statearr_28815[(9)] = inst_28791);

(statearr_28815[(7)] = inst_28789__$1);

return statearr_28815;
})();
if(inst_28793){
var statearr_28816_28836 = state_28810__$1;
(statearr_28816_28836[(1)] = (7));

} else {
var statearr_28817_28837 = state_28810__$1;
(statearr_28817_28837[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28811 === (3))){
var inst_28808 = (state_28810[(2)]);
var state_28810__$1 = state_28810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28810__$1,inst_28808);
} else {
if((state_val_28811 === (2))){
var _ = (function (){var statearr_28819 = state_28810;
(statearr_28819[(4)] = cljs.core.cons((5),(state_28810[(4)])));

return statearr_28819;
})();
var inst_28778 = fluree.db.dbfunctions.internal.select_from_path(path);
var inst_28779 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28780 = cljs.core.PersistentHashMap.EMPTY;
var inst_28781 = [inst_28778,sid,inst_28780];
var inst_28782 = cljs.core.PersistentHashMap.fromArrays(inst_28779,inst_28781);
var inst_28783 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("follow-subject query:",inst_28782) : fluree.db.util.log.debug.call(null,"follow-subject query:",inst_28782));
var inst_28784 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28785 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28784,inst_28782);
var state_28810__$1 = (function (){var statearr_28820 = state_28810;
(statearr_28820[(10)] = inst_28783);

return statearr_28820;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28810__$1,(6),inst_28785);
} else {
if((state_val_28811 === (9))){
var inst_28790 = (state_28810[(8)]);
var inst_28789 = (state_28810[(7)]);
var inst_28798 = (state_28810[(2)]);
var inst_28799 = fluree.db.dbfunctions.internal.get_all(inst_28789,inst_28798);
var inst_28800 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("follow-subject res*:",inst_28799) : fluree.db.util.log.debug.call(null,"follow-subject res*:",inst_28799));
var inst_28801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28802 = fluree.db.dbfunctions.internal.count(path);
var inst_28803 = fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28790,inst_28802,(9)], 0));
var inst_28804 = [inst_28799,inst_28803];
var inst_28805 = (new cljs.core.PersistentVector(null,2,(5),inst_28801,inst_28804,null));
var _ = (function (){var statearr_28821 = state_28810;
(statearr_28821[(4)] = cljs.core.rest((state_28810[(4)])));

return statearr_28821;
})();
var state_28810__$1 = (function (){var statearr_28822 = state_28810;
(statearr_28822[(11)] = inst_28800);

return statearr_28822;
})();
var statearr_28823_28838 = state_28810__$1;
(statearr_28823_28838[(2)] = inst_28805);

(statearr_28823_28838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28811 === (5))){
var _ = (function (){var statearr_28824 = state_28810;
(statearr_28824[(4)] = cljs.core.rest((state_28810[(4)])));

return statearr_28824;
})();
var state_28810__$1 = state_28810;
var ex28818 = (state_28810__$1[(2)]);
var statearr_28825_28839 = state_28810__$1;
(statearr_28825_28839[(5)] = ex28818);


var statearr_28826_28840 = state_28810__$1;
(statearr_28826_28840[(1)] = (4));

(statearr_28826_28840[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28811 === (8))){
var inst_28796 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,"_id");
var state_28810__$1 = state_28810;
var statearr_28827_28841 = state_28810__$1;
(statearr_28827_28841[(2)] = inst_28796);

(statearr_28827_28841[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0 = (function (){
var statearr_28828 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28828[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__);

(statearr_28828[(1)] = (1));

return statearr_28828;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1 = (function (state_28810){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28810);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28829){var ex__2687__auto__ = e28829;
var statearr_28830_28842 = state_28810;
(statearr_28830_28842[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28810[(4)]))){
var statearr_28831_28843 = state_28810;
(statearr_28831_28843[(1)] = cljs.core.first((state_28810[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28844 = state_28810;
state_28810 = G__28844;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__ = function(state_28810){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1.call(this,state_28810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28832 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28832[(6)] = c__2706__auto__);

return statearr_28832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e28845){var e = e28845;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_(key)){
return cljs.core.some((function (p1__28846_SHARP_){
return (fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2(coll,p1__28846_SHARP_) : fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__28846_SHARP_));
}),key);
} else {
return cljs.core.contains_QMARK_(coll,key);
}
}catch (e28847){var e = e28847;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28850 = arguments.length;
var i__5770__auto___28851 = (0);
while(true){
if((i__5770__auto___28851 < len__5769__auto___28850)){
args__5775__auto__.push((arguments[i__5770__auto___28851]));

var G__28852 = (i__5770__auto___28851 + (1));
i__5770__auto___28851 = G__28852;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e28849){var e = e28849;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28848){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28848));
}));

/**
 * Returns the nth element in coll.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e28853){var e = e28853;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns the first element in coll.
 */
fluree.db.dbfunctions.internal.first = (function fluree$db$dbfunctions$internal$first(coll){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.vec(coll):coll);
return cljs.core.first(coll_SINGLEQUOTE_);
}catch (e28854){var e = e28854;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"first",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28857 = arguments.length;
var i__5770__auto___28858 = (0);
while(true){
if((i__5770__auto___28858 < len__5769__auto___28857)){
args__5775__auto__.push((arguments[i__5770__auto___28858]));

var G__28859 = (i__5770__auto___28858 + (1));
i__5770__auto___28858 = G__28859;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e28856){var e = e28856;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28855){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28855));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e28860){var e = e28860;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28917){
var state_val_28918 = (state_28917[(1)]);
if((state_val_28918 === (7))){
var inst_28863 = (state_28917[(2)]);
var state_28917__$1 = state_28917;
var statearr_28919_28953 = state_28917__$1;
(statearr_28919_28953[(2)] = inst_28863);

(statearr_28919_28953[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (1))){
var state_28917__$1 = state_28917;
var statearr_28920_28954 = state_28917__$1;
(statearr_28920_28954[(2)] = null);

(statearr_28920_28954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (4))){
var inst_28862 = (state_28917[(2)]);
var state_28917__$1 = (function (){var statearr_28921 = state_28917;
(statearr_28921[(7)] = inst_28862);

return statearr_28921;
})();
var statearr_28922_28955 = state_28917__$1;
(statearr_28922_28955[(2)] = null);

(statearr_28922_28955[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (15))){
var inst_28888 = (state_28917[(8)]);
var inst_28885 = (state_28917[(9)]);
var inst_28897 = (state_28917[(10)]);
var inst_28900 = (state_28917[(11)]);
var inst_28898 = (state_28917[(12)]);
var inst_28887 = (state_28917[(13)]);
var inst_28904 = (function (){var db = inst_28885;
var prevT = inst_28887;
var db_SINGLEQUOTE_ = inst_28888;
var prev_vals = inst_28897;
var fuel = inst_28898;
var G__28899 = inst_28900;
return (function (p1__28861_SHARP_){
var f = p1__28861_SHARP_;
return fluree.db.flake.o(f);
});
})();
var inst_28905 = (inst_28904.cljs$core$IFn$_invoke$arity$1 ? inst_28904.cljs$core$IFn$_invoke$arity$1(inst_28900) : inst_28904.call(null,inst_28900));
var state_28917__$1 = state_28917;
var statearr_28923_28956 = state_28917__$1;
(statearr_28923_28956[(2)] = inst_28905);

(statearr_28923_28956[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (13))){
var inst_28897 = (state_28917[(10)]);
var inst_28900 = (state_28917[(11)]);
var inst_28896 = (state_28917[(2)]);
var inst_28897__$1 = fluree.db.util.async.throw_err(inst_28896);
var inst_28898 = fluree.db.dbfunctions.internal.count(inst_28897__$1);
var inst_28900__$1 = cljs.core.first(inst_28897__$1);
var inst_28901 = (inst_28900__$1 == null);
var state_28917__$1 = (function (){var statearr_28924 = state_28917;
(statearr_28924[(10)] = inst_28897__$1);

(statearr_28924[(11)] = inst_28900__$1);

(statearr_28924[(12)] = inst_28898);

return statearr_28924;
})();
if(cljs.core.truth_(inst_28901)){
var statearr_28925_28957 = state_28917__$1;
(statearr_28925_28957[(1)] = (14));

} else {
var statearr_28926_28958 = state_28917__$1;
(statearr_28926_28958[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (6))){
var inst_28872 = (state_28917[(2)]);
var state_28917__$1 = state_28917;
var statearr_28927_28959 = state_28917__$1;
(statearr_28927_28959[(2)] = inst_28872);

(statearr_28927_28959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (3))){
var inst_28915 = (state_28917[(2)]);
var state_28917__$1 = state_28917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28917__$1,inst_28915);
} else {
if((state_val_28918 === (12))){
var inst_28912 = (state_28917[(2)]);
var _ = (function (){var statearr_28928 = state_28917;
(statearr_28928[(4)] = cljs.core.rest((state_28917[(4)])));

return statearr_28928;
})();
var state_28917__$1 = state_28917;
var statearr_28929_28960 = state_28917__$1;
(statearr_28929_28960[(2)] = inst_28912);

(statearr_28929_28960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (2))){
var _ = (function (){var statearr_28931 = state_28917;
(statearr_28931[(4)] = cljs.core.cons((9),(state_28917[(4)])));

return statearr_28931;
})();
var inst_28878 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28879 = typeof inst_28878 === 'string';
var state_28917__$1 = state_28917;
if(cljs.core.truth_(inst_28879)){
var statearr_28932_28961 = state_28917__$1;
(statearr_28932_28961[(1)] = (10));

} else {
var statearr_28933_28962 = state_28917__$1;
(statearr_28933_28962[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (11))){
var inst_28888 = (state_28917[(8)]);
var inst_28885 = (state_28917[(9)]);
var inst_28887 = (state_28917[(13)]);
var inst_28885__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28886 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28885__$1);
var inst_28887__$1 = fluree.db.dbfunctions.internal.inc(inst_28886);
var inst_28888__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28885__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28887__$1);
var inst_28889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28890 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28891 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28892 = [inst_28890,inst_28891];
var inst_28893 = (new cljs.core.PersistentVector(null,2,(5),inst_28889,inst_28892,null));
var inst_28894 = fluree.db.dbproto._search(inst_28888__$1,inst_28893);
var state_28917__$1 = (function (){var statearr_28934 = state_28917;
(statearr_28934[(8)] = inst_28888__$1);

(statearr_28934[(9)] = inst_28885__$1);

(statearr_28934[(13)] = inst_28887__$1);

return statearr_28934;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28917__$1,(13),inst_28894);
} else {
if((state_val_28918 === (9))){
var _ = (function (){var statearr_28935 = state_28917;
(statearr_28935[(4)] = cljs.core.rest((state_28917[(4)])));

return statearr_28935;
})();
var state_28917__$1 = state_28917;
var ex28930 = (state_28917__$1[(2)]);
var statearr_28936_28963 = state_28917__$1;
(statearr_28936_28963[(5)] = ex28930);


var statearr_28937_28964 = state_28917__$1;
(statearr_28937_28964[(1)] = (4));

(statearr_28937_28964[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (5))){
var inst_28862 = (state_28917[(7)]);
var _ = (function (){var statearr_28938 = state_28917;
(statearr_28938[(4)] = cljs.core.cons((8),(state_28917[(4)])));

return statearr_28938;
})();
var inst_28869 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28862,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_28939 = state_28917;
(statearr_28939[(4)] = cljs.core.rest((state_28917[(4)])));

return statearr_28939;
})();
var state_28917__$1 = state_28917;
var statearr_28940_28965 = state_28917__$1;
(statearr_28940_28965[(2)] = inst_28869);

(statearr_28940_28965[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (14))){
var state_28917__$1 = state_28917;
var statearr_28941_28966 = state_28917__$1;
(statearr_28941_28966[(2)] = null);

(statearr_28941_28966[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (16))){
var inst_28898 = (state_28917[(12)]);
var inst_28907 = (state_28917[(2)]);
var inst_28908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28909 = [inst_28907,inst_28898];
var inst_28910 = (new cljs.core.PersistentVector(null,2,(5),inst_28908,inst_28909,null));
var state_28917__$1 = state_28917;
var statearr_28943_28967 = state_28917__$1;
(statearr_28943_28967[(2)] = inst_28910);

(statearr_28943_28967[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (10))){
var inst_28881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28882 = [null,(0)];
var inst_28883 = (new cljs.core.PersistentVector(null,2,(5),inst_28881,inst_28882,null));
var state_28917__$1 = state_28917;
var statearr_28944_28968 = state_28917__$1;
(statearr_28944_28968[(2)] = inst_28883);

(statearr_28944_28968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28918 === (8))){
var _ = (function (){var statearr_28945 = state_28917;
(statearr_28945[(4)] = cljs.core.rest((state_28917[(4)])));

return statearr_28945;
})();
var state_28917__$1 = state_28917;
var ex28942 = (state_28917__$1[(2)]);
var statearr_28946_28969 = state_28917__$1;
(statearr_28946_28969[(5)] = ex28942);


var statearr_28947_28970 = state_28917__$1;
(statearr_28947_28970[(1)] = (7));

(statearr_28947_28970[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0 = (function (){
var statearr_28948 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28948[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__);

(statearr_28948[(1)] = (1));

return statearr_28948;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1 = (function (state_28917){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28917);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28949){var ex__2687__auto__ = e28949;
var statearr_28950_28971 = state_28917;
(statearr_28950_28971[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28917[(4)]))){
var statearr_28951_28972 = state_28917;
(statearr_28951_28972[(1)] = cljs.core.first((state_28917[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28973 = state_28917;
state_28917 = G__28973;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__ = function(state_28917){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1.call(this,state_28917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28952 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28952[(6)] = c__2706__auto__);

return statearr_28952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29025){
var state_val_29026 = (state_29025[(1)]);
if((state_val_29026 === (7))){
var inst_28975 = (state_29025[(2)]);
var state_29025__$1 = state_29025;
var statearr_29027_29056 = state_29025__$1;
(statearr_29027_29056[(2)] = inst_28975);

(statearr_29027_29056[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29026 === (1))){
var state_29025__$1 = state_29025;
var statearr_29028_29057 = state_29025__$1;
(statearr_29028_29057[(2)] = null);

(statearr_29028_29057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29026 === (4))){
var inst_28974 = (state_29025[(2)]);
var state_29025__$1 = (function (){var statearr_29029 = state_29025;
(statearr_29029[(7)] = inst_28974);

return statearr_29029;
})();
var statearr_29030_29058 = state_29025__$1;
(statearr_29030_29058[(2)] = null);

(statearr_29030_29058[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29026 === (13))){
var inst_29020 = (state_29025[(2)]);
var _ = (function (){var statearr_29031 = state_29025;
(statearr_29031[(4)] = cljs.core.rest((state_29025[(4)])));

return statearr_29031;
})();
var state_29025__$1 = state_29025;
var statearr_29032_29059 = state_29025__$1;
(statearr_29032_29059[(2)] = inst_29020);

(statearr_29032_29059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29026 === (6))){
var inst_28984 = (state_29025[(2)]);
var state_29025__$1 = state_29025;
var statearr_29033_29060 = state_29025__$1;
(statearr_29033_29060[(2)] = inst_28984);

(statearr_29033_29060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29026 === (3))){
var inst_29023 = (state_29025[(2)]);
var state_29025__$1 = state_29025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29025__$1,inst_29023);
} else {
if((state_val_29026 === (12))){
var inst_29007 = (state_29025[(8)]);
var inst_29016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29017 = [null,inst_29007];
var inst_29018 = (new cljs.core.PersistentVector(null,2,(5),inst_29016,inst_29017,null));
var state_29025__$1 = state_29025;
var statearr_29034_29061 = state_29025__$1;
(statearr_29034_29061[(2)] = inst_29018);

(statearr_29034_29061[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29026 === (2))){
var _ = (function (){var statearr_29036 = state_29025;
(statearr_29036[(4)] = cljs.core.cons((9),(state_29025[(4)])));

return statearr_29036;
})();
var inst_28993 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28996 = [null,pred_name,"?o"];
var inst_28997 = (new cljs.core.PersistentVector(null,3,(5),inst_28995,inst_28996,null));
var inst_28998 = [inst_28997];
var inst_28999 = (new cljs.core.PersistentVector(null,1,(5),inst_28994,inst_28998,null));
var inst_29000 = ["?o",inst_28999,opts];
var inst_29001 = cljs.core.PersistentHashMap.fromArrays(inst_28993,inst_29000);
var inst_29002 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_29001);
var state_29025__$1 = state_29025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29025__$1,(10),inst_29002);
} else {
if((state_val_29026 === (11))){
var inst_29007 = (state_29025[(8)]);
var inst_29006 = (state_29025[(9)]);
var inst_29011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29012 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_29006);
var inst_29013 = [inst_29012,inst_29007];
var inst_29014 = (new cljs.core.PersistentVector(null,2,(5),inst_29011,inst_29013,null));
var state_29025__$1 = state_29025;
var statearr_29037_29062 = state_29025__$1;
(statearr_29037_29062[(2)] = inst_29014);

(statearr_29037_29062[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29026 === (9))){
var _ = (function (){var statearr_29038 = state_29025;
(statearr_29038[(4)] = cljs.core.rest((state_29025[(4)])));

return statearr_29038;
})();
var state_29025__$1 = state_29025;
var ex29035 = (state_29025__$1[(2)]);
var statearr_29039_29063 = state_29025__$1;
(statearr_29039_29063[(5)] = ex29035);


var statearr_29040_29064 = state_29025__$1;
(statearr_29040_29064[(1)] = (4));

(statearr_29040_29064[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29026 === (5))){
var inst_28974 = (state_29025[(7)]);
var _ = (function (){var statearr_29042 = state_29025;
(statearr_29042[(4)] = cljs.core.cons((8),(state_29025[(4)])));

return statearr_29042;
})();
var inst_28981 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28974,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_29043 = state_29025;
(statearr_29043[(4)] = cljs.core.rest((state_29025[(4)])));

return statearr_29043;
})();
var state_29025__$1 = state_29025;
var statearr_29044_29065 = state_29025__$1;
(statearr_29044_29065[(2)] = inst_28981);

(statearr_29044_29065[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29026 === (10))){
var inst_29006 = (state_29025[(9)]);
var inst_29004 = (state_29025[(2)]);
var inst_29005 = fluree.db.util.async.throw_err(inst_29004);
var inst_29006__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29005,(0),null);
var inst_29007 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29005,(1),null);
var inst_29008 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_29006__$1);
var inst_29009 = cljs.core.not(inst_29008);
var state_29025__$1 = (function (){var statearr_29045 = state_29025;
(statearr_29045[(8)] = inst_29007);

(statearr_29045[(9)] = inst_29006__$1);

return statearr_29045;
})();
if(inst_29009){
var statearr_29046_29066 = state_29025__$1;
(statearr_29046_29066[(1)] = (11));

} else {
var statearr_29047_29067 = state_29025__$1;
(statearr_29047_29067[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29026 === (8))){
var _ = (function (){var statearr_29048 = state_29025;
(statearr_29048[(4)] = cljs.core.rest((state_29025[(4)])));

return statearr_29048;
})();
var state_29025__$1 = state_29025;
var ex29041 = (state_29025__$1[(2)]);
var statearr_29049_29068 = state_29025__$1;
(statearr_29049_29068[(5)] = ex29041);


var statearr_29050_29069 = state_29025__$1;
(statearr_29050_29069[(1)] = (7));

(statearr_29050_29069[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0 = (function (){
var statearr_29051 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29051[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__);

(statearr_29051[(1)] = (1));

return statearr_29051;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1 = (function (state_29025){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29025);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29052){var ex__2687__auto__ = e29052;
var statearr_29053_29070 = state_29025;
(statearr_29053_29070[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29025[(4)]))){
var statearr_29054_29071 = state_29025;
(statearr_29054_29071[(1)] = cljs.core.first((state_29025[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29072 = state_29025;
state_29025 = G__29072;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__ = function(state_29025){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1.call(this,state_29025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29055 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29055[(6)] = c__2706__auto__);

return statearr_29055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e29073){var e = e29073;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29075 = arguments.length;
switch (G__29075) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29145){
var state_val_29146 = (state_29145[(1)]);
if((state_val_29146 === (7))){
var inst_29077 = (state_29145[(2)]);
var state_29145__$1 = state_29145;
var statearr_29147_29191 = state_29145__$1;
(statearr_29147_29191[(2)] = inst_29077);

(statearr_29147_29191[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (20))){
var inst_29121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29122 = ["*"];
var inst_29123 = (new cljs.core.PersistentVector(null,1,(5),inst_29121,inst_29122,null));
var state_29145__$1 = state_29145;
var statearr_29148_29192 = state_29145__$1;
(statearr_29148_29192[(2)] = inst_29123);

(statearr_29148_29192[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (1))){
var state_29145__$1 = state_29145;
var statearr_29149_29193 = state_29145__$1;
(statearr_29149_29193[(2)] = null);

(statearr_29149_29193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (4))){
var inst_29076 = (state_29145[(2)]);
var state_29145__$1 = (function (){var statearr_29150 = state_29145;
(statearr_29150[(7)] = inst_29076);

return statearr_29150;
})();
var statearr_29151_29194 = state_29145__$1;
(statearr_29151_29194[(2)] = null);

(statearr_29151_29194[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (15))){
var inst_29140 = (state_29145[(2)]);
var _ = (function (){var statearr_29152 = state_29145;
(statearr_29152[(4)] = cljs.core.rest((state_29145[(4)])));

return statearr_29152;
})();
var state_29145__$1 = state_29145;
var statearr_29153_29195 = state_29145__$1;
(statearr_29153_29195[(2)] = inst_29140);

(statearr_29153_29195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (21))){
var inst_29111 = (state_29145[(8)]);
var inst_29104 = (state_29145[(9)]);
var inst_29125 = (state_29145[(2)]);
var inst_29126 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29127 = cljs.core.PersistentHashMap.EMPTY;
var inst_29128 = [inst_29125,inst_29111,inst_29127];
var inst_29129 = cljs.core.PersistentHashMap.fromArrays(inst_29126,inst_29128);
var inst_29130 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29104,inst_29129);
var state_29145__$1 = state_29145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29145__$1,(22),inst_29130);
} else {
if((state_val_29146 === (13))){
var inst_29099 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29145__$1 = state_29145;
var statearr_29154_29196 = state_29145__$1;
(statearr_29154_29196[(2)] = inst_29099);

(statearr_29154_29196[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (22))){
var inst_29132 = (state_29145[(2)]);
var inst_29133 = fluree.db.util.async.throw_err(inst_29132);
var inst_29134 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29133,(0),null);
var inst_29135 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29133,(1),null);
var inst_29136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29137 = [inst_29134,inst_29135];
var inst_29138 = (new cljs.core.PersistentVector(null,2,(5),inst_29136,inst_29137,null));
var state_29145__$1 = state_29145;
var statearr_29155_29197 = state_29145__$1;
(statearr_29155_29197[(2)] = inst_29138);

(statearr_29155_29197[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (6))){
var inst_29086 = (state_29145[(2)]);
var state_29145__$1 = state_29145;
var statearr_29156_29198 = state_29145__$1;
(statearr_29156_29198[(2)] = inst_29086);

(statearr_29156_29198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (17))){
var inst_29108 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29109 = fluree.db.dbfunctions.internal.get(inst_29108,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29145__$1 = state_29145;
var statearr_29157_29199 = state_29145__$1;
(statearr_29157_29199[(2)] = inst_29109);

(statearr_29157_29199[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (3))){
var inst_29143 = (state_29145[(2)]);
var state_29145__$1 = state_29145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29145__$1,inst_29143);
} else {
if((state_val_29146 === (12))){
var inst_29097 = (state_29145[(2)]);
var state_29145__$1 = state_29145;
if(cljs.core.truth_(inst_29097)){
var statearr_29158_29200 = state_29145__$1;
(statearr_29158_29200[(1)] = (13));

} else {
var statearr_29159_29201 = state_29145__$1;
(statearr_29159_29201[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (2))){
var inst_29092 = (state_29145[(10)]);
var _ = (function (){var statearr_29160 = state_29145;
(statearr_29160[(4)] = cljs.core.cons((9),(state_29145[(4)])));

return statearr_29160;
})();
var inst_29092__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29145__$1 = (function (){var statearr_29161 = state_29145;
(statearr_29161[(10)] = inst_29092__$1);

return statearr_29161;
})();
if(cljs.core.truth_(inst_29092__$1)){
var statearr_29162_29202 = state_29145__$1;
(statearr_29162_29202[(1)] = (10));

} else {
var statearr_29163_29203 = state_29145__$1;
(statearr_29163_29203[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (19))){
var inst_29113 = cljs.core.PersistentVector.EMPTY;
var inst_29114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29115 = ["*"];
var inst_29116 = (new cljs.core.PersistentVector(null,1,(5),inst_29114,inst_29115,null));
var inst_29117 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29118 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29116,inst_29117);
var inst_29119 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29113,inst_29118);
var state_29145__$1 = state_29145;
var statearr_29165_29204 = state_29145__$1;
(statearr_29165_29204[(2)] = inst_29119);

(statearr_29165_29204[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (11))){
var inst_29092 = (state_29145[(10)]);
var state_29145__$1 = state_29145;
var statearr_29166_29205 = state_29145__$1;
(statearr_29166_29205[(2)] = inst_29092);

(statearr_29166_29205[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (9))){
var _ = (function (){var statearr_29167 = state_29145;
(statearr_29167[(4)] = cljs.core.rest((state_29145[(4)])));

return statearr_29167;
})();
var state_29145__$1 = state_29145;
var ex29164 = (state_29145__$1[(2)]);
var statearr_29168_29206 = state_29145__$1;
(statearr_29168_29206[(5)] = ex29164);


var statearr_29169_29207 = state_29145__$1;
(statearr_29169_29207[(1)] = (4));

(statearr_29169_29207[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (5))){
var inst_29076 = (state_29145[(7)]);
var _ = (function (){var statearr_29170 = state_29145;
(statearr_29170[(4)] = cljs.core.cons((8),(state_29145[(4)])));

return statearr_29170;
})();
var inst_29083 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29076,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_29171 = state_29145;
(statearr_29171[(4)] = cljs.core.rest((state_29145[(4)])));

return statearr_29171;
})();
var state_29145__$1 = state_29145;
var statearr_29172_29208 = state_29145__$1;
(statearr_29172_29208[(2)] = inst_29083);

(statearr_29172_29208[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (14))){
var inst_29105 = (state_29145[(11)]);
var inst_29104 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29105__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29145__$1 = (function (){var statearr_29173 = state_29145;
(statearr_29173[(11)] = inst_29105__$1);

(statearr_29173[(9)] = inst_29104);

return statearr_29173;
})();
if(cljs.core.truth_(inst_29105__$1)){
var statearr_29174_29209 = state_29145__$1;
(statearr_29174_29209[(1)] = (16));

} else {
var statearr_29175_29210 = state_29145__$1;
(statearr_29175_29210[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (16))){
var inst_29105 = (state_29145[(11)]);
var state_29145__$1 = state_29145;
var statearr_29176_29211 = state_29145__$1;
(statearr_29176_29211[(2)] = inst_29105);

(statearr_29176_29211[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (10))){
var inst_29094 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_29145__$1 = state_29145;
var statearr_29178_29212 = state_29145__$1;
(statearr_29178_29212[(2)] = inst_29094);

(statearr_29178_29212[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (18))){
var inst_29111 = (state_29145[(2)]);
var state_29145__$1 = (function (){var statearr_29179 = state_29145;
(statearr_29179[(8)] = inst_29111);

return statearr_29179;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29180_29213 = state_29145__$1;
(statearr_29180_29213[(1)] = (19));

} else {
var statearr_29181_29214 = state_29145__$1;
(statearr_29181_29214[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29146 === (8))){
var _ = (function (){var statearr_29182 = state_29145;
(statearr_29182[(4)] = cljs.core.rest((state_29145[(4)])));

return statearr_29182;
})();
var state_29145__$1 = state_29145;
var ex29177 = (state_29145__$1[(2)]);
var statearr_29183_29215 = state_29145__$1;
(statearr_29183_29215[(5)] = ex29177);


var statearr_29184_29216 = state_29145__$1;
(statearr_29184_29216[(1)] = (7));

(statearr_29184_29216[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_29185 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29185[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_29185[(1)] = (1));

return statearr_29185;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_29145){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29145);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29186){var ex__2687__auto__ = e29186;
var statearr_29187_29217 = state_29145;
(statearr_29187_29217[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29145[(4)]))){
var statearr_29188_29218 = state_29145;
(statearr_29188_29218[(1)] = cljs.core.first((state_29145[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29219 = state_29145;
state_29145 = G__29219;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_29145){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_29145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29189 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29189[(6)] = c__2706__auto__);

return statearr_29189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29221 = arguments.length;
switch (G__29221) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29265){
var state_val_29266 = (state_29265[(1)]);
if((state_val_29266 === (7))){
var inst_29243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29244 = ["*"];
var inst_29245 = (new cljs.core.PersistentVector(null,1,(5),inst_29243,inst_29244,null));
var state_29265__$1 = state_29265;
var statearr_29267_29287 = state_29265__$1;
(statearr_29267_29287[(2)] = inst_29245);

(statearr_29267_29287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29266 === (1))){
var state_29265__$1 = state_29265;
var statearr_29268_29288 = state_29265__$1;
(statearr_29268_29288[(2)] = null);

(statearr_29268_29288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29266 === (4))){
var inst_29222 = (state_29265[(2)]);
var inst_29223 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29222,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_29265__$1 = state_29265;
var statearr_29269_29289 = state_29265__$1;
(statearr_29269_29289[(2)] = inst_29223);

(statearr_29269_29289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29266 === (6))){
var inst_29235 = cljs.core.PersistentVector.EMPTY;
var inst_29236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29237 = ["*"];
var inst_29238 = (new cljs.core.PersistentVector(null,1,(5),inst_29236,inst_29237,null));
var inst_29239 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29240 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29238,inst_29239);
var inst_29241 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29235,inst_29240);
var state_29265__$1 = state_29265;
var statearr_29270_29290 = state_29265__$1;
(statearr_29270_29290[(2)] = inst_29241);

(statearr_29270_29290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29266 === (3))){
var inst_29263 = (state_29265[(2)]);
var state_29265__$1 = state_29265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29265__$1,inst_29263);
} else {
if((state_val_29266 === (2))){
var _ = (function (){var statearr_29272 = state_29265;
(statearr_29272[(4)] = cljs.core.cons((5),(state_29265[(4)])));

return statearr_29272;
})();
var inst_29232 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29233 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29265__$1 = (function (){var statearr_29273 = state_29265;
(statearr_29273[(7)] = inst_29233);

(statearr_29273[(8)] = inst_29232);

return statearr_29273;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29274_29291 = state_29265__$1;
(statearr_29274_29291[(1)] = (6));

} else {
var statearr_29275_29292 = state_29265__$1;
(statearr_29275_29292[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29266 === (9))){
var inst_29254 = (state_29265[(2)]);
var inst_29255 = fluree.db.util.async.throw_err(inst_29254);
var inst_29256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29255,(0),null);
var inst_29257 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29255,(1),null);
var inst_29258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29259 = [inst_29256,inst_29257];
var inst_29260 = (new cljs.core.PersistentVector(null,2,(5),inst_29258,inst_29259,null));
var _ = (function (){var statearr_29276 = state_29265;
(statearr_29276[(4)] = cljs.core.rest((state_29265[(4)])));

return statearr_29276;
})();
var state_29265__$1 = state_29265;
var statearr_29277_29293 = state_29265__$1;
(statearr_29277_29293[(2)] = inst_29260);

(statearr_29277_29293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29266 === (5))){
var _ = (function (){var statearr_29278 = state_29265;
(statearr_29278[(4)] = cljs.core.rest((state_29265[(4)])));

return statearr_29278;
})();
var state_29265__$1 = state_29265;
var ex29271 = (state_29265__$1[(2)]);
var statearr_29279_29294 = state_29265__$1;
(statearr_29279_29294[(5)] = ex29271);


var statearr_29280_29295 = state_29265__$1;
(statearr_29280_29295[(1)] = (4));

(statearr_29280_29295[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29266 === (8))){
var inst_29233 = (state_29265[(7)]);
var inst_29232 = (state_29265[(8)]);
var inst_29247 = (state_29265[(2)]);
var inst_29248 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29249 = cljs.core.PersistentHashMap.EMPTY;
var inst_29250 = [inst_29247,inst_29233,inst_29249];
var inst_29251 = cljs.core.PersistentHashMap.fromArrays(inst_29248,inst_29250);
var inst_29252 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29232,inst_29251);
var state_29265__$1 = state_29265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29265__$1,(9),inst_29252);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_29281 = [null,null,null,null,null,null,null,null,null];
(statearr_29281[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_29281[(1)] = (1));

return statearr_29281;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_29265){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29265);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29282){var ex__2687__auto__ = e29282;
var statearr_29283_29296 = state_29265;
(statearr_29283_29296[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29265[(4)]))){
var statearr_29284_29297 = state_29265;
(statearr_29284_29297[(1)] = cljs.core.first((state_29265[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29298 = state_29265;
state_29265 = G__29298;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_29265){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_29265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29285 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29285[(6)] = c__2706__auto__);

return statearr_29285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29342){
var state_val_29343 = (state_29342[(1)]);
if((state_val_29343 === (1))){
var state_29342__$1 = state_29342;
var statearr_29344_29358 = state_29342__$1;
(statearr_29344_29358[(2)] = null);

(statearr_29344_29358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29343 === (2))){
var _ = (function (){var statearr_29345 = state_29342;
(statearr_29345[(4)] = cljs.core.cons((5),(state_29342[(4)])));

return statearr_29345;
})();
var inst_29309 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29311 = ["_user/_auth"];
var inst_29312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29313 = ["*"];
var inst_29314 = (new cljs.core.PersistentVector(null,1,(5),inst_29312,inst_29313,null));
var inst_29315 = [inst_29314];
var inst_29316 = cljs.core.PersistentHashMap.fromArrays(inst_29311,inst_29315);
var inst_29317 = [inst_29316];
var inst_29318 = (new cljs.core.PersistentVector(null,1,(5),inst_29310,inst_29317,null));
var inst_29319 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29320 = cljs.core.PersistentHashMap.EMPTY;
var inst_29321 = [inst_29318,inst_29319,inst_29320];
var inst_29322 = cljs.core.PersistentHashMap.fromArrays(inst_29309,inst_29321);
var inst_29323 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29324 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29323,inst_29322);
var state_29342__$1 = state_29342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29342__$1,(6),inst_29324);
} else {
if((state_val_29343 === (3))){
var inst_29340 = (state_29342[(2)]);
var state_29342__$1 = state_29342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29342__$1,inst_29340);
} else {
if((state_val_29343 === (4))){
var inst_29299 = (state_29342[(2)]);
var inst_29300 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29299,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29342__$1 = state_29342;
var statearr_29347_29359 = state_29342__$1;
(statearr_29347_29359[(2)] = inst_29300);

(statearr_29347_29359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29343 === (5))){
var _ = (function (){var statearr_29348 = state_29342;
(statearr_29348[(4)] = cljs.core.rest((state_29342[(4)])));

return statearr_29348;
})();
var state_29342__$1 = state_29342;
var ex29346 = (state_29342__$1[(2)]);
var statearr_29349_29360 = state_29342__$1;
(statearr_29349_29360[(5)] = ex29346);


var statearr_29350_29361 = state_29342__$1;
(statearr_29350_29361[(1)] = (4));

(statearr_29350_29361[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29343 === (6))){
var inst_29326 = (state_29342[(2)]);
var inst_29327 = fluree.db.util.async.throw_err(inst_29326);
var inst_29328 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29327,(0),null);
var inst_29329 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29327,(1),null);
var inst_29330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29331 = ["_user/_auth","_id"];
var inst_29332 = (new cljs.core.PersistentVector(null,2,(5),inst_29330,inst_29331,null));
var inst_29333 = fluree.db.dbfunctions.internal.get_in(inst_29328,inst_29332);
var inst_29334 = cljs.core.first(inst_29333);
var inst_29335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29336 = [inst_29334,inst_29329];
var inst_29337 = (new cljs.core.PersistentVector(null,2,(5),inst_29335,inst_29336,null));
var _ = (function (){var statearr_29351 = state_29342;
(statearr_29351[(4)] = cljs.core.rest((state_29342[(4)])));

return statearr_29351;
})();
var state_29342__$1 = state_29342;
var statearr_29352_29362 = state_29342__$1;
(statearr_29352_29362[(2)] = inst_29337);

(statearr_29352_29362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0 = (function (){
var statearr_29353 = [null,null,null,null,null,null,null];
(statearr_29353[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__);

(statearr_29353[(1)] = (1));

return statearr_29353;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1 = (function (state_29342){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29342);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29354){var ex__2687__auto__ = e29354;
var statearr_29355_29363 = state_29342;
(statearr_29355_29363[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29342[(4)]))){
var statearr_29356_29364 = state_29342;
(statearr_29356_29364[(1)] = cljs.core.first((state_29342[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29365 = state_29342;
state_29342 = G__29365;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__ = function(state_29342){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1.call(this,state_29342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29357 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29357[(6)] = c__2706__auto__);

return statearr_29357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29387){
var state_val_29388 = (state_29387[(1)]);
if((state_val_29388 === (7))){
var inst_29372 = (state_29387[(7)]);
var inst_29376 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29377 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29376,inst_29372);
var state_29387__$1 = state_29387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29387__$1,(9),inst_29377);
} else {
if((state_val_29388 === (1))){
var state_29387__$1 = state_29387;
var statearr_29389_29408 = state_29387__$1;
(statearr_29389_29408[(2)] = null);

(statearr_29389_29408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29388 === (4))){
var inst_29366 = (state_29387[(2)]);
var state_29387__$1 = state_29387;
var statearr_29390_29409 = state_29387__$1;
(statearr_29390_29409[(2)] = inst_29366);

(statearr_29390_29409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29388 === (6))){
var inst_29372 = (state_29387[(7)]);
var state_29387__$1 = state_29387;
var statearr_29391_29410 = state_29387__$1;
(statearr_29391_29410[(2)] = inst_29372);

(statearr_29391_29410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29388 === (3))){
var inst_29385 = (state_29387[(2)]);
var state_29387__$1 = state_29387;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29387__$1,inst_29385);
} else {
if((state_val_29388 === (2))){
var inst_29372 = (state_29387[(7)]);
var _ = (function (){var statearr_29393 = state_29387;
(statearr_29393[(4)] = cljs.core.cons((5),(state_29387[(4)])));

return statearr_29393;
})();
var inst_29372__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29373 = typeof inst_29372__$1 === 'number';
var state_29387__$1 = (function (){var statearr_29394 = state_29387;
(statearr_29394[(7)] = inst_29372__$1);

return statearr_29394;
})();
if(cljs.core.truth_(inst_29373)){
var statearr_29395_29411 = state_29387__$1;
(statearr_29395_29411[(1)] = (6));

} else {
var statearr_29396_29412 = state_29387__$1;
(statearr_29396_29412[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29388 === (9))){
var inst_29379 = (state_29387[(2)]);
var inst_29380 = fluree.db.util.async.throw_err(inst_29379);
var state_29387__$1 = state_29387;
var statearr_29397_29413 = state_29387__$1;
(statearr_29397_29413[(2)] = inst_29380);

(statearr_29397_29413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29388 === (5))){
var _ = (function (){var statearr_29398 = state_29387;
(statearr_29398[(4)] = cljs.core.rest((state_29387[(4)])));

return statearr_29398;
})();
var state_29387__$1 = state_29387;
var ex29392 = (state_29387__$1[(2)]);
var statearr_29399_29414 = state_29387__$1;
(statearr_29399_29414[(5)] = ex29392);


if((ex29392 instanceof Error)){
var statearr_29400_29415 = state_29387__$1;
(statearr_29400_29415[(1)] = (4));

(statearr_29400_29415[(5)] = null);

} else {
throw ex29392;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29388 === (8))){
var inst_29382 = (state_29387[(2)]);
var _ = (function (){var statearr_29401 = state_29387;
(statearr_29401[(4)] = cljs.core.rest((state_29387[(4)])));

return statearr_29401;
})();
var state_29387__$1 = state_29387;
var statearr_29402_29416 = state_29387__$1;
(statearr_29402_29416[(2)] = inst_29382);

(statearr_29402_29416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0 = (function (){
var statearr_29403 = [null,null,null,null,null,null,null,null];
(statearr_29403[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__);

(statearr_29403[(1)] = (1));

return statearr_29403;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1 = (function (state_29387){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29387);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29404){var ex__2687__auto__ = e29404;
var statearr_29405_29417 = state_29387;
(statearr_29405_29417[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29387[(4)]))){
var statearr_29406_29418 = state_29387;
(statearr_29406_29418[(1)] = cljs.core.first((state_29387[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29419 = state_29387;
state_29387 = G__29419;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__ = function(state_29387){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1.call(this,state_29387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29407 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29407[(6)] = c__2706__auto__);

return statearr_29407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29420_SHARP_){
return fluree.db.flake.op(p1__29420_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29421_SHARP_){
return fluree.db.flake.o(p1__29421_SHARP_);
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29422){var e = e29422;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29423_SHARP_){
return fluree.db.flake.op(p1__29423_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29424_SHARP_){
return fluree.db.flake.o(p1__29424_SHARP_);
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29425){var e = e29425;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29427 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29427);
})() | (0));
return num;
}catch (e29426){var e = e29426;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29507){
var state_val_29508 = (state_29507[(1)]);
if((state_val_29508 === (7))){
var inst_29446 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29447 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29448 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29449 = cljs.core.PersistentHashMap.fromArrays(inst_29447,inst_29448);
var inst_29450 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29446,inst_29449);
var inst_29451 = (function(){throw inst_29450})();
var state_29507__$1 = state_29507;
var statearr_29509_29544 = state_29507__$1;
(statearr_29509_29544[(2)] = inst_29451);

(statearr_29509_29544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (1))){
var state_29507__$1 = state_29507;
var statearr_29510_29545 = state_29507__$1;
(statearr_29510_29545[(2)] = null);

(statearr_29510_29545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (4))){
var inst_29428 = (state_29507[(2)]);
var state_29507__$1 = state_29507;
var statearr_29511_29546 = state_29507__$1;
(statearr_29511_29546[(2)] = inst_29428);

(statearr_29511_29546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (15))){
var inst_29491 = (state_29507[(7)]);
var inst_29487 = (state_29507[(2)]);
var inst_29488 = fluree.db.util.async.throw_err(inst_29487);
var inst_29489 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29488,(0),null);
var inst_29490 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29488,(1),null);
var inst_29491__$1 = cljs.core.first(inst_29489);
var inst_29492 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29491__$1,compare_val);
var state_29507__$1 = (function (){var statearr_29512 = state_29507;
(statearr_29512[(7)] = inst_29491__$1);

(statearr_29512[(8)] = inst_29490);

return statearr_29512;
})();
if(inst_29492){
var statearr_29513_29547 = state_29507__$1;
(statearr_29513_29547[(1)] = (16));

} else {
var statearr_29514_29548 = state_29507__$1;
(statearr_29514_29548[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (13))){
var state_29507__$1 = state_29507;
var statearr_29515_29549 = state_29507__$1;
(statearr_29515_29549[(2)] = null);

(statearr_29515_29549[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (6))){
var state_29507__$1 = state_29507;
var statearr_29516_29550 = state_29507__$1;
(statearr_29516_29550[(2)] = null);

(statearr_29516_29550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (17))){
var inst_29491 = (state_29507[(7)]);
var inst_29495 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29491)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29496 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29497 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29498 = cljs.core.PersistentHashMap.fromArrays(inst_29496,inst_29497);
var inst_29499 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29495,inst_29498);
var inst_29500 = (function(){throw inst_29499})();
var state_29507__$1 = state_29507;
var statearr_29517_29551 = state_29507__$1;
(statearr_29517_29551[(2)] = inst_29500);

(statearr_29517_29551[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (3))){
var inst_29505 = (state_29507[(2)]);
var state_29507__$1 = state_29507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29507__$1,inst_29505);
} else {
if((state_val_29508 === (12))){
var inst_29443 = (state_29507[(9)]);
var inst_29466 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_29443], 0));
var inst_29467 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29468 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29469 = cljs.core.PersistentHashMap.fromArrays(inst_29467,inst_29468);
var inst_29470 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29466,inst_29469);
var inst_29471 = (function(){throw inst_29470})();
var state_29507__$1 = state_29507;
var statearr_29518_29552 = state_29507__$1;
(statearr_29518_29552[(2)] = inst_29471);

(statearr_29518_29552[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (2))){
var inst_29441 = (state_29507[(10)]);
var inst_29442 = (state_29507[(11)]);
var inst_29440 = (state_29507[(12)]);
var _ = (function (){var statearr_29519 = state_29507;
(statearr_29519[(4)] = cljs.core.cons((5),(state_29507[(4)])));

return statearr_29519;
})();
var inst_29438 = _QMARK_ctx;
var inst_29439 = cljs.core.__destructure_map(inst_29438);
var inst_29440__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29439,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29441__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29439,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29442__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29439,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29443 = fluree.db.dbproto._p_prop(inst_29442__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29441__$1);
var state_29507__$1 = (function (){var statearr_29520 = state_29507;
(statearr_29520[(10)] = inst_29441__$1);

(statearr_29520[(11)] = inst_29442__$1);

(statearr_29520[(9)] = inst_29443);

(statearr_29520[(12)] = inst_29440__$1);

return statearr_29520;
})();
if(cljs.core.truth_(inst_29440__$1)){
var statearr_29521_29553 = state_29507__$1;
(statearr_29521_29553[(1)] = (6));

} else {
var statearr_29522_29554 = state_29507__$1;
(statearr_29522_29554[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (11))){
var inst_29441 = (state_29507[(10)]);
var inst_29442 = (state_29507[(11)]);
var inst_29463 = (state_29507[(2)]);
var inst_29464 = fluree.db.dbproto._p_prop(inst_29442,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29441);
var state_29507__$1 = (function (){var statearr_29524 = state_29507;
(statearr_29524[(13)] = inst_29463);

return statearr_29524;
})();
if(cljs.core.truth_(inst_29464)){
var statearr_29525_29555 = state_29507__$1;
(statearr_29525_29555[(1)] = (12));

} else {
var statearr_29526_29556 = state_29507__$1;
(statearr_29526_29556[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (9))){
var state_29507__$1 = state_29507;
var statearr_29527_29557 = state_29507__$1;
(statearr_29527_29557[(2)] = null);

(statearr_29527_29557[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (5))){
var _ = (function (){var statearr_29528 = state_29507;
(statearr_29528[(4)] = cljs.core.rest((state_29507[(4)])));

return statearr_29528;
})();
var state_29507__$1 = state_29507;
var ex29523 = (state_29507__$1[(2)]);
var statearr_29529_29558 = state_29507__$1;
(statearr_29529_29558[(5)] = ex29523);


if((ex29523 instanceof Error)){
var statearr_29530_29559 = state_29507__$1;
(statearr_29530_29559[(1)] = (4));

(statearr_29530_29559[(5)] = null);

} else {
throw ex29523;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (14))){
var inst_29442 = (state_29507[(11)]);
var inst_29443 = (state_29507[(9)]);
var inst_29440 = (state_29507[(12)]);
var inst_29474 = (state_29507[(2)]);
var inst_29475 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29478 = [inst_29440,inst_29443,"?current-val"];
var inst_29479 = (new cljs.core.PersistentVector(null,3,(5),inst_29477,inst_29478,null));
var inst_29480 = [inst_29479];
var inst_29481 = (new cljs.core.PersistentVector(null,1,(5),inst_29476,inst_29480,null));
var inst_29482 = cljs.core.PersistentHashMap.EMPTY;
var inst_29483 = ["?current-val",inst_29481,inst_29482];
var inst_29484 = cljs.core.PersistentHashMap.fromArrays(inst_29475,inst_29483);
var inst_29485 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29442,inst_29484);
var state_29507__$1 = (function (){var statearr_29531 = state_29507;
(statearr_29531[(14)] = inst_29474);

return statearr_29531;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29507__$1,(15),inst_29485);
} else {
if((state_val_29508 === (16))){
var state_29507__$1 = state_29507;
var statearr_29532_29560 = state_29507__$1;
(statearr_29532_29560[(2)] = new_val);

(statearr_29532_29560[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (10))){
var inst_29456 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29457 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29458 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29459 = cljs.core.PersistentHashMap.fromArrays(inst_29457,inst_29458);
var inst_29460 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29456,inst_29459);
var inst_29461 = (function(){throw inst_29460})();
var state_29507__$1 = state_29507;
var statearr_29533_29561 = state_29507__$1;
(statearr_29533_29561[(2)] = inst_29461);

(statearr_29533_29561[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (18))){
var inst_29502 = (state_29507[(2)]);
var _ = (function (){var statearr_29534 = state_29507;
(statearr_29534[(4)] = cljs.core.rest((state_29507[(4)])));

return statearr_29534;
})();
var state_29507__$1 = state_29507;
var statearr_29535_29562 = state_29507__$1;
(statearr_29535_29562[(2)] = inst_29502);

(statearr_29535_29562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29508 === (8))){
var inst_29443 = (state_29507[(9)]);
var inst_29453 = (state_29507[(2)]);
var state_29507__$1 = (function (){var statearr_29536 = state_29507;
(statearr_29536[(15)] = inst_29453);

return statearr_29536;
})();
if(cljs.core.truth_(inst_29443)){
var statearr_29537_29563 = state_29507__$1;
(statearr_29537_29563[(1)] = (9));

} else {
var statearr_29538_29564 = state_29507__$1;
(statearr_29538_29564[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0 = (function (){
var statearr_29539 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29539[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__);

(statearr_29539[(1)] = (1));

return statearr_29539;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1 = (function (state_29507){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29507);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29540){var ex__2687__auto__ = e29540;
var statearr_29541_29565 = state_29507;
(statearr_29541_29565[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29507[(4)]))){
var statearr_29542_29566 = state_29507;
(statearr_29542_29566[(1)] = cljs.core.first((state_29507[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29567 = state_29507;
state_29507 = G__29567;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__ = function(state_29507){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1.call(this,state_29507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29543 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29543[(6)] = c__2706__auto__);

return statearr_29543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
