// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25938 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25938,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25938,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25938,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_(fluree.db.graphdb.exclude_predicates,fluree.db.flake.p(f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement(fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__25941){
var map__25942 = p__25941;
var map__25942__$1 = cljs.core.__destructure_map(map__25942);
var opts = map__25942__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25942__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26002){
var state_val_26003 = (state_26002[(1)]);
if((state_val_26003 === (7))){
var inst_25973 = cljs.core.not(reindex_QMARK_);
var state_26002__$1 = state_26002;
var statearr_26004_26028 = state_26002__$1;
(statearr_26004_26028[(2)] = inst_25973);

(statearr_26004_26028[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26003 === (1))){
var state_26002__$1 = state_26002;
var statearr_26005_26029 = state_26002__$1;
(statearr_26005_26029[(2)] = null);

(statearr_26005_26029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26003 === (4))){
var inst_25943 = (state_26002[(2)]);
var state_26002__$1 = state_26002;
var statearr_26006_26030 = state_26002__$1;
(statearr_26006_26030[(2)] = inst_25943);

(statearr_26006_26030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26003 === (6))){
var inst_25957 = (state_26002[(7)]);
var inst_25963 = (state_26002[(8)]);
var inst_25971 = (state_26002[(9)]);
var inst_25956 = (state_26002[(2)]);
var inst_25957__$1 = fluree.db.util.async.throw_err(inst_25956);
var inst_25958 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25959 = cljs.core.__destructure_map(inst_25958);
var inst_25960 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25959,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25961 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25959,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25962 = fluree.db.flake.size_bytes(inst_25957__$1);
var inst_25963__$1 = (inst_25961 + inst_25962);
var inst_25964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25965 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25966 = (new cljs.core.PersistentVector(null,2,(5),inst_25964,inst_25965,null));
var inst_25967 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25966);
var inst_25968 = cljs.core.__destructure_map(inst_25967);
var inst_25969 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25968,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25968,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25971__$1 = (inst_25963__$1 > inst_25970);
var state_26002__$1 = (function (){var statearr_26007 = state_26002;
(statearr_26007[(10)] = inst_25969);

(statearr_26007[(11)] = inst_25960);

(statearr_26007[(7)] = inst_25957__$1);

(statearr_26007[(8)] = inst_25963__$1);

(statearr_26007[(9)] = inst_25971__$1);

return statearr_26007;
})();
if(cljs.core.truth_(inst_25971__$1)){
var statearr_26008_26031 = state_26002__$1;
(statearr_26008_26031[(1)] = (7));

} else {
var statearr_26009_26032 = state_26002__$1;
(statearr_26009_26032[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26003 === (3))){
var inst_26000 = (state_26002[(2)]);
var state_26002__$1 = state_26002;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26002__$1,inst_26000);
} else {
if((state_val_26003 === (12))){
var inst_25960 = (state_26002[(11)]);
var inst_25957 = (state_26002[(7)]);
var inst_25963 = (state_26002[(8)]);
var inst_25986 = (state_26002[(2)]);
var inst_25987 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25960,inst_25957);
var inst_25988 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25989 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_25988,cljs.core.empty);
var inst_25990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25991 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25992 = (new cljs.core.PersistentVector(null,2,(5),inst_25990,inst_25991,null));
var inst_25993 = cljs.core.assoc_in(db,inst_25992,inst_25987);
var inst_25994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25995 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25996 = (new cljs.core.PersistentVector(null,2,(5),inst_25994,inst_25995,null));
var inst_25997 = cljs.core.assoc_in(inst_25993,inst_25996,inst_25963);
var _ = (function (){var statearr_26010 = state_26002;
(statearr_26010[(4)] = cljs.core.rest((state_26002[(4)])));

return statearr_26010;
})();
var state_26002__$1 = (function (){var statearr_26011 = state_26002;
(statearr_26011[(12)] = inst_25989);

(statearr_26011[(13)] = inst_25986);

return statearr_26011;
})();
var statearr_26012_26033 = state_26002__$1;
(statearr_26012_26033[(2)] = inst_25997);

(statearr_26012_26033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26003 === (2))){
var _ = (function (){var statearr_26013 = state_26002;
(statearr_26013[(4)] = cljs.core.cons((5),(state_26002[(4)])));

return statearr_26013;
})();
var inst_25951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25952 = [pred_id];
var inst_25953 = (new cljs.core.PersistentVector(null,1,(5),inst_25951,inst_25952,null));
var inst_25954 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25953);
var state_26002__$1 = state_26002;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26002__$1,(6),inst_25954);
} else {
if((state_val_26003 === (11))){
var state_26002__$1 = state_26002;
var statearr_26015_26034 = state_26002__$1;
(statearr_26015_26034[(2)] = null);

(statearr_26015_26034[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26003 === (9))){
var inst_25976 = (state_26002[(2)]);
var state_26002__$1 = state_26002;
if(cljs.core.truth_(inst_25976)){
var statearr_26016_26035 = state_26002__$1;
(statearr_26016_26035[(1)] = (10));

} else {
var statearr_26017_26036 = state_26002__$1;
(statearr_26017_26036[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26003 === (5))){
var _ = (function (){var statearr_26018 = state_26002;
(statearr_26018[(4)] = cljs.core.rest((state_26002[(4)])));

return statearr_26018;
})();
var state_26002__$1 = state_26002;
var ex26014 = (state_26002__$1[(2)]);
var statearr_26019_26037 = state_26002__$1;
(statearr_26019_26037[(5)] = ex26014);


if((ex26014 instanceof Error)){
var statearr_26020_26038 = state_26002__$1;
(statearr_26020_26038[(1)] = (4));

(statearr_26020_26038[(5)] = null);

} else {
throw ex26014;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26003 === (10))){
var inst_25978 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25979 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25980 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25981 = cljs.core.PersistentHashMap.fromArrays(inst_25979,inst_25980);
var inst_25982 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25978,inst_25981);
var inst_25983 = (function(){throw inst_25982})();
var state_26002__$1 = state_26002;
var statearr_26021_26039 = state_26002__$1;
(statearr_26021_26039[(2)] = inst_25983);

(statearr_26021_26039[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26003 === (8))){
var inst_25971 = (state_26002[(9)]);
var state_26002__$1 = state_26002;
var statearr_26022_26040 = state_26002__$1;
(statearr_26022_26040[(2)] = inst_25971);

(statearr_26022_26040[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0 = (function (){
var statearr_26023 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26023[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__);

(statearr_26023[(1)] = (1));

return statearr_26023;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1 = (function (state_26002){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26002);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26024){var ex__2687__auto__ = e26024;
var statearr_26025_26041 = state_26002;
(statearr_26025_26041[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26002[(4)]))){
var statearr_26026_26042 = state_26002;
(statearr_26026_26042[(1)] = cljs.core.first((state_26002[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26043 = state_26002;
state_26002 = G__26043;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__ = function(state_26002){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1.call(this,state_26002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26027 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26027[(6)] = c__2706__auto__);

return statearr_26027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__26046 = arguments.length;
switch (G__26046) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26246){
var state_val_26247 = (state_26246[(1)]);
if((state_val_26247 === (7))){
var state_26246__$1 = state_26246;
var statearr_26248_26315 = state_26246__$1;
(statearr_26248_26315[(2)] = null);

(statearr_26248_26315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (20))){
var inst_26168 = (state_26246[(7)]);
var inst_26166 = (state_26246[(8)]);
var inst_26133 = (state_26246[(9)]);
var inst_26169 = (state_26246[(10)]);
var inst_26082 = (state_26246[(11)]);
var inst_26083 = (state_26246[(12)]);
var inst_26171 = (state_26246[(13)]);
var inst_26170 = (state_26246[(14)]);
var inst_26167 = (state_26246[(15)]);
var inst_26181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26182 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26183 = (new cljs.core.PersistentVector(null,2,(5),inst_26181,inst_26182,null));
var inst_26184 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26133,inst_26183);
var inst_26185 = (inst_26184 + inst_26082);
var inst_26186 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26187 = [inst_26166,inst_26167,inst_26168,inst_26169,inst_26170,inst_26185];
var inst_26188 = cljs.core.PersistentHashMap.fromArrays(inst_26186,inst_26187);
var inst_26189 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_26133,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26171,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26188], 0));
var state_26246__$1 = (function (){var statearr_26249 = state_26246;
(statearr_26249[(16)] = inst_26189);

return statearr_26249;
})();
if(cljs.core.truth_(inst_26083)){
var statearr_26250_26316 = state_26246__$1;
(statearr_26250_26316[(1)] = (23));

} else {
var statearr_26251_26317 = state_26246__$1;
(statearr_26251_26317[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (27))){
var inst_26189 = (state_26246[(16)]);
var state_26246__$1 = state_26246;
var statearr_26252_26318 = state_26246__$1;
(statearr_26252_26318[(2)] = inst_26189);

(statearr_26252_26318[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (1))){
var state_26246__$1 = state_26246;
var statearr_26253_26319 = state_26246__$1;
(statearr_26253_26319[(2)] = null);

(statearr_26253_26319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (24))){
var inst_26189 = (state_26246[(16)]);
var inst_26193 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26189);
var inst_26194 = (inst_26193 == null);
var state_26246__$1 = state_26246;
var statearr_26254_26320 = state_26246__$1;
(statearr_26254_26320[(2)] = inst_26194);

(statearr_26254_26320[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (39))){
var inst_26219 = (state_26246[(17)]);
var inst_26228 = (state_26246[(18)]);
var inst_26177 = (state_26246[(19)]);
var inst_26178 = (state_26246[(20)]);
var inst_26170 = (state_26246[(14)]);
var inst_26220 = (state_26246[(21)]);
var inst_26221 = (state_26246[(22)]);
var inst_26235 = (state_26246[(2)]);
var inst_26236 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26170,inst_26177);
var inst_26165 = inst_26178;
var inst_26166 = inst_26220;
var inst_26167 = inst_26221;
var inst_26168 = inst_26228;
var inst_26169 = inst_26235;
var inst_26170__$1 = inst_26236;
var inst_26171 = inst_26219;
var state_26246__$1 = (function (){var statearr_26255 = state_26246;
(statearr_26255[(7)] = inst_26168);

(statearr_26255[(8)] = inst_26166);

(statearr_26255[(10)] = inst_26169);

(statearr_26255[(13)] = inst_26171);

(statearr_26255[(23)] = inst_26165);

(statearr_26255[(14)] = inst_26170__$1);

(statearr_26255[(15)] = inst_26167);

return statearr_26255;
})();
var statearr_26256_26321 = state_26246__$1;
(statearr_26256_26321[(2)] = null);

(statearr_26256_26321[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (4))){
var inst_26047 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26257_26322 = state_26246__$1;
(statearr_26257_26322[(2)] = inst_26047);

(statearr_26257_26322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (15))){
var inst_26105 = (state_26246[(24)]);
var state_26246__$1 = state_26246;
var statearr_26258_26323 = state_26246__$1;
(statearr_26258_26323[(2)] = inst_26105);

(statearr_26258_26323[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (21))){
var inst_26168 = (state_26246[(7)]);
var inst_26073 = (state_26246[(25)]);
var inst_26142 = (state_26246[(26)]);
var inst_26166 = (state_26246[(8)]);
var inst_26054 = (state_26246[(27)]);
var inst_26143 = (state_26246[(28)]);
var inst_26133 = (state_26246[(9)]);
var inst_26177 = (state_26246[(19)]);
var inst_26169 = (state_26246[(10)]);
var inst_26077 = (state_26246[(29)]);
var inst_26082 = (state_26246[(11)]);
var inst_26084 = (state_26246[(30)]);
var inst_26086 = (state_26246[(31)]);
var inst_26081 = (state_26246[(32)]);
var inst_26083 = (state_26246[(12)]);
var inst_26070 = (state_26246[(33)]);
var inst_26178 = (state_26246[(20)]);
var inst_26171 = (state_26246[(13)]);
var inst_26092 = (state_26246[(34)]);
var inst_26165 = (state_26246[(23)]);
var inst_26170 = (state_26246[(14)]);
var inst_26167 = (state_26246[(15)]);
var inst_26069 = (state_26246[(35)]);
var inst_26216 = fluree.db.flake.s(inst_26177);
var inst_26217 = fluree.db.flake.sid__GT_cid(inst_26216);
var inst_26218 = (function (){var flakes_bytes = inst_26082;
var G__26137 = inst_26165;
var t = inst_26054;
var vec__26138 = inst_26070;
var spot = inst_26166;
var add_flakes = inst_26070;
var first__26140 = inst_26142;
var vec__26173 = inst_26165;
var seq__26174 = inst_26178;
var root_setting_change_QMARK_ = inst_26084;
var ref_QMARK__map = inst_26081;
var r = inst_26178;
var seq__26139 = inst_26143;
var psot = inst_26167;
var add_pred_to_idx_QMARK_ = inst_26092;
var _ = inst_26069;
var tspo = inst_26170;
var cid = inst_26217;
var ecount = inst_26171;
var pred_ecount = inst_26086;
var first__26175 = inst_26177;
var db_STAR_ = inst_26133;
var system_change_QMARK_ = inst_26083;
var add_preds = inst_26073;
var opst = inst_26169;
var idx_QMARK__map = inst_26077;
var post = inst_26168;
var f = inst_26177;
return (function (p1__26044_SHARP_){
if(cljs.core.truth_(p1__26044_SHARP_)){
var x__5130__auto__ = p1__26044_SHARP_;
var y__5131__auto__ = fluree.db.flake.s(f);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return fluree.db.flake.s(f);
}
});
})();
var inst_26219 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_26171,inst_26217,inst_26218);
var inst_26220 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26166,inst_26177);
var inst_26221 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26167,inst_26177);
var inst_26222 = fluree.db.flake.p(inst_26177);
var inst_26223 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26077,inst_26222);
var state_26246__$1 = (function (){var statearr_26259 = state_26246;
(statearr_26259[(17)] = inst_26219);

(statearr_26259[(21)] = inst_26220);

(statearr_26259[(22)] = inst_26221);

return statearr_26259;
})();
if(cljs.core.truth_(inst_26223)){
var statearr_26260_26324 = state_26246__$1;
(statearr_26260_26324[(1)] = (34));

} else {
var statearr_26261_26325 = state_26246__$1;
(statearr_26261_26325[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (31))){
var inst_26205 = (state_26246[(36)]);
var state_26246__$1 = state_26246;
var statearr_26262_26326 = state_26246__$1;
(statearr_26262_26326[(2)] = inst_26205);

(statearr_26262_26326[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (32))){
var inst_26214 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26263_26327 = state_26246__$1;
(statearr_26263_26327[(2)] = inst_26214);

(statearr_26263_26327[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (33))){
var inst_26205 = (state_26246[(36)]);
var inst_26209 = (state_26246[(2)]);
var inst_26210 = fluree.db.util.async.throw_err(inst_26209);
var inst_26211 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26205,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26210);
var state_26246__$1 = state_26246;
var statearr_26264_26328 = state_26246__$1;
(statearr_26264_26328[(2)] = inst_26211);

(statearr_26264_26328[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (13))){
var inst_26054 = (state_26246[(27)]);
var inst_26133 = (state_26246[(9)]);
var inst_26082 = (state_26246[(11)]);
var inst_26070 = (state_26246[(33)]);
var inst_26123 = (state_26246[(2)]);
var inst_26124 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26123,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26054);
var inst_26125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26126 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26127 = (new cljs.core.PersistentVector(null,2,(5),inst_26125,inst_26126,null));
var inst_26128 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26124,inst_26127,cljs.core._PLUS_,inst_26082);
var inst_26129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26130 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26131 = (new cljs.core.PersistentVector(null,2,(5),inst_26129,inst_26130,null));
var inst_26132 = cljs.core.count(inst_26070);
var inst_26133__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26128,inst_26131,cljs.core._PLUS_,inst_26132);
var inst_26141 = cljs.core.seq(inst_26070);
var inst_26142 = cljs.core.first(inst_26141);
var inst_26143 = cljs.core.next(inst_26141);
var inst_26144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26145 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26146 = (new cljs.core.PersistentVector(null,2,(5),inst_26144,inst_26145,null));
var inst_26147 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26133__$1,inst_26146);
var inst_26148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26149 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26150 = (new cljs.core.PersistentVector(null,2,(5),inst_26148,inst_26149,null));
var inst_26151 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26133__$1,inst_26150);
var inst_26152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26153 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26154 = (new cljs.core.PersistentVector(null,2,(5),inst_26152,inst_26153,null));
var inst_26155 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26133__$1,inst_26154);
var inst_26156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26157 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26158 = (new cljs.core.PersistentVector(null,2,(5),inst_26156,inst_26157,null));
var inst_26159 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26133__$1,inst_26158);
var inst_26160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26161 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_26162 = (new cljs.core.PersistentVector(null,2,(5),inst_26160,inst_26161,null));
var inst_26163 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26133__$1,inst_26162);
var inst_26164 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26165 = inst_26070;
var inst_26166 = inst_26147;
var inst_26167 = inst_26151;
var inst_26168 = inst_26155;
var inst_26169 = inst_26159;
var inst_26170 = inst_26163;
var inst_26171 = inst_26164;
var state_26246__$1 = (function (){var statearr_26265 = state_26246;
(statearr_26265[(7)] = inst_26168);

(statearr_26265[(26)] = inst_26142);

(statearr_26265[(8)] = inst_26166);

(statearr_26265[(28)] = inst_26143);

(statearr_26265[(9)] = inst_26133__$1);

(statearr_26265[(10)] = inst_26169);

(statearr_26265[(13)] = inst_26171);

(statearr_26265[(23)] = inst_26165);

(statearr_26265[(14)] = inst_26170);

(statearr_26265[(15)] = inst_26167);

return statearr_26265;
})();
var statearr_26266_26329 = state_26246__$1;
(statearr_26266_26329[(2)] = null);

(statearr_26266_26329[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (22))){
var inst_26239 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26267_26330 = state_26246__$1;
(statearr_26267_26330[(2)] = inst_26239);

(statearr_26267_26330[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (36))){
var inst_26177 = (state_26246[(19)]);
var inst_26081 = (state_26246[(32)]);
var inst_26228 = (state_26246[(2)]);
var inst_26229 = fluree.db.flake.p(inst_26177);
var inst_26230 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26081,inst_26229);
var state_26246__$1 = (function (){var statearr_26268 = state_26246;
(statearr_26268[(18)] = inst_26228);

return statearr_26268;
})();
if(cljs.core.truth_(inst_26230)){
var statearr_26269_26331 = state_26246__$1;
(statearr_26269_26331[(1)] = (37));

} else {
var statearr_26270_26332 = state_26246__$1;
(statearr_26270_26332[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (29))){
var inst_26189 = (state_26246[(16)]);
var inst_26200 = (state_26246[(2)]);
var inst_26201 = fluree.db.util.async.throw_err(inst_26200);
var inst_26202 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26189,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26201);
var state_26246__$1 = state_26246;
var statearr_26271_26333 = state_26246__$1;
(statearr_26271_26333[(2)] = inst_26202);

(statearr_26271_26333[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (6))){
var inst_26054 = (state_26246[(27)]);
var inst_26059 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_26060 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26061 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26059)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26060)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26054),"."].join('');
var inst_26062 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26063 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26064 = cljs.core.PersistentHashMap.fromArrays(inst_26062,inst_26063);
var inst_26065 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26061,inst_26064);
var inst_26066 = (function(){throw inst_26065})();
var state_26246__$1 = state_26246;
var statearr_26272_26334 = state_26246__$1;
(statearr_26272_26334[(2)] = inst_26066);

(statearr_26272_26334[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (28))){
var inst_26084 = (state_26246[(30)]);
var inst_26205 = (state_26246[(2)]);
var state_26246__$1 = (function (){var statearr_26273 = state_26246;
(statearr_26273[(36)] = inst_26205);

return statearr_26273;
})();
if(cljs.core.truth_(inst_26084)){
var statearr_26274_26335 = state_26246__$1;
(statearr_26274_26335[(1)] = (30));

} else {
var statearr_26275_26336 = state_26246__$1;
(statearr_26275_26336[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (25))){
var inst_26196 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
if(cljs.core.truth_(inst_26196)){
var statearr_26276_26337 = state_26246__$1;
(statearr_26276_26337[(1)] = (26));

} else {
var statearr_26277_26338 = state_26246__$1;
(statearr_26277_26338[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (34))){
var inst_26168 = (state_26246[(7)]);
var inst_26177 = (state_26246[(19)]);
var inst_26225 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26168,inst_26177);
var state_26246__$1 = state_26246;
var statearr_26278_26339 = state_26246__$1;
(statearr_26278_26339[(2)] = inst_26225);

(statearr_26278_26339[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (17))){
var inst_26112 = (state_26246[(37)]);
var inst_26116 = (state_26246[(2)]);
var inst_26117 = fluree.db.util.async.throw_err(inst_26116);
var inst_26104 = inst_26112;
var inst_26105 = inst_26117;
var state_26246__$1 = (function (){var statearr_26279 = state_26246;
(statearr_26279[(24)] = inst_26105);

(statearr_26279[(38)] = inst_26104);

return statearr_26279;
})();
var statearr_26280_26340 = state_26246__$1;
(statearr_26280_26340[(2)] = null);

(statearr_26280_26340[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (3))){
var inst_26244 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26246__$1,inst_26244);
} else {
if((state_val_26247 === (12))){
var inst_26111 = (state_26246[(39)]);
var inst_26104 = (state_26246[(38)]);
var inst_26110 = cljs.core.seq(inst_26104);
var inst_26111__$1 = cljs.core.first(inst_26110);
var inst_26112 = cljs.core.next(inst_26110);
var state_26246__$1 = (function (){var statearr_26281 = state_26246;
(statearr_26281[(39)] = inst_26111__$1);

(statearr_26281[(37)] = inst_26112);

return statearr_26281;
})();
if(cljs.core.truth_(inst_26111__$1)){
var statearr_26282_26341 = state_26246__$1;
(statearr_26282_26341[(1)] = (14));

} else {
var statearr_26283_26342 = state_26246__$1;
(statearr_26283_26342[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (2))){
var inst_26054 = (state_26246[(27)]);
var _ = (function (){var statearr_26284 = state_26246;
(statearr_26284[(4)] = cljs.core.cons((5),(state_26246[(4)])));

return statearr_26284;
})();
var inst_26053 = cljs.core.first(flakes);
var inst_26054__$1 = fluree.db.flake.t(inst_26053);
var inst_26055 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26056 = (inst_26055 - (1));
var inst_26057 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_26054__$1,inst_26056);
var state_26246__$1 = (function (){var statearr_26285 = state_26246;
(statearr_26285[(27)] = inst_26054__$1);

return statearr_26285;
})();
if(inst_26057){
var statearr_26286_26343 = state_26246__$1;
(statearr_26286_26343[(1)] = (6));

} else {
var statearr_26287_26344 = state_26246__$1;
(statearr_26287_26344[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (23))){
var inst_26083 = (state_26246[(12)]);
var state_26246__$1 = state_26246;
var statearr_26288_26345 = state_26246__$1;
(statearr_26288_26345[(2)] = inst_26083);

(statearr_26288_26345[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (35))){
var inst_26168 = (state_26246[(7)]);
var state_26246__$1 = state_26246;
var statearr_26289_26346 = state_26246__$1;
(statearr_26289_26346[(2)] = inst_26168);

(statearr_26289_26346[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (19))){
var inst_26241 = (state_26246[(2)]);
var _ = (function (){var statearr_26290 = state_26246;
(statearr_26290[(4)] = cljs.core.rest((state_26246[(4)])));

return statearr_26290;
})();
var state_26246__$1 = state_26246;
var statearr_26291_26347 = state_26246__$1;
(statearr_26291_26347[(2)] = inst_26241);

(statearr_26291_26347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (11))){
var inst_26092 = (state_26246[(34)]);
var inst_26092__$1 = (state_26246[(2)]);
var inst_26100 = cljs.core.seq(inst_26092__$1);
var inst_26101 = cljs.core.first(inst_26100);
var inst_26102 = cljs.core.next(inst_26100);
var inst_26103 = db;
var inst_26104 = inst_26092__$1;
var inst_26105 = inst_26103;
var state_26246__$1 = (function (){var statearr_26293 = state_26246;
(statearr_26293[(40)] = inst_26101);

(statearr_26293[(24)] = inst_26105);

(statearr_26293[(38)] = inst_26104);

(statearr_26293[(34)] = inst_26092__$1);

(statearr_26293[(41)] = inst_26102);

return statearr_26293;
})();
var statearr_26294_26348 = state_26246__$1;
(statearr_26294_26348[(2)] = null);

(statearr_26294_26348[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (9))){
var inst_26086 = (state_26246[(31)]);
var inst_26070 = (state_26246[(33)]);
var inst_26088 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_26070,inst_26086);
var state_26246__$1 = state_26246;
var statearr_26295_26349 = state_26246__$1;
(statearr_26295_26349[(2)] = inst_26088);

(statearr_26295_26349[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (5))){
var _ = (function (){var statearr_26296 = state_26246;
(statearr_26296[(4)] = cljs.core.rest((state_26246[(4)])));

return statearr_26296;
})();
var state_26246__$1 = state_26246;
var ex26292 = (state_26246__$1[(2)]);
var statearr_26297_26350 = state_26246__$1;
(statearr_26297_26350[(5)] = ex26292);


if((ex26292 instanceof Error)){
var statearr_26298_26351 = state_26246__$1;
(statearr_26298_26351[(1)] = (4));

(statearr_26298_26351[(5)] = null);

} else {
throw ex26292;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (14))){
var inst_26105 = (state_26246[(24)]);
var inst_26111 = (state_26246[(39)]);
var inst_26114 = fluree.db.graphdb.add_predicate_to_idx(inst_26105,inst_26111,opts);
var state_26246__$1 = state_26246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26246__$1,(17),inst_26114);
} else {
if((state_val_26247 === (26))){
var inst_26189 = (state_26246[(16)]);
var inst_26198 = fluree.db.query.schema.schema_map(inst_26189);
var state_26246__$1 = state_26246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26246__$1,(29),inst_26198);
} else {
if((state_val_26247 === (16))){
var inst_26121 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26299_26352 = state_26246__$1;
(statearr_26299_26352[(2)] = inst_26121);

(statearr_26299_26352[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (38))){
var inst_26169 = (state_26246[(10)]);
var state_26246__$1 = state_26246;
var statearr_26300_26353 = state_26246__$1;
(statearr_26300_26353[(2)] = inst_26169);

(statearr_26300_26353[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (30))){
var inst_26189 = (state_26246[(16)]);
var inst_26207 = fluree.db.query.schema.setting_map(inst_26189);
var state_26246__$1 = state_26246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26246__$1,(33),inst_26207);
} else {
if((state_val_26247 === (10))){
var inst_26090 = cljs.core.PersistentVector.EMPTY;
var state_26246__$1 = state_26246;
var statearr_26301_26354 = state_26246__$1;
(statearr_26301_26354[(2)] = inst_26090);

(statearr_26301_26354[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (18))){
var inst_26177 = (state_26246[(19)]);
var inst_26165 = (state_26246[(23)]);
var inst_26176 = cljs.core.seq(inst_26165);
var inst_26177__$1 = cljs.core.first(inst_26176);
var inst_26178 = cljs.core.next(inst_26176);
var inst_26179 = cljs.core.not(inst_26177__$1);
var state_26246__$1 = (function (){var statearr_26302 = state_26246;
(statearr_26302[(19)] = inst_26177__$1);

(statearr_26302[(20)] = inst_26178);

return statearr_26302;
})();
if(inst_26179){
var statearr_26303_26355 = state_26246__$1;
(statearr_26303_26355[(1)] = (20));

} else {
var statearr_26304_26356 = state_26246__$1;
(statearr_26304_26356[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (37))){
var inst_26177 = (state_26246[(19)]);
var inst_26169 = (state_26246[(10)]);
var inst_26232 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26169,inst_26177);
var state_26246__$1 = state_26246;
var statearr_26305_26357 = state_26246__$1;
(statearr_26305_26357[(2)] = inst_26232);

(statearr_26305_26357[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (8))){
var inst_26073 = (state_26246[(25)]);
var inst_26054 = (state_26246[(27)]);
var inst_26077 = (state_26246[(29)]);
var inst_26083 = (state_26246[(12)]);
var inst_26070 = (state_26246[(33)]);
var inst_26069 = (state_26246[(35)]);
var inst_26069__$1 = (state_26246[(2)]);
var inst_26070__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_26071 = cljs.core.PersistentHashSet.EMPTY;
var inst_26072 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,inst_26070__$1);
var inst_26073__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26071,inst_26072);
var inst_26074 = cljs.core.PersistentHashMap.EMPTY;
var inst_26075 = (function (){var t = inst_26054;
var _ = inst_26069__$1;
var add_flakes = inst_26070__$1;
var add_preds = inst_26073__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26076 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26075,inst_26073__$1);
var inst_26077__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26074,inst_26076);
var inst_26078 = cljs.core.PersistentHashMap.EMPTY;
var inst_26079 = (function (){var t = inst_26054;
var _ = inst_26069__$1;
var add_flakes = inst_26070__$1;
var add_preds = inst_26073__$1;
var idx_QMARK__map = inst_26077__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26080 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26079,inst_26073__$1);
var inst_26081 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26078,inst_26080);
var inst_26082 = fluree.db.flake.size_bytes(inst_26070__$1);
var inst_26083__$1 = fluree.db.util.schema.system_change_QMARK_(inst_26070__$1);
var inst_26084 = fluree.db.util.schema.setting_change_QMARK_(inst_26070__$1);
var inst_26085 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26086 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26085,(0));
var state_26246__$1 = (function (){var statearr_26306 = state_26246;
(statearr_26306[(25)] = inst_26073__$1);

(statearr_26306[(29)] = inst_26077__$1);

(statearr_26306[(11)] = inst_26082);

(statearr_26306[(30)] = inst_26084);

(statearr_26306[(31)] = inst_26086);

(statearr_26306[(32)] = inst_26081);

(statearr_26306[(12)] = inst_26083__$1);

(statearr_26306[(33)] = inst_26070__$1);

(statearr_26306[(35)] = inst_26069__$1);

return statearr_26306;
})();
if(cljs.core.truth_(inst_26083__$1)){
var statearr_26307_26358 = state_26246__$1;
(statearr_26307_26358[(1)] = (9));

} else {
var statearr_26308_26359 = state_26246__$1;
(statearr_26308_26359[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26309 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26309[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26309[(1)] = (1));

return statearr_26309;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26246){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26246);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26310){var ex__2687__auto__ = e26310;
var statearr_26311_26360 = state_26246;
(statearr_26311_26360[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26246[(4)]))){
var statearr_26312_26361 = state_26246;
(statearr_26312_26361[(1)] = cljs.core.first((state_26246[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26362 = state_26246;
state_26246 = G__26362;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26246){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26313 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26313[(6)] = c__2706__auto__);

return statearr_26313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26364 = arguments.length;
switch (G__26364) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___26511 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26460){
var state_val_26461 = (state_26460[(1)]);
if((state_val_26461 === (7))){
var state_26460__$1 = state_26460;
var statearr_26462_26512 = state_26460__$1;
(statearr_26462_26512[(2)] = null);

(statearr_26462_26512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (20))){
var inst_26408 = (state_26460[(7)]);
var inst_26409 = (state_26460[(8)]);
var inst_26410 = (state_26460[(9)]);
var inst_26429 = (inst_26408 + (1));
var inst_26430 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26410,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26429);
var inst_26431 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_26430,inst_26409,opts);
var state_26460__$1 = state_26460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26460__$1,(23),inst_26431);
} else {
if((state_val_26461 === (1))){
var state_26460__$1 = state_26460;
var statearr_26463_26513 = state_26460__$1;
(statearr_26463_26513[(2)] = null);

(statearr_26463_26513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (24))){
var inst_26434 = (state_26460[(10)]);
var inst_26437 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26434,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26460__$1 = state_26460;
var statearr_26464_26514 = state_26460__$1;
(statearr_26464_26514[(2)] = inst_26437);

(statearr_26464_26514[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (4))){
var inst_26365 = (state_26460[(2)]);
var inst_26366 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26365);
var state_26460__$1 = state_26460;
var statearr_26465_26515 = state_26460__$1;
(statearr_26465_26515[(2)] = inst_26366);

(statearr_26465_26515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (15))){
var inst_26416 = (state_26460[(11)]);
var state_26460__$1 = state_26460;
var statearr_26466_26516 = state_26460__$1;
(statearr_26466_26516[(2)] = inst_26416);

(statearr_26466_26516[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (21))){
var state_26460__$1 = state_26460;
var statearr_26467_26517 = state_26460__$1;
(statearr_26467_26517[(2)] = null);

(statearr_26467_26517[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (13))){
var inst_26452 = (state_26460[(2)]);
var inst_26453 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26452);
var state_26460__$1 = state_26460;
var statearr_26468_26518 = state_26460__$1;
(statearr_26468_26518[(2)] = inst_26453);

(statearr_26468_26518[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (22))){
var inst_26448 = (state_26460[(2)]);
var state_26460__$1 = state_26460;
var statearr_26469_26519 = state_26460__$1;
(statearr_26469_26519[(2)] = inst_26448);

(statearr_26469_26519[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (6))){
var inst_26376 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_26377 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26378 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26376)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26377)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26379 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26380 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26381 = cljs.core.PersistentHashMap.fromArrays(inst_26379,inst_26380);
var inst_26382 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26378,inst_26381);
var inst_26383 = (function(){throw inst_26382})();
var state_26460__$1 = state_26460;
var statearr_26472_26520 = state_26460__$1;
(statearr_26472_26520[(2)] = inst_26383);

(statearr_26472_26520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (25))){
var inst_26416 = (state_26460[(11)]);
var inst_26434 = (state_26460[(10)]);
var inst_26417 = (state_26460[(12)]);
var inst_26439 = fluree.db.flake.t(inst_26416);
var inst_26440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26441 = [inst_26416];
var inst_26442 = (new cljs.core.PersistentVector(null,1,(5),inst_26440,inst_26441,null));
var inst_26407 = inst_26417;
var inst_26408 = inst_26439;
var inst_26409 = inst_26442;
var inst_26410 = inst_26434;
var state_26460__$1 = (function (){var statearr_26473 = state_26460;
(statearr_26473[(7)] = inst_26408);

(statearr_26473[(13)] = inst_26407);

(statearr_26473[(8)] = inst_26409);

(statearr_26473[(9)] = inst_26410);

return statearr_26473;
})();
var statearr_26474_26521 = state_26460__$1;
(statearr_26474_26521[(2)] = null);

(statearr_26474_26521[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (17))){
var inst_26408 = (state_26460[(7)]);
var inst_26416 = (state_26460[(11)]);
var inst_26409 = (state_26460[(8)]);
var inst_26410 = (state_26460[(9)]);
var inst_26417 = (state_26460[(12)]);
var inst_26425 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26409,inst_26416);
var tmp26470 = inst_26408;
var tmp26471 = inst_26410;
var inst_26407 = inst_26417;
var inst_26408__$1 = tmp26470;
var inst_26409__$1 = inst_26425;
var inst_26410__$1 = tmp26471;
var state_26460__$1 = (function (){var statearr_26475 = state_26460;
(statearr_26475[(7)] = inst_26408__$1);

(statearr_26475[(13)] = inst_26407);

(statearr_26475[(8)] = inst_26409__$1);

(statearr_26475[(9)] = inst_26410__$1);

return statearr_26475;
})();
var statearr_26476_26522 = state_26460__$1;
(statearr_26476_26522[(2)] = null);

(statearr_26476_26522[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (3))){
var inst_26458 = (state_26460[(2)]);
var state_26460__$1 = state_26460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26460__$1,inst_26458);
} else {
if((state_val_26461 === (12))){
var inst_26407 = (state_26460[(13)]);
var inst_26416 = (state_26460[(11)]);
var inst_26415 = cljs.core.seq(inst_26407);
var inst_26416__$1 = cljs.core.first(inst_26415);
var inst_26417 = cljs.core.next(inst_26415);
var state_26460__$1 = (function (){var statearr_26477 = state_26460;
(statearr_26477[(11)] = inst_26416__$1);

(statearr_26477[(12)] = inst_26417);

return statearr_26477;
})();
if(cljs.core.truth_(inst_26416__$1)){
var statearr_26478_26523 = state_26460__$1;
(statearr_26478_26523[(1)] = (14));

} else {
var statearr_26479_26524 = state_26460__$1;
(statearr_26479_26524[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (2))){
var _ = (function (){var statearr_26480 = state_26460;
(statearr_26480[(4)] = cljs.core.cons((5),(state_26460[(4)])));

return statearr_26480;
})();
var inst_26372 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26373 = (inst_26372 + (1));
var inst_26374 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_26373);
var state_26460__$1 = state_26460;
if(inst_26374){
var statearr_26481_26525 = state_26460__$1;
(statearr_26481_26525[(1)] = (6));

} else {
var statearr_26482_26526 = state_26460__$1;
(statearr_26482_26526[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (23))){
var inst_26416 = (state_26460[(11)]);
var inst_26433 = (state_26460[(2)]);
var inst_26434 = fluree.db.util.async.throw_err(inst_26433);
var inst_26435 = (inst_26416 == null);
var state_26460__$1 = (function (){var statearr_26483 = state_26460;
(statearr_26483[(10)] = inst_26434);

return statearr_26483;
})();
if(cljs.core.truth_(inst_26435)){
var statearr_26484_26527 = state_26460__$1;
(statearr_26484_26527[(1)] = (24));

} else {
var statearr_26485_26528 = state_26460__$1;
(statearr_26485_26528[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (19))){
var inst_26450 = (state_26460[(2)]);
var state_26460__$1 = state_26460;
var statearr_26486_26529 = state_26460__$1;
(statearr_26486_26529[(2)] = inst_26450);

(statearr_26486_26529[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (11))){
var inst_26455 = (state_26460[(2)]);
var _ = (function (){var statearr_26488 = state_26460;
(statearr_26488[(4)] = cljs.core.rest((state_26460[(4)])));

return statearr_26488;
})();
var state_26460__$1 = state_26460;
var statearr_26489_26530 = state_26460__$1;
(statearr_26489_26530[(2)] = inst_26455);

(statearr_26489_26530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (9))){
var inst_26389 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26390 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26389);
var state_26460__$1 = state_26460;
var statearr_26490_26531 = state_26460__$1;
(statearr_26490_26531[(2)] = inst_26390);

(statearr_26490_26531[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (5))){
var _ = (function (){var statearr_26491 = state_26460;
(statearr_26491[(4)] = cljs.core.rest((state_26460[(4)])));

return statearr_26491;
})();
var state_26460__$1 = state_26460;
var ex26487 = (state_26460__$1[(2)]);
var statearr_26492_26532 = state_26460__$1;
(statearr_26492_26532[(5)] = ex26487);


var statearr_26493_26533 = state_26460__$1;
(statearr_26493_26533[(1)] = (4));

(statearr_26493_26533[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (14))){
var inst_26408 = (state_26460[(7)]);
var inst_26416 = (state_26460[(11)]);
var inst_26419 = fluree.db.flake.t(inst_26416);
var inst_26420 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26408,inst_26419);
var state_26460__$1 = state_26460;
var statearr_26494_26534 = state_26460__$1;
(statearr_26494_26534[(2)] = inst_26420);

(statearr_26494_26534[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (26))){
var inst_26445 = (state_26460[(2)]);
var state_26460__$1 = state_26460;
var statearr_26495_26535 = state_26460__$1;
(statearr_26495_26535[(2)] = inst_26445);

(statearr_26495_26535[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (16))){
var inst_26423 = (state_26460[(2)]);
var state_26460__$1 = state_26460;
if(cljs.core.truth_(inst_26423)){
var statearr_26496_26536 = state_26460__$1;
(statearr_26496_26536[(1)] = (17));

} else {
var statearr_26497_26537 = state_26460__$1;
(statearr_26497_26537[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (10))){
var inst_26392 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_26400 = cljs.core.seq(inst_26392);
var inst_26401 = cljs.core.first(inst_26400);
var inst_26402 = cljs.core.next(inst_26400);
var inst_26403 = cljs.core.first(inst_26392);
var inst_26404 = fluree.db.flake.t(inst_26403);
var inst_26405 = cljs.core.PersistentVector.EMPTY;
var inst_26406 = db;
var inst_26407 = inst_26392;
var inst_26408 = inst_26404;
var inst_26409 = inst_26405;
var inst_26410 = inst_26406;
var state_26460__$1 = (function (){var statearr_26498 = state_26460;
(statearr_26498[(7)] = inst_26408);

(statearr_26498[(14)] = inst_26401);

(statearr_26498[(13)] = inst_26407);

(statearr_26498[(8)] = inst_26409);

(statearr_26498[(15)] = inst_26402);

(statearr_26498[(9)] = inst_26410);

return statearr_26498;
})();
var statearr_26499_26538 = state_26460__$1;
(statearr_26499_26538[(2)] = null);

(statearr_26499_26538[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (18))){
var state_26460__$1 = state_26460;
var statearr_26500_26539 = state_26460__$1;
(statearr_26500_26539[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26461 === (8))){
var inst_26386 = (state_26460[(2)]);
var inst_26387 = cljs.core.empty_QMARK_(flakes);
var state_26460__$1 = (function (){var statearr_26502 = state_26460;
(statearr_26502[(16)] = inst_26386);

return statearr_26502;
})();
if(inst_26387){
var statearr_26503_26540 = state_26460__$1;
(statearr_26503_26540[(1)] = (9));

} else {
var statearr_26504_26541 = state_26460__$1;
(statearr_26504_26541[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26505 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26505[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26505[(1)] = (1));

return statearr_26505;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26460){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26460);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26506){var ex__2687__auto__ = e26506;
var statearr_26507_26542 = state_26460;
(statearr_26507_26542[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26460[(4)]))){
var statearr_26508_26543 = state_26460;
(statearr_26508_26543[(1)] = cljs.core.first((state_26460[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26544 = state_26460;
state_26460 = G__26544;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26460){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26509 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26509[(6)] = c__2706__auto___26511);

return statearr_26509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26596){
var state_val_26597 = (state_26596[(1)]);
if((state_val_26597 === (7))){
var state_26596__$1 = state_26596;
var statearr_26598_26625 = state_26596__$1;
(statearr_26598_26625[(2)] = tt_id);

(statearr_26598_26625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (1))){
var state_26596__$1 = state_26596;
var statearr_26599_26626 = state_26596__$1;
(statearr_26599_26626[(2)] = null);

(statearr_26599_26626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (4))){
var inst_26545 = (state_26596[(2)]);
var state_26596__$1 = state_26596;
var statearr_26600_26627 = state_26596__$1;
(statearr_26600_26627[(2)] = inst_26545);

(statearr_26600_26627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (13))){
var inst_26589 = (state_26596[(2)]);
var state_26596__$1 = state_26596;
var statearr_26601_26628 = state_26596__$1;
(statearr_26601_26628[(2)] = inst_26589);

(statearr_26601_26628[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (6))){
var inst_26553 = cljs.core.random_uuid();
var state_26596__$1 = state_26596;
var statearr_26602_26629 = state_26596__$1;
(statearr_26602_26629[(2)] = inst_26553);

(statearr_26602_26629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (3))){
var inst_26594 = (state_26596[(2)]);
var state_26596__$1 = state_26596;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26596__$1,inst_26594);
} else {
if((state_val_26597 === (12))){
var inst_26572 = (state_26596[(7)]);
var state_26596__$1 = state_26596;
var statearr_26603_26630 = state_26596__$1;
(statearr_26603_26630[(2)] = inst_26572);

(statearr_26603_26630[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (2))){
var _ = (function (){var statearr_26604 = state_26596;
(statearr_26604[(4)] = cljs.core.cons((5),(state_26596[(4)])));

return statearr_26604;
})();
var inst_26551 = (tt_id == null);
var state_26596__$1 = state_26596;
if(cljs.core.truth_(inst_26551)){
var statearr_26605_26631 = state_26596__$1;
(statearr_26605_26631[(1)] = (6));

} else {
var statearr_26606_26632 = state_26596__$1;
(statearr_26606_26632[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (11))){
var inst_26579 = (state_26596[(8)]);
var inst_26572 = (state_26596[(7)]);
var inst_26582 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_26572,inst_26579);
var state_26596__$1 = state_26596;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26596__$1,(14),inst_26582);
} else {
if((state_val_26597 === (9))){
var inst_26573 = (state_26596[(9)]);
var inst_26579 = (state_26596[(8)]);
var inst_26578 = cljs.core.seq(inst_26573);
var inst_26579__$1 = cljs.core.first(inst_26578);
var inst_26580 = cljs.core.next(inst_26578);
var state_26596__$1 = (function (){var statearr_26608 = state_26596;
(statearr_26608[(10)] = inst_26580);

(statearr_26608[(8)] = inst_26579__$1);

return statearr_26608;
})();
if(cljs.core.truth_(inst_26579__$1)){
var statearr_26609_26633 = state_26596__$1;
(statearr_26609_26633[(1)] = (11));

} else {
var statearr_26610_26634 = state_26596__$1;
(statearr_26610_26634[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (5))){
var _ = (function (){var statearr_26611 = state_26596;
(statearr_26611[(4)] = cljs.core.rest((state_26596[(4)])));

return statearr_26611;
})();
var state_26596__$1 = state_26596;
var ex26607 = (state_26596__$1[(2)]);
var statearr_26612_26635 = state_26596__$1;
(statearr_26612_26635[(5)] = ex26607);


if((ex26607 instanceof Error)){
var statearr_26613_26636 = state_26596__$1;
(statearr_26613_26636[(1)] = (4));

(statearr_26613_26636[(5)] = null);

} else {
throw ex26607;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (14))){
var inst_26580 = (state_26596[(10)]);
var inst_26584 = (state_26596[(2)]);
var inst_26585 = fluree.db.util.async.throw_err(inst_26584);
var inst_26572 = inst_26585;
var inst_26573 = inst_26580;
var state_26596__$1 = (function (){var statearr_26614 = state_26596;
(statearr_26614[(9)] = inst_26573);

(statearr_26614[(7)] = inst_26572);

return statearr_26614;
})();
var statearr_26615_26637 = state_26596__$1;
(statearr_26615_26637[(2)] = null);

(statearr_26615_26637[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (10))){
var inst_26591 = (state_26596[(2)]);
var _ = (function (){var statearr_26616 = state_26596;
(statearr_26616[(4)] = cljs.core.rest((state_26596[(4)])));

return statearr_26616;
})();
var state_26596__$1 = state_26596;
var statearr_26617_26638 = state_26596__$1;
(statearr_26617_26638[(2)] = inst_26591);

(statearr_26617_26638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26597 === (8))){
var inst_26556 = (state_26596[(2)]);
var inst_26557 = (function (){var tt_id__$1 = inst_26556;
return (function (db_STAR_,idx){
return cljs.core.update.cljs$core$IFn$_invoke$arity$5(db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_26558 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26556);
var inst_26559 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26557,inst_26558,fluree.db.index.types);
var inst_26560 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_26561 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_26560);
var inst_26569 = cljs.core.seq(inst_26561);
var inst_26570 = cljs.core.first(inst_26569);
var inst_26571 = cljs.core.next(inst_26569);
var inst_26572 = inst_26559;
var inst_26573 = inst_26561;
var state_26596__$1 = (function (){var statearr_26618 = state_26596;
(statearr_26618[(9)] = inst_26573);

(statearr_26618[(11)] = inst_26571);

(statearr_26618[(12)] = inst_26570);

(statearr_26618[(7)] = inst_26572);

return statearr_26618;
})();
var statearr_26619_26639 = state_26596__$1;
(statearr_26619_26639[(2)] = null);

(statearr_26619_26639[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0 = (function (){
var statearr_26620 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26620[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__);

(statearr_26620[(1)] = (1));

return statearr_26620;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1 = (function (state_26596){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26596);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26621){var ex__2687__auto__ = e26621;
var statearr_26622_26640 = state_26596;
(statearr_26622_26640[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26596[(4)]))){
var statearr_26623_26641 = state_26596;
(statearr_26623_26641[(1)] = cljs.core.first((state_26596[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26642 = state_26596;
state_26596 = G__26642;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__ = function(state_26596){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1.call(this,state_26596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26624 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26624[(6)] = c__2706__auto__);

return statearr_26624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___26829 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26760){
var state_val_26761 = (state_26760[(1)]);
if((state_val_26761 === (7))){
var inst_26670 = (state_26760[(7)]);
var inst_26670__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_26760__$1 = (function (){var statearr_26762 = state_26760;
(statearr_26762[(7)] = inst_26670__$1);

return statearr_26762;
})();
if(inst_26670__$1){
var statearr_26763_26830 = state_26760__$1;
(statearr_26763_26830[(1)] = (13));

} else {
var statearr_26764_26831 = state_26760__$1;
(statearr_26764_26831[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (20))){
var state_26760__$1 = state_26760;
var statearr_26765_26832 = state_26760__$1;
(statearr_26765_26832[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (27))){
var inst_26706 = (state_26760[(8)]);
var inst_26710 = fluree.db.flake.s(inst_26706);
var state_26760__$1 = state_26760;
var statearr_26767_26833 = state_26760__$1;
(statearr_26767_26833[(2)] = inst_26710);

(statearr_26767_26833[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (1))){
var state_26760__$1 = state_26760;
var statearr_26768_26834 = state_26760__$1;
(statearr_26768_26834[(2)] = null);

(statearr_26768_26834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (24))){
var inst_26700 = (state_26760[(9)]);
var inst_26704 = cljs.core.first(inst_26700);
var state_26760__$1 = state_26760;
var statearr_26769_26835 = state_26760__$1;
(statearr_26769_26835[(2)] = inst_26704);

(statearr_26769_26835[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (39))){
var state_26760__$1 = state_26760;
var statearr_26770_26836 = state_26760__$1;
(statearr_26770_26836[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (4))){
var inst_26643 = (state_26760[(2)]);
var inst_26644 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26645 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26646 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26647 = cljs.core.PersistentHashMap.fromArrays(inst_26645,inst_26646);
var inst_26648 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_26644,inst_26647,inst_26643);
var inst_26649 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26648);
var state_26760__$1 = state_26760;
var statearr_26772_26837 = state_26760__$1;
(statearr_26772_26837[(2)] = inst_26649);

(statearr_26772_26837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (15))){
var inst_26677 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
if(cljs.core.truth_(inst_26677)){
var statearr_26773_26838 = state_26760__$1;
(statearr_26773_26838[(1)] = (16));

} else {
var statearr_26774_26839 = state_26760__$1;
(statearr_26774_26839[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (21))){
var inst_26726 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
var statearr_26775_26840 = state_26760__$1;
(statearr_26775_26840[(2)] = inst_26726);

(statearr_26775_26840[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (31))){
var inst_26724 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
var statearr_26776_26841 = state_26760__$1;
(statearr_26776_26841[(2)] = inst_26724);

(statearr_26776_26841[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (32))){
var inst_26730 = (state_26760[(10)]);
var inst_26732 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26730);
var state_26760__$1 = state_26760;
var statearr_26777_26842 = state_26760__$1;
(statearr_26777_26842[(2)] = inst_26732);

(statearr_26777_26842[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (40))){
var inst_26753 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
var statearr_26778_26843 = state_26760__$1;
(statearr_26778_26843[(2)] = inst_26753);

(statearr_26778_26843[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (33))){
var inst_26734 = (state_26760[(11)]);
var inst_26730 = (state_26760[(10)]);
var inst_26734__$1 = (inst_26730 == null);
var state_26760__$1 = (function (){var statearr_26779 = state_26760;
(statearr_26779[(11)] = inst_26734__$1);

return statearr_26779;
})();
if(cljs.core.truth_(inst_26734__$1)){
var statearr_26780_26844 = state_26760__$1;
(statearr_26780_26844[(1)] = (35));

} else {
var statearr_26781_26845 = state_26760__$1;
(statearr_26781_26845[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (13))){
var inst_26672 = cljs.core.first(ident);
var inst_26673 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26672);
var inst_26674 = (inst_26673 == null);
var state_26760__$1 = state_26760;
var statearr_26782_26846 = state_26760__$1;
(statearr_26782_26846[(2)] = inst_26674);

(statearr_26782_26846[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (22))){
var inst_26700 = (state_26760[(9)]);
var inst_26699 = (state_26760[(2)]);
var inst_26700__$1 = fluree.db.util.async.throw_err(inst_26699);
var inst_26701 = (inst_26700__$1 == null);
var state_26760__$1 = (function (){var statearr_26783 = state_26760;
(statearr_26783[(9)] = inst_26700__$1);

return statearr_26783;
})();
if(cljs.core.truth_(inst_26701)){
var statearr_26784_26847 = state_26760__$1;
(statearr_26784_26847[(1)] = (23));

} else {
var statearr_26785_26848 = state_26760__$1;
(statearr_26785_26848[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (36))){
var inst_26734 = (state_26760[(11)]);
var state_26760__$1 = state_26760;
var statearr_26786_26849 = state_26760__$1;
(statearr_26786_26849[(2)] = inst_26734);

(statearr_26786_26849[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (41))){
var inst_26748 = cljs.core.async.close_BANG_(return_chan);
var state_26760__$1 = state_26760;
var statearr_26787_26850 = state_26760__$1;
(statearr_26787_26850[(2)] = inst_26748);

(statearr_26787_26850[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (43))){
var inst_26751 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
var statearr_26788_26851 = state_26760__$1;
(statearr_26788_26851[(2)] = inst_26751);

(statearr_26788_26851[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (29))){
var inst_26715 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_26716 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26715].join('');
var inst_26717 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26718 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26719 = cljs.core.PersistentHashMap.fromArrays(inst_26717,inst_26718);
var inst_26720 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26716,inst_26719);
var inst_26721 = (function(){throw inst_26720})();
var state_26760__$1 = state_26760;
var statearr_26789_26852 = state_26760__$1;
(statearr_26789_26852[(2)] = inst_26721);

(statearr_26789_26852[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (6))){
var inst_26657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26658 = [ident];
var inst_26659 = (new cljs.core.PersistentVector(null,1,(5),inst_26657,inst_26658,null));
var inst_26660 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26659);
var state_26760__$1 = state_26760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26760__$1,(9),inst_26660);
} else {
if((state_val_26761 === (28))){
var inst_26712 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
var statearr_26790_26853 = state_26760__$1;
(statearr_26790_26853[(2)] = inst_26712);

(statearr_26790_26853[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (25))){
var inst_26706 = (state_26760[(8)]);
var inst_26706__$1 = (state_26760[(2)]);
var inst_26707 = (inst_26706__$1 == null);
var state_26760__$1 = (function (){var statearr_26791 = state_26760;
(statearr_26791[(8)] = inst_26706__$1);

return statearr_26791;
})();
if(cljs.core.truth_(inst_26707)){
var statearr_26792_26854 = state_26760__$1;
(statearr_26792_26854[(1)] = (26));

} else {
var statearr_26793_26855 = state_26760__$1;
(statearr_26793_26855[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (34))){
var inst_26755 = (state_26760[(2)]);
var _ = (function (){var statearr_26794 = state_26760;
(statearr_26794[(4)] = cljs.core.rest((state_26760[(4)])));

return statearr_26794;
})();
var state_26760__$1 = state_26760;
var statearr_26795_26856 = state_26760__$1;
(statearr_26795_26856[(2)] = inst_26755);

(statearr_26795_26856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (17))){
var inst_26688 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_26760__$1 = state_26760;
if(inst_26688){
var statearr_26796_26857 = state_26760__$1;
(statearr_26796_26857[(1)] = (19));

} else {
var statearr_26797_26858 = state_26760__$1;
(statearr_26797_26858[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (3))){
var inst_26758 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26760__$1,inst_26758);
} else {
if((state_val_26761 === (12))){
var inst_26668 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
var statearr_26798_26859 = state_26760__$1;
(statearr_26798_26859[(2)] = inst_26668);

(statearr_26798_26859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (2))){
var _ = (function (){var statearr_26799 = state_26760;
(statearr_26799[(4)] = cljs.core.cons((5),(state_26760[(4)])));

return statearr_26799;
})();
var inst_26655 = typeof ident === 'number';
var state_26760__$1 = state_26760;
if(cljs.core.truth_(inst_26655)){
var statearr_26800_26860 = state_26760__$1;
(statearr_26800_26860[(1)] = (6));

} else {
var statearr_26801_26861 = state_26760__$1;
(statearr_26801_26861[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (23))){
var state_26760__$1 = state_26760;
var statearr_26802_26862 = state_26760__$1;
(statearr_26802_26862[(2)] = null);

(statearr_26802_26862[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (35))){
var state_26760__$1 = state_26760;
var statearr_26803_26863 = state_26760__$1;
(statearr_26803_26863[(2)] = strict_QMARK_);

(statearr_26803_26863[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (19))){
var inst_26691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26692 = cljs.core.first(ident);
var inst_26693 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26692);
var inst_26694 = cljs.core.second(ident);
var inst_26695 = [inst_26693,inst_26694];
var inst_26696 = (new cljs.core.PersistentVector(null,2,(5),inst_26691,inst_26695,null));
var inst_26697 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26696);
var state_26760__$1 = state_26760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26760__$1,(22),inst_26697);
} else {
if((state_val_26761 === (11))){
var state_26760__$1 = state_26760;
var statearr_26805_26864 = state_26760__$1;
(statearr_26805_26864[(2)] = null);

(statearr_26805_26864[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (9))){
var inst_26662 = (state_26760[(2)]);
var inst_26663 = fluree.db.util.async.throw_err(inst_26662);
var inst_26664 = cljs.core.not_empty(inst_26663);
var state_26760__$1 = state_26760;
if(cljs.core.truth_(inst_26664)){
var statearr_26806_26865 = state_26760__$1;
(statearr_26806_26865[(1)] = (10));

} else {
var statearr_26807_26866 = state_26760__$1;
(statearr_26807_26866[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (5))){
var _ = (function (){var statearr_26808 = state_26760;
(statearr_26808[(4)] = cljs.core.rest((state_26760[(4)])));

return statearr_26808;
})();
var state_26760__$1 = state_26760;
var ex26804 = (state_26760__$1[(2)]);
var statearr_26809_26867 = state_26760__$1;
(statearr_26809_26867[(5)] = ex26804);


var statearr_26810_26868 = state_26760__$1;
(statearr_26810_26868[(1)] = (4));

(statearr_26810_26868[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (14))){
var inst_26670 = (state_26760[(7)]);
var state_26760__$1 = state_26760;
var statearr_26811_26869 = state_26760__$1;
(statearr_26811_26869[(2)] = inst_26670);

(statearr_26811_26869[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (26))){
var state_26760__$1 = state_26760;
var statearr_26812_26870 = state_26760__$1;
(statearr_26812_26870[(2)] = null);

(statearr_26812_26870[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (16))){
var inst_26679 = cljs.core.first(ident);
var inst_26680 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_26679], 0));
var inst_26681 = ["Subject ID lookup failed. The predicate ",inst_26680," does not exist."].join('');
var inst_26682 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26683 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26684 = cljs.core.PersistentHashMap.fromArrays(inst_26682,inst_26683);
var inst_26685 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26681,inst_26684);
var inst_26686 = (function(){throw inst_26685})();
var state_26760__$1 = state_26760;
var statearr_26813_26871 = state_26760__$1;
(statearr_26813_26871[(2)] = inst_26686);

(statearr_26813_26871[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (38))){
var inst_26740 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26741 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26742 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26743 = cljs.core.PersistentHashMap.fromArrays(inst_26741,inst_26742);
var inst_26744 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26740,inst_26743);
var inst_26745 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26744);
var state_26760__$1 = state_26760;
var statearr_26814_26872 = state_26760__$1;
(statearr_26814_26872[(2)] = inst_26745);

(statearr_26814_26872[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (30))){
var state_26760__$1 = state_26760;
var statearr_26815_26873 = state_26760__$1;
(statearr_26815_26873[(2)] = null);

(statearr_26815_26873[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (10))){
var state_26760__$1 = state_26760;
var statearr_26816_26874 = state_26760__$1;
(statearr_26816_26874[(2)] = ident);

(statearr_26816_26874[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (18))){
var inst_26728 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
var statearr_26817_26875 = state_26760__$1;
(statearr_26817_26875[(2)] = inst_26728);

(statearr_26817_26875[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (42))){
var state_26760__$1 = state_26760;
var statearr_26818_26876 = state_26760__$1;
(statearr_26818_26876[(2)] = null);

(statearr_26818_26876[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (37))){
var inst_26738 = (state_26760[(2)]);
var state_26760__$1 = state_26760;
if(cljs.core.truth_(inst_26738)){
var statearr_26819_26877 = state_26760__$1;
(statearr_26819_26877[(1)] = (38));

} else {
var statearr_26820_26878 = state_26760__$1;
(statearr_26820_26878[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26761 === (8))){
var inst_26730 = (state_26760[(10)]);
var inst_26730__$1 = (state_26760[(2)]);
var state_26760__$1 = (function (){var statearr_26821 = state_26760;
(statearr_26821[(10)] = inst_26730__$1);

return statearr_26821;
})();
if(cljs.core.truth_(inst_26730__$1)){
var statearr_26822_26879 = state_26760__$1;
(statearr_26822_26879[(1)] = (32));

} else {
var statearr_26823_26880 = state_26760__$1;
(statearr_26823_26880[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2684__auto____0 = (function (){
var statearr_26824 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26824[(0)] = fluree$db$graphdb$subid_$_state_machine__2684__auto__);

(statearr_26824[(1)] = (1));

return statearr_26824;
});
var fluree$db$graphdb$subid_$_state_machine__2684__auto____1 = (function (state_26760){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26760);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26825){var ex__2687__auto__ = e26825;
var statearr_26826_26881 = state_26760;
(statearr_26826_26881[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26760[(4)]))){
var statearr_26827_26882 = state_26760;
(statearr_26827_26882[(1)] = cljs.core.first((state_26760[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26883 = state_26760;
state_26760 = G__26883;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2684__auto__ = function(state_26760){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2684__auto____1.call(this,state_26760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2684__auto____0;
fluree$db$graphdb$subid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2684__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26828 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26828[(6)] = c__2706__auto___26829);

return statearr_26828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__26884){
var map__26885 = p__26884;
var map__26885__$1 = cljs.core.__destructure_map(map__26885);
var db = map__26885__$1;
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26885__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26885__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26901){
var state_val_26902 = (state_26901[(1)]);
if((state_val_26902 === (1))){
var state_26901__$1 = state_26901;
var statearr_26903_26917 = state_26901__$1;
(statearr_26903_26917[(2)] = null);

(statearr_26903_26917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26902 === (2))){
var _ = (function (){var statearr_26904 = state_26901;
(statearr_26904[(4)] = cljs.core.cons((5),(state_26901[(4)])));

return statearr_26904;
})();
var inst_26892 = (current_db_fn.cljs$core$IFn$_invoke$arity$1 ? current_db_fn.cljs$core$IFn$_invoke$arity$1(db) : current_db_fn.call(null,db));
var state_26901__$1 = state_26901;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26901__$1,(6),inst_26892);
} else {
if((state_val_26902 === (3))){
var inst_26899 = (state_26901[(2)]);
var state_26901__$1 = state_26901;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26901__$1,inst_26899);
} else {
if((state_val_26902 === (4))){
var inst_26886 = (state_26901[(2)]);
var state_26901__$1 = state_26901;
var statearr_26906_26918 = state_26901__$1;
(statearr_26906_26918[(2)] = inst_26886);

(statearr_26906_26918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26902 === (5))){
var _ = (function (){var statearr_26907 = state_26901;
(statearr_26907[(4)] = cljs.core.rest((state_26901[(4)])));

return statearr_26907;
})();
var state_26901__$1 = state_26901;
var ex26905 = (state_26901__$1[(2)]);
var statearr_26908_26919 = state_26901__$1;
(statearr_26908_26919[(5)] = ex26905);


if((ex26905 instanceof Error)){
var statearr_26909_26920 = state_26901__$1;
(statearr_26909_26920[(1)] = (4));

(statearr_26909_26920[(5)] = null);

} else {
throw ex26905;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26902 === (6))){
var inst_26894 = (state_26901[(2)]);
var inst_26895 = fluree.db.util.async.throw_err(inst_26894);
var inst_26896 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26895,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_26910 = state_26901;
(statearr_26910[(4)] = cljs.core.rest((state_26901[(4)])));

return statearr_26910;
})();
var state_26901__$1 = state_26901;
var statearr_26911_26921 = state_26901__$1;
(statearr_26911_26921[(2)] = inst_26896);

(statearr_26911_26921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0 = (function (){
var statearr_26912 = [null,null,null,null,null,null,null];
(statearr_26912[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__);

(statearr_26912[(1)] = (1));

return statearr_26912;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1 = (function (state_26901){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26901);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26913){var ex__2687__auto__ = e26913;
var statearr_26914_26922 = state_26901;
(statearr_26914_26922[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26901[(4)]))){
var statearr_26915_26923 = state_26901;
(statearr_26915_26923[(1)] = cljs.core.first((state_26901[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26924 = state_26901;
state_26901 = G__26924;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__ = function(state_26901){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1.call(this,state_26901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26916 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26916[(6)] = c__2706__auto__);

return statearr_26916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__26925,property,collection){
var map__26926 = p__26925;
var map__26926__$1 = cljs.core.__destructure_map(map__26926);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26926__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__26927 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__26927.cljs$core$IFn$_invoke$arity$1 ? fexpr__26927.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26927.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__26928,property,predicate){
var map__26929 = p__26928;
var map__26929__$1 = cljs.core.__destructure_map(map__26929);
var this$ = map__26929__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26929__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__26930 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__26930.cljs$core$IFn$_invoke$arity$1 ? fexpr__26930.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26930.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__26931 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__26931);
} else {
return G__26931;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__26933 = arguments.length;
switch (G__26933) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26965){
var state_val_26966 = (state_26965[(1)]);
if((state_val_26966 === (7))){
var state_26965__$1 = state_26965;
var statearr_26967_27061 = state_26965__$1;
(statearr_26967_27061[(2)] = null);

(statearr_26967_27061[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (1))){
var state_26965__$1 = state_26965;
var statearr_26968_27062 = state_26965__$1;
(statearr_26968_27062[(2)] = null);

(statearr_26968_27062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (4))){
var inst_26934 = (state_26965[(2)]);
var state_26965__$1 = state_26965;
var statearr_26969_27063 = state_26965__$1;
(statearr_26969_27063[(2)] = inst_26934);

(statearr_26969_27063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (6))){
var inst_26948 = (state_26965[(7)]);
var inst_26947 = (state_26965[(2)]);
var inst_26948__$1 = fluree.db.util.async.throw_err(inst_26947);
var inst_26949 = (inst_26948__$1 == null);
var state_26965__$1 = (function (){var statearr_26970 = state_26965;
(statearr_26970[(7)] = inst_26948__$1);

return statearr_26970;
})();
if(cljs.core.truth_(inst_26949)){
var statearr_26971_27064 = state_26965__$1;
(statearr_26971_27064[(1)] = (7));

} else {
var statearr_26972_27065 = state_26965__$1;
(statearr_26972_27065[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (3))){
var inst_26963 = (state_26965[(2)]);
var state_26965__$1 = state_26965;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26965__$1,inst_26963);
} else {
if((state_val_26966 === (12))){
var inst_26960 = (state_26965[(2)]);
var _ = (function (){var statearr_26973 = state_26965;
(statearr_26973[(4)] = cljs.core.rest((state_26965[(4)])));

return statearr_26973;
})();
var state_26965__$1 = state_26965;
var statearr_26974_27066 = state_26965__$1;
(statearr_26974_27066[(2)] = inst_26960);

(statearr_26974_27066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (2))){
var _ = (function (){var statearr_26975 = state_26965;
(statearr_26975[(4)] = cljs.core.cons((5),(state_26965[(4)])));

return statearr_26975;
})();
var inst_26941 = fluree.db.dbproto._rootdb(this$);
var inst_26942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26943 = [tag_id,(30)];
var inst_26944 = (new cljs.core.PersistentVector(null,2,(5),inst_26942,inst_26943,null));
var inst_26945 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26941,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26944);
var state_26965__$1 = state_26965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26965__$1,(6),inst_26945);
} else {
if((state_val_26966 === (11))){
var inst_26954 = (state_26965[(8)]);
var inst_26958 = fluree.db.flake.o(inst_26954);
var state_26965__$1 = state_26965;
var statearr_26977_27067 = state_26965__$1;
(statearr_26977_27067[(2)] = inst_26958);

(statearr_26977_27067[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (9))){
var inst_26954 = (state_26965[(8)]);
var inst_26954__$1 = (state_26965[(2)]);
var inst_26955 = (inst_26954__$1 == null);
var state_26965__$1 = (function (){var statearr_26978 = state_26965;
(statearr_26978[(8)] = inst_26954__$1);

return statearr_26978;
})();
if(cljs.core.truth_(inst_26955)){
var statearr_26979_27068 = state_26965__$1;
(statearr_26979_27068[(1)] = (10));

} else {
var statearr_26980_27069 = state_26965__$1;
(statearr_26980_27069[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (5))){
var _ = (function (){var statearr_26981 = state_26965;
(statearr_26981[(4)] = cljs.core.rest((state_26965[(4)])));

return statearr_26981;
})();
var state_26965__$1 = state_26965;
var ex26976 = (state_26965__$1[(2)]);
var statearr_26982_27070 = state_26965__$1;
(statearr_26982_27070[(5)] = ex26976);


if((ex26976 instanceof Error)){
var statearr_26983_27071 = state_26965__$1;
(statearr_26983_27071[(1)] = (4));

(statearr_26983_27071[(5)] = null);

} else {
throw ex26976;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (10))){
var state_26965__$1 = state_26965;
var statearr_26984_27072 = state_26965__$1;
(statearr_26984_27072[(2)] = null);

(statearr_26984_27072[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (8))){
var inst_26948 = (state_26965[(7)]);
var inst_26952 = cljs.core.first(inst_26948);
var state_26965__$1 = state_26965;
var statearr_26985_27073 = state_26965__$1;
(statearr_26985_27073[(2)] = inst_26952);

(statearr_26985_27073[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26986 = [null,null,null,null,null,null,null,null,null];
(statearr_26986[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26986[(1)] = (1));

return statearr_26986;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26965){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26965);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26987){var ex__2687__auto__ = e26987;
var statearr_26988_27074 = state_26965;
(statearr_26988_27074[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26965[(4)]))){
var statearr_26989_27075 = state_26965;
(statearr_26989_27075[(1)] = cljs.core.first((state_26965[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27076 = state_26965;
state_26965 = G__27076;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26965){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26990 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26990[(6)] = c__2706__auto__);

return statearr_26990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27026){
var state_val_27027 = (state_27026[(1)]);
if((state_val_27027 === (7))){
var inst_27000 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27026__$1 = state_27026;
var statearr_27028_27077 = state_27026__$1;
(statearr_27028_27077[(2)] = inst_27000);

(statearr_27028_27077[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (1))){
var state_27026__$1 = state_27026;
var statearr_27029_27078 = state_27026__$1;
(statearr_27029_27078[(2)] = null);

(statearr_27029_27078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (4))){
var inst_26991 = (state_27026[(2)]);
var state_27026__$1 = state_27026;
var statearr_27030_27079 = state_27026__$1;
(statearr_27030_27079[(2)] = inst_26991);

(statearr_27030_27079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (15))){
var inst_27021 = (state_27026[(2)]);
var _ = (function (){var statearr_27031 = state_27026;
(statearr_27031[(4)] = cljs.core.rest((state_27026[(4)])));

return statearr_27031;
})();
var state_27026__$1 = state_27026;
var statearr_27032_27080 = state_27026__$1;
(statearr_27032_27080[(2)] = inst_27021);

(statearr_27032_27080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (13))){
var inst_27006 = (state_27026[(7)]);
var inst_27012 = clojure.string.includes_QMARK_(inst_27006,":");
var state_27026__$1 = state_27026;
if(inst_27012){
var statearr_27033_27081 = state_27026__$1;
(statearr_27033_27081[(1)] = (16));

} else {
var statearr_27034_27082 = state_27026__$1;
(statearr_27034_27082[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (6))){
var state_27026__$1 = state_27026;
var statearr_27035_27083 = state_27026__$1;
(statearr_27035_27083[(2)] = pred);

(statearr_27035_27083[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (17))){
var inst_27006 = (state_27026[(7)]);
var state_27026__$1 = state_27026;
var statearr_27036_27084 = state_27026__$1;
(statearr_27036_27084[(2)] = inst_27006);

(statearr_27036_27084[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (3))){
var inst_27024 = (state_27026[(2)]);
var state_27026__$1 = state_27026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27026__$1,inst_27024);
} else {
if((state_val_27027 === (12))){
var inst_27010 = (state_27026[(2)]);
var state_27026__$1 = state_27026;
if(cljs.core.truth_(inst_27010)){
var statearr_27037_27085 = state_27026__$1;
(statearr_27037_27085[(1)] = (13));

} else {
var statearr_27038_27086 = state_27026__$1;
(statearr_27038_27086[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (2))){
var _ = (function (){var statearr_27039 = state_27026;
(statearr_27039[(4)] = cljs.core.cons((5),(state_27026[(4)])));

return statearr_27039;
})();
var inst_26997 = typeof pred === 'string';
var state_27026__$1 = state_27026;
if(cljs.core.truth_(inst_26997)){
var statearr_27040_27087 = state_27026__$1;
(statearr_27040_27087[(1)] = (6));

} else {
var statearr_27041_27088 = state_27026__$1;
(statearr_27041_27088[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (11))){
var inst_27002 = (state_27026[(8)]);
var state_27026__$1 = state_27026;
var statearr_27043_27089 = state_27026__$1;
(statearr_27043_27089[(2)] = inst_27002);

(statearr_27043_27089[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (9))){
var inst_27002 = (state_27026[(8)]);
var inst_27005 = (state_27026[(2)]);
var inst_27006 = fluree.db.util.async.throw_err(inst_27005);
var state_27026__$1 = (function (){var statearr_27044 = state_27026;
(statearr_27044[(7)] = inst_27006);

return statearr_27044;
})();
if(cljs.core.truth_(inst_27002)){
var statearr_27045_27090 = state_27026__$1;
(statearr_27045_27090[(1)] = (10));

} else {
var statearr_27046_27091 = state_27026__$1;
(statearr_27046_27091[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (5))){
var _ = (function (){var statearr_27047 = state_27026;
(statearr_27047[(4)] = cljs.core.rest((state_27026[(4)])));

return statearr_27047;
})();
var state_27026__$1 = state_27026;
var ex27042 = (state_27026__$1[(2)]);
var statearr_27048_27092 = state_27026__$1;
(statearr_27048_27092[(5)] = ex27042);


if((ex27042 instanceof Error)){
var statearr_27049_27093 = state_27026__$1;
(statearr_27049_27093[(1)] = (4));

(statearr_27049_27093[(5)] = null);

} else {
throw ex27042;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (14))){
var state_27026__$1 = state_27026;
var statearr_27050_27094 = state_27026__$1;
(statearr_27050_27094[(2)] = null);

(statearr_27050_27094[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (16))){
var inst_27006 = (state_27026[(7)]);
var inst_27014 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_27006,/:/);
var inst_27015 = cljs.core.second(inst_27014);
var state_27026__$1 = state_27026;
var statearr_27051_27095 = state_27026__$1;
(statearr_27051_27095[(2)] = inst_27015);

(statearr_27051_27095[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (10))){
var inst_27006 = (state_27026[(7)]);
var state_27026__$1 = state_27026;
var statearr_27052_27096 = state_27026__$1;
(statearr_27052_27096[(2)] = inst_27006);

(statearr_27052_27096[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (18))){
var inst_27018 = (state_27026[(2)]);
var state_27026__$1 = state_27026;
var statearr_27053_27097 = state_27026__$1;
(statearr_27053_27097[(2)] = inst_27018);

(statearr_27053_27097[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27027 === (8))){
var inst_27002 = (state_27026[(2)]);
var inst_27003 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_27026__$1 = (function (){var statearr_27054 = state_27026;
(statearr_27054[(8)] = inst_27002);

return statearr_27054;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27026__$1,(9),inst_27003);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_27055 = [null,null,null,null,null,null,null,null,null];
(statearr_27055[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_27055[(1)] = (1));

return statearr_27055;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_27026){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27026);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27056){var ex__2687__auto__ = e27056;
var statearr_27057_27098 = state_27026;
(statearr_27057_27098[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27026[(4)]))){
var statearr_27058_27099 = state_27026;
(statearr_27058_27099[(1)] = cljs.core.first((state_27026[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27100 = state_27026;
state_27026 = G__27100;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_27026){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_27026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27059 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27059[(6)] = c__2706__auto__);

return statearr_27059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__27102 = arguments.length;
switch (G__27102) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27135){
var state_val_27136 = (state_27135[(1)]);
if((state_val_27136 === (7))){
var state_27135__$1 = state_27135;
var statearr_27137_27225 = state_27135__$1;
(statearr_27137_27225[(2)] = null);

(statearr_27137_27225[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (1))){
var state_27135__$1 = state_27135;
var statearr_27138_27226 = state_27135__$1;
(statearr_27138_27226[(2)] = null);

(statearr_27138_27226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (4))){
var inst_27103 = (state_27135[(2)]);
var state_27135__$1 = state_27135;
var statearr_27139_27227 = state_27135__$1;
(statearr_27139_27227[(2)] = inst_27103);

(statearr_27139_27227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (6))){
var inst_27118 = (state_27135[(7)]);
var inst_27117 = (state_27135[(2)]);
var inst_27118__$1 = fluree.db.util.async.throw_err(inst_27117);
var inst_27119 = (inst_27118__$1 == null);
var state_27135__$1 = (function (){var statearr_27140 = state_27135;
(statearr_27140[(7)] = inst_27118__$1);

return statearr_27140;
})();
if(cljs.core.truth_(inst_27119)){
var statearr_27141_27228 = state_27135__$1;
(statearr_27141_27228[(1)] = (7));

} else {
var statearr_27142_27229 = state_27135__$1;
(statearr_27142_27229[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (3))){
var inst_27133 = (state_27135[(2)]);
var state_27135__$1 = state_27135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27135__$1,inst_27133);
} else {
if((state_val_27136 === (12))){
var inst_27130 = (state_27135[(2)]);
var _ = (function (){var statearr_27143 = state_27135;
(statearr_27143[(4)] = cljs.core.rest((state_27135[(4)])));

return statearr_27143;
})();
var state_27135__$1 = state_27135;
var statearr_27144_27230 = state_27135__$1;
(statearr_27144_27230[(2)] = inst_27130);

(statearr_27144_27230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (2))){
var _ = (function (){var statearr_27145 = state_27135;
(statearr_27145[(4)] = cljs.core.cons((5),(state_27135[(4)])));

return statearr_27145;
})();
var inst_27109 = (30);
var inst_27111 = fluree.db.dbproto._rootdb(this$);
var inst_27112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27113 = [inst_27109,tag_name];
var inst_27114 = (new cljs.core.PersistentVector(null,2,(5),inst_27112,inst_27113,null));
var inst_27115 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27111,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27114);
var state_27135__$1 = state_27135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27135__$1,(6),inst_27115);
} else {
if((state_val_27136 === (11))){
var inst_27124 = (state_27135[(8)]);
var inst_27128 = fluree.db.flake.s(inst_27124);
var state_27135__$1 = state_27135;
var statearr_27147_27231 = state_27135__$1;
(statearr_27147_27231[(2)] = inst_27128);

(statearr_27147_27231[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (9))){
var inst_27124 = (state_27135[(8)]);
var inst_27124__$1 = (state_27135[(2)]);
var inst_27125 = (inst_27124__$1 == null);
var state_27135__$1 = (function (){var statearr_27148 = state_27135;
(statearr_27148[(8)] = inst_27124__$1);

return statearr_27148;
})();
if(cljs.core.truth_(inst_27125)){
var statearr_27149_27232 = state_27135__$1;
(statearr_27149_27232[(1)] = (10));

} else {
var statearr_27150_27233 = state_27135__$1;
(statearr_27150_27233[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (5))){
var _ = (function (){var statearr_27151 = state_27135;
(statearr_27151[(4)] = cljs.core.rest((state_27135[(4)])));

return statearr_27151;
})();
var state_27135__$1 = state_27135;
var ex27146 = (state_27135__$1[(2)]);
var statearr_27152_27234 = state_27135__$1;
(statearr_27152_27234[(5)] = ex27146);


if((ex27146 instanceof Error)){
var statearr_27153_27235 = state_27135__$1;
(statearr_27153_27235[(1)] = (4));

(statearr_27153_27235[(5)] = null);

} else {
throw ex27146;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (10))){
var state_27135__$1 = state_27135;
var statearr_27154_27236 = state_27135__$1;
(statearr_27154_27236[(2)] = null);

(statearr_27154_27236[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (8))){
var inst_27118 = (state_27135[(7)]);
var inst_27122 = cljs.core.first(inst_27118);
var state_27135__$1 = state_27135;
var statearr_27155_27237 = state_27135__$1;
(statearr_27155_27237[(2)] = inst_27122);

(statearr_27155_27237[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_27156 = [null,null,null,null,null,null,null,null,null];
(statearr_27156[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_27156[(1)] = (1));

return statearr_27156;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_27135){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27135);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27157){var ex__2687__auto__ = e27157;
var statearr_27158_27238 = state_27135;
(statearr_27158_27238[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27135[(4)]))){
var statearr_27159_27239 = state_27135;
(statearr_27159_27239[(1)] = cljs.core.first((state_27135[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27240 = state_27135;
state_27135 = G__27240;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_27135){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_27135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27160 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27160[(6)] = c__2706__auto__);

return statearr_27160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27195){
var state_val_27196 = (state_27195[(1)]);
if((state_val_27196 === (7))){
var inst_27174 = typeof pred === 'string';
var state_27195__$1 = state_27195;
if(cljs.core.truth_(inst_27174)){
var statearr_27197_27241 = state_27195__$1;
(statearr_27197_27241[(1)] = (10));

} else {
var statearr_27198_27242 = state_27195__$1;
(statearr_27198_27242[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (1))){
var state_27195__$1 = state_27195;
var statearr_27199_27243 = state_27195__$1;
(statearr_27199_27243[(2)] = null);

(statearr_27199_27243[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (4))){
var inst_27161 = (state_27195[(2)]);
var state_27195__$1 = state_27195;
var statearr_27200_27244 = state_27195__$1;
(statearr_27200_27244[(2)] = inst_27161);

(statearr_27200_27244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (15))){
var inst_27188 = (state_27195[(2)]);
var state_27195__$1 = state_27195;
var statearr_27201_27245 = state_27195__$1;
(statearr_27201_27245[(2)] = inst_27188);

(statearr_27201_27245[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (13))){
var inst_27179 = (state_27195[(7)]);
var inst_27181 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27179),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27182 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_27181);
var state_27195__$1 = state_27195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27195__$1,(16),inst_27182);
} else {
if((state_val_27196 === (6))){
var inst_27169 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_27195__$1 = state_27195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27195__$1,(9),inst_27169);
} else {
if((state_val_27196 === (3))){
var inst_27193 = (state_27195[(2)]);
var state_27195__$1 = state_27195;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27195__$1,inst_27193);
} else {
if((state_val_27196 === (12))){
var inst_27179 = (state_27195[(7)]);
var inst_27179__$1 = (state_27195[(2)]);
var state_27195__$1 = (function (){var statearr_27202 = state_27195;
(statearr_27202[(7)] = inst_27179__$1);

return statearr_27202;
})();
if(cljs.core.truth_(inst_27179__$1)){
var statearr_27203_27246 = state_27195__$1;
(statearr_27203_27246[(1)] = (13));

} else {
var statearr_27204_27247 = state_27195__$1;
(statearr_27204_27247[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (2))){
var _ = (function (){var statearr_27205 = state_27195;
(statearr_27205[(4)] = cljs.core.cons((5),(state_27195[(4)])));

return statearr_27205;
})();
var inst_27167 = clojure.string.includes_QMARK_(tag_name,"/");
var state_27195__$1 = state_27195;
if(inst_27167){
var statearr_27206_27248 = state_27195__$1;
(statearr_27206_27248[(1)] = (6));

} else {
var statearr_27207_27249 = state_27195__$1;
(statearr_27207_27249[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (11))){
var inst_27177 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27195__$1 = state_27195;
var statearr_27209_27250 = state_27195__$1;
(statearr_27209_27250[(2)] = inst_27177);

(statearr_27209_27250[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (9))){
var inst_27171 = (state_27195[(2)]);
var inst_27172 = fluree.db.util.async.throw_err(inst_27171);
var state_27195__$1 = state_27195;
var statearr_27210_27251 = state_27195__$1;
(statearr_27210_27251[(2)] = inst_27172);

(statearr_27210_27251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (5))){
var _ = (function (){var statearr_27211 = state_27195;
(statearr_27211[(4)] = cljs.core.rest((state_27195[(4)])));

return statearr_27211;
})();
var state_27195__$1 = state_27195;
var ex27208 = (state_27195__$1[(2)]);
var statearr_27212_27252 = state_27195__$1;
(statearr_27212_27252[(5)] = ex27208);


if((ex27208 instanceof Error)){
var statearr_27213_27253 = state_27195__$1;
(statearr_27213_27253[(1)] = (4));

(statearr_27213_27253[(5)] = null);

} else {
throw ex27208;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (14))){
var state_27195__$1 = state_27195;
var statearr_27214_27254 = state_27195__$1;
(statearr_27214_27254[(2)] = null);

(statearr_27214_27254[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (16))){
var inst_27184 = (state_27195[(2)]);
var inst_27185 = fluree.db.util.async.throw_err(inst_27184);
var state_27195__$1 = state_27195;
var statearr_27215_27255 = state_27195__$1;
(statearr_27215_27255[(2)] = inst_27185);

(statearr_27215_27255[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (10))){
var state_27195__$1 = state_27195;
var statearr_27216_27256 = state_27195__$1;
(statearr_27216_27256[(2)] = pred);

(statearr_27216_27256[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27196 === (8))){
var inst_27190 = (state_27195[(2)]);
var _ = (function (){var statearr_27217 = state_27195;
(statearr_27217[(4)] = cljs.core.rest((state_27195[(4)])));

return statearr_27217;
})();
var state_27195__$1 = state_27195;
var statearr_27218_27257 = state_27195__$1;
(statearr_27218_27257[(2)] = inst_27190);

(statearr_27218_27257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_27219 = [null,null,null,null,null,null,null,null];
(statearr_27219[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_27219[(1)] = (1));

return statearr_27219;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_27195){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27195);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27220){var ex__2687__auto__ = e27220;
var statearr_27221_27258 = state_27195;
(statearr_27221_27258[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27195[(4)]))){
var statearr_27222_27259 = state_27195;
(statearr_27222_27259[(1)] = cljs.core.first((state_27195[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27260 = state_27195;
state_27195 = G__27260;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_27195){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_27195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27223 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27223[(6)] = c__2706__auto__);

return statearr_27223;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27262,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27266 = k27262;
var G__27266__$1 = (((G__27266 instanceof cljs.core.Keyword))?G__27266.fqn:null);
switch (G__27266__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27262,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__27267){
var vec__27268 = p__27267;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27268,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27268,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27261){
var self__ = this;
var G__27261__$1 = this;
return (new cljs.core.RecordIter((0),G__27261__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__27271 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__27271(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27263,other27264){
var self__ = this;
var this27263__$1 = this;
return (((!((other27264 == null)))) && ((((this27263__$1.constructor === other27264.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.conn,other27264.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.network,other27264.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.ledger_id,other27264.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.block,other27264.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.t,other27264.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.tt_id,other27264.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.stats,other27264.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.spot,other27264.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.psot,other27264.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.post,other27264.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.opst,other27264.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.tspo,other27264.tspo)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.schema,other27264.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.settings,other27264.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.comparators,other27264.comparators)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.schema_cache,other27264.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.novelty,other27264.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.permissions,other27264.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.fork,other27264.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.fork_block,other27264.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.current_db_fn,other27264.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27263__$1.__extmap,other27264.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27262){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27272 = k27262;
var G__27272__$1 = (((G__27272 instanceof cljs.core.Keyword))?G__27272.fqn:null);
switch (G__27272__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27262);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27261){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27273 = cljs.core.keyword_identical_QMARK_;
var expr__27274 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__27276 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27277 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27276,G__27277) : pred__27273.call(null,G__27276,G__27277));
})())){
return (new fluree.db.graphdb.GraphDb(G__27261,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27278 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27279 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27278,G__27279) : pred__27273.call(null,G__27278,G__27279));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27261,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27280 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__27281 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27280,G__27281) : pred__27273.call(null,G__27280,G__27281));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27261,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27282 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27283 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27282,G__27283) : pred__27273.call(null,G__27282,G__27283));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__27261,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27284 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27285 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27284,G__27285) : pred__27273.call(null,G__27284,G__27285));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__27261,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27286 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27287 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27286,G__27287) : pred__27273.call(null,G__27286,G__27287));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__27261,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27288 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27289 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27288,G__27289) : pred__27273.call(null,G__27288,G__27289));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__27261,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27290 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27291 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27290,G__27291) : pred__27273.call(null,G__27290,G__27291));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__27261,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27292 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27293 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27292,G__27293) : pred__27273.call(null,G__27292,G__27293));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27261,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27294 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27295 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27294,G__27295) : pred__27273.call(null,G__27294,G__27295));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27261,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27296 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27297 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27296,G__27297) : pred__27273.call(null,G__27296,G__27297));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27261,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27298 = new cljs.core.Keyword(null,"tspo","tspo",-440144953);
var G__27299 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27298,G__27299) : pred__27273.call(null,G__27298,G__27299));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27261,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27300 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27301 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27300,G__27301) : pred__27273.call(null,G__27300,G__27301));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__27261,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27302 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27303 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27302,G__27303) : pred__27273.call(null,G__27302,G__27303));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__27261,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27304 = new cljs.core.Keyword(null,"comparators","comparators",-1325611955);
var G__27305 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27304,G__27305) : pred__27273.call(null,G__27304,G__27305));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__27261,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27306 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27307 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27306,G__27307) : pred__27273.call(null,G__27306,G__27307));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__27261,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27308 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27309 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27308,G__27309) : pred__27273.call(null,G__27308,G__27309));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__27261,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27310 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27311 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27310,G__27311) : pred__27273.call(null,G__27310,G__27311));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__27261,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27312 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27313 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27312,G__27313) : pred__27273.call(null,G__27312,G__27313));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__27261,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27314 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27315 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27314,G__27315) : pred__27273.call(null,G__27314,G__27315));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27261,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27316 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27317 = expr__27274;
return (pred__27273.cljs$core$IFn$_invoke$arity$2 ? pred__27273.cljs$core$IFn$_invoke$arity$2(G__27316,G__27317) : pred__27273.call(null,G__27316,G__27317));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27261,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__27261),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27261){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27261,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27265){
var extmap__5385__auto__ = (function (){var G__27318 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27265,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__27265)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27318);
} else {
return G__27318;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27265),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27265),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,clojure.data.avl.sorted_set_by(cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__27321 = fluree.db.index.default_comparators;
var map__27321__$1 = cljs.core.__destructure_map(map__27321);
var spot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27321__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27321__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27321__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27321__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27321__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch(network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch(network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch(network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch(network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch(network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
