// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
/**
 * Map of default index comparators for the five index types
 */
fluree.db.index.default_comparators = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"post","post",269697687),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"tspo","tspo",-440144953),fluree.db.flake.cmp_flakes_block], null);
/**
 * The five possible index orderings based on the subject, predicate, object,
 *   and transaction flake attributes
 */
fluree.db.index.types = cljs.core.set(cljs.core.keys(fluree.db.index.default_comparators));
/**
 * Returns `true` if `node` is a map for a leaf node
 */
fluree.db.index.leaf_QMARK_ = (function fluree$db$index$leaf_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === true;
});
/**
 * Returns `true` if `node` is a map for branch node
 */
fluree.db.index.branch_QMARK_ = (function fluree$db$index$branch_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === false;
});

/**
 * @interface
 */
fluree.db.index.Resolver = function(){};

var fluree$db$index$Resolver$resolve$dyn_14555 = (function (r,node){
var x__5393__auto__ = (((r == null))?null:r);
var m__5394__auto__ = (fluree.db.index.resolve[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__5394__auto__.call(null,r,node));
} else {
var m__5392__auto__ = (fluree.db.index.resolve["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__5392__auto__.call(null,r,node));
} else {
throw cljs.core.missing_protocol("Resolver.resolve",r);
}
}
});
/**
 * Populate the supplied index branch or leaf node maps with either the child
 *   node attributes or the flakes they store, respectively.
 */
fluree.db.index.resolve = (function fluree$db$index$resolve(r,node){
if((((!((r == null)))) && ((!((r.fluree$db$index$Resolver$resolve$arity$2 == null)))))){
return r.fluree$db$index$Resolver$resolve$arity$2(r,node);
} else {
return fluree$db$index$Resolver$resolve$dyn_14555(r,node);
}
});

fluree.db.index.try_resolve = (function fluree$db$index$try_resolve(r,error_ch,node){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14577){
var state_val_14578 = (state_14577[(1)]);
if((state_val_14578 === (1))){
var state_14577__$1 = state_14577;
var statearr_14579_14594 = state_14577__$1;
(statearr_14579_14594[(2)] = null);

(statearr_14579_14594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (2))){
var _ = (function (){var statearr_14580 = state_14577;
(statearr_14580[(4)] = cljs.core.cons((6),(state_14577[(4)])));

return statearr_14580;
})();
var inst_14569 = fluree.db.index.resolve(r,node);
var state_14577__$1 = state_14577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14577__$1,(7),inst_14569);
} else {
if((state_val_14578 === (3))){
var inst_14575 = (state_14577[(2)]);
var state_14577__$1 = state_14577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14577__$1,inst_14575);
} else {
if((state_val_14578 === (4))){
var inst_14556 = (state_14577[(2)]);
var inst_14557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14558 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015)];
var inst_14559 = (new cljs.core.PersistentVector(null,3,(5),inst_14557,inst_14558,null));
var inst_14560 = cljs.core.select_keys(node,inst_14559);
var inst_14561 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_14556,"Error resolving index node:",inst_14560) : fluree.db.util.log.error.call(null,inst_14556,"Error resolving index node:",inst_14560));
var state_14577__$1 = (function (){var statearr_14582 = state_14577;
(statearr_14582[(7)] = inst_14561);

return statearr_14582;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14577__$1,(5),error_ch,inst_14556);
} else {
if((state_val_14578 === (5))){
var inst_14563 = (state_14577[(2)]);
var state_14577__$1 = state_14577;
var statearr_14583_14595 = state_14577__$1;
(statearr_14583_14595[(2)] = inst_14563);

(statearr_14583_14595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (6))){
var _ = (function (){var statearr_14584 = state_14577;
(statearr_14584[(4)] = cljs.core.rest((state_14577[(4)])));

return statearr_14584;
})();
var state_14577__$1 = state_14577;
var ex14581 = (state_14577__$1[(2)]);
var statearr_14585_14596 = state_14577__$1;
(statearr_14585_14596[(5)] = ex14581);


var statearr_14586_14597 = state_14577__$1;
(statearr_14586_14597[(1)] = (4));

(statearr_14586_14597[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14578 === (7))){
var inst_14571 = (state_14577[(2)]);
var inst_14572 = fluree.db.util.async.throw_err(inst_14571);
var _ = (function (){var statearr_14587 = state_14577;
(statearr_14587[(4)] = cljs.core.rest((state_14577[(4)])));

return statearr_14587;
})();
var state_14577__$1 = state_14577;
var statearr_14588_14598 = state_14577__$1;
(statearr_14588_14598[(2)] = inst_14572);

(statearr_14588_14598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$try_resolve_$_state_machine__2684__auto__ = null;
var fluree$db$index$try_resolve_$_state_machine__2684__auto____0 = (function (){
var statearr_14589 = [null,null,null,null,null,null,null,null];
(statearr_14589[(0)] = fluree$db$index$try_resolve_$_state_machine__2684__auto__);

(statearr_14589[(1)] = (1));

return statearr_14589;
});
var fluree$db$index$try_resolve_$_state_machine__2684__auto____1 = (function (state_14577){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14577);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14590){var ex__2687__auto__ = e14590;
var statearr_14591_14599 = state_14577;
(statearr_14591_14599[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14577[(4)]))){
var statearr_14592_14600 = state_14577;
(statearr_14592_14600[(1)] = cljs.core.first((state_14577[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14601 = state_14577;
state_14577 = G__14601;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$try_resolve_$_state_machine__2684__auto__ = function(state_14577){
switch(arguments.length){
case 0:
return fluree$db$index$try_resolve_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$try_resolve_$_state_machine__2684__auto____1.call(this,state_14577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$try_resolve_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$try_resolve_$_state_machine__2684__auto____0;
fluree$db$index$try_resolve_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$try_resolve_$_state_machine__2684__auto____1;
return fluree$db$index$try_resolve_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14593 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14593[(6)] = c__2706__auto__);

return statearr_14593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns `true` if the data associated with the index node map `node` is fully
 *   resolved from storage
 */
fluree.db.index.resolved_QMARK_ = (function fluree$db$index$resolved_QMARK_(node){
if(fluree.db.index.leaf_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
if(fluree.db.index.branch_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
return null;
}
}
});
/**
 * Clear the populated child node attributes from the supplied `node` map if it
 *   represents a branch, or the populated flakes if `node` represents a leaf.
 */
fluree.db.index.unresolve = (function fluree$db$index$unresolve(node){
if(fluree.db.index.leaf_QMARK_(node)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
} else {
if(fluree.db.index.branch_QMARK_(node)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.Keyword(null,"children","children",-940561982));
} else {
return null;
}
}
});
fluree.db.index.lookup = (function fluree$db$index$lookup(branch,flake){
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.index.branch_QMARK_(branch);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_(branch);
} else {
return and__5043__auto__;
}
})())){
var map__14602 = branch;
var map__14602__$1 = cljs.core.__destructure_map(map__14602);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14602__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.val((function (){var or__5045__auto__ = clojure.data.avl.nearest(children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.first(children);
}
})());
} else {
return null;
}
});
fluree.db.index.lookup_leaf = (function fluree$db$index$lookup_leaf(r,branch,flake){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14638){
var state_val_14639 = (state_14638[(1)]);
if((state_val_14639 === (7))){
var inst_14609 = (state_14638[(7)]);
var state_14638__$1 = state_14638;
var statearr_14640_14671 = state_14638__$1;
(statearr_14640_14671[(2)] = inst_14609);

(statearr_14640_14671[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (1))){
var state_14638__$1 = state_14638;
var statearr_14641_14672 = state_14638__$1;
(statearr_14641_14672[(2)] = null);

(statearr_14641_14672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (4))){
var inst_14603 = (state_14638[(2)]);
var state_14638__$1 = state_14638;
var statearr_14642_14673 = state_14638__$1;
(statearr_14642_14673[(2)] = inst_14603);

(statearr_14642_14673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (15))){
var inst_14617 = (state_14638[(8)]);
var inst_14622 = fluree.db.index.resolve(r,inst_14617);
var state_14638__$1 = state_14638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14638__$1,(17),inst_14622);
} else {
if((state_val_14639 === (13))){
var inst_14630 = (state_14638[(2)]);
var state_14638__$1 = state_14638;
var statearr_14643_14674 = state_14638__$1;
(statearr_14643_14674[(2)] = inst_14630);

(statearr_14643_14674[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (6))){
var inst_14611 = fluree.db.index.resolved_QMARK_(branch);
var state_14638__$1 = state_14638;
var statearr_14644_14675 = state_14638__$1;
(statearr_14644_14675[(2)] = inst_14611);

(statearr_14644_14675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (17))){
var inst_14624 = (state_14638[(2)]);
var inst_14625 = fluree.db.util.async.throw_err(inst_14624);
var inst_14617 = inst_14625;
var state_14638__$1 = (function (){var statearr_14645 = state_14638;
(statearr_14645[(8)] = inst_14617);

return statearr_14645;
})();
var statearr_14646_14676 = state_14638__$1;
(statearr_14646_14676[(2)] = null);

(statearr_14646_14676[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (3))){
var inst_14636 = (state_14638[(2)]);
var state_14638__$1 = state_14638;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14638__$1,inst_14636);
} else {
if((state_val_14639 === (12))){
var inst_14617 = (state_14638[(8)]);
var inst_14619 = fluree.db.index.leaf_QMARK_(inst_14617);
var state_14638__$1 = state_14638;
if(inst_14619){
var statearr_14647_14677 = state_14638__$1;
(statearr_14647_14677[(1)] = (14));

} else {
var statearr_14648_14678 = state_14638__$1;
(statearr_14648_14678[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (2))){
var inst_14609 = (state_14638[(7)]);
var _ = (function (){var statearr_14649 = state_14638;
(statearr_14649[(4)] = cljs.core.cons((5),(state_14638[(4)])));

return statearr_14649;
})();
var inst_14609__$1 = fluree.db.index.branch_QMARK_(branch);
var state_14638__$1 = (function (){var statearr_14650 = state_14638;
(statearr_14650[(7)] = inst_14609__$1);

return statearr_14650;
})();
if(inst_14609__$1){
var statearr_14651_14679 = state_14638__$1;
(statearr_14651_14679[(1)] = (6));

} else {
var statearr_14652_14680 = state_14638__$1;
(statearr_14652_14680[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (11))){
var inst_14633 = (state_14638[(2)]);
var _ = (function (){var statearr_14654 = state_14638;
(statearr_14654[(4)] = cljs.core.rest((state_14638[(4)])));

return statearr_14654;
})();
var state_14638__$1 = state_14638;
var statearr_14655_14681 = state_14638__$1;
(statearr_14655_14681[(2)] = inst_14633);

(statearr_14655_14681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (9))){
var inst_14616 = fluree.db.index.lookup(branch,flake);
var inst_14617 = inst_14616;
var state_14638__$1 = (function (){var statearr_14656 = state_14638;
(statearr_14656[(8)] = inst_14617);

return statearr_14656;
})();
var statearr_14657_14682 = state_14638__$1;
(statearr_14657_14682[(2)] = null);

(statearr_14657_14682[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (5))){
var _ = (function (){var statearr_14658 = state_14638;
(statearr_14658[(4)] = cljs.core.rest((state_14638[(4)])));

return statearr_14658;
})();
var state_14638__$1 = state_14638;
var ex14653 = (state_14638__$1[(2)]);
var statearr_14659_14683 = state_14638__$1;
(statearr_14659_14683[(5)] = ex14653);


if((ex14653 instanceof Error)){
var statearr_14660_14684 = state_14638__$1;
(statearr_14660_14684[(1)] = (4));

(statearr_14660_14684[(5)] = null);

} else {
throw ex14653;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (14))){
var inst_14617 = (state_14638[(8)]);
var state_14638__$1 = state_14638;
var statearr_14661_14685 = state_14638__$1;
(statearr_14661_14685[(2)] = inst_14617);

(statearr_14661_14685[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (16))){
var inst_14628 = (state_14638[(2)]);
var state_14638__$1 = state_14638;
var statearr_14662_14686 = state_14638__$1;
(statearr_14662_14686[(2)] = inst_14628);

(statearr_14662_14686[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (10))){
var state_14638__$1 = state_14638;
var statearr_14663_14687 = state_14638__$1;
(statearr_14663_14687[(2)] = null);

(statearr_14663_14687[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14639 === (8))){
var inst_14614 = (state_14638[(2)]);
var state_14638__$1 = state_14638;
if(cljs.core.truth_(inst_14614)){
var statearr_14664_14688 = state_14638__$1;
(statearr_14664_14688[(1)] = (9));

} else {
var statearr_14665_14689 = state_14638__$1;
(statearr_14665_14689[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$lookup_leaf_$_state_machine__2684__auto__ = null;
var fluree$db$index$lookup_leaf_$_state_machine__2684__auto____0 = (function (){
var statearr_14666 = [null,null,null,null,null,null,null,null,null];
(statearr_14666[(0)] = fluree$db$index$lookup_leaf_$_state_machine__2684__auto__);

(statearr_14666[(1)] = (1));

return statearr_14666;
});
var fluree$db$index$lookup_leaf_$_state_machine__2684__auto____1 = (function (state_14638){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14638);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14667){var ex__2687__auto__ = e14667;
var statearr_14668_14690 = state_14638;
(statearr_14668_14690[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14638[(4)]))){
var statearr_14669_14691 = state_14638;
(statearr_14669_14691[(1)] = cljs.core.first((state_14638[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14692 = state_14638;
state_14638 = G__14692;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$lookup_leaf_$_state_machine__2684__auto__ = function(state_14638){
switch(arguments.length){
case 0:
return fluree$db$index$lookup_leaf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$lookup_leaf_$_state_machine__2684__auto____1.call(this,state_14638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$lookup_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$lookup_leaf_$_state_machine__2684__auto____0;
fluree$db$index$lookup_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$lookup_leaf_$_state_machine__2684__auto____1;
return fluree$db$index$lookup_leaf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14670 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14670[(6)] = c__2706__auto__);

return statearr_14670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.index.add_flakes = (function fluree$db$index$add_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.conj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14693 = new_leaf;
var G__14693__$1 = (((G__14693 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14693));
if((G__14693__$1 == null)){
return null;
} else {
return cljs.core.first(G__14693__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
fluree.db.index.rem_flakes = (function fluree$db$index$rem_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.disj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14694 = new_leaf;
var G__14694__$1 = (((G__14694 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14694));
if((G__14694__$1 == null)){
return null;
} else {
return cljs.core.first(G__14694__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
/**
 * Returns a blank leaf node map for the provided `network`, `ledger-id`, and index
 *   comparator `cmp`.
 */
fluree.db.index.empty_leaf = (function fluree$db$index$empty_leaf(network,ledger_id,cmp){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[(0),ledger_id,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.new_leaf = (function fluree$db$index$new_leaf(network,ledger_id,cmp,flakes){
var empty_set = fluree.db.flake.sorted_set_by(cmp);
return fluree.db.index.add_flakes(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(fluree.db.index.empty_leaf(network,ledger_id,cmp),new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set),flakes);
});
/**
 * Checks if the `node` passed in the second argument is a descendant of the
 *   `branch` passed in the first argument
 */
fluree.db.index.descendant_QMARK_ = (function fluree$db$index$descendant_QMARK_(p__14695,p__14696){
var map__14697 = p__14695;
var map__14697__$1 = cljs.core.__destructure_map(map__14697);
var branch = map__14697__$1;
var cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14697__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14697__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14697__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14697__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var map__14698 = p__14696;
var map__14698__$1 = cljs.core.__destructure_map(map__14698);
var node = map__14698__$1;
var node_first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14698__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var node_rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14698__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
if((!(fluree.db.index.branch_QMARK_(branch)))){
return false;
} else {
var and__5043__auto__ = (function (){var or__5045__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(first_flake,node_first) : cmp.call(null,first_flake,node_first)) > (0))));
}
})();
if(cljs.core.truth_(and__5043__auto__)){
return (((rhs == null)) || ((((!((node_rhs == null)))) && ((!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(node_rhs,rhs) : cmp.call(null,node_rhs,rhs)) > (0))))))));
} else {
return and__5043__auto__;
}
}
});
fluree.db.index.child_entry = (function fluree$db$index$child_entry(p__14699){
var map__14700 = p__14699;
var map__14700__$1 = cljs.core.__destructure_map(map__14700);
var node = map__14700__$1;
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14700__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var child_node = fluree.db.index.unresolve(node);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first,child_node], null);
});
/**
 * Returns avl sorted map whose keys are the first flakes of the index node
 *   sequence `child-nodes`, and whose values are the corresponding nodes from
 *   `child-nodes`.
 */
fluree.db.index.child_map = (function fluree$db$index$child_map(var_args){
var args__5775__auto__ = [];
var len__5769__auto___14703 = arguments.length;
var i__5770__auto___14704 = (0);
while(true){
if((i__5770__auto___14704 < len__5769__auto___14703)){
args__5775__auto__.push((arguments[i__5770__auto___14704]));

var G__14705 = (i__5770__auto___14704 + (1));
i__5770__auto___14704 = G__14705;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic = (function (cmp,child_nodes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,cmp,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(fluree.db.index.child_entry,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_nodes], 0)));
}));

(fluree.db.index.child_map.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.index.child_map.cljs$lang$applyTo = (function (seq14701){
var G__14702 = cljs.core.first(seq14701);
var seq14701__$1 = cljs.core.next(seq14701);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14702,seq14701__$1);
}));

/**
 * Returns a blank branch node which contains a single empty leaf node for the
 *   provided `network`, `ledger-id`, and index comparator `cmp`.
 */
fluree.db.index.empty_branch = (function fluree$db$index$empty_branch(network,ledger_id,cmp){
var child_node = fluree.db.index.empty_leaf(network,ledger_id,cmp);
var children = fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_node], 0));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[children,(0),ledger_id,false,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.reset_children = (function fluree$db$index$reset_children(p__14706,new_child_nodes){
var map__14707 = p__14706;
var map__14707__$1 = cljs.core.__destructure_map(map__14707);
var branch = map__14707__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14707__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14707__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var new_kids = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.index.child_map,comparator,new_child_nodes);
var new_first = (function (){var or__5045__auto__ = (function (){var G__14708 = new_kids;
var G__14708__$1 = (((G__14708 == null))?null:cljs.core.first(G__14708));
if((G__14708__$1 == null)){
return null;
} else {
return cljs.core.key(G__14708__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
var new_size = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),new_child_nodes));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(branch,new cljs.core.Keyword(null,"first","first",-644103046),new_first,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"size","size",1098693007),new_size,new cljs.core.Keyword(null,"children","children",-940561982),new_kids], 0));
});
fluree.db.index.new_branch = (function fluree$db$index$new_branch(network,ledger_id,cmp,child_nodes){
return fluree.db.index.reset_children(fluree.db.index.empty_branch(network,ledger_id,cmp),child_nodes);
});
/**
 * Returns `true` if `flake` has a transaction value after the provided `t`
 */
fluree.db.index.after_t_QMARK_ = (function fluree$db$index$after_t_QMARK_(t,flake){
return (fluree.db.flake.t(flake) < t);
});
/**
 * Returns a sequence containing only flakes from the flake set `flakes` with
 *   transaction values after the provided `t`.
 */
fluree.db.index.filter_after = (function fluree$db$index$filter_after(t,flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t),flakes);
});
/**
 * Returns an avl-subset of the avl-set `flakes` with transaction values on or
 *   before the provided `t`.
 */
fluree.db.index.flakes_through = (function fluree$db$index$flakes_through(t,flakes){
return fluree.db.flake.disj_all(flakes,fluree.db.index.filter_after(t,flakes));
});
fluree.db.index.novelty_subrange = (function fluree$db$index$novelty_subrange(p__14709,through_t,novelty){
var map__14710 = p__14709;
var map__14710__$1 = cljs.core.__destructure_map(map__14710);
var node = map__14710__$1;
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14710__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14710__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14710__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$6 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$6("novelty-subrange: first-flake:",first_flake,"\nrhs:",rhs,"\nleftmost?",leftmost_QMARK_) : fluree.db.util.log.debug.call(null,"novelty-subrange: first-flake:",first_flake,"\nrhs:",rhs,"\nleftmost?",leftmost_QMARK_));

var subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
return fluree.db.index.flakes_through(through_t,subrange);
});
/**
 * Returns a sequence of flakes from the sorted set `flakes` that are out of date
 *   by the transaction `t` because `flakes` contains another flake with the same
 *   subject and predicate and a transaction value later than that flake but on or
 *   before `t`.
 */
fluree.db.index.stale_by = (function fluree$db$index$stale_by(t,flakes){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (flakes__$1){
var last_flake = cljs.core.last(flakes__$1);
if(cljs.core.truth_(fluree.db.flake.op(last_flake))){
return cljs.core.butlast(flakes__$1);
} else {
return flakes__$1;
}
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.s,fluree.db.flake.p,fluree.db.flake.o),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t)),flakes))], 0));
});
/**
 * Returns a sorted set of flakes that are not out of date between the
 *   transactions `from-t` and `to-t`.
 */
fluree.db.index.t_range = (function fluree$db$index$t_range(p__14711,novelty,from_t,to_t){
var map__14712 = p__14711;
var map__14712__$1 = cljs.core.__destructure_map(map__14712);
var leaf = map__14712__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14712__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14712__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var latest = (function (){var G__14713 = flakes;
if((leaf_t > to_t)){
return fluree.db.flake.conj_all(G__14713,fluree.db.index.novelty_subrange(leaf,to_t,novelty));
} else {
return G__14713;
}
})();
var stale_flakes = fluree.db.index.stale_by(from_t,latest);
var subsequent = fluree.db.index.filter_after(to_t,latest);
var out_of_range = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(stale_flakes,subsequent);
return fluree.db.flake.disj_all(latest,out_of_range);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.CachedTRangeResolver = (function (node_resolver,novelty,from_t,to_t,async_cache,__meta,__extmap,__hash){
this.node_resolver = node_resolver;
this.novelty = novelty;
this.from_t = from_t;
this.to_t = to_t;
this.async_cache = async_cache;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (_,p__14719){
var self__ = this;
var map__14720 = p__14719;
var map__14720__$1 = cljs.core.__destructure_map(map__14720);
var node = map__14720__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14720__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14720__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var tt_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14720__$1,new cljs.core.Keyword(null,"tt-id","tt-id",725587484));
var ___$1 = this;
if(fluree.db.index.branch_QMARK_(node)){
return fluree.db.index.resolve(self__.node_resolver,node);
} else {
var G__14721 = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.index","t-range","fluree.db.index/t-range",437950593),id,tempid,tt_id,self__.from_t,self__.to_t], null);
var G__14722 = (function (___$2){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14740){
var state_val_14741 = (state_14740[(1)]);
if((state_val_14741 === (1))){
var state_14740__$1 = state_14740;
var statearr_14742_14777 = state_14740__$1;
(statearr_14742_14777[(2)] = null);

(statearr_14742_14777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (2))){
var ___$3 = (function (){var statearr_14743 = state_14740;
(statearr_14743[(4)] = cljs.core.cons((5),(state_14740[(4)])));

return statearr_14743;
})();
var inst_14729 = fluree.db.index.resolve(self__.node_resolver,node);
var state_14740__$1 = state_14740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14740__$1,(6),inst_14729);
} else {
if((state_val_14741 === (3))){
var inst_14738 = (state_14740[(2)]);
var state_14740__$1 = state_14740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14740__$1,inst_14738);
} else {
if((state_val_14741 === (4))){
var inst_14723 = (state_14740[(2)]);
var state_14740__$1 = state_14740;
var statearr_14745_14778 = state_14740__$1;
(statearr_14745_14778[(2)] = inst_14723);

(statearr_14745_14778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (5))){
var ___$3 = (function (){var statearr_14746 = state_14740;
(statearr_14746[(4)] = cljs.core.rest((state_14740[(4)])));

return statearr_14746;
})();
var state_14740__$1 = state_14740;
var ex14744 = (state_14740__$1[(2)]);
var statearr_14747_14779 = state_14740__$1;
(statearr_14747_14779[(5)] = ex14744);


if((ex14744 instanceof Error)){
var statearr_14748_14780 = state_14740__$1;
(statearr_14748_14780[(1)] = (4));

(statearr_14748_14780[(5)] = null);

} else {
throw ex14744;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14741 === (6))){
var inst_14731 = (state_14740[(2)]);
var inst_14732 = fluree.db.util.async.throw_err(inst_14731);
var inst_14733 = fluree.db.index.t_range(inst_14732,self__.novelty,self__.from_t,self__.to_t);
var inst_14734 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_14732,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_14735 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_14734,new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_14733], 0));
var ___$3 = (function (){var statearr_14749 = state_14740;
(statearr_14749[(4)] = cljs.core.rest((state_14740[(4)])));

return statearr_14749;
})();
var state_14740__$1 = state_14740;
var statearr_14750_14781 = state_14740__$1;
(statearr_14750_14781[(2)] = inst_14735);

(statearr_14750_14781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2684__auto__ = null;
var fluree$db$index$state_machine__2684__auto____0 = (function (){
var statearr_14751 = [null,null,null,null,null,null,null];
(statearr_14751[(0)] = fluree$db$index$state_machine__2684__auto__);

(statearr_14751[(1)] = (1));

return statearr_14751;
});
var fluree$db$index$state_machine__2684__auto____1 = (function (state_14740){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14740);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14752){var ex__2687__auto__ = e14752;
var statearr_14753_14782 = state_14740;
(statearr_14753_14782[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14740[(4)]))){
var statearr_14754_14783 = state_14740;
(statearr_14754_14783[(1)] = cljs.core.first((state_14740[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14784 = state_14740;
state_14740 = G__14784;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$state_machine__2684__auto__ = function(state_14740){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2684__auto____1.call(this,state_14740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2684__auto____0;
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2684__auto____1;
return fluree$db$index$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14755 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14755[(6)] = c__2706__auto__);

return statearr_14755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__14721,G__14722) : self__.async_cache.call(null,G__14721,G__14722));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k14715,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__14756 = k14715;
var G__14756__$1 = (((G__14756 instanceof cljs.core.Keyword))?G__14756.fqn:null);
switch (G__14756__$1) {
case "node-resolver":
return self__.node_resolver;

break;
case "novelty":
return self__.novelty;

break;
case "from-t":
return self__.from_t;

break;
case "to-t":
return self__.to_t;

break;
case "async-cache":
return self__.async_cache;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k14715,else__5346__auto__);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__14757){
var vec__14758 = p__14757;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14758,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14758,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.index.CachedTRangeResolver{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14714){
var self__ = this;
var G__14714__$1 = this;
return (new cljs.core.RecordIter((0),G__14714__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__14761 = (function (coll__5340__auto__){
return (361103374 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__14761(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14716,other14717){
var self__ = this;
var this14716__$1 = this;
return (((!((other14717 == null)))) && ((((this14716__$1.constructor === other14717.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14716__$1.node_resolver,other14717.node_resolver)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14716__$1.novelty,other14717.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14716__$1.from_t,other14717.from_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14716__$1.to_t,other14717.to_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14716__$1.async_cache,other14717.async_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14716__$1.__extmap,other14717.__extmap)))))))))))))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"to-t","to-t",569467359),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k14715){
var self__ = this;
var this__5350__auto____$1 = this;
var G__14762 = k14715;
var G__14762__$1 = (((G__14762 instanceof cljs.core.Keyword))?G__14762.fqn:null);
switch (G__14762__$1) {
case "node-resolver":
case "novelty":
case "from-t":
case "to-t":
case "async-cache":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k14715);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__14714){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__14763 = cljs.core.keyword_identical_QMARK_;
var expr__14764 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__14766 = new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078);
var G__14767 = expr__14764;
return (pred__14763.cljs$core$IFn$_invoke$arity$2 ? pred__14763.cljs$core$IFn$_invoke$arity$2(G__14766,G__14767) : pred__14763.call(null,G__14766,G__14767));
})())){
return (new fluree.db.index.CachedTRangeResolver(G__14714,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14768 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__14769 = expr__14764;
return (pred__14763.cljs$core$IFn$_invoke$arity$2 ? pred__14763.cljs$core$IFn$_invoke$arity$2(G__14768,G__14769) : pred__14763.call(null,G__14768,G__14769));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,G__14714,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14770 = new cljs.core.Keyword(null,"from-t","from-t",1730913525);
var G__14771 = expr__14764;
return (pred__14763.cljs$core$IFn$_invoke$arity$2 ? pred__14763.cljs$core$IFn$_invoke$arity$2(G__14770,G__14771) : pred__14763.call(null,G__14770,G__14771));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,G__14714,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14772 = new cljs.core.Keyword(null,"to-t","to-t",569467359);
var G__14773 = expr__14764;
return (pred__14763.cljs$core$IFn$_invoke$arity$2 ? pred__14763.cljs$core$IFn$_invoke$arity$2(G__14772,G__14773) : pred__14763.call(null,G__14772,G__14773));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,G__14714,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14774 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__14775 = expr__14764;
return (pred__14763.cljs$core$IFn$_invoke$arity$2 ? pred__14763.cljs$core$IFn$_invoke$arity$2(G__14774,G__14775) : pred__14763.call(null,G__14774,G__14775));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,G__14714,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__14714),null));
}
}
}
}
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__14714){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,G__14714,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.index.CachedTRangeResolver.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node-resolver","node-resolver",-1971835691,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"from-t","from-t",-923522244,null),new cljs.core.Symbol(null,"to-t","to-t",-2084968410,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null)], null);
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$type = true);

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.index/CachedTRangeResolver",null,(1),null));
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.index/CachedTRangeResolver");
}));

/**
 * Positional factory function for fluree.db.index/CachedTRangeResolver.
 */
fluree.db.index.__GT_CachedTRangeResolver = (function fluree$db$index$__GT_CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache){
return (new fluree.db.index.CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache,null,null,null));
});

/**
 * Factory function for fluree.db.index/CachedTRangeResolver, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_CachedTRangeResolver = (function fluree$db$index$map__GT_CachedTRangeResolver(G__14718){
var extmap__5385__auto__ = (function (){var G__14776 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14718,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], 0));
if(cljs.core.record_QMARK_(G__14718)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__14776);
} else {
return G__14776;
}
})();
return (new fluree.db.index.CachedTRangeResolver(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078).cljs$core$IFn$_invoke$arity$1(G__14718),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__14718),new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(G__14718),new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(G__14718),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__14718),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Find the value of `leaf` at transaction `t` by adding new flakes from
 *   `idx-novelty` to `leaf` if `t` is newer than `leaf`, or removing flakes later
 *   than `t` from `leaf` if `t` is older than `leaf`.
 */
fluree.db.index.at_t = (function fluree$db$index$at_t(p__14787,t,idx_novelty){
var map__14788 = p__14787;
var map__14788__$1 = cljs.core.__destructure_map(map__14788);
var leaf = map__14788__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14788__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14788__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14788__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14788__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(leaf_t,t)){
return leaf;
} else {
var G__14789 = leaf;
var G__14789__$1 = (((leaf_t > t))?fluree.db.index.add_flakes(G__14789,fluree.db.index.novelty_subrange(leaf,t,idx_novelty)):G__14789);
var G__14789__$2 = (((leaf_t < t))?fluree.db.index.rem_flakes(G__14789__$1,fluree.db.index.filter_after(t,flakes)):G__14789__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__14789__$2,new cljs.core.Keyword(null,"t","t",-1397832519),t);

}
});
fluree.db.index.mark_expanded = (function fluree$db$index$mark_expanded(node){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179),true);
});
fluree.db.index.unmark_expanded = (function fluree$db$index$unmark_expanded(node){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179));
});
fluree.db.index.expanded_QMARK_ = (function fluree$db$index$expanded_QMARK_(node){
return new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179).cljs$core$IFn$_invoke$arity$1(node) === true;
});
fluree.db.index.resolve_when = (function fluree$db$index$resolve_when(r,resolve_QMARK_,error_ch,node){
if(cljs.core.truth_((resolve_QMARK_.cljs$core$IFn$_invoke$arity$1 ? resolve_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : resolve_QMARK_.call(null,node)))){
return fluree.db.index.try_resolve(r,error_ch,node);
} else {
var G__14790 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(G__14790,node);

return G__14790;
}
});
fluree.db.index.resolve_children_when = (function fluree$db$index$resolve_children_when(r,resolve_QMARK_,error_ch,branch){
if(cljs.core.truth_(fluree.db.index.resolved_QMARK_(branch))){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14791){
var vec__14792 = p__14791;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14792,(0),null);
var child = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14792,(1),null);
return fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,child);
}),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(branch)));
} else {
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14797){
var state_val_14798 = (state_14797[(1)]);
if((state_val_14798 === (1))){
var inst_14795 = cljs.core.PersistentVector.EMPTY;
var state_14797__$1 = state_14797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14797__$1,inst_14795);
} else {
return null;
}
});
return (function() {
var fluree$db$index$resolve_children_when_$_state_machine__2684__auto__ = null;
var fluree$db$index$resolve_children_when_$_state_machine__2684__auto____0 = (function (){
var statearr_14799 = [null,null,null,null,null,null,null];
(statearr_14799[(0)] = fluree$db$index$resolve_children_when_$_state_machine__2684__auto__);

(statearr_14799[(1)] = (1));

return statearr_14799;
});
var fluree$db$index$resolve_children_when_$_state_machine__2684__auto____1 = (function (state_14797){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14797);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14800){var ex__2687__auto__ = e14800;
var statearr_14801_14804 = state_14797;
(statearr_14801_14804[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14797[(4)]))){
var statearr_14802_14805 = state_14797;
(statearr_14802_14805[(1)] = cljs.core.first((state_14797[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14806 = state_14797;
state_14797 = G__14806;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$resolve_children_when_$_state_machine__2684__auto__ = function(state_14797){
switch(arguments.length){
case 0:
return fluree$db$index$resolve_children_when_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$resolve_children_when_$_state_machine__2684__auto____1.call(this,state_14797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$resolve_children_when_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$resolve_children_when_$_state_machine__2684__auto____0;
fluree$db$index$resolve_children_when_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$resolve_children_when_$_state_machine__2684__auto____1;
return fluree$db$index$resolve_children_when_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14803 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14803[(6)] = c__2706__auto__);

return statearr_14803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}
});
/**
 * Returns a channel that will eventually contain the stream of index nodes
 *   descended from `root` in depth-first order. `resolve?` is a boolean function
 *   that will be applied to each node to determine whether or not the data
 *   associated with that node will be resolved from disk using the supplied
 *   `Resolver` `r`. `include?` is a boolean function that will be applied to each
 *   node to determine if it will be included in the final output node stream, `n`
 *   is an optional parameter specifying the number of nodes to load concurrently,
 *   and `xf` is an optional transducer that will transform the output stream if
 *   supplied.
 */
fluree.db.index.tree_chan = (function fluree$db$index$tree_chan(var_args){
var G__14808 = arguments.length;
switch (G__14808) {
case 5:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 7:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5 = (function (r,root,resolve_QMARK_,include_QMARK_,error_ch){
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(r,root,resolve_QMARK_,include_QMARK_,(1),cljs.core.identity,error_ch);
}));

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7 = (function (r,root,resolve_QMARK_,include_QMARK_,n,xf,error_ch){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(n,xf);
var c__2706__auto___14886 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14854){
var state_val_14855 = (state_14854[(1)]);
if((state_val_14855 === (7))){
var inst_14849 = (state_14854[(2)]);
var state_14854__$1 = state_14854;
var statearr_14856_14887 = state_14854__$1;
(statearr_14856_14887[(2)] = inst_14849);

(statearr_14856_14887[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (1))){
var inst_14809 = fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,root);
var state_14854__$1 = state_14854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14854__$1,(2),inst_14809);
} else {
if((state_val_14855 === (4))){
var inst_14851 = (state_14854[(2)]);
var inst_14852 = cljs.core.async.close_BANG_(out);
var state_14854__$1 = (function (){var statearr_14857 = state_14854;
(statearr_14857[(7)] = inst_14851);

return statearr_14857;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14854__$1,inst_14852);
} else {
if((state_val_14855 === (15))){
var state_14854__$1 = state_14854;
var statearr_14858_14888 = state_14854__$1;
(statearr_14858_14888[(2)] = null);

(statearr_14858_14888[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (13))){
var inst_14846 = (state_14854[(2)]);
var state_14854__$1 = state_14854;
var statearr_14859_14889 = state_14854__$1;
(statearr_14859_14889[(2)] = inst_14846);

(statearr_14859_14889[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (6))){
var state_14854__$1 = state_14854;
var statearr_14860_14890 = state_14854__$1;
(statearr_14860_14890[(2)] = null);

(statearr_14860_14890[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (17))){
var inst_14831 = (state_14854[(2)]);
var state_14854__$1 = state_14854;
var statearr_14861_14891 = state_14854__$1;
(statearr_14861_14891[(2)] = inst_14831);

(statearr_14861_14891[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (3))){
var inst_14817 = (state_14854[(8)]);
var inst_14815 = (state_14854[(9)]);
var inst_14817__$1 = cljs.core.peek(inst_14815);
var state_14854__$1 = (function (){var statearr_14862 = state_14854;
(statearr_14862[(8)] = inst_14817__$1);

return statearr_14862;
})();
if(cljs.core.truth_(inst_14817__$1)){
var statearr_14863_14892 = state_14854__$1;
(statearr_14863_14892[(1)] = (5));

} else {
var statearr_14864_14893 = state_14854__$1;
(statearr_14864_14893[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (12))){
var inst_14817 = (state_14854[(8)]);
var inst_14837 = fluree.db.index.resolve_children_when(r,resolve_QMARK_,error_ch,inst_14817);
var state_14854__$1 = state_14854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14854__$1,(18),inst_14837);
} else {
if((state_val_14855 === (2))){
var inst_14811 = (state_14854[(2)]);
var inst_14812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14813 = [inst_14811];
var inst_14814 = (new cljs.core.PersistentVector(null,1,(5),inst_14812,inst_14813,null));
var inst_14815 = inst_14814;
var state_14854__$1 = (function (){var statearr_14865 = state_14854;
(statearr_14865[(9)] = inst_14815);

return statearr_14865;
})();
var statearr_14866_14894 = state_14854__$1;
(statearr_14866_14894[(2)] = null);

(statearr_14866_14894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (11))){
var inst_14817 = (state_14854[(8)]);
var inst_14827 = (include_QMARK_.cljs$core$IFn$_invoke$arity$1 ? include_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_14817) : include_QMARK_.call(null,inst_14817));
var state_14854__$1 = state_14854;
if(cljs.core.truth_(inst_14827)){
var statearr_14867_14895 = state_14854__$1;
(statearr_14867_14895[(1)] = (14));

} else {
var statearr_14868_14896 = state_14854__$1;
(statearr_14868_14896[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (9))){
var inst_14817 = (state_14854[(8)]);
var inst_14823 = fluree.db.index.expanded_QMARK_(inst_14817);
var state_14854__$1 = state_14854;
var statearr_14869_14897 = state_14854__$1;
(statearr_14869_14897[(2)] = inst_14823);

(statearr_14869_14897[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (5))){
var inst_14820 = (state_14854[(10)]);
var inst_14817 = (state_14854[(8)]);
var inst_14815 = (state_14854[(9)]);
var inst_14819 = cljs.core.pop(inst_14815);
var inst_14820__$1 = fluree.db.index.leaf_QMARK_(inst_14817);
var state_14854__$1 = (function (){var statearr_14870 = state_14854;
(statearr_14870[(10)] = inst_14820__$1);

(statearr_14870[(11)] = inst_14819);

return statearr_14870;
})();
if(inst_14820__$1){
var statearr_14871_14898 = state_14854__$1;
(statearr_14871_14898[(1)] = (8));

} else {
var statearr_14872_14899 = state_14854__$1;
(statearr_14872_14899[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (14))){
var inst_14817 = (state_14854[(8)]);
var inst_14829 = fluree.db.index.unmark_expanded(inst_14817);
var state_14854__$1 = state_14854;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14854__$1,(17),out,inst_14829);
} else {
if((state_val_14855 === (16))){
var inst_14819 = (state_14854[(11)]);
var inst_14834 = (state_14854[(2)]);
var inst_14815 = inst_14819;
var state_14854__$1 = (function (){var statearr_14873 = state_14854;
(statearr_14873[(9)] = inst_14815);

(statearr_14873[(12)] = inst_14834);

return statearr_14873;
})();
var statearr_14874_14900 = state_14854__$1;
(statearr_14874_14900[(2)] = null);

(statearr_14874_14900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (10))){
var inst_14825 = (state_14854[(2)]);
var state_14854__$1 = state_14854;
if(cljs.core.truth_(inst_14825)){
var statearr_14875_14901 = state_14854__$1;
(statearr_14875_14901[(1)] = (11));

} else {
var statearr_14876_14902 = state_14854__$1;
(statearr_14876_14902[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (18))){
var inst_14819 = (state_14854[(11)]);
var inst_14817 = (state_14854[(8)]);
var inst_14839 = (state_14854[(2)]);
var inst_14840 = fluree.db.index.mark_expanded(inst_14817);
var inst_14841 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14819,inst_14840);
var inst_14842 = cljs.core.rseq(inst_14839);
var inst_14843 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14841,inst_14842);
var inst_14815 = inst_14843;
var state_14854__$1 = (function (){var statearr_14877 = state_14854;
(statearr_14877[(9)] = inst_14815);

return statearr_14877;
})();
var statearr_14878_14903 = state_14854__$1;
(statearr_14878_14903[(2)] = null);

(statearr_14878_14903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14855 === (8))){
var inst_14820 = (state_14854[(10)]);
var state_14854__$1 = state_14854;
var statearr_14879_14904 = state_14854__$1;
(statearr_14879_14904[(2)] = inst_14820);

(statearr_14879_14904[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2684__auto__ = null;
var fluree$db$index$state_machine__2684__auto____0 = (function (){
var statearr_14880 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14880[(0)] = fluree$db$index$state_machine__2684__auto__);

(statearr_14880[(1)] = (1));

return statearr_14880;
});
var fluree$db$index$state_machine__2684__auto____1 = (function (state_14854){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14854);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14881){var ex__2687__auto__ = e14881;
var statearr_14882_14905 = state_14854;
(statearr_14882_14905[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14854[(4)]))){
var statearr_14883_14906 = state_14854;
(statearr_14883_14906[(1)] = cljs.core.first((state_14854[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14907 = state_14854;
state_14854 = G__14907;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$state_machine__2684__auto__ = function(state_14854){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2684__auto____1.call(this,state_14854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2684__auto____0;
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2684__auto____1;
return fluree$db$index$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14884 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14884[(6)] = c__2706__auto___14886);

return statearr_14884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return out;
}));

(fluree.db.index.tree_chan.cljs$lang$maxFixedArity = 7);

