// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16011){
var state_val_16012 = (state_16011[(1)]);
if((state_val_16012 === (1))){
var state_16011__$1 = state_16011;
var statearr_16013_16027 = state_16011__$1;
(statearr_16013_16027[(2)] = null);

(statearr_16013_16027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16012 === (2))){
var _ = (function (){var statearr_16014 = state_16011;
(statearr_16014[(4)] = cljs.core.cons((5),(state_16011[(4)])));

return statearr_16014;
})();
var inst_16002 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_16011__$1 = state_16011;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16011__$1,(6),inst_16002);
} else {
if((state_val_16012 === (3))){
var inst_16009 = (state_16011[(2)]);
var state_16011__$1 = state_16011;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16011__$1,inst_16009);
} else {
if((state_val_16012 === (4))){
var inst_15996 = (state_16011[(2)]);
var state_16011__$1 = state_16011;
var statearr_16016_16028 = state_16011__$1;
(statearr_16016_16028[(2)] = inst_15996);

(statearr_16016_16028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16012 === (5))){
var _ = (function (){var statearr_16017 = state_16011;
(statearr_16017[(4)] = cljs.core.rest((state_16011[(4)])));

return statearr_16017;
})();
var state_16011__$1 = state_16011;
var ex16015 = (state_16011__$1[(2)]);
var statearr_16018_16029 = state_16011__$1;
(statearr_16018_16029[(5)] = ex16015);


if((ex16015 instanceof Error)){
var statearr_16019_16030 = state_16011__$1;
(statearr_16019_16030[(1)] = (4));

(statearr_16019_16030[(5)] = null);

} else {
throw ex16015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16012 === (6))){
var inst_16004 = (state_16011[(2)]);
var inst_16005 = fluree.db.util.async.throw_err(inst_16004);
var inst_16006 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_16005);
var _ = (function (){var statearr_16020 = state_16011;
(statearr_16020[(4)] = cljs.core.rest((state_16011[(4)])));

return statearr_16020;
})();
var state_16011__$1 = state_16011;
var statearr_16021_16031 = state_16011__$1;
(statearr_16021_16031[(2)] = inst_16006);

(statearr_16021_16031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0 = (function (){
var statearr_16022 = [null,null,null,null,null,null,null];
(statearr_16022[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__);

(statearr_16022[(1)] = (1));

return statearr_16022;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1 = (function (state_16011){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16011);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16023){var ex__2687__auto__ = e16023;
var statearr_16024_16032 = state_16011;
(statearr_16024_16032[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16011[(4)]))){
var statearr_16025_16033 = state_16011;
(statearr_16025_16033[(1)] = cljs.core.first((state_16011[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16034 = state_16011;
state_16011 = G__16034;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__ = function(state_16011){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1.call(this,state_16011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16026 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16026[(6)] = c__2706__auto__);

return statearr_16026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16066){
var state_val_16067 = (state_16066[(1)]);
if((state_val_16067 === (7))){
var inst_16050 = (state_16066[(7)]);
var inst_16052 = cljs.core.empty_QMARK_(inst_16050);
var inst_16053 = (!(inst_16052));
var state_16066__$1 = state_16066;
var statearr_16068_16092 = state_16066__$1;
(statearr_16068_16092[(2)] = inst_16053);

(statearr_16068_16092[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16067 === (1))){
var state_16066__$1 = state_16066;
var statearr_16069_16093 = state_16066__$1;
(statearr_16069_16093[(2)] = null);

(statearr_16069_16093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16067 === (4))){
var inst_16036 = (state_16066[(2)]);
var state_16066__$1 = state_16066;
var statearr_16070_16094 = state_16066__$1;
(statearr_16070_16094[(2)] = inst_16036);

(statearr_16070_16094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16067 === (6))){
var inst_16050 = (state_16066[(7)]);
var inst_16042 = (state_16066[(8)]);
var inst_16048 = (state_16066[(2)]);
var inst_16049 = fluree.db.util.async.throw_err(inst_16048);
var inst_16050__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16042,inst_16049);
var state_16066__$1 = (function (){var statearr_16071 = state_16066;
(statearr_16071[(7)] = inst_16050__$1);

return statearr_16071;
})();
if(cljs.core.truth_(inst_16050__$1)){
var statearr_16072_16095 = state_16066__$1;
(statearr_16072_16095[(1)] = (7));

} else {
var statearr_16073_16096 = state_16066__$1;
(statearr_16073_16096[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16067 === (3))){
var inst_16064 = (state_16066[(2)]);
var state_16066__$1 = state_16066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16066__$1,inst_16064);
} else {
if((state_val_16067 === (12))){
var inst_16061 = (state_16066[(2)]);
var _ = (function (){var statearr_16074 = state_16066;
(statearr_16074[(4)] = cljs.core.rest((state_16066[(4)])));

return statearr_16074;
})();
var state_16066__$1 = state_16066;
var statearr_16075_16097 = state_16066__$1;
(statearr_16075_16097[(2)] = inst_16061);

(statearr_16075_16097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16067 === (2))){
var _ = (function (){var statearr_16076 = state_16066;
(statearr_16076[(4)] = cljs.core.cons((5),(state_16066[(4)])));

return statearr_16076;
})();
var inst_16042 = (function (){return (function (p1__16035_SHARP_){
return fluree.db.flake.o(p1__16035_SHARP_);
});
})();
var inst_16043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16044 = [pred_id];
var inst_16045 = (new cljs.core.PersistentVector(null,1,(5),inst_16043,inst_16044,null));
var inst_16046 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16045);
var state_16066__$1 = (function (){var statearr_16077 = state_16066;
(statearr_16077[(8)] = inst_16042);

return statearr_16077;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16066__$1,(6),inst_16046);
} else {
if((state_val_16067 === (11))){
var state_16066__$1 = state_16066;
var statearr_16079_16098 = state_16066__$1;
(statearr_16079_16098[(2)] = true);

(statearr_16079_16098[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16067 === (9))){
var inst_16056 = (state_16066[(2)]);
var state_16066__$1 = state_16066;
if(cljs.core.truth_(inst_16056)){
var statearr_16080_16099 = state_16066__$1;
(statearr_16080_16099[(1)] = (10));

} else {
var statearr_16081_16100 = state_16066__$1;
(statearr_16081_16100[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16067 === (5))){
var _ = (function (){var statearr_16082 = state_16066;
(statearr_16082[(4)] = cljs.core.rest((state_16066[(4)])));

return statearr_16082;
})();
var state_16066__$1 = state_16066;
var ex16078 = (state_16066__$1[(2)]);
var statearr_16083_16101 = state_16066__$1;
(statearr_16083_16101[(5)] = ex16078);


if((ex16078 instanceof Error)){
var statearr_16084_16102 = state_16066__$1;
(statearr_16084_16102[(1)] = (4));

(statearr_16084_16102[(5)] = null);

} else {
throw ex16078;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16067 === (10))){
var inst_16050 = (state_16066[(7)]);
var inst_16058 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_16050);
var state_16066__$1 = state_16066;
var statearr_16085_16103 = state_16066__$1;
(statearr_16085_16103[(2)] = inst_16058);

(statearr_16085_16103[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16067 === (8))){
var inst_16050 = (state_16066[(7)]);
var state_16066__$1 = state_16066;
var statearr_16086_16104 = state_16066__$1;
(statearr_16086_16104[(2)] = inst_16050);

(statearr_16086_16104[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_16087 = [null,null,null,null,null,null,null,null,null];
(statearr_16087[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__);

(statearr_16087[(1)] = (1));

return statearr_16087;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1 = (function (state_16066){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16066);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16088){var ex__2687__auto__ = e16088;
var statearr_16089_16105 = state_16066;
(statearr_16089_16105[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16066[(4)]))){
var statearr_16090_16106 = state_16066;
(statearr_16090_16106[(1)] = cljs.core.first((state_16066[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16107 = state_16066;
state_16066 = G__16107;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__ = function(state_16066){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1.call(this,state_16066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16091 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16091[(6)] = c__2706__auto__);

return statearr_16091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16188){
var state_val_16189 = (state_16188[(1)]);
if((state_val_16189 === (7))){
var state_16188__$1 = state_16188;
var statearr_16190_16228 = state_16188__$1;
(statearr_16190_16228[(2)] = flakes);

(statearr_16190_16228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (20))){
var inst_16145 = (state_16188[(7)]);
var inst_16178 = (state_16188[(2)]);
var inst_16137 = inst_16145;
var inst_16138 = inst_16178;
var state_16188__$1 = (function (){var statearr_16191 = state_16188;
(statearr_16191[(8)] = inst_16138);

(statearr_16191[(9)] = inst_16137);

return statearr_16191;
})();
var statearr_16192_16229 = state_16188__$1;
(statearr_16192_16229[(2)] = null);

(statearr_16192_16229[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (1))){
var state_16188__$1 = state_16188;
var statearr_16193_16230 = state_16188__$1;
(statearr_16193_16230[(2)] = null);

(statearr_16193_16230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (4))){
var inst_16110 = (state_16188[(2)]);
var state_16188__$1 = state_16188;
var statearr_16194_16231 = state_16188__$1;
(statearr_16194_16231[(2)] = inst_16110);

(statearr_16194_16231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (15))){
var inst_16144 = (state_16188[(10)]);
var inst_16162 = fluree.db.flake.o(inst_16144);
var state_16188__$1 = state_16188;
var statearr_16195_16232 = state_16188__$1;
(statearr_16195_16232[(2)] = inst_16162);

(statearr_16195_16232[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (13))){
var inst_16181 = (state_16188[(2)]);
var state_16188__$1 = state_16188;
var statearr_16196_16233 = state_16188__$1;
(statearr_16196_16233[(2)] = inst_16181);

(statearr_16196_16233[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (6))){
var inst_16117 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16188__$1 = state_16188;
var statearr_16197_16234 = state_16188__$1;
(statearr_16197_16234[(2)] = inst_16117);

(statearr_16197_16234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (17))){
var inst_16159 = (state_16188[(2)]);
var inst_16160 = fluree.db.util.async.throw_err(inst_16159);
var state_16188__$1 = state_16188;
var statearr_16198_16235 = state_16188__$1;
(statearr_16198_16235[(2)] = inst_16160);

(statearr_16198_16235[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (3))){
var inst_16186 = (state_16188[(2)]);
var state_16188__$1 = state_16188;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16188__$1,inst_16186);
} else {
if((state_val_16189 === (12))){
var inst_16151 = (state_16188[(11)]);
var inst_16144 = (state_16188[(10)]);
var inst_16149 = fluree.db.flake.p(inst_16144);
var inst_16150 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16149);
var inst_16151__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_16150);
var inst_16152 = fluree.db.flake.op(inst_16144);
var inst_16153 = inst_16152 === false;
var inst_16154 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_16151__$1);
var state_16188__$1 = (function (){var statearr_16199 = state_16188;
(statearr_16199[(12)] = inst_16153);

(statearr_16199[(11)] = inst_16151__$1);

return statearr_16199;
})();
if(inst_16154){
var statearr_16200_16236 = state_16188__$1;
(statearr_16200_16236[(1)] = (14));

} else {
var statearr_16201_16237 = state_16188__$1;
(statearr_16201_16237[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (2))){
var _ = (function (){var statearr_16202 = state_16188;
(statearr_16202[(4)] = cljs.core.cons((5),(state_16188[(4)])));

return statearr_16202;
})();
var state_16188__$1 = state_16188;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16203_16238 = state_16188__$1;
(statearr_16203_16238[(1)] = (6));

} else {
var statearr_16204_16239 = state_16188__$1;
(statearr_16204_16239[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (19))){
var inst_16164 = (state_16188[(13)]);
var inst_16138 = (state_16188[(8)]);
var inst_16151 = (state_16188[(11)]);
var inst_16144 = (state_16188[(10)]);
var inst_16172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16173 = fluree.db.flake.s(inst_16144);
var inst_16174 = [inst_16173,inst_16151,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16175 = (new cljs.core.PersistentVector(null,3,(5),inst_16172,inst_16174,null));
var inst_16176 = cljs.core.assoc_in(inst_16138,inst_16175,inst_16164);
var state_16188__$1 = state_16188;
var statearr_16205_16240 = state_16188__$1;
(statearr_16205_16240[(2)] = inst_16176);

(statearr_16205_16240[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (11))){
var inst_16138 = (state_16188[(8)]);
var state_16188__$1 = state_16188;
var statearr_16207_16241 = state_16188__$1;
(statearr_16207_16241[(2)] = inst_16138);

(statearr_16207_16241[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (9))){
var inst_16137 = (state_16188[(9)]);
var inst_16144 = (state_16188[(10)]);
var inst_16143 = cljs.core.seq(inst_16137);
var inst_16144__$1 = cljs.core.first(inst_16143);
var inst_16145 = cljs.core.next(inst_16143);
var inst_16146 = cljs.core.not(inst_16144__$1);
var state_16188__$1 = (function (){var statearr_16208 = state_16188;
(statearr_16208[(7)] = inst_16145);

(statearr_16208[(10)] = inst_16144__$1);

return statearr_16208;
})();
if(inst_16146){
var statearr_16209_16242 = state_16188__$1;
(statearr_16209_16242[(1)] = (11));

} else {
var statearr_16210_16243 = state_16188__$1;
(statearr_16210_16243[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (5))){
var _ = (function (){var statearr_16211 = state_16188;
(statearr_16211[(4)] = cljs.core.rest((state_16188[(4)])));

return statearr_16211;
})();
var state_16188__$1 = state_16188;
var ex16206 = (state_16188__$1[(2)]);
var statearr_16212_16244 = state_16188__$1;
(statearr_16212_16244[(5)] = ex16206);


if((ex16206 instanceof Error)){
var statearr_16213_16245 = state_16188__$1;
(statearr_16213_16245[(1)] = (4));

(statearr_16213_16245[(5)] = null);

} else {
throw ex16206;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (14))){
var inst_16144 = (state_16188[(10)]);
var inst_16156 = fluree.db.flake.o(inst_16144);
var inst_16157 = fluree.db.query.schema.convert_type_to_kw(inst_16156,db);
var state_16188__$1 = state_16188;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16188__$1,(17),inst_16157);
} else {
if((state_val_16189 === (16))){
var inst_16153 = (state_16188[(12)]);
var inst_16164 = (state_16188[(2)]);
var state_16188__$1 = (function (){var statearr_16214 = state_16188;
(statearr_16214[(13)] = inst_16164);

return statearr_16214;
})();
if(cljs.core.truth_(inst_16153)){
var statearr_16215_16246 = state_16188__$1;
(statearr_16215_16246[(1)] = (18));

} else {
var statearr_16216_16247 = state_16188__$1;
(statearr_16216_16247[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (10))){
var inst_16183 = (state_16188[(2)]);
var _ = (function (){var statearr_16217 = state_16188;
(statearr_16217[(4)] = cljs.core.rest((state_16188[(4)])));

return statearr_16217;
})();
var state_16188__$1 = state_16188;
var statearr_16218_16248 = state_16188__$1;
(statearr_16218_16248[(2)] = inst_16183);

(statearr_16218_16248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (18))){
var inst_16164 = (state_16188[(13)]);
var inst_16138 = (state_16188[(8)]);
var inst_16151 = (state_16188[(11)]);
var inst_16144 = (state_16188[(10)]);
var inst_16166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16167 = fluree.db.flake.s(inst_16144);
var inst_16168 = [inst_16167,inst_16151,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16169 = (new cljs.core.PersistentVector(null,3,(5),inst_16166,inst_16168,null));
var inst_16170 = cljs.core.assoc_in(inst_16138,inst_16169,inst_16164);
var state_16188__$1 = state_16188;
var statearr_16219_16249 = state_16188__$1;
(statearr_16219_16249[(2)] = inst_16170);

(statearr_16219_16249[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16189 === (8))){
var inst_16120 = (state_16188[(2)]);
var inst_16121 = cljs.core.PersistentHashSet.EMPTY;
var inst_16122 = cljs.core.vals(tempids);
var inst_16123 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16121,inst_16122);
var inst_16124 = (function (){var pred_flakes = inst_16120;
var is_new_QMARK_ = inst_16123;
return (function (p1__16109_SHARP_,p2__16108_SHARP_){
var f = p2__16108_SHARP_;
return cljs.core.assoc_in(p1__16109_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s(f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__16220 = fluree.db.flake.s(f);
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__16220) : is_new_QMARK_.call(null,G__16220));
})()));
});
})();
var inst_16125 = cljs.core.PersistentHashMap.EMPTY;
var inst_16126 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16124,inst_16125,inst_16120);
var inst_16134 = cljs.core.seq(inst_16120);
var inst_16135 = cljs.core.first(inst_16134);
var inst_16136 = cljs.core.next(inst_16134);
var inst_16137 = inst_16120;
var inst_16138 = inst_16126;
var state_16188__$1 = (function (){var statearr_16221 = state_16188;
(statearr_16221[(8)] = inst_16138);

(statearr_16221[(9)] = inst_16137);

(statearr_16221[(14)] = inst_16136);

(statearr_16221[(15)] = inst_16135);

return statearr_16221;
})();
var statearr_16222_16250 = state_16188__$1;
(statearr_16222_16250[(2)] = null);

(statearr_16222_16250[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0 = (function (){
var statearr_16223 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16223[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__);

(statearr_16223[(1)] = (1));

return statearr_16223;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1 = (function (state_16188){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16188);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16224){var ex__2687__auto__ = e16224;
var statearr_16225_16251 = state_16188;
(statearr_16225_16251[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16188[(4)]))){
var statearr_16226_16252 = state_16188;
(statearr_16226_16252[(1)] = cljs.core.first((state_16188[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16253 = state_16188;
state_16188 = G__16253;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__ = function(state_16188){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1.call(this,state_16188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16227 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16227[(6)] = c__2706__auto__);

return statearr_16227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16255 = arguments.length;
switch (G__16255) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16258 = arguments.length;
switch (G__16258) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16570){
var state_val_16571 = (state_16570[(1)]);
if((state_val_16571 === (121))){
var inst_16525 = (state_16570[(7)]);
var state_16570__$1 = state_16570;
var statearr_16572_16765 = state_16570__$1;
(statearr_16572_16765[(2)] = inst_16525);

(statearr_16572_16765[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (65))){
var inst_16424 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16424)){
var statearr_16573_16766 = state_16570__$1;
(statearr_16573_16766[(1)] = (66));

} else {
var statearr_16574_16767 = state_16570__$1;
(statearr_16574_16767[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (70))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16434 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16435 = (inst_16430.cljs$core$IFn$_invoke$arity$5 ? inst_16430.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16434,null) : inst_16430.call(null,cljs.core.PersistentArrayMap,null,3,inst_16434,null));
var inst_16436 = (inst_16430.cljs$core$IFn$_invoke$arity$4 ? inst_16430.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16435,null) : inst_16430.call(null,cljs.core.PersistentHashSet,null,inst_16435,null));
var inst_16437 = (inst_16436.cljs$core$IFn$_invoke$arity$1 ? inst_16436.cljs$core$IFn$_invoke$arity$1(inst_16429) : inst_16436.call(null,inst_16429));
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16437)){
var statearr_16575_16768 = state_16570__$1;
(statearr_16575_16768[(1)] = (72));

} else {
var statearr_16576_16769 = state_16570__$1;
(statearr_16576_16769[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (62))){
var inst_16414 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16577_16770 = state_16570__$1;
(statearr_16577_16770[(2)] = inst_16414);

(statearr_16577_16770[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (74))){
var inst_16520 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16578_16771 = state_16570__$1;
(statearr_16578_16771[(2)] = inst_16520);

(statearr_16578_16771[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (110))){
var inst_16547 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16547)){
var statearr_16579_16772 = state_16570__$1;
(statearr_16579_16772[(1)] = (117));

} else {
var statearr_16580_16773 = state_16570__$1;
(statearr_16580_16773[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (7))){
var inst_16565 = (state_16570[(2)]);
var _ = (function (){var statearr_16581 = state_16570;
(statearr_16581[(4)] = cljs.core.rest((state_16570[(4)])));

return statearr_16581;
})();
var state_16570__$1 = state_16570;
var statearr_16582_16774 = state_16570__$1;
(statearr_16582_16774[(2)] = inst_16565);

(statearr_16582_16774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (59))){
var inst_16418 = (state_16570[(10)]);
var inst_16298 = (state_16570[(11)]);
var inst_16417 = (state_16570[(2)]);
var inst_16418__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16298);
var state_16570__$1 = (function (){var statearr_16583 = state_16570;
(statearr_16583[(10)] = inst_16418__$1);

(statearr_16583[(12)] = inst_16417);

return statearr_16583;
})();
if(cljs.core.truth_(inst_16418__$1)){
var statearr_16584_16775 = state_16570__$1;
(statearr_16584_16775[(1)] = (63));

} else {
var statearr_16585_16776 = state_16570__$1;
(statearr_16585_16776[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (86))){
var inst_16460 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16586_16777 = state_16570__$1;
(statearr_16586_16777[(2)] = inst_16460);

(statearr_16586_16777[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (20))){
var inst_16298 = (state_16570[(11)]);
var inst_16324 = (state_16570[(13)]);
var inst_16324__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16298);
var state_16570__$1 = (function (){var statearr_16587 = state_16570;
(statearr_16587[(13)] = inst_16324__$1);

return statearr_16587;
})();
if(cljs.core.truth_(inst_16324__$1)){
var statearr_16588_16778 = state_16570__$1;
(statearr_16588_16778[(1)] = (23));

} else {
var statearr_16589_16779 = state_16570__$1;
(statearr_16589_16779[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (72))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16439 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16429,inst_16430,throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16590_16780 = state_16570__$1;
(statearr_16590_16780[(2)] = inst_16439);

(statearr_16590_16780[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (58))){
var inst_16379 = (state_16570[(14)]);
var state_16570__$1 = state_16570;
var statearr_16591_16781 = state_16570__$1;
(statearr_16591_16781[(2)] = inst_16379);

(statearr_16591_16781[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (60))){
var inst_16286 = (state_16570[(15)]);
var inst_16297 = (state_16570[(16)]);
var inst_16405 = fluree.db.dbproto._p_prop(inst_16286,new cljs.core.Keyword(null,"name","name",1843675177),inst_16297);
var inst_16406 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16405)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16407 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16408 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16409 = cljs.core.PersistentHashMap.fromArrays(inst_16407,inst_16408);
var inst_16410 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16406,inst_16409);
var inst_16411 = (function(){throw inst_16410})();
var state_16570__$1 = state_16570;
var statearr_16592_16782 = state_16570__$1;
(statearr_16592_16782[(2)] = inst_16411);

(statearr_16592_16782[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (27))){
var inst_16327 = (state_16570[(17)]);
var state_16570__$1 = state_16570;
var statearr_16593_16783 = state_16570__$1;
(statearr_16593_16783[(2)] = inst_16327);

(statearr_16593_16783[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (1))){
var state_16570__$1 = state_16570;
var statearr_16594_16784 = state_16570__$1;
(statearr_16594_16784[(2)] = null);

(statearr_16594_16784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (69))){
var inst_16417 = (state_16570[(12)]);
var state_16570__$1 = state_16570;
var statearr_16595_16785 = state_16570__$1;
(statearr_16595_16785[(2)] = inst_16417);

(statearr_16595_16785[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (101))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16498 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16429,inst_16430,throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16596_16786 = state_16570__$1;
(statearr_16596_16786[(2)] = inst_16498);

(statearr_16596_16786[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (24))){
var inst_16324 = (state_16570[(13)]);
var state_16570__$1 = state_16570;
var statearr_16597_16787 = state_16570__$1;
(statearr_16597_16787[(2)] = inst_16324);

(statearr_16597_16787[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (102))){
var inst_16500 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16598_16788 = state_16570__$1;
(statearr_16598_16788[(2)] = inst_16500);

(statearr_16598_16788[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (55))){
var inst_16396 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16599_16789 = state_16570__$1;
(statearr_16599_16789[(2)] = inst_16396);

(statearr_16599_16789[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (85))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16458 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16429,inst_16430,throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16600_16790 = state_16570__$1;
(statearr_16600_16790[(2)] = inst_16458);

(statearr_16600_16790[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (39))){
var inst_16361 = (state_16570[(18)]);
var state_16570__$1 = state_16570;
var statearr_16601_16791 = state_16570__$1;
(statearr_16601_16791[(2)] = inst_16361);

(statearr_16601_16791[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (88))){
var inst_16417 = (state_16570[(12)]);
var state_16570__$1 = state_16570;
var statearr_16602_16792 = state_16570__$1;
(statearr_16602_16792[(2)] = inst_16417);

(statearr_16602_16792[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (46))){
var inst_16298 = (state_16570[(11)]);
var inst_16380 = (state_16570[(19)]);
var inst_16379 = (state_16570[(2)]);
var inst_16380__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16298);
var state_16570__$1 = (function (){var statearr_16603 = state_16570;
(statearr_16603[(19)] = inst_16380__$1);

(statearr_16603[(14)] = inst_16379);

return statearr_16603;
})();
if(cljs.core.truth_(inst_16380__$1)){
var statearr_16604_16793 = state_16570__$1;
(statearr_16604_16793[(1)] = (47));

} else {
var statearr_16605_16794 = state_16570__$1;
(statearr_16605_16794[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (4))){
var inst_16259 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16606_16795 = state_16570__$1;
(statearr_16606_16795[(2)] = inst_16259);

(statearr_16606_16795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (77))){
var inst_16518 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16607_16796 = state_16570__$1;
(statearr_16607_16796[(2)] = inst_16518);

(statearr_16607_16796[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (106))){
var inst_16510 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16608_16797 = state_16570__$1;
(statearr_16608_16797[(2)] = inst_16510);

(statearr_16608_16797[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (119))){
var inst_16296 = (state_16570[(20)]);
var inst_16560 = (state_16570[(2)]);
var inst_16285 = inst_16296;
var inst_16286 = inst_16560;
var state_16570__$1 = (function (){var statearr_16609 = state_16570;
(statearr_16609[(15)] = inst_16286);

(statearr_16609[(21)] = inst_16285);

return statearr_16609;
})();
var statearr_16610_16798 = state_16570__$1;
(statearr_16610_16798[(2)] = null);

(statearr_16610_16798[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (95))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16482 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16483 = (inst_16430.cljs$core$IFn$_invoke$arity$5 ? inst_16430.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16482,null) : inst_16430.call(null,cljs.core.PersistentArrayMap,null,5,inst_16482,null));
var inst_16484 = (inst_16430.cljs$core$IFn$_invoke$arity$4 ? inst_16430.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16483,null) : inst_16430.call(null,cljs.core.PersistentHashSet,null,inst_16483,null));
var inst_16485 = (inst_16484.cljs$core$IFn$_invoke$arity$1 ? inst_16484.cljs$core$IFn$_invoke$arity$1(inst_16429) : inst_16484.call(null,inst_16429));
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16485)){
var statearr_16611_16799 = state_16570__$1;
(statearr_16611_16799[(1)] = (96));

} else {
var statearr_16612_16800 = state_16570__$1;
(statearr_16612_16800[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (54))){
var inst_16387 = (state_16570[(22)]);
var state_16570__$1 = state_16570;
var statearr_16613_16801 = state_16570__$1;
(statearr_16613_16801[(2)] = inst_16387);

(statearr_16613_16801[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (92))){
var inst_16417 = (state_16570[(12)]);
var state_16570__$1 = state_16570;
var statearr_16614_16802 = state_16570__$1;
(statearr_16614_16802[(2)] = inst_16417);

(statearr_16614_16802[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (104))){
var inst_16417 = (state_16570[(12)]);
var state_16570__$1 = state_16570;
var statearr_16615_16803 = state_16570__$1;
(statearr_16615_16803[(2)] = inst_16417);

(statearr_16615_16803[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (15))){
var inst_16306 = (state_16570[(23)]);
var state_16570__$1 = state_16570;
var statearr_16616_16804 = state_16570__$1;
(statearr_16616_16804[(2)] = inst_16306);

(statearr_16616_16804[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (48))){
var inst_16380 = (state_16570[(19)]);
var state_16570__$1 = state_16570;
var statearr_16617_16805 = state_16570__$1;
(statearr_16617_16805[(2)] = inst_16380);

(statearr_16617_16805[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (50))){
var inst_16387 = (state_16570[(22)]);
var inst_16298 = (state_16570[(11)]);
var inst_16385 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16386 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16385);
var inst_16387__$1 = inst_16386 === true;
var state_16570__$1 = (function (){var statearr_16618 = state_16570;
(statearr_16618[(22)] = inst_16387__$1);

return statearr_16618;
})();
if(cljs.core.truth_(inst_16387__$1)){
var statearr_16619_16806 = state_16570__$1;
(statearr_16619_16806[(1)] = (53));

} else {
var statearr_16620_16807 = state_16570__$1;
(statearr_16620_16807[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (116))){
var inst_16541 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16621_16808 = state_16570__$1;
(statearr_16621_16808[(2)] = inst_16541);

(statearr_16621_16808[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (75))){
var inst_16430 = (state_16570[(8)]);
var state_16570__$1 = state_16570;
var G__16622_16809 = inst_16430;
var G__16622_16810__$1 = (((G__16622_16809 instanceof cljs.core.Keyword))?G__16622_16809.fqn:null);
switch (G__16622_16810__$1) {
case "long":
var statearr_16623_16812 = state_16570__$1;
(statearr_16623_16812[(1)] = (79));


break;
case "bigint":
var statearr_16624_16813 = state_16570__$1;
(statearr_16624_16813[(1)] = (83));


break;
case "double":
var statearr_16625_16814 = state_16570__$1;
(statearr_16625_16814[(1)] = (87));


break;
case "float":
var statearr_16626_16815 = state_16570__$1;
(statearr_16626_16815[(1)] = (91));


break;
case "bigdec":
var statearr_16627_16816 = state_16570__$1;
(statearr_16627_16816[(1)] = (95));


break;
case "string":
var statearr_16628_16817 = state_16570__$1;
(statearr_16628_16817[(1)] = (99));


break;
case "instant":
var statearr_16629_16818 = state_16570__$1;
(statearr_16629_16818[(1)] = (103));


break;
default:
var statearr_16630_16819 = state_16570__$1;
(statearr_16630_16819[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (99))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16492 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16493 = (inst_16430.cljs$core$IFn$_invoke$arity$5 ? inst_16430.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16492,null) : inst_16430.call(null,cljs.core.PersistentArrayMap,null,5,inst_16492,null));
var inst_16494 = (inst_16430.cljs$core$IFn$_invoke$arity$4 ? inst_16430.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16493,null) : inst_16430.call(null,cljs.core.PersistentHashSet,null,inst_16493,null));
var inst_16495 = (inst_16494.cljs$core$IFn$_invoke$arity$1 ? inst_16494.cljs$core$IFn$_invoke$arity$1(inst_16429) : inst_16494.call(null,inst_16429));
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16495)){
var statearr_16631_16820 = state_16570__$1;
(statearr_16631_16820[(1)] = (100));

} else {
var statearr_16632_16821 = state_16570__$1;
(statearr_16632_16821[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (21))){
var inst_16322 = (state_16570[(24)]);
var state_16570__$1 = state_16570;
var statearr_16633_16822 = state_16570__$1;
(statearr_16633_16822[(2)] = inst_16322);

(statearr_16633_16822[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (31))){
var inst_16338 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16634_16823 = state_16570__$1;
(statearr_16634_16823[(2)] = inst_16338);

(statearr_16634_16823[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (113))){
var inst_16544 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16635_16824 = state_16570__$1;
(statearr_16635_16824[(2)] = inst_16544);

(statearr_16635_16824[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (32))){
var state_16570__$1 = state_16570;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16636_16825 = state_16570__$1;
(statearr_16636_16825[(1)] = (35));

} else {
var statearr_16637_16826 = state_16570__$1;
(statearr_16637_16826[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (40))){
var inst_16374 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16374)){
var statearr_16638_16827 = state_16570__$1;
(statearr_16638_16827[(1)] = (44));

} else {
var statearr_16639_16828 = state_16570__$1;
(statearr_16639_16828[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (91))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16472 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16473 = (inst_16430.cljs$core$IFn$_invoke$arity$5 ? inst_16430.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16472,null) : inst_16430.call(null,cljs.core.PersistentArrayMap,null,3,inst_16472,null));
var inst_16474 = (inst_16430.cljs$core$IFn$_invoke$arity$4 ? inst_16430.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16473,null) : inst_16430.call(null,cljs.core.PersistentHashSet,null,inst_16473,null));
var inst_16475 = (inst_16474.cljs$core$IFn$_invoke$arity$1 ? inst_16474.cljs$core$IFn$_invoke$arity$1(inst_16429) : inst_16474.call(null,inst_16429));
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16475)){
var statearr_16640_16829 = state_16570__$1;
(statearr_16640_16829[(1)] = (92));

} else {
var statearr_16641_16830 = state_16570__$1;
(statearr_16641_16830[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (117))){
var state_16570__$1 = state_16570;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16642_16831 = state_16570__$1;
(statearr_16642_16831[(1)] = (120));

} else {
var statearr_16643_16832 = state_16570__$1;
(statearr_16643_16832[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (108))){
var inst_16529 = (state_16570[(25)]);
var inst_16298 = (state_16570[(11)]);
var inst_16529__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16298);
var state_16570__$1 = (function (){var statearr_16644 = state_16570;
(statearr_16644[(25)] = inst_16529__$1);

return statearr_16644;
})();
if(cljs.core.truth_(inst_16529__$1)){
var statearr_16645_16833 = state_16570__$1;
(statearr_16645_16833[(1)] = (111));

} else {
var statearr_16646_16834 = state_16570__$1;
(statearr_16646_16834[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (56))){
var inst_16391 = (state_16570[(2)]);
var inst_16392 = fluree.db.util.async.throw_err(inst_16391);
var inst_16393 = cljs.core.not(inst_16392);
var state_16570__$1 = state_16570;
var statearr_16647_16835 = state_16570__$1;
(statearr_16647_16835[(2)] = inst_16393);

(statearr_16647_16835[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (33))){
var inst_16321 = (state_16570[(26)]);
var state_16570__$1 = state_16570;
var statearr_16648_16836 = state_16570__$1;
(statearr_16648_16836[(2)] = inst_16321);

(statearr_16648_16836[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (13))){
var inst_16316 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16316)){
var statearr_16649_16837 = state_16570__$1;
(statearr_16649_16837[(1)] = (17));

} else {
var statearr_16650_16838 = state_16570__$1;
(statearr_16650_16838[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (22))){
var inst_16347 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16347)){
var statearr_16651_16839 = state_16570__$1;
(statearr_16651_16839[(1)] = (32));

} else {
var statearr_16652_16840 = state_16570__$1;
(statearr_16652_16840[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (90))){
var inst_16470 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16653_16841 = state_16570__$1;
(statearr_16653_16841[(2)] = inst_16470);

(statearr_16653_16841[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (109))){
var inst_16527 = (state_16570[(27)]);
var state_16570__$1 = state_16570;
var statearr_16654_16842 = state_16570__$1;
(statearr_16654_16842[(2)] = inst_16527);

(statearr_16654_16842[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (36))){
var inst_16321 = (state_16570[(26)]);
var state_16570__$1 = state_16570;
var statearr_16655_16843 = state_16570__$1;
(statearr_16655_16843[(2)] = inst_16321);

(statearr_16655_16843[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (41))){
var inst_16298 = (state_16570[(11)]);
var inst_16366 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16367 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16366);
var inst_16368 = inst_16367 === true;
var state_16570__$1 = state_16570;
var statearr_16656_16844 = state_16570__$1;
(statearr_16656_16844[(2)] = inst_16368);

(statearr_16656_16844[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (118))){
var inst_16525 = (state_16570[(7)]);
var state_16570__$1 = state_16570;
var statearr_16657_16845 = state_16570__$1;
(statearr_16657_16845[(2)] = inst_16525);

(statearr_16657_16845[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (89))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16468 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16429,inst_16430,throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16658_16846 = state_16570__$1;
(statearr_16658_16846[(2)] = inst_16468);

(statearr_16658_16846[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (100))){
var inst_16417 = (state_16570[(12)]);
var state_16570__$1 = state_16570;
var statearr_16659_16847 = state_16570__$1;
(statearr_16659_16847[(2)] = inst_16417);

(statearr_16659_16847[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (122))){
var inst_16557 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16660_16848 = state_16570__$1;
(statearr_16660_16848[(2)] = inst_16557);

(statearr_16660_16848[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (43))){
var inst_16371 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16661_16849 = state_16570__$1;
(statearr_16661_16849[(2)] = inst_16371);

(statearr_16661_16849[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (61))){
var inst_16379 = (state_16570[(14)]);
var state_16570__$1 = state_16570;
var statearr_16662_16850 = state_16570__$1;
(statearr_16662_16850[(2)] = inst_16379);

(statearr_16662_16850[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (29))){
var inst_16298 = (state_16570[(11)]);
var inst_16333 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16334 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16333);
var inst_16335 = inst_16334 === true;
var state_16570__$1 = state_16570;
var statearr_16663_16851 = state_16570__$1;
(statearr_16663_16851[(2)] = inst_16335);

(statearr_16663_16851[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (44))){
var inst_16360 = (state_16570[(28)]);
var inst_16376 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16360,"a component","a non-component",throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16664_16852 = state_16570__$1;
(statearr_16664_16852[(2)] = inst_16376);

(statearr_16664_16852[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (93))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16478 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16429,inst_16430,throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16665_16853 = state_16570__$1;
(statearr_16665_16853[(2)] = inst_16478);

(statearr_16665_16853[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (6))){
var inst_16297 = (state_16570[(16)]);
var inst_16285 = (state_16570[(21)]);
var inst_16294 = cljs.core.seq(inst_16285);
var inst_16295 = cljs.core.first(inst_16294);
var inst_16296 = cljs.core.next(inst_16294);
var inst_16297__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16295,(0),null);
var inst_16298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16295,(1),null);
var inst_16299 = cljs.core.not(inst_16297__$1);
var state_16570__$1 = (function (){var statearr_16666 = state_16570;
(statearr_16666[(16)] = inst_16297__$1);

(statearr_16666[(11)] = inst_16298);

(statearr_16666[(20)] = inst_16296);

return statearr_16666;
})();
if(inst_16299){
var statearr_16667_16854 = state_16570__$1;
(statearr_16667_16854[(1)] = (8));

} else {
var statearr_16668_16855 = state_16570__$1;
(statearr_16668_16855[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (111))){
var inst_16533 = (state_16570[(29)]);
var inst_16298 = (state_16570[(11)]);
var inst_16531 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16532 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16531);
var inst_16533__$1 = inst_16532 === true;
var state_16570__$1 = (function (){var statearr_16669 = state_16570;
(statearr_16669[(29)] = inst_16533__$1);

return statearr_16669;
})();
if(cljs.core.truth_(inst_16533__$1)){
var statearr_16670_16856 = state_16570__$1;
(statearr_16670_16856[(1)] = (114));

} else {
var statearr_16671_16857 = state_16570__$1;
(statearr_16671_16857[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (28))){
var inst_16341 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16672_16858 = state_16570__$1;
(statearr_16672_16858[(2)] = inst_16341);

(statearr_16672_16858[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (64))){
var inst_16418 = (state_16570[(10)]);
var state_16570__$1 = state_16570;
var statearr_16673_16859 = state_16570__$1;
(statearr_16673_16859[(2)] = inst_16418);

(statearr_16673_16859[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (103))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16502 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16503 = (inst_16430.cljs$core$IFn$_invoke$arity$5 ? inst_16430.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16502,null) : inst_16430.call(null,cljs.core.PersistentArrayMap,null,2,inst_16502,null));
var inst_16504 = (inst_16430.cljs$core$IFn$_invoke$arity$4 ? inst_16430.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16503,null) : inst_16430.call(null,cljs.core.PersistentHashSet,null,inst_16503,null));
var inst_16505 = (inst_16504.cljs$core$IFn$_invoke$arity$1 ? inst_16504.cljs$core$IFn$_invoke$arity$1(inst_16429) : inst_16504.call(null,inst_16429));
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16505)){
var statearr_16674_16860 = state_16570__$1;
(statearr_16674_16860[(1)] = (104));

} else {
var statearr_16675_16861 = state_16570__$1;
(statearr_16675_16861[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (51))){
var inst_16383 = (state_16570[(30)]);
var state_16570__$1 = state_16570;
var statearr_16676_16862 = state_16570__$1;
(statearr_16676_16862[(2)] = inst_16383);

(statearr_16676_16862[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (25))){
var inst_16344 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16677_16863 = state_16570__$1;
(statearr_16677_16863[(2)] = inst_16344);

(statearr_16677_16863[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (34))){
var inst_16361 = (state_16570[(18)]);
var inst_16298 = (state_16570[(11)]);
var inst_16360 = (state_16570[(2)]);
var inst_16361__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16298);
var state_16570__$1 = (function (){var statearr_16678 = state_16570;
(statearr_16678[(28)] = inst_16360);

(statearr_16678[(18)] = inst_16361__$1);

return statearr_16678;
})();
if(cljs.core.truth_(inst_16361__$1)){
var statearr_16679_16864 = state_16570__$1;
(statearr_16679_16864[(1)] = (38));

} else {
var statearr_16680_16865 = state_16570__$1;
(statearr_16680_16865[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (17))){
var inst_16286 = (state_16570[(15)]);
var inst_16318 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16286,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16681_16866 = state_16570__$1;
(statearr_16681_16866[(2)] = inst_16318);

(statearr_16681_16866[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (3))){
var inst_16568 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16570__$1,inst_16568);
} else {
if((state_val_16571 === (12))){
var inst_16302 = (state_16570[(31)]);
var state_16570__$1 = state_16570;
var statearr_16682_16867 = state_16570__$1;
(statearr_16682_16867[(2)] = inst_16302);

(statearr_16682_16867[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (2))){
var _ = (function (){var statearr_16683 = state_16570;
(statearr_16683[(4)] = cljs.core.cons((5),(state_16570[(4)])));

return statearr_16683;
})();
var inst_16278 = pred_changes;
var inst_16279 = cljs.core.seq(inst_16278);
var inst_16280 = cljs.core.first(inst_16279);
var inst_16281 = cljs.core.next(inst_16279);
var inst_16282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16280,(0),null);
var inst_16283 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16280,(1),null);
var inst_16284 = db;
var inst_16285 = inst_16278;
var inst_16286 = inst_16284;
var state_16570__$1 = (function (){var statearr_16684 = state_16570;
(statearr_16684[(32)] = inst_16283);

(statearr_16684[(15)] = inst_16286);

(statearr_16684[(33)] = inst_16282);

(statearr_16684[(34)] = inst_16281);

(statearr_16684[(21)] = inst_16285);

return statearr_16684;
})();
var statearr_16685_16868 = state_16570__$1;
(statearr_16685_16868[(2)] = null);

(statearr_16685_16868[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (66))){
var inst_16430 = (state_16570[(8)]);
var inst_16298 = (state_16570[(11)]);
var inst_16429 = (state_16570[(9)]);
var inst_16427 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16428 = cljs.core.__destructure_map(inst_16427);
var inst_16429__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16428,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16430__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16428,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16431 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16430__$1,inst_16429__$1);
var state_16570__$1 = (function (){var statearr_16686 = state_16570;
(statearr_16686[(8)] = inst_16430__$1);

(statearr_16686[(9)] = inst_16429__$1);

return statearr_16686;
})();
if(inst_16431){
var statearr_16687_16869 = state_16570__$1;
(statearr_16687_16869[(1)] = (69));

} else {
var statearr_16688_16870 = state_16570__$1;
(statearr_16688_16870[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (107))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16512 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16429,inst_16430,throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16689_16871 = state_16570__$1;
(statearr_16689_16871[(2)] = inst_16512);

(statearr_16689_16871[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (23))){
var inst_16298 = (state_16570[(11)]);
var inst_16327 = (state_16570[(17)]);
var inst_16326 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16327__$1 = inst_16326 === true;
var state_16570__$1 = (function (){var statearr_16690 = state_16570;
(statearr_16690[(17)] = inst_16327__$1);

return statearr_16690;
})();
if(cljs.core.truth_(inst_16327__$1)){
var statearr_16691_16872 = state_16570__$1;
(statearr_16691_16872[(1)] = (26));

} else {
var statearr_16692_16873 = state_16570__$1;
(statearr_16692_16873[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (47))){
var inst_16383 = (state_16570[(30)]);
var inst_16298 = (state_16570[(11)]);
var inst_16382 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16383__$1 = cljs.core.not(inst_16382);
var state_16570__$1 = (function (){var statearr_16693 = state_16570;
(statearr_16693[(30)] = inst_16383__$1);

return statearr_16693;
})();
if(inst_16383__$1){
var statearr_16694_16874 = state_16570__$1;
(statearr_16694_16874[(1)] = (50));

} else {
var statearr_16695_16875 = state_16570__$1;
(statearr_16695_16875[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (35))){
var inst_16350 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16351 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16352 = cljs.core.PersistentHashMap.fromArrays(inst_16350,inst_16351);
var inst_16353 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_16352);
var inst_16354 = (function(){throw inst_16353})();
var state_16570__$1 = state_16570;
var statearr_16696_16876 = state_16570__$1;
(statearr_16696_16876[(2)] = inst_16354);

(statearr_16696_16876[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (82))){
var inst_16450 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16697_16877 = state_16570__$1;
(statearr_16697_16877[(2)] = inst_16450);

(statearr_16697_16877[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (76))){
var state_16570__$1 = state_16570;
var statearr_16698_16878 = state_16570__$1;
(statearr_16698_16878[(2)] = null);

(statearr_16698_16878[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (97))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16488 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16429,inst_16430,throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16699_16879 = state_16570__$1;
(statearr_16699_16879[(2)] = inst_16488);

(statearr_16699_16879[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (19))){
var inst_16322 = (state_16570[(24)]);
var inst_16298 = (state_16570[(11)]);
var inst_16321 = (state_16570[(2)]);
var inst_16322__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16298);
var state_16570__$1 = (function (){var statearr_16700 = state_16570;
(statearr_16700[(26)] = inst_16321);

(statearr_16700[(24)] = inst_16322__$1);

return statearr_16700;
})();
if(cljs.core.truth_(inst_16322__$1)){
var statearr_16701_16880 = state_16570__$1;
(statearr_16701_16880[(1)] = (20));

} else {
var statearr_16702_16881 = state_16570__$1;
(statearr_16702_16881[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (57))){
var state_16570__$1 = state_16570;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16703_16882 = state_16570__$1;
(statearr_16703_16882[(1)] = (60));

} else {
var statearr_16704_16883 = state_16570__$1;
(statearr_16704_16883[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (68))){
var inst_16527 = (state_16570[(27)]);
var inst_16298 = (state_16570[(11)]);
var inst_16525 = (state_16570[(2)]);
var inst_16526 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16527__$1 = inst_16526 === true;
var state_16570__$1 = (function (){var statearr_16705 = state_16570;
(statearr_16705[(27)] = inst_16527__$1);

(statearr_16705[(7)] = inst_16525);

return statearr_16705;
})();
if(cljs.core.truth_(inst_16527__$1)){
var statearr_16706_16884 = state_16570__$1;
(statearr_16706_16884[(1)] = (108));

} else {
var statearr_16707_16885 = state_16570__$1;
(statearr_16707_16885[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (11))){
var inst_16306 = (state_16570[(23)]);
var inst_16298 = (state_16570[(11)]);
var inst_16304 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16305 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16304);
var inst_16306__$1 = inst_16305 === false;
var state_16570__$1 = (function (){var statearr_16708 = state_16570;
(statearr_16708[(23)] = inst_16306__$1);

return statearr_16708;
})();
if(cljs.core.truth_(inst_16306__$1)){
var statearr_16709_16886 = state_16570__$1;
(statearr_16709_16886[(1)] = (14));

} else {
var statearr_16710_16887 = state_16570__$1;
(statearr_16710_16887[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (115))){
var inst_16533 = (state_16570[(29)]);
var state_16570__$1 = state_16570;
var statearr_16712_16888 = state_16570__$1;
(statearr_16712_16888[(2)] = inst_16533);

(statearr_16712_16888[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (9))){
var inst_16302 = (state_16570[(31)]);
var inst_16298 = (state_16570[(11)]);
var inst_16302__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16298);
var state_16570__$1 = (function (){var statearr_16713 = state_16570;
(statearr_16713[(31)] = inst_16302__$1);

return statearr_16713;
})();
if(cljs.core.truth_(inst_16302__$1)){
var statearr_16714_16889 = state_16570__$1;
(statearr_16714_16889[(1)] = (11));

} else {
var statearr_16715_16890 = state_16570__$1;
(statearr_16715_16890[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (5))){
var _ = (function (){var statearr_16716 = state_16570;
(statearr_16716[(4)] = cljs.core.rest((state_16570[(4)])));

return statearr_16716;
})();
var state_16570__$1 = state_16570;
var ex16711 = (state_16570__$1[(2)]);
var statearr_16717_16891 = state_16570__$1;
(statearr_16717_16891[(5)] = ex16711);


if((ex16711 instanceof Error)){
var statearr_16718_16892 = state_16570__$1;
(statearr_16718_16892[(1)] = (4));

(statearr_16718_16892[(5)] = null);

} else {
throw ex16711;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (112))){
var inst_16529 = (state_16570[(25)]);
var state_16570__$1 = state_16570;
var statearr_16719_16893 = state_16570__$1;
(statearr_16719_16893[(2)] = inst_16529);

(statearr_16719_16893[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (83))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16452 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16453 = (inst_16430.cljs$core$IFn$_invoke$arity$5 ? inst_16430.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16452,null) : inst_16430.call(null,cljs.core.PersistentArrayMap,null,3,inst_16452,null));
var inst_16454 = (inst_16430.cljs$core$IFn$_invoke$arity$4 ? inst_16430.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16453,null) : inst_16430.call(null,cljs.core.PersistentHashSet,null,inst_16453,null));
var inst_16455 = (inst_16454.cljs$core$IFn$_invoke$arity$1 ? inst_16454.cljs$core$IFn$_invoke$arity$1(inst_16429) : inst_16454.call(null,inst_16429));
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16455)){
var statearr_16720_16894 = state_16570__$1;
(statearr_16720_16894[(1)] = (84));

} else {
var statearr_16721_16895 = state_16570__$1;
(statearr_16721_16895[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (14))){
var inst_16298 = (state_16570[(11)]);
var inst_16308 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16309 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16308);
var inst_16310 = inst_16309 === true;
var state_16570__$1 = state_16570;
var statearr_16722_16896 = state_16570__$1;
(statearr_16722_16896[(2)] = inst_16310);

(statearr_16722_16896[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (45))){
var inst_16360 = (state_16570[(28)]);
var state_16570__$1 = state_16570;
var statearr_16723_16897 = state_16570__$1;
(statearr_16723_16897[(2)] = inst_16360);

(statearr_16723_16897[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (53))){
var inst_16286 = (state_16570[(15)]);
var inst_16297 = (state_16570[(16)]);
var inst_16389 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_16286,inst_16297);
var state_16570__$1 = state_16570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16570__$1,(56),inst_16389);
} else {
if((state_val_16571 === (78))){
var inst_16515 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16724_16898 = state_16570__$1;
(statearr_16724_16898[(2)] = inst_16515);

(statearr_16724_16898[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (26))){
var inst_16331 = (state_16570[(35)]);
var inst_16298 = (state_16570[(11)]);
var inst_16329 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16330 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16329);
var inst_16331__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16330);
var state_16570__$1 = (function (){var statearr_16725 = state_16570;
(statearr_16725[(35)] = inst_16331__$1);

return statearr_16725;
})();
if(inst_16331__$1){
var statearr_16726_16899 = state_16570__$1;
(statearr_16726_16899[(1)] = (29));

} else {
var statearr_16727_16900 = state_16570__$1;
(statearr_16727_16900[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (16))){
var inst_16313 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16728_16901 = state_16570__$1;
(statearr_16728_16901[(2)] = inst_16313);

(statearr_16728_16901[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (81))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16448 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16429,inst_16430,throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16729_16902 = state_16570__$1;
(statearr_16729_16902[(2)] = inst_16448);

(statearr_16729_16902[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (120))){
var inst_16550 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16551 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16552 = cljs.core.PersistentHashMap.fromArrays(inst_16550,inst_16551);
var inst_16553 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_16552);
var inst_16554 = (function(){throw inst_16553})();
var state_16570__$1 = state_16570;
var statearr_16730_16903 = state_16570__$1;
(statearr_16730_16903[(2)] = inst_16554);

(statearr_16730_16903[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (79))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16442 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16443 = (inst_16430.cljs$core$IFn$_invoke$arity$5 ? inst_16430.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16442,null) : inst_16430.call(null,cljs.core.PersistentArrayMap,null,2,inst_16442,null));
var inst_16444 = (inst_16430.cljs$core$IFn$_invoke$arity$4 ? inst_16430.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16443,null) : inst_16430.call(null,cljs.core.PersistentHashSet,null,inst_16443,null));
var inst_16445 = (inst_16444.cljs$core$IFn$_invoke$arity$1 ? inst_16444.cljs$core$IFn$_invoke$arity$1(inst_16429) : inst_16444.call(null,inst_16429));
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16445)){
var statearr_16731_16904 = state_16570__$1;
(statearr_16731_16904[(1)] = (80));

} else {
var statearr_16732_16905 = state_16570__$1;
(statearr_16732_16905[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (38))){
var inst_16298 = (state_16570[(11)]);
var inst_16364 = (state_16570[(36)]);
var inst_16363 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16364__$1 = cljs.core.not(inst_16363);
var state_16570__$1 = (function (){var statearr_16733 = state_16570;
(statearr_16733[(36)] = inst_16364__$1);

return statearr_16733;
})();
if(inst_16364__$1){
var statearr_16734_16906 = state_16570__$1;
(statearr_16734_16906[(1)] = (41));

} else {
var statearr_16735_16907 = state_16570__$1;
(statearr_16735_16907[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (98))){
var inst_16490 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16736_16908 = state_16570__$1;
(statearr_16736_16908[(2)] = inst_16490);

(statearr_16736_16908[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (87))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16462 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16463 = (inst_16430.cljs$core$IFn$_invoke$arity$5 ? inst_16430.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16462,null) : inst_16430.call(null,cljs.core.PersistentArrayMap,null,3,inst_16462,null));
var inst_16464 = (inst_16430.cljs$core$IFn$_invoke$arity$4 ? inst_16430.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16463,null) : inst_16430.call(null,cljs.core.PersistentHashSet,null,inst_16463,null));
var inst_16465 = (inst_16464.cljs$core$IFn$_invoke$arity$1 ? inst_16464.cljs$core$IFn$_invoke$arity$1(inst_16429) : inst_16464.call(null,inst_16429));
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16465)){
var statearr_16737_16909 = state_16570__$1;
(statearr_16737_16909[(1)] = (88));

} else {
var statearr_16738_16910 = state_16570__$1;
(statearr_16738_16910[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (30))){
var inst_16331 = (state_16570[(35)]);
var state_16570__$1 = state_16570;
var statearr_16739_16911 = state_16570__$1;
(statearr_16739_16911[(2)] = inst_16331);

(statearr_16739_16911[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (73))){
var state_16570__$1 = state_16570;
var statearr_16740_16912 = state_16570__$1;
(statearr_16740_16912[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (96))){
var inst_16417 = (state_16570[(12)]);
var state_16570__$1 = state_16570;
var statearr_16742_16913 = state_16570__$1;
(statearr_16742_16913[(2)] = inst_16417);

(statearr_16742_16913[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (10))){
var inst_16563 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16743_16914 = state_16570__$1;
(statearr_16743_16914[(2)] = inst_16563);

(statearr_16743_16914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (18))){
var inst_16286 = (state_16570[(15)]);
var state_16570__$1 = state_16570;
var statearr_16744_16915 = state_16570__$1;
(statearr_16744_16915[(2)] = inst_16286);

(statearr_16744_16915[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (105))){
var inst_16430 = (state_16570[(8)]);
var inst_16429 = (state_16570[(9)]);
var inst_16508 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16429,inst_16430,throw_QMARK_);
var state_16570__$1 = state_16570;
var statearr_16745_16916 = state_16570__$1;
(statearr_16745_16916[(2)] = inst_16508);

(statearr_16745_16916[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (52))){
var inst_16399 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16746_16917 = state_16570__$1;
(statearr_16746_16917[(2)] = inst_16399);

(statearr_16746_16917[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (114))){
var inst_16298 = (state_16570[(11)]);
var inst_16535 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16536 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16535);
var inst_16537 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16536);
var inst_16538 = (!(inst_16537));
var state_16570__$1 = state_16570;
var statearr_16747_16918 = state_16570__$1;
(statearr_16747_16918[(2)] = inst_16538);

(statearr_16747_16918[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (67))){
var inst_16417 = (state_16570[(12)]);
var state_16570__$1 = state_16570;
var statearr_16748_16919 = state_16570__$1;
(statearr_16748_16919[(2)] = inst_16417);

(statearr_16748_16919[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (71))){
var inst_16522 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16749_16920 = state_16570__$1;
(statearr_16749_16920[(2)] = inst_16522);

(statearr_16749_16920[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (42))){
var inst_16364 = (state_16570[(36)]);
var state_16570__$1 = state_16570;
var statearr_16750_16921 = state_16570__$1;
(statearr_16750_16921[(2)] = inst_16364);

(statearr_16750_16921[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (80))){
var inst_16417 = (state_16570[(12)]);
var state_16570__$1 = state_16570;
var statearr_16751_16922 = state_16570__$1;
(statearr_16751_16922[(2)] = inst_16417);

(statearr_16751_16922[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (37))){
var inst_16357 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16752_16923 = state_16570__$1;
(statearr_16752_16923[(2)] = inst_16357);

(statearr_16752_16923[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (63))){
var inst_16298 = (state_16570[(11)]);
var inst_16420 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16298);
var inst_16421 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16420);
var state_16570__$1 = state_16570;
var statearr_16753_16924 = state_16570__$1;
(statearr_16753_16924[(2)] = inst_16421);

(statearr_16753_16924[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (94))){
var inst_16480 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16754_16925 = state_16570__$1;
(statearr_16754_16925[(2)] = inst_16480);

(statearr_16754_16925[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (8))){
var inst_16286 = (state_16570[(15)]);
var state_16570__$1 = state_16570;
var statearr_16755_16926 = state_16570__$1;
(statearr_16755_16926[(2)] = inst_16286);

(statearr_16755_16926[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (49))){
var inst_16402 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
if(cljs.core.truth_(inst_16402)){
var statearr_16756_16927 = state_16570__$1;
(statearr_16756_16927[(1)] = (57));

} else {
var statearr_16757_16928 = state_16570__$1;
(statearr_16757_16928[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (84))){
var inst_16417 = (state_16570[(12)]);
var state_16570__$1 = state_16570;
var statearr_16758_16929 = state_16570__$1;
(statearr_16758_16929[(2)] = inst_16417);

(statearr_16758_16929[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2684__auto__ = null;
var fluree$db$query$schema$state_machine__2684__auto____0 = (function (){
var statearr_16759 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16759[(0)] = fluree$db$query$schema$state_machine__2684__auto__);

(statearr_16759[(1)] = (1));

return statearr_16759;
});
var fluree$db$query$schema$state_machine__2684__auto____1 = (function (state_16570){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16570);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16760){var ex__2687__auto__ = e16760;
var statearr_16761_16930 = state_16570;
(statearr_16761_16930[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16570[(4)]))){
var statearr_16762_16931 = state_16570;
(statearr_16762_16931[(1)] = cljs.core.first((state_16570[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16932 = state_16570;
state_16570 = G__16932;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2684__auto__ = function(state_16570){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2684__auto____1.call(this,state_16570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2684__auto____0;
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2684__auto____1;
return fluree$db$query$schema$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16763 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16763[(6)] = c__2706__auto__);

return statearr_16763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16934 = arguments.length;
switch (G__16934) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16958){
var state_val_16959 = (state_16958[(1)]);
if((state_val_16959 === (7))){
var state_16958__$1 = state_16958;
var statearr_16960_16980 = state_16958__$1;
(statearr_16960_16980[(2)] = db);

(statearr_16960_16980[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16959 === (1))){
var state_16958__$1 = state_16958;
var statearr_16961_16981 = state_16958__$1;
(statearr_16961_16981[(2)] = null);

(statearr_16961_16981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16959 === (4))){
var inst_16935 = (state_16958[(2)]);
var state_16958__$1 = state_16958;
var statearr_16962_16982 = state_16958__$1;
(statearr_16962_16982[(2)] = inst_16935);

(statearr_16962_16982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16959 === (6))){
var inst_16944 = (state_16958[(7)]);
var inst_16943 = (state_16958[(2)]);
var inst_16944__$1 = fluree.db.util.async.throw_err(inst_16943);
var inst_16945 = cljs.core.empty_QMARK_(inst_16944__$1);
var state_16958__$1 = (function (){var statearr_16963 = state_16958;
(statearr_16963[(7)] = inst_16944__$1);

return statearr_16963;
})();
if(inst_16945){
var statearr_16964_16983 = state_16958__$1;
(statearr_16964_16983[(1)] = (7));

} else {
var statearr_16965_16984 = state_16958__$1;
(statearr_16965_16984[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16959 === (3))){
var inst_16956 = (state_16958[(2)]);
var state_16958__$1 = state_16958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16958__$1,inst_16956);
} else {
if((state_val_16959 === (2))){
var _ = (function (){var statearr_16967 = state_16958;
(statearr_16967[(4)] = cljs.core.cons((5),(state_16958[(4)])));

return statearr_16967;
})();
var inst_16941 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_16958__$1 = state_16958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16958__$1,(6),inst_16941);
} else {
if((state_val_16959 === (9))){
var inst_16953 = (state_16958[(2)]);
var _ = (function (){var statearr_16968 = state_16958;
(statearr_16968[(4)] = cljs.core.rest((state_16958[(4)])));

return statearr_16968;
})();
var state_16958__$1 = state_16958;
var statearr_16969_16985 = state_16958__$1;
(statearr_16969_16985[(2)] = inst_16953);

(statearr_16969_16985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16959 === (5))){
var _ = (function (){var statearr_16970 = state_16958;
(statearr_16970[(4)] = cljs.core.rest((state_16958[(4)])));

return statearr_16970;
})();
var state_16958__$1 = state_16958;
var ex16966 = (state_16958__$1[(2)]);
var statearr_16971_16986 = state_16958__$1;
(statearr_16971_16986[(5)] = ex16966);


if((ex16966 instanceof Error)){
var statearr_16972_16987 = state_16958__$1;
(statearr_16972_16987[(1)] = (4));

(statearr_16972_16987[(5)] = null);

} else {
throw ex16966;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16959 === (10))){
var inst_16950 = (state_16958[(2)]);
var inst_16951 = fluree.db.util.async.throw_err(inst_16950);
var state_16958__$1 = state_16958;
var statearr_16973_16988 = state_16958__$1;
(statearr_16973_16988[(2)] = inst_16951);

(statearr_16973_16988[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16959 === (8))){
var inst_16944 = (state_16958[(7)]);
var inst_16948 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_16944,db,true);
var state_16958__$1 = state_16958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16958__$1,(10),inst_16948);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2684__auto__ = null;
var fluree$db$query$schema$state_machine__2684__auto____0 = (function (){
var statearr_16974 = [null,null,null,null,null,null,null,null];
(statearr_16974[(0)] = fluree$db$query$schema$state_machine__2684__auto__);

(statearr_16974[(1)] = (1));

return statearr_16974;
});
var fluree$db$query$schema$state_machine__2684__auto____1 = (function (state_16958){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16958);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16975){var ex__2687__auto__ = e16975;
var statearr_16976_16989 = state_16958;
(statearr_16976_16989[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16958[(4)]))){
var statearr_16977_16990 = state_16958;
(statearr_16977_16990[(1)] = cljs.core.first((state_16958[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16991 = state_16958;
state_16958 = G__16991;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2684__auto__ = function(state_16958){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2684__auto____1.call(this,state_16958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2684__auto____0;
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2684__auto____1;
return fluree$db$query$schema$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16978 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16978[(6)] = c__2706__auto__);

return statearr_16978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16993 = arguments.length;
switch (G__16993) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16995 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16995,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16995,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16995,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = fluree.db.flake.p(flake);
var o = fluree.db.flake.o(flake);
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__16998_SHARP_,p2__16999_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16998_SHARP_,p2__16999_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__17000_SHARP_){
var f = p1__17000_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,fluree.db.flake.p(f))){
return fluree.db.flake.o(f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17066){
var state_val_17067 = (state_17066[(1)]);
if((state_val_17067 === (1))){
var state_17066__$1 = state_17066;
var statearr_17068_17086 = state_17066__$1;
(statearr_17068_17086[(2)] = null);

(statearr_17068_17086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17067 === (2))){
var _ = (function (){var statearr_17069 = state_17066;
(statearr_17069[(4)] = cljs.core.cons((5),(state_17066[(4)])));

return statearr_17069;
})();
var inst_17018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17019 = fluree.db.flake.max_subject_id((1));
var inst_17020 = [inst_17019];
var inst_17021 = (new cljs.core.PersistentVector(null,1,(5),inst_17018,inst_17020,null));
var inst_17022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17023 = [(0)];
var inst_17024 = (new cljs.core.PersistentVector(null,1,(5),inst_17022,inst_17023,null));
var inst_17025 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_17021,cljs.core._LT__EQ_,inst_17024);
var state_17066__$1 = state_17066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17066__$1,(6),inst_17025);
} else {
if((state_val_17067 === (3))){
var inst_17064 = (state_17066[(2)]);
var state_17066__$1 = state_17066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17066__$1,inst_17064);
} else {
if((state_val_17067 === (4))){
var inst_17006 = (state_17066[(2)]);
var state_17066__$1 = state_17066;
var statearr_17071_17087 = state_17066__$1;
(statearr_17071_17087[(2)] = inst_17006);

(statearr_17071_17087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17067 === (5))){
var _ = (function (){var statearr_17072 = state_17066;
(statearr_17072[(4)] = cljs.core.rest((state_17066[(4)])));

return statearr_17072;
})();
var state_17066__$1 = state_17066;
var ex17070 = (state_17066__$1[(2)]);
var statearr_17073_17088 = state_17066__$1;
(statearr_17073_17088[(5)] = ex17070);


if((ex17070 instanceof Error)){
var statearr_17074_17089 = state_17066__$1;
(statearr_17074_17089[(1)] = (4));

(statearr_17074_17089[(5)] = null);

} else {
throw ex17070;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17067 === (6))){
var inst_17027 = (state_17066[(2)]);
var inst_17028 = fluree.db.util.async.throw_err(inst_17027);
var inst_17029 = (function (){var schema_flakes = inst_17028;
return (function (p1__17001_SHARP_){
return (fluree.db.flake.s(p1__17001_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_17030 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17029,inst_17028);
var inst_17031 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17030,(0),null);
var inst_17032 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17030,(1),null);
var inst_17033 = (function (){var schema_flakes = inst_17028;
var vec__17012 = inst_17030;
var collection_flakes = inst_17031;
var predicate_flakes = inst_17032;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = fluree.db.flake.s(first_flake);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__17004_SHARP_,p2__17003_SHARP_){
var f = p2__17003_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17004_SHARP_,fluree.db.flake.p(f),fluree.db.flake.o(f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_17034 = [(-1),"_tx"];
var inst_17035 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17036 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17037 = cljs.core.PersistentHashMap.fromArrays(inst_17035,inst_17036);
var inst_17038 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17039 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17040 = cljs.core.PersistentHashMap.fromArrays(inst_17038,inst_17039);
var inst_17041 = [inst_17037,inst_17040];
var inst_17042 = cljs.core.PersistentHashMap.fromArrays(inst_17034,inst_17041);
var inst_17043 = (function (){var schema_flakes = inst_17028;
var vec__17012 = inst_17030;
var collection_flakes = inst_17031;
var predicate_flakes = inst_17032;
return (function (p1__17002_SHARP_){
return fluree.db.flake.s(p1__17002_SHARP_);
});
})();
var inst_17044 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17043,inst_17031);
var inst_17045 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17033,inst_17042,inst_17044);
var inst_17047 = (function (){var schema_flakes = inst_17028;
var vec__17012 = inst_17030;
var collection_flakes = inst_17031;
var predicate_flakes = inst_17032;
var coll = inst_17045;
return (function (p__17046,pred_flakes){
var vec__17075 = p__17046;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17075,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17075,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = fluree.db.flake.s(first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__17078 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__17078.cljs$core$IFn$_invoke$arity$1 ? fexpr__17078.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__17078.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_17048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17049 = cljs.core.PersistentHashMap.EMPTY;
var inst_17050 = cljs.core.PersistentHashSet.EMPTY;
var inst_17051 = [inst_17049,inst_17050];
var inst_17052 = (new cljs.core.PersistentVector(null,2,(5),inst_17048,inst_17051,null));
var inst_17053 = (function (){var schema_flakes = inst_17028;
var vec__17012 = inst_17030;
var collection_flakes = inst_17031;
var predicate_flakes = inst_17032;
var coll = inst_17045;
return (function (p1__17005_SHARP_){
return fluree.db.flake.s(p1__17005_SHARP_);
});
})();
var inst_17054 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17053,inst_17032);
var inst_17055 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17047,inst_17052,inst_17054);
var inst_17056 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17055,(0),null);
var inst_17057 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17055,(1),null);
var inst_17058 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17059 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17060 = [inst_17059,inst_17045,inst_17056,inst_17057];
var inst_17061 = cljs.core.PersistentHashMap.fromArrays(inst_17058,inst_17060);
var _ = (function (){var statearr_17079 = state_17066;
(statearr_17079[(4)] = cljs.core.rest((state_17066[(4)])));

return statearr_17079;
})();
var state_17066__$1 = state_17066;
var statearr_17080_17090 = state_17066__$1;
(statearr_17080_17090[(2)] = inst_17061);

(statearr_17080_17090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0 = (function (){
var statearr_17081 = [null,null,null,null,null,null,null];
(statearr_17081[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2684__auto__);

(statearr_17081[(1)] = (1));

return statearr_17081;
});
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1 = (function (state_17066){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17066);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17082){var ex__2687__auto__ = e17082;
var statearr_17083_17091 = state_17066;
(statearr_17083_17091[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17066[(4)]))){
var statearr_17084_17092 = state_17066;
(statearr_17084_17092[(1)] = cljs.core.first((state_17066[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17093 = state_17066;
state_17066 = G__17093;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__ = function(state_17066){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1.call(this,state_17066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17085 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17085[(6)] = c__2706__auto__);

return statearr_17085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17135){
var state_val_17136 = (state_17135[(1)]);
if((state_val_17136 === (7))){
var inst_17118 = (state_17135[(2)]);
var inst_17119 = fluree.db.query.schema.flake__GT_pred_map(inst_17118);
var inst_17120 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17119,(114));
var inst_17122 = cljs.core.boolean$(inst_17121);
var inst_17123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17119,(110));
var inst_17124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17119,(117));
var inst_17125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_17124);
var inst_17126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17119,(111));
var inst_17127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17119,(115));
var inst_17128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17119,(112));
var inst_17129 = [inst_17122,inst_17123,inst_17125,inst_17126,inst_17127,inst_17128];
var inst_17130 = cljs.core.PersistentHashMap.fromArrays(inst_17120,inst_17129);
var _ = (function (){var statearr_17137 = state_17135;
(statearr_17137[(4)] = cljs.core.rest((state_17135[(4)])));

return statearr_17137;
})();
var state_17135__$1 = state_17135;
var statearr_17138_17161 = state_17135__$1;
(statearr_17138_17161[(2)] = inst_17130);

(statearr_17138_17161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17136 === (1))){
var state_17135__$1 = state_17135;
var statearr_17139_17162 = state_17135__$1;
(statearr_17139_17162[(2)] = null);

(statearr_17139_17162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17136 === (4))){
var inst_17094 = (state_17135[(2)]);
var state_17135__$1 = state_17135;
var statearr_17140_17163 = state_17135__$1;
(statearr_17140_17163[(2)] = inst_17094);

(statearr_17140_17163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17136 === (6))){
var _ = (function (){var statearr_17141 = state_17135;
(statearr_17141[(4)] = cljs.core.cons((9),(state_17135[(4)])));

return statearr_17141;
})();
var inst_17106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17108 = ["_setting/id","root"];
var inst_17109 = (new cljs.core.PersistentVector(null,2,(5),inst_17107,inst_17108,null));
var inst_17110 = [inst_17109];
var inst_17111 = (new cljs.core.PersistentVector(null,1,(5),inst_17106,inst_17110,null));
var inst_17112 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17111);
var state_17135__$1 = state_17135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17135__$1,(10),inst_17112);
} else {
if((state_val_17136 === (3))){
var inst_17133 = (state_17135[(2)]);
var state_17135__$1 = state_17135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17135__$1,inst_17133);
} else {
if((state_val_17136 === (2))){
var _ = (function (){var statearr_17144 = state_17135;
(statearr_17144[(4)] = cljs.core.cons((5),(state_17135[(4)])));

return statearr_17144;
})();
var state_17135__$1 = state_17135;
var statearr_17145_17164 = state_17135__$1;
(statearr_17145_17164[(2)] = null);

(statearr_17145_17164[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17136 === (9))){
var _ = (function (){var statearr_17146 = state_17135;
(statearr_17146[(4)] = cljs.core.rest((state_17135[(4)])));

return statearr_17146;
})();
var state_17135__$1 = state_17135;
var ex17142 = (state_17135__$1[(2)]);
var statearr_17147_17165 = state_17135__$1;
(statearr_17147_17165[(5)] = ex17142);


var statearr_17148_17166 = state_17135__$1;
(statearr_17148_17166[(1)] = (8));

(statearr_17148_17166[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17136 === (5))){
var _ = (function (){var statearr_17149 = state_17135;
(statearr_17149[(4)] = cljs.core.rest((state_17135[(4)])));

return statearr_17149;
})();
var state_17135__$1 = state_17135;
var ex17143 = (state_17135__$1[(2)]);
var statearr_17150_17167 = state_17135__$1;
(statearr_17150_17167[(5)] = ex17143);


if((ex17143 instanceof Error)){
var statearr_17151_17168 = state_17135__$1;
(statearr_17151_17168[(1)] = (4));

(statearr_17151_17168[(5)] = null);

} else {
throw ex17143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17136 === (10))){
var inst_17114 = (state_17135[(2)]);
var inst_17115 = fluree.db.util.async.throw_err(inst_17114);
var _ = (function (){var statearr_17152 = state_17135;
(statearr_17152[(4)] = cljs.core.rest((state_17135[(4)])));

return statearr_17152;
})();
var state_17135__$1 = state_17135;
var statearr_17153_17169 = state_17135__$1;
(statearr_17153_17169[(2)] = inst_17115);

(statearr_17153_17169[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17136 === (8))){
var inst_17100 = (state_17135[(2)]);
var state_17135__$1 = (function (){var statearr_17154 = state_17135;
(statearr_17154[(7)] = inst_17100);

return statearr_17154;
})();
var statearr_17155_17170 = state_17135__$1;
(statearr_17155_17170[(2)] = null);

(statearr_17155_17170[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0 = (function (){
var statearr_17156 = [null,null,null,null,null,null,null,null];
(statearr_17156[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2684__auto__);

(statearr_17156[(1)] = (1));

return statearr_17156;
});
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1 = (function (state_17135){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17135);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17157){var ex__2687__auto__ = e17157;
var statearr_17158_17171 = state_17135;
(statearr_17158_17171[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17135[(4)]))){
var statearr_17159_17172 = state_17135;
(statearr_17159_17172[(1)] = cljs.core.first((state_17135[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17173 = state_17135;
state_17135 = G__17173;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__ = function(state_17135){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1.call(this,state_17135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17160 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17160[(6)] = c__2706__auto__);

return statearr_17160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
