// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.connection_js');
goog.require('goog.object');
goog.scope(function(){
flureeworker.goog$module$goog$object = goog.module.get('goog.object');
});
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__71327 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__71327__$1 = cljs.core.__destructure_map(map__71327);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71327__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71327__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = flureeworker.goog$module$goog$object.get.call(null,obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__71328 = cljs.core.get_global_hierarchy;
return (fexpr__71328.cljs$core$IFn$_invoke$arity$0 ? fexpr__71328.cljs$core$IFn$_invoke$arity$0() : fexpr__71328.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__71329__delegate = function (conn_id,event,_){
return event;
};
var G__71329 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__71330__i = 0, G__71330__a = new Array(arguments.length -  2);
while (G__71330__i < G__71330__a.length) {G__71330__a[G__71330__i] = arguments[G__71330__i + 2]; ++G__71330__i;}
  _ = new cljs.core.IndexedSeq(G__71330__a,0,null);
} 
return G__71329__delegate.call(this,conn_id,event,_);};
G__71329.cljs$lang$maxFixedArity = 2;
G__71329.cljs$lang$applyTo = (function (arglist__71331){
var conn_id = cljs.core.first(arglist__71331);
arglist__71331 = cljs.core.next(arglist__71331);
var event = cljs.core.first(arglist__71331);
var _ = cljs.core.rest(arglist__71331);
return G__71329__delegate(conn_id,event,_);
});
G__71329.cljs$core$IFn$_invoke$arity$variadic = G__71329__delegate;
return G__71329;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__5045__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71349){
var state_val_71350 = (state_71349[(1)]);
if((state_val_71350 === (1))){
var inst_71332 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_71333 = flureeworker.conn_id__GT_db(conn_id,inst_71332);
var inst_71334 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_71335 = fluree.db.api.query.query(inst_71333,inst_71334);
var state_71349__$1 = state_71349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71349__$1,(2),inst_71335);
} else {
if((state_val_71350 === (2))){
var inst_71337 = (state_71349[(7)]);
var inst_71337__$1 = (state_71349[(2)]);
var inst_71338 = fluree.db.util.core.exception_QMARK_(inst_71337__$1);
var state_71349__$1 = (function (){var statearr_71351 = state_71349;
(statearr_71351[(7)] = inst_71337__$1);

return statearr_71351;
})();
if(inst_71338){
var statearr_71352_71365 = state_71349__$1;
(statearr_71352_71365[(1)] = (3));

} else {
var statearr_71353_71366 = state_71349__$1;
(statearr_71353_71366[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71350 === (3))){
var inst_71337 = (state_71349[(7)]);
var inst_71340 = flureeworker.error_return_map(inst_71337);
var state_71349__$1 = state_71349;
var statearr_71354_71367 = state_71349__$1;
(statearr_71354_71367[(2)] = inst_71340);

(statearr_71354_71367[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71350 === (4))){
var inst_71337 = (state_71349[(7)]);
var inst_71342 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_71343 = [inst_71337,"loaded"];
var inst_71344 = cljs.core.PersistentHashMap.fromArrays(inst_71342,inst_71343);
var state_71349__$1 = state_71349;
var statearr_71355_71368 = state_71349__$1;
(statearr_71355_71368[(2)] = inst_71344);

(statearr_71355_71368[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71350 === (5))){
var inst_71346 = (state_71349[(2)]);
var inst_71347 = (function (){var G__71356 = conn_id;
var G__71357 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__71358 = id;
var G__71359 = inst_71346;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71356,G__71357,G__71358,G__71359) : flureeworker.worker_action.call(null,G__71356,G__71357,G__71358,G__71359));
})();
var state_71349__$1 = state_71349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71349__$1,inst_71347);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2684__auto__ = null;
var flureeworker$process_query_$_state_machine__2684__auto____0 = (function (){
var statearr_71360 = [null,null,null,null,null,null,null,null];
(statearr_71360[(0)] = flureeworker$process_query_$_state_machine__2684__auto__);

(statearr_71360[(1)] = (1));

return statearr_71360;
});
var flureeworker$process_query_$_state_machine__2684__auto____1 = (function (state_71349){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71349);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71361){var ex__2687__auto__ = e71361;
var statearr_71362_71369 = state_71349;
(statearr_71362_71369[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71349[(4)]))){
var statearr_71363_71370 = state_71349;
(statearr_71363_71370[(1)] = cljs.core.first((state_71349[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71371 = state_71349;
state_71349 = G__71371;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2684__auto__ = function(state_71349){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2684__auto____1.call(this,state_71349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2684__auto____0;
flureeworker$process_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2684__auto____1;
return flureeworker$process_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71364 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71364[(6)] = c__2706__auto__);

return statearr_71364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__71372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__71372__$1 = cljs.core.__destructure_map(map__71372);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71372__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71372__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__71373 = cljs.core.seq(query_ids);
var chunk__71374 = null;
var count__71375 = (0);
var i__71376 = (0);
while(true){
if((i__71376 < count__71375)){
var id = chunk__71374.cljs$core$IIndexed$_nth$arity$2(null,i__71376);
flureeworker.process_query(conn_id,id,opts);


var G__71377 = seq__71373;
var G__71378 = chunk__71374;
var G__71379 = count__71375;
var G__71380 = (i__71376 + (1));
seq__71373 = G__71377;
chunk__71374 = G__71378;
count__71375 = G__71379;
i__71376 = G__71380;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__71373);
if(temp__5804__auto__){
var seq__71373__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__71373__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__71373__$1);
var G__71381 = cljs.core.chunk_rest(seq__71373__$1);
var G__71382 = c__5568__auto__;
var G__71383 = cljs.core.count(c__5568__auto__);
var G__71384 = (0);
seq__71373 = G__71381;
chunk__71374 = G__71382;
count__71375 = G__71383;
i__71376 = G__71384;
continue;
} else {
var id = cljs.core.first(seq__71373__$1);
flureeworker.process_query(conn_id,id,opts);


var G__71385 = cljs.core.next(seq__71373__$1);
var G__71386 = null;
var G__71387 = (0);
var G__71388 = (0);
seq__71373 = G__71385;
chunk__71374 = G__71386;
count__71375 = G__71387;
i__71376 = G__71388;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__71389 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71389,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71389,(1),null);
var cb = (function (header,data){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71397){
var state_val_71398 = (state_71397[(1)]);
if((state_val_71398 === (1))){
var inst_71392 = cljs.core.async.timeout((100));
var state_71397__$1 = state_71397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71397__$1,(2),inst_71392);
} else {
if((state_val_71398 === (2))){
var inst_71394 = (state_71397[(2)]);
var inst_71395 = flureeworker.process_all_queries(conn_id);
var state_71397__$1 = (function (){var statearr_71399 = state_71397;
(statearr_71399[(7)] = inst_71394);

return statearr_71399;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_71397__$1,inst_71395);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2684__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2684__auto____0 = (function (){
var statearr_71400 = [null,null,null,null,null,null,null,null];
(statearr_71400[(0)] = flureeworker$ledger_listener_$_state_machine__2684__auto__);

(statearr_71400[(1)] = (1));

return statearr_71400;
});
var flureeworker$ledger_listener_$_state_machine__2684__auto____1 = (function (state_71397){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71397);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71401){var ex__2687__auto__ = e71401;
var statearr_71402_71405 = state_71397;
(statearr_71402_71405[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71397[(4)]))){
var statearr_71403_71406 = state_71397;
(statearr_71403_71406[(1)] = cljs.core.first((state_71397[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71407 = state_71397;
state_71397 = G__71407;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2684__auto__ = function(state_71397){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2684__auto____1.call(this,state_71397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2684__auto____0;
flureeworker$ledger_listener_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2684__auto____1;
return flureeworker$ledger_listener_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71404 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71404[(6)] = c__2706__auto__);

return statearr_71404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__71408 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71408,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71408,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__71411 = config;
var map__71411__$1 = cljs.core.__destructure_map(map__71411);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71411__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71411__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71411__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71411__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71411__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71411__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__5045__auto__ = queries;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__71412 = conn_data;
var map__71412__$1 = cljs.core.__destructure_map(map__71412);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71412__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71412__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71412__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__71413 = config;
var map__71413__$1 = cljs.core.__destructure_map(map__71413);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71413__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71413__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71413__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71413__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71419){
var state_val_71420 = (state_71419[(1)]);
if((state_val_71420 === (1))){
var inst_71414 = cljs.core.async.timeout((100));
var state_71419__$1 = state_71419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71419__$1,(2),inst_71414);
} else {
if((state_val_71420 === (2))){
var inst_71416 = (state_71419[(2)]);
var inst_71417 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_71419__$1 = (function (){var statearr_71421 = state_71419;
(statearr_71421[(7)] = inst_71416);

return statearr_71421;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_71419__$1,inst_71417);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2684__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2684__auto____0 = (function (){
var statearr_71422 = [null,null,null,null,null,null,null,null];
(statearr_71422[(0)] = flureeworker$connect_STAR__$_state_machine__2684__auto__);

(statearr_71422[(1)] = (1));

return statearr_71422;
});
var flureeworker$connect_STAR__$_state_machine__2684__auto____1 = (function (state_71419){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71419);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71423){var ex__2687__auto__ = e71423;
var statearr_71424_71435 = state_71419;
(statearr_71424_71435[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71419[(4)]))){
var statearr_71425_71436 = state_71419;
(statearr_71425_71436[(1)] = cljs.core.first((state_71419[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71437 = state_71419;
state_71419 = G__71437;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2684__auto__ = function(state_71419){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2684__auto____1.call(this,state_71419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2684__auto____0;
flureeworker$connect_STAR__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2684__auto____1;
return flureeworker$connect_STAR__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71426 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71426[(6)] = c__2706__auto__);

return statearr_71426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__71427_71438 = conn_id;
var G__71428_71439 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__71429_71440 = ref;
var G__71430_71441 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71427_71438,G__71428_71439,G__71429_71440,G__71430_71441) : flureeworker.worker_action.call(null,G__71427_71438,G__71428_71439,G__71429_71440,G__71430_71441));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__71431 = conn_id;
var G__71432 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__71433 = ref;
var G__71434 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71431,G__71432,G__71433,G__71434) : flureeworker.worker_action.call(null,G__71431,G__71432,G__71433,G__71434));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__71443 = arguments.length;
switch (G__71443) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__71444 = conn_data;
var map__71444__$1 = cljs.core.__destructure_map(map__71444);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71444__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71444__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71444__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71444__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__71451 = conn_id;
var G__71452 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__71453 = ref;
var G__71454 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71451,G__71452,G__71453,G__71454) : flureeworker.worker_action.call(null,G__71451,G__71452,G__71453,G__71454));
}catch (e71446){var e = e71446;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__71447 = conn_id;
var G__71448 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__71449 = ref;
var G__71450 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71447,G__71448,G__71449,G__71450) : flureeworker.worker_action.call(null,G__71447,G__71448,G__71449,G__71450));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e71455){var e = e71455;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__71456 = conn_id;
var G__71457 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__71458 = ref;
var G__71459 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71456,G__71457,G__71458,G__71459) : flureeworker.worker_action.call(null,G__71456,G__71457,G__71458,G__71459));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__71460 = config_STAR_;
var map__71460__$1 = cljs.core.__destructure_map(map__71460);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71460__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71460__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71460__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71460__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71466){
var state_val_71467 = (state_71466[(1)]);
if((state_val_71467 === (1))){
var inst_71461 = cljs.core.async.timeout((100));
var state_71466__$1 = state_71466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71466__$1,(2),inst_71461);
} else {
if((state_val_71467 === (2))){
var inst_71463 = (state_71466[(2)]);
var inst_71464 = flureeworker.connect_STAR_(id,ref);
var state_71466__$1 = (function (){var statearr_71468 = state_71466;
(statearr_71468[(7)] = inst_71463);

return statearr_71468;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_71466__$1,inst_71464);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2684__auto__ = null;
var flureeworker$connect_p_$_state_machine__2684__auto____0 = (function (){
var statearr_71469 = [null,null,null,null,null,null,null,null];
(statearr_71469[(0)] = flureeworker$connect_p_$_state_machine__2684__auto__);

(statearr_71469[(1)] = (1));

return statearr_71469;
});
var flureeworker$connect_p_$_state_machine__2684__auto____1 = (function (state_71466){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71466);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71470){var ex__2687__auto__ = e71470;
var statearr_71471_71482 = state_71466;
(statearr_71471_71482[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71466[(4)]))){
var statearr_71472_71483 = state_71466;
(statearr_71472_71483[(1)] = cljs.core.first((state_71466[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71484 = state_71466;
state_71466 = G__71484;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2684__auto__ = function(state_71466){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2684__auto____1.call(this,state_71466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2684__auto____0;
flureeworker$connect_p_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2684__auto____1;
return flureeworker$connect_p_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71473 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71473[(6)] = c__2706__auto__);

return statearr_71473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__71474 = id;
var G__71475 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__71476 = ref;
var G__71477 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71474,G__71475,G__71476,G__71477) : flureeworker.worker_action.call(null,G__71474,G__71475,G__71476,G__71477));
})).catch((function (error){
var G__71478 = id;
var G__71479 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__71480 = ref;
var G__71481 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71478,G__71479,G__71480,G__71481) : flureeworker.worker_action.call(null,G__71478,G__71479,G__71480,G__71481));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__5775__auto__ = [];
var len__5769__auto___71552 = arguments.length;
var i__5770__auto___71553 = (0);
while(true){
if((i__5770__auto___71553 < len__5769__auto___71552)){
args__5775__auto__.push((arguments[i__5770__auto___71553]));

var G__71554 = (i__5770__auto___71553 + (1));
i__5770__auto___71553 = G__71554;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((4) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5776__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__71490){
var vec__71491 = p__71490;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71491,(0),null);
var map__71494 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__71494__$1 = cljs.core.__destructure_map(map__71494);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71494__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71494__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71494__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__71495 = conn_id;
var G__71496 = new cljs.core.Keyword(null,"login","login",55217519);
var G__71497 = ref;
var G__71498 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71495,G__71496,G__71497,G__71498) : flureeworker.worker_action.call(null,G__71495,G__71496,G__71497,G__71498));
})());
var auth = null;
var c__2706__auto___71555 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71519){
var state_val_71520 = (state_71519[(1)]);
if((state_val_71520 === (1))){
var state_71519__$1 = state_71519;
var statearr_71521_71556 = state_71519__$1;
(statearr_71521_71556[(2)] = null);

(statearr_71521_71556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71520 === (2))){
var ___$1 = (function (){var statearr_71522 = state_71519;
(statearr_71522[(4)] = cljs.core.cons((5),(state_71519[(4)])));

return statearr_71522;
})();
var inst_71510 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_71511 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__71523 = conn_id;
var G__71524 = new cljs.core.Keyword(null,"login","login",55217519);
var G__71525 = ref;
var G__71526 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71523,G__71524,G__71525,G__71526) : flureeworker.worker_action.call(null,G__71523,G__71524,G__71525,G__71526));
});
})();
var inst_71512 = inst_71510.then(inst_71511);
var inst_71513 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e71527){var ___$2 = e71527;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__71528 = conn_id;
var G__71529 = new cljs.core.Keyword(null,"login","login",55217519);
var G__71530 = ref;
var G__71531 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71528,G__71529,G__71530,G__71531) : flureeworker.worker_action.call(null,G__71528,G__71529,G__71530,G__71531));
} else {
var G__71532 = conn_id;
var G__71533 = new cljs.core.Keyword(null,"login","login",55217519);
var G__71534 = ref;
var G__71535 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71532,G__71533,G__71534,G__71535) : flureeworker.worker_action.call(null,G__71532,G__71533,G__71534,G__71535));

}
});
})();
var inst_71514 = inst_71512.catch(inst_71513);
var ___$2 = (function (){var statearr_71536 = state_71519;
(statearr_71536[(4)] = cljs.core.rest((state_71519[(4)])));

return statearr_71536;
})();
var state_71519__$1 = state_71519;
var statearr_71537_71557 = state_71519__$1;
(statearr_71537_71557[(2)] = inst_71514);

(statearr_71537_71557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71520 === (3))){
var inst_71517 = (state_71519[(2)]);
var state_71519__$1 = state_71519;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71519__$1,inst_71517);
} else {
if((state_val_71520 === (4))){
var inst_71499 = (state_71519[(2)]);
var inst_71500 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_71501 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71499);
var inst_71502 = [(400),inst_71501];
var inst_71503 = cljs.core.PersistentHashMap.fromArrays(inst_71500,inst_71502);
var inst_71504 = (function (){var G__71539 = conn_id;
var G__71540 = new cljs.core.Keyword(null,"login","login",55217519);
var G__71541 = ref;
var G__71542 = inst_71503;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71539,G__71540,G__71541,G__71542) : flureeworker.worker_action.call(null,G__71539,G__71540,G__71541,G__71542));
})();
var state_71519__$1 = state_71519;
var statearr_71543_71558 = state_71519__$1;
(statearr_71543_71558[(2)] = inst_71504);

(statearr_71543_71558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71520 === (5))){
var ___$1 = (function (){var statearr_71544 = state_71519;
(statearr_71544[(4)] = cljs.core.rest((state_71519[(4)])));

return statearr_71544;
})();
var state_71519__$1 = state_71519;
var ex71538 = (state_71519__$1[(2)]);
var statearr_71545_71559 = state_71519__$1;
(statearr_71545_71559[(5)] = ex71538);


var statearr_71546_71560 = state_71519__$1;
(statearr_71546_71560[(1)] = (4));

(statearr_71546_71560[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2684__auto__ = null;
var flureeworker$state_machine__2684__auto____0 = (function (){
var statearr_71547 = [null,null,null,null,null,null,null];
(statearr_71547[(0)] = flureeworker$state_machine__2684__auto__);

(statearr_71547[(1)] = (1));

return statearr_71547;
});
var flureeworker$state_machine__2684__auto____1 = (function (state_71519){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71519);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71548){var ex__2687__auto__ = e71548;
var statearr_71549_71561 = state_71519;
(statearr_71549_71561[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71519[(4)]))){
var statearr_71550_71562 = state_71519;
(statearr_71550_71562[(1)] = cljs.core.first((state_71519[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71563 = state_71519;
state_71519 = G__71563;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$state_machine__2684__auto__ = function(state_71519){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$state_machine__2684__auto____1.call(this,state_71519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2684__auto____0;
flureeworker$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2684__auto____1;
return flureeworker$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71551 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71551[(6)] = c__2706__auto___71555);

return statearr_71551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq71485){
var G__71486 = cljs.core.first(seq71485);
var seq71485__$1 = cljs.core.next(seq71485);
var G__71487 = cljs.core.first(seq71485__$1);
var seq71485__$2 = cljs.core.next(seq71485__$1);
var G__71488 = cljs.core.first(seq71485__$2);
var seq71485__$3 = cljs.core.next(seq71485__$2);
var G__71489 = cljs.core.first(seq71485__$3);
var seq71485__$4 = cljs.core.next(seq71485__$3);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71486,G__71487,G__71488,G__71489,seq71485__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__71564 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__71564__$1 = cljs.core.__destructure_map(map__71564);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71564__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71564__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__71566 = conn_id;
var G__71567 = new cljs.core.Keyword(null,"login","login",55217519);
var G__71568 = ref;
var G__71569 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71566,G__71567,G__71568,G__71569) : flureeworker.worker_action.call(null,G__71566,G__71567,G__71568,G__71569));
})());
var map__71565 = map_data;
var map__71565__$1 = cljs.core.__destructure_map(map__71565);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71565__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71565__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71565__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2706__auto___71623 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71590){
var state_val_71591 = (state_71590[(1)]);
if((state_val_71591 === (1))){
var state_71590__$1 = state_71590;
var statearr_71592_71624 = state_71590__$1;
(statearr_71592_71624[(2)] = null);

(statearr_71592_71624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71591 === (2))){
var ___$1 = (function (){var statearr_71593 = state_71590;
(statearr_71593[(4)] = cljs.core.cons((5),(state_71590[(4)])));

return statearr_71593;
})();
var inst_71581 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_71582 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__71594 = conn_id;
var G__71595 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__71596 = ref;
var G__71597 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71594,G__71595,G__71596,G__71597) : flureeworker.worker_action.call(null,G__71594,G__71595,G__71596,G__71597));
});
})();
var inst_71583 = inst_71581.then(inst_71582);
var inst_71584 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e71598){var ___$2 = e71598;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__71599 = conn_id;
var G__71600 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__71601 = ref;
var G__71602 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71599,G__71600,G__71601,G__71602) : flureeworker.worker_action.call(null,G__71599,G__71600,G__71601,G__71602));
} else {
var G__71603 = conn_id;
var G__71604 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__71605 = ref;
var G__71606 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71603,G__71604,G__71605,G__71606) : flureeworker.worker_action.call(null,G__71603,G__71604,G__71605,G__71606));

}
});
})();
var inst_71585 = inst_71583.catch(inst_71584);
var ___$2 = (function (){var statearr_71607 = state_71590;
(statearr_71607[(4)] = cljs.core.rest((state_71590[(4)])));

return statearr_71607;
})();
var state_71590__$1 = state_71590;
var statearr_71608_71625 = state_71590__$1;
(statearr_71608_71625[(2)] = inst_71585);

(statearr_71608_71625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71591 === (3))){
var inst_71588 = (state_71590[(2)]);
var state_71590__$1 = state_71590;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71590__$1,inst_71588);
} else {
if((state_val_71591 === (4))){
var inst_71570 = (state_71590[(2)]);
var inst_71571 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_71572 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71570);
var inst_71573 = [(400),inst_71572];
var inst_71574 = cljs.core.PersistentHashMap.fromArrays(inst_71571,inst_71573);
var inst_71575 = (function (){var G__71610 = conn_id;
var G__71611 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__71612 = ref;
var G__71613 = inst_71574;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__71610,G__71611,G__71612,G__71613) : flureeworker.worker_action.call(null,G__71610,G__71611,G__71612,G__71613));
})();
var state_71590__$1 = state_71590;
var statearr_71614_71626 = state_71590__$1;
(statearr_71614_71626[(2)] = inst_71575);

(statearr_71614_71626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71591 === (5))){
var ___$1 = (function (){var statearr_71615 = state_71590;
(statearr_71615[(4)] = cljs.core.rest((state_71590[(4)])));

return statearr_71615;
})();
var state_71590__$1 = state_71590;
var ex71609 = (state_71590__$1[(2)]);
var statearr_71616_71627 = state_71590__$1;
(statearr_71616_71627[(5)] = ex71609);


var statearr_71617_71628 = state_71590__$1;
(statearr_71617_71628[(1)] = (4));

(statearr_71617_71628[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2684__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2684__auto____0 = (function (){
var statearr_71618 = [null,null,null,null,null,null,null];
(statearr_71618[(0)] = flureeworker$pw_generate_$_state_machine__2684__auto__);

(statearr_71618[(1)] = (1));

return statearr_71618;
});
var flureeworker$pw_generate_$_state_machine__2684__auto____1 = (function (state_71590){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71590);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71619){var ex__2687__auto__ = e71619;
var statearr_71620_71629 = state_71590;
(statearr_71620_71629[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71590[(4)]))){
var statearr_71621_71630 = state_71590;
(statearr_71621_71630[(1)] = cljs.core.first((state_71590[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71631 = state_71590;
state_71590 = G__71631;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2684__auto__ = function(state_71590){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2684__auto____1.call(this,state_71590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2684__auto____0;
flureeworker$pw_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2684__auto____1;
return flureeworker$pw_generate_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71622 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71622[(6)] = c__2706__auto___71623);

return statearr_71622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__71632_SHARP_){
return (js_array[p1__71632_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e71633){var e = e71633;
var data = (event["data"]);
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5804__auto___71634 = cljs.core.not(self.document);
if(temp__5804__auto___71634){
var worker_QMARK__71635 = temp__5804__auto___71634;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__71636_71638 = null;
var G__71637_71639 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__71636_71638,G__71637_71639) : flureeworker.worker_action.call(null,G__71636_71638,G__71637_71639));
