/*
 * Decompiled with CFR 0.152.
 */
package io.appform.foxtrot.client.cluster;

import io.appform.foxtrot.client.FoxtrotClientConfig;
import io.appform.foxtrot.client.cluster.FoxtrotNodeDiscoveryCluster;
import io.appform.foxtrot.client.cluster.FoxtrotSimpleCluster;
import io.appform.foxtrot.client.cluster.IFoxtrotCluster;
import io.appform.foxtrot.client.selectors.EndpointType;
import io.appform.foxtrot.client.selectors.RandomSelector;

public class FoxtrotClusterFactory {
    private final FoxtrotClientConfig clientConfig;

    public IFoxtrotCluster getCluster(EndpointType endpointType) throws Exception {
        switch (endpointType) {
            case SIMPLE: {
                return new FoxtrotSimpleCluster(this.clientConfig);
            }
            case DISCOVERY: {
                return new FoxtrotNodeDiscoveryCluster(this.clientConfig, new RandomSelector());
            }
        }
        throw new UnsupportedOperationException("Endpoint type: " + (Object)((Object)endpointType) + " not supported");
    }

    public FoxtrotClusterFactory(FoxtrotClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }
}

