/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client.senders;

import com.flipkart.foxtrot.client.Document;
import com.flipkart.foxtrot.client.EventSender;
import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import com.flipkart.foxtrot.client.cluster.FoxtrotCluster;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterMember;
import com.flipkart.foxtrot.client.selectors.FoxtrotTarget;
import com.flipkart.foxtrot.client.senders.FoxtrotHttpClient;
import com.flipkart.foxtrot.client.serialization.DeserializationException;
import com.flipkart.foxtrot.client.serialization.EventSerializationHandler;
import com.flipkart.foxtrot.client.serialization.SerializationException;
import com.flipkart.foxtrot.client.util.JsonUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkHttpClient;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.Logger;
import feign.Response;
import feign.slf4j.Slf4jLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSyncEventSender
extends EventSender {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpSyncEventSender.class.getSimpleName());
    private final String table;
    private final FoxtrotCluster client;
    private FoxtrotHttpClient httpClient;
    private static final Slf4jLogger slf4jLogger = new Slf4jLogger();
    private static final String ERROR_MESSAGE = "message";
    private static final String INTERNAL_SERVER_ERROR = "500 INTERNAL SERVER ERROR";
    private static List<String> ignoreableFailureReasons = Lists.newArrayList();

    public HttpSyncEventSender(FoxtrotClientConfig config, FoxtrotCluster client, EventSerializationHandler serializationHandler) {
        super(serializationHandler);
        this.table = config.getTable();
        this.client = client;
        OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.setConnectionPool(new ConnectionPool(config.getMaxConnections(), config.getKeepAliveTimeMillis()));
        this.httpClient = (FoxtrotHttpClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(okHttpClient)).logger((feign.Logger)slf4jLogger).logLevel(Logger.Level.BASIC).target(new FoxtrotTarget<FoxtrotHttpClient>(FoxtrotHttpClient.class, "foxtrot", client));
        ignoreableFailureReasons = config.getIgnorableFailureMessagePatterns();
    }

    @Override
    public void send(Document document) {
        this.send(this.table, document);
    }

    @Override
    public void send(String table, Document document) {
        this.send(table, Collections.singletonList(document));
    }

    @Override
    public void send(List<Document> documents) {
        this.send(this.table, documents);
    }

    @Override
    public void send(String table, List<Document> documents) {
        try {
            this.send(table, this.getSerializationHandler().serialize(documents));
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }

    public void send(String table, byte[] payload) {
        block7: {
            FoxtrotClusterMember clusterMember = this.client.member();
            Preconditions.checkNotNull((Object)clusterMember, (Object)"No members found in foxtrot cluster");
            try {
                String responseBody;
                Response response = this.httpClient.send(table, payload);
                String string = responseBody = Objects.nonNull(response.body()) ? IOUtils.toString((InputStream)response.body().asInputStream()) : "{}";
                if (Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.Family.familyOf((int)response.status()))) {
                    logger.info("table={} messages_sent host={} port={} response={}", new Object[]{table, clusterMember.getHost(), clusterMember.getPort(), responseBody});
                    break block7;
                }
                if (response.status() == 400) {
                    logger.error("table={} client_error host={} port={} statusCode={} reason={} response={}", new Object[]{table, clusterMember.getHost(), clusterMember.getPort(), response.status(), response.reason(), responseBody});
                    break block7;
                }
                if (response.status() == 500) {
                    logger.debug("table={} server_error host={} port={} statusCode={} reason={} response={}", new Object[]{table, clusterMember.getHost(), clusterMember.getPort(), response.status(), response.reason(), responseBody});
                    Map<String, Object> responseMap = JsonUtils.readMapFromString(responseBody);
                    Optional<String> throwableFailure = Optional.of(INTERNAL_SERVER_ERROR);
                    if (responseMap.containsKey(ERROR_MESSAGE) && responseMap.get(ERROR_MESSAGE) instanceof String && Strings.isNotBlank((String)((String)responseMap.get(ERROR_MESSAGE)))) {
                        String[] failureReasons = ((String)responseMap.get(ERROR_MESSAGE)).split("&&&");
                        throwableFailure = Stream.of(failureReasons).filter(failureReason -> ignoreableFailureReasons.stream().noneMatch(ignorableFailureReason -> this.isMatching((String)failureReason, (String)ignorableFailureReason))).findAny();
                    }
                    if (throwableFailure.isPresent()) {
                        logger.error("table={} event_send_failed  host={} port={} statusCode={} reason={} response={} exception_message={}", new Object[]{table, clusterMember.getHost(), clusterMember.getPort(), response.status(), response.reason(), responseBody, throwableFailure.get()});
                        throw new RuntimeException(String.format("table=%s event_send_failed status [%d] exception_message=%s", table, response.status(), throwableFailure.get()));
                    }
                    break block7;
                }
                throw new RuntimeException(String.format("table=%s event_send_failed status [%d] exception_message=%s", table, response.status(), response.reason()));
            }
            catch (DeserializationException | FeignException | IOException e) {
                logger.error("table={} msg=event_publish_failed", (Object)new Object[]{table}, (Object)e);
                throw new RuntimeException("msg=event_publish_failed with exception : ", e);
            }
        }
    }

    private boolean isMatching(String str, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }
}

