/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class MockElasticsearchServer {
    private final Node node;
    private String DATA_DIRECTORY = UUID.randomUUID().toString() + "/elasticsearch-data";

    public MockElasticsearchServer(String directory) {
        this.DATA_DIRECTORY = UUID.randomUUID().toString() + "/" + directory;
        Settings settings = Settings.builder().put("http.enabled", "false").put("path.home", "target/" + this.DATA_DIRECTORY).build();
        this.node = NodeBuilder.nodeBuilder().local(true).settings(settings).node();
    }

    public void refresh(String index) {
        this.node.client().admin().indices().refresh((RefreshRequest)new RefreshRequest().indices(new String[]{index})).actionGet();
    }

    public Client getClient() {
        return this.node.client();
    }

    public void shutdown() throws IOException {
        this.node.client().admin().indices().delete(new DeleteIndexRequest("table-meta"));
        this.node.close();
        this.deleteDataDirectory();
    }

    private void deleteDataDirectory() throws IOException {
        System.out.println("Deleting DATA DIRECTORY");
        FileUtils.deleteDirectory((File)new File(this.DATA_DIRECTORY));
    }
}

