/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;

public class MockHTable
implements Table {
    private NavigableMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>> data = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>>(Bytes.BYTES_COMPARATOR);

    private static List<KeyValue> toKeyValue(byte[] row, NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> rowdata, int maxVersions) {
        return MockHTable.toKeyValue(row, rowdata, 0L, Long.MAX_VALUE, maxVersions);
    }

    private static List<KeyValue> toKeyValue(byte[] row, NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> rowdata, long timestampStart, long timestampEnd, int maxVersions) {
        ArrayList<KeyValue> ret = new ArrayList<KeyValue>();
        for (byte[] family : rowdata.keySet()) {
            block1: for (byte[] qualifier : ((NavigableMap)rowdata.get(family)).keySet()) {
                int versionsAdded = 0;
                for (Map.Entry tsToVal : ((NavigableMap)((NavigableMap)rowdata.get(family)).get(qualifier)).descendingMap().entrySet()) {
                    if (versionsAdded++ == maxVersions) continue block1;
                    Long timestamp = (Long)tsToVal.getKey();
                    if (timestamp < timestampStart || timestamp > timestampEnd) continue;
                    byte[] value = (byte[])tsToVal.getValue();
                    ret.add(new KeyValue(row, family, qualifier, timestamp.longValue(), value));
                }
            }
        }
        return ret;
    }

    public TableName getName() {
        return null;
    }

    public Configuration getConfiguration() {
        return null;
    }

    public HTableDescriptor getTableDescriptor() {
        return null;
    }

    public boolean exists(Get get) throws IOException {
        if (get.getFamilyMap() == null || get.getFamilyMap().size() == 0) {
            return this.data.containsKey(get.getRow());
        }
        byte[] row = get.getRow();
        if (!this.data.containsKey(row)) {
            return false;
        }
        for (byte[] family : get.getFamilyMap().keySet()) {
            if (!((NavigableMap)this.data.get(row)).containsKey(family)) {
                return false;
            }
            for (byte[] qualifier : (NavigableSet)get.getFamilyMap().get(family)) {
                if (((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).containsKey(qualifier)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        return new boolean[0];
    }

    public Result get(Get get) throws IOException {
        if (!this.data.containsKey(get.getRow())) {
            return new Result();
        }
        byte[] row = get.getRow();
        List<Object> kvs = new ArrayList();
        if (!get.hasFamilies()) {
            kvs = MockHTable.toKeyValue(row, (NavigableMap)this.data.get(row), get.getMaxVersions());
        } else {
            for (byte[] family : get.getFamilyMap().keySet()) {
                if (((NavigableMap)this.data.get(row)).get(family) == null) continue;
                NavigableSet qualifiers = (NavigableSet)get.getFamilyMap().get(family);
                if (qualifiers == null || qualifiers.isEmpty()) {
                    qualifiers = ((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).navigableKeySet();
                }
                for (byte[] qualifier : qualifiers) {
                    if (qualifier == null) {
                        qualifier = "".getBytes();
                    }
                    if (!((NavigableMap)this.data.get(row)).containsKey(family) || !((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).containsKey(qualifier) || ((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).isEmpty()) continue;
                    Map.Entry timestampAndValue = ((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).lastEntry();
                    kvs.add(new KeyValue(row, family, qualifier, ((Long)timestampAndValue.getKey()).longValue(), (byte[])timestampAndValue.getValue()));
                }
            }
        }
        Filter filter = get.getFilter();
        if (filter != null) {
            filter.reset();
            ArrayList<KeyValue> nkvs = new ArrayList<KeyValue>(kvs.size());
            for (KeyValue keyValue : kvs) {
                if (filter.filterAllRemaining()) break;
                if (filter.filterRowKey(keyValue.getBuffer(), keyValue.getRowOffset(), (int)keyValue.getRowLength()) || filter.filterKeyValue((Cell)keyValue) != Filter.ReturnCode.INCLUDE) continue;
                nkvs.add(keyValue);
            }
            kvs = nkvs;
        }
        return new Result(kvs);
    }

    /*
     * WARNING - void declaration
     */
    public ResultScanner getScanner(Scan scan) throws IOException {
        final ArrayList<Result> ret = new ArrayList<Result>();
        byte[] st = scan.getStartRow();
        byte[] sp = scan.getStopRow();
        Filter filter = scan.getFilter();
        for (byte[] row : this.data.keySet()) {
            if (st != null && st.length > 0 && Bytes.BYTES_COMPARATOR.compare(st, row) != 0) {
                if (st != null && st.length > 0 && Bytes.BYTES_COMPARATOR.compare(st, row) > 0) continue;
                if (sp != null && sp.length > 0 && Bytes.BYTES_COMPARATOR.compare(sp, row) <= 0) break;
            }
            List<Object> kvs = null;
            if (!scan.hasFamilies()) {
                kvs = MockHTable.toKeyValue(row, (NavigableMap)this.data.get(row), scan.getTimeRange().getMin(), scan.getTimeRange().getMax(), scan.getMaxVersions());
            } else {
                kvs = new ArrayList();
                for (byte[] family : scan.getFamilyMap().keySet()) {
                    void var11_14;
                    if (((NavigableMap)this.data.get(row)).get(family) == null) continue;
                    NavigableSet navigableSet = (NavigableSet)scan.getFamilyMap().get(family);
                    if (navigableSet == null || navigableSet.isEmpty()) {
                        NavigableSet navigableSet2 = ((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).navigableKeySet();
                    }
                    block2: for (byte[] qualifier : var11_14) {
                        if (((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier) == null) continue;
                        for (Long timestamp : ((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).descendingKeySet()) {
                            if (timestamp < scan.getTimeRange().getMin() || timestamp > scan.getTimeRange().getMax()) continue;
                            byte[] value = (byte[])((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).get(timestamp);
                            kvs.add(new KeyValue(row, family, qualifier, timestamp.longValue(), value));
                            if (kvs.size() != scan.getMaxVersions()) continue;
                            continue block2;
                        }
                    }
                }
            }
            if (filter != null) {
                filter.reset();
                ArrayList<KeyValue> nkvs = new ArrayList<KeyValue>(kvs.size());
                for (KeyValue keyValue : kvs) {
                    if (filter.filterAllRemaining()) break;
                    if (filter.filterRowKey(keyValue.getBuffer(), keyValue.getRowOffset(), (int)keyValue.getRowLength())) continue;
                    Filter.ReturnCode filterResult = filter.filterKeyValue((Cell)keyValue);
                    if (filterResult == Filter.ReturnCode.INCLUDE) {
                        nkvs.add(keyValue);
                        continue;
                    }
                    if (filterResult != Filter.ReturnCode.NEXT_ROW) continue;
                    break;
                }
                kvs = nkvs;
            }
            if (kvs.isEmpty()) continue;
            ret.add(new Result(kvs));
        }
        return new ResultScanner(){
            private final Iterator<Result> iterator;
            {
                this.iterator = ret.iterator();
            }

            public Iterator<Result> iterator() {
                return this.iterator;
            }

            public Result[] next(int nbRows) throws IOException {
                Result next;
                ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
                for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
                    resultSets.add(next);
                }
                return resultSets.toArray(new Result[resultSets.size()]);
            }

            public Result next() throws IOException {
                try {
                    return this.iterator().next();
                }
                catch (NoSuchElementException e) {
                    return null;
                }
            }

            public void close() {
            }
        };
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public void put(Put put) throws IOException {
        byte[] row = put.getRow();
        NavigableMap rowData = this.forceFind(this.data, row, new TreeMap(Bytes.BYTES_COMPARATOR));
        for (byte[] family : put.getFamilyMap().keySet()) {
            NavigableMap familyData = this.forceFind(rowData, family, new TreeMap(Bytes.BYTES_COMPARATOR));
            for (KeyValue kv : (List)put.getFamilyMap().get(family)) {
                kv.updateLatestStamp(Bytes.toBytes((long)System.currentTimeMillis()));
                byte[] qualifier = kv.getQualifier();
                NavigableMap qualifierData = this.forceFind(familyData, qualifier, new TreeMap());
                qualifierData.put(kv.getTimestamp(), kv.getValue());
            }
        }
    }

    private <K, V> V forceFind(NavigableMap<K, V> map, K key, V newObject) {
        Object data = map.get(key);
        if (data == null) {
            data = newObject;
            map.put(key, data);
        }
        return data;
    }

    public void put(List<Put> puts) throws IOException {
        for (Put put : puts) {
            this.put(put);
        }
    }

    private boolean check(byte[] row, byte[] family, byte[] qualifier, byte[] value) {
        if (value == null || value.length == 0) {
            return !this.data.containsKey(row) || !((NavigableMap)this.data.get(row)).containsKey(family) || !((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).containsKey(qualifier);
        }
        return this.data.containsKey(row) && ((NavigableMap)this.data.get(row)).containsKey(family) && ((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).containsKey(qualifier) && !((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).isEmpty() && Arrays.equals((byte[])((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).lastEntry().getValue(), value);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        if (this.check(row, family, qualifier, value)) {
            this.put(put);
            return true;
        }
        return false;
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        return false;
    }

    public void delete(Delete delete) throws IOException {
        byte[] row = delete.getRow();
        if (this.data.get(row) == null) {
            return;
        }
        if (delete.getFamilyMap().size() == 0) {
            this.data.remove(row);
            return;
        }
        for (byte[] family : delete.getFamilyMap().keySet()) {
            if (((NavigableMap)this.data.get(row)).get(family) == null) continue;
            if (((List)delete.getFamilyMap().get(family)).isEmpty()) {
                ((NavigableMap)this.data.get(row)).remove(family);
                continue;
            }
            for (KeyValue kv : (List)delete.getFamilyMap().get(family)) {
                ((NavigableMap)((NavigableMap)this.data.get(row)).get(kv.getFamily())).remove(kv.getQualifier());
            }
            if (!((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).isEmpty()) continue;
            ((NavigableMap)this.data.get(row)).remove(family);
        }
        if (((NavigableMap)this.data.get(row)).isEmpty()) {
            this.data.remove(row);
        }
    }

    public void delete(List<Delete> deletes) throws IOException {
        for (Delete delete : deletes) {
            this.delete(delete);
        }
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        if (this.check(row, family, qualifier, value)) {
            this.delete(delete);
            return true;
        }
        return false;
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        return false;
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, Durability.ASYNC_WAL);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        if (this.check(row, family, qualifier, null)) {
            Put put = new Put(row);
            put.add(family, qualifier, Bytes.toBytes((long)amount));
            this.put(put);
            return amount;
        }
        long newValue = Bytes.toLong((byte[])((byte[])((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).lastEntry().getValue())) + amount;
        ((NavigableMap)((NavigableMap)((NavigableMap)this.data.get(row)).get(family)).get(qualifier)).put(System.currentTimeMillis(), Bytes.toBytes((long)newValue));
        return newValue;
    }

    public void close() throws IOException {
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return null;
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        return null;
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
    }

    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        ArrayList<Result> results = new ArrayList<Result>();
        for (Row row : actions) {
            if (row instanceof Delete) {
                this.delete((Delete)row);
                continue;
            }
            if (row instanceof Put) {
                this.put((Put)row);
                continue;
            }
            if (!(row instanceof Get)) continue;
            results.add(this.get((Get)row));
        }
        return results.toArray();
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
    }

    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        return new Object[0];
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        results = this.batch(actions);
    }

    public Result[] get(List<Get> gets) throws IOException {
        ArrayList<Result> results = new ArrayList<Result>();
        for (Get g : gets) {
            results.add(this.get(g));
        }
        return results.toArray(new Result[results.size()]);
    }

    public Result increment(Increment increment) throws IOException {
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        NavigableMap famToVal = increment.getFamilyMap();
        for (Map.Entry ef : famToVal.entrySet()) {
            byte[] family = (byte[])ef.getKey();
            List qToVal = (List)ef.getValue();
            for (KeyValue eq : qToVal) {
                this.incrementColumnValue(increment.getRow(), family, eq.getKey(), eq.getValueLength());
                kvs.add(new KeyValue(increment.getRow(), family, eq.getKey(), eq.getValue()));
            }
        }
        return new Result(kvs);
    }

    private MockHTable() {
    }

    public static MockHTable create() {
        return new MockHTable();
    }

    public static MockHTable with(Map<String, Map<String, String>> dump) {
        MockHTable ret = new MockHTable();
        for (String row : dump.keySet()) {
            for (String column : dump.get(row).keySet()) {
                String val = dump.get(row).get(column);
                MockHTable.put(ret, row, column, val);
            }
        }
        return ret;
    }

    private static void put(MockHTable ret, String row, String column, String val) {
        String[] fq = MockHTable.split(column);
        byte[] family = Bytes.toBytesBinary((String)fq[0]);
        byte[] qualifier = Bytes.toBytesBinary((String)fq[1]);
        NavigableMap families = ret.forceFind(ret.data, Bytes.toBytesBinary((String)row), new TreeMap(Bytes.BYTES_COMPARATOR));
        NavigableMap qualifiers = ret.forceFind(families, family, new TreeMap(Bytes.BYTES_COMPARATOR));
        NavigableMap values = ret.forceFind(qualifiers, qualifier, new TreeMap());
        values.put(System.currentTimeMillis(), Bytes.toBytesBinary((String)val));
    }

    public static MockHTable with(String[][] dump) {
        MockHTable ret = new MockHTable();
        for (String[] row : dump) {
            MockHTable.put(ret, row[0], row[1], row[2]);
        }
        return ret;
    }

    private static String[] split(String column) {
        return new String[]{column.substring(0, column.indexOf(58)), column.substring(column.indexOf(58) + 1)};
    }

    public byte[] read(String rowid, String column) {
        NavigableMap row = (NavigableMap)this.data.get(Bytes.toBytesBinary((String)rowid));
        if (row == null) {
            return null;
        }
        String[] fq = MockHTable.split(column);
        byte[] family = Bytes.toBytesBinary((String)fq[0]);
        byte[] qualifier = Bytes.toBytesBinary((String)fq[1]);
        if (!row.containsKey(family)) {
            return null;
        }
        if (!((NavigableMap)row.get(family)).containsKey(qualifier)) {
            return null;
        }
        return (byte[])((NavigableMap)((NavigableMap)row.get(family)).get(qualifier)).lastEntry().getValue();
    }

    public static String toEString(boolean val) {
        return Bytes.toStringBinary((byte[])Bytes.toBytes((boolean)val));
    }

    public static String toEString(double val) {
        return Bytes.toStringBinary((byte[])Bytes.toBytes((double)val));
    }

    public static String toEString(float val) {
        return Bytes.toStringBinary((byte[])Bytes.toBytes((float)val));
    }

    public static String toEString(int val) {
        return Bytes.toStringBinary((byte[])Bytes.toBytes((int)val));
    }

    public static String toEString(long val) {
        return Bytes.toStringBinary((byte[])Bytes.toBytes((long)val));
    }

    public static String toEString(short val) {
        return Bytes.toStringBinary((byte[])Bytes.toBytes((short)val));
    }

    public void mutateRow(RowMutations rm) throws IOException {
    }

    public Result append(Append append) throws IOException {
        return null;
    }

    public long getWriteBufferSize() {
        return 0L;
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        return null;
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation) throws IOException {
        return false;
    }
}

