/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.group.GroupRequest;
import com.flipkart.foxtrot.common.group.GroupResponse;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupActionCardinalityTest
extends ActionTest {
    private static final Logger log = LoggerFactory.getLogger(GroupActionCardinalityTest.class);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        List<Document> documents = TestUtils.getGroupDocumentsForEstimation(this.getMapper());
        this.getQueryStore().save("test-table", documents);
        this.getElasticsearchServer().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
        this.getTableMetadataManager().updateEstimationData("test-table", 1397658117000L);
    }

    @Test
    public void testEstimationWithMultipleNesting() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "registered"}));
        GroupResponse response = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertTrue((boolean)response.getResult().containsKey("android"));
        Assert.assertTrue((boolean)response.getResult().containsKey("ios"));
    }

    @Test
    public void testEstimationBooleanCardinality() throws Exception {
        GroupRequest groupRequest = new GroupRequest();
        groupRequest.setTable("test-table");
        groupRequest.setNesting(Collections.singletonList("registered"));
        GroupResponse response = (GroupResponse)GroupResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)groupRequest));
        Assert.assertTrue((boolean)response.getResult().containsKey("0"));
    }
}

