/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.stats.BucketResponse;
import com.flipkart.foxtrot.common.stats.StatsTrendRequest;
import com.flipkart.foxtrot.common.stats.StatsTrendResponse;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatsTrendActionTest
extends ActionTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        List<Document> documents = TestUtils.getStatsTrendDocuments(this.getMapper());
        this.getQueryStore().save("test-table", documents);
        this.getElasticsearchServer().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
    }

    private void filterNonZeroCounts(StatsTrendResponse statsTrendResponse) {
        statsTrendResponse.getResult().removeIf(statsTrendValue -> ((Number)statsTrendValue.getStats().get("count")).equals(0L));
    }

    @Test
    public void testStatsTrendActionWithoutNesting() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)5L, (long)statsTrendResponse.getResult().size());
        Assert.assertNull((Object)statsTrendResponse.getBuckets());
    }

    @Test
    public void testStatsTrendActionWithNesting() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os"}));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNull((Object)statsTrendResponse.getResult());
        Assert.assertNotNull((Object)statsTrendResponse.getBuckets());
        Assert.assertEquals((long)3L, (long)statsTrendResponse.getBuckets().size());
    }

    @Test
    public void testStatsTrendActionWithMultiLevelNesting() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNull((Object)statsTrendResponse.getResult());
        Assert.assertNotNull((Object)statsTrendResponse.getBuckets());
        Assert.assertEquals((long)3L, (long)statsTrendResponse.getBuckets().size());
        Assert.assertEquals((long)1L, (long)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getBuckets().size());
        Assert.assertEquals((long)2L, (long)((BucketResponse)statsTrendResponse.getBuckets().get(1)).getBuckets().size());
        Assert.assertEquals((long)1L, (long)((BucketResponse)statsTrendResponse.getBuckets().get(2)).getBuckets().size());
    }

    @Test
    public void testStatsTrendActionWithNoFilter() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(this.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNull((Object)statsTrendResponse);
    }

    @Test(expected=MalformedQueryException.class)
    public void testStatsTrendActionNullTable() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable(null);
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        this.getQueryExecutor().execute((ActionRequest)request);
    }

    @Test(expected=MalformedQueryException.class)
    public void testStatsTrendActionNullField() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField(null);
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        this.getQueryExecutor().execute((ActionRequest)request);
    }
}

