/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.group.GroupResponse;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.cache.CacheFactory;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.cache.impl.DistributedCache;
import com.flipkart.foxtrot.core.cache.impl.DistributedCacheFactory;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.impl.CacheConfig;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.util.Collections;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DistributedCacheTest {
    private DistributedCache distributedCache;
    private HazelcastInstance hazelcastInstance;
    private ObjectMapper mapper;

    @Before
    public void setUp() throws Exception {
        this.mapper = new ObjectMapper();
        this.mapper = (ObjectMapper)Mockito.spy((Object)this.mapper);
        this.hazelcastInstance = new TestHazelcastInstanceFactory(1).newHazelcastInstance();
        HazelcastConnection hazelcastConnection = (HazelcastConnection)Mockito.mock(HazelcastConnection.class);
        Mockito.when((Object)hazelcastConnection.getHazelcast()).thenReturn((Object)this.hazelcastInstance);
        Mockito.when((Object)hazelcastConnection.getHazelcastConfig()).thenReturn((Object)new Config());
        this.distributedCache = new DistributedCache(hazelcastConnection, "TEST", this.mapper);
        CacheManager cacheManager = new CacheManager((CacheFactory)new DistributedCacheFactory(hazelcastConnection, this.mapper, new CacheConfig()));
        TableMetadataManager tableMetadataManager = (TableMetadataManager)Mockito.mock(TableMetadataManager.class);
        Mockito.when((Object)tableMetadataManager.exists("test-table")).thenReturn((Object)true);
        QueryStore queryStore = (QueryStore)Mockito.mock(QueryStore.class);
        AnalyticsLoader analyticsLoader = new AnalyticsLoader(tableMetadataManager, null, queryStore, null, cacheManager, this.mapper);
        TestUtils.registerActions(analyticsLoader, this.mapper);
    }

    @After
    public void tearDown() throws Exception {
        this.hazelcastInstance.shutdown();
    }

    @Test
    public void testPut() throws Exception {
        GroupResponse expectedResponse = new GroupResponse(Collections.singletonMap("Hello", "world"));
        ActionResponse returnResponse = this.distributedCache.put("DUMMY_KEY_PUT", (ActionResponse)expectedResponse);
        Assert.assertEquals((Object)expectedResponse, (Object)returnResponse);
        GroupResponse actualResponse = (GroupResponse)GroupResponse.class.cast(this.distributedCache.get("DUMMY_KEY_PUT"));
        Assert.assertEquals((Object)((GroupResponse)GroupResponse.class.cast(expectedResponse)).getResult(), (Object)actualResponse.getResult());
    }

    @Test
    public void testPutCacheException() throws Exception {
        ((ObjectMapper)Mockito.doThrow((Throwable[])new Throwable[]{new JsonGenerationException("TEST_EXCEPTION")}).when((Object)this.mapper)).writeValueAsString(Mockito.any());
        ActionResponse returnResponse = this.distributedCache.put("DUMMY_KEY_PUT", null);
        ((ObjectMapper)Mockito.verify((Object)this.mapper, (VerificationMode)Mockito.times((int)1))).writeValueAsString(Mockito.any());
        Assert.assertNull((Object)returnResponse);
        Assert.assertNull((Object)this.hazelcastInstance.getMap("TEST").get((Object)"DUMMY_KEY_PUT"));
    }

    @Test
    public void testGet() throws Exception {
        GroupResponse baseRequest = new GroupResponse();
        baseRequest.setResult(Collections.singletonMap("Hello", "World"));
        String requestString = this.mapper.writeValueAsString((Object)baseRequest);
        this.distributedCache.put("DUMMY_KEY_GET", (ActionResponse)this.mapper.readValue(requestString, ActionResponse.class));
        ActionResponse actionResponse = this.distributedCache.get("DUMMY_KEY_GET");
        String actualResponse = this.mapper.writeValueAsString((Object)actionResponse);
        Assert.assertEquals((Object)requestString, (Object)actualResponse);
    }

    @Test
    public void testGetInvalidKeyValue() throws Exception {
        Assert.assertNull((Object)this.distributedCache.get("DUMMY_KEY_GET"));
    }

    @Test
    public void testGetNullKey() throws Exception {
        Assert.assertNull((Object)this.distributedCache.get(null));
    }

    @Test
    public void testHas() throws Exception {
        GroupResponse baseRequest = new GroupResponse();
        baseRequest.setResult(Collections.singletonMap("Hello", "World"));
        this.distributedCache.put("DUMMY_KEY_HAS", (ActionResponse)baseRequest);
        boolean response = this.distributedCache.has("DUMMY_KEY_HAS");
        Assert.assertTrue((boolean)response);
        response = this.distributedCache.has("INVALID_KEY");
        Assert.assertFalse((boolean)response);
        response = this.distributedCache.has(null);
        Assert.assertFalse((boolean)response);
    }
}

