/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.FieldType;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.common.TableFieldMapping;
import com.flipkart.foxtrot.common.group.GroupResponse;
import com.flipkart.foxtrot.core.MockElasticsearchServer;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.cardinality.CardinalityConfig;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchQueryStore;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.core.table.impl.DistributedTableMetadataManager;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.util.UUID;
import org.elasticsearch.client.Client;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DistributedTableMetadataManagerTest {
    private DataStore dataStore;
    private ElasticsearchQueryStore queryStore;
    private HazelcastInstance hazelcastInstance;
    private DistributedTableMetadataManager distributedTableMetadataManager;
    private MockElasticsearchServer elasticsearchServer;
    private IMap<String, Table> tableDataStore;
    private ObjectMapper objectMapper;

    @Before
    public void setUp() throws Exception {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerSubtypes(new Class[]{GroupResponse.class});
        this.dataStore = (DataStore)Mockito.mock(DataStore.class);
        this.elasticsearchServer = new MockElasticsearchServer(UUID.randomUUID().toString());
        ElasticsearchConnection elasticsearchConnection = TestUtils.initESConnection(this.elasticsearchServer);
        Mockito.when((Object)elasticsearchConnection.getClient()).thenReturn((Object)this.elasticsearchServer.getClient());
        ElasticsearchUtils.initializeMappings((Client)elasticsearchConnection.getClient());
        this.hazelcastInstance = new TestHazelcastInstanceFactory(1).newHazelcastInstance();
        HazelcastConnection hazelcastConnection = (HazelcastConnection)Mockito.mock(HazelcastConnection.class);
        Mockito.when((Object)hazelcastConnection.getHazelcast()).thenReturn((Object)this.hazelcastInstance);
        Mockito.when((Object)hazelcastConnection.getHazelcastConfig()).thenReturn((Object)new Config());
        hazelcastConnection.start();
        this.distributedTableMetadataManager = new DistributedTableMetadataManager(hazelcastConnection, elasticsearchConnection, this.objectMapper, new CardinalityConfig("true", String.valueOf(50)));
        this.distributedTableMetadataManager.start();
        this.tableDataStore = this.hazelcastInstance.getMap("tablemetadatamap");
        this.queryStore = new ElasticsearchQueryStore((TableMetadataManager)this.distributedTableMetadataManager, elasticsearchConnection, this.dataStore, this.objectMapper, new CardinalityConfig("true", String.valueOf(50)));
    }

    @After
    public void tearDown() throws Exception {
        this.hazelcastInstance.shutdown();
        this.elasticsearchServer.shutdown();
        this.distributedTableMetadataManager.stop();
    }

    @Test
    public void testSave() throws Exception {
        Table table = new Table();
        table.setName("TEST_TABLE");
        table.setTtl(15);
        this.distributedTableMetadataManager.save(table);
        Table responseTable = this.distributedTableMetadataManager.get("TEST_TABLE");
        Assert.assertEquals((Object)table.getName(), (Object)responseTable.getName());
        Assert.assertEquals((long)table.getTtl(), (long)responseTable.getTtl());
    }

    @Test
    public void testGet() throws Exception {
        Table table = new Table();
        table.setName("test-table");
        table.setTtl(60);
        this.tableDataStore.put((Object)"test-table", (Object)table);
        Table response = this.distributedTableMetadataManager.get(table.getName());
        Assert.assertEquals((Object)table.getName(), (Object)response.getName());
        Assert.assertEquals((long)table.getTtl(), (long)response.getTtl());
    }

    @Test
    public void testGetMissingTable() throws Exception {
        Table response = this.distributedTableMetadataManager.get(TestUtils.TEST_TABLE + "-missing");
        Assert.assertNull((Object)response);
    }

    @Test
    public void testExists() throws Exception {
        Table table = new Table();
        table.setName("test-table");
        table.setTtl(15);
        this.distributedTableMetadataManager.save(table);
        Assert.assertTrue((boolean)this.distributedTableMetadataManager.exists(table.getName()));
        Assert.assertFalse((boolean)this.distributedTableMetadataManager.exists("DUMMY_TEST_NAME_NON_EXISTENT"));
    }

    @Test
    public void testGetFieldMappings() throws Exception {
        Table table = new Table();
        table.setName("test-table");
        table.setTtl(15);
        this.distributedTableMetadataManager.save(table);
        Document document = TestUtils.getDocument("A", new DateTime().minusDays(1).getMillis(), new Object[]{"os", "android", "version", 1}, this.objectMapper);
        Document translatedDocument = TestUtils.translatedDocumentWithRowKeyVersion1(table, document);
        ((DataStore)Mockito.doReturn((Object)translatedDocument).when((Object)this.dataStore)).save(table, document);
        this.queryStore.save("test-table", document);
        document = TestUtils.getDocument("B", new DateTime().getMillis(), new Object[]{"os", "android", "version", "abcd"}, this.objectMapper);
        translatedDocument = TestUtils.translatedDocumentWithRowKeyVersion1(table, document);
        ((DataStore)Mockito.doReturn((Object)translatedDocument).when((Object)this.dataStore)).save(table, document);
        this.queryStore.save("test-table", document);
        TableFieldMapping tableFieldMapping = this.distributedTableMetadataManager.getFieldMappings("test-table", true, false);
        Assert.assertEquals((long)3L, (long)tableFieldMapping.getMappings().size());
        Assert.assertEquals((Object)FieldType.STRING, (Object)tableFieldMapping.getMappings().stream().filter(x -> x.getField().equals("version")).findAny().get().getType());
        Assert.assertEquals((Object)FieldType.STRING, (Object)tableFieldMapping.getMappings().stream().filter(x -> x.getField().equals("os")).findAny().get().getType());
    }
}

