/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.query.datetime.LastFilter;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.core.common.PeriodSelector;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConfig;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import io.dropwizard.util.Duration;
import java.util.Arrays;
import java.util.Collections;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ElasticsearchUtilsTest {
    private static final long TEST_CURRENT_TIME = 1428151913000L;
    @Rule
    public TestWatcher tzRule = new TestWatcher(){
        private DateTimeZone defaultTz = DateTimeZone.getDefault();

        protected void starting(Description description) {
            DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forOffsetHoursMinutes((int)5, (int)30));
        }

        protected void finished(Description description) {
            DateTimeZone.setDefault((DateTimeZone)this.defaultTz);
        }
    };

    @Test
    public void testGetIndicesLastSameSDay() throws Exception {
        TestRequest request = new TestRequest();
        LastFilter filter = new LastFilter();
        filter.setDuration(Duration.minutes((long)10L));
        filter.setCurrentTime(1428151913000L);
        request.setFilters(Collections.singletonList(filter));
        Object[] indexes = ElasticsearchUtils.getIndices((String)"test", (ActionRequest)request, (Interval)new PeriodSelector(request.getFilters()).analyze(1428151913000L));
        System.out.println(Arrays.toString(indexes));
        Assert.assertArrayEquals((Object[])new String[]{"foxtrot-test-table-04-4-2015"}, (Object[])indexes);
    }

    @Test
    public void testGetIndicesLastLastDays() throws Exception {
        TestRequest request = new TestRequest();
        LastFilter filter = new LastFilter();
        filter.setDuration(Duration.days((long)2L));
        filter.setCurrentTime(1428151913000L);
        request.setFilters(Collections.singletonList(filter));
        Object[] indexes = ElasticsearchUtils.getIndices((String)"test", (ActionRequest)request, (Interval)new PeriodSelector(request.getFilters()).analyze(1428151913000L));
        System.out.println(Arrays.toString(indexes));
        Assert.assertArrayEquals((Object[])new String[]{"foxtrot-test-table-02-4-2015", "foxtrot-test-table-03-4-2015", "foxtrot-test-table-04-4-2015"}, (Object[])indexes);
    }

    @Test
    public void testGetIndicesBetween() throws Exception {
        TestRequest request = new TestRequest();
        BetweenFilter filter = new BetweenFilter();
        filter.setTemporal(true);
        filter.setFrom((Number)1427997600000L);
        filter.setTo((Number)1428001200000L);
        request.setFilters(Collections.singletonList(filter));
        Object[] indexes = ElasticsearchUtils.getIndices((String)"test", (ActionRequest)request, (Interval)new PeriodSelector(request.getFilters()).analyze(1428151913000L));
        System.out.println(Arrays.toString(indexes));
        Assert.assertArrayEquals((Object[])new String[]{"foxtrot-test-table-02-4-2015", "foxtrot-test-table-03-4-2015"}, (Object[])indexes);
    }

    @Test
    public void testGetIndicesGreaterThan() throws Exception {
        TestRequest request = new TestRequest();
        GreaterThanFilter filter = new GreaterThanFilter();
        filter.setTemporal(true);
        filter.setValue((Number)1427997600000L);
        request.setFilters(Collections.singletonList(filter));
        Object[] indexes = ElasticsearchUtils.getIndices((String)"test", (ActionRequest)request, (Interval)new PeriodSelector(request.getFilters()).analyze(1428151913000L));
        System.out.println(Arrays.toString(indexes));
        Assert.assertArrayEquals((Object[])new String[]{"foxtrot-test-table-02-4-2015", "foxtrot-test-table-03-4-2015", "foxtrot-test-table-04-4-2015"}, (Object[])indexes);
    }

    @Test
    public void testGetIndicesGreaterEquals() throws Exception {
        TestRequest request = new TestRequest();
        GreaterEqualFilter filter = new GreaterEqualFilter();
        filter.setTemporal(true);
        filter.setValue((Number)1427997600000L);
        request.setFilters(Collections.singletonList(filter));
        Object[] indexes = ElasticsearchUtils.getIndices((String)"test", (ActionRequest)request, (Interval)new PeriodSelector(request.getFilters()).analyze(1428151913000L));
        System.out.println(Arrays.toString(indexes));
        Assert.assertArrayEquals((Object[])new String[]{"foxtrot-test-table-02-4-2015", "foxtrot-test-table-03-4-2015", "foxtrot-test-table-04-4-2015"}, (Object[])indexes);
    }

    @Test
    public void testGetIndicesLessThan() throws Exception {
        TestRequest request = new TestRequest();
        LessThanFilter filter = new LessThanFilter();
        filter.setTemporal(true);
        filter.setValue((Number)1427997600000L);
        request.setFilters(Collections.singletonList(filter));
        Object[] indexes = ElasticsearchUtils.getIndices((String)"test", (ActionRequest)request, (Interval)new PeriodSelector(request.getFilters()).analyze(1428151913000L));
        System.out.println(Arrays.toString(indexes));
        Assert.assertArrayEquals((Object[])new String[]{"foxtrot-test-table-*"}, (Object[])indexes);
    }

    @Test
    public void testGetIndicesLessThanEquals() throws Exception {
        TestRequest request = new TestRequest();
        LessThanFilter filter = new LessThanFilter();
        filter.setTemporal(true);
        filter.setValue((Number)1427997600000L);
        request.setFilters(Collections.singletonList(filter));
        Object[] indexes = ElasticsearchUtils.getIndices((String)"test", (ActionRequest)request, (Interval)new PeriodSelector(request.getFilters()).analyze(1428151913000L));
        System.out.println(Arrays.toString(indexes));
        Assert.assertArrayEquals((Object[])new String[]{"foxtrot-test-table-*"}, (Object[])indexes);
    }

    @Test
    public void testWithDifferentTableprefixShouldCreateIndexWithTableName() throws Exception {
        ElasticsearchConfig config = new ElasticsearchConfig();
        config.setTableNamePrefix("azkaban");
        ElasticsearchUtils.setTableNamePrefix((ElasticsearchConfig)config);
        TestRequest request = new TestRequest();
        LastFilter filter = new LastFilter();
        filter.setDuration(Duration.minutes((long)10L));
        filter.setCurrentTime(1428151913000L);
        request.setFilters(Collections.singletonList(filter));
        Object[] indexes = ElasticsearchUtils.getIndices((String)"test", (ActionRequest)request, (Interval)new PeriodSelector(request.getFilters()).analyze(1428151913000L));
        Assert.assertArrayEquals((Object[])new String[]{"azkaban-test-table-04-4-2015"}, (Object[])indexes);
        config.setTableNamePrefix("foxtrot");
        ElasticsearchUtils.setTableNamePrefix((ElasticsearchConfig)config);
    }

    @Test
    public void testGetIndicesGreaterEqualsWithDifferentTablePrefixName() throws Exception {
        ElasticsearchConfig config = new ElasticsearchConfig();
        config.setTableNamePrefix("azkaban");
        ElasticsearchUtils.setTableNamePrefix((ElasticsearchConfig)config);
        TestRequest request = new TestRequest();
        GreaterEqualFilter filter = new GreaterEqualFilter();
        filter.setTemporal(true);
        filter.setValue((Number)1427997600000L);
        request.setFilters(Collections.singletonList(filter));
        Object[] indexes = ElasticsearchUtils.getIndices((String)"test", (ActionRequest)request, (Interval)new PeriodSelector(request.getFilters()).analyze(1428151913000L));
        Assert.assertArrayEquals((Object[])new String[]{"azkaban-test-table-02-4-2015", "azkaban-test-table-03-4-2015", "azkaban-test-table-04-4-2015"}, (Object[])indexes);
        config.setTableNamePrefix("foxtrot");
        ElasticsearchUtils.setTableNamePrefix((ElasticsearchConfig)config);
    }

    private static final class TestRequest
    extends ActionRequest {
        private TestRequest() {
            super("test");
        }
    }
}

