/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.MockElasticsearchServer;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.table.impl.TableMapStore;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TableMapStoreTest {
    private MockElasticsearchServer elasticsearchServer;
    private ObjectMapper mapper = new ObjectMapper();
    private ElasticsearchConnection elasticsearchConnection;
    private TableMapStore tableMapStore;
    public static final String TEST_TABLE = "test-table";
    public static final String TABLE_META_INDEX = "table-meta";
    public static final String TABLE_META_TYPE = "table-meta";

    @Before
    public void setUp() throws Exception {
        this.mapper = (ObjectMapper)Mockito.spy((Object)this.mapper);
        this.elasticsearchServer = new MockElasticsearchServer(UUID.randomUUID().toString());
        ElasticsearchUtils.initializeMappings((Client)this.elasticsearchServer.getClient());
        this.elasticsearchConnection = (ElasticsearchConnection)Mockito.mock(ElasticsearchConnection.class);
        Mockito.when((Object)this.elasticsearchConnection.getClient()).thenReturn((Object)this.elasticsearchServer.getClient());
        Settings indexSettings = Settings.builder().put("number_of_replicas", 0).build();
        CreateIndexRequest createRequest = new CreateIndexRequest("table-meta").settings(indexSettings);
        this.elasticsearchServer.getClient().admin().indices().create(createRequest).actionGet();
        this.elasticsearchServer.getClient().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().execute().actionGet();
        TableMapStore.Factory factory = new TableMapStore.Factory(this.elasticsearchConnection);
        this.tableMapStore = factory.newMapStore(null, null);
    }

    @After
    public void tearDown() throws Exception {
        this.elasticsearchServer.shutdown();
    }

    @Test
    public void testStore() throws Exception {
        Table table = new Table();
        table.setName(TEST_TABLE);
        table.setTtl(30);
        this.tableMapStore.store(table.getName(), table);
        GetResponse response = (GetResponse)((GetRequestBuilder)this.elasticsearchConnection.getClient().prepareGet().setIndex("table-meta")).setType("table-meta").setId(table.getName()).execute().actionGet();
        this.compareTables(table, (Table)this.mapper.readValue(response.getSourceAsBytes(), Table.class));
    }

    @Test(expected=RuntimeException.class)
    public void testStoreNullKey() throws Exception {
        Table table = new Table();
        table.setName(TEST_TABLE);
        table.setTtl(30);
        this.tableMapStore.store(null, table);
    }

    @Test(expected=RuntimeException.class)
    public void testStoreNullTable() throws Exception {
        Table table = new Table();
        table.setName(TEST_TABLE);
        table.setTtl(30);
        this.tableMapStore.store(table.getName(), null);
    }

    @Test(expected=RuntimeException.class)
    public void testStoreNullTableName() throws Exception {
        Table table = new Table();
        table.setName(null);
        table.setTtl(30);
        this.tableMapStore.store(TEST_TABLE, table);
    }

    @Test
    public void testStoreAll() throws Exception {
        HashMap tables = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            Table table = new Table();
            table.setName(UUID.randomUUID().toString());
            table.setTtl(20);
            tables.put(table.getName(), table);
        }
        this.tableMapStore.storeAll((Map)tables);
        MultiGetResponse response = (MultiGetResponse)this.elasticsearchConnection.getClient().prepareMultiGet().add("table-meta", "table-meta", tables.keySet()).execute().actionGet();
        HashMap responseTables = Maps.newHashMap();
        for (MultiGetItemResponse multiGetItemResponse : response) {
            Table table = (Table)this.mapper.readValue(multiGetItemResponse.getResponse().getSourceAsString(), Table.class);
            responseTables.put(table.getName(), table);
        }
        for (Map.Entry entry : tables.entrySet()) {
            this.compareTables((Table)entry.getValue(), (Table)responseTables.get(entry.getKey()));
        }
    }

    @Test(expected=RuntimeException.class)
    public void testStoreAllNull() throws Exception {
        this.tableMapStore.storeAll(null);
    }

    @Test(expected=RuntimeException.class)
    public void testStoreAllNullTableKey() throws Exception {
        HashMap tables = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            Table table = new Table();
            table.setName(UUID.randomUUID().toString());
            table.setTtl(20);
            tables.put(null, table);
        }
        this.tableMapStore.storeAll((Map)tables);
    }

    @Test(expected=RuntimeException.class)
    public void testStoreAllNullTableValue() throws Exception {
        HashMap tables = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            tables.put(UUID.randomUUID().toString(), null);
        }
        this.tableMapStore.storeAll((Map)tables);
    }

    @Test(expected=RuntimeException.class)
    public void testStoreAllNullTableKeyValue() throws Exception {
        HashMap tables = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            tables.put(null, null);
        }
        this.tableMapStore.storeAll((Map)tables);
    }

    @Test(expected=RuntimeException.class)
    public void testStoreAllSomeNullKeys() throws Exception {
        HashMap tables = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            Table table = new Table();
            table.setName(UUID.randomUUID().toString());
            table.setTtl(20);
            tables.put(table.getName(), table);
        }
        Table table = new Table();
        table.setName(UUID.randomUUID().toString());
        table.setTtl(20);
        tables.put(null, table);
        this.tableMapStore.storeAll((Map)tables);
    }

    @Test(expected=RuntimeException.class)
    public void testStoreAllSomeNullValues() throws Exception {
        HashMap tables = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            Table table = new Table();
            table.setName(UUID.randomUUID().toString());
            table.setTtl(20);
            tables.put(table.getName(), table);
        }
        Table table = new Table();
        table.setName(UUID.randomUUID().toString());
        table.setTtl(20);
        tables.put(table.getName(), null);
        this.tableMapStore.storeAll((Map)tables);
    }

    @Test(expected=RuntimeException.class)
    public void testStoreAllSomeNullKeyValues() throws Exception {
        HashMap tables = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            Table table = new Table();
            table.setName(UUID.randomUUID().toString());
            table.setTtl(20);
            tables.put(table.getName(), table);
        }
        tables.put(null, null);
        this.tableMapStore.storeAll((Map)tables);
    }

    @Test
    public void testDelete() throws Exception {
        Table table = new Table();
        table.setName(TEST_TABLE);
        table.setTtl(30);
        this.tableMapStore.store(table.getName(), table);
        GetResponse response = (GetResponse)((GetRequestBuilder)this.elasticsearchConnection.getClient().prepareGet().setIndex("table-meta")).setType("table-meta").setId(table.getName()).execute().actionGet();
        Assert.assertTrue((boolean)response.isExists());
        this.tableMapStore.delete(table.getName());
        response = (GetResponse)((GetRequestBuilder)this.elasticsearchConnection.getClient().prepareGet().setIndex("table-meta")).setType("table-meta").setId(table.getName()).execute().actionGet();
        Assert.assertFalse((boolean)response.isExists());
    }

    @Test(expected=RuntimeException.class)
    public void testDeleteNullKey() throws Exception {
        this.tableMapStore.delete(null);
    }

    @Test
    public void testDeleteMissingKey() throws Exception {
        this.tableMapStore.delete("HELLO");
    }

    @Test
    public void testDeleteAll() throws Exception {
        GetResponse response;
        HashMap tables = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            Table table = new Table();
            table.setName(UUID.randomUUID().toString());
            table.setTtl(20);
            tables.put(table.getName(), table);
        }
        this.tableMapStore.storeAll((Map)tables);
        for (String name : tables.keySet()) {
            response = (GetResponse)((GetRequestBuilder)this.elasticsearchConnection.getClient().prepareGet().setIndex("table-meta")).setType("table-meta").setId(name).execute().actionGet();
            Assert.assertTrue((boolean)response.isExists());
        }
        this.tableMapStore.deleteAll(tables.keySet());
        for (String name : tables.keySet()) {
            response = (GetResponse)((GetRequestBuilder)this.elasticsearchConnection.getClient().prepareGet().setIndex("table-meta")).setType("table-meta").setId(name).execute().actionGet();
            Assert.assertFalse((boolean)response.isExists());
        }
    }

    @Test(expected=RuntimeException.class)
    public void testDeleteAllNull() throws Exception {
        this.tableMapStore.deleteAll(null);
    }

    @Test(expected=RuntimeException.class)
    public void testDeleteAllNullKeys() throws Exception {
        ArrayList<Object> keys = new ArrayList<Object>();
        keys.add(null);
        keys.add(null);
        this.tableMapStore.deleteAll(keys);
    }

    @Test
    public void testLoad() throws Exception {
        Table table = new Table();
        table.setName(TEST_TABLE);
        table.setTtl(30);
        ((IndexRequestBuilder)((IndexRequestBuilder)this.elasticsearchServer.getClient().prepareIndex().setIndex("table-meta")).setType("table-meta").setConsistencyLevel(WriteConsistencyLevel.ALL)).setSource(this.mapper.writeValueAsString((Object)table)).setId(table.getName()).setRefresh(true).execute().actionGet();
        Table responseTable = this.tableMapStore.load(table.getName());
        this.compareTables(table, responseTable);
    }

    @Test
    public void testLoadMissingKey() throws Exception {
        Assert.assertNull((Object)this.tableMapStore.load(UUID.randomUUID().toString()));
    }

    @Test
    public void testLoadNullKey() throws Exception {
        Assert.assertNull((Object)this.tableMapStore.load(UUID.randomUUID().toString()));
    }

    @Test(expected=RuntimeException.class)
    public void testLoadKeyWithWrongJson() throws Exception {
        ((IndexRequestBuilder)((IndexRequestBuilder)this.elasticsearchServer.getClient().prepareIndex().setIndex("table-meta")).setType("table-meta").setConsistencyLevel(WriteConsistencyLevel.ALL)).setSource("{ \"test\" : \"test\"}").setId(TEST_TABLE).setRefresh(true).execute().actionGet();
        this.tableMapStore.load(TEST_TABLE);
    }

    @Test
    public void testLoadAll() throws Exception {
        HashMap tables = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            Table table = new Table();
            table.setName(UUID.randomUUID().toString());
            table.setTtl(20);
            tables.put(table.getName(), table);
            ((IndexRequestBuilder)((IndexRequestBuilder)this.elasticsearchServer.getClient().prepareIndex().setIndex("table-meta")).setType("table-meta").setConsistencyLevel(WriteConsistencyLevel.ALL)).setSource(this.mapper.writeValueAsString((Object)table)).setId(table.getName()).setRefresh(true).execute().actionGet();
        }
        ImmutableSet names = ImmutableSet.copyOf((Iterable)Iterables.limit(tables.keySet(), (int)5));
        Map responseTables = this.tableMapStore.loadAll((Collection)names);
        Assert.assertEquals((long)names.size(), (long)responseTables.size());
        for (String name : names) {
            this.compareTables((Table)tables.get(name), (Table)responseTables.get(name));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testLoadAllNull() throws Exception {
        this.tableMapStore.loadAll(null);
    }

    @Test(expected=RuntimeException.class)
    public void testLoadAllKeyWithWrongJson() throws Exception {
        ((IndexRequestBuilder)((IndexRequestBuilder)this.elasticsearchServer.getClient().prepareIndex().setIndex("table-meta")).setType("table-meta").setConsistencyLevel(WriteConsistencyLevel.ALL)).setSource("{ \"test\" : \"test\"}").setId(TEST_TABLE).setRefresh(true).execute().actionGet();
        this.tableMapStore.loadAll(Arrays.asList(TEST_TABLE));
    }

    @Test
    public void testLoadAllKeys() throws Exception {
        HashMap tables = Maps.newHashMap();
        for (int i = 0; i < 10; ++i) {
            Table table = new Table();
            table.setName(UUID.randomUUID().toString());
            table.setTtl(20);
            tables.put(table.getName(), table);
            ((IndexRequestBuilder)((IndexRequestBuilder)this.elasticsearchServer.getClient().prepareIndex().setIndex("table-meta")).setType("table-meta").setConsistencyLevel(WriteConsistencyLevel.ALL)).setSource(this.mapper.writeValueAsString((Object)table)).setId(table.getName()).setRefresh(true).execute().actionGet();
        }
        Set responseKeys = this.tableMapStore.loadAllKeys();
        for (String name : tables.keySet()) {
            Assert.assertTrue((boolean)responseKeys.contains(name));
        }
    }

    private void compareTables(Table expected, Table actual) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((long)expected.getTtl(), (long)actual.getTtl());
    }
}

