/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.table.impl;

import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.ErrorCode;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.table.TableManager;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.core.table.impl.FoxtrotTableManager;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class FoxtrotTableManagerTest {
    private TableManager tableManager;
    private QueryStore queryStore;
    private DataStore dataStore;
    private TableMetadataManager metadataManager;

    @Before
    public void setUp() throws Exception {
        this.queryStore = (QueryStore)Mockito.mock(QueryStore.class);
        this.dataStore = (DataStore)Mockito.mock(DataStore.class);
        this.metadataManager = (TableMetadataManager)Mockito.mock(TableMetadataManager.class);
        this.tableManager = new FoxtrotTableManager(this.metadataManager, this.queryStore, this.dataStore);
    }

    @Test
    public void saveTableNullName() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        try {
            Table table = new Table();
            table.setName(null);
            table.setTtl(60);
            this.tableManager.save(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)e.getCode());
        }
    }

    @Test
    public void saveTableEmptyName() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        try {
            Table table = new Table();
            table.setName(" ");
            table.setTtl(60);
            this.tableManager.save(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)e.getCode());
        }
    }

    @Test
    public void saveNullTable() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        try {
            this.tableManager.save(null);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)e.getCode());
        }
    }

    @Test
    public void saveTableInvalidTtl() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        try {
            Table table = new Table();
            table.setName("abcd");
            table.setTtl(0);
            this.tableManager.save(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)e.getCode());
        }
    }

    @Test
    public void saveTable() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        Table table = new Table();
        table.setName("abcd");
        table.setTtl(10);
        this.tableManager.save(table);
    }

    @Test
    public void saveExistingTable() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        ((TableMetadataManager)Mockito.doReturn((Object)true).when((Object)this.metadataManager)).exists((String)Matchers.any(String.class));
        try {
            Table table = new Table();
            table.setName("abcd");
            table.setTtl(10);
            this.tableManager.save(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.TABLE_ALREADY_EXISTS, (Object)e.getCode());
        }
    }

    @Test
    public void saveTableQueryStoreFailed() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doThrow((Throwable[])new Throwable[]{FoxtrotExceptions.createExecutionException((String)"dummy", (Exception)new IOException())}).when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        try {
            Table table = new Table();
            table.setName("abcd");
            table.setTtl(10);
            this.tableManager.save(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.STORE_EXECUTION_ERROR, (Object)e.getCode());
        }
    }

    @Test
    public void saveTableDataStoreFailed() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doThrow((Throwable[])new Throwable[]{FoxtrotExceptions.createExecutionException((String)"dummy", (Exception)new IOException())}).when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        try {
            Table table = new Table();
            table.setName("abcd");
            table.setTtl(10);
            this.tableManager.save(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.STORE_EXECUTION_ERROR, (Object)e.getCode());
        }
    }

    @Test
    public void saveTableDataStoreNoTableFound() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doThrow((Throwable[])new Throwable[]{FoxtrotExceptions.createTableMissingException((String)"Dummy")}).when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        try {
            Table table = new Table();
            table.setName("abcd");
            table.setTtl(10);
            this.tableManager.save(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.TABLE_NOT_FOUND, (Object)e.getCode());
        }
    }

    @Test
    public void updateTable() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        ((TableMetadataManager)Mockito.doReturn((Object)true).when((Object)this.metadataManager)).exists(Mockito.anyString());
        Table table = new Table();
        table.setName("abcd");
        table.setTtl(10);
        this.tableManager.update(table);
    }

    @Test
    public void updateNonExistingTable() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        ((TableMetadataManager)Mockito.doReturn((Object)false).when((Object)this.metadataManager)).exists(Mockito.anyString());
        try {
            Table table = new Table();
            table.setName("abcd");
            table.setTtl(10);
            this.tableManager.update(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.TABLE_NOT_FOUND, (Object)e.getCode());
        }
    }

    @Test
    public void updateNullTable() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        ((TableMetadataManager)Mockito.doReturn((Object)false).when((Object)this.metadataManager)).exists(Mockito.anyString());
        try {
            this.tableManager.update(null);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)e.getCode());
        }
    }

    @Test
    public void updateTableNullName() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        ((TableMetadataManager)Mockito.doReturn((Object)false).when((Object)this.metadataManager)).exists(Mockito.anyString());
        try {
            Table table = new Table();
            table.setName(null);
            table.setTtl(10);
            this.tableManager.update(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)e.getCode());
        }
    }

    @Test
    public void updateTableEmptyName() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        ((TableMetadataManager)Mockito.doReturn((Object)false).when((Object)this.metadataManager)).exists(Mockito.anyString());
        try {
            Table table = new Table();
            table.setName(" ");
            table.setTtl(10);
            this.tableManager.update(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)e.getCode());
        }
    }

    @Test
    public void updateTableInvalidTtl() throws Exception {
        ((TableMetadataManager)Mockito.doNothing().when((Object)this.metadataManager)).save((Table)Matchers.any(Table.class));
        ((DataStore)Mockito.doNothing().when((Object)this.dataStore)).initializeTable((Table)Matchers.any(Table.class), Mockito.anyBoolean());
        ((QueryStore)Mockito.doNothing().when((Object)this.queryStore)).initializeTable((String)Matchers.any(String.class));
        ((TableMetadataManager)Mockito.doReturn((Object)false).when((Object)this.metadataManager)).exists(Mockito.anyString());
        try {
            Table table = new Table();
            table.setName("abcd");
            table.setTtl(0);
            this.tableManager.update(table);
            Assert.fail();
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.INVALID_REQUEST, (Object)e.getCode());
        }
    }
}

